// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <cc++/process.h>
#include <cc++/slog.h>
#include "server.h"

namespace server {
using namespace ost;
using namespace std;

Binder	Binder::binder;

Binder::Binder() :
ScriptBinder("server")
{
};

void Binder::attach(ScriptInterp *interp)
{
};

void Binder::detach(ScriptInterp *interp)
{
	Line *cdr;
	char buffer[256];
	char var[65];
	char *p;
	unsigned idx = 0;
	const char *cp;
	size_t len;

	ScriptImage *img = interp->getImage();
	Name *scr = interp->getName();

	snprintf(var, sizeof(var), "cdr.%s", scr->name);
	p = strchr(var, ':');
	if(p)
		*p = 0; 

	cdr = (Line *)img->getPointer(var);	
	if(!cdr)
		return;

	snprintf(buffer, sizeof(buffer), "%s:", var + 4);
	len = strlen(buffer);
	
	while(len < sizeof(buffer) - 2 && NULL != (cp = getOption(cdr, &idx)))
	{
		if(isalpha(*cp))
		{
			var[0] = '%';
			snprintf(var + 1, sizeof(var) - 1, "session.%s", cp);
			cp = interp->getContent(var);
		}
		else
			cp = interp->getContent(cp);
		if(!cp || !*cp)
			cp = "-";
		snprintf(buffer + len, sizeof(buffer) - len, " %s", cp);
		len = strlen(buffer);
	}
#ifndef	WIN32
	if(getppid() > 1)
		fprintf(stderr, "%s\n", buffer);
#endif
	buffer[len++] = '\n';
	buffer[len] = 0;

#ifdef	WIN32
	HANDLE fd;
	DWORD res;
	fd = CreateFile(server::runtime.getLast("calls"), 
		GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

	if(fd == INVALID_HANDLE_VALUE)
			return;

	Thread::yield();
	SetFilePointer(fd, 0, 0, FILE_END);
	WriteFile(fd, buffer, (DWORD)len, &res, NULL);
	CloseHandle(fd);
#else
	int fd;
	fd = ::open(server::runtime.getLast("calls"), O_WRONLY | O_APPEND | O_CREAT, 0640);
	if(fd < 0)
		return;

	::write(fd, buffer, len);
	::close(fd);
#endif
}

} // end namespace
