// Copyright (C) 2006 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// Portions originally generated by mib2c

// Necesary libraries
#include <bayonne.h>
#include <cc++/thread.h>
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "snmpsubagent.h"
#include "snmpsubagent_routines.h"
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>

#ifdef  CCXX_NAMESPACES
using namespace ost;
using namespace std;
#endif

static netsnmp_oid_stash_node *undoStorage = NULL;
static netsnmp_oid_stash_node *commitStorage = NULL;

void snmp_agent_free_undoInfo( void* pvInfo )
{ // Start of snmp_agent_free_undoInfo( void* )
	////////////////////////
	// Variable declaration
	////////////////////////
	struct undoInfo*	puiClean;
       
	///////////
	// Cleanup
	///////////
	puiClean = reinterpret_cast<struct undoInfo*>( pvInfo );
	if ( puiClean != NULL )
	{
		SNMP_FREE( puiClean->ptr );
		SNMP_FREE( puiClean );
	} // End of if
} // End of snmp_agent_free_undoInfo( void* )

bool initialize_table_bayLineTable( void )
{ // Start of initialize_table_bayLineTable( void )
	////////////////////////
	// Variable declaration
	////////////////////////
	oid					oBayLineTable[] = { SNMP_OID_BAYONNE_LINE_TABLE };
	netsnmp_table_registration_info*	pntriTable;
	netsnmp_handler_registration*		pnhrTablehndl;
	netsnmp_iterator_info*			pniiWalk;

	//////////////////
	// Initialization
	//////////////////
	pntriTable = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
	pniiWalk = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
	pnhrTablehndl = netsnmp_create_handler_registration( "bayLineTable",
	                                                     bayLineTable_handler,
	                                                     oBayLineTable,
	                                                     OID_LENGTH( oBayLineTable ),
	                                                     HANDLER_CAN_RONLY );

	// Allocation failure
	if ( ( pnhrTablehndl == NULL ) || ( pntriTable == NULL ) || ( pniiWalk == NULL ) )
	{
		return false;
	} // End of if

	//////////////////////////
	// Setup table definition
	//////////////////////////
	// index: bayLineIndex
	netsnmp_table_helper_add_indexes( pntriTable, ASN_INTEGER, 0 );

	// Define the minimum and maximum accessible columns (optimization)
	pntriTable->min_column = static_cast<baylinecolumn_t>( bayColGroup );
	pntriTable->max_column = static_cast<baylinecolumn_t>( bayColDirection );

	// Column iterator routines
	pniiWalk->get_first_data_point = bayLineTable_get_first_data_point;
	pniiWalk->get_next_data_point = bayLineTable_get_next_data_point;
	pniiWalk->free_loop_context_at_end = bayLineTable_loop_free;

	pniiWalk->table_reginfo = pntriTable;

	////////////////////////////////////////
	// Register table with the master agent
	////////////////////////////////////////
	DEBUGMSGTL( ( "initialize_table_bayLineTable", "Registering table bayLineTable as a table iterator\n" ) );
	netsnmp_register_table_iterator( pnhrTablehndl, pniiWalk );

	return true;
} // End of initialize_table_bayLineTable( void )

int bayLineTable_handler( netsnmp_mib_handler* pnmhUnused, netsnmp_handler_registration* pnhrTable, netsnmp_agent_request_info* pnariRequest, netsnmp_request_info* pnriList )
{ // Start of bayLineTable_handler( netsnmp_mib_handler*, netsnmp_handler_registration*, netsnmp_agent_request_info*, netsnmp_request_info* )
	////////////////////////
	// Variable declaration
	////////////////////////
	char*				pcValue;
	netsnmp_table_request_info*	pntriTable;
	oid*				poSuffix;
	size_t				stSize;
	size_t				stSufln;
	struct commitInfo*		psciCommit;
	struct timeval			stvThen;
	Trunk*				ptLine;
	u_char*				pucValue;
	u_char				ucType;
	u_long				ulValue;
	void*				pvData;

	//////////////////
	// Initialization
	//////////////////
	psciCommit = NULL;
	pvData = NULL;
	pucValue = reinterpret_cast<u_char*>( &ulValue );	// Assume the response will be a number
	ulValue = 0;

	////////////////////////////////////////
	// column and row index encoded portion
	////////////////////////////////////////
	poSuffix = pnriList->requestvb->name + pnhrTable->rootoid_len + 1;
	stSufln = pnriList->requestvb->name_length - ( pnhrTable->rootoid_len + 1 );

	for ( netsnmp_request_info* pnriReq = pnriList; pnriReq; pnriReq = pnriReq->next )
	{
		if ( pnriReq->processed != 0 )
		{
			continue;
		} // End of if

		switch ( pnariRequest->mode )
		{
			case MODE_GET:
			case MODE_SET_RESERVE1:
				pvData = netsnmp_extract_iterator_context( pnriReq );
				ptLine = reinterpret_cast<Trunk*>( pvData );
				if ( pvData == NULL )
				{
					if ( pnariRequest->mode == MODE_GET )
					{
						netsnmp_set_request_error( pnariRequest, pnriReq, SNMP_NOSUCHINSTANCE );
						continue;
					} // End of if
				} // End of if
				break;

			default: // == the other SET modes
				psciCommit = reinterpret_cast<struct commitInfo*>( netsnmp_oid_stash_get_data( commitStorage, poSuffix + 1, stSufln - 1 ) );
				break;
		} // End of switch

		// Extracts the information about the table from the request
		pntriTable = netsnmp_extract_table_info( pnriReq );
		if ( pntriTable == NULL )
		{
			continue;
		} // End of if

		// pntriTable->colnum contains the column number requested
		// pntriTable->indexes contains a linked list of snmp variable
		// bindings for the indexes of the table. Values in the list
		// have been set corresponding to the indexes of the
		// request
		switch ( pnariRequest->mode )
		{
			case MODE_GET:
				switch ( static_cast<baylinecolumn_t>( pntriTable->colnum ) )
				{
					case bayColGroup:
						pcValue = const_cast<char*>( driver->getTrunkGroup( ptLine->getId( ) )->getName( ) );
						stSize = strlen( pcValue );
						pucValue = reinterpret_cast<u_char*>( pcValue );
						ucType = ASN_OCTET_STR;
						break;

					case bayColANI:
						pucValue = const_cast<u_char*>( getBaySymbol( SYM_CLID, ptLine, &stSize ) );
						ucType = ASN_OCTET_STR;
						break;

					case bayColDNIS:
						pucValue = const_cast<u_char*>( getBaySymbol( SYM_DNID, ptLine, &stSize ) );
						ucType = ASN_OCTET_STR;
						break;

					case bayColName:
						pucValue = const_cast<u_char*>( getBaySymbol( SYM_NAME, ptLine, &stSize ) );
						ucType = ASN_OCTET_STR;
						break;

					case bayColUid:
						pucValue = const_cast<u_char*>( getBaySymbol( SYM_USER, ptLine, &stSize ) );
						ucType = ASN_OCTET_STR;
						break;

					case bayColInfo:
						pucValue = const_cast<u_char*>( getBaySymbol( SYM_INFODIGITS, ptLine, &stSize ) );
						ucType = ASN_OCTET_STR;
						break;

					case bayColLanguage:
						pucValue = const_cast<u_char*>( getBaySymbol( SYM_LANGUAGE, ptLine, &stSize ) );
						ucType = ASN_OCTET_STR;
						break;

					case bayColGuid:
						pucValue = const_cast<u_char*>( getBaySymbol( SYM_GID, ptLine, &stSize ) );
						ucType = ASN_OCTET_STR;
						break;

					case bayColPolicy:
						pucValue = const_cast<u_char*>( getBaySymbol( SYM_POLICY, ptLine, &stSize ) );
						ucType = ASN_OCTET_STR;
						break;

					case bayColCaps:
						ulValue = static_cast<u_long>( ptLine->getCapabilities( ) );
						ucType = ASN_INTEGER;
						stSize = sizeof ( u_long );
						break;

					case bayColDuration:
						if ( snmp.OffHook( ptLine->getId( ) ) )
						{

							stvThen = snmp.LastCall( ptLine->getId( ) );
							ulValue = timeval_tticks( &stvThen );
						} // End of if
						ucType = ASN_TIMETICKS;
						stSize = sizeof ( u_long );
						break;

					case bayColLastCall:
						stvThen = snmp.LastCall( ptLine->getId( ) );
						ucType = ASN_TIMETICKS;
						ulValue = timeval_tticks( &stvThen );
						stSize = sizeof ( u_long );
						break;

					case bayColTotal:
						ulValue = snmp.Calls( ptLine->getId( ) );
						ucType = ASN_COUNTER;
						stSize = sizeof ( u_long );
						break;

					case bayColStatus:
						ulValue = get_bayLineStatus( ptLine, &stSize );
						ucType = ASN_INTEGER;
						break;

					case bayColDirection:
						ulValue = get_bayLineDir( ptLine, &stSize );
						stSize = sizeof ( u_long );
						ucType = ASN_INTEGER;
						break;

					default:
						// We shouldn't get here
						snmp_log( LOG_ERR, "problem encountered in bayLineTable_handler: unknown column\n" );
						return SNMP_ERR_GENERR;
				} // End of switch
				snmp_set_var_typed_value( pnriReq->requestvb, ucType, pucValue, stSize );
				break;

			case MODE_SET_RESERVE1:
				psciCommit = reinterpret_cast<struct commitInfo*>( netsnmp_oid_stash_get_data( commitStorage, poSuffix + 1, stSufln - 1 ) );
				if ( !psciCommit )
				{
					// create the commit storage info
					psciCommit = SNMP_MALLOC_STRUCT( commitInfo );
					if ( !pvData )
					{
						psciCommit->data_context = NULL; // Not supported
						psciCommit->new_row = 1;
					}
					else
					{
						psciCommit->data_context = pvData;
					} // End of if
					netsnmp_oid_stash_add_data( &commitStorage, poSuffix + 1, stSufln - 1, psciCommit );
				} // End of if
				break;

			case MODE_SET_RESERVE2:
				netsnmp_set_request_error( pnariRequest, pnriReq, SNMP_ERR_NOTWRITABLE );
				break;

			case MODE_SET_FREE:
			case MODE_SET_UNDO:
			case MODE_SET_ACTION:
				break;

			case MODE_SET_COMMIT:
				if ( !psciCommit->have_committed )
				{
					psciCommit->have_committed = 1;
				} // End of if
				break;

			default:
				snmp_log( LOG_ERR, "problem encountered in bayLineTable_handler: unsupported mode\n" );
		} // End of switch
	} // End of for

	////////////
	// Clean up
	////////////
	if ( ( pnariRequest->mode == MODE_SET_UNDO ) ||
	     ( pnariRequest->mode == MODE_SET_FREE ) ||
	     ( pnariRequest->mode == MODE_SET_COMMIT ) )
	{
		// Clear out the undo cache
		netsnmp_oid_stash_free( &undoStorage, snmp_agent_free_undoInfo );
		netsnmp_oid_stash_free( &commitStorage, netsnmp_oid_stash_no_free );
	} // End of if

	return SNMP_ERR_NOERROR;
} // End of bayLineTable_handler(netsnmp_mib_handler*, netsnmp_handler_registration*, netsnmp_agent_request_info*, netsnmp_request_info* )

netsnmp_variable_list* bayLineTable_get_first_data_point(void** ppvLoop, void** ppvData, netsnmp_variable_list* pnsvlVariables, netsnmp_iterator_info* psniiContext )
{ // Start of bayLineTable_get_first_data_point( void**, void**, netsnmp_variable_list*, netsnmp_iterator_info* )
	////////////////////////
	// Variable declaration
	////////////////////////
	size_t*	pstInitial;

	//////////////////////////////
	// Initialize the table index
	//////////////////////////////
	pstInitial = new size_t;
	*pstInitial = 0;
	*ppvLoop = reinterpret_cast<void*>( pstInitial );

	///////////////////////
	// Get the table index
	///////////////////////
	return bayLineTable_get_next_data_point( ppvLoop, ppvData, pnsvlVariables,  psniiContext );
} // End of bayLineTable_get_first_data_point( void**, void**, netsnmp_variable_list*, netsnmp_iterator_info* )

netsnmp_variable_list* bayLineTable_get_next_data_point( void** ppvLoop, void** ppvData, netsnmp_variable_list* pnsvlVariables, netsnmp_iterator_info* psniiContext )
{ // Start of bayLineTable_get_next_data_point( void**, void**, netsnmp_variable_list*, netsnmp_iterator_info* )
	////////////////////////
	// Variable declaration
	////////////////////////
	size_t* pstIndex;

	//////////////////
	// Initialization
	//////////////////
	pstIndex = reinterpret_cast<size_t*>( *ppvLoop );

	////////////////////
	// Walk table index
	////////////////////
	if ( *pstIndex < driver->getTrunkCount( ) )
	{
		*ppvData = reinterpret_cast<void*>( driver->getTrunkPort( *pstIndex ) ); 

		// Next iteration
		snmp_set_var_value( pnsvlVariables, reinterpret_cast<u_char*>( pstIndex ), sizeof ( size_t ) );
		( *pstIndex ) ++;

		return pnsvlVariables;
	} // End of if

	// Signal end of table
	*ppvData = NULL;
	return NULL;
} // End of bayLineTable_get_next_data_point( void**, void**, netsnmp_variable_list*, netsnmp_iterator_info* )

void bayLineTable_loop_free( void* pvFree, netsnmp_iterator_info* psniiContext )
{ // Start of bayLineTable_loop_free( void*, netsnmp_iterator_info* )
	///////////
	// Cleanup
	///////////
	delete reinterpret_cast<unsigned int*>( pvFree );
	pvFree = NULL;
} // End of bayLineTable_loop_free( void*, netsnmp_iterator_info* )

u_long get_bayLineStatus( Trunk* ptPort, size_t* pstLength )
{ // Start of get_bayLineStatus( Trunk*, size_t* )
	////////////////////////
	// Variable declaration
	////////////////////////
	baylinestatus_t	blstResult;

	/////////////////////////////////////////////////
	// Translate Bayonne value to Net-SNMP MIB value
	/////////////////////////////////////////////////
	if ( snmp.OffHook( ptPort->getId( ) )  )
	{
		switch( ptPort->getTrunkMode( ) )
		{
			case TRUNK_MODE_INCOMING:
			case TRUNK_MODE_OUTGOING:
				blstResult = bayStatActive;
				break;

			case TRUNK_MODE_INACTIVE:
				blstResult = bayStatIdle;
				break;

			case TRUNK_MODE_UNAVAILABLE:
			default:
				blstResult = bayStatUnknown;
				break;
		} /* End of switch */
	}
	else
	{
		blstResult = bayStatIdle;
	} // End of if
	*pstLength = sizeof( u_long );

	return static_cast<u_long>( blstResult );
} // End of get_bayLineStatus( Trunk*, size_t* )

u_long get_bayLineDir( Trunk *ptPort, size_t* pstLength )
{ // Start of get_bayLineDir( Trunk*, size_t* )
	////////////////////////
	// Variable declaration
	////////////////////////
	baylinedir_t	bldtResult;

	/////////////////////////////////////////////////
	// Translate Bayonne value to Net-SNMP MIB value
	/////////////////////////////////////////////////
	if ( snmp.OffHook( ptPort->getId( ) )  )
	{
		switch( ptPort->getTrunkMode( ) )
		{
			case TRUNK_MODE_INCOMING:
				bldtResult = bayDirIncoming;
				break;

			case TRUNK_MODE_OUTGOING:
				bldtResult = bayDirOutgoing;
				break;

			case TRUNK_MODE_INACTIVE:
				bldtResult = bayDirInactive;
				break;

			case TRUNK_MODE_UNAVAILABLE:
			default:
				bldtResult = bayDirUnavailable;
				break;
		} // End of switch
	}
	else
	{
		bldtResult = bayDirInactive;
	} // End of if
	*pstLength = sizeof( u_long );

	return static_cast<u_long>( bldtResult );
} // End of get_bayLineDir( Trunk*, size_t* )

const u_char* getBaySymbol( const char* pcSymbol, Trunk* ptPort, size_t* pstLength )
{ // Start of getBaySymbol( const char*, Trunk*, size_t* )
	////////////////////////
	// Variable declaration
	////////////////////////
	const char*		pcAnswer = ptPort->getSymbol( pcSymbol );
	static const char*	pcEmpty = "";
	const size_t		stEmptylen = 1;

	////////////////////
	// Get the variable
	////////////////////
	// the getSymbol Trunk class method returns NULL if there is
	// no variable with the given name; this is not acceptable
	// for Net-SNMP
	if ( pcAnswer == NULL )
	{
		*pstLength = stEmptylen;
		return reinterpret_cast<const u_char*>( pcEmpty );
	} // End of if

	*pstLength = strlen( pcAnswer );
	
	return reinterpret_cast<const u_char*>( pcAnswer );
} // End of getBaySymbol( const char*, Trunk*, size_t* )

int bayStatus_handler( netsnmp_mib_handler *pnsmhMHndl, netsnmp_handler_registration *pnshrRHndl, netsnmp_agent_request_info *pnsariContext, netsnmp_request_info *pnsriData )
{ // Start of bayStatus_handler( netsnmp_mib_handler*, netsnmp_handler_registration*, netsnmp_agent_request_info*, netsnmp_request_info* )
	////////////////////////
	// Variable declaration
	////////////////////////
	u_char*		pucResult;
	char*		pcResult;
	oid             oBayStatus[ ] = { SNMP_OID_BAYONNE_STATUS };
	oid*		poRequest;
	size_t		stBayStlen;
	size_t		stReqlen;
	size_t		stSize;
	struct timeval	stvThen;
	u_char		ucType;
	unsigned long	ulResult;

	//////////////////
	// Initialization
	//////////////////
	poRequest = pnsriData->requestvb->name;
	stReqlen = pnsriData->requestvb->name_length;
	stBayStlen = OID_LENGTH( oBayStatus );
	pucResult = reinterpret_cast<u_char*>( &ulResult );	// Assume the result is a number

	//////////////////////
	// Verify OID request
	//////////////////////
	if ( ( snmp_oidtree_compare( oBayStatus, stBayStlen, poRequest, stReqlen ) ) ||
	     ( stReqlen != ( stBayStlen + 2 ) ) ||
	     ( pnsariContext->mode != MODE_GET ) )
	{
		// Invalid OID requested, Invalid OID length, or something other than a GET request
		return SNMP_ERR_GENERR;
	} // End of if

	// Request belongs to this tree

	///////////////////////////////
	// Handle the column requested
	///////////////////////////////
	switch ( static_cast<baystatus_t>( poRequest[ 8 ] ) )
	{
		case	bayHost:
			ucType = ASN_OCTET_STR;
			pcResult = const_cast<char*>( keyserver.getNode( ) );
			stSize = strlen( pcResult );
			pucResult = reinterpret_cast<u_char*>( pcResult );
			break;

		case	bayDriver:
			ucType = ASN_OCTET_STR;
			pcResult = const_cast<char*>( plugins.getDriverName( ) );
			stSize = strlen( pcResult );
			pucResult = reinterpret_cast<u_char*>( pcResult );
			break;

		case	bayVersion:
			ucType = ASN_OCTET_STR;
			pcResult = const_cast<char*>( getenv( "SERVER_VERSION" ) );
			stSize = strlen( pcResult );
			pucResult = reinterpret_cast<u_char*>( pcResult );
			break;

		case	bayUid:
			ucType = ASN_OCTET_STR;
			pcResult = const_cast<char*>( keyserver.getLast( "user" ) );
			stSize = strlen( pcResult );
			pucResult = reinterpret_cast<u_char*>( pcResult );
			break;

		case	bayBoot:
			ucType = ASN_TIMETICKS;
			stvThen = snmp.Boot( );
			ulResult = timeval_tticks( &stvThen );
			stSize = sizeof ( unsigned long );
			break;

		case	bayBusy:
			ucType = ASN_GAUGE;
			ulResult = getBusy( );
			stSize = sizeof ( unsigned long );
			break;

		case	bayAvail:
			ucType = ASN_GAUGE;
			ulResult = driver->getTrunkUsed( ) - getBusy( );
			stSize = sizeof ( unsigned long );
			break;

		case	bayUsed:
			ucType = ASN_GAUGE;
			ulResult = driver->getTrunkUsed( );
			stSize = sizeof ( unsigned long );
			break;

		case	bayTotal:
			ucType = ASN_GAUGE;
			ulResult = driver->getTrunkCount( );
			stSize = sizeof ( unsigned long );
			break;

		case	bayCalls:
			ucType = ASN_COUNTER;
			// Busy lines are excluded
			ulResult = getGroup( NULL )->getStat( STAT_SYS_ACTIVITY ) - getBusy( );
			stSize = sizeof ( unsigned long );
			break;

		case	bayDurMin:
			ucType = ASN_TIMETICKS;
			ulResult = snmp.MinDuration( );
			stSize = sizeof ( unsigned long );
			break;

		case	bayDurAvg:
			ucType = ASN_TIMETICKS;
			// Busy lines are excluded; otherwise the averages are all messed up
			ulResult = getGroup( NULL )->getStat( STAT_SYS_ACTIVITY ) - getBusy( );
 	                ulResult = ( ulResult ? snmp.TotalDuration( ) / ulResult : 0 );
			stSize = sizeof ( unsigned long );
			break;

		case	bayDurMax:
			ucType = ASN_TIMETICKS;
			ulResult = snmp.MaxDuration( );
			stSize = sizeof ( unsigned long );
			break;

		case	bayLastCall:
			ucType = ASN_TIMETICKS;
			stvThen = snmp.LastCall( );
			ulResult = static_cast<unsigned long>( timeval_tticks( &stvThen ) );
			stSize = sizeof ( unsigned long );
			break;

		default:	// Unhandled OID
			return SNMP_ERR_GENERR;
	} // End of switch

	snmp_set_var_typed_value( pnsriData->requestvb, ucType, pucResult, stSize );
	return SNMP_ERR_NOERROR;
} // End of bayStatus_handler( netsnmp_mib_handler*, netsnmp_handler_registration*, netsnmp_agent_request_info*, netsnmp_request_info* )

unsigned long getBusy( )
{ // Start of getBusy( )
	////////////////////////
	// Variable declaration
	////////////////////////
	unsigned long	ulBusy;
	TrunkGroup*	ptgIndex;

	//////////////////
	// Initialization
	//////////////////
	ptgIndex = getGroup( NULL );
	ulBusy = 0;

	/////////////////////////////////////////
	// Retrieve the activity from all trunks
	/////////////////////////////////////////
	while ( ptgIndex != NULL )
	{
		ulBusy += ptgIndex->getStat( STAT_ACTIVE_CALLS );
		ptgIndex = ptgIndex->getNext( );
	} // End of while

	return ulBusy;
} // End of getBusy( )
