/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nsidita.DocFileInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteJSFiles {
    private static String txt_VM_encoding_not_supported = "This VM does not support the specified encoding.";
    private static String txt_indices_location = "The created index files are located in ";

    public static void WriteHTMLList(String fileO, ArrayList<String> list, boolean doStem) {
        int i = 0;
        if (list == null) {
            return;
        }
        if (fileO == null) {
            return;
        }
        Iterator<String> it = list.iterator();
        try {
            FileOutputStream fOut = new FileOutputStream(fileO);
            BufferedOutputStream bout = new BufferedOutputStream(fOut);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
            out.write("var doStem = " + doStem + ";\n");
            out.write("//List of indexed files.\n");
            out.write("fl = new Array();\n");
            while (it.hasNext()) {
                String temp = it.next();
                out.write("fl[\"" + i + "\"]" + "= \"" + temp.replace(File.separatorChar, '/') + "\";\n");
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(txt_VM_encoding_not_supported);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void WriteHTMLInfoList(String fileO, ArrayList<DocFileInfo> list) {
        int i = 0;
        Iterator<DocFileInfo> it = null;
        if (list == null) {
            return;
        }
        if (fileO == null) {
            return;
        }
        it = list.iterator();
        try {
            FileOutputStream fOut = new FileOutputStream(fileO, true);
            BufferedOutputStream bout = new BufferedOutputStream(fOut);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
            out.write("fil = new Array();\n");
            while (it.hasNext()) {
                DocFileInfo tempInfo = it.next();
                String tempPath = tempInfo.getFullpath().toString().replace(File.separatorChar, '/');
                String tempTitle = tempInfo.getTitle();
                String tempShortdesc = tempInfo.getShortdesc();
                if (tempTitle != null) {
                    tempTitle = tempTitle.replaceAll("\\s+", " ");
                    tempTitle = tempTitle.replaceAll("['\ufffd\"]", " ");
                    tempTitle = tempTitle.replaceAll("\\\\", "\\\\\\\\");
                }
                if (tempShortdesc != null) {
                    tempShortdesc = tempShortdesc.replaceAll("\\s+", " ");
                    tempShortdesc = tempShortdesc.replaceAll("['\ufffd\"]", " ");
                    tempShortdesc = tempShortdesc.replaceAll("\\\\", "\\\\\\\\");
                }
                if (tempShortdesc != null) {
                    String strippedNonAlphaCharsShortDesc = WriteJSFiles.stripNonAlphabeticalChars(tempShortdesc);
                    if (strippedNonAlphaCharsShortDesc.length() > 140) {
                        strippedNonAlphaCharsShortDesc = strippedNonAlphaCharsShortDesc.substring(0, 137);
                    }
                    strippedNonAlphaCharsShortDesc = strippedNonAlphaCharsShortDesc + "...";
                    out.write("fil[\"" + i + "\"]" + "= \"" + tempPath + "@@@" + tempTitle + "@@@" + strippedNonAlphaCharsShortDesc + "\";\n");
                    ++i;
                    continue;
                }
                out.write("fil[\"" + i + "\"]" + "= \"" + tempPath + "@@@" + tempTitle + "@@@null" + "\";\n");
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(txt_VM_encoding_not_supported);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void WriteIndex(String fileOutStr, Map<String, ?> indexMap, String indexerLanguage) {
        if (indexMap == null || fileOutStr == null) {
            return;
        }
        TreeSet<String> sortedKeys = new TreeSet<String>();
        sortedKeys.addAll(indexMap.keySet());
        Iterator keyIt = sortedKeys.iterator();
        String tstr = (String)keyIt.next();
        File fileOut = new File(fileOutStr);
        int indexSize = sortedKeys.size();
        for (int i = 1; i <= 3; ++i) {
            try {
                FileOutputStream fOut = new FileOutputStream(fileOut.getParent() + File.separator + "index-" + i + fileOut.getName());
                BufferedOutputStream bout = new BufferedOutputStream(fOut);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
                try {
                    int count = 0;
                    if (i == 1) {
                        out.write("var indexerLanguage=\"" + indexerLanguage + "\";\n");
                    }
                    out.write("//Auto generated index for searching by xsl-webhelpindexer for DocBook Webhelp.# Kasun Gajasinghe, University of Moratuwa\n");
                    while (keyIt.hasNext()) {
                        out.write("w[\"" + tstr + "\"]" + "=\"" + indexMap.get(tstr) + "\";\n");
                        tstr = (String)keyIt.next();
                        if (indexSize / ++count >= 3) continue;
                    }
                    out.write("\n");
                    out.flush();
                    out.close();
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println(txt_VM_encoding_not_supported);
                }
                continue;
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        System.out.println(txt_indices_location + fileOut.getParent());
    }

    private static String stripNonAlphabeticalChars(String input) {
        String output = input;
        for (int i = input.length() - 1; i > 0; --i) {
            char charAt = input.charAt(i);
            char k = charAt;
            if (k > 'A' && k < '[' || k > 'a' && k < '{' || k > '0' && k < ':') {
                return output;
            }
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    private static String stripWords(String input) {
        int idx = input.lastIndexOf(" ");
        if (idx != -1) {
            return input.substring(0, idx);
        }
        return input;
    }
}

