/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ComputedAttribute;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.XSLLeafNodeConstructor;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class XSLAttribute
extends XSLLeafNodeConstructor {
    private Expression attributeName;
    private Expression separator;
    private Expression namespace = null;
    private int validationAction = 3;
    private SimpleType schemaType;

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        String namespaceAtt = null;
        String selectAtt = null;
        String separatorAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "name") {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "namespace") {
                namespaceAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "select") {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f == "separator") {
                separatorAtt = atts.getValue(a);
                continue;
            }
            if (f == "validation") {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "type") {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
            return;
        }
        this.attributeName = this.makeAttributeValueTemplate(nameAtt);
        if (this.attributeName instanceof StringLiteral) {
            if (!this.getConfiguration().getNameChecker().isQName(((StringLiteral)this.attributeName).getStringValue())) {
                this.invalidAttributeName("Attribute name " + Err.wrap(nameAtt) + " is not a valid QName");
            }
            if (nameAtt.equals("xmlns") && this.namespace == null) {
                this.invalidAttributeName("Invalid attribute name: xmlns");
            }
            if (nameAtt.startsWith("xmlns:")) {
                if (namespaceAtt == null) {
                    this.invalidAttributeName("Invalid attribute name: " + Err.wrap(nameAtt));
                } else {
                    nameAtt = nameAtt.substring(6);
                    this.attributeName = new StringLiteral(nameAtt);
                }
            }
        }
        if (namespaceAtt != null) {
            this.namespace = this.makeAttributeValueTemplate(namespaceAtt);
            if (this.namespace instanceof StringLiteral && !StandardURIChecker.getInstance().isValidURI(((StringLiteral)this.namespace).getStringValue())) {
                this.compileError("The value of the namespace attribute must be a valid URI", "XTDE0865");
            }
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        this.separator = separatorAtt == null ? (selectAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : new StringLiteral(StringValue.SINGLE_SPACE)) : this.makeAttributeValueTemplate(separatorAtt);
        if (validationAtt != null) {
            this.validationAction = Validation.getCode(validationAtt);
            if (this.validationAction != 4 && !this.getExecutable().isSchemaAware()) {
                this.validationAction = 4;
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of validation attribute", "XTSE0020");
                this.validationAction = this.getContainingStylesheet().getDefaultValidation();
            }
        } else {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        }
        if (typeAtt != null) {
            if (!this.getExecutable().isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            } else {
                SchemaType type = this.getSchemaType(typeAtt);
                if (type == null) {
                    this.compileError("Unknown attribute type " + typeAtt, "XTSE1520");
                } else if (type.isSimpleType()) {
                    this.schemaType = (SimpleType)type;
                } else {
                    this.compileError("Type annotation for attributes must be a simple type", "XTSE1530");
                    type = null;
                }
                this.validationAction = 8;
            }
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The validation and type attributes are mutually exclusive", "XTSE1505");
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
            this.schemaType = null;
        }
    }

    private void invalidAttributeName(String message) throws XPathException {
        this.compileError(message, "XTDE0850");
        this.attributeName = new StringLiteral("saxon-error-attribute");
    }

    public void validate(Declaration decl) throws XPathException {
        if (this.schemaType != null && this.schemaType.isNamespaceSensitive()) {
            this.compileError("Validation at attribute level must not specify a namespace-sensitive type (xs:QName or xs:NOTATION)", "XTTE1545");
        }
        this.attributeName = this.typeCheck("name", this.attributeName);
        this.namespace = this.typeCheck("namespace", this.namespace);
        this.select = this.typeCheck("select", this.select);
        this.separator = this.typeCheck("separator", this.separator);
        super.validate(decl);
    }

    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0840";
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        SavedNamespaceContext nsContext = null;
        int annotation = this.getTypeAnnotation(this.schemaType);
        if (this.attributeName instanceof StringLiteral) {
            String[] parts;
            String qName = Whitespace.trim(((StringLiteral)this.attributeName).getStringValue());
            try {
                parts = this.getConfiguration().getNameChecker().getQNameParts(qName);
            }
            catch (QNameException e) {
                return null;
            }
            if (this.namespace == null) {
                String nsuri = "";
                if (!parts[0].equals("") && (nsuri = this.getURIForPrefix(parts[0], false)) == null) {
                    this.undeclaredNamespaceError(parts[0], "XTSE0280");
                    return null;
                }
                int nameCode = this.getNamePool().allocate(parts[0], nsuri, parts[1]);
                FixedAttribute inst = new FixedAttribute(nameCode, this.validationAction, this.schemaType, annotation);
                inst.setContainer(this);
                this.compileContent(exec, decl, inst, this.separator);
                return inst;
            }
            if (this.namespace instanceof StringLiteral) {
                String nsuri = ((StringLiteral)this.namespace).getStringValue();
                if (nsuri.equals("")) {
                    parts[0] = "";
                } else if (parts[0].equals("")) {
                    String p;
                    NodeInfo ns;
                    AxisIterator iter = this.iterateAxis((byte)8);
                    while ((ns = (NodeInfo)iter.next()) != null) {
                        if (!ns.getStringValue().equals(nsuri)) continue;
                        parts[0] = ns.getLocalPart();
                        break;
                    }
                    if (parts[0].equals("") && (p = this.getNamePool().suggestPrefixForURI(((StringLiteral)this.namespace).getStringValue())) != null) {
                        parts[0] = p;
                    }
                    if (parts[0].equals("")) {
                        parts[0] = "ns0";
                    }
                }
                int nameCode = this.getNamePool().allocate(parts[0], nsuri, parts[1]);
                FixedAttribute inst = new FixedAttribute(nameCode, this.validationAction, this.schemaType, annotation);
                this.compileContent(exec, decl, inst, this.separator);
                return inst;
            }
        } else if (this.namespace == null) {
            nsContext = this.makeNamespaceContext();
        }
        ComputedAttribute inst = new ComputedAttribute(this.attributeName, this.namespace, nsContext, this.validationAction, this.schemaType, annotation, false);
        this.compileContent(exec, decl, inst, this.separator);
        return inst;
    }
}

