/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Head
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _count = new QName("count");
    private static final QName _fail_on_error = new QName("fail-on-error");
    private static final QName c_line = new QName("c", "http://www.w3.org/ns/xproc-step", "line");
    private WritablePipe result = null;

    public Head(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        boolean bl = this.getOption(_fail_on_error, true);
        int n = this.getOption(_count, 10);
        RuntimeValue runtimeValue = this.getOption(_href);
        URI uRI = runtimeValue.getBaseURI().resolve(runtimeValue.getString());
        if (!"file".equals(uRI.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the copy step.");
        }
        File file = new File(uRI.getPath());
        if (!file.exists()) {
            throw new XProcException(this.step.getNode(), "Cannot read: file does not exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new XProcException(this.step.getNode(), "Cannot read: file is a directory: " + file.getAbsolutePath());
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_result);
        treeWriter.startContent();
        try {
            int n2;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            if (n >= 0) {
                string = bufferedReader.readLine();
                for (n2 = 0; string != null && n2 < n; ++n2) {
                    treeWriter.addStartElement(c_line);
                    treeWriter.startContent();
                    treeWriter.addText(string);
                    treeWriter.addEndElement();
                    treeWriter.addText("\n");
                    string = bufferedReader.readLine();
                }
            } else {
                n = -n;
                string = "not null";
                while (string != null && n2 < n) {
                    ++n2;
                    string = bufferedReader.readLine();
                }
                string = bufferedReader.readLine();
                while (string != null) {
                    treeWriter.addStartElement(c_line);
                    treeWriter.startContent();
                    treeWriter.addText(string);
                    treeWriter.addEndElement();
                    treeWriter.addText("\n");
                    string = bufferedReader.readLine();
                }
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XProcException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

