/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.MessageListenerProxy;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

public class XsltTransformer
implements Destination {
    private Processor processor;
    private Controller controller;
    private Source initialSource;
    private Destination destination;
    private Builder sourceTreeBuilder;

    protected XsltTransformer(Processor processor, Controller controller) {
        this.processor = processor;
        this.controller = controller;
    }

    public void setInitialTemplate(QName templateName) throws SaxonApiException {
        try {
            this.controller.setInitialTemplate(templateName == null ? null : templateName.getClarkName());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public QName getInitialTemplate() {
        String template = this.controller.getInitialTemplate();
        return template == null ? null : QName.fromClarkName(template);
    }

    public void setInitialMode(QName modeName) {
        this.controller.setInitialMode(modeName == null ? null : modeName.getClarkName());
    }

    public QName getInitialMode() {
        String mode = this.controller.getInitialMode();
        if (mode == null) {
            return null;
        }
        return QName.fromClarkName(mode);
    }

    public void setSchemaValidationMode(ValidationMode mode) {
        if (mode != null) {
            this.controller.setSchemaValidationMode(mode.getNumber());
        }
    }

    public ValidationMode getSchemaValidationMode() {
        return ValidationMode.get(this.controller.getSchemaValidationMode());
    }

    public void setSource(Source source) throws SaxonApiException {
        if (source instanceof NodeInfo) {
            this.setInitialContextNode(new XdmNode((NodeInfo)source));
        } else if (source instanceof DOMSource) {
            this.setInitialContextNode(this.processor.newDocumentBuilder().wrap(source));
        } else {
            this.initialSource = source;
        }
    }

    public void setInitialContextNode(XdmNode node) {
        this.initialSource = node == null ? null : node.getUnderlyingNode();
    }

    public XdmNode getInitialContextNode() {
        if (this.initialSource instanceof NodeInfo) {
            return (XdmNode)XdmValue.wrap((NodeInfo)this.initialSource);
        }
        return null;
    }

    public void setParameter(QName name, XdmValue value) {
        this.controller.setParameter(name.getStructuredQName(), value == null ? null : value.getUnderlyingValue());
    }

    public XdmValue getParameter(QName name) {
        Object oval = this.controller.getParameter(name.getClarkName());
        if (oval == null) {
            return null;
        }
        if (oval instanceof ValueRepresentation) {
            return XdmValue.wrap((ValueRepresentation)oval);
        }
        throw new IllegalStateException(oval.getClass().getName());
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setBaseOutputURI(String uri) {
        this.controller.setBaseOutputURI(uri);
    }

    public String getBaseOutputURI() {
        return this.controller.getBaseOutputURI();
    }

    public void setURIResolver(URIResolver resolver) {
        this.controller.setURIResolver(resolver);
    }

    public URIResolver getURIResolver() {
        return this.controller.getURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.controller.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.controller.getErrorListener();
    }

    public void setMessageListener(MessageListener listener) {
        this.controller.setMessageEmitter(new MessageListenerProxy(listener));
    }

    public MessageListener getMessageListener() {
        Receiver r = this.controller.getMessageEmitter();
        if (r instanceof MessageListenerProxy) {
            return ((MessageListenerProxy)r).getMessageListener();
        }
        return null;
    }

    public void setTraceListener(TraceListener listener) {
        this.controller.setTraceListener(listener);
    }

    public TraceListener getTraceListener() {
        return this.controller.getTraceListener();
    }

    public void transform() throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        try {
            Receiver receiver = this.destination instanceof Serializer ? ((Serializer)this.destination).getReceiver(this.controller.getExecutable()) : this.destination.getReceiver(this.controller.getConfiguration());
            this.controller.transform(this.initialSource, receiver);
            this.destination.close();
        }
        catch (TransformerException e) {
            throw new SaxonApiException(e);
        }
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        this.sourceTreeBuilder = this.controller.makeBuilder();
        Receiver stripper = this.controller.makeStripper(this.sourceTreeBuilder);
        if (this.controller.getExecutable().stripsInputTypeAnnotations()) {
            stripper = this.controller.getConfiguration().getAnnotationStripper(stripper);
        }
        return stripper;
    }

    public void close() throws SaxonApiException {
        if (this.sourceTreeBuilder != null) {
            DocumentInfo doc = (DocumentInfo)this.sourceTreeBuilder.getCurrentRoot();
            this.sourceTreeBuilder = null;
            if (doc == null) {
                throw new SaxonApiException("No source document has been built by the previous pipeline stage");
            }
            Receiver result = this.destination.getReceiver(this.processor.getUnderlyingConfiguration());
            try {
                this.controller.transformDocument(doc, result);
            }
            catch (TransformerException e) {
                throw new SaxonApiException(e);
            }
            this.destination.close();
        }
    }

    public Controller getUnderlyingController() {
        return this.controller;
    }
}

