#ifndef LIBINT2_STATICS_INITIALIZATION
static constexpr std::size_t interpolation_order = 15;
static constexpr long cheb_table_tminlog2 = 1;
static constexpr long cheb_table_tmaxlog2 = 10;
static constexpr long cheb_table_uminlog10 = -7;
static constexpr long cheb_table_umaxlog10 = 3;
static constexpr std::size_t cheb_table_mmax = 36;
static constexpr std::size_t cheb_table_nintervals = 100;
#if LIBINT2_CONSTEXPR_STATICS
static constexpr double cheb_table[cheb_table_nintervals][(cheb_table_mmax+2)*(interpolation_order+1)*(interpolation_order+1)]=
#else   // LIBINT2_CONSTEXPR_STATICS
static double cheb_table[cheb_table_nintervals][(cheb_table_mmax + 2) *
                                                (interpolation_order + 1) *
                                                (interpolation_order + 1)];
#endif  // LIBINT2_CONSTEXPR_STATICS
#else   // LIBINT2_STATICS_INITIALIZATION
template <>
double libint2::TennoGmEval<double>::cheb_table[cheb_table_nintervals]
                                               [(cheb_table_mmax + 2) *
                                                (interpolation_order + 1) *
                                                (interpolation_order + 1)] =
#endif  // LIBINT2_STATICS_INITIALIZATION
#if defined(LIBINT2_STATICS_INITIALIZATION) || LIBINT2_CONSTEXPR_STATICS
{
{
// [{0,1.e-7},{2.,1.e-6}]: m=-1
1574.099060592179,
-1814.388239571181,
1044.447806290431,
-400.8209005623277,
115.3657460636863,
-26.56389507104134,
5.097145113657456,
-0.83832781596574,
0.1206452722876013,
-0.01543308909506156,
0.001776801889735479,
-0.0001859653156285211,
0.00001784138614429288,
-1.58006404468285e-6,
1.30656529519928e-7,
-1.002196839192993e-8,
-1.49165646614661,
0.002291247061873229,
0.001316765414613675,
0.0005036539348756806,
0.0001440013104065502,
0.00003271548776340336,
6.108425070560801e-6,
9.49303730642269e-7,
1.208006631175334e-7,
1.145127064724889e-8,
4.122410931523461e-10,
-1.41753183667465e-10,
-4.770185557735302e-11,
-9.90748734787222e-12,
-1.690897054470309e-12,
-2.405105134065163e-13,
0.3789443395607031,
-8.10211698910079e-7,
-9.31956809161205e-7,
-7.14343887223713e-7,
-4.103817250822676e-7,
-1.884167140256868e-7,
-7.19793827514151e-8,
-2.351535435665027e-8,
-6.69869354293016e-9,
-1.687214900615387e-9,
-3.793556551437544e-10,
-7.6558327370668e-11,
-1.387596208335474e-11,
-2.244571967857932e-12,
-3.201911757998241e-13,
-3.6949491290189e-14,
-0.1336916932485362,
8.66035774624246e-8,
9.97058881127457e-8,
7.65268438841298e-8,
4.40521010186978e-8,
2.028647399670971e-8,
7.785016444955e-9,
2.560673850648647e-9,
7.36943512208018e-10,
1.885020293200398e-10,
4.338607386138118e-11,
9.07422053881627e-12,
1.737835392696631e-12,
3.068061950133674e-13,
5.120793127061396e-14,
7.731161552539405e-15,
0.04448817611442932,
-1.62795441647854e-8,
-1.87425080192799e-8,
-1.438539142162435e-8,
-8.28087957442271e-9,
-3.813469959333887e-9,
-1.463460889405265e-9,
-4.813838038066158e-10,
-1.385487396295842e-10,
-3.544431444902185e-11,
-8.16027638526416e-12,
-1.707696807621133e-12,
-3.274144392218438e-13,
-5.793364641872831e-14,
-9.71909643024958e-15,
-1.48131491712571e-15,
-0.01323286285941486,
3.32207757365285e-9,
3.82468198814064e-9,
2.935550127798544e-9,
1.689836438653971e-9,
7.78196548369386e-10,
2.986425111356911e-10,
9.82347304113339e-11,
2.827367835414865e-11,
7.23333561359621e-12,
1.665411338176024e-12,
3.48559273868105e-13,
6.68438383659059e-14,
1.183290079523875e-14,
1.987178770322151e-15,
3.034553073773919e-16,
0.003499098779536835,
-6.63959690745244e-10,
-7.64411681700717e-10,
-5.86707399929286e-10,
-3.377356429636672e-10,
-1.555327486080098e-10,
-5.96876963962618e-11,
-1.963358159788939e-11,
-5.65092257404081e-12,
-1.445708716471836e-12,
-3.328694847492824e-13,
-6.9670619770885e-14,
-1.336211513839352e-14,
-2.365850091827054e-15,
-3.974851827912314e-16,
-6.074729458603443e-17,
-0.000827099227654356,
1.257087098131137e-10,
1.447274773392354e-10,
1.110824081916868e-10,
6.39441331238205e-11,
2.944732361936649e-11,
1.130079895930273e-11,
3.717273882321164e-12,
1.069906388680631e-12,
2.737221951095715e-13,
6.30244090125673e-14,
1.31915442217812e-14,
2.530132830236327e-15,
4.480226136561669e-16,
7.528971562064695e-17,
1.151145962809195e-17,
0.000176165081753516,
-2.228820598050299e-11,
-2.566024209291207e-11,
-1.969495853443075e-11,
-1.133732360191084e-11,
-5.22102504816956e-12,
-2.003638251029574e-12,
-6.5907548934219e-13,
-1.896955974435724e-13,
-4.853144539428367e-14,
-1.117443250857239e-14,
-2.338941166007157e-15,
-4.486222377980768e-16,
-7.94447542950776e-17,
-1.335256028885175e-17,
-2.04209970338462e-18,
-0.00003408154212137801,
3.68894887888769e-12,
4.2470588884918e-12,
3.259737455500452e-12,
1.876454904750552e-12,
8.6413866921653e-13,
3.316248947802264e-13,
1.090845559341613e-13,
3.139684083133214e-14,
8.0325439479528e-15,
1.849514462225451e-15,
3.871295230616127e-16,
7.42552545824947e-17,
1.315014511421303e-17,
2.210412035514261e-18,
3.381158746560386e-19,
6.033239066864414e-6,
-5.70187861654054e-13,
-6.56452974206371e-13,
-5.03846183885416e-13,
-2.900370702051224e-13,
-1.335669075308122e-13,
-5.125811880439109e-14,
-1.68608327399547e-14,
-4.852908819627965e-15,
-1.241566959767953e-15,
-2.858751996268434e-16,
-5.983819179561792e-17,
-1.147773384532959e-17,
-2.032700968062557e-18,
-3.417019291720124e-19,
-5.227428293616488e-20,
-9.83700766743873e-7,
8.24631499753805e-14,
9.49392022063447e-14,
7.28685187282214e-14,
4.194647759774244e-14,
1.931705423628254e-14,
7.41318387541683e-15,
2.438491751423526e-15,
7.01850680633143e-16,
1.795615673670627e-16,
4.134481068949792e-17,
8.65417204457024e-18,
1.660003364880151e-18,
2.939946248601531e-19,
4.942065510330954e-20,
7.55985512877057e-21,
1.485689595037498e-7,
-1.118694440175226e-14,
-1.28794447772825e-14,
-9.88533775498513e-15,
-5.69045619392975e-15,
-2.620550406226486e-15,
-1.005672221011371e-15,
-3.308057873080369e-16,
-9.52131176054332e-17,
-2.435936384019531e-17,
-5.608859543928709e-18,
-1.174037546089967e-18,
-2.252006161134467e-19,
-3.987981410119127e-20,
-6.704448146284565e-21,
-1.029811179049896e-21,
-2.089652765936793e-8,
1.427757177957228e-15,
1.643766090392335e-15,
1.261636934762308e-15,
7.26256410945025e-16,
3.344532632596485e-16,
1.283510496494669e-16,
4.221980000064989e-17,
1.215178426787607e-17,
3.108919554513892e-18,
7.15846947383749e-19,
1.49844395277359e-19,
2.873577874151047e-20,
5.080143628468701e-21,
8.639202146900534e-22,
1.405082183308628e-22,
2.789222864602739e-9,
-1.740269865403746e-16,
-2.003559606929321e-16,
-1.537788646803221e-16,
-8.85222095026256e-17,
-4.076596479736412e-17,
-1.564450240371382e-17,
-5.146104222625777e-18,
-1.481162210418913e-18,
-3.789424647838953e-19,
-8.72538149221833e-20,
-1.82611265372239e-20,
-3.502407396244108e-21,
-6.264131675041919e-22,
-1.053461143326675e-22,
-1.08691172630308e-23,
-3.440852516604282e-10,
1.979303523170339e-17,
2.278757270533531e-17,
1.749010651798701e-17,
1.006811246326977e-17,
4.63653514300154e-18,
1.779334560842879e-18,
5.852944402719886e-19,
1.684610295111887e-19,
4.31005204383052e-20,
9.92173857829677e-21,
2.071028812676523e-21,
4.055538619460612e-22,
8.544752519919683e-23,
2.774440341367274e-24,
-1.263805647422767e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=0
0.745828233073305,
-0.001145623530936614,
-0.0006583827073068374,
-0.0002518269674378403,
-0.00007200065520327508,
-0.00001635774388170168,
-3.0542125352804e-6,
-4.746518653211346e-7,
-6.04003315587667e-8,
-5.725635323624443e-9,
-2.06120546576173e-10,
7.08765918337325e-11,
2.385092778867651e-11,
4.953743673936111e-12,
8.454485272351543e-13,
1.202552567032582e-13,
-0.3789443395607031,
8.10211698910079e-7,
9.31956809161205e-7,
7.14343887223713e-7,
4.103817250822676e-7,
1.884167140256868e-7,
7.19793827514151e-8,
2.351535435665027e-8,
6.69869354293016e-9,
1.687214900615387e-9,
3.793556551437544e-10,
7.6558327370668e-11,
1.387596208335474e-11,
2.244571967857932e-12,
3.201911757998241e-13,
3.694949129018903e-14,
0.2005375398728043,
-1.299053661936369e-7,
-1.495588321691185e-7,
-1.147902658261948e-7,
-6.60781515280467e-8,
-3.042971099506456e-8,
-1.16775246674325e-8,
-3.841010775972971e-9,
-1.105415268312027e-9,
-2.827530439800597e-10,
-6.50791107920718e-11,
-1.36113308082244e-11,
-2.606753089044947e-12,
-4.602092925200513e-13,
-7.681189690592091e-14,
-1.159674232880883e-14,
-0.0889763522288602,
3.25590883295709e-8,
3.74850160385599e-8,
2.877078284324877e-8,
1.656175914884546e-8,
7.62693991866779e-9,
2.926921778810538e-9,
9.62767607613234e-10,
2.770974792591691e-10,
7.08886288980439e-11,
1.632055277052836e-11,
3.415393615242274e-12,
6.54828878443689e-13,
1.158672928374592e-13,
1.943819286050005e-14,
2.962629834249644e-15,
0.03308215714853663,
-8.30519393413209e-9,
-9.56170497035156e-9,
-7.33887531949634e-9,
-4.224591096634913e-9,
-1.945491370923459e-9,
-7.46606277839225e-10,
-2.455868260283339e-10,
-7.06841958853714e-11,
-1.808333903399046e-11,
-4.163528345440047e-12,
-8.71398184670261e-13,
-1.671095959147647e-13,
-2.95822519880895e-14,
-4.967946925803616e-15,
-7.586382684545455e-16,
-0.01049729633853351,
1.991879072231625e-9,
2.293235045097422e-9,
1.760122199784229e-9,
1.013206928888912e-9,
4.665982458230674e-10,
1.790630891884162e-10,
5.89007447935467e-11,
1.695276772208747e-11,
4.337126149406555e-12,
9.98608454245779e-13,
2.090118593122552e-13,
4.008634541512049e-14,
7.09755027540556e-15,
1.192455548347011e-15,
1.822418838025092e-16,
0.002894847296804372,
-4.39980484346601e-10,
-5.06546170688133e-10,
-3.887884286715246e-10,
-2.238044659337291e-10,
-1.030656326679473e-10,
-3.955279635762273e-11,
-1.301045858814485e-11,
-3.744672360388189e-12,
-9.58027682885022e-13,
-2.205854315443528e-13,
-4.617040477631059e-14,
-8.85546490577004e-15,
-1.56807914787495e-15,
-2.63514004780888e-16,
-4.029010854946129e-17,
-0.0007046603286275615,
8.91528240080878e-11,
1.026409684707467e-10,
7.87798342137838e-11,
4.534929445142751e-11,
2.088410021284157e-11,
8.01455301185626e-12,
2.636301959914071e-12,
7.58782390506869e-13,
1.9412578176468e-13,
4.469773007756131e-14,
9.35576467259658e-15,
1.794488952614004e-15,
3.177790184164177e-16,
5.341024154312659e-17,
8.1683981170527e-18,
0.0001533669393685798,
-1.660026994616108e-11,
-1.911176498804316e-11,
-1.46688185419463e-11,
-8.44404706688414e-12,
-3.88862400940513e-12,
-1.492312025716912e-12,
-4.908805014424841e-13,
-1.41285783665846e-13,
-3.614644774672019e-14,
-8.3228150752411e-15,
-1.742082852392796e-15,
-3.341486467779205e-16,
-5.917565335742108e-17,
-9.94685230362734e-18,
-1.521521725230562e-18,
-0.00003016617812087408,
2.85093838999762e-12,
3.28226381383145e-12,
2.519230107995865e-12,
1.45018488392835e-12,
6.678343225479e-13,
2.562905114719695e-13,
8.43041365458844e-14,
2.426453628276733e-14,
6.20783279841355e-15,
1.429375536892363e-15,
2.991908663022428e-16,
5.738865303999741e-17,
1.016349388803839e-17,
1.708506585335695e-18,
2.613775164605455e-19,
5.410355353944985e-6,
-4.53547381402521e-13,
-5.22165677226588e-13,
-4.00776902964934e-13,
-2.307056555467028e-13,
-1.062438115435973e-13,
-4.077251639739635e-14,
-1.3411706304912e-14,
-3.860179224344103e-15,
-9.87588742114494e-16,
-2.273964900046199e-16,
-4.759795785955029e-17,
-9.130009248392e-18,
-1.616960040677316e-18,
-2.718275471341859e-19,
-4.158680175844038e-20,
-8.91511417699681e-7,
6.71268761487185e-14,
7.72826665961611e-14,
5.93166301127468e-14,
3.414538719835219e-14,
1.57245228230158e-14,
6.03450166604229e-15,
1.984988779245841e-15,
5.713230457364508e-16,
1.461675306219349e-16,
3.365577260480216e-17,
7.04475754253638e-18,
1.351299434769305e-18,
2.393286872693056e-19,
4.023989894319935e-20,
6.152859237489442e-21,
1.358238467661596e-7,
-9.28024346746994e-15,
-1.068427443960198e-14,
-8.2004826190987e-15,
-4.720576031707241e-15,
-2.173904470253792e-15,
-8.34265803973124e-16,
-2.744234300186194e-16,
-7.89850824922682e-17,
-2.020759533505145e-17,
-4.652905293154988e-18,
-9.73943352304331e-19,
-1.868158833333274e-19,
-3.307854814743088e-20,
-5.566970768818919e-21,
-8.613012114009704e-22,
-1.924406543198396e-8,
1.203226060581744e-15,
1.38526511355352e-15,
1.063230141287675e-15,
6.12044323971162e-16,
2.818566942587127e-16,
1.081664015927517e-16,
3.558026776117328e-17,
1.024078602425207e-17,
2.62001051980033e-18,
6.032684657355768e-19,
1.262802908113536e-19,
2.423308307729809e-20,
4.281056119612596e-21,
7.089538527741798e-22,
1.192659627681804e-22,
2.585049477471616e-9,
-1.486670837023192e-16,
-1.711592961431218e-16,
-1.313696004359424e-16,
-7.56224045927738e-17,
-3.482538927579039e-17,
-1.336472547925327e-17,
-4.396194882352481e-18,
-1.265322461164554e-18,
-3.237219917797458e-19,
-7.45373780687122e-20,
-1.559866365073913e-20,
-2.996756945860274e-21,
-5.408280319353021e-22,
-8.474090607301824e-23,
-1.646625413395424e-24,
-3.205981555177118e-10,
1.710192565856503e-17,
1.968931856172462e-17,
1.511210896630111e-17,
8.69922747388425e-18,
4.006140713333358e-18,
1.53741214152096e-18,
5.05716538967916e-19,
1.455558521197291e-19,
3.724020571405362e-20,
8.57835396199195e-21,
1.790974028618984e-21,
3.332771792926536e-22,
6.996238665344544e-23,
2.282754462964761e-23,
-6.939891515103894e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=1
0.1894721697803516,
-4.0510584945504e-7,
-4.65978404580602e-7,
-3.571719436118566e-7,
-2.051908625411338e-7,
-9.42083570128434e-8,
-3.598969137570756e-8,
-1.175767717832513e-8,
-3.349346771465082e-9,
-8.43607450307694e-10,
-1.896778275718772e-10,
-3.827916368533399e-11,
-6.93798104167737e-12,
-1.122285983928966e-12,
-1.600955878999121e-13,
-1.847474564509451e-14,
-0.2005375398728043,
1.299053661936369e-7,
1.495588321691185e-7,
1.147902658261948e-7,
6.60781515280467e-8,
3.042971099506456e-8,
1.16775246674325e-8,
3.841010775972971e-9,
1.105415268312027e-9,
2.827530439800597e-10,
6.50791107920718e-11,
1.36113308082244e-11,
2.606753089044947e-12,
4.602092925200513e-13,
7.68118969059209e-14,
1.159674232880884e-14,
0.1334645283432904,
-4.88386324943563e-8,
-5.62275240578399e-8,
-4.31561742648732e-8,
-2.48426387232682e-8,
-1.144040987800169e-8,
-4.390382668215808e-9,
-1.444151411419851e-9,
-4.156462188887537e-10,
-1.063329433470658e-10,
-2.448082915579255e-11,
-5.123090422863411e-12,
-9.82243317665533e-13,
-1.738009392561888e-13,
-2.915728929074983e-14,
-4.443944751374455e-15,
-0.0661643142970748,
1.661038786826426e-8,
1.912340994070321e-8,
1.467775063899274e-8,
8.44918219326986e-9,
3.890982741846936e-9,
1.493212555678457e-9,
4.911736520566701e-10,
1.413683917707435e-10,
3.616667806798108e-11,
8.32705669088013e-12,
1.742796369340529e-12,
3.342191918295335e-13,
5.916450397618119e-14,
9.93589385160438e-15,
1.517276536906702e-15,
0.02624324084633328,
-4.97969768057904e-9,
-5.73308761274353e-9,
-4.40030549946055e-9,
-2.533017322222268e-9,
-1.166495614557663e-9,
-4.476577229710383e-10,
-1.472518619838661e-10,
-4.238191930521848e-11,
-1.084281537351634e-11,
-2.496521135614441e-12,
-5.225296482806344e-13,
-1.00215863537787e-13,
-1.774387568851859e-14,
-2.981138870883269e-15,
-4.556047094999339e-16,
-0.00868454189034105,
1.319941453036217e-9,
1.519638512060272e-9,
1.166365286011407e-9,
6.71413397799364e-10,
3.091968980030024e-10,
1.18658389072546e-10,
3.903137576432857e-11,
1.123401708113406e-11,
2.874083048647256e-12,
6.61756294631289e-13,
1.385112143285846e-13,
2.656639471715661e-14,
4.704237443521594e-15,
7.90542014433216e-16,
1.208703257550662e-16,
0.002466311150209744,
-3.12034884028926e-10,
-3.59243389648325e-10,
-2.757294197487899e-10,
-1.587225305803108e-10,
-7.30943507450904e-11,
-2.805093554155249e-11,
-9.22705685971754e-12,
-2.655738366779325e-12,
-6.79440236177714e-13,
-1.56442055271661e-13,
-3.274517635422444e-14,
-6.280711334495086e-15,
-1.11222656425384e-15,
-1.869358450179837e-16,
-2.858939364534666e-17,
-0.0006134677589846643,
6.6401079859754e-11,
7.64470600386458e-11,
5.86752742341558e-11,
3.377618830574254e-11,
1.555449605521502e-11,
5.96924810961977e-12,
1.963522007990978e-12,
5.651431353027179e-13,
1.445857911505171e-13,
3.329126033823177e-14,
6.96833141691928e-15,
1.336594589755852e-15,
2.36702615299277e-16,
3.978740797587449e-17,
6.086085058907811e-18,
0.0001357478013769899,
-1.282922274721442e-11,
-1.477018715329038e-11,
-1.133653547911113e-11,
-6.52583197372273e-12,
-3.00525444964428e-12,
-1.153307300924944e-12,
-3.793686142265483e-13,
-1.091904132060583e-13,
-2.793524757614331e-14,
-6.43218991344129e-15,
-1.346358896457295e-15,
-2.582489346383042e-16,
-4.573572536828251e-17,
-7.688284090194313e-18,
-1.176195695468192e-18,
-0.00002705176065673001,
2.26773610572723e-12,
2.610827463619106e-12,
2.003883806769199e-12,
1.153527870144095e-12,
5.3121887001619e-13,
2.038625099538499e-13,
6.70585078300084e-14,
1.930088930141955e-14,
4.937941965067321e-15,
1.136982050978024e-15,
2.379897095034448e-16,
4.56500223317349e-17,
8.08478470623932e-18,
1.359146031420571e-18,
2.079483487069363e-19,
4.903313865860508e-6,
-3.69197868580164e-13,
-4.25054723569748e-13,
-3.262415095924654e-13,
-1.877996549034611e-13,
-8.64848871834187e-14,
-3.318976363659506e-14,
-1.091743975753139e-14,
-3.142277176418154e-15,
-8.03921525263746e-16,
-1.851067663091546e-16,
-3.874617904012105e-17,
-7.43217125352163e-18,
-1.316289362788027e-18,
-2.212926830326549e-19,
-3.385991810358143e-20,
-8.15034497939213e-7,
5.56860068350795e-14,
6.41108804481245e-14,
4.92069128122433e-14,
2.832576861711438e-14,
1.30444917330629e-14,
5.006003498298163e-15,
1.646675009421933e-15,
4.739491883750795e-16,
1.21255473519127e-16,
2.791970176763094e-17,
5.844121998393696e-18,
1.121013346607623e-18,
1.985318728612633e-19,
3.337479186989929e-20,
5.117878057495303e-21,
1.250830576783593e-7,
-7.82081255927577e-15,
-9.00404267570854e-15,
-6.91085733162539e-15,
-3.978208328870732e-15,
-1.832031774097865e-15,
-7.0306751173416e-16,
-2.312671021376405e-16,
-6.65637703142953e-17,
-1.702973185642923e-17,
-3.921190279061586e-18,
-8.20782358541928e-19,
-1.57441931038033e-19,
-2.788224854786837e-20,
-4.688212513994801e-21,
-7.198671095584899e-22,
-1.783278318199226e-8,
1.027612948657064e-15,
1.183083064537183e-15,
9.08049711247401e-16,
5.22715319206998e-16,
2.407191963170973e-16,
9.23793257100037e-17,
3.038726985210168e-17,
8.7461281978478e-18,
2.237620388910273e-18,
5.152290345031731e-19,
1.078372441750907e-19,
2.067558560111882e-20,
3.689420088750761e-21,
6.285916631614116e-22,
6.73416343941345e-23,
2.408631148984636e-9,
-1.284574781088065e-16,
-1.478921297307536e-16,
-1.135113931351744e-16,
-6.53423974260439e-17,
-3.009127407568712e-17,
-1.154794399628568e-17,
-3.798583023749323e-18,
-1.093316575403223e-18,
-2.797156546202024e-19,
-6.44062284011493e-20,
-1.348021127951666e-20,
-2.585967972960155e-21,
-4.612253321040552e-22,
-7.699969691036479e-23,
-8.707713154043492e-24,
-3.001031935368154e-10,
1.492322908045358e-17,
1.718100161673156e-17,
1.318690485107428e-17,
7.59099123498427e-18,
3.495779349130646e-18,
1.341553835524515e-18,
4.412912696148158e-19,
1.270142394086664e-19,
3.249327367043844e-20,
7.47770926184621e-21,
1.576658153454127e-21,
3.127434472898074e-22,
2.54702510522538e-23,
-4.339547237383009e-24,
3.06742751267245e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=2
0.1002687699364021,
-6.49526830968184e-8,
-7.47794160845593e-8,
-5.73951329130974e-8,
-3.303907576402335e-8,
-1.521485549753228e-8,
-5.83876233371625e-9,
-1.920505387986485e-9,
-5.52707634156013e-10,
-1.413765219900298e-10,
-3.253955539603588e-11,
-6.8056654041122e-12,
-1.303376544522473e-12,
-2.301046462600257e-13,
-3.840594845296047e-14,
-5.798371164404422e-15,
-0.1334645283432904,
4.88386324943563e-8,
5.62275240578399e-8,
4.31561742648732e-8,
2.48426387232682e-8,
1.144040987800169e-8,
4.390382668215808e-9,
1.444151411419851e-9,
4.156462188887537e-10,
1.063329433470658e-10,
2.448082915579254e-11,
5.123090422863411e-12,
9.82243317665533e-13,
1.738009392561888e-13,
2.915728929074982e-14,
4.443944751374453e-15,
0.0992464714456122,
-2.49155818023964e-8,
-2.868511491105481e-8,
-2.201662595848911e-8,
-1.26737732899048e-8,
-5.8364741127704e-9,
-2.239818833517686e-9,
-7.36760478085005e-10,
-2.120525876561152e-10,
-5.42500171019716e-11,
-1.24905850363202e-11,
-2.614194554010793e-12,
-5.013287877443e-13,
-8.87467559642722e-14,
-1.490384077740684e-14,
-2.275914805359603e-15,
-0.05248648169266798,
9.95939536115815e-9,
1.146617522548713e-8,
8.80061099892116e-9,
5.06603464444457e-9,
2.332991229115341e-9,
8.95315445942083e-10,
2.945037239677341e-10,
8.47638386104375e-11,
2.168563074703282e-11,
4.993042271228915e-12,
1.045059296561276e-12,
2.004317270755751e-13,
3.548775137703738e-14,
5.962277741766936e-15,
9.11209418999955e-16,
0.02171135472585215,
-3.29985363259052e-9,
-3.79909628015066e-9,
-2.915913215028499e-9,
-1.6785334944984e-9,
-7.72992245007501e-10,
-2.966459726813632e-10,
-9.75784394108208e-11,
-2.808504270283497e-11,
-7.18520762161809e-12,
-1.654390736578208e-12,
-3.462780358214695e-13,
-6.6415986792906e-14,
-1.176059360877735e-14,
-1.976355036066724e-15,
-3.021758144159002e-16,
-0.00739893345056149,
9.36104652083622e-10,
1.077730168941344e-9,
8.27188259243582e-10,
4.76167591739328e-10,
2.192830522345321e-10,
8.41528066243739e-11,
2.768117057905933e-11,
7.96721510031113e-12,
2.038320708526271e-12,
4.693261658133977e-13,
9.82355290623477e-14,
1.884213400343041e-14,
3.336679692737845e-15,
5.608075350441063e-16,
8.57681809467422e-17,
0.00214713715645885,
-2.324037795096873e-10,
-2.675647101358917e-10,
-2.053634598200299e-10,
-1.182166590703779e-10,
-5.4440736193381e-11,
-2.089236838371851e-11,
-6.87232702798464e-12,
-1.978000973564157e-12,
-5.060502690280503e-13,
-1.165194111842145e-13,
-2.438915995903156e-14,
-4.678081063804585e-15,
-8.28459154199401e-16,
-1.392559282990386e-16,
-2.130129701239122e-17,
-0.0005429912069275136,
5.13168910549661e-11,
5.90807486892717e-11,
4.53461419748612e-11,
2.610332792851829e-11,
1.202101781406309e-11,
4.613229209642731e-12,
1.517474458861067e-12,
4.367616533868793e-13,
1.117409904485555e-13,
2.572875968696272e-14,
5.385435592614729e-15,
1.032995739767664e-15,
1.8294290207621e-16,
3.075313649892596e-17,
4.704782437860506e-18,
0.0001217329227978113,
-1.020481246887719e-11,
-1.174872357834741e-11,
-9.01747712436833e-12,
-5.19087541214098e-12,
-2.390484913457613e-12,
-9.17381294172428e-13,
-3.017632850311932e-13,
-8.68540017979737e-14,
-2.222073882722941e-14,
-5.116419224456622e-15,
-1.070953694983457e-15,
-2.054251044150835e-16,
-3.638152330228089e-17,
-6.116152736001298e-18,
-9.35775935989916e-19,
-0.0000245165541848841,
1.845988637640248e-12,
2.125272805887534e-12,
1.631206924759124e-12,
9.38997915772766e-13,
4.324242707091831e-13,
1.659487547821304e-13,
5.458717793259855e-14,
1.5711379879621e-14,
4.019606090321645e-15,
9.25533477532369e-16,
1.937308226450298e-16,
3.716084296580368e-17,
6.58144070081443e-18,
1.10646225506936e-18,
1.693030431356538e-19,
4.48269074656751e-6,
-3.06273081725892e-13,
-3.526098932746248e-13,
-2.706380594654045e-13,
-1.5579174984321e-13,
-7.17447148700472e-14,
-2.753302320822103e-14,
-9.05671385650891e-15,
-2.606720910017084e-15,
-6.66905204014779e-16,
-1.535583909042404e-16,
-3.214265690311711e-17,
-6.165549642653486e-18,
-1.091975295752844e-18,
-1.835880238154285e-19,
-2.809539591335641e-20,
-7.505842682593638e-7,
4.6928876603758e-14,
5.4028862661171e-14,
4.146867969092211e-14,
2.387128528607296e-14,
1.09931279404751e-14,
4.218764770790454e-15,
1.387720932642895e-15,
3.994166766123349e-16,
1.02187104980116e-16,
2.352914960712524e-17,
4.925108353590121e-18,
9.44728201430442e-19,
1.673221189948023e-19,
2.813497867262656e-20,
4.305245500367201e-21,
1.159099140781194e-7,
-6.67934507328545e-15,
-7.68987978278034e-15,
-5.90220021365111e-15,
-3.397578822508027e-15,
-1.56464219335011e-15,
-6.00453112575567e-16,
-1.975131420973482e-16,
-5.684865458085652e-17,
-1.454421823529255e-17,
-3.348891160834904e-18,
-7.00987427197057e-19,
-1.34464153364505e-19,
-2.38216005417616e-20,
-4.004112901191677e-21,
-6.061828520297281e-22,
-1.661363751595428e-8,
8.87710358949916e-16,
1.022014268772708e-15,
7.84424861847036e-16,
4.51551158353843e-16,
2.079469102852836e-16,
7.9802512245369e-17,
2.625025453094577e-17,
7.55540717248721e-18,
1.932984436183105e-18,
4.450776629367407e-19,
9.31626540623265e-20,
1.78796855177115e-20,
3.168624341943109e-21,
5.238868700220612e-22,
7.9672619188318e-23,
2.254683816205279e-9,
-1.120954171826466e-16,
-1.290546123419128e-16,
-9.90530663760215e-17,
-5.70195179853914e-17,
-2.625844872541512e-17,
-1.007704465967322e-17,
-3.314745557724495e-18,
-9.54057617094383e-19,
-2.440868195451913e-19,
-5.62026458782076e-20,
-1.176698897924273e-20,
-2.256635274718805e-21,
-3.927498173291189e-22,
-6.726340036848802e-23,
-1.77072010437126e-23,
-2.820642330971977e-10,
1.313491282708969e-17,
1.512212658574714e-17,
1.16066600843053e-17,
6.68132946682724e-18,
3.076864862219147e-18,
1.180789805319739e-18,
3.884093806879942e-19,
1.11792066079999e-19,
2.86006014894011e-20,
6.589450843988214e-21,
1.381031037373544e-21,
2.552536209152875e-22,
4.208325214949718e-23,
1.664531022367141e-23,
4.263615472454349e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=3
0.0667322641716452,
-2.44193162471782e-8,
-2.81137620289199e-8,
-2.157808713243658e-8,
-1.24213193616341e-8,
-5.72020493900085e-9,
-2.195191334107904e-9,
-7.22075705709926e-10,
-2.078231094443769e-10,
-5.31664716735329e-11,
-1.224041457789627e-11,
-2.561545211431705e-12,
-4.91121658832766e-13,
-8.69004696280944e-14,
-1.457864464537491e-14,
-2.221972375687226e-15,
-0.0992464714456121,
2.49155818023964e-8,
2.868511491105481e-8,
2.201662595848911e-8,
1.26737732899048e-8,
5.8364741127704e-9,
2.239818833517686e-9,
7.36760478085005e-10,
2.120525876561152e-10,
5.42500171019716e-11,
1.24905850363202e-11,
2.614194554010793e-12,
5.013287877443e-13,
8.87467559642723e-14,
1.490384077740684e-14,
2.275914805359559e-15,
0.078729722539002,
-1.493909304173722e-8,
-1.71992628382307e-8,
-1.320091649838174e-8,
-7.59905196666686e-9,
-3.499486843673012e-9,
-1.342973168913124e-9,
-4.417555859516012e-10,
-1.271457579156563e-10,
-3.252844612054923e-11,
-7.48956340684337e-12,
-1.567588944841913e-12,
-3.006475906133627e-13,
-5.323162706555598e-14,
-8.94341661265029e-15,
-1.366814128500057e-15,
-0.04342270945170562,
6.5997072651811e-9,
7.59819256030138e-9,
5.83182643005705e-9,
3.35706698899683e-9,
1.545984490015016e-9,
5.93291945362732e-10,
1.951568788216434e-10,
5.61700854056704e-11,
1.437041524323631e-11,
3.308781473156444e-12,
6.92556071642946e-13,
1.328319735858133e-13,
2.352118721755127e-14,
3.952710072133413e-15,
6.043516288356292e-16,
0.01849733362640329,
-2.340261630209037e-9,
-2.69432542235334e-9,
-2.067970648108939e-9,
-1.19041897934831e-9,
-5.48207630586326e-10,
-2.103820165609331e-10,
-6.92029264476478e-11,
-1.991803775077766e-11,
-5.095801771315637e-12,
-1.173315414533489e-12,
-2.455888226558667e-13,
-4.710533500856706e-14,
-8.34169923184785e-15,
-1.402018837617953e-15,
-2.144204523616083e-16,
-0.006441411469312655,
6.97211338526264e-10,
8.02694130404454e-10,
6.16090379457617e-10,
3.546499772097105e-10,
1.633222085794877e-10,
6.2677105150904e-11,
2.061698108387118e-11,
5.93400292066866e-12,
1.518150807078067e-12,
3.495582335512426e-13,
7.31674798767589e-14,
1.403424319135452e-14,
2.485377462698852e-15,
4.177677848964202e-16,
6.390389092048617e-17,
0.00190046922425815,
-1.796091186928712e-10,
-2.067826204130147e-10,
-1.587114969124471e-10,
-9.13616477500631e-11,
-4.207356234933552e-11,
-1.614630223379358e-11,
-5.311160606028216e-12,
-1.528665786858266e-12,
-3.910934665710142e-13,
-9.00506589045172e-14,
-1.884902457419689e-14,
-3.615485089423289e-15,
-6.40300157246656e-16,
-1.076359775395586e-16,
-1.646673859961114e-17,
-0.000486931692530279,
4.0819249934139e-11,
4.69948943808903e-11,
3.606990854928193e-11,
2.076350167838734e-11,
9.56193966756464e-12,
3.669525181960398e-12,
1.207053141858527e-12,
3.474160076909105e-13,
8.8882955436468e-14,
2.046567692720032e-14,
4.283814786686543e-15,
8.21700418875043e-16,
1.45526091845093e-16,
2.446461096701669e-17,
3.743105406323698e-18,
0.0001103244936829602,
-8.30694886322434e-12,
-9.56372761940566e-12,
-7.34043115597563e-12,
-4.225490617845685e-12,
-1.945909216749094e-12,
-7.4676939596614e-13,
-2.456423005146472e-13,
-7.07012094056353e-14,
-1.808822739294645e-14,
-4.164900647016098e-15,
-8.71788701566568e-16,
-1.672237903924555e-16,
-2.961648279355093e-17,
-4.979082770705902e-18,
-7.618635068022185e-19,
-0.00002241343944743181,
1.531364783146805e-12,
1.763048746259634e-12,
1.353189744619538e-12,
7.78958431052098e-13,
3.587234278303734e-13,
1.376650598120685e-13,
4.528355078645735e-14,
1.303359922648828e-14,
3.334524658928275e-15,
7.67791641045777e-16,
1.607132145694942e-16,
3.082773541250124e-17,
5.459885516755697e-18,
9.17939829918045e-19,
1.404650547843315e-19,
4.128214429209985e-6,
-2.581088607264816e-13,
-2.97158790004057e-13,
-2.28077773121001e-13,
-1.312920891179464e-13,
-6.04622129034692e-14,
-2.320320978163491e-14,
-7.63246629467715e-15,
-2.196792058367401e-15,
-5.620291640428931e-16,
-1.294103350137396e-16,
-2.708809693416767e-17,
-5.196023822153152e-18,
-9.20276923952307e-19,
-1.547255804601331e-19,
-2.367692880704385e-20,
-6.95540533099778e-7,
4.00796190788717e-14,
4.61433642183312e-14,
3.541633703540303e-14,
2.038727801957118e-14,
9.38868443195693e-15,
3.603037687607031e-15,
1.18518378886368e-15,
3.411221305023802e-16,
8.72730335721703e-17,
2.009512581451498e-17,
4.206312202460701e-18,
8.06856983166491e-19,
1.429025926654437e-19,
2.402652211063208e-20,
3.679091332387036e-21,
1.079856378127598e-7,
-5.76999313855698e-15,
-6.64294976269126e-15,
-5.09865185748494e-15,
-2.935019355254665e-15,
-1.351625824119903e-15,
-5.187051654139863e-16,
-1.706229823716403e-16,
-4.910908462598953e-17,
-1.256412508924846e-17,
-2.892965967882836e-18,
-6.055571902519743e-19,
-1.161597607577762e-19,
-2.057176840524071e-20,
-3.457906186799405e-21,
-5.319247768766589e-22,
-1.555000355584572e-8,
7.74475857005481e-16,
8.91648240386965e-16,
6.84365252219583e-16,
3.939522341224644e-16,
1.814216412331765e-16,
6.96230762891721e-17,
2.290183135520724e-17,
6.5916572344837e-18,
1.686418981949884e-18,
3.883089425878659e-19,
8.12770715301657e-20,
1.559031336846449e-20,
2.769978486355839e-21,
4.652041040141158e-22,
6.36913881838997e-23,
2.11918167855723e-9,
-9.86647080827839e-17,
-1.135919381282918e-16,
-8.71850269669193e-17,
-5.018772721465712e-17,
-2.311229454602993e-17,
-8.8696647131979e-18,
-2.917589958333379e-18,
-8.39747487871092e-19,
-2.148421666792557e-19,
-4.946925777666874e-20,
-1.035440657065286e-20,
-1.984960494746353e-21,
-3.540213132047773e-22,
-6.068396087054575e-23,
-5.871853298454186e-24,
-2.660657437577934e-10,
1.164916146590561e-17,
1.341159222770066e-17,
1.029377661556848e-17,
5.92557319114235e-18,
2.728826409002877e-18,
1.047225148896723e-18,
3.444747077561536e-19,
9.91476065421739e-20,
2.536489247677625e-20,
5.840229901475311e-21,
1.227526590255297e-21,
2.353935486125701e-22,
3.04920393342128e-23,
6.480213088834009e-24,
1.110105310093289e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=4
0.0496232357228061,
-1.24577909011982e-8,
-1.434255745552741e-8,
-1.100831297924455e-8,
-6.3368866449524e-9,
-2.918237056385202e-9,
-1.119909416758843e-9,
-3.68380239042503e-10,
-1.060262938280576e-10,
-2.712500855098581e-11,
-6.2452925181601e-12,
-1.307097277005397e-12,
-2.5066439387215e-13,
-4.43733779821361e-14,
-7.45192038870342e-15,
-1.137957402679781e-15,
-0.078729722539002,
1.493909304173722e-8,
1.71992628382307e-8,
1.320091649838174e-8,
7.59905196666686e-9,
3.499486843673012e-9,
1.342973168913124e-9,
4.41755585951601e-10,
1.271457579156563e-10,
3.252844612054923e-11,
7.48956340684337e-12,
1.567588944841913e-12,
3.006475906133627e-13,
5.3231627065556e-14,
8.94341661265029e-15,
1.366814128500036e-15,
0.0651340641775584,
-9.89956089777166e-9,
-1.139728884045207e-8,
-8.74773964508557e-9,
-5.03560048349525e-9,
-2.318976735022524e-9,
-8.89937918044097e-10,
-2.927353182324651e-10,
-8.42551281085056e-11,
-2.155562286485447e-11,
-4.963172209734667e-12,
-1.03883410746442e-12,
-1.992479603787199e-13,
-3.528178082632709e-14,
-5.929065108200235e-15,
-9.06527443253273e-16,
-0.03699466725280784,
4.68052326041813e-9,
5.38865084470674e-9,
4.13594129621792e-9,
2.380837958696647e-9,
1.096415261172664e-9,
4.207640331218708e-10,
1.384058528952971e-10,
3.983607550155577e-11,
1.019160354263139e-11,
2.346630829067004e-12,
4.911776453117395e-13,
9.42106700171348e-14,
1.668339846369462e-14,
2.804037675236345e-15,
4.28840904724215e-16,
0.01610352867328122,
-1.743028346315644e-9,
-2.006735326011116e-9,
-1.540225948644029e-9,
-8.86624943024268e-10,
-4.083055214487154e-10,
-1.566927628772586e-10,
-5.15424527096775e-11,
-1.483500730167151e-11,
-3.795377017695131e-12,
-8.73895583878096e-13,
-1.829186996918996e-13,
-3.508560797839062e-14,
-6.21344365673895e-15,
-1.044419462236118e-15,
-1.597597273079918e-16,
-0.005701407672713987,
5.38827356076115e-10,
6.20347861236168e-10,
4.76134490735134e-10,
2.740849432489187e-10,
1.262206870474214e-10,
4.843890670115617e-11,
1.593348181801078e-11,
4.585997360553539e-12,
1.173280399707607e-12,
2.701519767122948e-13,
5.654707372231652e-14,
1.084645526823242e-14,
1.920900471749016e-15,
3.22907932602715e-16,
4.940021579120283e-17,
0.001704260923867225,
-1.428673747699265e-10,
-1.644821303336224e-10,
-1.262446799228755e-10,
-7.26722558745794e-11,
-3.34667888365793e-11,
-1.284333813690094e-11,
-4.224685996517849e-12,
-1.215956026921924e-12,
-3.110903440286186e-13,
-7.16298692454544e-14,
-1.49933517533628e-14,
-2.875951465987739e-15,
-5.093413216292831e-16,
-8.56261384704915e-17,
-1.310086878748108e-17,
-0.0004412979759989785,
3.32277955052479e-11,
3.82549105378933e-11,
2.936172467016198e-11,
1.690196249801183e-11,
7.78363687925952e-12,
2.987077588570715e-12,
9.82569203606639e-13,
2.828048380680892e-13,
7.23529096857406e-14,
1.665960261439364e-14,
3.487154811858516e-15,
6.68895162386122e-16,
1.184659313001001e-16,
1.991633138371363e-17,
3.047453930207636e-18,
0.0001008604773720204,
-6.89114151863002e-12,
-7.933719351801e-12,
-6.0893538459008e-12,
-3.505312936921188e-12,
-1.614255423941127e-12,
-6.19492768657116e-13,
-2.037759783755518e-13,
-5.86511964721884e-14,
-1.500536095286072e-14,
-3.455062381628611e-15,
-7.23209466047353e-16,
-1.387248099893338e-16,
-2.456948266919239e-17,
-4.130728512494125e-18,
-6.32094475335418e-19,
-0.00002064105862765059,
1.290543745143334e-12,
1.485793307036001e-12,
1.140388372096366e-12,
6.56460161503367e-13,
3.023109336907838e-13,
1.160159987016442e-13,
3.816231495839279e-14,
1.098395553858736e-14,
2.810144604330101e-15,
6.47051394320944e-16,
1.354404255884243e-16,
2.598010999855499e-17,
4.601382508100259e-18,
7.736251395118489e-19,
1.183858436534486e-19,
3.825473837217883e-6,
-2.204379403319348e-13,
-2.537885439544355e-13,
-1.947898849742683e-13,
-1.121300471135944e-13,
-5.163777266782705e-14,
-1.981671046406392e-14,
-6.51851188525061e-15,
-1.876172018720127e-15,
-4.800017635817108e-16,
-1.105232112129406e-16,
-2.313471332064645e-17,
-4.437710712792614e-18,
-7.85980138628193e-19,
-1.321489027879718e-19,
-2.022157390180615e-20,
-6.479905239354346e-7,
3.46231273909444e-14,
3.98613465150628e-14,
3.059471104128654e-14,
1.761172788119606e-14,
8.11049718263303e-15,
3.112515836687999e-15,
1.023831591113768e-15,
2.946814752492629e-16,
7.53916492467913e-17,
1.735938759260278e-17,
3.633677742170488e-18,
6.97013244718627e-19,
1.234406867912958e-19,
2.075974818150395e-20,
3.189716166740996e-21,
1.010721702892415e-7,
-5.03398150676752e-15,
-5.79558511998507e-15,
-4.4482755561511e-15,
-2.560632772713437e-15,
-1.179214534045265e-15,
-4.525399665273364e-16,
-1.488586056199627e-16,
-4.284482331784438e-17,
-1.096147399984479e-17,
-2.523948570550767e-18,
-5.283164336563413e-19,
-1.013424043750784e-19,
-1.794492517464179e-20,
-3.017957280893334e-21,
-4.671534225509609e-22,
-1.461398677885574e-8,
6.81552510279791e-16,
7.84666291300763e-16,
6.02253583175937e-16,
3.466849709187523e-16,
1.596542741390964e-16,
6.1269549638523e-17,
2.015402228145615e-17,
5.800778309340133e-18,
1.48408082302345e-18,
3.417162936966153e-19,
7.15182665251724e-20,
1.372809305342285e-20,
2.461548105989335e-21,
4.003269755365321e-22,
2.64294407721514e-23,
1.99900442482908e-9,
-8.75060265696802e-17,
-1.007450321006925e-16,
-7.73246634664913e-17,
-4.451164717506513e-17,
-2.049836443812998e-17,
-7.86653298709535e-18,
-2.587619724636637e-18,
-7.44774912187084e-19,
-1.905445402459728e-19,
-4.387404380449638e-20,
-9.18236277818142e-21,
-1.761757066943941e-21,
-3.163875755152972e-22,
-5.237821909186658e-23,
-2.739299669941272e-24,
-2.517807510063571e-10,
1.040149376422377e-17,
1.197516178897978e-17,
9.19127564331443e-18,
5.290922765538373e-18,
2.436559231503841e-18,
9.35063642082678e-19,
3.075803043830371e-19,
8.85279742695151e-20,
2.264725284023671e-20,
5.217881353054472e-21,
1.103373446490933e-21,
2.015547338636071e-22,
2.9022122231116e-24,
1.525874284522799e-23,
4.016346834586082e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=5
0.039364861269501,
-7.46954652086861e-9,
-8.59963141911535e-9,
-6.60045824919087e-9,
-3.79952598333343e-9,
-1.749743421836506e-9,
-6.71486584456562e-10,
-2.208777929758006e-10,
-6.35728789578281e-11,
-1.626422306027461e-11,
-3.74478170342169e-12,
-7.83794472420957e-13,
-1.503237953066814e-13,
-2.6615813532778e-14,
-4.47170830632514e-15,
-6.83407064250016e-16,
-0.0651340641775584,
9.89956089777166e-9,
1.139728884045207e-8,
8.74773964508557e-9,
5.03560048349525e-9,
2.318976735022524e-9,
8.89937918044097e-10,
2.927353182324651e-10,
8.42551281085056e-11,
2.155562286485447e-11,
4.96317220973467e-12,
1.03883410746442e-12,
1.992479603787199e-13,
3.528178082632705e-14,
5.92906510820023e-15,
9.06527443253319e-16,
0.05549200087921176,
-7.02078489062719e-9,
-8.08297626706011e-9,
-6.20391194432689e-9,
-3.571256938044971e-9,
-1.644622891758996e-9,
-6.31146049682806e-10,
-2.076087793429457e-10,
-5.97541132523337e-11,
-1.528740531394708e-11,
-3.519946243600506e-12,
-7.36766467967609e-13,
-1.413160050257023e-13,
-2.502509769554188e-14,
-4.206056512854426e-15,
-6.43261357086359e-16,
-0.03220705734656363,
3.48605669263133e-9,
4.01347065202229e-9,
3.080451897288099e-9,
1.773249886048559e-9,
8.16611042897442e-10,
3.133855257545213e-10,
1.030849054193563e-10,
2.967001460334341e-11,
7.59075403539036e-12,
1.747791167756216e-12,
3.658373993838024e-13,
7.0171215956782e-14,
1.24268873134823e-14,
2.088838924472491e-15,
3.195194546114509e-16,
0.01425351918178457,
-1.347068390190274e-9,
-1.550869653090403e-9,
-1.190336226837821e-9,
-6.85212358122289e-10,
-3.1555171761855e-10,
-1.210972667528891e-10,
-3.98337045450265e-11,
-1.146499340138372e-11,
-2.933200999268984e-12,
-6.75379941780732e-13,
-1.413676843057943e-13,
-2.711613817057507e-14,
-4.802251179358108e-15,
-8.07269831513121e-16,
-1.235005394956374e-16,
-0.005112782771544293,
4.28602124307536e-10,
4.93446390998284e-10,
3.787340397666435e-10,
2.180167676225968e-10,
1.004003665092122e-10,
3.853001441050108e-11,
1.267405798948719e-11,
3.647868080746674e-12,
9.33271032080961e-13,
2.148896077352368e-13,
4.49800552598978e-14,
8.62785439792287e-15,
1.528023964758438e-15,
2.568784154035241e-16,
3.930260649556015e-17,
0.001544542916007128,
-1.162972842687648e-10,
-1.338921868830841e-10,
-1.02766036345918e-10,
-5.91568687432435e-11,
-2.724272907750139e-11,
-1.045477156003322e-11,
-3.438992212634984e-12,
-9.89816933241704e-13,
-2.532351839009894e-13,
-5.830860915051991e-14,
-1.220504184135123e-14,
-2.341133068518732e-15,
-4.146307601430263e-16,
-6.970715966302923e-17,
-1.066608805483682e-17,
-0.0004034419106906351,
2.75645661215465e-11,
3.17348774613452e-11,
2.435741542515809e-11,
1.402125177160566e-11,
6.45702170678049e-12,
2.477971078856001e-12,
8.15103914892805e-13,
2.346047862890012e-13,
6.00214439139443e-14,
1.382024955010638e-14,
2.892837868581033e-15,
5.548992408456399e-16,
9.82779323639215e-17,
1.65229141572728e-17,
2.528376189785158e-18,
0.0000928847636898651,
-5.80744684814982e-12,
-6.68606987591109e-12,
-5.13174767001966e-12,
-2.954070724224254e-12,
-1.360399200438399e-12,
-5.220719937083599e-13,
-1.717304171650985e-13,
-4.942779988099077e-14,
-1.26456507081219e-14,
-2.911731272696421e-15,
-6.094819175426742e-16,
-1.169104927552321e-16,
-2.0706212551058e-17,
-3.481315559527861e-18,
-5.327465099509585e-19,
-0.00001912735635669304,
1.10218919996813e-12,
1.268942142178463e-12,
9.73948981551814e-13,
5.60649980372775e-13,
2.581887458174345e-13,
9.90835072197286e-14,
3.259254459090375e-14,
9.38085582364007e-15,
2.400007724907812e-15,
5.526158044420276e-16,
1.156735171471609e-16,
2.218854381777468e-17,
3.929889599829952e-18,
6.607437392054926e-19,
1.011186782309642e-19,
3.563948742906008e-6,
-1.904272326214137e-13,
-2.192374426410704e-13,
-1.682709389784308e-13,
-9.68645196093675e-14,
-4.460774199378183e-14,
-1.711883997581535e-14,
-5.631074696240701e-15,
-1.620748386892418e-15,
-4.146541438894321e-16,
-9.54766427309609e-17,
-1.99852106106339e-17,
-3.833587878672571e-18,
-6.78984104701974e-19,
-1.141621818697347e-19,
-1.747340368810488e-20,
-6.06505809765561e-7,
3.02067353660473e-14,
3.47767876730596e-14,
2.669216849121695e-14,
1.536524447527923e-14,
7.07595395858539e-15,
2.715495675435591e-15,
8.93235801624504e-16,
2.570931653393354e-16,
6.57750433210397e-17,
1.514511885126269e-17,
3.170188495765663e-18,
6.081104367164216e-19,
1.077069775696126e-19,
1.811112981307821e-20,
2.769946331202879e-21,
9.4988199622991e-8,
-4.42999055357313e-15,
-5.10021488548558e-15,
-3.914559251243157e-15,
-2.253401055766623e-15,
-1.037729177979642e-15,
-3.982430146084185e-16,
-1.309981661762469e-16,
-3.7704198473115e-17,
-9.64629460029556e-18,
-2.221121780012685e-18,
-4.649252563171196e-19,
-8.91837372057792e-20,
-1.580216169265996e-20,
-2.65575151535969e-21,
-4.002652966127876e-22,
-1.378397316939512e-8,
6.04367221828471e-16,
6.9580344973733e-16,
5.34048840536346e-16,
3.074231751253775e-16,
1.415735583219714e-16,
5.433082570197823e-17,
1.787159815702128e-17,
5.143846312136093e-18,
1.316009684463585e-18,
3.030184949750057e-19,
6.34270768548009e-20,
1.217113605873303e-20,
2.155503872562606e-21,
3.575319103729979e-22,
5.822798963092068e-23,
1.891696652281043e-9,
-7.81352252978149e-17,
-8.99564990926111e-17,
-6.90441593725876e-17,
-3.974500700284376e-17,
-1.830324657179935e-17,
-7.02412619268641e-18,
-2.310518446531845e-18,
-6.650190131720499e-19,
-1.701388528253557e-19,
-3.917582649169926e-20,
-8.20351516752429e-21,
-1.572817304127304e-21,
-2.705711343746991e-22,
-4.716527510057895e-23,
-1.534338368253897e-23,
-2.389484772274459e-10,
9.34370902489361e-18,
1.075734217189499e-17,
8.25656465080466e-18,
4.752859989500658e-18,
2.188772277983048e-18,
8.39971947878911e-19,
2.763007677915032e-19,
7.95252654240074e-20,
2.034523151119909e-20,
4.686466367728638e-21,
9.82738542995185e-22,
1.830416813807583e-22,
3.153801366510671e-23,
1.163460915126765e-23,
-9.19059752164347e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=6
0.0325670320887792,
-4.94978044888583e-9,
-5.69864442022604e-9,
-4.37386982254279e-9,
-2.51780024174762e-9,
-1.159488367511262e-9,
-4.44968959022049e-10,
-1.463676591162325e-10,
-4.21275640542528e-11,
-1.077781143242724e-11,
-2.481586104867333e-12,
-5.1941705373221e-13,
-9.96239801893599e-14,
-1.764089041316353e-14,
-2.964532554100116e-15,
-4.53263721626659e-16,
-0.0554920008792118,
7.02078489062719e-9,
8.08297626706011e-9,
6.20391194432689e-9,
3.57125693804497e-9,
1.644622891758996e-9,
6.31146049682806e-10,
2.076087793429457e-10,
5.97541132523336e-11,
1.528740531394708e-11,
3.519946243600506e-12,
7.36766467967609e-13,
1.413160050257023e-13,
2.502509769554187e-14,
4.206056512854425e-15,
6.4326135708637e-16,
0.04831058601984545,
-5.229085038947e-9,
-6.02020597803343e-9,
-4.62067784593215e-9,
-2.659874829072839e-9,
-1.224916564346163e-9,
-4.70078288631782e-10,
-1.546273581290344e-10,
-4.450502190501512e-11,
-1.138613105308555e-11,
-2.621686751634325e-12,
-5.48756099075704e-13,
-1.05256823935173e-13,
-1.864033097022321e-14,
-3.133258386708786e-15,
-4.792791819174509e-16,
-0.02850703836357027,
2.69413678038059e-9,
3.10173930618085e-9,
2.38067245367568e-9,
1.3704247162446e-9,
6.3110343523711e-10,
2.42194533505782e-10,
7.96674090900543e-11,
2.29299868027678e-11,
5.86640199853806e-12,
1.350759883561484e-12,
2.827353686115931e-13,
5.423227634115107e-14,
9.60450235871642e-15,
1.614539663026208e-15,
2.470010789909679e-16,
0.01278195692886035,
-1.071505310768825e-9,
-1.233615977495693e-9,
-9.46835099416597e-10,
-5.45041919056485e-10,
-2.510009162730274e-10,
-9.63250360262515e-11,
-3.168514497371758e-11,
-9.11967020186657e-12,
-2.333177580202373e-12,
-5.372240193380853e-13,
-1.124501381497396e-13,
-2.156963599480719e-14,
-3.820059911907036e-15,
-6.42196038508293e-16,
-9.82565162254511e-17,
-0.004633628747966784,
3.48891852804268e-10,
4.01676560646919e-10,
3.082981090359631e-10,
1.774706062286996e-10,
8.17281872320294e-11,
3.136431467991745e-11,
1.031697663784502e-11,
2.969450799707862e-12,
7.59705551698558e-13,
1.749258274505446e-13,
3.661512552382754e-14,
7.02339920551268e-15,
1.24389228044845e-15,
2.091214789897e-16,
3.199826414438647e-17,
0.00141204668742743,
-9.64759814257733e-11,
-1.110720711151234e-10,
-8.5250953988372e-11,
-4.90743812008033e-11,
-2.259957597381621e-11,
-8.67289877602842e-12,
-2.85286370213548e-12,
-8.21116752014576e-13,
-2.10075053699586e-13,
-4.837087342554115e-14,
-1.012493254011588e-14,
-1.942147342998458e-15,
-3.439727630979756e-16,
-5.783019951765741e-17,
-8.84931691249182e-18,
-0.000371539055903682,
2.322978743507315e-11,
2.674427955254421e-11,
2.052699071761066e-11,
1.181628291850218e-11,
5.44159681170314e-12,
2.088287978651717e-12,
6.86921669916389e-13,
1.977111998854657e-13,
5.058260292489837e-14,
1.164692511206848e-14,
2.437927674965585e-15,
4.676419719069023e-16,
8.28248495893206e-17,
1.392526224608152e-17,
2.130986740656002e-18,
0.0000860731034767827,
-4.95985139532279e-12,
-5.71023963458335e-12,
-4.38277041297688e-12,
-2.522924909371282e-12,
-1.161849355116408e-12,
-4.458757820812079e-13,
-1.466664505250106e-13,
-4.221385116774606e-14,
-1.080003475216755e-14,
-2.486771117980682e-15,
-5.205308265745897e-16,
-9.98484463360759e-17,
-1.768450435498659e-17,
-2.973347674132096e-18,
-4.550319373887905e-19,
-0.00001781973150743628,
9.52135709982814e-13,
1.096186691526793e-12,
8.41354294489089e-13,
4.84322367556337e-13,
2.230386038241452e-13,
8.55941591445378e-14,
2.815536008188442e-14,
8.10373807785211e-15,
2.073269733480648e-15,
4.773829865364514e-16,
9.99260022174384e-17,
1.916793010932747e-17,
3.394926684189979e-18,
5.708107022672828e-19,
8.73595566385845e-20,
3.335782775119306e-6,
-1.661370735314391e-13,
-1.912723656102396e-13,
-1.46806952343595e-13,
-8.45088593747005e-14,
-3.891775356976431e-14,
-1.493522882351114e-14,
-4.912797766895399e-15,
-1.414012656733023e-15,
-3.617628021940464e-16,
-8.32981659471742e-17,
-1.743603844213828e-17,
-3.344614673419453e-18,
-5.923857853690342e-19,
-9.96034842123163e-20,
-1.524366838117332e-20,
-5.699984551566529e-7,
2.658251410555879e-14,
3.060424903740924e-14,
2.348962717980668e-14,
1.352171401414249e-14,
6.22697727637717e-15,
2.389689193588719e-15,
7.86065017477662e-16,
2.262470711465524e-16,
5.788336253355048e-17,
1.332801943375028e-17,
2.789835111526539e-18,
5.351546392708676e-19,
9.47890887567648e-20,
1.59358908482752e-20,
2.433808799096058e-21,
8.95932367638026e-8,
-3.92829548565393e-15,
-4.52261713041884e-15,
-3.471236648225317e-15,
-1.998204117311806e-15,
-9.20206705348398e-16,
-3.531421455414249e-16,
-1.161626841197369e-16,
-3.343422116191873e-17,
-8.55386046454081e-18,
-1.969583158503869e-18,
-4.122750742031125e-19,
-7.908436105688e-20,
-1.400856492734182e-20,
-2.354641550784266e-21,
-3.599614624757005e-22,
-1.304295908184619e-8,
5.39562990682458e-16,
6.21194825945018e-16,
4.76784612471308e-16,
2.744592436152532e-16,
1.263931141993446e-16,
4.850512063030418e-17,
1.59552902212622e-17,
4.592290367157075e-18,
1.174898771105707e-18,
2.705291610895638e-19,
5.662881210340092e-20,
1.085988383650725e-20,
1.916847573492768e-21,
3.267759801320191e-22,
5.992575993287988e-23,
1.795300004239815e-9,
-7.01903844782885e-17,
-8.08096635931242e-17,
-6.20237044797978e-17,
-3.57037092251835e-17,
-1.644216101330169e-17,
-6.309908858496e-18,
-2.075583686284972e-18,
-5.973996385169951e-19,
-1.528393056716889e-19,
-3.519235654635015e-20,
-7.36799829418947e-21,
-1.412933025439169e-21,
-2.475266193715659e-22,
-4.251142921421126e-23,
-8.385722978214973e-24,
-2.273584218500236e-10,
8.43919845343171e-18,
9.71598594856346e-18,
7.45729429780445e-18,
4.292763088409395e-18,
1.976889914474093e-18,
7.586591331137e-19,
2.495537049889135e-19,
7.18272197418165e-20,
1.837602638206032e-20,
4.230630981857318e-21,
8.85631252860671e-22,
1.722443918407583e-22,
3.405252986012859e-23,
2.042981426616492e-24,
-6.479606501447192e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=7
0.02774600043960588,
-3.51039244531359e-9,
-4.04148813353006e-9,
-3.10195597216344e-9,
-1.785628469022485e-9,
-8.22311445879498e-10,
-3.15573024841403e-10,
-1.038043896714728e-10,
-2.98770566261668e-11,
-7.64370265697354e-12,
-1.759973121800253e-12,
-3.68383233983805e-13,
-7.06580025128511e-14,
-1.251254884777093e-14,
-2.103028256427212e-15,
-3.216306785431839e-16,
-0.0483105860198454,
5.229085038947e-9,
6.02020597803343e-9,
4.62067784593215e-9,
2.659874829072839e-9,
1.224916564346163e-9,
4.70078288631782e-10,
1.546273581290344e-10,
4.45050219050151e-11,
1.138613105308554e-11,
2.621686751634324e-12,
5.48756099075704e-13,
1.05256823935173e-13,
1.864033097022316e-14,
3.13325838670878e-15,
4.792791819175003e-16,
0.04276055754535541,
-4.04120517057088e-9,
-4.65260895927128e-9,
-3.57100868051352e-9,
-2.0556370743669e-9,
-9.46655152855665e-10,
-3.63291800258673e-10,
-1.195011136350814e-10,
-3.43949802041517e-11,
-8.79960299780709e-12,
-2.026139825342227e-12,
-4.241030529173898e-13,
-8.13484145117266e-14,
-1.440675353807417e-14,
-2.421809494539379e-15,
-3.705016184869786e-16,
-0.02556391385772178,
2.143010621537689e-9,
2.467231954991431e-9,
1.893670198833227e-9,
1.09008383811299e-9,
5.02001832546064e-10,
1.926500720525064e-10,
6.33702899474363e-11,
1.823934040373347e-11,
4.666355160404829e-12,
1.07444803867619e-12,
2.249002762994821e-13,
4.313927198961463e-14,
7.64011982381751e-15,
1.284392077017303e-15,
1.965130324469304e-16,
0.01158407186991659,
-8.72229632010657e-10,
-1.004191401617283e-9,
-7.70745272589897e-10,
-4.43676515571743e-10,
-2.043204680800706e-10,
-7.84107866997925e-11,
-2.579244159461218e-11,
-7.42362699926955e-12,
-1.89926387924637e-12,
-4.373145686263544e-13,
-9.1537813809559e-14,
-1.755849801378491e-14,
-3.109730701147406e-15,
-5.228036974700053e-16,
-7.99956603298247e-17,
-0.004236140062230218,
2.8942794427548e-10,
3.33216213343252e-10,
2.557528619634903e-10,
1.47223143601474e-10,
6.77987279210177e-11,
2.601869632791989e-11,
8.55859110635204e-12,
2.463350256028071e-12,
6.3022516109475e-13,
1.451126202756975e-13,
3.037479762017354e-14,
5.826442028972535e-15,
1.03191828921904e-15,
1.734905985319068e-16,
2.654795082556126e-17,
0.001300386695672643,
-8.13042560230848e-11,
-9.36049784342832e-11,
-7.18444675119278e-11,
-4.135699021492488e-11,
-1.904558884103801e-11,
-7.30900792531056e-12,
-2.404225844717085e-12,
-6.91989199601925e-13,
-1.770391102378367e-13,
-4.076423789243025e-14,
-8.53274686258285e-15,
-1.636746901596725e-15,
-2.898869730198328e-16,
-4.873841796439118e-17,
-7.45845425096215e-18,
-0.0003442924149984081,
1.9839405619842e-11,
2.284095858271672e-11,
1.753108168597294e-11,
1.009169965709477e-11,
4.647397429496204e-12,
1.783503131790439e-12,
5.86665803240025e-13,
1.688554049990949e-13,
4.320013909260971e-14,
9.94708449128086e-15,
2.082123310250091e-15,
3.993937859771224e-16,
7.07380180668374e-17,
1.189339094118917e-17,
1.820126986144629e-18,
0.0000801887916608039,
-4.28461069078924e-12,
-4.93284010711179e-12,
-3.786094321548407e-12,
-2.179450651900971e-12,
-1.003673716240395e-12,
-3.851737157788361e-13,
-1.266991202462489e-13,
-3.646682131519088e-14,
-9.32971379183864e-15,
-2.148223437060026e-15,
-4.496670080441679e-16,
-8.6255686343386e-17,
-1.527717522981488e-17,
-2.568647002582865e-18,
-3.931115345910179e-19,
-0.00001667890223332815,
8.30684956384487e-13,
9.5636135455601e-13,
7.34034398297011e-13,
4.225440876716052e-13,
1.945886715078166e-13,
7.46761071453522e-14,
2.456397667277926e-14,
7.07005978323992e-15,
1.808813115648129e-15,
4.164906235056211e-16,
8.71801487209027e-17,
1.672306559811036e-17,
2.961926505754154e-18,
4.980161555811965e-19,
7.622090171589255e-20,
3.134992288437231e-6,
-1.462038540361909e-13,
-1.683234001639051e-13,
-1.291929728664321e-13,
-7.43694405349512e-14,
-3.424838121733767e-14,
-1.314329294302467e-14,
-4.323358378388656e-15,
-1.244359116291433e-15,
-3.183585510662971e-16,
-7.33041216551412e-17,
-1.534410209097484e-17,
-2.943345908424197e-18,
-5.213161310934457e-19,
-8.76538736783971e-20,
-1.34175485462187e-20,
-5.376254734815428e-7,
2.357210625739575e-14,
2.713838914337441e-14,
2.08294817473778e-14,
1.199041160460855e-14,
5.52178681992158e-15,
2.119062633945014e-15,
6.97045103695791e-16,
2.00625186604693e-16,
5.132824241224739e-17,
1.181866819655667e-17,
2.473898905069787e-18,
4.745534208960596e-19,
8.40563714840859e-20,
1.413053006720811e-20,
2.15820021936746e-21,
8.47767597052971e-8,
-3.50707605956149e-15,
-4.03767037401767e-15,
-3.099026302472384e-15,
-1.783942670694008e-15,
-8.21535710439892e-16,
-3.152757884914672e-16,
-1.037069211835641e-16,
-2.984917814121388e-17,
-7.63666013208069e-18,
-1.758393923069442e-18,
-3.680684104864303e-19,
-7.06011536299747e-20,
-1.25095989901871e-20,
-2.106534410833141e-21,
-3.168117920521326e-22,
-1.237738630268881e-8,
4.84631055297273e-16,
5.57952101765686e-16,
4.28244033343631e-16,
2.465170464880954e-16,
1.135252627280068e-16,
4.356690467347537e-17,
1.433091293643254e-17,
4.124758309694766e-18,
1.055284155218573e-18,
2.429889513925605e-19,
5.086685074047993e-20,
9.75075093628106e-21,
1.716088107747856e-21,
2.966487240951286e-22,
5.723263446409823e-23,
1.708233646174091e-9,
-6.33966146327402e-17,
-7.29880474263948e-17,
-5.60203928601062e-17,
-3.224792600530055e-17,
-1.485071471308765e-17,
-5.699169278666914e-18,
-1.874686877627672e-18,
-5.395772910051684e-19,
-1.380460828908711e-19,
-3.17848251711478e-20,
-6.655030763006767e-21,
-1.280189931044129e-21,
-2.213668210358196e-22,
-3.352162515209356e-23,
-1.14430873213239e-23,
-2.168388189348549e-10,
7.6597577631404e-18,
8.81862173684541e-18,
6.76854188180386e-18,
3.896285410849074e-18,
1.794305280138802e-18,
6.88589690429561e-19,
2.265049048012521e-19,
6.519373536430832e-20,
1.667999848602327e-20,
3.837993753356081e-21,
7.99149863861019e-22,
1.606111067770142e-22,
4.027056168773908e-23,
-2.001753918787115e-24,
-1.309310952355078e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=8
0.02415529300992272,
-2.6145425194735e-9,
-3.01010298901671e-9,
-2.31033892296607e-9,
-1.32993741453642e-9,
-6.12458282173081e-10,
-2.35039144315891e-10,
-7.73136790645172e-11,
-2.225251095250756e-11,
-5.69306552654277e-12,
-1.310843375817162e-12,
-2.743780495378519e-13,
-5.26284119675865e-14,
-9.32016548511158e-15,
-1.56662919335439e-15,
-2.396395909587487e-16,
-0.0427605575453554,
4.04120517057088e-9,
4.65260895927128e-9,
3.57100868051352e-9,
2.0556370743669e-9,
9.46655152855665e-10,
3.63291800258673e-10,
1.195011136350814e-10,
3.43949802041517e-11,
8.79960299780709e-12,
2.026139825342226e-12,
4.2410305291739e-13,
8.13484145117265e-14,
1.440675353807421e-14,
2.421809494539391e-15,
3.705016184869371e-16,
0.03834587078658268,
-3.21451593230653e-9,
-3.70084793248715e-9,
-2.840505298249841e-9,
-1.635125757169485e-9,
-7.53002748819096e-10,
-2.889751080787597e-10,
-9.50554349211544e-11,
-2.73590106056002e-11,
-6.99953274060724e-12,
-1.611672058014285e-12,
-3.373504144492233e-13,
-6.47089079844219e-14,
-1.14601797357259e-14,
-1.926588115526042e-15,
-2.947695486707794e-16,
-0.02316814373983422,
1.744459264021348e-9,
2.008382803234606e-9,
1.541490545179825e-9,
8.87353031143503e-10,
4.086409361601493e-10,
1.568215733995882e-10,
5.15848831892254e-11,
1.48472539985394e-11,
3.798527758492816e-12,
8.74629137252726e-13,
1.830756276191228e-13,
3.511699602757196e-14,
6.21946140229182e-15,
1.045607394938405e-15,
1.599913206633457e-16,
0.0105903501555752,
-7.2356986068869e-10,
-8.33040533358117e-10,
-6.39382154908716e-10,
-3.680578590036793e-10,
-1.694968198025416e-10,
-6.50467408197987e-11,
-2.139647776587977e-11,
-6.15837564007008e-12,
-1.575562902736853e-12,
-3.627815506892361e-13,
-7.59369940504259e-14,
-1.456610507243655e-14,
-2.579795723065589e-15,
-4.337264963240499e-16,
-6.636987704466765e-17,
-0.003901160086968159,
2.439127680675773e-10,
2.808149353009188e-10,
2.155334025343015e-10,
1.240709706439215e-10,
5.71367665227212e-11,
2.192702377578092e-11,
7.21267753410166e-12,
2.075967598791497e-12,
5.311173307098621e-13,
1.222927136764678e-13,
2.55982405875457e-14,
4.910240704704154e-15,
8.69660919139169e-16,
1.462152539518262e-16,
2.237536264943906e-17,
0.001205023452503771,
-6.94379196697479e-11,
-7.9943355039855e-11,
-6.13587859011712e-11,
-3.532094879998478e-11,
-1.626589100330722e-11,
-6.24226096129359e-12,
-2.053330311348988e-12,
-5.90993917499383e-13,
-1.512004868247637e-13,
-3.481479571968873e-14,
-7.2874315860461e-15,
-1.397878250783857e-15,
-2.475830628592887e-16,
-4.162686844253177e-17,
-6.370444851783632e-18,
-0.0003207551676862242,
1.713844279830351e-11,
1.973136046891112e-11,
1.514437731725086e-11,
8.71780262548186e-12,
4.01469487319469e-12,
1.540694866274912e-12,
5.067964820243089e-13,
1.458672855599482e-13,
3.731885524383922e-14,
8.59289376558095e-15,
1.798668036206069e-15,
3.450227469021581e-16,
6.110869993298382e-17,
1.027458709314905e-17,
1.572447500539567e-18,
0.0000750550599325138,
-3.73808229994643e-12,
-4.30362609114582e-12,
-3.303154788993026e-12,
-1.901448392597538e-12,
-8.75649020898825e-13,
-3.360424818139212e-13,
-1.105378949155931e-13,
-3.181526899251326e-14,
-8.13965901245117e-15,
-1.874207803181336e-15,
-3.923106673395792e-16,
-7.52537969138755e-17,
-1.332867334663054e-17,
-2.241070829692169e-18,
-3.429897119454218e-19,
-0.00001567495031486587,
7.31018895225959e-13,
8.41616569136647e-13,
6.45964533003328e-13,
3.718470119465699e-13,
1.712418182531348e-13,
6.57164310077998e-14,
2.161678080421637e-14,
6.2217923897982e-15,
1.591791939171012e-15,
3.665204224391514e-16,
7.67204688299032e-17,
1.471671567980953e-17,
2.606586849743192e-18,
4.38276362750955e-19,
6.70784085184066e-20,
2.95694085596453e-6,
-1.296466086333633e-13,
-1.492611681702007e-13,
-1.145621710105272e-13,
-6.59472761441417e-14,
-3.036983318257947e-14,
-1.16548466638919e-14,
-3.833748786604668e-15,
-1.103438731543449e-15,
-2.823053843853238e-16,
-6.50026917758932e-17,
-1.360645551267773e-17,
-2.610032584274986e-18,
-4.622856784286813e-19,
-7.773006720755749e-20,
-1.189611141236484e-20,
-5.087236895848286e-7,
2.104458365555603e-14,
2.422847138657793e-14,
1.85960376010346e-14,
1.070473811595725e-14,
4.929712584202072e-15,
1.891845968702073e-15,
6.2230443301051e-16,
1.791131759500626e-16,
4.582459200751202e-17,
1.055142201440009e-17,
2.208641328365634e-18,
4.236734570725901e-19,
7.50395116940705e-20,
1.261339315700258e-20,
1.933143120877615e-21,
8.04506414647127e-8,
-3.15002553278924e-15,
-3.626600787183954e-15,
-2.783518770725588e-15,
-1.60232197715021e-15,
-7.37896328158686e-16,
-2.831780185276968e-16,
-9.31486766202845e-17,
-2.681028230450473e-17,
-6.85918577612331e-18,
-1.579375217054779e-18,
-3.305986458944957e-19,
-6.341609592947568e-20,
-1.123033975312345e-20,
-1.889173985999005e-21,
-2.910452522743384e-22,
-1.177631282535654e-8,
4.3766644723591e-16,
5.03882101456154e-16,
3.867437788996011e-16,
2.226275848044186e-16,
1.025237637747276e-16,
3.934492706426845e-17,
1.294213494265773e-17,
3.725037051516231e-18,
9.53019470952621e-19,
2.194430789148224e-19,
4.593411022798624e-20,
8.80148914913738e-21,
1.56296344495778e-21,
2.728633713047505e-22,
3.415940487680265e-23,
1.629207604093637e-9,
-5.75421281770315e-17,
-6.62478211483388e-17,
-5.08470785345824e-17,
-2.926992749741851e-17,
-1.34792962775315e-17,
-5.172868443873556e-18,
-1.701565336694332e-18,
-4.897489070670894e-19,
-1.25298380097121e-19,
-2.885060439483287e-20,
-6.03833667387056e-21,
-1.158926985441437e-21,
-2.06959107568848e-22,
-3.402752086992275e-23,
-3.596380359480949e-24,
-2.07248131095109e-10,
6.98337629535958e-18,
8.03990883192926e-18,
6.17085769694751e-18,
3.552230803739175e-18,
1.635862343783665e-18,
6.27785003812783e-19,
2.065037908385463e-19,
5.943710737765336e-20,
1.520675242661539e-20,
3.497920533966588e-21,
7.32457754625352e-22,
1.500073997442544e-22,
2.214327714770809e-23,
-5.975594568647092e-24,
7.276416618205942e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=9
0.0213802787726777,
-2.02060258528544e-9,
-2.32630447963564e-9,
-1.78550434025676e-9,
-1.02781853718345e-9,
-4.73327576427832e-10,
-1.816459001293365e-10,
-5.97505568175407e-11,
-1.719749010207585e-11,
-4.39980149890354e-12,
-1.013069912671113e-12,
-2.120515264586949e-13,
-4.06742072558633e-14,
-7.20337676903711e-15,
-1.210904747269695e-15,
-1.85250809243467e-16,
-0.03834587078658267,
3.21451593230653e-9,
3.70084793248715e-9,
2.84050529824984e-9,
1.635125757169485e-9,
7.53002748819096e-10,
2.889751080787597e-10,
9.50554349211544e-11,
2.73590106056002e-11,
6.99953274060724e-12,
1.611672058014285e-12,
3.373504144492233e-13,
6.47089079844219e-14,
1.146017973572588e-14,
1.926588115526041e-15,
2.947695486707975e-16,
0.03475221560975134,
-2.61668889603202e-9,
-3.01257420485191e-9,
-2.312235817769737e-9,
-1.331029546715255e-9,
-6.12961404240224e-10,
-2.352323600993823e-10,
-7.73773247838381e-11,
-2.22708809978091e-11,
-5.69779163773922e-12,
-1.311943705879089e-12,
-2.746134414286843e-13,
-5.26754940413578e-14,
-9.32919210343743e-15,
-1.568411092407786e-15,
-2.399869809952813e-16,
-0.02118070031115138,
1.447139721377412e-9,
1.666081066716272e-9,
1.27876430981746e-9,
7.36115718007375e-10,
3.389936396050907e-10,
1.300934816396003e-10,
4.279295553176048e-11,
1.231675128014043e-11,
3.151125805473775e-12,
7.25563101378488e-13,
1.518739881008543e-13,
2.91322101448739e-14,
5.159591446133559e-15,
8.6745299264798e-16,
1.327397540870727e-16,
0.00975290021742006,
-6.09781920168933e-10,
-7.02037338252285e-10,
-5.38833506335744e-10,
-3.101774266097985e-10,
-1.428419163068005e-10,
-5.48175594394514e-11,
-1.803169383525384e-11,
-5.18991899697865e-12,
-1.327793326774634e-12,
-3.057317841911597e-13,
-6.39956014688582e-14,
-1.227560176177235e-14,
-2.174152297857013e-15,
-3.655381348667001e-16,
-5.593840661761394e-17,
-0.003615070357463653,
2.083137590077086e-10,
2.398300651177975e-10,
1.840763577021571e-10,
1.059628463991734e-10,
4.8797673009562e-11,
1.872678288374277e-11,
6.15999093400157e-12,
1.772981752485081e-12,
4.536014604709421e-13,
1.044443871582999e-13,
2.186229475800589e-14,
4.193634752312951e-15,
7.42749188501421e-16,
1.248806053337931e-16,
1.911133462653548e-17,
0.001122643086910748,
-5.99845497943388e-11,
-6.90597616415073e-11,
-5.30053206106224e-11,
-3.051230918932718e-11,
-1.405143205624619e-11,
-5.39243203198705e-12,
-1.773787687093262e-12,
-5.105354994621511e-13,
-1.306159933540173e-13,
-3.007512817978637e-14,
-6.29533812681786e-15,
-1.207579613854915e-15,
-2.138804496938978e-16,
-3.596105515422545e-17,
-5.503566231978177e-18,
-0.0003002202407288779,
1.495232923195921e-11,
1.721450440162441e-11,
1.321261918440221e-11,
7.60579358675583e-12,
3.502596091131973e-12,
1.344169930147987e-12,
4.421515806137591e-13,
1.272610762438979e-13,
3.255863611994139e-14,
7.49683122880546e-15,
1.56924267235903e-15,
3.010151884186473e-16,
5.331469442925533e-17,
8.96428323098009e-18,
1.37195791657843e-18,
0.00007053727630420817,
-3.28958502504019e-12,
-3.7872745571123e-12,
-2.906840395442859e-12,
-1.673311551991115e-12,
-7.70588181324708e-13,
-2.957239392225375e-13,
-9.72755135161341e-14,
-2.79980657247493e-14,
-7.16306371888911e-15,
-1.649341897893948e-15,
-3.452421089595943e-16,
-6.62252241138829e-17,
-1.172964059102883e-17,
-1.972239753707987e-18,
-3.0185427038515e-19,
-0.00001478469362389153,
6.48232699928877e-13,
7.46305445683734e-13,
5.72810551750566e-13,
3.297362061260217e-13,
1.518490855090886e-13,
5.82742024633826e-14,
1.916873378326853e-14,
5.517190736294272e-15,
1.41152617400226e-15,
3.25013287118306e-16,
6.80322440163819e-17,
1.305015527488363e-17,
2.311421078065563e-18,
3.886507967753894e-19,
5.948665033007376e-20,
2.79798101397282e-6,
-1.157452323573988e-13,
-1.332566182445563e-13,
-1.022782264685211e-13,
-5.88760709565921e-14,
-2.711342442561117e-14,
-1.040515482837678e-14,
-3.422675039740023e-15,
-9.85122655655016e-16,
-2.520353035758986e-16,
-5.803284015284738e-17,
-1.214753084477492e-17,
-2.330182965767771e-18,
-4.127223666860287e-19,
-6.939673855506588e-20,
-1.061947380190745e-20,
-4.827643057236451e-7,
1.89021005508064e-14,
2.176184669726548e-14,
1.670283340301399e-14,
9.61492242261026e-15,
4.427834138460452e-15,
1.699243172569607e-15,
5.58949644293774e-16,
1.608782682585058e-16,
4.115935686791808e-17,
9.4772267262626e-18,
1.983787553234738e-18,
3.805377522742319e-19,
6.74103661422233e-20,
1.133456746152756e-20,
1.724931353943811e-21,
7.654376017705041e-8,
-2.84476177610206e-15,
-3.275152918248359e-15,
-2.513772591675768e-15,
-1.447043627778349e-15,
-6.66388036341966e-16,
-2.557357209480048e-16,
-8.41218027964093e-17,
-2.421214815306491e-17,
-6.19447630456589e-18,
-1.426321961456297e-18,
-2.985625006150105e-19,
-5.727052587007492e-20,
-1.013885119774374e-20,
-1.706647941482639e-21,
-2.667350916205355e-22,
-1.123081178492394e-8,
3.9720185856354e-16,
4.5729552448699e-16,
3.509872633113512e-16,
2.020444840472078e-16,
9.30448994273205e-17,
3.570728132964019e-17,
1.174556719916436e-17,
3.380638986919938e-18,
8.64906524706833e-19,
1.99150770141045e-19,
4.169707160957727e-20,
7.99871354397012e-21,
1.38961788540081e-21,
2.352132886716973e-22,
6.44538013895011e-23,
1.557158898082609e-9,
-5.24616413416631e-17,
-6.03986948040037e-17,
-4.635770859128519e-17,
-2.668563891795025e-17,
-1.228918786483536e-17,
-4.716147819297478e-18,
-1.551331544286053e-18,
-4.465082562379335e-19,
-1.142357738192446e-19,
-2.630334825488254e-20,
-5.504215889745242e-21,
-1.05694129186055e-21,
-1.918857700966544e-22,
-3.037703476276023e-23,
5.963875768483764e-25,
-1.984686880434762e-10,
6.39267542825697e-18,
7.35983935767874e-18,
5.64888513355659e-18,
3.25175929488637e-18,
1.497490157963224e-18,
5.746828176125025e-19,
1.890361689883631e-19,
5.44088806736452e-20,
1.392236426109742e-20,
3.205741973005368e-21,
6.59273155400193e-22,
1.266571650409074e-22,
5.3141970035307e-23,
6.676098915209827e-24,
-3.117640342359542e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=10
0.01917293539329134,
-1.60725796615327e-9,
-1.85042396624357e-9,
-1.42025264912492e-9,
-8.17562878584742e-10,
-3.76501374409548e-10,
-1.444875540393798e-10,
-4.75277174605772e-11,
-1.36795053028001e-11,
-3.49976637030362e-12,
-8.05836029007142e-13,
-1.686752072246117e-13,
-3.23544539922109e-14,
-5.73008986786294e-15,
-9.63294057763021e-16,
-1.473847743353986e-16,
-0.03475221560975133,
2.61668889603202e-9,
3.01257420485191e-9,
2.312235817769737e-9,
1.331029546715255e-9,
6.12961404240224e-10,
2.352323600993823e-10,
7.73773247838381e-11,
2.22708809978091e-11,
5.69779163773922e-12,
1.311943705879089e-12,
2.746134414286843e-13,
5.26754940413578e-14,
9.32919210343739e-15,
1.568411092407794e-15,
2.399869809953252e-16,
0.03177105046672708,
-2.17070958206612e-9,
-2.499121600074408e-9,
-1.91814646472619e-9,
-1.104173577011062e-9,
-5.08490459407636e-10,
-1.951402224594005e-10,
-6.41894332976407e-11,
-1.847512692021065e-11,
-4.72668870821066e-12,
-1.088344652067732e-12,
-2.278109821512816e-13,
-4.369831521731096e-14,
-7.73938716920012e-15,
-1.301179488971843e-15,
-1.99109631130816e-16,
-0.01950580043484108,
1.219563840337895e-9,
1.404074676504604e-9,
1.077667012671515e-9,
6.20354853219612e-10,
2.856838326136078e-10,
1.096351188789054e-10,
3.606338767050855e-11,
1.037983799395756e-11,
2.655586653549332e-12,
6.11463568382334e-13,
1.279912029377178e-13,
2.455120352354569e-14,
4.348304595718625e-15,
7.31076269732834e-16,
1.118768132302208e-16,
0.00903767589365881,
-5.20784397519262e-10,
-5.99575162794483e-10,
-4.60190894255384e-10,
-2.649071159979286e-10,
-1.219941825239028e-10,
-4.68169572093561e-11,
-1.539997733500363e-11,
-4.43245438121262e-12,
-1.134003651177336e-12,
-2.611109678957465e-13,
-5.46557368950067e-14,
-1.048408688077694e-14,
-1.856872971271156e-15,
-3.122015133411336e-16,
-4.777833654871878e-17,
-0.00336792926068652,
1.799536493816058e-10,
2.071792849228978e-10,
1.590159618306206e-10,
9.1536927567264e-11,
4.215429616840813e-11,
1.617729609583435e-11,
5.32136306123807e-12,
1.531606498374447e-12,
3.918479800589709e-13,
9.0225384538654e-14,
1.88860143803564e-14,
3.622738841526226e-15,
6.41641348934437e-16,
1.078831654769339e-16,
1.651069885393876e-17,
0.001050770842559686,
-5.23331523121122e-11,
-6.02507654059789e-11,
-4.6244167145633e-11,
-2.66202775537751e-11,
-1.225908631902163e-11,
-4.704594755540874e-12,
-1.5475305321557e-12,
-4.454137668558173e-13,
-1.1395522642031e-13,
-2.623890930091442e-14,
-5.492349353487849e-15,
-1.053553159578686e-15,
-1.866014299774487e-16,
-3.137499116978269e-17,
-4.801853248105515e-18,
-0.0002821491061750563,
1.315834012972268e-11,
1.514909826248362e-11,
1.162736160789381e-11,
6.6932462230017e-12,
3.082352732223736e-12,
1.182895759547679e-12,
3.891020549386933e-13,
1.119922631506029e-13,
2.865225494005053e-14,
6.59736760637515e-15,
1.380968438262752e-15,
2.649008971671017e-16,
4.691856436732163e-17,
7.88895885091875e-18,
1.207414971853036e-18,
0.00006653112119922577,
-2.91704714647458e-12,
-3.358374501886483e-12,
-2.57764748004512e-12,
-1.483812925936623e-12,
-6.8332088404004e-13,
-2.622339107970721e-13,
-8.62593019298676e-14,
-2.482735828599562e-14,
-6.3518677765774e-15,
-1.462559790749132e-15,
-3.061450949238041e-16,
-5.872569757417322e-17,
-1.04014021540212e-17,
-1.74893000952759e-18,
-2.676823191332545e-19,
-0.00001398989484705889,
5.7872584641011e-13,
6.66282728131735e-13,
5.11390853659944e-13,
2.943801943603432e-13,
1.35567048250723e-13,
5.202574579042025e-14,
1.711336587283451e-14,
4.92561059406618e-15,
1.260175830357735e-15,
2.901640427383767e-16,
6.073762549397878e-17,
1.165090783840628e-17,
2.063598413549413e-18,
3.46984575651272e-19,
5.311109374604176e-20,
2.655204374560818e-6,
-1.039615735451757e-13,
-1.196901804545786e-13,
-9.18656018453035e-14,
-5.28820837600901e-14,
-2.435309256734467e-14,
-9.34583929341828e-15,
-3.074223650671038e-15,
-8.84830650275733e-16,
-2.263765036394088e-16,
-5.212475558401418e-17,
-1.091085328538581e-17,
-2.092963925090594e-18,
-3.707059771684445e-19,
-6.233239361646994e-20,
-9.54055264295051e-21,
-4.5932056066368e-7,
1.70703599430779e-14,
1.965297750160397e-14,
1.50842166523436e-14,
8.68317192220754e-15,
3.998747360084785e-15,
1.534575177328094e-15,
5.047837271497391e-16,
1.452881177044313e-16,
3.717075645380137e-17,
8.55882887224709e-18,
1.791549010992261e-18,
3.436604493461046e-19,
6.087873129399575e-20,
1.023832677810035e-20,
1.556248801560132e-21,
7.299809221472018e-8,
-2.581747421361302e-15,
-2.972346467395381e-15,
-2.281360075355449e-15,
-1.313256256085866e-15,
-6.04776699843049e-16,
-2.320915160111739e-16,
-7.63442734335899e-17,
-2.197360246119149e-17,
-5.621764581771527e-18,
-1.294452122309009e-18,
-2.709576289877888e-19,
-5.197429784776608e-20,
-9.20594246750267e-21,
-1.55028401721739e-21,
-2.371518186341766e-22,
-1.073352861143419e-8,
3.62092436314813e-16,
4.16874310289837e-16,
3.19962837886881e-16,
1.841853926194218e-16,
8.48204870700823e-17,
3.25510488429515e-17,
1.070735527146826e-17,
3.081818911411747e-18,
7.88456885015211e-19,
1.815456268373951e-19,
3.800892732971085e-20,
7.29676971877105e-21,
1.270094167016565e-21,
2.093744194825509e-22,
5.83687096182709e-23,
1.491203777028391e-9,
-4.8024650225678e-17,
-5.52904202375591e-17,
-4.243696332842278e-17,
-2.442867693380983e-17,
-1.12498188404017e-17,
-4.317275494104789e-18,
-1.420126417938397e-18,
-4.087446266171565e-19,
-1.045739264936691e-19,
-2.407804502550872e-20,
-5.040351802778913e-21,
-9.69267127905252e-22,
-1.709960556307821e-22,
-2.611693416943858e-23,
-4.610570475824867e-24,
-1.904018650067956e-10,
5.87378733563816e-18,
6.76244739036329e-18,
5.19036989451984e-18,
2.987816750550701e-18,
1.37594015556871e-18,
5.28036355379515e-19,
1.736924348751513e-19,
4.9992178223702e-20,
1.279115262402475e-20,
2.947536912240907e-21,
6.100447062889509e-22,
1.112964189432876e-22,
4.12714270748916e-23,
1.11679247064949e-23,
-2.405638858592079e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=11
0.01737610780487567,
-1.30834444801601e-9,
-1.506287102425954e-9,
-1.156117908884869e-9,
-6.65514773357627e-10,
-3.06480702120112e-10,
-1.176161800496911e-10,
-3.8688662391919e-11,
-1.113544049890455e-11,
-2.84889581886961e-12,
-6.55971852939544e-13,
-1.373067207143421e-13,
-2.633774702067888e-14,
-4.66459605171869e-15,
-7.84205546203897e-16,
-1.199934904976611e-16,
-0.03177105046672707,
2.17070958206612e-9,
2.49912160007441e-9,
1.91814646472619e-9,
1.104173577011062e-9,
5.08490459407636e-10,
1.951402224594005e-10,
6.41894332976407e-11,
1.847512692021065e-11,
4.72668870821066e-12,
1.088344652067732e-12,
2.278109821512816e-13,
4.36983152173109e-14,
7.73938716920011e-15,
1.301179488971851e-15,
1.991096311308221e-16,
0.02925870065226162,
-1.829345760506843e-9,
-2.106112014756906e-9,
-1.616500519007272e-9,
-9.30532279829418e-10,
-4.28525748920412e-10,
-1.644526783183581e-10,
-5.40950815057628e-11,
-1.556975699093634e-11,
-3.983379980323999e-12,
-9.17195352573501e-13,
-1.919868044065769e-13,
-3.682680528531867e-14,
-6.52245689357743e-15,
-1.096614404599113e-15,
-1.678152198459046e-16,
-0.01807535178731853,
1.041568795038551e-9,
1.199150325588997e-9,
9.20381788510793e-10,
5.29814231995871e-10,
2.439883650478119e-10,
9.36339144187145e-11,
3.079995467000807e-11,
8.86490876242547e-12,
2.268007302354731e-12,
5.22221935791506e-13,
1.093114737900158e-13,
2.096817376155514e-14,
3.713745942543407e-15,
6.244030266814538e-16,
9.55566730964792e-17,
0.00841982315171599,
-4.49884123454006e-10,
-5.17948212307234e-10,
-3.97539904576544e-10,
-2.288423189181555e-10,
-1.053857404210183e-10,
-4.044324023958507e-11,
-1.330340765309492e-11,
-3.829016245936042e-12,
-9.7961995014741e-13,
-2.255634613466337e-13,
-4.72150359508786e-14,
-9.05684710380676e-15,
-1.6041033723688e-15,
-2.697079137019766e-16,
-4.127674709779191e-17,
-0.003152312527635119,
1.56999456935036e-10,
1.807522962164395e-10,
1.387325014357498e-10,
7.98608326606637e-11,
3.677725895676022e-11,
1.41137842665057e-11,
4.642591596428641e-12,
1.336241300556381e-12,
3.418656792580956e-13,
7.87167279020997e-14,
1.647704806033759e-14,
3.160659478685156e-15,
5.598042899032215e-16,
9.41249735369919e-17,
1.440555976785281e-17,
0.000987521871620986,
-4.60541904542652e-11,
-5.30218439189642e-11,
-4.06957656278367e-11,
-2.34263617806259e-11,
-1.078823456283831e-11,
-4.140135158438075e-12,
-1.361857192292403e-12,
-3.919729210291309e-13,
-1.002828922906452e-13,
-2.309078662235346e-14,
-4.833389534206636e-15,
-9.27153140310352e-16,
-1.642149745257344e-16,
-2.761135573198059e-17,
-4.225953272298319e-18,
-0.0002661244857176951,
1.166818861315383e-11,
1.343349803892501e-11,
1.031058994426481e-11,
5.93525171761054e-12,
2.733283542544791e-12,
1.048935645638478e-12,
3.450372085254342e-13,
9.9309433375982e-14,
2.540747116568149e-14,
5.85023917652793e-15,
1.224580382462303e-15,
2.349027912260248e-16,
4.160560892412616e-17,
6.995719623908987e-18,
1.070729075218587e-18,
0.00006295452670755043,
-2.604266305880853e-12,
-2.998272273179639e-12,
-2.301258838850046e-12,
-1.324710873113522e-12,
-6.10051716433785e-13,
-2.341158557903939e-13,
-7.70101463400493e-14,
-2.216524764790102e-14,
-5.670791230624717e-15,
-1.305738191764589e-15,
-2.733193115894139e-16,
-5.24290825906354e-17,
-9.28620119778406e-18,
-1.561433504984829e-18,
-2.389902401428441e-19,
-0.00001327601204933319,
5.19807576954061e-13,
5.98450567509476e-13,
4.59327752286113e-13,
2.644102708936791e-13,
1.217653947231519e-13,
4.67291703275709e-14,
1.537110965501623e-14,
4.424150776399657e-15,
1.131881884969911e-15,
2.606236331238818e-16,
5.455423614024103e-17,
1.046481098160972e-17,
1.853528392209665e-18,
3.116649195544665e-19,
4.77031814852247e-20,
2.526263750671556e-6,
-9.38869986618944e-14,
-1.080913981045581e-13,
-8.29632083551111e-14,
-4.77574552241334e-14,
-2.19931149253648e-14,
-8.44016518100529e-15,
-2.776311060621301e-15,
-7.99084809867766e-16,
-2.044391993139166e-16,
-4.707356272630538e-17,
-9.8535371255916e-18,
-1.890148554250734e-18,
-3.347860032583915e-19,
-5.629341807850078e-20,
-8.61476913939187e-21,
-4.380442872700891e-7,
1.549213421946621e-14,
1.783597808161729e-14,
1.368961820121186e-14,
7.8803766842528e-15,
3.629046640789916e-15,
1.392697398441169e-15,
4.581144232714582e-16,
1.318556561225096e-16,
3.373417956835633e-17,
7.76753656595681e-18,
1.625919864389931e-18,
3.118882096113548e-19,
5.523892508012972e-20,
9.29243777831215e-21,
1.42559253883778e-21,
6.976583371844488e-8,
-2.353541032772743e-15,
-2.709614165822924e-15,
-2.079705601125645e-15,
-1.197174631908271e-15,
-5.51319156989222e-16,
-2.115764416183226e-16,
-6.95960403783664e-17,
-2.003131097995003e-17,
-5.124846087495957e-18,
-1.180033052000476e-18,
-2.470090579072903e-19,
-4.738173471491218e-20,
-8.38765642245651e-21,
-1.411721108482896e-21,
-2.214172007279994e-22,
-1.027834990966261e-8,
3.31434429857061e-16,
3.81577977585206e-16,
2.928719038669848e-16,
1.685906002762931e-16,
7.76388224394896e-17,
2.97949852068011e-17,
9.80077484327876e-18,
2.820884971893096e-18,
7.21701216234222e-19,
1.661738758656284e-19,
3.478000234546933e-20,
6.68067784173185e-21,
1.193025943590851e-21,
1.897184855066229e-22,
1.91056897301903e-23,
1.430601514544923e-9,
-4.41270126130275e-17,
-5.08030993015374e-17,
-3.899281753156021e-17,
-2.244606758788084e-17,
-1.03367938167724e-17,
-3.966889448653639e-18,
-1.304870300930744e-18,
-3.755712307255589e-19,
-9.60872068080171e-20,
-2.212451455099116e-20,
-4.629137650653678e-21,
-8.88912084356438e-22,
-1.632327176858276e-22,
-2.586550471388209e-23,
2.582516932567604e-24,
-1.829643834218873e-10,
5.41553780761971e-18,
6.23486814638987e-18,
4.785437894184664e-18,
2.754719192502439e-18,
1.268594792067529e-18,
4.868410864187049e-19,
1.601418383963651e-19,
4.609187312940743e-20,
1.179122308832261e-20,
2.718321223448515e-21,
5.73756305508987e-22,
1.004318572361482e-22,
6.1177579980698e-24,
1.281198497546469e-23,
1.383716615053453e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=12
0.01588552523336354,
-1.085354791033059e-9,
-1.249560800037204e-9,
-9.59073232363095e-10,
-5.52086788505531e-10,
-2.54245229703818e-10,
-9.75701112297002e-11,
-3.20947166488204e-11,
-9.23756346010533e-12,
-2.363344354105331e-12,
-5.44172326033866e-13,
-1.139054910756408e-13,
-2.184915760865547e-14,
-3.86969358460006e-15,
-6.50589744485926e-16,
-9.95548155654109e-17,
-0.02925870065226162,
1.82934576050684e-9,
2.106112014756906e-9,
1.616500519007272e-9,
9.30532279829418e-10,
4.28525748920412e-10,
1.644526783183581e-10,
5.40950815057628e-11,
1.556975699093634e-11,
3.983379980324e-12,
9.17195352573501e-13,
1.919868044065769e-13,
3.682680528531866e-14,
6.52245689357742e-15,
1.096614404599112e-15,
1.678152198459089e-16,
0.0271130276809778,
-1.562353192557826e-9,
-1.798725488383495e-9,
-1.380572682766189e-9,
-7.94721347993807e-10,
-3.659825475717179e-10,
-1.404508716280718e-10,
-4.61999320050121e-11,
-1.329736314363821e-11,
-3.402010953532096e-12,
-7.8333290368726e-13,
-1.639672106850237e-13,
-3.145226064233281e-14,
-5.57061891381517e-15,
-9.36604540022066e-16,
-1.433350096446406e-16,
-0.01683964630343286,
8.99768246908036e-10,
1.035896424614497e-9,
7.95079809153109e-10,
4.57684637836324e-10,
2.107714808420424e-10,
8.08864804791724e-11,
2.660681530619058e-11,
7.6580324918723e-12,
1.959239900294875e-12,
4.5112692269328e-13,
9.44300719017594e-14,
1.811369420761402e-14,
3.208206744738795e-15,
5.39415827403951e-16,
8.25534941943298e-17,
0.0078807813190875,
-3.92498642337582e-10,
-4.51880740541089e-10,
-3.468312535893672e-10,
-1.996520816516552e-10,
-9.19431473918986e-11,
-3.528446066626352e-11,
-1.160647899107136e-11,
-3.340603251390882e-12,
-8.54664198145221e-13,
-1.967918197552481e-13,
-4.119262015084525e-14,
-7.9016486967047e-15,
-1.399510724751886e-15,
-2.353124338512048e-16,
-3.601389942669066e-17,
-0.002962565614820673,
1.381625713615927e-10,
1.590655317555076e-10,
1.220872968824471e-10,
7.02790853412658e-11,
3.236470368823316e-11,
1.242040547520609e-11,
4.08557157684164e-12,
1.175918763077154e-12,
3.008486768693131e-13,
6.92723598664583e-14,
1.450016860251218e-14,
2.781459420903514e-15,
4.926449235191444e-16,
8.28340671995416e-17,
1.267785987840715e-17,
0.000931435700019922,
-4.08386601462571e-11,
-4.70172431364894e-11,
-3.608706480512012e-11,
-2.077338101174817e-11,
-9.56649239895801e-12,
-3.671274759754334e-12,
-1.207630229845486e-12,
-3.475830168178124e-13,
-8.89261490803768e-14,
-2.047583711788084e-14,
-4.28603133856331e-15,
-8.22159769509205e-16,
-1.456196314388632e-16,
-2.448501844987059e-17,
-3.747551545021863e-18,
-0.0002518181077163732,
1.041706524873203e-11,
1.199308912174105e-11,
9.20503537767577e-12,
5.29884350527694e-12,
2.440206871640282e-12,
9.36463425427756e-13,
3.080405861056304e-13,
8.86609908061634e-14,
2.268316497744913e-14,
5.222952779669378e-15,
1.093277248668146e-15,
2.097163309503321e-16,
3.714480584877303e-17,
6.245733942445886e-18,
9.55959859681853e-19,
0.00005974205412156155,
-2.339134093543255e-12,
-2.693027550626564e-12,
-2.066974882857455e-12,
-1.189846217622704e-12,
-5.47944275609988e-13,
-2.10281266226866e-13,
-6.91699933662794e-14,
-1.990867847022308e-14,
-5.093468476129579e-15,
-1.172806348632758e-15,
-2.454940635455448e-16,
-4.709164669086075e-17,
-8.34087471628026e-18,
-1.402495073715483e-18,
-2.146674706407518e-19,
-0.0000126313092992313,
4.69434724374528e-13,
5.40456680900002e-13,
4.148158041312954e-13,
2.387871393216481e-13,
1.099655116285585e-13,
4.220080172856459e-14,
1.388154735053433e-14,
3.995421760346637e-15,
1.022195410469477e-15,
2.353676790370967e-16,
4.92676602067453e-17,
9.45073671024728e-18,
1.673921025441646e-18,
2.814676205434302e-19,
4.308291025971809e-20,
2.409244222833884e-6,
-8.52067558083683e-14,
-9.80978997131448e-14,
-7.52929156600508e-14,
-4.33420807166426e-14,
-1.995976064747711e-14,
-7.65983727363331e-15,
-2.519629848269165e-15,
-7.25206259553632e-16,
-1.855380278381486e-16,
-4.27214538886933e-17,
-8.94255207479047e-18,
-1.715402492268878e-18,
-3.038365937551164e-19,
-5.108967046528354e-20,
-7.817806781995468e-21,
-4.186486408185673e-7,
1.412277199778818e-14,
1.625944163838581e-14,
1.2479581880357e-14,
7.18382392004625e-15,
3.308272362297786e-15,
1.269595814762058e-15,
4.176213612271942e-16,
1.202008523737876e-16,
3.075240093544634e-17,
7.08096249310392e-18,
1.482203365205574e-18,
2.843230693991774e-19,
5.036297185625886e-20,
8.46942937824274e-21,
1.293173936787293e-21,
6.68072483425903e-8,
-2.154268320141821e-15,
-2.480192987584596e-15,
-1.90361835561953e-15,
-1.095810683882763e-15,
-5.046393509970417e-16,
-1.936624172070591e-16,
-6.3703396831782e-17,
-1.833527683348671e-17,
-4.690930331161904e-18,
-1.08012124551096e-18,
-2.260964110020853e-19,
-4.337017237176427e-20,
-7.67488320008792e-21,
-1.291948664465745e-21,
-2.050683317881571e-22,
-9.86015254175967e-9,
3.04506791858176e-16,
3.505763900204952e-16,
2.690773081565769e-16,
1.548933323294216e-16,
7.1330999646408e-17,
2.737427050476919e-17,
9.00450444291419e-18,
2.591700039801482e-18,
6.6306482875307e-19,
1.526750883503512e-19,
3.196166856052021e-20,
6.1334373509494e-21,
1.077331888922276e-21,
1.780268100067948e-22,
3.670088807164387e-23,
1.374726631123391e-9,
-4.06848124880812e-17,
-4.68401201199547e-17,
-3.59511188569889e-17,
-2.069512537442736e-17,
-9.53045539953954e-18,
-3.657445853179093e-18,
-1.203081812014127e-18,
-3.462742286092342e-19,
-8.8592070219072e-20,
-2.039870269179982e-20,
-4.266655895846567e-21,
-8.19359656984183e-22,
-1.538054330644521e-22,
-2.425113389342064e-23,
5.419619223104171e-24,
-1.760854408082199e-10,
5.00884249264412e-18,
5.76664288027465e-18,
4.426061750315066e-18,
2.547845690670796e-18,
1.173326061439599e-18,
4.502803273502754e-19,
1.481153684686968e-19,
4.263090599810564e-20,
1.090739772718826e-20,
2.5122895613098e-21,
5.222193251077172e-22,
9.69031623647156e-23,
2.727079193903002e-23,
8.719145235069943e-24,
-9.30944446602362e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=13
0.01462935032613081,
-9.14672880253421e-10,
-1.053056007378453e-9,
-8.08250259503636e-10,
-4.65266139914709e-10,
-2.14262874460206e-10,
-8.2226339159179e-11,
-2.70475407528814e-11,
-7.78487849546817e-12,
-1.991689990161999e-12,
-4.5859767628675e-13,
-9.59934022032885e-14,
-1.841340264265933e-14,
-3.26122844678871e-15,
-5.48307202299556e-16,
-8.39076099229546e-17,
-0.0271130276809778,
1.562353192557826e-9,
1.798725488383495e-9,
1.380572682766189e-9,
7.94721347993807e-10,
3.65982547571718e-10,
1.404508716280718e-10,
4.61999320050121e-11,
1.329736314363821e-11,
3.402010953532096e-12,
7.8333290368726e-13,
1.639672106850237e-13,
3.145226064233281e-14,
5.57061891381514e-15,
9.36604540022068e-16,
1.4333500964467e-16,
0.02525946945514929,
-1.349652370362054e-9,
-1.553844636921746e-9,
-1.192619713729664e-9,
-6.86526956754486e-10,
-3.161572212630636e-10,
-1.213297207187586e-10,
-3.991022295928587e-11,
-1.148704873780845e-11,
-2.938859850442312e-12,
-6.7669038403992e-13,
-1.416451078526392e-13,
-2.717054131142096e-14,
-4.8123101171082e-15,
-8.09123741105983e-16,
-1.238302412914611e-16,
-0.01576156263817584,
7.84997284675187e-10,
9.03761481082205e-10,
6.93662507178755e-10,
3.99304163303322e-10,
1.838862947838027e-10,
7.05689213325291e-11,
2.321295798214341e-11,
6.68120650278196e-12,
1.709328396290492e-12,
3.935836395105077e-13,
8.2385240301692e-14,
1.580329739341023e-14,
2.799021449506306e-15,
4.706248677020605e-16,
7.2027798850818e-17,
0.00740641403705139,
-3.45406428403974e-10,
-3.9766382938876e-10,
-3.05218242206111e-10,
-1.756977133531607e-10,
-8.09117592205811e-11,
-3.105101368801453e-11,
-1.021392894210387e-11,
-2.939796907692822e-12,
-7.52121692173266e-13,
-1.731808996661409e-13,
-3.625042150627845e-14,
-6.95364855226014e-15,
-1.231612308800039e-15,
-2.070851679982798e-16,
-3.169464969491638e-17,
-0.002794307100019011,
1.225159804376556e-10,
1.410517294081834e-10,
1.082611944143744e-10,
6.23201430346769e-11,
2.869947719661264e-11,
1.101382427916269e-11,
3.622890689503463e-12,
1.042749050443939e-12,
2.667784472386945e-13,
6.14275113530881e-14,
1.28580940156059e-14,
2.466479308492329e-15,
4.368588942246539e-16,
7.34550553615752e-17,
1.124265472700304e-17,
0.000881363377015016,
-3.64597283707655e-11,
-4.19758119263279e-11,
-3.221762382204497e-11,
-1.854595226857279e-11,
-8.54072405078865e-12,
-3.277621989015437e-12,
-1.078142051375723e-12,
-3.103134678232999e-13,
-7.93910774215052e-14,
-1.82803347289531e-14,
-3.82647037040858e-15,
-7.34007158338346e-16,
-1.300068203576446e-16,
-2.186006875884557e-17,
-3.345859606753852e-18,
-0.0002389682173403034,
9.35653639755674e-12,
1.077211022942776e-11,
8.26789955209283e-12,
4.7593848823854e-12,
2.191777107917608e-12,
8.41125067009591e-13,
2.766799741565827e-13,
7.96347140799278e-14,
2.037387395554176e-14,
4.691225406184272e-15,
9.81976256068749e-16,
1.883665874164848e-16,
3.336350045888988e-17,
5.609980130083652e-18,
8.58668301306029e-19,
0.00005684089174961592,
-2.11245625712751e-12,
-2.432055061105155e-12,
-1.866671116330571e-12,
-1.074542125646308e-12,
-4.94844801729331e-13,
-1.899036075485911e-13,
-6.24669630017535e-14,
-1.797939789980941e-14,
-4.599879341685355e-15,
-1.059154554433202e-15,
-2.217044699042474e-16,
-4.252831460448988e-17,
-7.53264651304034e-18,
-1.266605288347943e-18,
-1.938712796347374e-19,
-0.0000120462120026501,
4.26033529575408e-13,
4.90489211356885e-13,
3.764643578593347e-13,
2.167102766872315e-13,
9.97987447996347e-14,
3.829916394186915e-14,
1.259814186451035e-14,
3.626029174432518e-15,
9.27689595080991e-16,
2.136071448576943e-16,
4.471273899502612e-17,
8.57700616161944e-18,
1.519169305683848e-18,
2.554494620495467e-19,
3.91024139989529e-20,
2.302568144866618e-6,
-7.76752623592888e-14,
-8.94269478594543e-14,
-6.86377148085925e-14,
-3.95110398879129e-14,
-1.819550182766352e-14,
-6.98277845295589e-15,
-2.296917970951946e-15,
-6.61104827399082e-16,
-1.691382397988284e-16,
-3.894530085558465e-17,
-8.15212569854034e-18,
-1.563782823992212e-18,
-2.769821430212285e-19,
-4.657305297529676e-20,
-7.126601275362403e-21,
-4.008951847819533e-7,
1.292702526850725e-14,
1.488278740467479e-14,
1.142296080513522e-14,
6.57558404756744e-15,
3.028167652520701e-15,
1.162101738845312e-15,
3.822622335857366e-16,
1.10023707542655e-16,
2.814866761329538e-17,
6.48143536042606e-18,
1.356707286444631e-18,
2.602541794839928e-19,
4.610669330864199e-20,
7.747820684358142e-21,
1.175641702099375e-21,
6.408903631360503e-8,
-1.979242549247029e-15,
-2.278687130936138e-15,
-1.748956908613805e-15,
-1.006780413899127e-15,
-4.636394108692213e-16,
-1.779281197569761e-16,
-5.85277528157561e-17,
-1.684561076508785e-17,
-4.309812326283652e-18,
-9.9236742958548e-19,
-2.077269341859625e-19,
-3.984327899674806e-20,
-7.05162712067248e-21,
-1.190945243202861e-21,
-1.887579563975735e-22,
-9.47461115072486e-9,
2.80728625101711e-16,
3.232007650110507e-16,
2.480657412309232e-16,
1.427981041595441e-16,
6.57609430873545e-17,
2.523668375767988e-17,
8.30136620649882e-18,
2.389320761897178e-18,
6.112863730496478e-19,
1.407557377432362e-19,
2.947388206958956e-20,
5.645186556196158e-21,
9.72486706770959e-22,
1.766292459651058e-22,
5.54658361788254e-23,
1.323047342009973e-9,
-3.76298268263857e-17,
-4.33229380389499e-17,
-3.32515820637296e-17,
-1.914114732973e-17,
-8.81482229128863e-18,
-3.382811658337506e-18,
-1.112743586997694e-18,
-3.202730578250314e-19,
-8.193961789646e-20,
-1.886574982298652e-20,
-3.946984299627537e-21,
-7.615999089997592e-22,
-1.41053282288044e-22,
-1.798049261277547e-23,
4.463706654122876e-24,
-1.697044609804907e-10,
4.64625520241293e-18,
5.34919885162775e-18,
4.10566164215045e-18,
2.36340859140574e-18,
1.088389675723513e-18,
4.176847810475802e-19,
1.373931918519242e-19,
3.954523601031069e-20,
1.011960593745626e-20,
2.327636153553864e-21,
4.755848445844427e-22,
9.99235980311319e-23,
4.78091157037571e-23,
-5.330435439753685e-24,
-3.176920358139717e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=14
0.0135565138404889,
-7.81176596278913e-10,
-8.99362744191747e-10,
-6.90286341383094e-10,
-3.97360673996903e-10,
-1.829912737858589e-10,
-7.02254358140359e-11,
-2.3099966002506e-11,
-6.6486815718191e-12,
-1.701005476766048e-12,
-3.9166645184363e-13,
-8.19836053425119e-14,
-1.57261303211664e-14,
-2.78530945690757e-15,
-4.68302270011034e-16,
-7.1667504822334e-17,
-0.02525946945514928,
1.349652370362054e-9,
1.553844636921746e-9,
1.192619713729664e-9,
6.86526956754486e-10,
3.16157221263064e-10,
1.213297207187586e-10,
3.99102229592859e-11,
1.148704873780844e-11,
2.938859850442312e-12,
6.7669038403992e-13,
1.416451078526392e-13,
2.717054131142094e-14,
4.8123101171082e-15,
8.09123741106003e-16,
1.238302412914577e-16,
0.02364234395726377,
-1.17749592701278e-9,
-1.355642221623308e-9,
-1.040493760768132e-9,
-5.98956244954983e-10,
-2.758294421757041e-10,
-1.058533819987937e-10,
-3.481943697321512e-11,
-1.002180975417294e-11,
-2.563992594435739e-12,
-5.90375459265762e-13,
-1.235778604525381e-13,
-2.370494609011521e-14,
-4.198532174259151e-15,
-7.05937301553249e-16,
-1.080416982765656e-16,
-0.01481282807410361,
6.9081285680797e-10,
7.95327658777545e-10,
6.10436484412241e-10,
3.513954267063323e-10,
1.618235184411673e-10,
6.2102027376031e-11,
2.042785788420839e-11,
5.87959381538583e-12,
1.50424338434658e-12,
3.46361799332292e-13,
7.25008430125588e-14,
1.39072971045227e-14,
2.463224617601431e-15,
4.141703359943066e-16,
6.33892993881995e-17,
0.00698576775004725,
-3.06289951094132e-10,
-3.5262932352045e-10,
-2.706529860359296e-10,
-1.558003575866887e-10,
-7.17486929915299e-11,
-2.753456069790609e-11,
-9.05722672375845e-12,
-2.606872626109788e-12,
-6.66946118096722e-13,
-1.535687783827137e-13,
-3.214523503900607e-14,
-6.16619827123966e-15,
-1.092147235583876e-15,
-1.836376383929629e-16,
-2.810663679319078e-17,
-0.002644090131005719,
1.093791851112588e-10,
1.259274357777888e-10,
9.66528714652178e-11,
5.56378568051904e-11,
2.562217215212282e-11,
9.83286596695301e-12,
3.23442615409648e-12,
9.30940403461063e-13,
2.381732322622522e-13,
5.48410041863609e-14,
1.14794111111394e-14,
2.202021474930298e-15,
3.900204609990978e-16,
6.558020634867604e-17,
1.003757890393408e-17,
0.000836388760698511,
-3.27478773916383e-11,
-3.77023858032156e-11,
-2.893764843249256e-11,
-1.665784708844541e-11,
-7.67121987775607e-12,
-2.943937734550624e-12,
-9.68379909553653e-13,
-2.787214992813508e-13,
-7.13085588447671e-14,
-1.641928892181032e-14,
-3.436916896495095e-15,
-6.59283055739095e-16,
-1.167722509624482e-16,
-1.963493072942469e-17,
-3.005339748615291e-18,
-0.0002273635678226506,
8.4498250502599e-12,
9.72822026946108e-12,
7.46668448454155e-12,
4.298168513648725e-12,
1.97937921201225e-12,
7.5961443214961e-13,
2.498678526501699e-13,
7.19175917844051e-14,
1.839951741416531e-14,
4.236618228335758e-15,
8.86817881505391e-16,
1.701132597357269e-16,
3.013058732090097e-17,
5.066420163374294e-18,
7.754837219005e-19,
0.00005420795391827619,
-1.917150880704178e-12,
-2.20720144835997e-12,
-1.694089608259364e-12,
-9.75196243879286e-13,
-4.490943510396337e-13,
-1.723462375239824e-13,
-5.66916383197082e-14,
-1.631713126477012e-14,
-4.174603173267907e-15,
-9.61232149861021e-16,
-2.012073219998658e-16,
-3.859653024495644e-17,
-6.83627056884163e-18,
-1.149519393109824e-18,
-1.759516117387402e-19,
-0.00001151283193148276,
3.88376079760378e-13,
4.47134472155884e-13,
3.431883690043803e-13,
1.975550814098789e-13,
9.09774547836483e-14,
3.491387140544208e-14,
1.148458299330692e-14,
3.305522161762363e-15,
8.45690693264735e-16,
1.947263899514985e-16,
4.076060703543991e-17,
7.81890357407789e-18,
1.384901173963366e-18,
2.32871830428487e-19,
3.564319677101009e-20,
2.204924115699483e-6,
-7.10986542428246e-14,
-8.1855348301383e-14,
-6.282629791807e-14,
-3.616572002698565e-14,
-1.665492566492645e-14,
-6.39156093607915e-15,
-2.102442736563671e-15,
-6.05130520702852e-16,
-1.548177009466323e-16,
-3.56479067919839e-17,
-7.461913738293e-18,
-1.431383290532742e-18,
-2.535282741280205e-19,
-4.263177676200711e-20,
-6.527622183493601e-21,
-3.845841046385198e-7,
1.187677175283246e-14,
1.367363841311594e-14,
1.049490473872296e-14,
6.04135212518425e-15,
2.78214484659857e-15,
1.067687064133639e-15,
3.512054454704882e-16,
1.010848702084819e-16,
2.586174198497839e-17,
5.954858360259995e-18,
1.246490752398768e-18,
2.39104516093331e-19,
4.234198076712186e-20,
7.125484266442777e-21,
1.100076805832994e-21,
6.158308334957182e-8,
-1.824687949261186e-15,
-2.100749579398545e-15,
-1.612384802169739e-15,
-9.28163202967557e-16,
-4.274348594137371e-16,
-1.640341189627159e-16,
-5.395745615901289e-17,
-1.553017746803654e-17,
-3.973270631994134e-18,
-9.14874874658475e-19,
-1.91502396654552e-19,
-3.673592528749365e-20,
-6.51198397904311e-21,
-1.093730705103513e-21,
-1.61693528445795e-22,
-9.11804885320263e-9,
2.596277491188658e-16,
2.989074847421239e-16,
2.294199610577516e-16,
1.320647320163805e-16,
6.08180441539207e-17,
2.333977733557194e-17,
7.67739685552562e-18,
2.209729344897689e-18,
5.65343105892195e-19,
1.301709355529896e-19,
2.7239253935395e-20,
5.236145968390718e-21,
9.4988486441103e-22,
1.454033986166996e-22,
-1.4579406462049e-24,
1.275108662911398e-9,
-3.49061340376826e-17,
-4.018717095300066e-17,
-3.084479206646357e-17,
-1.775568784929928e-17,
-8.17679481654721e-18,
-3.13795974487341e-18,
-1.032201975162941e-18,
-2.970910596120996e-19,
-7.60080201547225e-20,
-1.750181836881896e-20,
-3.665554944373315e-21,
-7.020337674920067e-22,
-1.185919665815921e-22,
-2.157691982128523e-23,
-9.7074063780368e-24,
-1.637693137419017e-10,
4.32162606353e-18,
4.97545575751689e-18,
3.818803238060427e-18,
2.198279641842923e-18,
1.012344986299919e-18,
3.885016446570075e-19,
1.277940852483665e-19,
3.678144070753486e-20,
9.40855409974948e-21,
2.170124013256007e-21,
4.63064188702474e-22,
7.73781388436392e-23,
-9.6339172326434e-24,
1.332123297681513e-23,
2.678372388467863e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=15
0.01262973472757464,
-6.74826185181027e-10,
-7.76922318460873e-10,
-5.96309856864832e-10,
-3.43263478377243e-10,
-1.580786106315318e-10,
-6.06648603593793e-11,
-1.995511147964293e-11,
-5.74352436890422e-12,
-1.469429925221156e-12,
-3.3834519201996e-13,
-7.08225539263196e-14,
-1.358527065571047e-14,
-2.406155058554099e-15,
-4.04561870553002e-16,
-6.19151206457312e-17,
-0.02364234395726377,
1.17749592701278e-9,
1.355642221623308e-9,
1.040493760768132e-9,
5.98956244954983e-10,
2.758294421757041e-10,
1.058533819987937e-10,
3.48194369732151e-11,
1.002180975417294e-11,
2.563992594435738e-12,
5.90375459265762e-13,
1.235778604525381e-13,
2.370494609011521e-14,
4.19853217425917e-15,
7.05937301553252e-16,
1.080416982765487e-16,
0.02221924211115541,
-1.036219285211955e-9,
-1.192991488166318e-9,
-9.15654726618362e-10,
-5.27093140059499e-10,
-2.42735277661751e-10,
-9.31530410640465e-11,
-3.064178682631258e-11,
-8.81939072307874e-12,
-2.25636507651987e-12,
-5.19542698998438e-13,
-1.087512645188379e-13,
-2.08609456567842e-14,
-3.694836926402832e-15,
-6.21255503991295e-16,
-9.50839490816057e-17,
-0.01397153550009529,
6.12579902188284e-10,
7.05258647040924e-10,
5.41305972071877e-10,
3.116007151733876e-10,
1.434973859830646e-10,
5.5069121395814e-11,
1.811445344751749e-11,
5.21374525221975e-12,
1.333892236193488e-12,
3.071375567654375e-13,
6.42904700780151e-14,
1.233239654247985e-14,
2.184294471165678e-15,
3.672752767857559e-16,
5.621327358857008e-17,
0.00661022532751403,
-2.7344796277814e-10,
-3.14818589444464e-10,
-2.416321786630386e-10,
-1.390946420129727e-10,
-6.40554303803055e-11,
-2.458216491738193e-11,
-8.086065385241e-12,
-2.327351008652599e-12,
-5.95433080655613e-13,
-1.371025104659022e-13,
-2.86985277778625e-14,
-5.50505368731594e-15,
-9.75051152460557e-16,
-1.639505158826411e-16,
-2.509394729788883e-17,
-0.002509166282057533,
9.82436321739471e-11,
1.131071574085325e-10,
8.68129452966225e-11,
4.99735412648439e-11,
2.30136596330415e-11,
8.83181320356487e-12,
2.905139728632342e-12,
8.36164497835816e-13,
2.139256765321999e-13,
4.925786676494496e-14,
1.031075068935166e-14,
1.977849167198159e-15,
3.503167529686585e-16,
5.890479218891711e-17,
9.01601915665145e-18,
0.000795772487386482,
-2.9574387676087e-11,
-3.40487709433179e-11,
-2.61333956960521e-11,
-1.504358979786073e-11,
-6.92782724208441e-12,
-2.658650512539573e-12,
-8.74537484280831e-13,
-2.517115712469411e-13,
-6.43983109500285e-14,
-1.482816379917937e-14,
-3.103862584970554e-15,
-5.95396409326948e-16,
-1.054570564345937e-16,
-1.773247029137626e-17,
-2.714192188790867e-18,
-0.0002168318164694381,
7.66860354309803e-12,
8.82880581678961e-12,
6.77635845095903e-12,
3.900784985833632e-12,
1.796377408909452e-12,
6.89384951919162e-13,
2.267665538785768e-13,
6.52685252316897e-14,
1.669841273713757e-14,
3.844928609646513e-15,
8.04829290650265e-16,
1.543861213224096e-16,
2.734508093731222e-17,
4.598077631015652e-18,
7.03807958527198e-19,
0.00005180774360108487,
-1.747692356692348e-12,
-2.012105122134844e-12,
-1.544347658549745e-12,
-8.88997865210451e-13,
-4.093985460041859e-13,
-1.571124211240909e-13,
-5.168062340403011e-14,
-1.487484970878487e-14,
-3.805608114155977e-15,
-8.76268754708284e-16,
-1.834227348550256e-16,
-3.518506298190505e-17,
-6.23204641261318e-18,
-1.047926677533878e-18,
-1.604036122887779e-19,
-0.00001102461208279982,
3.55493054844938e-13,
4.0927649240269e-13,
3.141312983958006e-13,
1.808284900745089e-13,
8.32745776399482e-14,
3.195778522942556e-14,
1.051220728453882e-14,
3.025650762053085e-15,
7.74088034344775e-16,
1.782394250711636e-16,
3.730954183542925e-17,
7.15691300621556e-18,
1.267651941402615e-18,
2.131579492025154e-19,
3.262581672229541e-20,
2.115213155314373e-6,
-6.53222589094011e-14,
-7.52050276997264e-14,
-5.77219886716156e-14,
-3.322744394663226e-14,
-1.530179999879842e-14,
-5.87228013537416e-15,
-1.931630371621905e-15,
-5.559669086733322e-16,
-1.422396158810413e-16,
-3.275172154476075e-17,
-6.85568076402348e-18,
-1.315094367522558e-18,
-2.329327376326444e-19,
-3.91685806361905e-20,
-5.996185537302829e-21,
-3.695467009563326e-7,
1.094935526758724e-14,
1.260591077087601e-14,
9.67539355657306e-15,
5.5696036463304e-15,
2.564896716381343e-15,
9.84315068976067e-16,
3.237810375127558e-16,
9.3191512423346e-17,
2.38422938413493e-17,
5.489866795379845e-18,
1.149159728433896e-18,
2.204353197187039e-19,
3.903086880391853e-20,
6.567867486629101e-21,
1.019697261479747e-21,
5.926549017704e-8,
-1.687535398271254e-15,
-1.942846876046367e-15,
-1.491190008267806e-15,
-8.5839788271727e-16,
-3.953067524427308e-16,
-1.517045101876282e-16,
-4.990175090052478e-17,
-1.436285461764458e-17,
-3.674620834932786e-18,
-8.46109020070706e-19,
-1.771094539565827e-19,
-3.397439707793584e-20,
-6.019172946123585e-21,
-1.011785235776477e-21,
-1.534498015458214e-22,
-8.78732022287266e-9,
2.408171880718393e-16,
2.772510268470852e-16,
2.127980166321143e-16,
1.224963731275836e-16,
5.64116534105584e-17,
2.16487634388973e-17,
7.12115406670197e-18,
2.049630102790045e-18,
5.243843424973517e-19,
1.207406552806036e-19,
2.525854599168192e-20,
4.85415519888492e-21,
9.00643494125256e-22,
1.378411470418175e-22,
-2.27418317754134e-23,
1.230519040883241e-9,
-3.24675471346196e-17,
-3.737964413130625e-17,
-2.868993575654614e-17,
-1.651525302909046e-17,
-7.60555364054304e-18,
-2.918737962469904e-18,
-9.60091074131979e-19,
-2.763360011579292e-19,
-7.06982163874604e-20,
-1.627884977008042e-20,
-3.40821209438993e-21,
-6.5355352963201e-22,
-1.142152584955927e-22,
-1.960721900514416e-23,
-4.38780613153767e-24,
-1.582348936886973e-10,
4.0298400337777e-18,
4.63952468825978e-18,
3.560966632619424e-18,
2.049856981434628e-18,
9.43993834097949e-19,
3.622709369565682e-19,
1.191659280014345e-19,
3.429812908389771e-20,
8.77150512763049e-21,
2.022862387685088e-21,
4.41239336679754e-22,
7.459200696386e-23,
-3.44987938966711e-23,
9.69278044197196e-24,
5.271404047297608e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=16
0.01182117197863188,
-5.8874796350639e-10,
-6.77821110811654e-10,
-5.20246880384066e-10,
-2.99478122477492e-10,
-1.37914721087852e-10,
-5.29266909993968e-11,
-1.740971848660756e-11,
-5.01090487708647e-12,
-1.281996297217869e-12,
-2.95187729632881e-13,
-6.17889302262691e-14,
-1.18524730450576e-14,
-2.099266087129586e-15,
-3.52968650776626e-16,
-5.4020849138272e-17,
-0.02221924211115541,
1.036219285211955e-9,
1.192991488166318e-9,
9.15654726618362e-10,
5.27093140059498e-10,
2.427352776617509e-10,
9.31530410640465e-11,
3.064178682631258e-11,
8.81939072307874e-12,
2.25636507651987e-12,
5.19542698998438e-13,
1.087512645188379e-13,
2.08609456567842e-14,
3.694836926402857e-15,
6.21255503991294e-16,
9.50839490815786e-17,
0.02095730325014294,
-9.18869853282426e-10,
-1.057887970561386e-9,
-8.11958958107816e-10,
-4.67401072760081e-10,
-2.152460789745969e-10,
-8.2603682093721e-11,
-2.717168017127624e-11,
-7.82061787832962e-12,
-2.000838354290233e-12,
-4.60706335148156e-13,
-9.64357051170228e-14,
-1.849859481371986e-14,
-3.276441706748172e-15,
-5.509129151785434e-16,
-8.43199103832294e-17,
-0.01322045065502882,
5.46895925556299e-10,
6.29637178888951e-10,
4.83264357326094e-10,
2.78189284025955e-10,
1.281108607606154e-10,
4.91643298347655e-11,
1.617213077048257e-11,
4.65470201730536e-12,
1.190866161311267e-12,
2.742050209318138e-13,
5.73970555557278e-14,
1.101010737463217e-14,
1.950102304919121e-15,
3.279010317653849e-16,
5.018789459796777e-17,
0.006272915705143572,
-2.45609080434861e-10,
-2.82767893521324e-10,
-2.170323632415507e-10,
-1.249338531621067e-10,
-5.75341490826023e-11,
-2.207953300891162e-11,
-7.26284932158067e-12,
-2.090411244589486e-12,
-5.34814191330486e-13,
-1.23144666912361e-13,
-2.577687672337898e-14,
-4.9446229179903e-15,
-8.75791882420681e-16,
-1.472619804779697e-16,
-2.254004789252466e-17,
-0.00238731746212269,
8.87231630273564e-11,
1.021463128289123e-10,
7.8400187087357e-11,
4.51307693931221e-11,
2.078348172604134e-11,
7.9759515375374e-12,
2.623612452815744e-12,
7.55134713733124e-13,
1.931949328481196e-13,
4.448449139708362e-14,
9.31158775479668e-15,
1.786189227965961e-15,
3.163711693541364e-16,
5.319741086980436e-17,
8.14257650941813e-18,
0.00075891135765001,
-2.68401124010092e-11,
-3.090082035895486e-11,
-2.37172545785034e-11,
-1.36527474505022e-11,
-6.28732093122199e-12,
-2.412847331731998e-12,
-7.93682938579927e-13,
-2.284398383123362e-13,
-5.84444445803761e-14,
-1.34572501337984e-14,
-2.816902517124883e-15,
-5.403514247656308e-16,
-9.5707783726189e-17,
-1.609327155781209e-17,
-2.463327380235099e-18,
-0.0002072309751746387,
6.99076944572591e-12,
8.04842051036387e-12,
6.1773906509499e-12,
3.555991470484409e-12,
1.637594188457326e-12,
6.28449686200499e-13,
2.067224941766843e-13,
5.94993989964799e-14,
1.522243249785453e-14,
3.505075028353295e-15,
7.33690941662102e-16,
1.40740252253834e-16,
2.492818505060094e-17,
4.191706786483776e-18,
6.4161515087527e-19,
0.00004961075428487962,
-1.599718744713901e-12,
-1.841744213407841e-12,
-1.413590840935761e-12,
-8.13728204273026e-13,
-3.747355988905727e-13,
-1.43810033344692e-13,
-4.730493271873993e-14,
-1.361542841135032e-14,
-3.483396149348922e-15,
-8.02077412403985e-16,
-1.678929414361336e-16,
-3.220610672661802e-17,
-5.704424692116962e-18,
-9.5921273697716e-19,
-1.468258398411458e-19,
-0.00001057605755861685,
3.26611092311148e-13,
3.76024905666001e-13,
2.886097646524377e-13,
1.661371168619344e-13,
7.65089526200512e-14,
2.936138249645553e-14,
9.65814587780262e-15,
2.779832822120867e-15,
7.1119763936604e-16,
1.637585061827172e-16,
3.427838086299268e-17,
6.57546826921558e-18,
1.164667462104323e-18,
1.958421806765349e-19,
2.997628009043223e-20,
2.032507416705809e-6,
-6.02214673378815e-14,
-6.93325246281684e-14,
-5.32146763721461e-14,
-3.063282685377499e-14,
-1.410693507116044e-14,
-5.41373408087361e-15,
-1.780796101022291e-15,
-5.125534328618399e-16,
-1.311326504886435e-16,
-3.019426983450977e-17,
-6.32035253765461e-18,
-1.212406324870487e-18,
-2.147428583904447e-19,
-3.611014319329019e-20,
-5.530133022644244e-21,
-3.556395661458052e-7,
1.012635977679263e-14,
1.165840223454013e-14,
8.9481539378468e-15,
5.15097093723918e-15,
2.372109291186641e-15,
9.1033020789796e-16,
2.994444346780848e-16,
8.61868931989305e-17,
2.205022219325326e-17,
5.077230173020685e-18,
1.062783631511575e-18,
2.038668822934344e-19,
3.610252873003688e-20,
6.07451288255019e-21,
9.37675940411546e-22,
5.711581193413818e-8,
-1.56526959640091e-15,
-1.802083175081384e-15,
-1.383149883428571e-15,
-7.96204997070784e-16,
-3.666658789923406e-16,
-1.407131755822647e-16,
-4.628625769591904e-17,
-1.332223458979254e-17,
-3.408387520127931e-18,
-7.84807071411537e-19,
-1.642751674499649e-19,
-3.151243571917244e-20,
-5.589404145345746e-21,
-9.38982294167782e-22,
-1.357656296505999e-22,
-8.47971870740215e-9,
2.239773796672472e-16,
2.578634816639373e-16,
1.979175268909109e-16,
1.139304759313431e-16,
5.246691313040294e-17,
2.013491431989604e-17,
6.62318820159124e-18,
1.906304250737917e-18,
4.877139749382442e-19,
1.122974656159864e-19,
2.349962272815669e-20,
4.515506692463e-21,
8.18690849603694e-22,
1.270152235371482e-22,
-1.3466714558008e-24,
1.188939681731522e-9,
-3.027565028995391e-17,
-3.485612972116848e-17,
-2.675306700694174e-17,
-1.540030191024808e-17,
-7.09209981759942e-18,
-2.721692888692831e-18,
-8.95275065516727e-19,
-2.576804985934724e-19,
-6.592475575844827e-20,
-1.517973039213725e-20,
-3.181152612515697e-21,
-6.097857603826526e-22,
-9.8685601290015e-23,
-1.797064207606275e-23,
-1.228946718293829e-23,
-1.530619764256339e-10,
3.76661490774447e-18,
4.33647557300055e-18,
3.328367856547123e-18,
1.915962381833745e-18,
8.8233312121701e-19,
3.386077653513412e-19,
1.113819373664169e-19,
3.205780793315977e-20,
8.2003910160512e-21,
1.890997845688397e-21,
4.03183859020454e-22,
6.84884582583125e-23,
-8.2546393075585e-24,
1.07684173165896e-23,
2.414400606310702e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=17
0.0111096210555777,
-5.18109642605977e-10,
-5.96495744083159e-10,
-4.57827363309181e-10,
-2.63546570029749e-10,
-1.213676388308755e-10,
-4.65765205320233e-11,
-1.532089341315629e-11,
-4.40969536153937e-12,
-1.128182538259935e-12,
-2.59771349499219e-13,
-5.4375632259419e-14,
-1.04304728283921e-14,
-1.847418463201428e-15,
-3.10627751995647e-16,
-4.75419745407896e-17,
-0.02095730325014293,
9.18869853282426e-10,
1.057887970561386e-9,
8.11958958107816e-10,
4.67401072760081e-10,
2.152460789745969e-10,
8.2603682093721e-11,
2.717168017127624e-11,
7.82061787832962e-12,
2.000838354290232e-12,
4.60706335148156e-13,
9.64357051170228e-14,
1.849859481371985e-14,
3.276441706748208e-15,
5.50912915178551e-16,
8.43199103831912e-17,
0.01983067598254323,
-8.20343888334449e-10,
-9.44455768333426e-10,
-7.24896535989141e-10,
-4.17283926038933e-10,
-1.921662911409231e-10,
-7.37464947521483e-11,
-2.425819615572385e-11,
-6.98205302595804e-12,
-1.786299241966901e-12,
-4.113075313977207e-13,
-8.60955833335915e-14,
-1.651516106194827e-14,
-2.925153457378963e-15,
-4.918515476480592e-16,
-7.52818418966481e-17,
-0.01254583141028788,
4.91218160869741e-10,
5.65535787042668e-10,
4.34064726483117e-10,
2.498677063242224e-10,
1.150682981652087e-10,
4.41590660178248e-11,
1.452569864316186e-11,
4.180822489179123e-12,
1.06962838266101e-12,
2.462893338247306e-13,
5.15537534467612e-14,
9.88924583598172e-15,
1.751583764837803e-15,
2.945239609551046e-16,
4.508009578875894e-17,
0.005968293655306471,
-2.218079075683851e-10,
-2.553657820722741e-10,
-1.960004677183873e-10,
-1.128269234828022e-10,
-5.1958704315102e-11,
-1.993987884384298e-11,
-6.55903113203919e-12,
-1.887836784332761e-12,
-4.829873321202847e-13,
-1.112112284927068e-13,
-2.327896938699909e-14,
-4.465473069912629e-15,
-7.90927923363923e-16,
-1.329935271771219e-16,
-2.035644129671977e-17,
-0.002276734072914438,
8.05203372021803e-11,
9.2702461075889e-11,
7.11517637347614e-11,
4.095824235107559e-11,
1.886196279346749e-11,
7.23854199511982e-12,
2.381048815714723e-12,
6.85319514929795e-13,
1.753333337392929e-13,
4.037175040097788e-14,
8.45070755124016e-15,
1.62105427425893e-15,
2.871233512887472e-16,
4.827981469571915e-17,
7.38998202577617e-18,
0.000725308413117998,
-2.446769306019661e-11,
-2.816947178645307e-11,
-2.162086727846244e-11,
-1.244597014677474e-11,
-5.73157965963717e-12,
-2.199573901715764e-12,
-7.23528729623001e-13,
-2.082478964890113e-13,
-5.327851374286919e-14,
-1.226776259928489e-14,
-2.567918295630838e-15,
-4.925908829841784e-16,
-8.72486482255327e-17,
-1.467097364249179e-17,
-2.245652431901535e-18,
-0.0001984430178854305,
6.39887499661292e-12,
7.36697687407523e-12,
5.65436337943429e-12,
3.254912826124711e-12,
1.498942399721959e-12,
5.75240134975098e-13,
1.892197314000739e-13,
5.446171379655217e-14,
1.393358463592433e-14,
3.208309658431679e-15,
6.71571768263045e-16,
1.288244275033065e-16,
2.281769721148601e-17,
3.836850703310109e-18,
5.873049954984183e-19,
0.0000475922589287484,
-1.469749913439917e-12,
-1.692112073240186e-12,
-1.298743939203798e-12,
-7.47617024881586e-13,
-3.442902863310379e-13,
-1.321262210578356e-13,
-4.34616563921927e-14,
-1.25092476827805e-14,
-3.20038937242204e-15,
-7.36913277338475e-16,
-1.542527160993266e-16,
-2.958960564952553e-17,
-5.240996976209302e-18,
-8.81291604534364e-19,
-1.349004707551353e-19,
-0.00001016252912574661,
3.01107147246994e-13,
3.466624050372081e-13,
2.660732144600118e-13,
1.531640379052832e-13,
7.0534630978743e-14,
2.706865337405344e-14,
8.90397490303305e-15,
2.562765551847079e-15,
6.55662840926822e-16,
1.509712546826458e-16,
3.160173808416839e-17,
6.062026489662031e-18,
1.073725262143027e-18,
1.805519682349098e-19,
2.763895541128246e-20,
1.956018158017124e-6,
-5.56949913188056e-14,
-6.41212267346003e-14,
-4.92148577448195e-14,
-2.833034653681284e-14,
-1.304660404055851e-14,
-5.006817271277278e-15,
-1.646944761455254e-15,
-4.740280199982182e-16,
-1.212762521852754e-16,
-2.792476841182786e-17,
-5.84529624747409e-18,
-1.121279662721024e-18,
-1.986052126699819e-19,
-3.339632169722799e-20,
-5.111957218629894e-21,
-3.427400205958215e-7,
9.3926923824294e-15,
1.081373646432359e-14,
8.29984905074852e-15,
4.77777670252842e-15,
2.200247047798298e-15,
8.44375675230925e-16,
2.77749329388084e-16,
7.99425556079201e-17,
2.045266205630962e-17,
4.709379936144547e-18,
9.85780113637651e-19,
1.890998783266998e-19,
3.350032970236267e-20,
5.630916339913239e-21,
8.54464104059367e-22,
5.511645638980936e-8,
-1.455813425226366e-15,
-1.676067105703641e-15,
-1.286428982978599e-15,
-7.40527979423477e-16,
-3.410256724085958e-16,
-1.308733884987961e-16,
-4.304955486765171e-17,
-1.239063883687398e-17,
-3.17004603021337e-18,
-7.29927414913228e-19,
-1.527905394618135e-19,
-2.930891987028096e-20,
-5.191409969724276e-21,
-8.73320671441119e-22,
-1.341148121219603e-22,
-8.1929027317681e-9,
2.088425688376585e-16,
2.404388873839319e-16,
1.845436574969595e-16,
1.062318589517733e-16,
4.892156999621375e-17,
1.87743394253186e-17,
6.17564038450572e-18,
1.777489393926805e-18,
4.547557102461618e-19,
1.047121872477003e-19,
2.192425961478908e-20,
4.201429403132987e-21,
7.26759255528715e-22,
1.288869799017071e-22,
4.03834504951096e-23,
1.150075960495744e-9,
-2.82982820588292e-17,
-3.257960049309596e-17,
-2.500576637196971e-17,
-1.439447494960035e-17,
-6.62889951555236e-18,
-2.543933299383809e-18,
-8.36802689449893e-19,
-2.408508542638721e-19,
-6.161970441446414e-20,
-1.418830578357436e-20,
-2.97015935906618e-21,
-5.700027854391264e-22,
-1.009187322857895e-22,
-1.671003241618421e-23,
-2.01602179801985e-24,
-1.482162910520903e-10,
3.52834384121171e-18,
4.062155879135568e-18,
3.117819724490525e-18,
1.794761151635019e-18,
8.26517913641305e-19,
3.171878540870348e-19,
1.043358735127756e-19,
3.003041098502506e-20,
7.68398869334351e-21,
1.767988082636818e-21,
3.638030367832496e-22,
7.441176572212362e-23,
3.24057599017934e-23,
-1.844935901548973e-24,
-2.274858843692428e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=18
0.01047865162507147,
-4.59434926641213e-10,
-5.28943985280693e-10,
-4.05979479053908e-10,
-2.33700536380041e-10,
-1.076230394872984e-10,
-4.13018410468605e-11,
-1.358584008563812e-11,
-3.91030893916481e-12,
-1.000419177145116e-12,
-2.30353167574078e-13,
-4.82178525585114e-14,
-9.24929740685992e-15,
-1.638220853374104e-15,
-2.754564575892761e-16,
-4.21599551915959e-17,
-0.01983067598254323,
8.20343888334449e-10,
9.44455768333426e-10,
7.24896535989141e-10,
4.17283926038932e-10,
1.921662911409231e-10,
7.37464947521483e-11,
2.425819615572385e-11,
6.98205302595804e-12,
1.7862992419669e-12,
4.11307531397721e-13,
8.60955833335915e-14,
1.651516106194826e-14,
2.925153457378945e-15,
4.9185154764807e-16,
7.52818418966695e-17,
0.01881874711543183,
-7.36827241304611e-10,
-8.48303680564003e-10,
-6.51097089724676e-10,
-3.74801559486334e-10,
-1.726024472478131e-10,
-6.62385990267372e-11,
-2.178854796474279e-11,
-6.27123373376868e-12,
-1.604442573991516e-12,
-3.69434000737096e-13,
-7.73306301701419e-14,
-1.483386875397262e-14,
-2.627375647256686e-15,
-4.417859414326091e-16,
-6.76201436832266e-17,
-0.01193658731061366,
4.43615815136787e-10,
5.10731564144567e-10,
3.92000935436789e-10,
2.256538469656129e-10,
1.039174086302079e-10,
3.987975768768745e-11,
1.311806226407887e-11,
3.775673568665664e-12,
9.65974664240606e-13,
2.224224569854216e-13,
4.655793877399952e-14,
8.93094613982628e-15,
1.581855846729155e-15,
2.659870543534919e-16,
4.071288259188199e-17,
0.005691835182285849,
-2.013008430054452e-10,
-2.317561526897163e-10,
-1.778794093368987e-10,
-1.023956058776862e-10,
-4.71549069836674e-11,
-1.809635498779906e-11,
-5.95262203928665e-12,
-1.713298787324442e-12,
-4.383333343482202e-13,
-1.009293760024419e-13,
-2.112676887809844e-14,
-4.052635685647601e-15,
-7.17808378230038e-16,
-1.206995367387616e-16,
-1.847495505189721e-17,
-0.002175925239319494,
7.34030791797945e-11,
8.45084153584435e-11,
6.48626018346845e-11,
3.733791043991964e-11,
1.719473897872518e-11,
6.59872170507579e-12,
2.170586188845484e-12,
6.24743689460263e-13,
1.598355412268741e-13,
3.680328779746195e-14,
7.70375488681868e-15,
1.477772648919842e-15,
2.617459446419691e-16,
4.401292094520132e-17,
6.736957337248244e-18,
0.0006945505626055684,
-2.239606248829187e-11,
-2.578441905943214e-11,
-1.97902718281496e-11,
-1.139219489151108e-11,
-5.24629839906121e-12,
-2.013340472426026e-12,
-6.62269059904594e-13,
-1.906159982891783e-13,
-4.876754622604821e-14,
-1.122908380460162e-14,
-2.350501189018533e-15,
-4.508854962097201e-16,
-7.9861939921724e-17,
-1.3428977526052e-17,
-2.055567906916773e-18,
-0.000190369036438014,
5.878999670428e-12,
6.76844831215087e-12,
5.19497577154416e-12,
2.990468108005019e-12,
1.377161149228725e-12,
5.28504885729776e-13,
1.738466260616648e-13,
5.003699087300177e-14,
1.280155752600352e-14,
2.947653117640382e-15,
6.17010866019358e-16,
1.183584231254931e-16,
2.096398839515151e-17,
3.525166221655508e-18,
5.396013114066942e-19,
0.00004573138098336426,
-1.354982160767873e-12,
-1.559980820544914e-12,
-1.197329463440958e-12,
-6.89238169635992e-13,
-3.174058389724776e-13,
-1.218089400175036e-13,
-4.006788700913008e-14,
-1.153244496766626e-14,
-2.950482780322072e-15,
-6.79370644835747e-16,
-1.422078197750006e-16,
-2.727912013028045e-17,
-4.831768488480745e-18,
-8.12482734769071e-19,
-1.243693004108551e-19,
-9.78008307652061e-6,
2.7847477876923e-13,
3.206059289446412e-13,
2.460741315892807e-13,
1.416516422299996e-13,
6.52329785471625e-14,
2.503407037046106e-14,
8.23471854887156e-15,
2.370138586417574e-15,
6.06380873539417e-16,
1.396237533280789e-16,
2.922646365564373e-17,
5.606393586237531e-18,
9.93021875653862e-19,
1.66982726190838e-19,
2.556437538967103e-20,
1.885070641286777e-6,
-5.16598199032097e-14,
-5.94755641388565e-14,
-4.56491802060479e-14,
-2.627777786612987e-14,
-1.210136152701976e-14,
-4.644067274563065e-15,
-1.527621660626288e-15,
-4.396841559333367e-16,
-1.124896655596735e-16,
-2.590159785049963e-17,
-5.421802494424793e-18,
-1.040042554398661e-18,
-1.842176595995539e-19,
-3.097819109547486e-20,
-4.740721470541777e-21,
-3.307425017583961e-7,
8.73588944321227e-15,
1.005756416386965e-14,
7.71946540478537e-15,
4.443681069132186e-15,
2.046390368338966e-15,
7.85331027417206e-16,
2.583271628510436e-16,
7.43524201016312e-17,
1.902247400663446e-17,
4.380068995492616e-18,
9.16843466338463e-19,
1.758774200669037e-19,
3.116947034505908e-20,
5.236694789352692e-21,
7.83412937471621e-22,
5.325220362284141e-8,
-1.357439507878232e-15,
-1.562809951925729e-15,
-1.199500911184137e-15,
-6.90488165985909e-16,
-3.179814932801204e-16,
-1.220298629600594e-16,
-4.014056247420801e-17,
-1.155336566720823e-17,
-2.955836523838418e-18,
-6.80603003066223e-19,
-1.42466861926708e-19,
-2.73317391620806e-20,
-4.838525675775744e-21,
-8.10794979696446e-22,
-1.273036010769026e-22,
-7.924836234366395e-9,
1.951902986328566e-16,
2.2472113099416e-16,
1.724798344732848e-16,
9.92873651399762e-17,
4.572351326906899e-17,
1.754704048966447e-17,
5.771932528045363e-18,
1.661293062789226e-18,
4.250253573776465e-19,
9.78672941608109e-20,
2.050277868634172e-20,
3.926132020172043e-21,
6.51043174086239e-22,
1.213215431162181e-22,
6.55097967549173e-23,
1.113670455942731e-9,
-2.650835286937716e-17,
-3.051886842678093e-17,
-2.342409616454326e-17,
-1.348399250868574e-17,
-6.20960696791998e-18,
-2.383023947196963e-18,
-7.83873091263451e-19,
-2.25616272692358e-19,
-5.772223714678162e-20,
-1.329223277588118e-20,
-2.781621578892455e-21,
-5.302399467326444e-22,
-9.64642109132006e-23,
-1.966170662362084e-23,
1.815670430583775e-25,
-1.436677626988658e-10,
3.31197153024505e-18,
3.813048058191316e-18,
2.926622417824389e-18,
1.684699149713526e-18,
7.75832520728595e-19,
2.977366115010512e-19,
9.79372796138612e-20,
2.818886743888283e-20,
7.2152626872288e-21,
1.659416049954907e-21,
3.300251433370859e-22,
7.027293098759029e-23,
5.82518147229403e-23,
-2.307344723960506e-24,
-4.900399477057161e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=19
0.00991533799127161,
-4.10171944167225e-10,
-4.72227884166713e-10,
-3.6244826799457e-10,
-2.08641963019466e-10,
-9.60831455704615e-11,
-3.68732473760742e-11,
-1.212909807786192e-11,
-3.49102651297902e-12,
-8.9314962098345e-13,
-2.056537656988603e-13,
-4.30477916667958e-14,
-8.25758053097413e-15,
-1.462576728689474e-15,
-2.459257738240349e-16,
-3.76409209483332e-17,
-0.01881874711543183,
7.36827241304611e-10,
8.48303680564003e-10,
6.51097089724675e-10,
3.74801559486334e-10,
1.726024472478131e-10,
6.62385990267372e-11,
2.178854796474279e-11,
6.27123373376868e-12,
1.604442573991516e-12,
3.69434000737096e-13,
7.73306301701419e-14,
1.483386875397263e-14,
2.62737564725665e-15,
4.417859414326063e-16,
6.76201436832673e-17,
0.01790488096592049,
-6.6542372270518e-10,
-7.66097346216851e-10,
-5.88001403155184e-10,
-3.38480770448419e-10,
-1.558761129453118e-10,
-5.98196365315312e-11,
-1.96770933961183e-11,
-5.6635103529985e-12,
-1.448961996360909e-12,
-3.336336854781325e-13,
-6.98369081609996e-14,
-1.339641920973936e-14,
-2.372783770092998e-15,
-3.989805815303058e-16,
-6.10693238885842e-17,
-0.0113836703645724,
4.02601686010906e-10,
4.63512305379451e-10,
3.55758818673811e-10,
2.047912117553803e-10,
9.43098139673385e-11,
3.619270997559952e-11,
1.190524407857375e-11,
3.426597574649016e-12,
8.76666668696474e-13,
2.018587520048919e-13,
4.22535377561976e-14,
8.10527137129483e-15,
1.435616756462903e-15,
2.413990734782409e-16,
3.694991010058232e-17,
0.005439813098298497,
-1.835076979494809e-10,
-2.112710383961028e-10,
-1.621565045867066e-10,
-9.33447760997965e-11,
-4.29868474468117e-11,
-1.649680426268901e-11,
-5.42646547211356e-12,
-1.561859223650614e-12,
-3.995888530671779e-13,
-9.20082194936508e-14,
-1.925938721702604e-14,
-3.694431622304094e-15,
-6.5436486165665e-16,
-1.100323023574998e-16,
-1.684239328949024e-17,
-0.002083651687783232,
6.71881874641276e-11,
7.73532571774352e-11,
5.93708154837878e-11,
3.417658467415273e-11,
1.573889519700838e-11,
6.04002141721083e-12,
1.986807179691662e-12,
5.71847994861171e-13,
1.463026386765127e-13,
3.368725141341727e-14,
7.0515035669982e-15,
1.352656488647219e-15,
2.395858196957621e-16,
4.028693254262588e-17,
6.166703800534505e-18,
0.0006662916275394208,
-2.057649884663617e-11,
-2.368956909268712e-11,
-1.818241520052665e-11,
-1.046663837808785e-11,
-4.8200640223329e-12,
-1.849767100066638e-12,
-6.08463191219923e-13,
-1.751294680566762e-13,
-4.480545134121199e-14,
-1.031678591184833e-14,
-2.159538031589777e-15,
-4.142544808247559e-16,
-7.3373958072638e-17,
-1.233808191688375e-17,
-1.888605953867738e-18,
-0.000182925524634948,
5.41992865874797e-12,
6.23992330022787e-12,
4.78931786761634e-12,
2.756952686518112e-12,
1.269623359562139e-12,
4.872357614792879e-13,
1.602715485000855e-13,
4.612978000404956e-14,
1.180193115545011e-14,
2.717482587417785e-15,
5.688312805335335e-16,
1.091164802589834e-16,
1.932707472962002e-17,
3.249931568298019e-18,
4.974763046357363e-19,
0.00004401037376423283,
-1.25313650272448e-12,
-1.442726678251027e-12,
-1.107333590616815e-12,
-6.37432389151411e-13,
-2.935484030553316e-13,
-1.126533165109132e-13,
-3.705623341842689e-14,
-1.066562362416328e-14,
-2.728713928341317e-15,
-6.28306888666412e-16,
-1.315190802317685e-16,
-2.522877247033924e-17,
-4.468614106166539e-18,
-7.51420621025131e-19,
-1.150233068109671e-19,
-9.42534572255409e-6,
2.582989322727463e-13,
2.97377628148319e-13,
2.282457532457571e-13,
1.31388804259071e-13,
6.05067684581962e-14,
2.322032133809808e-14,
7.63810335760759e-15,
2.198419356540948e-15,
5.624479635443087e-16,
1.295079037405108e-16,
2.710899588325429e-17,
5.200213909656826e-18,
9.21083982562896e-19,
1.548859868474596e-19,
2.370854331091961e-20,
1.819084272412034e-6,
-4.80474030555879e-14,
-5.53166157012617e-14,
-4.24570695506669e-14,
-2.444025153557367e-14,
-1.125514963020437e-14,
-4.31932165029569e-15,
-1.420799725222001e-15,
-4.089384047780698e-16,
-1.046236240009366e-16,
-2.409038765013542e-17,
-5.042677007492385e-18,
-9.67317948952284e-19,
-1.713361463717221e-19,
-2.88115478060214e-20,
-4.409578462437416e-21,
-3.195556820331658e-7,
8.14558590530454e-15,
9.37795212471613e-15,
7.19784392515877e-15,
4.143411651126137e-15,
1.908111230578701e-15,
7.32264477446319e-16,
2.40871433397248e-16,
6.93282688120568e-17,
1.773708517403247e-17,
4.084099558408774e-18,
8.54899388751194e-19,
1.639936997378915e-19,
2.904242874356073e-20,
4.882532716954848e-21,
7.51807091040347e-22,
5.150981951272655e-8,
-1.268701900770652e-15,
-1.460647009777103e-15,
-1.121087960686934e-15,
-6.45350049457135e-16,
-2.971946281430912e-16,
-1.140526130609775e-16,
-3.751652295107405e-17,
-1.079810787892867e-17,
-2.762610267501035e-18,
-6.36112204508232e-19,
-1.331533524237679e-19,
-2.554280713917507e-20,
-4.52289454041839e-21,
-7.602074657588844e-22,
-1.185422353902616e-22,
-7.673740453274067e-9,
1.82833218518237e-16,
2.104945172332808e-16,
1.615605056064031e-16,
9.30016950045538e-17,
4.282885599723149e-17,
1.643617529957399e-17,
5.406523579805997e-18,
1.5561201606893e-18,
3.981225241924089e-19,
9.16722631167996e-20,
1.918256816355644e-20,
3.675843871755123e-21,
6.66103480985087e-22,
1.153428905261715e-22,
3.8069971888972e-24,
1.079497262022477e-9,
-2.488291521389691e-17,
-2.864751422909971e-17,
-2.198777883006938e-17,
-1.265718189477977e-17,
-5.828846705120984e-18,
-2.236901849408019e-18,
-7.35807652422876e-19,
-2.117821740272172e-19,
-5.418274842883979e-20,
-1.247608512032999e-20,
-2.611341882892645e-21,
-5.006848735466829e-22,
-9.01432668696509e-23,
-1.526071085675774e-23,
-1.309319595577758e-26,
-1.393898898434562e-10,
3.114896073373843e-18,
3.586156560614407e-18,
2.752476769478353e-18,
1.584452868903106e-18,
7.29667381150017e-19,
2.800200896773673e-19,
9.21101617613785e-20,
2.651169683574577e-20,
6.78107731862848e-21,
1.559730774274122e-21,
3.343174150843953e-22,
6.859690532088882e-23,
-6.0967557520936e-24,
-4.80879223533801e-24,
1.6463657420491e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=20
0.00940937355771591,
-3.68413620652305e-10,
-4.24151840282001e-10,
-3.25548544862338e-10,
-1.87400779743167e-10,
-8.63012236239065e-11,
-3.31192995133686e-11,
-1.08942739823714e-11,
-3.13561686688434e-12,
-8.02221286995758e-13,
-1.84717000368548e-13,
-3.86653150850709e-14,
-7.41693437698631e-15,
-1.313687823628325e-15,
-2.208929707163031e-16,
-3.38100718416339e-17,
-0.01790488096592049,
6.6542372270518e-10,
7.66097346216851e-10,
5.88001403155184e-10,
3.38480770448419e-10,
1.558761129453118e-10,
5.98196365315312e-11,
1.96770933961183e-11,
5.6635103529985e-12,
1.448961996360908e-12,
3.336336854781324e-13,
6.98369081609996e-14,
1.339641920973937e-14,
2.372783770092989e-15,
3.989805815302922e-16,
6.10693238885962e-17,
0.0170755055468586,
-6.03902529016359e-10,
-6.95268458069176e-10,
-5.33638228010717e-10,
-3.071868176330704e-10,
-1.414647209510078e-10,
-5.42890649633993e-11,
-1.785786611786063e-11,
-5.13989636197352e-12,
-1.315000003044712e-12,
-3.027881280073378e-13,
-6.33803066342963e-14,
-1.21579070569422e-14,
-2.153425134694549e-15,
-3.620986102174006e-16,
-5.54248651507095e-17,
-0.01087962619659767,
3.67015395898977e-10,
4.22542076792222e-10,
3.243130091734262e-10,
1.866895521996004e-10,
8.59736948936269e-11,
3.299360852537934e-11,
1.085293094422755e-11,
3.123718447301353e-12,
7.99177706134388e-13,
1.840164389873092e-13,
3.851877443405346e-14,
7.38886324460754e-15,
1.308729723314231e-15,
2.200646047161203e-16,
3.368478657766728e-17,
0.005209129219457847,
-1.67970468660314e-10,
-1.933831429435823e-10,
-1.484270387094652e-10,
-8.54414616853793e-11,
-3.934723799251982e-11,
-1.510005354302663e-11,
-4.96701794922901e-12,
-1.429619987152885e-12,
-3.657565966912698e-13,
-8.42181285335395e-14,
-1.762875891750055e-14,
-3.381641221620978e-15,
-5.98964549227784e-16,
-1.007173313534852e-16,
-1.541675951100215e-17,
-0.001998874882585757,
6.17294965392037e-11,
7.10687072772499e-11,
5.45472456009571e-11,
3.139991513390502e-11,
1.44601920668336e-11,
5.54930130013655e-12,
1.825389573638928e-12,
5.25388404164031e-13,
1.344163540221016e-13,
3.095035773518353e-14,
6.47861409470058e-15,
1.242763442484673e-15,
2.20121874186771e-16,
3.701424572151848e-17,
5.665817904387792e-18,
0.0006402393362285107,
-1.896975030574828e-11,
-2.183973155094766e-11,
-1.676261253677242e-11,
-9.64933440287972e-12,
-4.443681758498035e-12,
-1.705325165189231e-12,
-5.60950419754151e-13,
-1.614542300152772e-13,
-4.130675904439205e-14,
-9.51118905605986e-15,
-1.990909481747911e-15,
-3.819076808237233e-16,
-6.76447618311966e-17,
-1.137476057878911e-17,
-1.741166835810291e-18,
-0.000176041495738137,
5.01254602566845e-12,
5.7709067300093e-12,
4.42933437551923e-12,
2.549729564118963e-12,
1.174193615681336e-12,
4.506132673714811e-13,
1.482249341104866e-13,
4.266249462235324e-14,
1.091485574552475e-14,
2.513227562163566e-15,
5.260763223979846e-16,
1.009150898959081e-16,
1.787445689165527e-17,
3.005682822888391e-18,
4.600926179231781e-19,
0.00004241405567363511,
-1.162345193587877e-12,
-1.338199324779913e-12,
-1.02710588815718e-12,
-5.91249618331865e-13,
-2.722804576778292e-13,
-1.044914458740492e-13,
-3.437146506080636e-14,
-9.89288709055949e-15,
-2.53101583197443e-15,
-5.827855655792923e-16,
-1.219904829841869e-16,
-2.340096373586577e-17,
-4.144874336656812e-18,
-6.969856686787789e-19,
-1.066915016545993e-19,
-9.09541409459214e-6,
2.402368576995835e-13,
2.765828970875256e-13,
2.12285208509278e-13,
1.222011775225525e-13,
5.62757112381424e-14,
2.159659408563645e-14,
7.10399396637519e-15,
2.044690682792543e-15,
5.231177768833815e-16,
1.204518587293927e-16,
2.521336911016647e-17,
4.836588169327325e-18,
8.56677203562766e-19,
1.440557776258132e-19,
2.205214348140619e-20,
1.757556749512042e-6,
-4.48007329725835e-14,
-5.15787487669215e-14,
-3.95881508608691e-14,
-2.278876941886913e-14,
-1.049461422629737e-14,
-4.027455569331795e-15,
-1.324793193636824e-15,
-3.813055672393981e-16,
-9.75539940261362e-17,
-2.246255583763962e-17,
-4.701936124418819e-18,
-9.01957170066781e-19,
-1.597589028401779e-19,
-2.686320688354943e-20,
-4.112361450579436e-21,
-3.091001495556406e-7,
7.6131054288202e-15,
8.76491134203622e-15,
6.72731776827531e-15,
3.872555059654426e-15,
1.783377194881102e-15,
6.84396048559285e-16,
2.251255747570434e-16,
6.47962562500773e-17,
1.657760844305777e-17,
3.817122902995771e-18,
7.99011480164425e-19,
1.532703330006735e-19,
2.71511714571416e-20,
4.567072439091684e-21,
6.967370637599645e-22,
4.98777423554832e-8,
-1.18838284829313e-15,
-1.368176286382985e-15,
-1.050114062316667e-15,
-6.04494194778409e-16,
-2.783798167408066e-16,
-1.068321661975883e-16,
-3.514142644863136e-17,
-1.011450138684638e-17,
-2.587715145627833e-18,
-5.958427399498936e-19,
-1.247238051589202e-19,
-2.392182749186931e-20,
-4.237820293863896e-21,
-7.166007790322378e-22,
-1.085096676734863e-22,
-7.438054557083291e-9,
1.716126442764407e-16,
1.975763541550271e-16,
1.516454496646419e-16,
8.72941307353588e-17,
4.020042616843803e-17,
1.542747855386291e-17,
5.074722797059025e-18,
1.460620881657565e-18,
3.736873280599007e-19,
8.60431483432245e-20,
1.801484528016819e-20,
3.459479304578959e-21,
6.049435152828322e-22,
9.77823204663517e-23,
2.070730099552928e-23,
1.047357311434539e-9,
-2.340242668931649e-17,
-2.694303887833968e-17,
-2.067954573297162e-17,
-1.190410248183531e-17,
-5.482040907362454e-18,
-2.103810252782988e-18,
-6.92028427310527e-19,
-1.991817636123897e-19,
-5.095908044843126e-20,
-1.173236900014686e-20,
-2.456134553407804e-21,
-4.750887407349755e-22,
-8.28704395629489e-23,
-9.5600147912212e-24,
-3.355975003491576e-24,
-1.353592292475872e-10,
2.934890607450178e-18,
3.378917615609027e-18,
2.593415009790025e-18,
1.492889569128382e-18,
6.87500956741865e-19,
2.638381764173586e-19,
8.67869271794175e-20,
2.497903677163022e-20,
6.391738113687481e-21,
1.473126853292446e-21,
3.042073010550121e-22,
5.42611689012047e-23,
1.771618533225712e-23,
7.365279567838415e-24,
-4.770471167721829e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=21
0.00895244048296025,
-3.3271186135259e-10,
-3.83048673108425e-10,
-2.94000701577592e-10,
-1.692403852242096e-10,
-7.79380564726559e-11,
-2.99098182657656e-11,
-9.83854669805915e-12,
-2.83175517649925e-12,
-7.24480998180454e-13,
-1.668168427390662e-13,
-3.49184540804998e-14,
-6.69820960486969e-15,
-1.186391885046495e-15,
-1.994902907651463e-16,
-3.05346619442982e-17,
-0.01707550554685859,
6.03902529016359e-10,
6.95268458069176e-10,
5.33638228010717e-10,
3.0718681763307e-10,
1.414647209510078e-10,
5.42890649633993e-11,
1.785786611786063e-11,
5.13989636197352e-12,
1.315000003044712e-12,
3.027881280073378e-13,
6.33803066342963e-14,
1.215790705694219e-14,
2.153425134694532e-15,
3.62098610217415e-16,
5.54248651507268e-17,
0.01631943929489651,
-5.50523093848465e-10,
-6.33813115188334e-10,
-4.86469513760139e-10,
-2.800343282994007e-10,
-1.289605423404404e-10,
-4.9490412788069e-11,
-1.627939641634133e-11,
-4.68557767095203e-12,
-1.198766559201582e-12,
-2.760246584809639e-13,
-5.77781616510803e-14,
-1.108329486691138e-14,
-1.963094584971143e-15,
-3.300969070740993e-16,
-5.052717986668862e-17,
-0.01041825843891635,
3.35940937320642e-10,
3.86766285887181e-10,
2.968540774189425e-10,
1.708829233707657e-10,
7.86944759850429e-11,
3.020010708605451e-11,
9.93403589845843e-12,
2.859239974305888e-12,
7.3151319338257e-13,
1.684362570670855e-13,
3.525751783500207e-14,
6.76328244324392e-15,
1.1979290984567e-15,
2.014346627050594e-16,
3.083351902106978e-17,
0.004997187206464167,
-1.543237413480046e-10,
-1.776717681931195e-10,
-1.363681140023887e-10,
-7.84997878347602e-11,
-3.615048016708293e-11,
-1.387325325034097e-11,
-4.563473934097183e-12,
-1.313471010410038e-12,
-3.360408850552452e-13,
-7.73758943379582e-14,
-1.619653523674517e-14,
-3.106908606206894e-15,
-5.50304685479853e-16,
-9.25356143087526e-17,
-1.416454474945105e-17,
-0.00192071800865394,
5.69092509165796e-11,
6.55191946520771e-11,
5.02878376097294e-11,
2.894800320830079e-11,
1.333104527533828e-11,
5.11597549550789e-12,
1.682851259242782e-12,
4.843626900401665e-13,
1.239202771317251e-13,
2.85335671678663e-14,
5.97272844518335e-15,
1.145723042398783e-15,
2.029342854746426e-16,
3.412428180306139e-17,
5.223500516519786e-18,
0.0006161452350895031,
-1.754391108996284e-11,
-2.01981735551745e-11,
-1.550267031442624e-11,
-8.92405347447908e-12,
-4.109677654913554e-12,
-1.577146435811266e-12,
-5.18787269390352e-13,
-1.493187311792928e-13,
-3.820199510957464e-14,
-8.79629646759287e-15,
-1.841267128533318e-15,
-3.532028147540947e-16,
-6.25605988505035e-17,
-1.051988975391206e-17,
-1.610324388858236e-18,
-0.0001696562233566003,
4.64938078829236e-12,
5.35279731516965e-12,
4.10842356494755e-12,
2.364998480418751e-12,
1.089121833976976e-12,
4.17965784749435e-13,
1.374858606554646e-13,
3.957154848094054e-14,
1.012406335827254e-14,
2.33114226901108e-15,
4.879619333556087e-16,
9.36038560859759e-17,
1.657949738668526e-17,
2.787941703004064e-18,
4.267661440778493e-19,
0.00004092936334993491,
-1.081065858098226e-12,
-1.244623035109477e-12,
-9.55283436922183e-13,
-5.49905298063099e-13,
-2.532407002085783e-13,
-9.71846732460394e-14,
-3.196797280281195e-14,
-9.20110805929147e-15,
-2.354029992935472e-15,
-5.420333640017899e-16,
-1.134601594782106e-16,
-2.176464530284006e-17,
-3.855050151661231e-18,
-6.482525922794484e-19,
-9.92325153609628e-20,
-8.78777668434805e-6,
2.240035161357748e-13,
2.578935726061603e-13,
1.979406228816603e-13,
1.139437714413712e-13,
5.24730362920092e-14,
2.01372644765492e-14,
6.62396157021251e-15,
1.906526570011438e-15,
4.877696462705714e-16,
1.123127066789378e-16,
2.350966467416685e-17,
4.509776842839471e-18,
7.98795764692836e-19,
1.34322790029279e-19,
2.055903515919472e-20,
1.700051307261861e-6,
-4.18720897785577e-14,
-4.82070238020747e-14,
-3.700025649136045e-14,
-2.129905787412665e-14,
-9.80857689560751e-15,
-3.764179158818932e-15,
-1.238190954773027e-15,
-3.563794943189103e-16,
-9.11768660803889e-17,
-2.099417781949091e-17,
-4.394571897459147e-18,
-8.4299618692176e-19,
-1.493164544949466e-19,
-2.510850159126218e-20,
-3.843005874688512e-21,
-2.993065277615929e-7,
7.13114089677853e-15,
8.21002918701209e-15,
6.30143000366502e-15,
3.627394387637403e-15,
1.670476563053636e-15,
6.41068852896682e-16,
2.10873510761676e-16,
6.06941912133118e-17,
1.552812778973864e-17,
3.575472803735241e-18,
7.48435091969485e-19,
1.435675930871294e-19,
2.541730007420278e-20,
4.277712408708705e-21,
6.67288475157224e-22,
4.834582696835756e-8,
-1.115450922780726e-15,
-1.2842103068283e-15,
-9.85667795498056e-16,
-5.67395946213261e-16,
-2.612954462924123e-16,
-1.002758000877942e-16,
-3.298477284888443e-17,
-9.49376805087224e-18,
-2.428905400280596e-18,
-5.592745719806122e-19,
-1.17070475909898e-19,
-2.245686518887446e-20,
-3.975303385228456e-21,
-6.690706946189201e-22,
-1.04342611953626e-22,
-7.216403284791727e-9,
1.613934544237793e-16,
1.858110774109875e-16,
1.426152666084984e-16,
8.20959401573526e-17,
3.78065715558627e-17,
1.450880333495254e-17,
4.772533042733882e-18,
1.373644032349452e-18,
3.514381466940708e-19,
8.09190685920612e-20,
1.692762768599915e-20,
3.254373497701388e-21,
6.0351812132593e-22,
9.12137490378729e-23,
-1.3672939176316e-23,
1.017074507390932e-9,
-2.205016151591182e-17,
-2.538618611001002e-17,
-1.948461714580187e-17,
-1.121624637550108e-17,
-5.16527154218992e-18,
-1.982245593889053e-18,
-6.520408606561643e-19,
-1.876722205345586e-19,
-4.801479649328421e-20,
-1.105570616941742e-20,
-2.312838554328165e-21,
-4.43937111747601e-22,
-8.153653160771632e-23,
-1.323767671442458e-23,
3.464549707033916e-25,
-1.315549674357316e-10,
2.770040293476735e-18,
3.189126683372339e-18,
2.447745094975921e-18,
1.409035234285871e-18,
6.4888459739385e-19,
2.490186317413121e-19,
8.19125191019979e-20,
2.357581381640949e-20,
6.029805732369156e-21,
1.391253514060696e-21,
3.006115879416635e-22,
4.90575835017242e-23,
-1.50945234756546e-23,
9.05330123789798e-24,
2.553413317258148e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=22
0.0085377527734293,
-3.01951264508179e-10,
-3.47634229034588e-10,
-2.66819114005358e-10,
-1.535934088165352e-10,
-7.07323604755039e-11,
-2.71445324816996e-11,
-8.92893305893031e-12,
-2.56994818098676e-12,
-6.57500001522356e-13,
-1.513940640036689e-13,
-3.16901533171482e-14,
-6.07895352847109e-15,
-1.076712567347264e-15,
-1.810493051087073e-16,
-2.771243257536521e-17,
-0.01631943929489651,
5.50523093848465e-10,
6.33813115188334e-10,
4.86469513760139e-10,
2.80034328299401e-10,
1.289605423404403e-10,
4.9490412788069e-11,
1.627939641634132e-11,
4.68557767095203e-12,
1.198766559201582e-12,
2.760246584809638e-13,
5.77781616510803e-14,
1.108329486691138e-14,
1.963094584971145e-15,
3.300969070740993e-16,
5.05271798666863e-17,
0.01562738765837453,
-5.03911405980963e-10,
-5.80149428830771e-10,
-4.45281116128414e-10,
-2.563243850561486e-10,
-1.180417139775643e-10,
-4.53001606290818e-11,
-1.490105384768765e-11,
-4.28885996145883e-12,
-1.097269790073855e-12,
-2.526543856006283e-13,
-5.28862767525029e-14,
-1.014492366486581e-14,
-1.796893647685713e-15,
-3.021519940576676e-16,
-4.625027853091101e-17,
-0.00999437441292897,
3.08647482696022e-10,
3.55343536386254e-10,
2.72736228004789e-10,
1.569995756695271e-10,
7.23009603341689e-11,
2.774650650068311e-11,
9.12694786819475e-12,
2.626942020820188e-12,
6.72081770110519e-13,
1.547517886759229e-13,
3.239307047349154e-14,
6.21381721241431e-15,
1.100609370960042e-15,
1.850712286172459e-16,
2.832908949874196e-17,
0.004801795021634631,
-1.422731272914447e-10,
-1.637979866301877e-10,
-1.257195940243197e-10,
-7.23700080207497e-11,
-3.332761318834466e-11,
-1.278993873876934e-11,
-4.207128148106825e-12,
-1.210906725100379e-12,
-3.098006928292999e-13,
-7.13339179196629e-14,
-1.493182111297506e-14,
-2.864307605998955e-15,
-5.073357136423576e-16,
-8.53107045050339e-17,
-1.305875133714488e-17,
-0.001848435705237781,
5.26317332692596e-11,
6.05945206647995e-11,
4.6508010942723e-11,
2.677216042311734e-11,
1.232903296459335e-11,
4.731439307377262e-12,
1.556361808152461e-12,
4.479561935325252e-13,
1.146059853273515e-13,
2.638888940246702e-14,
5.52380138554593e-15,
1.059608444239441e-15,
1.876817965256029e-16,
3.155966927214844e-17,
4.830973184285662e-18,
0.0005937967817539643,
-1.627283275913999e-11,
-1.873479060322816e-11,
-1.437948247741957e-11,
-8.277494681525e-12,
-3.811926418946757e-12,
-1.462880246633515e-12,
-4.812005122975691e-13,
-1.385004196842862e-13,
-3.543422175428948e-14,
-8.15899794159394e-15,
-1.707866766347126e-15,
-3.276134963079066e-16,
-5.802824190328923e-17,
-9.75779596072095e-18,
-1.493680425666646e-18,
-0.0001637174540436998,
4.32426344557204e-12,
4.97849215561095e-12,
3.82113375933447e-12,
2.199621198956223e-12,
1.012962803921539e-12,
3.887386941689231e-13,
1.278718916009576e-13,
3.680443234934398e-14,
9.41612000049996e-15,
2.168133462565642e-15,
4.538406390446947e-16,
8.70585816123116e-17,
1.542020118159079e-17,
2.593010233924521e-18,
3.9692962918194e-19,
0.00003954499500585187,
-1.008015821143527e-12,
-1.160521075038245e-12,
-8.90732801670751e-13,
-5.12746970739718e-13,
-2.361286629702827e-13,
-9.0617690012555e-14,
-2.980782702265735e-14,
-8.57936955251527e-15,
-2.194963404123951e-15,
-5.054071795755614e-16,
-1.057934953729473e-16,
-2.029399507735624e-17,
-3.594569501805575e-18,
-6.044532716727767e-19,
-9.25273307865409e-20,
-8.50024966619271e-6,
2.093603082919272e-13,
2.410349571376528e-13,
1.850011582149023e-13,
1.064952178512517e-13,
4.904285154214572e-14,
1.882088315448809e-14,
6.19095061625126e-15,
1.781896274869881e-15,
4.558840237121657e-16,
1.049708188893931e-16,
2.197284701159819e-17,
4.214977324923638e-18,
7.46576785498949e-19,
1.255432265904975e-19,
1.921932545697273e-20,
1.646186374495454e-6,
-3.92212843246824e-14,
-4.51551713419669e-14,
-3.465787331974832e-14,
-1.995067390963568e-14,
-9.18762329700111e-15,
-3.525879535238891e-15,
-1.159804586405101e-15,
-3.33818132105956e-16,
-8.54047282431279e-17,
-1.966510233118707e-17,
-4.116369363913513e-18,
-7.89629714119878e-19,
-1.398574963955519e-19,
-2.351899455536035e-20,
-3.606859145585932e-21,
-2.90113939906064e-7,
6.69350323938721e-15,
7.70618023012915e-15,
5.91471166269137e-15,
3.404781444380808e-15,
1.567959540399613e-15,
6.01726511679484e-16,
1.979322255363524e-16,
5.69693978112035e-17,
1.457517159240548e-17,
3.356046608165028e-18,
7.02496870500486e-19,
1.347592877932552e-19,
2.38766570813128e-20,
4.012921788058607e-21,
6.06292032207894e-22,
4.690513435271006e-8,
-1.049027851716188e-15,
-1.207737922565944e-15,
-9.26973075126027e-16,
-5.33608553359638e-16,
-2.457357807346892e-16,
-9.43045607191985e-17,
-3.102059082697337e-17,
-8.92843217670719e-18,
-2.284270274452952e-18,
-5.25971060205232e-19,
-1.100919711035828e-19,
-2.111930206148971e-20,
-3.757997401722474e-21,
-6.296900275146312e-22,
-7.72709602149983e-23,
-7.007570181780956e-9,
1.520600154670423e-16,
1.75065559029414e-16,
1.343677769565737e-16,
7.734830404313e-17,
3.562020483364893e-17,
1.36697545593988e-17,
4.496536359208263e-18,
1.294205297092237e-18,
3.311108039075479e-19,
7.62423522456824e-20,
1.5967304374578e-20,
3.058680305858915e-21,
5.19975532646306e-22,
9.37007903561903e-23,
3.7973593549131e-23,
9.8849250527491e-10,
-2.081173732124619e-17,
-2.396039760673024e-17,
-1.839028409188141e-17,
-1.058629770466106e-17,
-4.875169516169955e-18,
-1.870914879340242e-18,
-6.154198616982971e-19,
-1.771318484704058e-19,
-4.531648025986101e-20,
-1.043461161152929e-20,
-2.191379229586017e-21,
-4.195419939481513e-22,
-5.44371615392953e-23,
-1.178487007294573e-23,
-2.38024997155321e-23,
-1.27958562221774e-10,
2.618691311751671e-18,
3.014879733673468e-18,
2.31400562588343e-18,
1.332048618881828e-18,
6.13430976995495e-19,
2.354127371358144e-19,
7.74366265103892e-20,
2.228834328778139e-20,
5.703993303786412e-21,
1.311687505518983e-21,
2.654107123258638e-22,
5.581486982770415e-23,
3.48023049249437e-23,
-1.277855902606402e-24,
-2.711426478850862e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=23
0.00815971964744825,
-2.75261546924232e-10,
-3.16906557594167e-10,
-2.4323475688007e-10,
-1.400171641497003e-10,
-6.44802711702202e-11,
-2.47452063940345e-11,
-8.13969820817066e-12,
-2.34278883547601e-12,
-5.99383279600791e-13,
-1.380123292404819e-13,
-2.88890808255401e-14,
-5.54164743345569e-15,
-9.81547292485571e-16,
-1.650484535370497e-16,
-2.52635899333444e-17,
-0.01562738765837453,
5.03911405980963e-10,
5.80149428830771e-10,
4.45281116128414e-10,
2.563243850561485e-10,
1.180417139775643e-10,
4.53001606290818e-11,
1.490105384768764e-11,
4.28885996145883e-12,
1.097269790073855e-12,
2.526543856006282e-13,
5.28862767525028e-14,
1.014492366486581e-14,
1.796893647685774e-15,
3.021519940576733e-16,
4.62502785308411e-17,
0.01499156161939346,
-4.62971224044034e-10,
-5.33015304579381e-10,
-4.09104342007184e-10,
-2.354993635042906e-10,
-1.084514405012534e-10,
-4.16197597510247e-11,
-1.369042180229213e-11,
-3.940413031230282e-12,
-1.008122655165778e-12,
-2.321276830138844e-13,
-4.85896057102372e-14,
-9.32072581862148e-15,
-1.650914056440208e-15,
-2.776068429258565e-16,
-4.249363424798463e-17,
-0.00960359004326988,
2.84546254582902e-10,
3.2759597326039e-10,
2.514391880486504e-10,
1.447400160415058e-10,
6.66552263766922e-11,
2.557987747753979e-11,
8.41425629621402e-12,
2.421813450200864e-12,
6.19601385658626e-13,
1.426678358393319e-13,
2.986364222595419e-14,
5.72861521199854e-15,
1.014671427276901e-15,
1.706214090095918e-16,
2.61175026831283e-17,
0.004621089263094239,
-1.31579333173145e-10,
-1.514863016619939e-10,
-1.162700273568038e-10,
-6.69304010577912e-11,
-3.08225824114824e-11,
-1.182859826844278e-11,
-3.890904520381031e-12,
-1.119890483831278e-12,
-2.865149633183698e-13,
-6.59722235061652e-14,
-1.380950346386353e-14,
-2.649021110599311e-15,
-4.692044913176429e-16,
-7.88991731794761e-17,
-1.207743295563098e-17,
-0.001781390345231983,
4.88184982768245e-11,
5.6204371808999e-11,
4.31384474317326e-11,
2.483248404427212e-11,
1.143577925670079e-11,
4.388640739847018e-12,
1.443601536875098e-12,
4.155012590477902e-13,
1.063026652615894e-13,
2.447699382448688e-14,
5.123600298881112e-15,
9.82840488900646e-16,
1.7408472598321e-16,
2.927338789550939e-17,
4.48104096850542e-18,
0.0005730110891586605,
-1.513492205961282e-11,
-1.742472254476574e-11,
-1.337396815776844e-11,
-7.69867419640307e-12,
-3.545369813751313e-12,
-1.36058542960118e-12,
-4.475516206066258e-13,
-1.288155132236425e-13,
-3.295642000197354e-14,
-7.588467119053e-15,
-1.588442236771486e-15,
-3.047050355994307e-16,
-5.397070383432432e-17,
-9.07553586559038e-18,
-1.389254045456493e-18,
-0.0001581799806502307,
4.03206329705226e-12,
4.64208431451898e-12,
3.562931217709316e-12,
2.050987889306128e-12,
9.44514654804148e-13,
3.624707611719689e-13,
1.192313084596442e-13,
3.431747831627298e-14,
8.77985364340047e-15,
2.021628724510403e-15,
4.231739842736429e-16,
8.11759807054493e-17,
1.437827392893953e-17,
2.417812918458024e-18,
3.701139210719641e-19,
0.00003825112342606374,
-9.42121385922248e-13,
-1.084657305517501e-12,
-8.32505210737529e-13,
-4.79228479622857e-13,
-2.206928316137146e-13,
-8.46939740701055e-14,
-2.785927773195326e-14,
-8.01853322512947e-15,
-2.051478104018715e-15,
-4.723686840148646e-16,
-9.88778094840793e-17,
-1.896739865792528e-17,
-3.359600893828682e-18,
-5.649438109383849e-19,
-8.64810516875842e-20,
-8.23092518518575e-6,
1.961062885009153e-13,
2.257757034468994e-13,
1.732892489650955e-13,
9.9753301832813e-14,
4.593808530094197e-14,
1.762938570887313e-14,
5.7990189952929e-15,
1.669089527447318e-15,
4.270233533090607e-16,
9.83254452267946e-17,
2.058182206679206e-17,
3.948144953342864e-18,
6.99317026619964e-19,
1.17596018386612e-19,
1.800094856158346e-20,
1.595627129059263e-6,
-3.68142767223681e-14,
-4.23840015188204e-14,
-3.253092201435534e-14,
-1.872630247417066e-14,
-8.6237795583632e-15,
-3.309496614881277e-15,
-1.088627504062445e-15,
-3.13331763332895e-16,
-8.01634604148518e-17,
-1.845826292012585e-17,
-3.863748666096948e-18,
-7.41171108043292e-19,
-1.312806281348645e-19,
-2.207597463314997e-20,
-3.379248824436351e-21,
-2.814687469488598e-7,
6.29492238460036e-15,
7.24729707705607e-15,
5.56250584862173e-15,
3.202035505225193e-15,
1.474591608107729e-15,
5.65895261269135e-16,
1.861458797234048e-16,
5.35770215018655e-17,
1.370725928673741e-17,
3.156204025188634e-18,
6.60668989674372e-19,
1.267339819059586e-19,
2.244575864450643e-20,
3.775085448970556e-21,
5.797306713140421e-22,
4.554775773091647e-8,
-9.88362032306208e-16,
-1.137893818948147e-15,
-8.73365747735804e-16,
-5.02749698832952e-16,
-2.315247564555665e-16,
-8.88508812288503e-17,
-2.922665537827226e-17,
-8.41209702411578e-18,
-2.152168904498788e-18,
-4.955539486825765e-19,
-1.037316184606017e-19,
-1.989836185103063e-20,
-3.523760208353686e-21,
-5.927030272690292e-22,
-9.11164863629155e-23,
-6.810475335150878e-9,
1.435129057364949e-16,
1.652253355888315e-16,
1.268151267937311e-16,
7.30006496300458e-17,
3.361803646287508e-17,
1.290139439399552e-17,
4.243791441683866e-18,
1.221459812276461e-18,
3.125013164721687e-19,
7.19559721271297e-20,
1.506078594067912e-20,
2.889533134186229e-21,
5.140040147254236e-22,
8.51844709882407e-23,
1.165259385505007e-23,
9.61472020347785e-10,
-1.967473210285986e-17,
-2.265137201039625e-17,
-1.738556987352385e-17,
-1.00079377745063e-17,
-4.608824993653011e-18,
-1.768701435410505e-18,
-5.817975794229567e-19,
-1.674546258902463e-19,
-4.284208155715833e-20,
-9.86463622932947e-21,
-2.064465422639799e-21,
-3.962123129202351e-22,
-7.086054216919057e-23,
-1.178231014130302e-23,
-1.551143836959744e-24,
-1.245534412861944e-10,
2.479409320966787e-18,
2.854525420207803e-18,
2.190929149001932e-18,
1.26120011086118e-18,
5.80804028747356e-19,
2.228917082399175e-19,
7.3318158190904e-20,
2.11026987014086e-20,
5.39877912763075e-21,
1.243043904696574e-21,
2.604348781019469e-22,
4.952924302278756e-23,
9.44318374368091e-24,
2.583949802134296e-24,
-1.259117870186953e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=24
0.00781369382918726,
-2.51955702990481e-10,
-2.90074714415385e-10,
-2.22640558064207e-10,
-1.281621925280743e-10,
-5.90208569887822e-11,
-2.26500803145409e-11,
-7.45052692384382e-12,
-2.14442998072942e-12,
-5.48634895036927e-13,
-1.263271928003141e-13,
-2.64431383762514e-14,
-5.0724618324329e-15,
-8.98446823842886e-16,
-1.510759970288364e-16,
-2.312513926542176e-17,
-0.01499156161939346,
4.62971224044034e-10,
5.33015304579381e-10,
4.09104342007184e-10,
2.354993635042906e-10,
1.084514405012534e-10,
4.16197597510247e-11,
1.369042180229213e-11,
3.94041303123028e-12,
1.008122655165778e-12,
2.321276830138844e-13,
4.85896057102372e-14,
9.32072581862148e-15,
1.650914056440217e-15,
2.776068429258586e-16,
4.249363424797356e-17,
0.01440538506490483,
-4.26819381874353e-10,
-4.91393959890585e-10,
-3.77158782072976e-10,
-2.171100240622587e-10,
-9.99828395650384e-11,
-3.83698162163097e-11,
-1.262138444432103e-11,
-3.632720175301296e-12,
-9.2940207848794e-13,
-2.14001753758998e-13,
-4.47954633389311e-14,
-8.59292281799777e-15,
-1.522007140915711e-15,
-2.559321135144162e-16,
-3.91762540243457e-17,
-0.00924217852618908,
2.63158666346302e-10,
3.02972603324001e-10,
2.325400547136181e-10,
1.338608021155885e-10,
6.16451648229675e-11,
2.365719653688662e-11,
7.78180904076241e-12,
2.239780967662655e-12,
5.73029926636765e-13,
1.319444470123362e-13,
2.761900692772824e-14,
5.29804222119912e-15,
9.38408982635261e-16,
1.577983463586812e-16,
2.415486591151081e-17,
0.004453475863079748,
-1.220462456920574e-10,
-1.405109295224929e-10,
-1.078461185793279e-10,
-6.20812101106783e-11,
-2.858944814175106e-11,
-1.097160184961719e-11,
-3.60900384218763e-12,
-1.038753147619442e-12,
-2.657566631539633e-13,
-6.11924845612146e-14,
-1.280900074721047e-14,
-2.457101222252712e-15,
-4.352118149387937e-16,
-7.31834697380912e-17,
-1.120260243978359e-17,
-0.001719033267446847,
4.54047661782739e-11,
5.22741676336472e-11,
4.01219044728064e-11,
2.309602258892204e-11,
1.063610944112169e-11,
4.081756288752787e-12,
1.342654861803183e-12,
3.864465396661215e-13,
9.88692600046893e-14,
2.276540135687917e-14,
4.765326710262901e-15,
9.14115106778309e-16,
1.619121114867271e-16,
2.722660760531251e-17,
4.167762145480333e-18,
0.0005536299322813742,
-1.411222153978798e-11,
-1.624729510093742e-11,
-1.247025926207546e-11,
-7.1784576126249e-12,
-3.305801291839135e-12,
-1.268647664111338e-12,
-4.173095796118578e-13,
-1.201111741078464e-13,
-3.072948775216559e-14,
-7.07570053585137e-15,
-1.481108944810343e-15,
-2.841159324534441e-16,
-5.032395912328666e-17,
-8.46234521787752e-18,
-1.295398368110576e-18,
-0.0001530044943148291,
3.7684855555206e-12,
4.33862923569165e-12,
3.330020853405114e-12,
1.916913924509811e-12,
8.82771329226425e-13,
3.387758973440489e-13,
1.114371112776789e-13,
3.207413300122774e-14,
8.20591244187318e-15,
1.889474741942557e-15,
3.955112390320793e-16,
7.58695949979221e-17,
1.343840392014869e-17,
2.259775121758537e-18,
3.459239696632224e-19,
0.00003703916326334684,
-8.82478296932973e-13,
-1.015990663990022e-12,
-7.798016191755e-13,
-4.488898575756323e-13,
-2.067213835447566e-13,
-7.93322355711567e-14,
-2.609558543979029e-14,
-7.51090286230507e-15,
-1.921605086697519e-15,
-4.424645027393497e-16,
-9.26182005474444e-17,
-1.776665239027746e-17,
-3.146923448741915e-18,
-5.291821449428187e-19,
-8.10072346844012e-20,
-7.97812913135711e-6,
1.840712573868506e-13,
2.119198622722149e-13,
1.626544985331101e-13,
9.36314481640397e-14,
4.311886822348794e-14,
1.654747172715182e-14,
5.443133787768471e-15,
1.566657742271747e-15,
4.008170269683225e-16,
9.22912517030562e-17,
1.931873115553711e-17,
3.705851976482382e-18,
6.56400396899706e-19,
1.103808332768596e-19,
1.689811484405794e-20,
1.548078556181612e-6,
-3.46220815712273e-14,
-3.98601436590521e-14,
-3.059378963949453e-14,
-1.761119958000852e-14,
-8.11025582541371e-15,
-3.112424697173805e-15,
-1.023802588344949e-15,
-2.946736900262634e-16,
-7.53899458637704e-17,
-1.735912697299575e-17,
-3.633674673554781e-18,
-6.97036704881314e-19,
-1.234638658101512e-19,
-2.076209925547353e-20,
-3.177761510711627e-21,
-2.733235036983714e-7,
5.93088833520906e-15,
6.82818740189822e-15,
5.24082730447953e-15,
3.016862472334383e-15,
1.38931629554934e-15,
5.331696663823928e-16,
1.753811090522143e-16,
5.04786776396379e-17,
1.291457361507129e-17,
2.973681069756536e-18,
6.224614194539352e-19,
1.194091227513841e-19,
2.11527016506919e-20,
3.551922866959287e-21,
5.403443349623367e-22,
4.426667782862287e-8,
-9.32807236730264e-16,
-1.073933998740167e-15,
-8.24274774405072e-16,
-4.744906662737216e-16,
-2.185109940602429e-16,
-8.38566676648363e-17,
-2.7583856689049e-17,
-7.93926251479641e-18,
-2.031197854631837e-18,
-4.676990173204147e-19,
-9.79018370176389e-20,
-1.878141126606603e-20,
-3.323855936160541e-21,
-5.576769383612861e-22,
-8.77686097343144e-23,
-6.624156750498962e-9,
1.356662638992982e-16,
1.561915555816474e-16,
1.198814447924931e-16,
6.90093018759668e-17,
3.177995331082323e-17,
1.219600426876859e-17,
4.011760116365308e-18,
1.154675475733442e-18,
2.954148872353932e-19,
6.8024871489628e-20,
1.423957497092859e-20,
2.721708565672397e-21,
4.784184419555411e-22,
9.2568830811903e-23,
2.043473761200975e-23,
9.3588856390047e-10,
-1.862837225992203e-17,
-2.144670575527072e-17,
-1.646095440377728e-17,
-9.47568638331279e-18,
-4.36371422565499e-18,
-1.674636749059222e-18,
-5.508558642237612e-19,
-1.585488203514978e-19,
-4.056391012867151e-20,
-9.3405755986678e-21,
-1.953350621263358e-21,
-3.734229889280215e-22,
-7.023929571958216e-23,
-1.314572508839171e-23,
1.630099457142038e-24,
-1.213247474899345e-10,
2.350945427324014e-18,
2.706625900912154e-18,
2.077412079026501e-18,
1.195854440303993e-18,
5.507112392975496e-19,
2.11343146571666e-19,
6.95193948498041e-20,
2.000978287779069e-20,
5.119057370256431e-21,
1.175580319979406e-21,
2.462863997753316e-22,
5.669131508090368e-23,
1.212350712099921e-23,
-9.50064299358269e-24,
-5.877557427840374e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=25
0.00749578080969673,
-2.31485612022017e-10,
-2.66507652289691e-10,
-2.04552171003592e-10,
-1.177496817521453e-10,
-5.42257202506267e-11,
-2.08098798755123e-11,
-6.84521090114606e-12,
-1.970206515615141e-12,
-5.04061327582889e-13,
-1.160638415069422e-13,
-2.42948028551186e-14,
-4.66036290931074e-15,
-8.2545702822011e-16,
-1.388034214629287e-16,
-2.124681712398502e-17,
-0.01440538506490483,
4.26819381874353e-10,
4.91393959890585e-10,
3.77158782072976e-10,
2.171100240622587e-10,
9.99828395650383e-11,
3.83698162163097e-11,
1.262138444432102e-11,
3.6327201753013e-12,
9.2940207848794e-13,
2.140017537589979e-13,
4.47954633389311e-14,
8.59292281799778e-15,
1.522007140915697e-15,
2.559321135144122e-16,
3.917625402435964e-17,
0.01386326778928363,
-3.94737999519453e-10,
-4.54458904986002e-10,
-3.48810082070427e-10,
-2.007912031733827e-10,
-9.24677472344513e-11,
-3.548579480532994e-11,
-1.167271356114362e-11,
-3.359671451493984e-12,
-8.59544889955148e-13,
-1.979166705185043e-13,
-4.142851039159251e-14,
-7.94706333179849e-15,
-1.407613473952458e-15,
-2.3669751953824e-16,
-3.623229886778338e-17,
-0.00890695172616009,
2.44092491384126e-10,
2.81021859044999e-10,
2.156922371586657e-10,
1.241624202213623e-10,
5.71788962835047e-11,
2.194320369923539e-11,
7.21800768437559e-12,
2.077506295238979e-12,
5.31513326307951e-13,
1.223849691224349e-13,
2.561800149442187e-14,
4.914202444505103e-15,
8.70423629878028e-16,
1.463669394768262e-16,
2.240520487931989e-17,
0.004297583168616913,
-1.135119154456809e-10,
-1.306854190841138e-10,
-1.003047611820128e-10,
-5.77400564723032e-11,
-2.659027360280334e-11,
-1.020439072188163e-11,
-3.356637154507846e-12,
-9.66116349165273e-13,
-2.471731500117159e-13,
-5.69135033921918e-14,
-1.191331677565033e-14,
-2.28528776695846e-15,
-4.047802787380162e-16,
-6.80665189982651e-17,
-1.041940533748602e-17,
-0.001660889796815724,
4.23366646188279e-11,
4.87418853021951e-11,
3.74107777857527e-11,
2.153537283760202e-11,
9.91740387539183e-12,
3.805942992285824e-12,
1.251928738819722e-12,
3.603335223189779e-13,
9.21884632553271e-14,
2.122710160727721e-14,
4.443326834381688e-15,
8.52347797373838e-16,
1.50971877359743e-16,
2.538703562501583e-17,
3.886195105262995e-18,
0.0005355157301073315,
-1.318969944442202e-11,
-1.51852023250358e-11,
-1.165507298700618e-11,
-6.70919873583516e-12,
-3.089699652315892e-12,
-1.185715640713154e-12,
-3.900298894748309e-13,
-1.122594655051297e-13,
-2.872069354676013e-14,
-6.61316159695613e-15,
-1.384289336734865e-15,
-2.655435821751006e-16,
-4.703441332858284e-17,
-7.90921330003096e-18,
-1.210734398620444e-18,
-0.0001481566536485331,
3.52991319896592e-12,
4.06396266889374e-12,
3.119206486628943e-12,
1.795559436016937e-12,
8.26885536810609e-13,
3.173289432945352e-13,
1.043823420913538e-13,
3.004361154481184e-14,
7.68642037129493e-15,
1.7698580167311e-15,
3.704728032289396e-16,
7.1066609363339e-17,
1.258769404462009e-17,
2.116729082246166e-18,
3.240288442714221e-19,
0.00003590158102284299,
-8.2832065698477e-13,
-9.53639378778877e-13,
-7.31945242289081e-13,
-4.213415160992609e-13,
-1.940349067114619e-13,
-7.44636226592497e-14,
-2.449410200781956e-14,
-7.04995982973944e-15,
-1.803676618700021e-15,
-4.153106307899118e-16,
-8.69342891748164e-17,
-1.667633756607892e-17,
-2.953805233162965e-18,
-4.967094375095085e-19,
-7.60368694798123e-20,
-7.74038643156566e-6,
1.731102880064015e-13,
1.993005803131561e-13,
1.529688422922976e-13,
8.80559369361278e-14,
4.055125105214801e-14,
1.556211271170959e-14,
5.1190093977256e-15,
1.473367430256298e-15,
3.769494679687359e-16,
8.67955736291892e-17,
1.816836214842168e-17,
3.485184573875933e-18,
6.17316500151712e-19,
1.038063564521121e-19,
1.589037876762942e-20,
1.503279707263028e-6,
-3.26198938829842e-14,
-3.75550399660659e-14,
-2.882455727859199e-14,
-1.659274768719996e-14,
-7.64124150875203e-15,
-2.932433887919656e-15,
-9.64596337453383e-16,
-2.776327942271827e-16,
-7.10301722838534e-17,
-1.635525718892981e-17,
-3.423542104639549e-18,
-6.56728760338843e-19,
-1.16324476916353e-19,
-1.956071822786739e-20,
-2.993787427397745e-21,
-2.656360904392482e-7,
5.59752339179454e-15,
6.44438683844743e-15,
4.94624950292467e-15,
2.847289878418756e-15,
1.311225248338607e-15,
5.032011335110455e-16,
1.655232472353728e-16,
4.764136169969767e-17,
1.218866922425023e-17,
2.806539582045956e-18,
5.874768953078086e-19,
1.126883580313647e-19,
1.995590963666786e-20,
3.362715509721233e-21,
5.191183874344e-22,
4.305564182601166e-8,
-8.81805377755221e-16,
-1.015215940302306e-15,
-7.79207001600053e-16,
-4.485475737439194e-16,
-2.065637611336563e-16,
-7.92717496727642e-17,
-2.607569178112358e-17,
-7.50517842957984e-18,
-1.920141075929829e-18,
-4.421280932112073e-19,
-9.25487514034223e-20,
-1.775246975636098e-20,
-3.142853882897645e-21,
-5.295685736109108e-22,
-8.225771006021153e-23,
-6.44775469412861e-9,
1.284456297080018e-16,
1.478784934840511e-16,
1.13500934188078e-16,
6.53363851330575e-17,
3.008851301395771e-17,
1.154689023058142e-17,
3.79824020502543e-18,
1.0932209887329e-18,
2.796931448238774e-19,
6.43966787193061e-20,
1.347412078566336e-20,
2.599164227368872e-21,
4.75256202286747e-22,
6.21498514802439e-23,
-5.9945916375404e-24,
9.11630530398704e-10,
-1.766327702025532e-17,
-2.033559882876152e-17,
-1.5608148367291e-17,
-8.98477181936114e-18,
-4.137639761556678e-18,
-1.587877492938358e-18,
-5.223172576909212e-19,
-1.503348939634738e-19,
-3.846222088853789e-20,
-8.85586940460582e-21,
-1.853024973208166e-21,
-3.5642796675438e-22,
-6.433893265574655e-23,
-9.74264826769415e-24,
-7.775213765605851e-25,
-1.182591226874354e-10,
2.232208151691284e-18,
2.569924564110679e-18,
1.972489930973562e-18,
1.135456397964542e-18,
5.228969171769672e-19,
2.006691295595673e-19,
6.60083583915324e-20,
1.899786914138696e-20,
4.859046370546689e-21,
1.123763125579092e-21,
2.425583766955379e-22,
3.19052576569221e-23,
-1.35652281647324e-23,
1.602159250025949e-23,
2.245505682692115e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=26
0.00720269253245241,
-2.13409690937176e-10,
-2.45696979945292e-10,
-1.88579391036488e-10,
-1.085550120311293e-10,
-4.99914197825192e-11,
-1.91849081081548e-11,
-6.31069222216051e-12,
-1.816360087650648e-12,
-4.6470103924397e-13,
-1.07000876879499e-13,
-2.23977316694656e-14,
-4.29646140899889e-15,
-7.61003570457849e-16,
-1.279660567572068e-16,
-1.958812701217901e-17,
-0.01386326778928363,
3.94737999519453e-10,
4.54458904986002e-10,
3.48810082070427e-10,
2.007912031733827e-10,
9.24677472344513e-11,
3.54857948053299e-11,
1.167271356114361e-11,
3.35967145149398e-12,
8.59544889955148e-13,
1.979166705185043e-13,
4.14285103915925e-14,
7.94706333179848e-15,
1.407613473952444e-15,
2.366975195382488e-16,
3.623229886779554e-17,
0.01336042758924013,
-3.66138737076189e-10,
-4.21532788567498e-10,
-3.23538355737999e-10,
-1.862436303320434e-10,
-8.57683444252571e-11,
-3.291480554885308e-11,
-1.082701152656339e-11,
-3.116259442858469e-12,
-7.97269989461926e-13,
-1.835774536836523e-13,
-3.84270022416329e-14,
-7.37130366675791e-15,
-1.305635444816815e-15,
-2.195504092149483e-16,
-3.360780731922516e-17,
-0.0085951663372344,
2.27023830891372e-10,
2.613708381682398e-10,
2.006095223640349e-10,
1.154801129446118e-10,
5.31805472056092e-11,
2.040878144376422e-11,
6.71327430901601e-12,
1.932232698330636e-12,
4.94346300023455e-13,
1.138270067843886e-13,
2.38266335513011e-14,
4.570575533917843e-15,
8.09560557477566e-16,
1.361330379957881e-16,
2.083881067360862e-17,
0.004152224492039111,
-1.058416615470661e-10,
-1.218547132554837e-10,
-9.35269444643786e-11,
-5.38384320940032e-11,
-2.479350968847874e-11,
-9.51485748071424e-12,
-3.129821847049199e-12,
-9.00833805797413e-13,
-2.304711581383107e-13,
-5.30677540181973e-14,
-1.110831708595085e-14,
-2.130869493417065e-15,
-3.774296934070011e-16,
-6.346758908234886e-17,
-9.71548775491903e-18,
-0.001606547190294296,
3.95690983327564e-11,
4.55556069745206e-11,
3.496521896056818e-11,
2.012759620724623e-11,
9.26909895682829e-12,
3.557146922093645e-12,
1.170089668409423e-12,
3.3677839651105e-13,
8.61620806391658e-14,
1.983948479061998e-14,
4.152868010171128e-15,
7.96630746496602e-16,
1.411032399406236e-16,
2.372763991898048e-17,
3.632203233963549e-18,
0.000518548287775165,
-1.235469619647582e-11,
-1.422386934123758e-11,
-1.091722270328534e-11,
-6.28445802610765e-12,
-2.894099378859408e-12,
-1.11065130153942e-12,
-3.65338197322551e-13,
-1.051526404076767e-13,
-2.690247129973754e-14,
-6.19450305845761e-15,
-1.296654811314608e-15,
-2.487331332021588e-16,
-4.405692915232152e-17,
-7.40855130236427e-18,
-1.13410096339188e-18,
-0.0001436063246718495,
3.31328263861966e-12,
3.81455752741198e-12,
2.927780978594211e-12,
1.685366069829929e-12,
7.76139629347784e-13,
2.978544915971499e-13,
9.7976408347103e-14,
2.819983940987885e-14,
7.21470649811959e-15,
1.661242528429688e-15,
3.477371575712753e-16,
6.67053506954141e-17,
1.181522148132045e-17,
1.986837536180407e-18,
3.041470566909987e-19,
0.00003483173887542352,
-7.78996294833145e-13,
-8.96852610032646e-13,
-6.88359789258793e-13,
-3.962517156043773e-13,
-1.824806294545806e-13,
-7.00295070952335e-14,
-2.303554225442003e-14,
-6.63015342567947e-15,
-1.696272603125908e-15,
-3.905800824461848e-16,
-8.17576302621979e-17,
-1.568332563099794e-17,
-2.777922329136062e-18,
-4.67134179391544e-19,
-7.150865889365867e-20,
-7.51639234346067e-6,
1.630993554695889e-13,
1.877750686459197e-13,
1.44122685705208e-13,
8.29636804754737e-14,
3.820618085195124e-14,
1.466215919625388e-14,
4.822978317866363e-15,
1.388163001224031e-15,
3.551506129195371e-16,
8.17762293248125e-17,
1.711769999298342e-17,
3.283640249791492e-18,
5.816193012429601e-19,
9.78047641079967e-20,
1.497087162312136e-20,
1.460998923827838e-6,
-3.07863863076442e-14,
-3.544413642204251e-14,
-2.72043790284567e-14,
-1.566009822404385e-14,
-7.2117406585402e-15,
-2.767606922114769e-15,
-9.10378085933628e-16,
-2.62027556229933e-16,
-6.70376990051985e-17,
-1.543596147497862e-17,
-3.231115262988517e-18,
-6.198150158645901e-19,
-1.097797228321752e-19,
-1.846227953601961e-20,
-2.832316770105403e-21,
-2.583689865838476e-7,
5.29147873934447e-15,
6.09203992113288e-15,
4.67581326506957e-15,
2.69161428352621e-15,
1.239534003699508e-15,
4.756886140371957e-16,
1.564732672451095e-16,
4.503657312255938e-17,
1.152225522184126e-17,
2.653091252118722e-18,
5.553568105544689e-19,
1.065311554211776e-19,
1.88648616043585e-20,
3.174761912219652e-21,
4.910769653574658e-22,
4.190906158403986e-8,
-8.34872473831156e-16,
-9.61182439310433e-16,
-7.37734759238424e-16,
-4.246742346043854e-16,
-1.955696845898533e-16,
-7.50526187066164e-17,
-2.468784882819179e-17,
-7.10572606387699e-18,
-1.817945875391431e-18,
-4.185955403288926e-19,
-8.76157421476601e-20,
-1.681027380300677e-20,
-2.993955792814107e-21,
-4.985906074513655e-22,
-5.9146860178633e-23,
-6.280498464320895e-9,
1.217861752990837e-16,
1.402115134637173e-16,
1.076163098672635e-16,
6.1948923430685e-17,
2.852852958172371e-17,
1.094822479218852e-17,
3.601314970901279e-18,
1.036540736254439e-18,
2.65191476567941e-19,
6.106126582590535e-20,
1.277847760290272e-20,
2.455883919160254e-21,
4.435538014120124e-22,
6.76471592931841e-23,
8.578061048192e-25,
8.885975737619643e-10,
-1.677124791012325e-17,
-1.930861238963601e-17,
-1.481990718659847e-17,
-8.53102376698191e-18,
-3.928681094079417e-18,
-1.507686700570354e-18,
-4.959394400621506e-19,
-1.427424850021475e-19,
-3.651816925789602e-20,
-8.40978990624046e-21,
-1.767441325535257e-21,
-3.353403543595206e-22,
-4.09776814533349e-23,
-1.252626285274518e-23,
-2.116307031420134e-23,
-1.153445234191614e-10,
2.122240216821666e-18,
2.443319303454646e-18,
1.87531680724645e-18,
1.079519060676151e-18,
4.971368306955452e-19,
1.907832655195844e-19,
6.275639830401839e-20,
1.806255387191332e-20,
4.620768242787674e-21,
1.065436317136562e-21,
2.251214236454531e-22,
3.77395443214497e-23,
7.9491538364475e-25,
7.905406763002313e-24,
7.88232490179528e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=27
0.00693163389464181,
-1.97368999759726e-10,
-2.27229452493001e-10,
-1.74405041035214e-10,
-1.003956015866913e-10,
-4.62338736172257e-11,
-1.774289740266497e-11,
-5.83635678057181e-12,
-1.679835725746992e-12,
-4.29772444977574e-13,
-9.89583352592521e-14,
-2.071425519579626e-14,
-3.97353166589924e-15,
-7.03806736976221e-16,
-1.183487597691241e-16,
-1.811614943389928e-17,
-0.01336042758924013,
3.66138737076189e-10,
4.21532788567498e-10,
3.23538355737999e-10,
1.862436303320434e-10,
8.57683444252571e-11,
3.29148055488531e-11,
1.082701152656338e-11,
3.116259442858469e-12,
7.97269989461926e-13,
1.835774536836523e-13,
3.84270022416329e-14,
7.37130366675791e-15,
1.305635444816876e-15,
2.195504092149459e-16,
3.360780731915916e-17,
0.01289274950585161,
-3.40535746337059e-10,
-3.9205625725236e-10,
-3.00914283546052e-10,
-1.732201694169177e-10,
-7.97708208084137e-11,
-3.061317216564633e-11,
-1.006991146352401e-11,
-2.898349047495954e-12,
-7.41519450035183e-13,
-1.70740510176583e-13,
-3.573995032695144e-14,
-6.85586330087671e-15,
-1.214340836216908e-15,
-2.04199556993747e-16,
-3.125821600982356e-17,
-0.00830444898407879,
2.11683323094142e-10,
2.437094265109789e-10,
1.870538889287661e-10,
1.076768641880116e-10,
4.95870193769598e-11,
1.902971496142939e-11,
6.2596436940987e-12,
1.801667611594913e-12,
4.609423162766429e-13,
1.061355080363998e-13,
2.221663417190559e-14,
4.261738986833797e-15,
7.54859386806523e-16,
1.269351781652723e-16,
1.943097551784796e-17,
0.004016367975735545,
-9.89227458318876e-11,
-1.138890174362977e-10,
-8.74130474014175e-11,
-5.03189905181138e-11,
-2.317274739206993e-11,
-8.89286730523381e-12,
-2.925224171023456e-12,
-8.41945991277596e-13,
-2.15405201597905e-13,
-4.959871197654756e-14,
-1.038217002543863e-14,
-1.991576866242813e-15,
-3.527580998217378e-16,
-5.931909979630986e-17,
-9.08050811682727e-18,
-0.001555644863298463,
3.70640885889423e-11,
4.26716080231542e-11,
3.275166810942731e-11,
1.885337407807619e-11,
8.68229813646458e-12,
3.331953904574647e-12,
1.096014591953305e-12,
3.154579212189025e-13,
8.07074138981752e-14,
1.858350917512074e-14,
3.889964433794825e-15,
7.46199399620214e-16,
1.321707877144293e-16,
2.222565388196239e-17,
3.402302615486656e-18,
0.0005026221363566476,
-1.159648923525944e-11,
-1.335095134604627e-11,
-1.024723342515983e-11,
-5.89878124445085e-12,
-2.716488702738476e-12,
-1.042490720598173e-12,
-3.429174292175364e-13,
-9.86994379353457e-14,
-2.525147274365727e-14,
-5.81434884954979e-15,
-1.2170800512917e-15,
-2.334687274534228e-16,
-4.135327577153772e-17,
-6.953931340774849e-18,
-1.064514063111548e-18,
-0.0001393269560682086,
3.1159851894996e-12,
3.5874104518358e-12,
2.75343916601926e-12,
1.585006867589165e-12,
7.29922520199956e-13,
2.801180292949231e-13,
9.21421693183565e-14,
2.652061378922237e-14,
6.78509043436303e-15,
1.562320335033161e-15,
3.270305235530393e-16,
6.27333023279544e-17,
1.111168557198136e-17,
1.868537146389123e-18,
2.860386260838995e-19,
0.00003382376548051604,
-7.33947098473632e-13,
-8.44987807594721e-13,
-6.48552084666502e-13,
-3.733365615599942e-13,
-1.719278135668451e-13,
-6.5979716280701e-14,
-2.17034023967417e-14,
-6.2467334958044e-15,
-1.598177755280484e-15,
-3.679930315450403e-16,
-7.70296518393978e-17,
-1.477638038567675e-17,
-2.617281424622339e-18,
-4.401224860351501e-19,
-6.737485800694924e-20,
-7.304988575248318e-6,
1.539318230716703e-13,
1.772205572334833e-13,
1.360217992958546e-13,
7.83004359465845e-14,
3.605867788431731e-14,
1.383802485972137e-14,
4.551887222017812e-15,
1.310136858203114e-15,
3.351882608038246e-16,
7.71797517856674e-17,
1.615555485871963e-17,
3.099076094531438e-18,
5.489246463399011e-19,
9.23079642081399e-20,
1.413377287481692e-20,
1.421029842606636e-6,
-2.9103140359822e-14,
-3.350622796309937e-14,
-2.57169794027167e-14,
-1.480388226933776e-14,
-6.81743872885131e-15,
-2.616288032865919e-15,
-8.60603185338721e-16,
-2.477012144057101e-16,
-6.33724213201179e-17,
-1.459200379621546e-17,
-3.054454067881212e-18,
-5.859284010805153e-19,
-1.037819783219092e-19,
-1.745168960299976e-20,
-2.673063788579178e-21,
-2.514886599816009e-7,
5.00985023194334e-15,
5.7678031285701e-15,
4.42695234366298e-15,
2.548358437270749e-15,
1.173562262963928e-15,
4.503710340161241e-16,
1.481452911936573e-16,
4.263959318368296e-17,
1.090900886043182e-17,
2.511886358776995e-18,
5.257918388840875e-19,
1.008619465697139e-19,
1.787998991255812e-20,
3.004593459433389e-21,
4.452878046288115e-22,
4.082192765932459e-8,
-7.91587152724659e-16,
-9.11348373075787e-16,
-6.99485701932073e-16,
-4.026563096567472e-16,
-1.854300575926565e-16,
-7.11613947244961e-17,
-2.34078679745973e-17,
-6.73731835542217e-18,
-1.723690812250918e-18,
-3.968940118395554e-19,
-8.30777509185687e-20,
-1.593552319480004e-20,
-2.827034897807385e-21,
-4.762893366611443e-22,
-6.82491672099572e-23,
-6.121695163331303e-9,
1.156312483823455e-16,
1.331253921638871e-16,
1.021775110591623e-16,
5.881809949179e-17,
2.708673215177238e-17,
1.039491479764488e-17,
3.419309325411984e-18,
9.84155358854281e-19,
2.517854714836794e-19,
5.797547473757735e-20,
1.215056301359947e-20,
2.329756259447829e-21,
3.75401206210039e-22,
6.798638974408e-23,
4.77527590473889e-23,
8.666992230645164e-10,
-1.594509442109413e-17,
-1.835746805941976e-17,
-1.408987697118958e-17,
-8.11078463755978e-18,
-3.735153869073736e-18,
-1.433417889218349e-18,
-4.715093085228756e-19,
-1.357112085661959e-19,
-3.472030296269808e-20,
-7.99423950643938e-21,
-1.675342616320076e-21,
-3.224359444656939e-22,
-5.1857931214757e-23,
-7.919632769548849e-24,
-6.758213241539178e-24,
-1.125700631330055e-10,
2.020199230599869e-18,
2.32584027950636e-18,
1.785148327947182e-18,
1.02761391535851e-18,
4.732336547797442e-19,
1.816100988564935e-19,
5.973859022997596e-20,
1.719399697399712e-20,
4.402053394944624e-21,
1.013949473103621e-21,
1.970114482680379e-22,
3.835431828086392e-23,
4.48955610726233e-23,
3.161502795342911e-24,
-3.773371806819803e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=28
0.00668021379462007,
-1.83069368538094e-10,
-2.10766394283749e-10,
-1.61769177868999e-10,
-9.31218151660217e-11,
-4.28841722126285e-11,
-1.645740277442654e-11,
-5.41350576328169e-12,
-1.558129721429234e-12,
-3.98634994730963e-13,
-9.17887268418261e-14,
-1.921350112081643e-14,
-3.68565183337896e-15,
-6.5281772240844e-16,
-1.097752046074731e-16,
-1.68039036595774e-17,
-0.0128927495058516,
3.40535746337059e-10,
3.9205625725236e-10,
3.00914283546052e-10,
1.732201694169177e-10,
7.97708208084137e-11,
3.06131721656463e-11,
1.006991146352401e-11,
2.898349047495954e-12,
7.41519450035183e-13,
1.70740510176583e-13,
3.57399503269514e-14,
6.8558633008767e-15,
1.214340836216906e-15,
2.041995569937575e-16,
3.125821600982516e-17,
0.01245667347611818,
-3.17524984641214e-10,
-3.65564139766468e-10,
-2.805808333931492e-10,
-1.615152962820174e-10,
-7.43805290654398e-11,
-2.854457244214409e-11,
-9.38946554114805e-12,
-2.70250141739237e-12,
-6.91413474414964e-13,
-1.592032620545998e-13,
-3.332495125785872e-14,
-6.39260848025071e-15,
-1.132289080208988e-15,
-1.904027672479046e-16,
-2.91464632775635e-17,
-0.00803273595147164,
1.978454916637849e-10,
2.277780348726065e-10,
1.748260948028434e-10,
1.006379810362326e-10,
4.63454947841421e-11,
1.778573461046848e-11,
5.8504483420472e-12,
1.683891982555274e-12,
4.308104031958309e-13,
9.91974239530996e-14,
2.076434005087847e-14,
3.983153732486798e-15,
7.05516199642971e-16,
1.186381995914978e-16,
1.816101623422778e-17,
0.003889112158245967,
-9.26602214723525e-11,
-1.066790200578817e-10,
-8.18791702735654e-11,
-4.71334351951888e-11,
-2.170574534116069e-11,
-8.32988476143633e-12,
-2.740036479883166e-12,
-7.88644803047229e-13,
-2.017685347454348e-13,
-4.645877293780051e-14,
-9.72491108446753e-15,
-1.865498499050271e-15,
-3.304269693336702e-16,
-5.556413470447603e-17,
-8.50575649136313e-18,
-0.001507866409043545,
3.4789467705316e-11,
4.00528540376065e-11,
3.074170027507092e-11,
1.769634373311737e-11,
8.14946610810712e-12,
3.127472161752954e-12,
1.028752287638936e-12,
2.960983138021004e-13,
7.57544182299676e-14,
1.744304654842698e-14,
3.651240153812199e-15,
7.00406182322566e-16,
1.240598273515033e-16,
2.086179405483223e-17,
3.193542149112161e-18,
0.000487644346243786,
-1.090594816333509e-11,
-1.255593658152487e-11,
-9.63703708114382e-12,
-5.54752403660607e-12,
-2.554728820720104e-12,
-9.80413102540004e-13,
-3.224975926168153e-13,
-9.28221482630174e-14,
-2.374781652036562e-14,
-5.468121172649417e-15,
-1.144606832900354e-15,
-2.195665581599023e-16,
-3.889089836842814e-17,
-6.539880018762353e-18,
-1.001136322269943e-18,
-0.0001352950624752714,
2.93578840358415e-12,
3.37995124153447e-12,
2.594208347228241e-12,
1.493346251168794e-12,
6.87711256537184e-13,
2.639188659938718e-13,
8.68136098735016e-14,
2.498693406570527e-14,
6.39271104216823e-15,
1.471972130923781e-15,
3.081186086608866e-16,
5.910552208563851e-17,
1.04691249757644e-17,
1.760489546211464e-18,
2.695002166614322e-19,
0.00003287244852505361,
-6.92693202735281e-13,
-7.97492506298949e-13,
-6.1209809587061e-13,
-3.523519612065862e-13,
-1.622640502247485e-13,
-6.22711117710128e-14,
-2.048349246681215e-14,
-5.89561585261377e-15,
-1.508347172329593e-15,
-3.473088826634282e-16,
-7.26999914563493e-17,
-1.394584213743174e-17,
-2.470174119540944e-18,
-4.153859124945606e-19,
-6.358875756444233e-20,
-7.105143311111251e-6,
1.4551559842565e-13,
1.675310208024047e-13,
1.285848056676624e-13,
7.40193587637529e-14,
3.408716942892429e-14,
1.308143087136061e-14,
4.303012869815558e-15,
1.23850519210301e-15,
3.168618819486701e-16,
7.29599678006831e-17,
1.527225712501644e-17,
2.929637920406619e-18,
5.189157069976025e-19,
8.72607369687584e-20,
1.335896412227567e-20,
1.383188036737344e-6,
-2.75541832344875e-14,
-3.172292521874896e-14,
-2.434824403928771e-14,
-1.401597494472118e-14,
-6.4545940763683e-15,
-2.477041312621587e-15,
-8.14799308046301e-16,
-2.345178220902034e-16,
-5.99995573958935e-17,
-1.381537702601088e-17,
-2.891887749092275e-18,
-5.547435221483949e-19,
-9.82601271883467e-20,
-1.652367196808954e-20,
-2.529146391924355e-21,
-2.449650509670183e-7,
4.75010940965236e-15,
5.46876546381415e-15,
4.197432466191943e-15,
2.416236189250558e-15,
1.112717732178179e-15,
4.270210923896889e-16,
1.404645510839042e-16,
4.042890207990209e-17,
1.034342034601356e-17,
2.381656609468773e-18,
4.985364980768726e-19,
9.56298402026983e-20,
1.694265610499356e-20,
2.852197927324805e-21,
4.313552738001782e-22,
3.97897363235186e-8,
-7.51581182412027e-16,
-8.65289798833392e-16,
-6.64134441613092e-16,
-3.823064905094464e-16,
-1.76058621492298e-16,
-6.75649747031652e-17,
-2.222485996593426e-17,
-6.39682189364699e-18,
-1.636577219878744e-18,
-3.768351085250085e-19,
-7.88807253018074e-20,
-1.513156453201008e-20,
-2.679765247878584e-21,
-4.503925503835888e-22,
-6.958610108413105e-23,
-5.970720125935374e-9,
1.0993116603922e-16,
1.26562930013408e-16,
9.71406354725012e-17,
5.59186411256244e-17,
2.575148251802543e-17,
9.88249398203062e-18,
3.250753081020494e-18,
9.35641519656547e-19,
2.393760823489798e-19,
5.511522467274461e-20,
1.154107980970867e-20,
2.221878295594968e-21,
3.79658922749931e-22,
5.65191079497299e-23,
2.61945180721329e-23,
8.458536974768422e-10,
-1.517848893485489e-17,
-1.747488089868198e-17,
-1.341246632462094e-17,
-7.72083576183794e-18,
-3.555575811808739e-18,
-1.364502290623527e-18,
-4.488401477069491e-19,
-1.29186477506015e-19,
-3.305135379767129e-20,
-7.61024312742903e-21,
-1.593009236367701e-21,
-3.056315953427129e-22,
-5.427444780402751e-23,
-9.30406627428273e-24,
-1.099960142496983e-24,
-1.099258765858544e-10,
1.925341535708214e-18,
2.216631325028557e-18,
1.701327362273632e-18,
9.79362692115815e-19,
4.510131310524613e-19,
1.730826972229161e-19,
5.693387255526648e-20,
1.638629685540459e-20,
4.193101207812178e-21,
9.6855147020404e-22,
1.971929606058523e-22,
2.99215344808699e-23,
2.32686455146496e-23,
1.080018523387574e-23,
-2.053286300581792e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=29
0.0064463747529258,
-1.70267873168529e-10,
-1.9602812862618e-10,
-1.50457141773026e-10,
-8.66100847084588e-11,
-3.98854104042069e-11,
-1.530658608282316e-11,
-5.034955731762e-12,
-1.449174523747977e-12,
-3.70759725017591e-13,
-8.53702550882915e-14,
-1.786997516347572e-14,
-3.42793165043835e-15,
-6.07170418108452e-16,
-1.020997784968788e-16,
-1.562910800491381e-17,
-0.01245667347611818,
3.17524984641214e-10,
3.65564139766468e-10,
2.80580833393149e-10,
1.615152962820174e-10,
7.43805290654398e-11,
2.854457244214408e-11,
9.38946554114805e-12,
2.702501417392369e-12,
6.91413474414964e-13,
1.592032620545998e-13,
3.332495125785872e-14,
6.3926084802507e-15,
1.13228908020897e-15,
1.90402767247907e-16,
2.914646327758196e-17,
0.01204910392720746,
-2.96768237495677e-10,
-3.4166705230891e-10,
-2.622391422042652e-10,
-1.509569715543489e-10,
-6.95182421762132e-11,
-2.667860191570272e-11,
-8.7756725130708e-12,
-2.525837973832912e-12,
-6.46215604793746e-13,
-1.487961359296494e-13,
-3.114651007631766e-14,
-5.9747305987303e-15,
-1.058274299464586e-15,
-1.779572993871377e-16,
-2.724152435120898e-17,
-0.00777822431649247,
1.853204429447143e-10,
2.13358040115774e-10,
1.637583405471389e-10,
9.42668703903823e-11,
4.34114906823235e-11,
1.665976952287348e-11,
5.4800729597666e-12,
1.577289606094535e-12,
4.035370694908897e-13,
9.29175458756057e-14,
1.944982216893557e-14,
3.73099699810058e-15,
6.60853938668599e-16,
1.111282694092119e-16,
1.701151298138793e-17,
0.003769666022608678,
-8.69736692632868e-11,
-1.001321350940127e-10,
-7.68542506876746e-11,
-4.42408593327919e-11,
-2.037366527026707e-11,
-7.81868040438211e-12,
-2.57188071909725e-12,
-7.40245784505224e-13,
-1.893860455749119e-13,
-4.360761637106928e-14,
-9.12810038453123e-15,
-1.751015455797067e-15,
-3.101495683773194e-16,
-5.215448514710134e-17,
-7.98385537298142e-18,
-0.001462933038705566,
3.27178444895641e-11,
3.76678097440667e-11,
2.891111124304165e-11,
1.66425721095938e-11,
7.66418646205697e-12,
2.941239307580355e-12,
9.67492777837401e-13,
2.784664447852976e-13,
7.12434495601349e-14,
1.640436351772494e-14,
3.433820498662255e-15,
6.58699674480001e-16,
1.166726950824183e-16,
1.961964004227278e-17,
3.003408991316579e-18,
0.0004735327186683921,
-1.027525941262714e-11,
-1.182982934546576e-11,
-9.07972921537183e-12,
-5.22671187913279e-12,
-2.406989397899493e-12,
-9.23716030985975e-13,
-3.038476345596971e-13,
-8.74542692306883e-14,
-2.237448864777174e-14,
-5.15190245818189e-15,
-1.078415130330207e-15,
-2.068693275564525e-16,
-3.664193733833186e-17,
-6.161713135161279e-18,
-9.4325089244589e-19,
-0.0001314897946407249,
2.77077282018619e-12,
3.189970035839568e-12,
2.448392391651837e-12,
1.409407849529027e-12,
6.49056203064659e-13,
2.490844479151557e-13,
8.19339701406321e-14,
2.358246348913911e-14,
6.03338870945294e-15,
1.389235535319571e-15,
2.907999667764132e-16,
5.57833685985087e-17,
9.88069658336267e-18,
1.661543864569554e-18,
2.543549237535714e-19,
0.00003197314483786301,
-6.54820191876956e-13,
-7.53889592415239e-13,
-5.78631624586838e-13,
-3.330871139086496e-13,
-1.533922621868959e-13,
-5.88664388277866e-14,
-1.936355788346852e-14,
-5.57327335541913e-15,
-1.425878466528141e-15,
-3.283198557188677e-16,
-6.87251564790984e-17,
-1.31833674925175e-17,
-2.335122774233158e-18,
-3.926767148464845e-19,
-6.01123134810221e-20,
-6.91593441722023e-6,
1.377708175417337e-13,
1.586145125409521e-13,
1.21741133041452e-13,
7.00798245531655e-14,
3.227294727750297e-14,
1.238519769649433e-14,
4.073993623634522e-15,
1.172588270995033e-15,
2.999975722997212e-16,
6.90768355068733e-17,
1.44594279202343e-17,
2.773716497106803e-18,
4.913014179982441e-19,
8.26169058546768e-20,
1.264472562320588e-20,
1.347308178028865e-6,
-2.612560839976221e-14,
-3.007821770324413e-14,
-2.308588443738678e-14,
-1.328930242184443e-14,
-6.11994908397479e-15,
-2.348616605542032e-15,
-7.7255522749781e-16,
-2.223590192718102e-16,
-5.688882586630497e-17,
-1.309910771927116e-17,
-2.741956718835735e-18,
-5.259834485446589e-19,
-9.3164625684266e-20,
-1.566620396664237e-20,
-2.399409428880984e-21,
-2.3877113444031e-7,
4.51004667973674e-15,
5.19238303933478e-15,
3.985301126998861e-15,
2.294123587066819e-15,
1.056482812345541e-15,
4.054401533090255e-16,
1.333657072562736e-16,
3.838569408807141e-17,
9.82068101934712e-18,
2.261291679926335e-18,
4.733474084475623e-19,
9.07979421067912e-20,
1.606934228607461e-20,
2.707248229685155e-21,
4.28907477205829e-22,
3.880842735006606e-8,
-7.14531630904545e-16,
-8.22634927408114e-16,
-6.3139561956949e-16,
-3.634605115117398e-16,
-1.673797291852643e-16,
-6.42343280416322e-17,
-2.112927548868969e-17,
-6.0814877974444e-18,
-1.555901763521864e-18,
-3.582593745518517e-19,
-7.49911687844471e-20,
-1.438405401825892e-20,
-2.550649385815437e-21,
-4.303305222662385e-22,
-6.29751494289715e-23,
-5.82700872635959e-9,
1.046422110634307e-16,
1.204737957207411e-16,
9.24670524183254e-17,
5.32283107205984e-17,
2.451253983412759e-17,
9.4070323737446e-18,
3.094354257757265e-18,
8.90626137636635e-19,
2.278622923713576e-19,
5.246499717722792e-20,
1.096859644810007e-20,
2.111606424851397e-21,
4.11016096683493e-22,
5.68087908067921e-23,
-3.1058406723869e-23,
8.259868877891618e-10,
-1.446584542793271e-17,
-1.665441976050271e-17,
-1.278273915943687e-17,
-7.35833570069061e-18,
-3.388638394959294e-18,
-1.300437712680145e-18,
-4.277667383094918e-19,
-1.231211124954193e-19,
-3.149936457963406e-20,
-7.25252203944763e-21,
-1.519238585347206e-21,
-2.928266717361135e-22,
-4.901489332056242e-23,
-6.750918343229144e-24,
-3.958488733715843e-24,
-1.074030028723318e-10,
1.837008646468473e-18,
2.114934330369998e-18,
1.623272038080648e-18,
9.34430441720962e-19,
4.303210572249346e-19,
1.651417889067572e-19,
5.432209253514311e-20,
1.563485985786526e-20,
3.997311391224232e-21,
9.22375858770349e-22,
2.08050699721493e-22,
3.276884376149738e-23,
-3.48336081098882e-23,
6.371494430075377e-24,
4.453538471403286e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=30
0.00622833673805909,
-1.58762492320607e-10,
-1.82782069883234e-10,
-1.402904166965746e-10,
-8.07576481410087e-11,
-3.71902645327199e-11,
-1.427228622107204e-11,
-4.69473277057402e-12,
-1.351250708696185e-12,
-3.45706737207482e-13,
-7.96016310272999e-14,
-1.666247562892936e-14,
-3.19630424012535e-15,
-5.66144540104484e-16,
-9.52013836239537e-17,
-1.457323163879193e-17,
-0.01204910392720746,
2.96768237495677e-10,
3.4166705230891e-10,
2.62239142204265e-10,
1.509569715543489e-10,
6.95182421762132e-11,
2.667860191570272e-11,
8.7756725130708e-12,
2.525837973832912e-12,
6.46215604793746e-13,
1.487961359296494e-13,
3.114651007631764e-14,
5.97473059873029e-15,
1.058274299464622e-15,
1.779572993871507e-16,
2.724152435117234e-17,
0.01166733647473871,
-2.77980664417071e-10,
-3.20037060173661e-10,
-2.456375108207084e-10,
-1.414003055855735e-10,
-6.51172360234853e-11,
-2.498965428431022e-11,
-8.22010943964991e-12,
-2.365934409141803e-12,
-6.05305604236335e-13,
-1.393763188134085e-13,
-2.917473325340322e-14,
-5.59649549715101e-15,
-9.9128090800329e-16,
-1.666924041136563e-16,
-2.551726947164984e-17,
-0.00753933204521788,
1.739473385265823e-10,
2.002642701880355e-10,
1.537085013753569e-10,
8.84817186655882e-11,
4.07473305405362e-11,
1.5637360808765e-11,
5.14376143819476e-12,
1.480491569010523e-12,
3.787720911498427e-13,
8.72152327421426e-14,
1.825620076906462e-14,
3.502030911595406e-15,
6.20299136751548e-16,
1.043089702929193e-16,
1.59677107491409e-17,
0.003657332596763734,
-8.17946112239074e-11,
-9.41695243601634e-11,
-7.22777781076015e-11,
-4.1606430273983e-11,
-1.916046615514174e-11,
-7.35309826895062e-12,
-2.418731944593415e-12,
-6.96166111963218e-13,
-1.781086239003287e-13,
-4.101090879431416e-14,
-8.58455124666672e-15,
-1.64674918619027e-15,
-2.916817376743846e-16,
-4.904910011682567e-17,
-7.50852251281784e-18,
-0.001420598155979963,
3.082577823746e-11,
3.54894880359122e-11,
2.723918764574315e-11,
1.568013563718405e-11,
7.22096819359977e-12,
2.771148092920046e-12,
9.1154290366663e-13,
2.623628076884768e-13,
6.7123465942405e-14,
1.545570737434501e-14,
3.235245390910372e-15,
6.20607982628479e-16,
1.099258121049845e-16,
1.8485139443876e-17,
2.829752583885698e-18,
0.0004602142812473708,
-9.69770487073063e-12,
-1.116489512552941e-11,
-8.56937337085121e-12,
-4.93292747339177e-12,
-2.271696710744806e-12,
-8.71795567710144e-13,
-2.867688954945421e-13,
-8.25386222126714e-14,
-2.111686048331685e-14,
-4.86232437358402e-15,
-1.017799883395122e-15,
-1.952417903164631e-16,
-3.458243895196245e-17,
-5.815403269339002e-18,
-8.90241247071783e-19,
-0.0001278925798798351,
2.61928077633822e-12,
3.015558379827327e-12,
2.314526506150329e-12,
1.332348460126353e-12,
6.13569050816112e-13,
2.354657561049719e-13,
7.7454231795007e-14,
2.229309349685429e-14,
5.70351388524147e-15,
1.313279427169879e-15,
2.749006273370339e-16,
5.273347056104757e-17,
9.34048986837153e-18,
1.570706365574739e-18,
2.404505456856106e-19,
0.00003112170481671703,
-6.19968677944891e-13,
-7.13765305291154e-13,
-5.47835097809149e-13,
-3.15359209984181e-13,
-1.452282625161698e-13,
-5.57333895449751e-14,
-1.833297127706804e-14,
-5.276647210901719e-15,
-1.349989072393559e-15,
-3.108457600446837e-16,
-6.50674299061368e-17,
-1.248172192229377e-17,
-2.210844415783875e-18,
-3.717787886622078e-19,
-5.691417752389263e-20,
-6.736535253057781e-6,
1.306279477919257e-13,
1.503909800565373e-13,
1.154293389410529e-13,
6.64464641890436e-14,
3.059972335182341e-14,
1.174307455879208e-14,
3.862773351638255e-15,
1.111794294429216e-15,
2.844439249017624e-16,
6.54954921534888e-17,
1.370977017661458e-17,
2.629912833587299e-18,
4.6583183431268e-19,
7.83340482770171e-20,
1.198774634580731e-20,
1.313241628404158e-6,
-2.480526309363191e-14,
-2.855811403289718e-14,
-2.191916181415742e-14,
-1.261768296150527e-14,
-5.81065695660605e-15,
-2.229921414450714e-15,
-7.33511577340485e-16,
-2.111213722100375e-16,
-5.401376471887967e-17,
-1.243710348944122e-17,
-2.603382493475607e-18,
-4.99400863465636e-19,
-8.84602828672105e-20,
-1.487539395567357e-20,
-2.274093193082588e-21,
-2.328825465570728e-7,
4.28772427213283e-15,
4.93642491499986e-15,
3.788846016405405e-15,
2.181034946207103e-15,
1.004403579128276e-15,
3.854540170423811e-16,
1.267914584255413e-16,
3.649347617517826e-17,
9.33657175677397e-18,
2.149822186098932e-18,
4.500165289056921e-19,
8.63218763666867e-20,
1.527132359718947e-20,
2.573699833116132e-21,
4.13430710067147e-22,
3.78743307603036e-8,
-6.80154342578847e-16,
-7.83056612562852e-16,
-6.01018141806843e-16,
-3.459738313664865e-16,
-1.593268169591708e-16,
-6.11439099771932e-17,
-2.011271200322571e-17,
-5.788897846312156e-18,
-1.481044150483626e-18,
-3.410223628662101e-19,
-7.13873848817485e-20,
-1.369406787468291e-20,
-2.416990620320137e-21,
-4.071204231739245e-22,
-7.142834270737256e-23,
-5.690049337541933e-9,
9.97257929021729e-17,
1.14813560271816e-16,
8.81226613703905e-17,
5.07274784457224e-17,
2.336086424136143e-17,
8.96506066892443e-18,
2.948971735232023e-18,
8.48782039793042e-19,
2.171578589171055e-19,
4.999890685091302e-20,
1.044809140250953e-20,
2.014643798513507e-21,
4.0317695367687e-22,
5.26509886826817e-23,
-4.01296081367488e-23,
8.070314778343065e-10,
-1.380221760517897e-17,
-1.589039001236173e-17,
-1.219632468384916e-17,
-7.02076842466924e-18,
-3.233182952935315e-18,
-1.240779510019926e-18,
-4.081426497635679e-19,
-1.174727709450032e-19,
-3.005519359041545e-20,
-6.920526880042858e-21,
-1.444934804883235e-21,
-2.770927351362474e-22,
-5.895560157793998e-23,
-9.26993280819423e-24,
8.993086775005658e-24,
-1.049932841633921e-10,
1.754615809798844e-18,
2.020076073831817e-18,
1.550465639197041e-18,
8.92519711310363e-19,
4.110204472609638e-19,
1.577349492219346e-19,
5.188580299912478e-20,
1.493325812780346e-20,
3.816983268306311e-21,
8.82679165124636e-22,
2.02847920547698e-22,
2.75161808326895e-23,
-4.18353115366016e-23,
9.27396037702322e-24,
4.986726275267988e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=31
0.00602455196360373,
-1.48384118747839e-10,
-1.70833526154455e-10,
-1.311195711021326e-10,
-7.54784857771744e-11,
-3.47591210881066e-11,
-1.333930095785136e-11,
-4.3878362565354e-12,
-1.262918986916456e-12,
-3.23107802396873e-13,
-7.43980679648247e-14,
-1.557325503815882e-14,
-2.98736529936514e-15,
-5.29137149732307e-16,
-8.89786496935753e-17,
-1.362076217559012e-17,
-0.01166733647473871,
2.77980664417071e-10,
3.20037060173661e-10,
2.45637510820708e-10,
1.414003055855735e-10,
6.51172360234853e-11,
2.498965428431022e-11,
8.22010943964991e-12,
2.365934409141803e-12,
6.05305604236335e-13,
1.393763188134084e-13,
2.917473325340321e-14,
5.59649549715101e-15,
9.91280908003281e-16,
1.666924041136589e-16,
2.551726947165924e-17,
0.01130899806782683,
-2.60921007789874e-10,
-3.00396405282053e-10,
-2.305627520630354e-10,
-1.327225779983823e-10,
-6.11209958108043e-11,
-2.34560412131475e-11,
-7.71564215729214e-12,
-2.220737353515785e-12,
-5.68158136724764e-13,
-1.308228491132139e-13,
-2.738430115359652e-14,
-5.25304636739316e-15,
-9.30448705128438e-16,
-1.564634554393378e-16,
-2.395156612253014e-17,
-0.00731466519352798,
1.635892224478231e-10,
1.883390487203364e-10,
1.445555562152104e-10,
8.32128605479703e-11,
3.832093231028544e-11,
1.4706196537902e-11,
4.83746388918708e-12,
1.392332223926508e-12,
3.562172478006758e-13,
8.20218175886325e-14,
1.716910249333321e-14,
3.293498372380828e-15,
5.833634753518e-16,
9.80982002335402e-17,
1.501704502243993e-17,
0.003551495389949731,
-7.70644455936473e-11,
-8.87237200897771e-11,
-6.80979691143554e-11,
-3.92003390929587e-11,
-1.805242048399877e-11,
-6.92787023229986e-12,
-2.278857259166493e-12,
-6.55907019221167e-13,
-1.678086648560014e-13,
-3.863926843586293e-14,
-8.08811347730081e-15,
-1.551519956566736e-15,
-2.748145301963706e-16,
-4.621284861382777e-17,
-7.07438152945391e-18,
-0.001380642843717453,
2.9093114611789e-11,
3.34946853761244e-11,
2.570812011219764e-11,
1.479878241997037e-11,
6.81509013214004e-12,
2.615386703094213e-12,
8.60306686471714e-13,
2.476158666345851e-13,
6.33505814490647e-14,
1.458697312055005e-14,
3.053399650189996e-15,
5.8572537094271e-16,
1.037473167276214e-16,
1.744620980500494e-17,
2.67072387608941e-18,
0.000447624029584153,
-9.16748271725936e-12,
-1.055445432948267e-11,
-8.10084277159294e-12,
-4.66321961048068e-12,
-2.147491677874099e-12,
-8.24130146374195e-13,
-2.710898112847473e-13,
-7.80258272396444e-14,
-1.996229859862568e-14,
-4.596477995077051e-15,
-9.62152195095178e-16,
-1.845671471034525e-16,
-3.26917160884686e-17,
-5.497472143549668e-18,
-8.41575281970356e-19,
-0.0001244868197836559,
2.479874720222569e-12,
2.855061230884985e-12,
2.191340398697254e-12,
1.261436844231425e-12,
5.80913052042462e-13,
2.229335589389022e-13,
7.33318853579253e-14,
2.110658891546497e-14,
5.399956308098872e-15,
1.243383044434385e-15,
2.602697197563858e-16,
4.992688776931767e-17,
8.84337972009117e-18,
1.487115282331684e-18,
2.276545627302021e-19,
0.00003031440857929109,
-5.87825764113381e-13,
-6.76759409160362e-13,
-5.19432024395019e-13,
-2.990090883673145e-13,
-1.376987548605927e-13,
-5.28438354291513e-14,
-1.73824800544113e-14,
-5.003074316694226e-15,
-1.27999765866046e-15,
-2.947297149832478e-16,
-6.16939724597461e-17,
-1.183460576148783e-17,
-2.096225630162993e-18,
-3.525052119262101e-19,
-5.396330163131924e-20,
-6.566202628638315e-6,
1.240262253941141e-13,
1.427904664629103e-13,
1.095957294768887e-13,
6.30883689895979e-14,
2.905326368309216e-14,
1.11495989748563e-14,
3.667555223242954e-15,
1.05560609445024e-15,
2.700686263956537e-16,
6.21854719830066e-17,
1.301690868333778e-17,
2.497003575516809e-18,
4.422859635902722e-19,
7.437553655293394e-20,
1.138640964197942e-20,
1.28085438669323e-6,
-2.358248957898531e-14,
-2.71503440349536e-14,
-2.083865846481095e-14,
-1.199569529800169e-14,
-5.52422111002437e-15,
-2.119997640411118e-15,
-6.97353200364797e-16,
-2.007141717440564e-16,
-5.135116579613046e-17,
-1.182401975639847e-17,
-2.475051495828342e-18,
-4.747843249158361e-19,
-8.40962462367946e-20,
-1.414102054892476e-20,
-2.165495504636857e-21,
-2.272772651781023e-7,
4.08143709447935e-15,
4.69892803076744e-15,
3.60656043027805e-15,
2.076102938204404e-15,
9.56080613160338e-16,
3.669094008029099e-16,
1.206913834786662e-16,
3.47377364115216e-17,
8.88738153113656e-18,
2.046391956322214e-18,
4.283576917011199e-19,
8.21694731080336e-20,
1.45573440386442e-20,
2.449554946876409e-21,
3.725205248401959e-22,
3.698412105956922e-8,
-6.48198484392589e-16,
-7.4626607209767e-16,
-5.72780359813842e-16,
-3.2971885895509e-16,
-1.518411269679388e-16,
-5.82711713911919e-17,
-1.91677519006828e-17,
-5.516916757441431e-18,
-1.411460928712631e-18,
-3.250010754327462e-19,
-6.80290611213591e-20,
-1.304769894731815e-20,
-2.31412957440656e-21,
-3.915177570177078e-22,
-5.75601542515282e-23,
-5.559377258048693e-9,
9.51477430655608e-17,
1.095428857406823e-16,
8.40772693583079e-17,
4.83987638253228e-17,
2.228845170156913e-17,
8.55350734564701e-18,
2.813595656660638e-18,
8.09817333551164e-19,
2.071847538821359e-19,
4.770454810900034e-20,
9.98893386587334e-21,
1.920534810914167e-21,
3.333776109618503e-22,
5.12813479516972e-23,
1.34830304402649e-23,
7.889261839006751e-10,
-1.318321298631016e-17,
-1.517773462465544e-17,
-1.164934148491392e-17,
-6.70589961380168e-18,
-3.088180526162462e-18,
-1.185132779898133e-18,
-3.898383125010874e-19,
-1.122045246790106e-19,
-2.870622248521342e-20,
-6.608972291079041e-21,
-1.385214741074174e-21,
-2.682378894431395e-22,
-4.381517823735199e-23,
-4.656914969717166e-24,
-3.669995845004559e-24,
-1.026892777479978e-10,
1.67764231872419e-18,
1.93145706918969e-18,
1.482448041912562e-18,
8.53365641080312e-19,
3.929893614320265e-19,
1.508152200587144e-19,
4.960914737060556e-20,
1.427840655977468e-20,
3.653781897739769e-21,
8.4295234697698e-22,
1.733234010766047e-22,
2.821251439633074e-23,
1.14333097423807e-23,
7.512676539141729e-24,
-3.999207525792871e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=32
0.00583366823736935,
-1.38990332208536e-10,
-1.60018530086831e-10,
-1.228187554103542e-10,
-7.07001527927867e-11,
-3.25586180117426e-11,
-1.249482714215511e-11,
-4.11005471982495e-12,
-1.182967204570901e-12,
-3.02652802118167e-13,
-6.96881594067042e-14,
-1.458736662670161e-14,
-2.79824774857551e-15,
-4.95640454001641e-16,
-8.33462020568288e-17,
-1.275863473582914e-17,
-0.01130899806782682,
2.60921007789874e-10,
3.00396405282053e-10,
2.305627520630353e-10,
1.327225779983823e-10,
6.11209958108043e-11,
2.34560412131475e-11,
7.71564215729214e-12,
2.220737353515784e-12,
5.68158136724764e-13,
1.308228491132139e-13,
2.738430115359651e-14,
5.25304636739315e-15,
9.30448705128428e-16,
1.564634554393469e-16,
2.395156612254308e-17,
0.01097199779029198,
-2.45383833671735e-10,
-2.82508573080505e-10,
-2.168333343228157e-10,
-1.248192908219554e-10,
-5.74813984654282e-11,
-2.2059294806853e-11,
-7.25619583378062e-12,
-2.088498335889762e-12,
-5.34325871701014e-13,
-1.230327263829488e-13,
-2.575365373999991e-14,
-4.94024755857119e-15,
-8.75045213027493e-16,
-1.471473003503749e-16,
-2.252556753385895e-17,
-0.00710299077989996,
1.541288911873026e-10,
1.774474401795635e-10,
1.361959382287179e-10,
7.84006781859214e-11,
3.610484096799942e-11,
1.385574046460044e-11,
4.55771451833322e-12,
1.311814038442403e-12,
3.356173297120201e-13,
7.72785368717296e-14,
1.617622695460251e-14,
3.103039913134628e-15,
5.49629060393062e-16,
9.24256972264756e-17,
1.414876305827093e-17,
0.003451607109293459,
-7.27327865294698e-11,
-8.37367134403079e-11,
-6.42703002804917e-11,
-3.699695604992454e-11,
-1.703772533034947e-11,
-6.53846675773529e-12,
-2.150766716179204e-12,
-6.1903966658644e-13,
-1.583764536226568e-13,
-3.646743280137385e-14,
-7.63349912546967e-15,
-1.464313427356342e-15,
-2.593682918308322e-16,
-4.361552451299493e-17,
-6.67680967914778e-18,
-0.001342872088728329,
2.75024481513925e-11,
3.16633629880041e-11,
2.430252831443811e-11,
1.398965883124591e-11,
6.44247503353197e-12,
2.472390439087924e-12,
8.13269433842839e-13,
2.340774817156493e-13,
5.98868957950402e-14,
1.378943398505034e-14,
2.886456585237685e-15,
5.537014412647615e-16,
9.80751482697044e-17,
1.649241647503411e-17,
2.524725851849575e-18,
0.0004357038692474264,
-8.6795615208514e-12,
-9.99271430818081e-12,
-7.66969139550437e-12,
-4.41502895484682e-12,
-2.033195682165579e-12,
-7.80267456292667e-13,
-2.566615987548828e-13,
-7.38730612047464e-14,
-1.889984707847853e-14,
-4.351840655536365e-15,
-9.10944019266924e-16,
-1.747441072590429e-16,
-3.095182876587923e-17,
-5.204903411335738e-18,
-7.96791201182005e-19,
-0.0001212576348228547,
2.351303064534073e-12,
2.707037645944526e-12,
2.077728104720453e-12,
1.196036357579589e-12,
5.50795021335247e-13,
2.113753424430208e-13,
6.95299204566017e-14,
2.001229733558475e-14,
5.119990652185757e-15,
1.178918863783878e-15,
2.467758908553166e-16,
4.733842380983553e-17,
8.38490231098919e-18,
1.410020148576594e-18,
2.15853278356248e-19,
0.00002954791177065373,
-5.58118013363169e-13,
-6.42557098035023e-13,
-4.93180781841573e-13,
-2.838976599901256e-13,
-1.307396863606677e-13,
-5.017319530501883e-14,
-1.650399847763892e-14,
-4.750227417223976e-15,
-1.215308817077442e-15,
-2.798346238458682e-16,
-5.857608777251269e-17,
-1.123651488271076e-17,
-1.990289491964034e-18,
-3.346913123409973e-19,
-5.12365124092003e-20,
-6.404266538477201e-6,
1.179123616877042e-13,
1.357516209250368e-13,
1.041932161470729e-13,
5.99784326390145e-14,
2.762108535600045e-14,
1.059998045229648e-14,
3.48676345254422e-15,
1.003570124742531e-15,
2.567556416785243e-16,
5.912005709709179e-17,
1.23752469865813e-17,
2.373915300548596e-18,
4.204832610279359e-19,
7.071040154534451e-20,
1.082631206673215e-20,
1.250025331106843e-6,
-2.244790984625894e-14,
-2.584411087736792e-14,
-1.983608751522258e-14,
-1.141856912394987e-14,
-5.25844473726065e-15,
-2.018002228188232e-15,
-6.63802781635016e-16,
-1.910576002757719e-16,
-4.888060950435626e-17,
-1.125515579103543e-17,
-2.355974655693377e-18,
-4.519412196610901e-19,
-8.0051048755491e-20,
-1.346200070911444e-20,
-2.060958004140191e-21,
-2.219353352626961e-7,
3.88968000690305e-15,
4.47815953039285e-15,
3.4371143524101e-15,
1.97856194431228e-15,
9.11161334073129e-16,
3.496709969965106e-16,
1.150209747176418e-16,
3.310566429241849e-17,
8.4698291683868e-18,
1.950246020415719e-18,
4.082306821368144e-19,
7.83129162858027e-20,
1.387840840230265e-20,
2.329744577161181e-21,
3.49473252132572e-22,
3.613477776296149e-8,
-6.18441966129957e-16,
-7.12007615212911e-16,
-5.46486023665839e-16,
-3.145826237595455e-16,
-1.448706343623561e-16,
-5.55961469835516e-17,
-1.828782813837104e-17,
-5.263654891327011e-18,
-1.346665496170687e-18,
-3.100803961324616e-19,
-6.49074238154239e-20,
-1.245198324421429e-20,
-2.205432485762572e-21,
-3.697328162690153e-22,
-5.660402694298685e-23,
-5.434569455027732e-9,
9.08777209367829e-17,
1.04626841202562e-16,
8.03040659070896e-17,
4.622673351835041e-17,
2.128819496165041e-17,
8.16964480506666e-18,
2.68732777387374e-18,
7.73474083464295e-19,
1.978860137258564e-19,
4.556687184551459e-20,
9.54508771480898e-21,
1.824152237890365e-21,
3.058498242076232e-22,
6.127298361449153e-23,
2.6853153466724e-23,
7.716150940601181e-10,
-1.260492015373022e-17,
-1.451195041163943e-17,
-1.113833323950041e-17,
-6.41173964736015e-18,
-2.952714884235582e-18,
-1.133145952946042e-18,
-3.727376726371506e-19,
-1.072823773984804e-19,
-2.744744213545145e-20,
-6.320324941831258e-21,
-1.322704154169393e-21,
-2.52671144818999e-22,
-4.532328505684148e-23,
-8.923190135330539e-24,
-9.88494950236042e-25,
-1.004841793833347e-10,
1.605623278123428e-18,
1.848542086369405e-18,
1.418808443581646e-18,
8.16731746919586e-19,
3.761188337941897e-19,
1.44340887934934e-19,
4.747942964519044e-20,
1.366593126160285e-20,
3.497688496010704e-21,
8.0342947032986e-22,
1.614490822658641e-22,
3.767457075194595e-23,
2.35385161469016e-23,
-5.686240823850839e-24,
-1.785316573767223e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=33
0.00565449903391341,
-1.30460503894937e-10,
-1.50198202641027e-10,
-1.152813760315177e-10,
-6.63612889991911e-11,
-3.05604979054021e-11,
-1.172802060657375e-11,
-3.85782107864607e-12,
-1.110368676757892e-12,
-2.84079068362382e-13,
-6.54114245566069e-14,
-1.369215057679826e-14,
-2.62652318369658e-15,
-4.65224352564215e-16,
-7.8231727719673e-17,
-1.197578306127006e-17,
-0.01097199779029197,
2.45383833671735e-10,
2.82508573080505e-10,
2.168333343228156e-10,
1.248192908219554e-10,
5.74813984654282e-11,
2.205929480685299e-11,
7.25619583378062e-12,
2.088498335889762e-12,
5.34325871701014e-13,
1.230327263829487e-13,
2.57536537399999e-14,
4.94024755857119e-15,
8.75045213027506e-16,
1.471473003503709e-16,
2.252556753384648e-17,
0.01065448616984995,
-2.31193336780954e-10,
-2.66171160269345e-10,
-2.042939073430768e-10,
-1.176010172788822e-10,
-5.41572614519991e-11,
-2.078361069690067e-11,
-6.83657177749984e-12,
-1.967721057663605e-12,
-5.0342599456803e-13,
-1.159178053075944e-13,
-2.426434043190391e-14,
-4.65455986970177e-15,
-8.24443590589189e-16,
-1.386385458399209e-16,
-2.122314458784922e-17,
-0.00690321421858741,
1.454655730589473e-10,
1.674734268806246e-10,
1.285406005609902e-10,
7.3993912099853e-11,
3.407545066070075e-11,
1.307693351547127e-11,
4.30153343235864e-12,
1.238079333172945e-12,
3.167529072453304e-13,
7.29348656027517e-14,
1.526699825094038e-14,
2.928626854712413e-15,
5.1873658366112e-16,
8.72310490264568e-17,
1.335361935887268e-17,
0.003357180221820652,
-6.87561203784786e-11,
-7.91584074700072e-11,
-6.0756320786093e-11,
-3.497414707811346e-11,
-1.610618758382932e-11,
-6.18097609771958e-12,
-2.033173584607021e-12,
-5.85193704289101e-13,
-1.497172394875965e-13,
-3.447358496262129e-14,
-7.21614146308445e-15,
-1.384253603171985e-15,
-2.451878706996878e-16,
-4.12310411754525e-17,
-6.311814602541407e-18,
-0.001307111607718656,
2.60386845621848e-11,
2.997814292411717e-11,
2.300907418618671e-11,
1.324508686435256e-11,
6.09958704641021e-12,
2.340802368844795e-12,
7.69984796253726e-13,
2.216191836110961e-13,
5.66995412346319e-14,
1.305552196641886e-14,
2.732832057758061e-15,
5.242323217845577e-16,
9.28554863082331e-17,
1.561471021693017e-17,
2.390373589832652e-18,
0.0004244017218845266,
-8.22956072593868e-12,
-9.47463176088577e-12,
-7.27204836658293e-12,
-4.186127251563875e-12,
-1.927782574689628e-12,
-7.39813698556815e-13,
-2.433547216001634e-13,
-7.00430406751271e-14,
-1.791996728275615e-14,
-4.126216023348105e-15,
-8.6371561823622e-16,
-1.656844831160036e-16,
-2.934715747153156e-17,
-4.935070785094539e-18,
-7.554871193806e-19,
-0.0001181916475776741,
2.23247206119361e-12,
2.570228401052173e-12,
1.972723134206569e-12,
1.135590643898081e-12,
5.22958747255993e-13,
2.00692781915964e-13,
6.60159941394611e-14,
1.900090973476818e-14,
4.861235285163186e-15,
1.1193384993417e-15,
2.343043519385502e-16,
4.494605945278968e-17,
7.96115785383844e-18,
1.338765526948531e-18,
2.049462405389288e-19,
0.00002881919936612748,
-5.30605626721798e-13,
-6.10882293157737e-13,
-4.68869471890517e-13,
-2.699029464315628e-13,
-1.242948838975339e-13,
-4.769991195685843e-14,
-1.569043551058298e-14,
-4.516065554018613e-15,
-1.155400386189584e-15,
-2.660402557762686e-16,
-5.568860859678801e-17,
-1.068262114303191e-17,
-1.89218179036382e-18,
-3.181940017074721e-19,
-4.871104792517e-20,
-6.25012137396291e-6,
1.122394666472207e-13,
1.29220459308412e-13,
9.9180364600725e-14,
5.70928036117417e-14,
2.62922043409021e-14,
1.009000371686465e-14,
3.319011466104318e-15,
9.55287298583283e-16,
2.444028676784491e-16,
5.627573695876784e-17,
1.177986446635384e-17,
2.259706261843205e-18,
4.00255830815575e-19,
6.730778297643338e-20,
1.030338986563085e-20,
1.220644708899466e-6,
-2.139324562473559e-14,
-2.462988384916589e-14,
-1.890413387500208e-14,
-1.088209353553619e-14,
-5.011388646092221e-15,
-1.923190985751993e-15,
-6.32615526484093e-16,
-1.820812005918943e-16,
-4.658406936990797e-17,
-1.072635984828495e-17,
-2.245285663011043e-18,
-4.307084304391534e-19,
-7.62894125608305e-20,
-1.282917898900863e-20,
-1.965018880081736e-21,
-2.168386320027992e-7,
3.71112034135165e-15,
4.27258512314331e-15,
3.279330171241075e-15,
1.887734076936075e-15,
8.69333563203572e-16,
3.336190027308892e-16,
1.097408240310175e-16,
3.158591686523724e-17,
8.08101339960364e-18,
1.860719537042933e-18,
3.894939609282388e-19,
7.47143226588085e-20,
1.323114705095696e-20,
2.22710268442938e-21,
3.452884620802363e-22,
3.532355122523724e-8,
-5.90687578239277e-16,
-6.80054196030698e-16,
-5.2196086922506e-16,
-3.004648112931232e-16,
-1.383691426429152e-16,
-5.310110824280294e-17,
-1.746710886761153e-17,
-5.027433212671753e-18,
-1.286230209720487e-18,
-2.961649570142437e-19,
-6.199366188383644e-20,
-1.189223836689779e-20,
-2.109067992542975e-21,
-3.543361016230654e-22,
-5.106893884470941e-23,
-5.31523999812455e-9,
8.68887106534811e-17,
1.000343234978139e-16,
7.67791784621094e-17,
4.41976453784231e-17,
2.035376551003768e-17,
7.81104434778186e-18,
2.569369454330242e-18,
7.39523470092239e-19,
1.892014793883928e-19,
4.356391234639256e-20,
9.11664439069344e-21,
1.752967760284924e-21,
3.20819303409895e-22,
4.799487612376368e-23,
-7.2167585572659e-24,
7.550470924312747e-10,
-1.206384690749953e-17,
-1.388901682969829e-17,
-1.066021406705884e-17,
-6.13651215149226e-18,
-2.825967959970136e-18,
-1.084505038437703e-18,
-3.567377234611658e-19,
-1.026772663129225e-19,
-2.626904161782941e-20,
-6.048698563941425e-21,
-1.267160514775924e-21,
-2.429473938203784e-22,
-3.979978141697631e-23,
-7.102959413109529e-24,
-4.971481891656307e-24,
-9.83717562935065e-11,
1.538142579320259e-18,
1.770852062448795e-18,
1.359179149076549e-18,
7.82406368104412e-19,
3.603114123355427e-19,
1.382745983513785e-19,
4.548410378676026e-20,
1.309116022652002e-20,
3.349009775313247e-21,
7.7249531106448e-22,
1.651286375460155e-22,
2.721189686242343e-23,
-8.6805809601258e-24,
5.162244929669935e-24,
1.895194996632564e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=34
0.00548599889514599,
-1.22691916835867e-10,
-1.41254286540252e-10,
-1.084166671614078e-10,
-6.24096454109777e-11,
-2.87406992327141e-11,
-1.10296474034265e-11,
-3.62809791689031e-12,
-1.044249167944881e-12,
-2.67162935850507e-13,
-6.15163631914744e-14,
-1.287682686999995e-14,
-2.47012377928559e-15,
-4.37522606513753e-16,
-7.35736501751855e-17,
-1.126278376692315e-17,
-0.01065448616984995,
2.31193336780954e-10,
2.66171160269345e-10,
2.042939073430768e-10,
1.176010172788821e-10,
5.41572614519991e-11,
2.078361069690066e-11,
6.83657177749983e-12,
1.967721057663605e-12,
5.0342599456803e-13,
1.159178053075944e-13,
2.42643404319039e-14,
4.65455986970177e-15,
8.24443590589203e-16,
1.386385458399222e-16,
2.122314458783423e-17,
0.01035482132788112,
-2.18198359588421e-10,
-2.51210140320937e-10,
-1.928109008414853e-10,
-1.109908681497795e-10,
-5.11131759910511e-11,
-1.961540027320691e-11,
-6.45230014853795e-12,
-1.857118999759417e-12,
-4.75129360867996e-13,
-1.094022984041276e-13,
-2.290049737641064e-14,
-4.39294028206867e-15,
-7.78104875491554e-16,
-1.308465735396323e-16,
-2.003042903840135e-17,
-0.00671436044364179,
1.375122407569646e-10,
1.583168149400229e-10,
1.215126415721924e-10,
6.99482941562307e-11,
3.221237516766037e-11,
1.236195219543981e-11,
4.066347169214261e-12,
1.170387408578266e-12,
2.99434478975209e-13,
6.89471699252464e-14,
1.443228292617015e-14,
2.768507206343961e-15,
4.903757413979546e-16,
8.2462082351029e-17,
1.262362920676532e-17,
0.003267779019296474,
-6.50967114054595e-11,
-7.494535731029e-11,
-5.75226854654646e-11,
-3.311271716088014e-11,
-1.524896761602494e-11,
-5.85200592211176e-12,
-1.92496199063424e-12,
-5.54047959027719e-13,
-1.41748853086575e-13,
-3.263880491604728e-14,
-6.83208014439215e-15,
-1.310580804457354e-15,
-2.321387157741827e-16,
-3.903677554671062e-17,
-5.975933973978255e-18,
-0.001273205165630444,
2.46886821774619e-11,
2.842389528224955e-11,
2.181614509943584e-11,
1.255838175451147e-11,
5.78334772398592e-12,
2.219441095638605e-12,
7.30064164790017e-13,
2.101291220223674e-13,
5.37599018474996e-14,
1.237864806986398e-14,
2.591146854655808e-15,
4.970534493469879e-16,
8.80414724618296e-17,
1.480521234966906e-17,
2.266461300445975e-18,
0.0004136707665263032,
-7.81365221424426e-12,
-8.99579940375931e-12,
-6.90453096978186e-12,
-3.974567253677175e-12,
-1.830355615411582e-12,
-7.02424736711863e-13,
-2.310559794900864e-13,
-6.65031840722617e-14,
-1.701432349820266e-14,
-3.917684747692459e-15,
-8.20065231816167e-16,
-1.573112081930392e-16,
-2.786405252538506e-17,
-4.685679225288802e-18,
-7.17311713777045e-19,
-0.0001152767979493757,
2.122422514309477e-12,
2.443529181176166e-12,
1.875477894120764e-12,
1.079611789501741e-12,
4.97179537328813e-13,
1.907996484946766e-13,
6.27617422618176e-14,
1.806426227923766e-14,
4.621601560881683e-15,
1.064161026867568e-15,
2.227544354206869e-16,
4.273048462549747e-17,
7.56872639628716e-18,
1.272776102425843e-18,
1.948451361839954e-19,
0.00002812554612696359,
-5.05077599074831e-13,
-5.8149206592346e-13,
-4.46311639963062e-13,
-2.569176158267441e-13,
-1.183149193378384e-13,
-4.540501665059297e-14,
-1.493555157267651e-14,
-4.298792836421717e-15,
-1.099812902808823e-15,
-2.532408163452166e-16,
-5.300939019051984e-17,
-1.016867685177453e-17,
-1.801149465143375e-18,
-3.028864882962697e-19,
-4.636827199852245e-20,
-6.103218371674904e-6,
1.069661489391232e-13,
1.23149328081243e-13,
9.45205994036064e-14,
5.44104273989056e-14,
2.505692468140202e-14,
9.61594781028889e-15,
3.163075290843317e-15,
9.1040532907797e-16,
2.329201747751144e-16,
5.363175919963674e-17,
1.122641775146266e-17,
2.153541403736619e-18,
3.814536921516118e-19,
6.414498902564916e-20,
9.81692033900559e-21,
1.192612833606873e-6,
-2.041116723885571e-14,
-2.349922434985293e-14,
-1.803632067944469e-14,
-1.038254015034147e-14,
-4.781335853526786e-15,
-1.834904996961516e-15,
-6.03574690811581e-16,
-1.737225888480102e-16,
-4.444558531958363e-17,
-1.02339573547411e-17,
-2.142213750105191e-18,
-4.109369781679723e-19,
-7.27892359078797e-20,
-1.223999424223467e-20,
-1.872757257478696e-21,
-2.119706557844955e-7,
3.54457472678693e-15,
4.08084240281717e-15,
3.132162201451153e-15,
1.80301739131403e-15,
8.30320094828988e-16,
3.18647036431076e-16,
1.048159382440727e-16,
3.01684226568234e-17,
7.71835781630202e-18,
1.777216629166411e-18,
3.720196838800383e-19,
7.13581387183704e-20,
1.262429729683494e-20,
2.130950111979138e-21,
3.43409564944934e-22,
3.454793296188257e-8,
-5.64759721623972e-16,
-6.5020364862785e-16,
-4.99049728423309e-16,
-2.872760996494318e-16,
-1.322955175601017e-16,
-5.077026932096402e-17,
-1.670040157731439e-17,
-4.806757338571505e-18,
-1.229771814998167e-18,
-2.83165439085069e-19,
-5.927402814663952e-20,
-1.136934388459481e-20,
-2.012020923480028e-21,
-3.395492926739417e-22,
-5.388698856825949e-23,
-5.201036080718671e-9,
8.31565934555885e-17,
9.57375648786927e-17,
7.34812944903785e-17,
4.229923092862536e-17,
1.947951351639881e-17,
7.47553780595069e-18,
2.459007473786902e-18,
7.07759397354486e-19,
1.810775717245636e-19,
4.168968570849788e-20,
8.71095802480181e-21,
1.686537606318241e-21,
3.43421151953324e-22,
3.56110811648076e-23,
-4.48205772389843e-23,
7.391753559108041e-10,
-1.155686749847795e-17,
-1.330533522726674e-17,
-1.021222190056322e-17,
-5.87862715290347e-18,
-2.707207549021956e-18,
-1.038929051022173e-18,
-3.417459257054914e-19,
-9.83623871834186e-20,
-2.516531195772448e-20,
-5.794064010678598e-21,
-1.212472869262337e-21,
-2.337192722692064e-22,
-4.2474940411546e-23,
-5.965955593679378e-24,
2.307734061183654e-25,
-9.63462884293419e-11,
1.474826884779112e-18,
1.69795717682707e-18,
1.303230259558937e-18,
7.50199598019621e-19,
3.45479630837641e-19,
1.325827556346296e-19,
4.361214572040412e-20,
1.255169903792e-20,
3.208054030188835e-21,
7.44015809201275e-22,
1.73854988481407e-22,
1.64031553523068e-23,
-4.84400564425124e-23,
1.62246142964886e-23,
6.006037083967719e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=35
0.00532724308492497,
-1.15596668390477e-10,
-1.33085580134673e-10,
-1.021469536715384e-10,
-5.88005086394411e-11,
-2.70786307259996e-11,
-1.039180534845033e-11,
-3.41828588874992e-12,
-9.83860528831802e-13,
-2.51712997284015e-13,
-5.79589026537972e-14,
-1.213217021595195e-14,
-2.32727993485088e-15,
-4.12221795294601e-16,
-6.93192729199615e-17,
-1.061157229391749e-17,
-0.01035482132788111,
2.18198359588421e-10,
2.51210140320937e-10,
1.928109008414853e-10,
1.109908681497795e-10,
5.11131759910511e-11,
1.96154002732069e-11,
6.45230014853795e-12,
1.857118999759417e-12,
4.75129360867996e-13,
1.094022984041275e-13,
2.290049737641065e-14,
4.39294028206866e-15,
7.78104875491512e-16,
1.308465735396379e-16,
2.003042903844597e-17,
0.01007154066546268,
-2.06268361135447e-10,
-2.374752224100344e-10,
-1.822689623582887e-10,
-1.04922441234346e-10,
-4.83185627514906e-11,
-1.854292829315972e-11,
-6.09952075382139e-12,
-1.755581112867399e-12,
-4.49151718462814e-13,
-1.034207548878695e-13,
-2.164842438925519e-14,
-4.152760809516098e-15,
-7.35563612097064e-16,
-1.236931235263591e-16,
-1.893544380999582e-17,
-0.00653555803859342,
1.301934228109262e-10,
1.498907146205882e-10,
1.150453709309354e-10,
6.62254343217639e-11,
3.049793523205154e-11,
1.170401184422416e-11,
3.849923981268689e-12,
1.108095918055498e-12,
2.834977061731658e-13,
6.52776098320979e-14,
1.366416028878368e-14,
2.62116160891545e-15,
4.642774315520301e-16,
7.80735510928146e-17,
1.195186794410845e-17,
0.003183012914075945,
-6.17217054436523e-11,
-7.10597382056211e-11,
-5.45403627485875e-11,
-3.139595438627745e-11,
-1.445836930996423e-11,
-5.5486027390963e-12,
-1.825160411974971e-12,
-5.25322805055897e-13,
-1.343997546187427e-13,
-3.094662017466257e-14,
-6.47786713664636e-15,
-1.242633623356101e-15,
-2.201036811339272e-16,
-3.701303088744873e-17,
-5.666153274849829e-18,
-0.00124101229955624,
2.34409566423929e-11,
2.698739821088663e-11,
2.071359290904525e-11,
1.192370176085863e-11,
5.49106684615513e-12,
2.107274210105035e-12,
6.93167938460209e-13,
1.995095522138908e-13,
5.104297049386155e-14,
1.175305424291414e-14,
2.460195695446573e-15,
4.719336245546822e-16,
8.3592157485164e-17,
1.405703769260079e-17,
2.151935235621949e-18,
0.0004034687928271707,
-7.42847880014716e-12,
-8.55235213419025e-12,
-6.56417262947922e-12,
-3.778641263288644e-12,
-1.740128380665834e-12,
-6.67798769737119e-13,
-2.196660979182493e-13,
-6.32249179778942e-14,
-1.617560546327349e-14,
-3.724563593965018e-15,
-7.79640523703245e-16,
-1.495566964950757e-16,
-2.649054317866671e-17,
-4.454716003979066e-18,
-6.819570788562694e-19,
-0.0001125021849829378,
2.020310403422226e-12,
2.325968271894384e-12,
1.7852465661464e-12,
1.027670466930181e-12,
4.732596790199006e-13,
1.816200672426981e-13,
5.97422065013303e-14,
1.719517140633119e-14,
4.39925162680843e-15,
1.012963268855538e-15,
2.120375611676107e-16,
4.067470777890911e-17,
7.20459879842552e-18,
1.21154574773438e-18,
1.854721350839839e-19,
0.00002746448261777248,
-4.81347669421513e-13,
-5.54171975439331e-13,
-4.25342696605296e-13,
-2.448469228858286e-13,
-1.12756160877841e-13,
-4.327176507399438e-14,
-1.42338387850748e-14,
-4.096823973777743e-15,
-1.048140783976989e-15,
-2.413429173102566e-16,
-5.051888409117007e-17,
-9.69093244496992e-18,
-1.716529412518275e-18,
-2.886569226500228e-19,
-4.418986258572247e-20,
-5.963059099574419e-6,
1.020557602036408e-13,
1.174960342618109e-13,
9.01815362481229e-14,
5.19126620975792e-14,
2.390666146675185e-14,
9.17451815348309e-15,
3.017871206974127e-15,
8.68612297334687e-16,
2.222277608651629e-16,
5.116974931817737e-17,
1.07110622681448e-17,
2.054681874143459e-18,
3.639418748805592e-19,
6.120124281120724e-20,
9.36797344177453e-21,
1.165838957334176e-6,
-1.94951661467629e-14,
-2.244463914400014e-14,
-1.722689665827698e-14,
-9.91659827159394e-15,
-4.566761727845049e-15,
-1.752559163159003e-15,
-5.76487812087951e-16,
-1.659263698969431e-16,
-4.24509848165213e-17,
-9.77468555149648e-18,
-2.046077271028405e-18,
-3.924947244913475e-19,
-6.9522679062308e-20,
-1.169144492931318e-20,
-1.789153474940729e-21,
-2.073163540987022e-7,
3.38898946635638e-15,
3.90171825612901e-15,
2.994679344256754e-15,
1.72387590398761e-15,
7.938740995335e-16,
3.046603738164565e-16,
1.002151585200599e-16,
2.884421394478619e-17,
7.37956996673639e-18,
1.699206752289702e-18,
3.556874400059154e-19,
6.82293545590009e-20,
1.207936054160197e-20,
2.033616746419741e-21,
3.174901396636843e-22,
3.380562978769296e-8,
-5.40501627956397e-16,
-6.22275486804035e-16,
-4.77614072993207e-16,
-2.749367455617791e-16,
-1.266130359897635e-16,
-4.858953716955526e-17,
-1.59830705087608e-17,
-4.60029332128046e-18,
-1.176949290083018e-18,
-2.710018137867811e-19,
-5.672902728611376e-20,
-1.088316932375882e-20,
-1.924223094015429e-21,
-3.228570355165794e-22,
-5.202977698771108e-23,
-5.091634542225875e-9,
7.96597828385247e-17,
9.17117129644602e-17,
7.03913390871239e-17,
4.052050976520654e-17,
1.86603822860944e-17,
7.16118474237973e-18,
2.355604127031145e-18,
6.77996932474618e-19,
1.734615667364433e-19,
3.993980532569057e-20,
8.35439426400006e-21,
1.606446465909958e-21,
2.99624217317362e-22,
4.453567696861486e-23,
-8.7774607289324e-24,
7.23956912952864e-10,
-1.108117744843111e-17,
-1.275767682962012e-17,
-9.79187856373015e-18,
-5.63665809661151e-18,
-2.595776704187975e-18,
-9.96165918923341e-19,
-3.276793300132985e-19,
-9.43135077274041e-20,
-2.412992696417749e-20,
-5.556596361695559e-21,
-1.160937830165035e-21,
-2.215791574498594e-22,
-4.37180627731088e-23,
-8.19069621961887e-24,
2.284887073431902e-24,
-9.44025168252805e-11,
1.415340460474653e-18,
1.62947090126541e-18,
1.25066510258563e-18,
7.19940666306859e-19,
3.315448847297314e-19,
1.272350412056055e-19,
4.185291528223876e-20,
1.204603320531077e-20,
3.080642747493828e-21,
7.10563841447077e-22,
1.546670760651284e-22,
2.565893633186663e-23,
-1.03847985639137e-23,
4.256689562844347e-24,
1.608246907726659e-23,
// [{0,1.e-7},{2.,1.e-6}]: m=36
0.00517741066394056,
-1.0909917979421e-10,
-1.25605070160468e-10,
-9.64054504207426e-11,
-5.54954340748897e-11,
-2.55565879955256e-11,
-9.80770013660345e-12,
-3.22615007426898e-12,
-9.28559499879708e-13,
-2.37564680433998e-13,
-5.47011492020638e-14,
-1.145024868820532e-14,
-2.19647014103433e-15,
-3.89052437745757e-16,
-6.54232867698196e-17,
-1.00152145192226e-17,
-0.01007154066546268,
2.06268361135447e-10,
2.37475222410034e-10,
1.822689623582887e-10,
1.04922441234346e-10,
4.83185627514906e-11,
1.854292829315972e-11,
6.09952075382139e-12,
1.755581112867399e-12,
4.49151718462814e-13,
1.034207548878695e-13,
2.164842438925518e-14,
4.1527608095161e-15,
7.35563612097066e-16,
1.236931235263582e-16,
1.893544380998805e-17,
0.00980333705789013,
-1.95290134216389e-10,
-2.248360719308824e-10,
-1.725680563964031e-10,
-9.93381514826458e-11,
-4.57469028480773e-11,
-1.755601776633624e-11,
-5.77488597190303e-12,
-1.662143877083247e-12,
-4.25246559259749e-13,
-9.79164147481468e-14,
-2.049624043317548e-14,
-3.931742413373283e-15,
-6.96416147328154e-16,
-1.171103266390967e-16,
-1.792780191604861e-17,
-0.00636602582815235,
1.234434108873114e-10,
1.421194764112501e-10,
1.090807254971809e-10,
6.27919087725584e-11,
2.891673861993006e-11,
1.10972054781932e-11,
3.650320823950143e-12,
1.050645610111853e-12,
2.687995092375003e-13,
6.18932403493287e-14,
1.295573427329296e-14,
2.485267246711889e-15,
4.402073622683969e-16,
7.40260617753266e-17,
1.133230654979978e-17,
0.00310253074889044,
-5.86023916059799e-11,
-6.74684955272139e-11,
-5.17839822726111e-11,
-2.980925440214541e-11,
-1.372766711538728e-11,
-5.26818552526238e-12,
-1.732919846150455e-12,
-4.98773880534707e-13,
-1.276074262346477e-13,
-2.938263560728571e-14,
-6.15048923862134e-15,
-1.179834061382007e-15,
-2.089803936999694e-16,
-3.51425942370105e-17,
-5.379838102504111e-18,
-0.001210406378459291,
2.228543640011504e-11,
2.565705640219493e-11,
1.96925178881492e-11,
1.133592378969988e-11,
5.22038514192103e-12,
2.003396309182011e-12,
6.58998293745096e-13,
1.896747539309057e-13,
4.852681638910274e-14,
1.117369078172329e-14,
2.338921571100555e-15,
4.486700894987035e-16,
7.94716294920002e-17,
1.336414799197031e-17,
2.045871260915406e-18,
0.0003937576474445536,
-7.0710864120393e-12,
-8.14088895170116e-12,
-6.24836298156675e-12,
-3.596846634286921e-12,
-1.656408876584061e-12,
-6.35670235354973e-13,
-2.090977227564711e-13,
-6.0183099922687e-14,
-1.539738069399573e-14,
-3.545371440997171e-15,
-7.42131463939293e-16,
-1.423614773155544e-16,
-2.521609618222366e-17,
-4.240410010153677e-18,
-6.491520711259516e-19,
-0.0001098579309367778,
1.925390684527324e-12,
2.216687909633629e-12,
1.701370792466471e-12,
9.79387695023261e-13,
4.510246451139397e-13,
1.73087060910991e-13,
5.69353553425852e-14,
1.638729595331087e-14,
4.192563150926329e-15,
9.65371672806722e-16,
2.020755365986969e-16,
3.87637295766221e-17,
6.8661186280492e-18,
1.154628036876938e-18,
1.76758735626936e-19,
0.00002683376589438238,
-4.59250920143037e-13,
-5.28732153287801e-13,
-4.05816912433186e-13,
-2.336069790457284e-13,
-1.07579976419223e-13,
-4.128533162115552e-14,
-1.358042040856392e-14,
-3.908755331381714e-15,
-1.000024921793391e-15,
-2.302638718241908e-16,
-4.819978211059548e-17,
-9.24606752142898e-18,
-1.637733434931065e-18,
-2.754066978363738e-19,
-4.216104875021733e-20,
-5.829189818447073e-6,
9.74757577477379e-14,
1.122231116916758e-13,
8.6134418797264e-14,
4.95829542321724e-14,
2.283379154215677e-14,
8.76278925453416e-15,
2.882436902310885e-15,
8.29631228504869e-16,
2.122547641325983e-16,
4.887339008225487e-17,
1.023038300347277e-17,
1.962474891804804e-18,
3.476039878722806e-19,
5.84544064282803e-20,
8.95339402838733e-21,
1.140240291264494e-6,
-1.863944701473291e-14,
-2.1459456107346e-14,
-1.647074076727662e-14,
-9.4813199897317e-15,
-4.366308706942978e-15,
-1.675632500941758e-15,
-5.511835179206831e-16,
-1.586432190674054e-16,
-4.058764821992664e-17,
-9.3456380193783e-18,
-1.956268925969147e-18,
-3.752666782200857e-19,
-6.6467963287685e-20,
-1.117854771225704e-20,
-1.713738545996064e-21,
-2.02861966358782e-7,
3.24342385791938e-15,
3.73412965975707e-15,
2.866050348602154e-15,
1.649831108453433e-15,
7.59775217002671e-16,
2.915744486197894e-16,
9.59106675206834e-17,
2.760528347737837e-17,
7.06260167586991e-18,
1.626222701494059e-18,
3.403988952082815e-19,
6.52966655460475e-20,
1.158871745679356e-20,
1.948279024444046e-21,
2.74941314995043e-22,
3.309454121221829e-8,
-5.17772988219881e-16,
-5.96108173840209e-16,
-4.57529918929769e-16,
-2.633753781077216e-16,
-1.212888304305095e-16,
-4.654629847248375e-17,
-1.531096645165285e-17,
-4.406846522807804e-18,
-1.127458268982849e-18,
-2.596058107883348e-19,
-5.43396892966787e-20,
-1.042609719987428e-20,
-1.852763647487765e-21,
-3.085090899402676e-22,
-4.05113579044766e-23,
-4.9867388193865e-9,
7.63789121907497e-17,
8.7934471120239e-17,
6.74921989542895e-17,
3.885163069285189e-17,
1.789183516412438e-17,
6.86624395169148e-18,
2.258586781391058e-18,
6.50073361894043e-19,
1.663117282849163e-19,
3.829290648979615e-20,
8.03864687944053e-21,
1.544849596277549e-21,
2.14890147833714e-22,
3.85015379304916e-23,
6.55966623115168e-23,
7.093522556543961e-10,
-1.063425473585666e-17,
-1.224313805223356e-17,
-9.39695547375515e-18,
-5.409322110350924e-18,
-2.491084624851071e-18,
-9.55988862656488e-19,
-3.144635705833328e-19,
-9.05096695978594e-20,
-2.315582265241313e-20,
-5.332677541330543e-21,
-1.118530724492624e-21,
-2.119447581154999e-22,
-3.09844186752065e-23,
-8.773386375500171e-24,
-8.728475231041408e-24,
-9.25355980729972e-11,
1.359380722001406e-18,
1.565044872770133e-18,
1.201216299391079e-18,
6.91475647761101e-19,
3.184362979040927e-19,
1.222044624896415e-19,
4.01975015660686e-20,
1.156939654468581e-20,
2.964721987556842e-21,
6.84134510931581e-22,
1.19199189874585e-22,
2.086712257376347e-23,
6.4755323735028e-23,
7.394209974013145e-24,
-6.069143511877444e-23
}
,{
// [{0,1.e-6},{2.,0.00001}]: m=-1
496.5052144413837,
-573.7550617919485,
330.2861924129487,
-126.7496342004516,
36.48215304391397,
-8.40017433089345,
1.611870722261149,
-0.2651008723075621,
0.03815153957496404,
-0.004880372418750069,
0.000561869367649425,
-0.00005880878413361091,
5.64165641121163e-6,
-4.997073512412967e-7,
4.131090842265321e-8,
-3.169807532319296e-9,
-1.487360892745406,
0.00721968935388166,
0.004134253030548025,
0.001569946947901385,
0.0004423367047730428,
0.0000974927830870086,
0.00001705142068396829,
2.268235041064415e-6,
1.756935657987782e-7,
-1.471858487465063e-8,
-9.79148343900099e-9,
-2.575517835601959e-9,
-5.041316144486125e-10,
-7.97423740269048e-11,
-9.79506290961094e-12,
-6.890202535438655e-13,
0.3789411798968307,
-8.07086215019453e-6,
-9.26566804956242e-6,
-7.08149937494213e-6,
-4.050466833752765e-6,
-1.847435725165992e-6,
-6.98742741766144e-7,
-2.248278426644567e-7,
-6.256403296449456e-8,
-1.519265101944444e-8,
-3.221640139120508e-9,
-5.89405369616694e-10,
-8.93955369366837e-11,
-9.77779411122696e-12,
-9.25263973945158e-14,
2.954418026015685e-13,
-0.1336913547479516,
8.66022901507698e-7,
9.97029275442315e-7,
7.65223060977635e-7,
4.404688654992097e-7,
2.028168261641371e-7,
7.78134976671028e-8,
2.558270506724715e-8,
7.35566424441839e-9,
1.878014610911504e-9,
4.306573919875853e-10,
8.94133372033663e-11,
1.687625769800227e-11,
2.892552157001143e-12,
4.50256166904588e-13,
5.895972593198076e-14,
0.04448811248353383,
-1.627946725893628e-7,
-1.874233093815223e-7,
-1.438511959465646e-7,
-8.28056662656095e-8,
-3.813181729908638e-8,
-1.463239672258864e-8,
-4.812382761850093e-9,
-1.384649736038116e-9,
-3.540145713223359e-10,
-8.14054004417489e-11,
-1.699436595528133e-11,
-3.242598502405939e-12,
-5.681556470598786e-13,
-9.31653352099578e-14,
-1.359147060147583e-14,
-0.01323284987459298,
3.32206849552425e-8,
3.82466108502048e-8,
2.935518040423279e-8,
1.689799496870728e-8,
7.78162523968098e-9,
2.986163967145794e-9,
9.82175504899848e-10,
2.826378907218475e-10,
7.22827558019429e-11,
1.663080874073144e-11,
3.475837513290952e-12,
6.64711999826872e-13,
1.170077914308303e-13,
1.939573730692082e-14,
2.889960346822716e-15,
0.003499096184353032,
-6.63958428810653e-9,
-7.64408775992471e-9,
-5.86702939510427e-9,
-3.377305077307377e-9,
-1.55528018903091e-9,
-5.9684066235554e-10,
-1.963119340467017e-10,
-5.649547844359951e-11,
-1.445005300337428e-11,
-3.325455101230516e-12,
-6.95350008554775e-13,
-1.331030785716444e-13,
-2.347480081289518e-14,
-3.908652262981881e-15,
-5.873622625088677e-16,
-0.00082709873630332,
1.257085276830828e-9,
1.447270579696986e-9,
1.110817644364802e-9,
6.39433919746717e-10,
2.944664099773545e-10,
1.130027503004514e-10,
3.716929201229246e-11,
1.069707977058679e-11,
2.736206720206672e-12,
6.29776497595243e-13,
1.31719700720154e-13,
2.522655234239478e-14,
4.453710980197889e-15,
7.433413324067705e-16,
1.122114231187362e-16,
0.000176164994636763,
-2.228817997056205e-10,
-2.566018220284888e-10,
-1.969486659987628e-10,
-1.13372177584992e-10,
-5.22092756299943e-11,
-2.003563428636028e-11,
-6.59026265323971e-12,
-1.896672621513939e-12,
-4.851694676691834e-13,
-1.11677547324018e-13,
-2.336145723612621e-14,
-4.475543285934553e-15,
-7.90660731862206e-16,
-1.321608214376792e-16,
-2.00063405858897e-17,
-0.00003408152770257376,
3.68894528152418e-11,
4.24705060526059e-11,
3.259724740280708e-11,
1.876440265830245e-11,
8.6412518629665e-12,
3.316145462833723e-12,
1.090777478776699e-12,
3.139292183911783e-13,
8.03053867029984e-14,
1.848590868609108e-14,
3.867428875057183e-15,
7.4107552151293e-16,
1.309776920199457e-16,
2.191534739076036e-17,
3.323804677845939e-18,
6.033236838200369e-6,
-5.70187384650384e-12,
-6.56451875865317e-12,
-5.03844497870709e-12,
-2.900351291108916e-12,
-1.33565119719619e-12,
-5.125674661151976e-13,
-1.685993000282174e-13,
-4.852389167189651e-14,
-1.241301062388215e-14,
-2.857527319170931e-15,
-5.978692496227749e-16,
-1.145814885417744e-16,
-2.025754139493203e-17,
-3.391983761834895e-18,
-5.151517319901152e-19,
-9.83700444424372e-7,
8.24630896182175e-13,
9.49390632288937e-13,
7.28683053900718e-13,
4.194623198333145e-13,
1.931682801733615e-13,
7.4130102462791e-14,
2.438377524416867e-14,
7.01784926769094e-15,
1.795279218990608e-15,
4.13293147455319e-16,
8.64768621052451e-17,
1.657523512887041e-17,
2.931132739242066e-18,
4.910609754385784e-19,
7.465567945709536e-20,
1.4856891577791e-7,
-1.118693712751168e-13,
-1.287942802773015e-13,
-9.88531204348478e-14,
-5.69042659249308e-14,
-2.620523142331382e-14,
-1.005651295235727e-14,
-3.307920205869159e-15,
-9.52051928707395e-16,
-2.435530950136879e-16,
-5.606992331366504e-17,
-1.173253202881963e-17,
-2.249008184543445e-18,
-3.977942633167111e-19,
-6.667468717207556e-20,
-1.013395681376184e-20,
-2.089652207876599e-8,
1.427756343089938e-14,
1.643764168039936e-14,
1.261633983843288e-14,
7.26253013576398e-15,
3.344501341810783e-15,
1.283486479813019e-15,
4.221821984278319e-16,
1.215087491983673e-16,
3.108455369574838e-17,
7.15631226749187e-18,
1.49749535156287e-18,
2.870638751368063e-19,
5.079349412843963e-20,
8.53063255020583e-21,
1.289297498302231e-21,
2.78922218439228e-9,
-1.740268942935709e-15,
-2.003557482868683e-15,
-1.537785386252724e-15,
-8.85218341183152e-16,
-4.076561905004235e-16,
-1.564423702885939e-16,
-5.145929729291371e-17,
-1.481061804524907e-17,
-3.788903425342567e-18,
-8.72296480249397e-19,
-1.825430367586032e-19,
-3.499927568799909e-20,
-6.181105253985327e-21,
-1.034566929270992e-21,
-1.695223404021265e-22,
-3.440851742963932e-10,
1.979302562044813e-16,
2.278755057460188e-16,
1.749007254645098e-16,
1.006807335175307e-16,
4.636499107758434e-17,
1.779306922842415e-17,
5.852764420411629e-18,
1.684503469648452e-18,
4.309358474458328e-19,
9.92090483379367e-20,
2.077107831037164e-20,
3.994794091147617e-21,
6.86618812016688e-22,
1.013658285052655e-22,
3.219399766408319e-23,
// [{0,1.e-6},{2.,0.00001}]: m=0
0.743680446372703,
-0.003609844676940832,
-0.002067126515274013,
-0.000784973473950692,
-0.0002211683523865214,
-0.00004874639154350429,
-8.52571034198415e-6,
-1.134117520532207e-6,
-8.78467828993891e-8,
7.35929243732531e-9,
4.895741719500496e-9,
1.28775891780098e-9,
2.520658072243062e-10,
3.98711870134524e-11,
4.89753145480547e-12,
3.445101267719328e-13,
-0.3789411798968307,
8.07086215019453e-6,
9.26566804956242e-6,
7.08149937494213e-6,
4.050466833752765e-6,
1.847435725165992e-6,
6.98742741766144e-7,
2.248278426644567e-7,
6.256403296449456e-8,
1.519265101944444e-8,
3.221640139120508e-9,
5.89405369616694e-10,
8.93955369366837e-11,
9.77779411122696e-12,
9.25263973945158e-14,
-2.954418026015685e-13,
0.2005370321219274,
-1.299034352261547e-6,
-1.495543913163473e-6,
-1.147834591466453e-6,
-6.60703298248815e-7,
-3.042252392462056e-7,
-1.167202465006543e-7,
-3.837405760087073e-8,
-1.103349636662758e-8,
-2.817021916367256e-9,
-6.45986087981378e-10,
-1.341200058050494e-10,
-2.531438654700341e-11,
-4.338828235501713e-12,
-6.753842503568824e-13,
-8.8439588897972e-14,
-0.0889762249670693,
3.25589345178726e-7,
3.74846618763046e-7,
2.877023918931299e-7,
1.656113325312194e-7,
7.6263634598173e-8,
2.926479344517736e-8,
9.62476552370021e-9,
2.769299472076238e-9,
7.08029142644674e-10,
1.628108008834982e-10,
3.398873191056276e-11,
6.4851970048119e-12,
1.136311294119758e-12,
1.863306704199149e-13,
2.718294120295479e-14,
0.03308212468648191,
-8.30517123881061e-8,
-9.56165271255117e-8,
-7.33879510105817e-8,
-4.224498742176806e-8,
-1.945406309920239e-8,
-7.46540991786446e-9,
-2.455438762249612e-9,
-7.06594726804616e-10,
-1.807068895048566e-10,
-4.157702185182845e-11,
-8.68959378322734e-12,
-1.661779999567194e-12,
-2.925194785771085e-13,
-4.848934326727936e-14,
-7.224900867020685e-15,
-0.0104972885529821,
1.991875286427852e-8,
2.293226327972686e-8,
1.76010881852765e-8,
1.013191523190124e-8,
4.66584056708311e-9,
1.790521987062927e-9,
5.88935802138891e-10,
1.694864353304489e-10,
4.335015901003341e-11,
9.97636530367097e-12,
2.086050025659978e-12,
3.993092357140639e-13,
7.04244024386559e-14,
1.172595678896729e-14,
1.762086787389896e-15,
0.002894845577075749,
-4.39979846891493e-9,
-5.06544702894754e-9,
-3.887861755283016e-9,
-2.238018719117084e-9,
-1.030632434922387e-9,
-3.955096260522115e-10,
-1.300925220432314e-10,
-3.743977919711354e-11,
-9.57672352073863e-12,
-2.204217741587015e-12,
-4.610189525214277e-13,
-8.82929331980892e-14,
-1.55879884302505e-14,
-2.601694663941176e-15,
-3.927399814520352e-16,
-0.0007046599801605492,
8.9152719968324e-10,
1.026407289104939e-9,
7.87794664755658e-10,
4.534887107778079e-10,
2.08837102721609e-10,
8.01425372228196e-11,
2.636105063841139e-11,
7.5866904933814e-12,
1.940677872550696e-12,
4.467101897272793e-13,
9.34458290354789e-14,
1.790217316175704e-14,
3.162642928561665e-15,
5.286432855039836e-16,
8.00253646254139e-17,
0.0001533668744839608,
-1.660025375802531e-10,
-1.911172771350271e-10,
-1.466876132345747e-10,
-8.44398119174278e-11,
-3.888563336265678e-11,
-1.492265457481077e-11,
-4.908498651883106e-12,
-1.412681482008767e-12,
-3.613742399710937e-13,
-8.31865890415294e-14,
-1.740342992820691e-14,
-3.334839849917915e-15,
-5.893996156577618e-16,
-9.86190574053674e-17,
-1.495711823663693e-17,
-0.00003016616697755744,
2.85093600497968e-11,
3.282258322127127e-11,
2.519221677923781e-11,
1.450175178458868e-11,
6.67825383493483e-12,
2.562836505088141e-12,
8.42996228608739e-13,
2.426193802083341e-13,
6.20650331272987e-14,
1.428763199487055e-14,
2.989345279599645e-15,
5.729072525607187e-16,
1.012876891484766e-16,
1.695991923282808e-17,
2.575741174854787e-18,
5.410353581187509e-6,
-4.53547049438101e-12,
-5.22164912850554e-12,
-4.007757296050275e-12,
-2.307043046673457e-12,
-1.062425673393226e-12,
-4.077156143707133e-13,
-1.341107805608118e-13,
-3.859817578253463e-14,
-9.8740369375474e-15,
-2.273112603937471e-15,
-4.756227946610577e-16,
-9.11637754513752e-17,
-1.612123977758791e-17,
-2.700870330492933e-18,
-4.106048109515765e-19,
-8.91511155324279e-7,
6.71268325009417e-13,
7.72825660934745e-13,
5.93164758354986e-13,
3.41452095802405e-13,
1.572435923087019e-13,
6.03437610460924e-14,
1.984906174966621e-14,
5.712754955074248e-15,
1.461431995465809e-15,
3.364456472115833e-16,
7.04006758597444e-17,
1.349511699014697e-17,
2.386898719611061e-18,
4.000574221459614e-19,
6.086668609808323e-20,
1.358238104929435e-7,
-9.28023804090657e-14,
-1.068426194448176e-13,
-8.20046343838886e-14,
-4.720553949114466e-14,
-2.173884131455288e-14,
-8.34250193370554e-15,
-2.744131600888696e-15,
-7.8979170928906e-16,
-2.020457084717988e-16,
-4.651510776585474e-17,
-9.73357281946786e-18,
-1.865967300291128e-18,
-3.300772041072047e-19,
-5.534347575563655e-20,
-8.43401113654627e-21,
-1.924406072899527e-8,
1.203225421555261e-14,
1.385263642141085e-14,
1.063227882586818e-14,
6.12041723545321e-15,
2.818542991880464e-15,
1.081645633601205e-15,
3.557905829495839e-16,
1.02400892169295e-16,
2.619655078843239e-17,
6.031082259930393e-18,
1.262080423300829e-18,
2.419561992841692e-19,
4.280372779953389e-20,
7.184702026510315e-21,
1.097094345227602e-21,
2.58504889638411e-9,
-1.486670115267992e-15,
-1.711591299528954e-15,
-1.313693453246155e-15,
-7.5622110884357e-16,
-3.48251187593113e-16,
-1.336451787174161e-16,
-4.396058339076374e-17,
-1.265243602530138e-17,
-3.236811708824055e-18,
-7.45201895676225e-19,
-1.559433882998626e-19,
-2.989924874849582e-20,
-5.299249015819658e-21,
-8.872814341409183e-22,
-1.258437231957863e-22,
-3.205980886722793e-10,
1.71019179995343e-16,
1.96893009261316e-16,
1.511208189491349e-16,
8.69919630875803e-17,
4.006112000187929e-17,
1.53739005324157e-17,
5.057021516905508e-18,
1.455481643753221e-18,
3.723507761793257e-19,
8.57247834739611e-20,
1.793937277831997e-20,
3.444041562371693e-21,
6.109109855096281e-22,
9.69313523775056e-23,
1.340440104105298e-23,
// [{0,1.e-6},{2.,0.00001}]: m=1
0.1894705899484153,
-4.03543107509726e-6,
-4.63283402478121e-6,
-3.540749687471063e-6,
-2.025233416876383e-6,
-9.23717862582996e-7,
-3.493713708830718e-7,
-1.124139213322284e-7,
-3.128201648224728e-8,
-7.59632550972222e-9,
-1.610820069560254e-9,
-2.94702684808347e-10,
-4.469776846834186e-11,
-4.888897055613479e-12,
-4.62631986972579e-14,
1.477209013007843e-13,
-0.2005370321219274,
1.299034352261547e-6,
1.495543913163473e-6,
1.147834591466453e-6,
6.60703298248815e-7,
3.042252392462056e-7,
1.167202465006543e-7,
3.837405760087073e-8,
1.103349636662758e-8,
2.817021916367256e-9,
6.45986087981378e-10,
1.341200058050494e-10,
2.531438654700341e-11,
4.338828235501713e-12,
6.753842503568824e-13,
8.8439588897972e-14,
0.1334643374506039,
-4.8838401776809e-7,
-5.62269928144568e-7,
-4.31553587839695e-7,
-2.48416998796829e-7,
-1.143954518972594e-7,
-4.389719016776605e-8,
-1.443714828555032e-8,
-4.153949208114357e-9,
-1.06204371396701e-9,
-2.442162013252473e-10,
-5.098309786584414e-11,
-9.72779550721785e-12,
-1.704466941179636e-12,
-2.794960056298725e-13,
-4.077441180443243e-14,
-0.0661642493729653,
1.661034247762129e-7,
1.912330542510243e-7,
1.467759020211641e-7,
8.44899748435365e-8,
3.890812619840495e-8,
1.493081983572899e-8,
4.910877524499246e-9,
1.413189453609239e-9,
3.614137790097149e-10,
8.31540437036573e-11,
1.737918756645476e-11,
3.323559999134402e-12,
5.850389571542232e-13,
9.69786865345595e-14,
1.4449801734038e-14,
0.02624322138245476,
-4.97968821606961e-8,
-5.73306581993169e-8,
-4.40027204631911e-8,
-2.532978807975297e-8,
-1.166460141770772e-8,
-4.476304967657296e-9,
-1.47233950534722e-9,
-4.237160883261204e-10,
-1.08375397525083e-10,
-2.494091325917732e-11,
-5.215125064149913e-12,
-9.98273089285161e-13,
-1.76061006096654e-13,
-2.931489197241053e-14,
-4.405216968460723e-15,
-0.00868453673115518,
1.319939540670893e-8,
1.519634108680136e-8,
1.166358526581738e-8,
6.71405615733302e-9,
3.091897304758764e-9,
1.186528878153412e-9,
3.902775661286343e-10,
1.123193375910356e-10,
2.873017056213784e-11,
6.61265322474308e-12,
1.383056857560574e-12,
2.648787995935514e-13,
4.676396529049532e-14,
7.80508399179607e-15,
1.178219944484051e-15,
0.002466309930575201,
-3.12034519889752e-9,
-3.5924255118744e-9,
-2.757281326650269e-9,
-1.587210487725473e-9,
-7.3092985952708e-10,
-2.804988802804244e-10,
-9.22636772346227e-11,
-2.655341672688752e-11,
-6.79237255394087e-12,
-1.563485664048624e-12,
-3.270604016249487e-13,
-6.265760606612305e-14,
-1.106925024969479e-14,
-1.850251499454061e-15,
-2.800887764608401e-16,
-0.0006134674994461877,
6.64010151072108e-10,
7.64469109404839e-10,
5.86750453602003e-10,
3.377592480517697e-10,
1.555425336265709e-10,
5.96906183667635e-11,
1.96339946297423e-11,
5.650725934427403e-12,
1.445496961519871e-12,
3.327463565426214e-13,
6.96137197908316e-14,
1.333935941476381e-14,
2.357598467316964e-15,
3.944762301025633e-16,
5.982847093347441e-17,
0.000135747751232065,
-1.28292120146337e-10,
-1.477016244062093e-10,
-1.133649754378677e-10,
-6.52578829911008e-11,
-3.005214223899416e-11,
-1.153276426590734e-11,
-3.793483026440275e-12,
-1.091787210275894e-12,
-2.792926489037778e-13,
-6.42943439373796e-14,
-1.345205374898015e-14,
-2.578082636746821e-15,
-4.557946034199347e-16,
-7.631963431248997e-17,
-1.159083296856853e-17,
-0.00002705175179294576,
2.267734445905463e-11,
2.610823641739699e-11,
2.003877939970844e-11,
1.153521115748666e-11,
5.31212648996066e-12,
2.038577351531428e-12,
6.70553665864401e-13,
1.929908107178988e-13,
4.937016724044605e-14,
1.136555900314677e-14,
2.378113138614983e-15,
4.558187159660321e-16,
8.06061551864974e-17,
1.350434685764523e-17,
2.053039171398227e-18,
4.903312422795604e-6,
-3.69197628517373e-12,
-4.25054170804928e-12,
-3.26240661067532e-12,
-1.877986780037638e-12,
-8.64839874265557e-13,
-3.318907304877507e-13,
-1.091698543379269e-13,
-3.142015648748741e-14,
-8.03787705772076e-15,
-1.85045131251521e-15,
-3.872037736890057e-16,
-7.4223142802267e-17,
-1.312793442276204e-17,
-2.200329081933358e-18,
-3.347760946200239e-19,
-8.15034280282147e-7,
5.56859742738104e-13,
6.41108054730539e-13,
4.92067977213076e-13,
2.832563611386531e-13,
1.304436969318704e-13,
5.005909829388293e-14,
1.646613386433494e-14,
4.739137153441867e-15,
1.212373234191773e-15,
2.791134341781758e-16,
5.840618461634231e-17,
1.119671900520625e-17,
1.980680358891426e-18,
3.320877600060404e-19,
5.055001394673739e-20,
1.250830271095458e-7,
-7.8208084056644e-14,
-9.00403311166746e-14,
-6.91084265028564e-14,
-3.978191426363792e-14,
-1.832016206328569e-14,
-7.03055563045108e-15,
-2.31259241314468e-15,
-6.65592452978277e-16,
-1.702741665035563e-16,
-3.920123856417596e-17,
-8.20335109073088e-18,
-1.572714551229172e-18,
-2.782368795456992e-19,
-4.666233822522413e-20,
-7.114811425216059e-21,
-1.783277916541354e-8,
1.027612448853584e-14,
1.183081913697363e-14,
9.08047944643895e-15,
5.22713285333841e-15,
2.407173230393577e-15,
9.23778878508146e-16,
3.03863241589394e-16,
8.74558448713978e-17,
2.237339822216467e-17,
5.150964362907864e-18,
1.077938091658184e-18,
2.066676022681477e-19,
3.654755529997679e-20,
6.132610735352847e-21,
9.56536648656077e-22,
2.408630646889383e-9,
-1.284574205912815e-15,
-1.478919972917834e-15,
-1.135111898339318e-15,
-6.53421633670428e-16,
-3.009105849839328e-16,
-1.154777853448741e-16,
-3.798474192649721e-17,
-1.093253919009466e-17,
-2.796833790505585e-18,
-6.439147048105191e-19,
-1.347505552788433e-19,
-2.583485462107048e-20,
-4.579556285548559e-21,
-7.694491094798238e-22,
-1.087850996498425e-22,
-3.001031352071432e-10,
1.492322287977623e-16,
1.718098733920817e-16,
1.31868829339871e-16,
7.59096599860607e-17,
3.495756119527837e-17,
1.341536077537335e-17,
4.412793205349911e-18,
1.270066495525595e-18,
3.249194355984856e-19,
7.48066967207206e-20,
1.56484262872121e-20,
3.00030447176915e-21,
5.498907090065282e-22,
9.16657873767542e-23,
-7.121440316127093e-24,
// [{0,1.e-6},{2.,0.00001}]: m=2
0.1002685160609637,
-6.49517176130773e-7,
-7.47771956581737e-7,
-5.73917295733227e-7,
-3.303516491244073e-7,
-1.521126196231028e-7,
-5.83601232503271e-8,
-1.918702880043536e-8,
-5.51674818331379e-9,
-1.408510958183628e-9,
-3.229930439906889e-10,
-6.70600029025247e-11,
-1.26571932735017e-11,
-2.169414117750857e-12,
-3.376921251784412e-13,
-4.421979444898599e-14,
-0.1334643374506039,
4.8838401776809e-7,
5.62269928144568e-7,
4.31553587839695e-7,
2.48416998796829e-7,
1.143954518972594e-7,
4.389719016776605e-8,
1.443714828555032e-8,
4.153949208114357e-9,
1.06204371396701e-9,
2.442162013252473e-10,
5.098309786584414e-11,
9.72779550721785e-12,
1.704466941179636e-12,
2.794960056298725e-13,
4.077441180443245e-14,
0.099246374059448,
-2.49155137164319e-7,
-2.868495813765365e-7,
-2.201638530317462e-7,
-1.267349622653047e-7,
-5.83621892976074e-8,
-2.239622975359349e-8,
-7.36631628674887e-9,
-2.119784180413859e-9,
-5.42120668514572e-10,
-1.247310655554859e-10,
-2.606878134968214e-11,
-4.985339998701603e-12,
-8.77558435731334e-13,
-1.454680298018393e-13,
-2.167470260105749e-14,
-0.05248644276491093,
9.95937643213928e-8,
1.146613163986345e-7,
8.80054409263827e-8,
5.06595761595063e-8,
2.332920283541559e-8,
8.95260993531465e-9,
2.944679010694459e-9,
8.47432176652246e-10,
2.167507950501675e-10,
4.988182651835497e-11,
1.04302501282999e-11,
1.996546178570335e-12,
3.521220121933123e-13,
5.862978394482267e-14,
8.81043393691937e-15,
0.02171134182788748,
-3.29984885167721e-8,
-3.79908527170032e-8,
-2.915896316454326e-8,
-1.678514039333245e-8,
-7.72974326189686e-9,
-2.966322195383513e-9,
-9.7569391532158e-10,
-2.807983439775872e-10,
-7.18254264053442e-11,
-1.653163306185759e-11,
-3.457642143901406e-12,
-6.62196998983878e-13,
-1.169099132262629e-13,
-1.951270997948724e-14,
-2.945549861180226e-15,
-0.00739892979165786,
9.36103559666102e-9,
1.07772765355869e-8,
8.27184397992293e-9,
4.76163146316037e-9,
2.192789578573851e-9,
8.41496640838437e-10,
2.767910317029353e-10,
7.96602501803941e-11,
2.037711766175393e-11,
4.690456992130047e-12,
9.81181204871561e-13,
1.879728181977708e-13,
3.32077507489046e-14,
5.550754498301248e-15,
8.40266329454594e-16,
0.002147136248074182,
-2.324035528757864e-9,
-2.675641882923252e-9,
-2.053626587611859e-9,
-1.182157368183984e-9,
-5.44398867694283e-10,
-2.089171642841653e-10,
-6.87189812042602e-11,
-1.977754077054258e-11,
-5.059239365331454e-12,
-1.164612247901954e-12,
-2.436480192686922e-13,
-4.668775795172259e-14,
-8.25159463502546e-15,
-1.380666805404766e-15,
-2.093996489654088e-16,
-0.000542991006347814,
5.13168481246432e-10,
5.90806498385938e-10,
4.53459902335637e-10,
2.610315323006758e-10,
1.202085691108353e-10,
4.613105712305818e-11,
1.517393212530938e-11,
4.367148846729839e-12,
1.11717059705455e-12,
2.571773760810892e-13,
5.380821506489021e-14,
1.031233055975579e-14,
1.823178417087495e-15,
3.052785382644938e-16,
4.63633307737307e-17,
0.0001217328829107822,
-1.020480499967924e-10,
-1.174870637989009e-10,
-9.01745072377574e-11,
-5.19084501736155e-11,
-2.390456918867066e-11,
-9.17359807569278e-12,
-3.017491494350805e-12,
-8.68458647643764e-13,
-2.221657524323036e-13,
-5.11450154793452e-14,
-1.070150911413529e-14,
-2.051184220878292e-15,
-3.627277049581423e-16,
-6.076956065385728e-17,
-9.23866844305137e-18,
-0.00002451654696956233,
1.845987437326565e-11,
2.12527004206406e-11,
1.631202682135423e-11,
9.38993031275391e-12,
4.324197719258938e-12,
1.659453018438252e-12,
5.458490631439823e-13,
1.57100722415034e-13,
4.018936993254539e-14,
9.25225302591106e-15,
1.936018131507696e-15,
3.711155760309049e-16,
6.563963900336344e-17,
1.100163662149302e-17,
1.673888566782883e-18,
4.482689549453476e-6,
-3.06272902638896e-12,
-3.526094809116991e-12,
-2.706374264652018e-12,
-1.55791021075282e-12,
-7.1744043650651e-13,
-2.753250802901537e-13,
-9.0563749304252e-14,
-2.606525809969554e-14,
-6.66805374637843e-15,
-1.535124110076873e-15,
-3.212340757904756e-16,
-6.158196272841948e-17,
-1.089370380662883e-17,
-1.826481844395674e-18,
-2.780699558191629e-19,
-7.505840848308431e-7,
4.69288516805393e-13,
5.40288052733545e-13,
4.146859159740332e-13,
2.387118386472421e-13,
1.099303452804443e-13,
4.218693074157756e-14,
1.387673764862e-14,
3.99389525134986e-15,
1.021732119394506e-15,
2.352274938537829e-16,
4.922429391043259e-17,
9.43707764115221e-18,
1.669591542724108e-18,
2.800151075847676e-19,
4.266231506929331e-20,
1.159098879709013e-7,
-6.67934182461332e-14,
-7.68987230243813e-14,
-5.90218873090572e-14,
-3.397565602516024e-14,
-1.564630017294306e-14,
-6.00443767119267e-15,
-1.975069939645517e-15,
-5.684511543147254e-16,
-1.454240675144166e-16,
-3.348057044980225e-17,
-7.00641123963344e-18,
-1.343307880108436e-18,
-2.376668408653379e-19,
-3.987078965318456e-20,
-6.091071485242655e-21,
-1.661363404620566e-8,
8.87709960780308e-15,
1.022013351953607e-14,
7.84423454478213e-15,
4.515495380567962e-15,
2.079454179374568e-15,
7.9801366910706e-16,
2.624950103546225e-16,
7.55497268832062e-17,
1.932762160903053e-17,
4.449787241079971e-18,
9.31208492717322e-19,
1.785569662719471e-19,
3.161868162140499e-20,
5.288424324812389e-21,
7.82767909676211e-22,
2.25468337806358e-9,
-1.120953706154211e-15,
-1.290545051169313e-15,
-9.90529017795606e-16,
-5.70193284869171e-16,
-2.625827419444209e-16,
-1.007691069993966e-16,
-3.314657363937661e-17,
-9.5400688316707e-18,
-2.440614799092637e-18,
-5.619069360623944e-19,
-1.175876323770681e-19,
-2.254744650818438e-20,
-4.006414243101241e-21,
-6.69695720289018e-22,
-8.489535528328356e-23,
-2.820641817574262e-10,
1.313490773745633e-16,
1.512211486633235e-16,
1.160664209428003e-16,
6.68130875986344e-17,
3.076845791495922e-17,
1.180775080879625e-17,
3.883996830054554e-18,
1.117872595135794e-18,
2.859820433791275e-19,
6.584721138472209e-20,
1.378966112801129e-20,
2.630223244657943e-21,
4.417797448656907e-22,
9.21923692686583e-23,
3.884140741569672e-23,
// [{0,1.e-6},{2.,0.00001}]: m=3
0.0667321687253019,
-2.44192008884045e-7,
-2.81134964072284e-7,
-2.157767939198474e-7,
-1.242084993984145e-7,
-5.71977259486297e-8,
-2.194859508388302e-8,
-7.21857414277516e-9,
-2.076974604057179e-9,
-5.31021856983505e-10,
-1.221081006626236e-10,
-2.549154893292207e-11,
-4.86389775360892e-12,
-8.52233470589818e-13,
-1.397480028149363e-13,
-2.038720590221622e-14,
-0.099246374059448,
2.49155137164319e-7,
2.868495813765365e-7,
2.201638530317462e-7,
1.267349622653047e-7,
5.83621892976074e-8,
2.239622975359348e-8,
7.36631628674887e-9,
2.119784180413859e-9,
5.42120668514572e-10,
1.247310655554859e-10,
2.606878134968214e-11,
4.985339998701603e-12,
8.77558435731334e-13,
1.454680298018393e-13,
2.167470260105755e-14,
0.0787296641473664,
-1.493906464820892e-7,
-1.719919745979518e-7,
-1.32008161389574e-7,
-7.59893642392594e-8,
-3.499380425312339e-8,
-1.342891490297198e-8,
-4.417018516041688e-9,
-1.27114826497837e-9,
-3.251261925752512e-10,
-7.48227397775325e-11,
-1.564537519244984e-11,
-2.994819267855502e-12,
-5.281830182899687e-13,
-8.79446759172339e-14,
-1.321565090537889e-14,
-0.04342268365577628,
6.59969770335448e-8,
7.5981705434007e-8,
5.8317926329087e-8,
3.357028078666519e-8,
1.545948652379386e-8,
5.93264439076708e-9,
1.951387830643176e-9,
5.61596687955179e-10,
1.436508528106896e-10,
3.306326612371547e-11,
6.91528428780287e-12,
1.324393997967767e-12,
2.338198264525346e-13,
3.902541995897569e-14,
5.891099722353318e-15,
0.01849732447914422,
-2.340258899165237e-8,
-2.694319133896703e-8,
-2.067960994980716e-8,
-1.190407865790084e-8,
-5.48197394643458e-9,
-2.103741602096077e-9,
-6.91977579257333e-10,
-1.991506254509836e-10,
-5.094279415438442e-11,
-1.172614248032503e-11,
-2.452953012178891e-12,
-4.699320454944147e-13,
-8.30193768722413e-14,
-1.387688624576297e-14,
-2.100665823655186e-15,
-0.006441408744158651,
6.97210658624561e-9,
8.02692564873754e-9,
6.16087976281085e-9,
3.546472104537719e-9,
1.633196603076295e-9,
6.26751492849981e-10,
2.061569436119534e-10,
5.93326223113896e-11,
1.517771809593343e-11,
3.493836743691831e-12,
7.30944057803231e-13,
1.400632738546248e-13,
2.475478390474042e-14,
4.142000416175449e-15,
6.28198947142443e-16,
0.001900468522229202,
-1.79608968436741e-9,
-2.067822744356422e-9,
-1.587109658179057e-9,
-9.13610363054856e-10,
-4.207299918890709e-10,
-1.614586999311438e-10,
-5.310876243872764e-11,
-1.528502096359613e-11,
-3.910097089701637e-12,
-9.00120816286186e-13,
-1.883287527273909e-13,
-3.609315695948613e-14,
-6.38112446040829e-15,
-1.068474883649268e-15,
-1.622716571271802e-16,
-0.0004869315329821624,
4.08192200573472e-10,
4.69948255870609e-10,
3.606980294691149e-10,
2.076338009926956e-10,
9.56182768920238e-11,
3.669439235547738e-11,
1.206996599474021e-11,
3.473834595564905e-12,
8.88663011006036e-13,
2.045800622113713e-13,
4.280603651668193e-14,
8.20473689507912e-15,
1.450910825524397e-15,
2.430782432186633e-16,
3.695467002402383e-17,
0.0001103244612140123,
-8.30694346181277e-11,
-9.56371518220003e-11,
-7.34041206416898e-11,
-4.225468637607508e-11,
-1.9458889722243e-11,
-7.46753857743745e-12,
-2.456320782327428e-12,
-7.06953250343491e-13,
-1.808521645617658e-13,
-4.16351385868073e-14,
-8.71208158839486e-15,
-1.670020087712884e-15,
-2.953783676290437e-16,
-4.950736842652338e-17,
-7.53250630931266e-18,
-0.00002241343346186408,
1.531363887712051e-11,
1.763046684445528e-11,
1.353186579619327e-11,
7.78954787213381e-12,
3.587200717342375e-12,
1.376624839166883e-12,
4.528185615657852e-13,
1.303262372654192e-13,
3.334025511130721e-14,
7.67561741441338e-15,
1.606169732949477e-15,
3.07909689148267e-16,
5.446846979869651e-17,
9.13240401374338e-18,
1.390377742881282e-18,
4.128213420352967e-6,
-2.581087236487653e-12,
-2.97158474371035e-12,
-2.280772886066004e-12,
-1.312915313004642e-12,
-6.04616991350435e-13,
-2.320281545028572e-13,
-7.63220687193079e-14,
-2.196642723732537e-14,
-5.619527518665966e-15,
-1.293751406590059e-15,
-2.707336382338607e-16,
-5.19039561577975e-17,
-9.18280451746095e-18,
-1.540058975466191e-18,
-2.345919174497574e-19,
-6.955403764425995e-7,
4.00795995855508e-13,
4.61433193333119e-13,
3.541626813437706e-13,
2.038719869437658e-13,
9.38861137081625e-14,
3.602981611178185e-14,
1.185146897234019e-14,
3.411008940748913e-15,
8.72621676610155e-16,
2.009012132114344e-16,
4.204215332507497e-17,
8.06055700142858e-18,
1.426225776171813e-18,
2.392505365453461e-19,
3.644514320494277e-20,
1.079856152598792e-7,
-5.76999055049694e-14,
-6.64294380346412e-14,
-5.09864270973635e-14,
-2.935008823524949e-14,
-1.351616124044005e-14,
-5.186977203433238e-15,
-1.706180844169465e-15,
-4.910626510064116e-16,
-1.256268240147203e-16,
-2.892301782444859e-17,
-6.052785957249943e-18,
-1.160526208515343e-18,
-2.053610505868893e-19,
-3.445324433518438e-20,
-5.24903296869189e-21,
-1.555000052869103e-8,
7.74475534734544e-15,
8.9164749833084e-15,
6.84364113122022e-15,
3.939509226893584e-15,
1.814204333486639e-15,
6.96221491921699e-16,
2.290122159717306e-16,
6.59130631797176e-17,
1.686238153282477e-17,
3.882254120252687e-18,
8.12476279524125e-19,
1.55788905293279e-19,
2.753375575634802e-20,
4.619004989243799e-21,
7.433411622091496e-22,
2.11918129291146e-9,
-9.86646698583289e-16,
-1.135918501132428e-15,
-8.71848918587782e-16,
-5.018757166599942e-16,
-2.311215128219344e-16,
-8.86955474807961e-17,
-2.917517605234341e-17,
-8.39705905140942e-18,
-2.148208393821541e-18,
-4.945907457438732e-19,
-1.035089994591115e-19,
-1.984492440027599e-20,
-3.508843301026215e-21,
-5.921578856332606e-22,
-9.37670224829207e-23,
-2.660656982253027e-10,
1.164915723738736e-16,
1.341158249119954e-16,
1.029376166912919e-16,
5.92555598268698e-17,
2.728810571405105e-17,
1.04721300318482e-17,
3.44466534656843e-18,
9.91428436463589e-19,
2.53639315092174e-19,
5.839836189377723e-20,
1.220800290110425e-20,
2.337207268400195e-21,
4.510523403230998e-22,
7.67531757778118e-23,
-2.904990041497265e-23,
// [{0,1.e-6},{2.,0.00001}]: m=4
0.049623187029724,
-1.245775685821597e-7,
-1.434247906882682e-7,
-1.100819265158731e-7,
-6.33674811326524e-8,
-2.918109464880371e-8,
-1.119811487679674e-8,
-3.68315814337443e-9,
-1.059892090206929e-9,
-2.710603342572862e-10,
-6.2365532777743e-11,
-1.303439067484107e-11,
-2.492669999350801e-12,
-4.38779217865667e-13,
-7.27340149009197e-14,
-1.083735130052878e-14,
-0.0787296641473664,
1.493906464820892e-7,
1.719919745979518e-7,
1.32008161389574e-7,
7.59893642392594e-8,
3.499380425312339e-8,
1.342891490297198e-8,
4.41701851604169e-9,
1.27114826497837e-9,
3.251261925752512e-10,
7.48227397775325e-11,
1.564537519244984e-11,
2.994819267855502e-12,
5.28183018289969e-13,
8.79446759172339e-14,
1.321565090537888e-14,
0.0651340254836644,
-9.89954655503173e-8,
-1.139725581510105e-7,
-8.74768894936305e-8,
-5.03554211799978e-8,
-2.318922978569079e-8,
-8.89896658615062e-9,
-2.927081745964765e-9,
-8.42395031932769e-10,
-2.154762792160344e-10,
-4.959489918557321e-11,
-1.037292643170431e-11,
-1.986590996951651e-12,
-3.507297396788017e-13,
-5.853812993846337e-14,
-8.83664958353029e-15,
-0.03699464895828969,
4.68051779833053e-8,
5.38863826779347e-8,
4.13592198996148e-8,
2.380815731580195e-8,
1.096394789286929e-8,
4.2074832041922e-9,
1.383955158514681e-9,
3.983012509019717e-10,
1.0188558830877e-10,
2.345228496065032e-11,
4.905906024357838e-12,
9.39864090988839e-13,
1.660387537444833e-13,
2.775377249152746e-14,
4.201331647311703e-15,
0.01610352186039621,
-1.743026646561387e-8,
-2.006731412184367e-8,
-1.540219940702699e-8,
-8.86618026134421e-9,
-4.082991507690698e-9,
-1.566878732124937e-9,
-5.15392359029879e-10,
-1.483315557784727e-10,
-3.794429523983321e-11,
-8.7345918592295e-12,
-1.827360144508053e-12,
-3.501581846365489e-13,
-6.18869597618764e-14,
-1.035500104044937e-14,
-1.570497367825659e-15,
-0.005701405566627141,
5.38826905307725e-9,
6.20346823304051e-9,
4.7613289745151e-9,
2.740831089151862e-9,
1.262189975661361e-9,
4.843760997911859e-10,
1.593262873154442e-10,
4.585506289057578e-11,
1.173029126905052e-11,
2.700362448846023e-12,
5.649862581795338e-13,
1.08279470877991e-13,
1.914337338118572e-14,
3.20542465089296e-15,
4.868149713249287e-16,
0.001704260365448817,
-1.428672702011551e-9,
-1.644818895552196e-9,
-1.262443103145789e-9,
-7.26718303476672e-10,
-3.346639691231138e-10,
-1.284303732445663e-10,
-4.224488098172082e-11,
-1.215842108451462e-11,
-3.110320538530655e-12,
-7.1603021774192e-13,
-1.498211278091257e-13,
-2.871657913309846e-14,
-5.078187888547766e-15,
-8.50773851008709e-16,
-1.293413460026786e-16,
-0.0004412978461231866,
3.32277738996015e-10,
3.82548607890708e-10,
2.936164830293533e-10,
1.690187457705905e-10,
7.78355590116028e-11,
2.987015435681083e-11,
9.82528314478981e-12,
2.827813005829353e-12,
7.23408659386841e-13,
1.66540554609843e-13,
3.484832640879745e-14,
6.68008036086082e-15,
1.181513471573937e-15,
1.980294746082239e-16,
3.013002615852281e-17,
0.0001008604504369656,
-6.89113748917362e-11,
-7.93371007363753e-11,
-6.08933960339986e-11,
-3.505296539646972e-11,
-1.614240321508526e-11,
-6.19481177127919e-12,
-2.037683525410559e-12,
-5.86468067223511e-13,
-1.500311478811441e-13,
-3.454027833808597e-14,
-7.22776378865596e-15,
-1.38559359742312e-15,
-2.451081246975575e-16,
-4.109582097226062e-17,
-6.256687696832735e-18,
-0.00002064105358336768,
1.290543059754943e-11,
1.48579172887133e-11,
1.140385949525038e-11,
6.56457372416731e-12,
3.023083648493659e-12,
1.160140270454552e-12,
3.816101784506186e-13,
1.098320886552108e-13,
2.8097625433687e-14,
6.46875423192446e-15,
1.3536676030848e-15,
2.595196722420631e-16,
4.591400855908293e-17,
7.700287263078127e-18,
1.172952747498456e-18,
3.825472975603262e-6,
-2.204378331186583e-12,
-2.53788297086803e-12,
-1.947895060185857e-12,
-1.121296108249804e-12,
-5.163737083149068e-13,
-1.981640204362534e-13,
-6.51830898156114e-14,
-1.876055218779728e-14,
-4.799419987455122e-15,
-1.104956844641141e-15,
-2.312319058416177e-16,
-4.433308585422242e-17,
-7.84417216199448e-18,
-1.315861035805542e-18,
-2.005270621852468e-19,
-6.479903886057664e-7,
3.46231118615025e-13,
3.98613107572091e-13,
3.059465615097099e-13,
1.761166468641738e-13,
8.11043897813662e-14,
3.112471163114276e-14,
1.023802201197801e-14,
2.946645573624763e-15,
7.5382993215608e-16,
1.735539955830723e-16,
3.632004716219035e-17,
6.96378124535178e-18,
1.232259512870797e-18,
2.067534485395549e-19,
3.151835474564056e-20,
1.01072150613172e-7,
-5.0339794120424e-14,
-5.79558029670321e-14,
-4.44826815214207e-14,
-2.56062424853708e-14,
-1.17920668299545e-14,
-4.525339406280488e-15,
-1.488546412729399e-15,
-4.284254128175123e-16,
-1.096030658835029e-16,
-2.523410813140676e-17,
-5.280897618526338e-18,
-1.012561769993606e-18,
-1.791890853623228e-19,
-3.007226180378591e-20,
-4.585321741804877e-21,
-1.461398411490581e-8,
6.81552245815392e-15,
7.84665682349127e-15,
6.02252648400996e-15,
3.466838947177395e-15,
1.596532829158383e-15,
6.12687888941105e-16,
2.015352194672707e-16,
5.80048976493142e-17,
1.483931527744603e-17,
3.416508196263906e-18,
7.15006628217449e-19,
1.371027271036671e-19,
2.426285919249135e-20,
4.069479607984758e-21,
6.202855782371294e-22,
1.999004082798682e-9,
-8.75059948115248e-16,
-1.007449589748524e-15,
-7.73245512142306e-16,
-4.451151793981514e-16,
-2.049824540715378e-16,
-7.86644162910652e-17,
-2.587559643109462e-17,
-7.44740314909347e-18,
-1.905266004798472e-18,
-4.3865855311444e-19,
-9.18036440930053e-20,
-1.760591469468629e-20,
-3.115991359552896e-21,
-5.204811827222045e-22,
-7.941452959149808e-23,
-2.51780710350562e-10,
1.040149021330027e-16,
1.197515361264627e-16,
9.1912630920781e-17,
5.290908317548804e-17,
2.436545931102077e-17,
9.35053383571087e-18,
3.075733971924851e-18,
8.85245706731221e-19,
2.264732127329266e-19,
5.214343028836835e-20,
1.091196716978879e-20,
2.089697971113605e-21,
3.693964046274125e-22,
6.525180947951688e-23,
1.233413048500255e-23,
// [{0,1.e-6},{2.,0.00001}]: m=5
0.0393648320736832,
-7.46953232410446e-8,
-8.59959872989759e-8,
-6.6004080694787e-8,
-3.79946821196297e-8,
-1.749690212656169e-8,
-6.71445745148599e-9,
-2.208509258020844e-9,
-6.35574132489185e-10,
-1.625630962876256e-10,
-3.74113698887662e-11,
-7.82268759622492e-12,
-1.497409633927751e-12,
-2.640915091449844e-13,
-4.39723379586169e-14,
-6.60782545268944e-15,
-0.0651340254836644,
9.89954655503173e-8,
1.139725581510105e-7,
8.74768894936305e-8,
5.03554211799978e-8,
2.318922978569079e-8,
8.89896658615062e-9,
2.927081745964765e-9,
8.42395031932769e-10,
2.154762792160344e-10,
4.95948991855732e-11,
1.037292643170431e-11,
1.98659099695165e-12,
3.507297396788017e-13,
5.85381299384634e-14,
8.83664958353028e-15,
0.05549197343743454,
-7.02077669749579e-8,
-8.0829574016902e-8,
-6.20388298494222e-8,
-3.571223597370292e-8,
-1.644592183930393e-8,
-6.3112248062883e-9,
-2.075932737772022e-9,
-5.97451876352957e-10,
-1.52828382463155e-10,
-3.517842744097548e-11,
-7.35885903653676e-12,
-1.409796136483258e-12,
-2.490581306167245e-13,
-4.163065873729127e-14,
-6.30199747096808e-15,
-0.03220704372079361,
3.48605329312282e-8,
4.01346282436879e-8,
3.080439881405439e-8,
1.773236052268867e-8,
8.16598301538151e-9,
3.133757464249917e-9,
1.030784718059771e-9,
2.966631115569493e-10,
7.58885904796674e-11,
1.746918371845923e-11,
3.654720289016155e-12,
7.00316369273108e-13,
1.237739195237535e-13,
2.071000208089788e-14,
3.140994735652277e-15,
0.01425351391656745,
-1.347067263269298e-8,
-1.55086705826011e-8,
-1.190332243628761e-8,
-6.85207772287958e-9,
-3.155474939153367e-9,
-1.210940249477951e-9,
-3.983157182886062e-10,
-1.146376572264382e-10,
-2.932572817262599e-11,
-6.75090612211498e-12,
-1.41246564544881e-12,
-2.706986771949757e-13,
-4.785843345298436e-14,
-8.0135616272309e-15,
-1.217037428291796e-15,
-0.005112781096289068,
4.28601810601221e-9,
4.93445668663075e-9,
3.787329309417538e-9,
2.180154910418602e-9,
1.003991907364085e-9,
3.852911197316815e-10,
1.267346429444989e-10,
3.647526325335288e-11,
9.33096161554311e-12,
2.148090653214524e-12,
4.494633834250151e-13,
8.61497373988059e-14,
1.523456366558176e-14,
2.552321553055212e-15,
3.880240379863126e-16,
0.001544542461441856,
-1.162972086490027e-9,
-1.338920127622052e-9,
-1.027657690606248e-9,
-5.91565610199088e-10,
-2.724244565415405e-10,
-1.045455402491951e-10,
-3.438849100688184e-11,
-9.89734552043655e-12,
-2.531930307862562e-12,
-5.828919411364354e-13,
-1.219691424313439e-13,
-2.338028126310891e-14,
-4.135297150222747e-15,
-6.931031611149781e-16,
-1.054550918372101e-16,
-0.0004034418029504159,
2.75645500037209e-10,
3.173484034869127e-10,
2.435735845515427e-10,
1.402118618250874e-10,
6.45696129705003e-11,
2.477924712739169e-11,
8.15073411554803e-12,
2.345872272896395e-12,
6.00124592548475e-13,
1.381611135878812e-13,
2.891105520402312e-14,
5.542374399742426e-15,
9.80432500340129e-16,
1.643832835167894e-16,
2.502675095939522e-17,
0.000092884740990592,
-5.80744376390206e-11,
-6.68606277417007e-11,
-5.13173676844868e-11,
-2.9540581733344e-11,
-1.360387640652027e-11,
-5.220631212555008e-12,
-1.717245801550655e-12,
-4.942443985232791e-13,
-1.264393143431112e-13,
-2.910939401881717e-14,
-6.091504207640594e-15,
-1.16783852356747e-15,
-2.066130402255543e-16,
-3.465129320772344e-17,
-5.278285832516217e-18,
-0.0000191273520486219,
1.102188663901909e-11,
1.268940907840672e-11,
9.73947086773973e-12,
5.60647798930362e-12,
2.581867366363617e-12,
9.90819651180017e-13,
3.259153007270544e-13,
9.38027182408495e-14,
2.39970890138907e-14,
5.524781709769641e-15,
1.156159002814073e-15,
2.216653239412623e-16,
3.92208427483578e-17,
6.579307035959248e-18,
1.002635111993713e-18,
3.563947998592708e-6,
-1.904271472094732e-12,
-2.192372459728532e-12,
-1.682706370816611e-12,
-9.68641720380411e-13,
-4.460742186900027e-13,
-1.711859427121574e-13,
-5.630913052004993e-14,
-1.620655337626819e-14,
-4.146065321720421e-15,
-9.54547134318409e-16,
-1.997602965071413e-16,
-3.830080766352814e-17,
-6.77742397095739e-18,
-1.137139448044512e-18,
-1.733525553771554e-19,
-6.065056916980192e-7,
3.02067227967795e-13,
3.477675873125676e-13,
2.669212406392136e-13,
1.536519332648899e-13,
7.0759068488429e-14,
2.715459517396539e-14,
8.9321201393613e-15,
2.570794722418541e-15,
6.57680369054651e-16,
1.514189117514378e-16,
3.168837060712396e-17,
6.07595945157907e-18,
1.075240674898173e-18,
1.804327085438982e-19,
2.750910425476507e-20,
9.49881823077103e-8,
-4.42998883458528e-14,
-5.10021092737053e-14,
-3.914553175313841e-14,
-2.253394060597334e-14,
-1.037722735191264e-14,
-3.982380695925198e-15,
-1.309949130072538e-15,
-3.770232578074627e-16,
-9.64533582292143e-17,
-2.220680403475401e-17,
-4.647431831281418e-18,
-8.91131962740796e-19,
-1.577036038098338e-19,
-2.646759293858916e-20,
-4.043766620264035e-21,
-1.378397080713541e-8,
6.04367002155352e-15,
6.95802943921378e-15,
5.34048064080551e-15,
3.074222811968697e-15,
1.415727349781581e-15,
5.433019379110421e-16,
1.78711825120177e-16,
5.143606718959248e-17,
1.315886617440487e-17,
3.029637718945685e-18,
6.340530980364473e-19,
1.215707180084419e-19,
2.150670807429604e-20,
3.623468536013606e-21,
5.645064268197513e-22,
1.89169634687782e-9,
-7.81351986280553e-16,
-8.99564376832249e-16,
-6.90440651056042e-16,
-3.97448984742083e-16,
-1.830314661759837e-16,
-7.02404947143141e-17,
-2.310467897553505e-17,
-6.649899573657627e-18,
-1.701246798306871e-18,
-3.916898490419747e-19,
-8.19720450996804e-20,
-1.571753610935524e-20,
-2.789382140541124e-21,
-4.690495574089252e-22,
-6.370383705694648e-23,
-2.389484407061603e-10,
9.34370601438779e-17,
1.075733523993859e-16,
8.25655400964833e-17,
4.752847739720884e-17,
2.188761002319885e-17,
8.39963259960297e-18,
2.762949603569235e-18,
7.95223156414415e-19,
2.034429715325949e-19,
4.683679497078257e-20,
9.80063157854012e-21,
1.890159966269905e-21,
3.408549573113796e-22,
4.36504617430081e-23,
-1.55845488706477e-24,
// [{0,1.e-6},{2.,0.00001}]: m=6
0.0325670127418322,
-4.94977327751586e-8,
-5.69862790755052e-8,
-4.37384447468153e-8,
-2.51777105899989e-8,
-1.15946148928454e-8,
-4.44948329307531e-9,
-1.463540872982382e-9,
-4.21197515966385e-10,
-1.077381396080172e-10,
-2.479744959278661e-11,
-5.18646321585215e-12,
-9.93295498475825e-13,
-1.753648698394008e-13,
-2.926906496923169e-14,
-4.41832479176514e-15,
-0.0554919734374345,
7.02077669749579e-8,
8.0829574016902e-8,
6.20388298494222e-8,
3.57122359737029e-8,
1.644592183930393e-8,
6.3112248062883e-9,
2.075932737772022e-9,
5.97451876352957e-10,
1.52828382463155e-10,
3.517842744097548e-11,
7.35885903653676e-12,
1.409796136483258e-12,
2.490581306167245e-13,
4.163065873729126e-14,
6.30199747096805e-15,
0.04831056558119041,
-5.22907993968423e-8,
-6.02019423655318e-8,
-4.62065982210816e-8,
-2.6598540784033e-8,
-1.224897452307226e-8,
-4.70063619637487e-9,
-1.546177077089656e-9,
-4.44994667335424e-10,
-1.138328857195012e-10,
-2.620377557768885e-11,
-5.48208043352423e-12,
-1.050474553909662e-12,
-1.856608792856298e-13,
-3.106500312134699e-14,
-4.711492103478936e-15,
-0.02850702783313604,
2.69413452653864e-8,
3.10173411652027e-8,
2.380664487257559e-8,
1.370415544575937e-8,
6.31094987830683e-9,
2.42188049895594e-9,
7.96631436577225e-10,
2.292753144528799e-10,
5.86514563452529e-11,
1.350181224423018e-11,
2.824931290897665e-12,
5.413973543899589e-13,
9.57168669059695e-14,
1.602712325446313e-14,
2.434074856584276e-15,
0.01278195274072229,
-1.07150452650304e-8,
-1.233614171657673e-8,
-9.46832327354373e-9,
-5.45038727604644e-9,
-2.50997976841018e-9,
-9.63227799329192e-10,
-3.168366073612432e-10,
-9.1188158133381e-11,
-2.332740403885747e-11,
-5.37022663303624e-12,
-1.123658458562511e-12,
-2.153743434970218e-13,
-3.808640916398707e-14,
-6.380803882626219e-15,
-9.7006009493065e-16,
-0.004633627384270969,
3.48891625944981e-9,
4.01676038284282e-9,
3.082973071800833e-9,
1.774696830586953e-9,
8.17273369619874e-10,
3.136366207457632e-10,
1.031654730200462e-10,
2.969203656113717e-11,
7.59579092354356e-12,
1.748675823399135e-12,
3.659074272919165e-13,
7.01408437889488e-14,
1.240589145056384e-14,
2.079309483299041e-15,
3.163652755456341e-16,
0.001412046310336663,
-9.64759250133838e-10,
-1.110719412208346e-9,
-8.52507545933586e-10,
-4.9074151638964e-10,
-2.259936453975958e-10,
-8.67273649461951e-11,
-2.852756940452474e-11,
-8.21055295516806e-12,
-2.100436073927465e-12,
-4.835638975594751e-13,
-1.01188693214729e-13,
-1.939831039891543e-14,
-3.431513750467823e-15,
-5.753414926169964e-16,
-8.75936291546916e-17,
-0.0003715389651065896,
2.322977509808211e-10,
2.674425114558011e-10,
2.052694711132672e-10,
1.181623271494272e-10,
5.4415505725576e-11,
2.088252488840243e-11,
6.86898321876222e-12,
1.97697759770796e-12,
5.057572582973111e-13,
1.164375762883349e-13,
2.43660168747565e-14,
4.671354102405545e-15,
8.26452163408313e-16,
1.3860517355168e-16,
2.111314230641749e-17,
0.0000860730840904626,
-4.95984898302479e-11,
-5.7102340800633e-11,
-4.38276188647659e-11,
-2.522915092880431e-11,
-1.161840313801586e-11,
-4.458688426234348e-12,
-1.466618851931046e-12,
-4.22112231698128e-13,
-1.079869004642626e-13,
-2.486151767019018e-14,
-5.202715505280712e-15,
-9.97493960016352e-16,
-1.764937995478723e-16,
-2.960687782405197e-17,
-4.511849890024217e-18,
-0.00001781972778587155,
9.52135282923249e-12,
1.096185708186025e-11,
8.4135278500573e-12,
4.84320629700268e-12,
2.230370032007498e-12,
8.55929306219364e-13,
2.815455186105921e-13,
8.10327283169938e-14,
2.073031674188967e-14,
4.772733399111835e-15,
9.9880101075658e-16,
1.915039498932172e-16,
3.388709408298013e-17,
5.68569137212449e-18,
8.66772543057838e-19,
3.335782125747712e-6,
-1.661370044004575e-12,
-1.912722064303047e-12,
-1.468067079934398e-12,
-8.45085780563183e-13,
-3.891749446613854e-13,
-1.493502995431504e-13,
-4.91266693474207e-14,
-1.41393734418979e-14,
-3.61724265947829e-15,
-8.32804166797835e-16,
-1.742860812534591e-16,
-3.341776245842149e-17,
-5.913788820914455e-18,
-9.92404306810248e-19,
-1.513406911065863e-19,
-5.699983512549203e-7,
2.658250379084747e-13,
3.060422528691321e-13,
2.348959072145824e-13,
1.352167203993598e-13,
6.22693861673116e-14,
2.389659521238618e-14,
7.86045496601696e-15,
2.262358340699185e-15,
5.787761268357036e-16,
1.332537146300665e-16,
2.788727296283626e-17,
5.347300345068708e-18,
9.46353200656158e-19,
1.588310784195521e-19,
2.422304257668756e-20,
8.9593221409472e-8,
-3.92829405780515e-14,
-4.5226138426761e-14,
-3.471231601355146e-14,
-1.998198306890238e-14,
-9.20201353752788e-15,
-3.531380380423282e-15,
-1.161599819100753e-15,
-3.343266565115678e-16,
-8.55306432924985e-17,
-1.969216558010616e-17,
-4.121221527595893e-18,
-7.9025526736892e-19,
-1.398734975354308e-19,
-2.347599884748226e-20,
-3.572387177868846e-21,
-1.304295697288348e-8,
5.39562806246429e-15,
6.21194401265466e-15,
4.76783960564565e-15,
2.744584930793119e-15,
1.263924229232607e-15,
4.850459006272865e-16,
1.59549412440867e-16,
4.592089510158129e-17,
1.174795739076683e-17,
2.704811455616991e-18,
5.660827988274538e-19,
1.085467624169359e-19,
1.919761856489127e-20,
3.227581898779276e-21,
5.063620621276337e-22,
1.795299729890189e-9,
-7.01903618668822e-16,
-8.08096115284497e-16,
-6.20236245574619e-16,
-3.570361721106538e-16,
-1.644207626879572e-16,
-6.30984381658102e-17,
-2.075540848968041e-17,
-5.97374975727381e-18,
-1.528270073604698e-18,
-3.518662701544586e-19,
-7.36449611546542e-20,
-1.412026417073162e-20,
-2.489092280890995e-21,
-4.211957539849153e-22,
-7.52634456179747e-23,
-2.273583888641527e-10,
8.43919587915481e-17,
9.71598002103943e-17,
7.45728519836497e-17,
4.292752613353806e-17,
1.976880275950997e-17,
7.5865172496654e-18,
2.495487256503791e-18,
7.18243691524768e-19,
1.837510490790469e-19,
4.230503876530393e-20,
8.84684409609576e-21,
1.701047469199891e-21,
3.179255236365914e-22,
4.737520959068208e-23,
-8.611504227492403e-24,
// [{0,1.e-6},{2.,0.00001}]: m=7
0.02774598671871727,
-3.51038834874789e-8,
-4.0414787008451e-8,
-3.10194149247111e-8,
-1.785611798685146e-8,
-8.22296091965197e-9,
-3.15561240314415e-9,
-1.037966368886011e-9,
-2.98725938176479e-10,
-7.64141912315775e-11,
-1.758921372048774e-11,
-3.67942951826838e-12,
-7.04898068241629e-13,
-1.245290653083623e-13,
-2.081532936864563e-14,
-3.150998735484028e-15,
-0.0483105655811904,
5.22907993968423e-8,
6.02019423655318e-8,
4.62065982210816e-8,
2.6598540784033e-8,
1.224897452307226e-8,
4.70063619637487e-9,
1.546177077089656e-9,
4.44994667335424e-10,
1.138328857195012e-10,
2.620377557768885e-11,
5.48208043352423e-12,
1.050474553909662e-12,
1.856608792856298e-13,
3.106500312134698e-14,
4.711492103478922e-15,
0.04276054174970406,
-4.04120178980796e-8,
-4.6526011747804e-8,
-3.57099673088634e-8,
-2.055623316863906e-8,
-9.46642481746025e-9,
-3.632820748433911e-9,
-1.194947154865837e-9,
-3.439129716793199e-10,
-8.79771845178793e-11,
-2.025271836634527e-11,
-4.237396936346498e-12,
-8.12096031584938e-13,
-1.435753003589545e-13,
-2.404068488169467e-14,
-3.651112284876263e-15,
-0.02556390548144566,
2.143009053006118e-8,
2.46722834331539e-8,
1.893664654708779e-8,
1.090077455209307e-8,
5.01995953682045e-9,
1.926455598658418e-9,
6.33673214722498e-10,
1.823763162667653e-10,
4.665480807771578e-11,
1.074045326607267e-11,
2.247316917125063e-12,
4.307486869940509e-13,
7.61728183279724e-14,
1.276160776525322e-14,
1.94012018986457e-15,
0.01158406846067706,
-8.72229064862441e-9,
-1.004190095710691e-8,
-7.70743267950197e-9,
-4.43674207646732e-9,
-2.043183424049655e-9,
-7.84091551864397e-10,
-2.579136825501118e-10,
-7.42300914028419e-11,
-1.898947730885862e-11,
-4.371689558497777e-12,
-9.14768568229778e-13,
-1.753521094723688e-13,
-3.101472862641008e-14,
-5.198273708248828e-15,
-7.90913188863652e-16,
-0.004236138930957917,
2.89427775038312e-9,
3.33215823660386e-9,
2.557522637784502e-9,
1.472224549159563e-9,
6.77980936188478e-10,
2.601820948369316e-10,
8.55827082130303e-11,
2.463165886534762e-11,
6.30130822174235e-12,
1.450691692669198e-12,
3.035660796422081e-13,
5.819493119639453e-14,
1.029454125146959e-14,
1.72602447781703e-15,
2.627808873218544e-16,
0.00130038637788282,
-8.13042128436162e-10,
-9.36048790099089e-10,
-7.1844314889934e-10,
-4.135681450246675e-10,
-1.904542700402862e-10,
-7.30888371097041e-11,
-2.4041441265765e-11,
-6.91942159200584e-12,
-1.770150404047728e-12,
-4.075315170108268e-13,
-8.52810590620809e-14,
-1.634973935848133e-14,
-2.89258257173843e-15,
-4.851181074262146e-16,
-7.38959982591991e-17,
-0.0003442923374531275,
1.983939597065001e-10,
2.284093636463649e-10,
1.753104757997178e-10,
1.009166039113132e-10,
4.647361264236875e-11,
1.783475373959315e-11,
5.86647541912377e-12,
1.688448930073492e-12,
4.319476026962887e-13,
9.94460708741142e-14,
2.081086206236346e-14,
3.989975847518238e-15,
7.05975197407159e-16,
1.184275118971541e-16,
1.80474019134864e-17,
0.0000801887749137626,
-4.2846087690212e-11,
-4.93283568207834e-11,
-3.786087528873291e-11,
-2.179442831548663e-11,
-1.003666513435121e-11,
-3.851681874271342e-12,
-1.266954832525358e-12,
-3.646472770747276e-13,
-9.32864252488665e-14,
-2.147730027510798e-14,
-4.49460454241655e-15,
-8.61767774023532e-16,
-1.524919270829963e-16,
-2.558561090563574e-17,
-3.900472822237327e-18,
-0.00001667889898647179,
8.30684610729699e-12,
9.56360558656609e-12,
7.34033176546656e-12,
4.225426810801796e-12,
1.945873759901307e-12,
7.46751127997077e-13,
2.456332251227238e-13,
7.06968322069167e-14,
1.808620434368312e-14,
4.164018771498515e-15,
8.71429968697094e-16,
1.670887318644047e-16,
2.956894603439163e-17,
4.962016283095101e-18,
7.566851818365967e-19,
3.134991716977598e-6,
-1.462037973052713e-12,
-1.683232695361601e-12,
-1.291927723454905e-12,
-7.43692096767847e-13,
-3.424816858924483e-13,
-1.314312974507834e-13,
-4.323251013641457e-14,
-1.244297312506921e-14,
-3.183269270853058e-15,
-7.32895564742672e-16,
-1.533800417693501e-16,
-2.94101534744017e-17,
-5.204913731285056e-18,
-8.73574483011384e-19,
-1.332548115912391e-19,
-5.376253813464385e-7,
2.35720976896273e-13,
2.713836941536202e-13,
2.082945146376763e-13,
1.199037673932687e-13,
5.52175470782967e-14,
2.119037987043228e-14,
6.97028888994882e-15,
2.006158525318712e-15,
5.132346606287996e-16,
1.181646935235922e-16,
2.472979945051973e-17,
4.741992655628209e-18,
8.39263101063247e-19,
1.408799260411482e-19,
2.150269820405572e-20,
8.47767459973654e-8,
-3.50707486075031e-14,
-4.03766761365338e-14,
-3.099022065157661e-14,
-1.783937792307666e-14,
-8.2153121728192e-15,
-3.152723398513795e-15,
-1.037046524082038e-15,
-2.984787232569982e-16,
-7.63599172643956e-17,
-1.758084974647388e-17,
-3.67940619773318e-18,
-7.05553413875427e-19,
-1.248860158473281e-19,
-2.096305776013221e-20,
-3.192948103705701e-21,
-1.237738440843578e-8,
4.84630898958283e-15,
5.57951741781857e-15,
4.282434807482989e-15,
2.465164102921353e-15,
1.135246767695858e-15,
4.356645488075825e-16,
1.433061698972412e-16,
4.124588479453998e-17,
1.055197864520903e-17,
2.42946363178449e-18,
5.084510442018709e-19,
9.75058637455722e-20,
1.727563987891731e-20,
2.894053817509089e-21,
4.208846554455936e-22,
1.708233398378929e-9,
-6.3396595297337e-16,
-7.29880029050018e-16,
-5.60203245172427e-16,
-3.224784732191188e-16,
-1.485064224382615e-16,
-5.699113675678716e-17,
-1.874650276191403e-17,
-5.395560002190384e-18,
-1.380354646808991e-18,
-3.178122166818299e-19,
-6.651761970401513e-20,
-1.275368148524082e-20,
-2.250452286416026e-21,
-3.807501785516679e-22,
-6.508974560616141e-23,
-2.168387889955445e-10,
7.65975554481557e-17,
8.81861662902536e-17,
6.76853404085674e-17,
3.896276380722094e-17,
1.794296963975342e-17,
6.88583364752247e-18,
2.265007797211547e-18,
6.5190793726677e-19,
1.667785731620567e-19,
3.840048001191076e-20,
8.04164817008859e-21,
1.538402697173243e-21,
2.554950898952062e-22,
4.817032496553024e-23,
2.858508466956243e-23,
// [{0,1.e-6},{2.,0.00001}]: m=8
0.0241552827905952,
-2.61453996984212e-8,
-3.01009711827659e-8,
-2.31032991105408e-8,
-1.32992703920165e-8,
-6.12448726153613e-9,
-2.350318098187437e-9,
-7.73088538544828e-10,
-2.22497333667712e-10,
-5.69164428597506e-11,
-1.310188778884442e-11,
-2.741040216762116e-12,
-5.25237276954831e-13,
-9.28304396428149e-14,
-1.553250156067349e-14,
-2.355746051739461e-15,
-0.04276054174970406,
4.04120178980796e-8,
4.6526011747804e-8,
3.57099673088634e-8,
2.055623316863906e-8,
9.46642481746025e-9,
3.63282074843391e-9,
1.194947154865837e-9,
3.439129716793199e-10,
8.79771845178793e-11,
2.025271836634527e-11,
4.2373969363465e-12,
8.12096031584938e-13,
1.435753003589545e-13,
2.404068488169467e-14,
3.65111228487624e-15,
0.03834585822216849,
-3.21451357950918e-8,
-3.70084251497308e-8,
-2.840496982063169e-8,
-1.63511618281396e-8,
-7.52993930523067e-9,
-2.889683397987627e-9,
-9.50509822083747e-10,
-2.73564474400148e-10,
-6.99822121165737e-11,
-1.611067989910901e-11,
-3.370975375687595e-12,
-6.46123030491077e-13,
-1.142592274919589e-13,
-1.914241164787963e-14,
-2.910180284796588e-15,
-0.02316813692135515,
1.744458129724917e-8,
2.008380191421422e-8,
1.541486535900426e-8,
8.87348415293482e-9,
4.086366848099392e-9,
1.568183103728825e-9,
5.15827365100234e-10,
1.484601828056867e-10,
3.7978954617718e-11,
8.74337911699573e-12,
1.829537136459593e-12,
3.50704218944744e-13,
6.20294572528186e-14,
1.039654741649842e-14,
1.581826377729952e-15,
0.01059034732739444,
-7.23569437595768e-9,
-8.33039559150952e-9,
-6.39380659446116e-9,
-3.680561372898851e-9,
-1.694952340471169e-9,
-6.50455237092319e-10,
-2.139567705325723e-10,
-6.15791471633681e-11,
-1.575327055435563e-11,
-3.626729231672941e-12,
-7.58915199105515e-13,
-1.454873279909737e-13,
-2.573635312865414e-14,
-4.31506119455367e-15,
-6.569522183270612e-16,
-0.003901159133598689,
2.439126385291714e-9,
2.808146370277958e-9,
2.155329446683201e-9,
1.240704435065471e-9,
5.7136281011693e-10,
2.192665113276045e-10,
7.21243237967991e-11,
2.075826477587477e-11,
5.310451212106675e-12,
1.222594551024067e-12,
2.558431771844386e-13,
4.904921807512132e-14,
8.67774771526046e-15,
1.455354322252682e-15,
2.216879946768318e-16,
0.001205023181095289,
-6.9437885897576e-10,
-7.99432772765742e-10,
-6.13586665301672e-10,
-3.532081136911271e-10,
-1.626576442489956e-10,
-6.24216380888466e-11,
-2.053266396702219e-11,
-5.90957125528285e-12,
-1.511816609443587e-12,
-3.480612480608255e-13,
-7.2838017218424e-14,
-1.396491546659372e-14,
-2.470913191443676e-15,
-4.144962914109993e-16,
-6.316590610161831e-17,
-0.000320755100698059,
1.713843511123135e-10,
1.973134276877728e-10,
1.514435014655036e-10,
8.71777134407259e-11,
4.014666061973558e-11,
1.540672752868081e-11,
5.067819340494375e-12,
1.458589111290161e-12,
3.731457017605819e-13,
8.59092012767067e-14,
1.797841820723799e-14,
3.447071102952192e-15,
6.09967707913027e-16,
1.023424440623106e-16,
1.560189293304772e-17,
0.0000750550453216602,
-3.73808074449988e-11,
-4.30362250959852e-11,
-3.303149291116433e-11,
-1.901442062936126e-11,
-8.75643191069241e-12,
-3.360380072585397e-12,
-1.105349511933399e-12,
-3.181357446089283e-13,
-8.13879194639259e-14,
-1.873808445361995e-14,
-3.921434857064171e-15,
-7.51899290448363e-16,
-1.330602509693242e-16,
-2.23290754879615e-17,
-3.405090537245365e-18,
-0.00001567494745756917,
7.31018611571464e-12,
8.4161591599816e-12,
6.45963530398985e-12,
3.718458576561594e-12,
1.712407551130588e-12,
6.57156150183326e-13,
2.161624398067937e-13,
6.22148337136505e-14,
1.591633819128758e-14,
3.664475943401173e-15,
7.66899810141211e-16,
1.470506935563221e-16,
2.602456823062716e-17,
4.367868420223772e-18,
6.662610328103916e-19,
2.956940349221361e-6,
-1.296465615106304e-12,
-1.492610596661177e-12,
-1.145620044506488e-12,
-6.5947084385072e-13,
-3.036965656605423e-13,
-1.165471110580928e-13,
-3.8336596055915e-14,
-1.103387395125689e-14,
-2.822791162185098e-15,
-6.49905931460162e-16,
-1.360139113484227e-16,
-2.608097531639546e-17,
-4.61598423344789e-18,
-7.748289824018897e-19,
-1.182207343434908e-19,
-5.087236073289237e-7,
2.104457646210255e-13,
2.422845482304195e-13,
1.859601217507366e-13,
1.070470884324765e-13,
4.92968562305309e-14,
1.891825275298361e-14,
6.22290819248289e-15,
1.79105339000979e-15,
4.582058182252955e-16,
1.054957651769826e-16,
2.207868911262102e-17,
4.233742519138071e-18,
7.49342431296286e-19,
1.257975233145887e-19,
1.920893264679933e-20,
8.04506291523663e-8,
-3.15002451660588e-14,
-3.626598447335671e-14,
-2.78351517892655e-14,
-1.602317841940521e-14,
-7.37892519493277e-15,
-2.831750952653712e-15,
-9.31467534366239e-16,
-2.680917528863775e-16,
-6.85861955869757e-17,
-1.579114165675792e-17,
-3.304883064191443e-18,
-6.337470274855045e-19,
-1.121822260512825e-19,
-1.88352264889401e-20,
-2.867756949802847e-21,
-1.177631111467169e-8,
4.37666313572327e-15,
5.03881793684369e-15,
3.867433064523775e-15,
2.226270408828042e-15,
1.025232628100665e-15,
3.934454249223354e-16,
1.294188187438896e-16,
3.724892075188767e-17,
9.52945616299292e-18,
2.1940529438305e-18,
4.591799767349076e-19,
8.80541480858003e-20,
1.561870264309316e-20,
2.620513901332784e-21,
3.651990325808196e-22,
1.629207379181611e-9,
-5.75421115148747e-16,
-6.62477827823171e-16,
-5.08470196406057e-16,
-2.926985969293191e-16,
-1.347923382576223e-16,
-5.172820515918191e-17,
-1.701533832852998e-17,
-4.897307232711856e-18,
-1.252888464341402e-18,
-2.88464561295002e-19,
-6.037643973357595e-20,
-1.157961968336117e-20,
-2.041409101484945e-21,
-3.420210033369928e-22,
-6.074689810923517e-23,
-2.072481037995367e-10,
6.98337437034215e-17,
8.03990439946862e-17,
6.17085089305503e-17,
3.552222967354286e-17,
1.63585512053263e-17,
6.27779526161697e-18,
2.065002574882706e-18,
5.943438710328465e-19,
1.520499774308784e-19,
3.500802153568038e-20,
7.34089276815525e-21,
1.407601462945569e-21,
2.114768671305454e-22,
3.863334437742295e-23,
4.681366891502249e-23,
// [{0,1.e-6},{2.,0.00001}]: m=9
0.02138027087485203,
-2.02060089490398e-8,
-2.3263005873902e-8,
-1.785498365443169e-8,
-1.027811658431953e-8,
-4.73321240873012e-9,
-1.816410374216955e-9,
-5.97473577432919e-10,
-1.7195648583966e-10,
-4.39885922589397e-11,
-1.012635918317263e-11,
-2.118698468173249e-12,
-4.06048015792469e-13,
-7.17876501794772e-14,
-1.202034244084733e-14,
-1.825556142438118e-15,
-0.03834585822216849,
3.21451357950918e-8,
3.70084251497308e-8,
2.84049698206317e-8,
1.63511618281396e-8,
7.52993930523067e-9,
2.889683397987627e-9,
9.50509822083747e-10,
2.73564474400148e-10,
6.99822121165737e-11,
1.611067989910901e-11,
3.370975375687595e-12,
6.46123030491076e-13,
1.142592274919589e-13,
1.914241164787962e-14,
2.91018028479657e-15,
0.03475220538203273,
-2.61668719458738e-8,
-3.01257028713213e-8,
-2.312229803850638e-8,
-1.331022622940223e-8,
-6.12955027214909e-9,
-2.352274655593238e-9,
-7.73741047650351e-10,
-2.226902742085301e-10,
-5.6968431926577e-11,
-1.311506867549359e-11,
-2.74430570468939e-12,
-5.26056328417116e-13,
-9.30441858792277e-14,
-1.559482112474772e-14,
-2.372739566595106e-15,
-0.02118069465478988,
1.447138875191569e-8,
1.666079118301941e-8,
1.27876131889226e-8,
7.36112274579786e-9,
3.389904680942413e-9,
1.300910474184666e-9,
4.279135410651541e-10,
1.231582943267389e-10,
3.150654110871196e-11,
7.25345846334604e-12,
1.517830398211064e-12,
2.909746559819538e-13,
5.147270625730735e-14,
8.63012238910761e-15,
1.313904436656402e-15,
0.00975289783399639,
-6.09781596322918e-9,
-7.02036592569478e-9,
-5.38832361670791e-9,
-3.101761087663626e-9,
-1.428407025292301e-9,
-5.48166278319002e-10,
-1.803108094919946e-10,
-5.18956619396861e-11,
-1.327612803026646e-11,
-3.056486377560114e-12,
-6.39607942961089e-13,
-1.226230451878058e-13,
-2.169436928814396e-14,
-3.638385805626345e-15,
-5.542199866985772e-16,
-0.003615069543238206,
2.083136576911928e-9,
2.39829831827955e-9,
1.840759995891448e-9,
1.059624341065572e-9,
4.87972932743391e-10,
1.872649142651596e-10,
6.15979919006126e-11,
1.772871376571789e-11,
4.53544982829734e-12,
1.044183744174783e-12,
2.185140516536282e-13,
4.189474639946278e-14,
7.41273957436245e-15,
1.243488874233673e-15,
1.894977182125955e-16,
0.00112264285245217,
-5.99845228895862e-10,
-6.90596996910388e-10,
-5.30052255131706e-10,
-3.051219970439473e-10,
-1.405133121697223e-10,
-5.39235463506314e-11,
-1.773736769181208e-11,
-5.105061889539092e-12,
-1.306009956168092e-12,
-3.006822044698929e-13,
-6.29244637254559e-14,
-1.206474886028698e-14,
-2.1348869781324e-15,
-3.581985543382727e-16,
-5.460662482052021e-17,
-0.0003002201822854634,
1.495232301017301e-10,
1.721449007543519e-10,
1.32125971928958e-10,
7.60576826811015e-11,
3.502572771813606e-11,
1.344152031926438e-11,
4.421398057247403e-12,
1.27254298117397e-12,
3.255516785561201e-13,
7.4952337975678e-14,
1.568573946259056e-14,
3.00759716852246e-15,
5.322410035454236e-16,
8.93163018700277e-17,
1.362036371367506e-17,
0.00007053726344637305,
-3.28958374859497e-11,
-3.78727161798912e-11,
-2.90683588372332e-11,
-1.67330635768427e-11,
-7.70583397194366e-12,
-2.957202672699611e-12,
-9.72730978102585e-13,
-2.799667514155855e-13,
-7.16235217845392e-14,
-1.649014172754673e-14,
-3.451049144795304e-15,
-6.61728121343722e-16,
-1.171105495518553e-16,
-1.965540662803308e-17,
-2.998182469302692e-18,
-0.00001478469109017703,
6.48232464315303e-12,
7.46304903163527e-12,
5.72809718951493e-12,
3.297352473310412e-12,
1.518482024268046e-12,
5.82735246732214e-13,
1.916828787830394e-13,
5.51693405436493e-14,
1.411394833835734e-14,
3.249527937469999e-15,
6.80069191902648e-16,
1.304048050805806e-16,
2.307992089520043e-17,
3.874145501764036e-18,
5.91091056391633e-19,
2.797980561565256e-6,
-1.157451927933991e-12,
-1.332565271450954e-12,
-1.022780866257156e-12,
-5.8875909956673e-13,
-2.71132761392879e-13,
-1.040504101450168e-13,
-3.422600163815204e-14,
-9.85079553864857e-15,
-2.520132488894648e-15,
-5.802268216889161e-16,
-1.214327921326677e-16,
-2.328558287324901e-17,
-4.121440825310695e-18,
-6.918932049243447e-19,
-1.055883792025248e-19,
-4.827642318419553e-7,
1.890209445319415e-13,
2.176183265699659e-13,
1.670281185040989e-13,
9.61489760926669e-14,
4.427811284534462e-14,
1.699225631544883e-14,
5.589381044720876e-15,
1.608716254402661e-15,
4.115595706981097e-16,
9.47566087682022e-17,
1.98313598354759e-17,
3.802884029724812e-18,
6.73116660340919e-19,
1.130120858150033e-19,
1.725542252172296e-20,
7.654374905787304e-8,
-2.84476090730639e-14,
-3.275150917772694e-14,
-2.513769520832762e-14,
-1.447040092340757e-14,
-6.66384780087094e-15,
-2.557332216821378e-15,
-8.41201585435173e-16,
-2.421120166589943e-16,
-6.19399234459096e-17,
-1.426098841049487e-17,
-2.984672120401601e-18,
-5.723521304532544e-19,
-1.013160418425495e-19,
-1.701488789173062e-20,
-2.592718136682394e-21,
-1.123081023240098e-8,
3.97201743399329e-15,
4.57295259311641e-15,
3.509868562519941e-15,
2.020440154028037e-15,
9.30444678016107e-16,
3.570695004330013e-16,
1.174534902766901e-16,
3.380513436086955e-17,
8.64844455822799e-18,
1.991218549176589e-18,
4.167380907159105e-19,
7.99164519281136e-20,
1.416264002033444e-20,
2.377574211867105e-21,
3.468400584964989e-22,
1.557158693028425e-9,
-5.24616268823466e-16,
-6.03986615101975e-16,
-4.635765748346934e-16,
-2.668558007804399e-16,
-1.228913366951098e-16,
-4.716106222073214e-17,
-1.551304210683429e-17,
-4.464925088760865e-18,
-1.142273900892009e-18,
-2.629969514422732e-19,
-5.504483504084867e-20,
-1.055959423109989e-20,
-1.864744035063439e-21,
-3.095511579775811e-22,
-5.27550864521204e-23,
-1.984686630567465e-10,
6.39267374709174e-17,
7.35983548664578e-17,
5.64887919158342e-17,
3.251752454002845e-17,
1.497483844034159e-17,
5.746779752443246e-18,
1.890332383169147e-18,
5.440712860295927e-19,
1.391901252709343e-19,
3.204704988221215e-20,
6.714132735984921e-21,
1.288079611941175e-21,
2.107687953332736e-22,
3.635806331745528e-23,
2.295296517849964e-23,
// [{0,1.e-6},{2.,0.00001}]: m=10
0.01917292911108424,
-1.60725678975459e-8,
-1.85042125748654e-8,
-1.420248491031584e-8,
-8.1755809140698e-9,
-3.76496965261534e-9,
-1.444841698993813e-9,
-4.75254911041873e-10,
-1.36782237200074e-10,
-3.49911060582868e-11,
-8.0553399495545e-12,
-1.685487687843797e-12,
-3.23061515245538e-13,
-5.71296137459794e-14,
-9.57120582393981e-15,
-1.455090142398285e-15,
-0.03475220538203272,
2.61668719458738e-8,
3.01257028713213e-8,
2.312229803850638e-8,
1.331022622940223e-8,
6.12955027214909e-9,
2.352274655593238e-9,
7.73741047650351e-10,
2.2269027420853e-10,
5.6968431926577e-11,
1.311506867549359e-11,
2.74430570468939e-12,
5.26056328417116e-13,
9.30441858792277e-14,
1.559482112474772e-14,
2.372739566595068e-15,
0.03177104198218482,
-2.17070831278735e-8,
-2.499118677452911e-8,
-1.918141978338389e-8,
-1.10416841186968e-8,
-5.08485702141362e-9,
-1.951365711276999e-9,
-6.41870311597731e-10,
-1.847374414901084e-10,
-4.72598116630679e-11,
-1.088018769501907e-11,
-2.276745597316596e-12,
-4.364619839729306e-13,
-7.72090593859612e-14,
-1.294518358366146e-14,
-1.970856654984478e-15,
-0.01950579566799373,
1.219563192645865e-8,
1.404073185138989e-8,
1.077664723341608e-8,
6.2035221753274e-9,
2.85681405058467e-9,
1.09633255663803e-9,
3.606216189839979e-10,
1.037913238793746e-10,
2.655225606053356e-11,
6.11297275512038e-12,
1.279215885922209e-12,
2.452460903756185e-13,
4.338873857628602e-14,
7.27677161125179e-15,
1.108439973400491e-15,
0.00903767385809519,
-5.20784144227972e-9,
-5.99574579569877e-9,
-4.60189998972854e-9,
-2.649060852663881e-9,
-1.219932331858454e-9,
-4.6816228566289e-10,
-1.539949797515287e-10,
-4.432178441429392e-11,
-1.133862457074314e-11,
-2.610459360436909e-12,
-5.46285129134065e-13,
-1.047368659986581e-13,
-1.853184893589556e-14,
-3.108722185580933e-15,
-4.737442955416082e-16,
-0.003367928557310785,
1.799535686673481e-9,
2.071790990714925e-9,
1.590156765382654e-9,
9.15365991124666e-10,
4.215399365058625e-10,
1.617706390506261e-10,
5.32121030750191e-11,
1.531518566849722e-11,
3.918029868473566e-12,
9.02046613402622e-13,
1.887733911748601e-13,
3.619424658053463e-14,
6.40466093442874e-15,
1.074595663054342e-15,
1.638198743657928e-16,
0.001050770638007735,
-5.23331305358605e-10,
-6.02507152643167e-10,
-4.62440901753606e-10,
-2.662018893851521e-10,
-1.225900470140734e-10,
-4.704532111765453e-11,
-1.54748932004413e-11,
-4.453900434130588e-12,
-1.139430874952e-12,
-2.623331829161766e-13,
-5.49000881192038e-14,
-1.05265900898112e-14,
-1.862843512733326e-15,
-3.126070566198044e-16,
-4.767127268765936e-17,
-0.0002821490547437157,
1.315833502394178e-10,
1.514908650599085e-10,
1.162734356101562e-10,
6.69322544577429e-11,
3.08233359570234e-11,
1.182881071737352e-11,
3.89092392115189e-12,
1.11986700817836e-12,
2.864940877817694e-13,
6.59605670581349e-14,
1.380419661056824e-14,
2.646912492048951e-15,
4.684421981435428e-16,
7.86216258677237e-17,
1.199273121056177e-17,
0.00006653110979751053,
-2.91704608621349e-11,
-3.358372060545553e-11,
-2.577643732449296e-11,
-1.483808611359214e-11,
-6.83316910169762e-12,
-2.622308607413443e-12,
-8.62572953575881e-13,
-2.482620321736664e-13,
-6.35127674524402e-14,
-1.462287570227538e-14,
-3.060311361979362e-15,
-5.868216229475405e-16,
-1.038596395693684e-16,
-1.743365396109867e-17,
-2.65991404774266e-18,
-0.0000139898925850223,
5.7872564859019e-12,
6.66282272634613e-12,
5.11390154446197e-12,
2.943793893610702e-12,
1.355663068194078e-12,
5.202517672127951e-13,
1.711299149328118e-13,
4.925395085159225e-14,
1.260065557800684e-14,
2.901132529387696e-15,
6.071636269924059e-16,
1.164278451488629e-16,
2.060720118813446e-17,
3.459470671365687e-18,
5.279319476371808e-19,
2.655203968211444e-6,
-1.039615400083034e-12,
-1.196901032330884e-12,
-9.18654833059631e-13,
-5.28819472866791e-13,
-2.435296687075388e-13,
-9.34574281779032e-14,
-3.074160181226663e-14,
-8.84794114501553e-15,
-2.263578088010152e-15,
-5.211614525475404e-16,
-1.090724887155225e-16,
-2.091586231526929e-17,
-3.702171721214528e-18,
-6.21570807007186e-19,
-9.48756318421453e-20,
-4.59320493941622e-7,
1.707035472985399e-13,
1.965296549771407e-13,
1.508419822569575e-13,
8.68315070775312e-14,
3.998727820857456e-14,
1.534560180410486e-14,
5.047738610279115e-15,
1.452824385011921e-15,
3.716784980902602e-16,
8.55748931261863e-17,
1.790992145953351e-17,
3.434494348759823e-18,
6.079269505040122e-19,
1.020754782127934e-19,
1.559561756359957e-20,
7.299808212357372e-8,
-2.581746672809497e-14,
-2.972344743791384e-14,
-2.281357429526074e-14,
-1.313253209963791e-14,
-6.04773894262567e-15,
-2.320893626370877e-15,
-7.6342856767013e-16,
-2.197278710041195e-16,
-5.621347392496035e-17,
-1.294259238181499e-17,
-2.708768078092166e-18,
-5.194547909341855e-19,
-9.19594211133857e-20,
-1.544245237264529e-20,
-2.349947118765584e-21,
-1.073352719614166e-8,
3.62092336391664e-15,
4.16874080208364e-15,
3.199624846988347e-15,
1.841849859946441e-15,
8.48201125598847e-16,
3.255076143716182e-16,
1.070716605639773e-16,
3.081709585535193e-17,
7.88402542249569e-18,
1.815226236739147e-18,
3.798990018636123e-19,
7.28512810307275e-20,
1.29327264749794e-20,
2.172912148605343e-21,
2.962824983920766e-22,
1.49120358931685e-9,
-4.80246375977819e-16,
-5.52903911607705e-16,
-4.243691869391792e-16,
-2.442862554575022e-16,
-1.124977151028045e-16,
-4.317239181882043e-17,
-1.42010252678041e-17,
-4.087307183678212e-18,
-1.045668374595206e-18,
-2.407562822052043e-19,
-5.039197070294157e-20,
-9.66474526703145e-21,
-1.702996047506205e-21,
-2.854482602679982e-22,
-5.195587786817646e-23,
-1.904018420482176e-10,
5.87378585886113e-17,
6.76244398990694e-17,
5.19036467458704e-17,
2.98781074308498e-17,
1.37593461870751e-17,
5.280320635703587e-18,
1.736897339741503e-18,
4.999103420582792e-19,
1.278905818668133e-19,
2.944530790589835e-20,
6.178839722254234e-21,
1.186853221685168e-21,
1.706484461507906e-22,
2.833808299057563e-23,
4.302688109076559e-23,
// [{0,1.e-6},{2.,0.00001}]: m=11
0.01737610269101636,
-1.30834359729369e-8,
-1.506285143566067e-8,
-1.156114901925319e-8,
-6.65511311470111e-9,
-3.06477513607454e-9,
-1.176137327796619e-9,
-3.86870523825175e-10,
-1.11345137104265e-10,
-2.84842159632885e-11,
-6.5575343377468e-12,
-1.372152852344695e-12,
-2.63028164208558e-13,
-4.65220929396139e-14,
-7.79741056237386e-15,
-1.186369783297535e-15,
-0.03177104198218482,
2.17070831278735e-8,
2.49911867745291e-8,
1.918141978338389e-8,
1.10416841186968e-8,
5.08485702141362e-9,
1.951365711276999e-9,
6.41870311597731e-10,
1.847374414901083e-10,
4.72598116630679e-11,
1.088018769501906e-11,
2.276745597316596e-12,
4.36461983972931e-13,
7.72090593859612e-14,
1.294518358366146e-14,
1.97085665498444e-15,
0.0292586935019906,
-1.829344788968798e-8,
-2.106109777708484e-8,
-1.616497085012412e-8,
-9.3052832629911e-9,
-4.28522107587701e-9,
-1.644498834957045e-9,
-5.40932428475997e-10,
-1.556869858190619e-10,
-3.982838409080035e-11,
-9.16945913268056e-12,
-1.918823828883314e-12,
-3.678691355634276e-13,
-6.50831078644294e-14,
-1.09151574168778e-14,
-1.662659960100419e-15,
-0.0180753477161913,
1.041568288455972e-8,
1.199149159139784e-8,
9.20379997945731e-9,
5.2981217053279e-9,
2.439864663716971e-9,
9.36324571325805e-10,
3.079899595030653e-10,
8.86435688285901e-11,
2.267724914148687e-11,
5.22091872087395e-12,
1.092570258268159e-12,
2.09473731997322e-13,
3.706369787178818e-14,
6.21744437116145e-15,
9.47488591087288e-16,
0.00841982139327665,
-4.49883921668361e-9,
-5.17947747678721e-9,
-3.97539191345656e-9,
-2.288414977811621e-9,
-1.053849841264635e-9,
-4.044265976265574e-10,
-1.330302576875451e-10,
-3.828796417124229e-11,
-9.79507467118372e-12,
-2.255116533506508e-12,
-4.719334779371527e-13,
-9.0485616451341e-14,
-1.601165233604478e-14,
-2.686489157627869e-15,
-4.095496859385978e-16,
-0.003152311913979266,
1.569993916062809e-9,
1.807521457914527e-9,
1.387322705249326e-9,
7.98605668148841e-10,
3.677701410391737e-10,
1.411359633517944e-10,
4.64246796009393e-11,
1.336170130228107e-11,
3.418292624827691e-12,
7.86999548742015e-13,
1.647002643561958e-13,
3.15797702691542e-14,
5.588530538285514e-15,
9.37821169874224e-16,
1.430138179246662e-16,
0.000987521691611294,
-4.6054172584032e-10,
-5.30218027712395e-10,
-4.0695702463763e-10,
-2.342628906032997e-10,
-1.078816758501343e-10,
-4.140083751101928e-11,
-1.361823372410134e-11,
-3.919534528644323e-12,
-1.0027293072414e-12,
-2.308619847047015e-13,
-4.83146881369011e-14,
-9.26419372205925e-15,
-1.639547694293228e-15,
-2.75175690744572e-16,
-4.197455850851328e-17,
-0.000266124440110834,
1.166818437210949e-10,
1.343348827356128e-10,
1.031057495388149e-10,
5.93523445930088e-11,
2.733267647063655e-11,
1.04892344541555e-11,
3.450291822363086e-12,
9.93048131014361e-13,
2.540510704030697e-13,
5.84915029456578e-14,
1.224124547725598e-14,
2.347286497552766e-15,
4.15438557320293e-16,
6.973461565227663e-17,
1.063965823071719e-17,
0.0000629545165283858,
-2.604265415691216e-11,
-2.998270223442593e-11,
-2.301255692388186e-11,
-1.324707250616797e-11,
-6.10048379992867e-12,
-2.341132949792468e-12,
-7.70084616321104e-13,
-2.216427785799205e-13,
-5.670295003553626e-14,
-1.305509636684462e-14,
-2.732236322788849e-15,
-5.239253044452569e-16,
-9.27323946926305e-17,
-1.55676155423232e-17,
-2.375703785540957e-18,
-0.00001327601001758746,
5.19807409269769e-12,
5.98450181402186e-12,
4.59327159589658e-12,
2.6440958852691e-12,
1.217647662404621e-12,
4.672868794961612e-13,
1.537079230790403e-13,
4.423968097775787e-14,
1.131788410988522e-14,
2.605805805619783e-15,
5.453621332595871e-16,
1.045792510511645e-16,
1.851086191694605e-17,
3.107854880461995e-18,
4.743635438075157e-19,
2.526263383700163e-6,
-9.38869699891586e-13,
-1.080913320831536e-12,
-8.29631070085325e-13,
-4.77573385446118e-13,
-2.199300745960682e-13,
-8.44008269804151e-14,
-2.776256796682032e-14,
-7.99053573211611e-15,
-2.044232158810995e-15,
-4.706620103585149e-16,
-9.85045586158833e-17,
-1.888971180508926e-17,
-3.343669541128727e-18,
-5.614299054299207e-19,
-8.57079260367772e-20,
-4.380442267167623e-7,
1.549212972775809e-13,
1.783596773907854e-13,
1.36896023248315e-13,
7.88035840590105e-14,
3.629029805814767e-14,
1.392684477109193e-14,
4.581059225540412e-15,
1.318507629517977e-15,
3.373167600137238e-16,
7.76638226854103e-17,
1.625435726574986e-17,
3.117067312993485e-18,
5.517683435037554e-19,
9.2656021481073e-20,
1.415069318452165e-20,
6.97658245192772e-8,
-2.353540383286116e-14,
-2.709612670324893e-14,
-2.079703305451754e-14,
-1.197171988916936e-14,
-5.51316722706785e-15,
-2.115745732365034e-15,
-6.95948111765792e-16,
-2.003060342405864e-16,
-5.124484350024712e-17,
-1.179866249348879e-17,
-2.469374966781008e-18,
-4.735521514473348e-19,
-8.38316717116635e-20,
-1.408119815936393e-20,
-2.148003578011486e-21,
-1.027834861420148e-8,
3.31434342602864e-15,
3.81577776675057e-15,
2.928715954585841e-15,
1.685902452058856e-15,
7.76384954039018e-16,
2.979473424802281e-16,
9.8006098166416e-17,
2.820789422155356e-17,
7.21651683805056e-18,
1.661542540422349e-18,
3.477472345544334e-19,
6.66927236793454e-20,
1.181877165288046e-20,
1.979219376659382e-21,
2.88682158726845e-22,
1.430601342067882e-9,
-4.41270015201582e-16,
-5.08030737592699e-16,
-3.899277832278094e-16,
-2.244602244696317e-16,
-1.033675223859433e-16,
-3.966857539158166e-17,
-1.304849345581915e-17,
-3.755591335687547e-18,
-9.60806281523198e-19,
-2.21217307464558e-19,
-4.630141164844893e-20,
-8.88274025380936e-21,
-1.568883312652735e-21,
-2.602365385592035e-22,
-4.308594154254135e-23,
-1.829643622544462e-10,
5.41553650341742e-17,
6.23486514331489e-17,
4.785433284249484e-17,
2.754713887449854e-17,
1.26858991088445e-17,
4.868372868386869e-18,
1.601392458124095e-18,
4.609096918214359e-19,
1.179155268102454e-19,
2.715062918497936e-20,
5.687886168392691e-21,
1.086284624254248e-21,
1.768207321006365e-22,
3.640806233151086e-23,
2.279107958766975e-23,
// [{0,1.e-6},{2.,0.00001}]: m=12
0.01588552099109241,
-1.085354156393677e-8,
-1.249559338726456e-8,
-9.59070989169195e-9,
-5.5208420593484e-9,
-2.54242851070681e-9,
-9.756828556385e-10,
-3.20935155798866e-10,
-9.23687207450542e-11,
-2.362990583153397e-11,
-5.44009384750953e-12,
-1.138372798658298e-12,
-2.182309919864653e-13,
-3.86045296929806e-14,
-6.47259179183073e-15,
-9.85428327492218e-16,
-0.02925869350199059,
1.8293447889688e-8,
2.106109777708484e-8,
1.616497085012412e-8,
9.3052832629911e-9,
4.28522107587701e-9,
1.644498834957045e-9,
5.40932428475997e-10,
1.556869858190619e-10,
3.98283840908003e-11,
9.16945913268056e-12,
1.918823828883314e-12,
3.678691355634276e-13,
6.50831078644294e-14,
1.091515741687781e-14,
1.662659960100426e-15,
0.02711302157428695,
-1.562352432683958e-8,
-1.798723738709677e-8,
-1.380569996918597e-8,
-7.94718255799185e-9,
-3.659796995575457e-9,
-1.404486856988708e-9,
-4.61984939254598e-10,
-1.329653532428852e-10,
-3.401587371223031e-11,
-7.83137808131093e-12,
-1.638855387402239e-12,
-3.142105979959831e-13,
-5.55955468076819e-14,
-9.3261665567421e-15,
-1.421232886631352e-15,
-0.01683964278655418,
8.99767843336748e-9,
1.035895495357471e-8,
7.95078382691333e-9,
4.57682995562337e-9,
2.10769968252933e-9,
8.08853195253137e-10,
2.660605153750977e-10,
7.65759283424867e-11,
1.959014934236799e-11,
4.510233067013141e-12,
9.43866955874331e-13,
1.809712329026886e-13,
3.202330467209117e-14,
5.372978315254357e-15,
8.19099371876344e-16,
0.00788077978494787,
-3.92498479015694e-9,
-4.51880364478622e-9,
-3.468306763123241e-9,
-1.99651417037206e-9,
-9.19425352597915e-10,
-3.528399083794786e-10,
-1.160616990023458e-10,
-3.340425325570198e-11,
-8.54573156206905e-12,
-1.967498871854998e-12,
-4.117506608904778e-13,
-7.89494256728799e-14,
-1.397132634572378e-14,
-2.344552924690286e-15,
-3.575345447987131e-16,
-0.002962565074791597,
1.381625177508932e-9,
1.590654083123335e-9,
1.220871073902262e-9,
7.0278867180378e-10,
3.23645027547585e-10,
1.242025125319765e-10,
4.08547011719483e-11,
1.175860358583059e-11,
3.008187921698007e-12,
6.92585954108092e-13,
1.449440644094442e-13,
2.779258116588673e-14,
4.918643082825442e-15,
8.25527072278382e-16,
1.25923675541148e-16,
0.000931435540395908,
-4.0838645302602e-10,
-4.70172089577163e-10,
-3.60870123387785e-10,
-2.077332060766435e-10,
-9.56643676477403e-11,
-3.671232058974089e-11,
-1.207602137833548e-11,
-3.475668458568885e-12,
-8.89178746415507e-13,
-2.047202603108706e-13,
-4.284435917062924e-14,
-8.21550274156973e-15,
-1.454034950598095e-15,
-2.440711546730971e-16,
-3.723880386682403e-17,
-0.0002518180669997146,
1.041706168797348e-10,
1.199308092279285e-10,
9.20502279182831e-11,
5.29882901529002e-11,
2.440193525876589e-11,
9.36453182183151e-12,
3.080338472738693e-12,
8.86571116465209e-13,
2.268118006910244e-13,
5.222038559349061e-14,
1.092894531763716e-14,
2.095701223569218e-15,
3.709295796375346e-16,
6.227046155892857e-17,
9.50281512747105e-18,
0.00005974204497870576,
-2.339133338963943e-11,
-2.693025813143761e-11,
-2.066972215723412e-11,
-1.189843146972247e-11,
-5.47941447437887e-12,
-2.102790955260559e-12,
-6.91685653042497e-13,
-1.990785641658095e-13,
-5.093047843450169e-14,
-1.172612611183997e-14,
-2.454129597396142e-15,
-4.70606628105573e-16,
-8.32988768998878e-17,
-1.39853482441247e-17,
-2.134637564428639e-18,
-0.00001263130746437539,
4.69434581010911e-12,
5.40456350793123e-12,
4.148152973986218e-12,
2.387865559242928e-12,
1.099649743000038e-12,
4.220038931392261e-13,
1.388127603090834e-13,
3.995265577147089e-14,
1.022115493845854e-14,
2.353308705435121e-15,
4.925225102634817e-16,
9.44484998129518e-17,
1.671833942450856e-17,
2.807153347523998e-18,
4.285385024006395e-19,
2.409243889790517e-6,
-8.52067311039697e-13,
-9.80978428291728e-13,
-7.52928283399451e-13,
-4.334198018568755e-13,
-1.99596680550886e-13,
-7.65976620639298e-14,
-2.519583094517001e-14,
-7.25179346071526e-15,
-1.855242564442391e-15,
-4.271511108013877e-16,
-8.93989765737129e-17,
-1.714388061133556e-17,
-3.034745841942913e-18,
-5.096000487785418e-19,
-7.78080395034374e-20,
-4.186485856175974e-7,
1.412276810051582e-13,
1.625943266458577e-13,
1.247956810506759e-13,
7.18380806066267e-14,
3.308257755272346e-14,
1.269584603466488e-14,
4.176139855393327e-15,
1.20196606591011e-15,
3.07502282930977e-16,
7.07996178054302e-17,
1.481785336805532e-17,
2.841637220762211e-18,
5.030386320799528e-19,
8.44779650403459e-20,
1.28940041882986e-20,
6.680723992230981e-8,
-2.154267753001855e-14,
-2.480191681696732e-14,
-1.903616351007936e-14,
-1.095808375989089e-14,
-5.046372253513815e-15,
-1.936607857116472e-15,
-6.37023234539022e-16,
-1.833465899332862e-16,
-4.690614700244881e-17,
-1.079975582609129e-17,
-2.260327076982645e-18,
-4.334690863388861e-19,
-7.67389366493538e-20,
-1.289094794415035e-20,
-1.965512779237263e-21,
-9.86015135154924e-9,
3.04506715220789e-15,
3.505762135563966e-15,
2.690770372742841e-15,
1.548930204653547e-15,
7.13307124086795e-16,
2.73740500351913e-16,
9.00435937946739e-17,
2.591616531331608e-17,
6.63022477907272e-18,
1.526559699819633e-18,
3.195115812955962e-19,
6.127566275578813e-20,
1.08258474111312e-20,
1.817988789382365e-21,
2.988408440002016e-22,
1.374726472100704e-9,
-4.06848026914103e-16,
-4.68400975622856e-16,
-3.595108422972528e-16,
-2.069508550829016e-16,
-9.53041867880818e-17,
-3.657417671970164e-17,
-1.203063332967144e-17,
-3.462635461641493e-18,
-8.8585970724962e-19,
-2.03962108511181e-19,
-4.26899225673543e-20,
-8.19024498657461e-21,
-1.446926482889784e-21,
-2.395283136590555e-22,
-3.963920149820295e-23,
-1.760854212304083e-10,
5.00884133516989e-17,
5.76664021510609e-17,
4.426057659059321e-17,
2.547840979971393e-17,
1.173321723294017e-17,
4.502770003528149e-18,
1.481132012036418e-18,
4.262971094199059e-19,
1.090637884249806e-19,
2.511129301129307e-20,
5.24455738274461e-21,
1.005259350622374e-21,
2.053652379446798e-22,
3.398831621627872e-23,
-2.17154728171862e-23,
// [{0,1.e-6},{2.,0.00001}]: m=13
0.0146293467509953,
-9.14672394484399e-9,
-1.053054888854242e-8,
-8.08248542506206e-9,
-4.65264163149555e-9,
-2.1426105379385e-9,
-8.22249417478523e-10,
-2.70466214237998e-10,
-7.7843492909531e-11,
-1.991419204540017e-11,
-4.58472956634028e-12,
-9.59411914441657e-13,
-1.839345677817138e-13,
-3.25415539322147e-14,
-5.4575787084389e-15,
-8.31329980050216e-16,
-0.02711302157428695,
1.562352432683958e-8,
1.798723738709676e-8,
1.380569996918597e-8,
7.94718255799185e-9,
3.65979699557546e-9,
1.404486856988708e-9,
4.61984939254598e-10,
1.329653532428852e-10,
3.401587371223031e-11,
7.83137808131093e-12,
1.638855387402239e-12,
3.142105979959831e-13,
5.55955468076819e-14,
9.32616655674212e-15,
1.421232886631333e-15,
0.02525946417983128,
-1.349651765005122e-8,
-1.553843243036206e-8,
-1.192617574037e-8,
-6.86524493343506e-9,
-3.161549523793995e-9,
-1.213279792879706e-9,
-3.990907730626466e-10,
-1.148638925137301e-10,
-2.938522401355198e-11,
-6.76534960051971e-12,
-1.415800433811497e-12,
-2.71456849354033e-13,
-4.80349570081372e-14,
-8.05946747288144e-15,
-1.228649057813998e-15,
-0.01576155956989658,
7.84996958031411e-9,
9.03760728957271e-9,
6.93661352624669e-9,
3.99302834074424e-9,
1.838850705195884e-9,
7.05679816758978e-10,
2.321233980046985e-10,
6.68085065114059e-11,
1.70914631241386e-11,
3.934997743710111e-12,
8.23501321780981e-13,
1.578988513457661e-13,
2.794265269144617e-14,
4.689105849378903e-15,
7.15069089599793e-16,
0.0074064126869787,
-3.45406294377225e-9,
-3.97663520780825e-9,
-3.052177684755587e-9,
-1.756971679509412e-9,
-8.09112568868945e-10,
-3.105062813299343e-10,
-1.021367529298685e-10,
-2.939650896457582e-11,
-7.52046980424485e-12,
-1.731464885270194e-12,
-3.623601610236057e-13,
-6.94814529147112e-14,
-1.229660770705211e-14,
-2.063817680701733e-15,
-3.148091888673847e-16,
-0.00279430662114697,
1.2251593590669e-9,
1.410516268718642e-9,
1.082610370153495e-9,
6.23199618224255e-10,
2.869931029406071e-10,
1.101369617682196e-10,
3.622806413467649e-11,
1.042700537561169e-11,
2.66753623922223e-12,
6.14160780927035e-13,
1.285330775106875e-13,
2.464650822443347e-14,
4.362104851831757e-15,
7.32213464070705e-16,
1.11716411517636e-16,
0.00088136323450671,
-3.64597159081106e-10,
-4.19757832300092e-10,
-3.221757977157886e-10,
-1.854590155361855e-10,
-8.54067734061572e-11,
-3.277586137659318e-11,
-1.078118465464559e-11,
-3.10299890764555e-12,
-7.93841302423002e-13,
-1.827713495782161e-13,
-3.8251308611982e-14,
-7.33495428262474e-15,
-1.298253528705734e-15,
-2.179466153245289e-16,
-3.325985291951415e-17,
-0.0002389681807688802,
9.35653337923948e-11,
1.077210327949653e-10,
8.26788888355664e-11,
4.75937259978355e-11,
2.191765795229186e-11,
8.41116384206336e-12,
2.766742619084648e-12,
7.96314258653446e-13,
2.037219142470741e-13,
4.690450456433646e-14,
9.81651841455932e-15,
1.882426517862328e-15,
3.331955072783176e-16,
5.594139228295319e-17,
8.53855150669686e-18,
0.00005684088349276432,
-2.112455611991233e-11,
-2.432053575624201e-11,
-1.866668836033542e-11,
-1.074539500358211e-11,
-4.94842383750836e-12,
-1.899017516827083e-12,
-6.24657420634459e-13,
-1.797869507539096e-13,
-4.599519716772951e-14,
-1.058988916186094e-14,
-2.216351291978238e-15,
-4.250182476288815e-16,
-7.52325305488353e-17,
-1.263219153771476e-17,
-1.928420562835038e-18,
-0.00001204621033743424,
4.2603340605347e-12,
4.90488926937152e-12,
3.764639212590021e-12,
2.167097740326819e-12,
9.97982818379036e-13,
3.829880860582149e-13,
1.259790809576381e-13,
3.625894607142395e-14,
9.27620739099843e-15,
2.135754305167379e-15,
4.469946178744782e-16,
8.5719347604552e-17,
1.517372889671565e-17,
2.548004704366385e-18,
3.890307832053599e-19,
2.302567841261219e-6,
-7.76752409242873e-13,
-8.94268985035459e-13,
-6.86376390444884e-13,
-3.951095266129052e-13,
-1.819542148901105e-13,
-6.98271679080311e-14,
-2.296877404614467e-14,
-6.61081475592444e-15,
-1.691262909370062e-15,
-3.893979786993947e-16,
-8.14982253151213e-17,
-1.562901396420023e-17,
-2.766679282810941e-18,
-4.646201105741142e-19,
-7.094834135980096e-20,
-4.008951342547382e-7,
1.29270218653531e-13,
1.488277956862377e-13,
1.142294877635472e-13,
6.57557019892558e-14,
3.028154897452079e-14,
1.162091948986146e-14,
3.822557931001194e-15,
1.100199999535113e-15,
2.814676972398517e-16,
6.48056241916689e-17,
1.356345979388217e-17,
2.601117634460019e-18,
4.604510573241348e-19,
7.733346678645196e-20,
1.1830173654912e-20,
6.408902857743894e-8,
-1.97924205111505e-14,
-2.278685983944998e-14,
-1.748955147917667e-14,
-1.00677838682404e-14,
-4.636375438652462e-15,
-1.77926686761089e-15,
-5.85268100575323e-16,
-1.684506829278811e-16,
-4.309534991864888e-17,
-9.92238324137462e-18,
-2.076713402423211e-18,
-3.982636353818133e-19,
-7.05040824025774e-20,
-1.184296201594472e-20,
-1.810079069853817e-21,
-9.47461005345496e-9,
2.80728557427876e-15,
3.23200609186281e-15,
2.480655020308883e-15,
1.427978287716135e-15,
6.57606894565727e-16,
2.523648905790455e-16,
8.30123789769547e-17,
2.389247323499522e-17,
6.112510056901581e-18,
1.407364169602438e-18,
2.945413366739856e-19,
5.64885273635758e-20,
1.004698292885841e-20,
1.680531567693039e-21,
2.034670859794821e-22,
1.323047194928155e-9,
-3.76298181317461e-16,
-4.33229180188146e-16,
-3.325155133167572e-16,
-1.914111194740469e-16,
-8.81478970256802e-17,
-3.382786665234732e-17,
-1.112727163536625e-17,
-3.202633634176445e-18,
-8.19343938707492e-19,
-1.886484591367256e-19,
-3.948313867011676e-20,
-7.57351826130956e-21,
-1.342390034145742e-21,
-2.237529600798155e-22,
-3.262210577974894e-23,
-1.697044428199057e-10,
4.64625417046999e-17,
5.34919647551559e-17,
4.105657994948172e-17,
2.363404391204354e-17,
1.088385794519608e-17,
4.176818330096558e-18,
1.373915038863293e-18,
3.954384203793852e-19,
1.011640537187658e-19,
2.329223664315355e-20,
4.892070355284977e-21,
9.36789675674609e-22,
1.157849531357391e-22,
2.644066462570707e-23,
6.142881323588799e-23,
// [{0,1.e-6},{2.,0.00001}]: m=14
0.01355651078714347,
-7.81176216341979e-9,
-8.99361869354838e-9,
-6.90284998459298e-9,
-3.97359127899593e-9,
-1.829898497787728e-9,
-7.02243428494354e-10,
-2.30992469627299e-10,
-6.64826766214426e-11,
-1.700793685611515e-11,
-3.91568904065547e-12,
-8.1942769370112e-13,
-1.571052989979915e-13,
-2.7797773403841e-14,
-4.66308327837106e-15,
-7.10616443315668e-16,
-0.02525946417983128,
1.349651765005122e-8,
1.553843243036206e-8,
1.192617574037e-8,
6.86524493343505e-9,
3.16154952379399e-9,
1.213279792879706e-9,
3.99090773062647e-10,
1.148638925137301e-10,
2.938522401355198e-11,
6.76534960051971e-12,
1.415800433811497e-12,
2.714568493540329e-13,
4.80349570081372e-14,
8.05946747288144e-15,
1.228649057813984e-15,
0.02364233935484488,
-1.177495437047117e-8,
-1.355641093435907e-8,
-1.040492028937003e-8,
-5.98954251111636e-9,
-2.758276057793827e-9,
-1.058519725138467e-9,
-3.481850970070478e-10,
-1.002127597671089e-10,
-2.563719468620791e-11,
-5.90249661556517e-12,
-1.235251982671471e-12,
-2.368482770186492e-13,
-4.191397903716983e-14,
-7.03365877406836e-15,
-1.072603634399047e-15,
-0.01481282537395822,
6.90812588754472e-9,
7.95327041561675e-9,
6.10435536951137e-9,
3.513943359018934e-9,
1.61822513773794e-9,
6.21012562659888e-10,
2.042735058597434e-10,
5.87930179291535e-11,
1.504093960849017e-11,
3.462929770540496e-12,
7.24720322047234e-13,
1.389629058294272e-13,
2.459321541410484e-14,
4.127635361403118e-15,
6.29618377734957e-16,
0.00698576655286715,
-3.06289839766718e-9,
-3.52629067179652e-9,
-2.706525925383675e-9,
-1.5579990455606e-9,
-7.17482757351501e-10,
-2.753424044205425e-10,
-9.05701603366891e-11,
-2.606751343902861e-11,
-6.66884059805542e-12,
-1.535401952317552e-12,
-3.213326937767251e-13,
-6.16162705610827e-14,
-1.090526212953897e-14,
-1.830533660177073e-15,
-2.792910288398625e-16,
-0.002644089703480803,
1.09379147723294e-9,
1.259273496888328e-9,
9.66527393138195e-10,
5.56377046603277e-10,
2.562203202160404e-10,
9.83275841288465e-11,
3.234355396362987e-11,
9.30899672284832e-12,
2.381523907246407e-12,
5.48314048729449e-13,
1.147539258348605e-13,
2.200486284765258e-14,
3.894760586072431e-15,
6.538398459826831e-16,
9.97795587652606e-17,
0.000836388632698529,
-3.27478668275279e-10,
-3.77023614784563e-10,
-2.893761109261589e-10,
-1.665780409933893e-10,
-7.67118028334659e-11,
-2.943907344739231e-11,
-9.68359916685236e-12,
-2.787099905303205e-12,
-7.13026699868952e-13,
-1.641657659761383e-13,
-3.435781445078481e-14,
-6.58849281254887e-15,
-1.166184276573067e-15,
-1.95794872980034e-16,
-2.988492902306714e-17,
-0.0002273635347952441,
8.44982246971479e-11,
9.72821432753725e-11,
7.46667536335341e-11,
4.298158012496319e-11,
1.979369540098255e-11,
7.59607008686069e-12,
2.498629688969352e-12,
7.19147804866763e-13,
1.839807891445146e-13,
4.235955675641306e-14,
8.86540519066182e-15,
1.700072995094976e-15,
3.00930123142227e-16,
5.052876604670214e-17,
7.71368209746235e-18,
0.00005420794642480484,
-1.917150324855459e-11,
-2.207200168471174e-11,
-1.694087643557869e-11,
-9.75193981933814e-12,
-4.490922677118429e-12,
-1.72344638511779e-12,
-5.66905863604134e-13,
-1.631652571184501e-13,
-4.174293320677425e-14,
-9.61089436115673e-15,
-2.011475782692517e-15,
-3.857370639040595e-16,
-6.82817659117643e-17,
-1.1466021203891e-17,
-1.75065464169815e-18,
-0.00001151283041345668,
3.8837597258542e-12,
4.47134225376457e-12,
3.431879901840351e-12,
1.9755464527697e-12,
9.0977053090573e-13,
3.49135630947925e-13,
1.148438016167784e-13,
3.305405403113082e-14,
8.45630949439482e-15,
1.946988730808599e-15,
4.074908836664196e-16,
7.81450214846483e-17,
1.383338676209696e-17,
2.323101008887277e-18,
3.547429328287295e-19,
2.204923837799741e-6,
-7.10986355254737e-13,
-8.18553052030952e-13,
-6.28262317597658e-13,
-3.616564385944495e-13,
-1.665485551205897e-13,
-6.39150709179079e-14,
-2.102407313433113e-14,
-6.05110129642226e-15,
-1.548072672302355e-15,
-3.564310107278355e-16,
-7.45990139256546e-17,
-1.430614821694753e-17,
-2.53257289657698e-18,
-4.253348272835419e-19,
-6.496068381182727e-20,
-3.845840582163778e-7,
1.187676876375914e-13,
1.367363153052109e-13,
1.049489417355129e-13,
6.04133996158488e-14,
2.782133643517078e-14,
1.067678465435562e-14,
3.511997884931942e-15,
1.010816140545445e-15,
2.586007642918109e-16,
5.954089685907369e-17,
1.246165997673464e-17,
2.38985334903927e-18,
4.230760583580718e-19,
7.105841496198011e-20,
1.085658037804037e-20,
6.158307621750551e-8,
-1.824687509391166e-14,
-2.100748566560516e-14,
-1.612383247406161e-14,
-9.28161412980032e-15,
-4.274332107744411e-15,
-1.64032853591703e-15,
-5.395662371557014e-16,
-1.552969821903345e-16,
-3.973025155126792e-17,
-9.14762135971241e-18,
-1.91456707827267e-18,
-3.67174442449702e-19,
-6.501088361046347e-20,
-1.09176070973531e-20,
-1.659597072308038e-21,
-9.11804783840866e-9,
2.596276890647313e-15,
2.989073464624057e-15,
2.294197487906762e-15,
1.320644876331399e-15,
6.08178190619606e-16,
2.333960462231341e-16,
7.67728337063126e-17,
2.209663374513657e-17,
5.653079547860666e-18,
1.301587853683582e-18,
2.724152902146632e-19,
5.224262382156575e-20,
9.25900322763798e-21,
1.555361666588573e-21,
2.293827769100306e-22,
1.27510852647554e-9,
-3.49061262859178e-16,
-4.018715310389802e-16,
-3.084476466710816e-16,
-1.775565630499839e-16,
-8.17676576352604e-17,
-3.137937438208747e-17,
-1.03218728035216e-17,
-2.970826779225898e-18,
-7.60039976451607e-19,
-1.749954108606893e-19,
-3.662961884026525e-20,
-7.023591234260581e-21,
-1.235173130865743e-21,
-2.097116108311987e-22,
-4.067055537607682e-23,
-1.637692968501783e-10,
4.32162513961842e-17,
4.97545363011144e-17,
3.818799972297152e-17,
2.19827588384517e-17,
1.012341531441623e-17,
3.884989394659839e-18,
1.277921664983273e-18,
3.678101302183329e-19,
9.40975539233121e-20,
2.166425600971753e-20,
4.539244224448421e-21,
8.72904264602298e-22,
1.442125910866582e-22,
2.309875472319872e-23,
1.19563771542222e-23,
// [{0,1.e-6},{2.,0.00001}]: m=15
0.01262973208991564,
-6.74825882502561e-9,
-7.76921621518103e-9,
-5.963087870185e-9,
-3.43262246671753e-9,
-1.580774761896997e-9,
-6.06639896439853e-10,
-1.995453865313233e-10,
-5.7431946256865e-11,
-1.469261200677599e-11,
-3.38267480025986e-12,
-7.07900216905748e-13,
-1.357284246770165e-13,
-2.40174785040686e-14,
-4.02973373644072e-15,
-6.14324528906993e-16,
-0.02364233935484487,
1.177495437047117e-8,
1.355641093435907e-8,
1.040492028937003e-8,
5.98954251111636e-9,
2.758276057793826e-9,
1.058519725138467e-9,
3.48185097007048e-10,
1.002127597671089e-10,
2.56371946862079e-11,
5.90249661556517e-12,
1.235251982671471e-12,
2.368482770186492e-13,
4.19139790371698e-14,
7.03365877406836e-15,
1.072603634399024e-15,
0.02221923806093734,
-1.036218883131708e-8,
-1.192990562342512e-8,
-9.15653305426705e-9,
-5.2709150385284e-9,
-2.42733770660691e-9,
-9.31518843989832e-10,
-3.064102587896151e-10,
-8.81895268937302e-11,
-2.256140941273526e-11,
-5.19439465581074e-12,
-1.087080483070851e-12,
-2.084443587441409e-13,
-3.688982312115744e-14,
-6.19145304210454e-15,
-9.4442756660227e-16,
-0.01397153310573508,
6.12579679533456e-9,
7.05258134359328e-9,
5.41305185076753e-9,
3.115998091121303e-9,
1.434965514703049e-9,
5.50684808841103e-10,
1.811403206733842e-10,
5.21350268780589e-11,
1.333768119611127e-11,
3.070803904635206e-12,
6.42665387553473e-13,
1.232325411221694e-13,
2.181052425907492e-14,
3.66106732035419e-15,
5.585820576837592e-16,
0.00661022425870174,
-2.73447869308228e-9,
-3.14818374222074e-9,
-2.416318482845428e-9,
-1.39094261650816e-9,
-6.40550800540085e-10,
-2.458189603221104e-10,
-8.08588849090727e-11,
-2.327249180712023e-11,
-5.95380976811587e-12,
-1.370785121823591e-12,
-2.868848145871496e-13,
-5.5012157119126e-14,
-9.73690146516917e-15,
-1.634599614962309e-15,
-2.494488969235702e-16,
-0.002509165898057589,
9.82436004816159e-10,
1.131070844342546e-9,
8.68128332769925e-10,
4.99734122975245e-10,
2.301354084981307e-10,
8.83172203413069e-11,
2.90507975002709e-11,
8.36129971582725e-12,
2.139080099585793e-12,
4.924972979235628e-13,
1.030734433512852e-13,
1.976547843745224e-14,
3.498552829827121e-15,
5.873846189339909e-16,
8.96547869178737e-17,
0.000795772371790559,
-2.95743786441791e-10,
-3.40487501465845e-10,
-2.613336377189363e-10,
-1.504355304382731e-10,
-6.92779339038543e-11,
-2.658624530417183e-11,
-8.74520391144516e-12,
-2.517017317048759e-12,
-6.43932762009691e-13,
-1.482584486483279e-13,
-3.102891816737357e-14,
-5.9502554829171e-15,
-1.05325543128758e-15,
-1.768506810844574e-16,
-2.699788709507975e-17,
-0.0002168317864955526,
7.66860131970315e-11,
8.82880069723442e-11,
6.77635059215304e-11,
3.900775938051728e-11,
1.796369075598274e-11,
6.89378555870335e-12,
2.267623460413818e-12,
6.52661030199925e-13,
1.669717332685444e-13,
3.844357754631804e-14,
8.0459031528598e-15,
1.542948259660826e-15,
2.731270622538296e-16,
4.586408497793749e-17,
7.0026207961371e-18,
0.00005180773676996749,
-1.747691874405038e-11,
-2.012104011627421e-11,
-1.544345953858194e-11,
-8.88995902612363e-12,
-4.093967383853521e-12,
-1.571110337261545e-12,
-5.167971066163158e-13,
-1.487432429503967e-13,
-3.805339267588348e-14,
-8.76144927736453e-15,
-1.833708975689984e-15,
-3.516525961600967e-16,
-6.22502370350325e-17,
-1.0453954906239e-17,
-1.596346012473272e-18,
-0.00001102461069330195,
3.55492961258227e-12,
4.09276276911354e-12,
3.141309676044369e-12,
1.808281092369864e-12,
8.32742268757755e-13,
3.195751600812158e-13,
1.051203016902981e-13,
3.02554880671301e-14,
7.74035865141977e-15,
1.78215396874196e-15,
3.729948369048886e-16,
7.15306979893767e-17,
1.266287149691162e-17,
2.126672341089906e-18,
3.247879783208704e-19,
2.115212899992536e-6,
-6.5322242469495e-13,
-7.52049898454482e-13,
-5.77219305631618e-13,
-3.322737704682073e-13,
-1.530173838182006e-13,
-5.87223284261938e-14,
-1.931599258621747e-14,
-5.559489986970822e-15,
-1.422304516463714e-15,
-3.274750057552071e-16,
-6.8539135461153e-17,
-1.314419414347449e-17,
-2.326938935564513e-18,
-3.908219711504288e-19,
-5.969440342914647e-20,
-3.695466581591366e-7,
1.094935262811415e-13,
1.26059046932653e-13,
9.67538422709735e-14,
5.56959290537809e-14,
2.564886823607335e-14,
9.84307475977378e-15,
3.237760421329177e-15,
9.31886370698279e-16,
2.384082346221128e-16,
5.489188312464669e-17,
1.148870946494383e-17,
2.203291725918319e-18,
3.900606671361864e-19,
6.551517995376126e-20,
1.000826665938571e-20,
5.926548358105496e-8,
-1.687535007928322e-14,
-1.942845977248646e-14,
-1.491188628562551e-14,
-8.58396294273345e-15,
-3.953052894317835e-15,
-1.517033872861127e-15,
-4.990101217728936e-16,
-1.436242936083189e-16,
-3.67440312196017e-17,
-8.46008878714642e-18,
-1.770680788232793e-18,
-3.395811163327084e-19,
-6.012115297321342e-20,
-1.010024247058045e-20,
-1.541049036538743e-21,
-8.78731928160258e-9,
2.408171345360512e-15,
2.772509035764157e-15,
2.127978274050181e-15,
1.224961552698214e-15,
5.64114527414115e-16,
2.164860946978791e-16,
7.12105305455812e-17,
2.049571380957347e-17,
5.243515312240539e-18,
1.20729112034064e-18,
2.526834623287158e-19,
4.845809543546573e-20,
8.58143793552704e-21,
1.444153311904937e-21,
2.203996621561302e-22,
1.230518913978966e-9,
-3.24675401942807e-16,
-3.73796281505899e-16,
-2.868991122523304e-16,
-1.651522478631024e-16,
-7.60552762872303e-17,
-2.918717997331124e-17,
-9.60077924737784e-18,
-2.763284496083901e-18,
-7.06944853922156e-19,
-1.627697801464277e-19,
-3.406823808304364e-20,
-6.535686170297418e-21,
-1.155694236147766e-21,
-1.92287207821475e-22,
-3.096743866354723e-23,
-1.582348779374633e-10,
4.02983920334284e-17,
4.63952277608306e-17,
3.560963696916417e-17,
2.049853603902466e-17,
9.43990740625448e-18,
3.622685068840795e-18,
1.191639995209923e-18,
3.429766042790652e-19,
8.77450872159764e-20,
2.0202415664293e-20,
4.229711211480738e-21,
8.12762704969711e-22,
1.42636918802263e-22,
2.206222450243947e-23,
2.581437870818124e-24,
// [{0,1.e-6},{2.,0.00001}]: m=16
0.01182116967742244,
-5.88747718523558e-9,
-6.77820546717953e-9,
-5.20246014468502e-9,
-2.99477125555818e-9,
-1.379138028896913e-9,
-5.29259862569234e-10,
-1.740925485035239e-10,
-5.01063798835545e-11,
-1.281859734310395e-11,
-2.95124830778258e-12,
-6.17625991335736e-13,
-1.184241385093246e-13,
-2.095698951858492e-14,
-3.51682938703418e-15,
-5.36301817199512e-16,
-0.02221923806093734,
1.036218883131708e-8,
1.192990562342512e-8,
9.15653305426705e-9,
5.2709150385284e-9,
2.42733770660691e-9,
9.31518843989832e-10,
3.064102587896151e-10,
8.81895268937302e-11,
2.256140941273526e-11,
5.19439465581074e-12,
1.087080483070851e-12,
2.084443587441409e-13,
3.688982312115746e-14,
6.19145304210455e-15,
9.44427566602242e-16,
0.02095729965860263,
-9.18869519300184e-9,
-1.057887201538992e-8,
-8.11957777615129e-9,
-4.67399713668196e-9,
-2.152448272054574e-9,
-8.26027213261655e-10,
-2.717104810100763e-10,
-7.82025403170884e-11,
-2.000652179416691e-11,
-4.60620585695281e-12,
-9.63998081330209e-13,
-1.84848811683254e-13,
-3.271578638861251e-14,
-5.49160098053144e-15,
-8.37873086525542e-16,
-0.01322044851740424,
5.46895738616476e-9,
6.2963674844417e-9,
4.83263696569102e-9,
2.781885233016415e-9,
1.281101601080215e-9,
4.91637920644238e-10,
1.61717769818151e-10,
4.65449836142421e-11,
1.190761953623215e-11,
2.741570243647277e-12,
5.7376962917432e-13,
1.100243142382566e-13,
1.94738029303366e-14,
3.269199229923829e-15,
4.98897793849889e-16,
0.006272914745143712,
-2.45609001204034e-9,
-2.827677110856293e-9,
-2.170320831924757e-9,
-1.249335307438081e-9,
-5.75338521245312e-10,
-2.207930508532618e-10,
-7.26269937506754e-11,
-2.090324928956759e-11,
-5.34770024896435e-12,
-1.231243244808873e-12,
-2.576836083782109e-13,
-4.94136960936367e-14,
-8.74638207455869e-15,
-1.468461547326412e-15,
-2.241369673013849e-16,
-0.002387317115334922,
8.87231359316327e-10,
1.021462504387121e-9,
7.84000913148816e-10,
4.51306591310218e-10,
2.078338017094439e-10,
7.97587359117023e-11,
2.623561173406801e-11,
7.55105195106929e-12,
1.931798286009382e-12,
4.44775345940459e-13,
9.30867545011478e-14,
1.785076644854248e-14,
3.159766293899505e-15,
5.3055204327561e-16,
8.09936612066609e-17,
0.000758911252741411,
-2.68401046191271e-10,
-3.090080244051169e-10,
-2.371722707268241e-10,
-1.365271578326554e-10,
-6.28729176463287e-11,
-2.412824945561106e-11,
-7.93668211149748e-12,
-2.284313605713864e-12,
-5.84401066443545e-13,
-1.34552521412999e-13,
-2.816066103509195e-14,
-5.400318908689344e-15,
-9.55944718068152e-16,
-1.605242976052355e-16,
-2.450917266905226e-17,
-0.0002072309478501691,
6.99076751657667e-11,
8.04841606833418e-11,
6.17738383218368e-11,
3.555983620092044e-11,
1.637586957981977e-11,
6.28444136608743e-12,
2.067188432070789e-12,
5.94972973414991e-13,
1.522135711162415e-13,
3.504579720434858e-14,
7.33483592295793e-15,
1.406610388831136e-15,
2.490009479332961e-16,
4.181581935394227e-17,
6.385385051116275e-18,
0.00004961074803213924,
-1.599718323573705e-11,
-1.841743243696827e-11,
-1.413589352374626e-11,
-8.13726490504176e-12,
-3.747340204518004e-12,
-1.438088218488138e-12,
-4.730413569888479e-13,
-1.361496961244387e-13,
-3.483161388568487e-14,
-8.0196928483343e-15,
-1.678476764758633e-15,
-3.218881421158744e-16,
-5.698292014453783e-17,
-9.57002369483372e-18,
-1.461546730990103e-18,
-0.00001057605628200845,
3.26611010111657e-12,
3.76024716394703e-12,
2.886094741103107e-12,
1.661367823630404e-12,
7.65086445353089e-13,
2.93611460327988e-13,
9.65799031290688e-14,
2.779743272250388e-14,
7.11151817919089e-15,
1.637374015909154e-15,
3.426954630549547e-16,
6.57209274020451e-17,
1.163469321666802e-17,
1.954111318589273e-18,
2.984655451654303e-19,
2.032507181321179e-6,
-6.02214528207769e-13,
-6.93324912013037e-13,
-5.32146250600213e-13,
-3.063276777852356e-13,
-1.410688066086563e-13,
-5.41369231945005e-14,
-1.780768626957175e-14,
-5.125376175983998e-15,
-1.311245582664947e-15,
-3.019054268812052e-16,
-6.31879118032379e-17,
-1.211809921247408e-17,
-2.145340637902493e-18,
-3.603427480583569e-19,
-5.504323227219183e-20,
-3.556395265654102e-7,
1.012635743450683e-13,
1.165839684122834e-13,
8.94814565880859e-14,
5.15096140564692e-14,
2.372100512270633e-14,
9.10323469824562e-15,
2.994400017945529e-15,
8.61843415622285e-16,
2.204891691574424e-16,
5.076628165162199e-17,
1.062529605266233e-17,
2.037726222128775e-18,
3.60747955410797e-19,
6.059949495570809e-20,
9.26836640676083e-21,
5.711580581604733e-8,
-1.565269248426397e-14,
-1.802082373840542e-14,
-1.383148653478726e-14,
-7.96203581039105e-15,
-3.666645747752536e-15,
-1.407121745576989e-15,
-4.628559921349715e-16,
-1.332185554656422e-16,
-3.408192915946769e-17,
-7.84717475392756e-18,
-1.642408555173317e-18,
-3.149880092159401e-19,
-5.576501655100912e-20,
-9.3650652502038e-21,
-1.432509714515782e-21,
-8.47971783195298e-9,
2.239773317403198e-15,
2.57863371308136e-15,
1.979173574885892e-15,
1.139302808986733e-15,
5.246673349487345e-16,
2.013477647365933e-16,
6.62309760015278e-17,
1.906251727241371e-17,
4.876861743983475e-18,
1.12287084589606e-18,
2.35005573431146e-19,
4.507716442594379e-20,
8.00815351637647e-21,
1.335961728356585e-21,
1.777750818088642e-22,
1.188939563394604e-9,
-3.027564405170778e-16,
-3.485611535707768e-16,
-2.675304495713277e-16,
-1.540027652443768e-16,
-7.09207644123317e-17,
-2.721674947051545e-17,
-8.9526317705029e-18,
-2.576736612303412e-18,
-6.592202956622833e-19,
-1.51783401895212e-19,
-3.17677461104272e-20,
-6.090132326439019e-21,
-1.080156614158723e-21,
-1.841293620972435e-22,
-2.610923809439752e-23,
-1.530619617032547e-10,
3.76661415859309e-17,
4.33647384799625e-17,
3.328365208507968e-17,
1.915959334480976e-17,
8.82330318342403e-18,
3.386055794159844e-18,
1.11380410860965e-18,
3.205736401325546e-19,
8.20114885948413e-20,
1.888525274545777e-20,
3.964573973924536e-21,
7.53015655665891e-22,
1.05558754701731e-22,
2.784092201547545e-23,
3.077565121576199e-23,
// [{0,1.e-6},{2.,0.00001}]: m=17
0.01110961903046867,
-5.18109441565854e-9,
-5.96495281171256e-9,
-4.57826652713352e-9,
-2.6354575192642e-9,
-1.213668853303455e-9,
-4.65759421994916e-10,
-1.532051293948075e-10,
-4.40947634468651e-11,
-1.128070470636763e-11,
-2.59719732790537e-12,
-5.43540241535426e-13,
-1.042221793720704e-13,
-1.844491156057873e-14,
-3.09572652105227e-15,
-4.72213783301123e-16,
-0.02095729965860262,
9.18869519300184e-9,
1.057887201538992e-8,
8.11957777615129e-9,
4.67399713668196e-9,
2.152448272054574e-9,
8.26027213261655e-10,
2.717104810100763e-10,
7.82025403170884e-11,
2.000652179416691e-11,
4.60620585695281e-12,
9.63998081330209e-13,
1.84848811683254e-13,
3.271578638861251e-14,
5.49160098053143e-15,
8.37873086525538e-16,
0.01983067277610637,
-8.20343607924713e-9,
-9.44455122666255e-9,
-7.24895544853653e-9,
-4.17282784952462e-9,
-1.921652401620323e-9,
-7.37456880966357e-10,
-2.425766547272265e-10,
-6.98174754213631e-11,
-1.786142930434823e-11,
-4.112355365470916e-12,
-8.60654443761479e-13,
-1.650364713573849e-13,
-2.921070439550555e-14,
-4.903798844885729e-15,
-7.48346690774183e-16,
-0.01254582949028816,
4.91218002408085e-9,
5.65535422171279e-9,
4.34064166384967e-9,
2.498670614876252e-9,
1.150677042490666e-9,
4.41586101706539e-10,
1.452539875013561e-10,
4.180649857913668e-11,
1.069540049792908e-11,
2.462486489617835e-12,
5.1536721675644e-13,
9.8827392187276e-14,
1.749276414911796e-14,
2.93692309465404e-15,
4.482739346027852e-16,
0.005968292788337051,
-2.21807839829076e-9,
-2.553656260967736e-9,
-1.960002282871987e-9,
-1.128266478275516e-9,
-5.19584504273596e-10,
-1.993968397792505e-10,
-6.55890293351683e-11,
-1.887762987767273e-11,
-4.829495715023324e-12,
-1.111938364851119e-12,
-2.327168862528791e-13,
-4.4626916121353e-14,
-7.89941573470974e-15,
-1.326380108190443e-15,
-2.024841530552902e-16,
-0.00227673375818864,
8.0520313856534e-10,
9.27024073205595e-10,
7.11516812172985e-10,
4.09581473493656e-10,
1.886187529370011e-10,
7.23847483660714e-11,
2.381004633424187e-11,
6.85294081706948e-12,
1.753203199312186e-12,
4.036575642347352e-13,
8.44819831043869e-14,
1.620095672593659e-14,
2.867834154171145e-15,
4.815728927668771e-16,
7.35275180115214e-17,
0.000725308317482355,
-2.446768630817426e-10,
-2.816945623934912e-10,
-2.162084341278067e-10,
-1.244594267040146e-10,
-5.73155435297344e-11,
-2.199554478144616e-11,
-7.23515951229386e-12,
-2.082405406965745e-12,
-5.327474989103195e-13,
-1.226602902159724e-13,
-2.567192573014505e-14,
-4.92313636100936e-15,
-8.71503318675467e-16,
-1.463553676799529e-16,
-2.234884678825414e-17,
-0.0001984429928744689,
6.39887331205214e-11,
7.36697299523117e-11,
5.65435742518974e-11,
3.254905971049299e-11,
1.498936085966858e-11,
5.75235288991577e-12,
1.892165433206308e-12,
5.445987860090343e-13,
1.39326455929386e-13,
3.207877148256736e-14,
6.71390707765902e-15,
1.287552571442152e-15,
2.279316812697529e-16,
3.828009555783686e-17,
5.846186849825001e-18,
0.00004759225318401063,
-1.469749543542211e-11,
-1.692111221519346e-11,
-1.298742631764227e-11,
-7.47615519636565e-12,
-3.442888999497007e-12,
-1.321251569713759e-12,
-4.34609563501266e-13,
-1.250884470843521e-13,
-3.200183176275683e-14,
-7.3681830621805e-15,
-1.542129585934715e-15,
-2.95744171865742e-16,
-5.235610920239703e-17,
-8.79350191848878e-18,
-1.343104912774198e-18,
-0.0000101625279488242,
3.01107074661507e-12,
3.466622379029682e-12,
2.660729578995167e-12,
1.531637425291746e-12,
7.05343589273984e-13,
2.706844456703028e-13,
8.90383753289133e-14,
2.562686475683682e-14,
6.55622378842148e-15,
1.509526183192853e-15,
3.159393602509413e-16,
6.059046222332736e-17,
1.072669611589418e-17,
1.80170771951992e-18,
2.752165530967479e-19,
1.956017940324903e-6,
-5.56949784362313e-13,
-6.41211970713801e-13,
-4.92148122101013e-13,
-2.833029411304419e-13,
-1.304655575650122e-13,
-5.006780211912459e-14,
-1.646920380806455e-14,
-4.740139854281234e-15,
-1.212690709101626e-15,
-2.792146090592951e-16,
-5.843911615660174e-17,
-1.120750443069551e-17,
-1.984174370569703e-18,
-3.332896088637779e-19,
-5.091782451612085e-20,
-3.427399838830753e-7,
9.39269029437575e-14,
1.081373165640288e-13,
8.29984167031864e-14,
4.77776820549668e-14,
2.200239221745808e-14,
8.44369668518077e-15,
2.777453777033784e-15,
7.99402807894173e-16,
2.045149775788983e-16,
4.708844189538005e-17,
9.85557963084025e-18,
1.89012959731678e-18,
3.346281981112188e-19,
5.621386972339705e-20,
8.59530160797132e-21,
5.511645069954433e-8,
-1.455813113708693e-14,
-1.676066388407761e-14,
-1.286427881888912e-14,
-7.40526711747633e-15,
-3.410245048360001e-15,
-1.308724923497744e-15,
-4.304896531479822e-16,
-1.239029950646542e-16,
-3.169872355908589e-17,
-7.2984721050191e-18,
-1.527570477297587e-18,
-2.929669646927079e-19,
-5.187303275069608e-20,
-8.71106115442563e-21,
-1.326839521502715e-21,
-8.19290191547561e-9,
2.088425257632375e-15,
2.404387882014429e-15,
1.845435052462918e-15,
1.062316836664498e-15,
4.892140855306078e-16,
1.87742155067062e-16,
6.17555880156364e-17,
1.777442605101591e-17,
4.547326896597948e-18,
1.04700108852907e-18,
2.191314144015149e-19,
4.202968464309418e-20,
7.45827424588666e-21,
1.246652091488196e-21,
1.744389199348009e-22,
1.150075849887665e-9,
-2.829827643114181e-16,
-3.257958753487176e-16,
-2.500574648034318e-16,
-1.439445204831594e-16,
-6.62887842324111e-17,
-2.543917114600499e-17,
-8.36792033765597e-18,
-2.408446811276322e-18,
-6.161659727145175e-19,
-1.418706991789685e-19,
-2.969545878884956e-20,
-5.69250998939976e-21,
-1.003908271583305e-21,
-1.719936542025682e-22,
-3.021503701618793e-23,
-1.482162772610293e-10,
3.52834316308152e-17,
4.06215431766038e-17,
3.117817327503186e-17,
1.794758392303014e-17,
8.26515370809314e-18,
3.171859099852226e-18,
1.043346691924229e-18,
3.002952441939558e-19,
7.68247192253448e-20,
1.768908233204173e-20,
3.709469634053231e-21,
7.083418607422151e-22,
1.089200174494834e-22,
2.439823087634845e-23,
1.911490345428404e-23,
// [{0,1.e-6},{2.,0.00001}]: m=18
0.01047864982930131,
-4.59434759650092e-9,
-5.28943600769496e-9,
-4.05978888807565e-9,
-2.33699856834098e-9,
-1.076224136027287e-9,
-4.13013606630827e-10,
-1.358552405050381e-10,
-3.91012701585442e-11,
-1.000326089708345e-11,
-2.3031029284764e-12,
-4.81999040665104e-13,
-9.2424405841627e-14,
-1.635789319430625e-14,
-2.745800490265717e-15,
-4.1893654326277e-16,
-0.01983067277610636,
8.20343607924713e-9,
9.44455122666255e-9,
7.24895544853653e-9,
4.17282784952462e-9,
1.921652401620322e-9,
7.37456880966356e-10,
2.425766547272264e-10,
6.98174754213631e-11,
1.786142930434823e-11,
4.11235536547092e-12,
8.60654443761479e-13,
1.650364713573849e-13,
2.921070439550557e-14,
4.90379884488572e-15,
7.48346690774152e-16,
0.01881874423543225,
-7.36827003612127e-9,
-8.48303133256919e-9,
-6.51096249577451e-9,
-3.74800592231438e-9,
-1.726015563735999e-9,
-6.62379152559809e-10,
-2.178809812520341e-10,
-6.2709747868705e-11,
-1.604310074689362e-11,
-3.693729734426753e-12,
-7.73050825134661e-13,
-1.482410882809139e-13,
-2.623914622367744e-14,
-4.405384641981068e-15,
-6.72410901903681e-16,
-0.01193658557667482,
4.43615679658168e-9,
5.10731252193566e-9,
3.92000456574412e-9,
2.256532956551116e-9,
1.039169008547231e-9,
3.987936795585159e-10,
1.311780586703415e-10,
3.775525975534686e-11,
9.65899143004701e-12,
2.223876729702322e-12,
4.65433772505777e-13,
8.92538322427086e-14,
1.57988314694165e-14,
2.652760216381789e-15,
4.049683061143358e-16,
0.005691834395471355,
-2.013007846413296e-9,
-2.317560183013925e-9,
-1.778792030432413e-9,
-1.023953683734112e-9,
-4.7154688234249e-10,
-1.809618709151737e-10,
-5.95251158356031e-11,
-1.713235204267323e-11,
-4.383007998280342e-12,
-1.00914391058681e-12,
-2.112049577609735e-13,
-4.050239181483958e-14,
-7.16958538539782e-15,
-1.20393223191932e-15,
-1.838187950587356e-16,
-0.002175924952412564,
7.34030589237274e-10,
8.45083687171317e-10,
6.48625302376392e-10,
3.73378280107998e-10,
1.719466305873401e-10,
6.59866343436235e-11,
2.170547853664638e-11,
6.24721622082954e-12,
1.598242496713649e-12,
3.679808706439195e-13,
7.70157771895578e-14,
1.476940908289522e-14,
2.614509956107199e-15,
4.390661030061331e-16,
6.704654025120369e-17,
0.0006945504750672027,
-2.239605659232912e-10,
-2.578440548347791e-10,
-1.979025098829366e-10,
-1.139217089874714e-10,
-5.24627630091835e-11,
-2.013323511483701e-11,
-6.62257901626543e-12,
-1.906095751044098e-12,
-4.876425957560981e-13,
-1.122757001897195e-13,
-2.3498674771694e-14,
-4.506434000118134e-15,
-7.97760885114117e-16,
-1.33980334372921e-16,
-2.04616533109087e-17,
-0.0001903690134590629,
5.87899819083718e-11,
6.76844490526751e-11,
5.19497054178587e-11,
2.990462087024923e-11,
1.377155603703365e-11,
5.2850062938393e-12,
1.738438258933978e-12,
5.003537897560144e-13,
1.280073274138494e-13,
2.947273233243329e-14,
6.16851836178581e-15,
1.182976690420077e-15,
2.094244360022315e-16,
3.517400820095158e-17,
5.372421097207394e-18,
0.00004573137568721342,
-1.354981834133184e-11,
-1.559980068440836e-11,
-1.19732830891873e-11,
-6.89236840443504e-12,
-3.174046147414288e-12,
-1.218080003859023e-12,
-4.006726884350141e-13,
-1.153208912488848e-13,
-2.950300700716097e-14,
-6.79286781516723e-15,
-1.421727122079908e-15,
-2.726570790590744e-16,
-4.827012532408344e-17,
-8.1076857971395e-18,
-1.238481543445039e-18,
-9.78008198806019e-6,
2.78474714356392e-12,
3.206057806286164e-12,
2.460739039158064e-12,
1.416513801112913e-12,
6.52327371270015e-13,
2.503388507372258e-13,
8.23459664566513e-14,
2.370068413701246e-14,
6.06344967427891e-15,
1.396072152811704e-15,
2.921953906831486e-16,
5.603748903822248e-17,
9.92087419253225e-18,
1.666444088799398e-18,
2.545802419844207e-19,
1.885070439366627e-6,
-5.16598084189125e-13,
-5.94755376952877e-13,
-4.56491396136763e-13,
-2.627773113244646e-13,
-1.210131848372181e-13,
-4.644034237619451e-14,
-1.527599926257861e-14,
-4.396716447523991e-15,
-1.12483263701707e-15,
-2.589864893505525e-16,
-5.420568399778297e-17,
-1.039571866583134e-17,
-1.840495440911173e-18,
-3.091697441101813e-19,
-4.723513222047088e-20,
-3.307424676128625e-7,
8.73588757391865e-14,
1.005755985966246e-13,
7.71945879758436e-14,
4.443673462312356e-14,
2.046383362193639e-14,
7.85325650012928e-15,
2.583236252974295e-15,
7.43503836120084e-16,
1.902143067594377e-16,
4.37958933962756e-17,
9.16649202139297e-18,
1.757997194512207e-18,
3.112487706733917e-19,
5.228069402628371e-20,
7.98685036568917e-21,
5.325219831708557e-8,
-1.3574392279012e-14,
-1.562809307254863e-14,
-1.199499921577943e-14,
-6.90487026659119e-15,
-3.179804439220373e-15,
-1.220290575657159e-15,
-4.014003260841967e-16,
-1.155306047462864e-16,
-2.955680517713046e-17,
-6.80532095156317e-18,
-1.424362015515615e-18,
-2.731757640314295e-19,
-4.836467087857085e-20,
-8.12219238814611e-21,
-1.24255066691308e-21,
-7.924835471435845e-9,
1.951902597778246e-15,
2.247210415271386e-15,
1.724796971358627e-15,
9.92872070252312e-16,
4.572336765947278e-16,
1.754692870857658e-16,
5.771858639897348e-17,
1.661250829770174e-17,
4.250070316444248e-18,
9.78566388927101e-19,
2.04815758275542e-19,
3.926789152263976e-20,
6.95127679332608e-21,
1.182872601491716e-21,
1.836623182061497e-22,
1.113670352330858e-9,
-2.650834777515074e-16,
-3.051885669687795e-16,
-2.34240781584642e-16,
-1.348397177933449e-16,
-6.20958787525475e-17,
-2.383009273063077e-17,
-7.83863448417154e-18,
-2.256109301799482e-18,
-5.771935569632302e-19,
-1.328978688967504e-19,
-2.781544461310885e-20,
-5.331617775272082e-21,
-9.45694601016765e-22,
-1.621803819389814e-22,
-2.264867296449602e-23,
-1.436677497535284e-10,
3.31197091443474e-17,
3.813046640247895e-17,
2.926620241685631e-17,
1.684696643568533e-17,
7.75830192899043e-18,
2.977348465052442e-18,
9.79364744857324e-19,
2.818810292741778e-19,
7.21150348972481e-20,
1.659913436523251e-20,
3.474878359064435e-21,
6.807679747399689e-22,
1.209501268639325e-22,
4.1642566939522e-24,
-1.736055086829424e-24,
// [{0,1.e-6},{2.,0.00001}]: m=19
0.00991533638805318,
-4.10171803962357e-9,
-4.72227561333128e-9,
-3.62447772426827e-9,
-2.08641392476231e-9,
-9.60826200810161e-10,
-3.68728440483178e-10,
-1.212883273636132e-10,
-3.49087377106815e-11,
-8.93071465217411e-12,
-2.056177682735458e-12,
-4.3032722188074e-13,
-8.25182356786924e-14,
-1.460535219775279e-14,
-2.451899422442861e-15,
-3.74173345387076e-16,
-0.01881874423543225,
7.36827003612127e-9,
8.48303133256918e-9,
6.5109624957745e-9,
3.74800592231438e-9,
1.726015563735999e-9,
6.62379152559809e-10,
2.178809812520341e-10,
6.2709747868705e-11,
1.604310074689362e-11,
3.69372973442675e-12,
7.7305082513466e-13,
1.482410882809139e-13,
2.623914622367744e-14,
4.405384641981054e-15,
6.72410901903674e-16,
0.01790487836501223,
-6.65423519487253e-9,
-7.6609687829035e-9,
-5.88000684861618e-9,
-3.38479943482667e-9,
-1.558753512820847e-9,
-5.98190519337774e-10,
-1.967670880055122e-10,
-5.66328896330203e-11,
-1.448848714507052e-11,
-3.335815094553483e-12,
-6.98150658758666e-13,
-1.338807483640628e-13,
-2.369824720412473e-14,
-3.979140324572755e-15,
-6.07452459171518e-16,
-0.01138366879094341,
4.02601569282675e-9,
4.63512036602803e-9,
3.55758406086496e-9,
2.047907367468303e-9,
9.43093764685016e-10,
3.619237418303613e-10,
1.190502316712107e-10,
3.426470408534778e-11,
8.76601599656102e-12,
2.018287821173699e-12,
4.224099155219635e-13,
8.10047836296812e-14,
1.433917077079548e-14,
2.407864463839965e-15,
3.676375901183148e-16,
0.00543981238103117,
-1.835076473093133e-9,
-2.112709217928232e-9,
-1.621563255940933e-9,
-9.33445700269969e-10,
-4.29866576468338e-10,
-1.64966585859054e-10,
-5.42636963416144e-11,
-1.561804055207341e-11,
-3.995606241784009e-12,
-9.1995217660977e-13,
-1.925394429738876e-13,
-3.692352270724568e-14,
-6.53627489027115e-15,
-1.097665257505921e-15,
-1.676163506247149e-16,
-0.002083651425168135,
6.71881697762393e-10,
7.73532164495725e-10,
5.937075296422e-10,
3.417651269586091e-10,
1.573882890257983e-10,
6.03997053438386e-11,
1.98677370485751e-11,
5.71828725306863e-12,
1.462927787252008e-12,
3.368271005653958e-13,
7.04960243142888e-14,
1.3519302000239e-14,
2.393282655335591e-15,
4.019410030749563e-16,
6.138495991165568e-17,
0.0006662915471130918,
-2.057649366806828e-10,
-2.368955716859534e-10,
-1.818239689637262e-10,
-1.046661730465751e-10,
-4.82004461299414e-11,
-1.849752202856175e-11,
-6.08453390630978e-12,
-1.751238264157791e-12,
-4.480256459514741e-13,
-1.031545631643115e-13,
-2.158981426643385e-14,
-4.140418416216192e-15,
-7.32985525904591e-16,
-1.231090290124267e-16,
-1.880347396164333e-17,
-0.0001829255034503446,
5.41992735220921e-11,
6.23992029181154e-11,
4.78931324952742e-11,
2.756947369748151e-11,
1.269618462637934e-11,
4.87232002952871e-12,
1.602690758375666e-12,
4.612835663297248e-13,
1.180120283699571e-13,
2.717147133944564e-14,
5.686908504873855e-15,
1.090628318869365e-15,
1.930805016446867e-16,
3.243074386298248e-17,
4.953926370425855e-18,
0.00004401036886616099,
-1.253136212866708e-11,
-1.442726010828916e-11,
-1.107332566086182e-11,
-6.37431209617225e-12,
-2.93547316664601e-12,
-1.126524826755938e-12,
-3.705568485412707e-13,
-1.06653078468972e-13,
-2.728552349649647e-14,
-6.2823246775354e-15,
-1.314879255829913e-15,
-2.521687042196113e-16,
-4.46439351500413e-17,
-7.49899410976798e-18,
-1.145609435558042e-18,
-9.42534471295399e-6,
2.582988748512904e-12,
2.973774959305447e-12,
2.282455502840054e-12,
1.313885705907752e-12,
6.05065532418182e-13,
2.322015615349408e-13,
7.6379946858253e-14,
2.198356800385898e-14,
5.624159543702172e-15,
1.29493160693415e-15,
2.710282438753788e-16,
5.197856349394357e-17,
9.20247227189442e-18,
1.545843488060102e-18,
2.361748218777679e-19,
1.819084084611556e-6,
-4.8047392774471e-13,
-5.53165920281177e-13,
-4.24570332110534e-13,
-2.444020969805718e-13,
-1.125511109644136e-13,
-4.319292074550663e-14,
-1.420780267898533e-14,
-4.089272043182651e-15,
-1.0461789290334e-15,
-2.408774788953838e-16,
-5.0415719844654e-17,
-9.66896054281789e-18,
-1.711860960699004e-18,
-2.875727765097169e-19,
-4.393796679206712e-20,
-3.19555650194922e-7,
8.14558422527149e-14,
9.37794825629746e-14,
7.19783798691739e-14,
4.14340481447433e-14,
1.908104933796099e-14,
7.32259644495084e-15,
2.408682538274734e-15,
6.93264384504774e-16,
1.773614909485599e-16,
4.083668743880772e-17,
8.54716976193629e-18,
1.639232411554541e-18,
2.902187772352739e-19,
4.875327865116173e-20,
7.457976426698418e-21,
5.150981455381493e-8,
-1.268701648219033e-14,
-1.460646428255564e-14,
-1.12108706801856e-14,
-6.45349021734886e-15,
-2.97193681574709e-15,
-1.140518865450466e-15,
-3.751604500596376e-16,
-1.07978327244705e-16,
-2.7624694212771e-17,
-6.36047510533292e-18,
-1.331261440024305e-18,
-2.553195142484586e-19,
-4.52020276011857e-20,
-7.594587656483526e-21,
-1.164128849276975e-21,
-7.673739738643015e-9,
1.828331833493715e-15,
2.104944362539658e-15,
1.615603812989701e-15,
9.30015518911369e-16,
4.28287241728637e-16,
1.64360741034274e-16,
5.406457186417611e-17,
1.556082125703671e-17,
3.981016128970482e-18,
9.16616638727647e-19,
1.918441057106506e-19,
3.678815315601678e-20,
6.53187518498625e-21,
1.102431031023504e-21,
1.475285556184875e-22,
1.079497164763871e-9,
-2.488291058782116e-16,
-2.864750357716992e-16,
-2.198776247869863e-16,
-1.265716306953591e-16,
-5.828829368156079e-17,
-2.236888542140106e-17,
-7.35798879523978e-18,
-2.117771398909355e-18,
-5.418023829587816e-19,
-1.247482355362039e-19,
-2.610919080563361e-20,
-5.007669461753861e-21,
-8.8986012425943e-22,
-1.490533072589142e-22,
-1.902963331331448e-23,
-1.393898776684177e-10,
3.114895512491721e-17,
3.58615526915391e-17,
2.752474786586412e-17,
1.584450585154925e-17,
7.29665291281766e-18,
2.80018505224921e-18,
9.21089103427611e-19,
2.651076448300803e-19,
6.782310165730169e-20,
1.561425232428196e-20,
3.27432070468666e-21,
6.332931413282215e-22,
9.37193669370881e-23,
1.097275437838132e-23,
2.32151276231089e-23,
// [{0,1.e-6},{2.,0.00001}]: m=20
0.00940937211771612,
-3.68413501806064e-9,
-4.24151566628459e-9,
-3.25548124788725e-9,
-1.87400296115719e-9,
-8.63007781867999e-10,
-3.31189576279905e-10,
-1.08940490626017e-10,
-3.13548739343525e-11,
-8.02155037344681e-12,
-1.846864867213376e-12,
-3.8652541256733e-13,
-7.4120544140457e-14,
-1.311957311183872e-14,
-2.202692320990527e-15,
-3.36205450951837e-16,
-0.01790487836501223,
6.65423519487253e-9,
7.66096878290349e-9,
5.88000684861618e-9,
3.38479943482667e-9,
1.558753512820847e-9,
5.98190519337774e-10,
1.967670880055122e-10,
5.66328896330203e-11,
1.448848714507051e-11,
3.335815094553482e-12,
6.98150658758665e-13,
1.338807483640628e-13,
2.369824720412469e-14,
3.979140324572755e-15,
6.07452459171559e-16,
0.01707550318641511,
-6.03902353924012e-9,
-6.95268054904205e-9,
-5.33637609129745e-9,
-3.071861051202456e-9,
-1.414640647027525e-9,
-5.42885612745542e-10,
-1.785753475068161e-10,
-5.13970561280217e-11,
-1.314902399484154e-11,
-3.027431731760549e-12,
-6.33614873282945e-13,
-1.215071754445217e-13,
-2.150875615619356e-14,
-3.611796695760138e-15,
-5.51456385177152e-16,
-0.01087962476206302,
3.67015294618641e-9,
4.22541843585663e-9,
3.243126511881996e-9,
1.866891400540012e-9,
8.59733152936711e-10,
3.299331717181212e-10,
1.085273926832332e-10,
3.123608110414808e-11,
7.99121248356834e-12,
1.839904353219613e-12,
3.850788859477895e-13,
7.38470454144944e-14,
1.307254978054587e-14,
2.195330515011794e-15,
3.352327012460816e-16,
0.005209128562920105,
-1.679704244405934e-9,
-1.933830411239256e-9,
-1.484268824105456e-9,
-8.54412817396498e-10,
-3.934707225644842e-10,
-1.50999263359592e-10,
-4.96693426214363e-11,
-1.429571813267116e-11,
-3.657319468129912e-12,
-8.42067751413462e-13,
-1.762400607857264e-13,
-3.379825500060655e-14,
-5.98320663831542e-15,
-1.004852507675524e-15,
-1.53462399802319e-16,
-0.00199887464130677,
6.17294810035e-10,
7.10686715049746e-10,
5.45471906884951e-10,
3.139985191361401e-10,
1.446013383881732e-10,
5.54925660850516e-11,
1.825360171872092e-11,
5.25371479241339e-12,
1.344076937839071e-12,
3.094636894894028e-13,
6.47694427985867e-14,
1.242125524850182e-14,
2.198956577619101e-15,
3.693270870389919e-16,
5.641042196262414e-17,
0.0006402392620823987,
-1.896974573286263e-10,
-2.183972102149054e-10,
-1.676259637346121e-10,
-9.64931579418486e-11,
-4.443664619263314e-11,
-1.705312010346771e-11,
-5.60941765435339e-12,
-1.614492482165123e-12,
-4.130420992977337e-13,
-9.51001496887904e-14,
-1.990417976697502e-14,
-3.81719911583406e-15,
-6.75781756326865e-16,
-1.135076037988534e-16,
-1.733874170795883e-17,
-0.0001760414761458496,
5.01254486623736e-11,
5.77090406032085e-11,
4.42933027739669e-11,
2.549724845982208e-11,
1.174189270118404e-11,
4.506099320301954e-12,
1.482227398532793e-12,
4.266123151330068e-13,
1.091420943076409e-13,
2.512929878416791e-14,
5.259517038588798e-15,
1.008674819918328e-15,
1.785757417944012e-16,
2.999597644662247e-17,
4.582436983865592e-18,
0.00004241405113043468,
-1.162344935191326e-11,
-1.338198729799929e-11,
-1.027104974829298e-11,
-5.91248566824535e-12,
-2.722794892041325e-12,
-1.044907025433385e-12,
-3.437097603773847e-13,
-9.89260558779634e-14,
-2.530871791049664e-14,
-5.827192222131497e-15,
-1.219627098138228e-15,
-2.339035380148347e-16,
-4.141111867253934e-17,
-6.956292577827024e-18,
-1.06279371853991e-18,
-9.09541315559037e-6,
2.402368062940266e-12,
2.765827787218687e-12,
2.122850268113077e-12,
1.222009683350819e-12,
5.62755185694285e-13,
2.159644620699556e-13,
7.10389667982771e-14,
2.044634680445051e-14,
5.230891213895301e-15,
1.204386604611123e-15,
2.520784347674261e-16,
4.834477061793498e-17,
8.55929642679047e-18,
1.437863401422952e-18,
2.196930217832301e-19,
1.75755657440166e-6,
-4.48007237323999e-13,
-5.15787274906147e-13,
-3.958811820053593e-13,
-2.278873181727911e-13,
-1.049457959396423e-13,
-4.027428988050589e-14,
-1.324775706321203e-14,
-3.812955007112413e-15,
-9.75488431223324e-16,
-2.246018383807912e-16,
-4.700943094498008e-17,
-9.01576534116455e-18,
-1.596242056695725e-18,
-2.681609894763413e-19,
-4.097597849583129e-20,
-3.091001197986764e-7,
7.61310391335443e-14,
8.76490785254766e-14,
6.7273124117133e-14,
3.872548892685904e-14,
1.783371514890785e-14,
6.8439168900339e-15,
2.251227067526247e-15,
6.47946053590464e-16,
1.65767631835835e-16,
3.81673324074899e-17,
7.98850650580554e-18,
1.532097988125485e-18,
2.712457719442416e-19,
4.557165096603438e-20,
6.982668950416003e-21,
4.987773771051062e-8,
-1.188382619701134e-14,
-1.368175760030501e-14,
-1.050113254335821e-14,
-6.04493264556978e-15,
-2.783789599759853e-15,
-1.068315085888753e-15,
-3.514099381871612e-16,
-1.011425255275683e-16,
-2.587587786959811e-17,
-5.957828622405853e-18,
-1.246991158065296e-18,
-2.391590697140037e-19,
-4.234265564702483e-20,
-7.114535580778365e-21,
-1.089009499379278e-21,
-7.438053886309534e-9,
1.716126123421346e-15,
1.975762806235735e-15,
1.516453367893685e-15,
8.72940007827727e-16,
4.020030648855397e-16,
1.54273867061276e-16,
5.074662206860896e-17,
1.46058585190141e-17,
3.73670739829347e-18,
8.60364727537278e-19,
1.800621615681623e-19,
3.453549552874841e-20,
6.15770203845856e-21,
1.030043814891829e-21,
1.098524763831035e-22,
1.047357219962644e-9,
-2.340242247577207e-16,
-2.694302917630745e-16,
-2.067953083983665e-16,
-1.190408533470922e-16,
-5.482025113928441e-17,
-2.103798150361444e-17,
-6.92020462660937e-18,
-1.991769506564458e-18,
-5.095670041492413e-19,
-1.173261743229665e-19,
-2.455585106695835e-20,
-4.710255257176192e-21,
-8.36595000094574e-22,
-1.397086693146227e-22,
-1.886505398172096e-23,
-1.35359217776127e-10,
2.934890095142075e-17,
3.378916435979816e-17,
2.593413199344045e-17,
1.492887484917495e-17,
6.87499025772749e-18,
2.638366839001924e-18,
8.67861182603489e-19,
2.497873444496104e-19,
6.390187170499452e-20,
1.471351555606293e-20,
3.095462647303378e-21,
5.926896097027065e-22,
6.06914347214135e-23,
1.448346065782608e-23,
5.100308703771305e-23,
// [{0,1.e-6},{2.,0.00001}]: m=21
0.00895243918250611,
-3.32711759743626e-9,
-3.83048439145175e-9,
-2.94000342430809e-9,
-1.692399717413337e-9,
-7.79376756410423e-10,
-2.99095259668887e-10,
-9.83835440027561e-11,
-2.83164448165101e-11,
-7.24424357253526e-12,
-1.667907547276741e-12,
-3.49075329379333e-13,
-6.69403741820314e-14,
-1.184912360206234e-14,
-1.989570162286378e-15,
-3.03726229585781e-16,
-0.01707550318641511,
6.03902353924012e-9,
6.95268054904204e-9,
5.33637609129745e-9,
3.07186105120246e-9,
1.414640647027525e-9,
5.42885612745542e-10,
1.785753475068161e-10,
5.13970561280217e-11,
1.314902399484153e-11,
3.027431731760548e-12,
6.33614873282945e-13,
1.215071754445217e-13,
2.150875615619356e-14,
3.611796695760134e-15,
5.51456385177152e-16,
0.01631943714309453,
-5.50522941927962e-9,
-6.33812765378495e-9,
-4.864689767823e-9,
-2.800337100810018e-9,
-1.289599729405066e-9,
-4.94899757577182e-10,
-1.627910890248498e-10,
-4.68541216562221e-11,
-1.198681872535251e-11,
-2.759856529829419e-12,
-5.77618328921684e-13,
-1.107705681217417e-13,
-1.960882467081947e-14,
-3.292995772517634e-15,
-5.028490518683637e-16,
-0.01041825712584087,
3.35940848881201e-9,
3.86766082247867e-9,
2.968537648211035e-9,
1.708825634793066e-9,
7.86941445129001e-10,
3.019985267191965e-10,
9.93386852428767e-11,
2.859143626534349e-11,
7.31463893626013e-12,
1.684135502826993e-12,
3.524801215714673e-13,
6.75965100012159e-14,
1.19664132766314e-14,
2.009705015351186e-15,
3.069247996045967e-16,
0.0049971866032667,
-1.543237025087455e-9,
-1.776716787624311e-9,
-1.363679767212336e-9,
-7.84996297840327e-10,
-3.615033459704222e-10,
-1.387314152126249e-10,
-4.563400429680094e-11,
-1.313428698103307e-11,
-3.360192344597574e-12,
-7.73659223723484e-13,
-1.619236069964784e-13,
-3.105313812125228e-14,
-5.49739144399971e-15,
-9.23317717598333e-16,
-1.410260549610937e-16,
-0.001920717786215604,
5.69092371979227e-10,
6.55191630637057e-10,
5.02877891197958e-10,
2.89479473822162e-10,
1.333099385763411e-10,
5.11593603098051e-11,
1.682825296286345e-11,
4.843477446438752e-12,
1.239126297878716e-12,
2.853004490630382e-13,
5.97125393002319e-14,
1.145159734736349e-14,
2.027345268943437e-15,
3.405228113962552e-16,
5.201622513567877e-17,
0.000616145166516497,
-1.754390703195402e-10,
-2.019816421126492e-10,
-1.550265597099734e-10,
-8.92403696100044e-11,
-4.109662445443293e-11,
-1.577134762116766e-11,
-5.18779589490122e-12,
-1.493143102976018e-12,
-3.819973300795019e-13,
-8.79525457451989e-14,
-1.840830963475756e-14,
-3.530361869738736e-15,
-6.25015097526857e-16,
-1.049859175824144e-16,
-1.603852804277612e-17,
-0.0001696562051837986,
4.64937975470616e-11,
5.35279493524971e-11,
4.10841991163602e-11,
2.364994274389421e-11,
1.08911796008218e-11,
4.179628114265896e-12,
1.374839045631915e-12,
3.957042246983639e-13,
1.012348719455605e-13,
2.330876895837306e-14,
4.878508407044226e-15,
9.35614154972563e-16,
1.656444755343578e-16,
2.782517029919414e-17,
4.251174566398451e-18,
0.00004092935912442693,
-1.081065626773221e-11,
-1.244622502464022e-11,
-9.55282619281317e-12,
-5.49904356719483e-12,
-2.532398331993634e-12,
-9.71840077921497e-13,
-3.196753501340165e-13,
-9.20085604880953e-14,
-2.353901042785768e-14,
-5.419739712983502e-15,
-1.134352960112481e-15,
-2.175514677218096e-16,
-3.851681884437034e-17,
-6.470384772027141e-18,
-9.88635404235101e-19,
-8.78777580879673e-6,
2.240034699348822e-12,
2.578934662246841e-12,
1.979404595800834e-12,
1.139435834335247e-12,
5.24728631304391e-13,
2.013713157018703e-13,
6.62387413367521e-14,
1.906476237737074e-14,
4.877438917437681e-15,
1.123008446645351e-15,
2.350470000801871e-16,
4.507879584843933e-17,
7.98120152416056e-18,
1.340804909320752e-18,
2.048829207018523e-19,
1.700051143598519e-6,
-4.18720814434944e-13,
-4.82070046098839e-13,
-3.700022703026295e-13,
-2.129902395579197e-13,
-9.80854565567597e-14,
-3.764155181295265e-14,
-1.238175180427339e-14,
-3.563704139118522e-15,
-9.11722196893167e-16,
-2.099203782823838e-16,
-4.393676341302747e-17,
-8.42653831170905e-18,
-1.491944445896268e-18,
-2.5064865737099e-19,
-3.830205534884878e-20,
-2.993064998884593e-7,
7.13113952508363e-14,
8.21002602856815e-14,
6.30142515527493e-14,
3.627388805723682e-14,
1.670471421928189e-14,
6.41064906925025e-15,
2.108709146783251e-15,
6.0692696959125e-16,
1.552736417196219e-16,
3.575120063263848e-17,
7.48282593198786e-18,
1.435127872134463e-18,
2.541012290137479e-19,
4.268890202281552e-20,
6.521134315559376e-21,
4.834582260845034e-8,
-1.115450715212857e-14,
-1.284209828885667e-14,
-9.85667061829024e-15,
-5.67395101545738e-15,
-2.61294668327353e-15,
-1.00275202976108e-15,
-3.298437998804914e-16,
-9.49354192851404e-17,
-2.428789942897756e-17,
-5.592212286304994e-18,
-1.170471389597633e-18,
-2.244848564778556e-19,
-3.974394910286391e-20,
-6.678374378198342e-21,
-1.023343612069436e-21,
-7.216402653961203e-9,
1.61393425339459e-15,
1.858110104418857e-15,
1.426151638073828e-15,
8.20958218017201e-16,
3.780646253410378e-16,
1.450871969865362e-16,
4.772478250322281e-17,
1.373612000684315e-17,
3.514196106965199e-18,
8.09135476438964e-19,
1.693593357129473e-19,
3.247805360021884e-20,
5.744196366644785e-21,
9.68867273466696e-22,
1.517753193394477e-22,
1.017074421204568e-9,
-2.20501576672975e-16,
-2.538617724824362e-16,
-1.948460354257511e-16,
-1.121623071426381e-16,
-5.165257114987854e-17,
-1.982234521400198e-17,
-6.520336153768439e-18,
-1.876680324133725e-18,
-4.801235241927912e-19,
-1.105470669082953e-19,
-2.313667896138737e-20,
-4.438063176798e-21,
-7.88877087559752e-22,
-1.317220535709271e-22,
-1.739957115835577e-23,
-1.315549566086136e-10,
2.770039824304229e-17,
3.18912560304479e-17,
2.447743436413458e-17,
1.409033326583375e-17,
6.48882850949806e-18,
2.490172429434005e-18,
8.19114046989604e-19,
2.357574516428208e-19,
6.031632583110422e-20,
1.38863372104199e-20,
2.903616717977211e-21,
5.598258496949379e-22,
1.027677533031924e-22,
1.475347414297038e-23,
1.666410316982501e-24,
// [{0,1.e-6},{2.,0.00001}]: m=22
0.00853775159320756,
-3.01951176962006e-9,
-3.47634027452102e-9,
-2.66818804564872e-9,
-1.535930525601228e-9,
-7.07320323513762e-10,
-2.71442806372771e-10,
-8.9287673753408e-11,
-2.56985280640108e-11,
-6.57451199742077e-12,
-1.513715865880274e-12,
-3.16807436641473e-13,
-6.07535877222608e-14,
-1.075437807809678e-14,
-1.805898347880067e-15,
-2.757281925885724e-16,
-0.01631943714309453,
5.50522941927962e-9,
6.33812765378495e-9,
4.86468976782299e-9,
2.80033710081002e-9,
1.289599729405066e-9,
4.94899757577182e-10,
1.627910890248498e-10,
4.68541216562221e-11,
1.198681872535251e-11,
2.759856529829419e-12,
5.77618328921684e-13,
1.107705681217417e-13,
1.960882467081944e-14,
3.292995772517644e-15,
5.02849051868389e-16,
0.0156273856887613,
-5.03911273321801e-9,
-5.80149123371801e-9,
-4.45280647231655e-9,
-2.563238452189599e-9,
-1.180412167693501e-9,
-4.52997790078795e-10,
-1.490080278643151e-10,
-4.28871543980152e-11,
-1.097195840439019e-11,
-2.52620325424049e-12,
-5.28720182357201e-13,
-1.013947650018237e-13,
-1.794961991494642e-14,
-3.014557523026857e-15,
-4.603871994075796e-16,
-0.00999437320653404,
3.08647405017504e-9,
3.55343357524877e-9,
2.727359534424787e-9,
1.56999259568072e-9,
7.23006691940875e-10,
2.774628304252616e-10,
9.12680085936058e-11,
2.626857396206726e-11,
6.72038468919543e-12,
1.547318447447034e-12,
3.238472139929696e-13,
6.21062762425079e-14,
1.099478288800215e-14,
1.846635435195905e-15,
2.82052109920073e-16,
0.004801794465538791,
-1.422730929948023e-9,
-1.637979076592593e-9,
-1.257194727994856e-9,
-7.23698684555383e-10,
-3.332748464408426e-10,
-1.278984007745089e-10,
-4.207063240715732e-11,
-1.210869361609651e-11,
-3.097815744696697e-12,
-7.13251122657571e-13,
-1.492813482505625e-13,
-2.862899336841403e-14,
-5.068363172388714e-15,
-8.51307028484389e-16,
-1.300405628098947e-16,
-0.001848435499518763,
5.26317210952332e-10,
6.05944926330707e-10,
4.65079679124363e-10,
2.677211088268142e-10,
1.232898733618257e-10,
4.731404286293764e-11,
1.556338768451771e-11,
4.479429308874531e-12,
1.145991990224806e-12,
2.638576372324505e-13,
5.52249289036406e-14,
1.059108560907077e-14,
1.875045292493632e-15,
3.149577527644723e-16,
4.811558418822252e-17,
0.0005937967181491581,
-1.627282914158827e-10,
-1.873478227350838e-10,
-1.437946969082919e-10,
-8.27747996042234e-11,
-3.811912860314971e-11,
-1.462869840003557e-11,
-4.811936659746225e-12,
-1.384964786454196e-12,
-3.54322051811947e-13,
-8.15806913549491e-14,
-1.707477942502506e-14,
-3.274649542281009e-15,
-5.797556638113471e-16,
-9.73880961947099e-17,
-1.487911150057008e-17,
-0.0001637174371416679,
4.32426252027202e-11,
4.97849002502912e-11,
3.821130488771e-11,
2.199617433581748e-11,
1.012959335884671e-11,
3.887360323533584e-12,
1.278701404433191e-12,
3.680342430740682e-13,
9.41560419984779e-14,
2.167895891792825e-14,
4.537411853910616e-15,
8.70205873756824e-16,
1.540672766996552e-16,
2.588153893045535e-17,
3.954540833643675e-18,
0.00003954499106587089,
-1.00801561323951e-11,
-1.160520596321603e-11,
-8.90732066813656e-12,
-5.1274612470441e-12,
-2.361278837432233e-12,
-9.06170919339205e-13,
-2.98074335581375e-13,
-8.5791430573403e-14,
-2.194847509708492e-14,
-5.053538001917615e-15,
-1.057711496462038e-15,
-2.028545825678338e-16,
-3.591541184466321e-17,
-6.033620565981009e-18,
-9.21968809422326e-19,
-8.50024884787655e-6,
2.093602666166335e-12,
2.410348611767519e-12,
1.850010109094964e-12,
1.064950482596724e-12,
4.904269534257858e-13,
1.882076326693353e-13,
6.19087174450697e-14,
1.781850872899989e-14,
4.558607922440373e-15,
1.04960118701417e-15,
2.196836720137077e-16,
4.21326619098188e-17,
7.459711482131e-18,
1.253243890501053e-18,
1.91515482332867e-19,
1.646186221193182e-6,
-3.92212767803589e-13,
-4.51551539705218e-13,
-3.465784665359817e-13,
-1.995064320910212e-13,
-9.18759502077537e-14,
-3.525857832441098e-14,
-1.159790308509653e-14,
-3.338099131411026e-15,
-8.5400523102559e-16,
-1.966316539618713e-16,
-4.115556387802702e-17,
-7.89319715865637e-18,
-1.397534758119756e-18,
-2.34796611514973e-19,
-3.588344496031249e-20,
-2.901139137435027e-7,
6.69350199384878e-14,
7.70617736217119e-14,
5.91470726021383e-14,
3.404776375841848e-14,
1.567954872102072e-14,
6.01722928638634e-15,
1.979298683657725e-15,
5.696804082994495e-16,
1.457447677812514e-16,
3.355727116474352e-17,
7.02365699360551e-18,
1.347074559376173e-18,
2.385115680420088e-19,
4.006983430957472e-20,
6.122664386388954e-21,
4.690513025242737e-8,
-1.049027662672839e-14,
-1.207737487277583e-14,
-9.26972406933938e-15,
-5.33607784075195e-15,
-2.457350721917645e-15,
-9.43040168940218e-16,
-3.10202331683757e-16,
-8.92822626123001e-17,
-2.284163764173111e-17,
-5.259223302151693e-18,
-1.100778107822058e-18,
-2.111213086525929e-19,
-3.738158575069821e-20,
-6.279742100584644e-21,
-9.58802573712202e-22,
-7.007569587431577e-9,
1.520599889036141e-15,
1.750654978648479e-15,
1.34367683065377e-15,
7.73481959481032e-16,
3.562010528073221e-16,
1.366967812372642e-16,
4.496485941104399e-17,
1.294176546777424e-17,
3.310974829564008e-18,
7.62346577822258e-19,
1.595646816954198e-19,
3.059555636902611e-20,
5.411899061995293e-21,
9.18959646596484e-22,
1.470025207979462e-22,
9.88492423929113e-10,
-2.081173379663137e-16,
-2.396038949100416e-16,
-1.83902716335993e-16,
-1.058628336159258e-16,
-4.875156312813286e-17,
-1.870904743168767e-17,
-6.154130596421688e-18,
-1.77127974322633e-18,
-4.531583584352105e-19,
-1.043391552003834e-19,
-2.183845215353346e-20,
-4.187460144081536e-21,
-7.414797530104937e-22,
-1.257280458158633e-22,
-1.999794921387933e-23,
-1.279585519862261e-10,
2.618690881003649e-17,
3.014878741860711e-17,
2.314004103547423e-17,
1.33204686482849e-17,
6.13429354164649e-18,
2.354115218802353e-18,
7.74359798183781e-19,
2.228765543943054e-19,
5.702049661294783e-20,
1.312585525347773e-20,
2.744638075774117e-21,
5.354670828152475e-22,
1.026331768857533e-22,
6.032620854852588e-24,
-8.142050401889457e-24,
// [{0,1.e-6},{2.,0.00001}]: m=23
0.00815971857154726,
-2.75261470963981e-9,
-3.16906382689247e-9,
-2.4323448839115e-9,
-1.400168550405009e-9,
-6.44799864702533e-10,
-2.47449878788591e-10,
-8.13955445124249e-11,
-2.34270608281111e-11,
-5.99340936267625e-12,
-1.379928264914709e-12,
-2.88809164460842e-13,
-5.53852840608708e-14,
-9.80441233540972e-15,
-1.646497886258822e-15,
-2.514245259341965e-16,
-0.0156273856887613,
5.03911273321801e-9,
5.80149123371801e-9,
4.45280647231655e-9,
2.563238452189599e-9,
1.180412167693501e-9,
4.52997790078795e-10,
1.490080278643151e-10,
4.28871543980152e-11,
1.097195840439019e-11,
2.52620325424049e-12,
5.28720182357201e-13,
1.013947650018237e-13,
1.794961991494644e-14,
3.01455752302686e-15,
4.60387199407556e-16,
0.01499155980980106,
-4.62971107526256e-9,
-5.33015036287316e-9,
-4.09103930163718e-9,
-2.35498889352108e-9,
-1.084510037911313e-9,
-4.16194245637892e-10,
-1.369020128904087e-10,
-3.940286094310089e-11,
-1.008057703379315e-11,
-2.320977671170552e-12,
-4.85770820989454e-13,
-9.31594143637619e-14,
-1.649217433200371e-14,
-2.769953152793892e-15,
-4.230781648796118e-16,
-0.00960358893107821,
2.84546185989617e-9,
3.27595815318533e-9,
2.514389455989822e-9,
1.447397369110828e-9,
6.66549692881714e-10,
2.557968015490289e-10,
8.41412648143183e-11,
2.421738723219407e-11,
6.19563148939366e-12,
1.426502245315204e-12,
2.985626965011386e-13,
5.72579867368304e-14,
1.013672634477652e-14,
1.702614056968861e-15,
2.600811256213152e-16,
0.004621088748796693,
-1.315793027380788e-9,
-1.514862315826721e-9,
-1.162699197810871e-9,
-6.69302772067014e-10,
-3.082246834045544e-10,
-1.182851071573404e-10,
-3.890846921129305e-11,
-1.119857327218597e-11,
-2.864979975561923e-12,
-6.59644093081104e-13,
-1.38062322259104e-13,
-2.647771402267952e-14,
-4.687613231216894e-15,
-7.87394381906998e-16,
-1.20288960487537e-16,
-0.001781390154417564,
4.88184874241694e-10,
5.62043468198396e-10,
4.31384090719614e-10,
2.483243988096416e-10,
1.143573858080543e-10,
4.388609519957143e-11,
1.44358099790626e-11,
4.154894359311912e-12,
1.062966155422877e-12,
2.447420740618578e-13,
5.122433827444354e-14,
9.82394862673255e-15,
1.739266991435277e-15,
2.921642885731857e-16,
4.463733447229458e-17,
0.0005730110300015486,
-1.513491882106273e-10,
-1.742471508772935e-10,
-1.33739567107963e-10,
-7.69866101759241e-11,
-3.545357675622273e-11,
-1.360576113246704e-11,
-4.475454915548894e-12,
-1.288119850768651e-12,
-3.295461469971e-13,
-7.58763562133452e-14,
-1.588094148872294e-14,
-3.04572055804646e-15,
-5.392354686379738e-16,
-9.05853864032667e-17,
-1.384089274845293e-17,
-0.0001581799648903067,
4.03206246543619e-11,
4.64208239965241e-11,
3.562928278280928e-11,
2.050984505164887e-11,
9.44511537895905e-12,
3.624683688574259e-12,
1.19229734601535e-12,
3.43165723355609e-13,
8.77939006600483e-14,
2.021415207030638e-14,
4.230845998938373e-15,
8.11418332596496e-16,
1.436616477425302e-16,
2.413448251271957e-17,
3.68787543530029e-18,
0.00003825111974364103,
-9.42121198383427e-12,
-1.084656873693447e-11,
-8.32504547863203e-12,
-4.79227716460751e-12,
-2.206921287156619e-12,
-8.46934345761156e-13,
-2.785892280913715e-13,
-8.01832891621802e-14,
-2.05137356206203e-14,
-4.723205333954271e-15,
-9.88576522813119e-16,
-1.895969801914904e-16,
-3.356870136864621e-17,
-5.639595325940004e-18,
-8.61819631140757e-19,
-8.23092441867491e-6,
1.961062507793193e-12,
2.257756165897226e-12,
1.732891156344202e-12,
9.97531483302322e-13,
4.593794391988285e-13,
1.762927719493854e-13,
5.7989476060519e-14,
1.669048432714412e-14,
4.270023256299547e-15,
9.83157601797824e-16,
2.05777680413128e-16,
3.946596055746007e-17,
6.98766793059589e-18,
1.173980700199229e-18,
1.794174364417875e-19,
1.595626985165141e-6,
-3.68142698719053e-13,
-4.23839857450484e-13,
-3.253089780072369e-13,
-1.872627459720258e-13,
-8.62375388273402e-14,
-3.309476908114972e-14,
-1.088614539360432e-14,
-3.133243002845526e-15,
-8.01596416454431e-16,
-1.845650406619105e-16,
-3.863012481268363e-17,
-7.40889830811794e-18,
-1.311806913283531e-18,
-2.203997495951905e-19,
-3.368384645863575e-20,
-2.814687223442115e-7,
6.29492125021952e-14,
7.24729446504789e-14,
5.56250183904143e-14,
3.202030889025897e-14,
1.474587356434991e-14,
5.65891997993892e-15,
1.861437328347624e-15,
5.357578565028372e-16,
1.370662725863338e-16,
3.155912855329053e-17,
6.60545580694229e-18,
1.266873973782207e-18,
2.243278512242558e-19,
3.768914335634345e-20,
5.744540792091244e-21,
4.554775386775522e-8,
-9.88361859648283e-15,
-1.137893421388613e-14,
-8.73365137459412e-15,
-5.02748996226505e-15,
-2.315241093321882e-15,
-8.88503845419508e-16,
-2.922632860465698e-16,
-8.41190893190237e-17,
-2.152072750615125e-17,
-4.955096127786594e-18,
-1.037127407383477e-18,
-1.989121342000838e-19,
-3.52170207651211e-20,
-5.919536250338245e-21,
-9.07470112044054e-22,
-6.810474774209158e-9,
1.435128814109969e-15,
1.652252795772821e-15,
1.268150408130067e-15,
7.30005506418442e-16,
3.361794528566835e-16,
1.290132440423627e-16,
4.243745480270997e-17,
1.221433388260817e-17,
3.124871547318451e-18,
7.19495493210707e-19,
1.506081235651284e-19,
2.888433652877491e-20,
5.075698595531713e-21,
8.57523638358643e-22,
1.738477314985181e-22,
9.61471943446143e-10,
-1.967472886688622e-16,
-2.265136455929437e-16,
-1.73855584356923e-16,
-1.000792460613759e-16,
-4.608812864196407e-17,
-1.768692127246423e-17,
-5.817914688163723e-18,
-1.674510952371484e-18,
-4.284018602982773e-19,
-9.86381035311294e-20,
-2.06441194465689e-20,
-3.961511757143147e-21,
-7.047202962637374e-22,
-1.157858435819442e-22,
-1.470495300745869e-23,
-1.245534315950511e-10,
2.47940892456358e-17,
2.854524507482449e-17,
2.190927747762899e-17,
1.261198496821248e-17,
5.808025469929351e-18,
2.228905804891019e-18,
7.33173513133204e-19,
2.110219272954076e-19,
5.398973443724039e-20,
1.243089439267826e-20,
2.587324390162854e-21,
4.972924714144422e-22,
1.291096047260426e-22,
1.73007991504804e-23,
-4.275872570009778e-23,
// [{0,1.e-6},{2.,0.00001}]: m=24
0.00781369284438065,
-2.519556366609e-9,
-2.900745616859e-9,
-2.22640323615828e-9,
-1.281619226094799e-9,
-5.90206083846751e-10,
-2.26498895039397e-10,
-7.45040139321575e-11,
-2.14435771990076e-11,
-5.48597920219509e-12,
-1.263101627120245e-12,
-2.64360091178601e-13,
-5.06973825009119e-14,
-8.97480995747322e-15,
-1.50727876151343e-15,
-2.301935997037779e-16,
-0.01499155980980106,
4.62971107526256e-9,
5.33015036287316e-9,
4.09103930163718e-9,
2.35498889352108e-9,
1.084510037911313e-9,
4.16194245637892e-10,
1.369020128904086e-10,
3.94028609431009e-11,
1.008057703379315e-11,
2.320977671170551e-12,
4.85770820989454e-13,
9.31594143637619e-14,
1.649217433200369e-14,
2.769953152793897e-15,
4.230781648796229e-16,
0.01440538339661731,
-4.26819278984425e-9,
-4.91393722977799e-9,
-3.77158418398473e-9,
-2.171096053666243e-9,
-9.99824539322571e-10,
-3.83695202323543e-10,
-1.262118972214775e-10,
-3.632608084829111e-11,
-9.2934472340905e-12,
-2.139753367972807e-12,
-4.47844044751708e-13,
-8.58869801052456e-14,
-1.520508951716447e-14,
-2.55392108545332e-15,
-3.901216884323252e-16,
-0.00924217749759399,
2.63158605476169e-9,
3.02972463165358e-9,
2.325398395621847e-9,
1.338605544134088e-9,
6.16449366809136e-10,
2.365702143146913e-10,
7.78169384225896e-11,
2.239714654437295e-11,
5.7299599511241e-12,
1.319288186162268e-12,
2.761246445182196e-13,
5.29554280453621e-14,
9.37522646243577e-15,
1.574788763813357e-15,
2.40577920973723e-16,
0.004453475386043702,
-1.220462185604195e-9,
-1.405108670495945e-9,
-1.078460226799001e-9,
-6.20810997024084e-10,
-2.858934645201266e-10,
-1.09715237998925e-10,
-3.608952494765534e-11,
-1.038723589827944e-11,
-2.657415388557109e-12,
-6.11855185154624e-13,
-1.280608456860941e-13,
-2.455987156683195e-14,
-4.348167478618677e-15,
-7.30410721431858e-16,
-1.115933361465191e-16,
-0.001719033089975511,
4.54047564626236e-10,
5.22741452625381e-10,
4.012187013189e-10,
2.309598305249005e-10,
1.063607302673457e-10,
4.081728339689357e-11,
1.342636474647973e-11,
3.864359552257902e-12,
9.88638440979002e-13,
2.276290686372133e-13,
4.764282446559987e-14,
9.13716167400269e-15,
1.617706405840777e-15,
2.717561592318163e-16,
4.152267829257701e-17,
0.0005536298771216404,
-1.411221862913174e-10,
-1.624728839890441e-10,
-1.24702489740761e-10,
-7.17844576813056e-11,
-3.305790382660282e-11,
-1.268639291010437e-11,
-4.173040711084804e-12,
-1.201080031753573e-12,
-3.072786523124019e-13,
-7.07495322466082e-14,
-1.4807960996716e-14,
-2.839964164095163e-15,
-5.028157661901294e-16,
-8.44706887990581e-17,
-1.290756503404761e-17,
-0.0001530044795851382,
3.76848480536532e-11,
4.33862750839543e-11,
3.330018201907806e-11,
1.916910871861379e-11,
8.82768517634207e-12,
3.387737393680848e-12,
1.114356915864145e-12,
3.207331576557277e-13,
8.20549427401808e-14,
1.889282139501471e-14,
3.954306103328083e-15,
7.58387923488877e-16,
1.342748066794236e-16,
2.25583809957027e-17,
3.44727781221493e-18,
0.00003703915981404808,
-8.82478127185791e-12,
-1.015990273132727e-11,
-7.79801019187462e-12,
-4.488891668140191e-12,
-2.067207473299941e-12,
-7.93317472584566e-13,
-2.609526418816035e-13,
-7.5107179359721e-14,
-1.921510462531499e-14,
-4.424209201446119e-15,
-9.25999556228269e-16,
-1.775968221528549e-16,
-3.144451762225642e-17,
-5.282913387254792e-18,
-8.07365237730444e-19,
-7.978128411887e-6,
1.840712231345565e-12,
2.119197834034001e-12,
1.626543774650212e-12,
9.36313087792794e-13,
4.311873984541714e-13,
1.654737319337115e-13,
5.443068964271092e-14,
1.566620427109724e-14,
4.007979333289588e-15,
9.228245713249e-16,
1.931504940348152e-16,
3.704446372488909e-17,
6.55902437731025e-18,
1.102000678100176e-18,
1.684244753592534e-19,
1.548078420856013e-6,
-3.46220753321314e-13,
-3.98601292930041e-13,
-3.059376758679872e-13,
-1.761117419090917e-13,
-8.11023244119488e-14,
-3.112406749126911e-14,
-1.023790780678429e-14,
-2.946668930439071e-15,
-7.53864678547401e-16,
-1.735752490755182e-16,
-3.633004344279259e-17,
-6.96781054660843e-18,
-1.233725644695645e-18,
-2.07287173864241e-19,
-3.168083175311641e-20,
-2.733234805166047e-7,
5.93088729915013e-14,
6.82818501628458e-14,
5.24082364242765e-14,
3.016858256241441e-14,
1.389312412387209e-14,
5.331666859647565e-15,
1.753791482724939e-15,
5.047754870483817e-16,
1.291399602738224e-16,
2.973416439175533e-17,
6.223507503954277e-18,
1.193624780502794e-18,
2.113478252011636e-19,
3.551278035835759e-20,
5.426104889228339e-21,
4.426667418260586e-8,
-9.32807078618565e-15,
-1.073933634674556e-14,
-8.24274215543702e-15,
-4.744900228607856e-15,
-2.185104014579057e-15,
-8.3856212830095e-16,
-2.758355742040493e-16,
-7.93909018299943e-17,
-2.031109993071176e-17,
-4.676589451813691e-18,
-9.78837641656375e-19,
-1.877330049692262e-19,
-3.323662596468786e-20,
-5.587784712328931e-21,
-8.59070387175001e-22,
-6.624156220227017e-9,
1.356662415673645e-15,
1.56191504160457e-15,
1.198813658582697e-15,
6.90092110012742e-16,
3.177986960648082e-16,
1.219593997859847e-16,
4.011717885047508e-17,
1.154651708849445e-17,
2.954024075397754e-18,
6.80157600173898e-19,
1.423620527103721e-19,
2.730846238472593e-20,
4.830738179713381e-21,
8.06989457379786e-22,
1.298690572895313e-22,
9.35888491088682e-10,
-1.862836928192959e-16,
-2.144669889818994e-16,
-1.646094387785666e-16,
-9.47567426500817e-17,
-4.363703060910436e-17,
-1.674628175549283e-17,
-5.508502773559551e-18,
-1.585456674844876e-18,
-4.05618706833479e-19,
-9.33921238702604e-20,
-1.95459334536919e-20,
-3.751735411314049e-21,
-6.692414159529787e-22,
-1.087847810288789e-22,
-1.095405243974109e-23,
-1.213247383009115e-10,
2.350945061712155e-17,
2.706625059074875e-17,
2.077410786520567e-17,
1.19585295064718e-17,
5.507098737475472e-18,
2.113421416477965e-18,
6.9518657417684e-19,
2.000883360637827e-19,
5.119001505287791e-20,
1.178798503944743e-20,
2.46602550361576e-21,
4.680780644892388e-22,
8.856760736871403e-23,
2.048626739788151e-23,
-4.349495274693167e-24,
// [{0,1.e-6},{2.,0.00001}]: m=25
0.00749577990490053,
-2.31485553763128e-9,
-2.66507518143658e-9,
-2.04551965081859e-9,
-1.17749444676054e-9,
-5.42255018955656e-10,
-2.08097122818946e-10,
-6.84510064452043e-11,
-1.970143047155044e-11,
-5.04028851689658e-12,
-1.160488835585276e-12,
-2.42885410494727e-13,
-4.65797071818809e-14,
-8.24608716600185e-15,
-1.384976576396948e-15,
-2.115390824398117e-16,
-0.01440538339661731,
4.26819278984425e-9,
4.91393722977799e-9,
3.77158418398473e-9,
2.171096053666243e-9,
9.99824539322571e-10,
3.83695202323543e-10,
1.262118972214775e-10,
3.63260808482911e-11,
9.29344723409049e-12,
2.139753367972807e-12,
4.47844044751708e-13,
8.58869801052456e-14,
1.520508951716445e-14,
2.553921085453314e-15,
3.901216884323467e-16,
0.01386326624639099,
-3.94737908214254e-9,
-4.54458694748037e-9,
-3.48809759343277e-9,
-2.007908316201133e-9,
-9.24674050213705e-10,
-3.54855321472037e-10,
-1.167254076338844e-10,
-3.359571981655943e-11,
-8.59493992668616e-12,
-1.978932279243402e-12,
-4.141869667773293e-13,
-7.9433142068043e-14,
-1.40628396936538e-14,
-2.362183145720123e-15,
-3.608668814604782e-16,
-0.00890695077208799,
2.4409243712085e-9,
2.81021734099202e-9,
2.156920453598101e-9,
1.241621994048225e-9,
5.71786929040279e-10,
2.194304759978601e-10,
7.2179049895314e-11,
2.077447179655984e-11,
5.31483077711446e-12,
1.223710370309304e-12,
2.561216913721992e-13,
4.911974313366626e-14,
8.69633495723969e-15,
1.460821442863659e-15,
2.231866722908472e-16,
0.004297582724938574,
-1.135118911565553e-9,
-1.306853631563408e-9,
-1.003046753297217e-9,
-5.77399576312232e-10,
-2.659018256683554e-10,
-1.020432084922306e-10,
-3.356591186619823e-11,
-9.66089888064444e-12,
-2.471596102447421e-12,
-5.69072671593014e-13,
-1.191070611639988e-13,
-2.284290418500775e-14,
-4.044266014596687e-15,
-6.79390398078071e-16,
-1.038066957347422e-16,
-0.001660889631336523,
4.23366558868592e-10,
4.87418651960961e-10,
3.74107469217546e-10,
2.153533730411899e-10,
9.91737114785527e-11,
3.805917872983121e-11,
1.25191221330959e-11,
3.603240095215093e-12,
9.2183595692553e-13,
2.122485967371431e-13,
4.442388298960888e-14,
8.51989249216087e-15,
1.508447298483687e-15,
2.534120664125936e-16,
3.872269517791752e-17,
0.0005355156785534135,
-1.318969681887852e-10,
-1.518519627949903e-10,
-1.16550637067656e-10,
-6.70918805156564e-11,
-3.089689811743128e-11,
-1.185708087797278e-11,
-3.900249205554047e-12,
-1.122566051803549e-12,
-2.871922995928234e-13,
-6.61248748830528e-14,
-1.384007136171311e-14,
-2.654357732247434e-15,
-4.699618234186504e-16,
-7.89543334515075e-17,
-1.206547235184506e-17,
-0.0001481566398513381,
3.52991251997719e-11,
4.06396110546456e-11,
3.119204086676784e-11,
1.795556672970478e-11,
8.26882991951552e-12,
3.173269900437277e-12,
1.043810570848369e-12,
3.004287183950339e-13,
7.68604187459356e-14,
1.769683686197834e-14,
3.703998236336145e-15,
7.10387291227775e-16,
1.257780719318949e-16,
2.113165322359619e-17,
3.229459793297888e-18,
0.00003590157778522747,
-8.28320502849447e-12,
-9.53639023869211e-12,
-7.31944697482681e-12,
-4.213408888678398e-12,
-1.940343290101449e-12,
-7.44631792572547e-13,
-2.449381030208011e-13,
-7.04979191130203e-14,
-1.803590697233742e-14,
-4.152710564842275e-15,
-8.69177221994652e-16,
-1.66700085781009e-16,
-2.951561002082014e-17,
-4.959004065912431e-18,
-7.57909219513849e-19,
-7.74038575493814e-6,
1.731102568109401e-12,
1.993005084829578e-12,
1.529687320288825e-12,
8.80558099907043e-13,
4.055113413112549e-13,
1.556202297154407e-13,
5.118950359377599e-14,
1.473333445160206e-14,
3.769320782615037e-15,
8.67875645594455e-16,
1.816500941962868e-16,
3.483902561638444e-17,
6.168616186209818e-18,
1.036438435574962e-18,
1.584127054646261e-19,
1.50327957976328e-6,
-3.2619888184659e-13,
-3.75550268451881e-13,
-2.88245371373028e-13,
-1.659272449868804e-13,
-7.64122015134828e-14,
-2.932417495514591e-14,
-9.64585553213943e-15,
-2.776265863231665e-15,
-7.10269956984871e-16,
-1.635379425032711e-16,
-3.422930013932174e-17,
-6.56494489819265e-18,
-1.162407626454831e-18,
-1.953111749544297e-19,
-2.985260321305589e-20,
-2.656360685604884e-7,
5.5975224430214e-14,
6.4443846538167e-14,
4.94624614939295e-14,
2.84728601752473e-14,
1.311221692325728e-14,
5.031984041410061e-15,
1.655214516134094e-15,
4.764032839947247e-16,
1.218814072196497e-16,
2.806294173815865e-17,
5.873729569452083e-18,
1.126545897833958e-18,
1.994714540719215e-19,
3.351881314933065e-20,
5.124602949888135e-21,
4.305563837934306e-8,
-8.81805232601405e-15,
-1.015215606073311e-14,
-7.79206488539562e-15,
-4.485469830617059e-15,
-2.065632170978232e-15,
-7.92713321021646e-16,
-2.60754170370028e-16,
-7.50502035089062e-17,
-1.920060408443013e-17,
-4.420905392280173e-18,
-9.25322552906661e-19,
-1.774726634141894e-19,
-3.14231998604061e-20,
-5.280015526269465e-21,
-8.100531761492128e-22,
-6.447754192079596e-9,
1.284456091577168e-15,
1.478784461653416e-15,
1.135008615512909e-15,
6.53363015034742e-16,
3.008843598359059e-16,
1.154683118382541e-16,
3.798201451265215e-17,
1.093197823532005e-17,
2.79680377945787e-18,
6.4395872019164e-19,
1.347857328735782e-19,
2.585519824794949e-20,
4.578054641888344e-21,
7.646547594283668e-22,
1.152669151764576e-22,
9.11630461359135e-10,
-1.766327427354558e-16,
-2.033559250423769e-16,
-1.560813865887922e-16,
-8.98476064170443e-17,
-4.137629463964083e-17,
-1.587869597608271e-17,
-5.223120963397852e-18,
-1.503318423633588e-18,
-3.846045021218179e-19,
-8.85547116120703e-20,
-1.853525768883696e-20,
-3.5550133063776e-21,
-6.309750474725441e-22,
-1.059433728459568e-22,
-1.293513951609009e-23,
-1.182591139625149e-10,
2.232207813761916e-17,
2.56992378593217e-17,
1.972488736260987e-17,
1.135455025951784e-17,
5.228956603404751e-18,
2.006680875274575e-18,
6.60075435438223e-19,
1.899827266933493e-19,
4.860509870528031e-20,
1.119242058356054e-20,
2.341553018183252e-21,
4.457825103641225e-22,
7.97369420145151e-23,
1.741061864009586e-23,
3.464784037097228e-24,
// [{0,1.e-6},{2.,0.00001}]: m=26
0.00720269169830865,
-2.13409639492213e-9,
-2.456968614889e-9,
-1.88579209199237e-9,
-1.085548026833121e-9,
-4.99912269661286e-10,
-1.91847601161772e-10,
-6.31059486107387e-11,
-1.816304042414555e-11,
-4.64672361704525e-12,
-1.069876683986403e-12,
-2.23922022375854e-13,
-4.29434900526228e-14,
-7.60254475858222e-15,
-1.276960542726657e-15,
-1.950608442161737e-16,
-0.01386326624639099,
3.94737908214254e-9,
4.54458694748036e-9,
3.48809759343277e-9,
2.007908316201133e-9,
9.24674050213705e-10,
3.54855321472037e-10,
1.167254076338844e-10,
3.35957198165594e-11,
8.59493992668615e-12,
1.978932279243401e-12,
4.14186966777329e-13,
7.9433142068043e-14,
1.406283969365379e-14,
2.362183145720112e-15,
3.60866881460495e-16,
0.01336042615813199,
-3.66138655681275e-9,
-4.21532601148803e-9,
-3.23538068039715e-9,
-1.862432991072337e-9,
-8.57680393560419e-10,
-3.291457139967902e-10,
-1.08268574842971e-10,
-3.116170769483976e-11,
-7.97224616567169e-12,
-1.835565555463956e-12,
-3.841825370582988e-13,
-7.36796147004995e-14,
-1.304450243585965e-14,
-2.191232164295327e-15,
-3.347800084361047e-16,
-0.00859516544987773,
2.27023782313121e-9,
2.613707263126939e-9,
2.006093506594528e-9,
1.154799152624519e-9,
5.31803651336736e-10,
2.040864169844707e-10,
6.71318237323996e-11,
1.932179776128977e-11,
4.94319220489507e-12,
1.138145343186081e-12,
2.382141223280087e-13,
4.568580837001714e-14,
8.08853202919466e-15,
1.358780796156899e-15,
2.0761339146777e-16,
0.004152224078341108,
-1.058416397171443e-9,
-1.218546629902361e-9,
-9.35268673043834e-10,
-5.38383432602957e-10,
-2.479342786963734e-10,
-9.51479468245748e-11,
-3.129780533273869e-11,
-9.00810023803743e-12,
-2.304589892313746e-12,
-5.30621491842843e-13,
-1.110597074740194e-13,
-2.129973123039305e-14,
-3.771118246203403e-15,
-6.335301660410768e-16,
-9.6806737953535e-17,
-0.001606547035632542,
3.95690904561259e-10,
4.55555888379103e-10,
3.496519111984645e-10,
2.012756415443769e-10,
9.26906943511e-11,
3.557124263346018e-11,
1.170074761651143e-11,
3.367698155367269e-12,
8.61576898767375e-13,
1.983746246466024e-13,
4.152021408460348e-14,
7.96307319664663e-15,
1.409885470212792e-15,
2.368630003393975e-16,
3.619641710741013e-17,
0.0005185482394849822,
-1.235469382001527e-10,
-1.422386386923544e-10,
-1.091721430345278e-10,
-6.28444835544505e-11,
-2.894090471852709e-11,
-1.110644465161596e-11,
-3.653336997997414e-12,
-1.051500514390724e-12,
-2.69011465612841e-13,
-6.19389290173368e-14,
-1.296399382726255e-14,
-2.48635551949985e-15,
-4.402232518738753e-16,
-7.39607860728497e-17,
-1.130310910079282e-17,
-0.0001436063117213874,
3.31328202207836e-11,
3.81455610777331e-11,
2.927778799368608e-11,
1.685363560904238e-11,
7.76137318542509e-12,
2.978527179891673e-12,
9.79752415241515e-13,
2.819916773611107e-13,
7.21436281218718e-14,
1.661084231290007e-14,
3.47670889922075e-15,
6.66800345265957e-16,
1.180624407742457e-16,
1.983601639368107e-17,
3.031636185854804e-18,
0.00003483173583059967,
-7.78996154453569e-12,
-8.96852286796754e-12,
-6.88359293073426e-12,
-3.962511443499732e-12,
-1.824801033099806e-12,
-7.00291032644634e-13,
-2.303527658184098e-13,
-6.63000049303272e-14,
-1.696194349579901e-14,
-3.905440399842668e-15,
-8.17425422703823e-16,
-1.567756131437037e-16,
-2.775877178342317e-17,
-4.663975121100197e-18,
-7.128589074174547e-19,
-7.51639170596238e-6,
1.630993269779793e-12,
1.877750030415695e-12,
1.441225849988213e-12,
8.29635645329831e-13,
3.820607406500002e-13,
1.46620772342662e-13,
4.82292439664045e-14,
1.388131961820429e-14,
3.551347304139389e-15,
8.17689141554634e-16,
1.711463808069723e-16,
3.282470104472225e-17,
5.812032124475154e-18,
9.76555383747964e-19,
1.492675680942972e-19,
1.460998803494629e-6,
-3.07863810893908e-13,
-3.544412440657108e-13,
-2.720436058402857e-13,
-1.566007698911541e-13,
-7.21172110045601e-14,
-2.767591910728287e-14,
-9.1036821018239e-15,
-2.620218713937278e-15,
-6.70347905859866e-16,
-1.543462144205298e-16,
-3.23055206987456e-17,
-6.196013948435371e-18,
-1.097097887530486e-18,
-1.843420716804501e-19,
-2.817666882051321e-20,
-2.583689659013092e-7,
5.29147786832624e-14,
6.09203791553943e-14,
4.67581018637012e-14,
2.691610739043109e-14,
1.239530739112924e-14,
4.756861083715689e-15,
1.564716187830701e-15,
4.5035624270425e-16,
1.152176999804549e-16,
2.65286715854607e-17,
5.552614987842252e-18,
1.064970230962951e-18,
1.885680280575558e-19,
3.168063026833669e-20,
4.846278544960676e-21,
4.190905832081555e-8,
-8.34872340257785e-15,
-9.61182131746422e-15,
-7.37734287110442e-15,
-4.246736910461104e-15,
-1.955691839473131e-15,
-7.50522344695379e-16,
-2.468759617517124e-16,
-7.10558040289443e-17,
-1.817870109294126e-17,
-4.185620024796849e-18,
-8.76080270359467e-19,
-1.680277230776623e-19,
-2.974742603996701e-20,
-5.000197374389855e-21,
-7.69442178585303e-22,
-6.280497988301357e-9,
1.217861563459426e-15,
1.402114698224968e-15,
1.076162428757233e-15,
6.19488463036816e-16,
2.852845854092675e-16,
1.09481702786892e-16,
3.601279164838509e-17,
1.036519896862344e-17,
2.651803165326343e-18,
6.105790133831588e-19,
1.277960829004991e-19,
2.449905568957283e-20,
4.345685968118648e-21,
7.423388960377205e-22,
1.041550335394961e-22,
8.885975082090255e-10,
-1.677124537136612e-16,
-1.93086065439096e-16,
-1.481989821288455e-16,
-8.53101343672688e-17,
-3.928671587488535e-17,
-1.507679380182242e-17,
-4.959344781902402e-18,
-1.427398911991999e-18,
-3.651823083647073e-19,
-8.40822637971775e-20,
-1.75968099472905e-20,
-3.376686166853369e-21,
-6.036225346007808e-22,
-9.93991140436838e-23,
-9.48104381464357e-24,
-1.153445151240671e-10,
2.122239903851532e-17,
2.443318582815563e-17,
1.875315700840469e-17,
1.079517787155358e-17,
4.971356609475698e-18,
1.907823521849957e-18,
6.275576045943883e-19,
1.806245522219191e-19,
4.621012425016225e-20,
1.063521871146334e-20,
2.228480183296379e-21,
4.397996214249533e-22,
7.0061249005871e-23,
-7.402704109520547e-25,
9.77769113332631e-24,
// [{0,1.e-6},{2.,0.00001}]: m=27
0.00693163312319549,
-1.97368954107127e-9,
-2.27229347374018e-9,
-1.74404879671638e-9,
-1.003954158100566e-9,
-4.62337025106852e-10,
-1.774276607360185e-10,
-5.83627038169422e-11,
-1.679785990827971e-11,
-4.29746996334308e-12,
-9.89466139621701e-13,
-2.070934833886646e-13,
-3.97165710340215e-14,
-7.03141984682689e-15,
-1.181091572860055e-15,
-1.804334407302466e-16,
-0.01336042615813199,
3.66138655681275e-9,
4.21532601148803e-9,
3.23538068039715e-9,
1.862432991072337e-9,
8.57680393560419e-10,
3.2914571399679e-10,
1.08268574842971e-10,
3.116170769483976e-11,
7.97224616567169e-12,
1.835565555463956e-12,
3.84182537058299e-13,
7.36796147004995e-14,
1.304450243585962e-14,
2.191232164295323e-15,
3.347800084361322e-16,
0.01289274817481659,
-3.40535673469682e-9,
-3.92056089469041e-9,
-3.00914025989179e-9,
-1.732198728936778e-9,
-7.97705477005104e-10,
-3.061296254767061e-10,
-1.006977355985994e-10,
-2.898269664193467e-11,
-7.41478830734261e-12,
-1.707218014779121e-12,
-3.573211834920131e-13,
-6.85287125550254e-14,
-1.213279804379184e-14,
-2.03817119423566e-15,
-3.114200872018127e-16,
-0.00830444815668278,
2.11683279434299e-9,
2.437093259804838e-9,
1.870537346087757e-9,
1.076766865205965e-9,
4.95868557392771e-10,
1.902958936491587e-10,
6.25956106654804e-11,
1.801620047607572e-11,
4.609179784627713e-12,
1.061242983685736e-12,
2.221194149480487e-13,
4.259946246078802e-14,
7.54223649240926e-15,
1.267060332082437e-15,
1.936134759048897e-16,
0.00401636758908116,
-9.89227261403113e-10,
-1.138889720947719e-9,
-8.74129777996131e-10,
-5.03189103860925e-10,
-2.31726735877742e-10,
-8.89281065836474e-11,
-2.925186904127758e-11,
-8.41924538841788e-12,
-2.153942246918365e-12,
-4.959365616164832e-13,
-1.038005352115047e-13,
-1.990768299163213e-14,
-3.524713675532978e-15,
-5.921575008305947e-16,
-9.04910427675086e-17,
-0.001555644718427914,
3.70640814595607e-10,
4.26715916071478e-10,
3.275164290992964e-10,
1.885334506608836e-10,
8.68227141544448e-11,
3.331933395441175e-11,
1.096001099384878e-11,
3.154501543130881e-12,
8.07034396827954e-13,
1.858167870495797e-13,
3.889198148130659e-14,
7.45906655840128e-15,
1.320669755532134e-15,
2.218823582125972e-16,
3.390932737494647e-17,
0.0005026220910300303,
-1.159648707736491e-10,
-1.335094637731093e-10,
-1.024722579787022e-10,
-5.89877246321094e-11,
-2.716480614920014e-11,
-1.042484512970234e-11,
-3.429133453372105e-12,
-9.86970870771577e-13,
-2.52502698428531e-13,
-5.81379480957394e-14,
-1.21684811473364e-14,
-2.333801208075558e-15,
-4.132185428037496e-16,
-6.942605778569276e-17,
-1.061072653942614e-17,
-0.0001393269438889132,
3.1159846279813e-11,
3.58740915889223e-11,
2.753437181277786e-11,
1.585004582571543e-11,
7.29920415621552e-12,
2.801164139718355e-12,
9.21411066280073e-13,
2.652000205866357e-13,
6.78477742046682e-14,
1.562176165029791e-14,
3.269701701026418e-15,
6.27102454692788e-16,
1.110350886418802e-16,
1.865590052190138e-17,
2.851434506899807e-18,
0.00003382376261177372,
-7.33946970261389e-12,
-8.44987512375145e-12,
-6.48551631487762e-12,
-3.733360398187868e-12,
-1.719273330255675e-12,
-6.59793474517564e-13,
-2.17031597511871e-13,
-6.24659381852139e-14,
-1.598106284370493e-14,
-3.679601129735844e-15,
-7.70158713045101e-16,
-1.477111587319954e-16,
-2.615414268493643e-17,
-4.394494610358334e-18,
-6.717063087355202e-19,
-7.304987973582697e-6,
1.539317969804192e-12,
1.772204971561621e-12,
1.360217070737694e-12,
7.83003297720045e-13,
3.605858009394295e-13,
1.383794980285813e-13,
4.551837843506274e-14,
1.310108433798996e-14,
3.351737166775839e-15,
7.71730528776852e-16,
1.615274932434219e-16,
3.098004697774305e-17,
5.485476827162342e-18,
9.21710344486488e-19,
1.408917286067551e-19,
1.421029728852646e-6,
-2.91031355692207e-13,
-3.350621693233298e-13,
-2.571696246986652e-13,
-1.480386277467696e-13,
-6.8174207736102e-14,
-2.616274251714576e-14,
-8.60594118970246e-15,
-2.476959953920917e-15,
-6.33697509415615e-16,
-1.459077396496869e-16,
-3.053938583043615e-17,
-5.857312100102127e-18,
-1.03713782058518e-18,
-1.742710725280525e-19,
-2.66376716803036e-20,
-2.514886403998496e-7,
5.00984943041466e-14,
5.76780128298223e-14,
4.42694951058139e-14,
2.548355175565824e-14,
1.17355925881638e-14,
4.503687282465256e-15,
1.48143774399137e-15,
4.263872003657612e-16,
1.090856090401582e-16,
2.511680335315033e-17,
5.257114174938026e-18,
1.008294686448923e-18,
1.785381006136036e-19,
3.000120655671029e-20,
4.587207425928679e-21,
4.082192456528744e-8,
-7.91587029532491e-15,
-9.11348089415358e-15,
-6.99485266497263e-15,
-4.026558083440707e-15,
-1.854295958655959e-15,
-7.11610403325022e-16,
-2.340763485943481e-16,
-6.7371842087691e-17,
-1.723621809116303e-17,
-3.968619799053616e-18,
-8.30663242038914e-19,
-1.593169906906927e-19,
-2.82034019229094e-20,
-4.741948866052548e-21,
-7.325470817853066e-22,
-6.12169471136922e-9,
1.156312308651209e-15,
1.331253518290115e-15,
1.021774491424173e-15,
5.88180282067805e-16,
2.708666651359735e-16,
1.039486442639594e-16,
3.4192758654869e-17,
9.84136097353195e-18,
2.517785956140248e-18,
5.797175962217529e-19,
1.213425875774305e-19,
2.327381570512214e-20,
4.117448059655233e-21,
6.917796653291216e-22,
1.053725177680145e-22,
8.666991607407223e-10,
-1.594509206981972e-16,
-1.835746264540954e-16,
-1.408986866038623e-16,
-8.11077506931546e-17,
-3.735145057759805e-17,
-1.433411129484766e-17,
-4.715048229953346e-18,
-1.357085853081565e-18,
-3.471938595039186e-19,
-7.99404316595497e-20,
-1.672933000276713e-20,
-3.210790495349973e-21,
-5.76487522581918e-22,
-9.39509212856005e-23,
-5.673679737787221e-24,
-1.125700552367537e-10,
2.020198940183663e-17,
2.325839610773874e-17,
1.785147301840828e-17,
1.027612734897366e-17,
4.732325495474745e-18,
1.816092392232712e-18,
5.973835151333377e-19,
1.719389706979234e-19,
4.398970032072213e-20,
1.012875053802666e-20,
2.115868492249382e-21,
4.060274721241345e-22,
7.769648706962839e-23,
1.21654977001242e-23,
3.953836887050607e-25,
// [{0,1.e-6},{2.,0.00001}]: m=28
0.006680213079066,
-1.83069327840638e-9,
-2.10766300574401e-9,
-1.61769034019858e-9,
-9.31216495536168e-10,
-4.2884019678021e-10,
-1.645728569983951e-10,
-5.41342874214855e-11,
-1.558085384741988e-11,
-3.98612308283585e-12,
-9.17782777731978e-13,
-1.920912685291494e-13,
-3.68398073502498e-14,
-6.52225121792981e-15,
-1.095616082147661e-15,
-1.673900042180661e-16,
-0.01289274817481659,
3.40535673469682e-9,
3.92056089469041e-9,
3.00914025989179e-9,
1.732198728936778e-9,
7.97705477005103e-10,
3.06129625476706e-10,
1.006977355985994e-10,
2.898269664193466e-11,
7.41478830734261e-12,
1.707218014779121e-12,
3.57321183492013e-13,
6.85287125550254e-14,
1.213279804379184e-14,
2.038171194235668e-15,
3.11420087201816e-16,
0.01245667223502417,
-3.17524919151448e-9,
-3.65563988970726e-9,
-2.805806019131637e-9,
-1.615150297808947e-9,
-7.43802836089156e-10,
-2.854438404737381e-10,
-9.38934159982206e-11,
-2.702430071411358e-11,
-6.91376967694157e-12,
-1.591864475528604e-12,
-3.33179122422073e-13,
-6.3899193691182e-14,
-1.131335473861395e-14,
-1.900590498123649e-15,
-2.904202138572177e-16,
-0.00803273517816287,
1.978454522806323e-9,
2.27777944189555e-9,
1.748259555992347e-9,
1.006378207721899e-9,
4.63453471755507e-10,
1.778562131673034e-10,
5.8503738082558e-11,
1.683849077683659e-11,
4.307884493836939e-12,
9.91873123233014e-13,
2.076010704230189e-13,
3.981536598326712e-14,
7.04942735106838e-15,
1.184315001660312e-15,
1.809820855326801e-16,
0.003889111796069596,
-9.26602036488984e-10,
-1.066789790178657e-9,
-8.18791072748212e-10,
-4.71333626652193e-10,
-2.170567853861045e-10,
-8.32983348860265e-11,
-2.7400027484621e-11,
-7.88625385782693e-12,
-2.017585992069814e-12,
-4.64541967623934e-13,
-9.72299537032633e-14,
-1.864766639600022e-14,
-3.301674388825176e-15,
-5.547058955335453e-16,
-8.47733184464031e-17,
-0.001507866273063693,
3.47894612316324e-10,
4.00528391314005e-10,
3.074167739320209e-10,
1.769631738939762e-10,
8.14944184465173e-11,
3.127453538869136e-11,
1.028740035997959e-11,
2.960912612275378e-12,
7.57508095275518e-13,
1.744138442849113e-13,
3.650544344156391e-14,
7.00140362410467e-15,
1.239655628282711e-15,
2.082781733836326e-16,
3.183217974140701e-17,
0.0004876443036162518,
-1.090594619802102e-10,
-1.255593205622238e-10,
-9.63703013454867e-11,
-5.54751603904439e-11,
-2.554721454695691e-11,
-9.80407448909198e-12,
-3.224938732005829e-12,
-9.28200072060591e-13,
-2.374672097182091e-13,
-5.467616577644876e-14,
-1.144395595369282e-14,
-2.194858591504388e-15,
-3.886228103407972e-16,
-6.529565177227777e-17,
-9.98002057827949e-18,
-0.000135295051000302,
2.93578789073518e-11,
3.37995006065617e-11,
2.594206534513276e-11,
1.493344164203959e-11,
6.87709334372069e-12,
2.639173906780907e-12,
8.68126392912746e-13,
2.498637535655698e-13,
6.3924251585938e-14,
1.471840456736672e-14,
3.08063486160592e-15,
5.908446372769139e-16,
1.046165731442831e-16,
1.757797809916331e-17,
2.686822992596981e-18,
0.00003287244581755832,
-6.92693085324651e-12,
-7.97492235951004e-12,
-6.12097680871227e-12,
-3.523514834209772e-12,
-1.622636101680582e-12,
-6.22707740151234e-13,
-2.048327026362426e-13,
-5.89548794283551e-14,
-1.50828172270241e-14,
-3.472787374337403e-15,
-7.26873718066198e-16,
-1.394102105461215e-16,
-2.468464523856381e-17,
-4.147697069865434e-18,
-6.340145307381739e-19,
-7.105142742341705e-6,
1.455155744726578e-12,
1.675309656486062e-12,
1.285847210034628e-12,
7.40192612905079e-13,
3.408707965277107e-13,
1.308136196564119e-13,
4.302967538052597e-14,
1.238479097128066e-14,
3.16848529506134e-15,
7.29538181045692e-16,
1.526968268983569e-16,
2.928653699795046e-17,
5.185668281918828e-18,
8.71357428170463e-19,
1.332069023327594e-19,
1.383187929037685e-6,
-2.75541788260788e-13,
-3.172291506801353e-13,
-2.434822845733474e-13,
-1.401595700533789e-13,
-6.45457755358989e-14,
-2.477028630925225e-14,
-8.1479096499837e-15,
-2.345130194616088e-15,
-5.99970999588269e-16,
-1.381424518840909e-16,
-2.891413950140913e-17,
-5.545625046531156e-18,
-9.81958133290253e-19,
-1.65004635824909e-19,
-2.522298989196284e-20,
-2.44965032400503e-7,
4.75010867041711e-14,
5.46876376166219e-14,
4.197429853292375e-14,
2.4162331810403e-14,
1.112714961515735e-14,
4.270189658054345e-15,
1.404631520375407e-15,
4.042809696709833e-16,
1.034300836495891e-16,
2.381465568018625e-17,
4.984569744700246e-18,
9.56028825494722e-19,
1.693102183939368e-19,
2.844649614509836e-20,
4.321168532944713e-21,
3.978973338585078e-8,
-7.51581068553052e-15,
-8.65289536663429e-15,
-6.64134039167378e-15,
-3.823060271770021e-15,
-1.760581947472204e-15,
-6.75646471602334e-16,
-2.222464448523525e-16,
-6.39669788518134e-17,
-1.636513740020336e-17,
-3.768057627530146e-18,
-7.88685148529299e-19,
-1.512701522963827e-19,
-2.678150686226641e-20,
-4.498624685549396e-21,
-6.920899793476746e-22,
-5.970719696252917e-9,
1.099311498165026e-15,
1.26562892659266e-15,
9.71405781318598e-16,
5.59185751071398e-16,
2.575142171112075e-16,
9.88244736871457e-17,
3.250722415030584e-17,
9.35623267238238e-18,
2.393669884684569e-18,
5.511423490878956e-19,
1.153830170286039e-19,
2.212511338736615e-20,
3.851800687625614e-21,
6.585699841291974e-22,
1.715272879550524e-22,
8.458536381494405e-10,
-1.51784867530578e-16,
-1.747487587491489e-16,
-1.341245861284071e-16,
-7.7208268830324e-17,
-3.555567634499783e-17,
-1.36449601961515e-17,
-4.488360158612608e-18,
-1.291840557809077e-18,
-3.305016656294699e-19,
-7.60985836984544e-20,
-1.592646681162733e-20,
-3.052631987777037e-21,
-5.446195426308025e-22,
-9.36881102957982e-23,
-1.023988956527935e-23,
-1.099258690603681e-10,
1.925341265739082e-17,
2.216630703357668e-17,
1.70132640790378e-17,
9.79361596040315e-18,
4.510121223744478e-18,
1.730818649116321e-18,
5.693334509146052e-19,
1.638659280765474e-19,
4.192775504488843e-20,
9.65239581755514e-21,
1.995278295207226e-21,
3.882046677022109e-22,
1.363372187219021e-22,
1.11734575373187e-23,
-7.079641433914367e-23,
// [{0,1.e-6},{2.,0.00001}]: m=29
0.00644637408740829,
-1.70267836734841e-9,
-1.9602804473452e-9,
-1.5045701299459e-9,
-8.66099364468389e-10,
-3.98852738502552e-10,
-1.53064812738353e-10,
-5.03488677992997e-11,
-1.449134832096733e-11,
-3.70739415367131e-12,
-8.5360900738956e-13,
-1.786605917460065e-13,
-3.42643562775127e-14,
-6.06639902189592e-15,
-1.019085597117834e-15,
-1.557100436009052e-16,
-0.01245667223502417,
3.17524919151448e-9,
3.65563988970726e-9,
2.80580601913164e-9,
1.615150297808947e-9,
7.43802836089156e-10,
2.854438404737381e-10,
9.38934159982205e-11,
2.702430071411357e-11,
6.91376967694157e-12,
1.591864475528604e-12,
3.33179122422073e-13,
6.3899193691182e-14,
1.131335473861389e-14,
1.90059049812364e-15,
2.90420213857277e-16,
0.01204910276724431,
-2.96768178420948e-9,
-3.41666916284332e-9,
-2.622389333988522e-9,
-1.509567311582848e-9,
-6.9518020763326e-10,
-2.667843197509552e-10,
-8.7755607123837e-11,
-2.525773616525489e-11,
-6.46182674075541e-12,
-1.487809684849522e-12,
-3.114016056345288e-13,
-5.97230489749007e-14,
-1.057414102660146e-14,
-1.776472502490415e-15,
-2.714731283002232e-16,
-0.00777822359213973,
1.85320407297806e-9,
2.133579580357419e-9,
1.637582145496506e-9,
9.42667253304432e-10,
4.3411357077223e-10,
1.665966697720612e-10,
5.48000549692447e-11,
1.577250771565463e-11,
4.035171984139829e-12,
9.29083935247914e-13,
1.944599074065344e-13,
3.729533279200143e-14,
6.60334877765544e-15,
1.109411791068187e-15,
1.695466368876988e-16,
0.003769665682659048,
-8.69736530790778e-10,
-1.001320978284976e-9,
-7.68541934830025e-10,
-4.42407934734925e-10,
-2.03736046116286e-10,
-7.81863384717256e-11,
-2.571850089994806e-11,
-7.40228153068818e-12,
-1.893770238188733e-12,
-4.36034610712263e-13,
-9.12636086038787e-14,
-1.750350906025977e-14,
-3.099139070782374e-15,
-5.206954334611289e-16,
-7.95804492720246e-17,
-0.001462932910822964,
3.27178385936219e-10,
3.76677961681592e-10,
2.891109040325617e-10,
1.664254811690877e-10,
7.66416436398373e-11,
2.941222346687936e-11,
9.67481619588704e-12,
2.784600216144228e-12,
7.12401629145012e-13,
1.64028497327125e-13,
3.433186786066365e-14,
6.58457577445413e-15,
1.165868430878022e-15,
1.958869552781753e-16,
2.99400618712811e-17,
0.0004735326785059994,
-1.027525761765573e-10,
-1.182982521239169e-10,
-9.07972287086946e-11,
-5.22670457475587e-11,
-2.40698267032159e-11,
-9.23710867380743e-12,
-3.038442375219049e-12,
-8.74523137486523e-13,
-2.237348805524506e-13,
-5.15144159861998e-14,
-1.078222201641537e-14,
-2.067956230494846e-15,
-3.66158004086972e-16,
-6.152292332278908e-17,
-9.40388254095646e-18,
-0.0001314897838107437,
2.77077235054366e-11,
3.189968954447783e-11,
2.448390731654301e-11,
1.409405938386586e-11,
6.49054442837893e-12,
2.490830968915946e-12,
8.19330813278774e-13,
2.358195185002462e-13,
6.03312691095165e-14,
1.389114954383981e-14,
2.907494881372383e-15,
5.576408436095616e-16,
9.87385828438736e-17,
1.659078886151287e-17,
2.536056498588257e-18,
0.00003197314227840005,
-6.54820084088491e-12,
-7.53889344223146e-12,
-5.7863124359794e-12,
-3.330866752790485e-12,
-1.533918581942086e-12,
-5.886612875203e-13,
-1.936335389051332e-13,
-5.57315592824053e-14,
-1.425818380674396e-14,
-3.282921809415454e-15,
-6.87135711428537e-16,
-1.317894163529985e-16,
-2.333553031913565e-17,
-3.92110850399063e-18,
-5.994062412714386e-19,
-6.915933878722321e-6,
1.377707954997036e-12,
1.58614461787306e-12,
1.217410551317348e-12,
7.00797348563042e-13,
3.227286466366088e-13,
1.238513428804826e-13,
4.073951908435622e-14,
1.172564257876761e-14,
2.999852849587655e-15,
6.90711763961567e-16,
1.445705977037676e-16,
2.772810840749047e-17,
4.909777668812034e-18,
8.25018925817388e-19,
1.261245596563432e-19,
1.347308075913005e-6,
-2.612560433396744e-13,
-3.007820834140639e-13,
-2.308587006643632e-13,
-1.328928587667897e-13,
-6.1199338453187e-14,
-2.348604909446627e-14,
-7.72547532846711e-15,
-2.223545898695063e-15,
-5.68865595067073e-16,
-1.309806402966372e-16,
-2.741519293094378e-17,
-5.258158744983099e-18,
-9.31064875026666e-19,
-1.564560954204267e-19,
-2.391845208332477e-20,
-2.387711168121159e-7,
4.51004599650632e-14,
5.19238146613869e-14,
3.985298712053813e-14,
2.294120806759535e-14,
1.056480251592337e-14,
4.054381878442662e-15,
1.333644141284957e-15,
3.838494989702221e-16,
9.82030113904375e-17,
2.261115431979181e-17,
4.732686522978818e-18,
9.07723946437758e-19,
1.60737702803935e-19,
2.700678677898265e-20,
4.124664270817446e-21,
3.880842455721196e-8,
-7.14531525459684e-15,
-8.22634684612364e-15,
-6.31395246864335e-15,
-3.634600824193414e-15,
-1.673793339748755e-15,
-6.42340247007602e-16,
-2.112907595553169e-16,
-6.08137300962432e-17,
-1.555842767159505e-17,
-3.582317622007458e-18,
-7.4980902041176e-19,
-1.438137888882584e-19,
-2.546405254057826e-20,
-4.277951290338174e-21,
-6.556887796920798e-22,
-5.827008317349806e-9,
1.046421960108025e-15,
1.204737610607915e-15,
9.24669992135244e-16,
5.322824946522e-16,
2.451248340511936e-16,
9.40698909594065e-17,
3.094326025368645e-17,
8.90609446033386e-18,
2.278512231100632e-18,
5.246294109349693e-19,
1.09814519699507e-19,
2.10543646041864e-20,
3.718031562353401e-21,
6.343079751212454e-22,
1.044971770001394e-22,
8.259868312472341e-10,
-1.446584339971468e-16,
-1.665441509036007e-16,
-1.278273199044854e-16,
-7.35832744688678e-17,
-3.388630794681387e-17,
-1.300431885160513e-17,
-4.277628757303785e-18,
-1.231188139967662e-18,
-3.149844868534202e-19,
-7.25256313842504e-20,
-1.517957315842566e-20,
-2.9100586693309e-21,
-5.170271349293e-22,
-8.834938519240541e-23,
-1.169532270591517e-23,
-1.074029956921078e-10,
1.837008395068847e-17,
2.114933751497761e-17,
1.623271149275638e-17,
9.34429419415424e-18,
4.303201276340149e-18,
1.65141045235756e-18,
5.432133749620808e-19,
1.56348363094708e-19,
4.000092901493251e-20,
9.20744242368649e-21,
1.922824168362736e-21,
3.764702206173705e-22,
7.462641498420756e-23,
3.721477282753339e-24,
-4.19597963956504e-24,
// [{0,1.e-6},{2.,0.00001}]: m=30
0.00622833611751208,
-1.58762459575724e-9,
-1.82781994485363e-9,
-1.402903009565818e-9,
-8.07575148904473e-10,
-3.71901418044578e-10,
-1.42721920236869e-10,
-4.69467079991103e-11,
-1.351215035705679e-11,
-3.45688483847078e-12,
-7.95932237764302e-13,
-1.665895612110365e-13,
-3.1949596845591e-14,
-5.65667736930695e-15,
-9.5029524906182e-16,
-1.452101069286364e-16,
-0.0120491027672443,
2.96768178420948e-9,
3.41666916284332e-9,
2.62238933398852e-9,
1.509567311582848e-9,
6.9518020763326e-10,
2.667843197509552e-10,
8.7755607123837e-11,
2.525773616525488e-11,
6.46182674075541e-12,
1.487809684849521e-12,
3.114016056345287e-13,
5.97230489749007e-14,
1.057414102660145e-14,
1.776472502490409e-15,
2.714731283002286e-16,
0.0116673353882096,
-2.77980610946709e-9,
-3.20036937053613e-9,
-2.456373218244759e-9,
-1.414000879956648e-9,
-6.51170356158346e-10,
-2.498950046580918e-10,
-8.22000824538671e-11,
-2.365876157348195e-11,
-6.05275797620974e-12,
-1.393625902871872e-12,
-2.91689861109802e-13,
-5.5942999188002e-14,
-9.90502316648248e-15,
-1.664117686602401e-15,
-2.543199553322394e-16,
-0.00753933136531862,
1.739473061581644e-9,
2.002641956570054e-9,
1.537083869660127e-9,
8.84815869469894e-10,
4.07472092232593e-10,
1.563726769434591e-10,
5.14370017998987e-11,
1.480456306137711e-11,
3.787540476377658e-12,
8.7206922142457e-13,
1.825272172077663e-13,
3.500701812052084e-14,
6.19827814156566e-15,
1.041390866922821e-15,
1.591608985435496e-16,
0.003657332277057228,
-8.17945964840518e-10,
-9.41694904203947e-10,
-7.22777260081378e-10,
-4.16063702922704e-10,
-1.916041090995864e-10,
-7.35305586671957e-11,
-2.418704048971672e-11,
-6.96150054036032e-12,
-1.781004072862469e-12,
-4.100712433177946e-13,
-8.58296696516416e-14,
-1.646143943614345e-14,
-2.914671077230839e-15,
-4.89717388185687e-16,
-7.48501546424458e-17,
-0.001420598035492785,
3.08257728525458e-10,
3.54894756366899e-10,
2.723916861223603e-10,
1.568011372405328e-10,
7.22094801086606e-11,
2.771132602104349e-11,
9.11532712553255e-12,
2.623569412423707e-12,
6.71204641648174e-13,
1.54543247956481e-13,
3.23466660488167e-14,
6.20386869141544e-15,
1.098474012217357e-15,
1.845687699489134e-16,
2.8211647649614e-17,
0.0004602142433424366,
-9.6977032269818e-11,
-1.116489134065816e-10,
-8.56936756085984e-11,
-4.93292078439322e-11,
-2.271690549951126e-11,
-8.71790839127681e-12,
-2.86765784649907e-12,
-8.25368314757568e-13,
-2.111594418849653e-13,
-4.861902340391797e-14,
-1.017623208518164e-14,
-1.951742952419429e-15,
-3.455850392448571e-16,
-5.806776127017465e-17,
-8.87619842907147e-18,
-0.0001278925696419833,
2.61928034518436e-11,
3.015557387058952e-11,
2.314524982194732e-11,
1.332346705607944e-11,
6.13567434845359e-12,
2.354645158019439e-12,
7.74534158231723e-13,
2.229262378811594e-13,
5.70327354193073e-14,
1.313168728202657e-14,
2.748542854736401e-15,
5.271576669389911e-16,
9.3342122182618e-17,
1.568443433947476e-17,
2.397624373735353e-18,
0.00003112170239347645,
-6.19968578755755e-12,
-7.13765076899747e-12,
-5.47834747215422e-12,
-3.153588063483061e-12,
-1.452278907538845e-12,
-5.5733104206956e-13,
-1.83327835585922e-13,
-5.276539152012676e-14,
-1.349933780215564e-14,
-3.108202931865243e-15,
-6.50567685717721e-16,
-1.247764903450354e-16,
-2.209400619907358e-17,
-3.712582182364884e-18,
-5.675543595713897e-19,
-6.736534742478848e-6,
1.306279274629644e-12,
1.503909332473775e-12,
1.154292670863452e-12,
6.64463814632679e-13,
3.059964715858526e-13,
1.174301607834088e-13,
3.862734878489521e-14,
1.111772147565689e-14,
2.844325923564915e-15,
6.54902728446621e-16,
1.370758680219148e-16,
2.629077672107184e-17,
4.655315388856859e-18,
7.82277781981553e-19,
1.195980486907556e-19,
1.313241531449066e-6,
-2.480525933586373e-13,
-2.85581053803168e-13,
-2.191914853195712e-13,
-1.26176676698095e-13,
-5.81064287243622e-14,
-2.229910604454593e-14,
-7.33504465669052e-15,
-2.11117278414757e-15,
-5.401166976760062e-16,
-1.243613864350156e-16,
-2.6029797395654e-17,
-4.992467092545667e-18,
-8.84024941258311e-19,
-1.485547063148467e-19,
-2.271361256506266e-20,
-2.328825297978591e-7,
4.28772363939224e-14,
4.93642345806089e-14,
3.788843779921485e-14,
2.18103237136126e-14,
1.004401207616407e-14,
3.85452196816311e-15,
1.26790260777741e-15,
3.649278702814347e-16,
9.33622062075622e-17,
2.149658807009778e-17,
4.49940491149642e-18,
8.62983129119747e-19,
1.528295490117187e-19,
2.567875504100179e-20,
3.906908146270841e-21,
3.78743281018183e-8,
-6.8015424473938e-15,
-7.83056387279165e-15,
-6.01017795983598e-15,
-3.459734332229632e-15,
-1.593264502582327e-15,
-6.11436285219712e-16,
-2.011252677890153e-16,
-5.78879123999177e-17,
-1.480990231742332e-17,
-3.409974035672786e-18,
-7.13735418805231e-19,
-1.368946708581597e-19,
-2.424472741259568e-20,
-4.073715078128184e-21,
-6.184548496838038e-22,
-5.690048947748707e-9,
9.97257789098002e-16,
1.148135280532303e-15,
8.81226119135105e-16,
5.07274215036482e-16,
2.336081177499303e-16,
8.96502046410253e-17,
2.948945676881401e-17,
8.48766305953428e-18,
2.171460627160059e-18,
4.999793242106589e-19,
1.046683078127171e-19,
2.007112793179908e-20,
3.505821246356103e-21,
5.987973508025156e-22,
1.428682292652302e-22,
8.070314238862677e-10,
-1.380221571646135e-16,
-1.589038566343292e-16,
-1.219631800804612e-16,
-7.02076073873768e-17,
-3.233175870745655e-17,
-1.240774075724088e-17,
-4.081391446957618e-18,
-1.174707422870476e-18,
-3.005342780974367e-19,
-6.919807245229519e-20,
-1.448532594437362e-20,
-2.778279661005734e-21,
-4.879174605124978e-22,
-8.220684520287558e-23,
-1.697909567477118e-23,
-1.049932773052129e-10,
1.754615575307652e-17,
2.020075533851464e-17,
1.550464809813174e-17,
8.92518759409917e-18,
4.110195917692549e-18,
1.577342228344612e-18,
5.188492590064439e-19,
1.493354671495062e-19,
3.820939679098584e-20,
8.79683808385968e-21,
1.821730947840744e-21,
3.538626936160994e-22,
1.145852967311385e-22,
9.16952973349168e-24,
-5.360353864377779e-23,
// [{0,1.e-6},{2.,0.00001}]: m=31
0.00602455138362215,
-1.48384089210474e-9,
-1.70833458142166e-9,
-1.311194666994261e-9,
-7.54783655791424e-10,
-3.4759010381663e-10,
-1.333921598754776e-10,
-4.38778035619185e-11,
-1.262886808262744e-11,
-3.2309133703777e-12,
-7.43904842424761e-13,
-1.557008028172644e-13,
-2.98615244874504e-14,
-5.28707051330073e-15,
-8.88236251245204e-16,
-1.357365641501124e-16,
-0.01166733538820959,
2.77980610946709e-9,
3.20036937053613e-9,
2.45637321824476e-9,
1.414000879956648e-9,
6.51170356158346e-10,
2.498950046580918e-10,
8.22000824538671e-11,
2.365876157348195e-11,
6.05275797620974e-12,
1.393625902871872e-12,
2.916898611098019e-13,
5.59429991880021e-14,
9.90502316648251e-15,
1.664117686602387e-15,
2.543199553322081e-16,
0.01130899704797794,
-2.60920959237247e-9,
-3.00396293485508e-9,
-2.305625804490191e-9,
-1.327223804204841e-9,
-6.11208138348889e-10,
-2.345590154151887e-10,
-7.71555026998481e-11,
-2.220684459206567e-11,
-5.68131071456649e-12,
-1.308103832136855e-12,
-2.737908258116496e-13,
-5.25105271807812e-14,
-9.29741721234791e-15,
-1.562086300384335e-15,
-2.38741347815984e-16,
-0.00731466455411497,
1.63589192968112e-9,
1.88338980840799e-9,
1.44555452016283e-9,
8.32127405845451e-10,
3.832082181991924e-10,
1.47061117334399e-10,
4.83740809794359e-11,
1.392300108072135e-11,
3.562008145725121e-12,
8.20142486635632e-13,
1.716593393032931e-13,
3.292287887228753e-14,
5.82934215445898e-15,
9.7943477637258e-16,
1.497003092880939e-16,
0.003551495088731786,
-7.70644321313617e-10,
-8.87236890917216e-10,
-6.80979215305876e-10,
-3.92002843101318e-10,
-1.80523700271645e-10,
-6.92783150526062e-11,
-2.278831781383053e-11,
-6.55892353105903e-12,
-1.678011604120375e-12,
-3.863581198911875e-13,
-8.08666651220229e-14,
-1.550967172854142e-14,
-2.746185030587081e-15,
-4.614219248677283e-16,
-7.05291190761409e-17,
-0.00138064273000265,
2.90931096805425e-10,
3.34946740215107e-10,
2.570810268222352e-10,
1.479876235297473e-10,
6.815071649759e-11,
2.615372517346825e-11,
8.60297353937807e-12,
2.476104944238417e-12,
6.3347832564613e-13,
1.458570702097241e-13,
3.052869625508699e-14,
5.85522885720438e-15,
1.036755117812968e-15,
1.742032837789463e-16,
2.66285951876867e-17,
0.0004476239937516715,
-9.16748120822084e-11,
-1.055445085479335e-10,
-8.10083743774835e-11,
-4.66321346966625e-11,
-2.147486021976463e-11,
-8.24125805313598e-12,
-2.710869553833389e-12,
-7.8024183259049e-13,
-1.996145739691399e-13,
-4.5960905487484e-14,
-9.61989999209681e-15,
-1.845051834246408e-15,
-3.266974264436606e-16,
-5.489552026876418e-17,
-8.39168660355436e-18,
-0.0001244868100906936,
2.479874323466027e-11,
2.855060317319354e-11,
2.191338996322344e-11,
1.261435229687921e-11,
5.80911564993316e-12,
2.229324175868231e-12,
7.33311344840342e-13,
2.110615667990704e-13,
5.399735139237184e-14,
1.243281176990785e-14,
2.602270752202984e-15,
4.99105962767879e-16,
8.83760238401186e-17,
1.485032910587487e-17,
2.270218801683802e-18,
0.0000303144062816859,
-5.87825672633055e-12,
-6.76759198519144e-12,
-5.19431701048835e-12,
-2.99008716101325e-12,
-1.376984119910295e-12,
-5.28435722671067e-13,
-1.738230692509195e-13,
-5.002974655957175e-14,
-1.279946663640904e-14,
-2.947062273171247e-15,
-6.16841399431392e-16,
-1.183084955042837e-16,
-2.094893453109617e-17,
-3.520249296453711e-18,
-5.381747803707124e-19,
-6.566202143863204e-6,
1.24026206605285e-12,
1.427904232000354e-12,
1.095956630659288e-12,
6.30882925311671e-13,
2.905319326229226e-13,
1.114954492490869e-13,
3.667519664798766e-14,
1.055585625466013e-14,
2.700581527667205e-15,
6.21806479872862e-16,
1.301488893593239e-16,
2.496231917729754e-17,
4.420129861877917e-18,
7.42771109883192e-19,
1.135588323945985e-19,
1.280854294517531e-6,
-2.358248609891127e-13,
-2.715033602178756e-13,
-2.083864616414774e-13,
-1.199568113634195e-13,
-5.52420806665804e-14,
-2.119987629262885e-14,
-6.97346614202107e-15,
-2.007103804280142e-15,
-5.134922596428252e-16,
-1.182312650815009e-16,
-2.474677031148195e-17,
-4.746406452210512e-18,
-8.40463576008757e-19,
-1.412366710607273e-19,
-2.159390628520816e-20,
-2.27277249225193e-7,
4.08143650737582e-14,
4.69892667891169e-14,
3.606558355103046e-14,
2.076100549071073e-14,
9.56078412685566e-15,
3.669077118763694e-15,
1.206902724030303e-15,
3.473709685367678e-16,
8.88705396297863e-17,
2.046240873554843e-17,
4.28295865138596e-18,
8.21464675740617e-19,
1.454592460874477e-19,
2.445167518701905e-20,
3.741763112983134e-21,
3.698411852598817e-8,
-6.4819839344463e-15,
-7.46265862682268e-15,
-5.72780038349479e-15,
-3.297184888559443e-15,
-1.51840786090264e-15,
-5.82709097491306e-16,
-1.916757982542425e-16,
-5.516817809322239e-17,
-1.411409893740375e-17,
-3.24976934078885e-18,
-6.80205963716104e-19,
-1.30463032255051e-19,
-2.310259394451395e-20,
-3.883244397760157e-21,
-5.929275105640914e-22,
-5.55937688614946e-9,
9.51477300362053e-16,
1.095428557394587e-15,
8.4077223304613e-16,
4.839871080443115e-16,
2.228840287308831e-16,
8.55346987148089e-17,
2.813570907559459e-17,
8.09802986982144e-18,
2.071782181340669e-18,
4.770229119658173e-19,
9.98439017291581e-20,
1.916559649966202e-20,
3.40157846790136e-21,
5.526269534489655e-22,
7.25536325355684e-23,
7.889261323721087e-10,
-1.318321122459388e-16,
-1.517773056815638e-16,
-1.164933525781092e-16,
-6.70589244420133e-17,
-3.088173927218546e-17,
-1.18512772544935e-17,
-3.898349236128855e-18,
-1.122024496649881e-18,
-2.870563923120745e-19,
-6.609444861432633e-20,
-1.383459257683437e-20,
-2.654370853610785e-21,
-4.686785099997294e-22,
-7.807749330618665e-23,
-1.357622418828521e-23,
-1.02689271190681e-10,
1.677642099652499e-17,
1.931456564783738e-17,
1.482447267742849e-17,
8.53364749479077e-18,
3.929885345094299e-18,
1.508145799215227e-18,
4.960882455173911e-19,
1.427835265278377e-19,
3.6529301074791e-20,
8.41602856063996e-21,
1.764198774959912e-21,
3.225373316588963e-22,
4.58629925236704e-23,
2.765855850090235e-23,
2.028468448810737e-23,
// [{0,1.e-6},{2.,0.00001}]: m=32
0.0058336676941048,
-1.38990305473355e-9,
-1.60018468526806e-9,
-1.228186609122379e-9,
-7.07000439978324e-10,
-3.25585178079173e-10,
-1.249475023290459e-10,
-4.11000412269335e-11,
-1.182938078674098e-11,
-3.02637898810487e-12,
-6.96812951435936e-13,
-1.458449305549009e-13,
-2.7971499594001e-14,
-4.95251158324126e-15,
-8.32058843301194e-16,
-1.271599776661032e-16,
-0.01130899704797793,
2.60920959237247e-9,
3.00396293485508e-9,
2.305625804490191e-9,
1.327223804204841e-9,
6.11208138348889e-10,
2.345590154151887e-10,
7.71555026998481e-11,
2.220684459206566e-11,
5.68131071456649e-12,
1.308103832136855e-12,
2.737908258116496e-13,
5.25105271807812e-14,
9.29741721234787e-15,
1.56208630038434e-15,
2.387413478160196e-16,
0.01097199683117246,
-2.45383789452168e-9,
-2.82508471261199e-9,
-2.168331780244246e-9,
-1.248191108768176e-9,
-5.74812327298789e-10,
-2.205916760015986e-10,
-7.25611214691539e-11,
-2.088450162108203e-11,
-5.34301221858768e-12,
-1.230213729953448e-12,
-2.574890089549398e-13,
-4.93843183084316e-14,
-8.74401323168826e-15,
-1.469152164558585e-15,
-2.245504639323285e-16,
-0.00710299017746407,
1.541288642627315e-9,
1.774473781834525e-9,
1.361958430611822e-9,
7.84005686202676e-10,
3.610474005433088e-10,
1.385566301052196e-10,
4.55766356276634e-11,
1.311784706211873e-11,
3.356023208240926e-12,
7.72716239782415e-13,
1.617333302440532e-13,
3.101934345708504e-14,
5.49237006117715e-15,
9.22843849734885e-16,
1.410582381493683e-16,
0.003451606825006452,
-7.27327742013536e-10,
-8.37366850537735e-10,
-6.42702567055564e-10,
-3.699690588243546e-10,
-1.703767912439687e-10,
-6.53843129336682e-11,
-2.150743384844438e-11,
-6.19026236059581e-12,
-1.583695814115268e-12,
-3.646426755243028e-13,
-7.63217406377114e-14,
-1.463807214299238e-14,
-2.591887794538288e-15,
-4.35508209467695e-16,
-6.65714879656431e-17,
-0.001342871981230884,
2.7502443624277e-10,
3.16633525639361e-10,
2.430251231290434e-10,
1.398964040880262e-10,
6.44245806583907e-11,
2.472377415906132e-11,
8.13260866138615e-12,
2.340725497738653e-12,
5.98843721899019e-13,
1.378827164605251e-13,
2.885969997591093e-14,
5.535155502644687e-15,
9.80092279252356e-16,
1.64686560821725e-16,
2.517505987920168e-17,
0.0004357038353220581,
-8.6795601322035e-11,
-9.9927111107011e-11,
-7.66968648719219e-11,
-4.41502330394455e-11,
-2.033190477493569e-11,
-7.8026346156039e-12,
-2.566589706962612e-12,
-7.38715483802935e-13,
-1.889907298748664e-13,
-4.351484119488394e-14,
-9.10794763281617e-15,
-1.746870870158078e-15,
-3.093160834390373e-16,
-5.197615135202055e-17,
-7.9457657352036e-18,
-0.0001212576256324339,
2.35130269861277e-11,
2.707036803379649e-11,
2.077726811335712e-11,
1.196034868515626e-11,
5.50793649856991e-12,
2.113742897948418e-12,
6.95292279393136e-13,
2.001189869260385e-13,
5.119786672164533e-14,
1.178824913311771e-14,
2.467365605926892e-15,
4.732339838550805e-16,
8.37957391012177e-17,
1.40809970178162e-17,
2.152698418287852e-18,
0.00002954790958916573,
-5.58117928813438e-12,
-6.42556903352086e-12,
-4.93180482992254e-12,
-2.838973159271875e-12,
-1.307393694670665e-12,
-5.017295208025463e-13,
-1.65038384646735e-13,
-4.750135306818401e-14,
-1.215261685473416e-14,
-2.79812915670281e-15,
-5.856700012985023e-16,
-1.123304307142019e-16,
-1.989058298428299e-17,
-3.342476178965938e-18,
-5.110171762819018e-19,
-6.404266077599043e-6,
1.17912344287345e-12,
1.35751580859232e-12,
1.041931546437959e-12,
5.99783618307614e-13,
2.762102013920479e-13,
1.05999303965663e-13,
3.486730521818827e-14,
1.003551168419969e-14,
2.567459420724429e-15,
5.91155893689274e-16,
1.237337627564125e-16,
2.373201364517359e-17,
4.202310877073516e-18,
7.06184089038977e-19,
1.07973361923995e-19,
1.250025243365819e-6,
-2.244790661718877e-13,
-2.584410344215958e-13,
-1.983607610175715e-13,
-1.141855598371423e-13,
-5.25843263465913e-14,
-2.017992939099477e-14,
-6.63796670519007e-15,
-1.910540824677984e-15,
-4.887880949443519e-16,
-1.125432662391691e-16,
-2.3556275231425e-17,
-4.518089487447302e-18,
-8.00042084970695e-19,
-1.344466613405997e-19,
-2.05560205551155e-20,
-2.219353200592981e-7,
3.88967946115287e-14,
4.47815827375671e-14,
3.437112423402545e-14,
1.978559723460366e-14,
9.11159288591362e-15,
3.496694270411742e-15,
1.150199419152677e-15,
3.310506962377811e-16,
8.46952449105203e-17,
1.950106685770214e-17,
4.081742937725812e-18,
7.82879945741475e-19,
1.386471655848505e-19,
2.32993259251141e-20,
3.544195648685163e-21,
3.613477534568826e-8,
-6.1844188144143e-15,
-7.12007420210383e-15,
-5.46485724325926e-15,
-3.145822791317304e-15,
-1.448703169485329e-15,
-5.55959033623616e-16,
-1.828766786317905e-16,
-5.263562586237976e-17,
-1.346618278144348e-17,
-3.100589506069347e-18,
-6.48983942667594e-19,
-1.244754531030839e-19,
-2.203926533547571e-20,
-3.704655996876462e-21,
-5.685101204588145e-22,
-5.434569099818521e-9,
9.0877708784087e-16,
1.046268132199494e-15,
8.03040229521302e-16,
4.622668406511284e-16,
2.128814941875872e-16,
8.16960982770349e-17,
2.687304657624723e-17,
7.73461111972939e-18,
1.978803580275419e-18,
4.556189881777632e-19,
9.53823543197382e-20,
1.82963053463848e-20,
3.195700989527213e-21,
5.389611593611348e-22,
1.288149665122591e-22,
7.716150447918959e-10,
-1.260491850788024e-16,
-1.451194662193124e-16,
-1.113832742208439e-16,
-6.41173294986996e-17,
-2.952708715444574e-17,
-1.133141215144693e-17,
-3.727345599493575e-18,
-1.072806336147719e-18,
-2.744650848421965e-19,
-6.319557761428602e-20,
-1.322573556243744e-20,
-2.537302151744386e-21,
-4.530211571145428e-22,
-7.516279806749268e-23,
-8.34224324450276e-24,
-1.004841731075152e-10,
1.605623073154846e-17,
1.848541614408759e-17,
1.418807719162663e-17,
8.16730912489166e-18,
3.761180600002131e-18,
1.443403145211159e-18,
4.747915707531572e-19,
1.366545299352083e-19,
3.49648081683642e-20,
8.05169321451392e-21,
1.667982624226256e-21,
3.182632064112223e-22,
1.019013543708669e-22,
1.503533353754272e-23,
-4.555763815290347e-23,
// [{0,1.e-6},{2.,0.00001}]: m=33
0.00565449852398897,
-1.30460479618623e-9,
-1.50198146742754e-9,
-1.152812902245095e-9,
-6.6361190210242e-10,
-3.05604069174444e-10,
-1.172795077075943e-10,
-3.8577751349924e-11,
-1.110342229603283e-11,
-2.84065535728324e-12,
-6.54051916068428e-13,
-1.368954129058248e-13,
-2.62552635903906e-14,
-4.64870860617394e-15,
-7.8104315019217e-16,
-1.193706739080059e-16,
-0.01097199683117246,
2.45383789452168e-9,
2.82508471261198e-9,
2.168331780244246e-9,
1.248191108768176e-9,
5.74812327298789e-10,
2.205916760015985e-10,
7.25611214691539e-11,
2.088450162108203e-11,
5.34301221858768e-12,
1.230213729953447e-12,
2.574890089549397e-13,
4.93843183084316e-14,
8.74401323168827e-15,
1.469152164558582e-15,
2.245504639323136e-16,
0.01065448526619611,
-2.31193296394097e-9,
-2.66171067275179e-9,
-2.042937645917734e-9,
-1.176008529304014e-9,
-5.41571100814963e-10,
-2.078349451578294e-10,
-6.83649534414952e-11,
-1.96767705931781e-11,
-5.03403481236139e-12,
-1.159074359673623e-12,
-2.425999953660802e-13,
-4.65290151856276e-14,
-8.23855509176462e-15,
-1.384265774602241e-15,
-2.115873572252157e-16,
-0.0069032136500134,
1.454655484027149e-9,
1.674733701075559e-9,
1.285405134111196e-9,
7.39938117648748e-10,
3.407535824879554e-10,
1.307686258673433e-10,
4.3014867696891e-11,
1.238052472119228e-11,
3.167391628230703e-12,
7.29285351048644e-13,
1.526434812754308e-13,
2.927614428598626e-14,
5.18377558907664e-15,
8.710164189354e-16,
1.331429759317764e-16,
0.003357179953077041,
-6.87561090606898e-10,
-7.91583814098373e-10,
-6.07562807822585e-10,
-3.497410102200521e-10,
-1.610614516459705e-10,
-6.1809435397651e-11,
-2.03315216534646e-11,
-5.85181374434641e-12,
-1.497109304747495e-12,
-3.447067911513021e-13,
-7.21492499397506e-14,
-1.383788875660497e-14,
-2.450230698194233e-15,
-4.117164020607902e-16,
-6.293764963112214e-17,
-0.001307111505942551,
2.60386803962411e-10,
2.997813333167804e-10,
2.300905946125016e-10,
1.324506991164577e-10,
6.09957143239418e-11,
2.340790384647964e-11,
7.69976912077861e-12,
2.216146451377369e-12,
5.66972189616554e-13,
1.305445235828002e-13,
2.73238428980676e-14,
5.240612610396177e-15,
9.27948250298692e-16,
1.559284540604435e-16,
2.38372972003259e-17,
0.0004244016897180538,
-8.22955944521412e-11,
-9.4746288119087e-11,
-7.27204383973634e-11,
-4.186122039840007e-11,
-1.927777774515732e-11,
-7.39810014288188e-12,
-2.433522977896516e-12,
-7.00416454247055e-13,
-1.791925335271643e-13,
-4.125887196620121e-14,
-8.6357796213663e-15,
-1.65631894366348e-15,
-2.932850854081713e-16,
-4.928348939725151e-17,
-7.53444598915282e-18,
-0.0001181916388517221,
2.232471722994685e-11,
2.570227622320425e-11,
1.972721938809287e-11,
1.135589267646325e-11,
5.22957479681584e-12,
2.006918090169036e-12,
6.60153540875972e-13,
1.900054129315683e-13,
4.861046758753671e-14,
1.119251666560568e-14,
2.342680013172325e-15,
4.493217244949865e-16,
7.95623324043855e-17,
1.336990464232803e-17,
2.044068673928208e-18,
0.00002881919729217577,
-5.30605548420182e-12,
-6.10882112861615e-12,
-4.68869195125771e-12,
-2.699026277944241e-12,
-1.242945904219519e-12,
-4.769968670608136e-13,
-1.569028732236094e-13,
-4.515980250448056e-14,
-1.155356737545206e-14,
-2.66020151790902e-15,
-5.568019252924709e-16,
-1.067940593913566e-16,
-1.891041523877464e-17,
-3.177830356875686e-18,
-4.858629566894207e-19,
-6.250120935258113e-6,
1.122394505018801e-12,
1.292204221323941e-12,
9.91803075334342e-13,
5.70927379106054e-13,
2.629214382793352e-13,
1.00899572714567e-13,
3.318980910542228e-14,
9.55269709464356e-15,
2.443938676119121e-15,
5.627159172651074e-16,
1.177812908148496e-16,
2.259043026467207e-17,
4.000205368572233e-18,
6.722336152356995e-19,
1.027810782829048e-19,
1.220644625280755e-6,
-2.139324262310892e-13,
-2.462987693766551e-13,
-1.890412326545797e-13,
-1.088208132084902e-13,
-5.011377395951937e-14,
-1.923182350951626e-14,
-6.32609845812306e-15,
-1.820779305549641e-15,
-4.658239615432846e-16,
-1.072558916881011e-16,
-2.244962876745728e-17,
-4.305851774088323e-18,
-7.62462819882444e-19,
-1.281345040778105e-19,
-1.959487283833309e-20,
-2.168386174973285e-7,
3.71111983316198e-14,
4.27258395299344e-14,
3.27932837499489e-14,
1.887732008931565e-14,
8.69331658499083e-15,
3.336175408127687e-15,
1.097398622902965e-15,
3.158536330644323e-16,
8.08073004050973e-17,
1.860588593127535e-17,
3.894390181892899e-18,
7.46948311940738e-19,
1.322613232607619e-19,
2.222872972358114e-20,
3.405876989564993e-21,
3.53235489164462e-8,
-5.90687499248913e-15,
-6.80054014148676e-15,
-5.2196059002584e-15,
-3.004644898530986e-15,
-1.383688465861329e-15,
-5.310088101229071e-16,
-1.746695937756126e-16,
-5.02734714967578e-17,
-1.286186114936088e-17,
-2.961446920651113e-18,
-6.198569192303091e-19,
-1.188902347279072e-19,
-2.106097090000359e-20,
-3.538279260551851e-21,
-5.32713115742115e-22,
-5.315239658506984e-9,
8.68886993005607e-16,
1.000342973567432e-15,
7.67791383339171e-16,
4.419759917902354e-16,
2.035372296425052e-16,
7.81101170279995e-17,
2.569347923468206e-17,
7.39510913058099e-18,
1.891951486568658e-18,
4.356216796416817e-19,
9.11733336493731e-20,
1.749052536006028e-20,
3.114568354202504e-21,
5.18498690094137e-22,
6.16100073257643e-23,
7.550470452779185e-10,
-1.20638453675778e-16,
-1.388901328389632e-16,
-1.066020862407885e-16,
-6.13650588512327e-17,
-2.825962188080739e-17,
-1.084500606903752e-17,
-3.567348059718895e-18,
-1.026755973034385e-18,
-2.62682677782891e-19,
-6.04829170190391e-20,
-1.266325008532655e-20,
-2.428410495435508e-21,
-4.20685752497435e-22,
-7.205101985778775e-23,
-2.076257516256382e-23,
-9.83717502814454e-11,
1.538142387266035e-17,
1.770851620233542e-17,
1.359178470423342e-17,
7.82405586925973e-18,
3.603106877698618e-18,
1.382740314482133e-18,
4.548377227589725e-19,
1.309114206372398e-19,
3.349074876242022e-20,
7.71268285081091e-21,
1.621536536104305e-21,
3.066711391699696e-22,
3.59521870025323e-23,
1.234367024875968e-23,
2.043456131167706e-23,
// [{0,1.e-6},{2.,0.00001}]: m=34
0.00548599841558623,
-1.22691894726084e-9,
-1.41254235630599e-9,
-1.084165890122123e-9,
-6.24095554384088e-10,
-2.87406163649394e-10,
-1.102958380007993e-10,
-3.62805607345769e-11,
-1.044225081054101e-11,
-2.67150610929384e-12,
-6.15106864976724e-13,
-1.287445044774699e-13,
-2.46921591542158e-14,
-4.37200661584413e-15,
-7.3457608227929e-16,
-1.122752319661581e-16,
-0.01065448526619611,
2.31193296394097e-9,
2.66171067275179e-9,
2.042937645917733e-9,
1.176008529304014e-9,
5.41571100814963e-10,
2.078349451578293e-10,
6.83649534414951e-11,
1.96767705931781e-11,
5.03403481236139e-12,
1.159074359673622e-12,
2.425999953660802e-13,
4.65290151856276e-14,
8.23855509176464e-15,
1.384265774602251e-15,
2.115873572251907e-16,
0.0103548204750201,
-2.18198322604072e-9,
-2.51210055161334e-9,
-1.928107701166794e-9,
-1.109907176473123e-9,
-5.11130373731933e-10,
-1.961529388010149e-10,
-6.45223015453366e-11,
-1.857078708178842e-11,
-4.75108744234606e-12,
-1.093928026572966e-12,
-2.28965221913146e-13,
-4.39142164289793e-14,
-7.77566338361539e-15,
-1.306524628403206e-15,
-1.997144638972174e-16,
-0.00671435990615456,
1.375122181213869e-9,
1.583167628196832e-9,
1.215125615645236e-9,
6.99482020440142e-10,
3.221229032919584e-10,
1.236188707953086e-10,
4.066304330693139e-11,
1.170362748869345e-11,
2.99421860949515e-12,
6.89413582302641e-13,
1.442984998795098e-13,
2.767577751321194e-14,
4.900461396386101e-15,
8.23432804120992e-16,
1.258752992651687e-16,
0.003267778764856212,
-6.50967009906003e-10,
-7.49453333291922e-10,
-5.75226486531232e-10,
-3.311267477911315e-10,
-1.524892858098486e-10,
-5.85197596161968e-11,
-1.924942280194578e-11,
-5.54036612844321e-12,
-1.417430474041329e-12,
-3.26361308956987e-13,
-6.83096072451754e-14,
-1.31015315259934e-14,
-2.319870625722371e-15,
-3.898211351467837e-16,
-5.959324302635887e-17,
-0.001273205069131025,
2.46886783352882e-10,
2.842388643531835e-10,
2.181613151889606e-10,
1.255836611933986e-10,
5.78333332346423e-11,
2.219430042832724e-11,
7.30056893358482e-12,
2.10124936271102e-12,
5.37577600573787e-13,
1.237766158968312e-13,
2.590733886369304e-14,
4.96895683090894e-15,
8.79855256305824e-16,
1.478504682021833e-16,
2.260333786695069e-17,
0.0004136707359854712,
-7.81365103054803e-11,
-8.9957966781982e-11,
-6.90452678589138e-11,
-3.974562436796028e-11,
-1.830351178901153e-11,
-7.02421331565152e-12,
-2.3105373930856e-12,
-6.65018945266158e-13,
-1.701366365578669e-13,
-3.91738083299653e-14,
-8.19938004596865e-15,
-1.572626035705473e-15,
-2.784681639639851e-16,
-4.679466630232403e-17,
-7.15423978469092e-18,
-0.0001152767896535688,
2.122422201103011e-11,
2.443528459991677e-11,
1.875476787061777e-11,
1.079610514953182e-11,
4.97178363426481e-12,
1.907987474915646e-12,
6.27611495089258e-13,
1.806392106496399e-13,
4.621426966332934e-14,
1.064080610881265e-14,
2.227207709482701e-15,
4.271762391712463e-16,
7.56416598182041e-17,
1.271132133627906e-17,
1.943453295460313e-18,
0.000028125544152792,
-5.05077526420798e-12,
-5.81491898631379e-12,
-4.46311383160254e-12,
-2.569173201716312e-12,
-1.183146470294779e-12,
-4.540480764625208e-13,
-1.493541407267383e-13,
-4.29871368545945e-14,
-1.099772402386388e-14,
-2.53222162351513e-15,
-5.300158101125311e-16,
-1.016569360368768e-16,
-1.80009179711761e-17,
-3.025051165702707e-18,
-4.625212733032658e-19,
-6.10321795358166e-6,
1.069661339309996e-12,
1.231492935237634e-12,
9.45205463559201e-13,
5.44103663255087e-13,
2.505686843073647e-13,
9.61590463632314e-14,
3.163046887522166e-14,
9.1038897882869e-15,
2.329118084205689e-15,
5.362790617243476e-16,
1.122480570128179e-16,
2.152924208512464e-17,
3.812321088969953e-18,
6.40673037284528e-19,
9.79642077317677e-20,
1.192612753826762e-6,
-2.041116444381192e-13,
-2.349921791402717e-13,
-1.803631080008801e-13,
-1.038252877631328e-13,
-4.781325377661764e-14,
-1.834896956443021e-14,
-6.03569401111956e-15,
-1.737195438354371e-15,
-4.444402716485638e-16,
-1.023323985316029e-16,
-2.141913744303869e-17,
-4.108219180675275e-18,
-7.27474582196418e-19,
-1.222557735922616e-19,
-1.86940226232867e-20,
-2.119706419299932e-7,
3.54457425278985e-14,
4.08084131139861e-14,
3.132160526061812e-14,
1.803015462452337e-14,
8.303183182861e-15,
3.186456728545619e-15,
1.04815041085196e-15,
3.016790656079419e-16,
7.71809470446452e-17,
1.777093253539089e-17,
3.719624654041712e-18,
7.13435862807775e-19,
1.263515191271092e-19,
2.122776177293361e-20,
3.227329128771335e-21,
3.454793075443444e-8,
-5.64759647832005e-15,
-6.5020347871557e-15,
-4.99049467598364e-15,
-2.872757993640857e-15,
-1.322952409871419e-15,
-5.077005703472723e-16,
-1.670026191092687e-16,
-4.806677024501906e-17,
-1.229730825010377e-17,
-2.831461371530693e-18,
-5.92653146984501e-19,
-1.136711907920313e-19,
-2.0129813453051e-20,
-3.384664861820289e-21,
-5.171656958880977e-22,
-5.201035755688645e-9,
8.3156582833794e-16,
9.57375404211709e-16,
7.34812569469677e-16,
4.229918770170786e-16,
1.947947369090863e-16,
7.47550731934756e-17,
2.458987677777674e-17,
7.07747055872212e-18,
1.810684092152079e-18,
4.169145238490968e-19,
8.72797002328983e-20,
1.672943458127641e-20,
2.920890945355606e-21,
5.077789626535759e-22,
1.236868806403578e-22,
7.391753107390528e-10,
-1.155686605559e-16,
-1.330533190490268e-16,
-1.021221680051231e-16,
-5.87862128080257e-17,
-2.707202141065729e-17,
-1.038924909461156e-17,
-3.417432012799324e-18,
-9.8360730628977e-19,
-2.516441942720573e-19,
-5.794088220503451e-20,
-1.21282148064068e-20,
-2.327640460936953e-21,
-4.114007621065378e-22,
-6.734305664773799e-23,
-1.057380578159847e-23,
-9.63462826647596e-11,
1.474826704583599e-17,
1.697956761845393e-17,
1.303229622226644e-17,
7.50198867997647e-18,
3.454789724768575e-18,
1.325821631818308e-18,
4.361145456769771e-19,
1.255232863369368e-19,
3.211648553589105e-20,
7.39144749806686e-21,
1.532117654696513e-21,
3.052332172424135e-22,
9.53003010691417e-23,
-1.134227950850482e-24,
-4.581022746476021e-23,
// [{0,1.e-6},{2.,0.00001}]: m=35
0.00532724263309806,
-1.15596648197049e-9,
-1.33085533637589e-9,
-1.021468822958867e-9,
-5.88004264652007e-10,
-2.70785550407482e-10,
-1.039174725789147e-10,
-3.41824767207476e-11,
-9.83838529658905e-12,
-2.51701740618069e-12,
-5.79537179836811e-13,
-1.212999976830401e-13,
-2.32645075928138e-14,
-4.11927754588232e-15,
-6.92132887301125e-16,
-1.057936786125937e-16,
-0.01035482047502009,
2.18198322604072e-9,
2.51210055161334e-9,
1.928107701166794e-9,
1.109907176473122e-9,
5.11130373731933e-10,
1.961529388010149e-10,
6.45223015453366e-11,
1.857078708178842e-11,
4.75108744234605e-12,
1.093928026572966e-12,
2.28965221913146e-13,
4.39142164289793e-14,
7.7756633836154e-15,
1.306524628403221e-15,
1.997144638971982e-16,
0.01007153985923185,
-2.0626832718208e-9,
-2.374751442295248e-9,
-1.822688423467855e-9,
-1.049223030660213e-9,
-4.83184354937938e-10,
-1.854283061929629e-10,
-6.09945649603971e-11,
-1.755544123304018e-11,
-4.49132791424273e-12,
-1.034120373453962e-12,
-2.16447749819265e-13,
-4.151366626981778e-14,
-7.35069209457824e-15,
-1.235149206181668e-15,
-1.888129488987479e-16,
-0.0065355575297129,
1.301934019812077e-9,
1.498906666583926e-9,
1.150452973062526e-9,
6.62253495582299e-10,
3.049785716197138e-10,
1.170395192324001e-10,
3.849884560389366e-11,
1.108073225688702e-11,
2.834860948082811e-12,
6.52722617914009e-13,
1.366192144903589e-13,
2.620306305198936e-14,
4.639741251443864e-15,
7.79642270292193e-16,
1.191864860536811e-16,
0.003183012672827399,
-6.17216958382181e-10,
-7.10597160882931e-10,
-5.4540328797238e-10,
-3.139591529834844e-10,
-1.445833330866002e-10,
-5.54857510708159e-11,
-1.825142233396133e-11,
-5.25312340677735e-12,
-1.343944001434419e-12,
-3.094415397420628e-13,
-6.47683471592083e-14,
-1.242239207728155e-14,
-2.199638140824003e-15,
-3.696261704936611e-16,
-5.650834460194964e-17,
-0.001241012207933744,
2.344095309130419e-10,
2.698739003420328e-10,
2.07135803573738e-10,
1.192368731021519e-10,
5.49105353662384e-11,
2.107263994664902e-11,
6.93161217915629e-12,
1.995056835769545e-12,
5.104099096662028e-13,
1.17521424988201e-13,
2.459814013753884e-14,
4.717878107017047e-15,
8.3540449189681e-16,
1.403839989443173e-16,
2.146271934430909e-17,
0.0004034687637918467,
-7.42847770392453e-11,
-8.55234961004454e-11,
-6.56416875477277e-11,
-3.778636802368689e-11,
-1.740124272007675e-11,
-6.67795616226229e-12,
-2.196640232831336e-12,
-6.32237237279174e-13,
-1.617499438229489e-13,
-3.724282138124182e-14,
-7.79522698377667e-15,
-1.495116836873656e-15,
-2.647458079358119e-16,
-4.448962496554574e-17,
-6.80208811272966e-18,
-0.0001125021770862514,
2.020310112806096e-11,
2.32596760272606e-11,
1.785245538935165e-11,
1.027669284309725e-11,
4.732585897864552e-12,
1.816192312253342e-12,
5.97416565013242e-13,
1.719485480246254e-13,
4.399089625052526e-14,
1.012888652965704e-14,
2.120063247990634e-15,
4.066277459731328e-16,
7.20036721180858e-17,
1.210020420345611e-17,
1.850084998883119e-18,
0.00002746448073635289,
-4.81347601884957e-12,
-5.54171819930673e-12,
-4.25342457890708e-12,
-2.448466480555438e-12,
-1.127559077498504e-12,
-4.327157079112727e-13,
-1.423371097004766e-13,
-4.096750397896044e-14,
-1.048103136251729e-14,
-2.413255772816799e-15,
-5.051162497597231e-16,
-9.68815920352635e-17,
-1.71554612831342e-17,
-2.883025281107753e-18,
-4.408207841581919e-19,
-5.963058700674165e-6,
1.020557462284309e-12,
1.174960020827031e-12,
9.01814868513717e-13,
5.1912605227476e-13,
2.39066090874615e-13,
9.17447795090244e-14,
3.017844758470013e-14,
8.68597072409172e-15,
2.222199703660645e-15,
5.116616124126679e-16,
1.0709560760576e-16,
2.05410780616753e-17,
3.63736882312298e-18,
6.112816876695458e-19,
9.34723199998893e-20,
1.165838881134393e-6,
-1.949516353977835e-13,
-2.244463314119676e-13,
-1.722688744363418e-13,
-9.91658766284605e-14,
-4.566751956827773e-14,
-1.75255166362487e-14,
-5.76482878307343e-15,
-1.659235298231221e-15,
-4.244953143216752e-16,
-9.77401603215204e-17,
-2.045797611792099e-17,
-3.923881125589879e-18,
-6.94836702725219e-19,
-1.167732614868005e-19,
-1.785746537467921e-20,
-2.073163408523282e-7,
3.38898902355301e-14,
3.90171723653663e-14,
2.994677779124635e-14,
1.723874102063215e-14,
7.93872439904521e-15,
3.046590999972932e-15,
1.002143204278826e-15,
2.884373159289423e-16,
7.37932376147398e-17,
1.699092738370171e-17,
3.556368010484926e-18,
6.82122190196267e-19,
1.208060232701084e-19,
2.029989854401652e-20,
3.088504727954462e-21,
3.380562767506123e-8,
-5.40501558916659e-15,
-6.22275327834187e-15,
-4.77613828965373e-15,
-2.74936464613892e-15,
-1.266127772314721e-15,
-4.858933857377809e-16,
-1.598293979236802e-16,
-4.600218002343271e-17,
-1.176911242183627e-17,
-2.709846095260122e-18,
-5.671982223372289e-19,
-1.087902164104287e-19,
-1.926843578610928e-20,
-3.238198246125512e-21,
-4.906730267558459e-22,
-5.091634230863658e-9,
7.9659772886426e-16,
9.17116900489274e-16,
7.03913039107895e-16,
4.052046926612116e-16,
1.866034497376709e-16,
7.1611561233846e-17,
2.355585481225329e-17,
6.77985961349127e-18,
1.734543884996538e-18,
3.993809100213871e-19,
8.36115909948311e-20,
1.603359962954948e-20,
2.797336254305661e-21,
4.778876375462943e-22,
1.154455049350878e-22,
7.239568696404187e-10,
-1.108117609459293e-16,
-1.275767371227767e-16,
-9.79187377856998e-17,
-5.63665258808273e-17,
-2.595771625764197e-17,
-9.96162011076955e-18,
-3.27676834307206e-18,
-9.43121563772156e-19,
-2.412864578441533e-19,
-5.555635827647252e-20,
-1.162999172488739e-20,
-2.23072768593105e-21,
-3.90490871013946e-22,
-6.610138782122201e-23,
-1.5563126216083e-23,
-9.44025112932098e-11,
1.415340291175606e-17,
1.629470511416002e-17,
1.250664503835549e-17,
7.19939977946744e-18,
3.315442622121353e-18,
1.272345419286363e-18,
4.185240206382356e-19,
1.204599415193073e-19,
3.082206135594071e-20,
7.096066574274561e-21,
1.467076987541636e-21,
2.849745371283197e-22,
9.58704456037788e-23,
7.933304794569657e-24,
-4.464599004405113e-23,
// [{0,1.e-6},{2.,0.00001}]: m=36
0.00517741023751005,
-1.09099161302036e-9,
-1.25605027580667e-9,
-9.64053850583397e-10,
-5.54953588236561e-10,
-2.55565186865967e-10,
-9.80764694005074e-11,
-3.22611507726683e-11,
-9.28539354089421e-12,
-2.37554372117303e-12,
-5.46964013286483e-13,
-1.14482610956573e-13,
-2.19571082144896e-14,
-3.8878316918077e-15,
-6.53262314201611e-16,
-9.98572319485988e-17,
-0.01007153985923185,
2.0626832718208e-9,
2.37475144229525e-9,
1.822688423467854e-9,
1.049223030660213e-9,
4.83184354937938e-10,
1.854283061929628e-10,
6.09945649603971e-11,
1.755544123304017e-11,
4.49132791424273e-12,
1.034120373453962e-12,
2.16447749819265e-13,
4.15136662698178e-14,
7.35069209457823e-15,
1.235149206181678e-15,
1.88812948898751e-16,
0.00980333629456935,
-1.95290102971812e-9,
-2.248359999875889e-9,
-1.72567945959379e-9,
-9.93380243373449e-10,
-4.57467857429571e-10,
-1.755592788486001e-10,
-5.77482684058405e-11,
-1.662109838533053e-11,
-4.25229142212422e-12,
-9.79083926871014e-13,
-2.049288217355385e-13,
-3.930459457798406e-14,
-6.95961187716535e-15,
-1.169463405438284e-15,
-1.787797290809774e-16,
-0.00636602534565526,
1.23443391676443e-9,
1.421194321765941e-9,
1.090806575944821e-9,
6.27918305967003e-10,
2.891666661732163e-10,
1.10971502141638e-10,
3.650284466792467e-11,
1.050624681355527e-11,
2.687888002868987e-12,
6.18883079484159e-13,
1.295366943184238e-13,
2.484478415456528e-14,
4.399276281647748e-15,
7.39252340986511e-16,
1.130166892047797e-16,
0.0031025305198342,
-5.86023827282582e-10,
-6.74684750855055e-10,
-5.17839508934325e-10,
-2.980921827553681e-10,
-1.372763384155906e-10,
-5.26815998666205e-11,
-1.732903044789005e-11,
-4.98764208942367e-12,
-1.27602477416546e-12,
-2.938035624704914e-13,
-6.14953503438302e-14,
-1.179469526754167e-14,
-2.088511229778466e-15,
-3.509599973606134e-16,
-5.365679832348731e-17,
-0.001210406291353319,
2.228543311144715e-10,
2.565704882975779e-10,
1.969250626402983e-10,
1.133591040694001e-10,
5.22037281594655e-11,
2.003386848649341e-11,
6.58992069839748e-12,
1.896711711809736e-12,
4.852498314617388e-13,
1.117284641420975e-13,
2.338568095097887e-14,
4.485350510532543e-15,
7.94237423831835e-16,
1.334688749184491e-16,
2.040626428848477e-17,
0.0003937576198061513,
-7.07108539488285e-11,
-8.14088660961203e-11,
-6.24835938632743e-11,
-3.596842495115328e-11,
-1.656405064267002e-11,
-6.35667309294199e-12,
-2.090957977564546e-12,
-6.01819918091427e-13,
-1.539681368780934e-13,
-3.545110285410042e-14,
-7.42022136843996e-15,
-1.423197110922675e-15,
-2.520128513928341e-16,
-4.2350714724827e-17,
-6.475298534959332e-18,
-0.0001098579234110994,
1.925390414381097e-11,
2.216687287598995e-11,
1.701369837608116e-11,
9.79386595702119e-12,
4.510236326019732e-12,
1.730862837795172e-12,
5.69348440824911e-13,
1.638700164981245e-13,
4.19241255990117e-14,
9.65302312546322e-15,
2.020465006424179e-15,
3.875263697888042e-16,
6.86218446525948e-17,
1.153210087976473e-17,
1.763284059283185e-18,
0.00002683376409933124,
-4.59250857254593e-12,
-5.28732008481816e-12,
-4.05816690147805e-12,
-2.336067231302644e-12,
-1.075797407124206e-12,
-4.128515070954003e-13,
-1.358030139023439e-13,
-3.908686819256666e-14,
-9.9998986507261e-15,
-2.302477252049548e-15,
-4.819302281437604e-16,
-9.24348511180056e-17,
-1.636817284285468e-17,
-2.750767398441568e-18,
-4.2061210733363e-19,
-5.829189437448445e-6,
9.74757447128237e-13,
1.122230816776786e-12,
8.613437272408e-13,
4.95829011884665e-13,
2.283374268711058e-13,
8.76275175691213e-14,
2.882412233294173e-14,
8.29617027917555e-15,
2.122474982646386e-15,
4.88700436278483e-16,
1.022898020135162e-16,
1.961938936176742e-17,
3.474187293636071e-18,
5.838675557424156e-19,
8.92795610255431e-20,
1.140240218409418e-6,
-1.863944457931381e-13,
-2.145945049958663e-13,
-1.647073215904864e-13,
-9.4813100791445e-14,
-4.366299578957136e-14,
-1.675625494951559e-14,
-5.511789088016365e-15,
-1.586405659031702e-15,
-4.058629075410292e-16,
-9.34501250451244e-17,
-1.95600635596773e-17,
-3.751673021355077e-18,
-6.64347736503316e-19,
-1.116506208357704e-19,
-1.707326502839724e-20,
-2.028619536813731e-7,
3.24342344363244e-14,
3.73412870582616e-14,
2.866048884264489e-14,
1.649829422573519e-14,
7.59773664239302e-15,
2.915732568141524e-15,
9.59098836540997e-16,
2.760483237873013e-16,
7.06236897774067e-17,
1.62611509796558e-17,
3.403632610716297e-18,
6.52829241825444e-19,
1.155990244582029e-19,
1.94265982371056e-20,
2.974975002699445e-21,
3.309453918842485e-8,
-5.17772923533045e-15,
-5.96108024893275e-15,
-4.57529690287808e-15,
-2.633751148735764e-15,
-1.212885879820028e-15,
-4.654611239770856e-16,
-1.53108440625916e-16,
-4.406775932145772e-17,
-1.12742183157384e-17,
-2.595898897364434e-18,
-5.433493361198443e-19,
-1.042149345731465e-19,
-1.845542727002125e-20,
-3.103362272525944e-21,
-4.743855561277415e-22,
-4.986738520848057e-9,
7.63789028532323e-16,
8.79344496198595e-16,
6.74921659493183e-16,
3.885159269239969e-16,
1.789180019263903e-16,
6.86621714599734e-17,
2.25856862887302e-17,
6.50062636988584e-18,
1.663110925535417e-18,
3.829338777637186e-19,
8.01459019409071e-20,
1.53690629366173e-20,
2.735895701750563e-21,
4.634777449257331e-22,
5.83946521135321e-23,
7.093522140888153e-10,
-1.06342534638923e-16,
-1.224313512342455e-16,
-9.39695097786079e-17,
-5.409316934749913e-17,
-2.491079858776153e-17,
-9.55985190862666e-18,
-3.144611291159414e-18,
-9.05084297689872e-19,
-2.315551934505038e-19,
-5.331517298177653e-20,
-1.116002348214095e-20,
-2.142374340476709e-21,
-3.786138428810164e-22,
-6.176461685044963e-23,
-9.61496820184437e-24,
-9.25355927596536e-11,
1.359380562733914e-17,
1.565044505997368e-17,
1.201215737073915e-17,
6.91475002300113e-18,
3.184356738515563e-18,
1.222039515203414e-18,
4.019770750069836e-19,
1.156974287098264e-19,
2.959827917946247e-20,
6.814092518261924e-21,
1.433420506228407e-21,
2.784262056738293e-22,
3.3051215706099e-23,
1.759358252230744e-24,
1.491757625283246e-23
}
,{
// [{0,0.00001},{2.,0.0001}]: m=-1
155.7492388328067,
-181.4219983211386,
104.4543434307174,
-40.07851371037724,
11.53755077143807,
-2.656188792208226,
0.5097440435646096,
-0.0838307571261609,
0.01206405474255717,
-0.001543545534376746,
0.0001776187867601738,
-0.00001860819367828355,
1.782528728515215e-6,
-1.581114948853512e-7,
1.309309875048034e-8,
-9.89665585311111e-10,
-1.473877706255828,
0.02257417276539369,
0.0127802130108668,
0.004741503220823927,
0.001272180866809063,
0.000251238013616286,
0.00003273135290175263,
5.46275671985015e-7,
-1.206485135445219e-6,
-4.432635997165408e-7,
-1.043612727623789e-7,
-1.81734532143435e-8,
-2.097899641635827e-9,
-1.625108580033e-12,
8.830682536131131e-11,
2.916009393797762e-11,
0.378909858727456,
-0.0000797291355779416,
-0.000090972602813152,
-0.0000688874951766756,
-0.00003885335509431764,
-0.00001734559097238334,
-6.346736054468508e-6,
-1.938069260229025e-6,
-4.95076071982951e-7,
-1.035157206568306e-7,
-1.626156785512814e-8,
-1.197356304857663e-9,
3.409307486274038e-10,
1.907545764696372e-10,
5.900762959199679e-11,
1.291000780666324e-11,
-0.1336879700167898,
8.65895505546272e-6,
9.96737052697645e-6,
7.64776618816103e-6,
4.399579413720824e-6,
2.023497543076765e-6,
7.74583505327512e-7,
2.535178997443738e-7,
7.22468600860236e-8,
1.812226849787269e-8,
4.010580810575627e-9,
7.73828966076979e-10,
1.244397209735652e-10,
1.394245378498971e-11,
-4.941766338472281e-13,
-8.09420600791838e-13,
0.04448747619111063,
-1.627869828841208e-6,
-1.87405604299976e-6,
-1.438240202105189e-6,
-8.27743834622268e-7,
-3.810301085037591e-7,
-1.461029391557441e-7,
-4.797848564420398e-8,
-1.376289067908577e-8,
-3.497409867411435e-9,
-7.94401047583067e-10,
-1.617352897931263e-10,
-2.930022529488272e-11,
-4.578685935462785e-12,
-5.381810465539648e-13,
-1.776605052482853e-14,
-0.01323272002832564,
3.32197771763228e-7,
3.82445206554087e-7,
2.935197193660073e-7,
1.689430125644405e-7,
7.77822344338431e-8,
2.983553266194098e-8,
9.80458244044151e-9,
2.816495937613055e-9,
7.17772368508072e-10,
1.639809745344065e-10,
3.378495469597435e-11,
6.275660747922672e-12,
1.038586061817355e-12,
1.467371600096211e-13,
1.461326843802589e-14,
0.003499070232786285,
-6.63945809740875e-8,
-7.64379719863734e-8,
-5.86658337517805e-8,
-3.37679159193675e-8,
-1.554807270929166e-8,
-5.96477706599215e-9,
-1.960731742411728e-9,
-5.635805685651497e-10,
-1.437975082493603e-10,
-3.293084928197109e-11,
-6.81805240014263e-12,
-1.279319581927434e-12,
-2.164293423413787e-13,
-3.249797865012554e-14,
-3.876684938080389e-15,
-0.000827093822832123,
1.257067064107027e-8,
1.447228643707916e-8,
1.110753271065217e-8,
6.39359808667446e-9,
2.943981531132497e-9,
1.129503634752925e-9,
3.71348299231055e-10,
1.067724380565638e-10,
2.726058400373971e-11,
6.251033329181516e-12,
1.297640180281682e-12,
2.447976479498752e-13,
4.189078948325746e-14,
6.481010301746531e-15,
8.33227506141163e-16,
0.0001761641234748246,
-2.228791987420852e-9,
-2.565958331277156e-9,
-1.96939472786343e-9,
-1.133615936635166e-9,
-5.21995276927954e-10,
-2.002815271453517e-10,
-6.58534091013486e-11,
-1.893839660994695e-11,
-4.837200414293241e-12,
-1.110100717905489e-12,
-2.308210257320765e-13,
-4.368858746909831e-14,
-7.52849450598396e-15,
-1.185477980442212e-15,
-1.5875457251719e-16,
-0.00003408138351530461,
3.68890930823078e-10,
4.24696777412848e-10,
3.259597590800329e-10,
1.876293881319339e-10,
8.63990363580228e-11,
3.315110687779182e-11,
1.090096746774223e-11,
3.135373827513529e-12,
8.01049077356889e-13,
1.839358310498792e-13,
3.82878652645339e-14,
7.26317148494292e-15,
1.257464452805746e-15,
2.003154240286087e-16,
2.75201222086335e-17,
6.033214551662458e-6,
-5.7018261465164e-11,
-6.56440892585865e-11,
-5.03827638025476e-11,
-2.900157186898399e-11,
-1.335472423278409e-11,
-5.124302551192198e-12,
-1.685090344939948e-12,
-4.8471933488703e-13,
-1.238642632653869e-13,
-2.845284315367207e-14,
-5.927448399280869e-15,
-1.126242709064386e-15,
-1.956373903947866e-16,
-3.142103091043732e-17,
-4.392880536766759e-18,
-9.83697221242337e-7,
8.24624860507152e-12,
9.49376734686406e-12,
7.28661720414026e-12,
4.19437758959118e-12,
1.931456590622933e-12,
7.41127404506323e-13,
2.437235342849778e-13,
7.01127465409905e-14,
1.791915296350344e-14,
4.117439194897856e-15,
8.58284026074213e-16,
1.632754942743253e-16,
2.843330820716759e-17,
4.594401556120602e-18,
6.505215356859164e-19,
1.485684785210759e-7,
-1.118686438554175e-12,
-1.287926053371217e-12,
-9.88505493194945e-13,
-5.69013058411689e-13,
-2.620250511604144e-13,
-1.005442046923189e-13,
-3.306543634975973e-14,
-9.51259544375924e-15,
-2.431476649748694e-15,
-5.588320239962393e-16,
-1.165437878846274e-16,
-2.219158387868218e-17,
-3.872020984926551e-18,
-6.285901394192634e-19,
-8.98603953299018e-20,
-2.089646627292603e-8,
1.427747994461498e-13,
1.64374494466946e-13,
1.261604475010228e-13,
7.26219040503393e-14,
3.344188441349407e-14,
1.283246323367168e-14,
4.220242078186359e-15,
1.214178064971696e-15,
3.103801969654498e-16,
7.13487738356593e-17,
1.488531837990404e-17,
2.83650760429607e-18,
4.956550048399505e-19,
8.077244122184297e-20,
1.166370871763905e-20,
2.789215382307518e-9,
-1.740259718299662e-14,
-2.003536242415758e-14,
-1.537752781082564e-14,
-8.85180803317531e-15,
-4.076216171629209e-15,
-1.564158346475977e-15,
-5.144184026312749e-16,
-1.480056910913075e-16,
-3.783762525289036e-17,
-8.69929812917568e-18,
-1.815482492620532e-18,
-3.46171698193703e-19,
-6.056878642235158e-20,
-9.89926801832698e-21,
-1.437813888459368e-21,
-3.440844006581089e-10,
1.979292950835465e-15,
2.278732926886548e-15,
1.748973283073618e-15,
1.006768224157423e-15,
4.636138887610646e-16,
1.779030451064397e-16,
5.850945211933131e-17,
1.683455752783549e-17,
4.304026880213219e-18,
9.89668446076927e-19,
2.065756860906066e-19,
3.941604838158862e-20,
6.938019558104717e-21,
1.125785463769517e-21,
1.305505459485394e-22,
// [{0,0.00001},{2.,0.0001}]: m=0
0.736938853127914,
-0.01128708638269685,
-0.006390106505433398,
-0.002370751610411963,
-0.0006360904334045316,
-0.000125619006808143,
-0.00001636567645087632,
-2.731378359925077e-7,
6.032425677226097e-7,
2.216317998582704e-7,
5.218063638118946e-8,
9.08672660717175e-9,
1.048949820817914e-9,
8.125542900165e-13,
-4.415341268065565e-11,
-1.458004696898881e-11,
-0.378909858727456,
0.0000797291355779416,
0.000090972602813152,
0.0000688874951766756,
0.00003885335509431764,
0.00001734559097238334,
6.34673605446851e-6,
1.938069260229025e-6,
4.95076071982951e-7,
1.035157206568306e-7,
1.626156785512814e-8,
1.197356304857663e-9,
-3.409307486274038e-10,
-1.907545764696372e-10,
-5.900762959199679e-11,
-1.291000780666324e-11,
0.2005319550251848,
-0.00001298843258319408,
-0.00001495105579046468,
-0.00001147164928224155,
-6.59936912058124e-6,
-3.035246314615147e-6,
-1.161875257991267e-6,
-3.802768496165607e-7,
-1.083702901290354e-7,
-2.718340274680904e-8,
-6.01587121586344e-9,
-1.160743449115468e-9,
-1.866595814603478e-10,
-2.091368067748457e-11,
7.412649507708422e-13,
1.214130901187757e-12,
-0.0889749523822229,
3.25573965768243e-6,
3.74811208599953e-6,
2.876480404210386e-6,
1.655487669244541e-6,
7.6206021700752e-7,
2.92205878311489e-7,
9.59569712884082e-8,
2.75257813581716e-8,
6.99481973482289e-9,
1.588802095166139e-9,
3.234705795862536e-10,
5.860045058976561e-11,
9.1573718709256e-12,
1.076362093107935e-12,
3.553210104966061e-14,
0.03308180007081358,
-8.30494429408067e-7,
-9.56113016385213e-7,
-7.33799298415016e-7,
-4.223575314110999e-7,
-1.944555860846072e-7,
-7.45888316548522e-8,
-2.45114561011037e-8,
-7.04123984403261e-9,
-1.794430921270175e-9,
-4.09952436336015e-10,
-8.44623867399356e-11,
-1.568915186980662e-11,
-2.596465154543394e-12,
-3.668429000240567e-13,
-3.65331710950481e-14,
-0.01049721069828186,
1.991837429218518e-7,
2.293139159586472e-7,
1.759975012549787e-7,
1.013037477578936e-7,
4.664421812777877e-8,
1.789433119793952e-8,
5.88219522722304e-9,
1.690741705691955e-9,
4.313925247471876e-10,
9.87925478457079e-11,
2.045415720038497e-11,
3.837958745774126e-12,
6.492880270227704e-13,
9.7493935950131e-14,
1.163005481413744e-14,
0.002894828379926559,
-4.39973472438162e-8,
-5.06530025298579e-8,
-3.887636448734468e-8,
-2.237759330339636e-8,
-1.03039353589802e-8,
-3.953262721641552e-9,
-1.299719047310769e-9,
-3.737035331985711e-10,
-9.54120440132417e-11,
-2.187861665217042e-11,
-4.541740630993457e-12,
-8.56791767826043e-13,
-1.466177631910947e-13,
-2.268353605608027e-14,
-2.916296272029196e-15,
-0.0007046564955127922,
8.91516795829095e-9,
1.026383333501837e-8,
7.87757891905966e-9,
4.534463750918905e-9,
2.087981109727989e-9,
8.01126109355081e-10,
2.634136366598468e-10,
7.57535865130017e-11,
1.93488016758922e-11,
4.440402875926801e-12,
9.2328410382746e-13,
1.747543500478479e-13,
3.011397805316997e-14,
4.741911926744832e-15,
6.350182916098514e-16,
0.0001533662256412499,
-1.660009187820501e-9,
-1.911135497340829e-9,
-1.466818915079589e-9,
-8.44332246144385e-10,
-3.88795663404192e-10,
-1.491799808706641e-10,
-4.905435357872624e-11,
-1.410918221629693e-11,
-3.604720846185434e-12,
-8.27711239282766e-13,
-1.722953935948612e-13,
-3.268427166433897e-14,
-5.658590042460466e-15,
-9.01419407726921e-16,
-1.238405422183238e-16,
-0.00003016605554490378,
2.85091215499007e-10,
3.282203405739336e-10,
2.519137378712153e-10,
1.450078126370345e-10,
6.67735996550006e-11,
2.56215045022652e-11,
8.42544901015536e-12,
2.423595893375469e-12,
6.19321116626269e-13,
1.422641698437595e-13,
2.963723240557146e-14,
5.631211715520424e-15,
9.78186636400871e-16,
1.571051021107293e-16,
2.196438992849013e-17,
5.410335853684108e-6,
-4.53543729816603e-11,
-5.22157269168621e-11,
-4.007639961865167e-11,
-2.30690796185582e-11,
-1.062301257273512e-11,
-4.076201232969586e-12,
-1.340479605705881e-12,
-3.856201540674491e-13,
-9.85553535912094e-14,
-2.264591840024779e-14,
-4.720562757105564e-15,
-8.98015329220182e-16,
-1.563831584057903e-16,
-2.526921561402457e-17,
-3.577923917906588e-18,
-8.91508531579644e-7,
6.71263960257901e-12,
7.72815610756426e-12,
5.93149330838173e-12,
3.414343343503703e-12,
1.572272335906067e-12,
6.03312054762957e-13,
1.984080188245719e-13,
5.708000393540873e-14,
1.458999288372396e-14,
3.353252692434465e-15,
6.99317134332178e-16,
1.331598856049348e-16,
2.323392993471206e-17,
3.771837981102363e-18,
5.392214635266499e-19,
1.358234477619485e-7,
-9.28018377556216e-13,
-1.068413699427863e-12,
-8.20027163359068e-13,
-4.720333127151633e-13,
-2.173680748943875e-13,
-8.34094093847578e-14,
-2.743104674163009e-14,
-7.89200585250231e-15,
-2.01743254121424e-15,
-4.637581124302616e-16,
-9.67526290325494e-17,
-1.84369609655791e-17,
-3.221890205761983e-18,
-5.249865984125104e-19,
-7.562124583437008e-20,
-1.924401369924566e-8,
1.203219031321075e-13,
1.385248928122319e-13,
1.063205295823613e-13,
6.12015719729283e-14,
2.81830349003566e-14,
1.081461811580375e-14,
3.556696523131385e-15,
1.023312815832558e-15,
2.616093367208577e-16,
6.014676845629143e-17,
1.255212740343412e-17,
2.393383628311111e-18,
4.187723239220278e-19,
6.843800071248385e-20,
9.92142764109727e-21,
2.585043085524568e-9,
-1.486662897747386e-14,
-1.7115746806138e-14,
-1.313667942361281e-14,
-7.56191738511338e-15,
-3.482241367339983e-15,
-1.336244166767072e-15,
-4.394692475389929e-16,
-1.264457364549825e-16,
-3.232788127872502e-17,
-7.43349298570413e-18,
-1.551712925535712e-18,
-2.960260101220666e-19,
-5.18528245465986e-20,
-8.498082087552124e-21,
-1.237036178061457e-21,
-3.205974202196006e-10,
1.710184140954668e-15,
1.9689124571561e-15,
1.511181118152512e-15,
8.69888463990444e-16,
4.00582494507678e-16,
1.537169735033779e-16,
5.055572079544404e-17,
1.45464704043872e-17,
3.719238292906207e-18,
8.55297772955748e-19,
1.78577164469584e-19,
3.40780687660855e-20,
5.977437835063155e-21,
9.85659734060814e-22,
1.420132266930667e-22,
// [{0,0.00001},{2.,0.0001}]: m=1
0.189454929363728,
-0.0000398645677889708,
-0.000045486301406576,
-0.0000344437475883378,
-0.00001942667754715882,
-8.67279548619167e-6,
-3.173368027234254e-6,
-9.69034630114512e-7,
-2.475380359914755e-7,
-5.175786032841529e-8,
-8.13078392756407e-9,
-5.98678152428832e-10,
1.704653743137019e-10,
9.53772882348186e-11,
2.95038147959984e-11,
6.455003903331618e-12,
-0.2005319550251848,
0.00001298843258319408,
0.00001495105579046468,
0.00001147164928224155,
6.59936912058124e-6,
3.035246314615147e-6,
1.161875257991267e-6,
3.802768496165607e-7,
1.083702901290354e-7,
2.718340274680904e-8,
6.01587121586344e-9,
1.160743449115468e-9,
1.866595814603478e-10,
2.091368067748457e-11,
-7.412649507708422e-13,
-1.214130901187757e-12,
0.1334624285733343,
-4.88360948652364e-6,
-5.62216812899929e-6,
-4.31472060631558e-6,
-2.483231503866811e-6,
-1.14309032551128e-6,
-4.383088174672335e-7,
-1.439354569326123e-7,
-4.128867203725741e-8,
-1.049222960223433e-8,
-2.383203142749208e-9,
-4.852058693793803e-10,
-8.79006758846484e-11,
-1.373605780638839e-11,
-1.614543139661903e-12,
-5.32981515744912e-14,
-0.0661636001416287,
1.660988858816142e-6,
1.912226032770435e-6,
1.467598596830038e-6,
8.44715062822204e-7,
3.889111721692161e-7,
1.491776633097051e-7,
4.902291220220763e-8,
1.408247968806529e-8,
3.588861842540365e-9,
8.19904872672034e-10,
1.689247734798719e-10,
3.137830373961339e-11,
5.192930309086817e-12,
7.33685800048119e-13,
7.30663421900949e-14,
0.02624302674570416,
-4.97959357304627e-7,
-5.73284789896615e-7,
-4.39993753137445e-7,
-2.532593693947328e-7,
-1.166105453194464e-7,
-4.473582799484859e-8,
-1.470548806805754e-8,
-4.226854264229869e-9,
-1.078481311867964e-9,
-2.469813696142685e-10,
-5.113539300096218e-11,
-9.59489686443526e-12,
-1.623220067556934e-12,
-2.437348398753317e-13,
-2.907513703532808e-14,
-0.00868448513970761,
1.319920417310902e-7,
1.519590075891612e-7,
1.166290934617173e-7,
6.71327799100068e-8,
3.091180607685664e-8,
1.185978816489244e-8,
3.899157141921713e-9,
1.121110599592665e-9,
2.862361320389457e-10,
6.5635849956332e-11,
1.362522189294295e-11,
2.570375303471015e-12,
4.39853289571983e-13,
6.805060816799827e-14,
8.74888881610175e-15,
0.002466297734308051,
-3.12030878540802e-8,
-3.59234166726355e-8,
-2.757152621676344e-8,
-1.587062312824762e-8,
-7.30793388406245e-9,
-2.803941382748341e-9,
-9.21947728311292e-10,
-2.65137552796032e-10,
-6.77208058657572e-11,
-1.554141006577468e-11,
-3.231494363402694e-12,
-6.116402251688544e-13,
-1.053989231860168e-13,
-1.659669174349266e-14,
-2.222564020920557e-15,
-0.0006134649040753415,
6.64003675879293e-9,
7.64454199801055e-9,
5.86727566695529e-9,
3.377328988397998e-9,
1.555182655376089e-9,
5.96719924157771e-10,
1.962174145369448e-10,
5.643672892907698e-11,
1.441888340107773e-11,
3.310844960888294e-12,
6.89181575163872e-13,
1.307370868066769e-13,
2.263436019644999e-14,
3.605677635740292e-15,
4.953621692235039e-16,
0.0001357472497851238,
-1.282910468968048e-9,
-1.476991531687594e-9,
-1.133611819733454e-9,
-6.52535156471185e-10,
-3.004811982653882e-10,
-1.152967701903092e-10,
-3.79145205227145e-11,
-1.090618151357578e-11,
-2.786945023127287e-12,
-6.40188763908699e-13,
-1.33367545742829e-13,
-2.5340452702472e-14,
-4.401839863448861e-15,
-7.069729608660283e-16,
-9.88397524486796e-17,
-0.00002705166315546007,
2.267717847801305e-10,
2.610785423337701e-10,
2.003819272890058e-10,
1.153453573353396e-10,
5.31150440948689e-11,
2.038099896258423e-11,
6.70239565976162e-12,
1.928100088752811e-12,
4.927765936805435e-13,
1.132295519189902e-13,
2.36028054155098e-14,
4.490075051324964e-15,
7.8191551195463e-16,
1.263460284560753e-16,
1.788961213740683e-17,
4.903297992198168e-6,
-3.69195227903846e-11,
-4.25048643206408e-11,
-3.262321759326035e-11,
-1.877889092043602e-11,
-8.64749901308807e-12,
-3.318216748482682e-12,
-1.091244250645699e-12,
-3.139400639758095e-13,
-8.02449716835765e-14,
-1.844289229336789e-14,
-3.846244762659701e-15,
-7.32379481347218e-16,
-1.277866233830846e-16,
-2.074510088011013e-17,
-2.965725743663194e-18,
-8.15032103718489e-7,
5.56856486628546e-12,
6.41100557283407e-12,
4.92056468257525e-12,
2.832431110522119e-12,
1.304314932731926e-12,
5.004973177915997e-13,
1.645997194698034e-13,
4.735590203187496e-14,
1.210558398484311e-14,
2.782776075241857e-15,
5.805632651411674e-16,
1.106308213491395e-16,
1.933292025533329e-17,
3.150192810191998e-18,
4.537793208195355e-19,
1.250827214223034e-7,
-7.82076686974996e-13,
-9.00393747194493e-13,
-6.91069583847294e-13,
-3.978022404031987e-13,
-1.831860532408161e-13,
-7.02936080496394e-14,
-2.311806375528486e-14,
-6.65139988913764e-15,
-1.700426576591836e-15,
-3.909461623184216e-16,
-8.15871829602362e-17,
-1.555664762277617e-17,
-2.721978055840781e-18,
-4.448695346713452e-19,
-6.447960053151067e-20,
-1.783273899973377e-8,
1.027607450840572e-13,
1.183070405374982e-13,
9.08030278780358e-14,
5.22692946867844e-14,
2.406985907738698e-14,
9.23635104785106e-15,
3.037686571108934e-15,
8.74013995774579e-16,
2.234554203372257e-16,
5.138134073915263e-17,
1.072558788552985e-17,
2.046156416348728e-18,
3.584428706219315e-19,
5.872006580551296e-20,
8.50323538517511e-21,
2.408625625949221e-9,
-1.284568454183259e-14,
-1.478906729100443e-14,
-1.135091568395958e-14,
-6.53398228075319e-15,
-3.008890277926967e-15,
-1.154612397644822e-15,
-3.797385713216477e-16,
-1.092627367402732e-16,
-2.793627419852715e-17,
-6.424374924144994e-18,
-1.341348729598746e-18,
-2.560082687486974e-19,
-4.489458468754006e-20,
-7.368303899096023e-21,
-1.065134998011212e-21,
-3.001025519117536e-10,
1.492316087323331e-15,
1.718084456416148e-15,
1.318666376688636e-15,
7.59071367420988e-16,
3.495523720916815e-16,
1.341357708523531e-16,
4.411619924527398e-17,
1.269390990515206e-17,
3.245722435466975e-18,
7.46473651758853e-19,
1.559016316247649e-19,
2.9761802598329e-20,
5.178897025040243e-21,
8.599306610751428e-22,
1.723150511792424e-22,
// [{0,0.00001},{2.,0.0001}]: m=2
0.1002659775125924,
-6.49421629159704e-6,
-7.47552789523234e-6,
-5.73582464112077e-6,
-3.299684560290618e-6,
-1.517623157307573e-6,
-5.80937628995634e-7,
-1.901384248082804e-7,
-5.41851450645177e-8,
-1.359170137340452e-8,
-3.00793560793172e-9,
-5.80371724557734e-10,
-9.33297907301739e-11,
-1.045684033874228e-11,
3.70632475385421e-13,
6.070654505938784e-13,
-0.1334624285733343,
4.88360948652364e-6,
5.62216812899929e-6,
4.31472060631558e-6,
2.483231503866811e-6,
1.14309032551128e-6,
4.383088174672334e-7,
1.439354569326123e-7,
4.12886720372574e-8,
1.049222960223433e-8,
2.383203142749208e-9,
4.852058693793803e-10,
8.79006758846484e-11,
1.373605780638839e-11,
1.614543139661903e-12,
5.32981515744912e-14,
0.099245400212443,
-2.49148328822421e-6,
-2.868339049155653e-6,
-2.201397895245058e-6,
-1.267072594233305e-6,
-5.83366758253824e-7,
-2.237664949645577e-7,
-7.35343683033114e-8,
-2.112371953209794e-8,
-5.383292763810548e-9,
-1.22985730900805e-9,
-2.533871602198079e-10,
-4.706745560942009e-11,
-7.78939546363023e-12,
-1.100528700072178e-12,
-1.095995132851407e-13,
-0.05248605349140973,
9.95918714609261e-7,
1.146569579793238e-6,
8.79987506274895e-7,
5.06518738789469e-7,
2.332210906388943e-7,
8.94716559896978e-8,
2.941097613611527e-8,
8.45370852845979e-9,
2.156962623735942e-9,
4.939627392285402e-10,
1.02270786001925e-10,
1.918979372887066e-11,
3.246440135113895e-12,
4.874696797506673e-13,
5.81502740706522e-14,
0.02171121284926855,
-3.29980104327723e-7,
-3.79897518972901e-7,
-2.915727336542915e-7,
-1.678319497750159e-7,
-7.72795151921411e-8,
-2.964947041223092e-8,
-9.74789285480422e-9,
-2.802776498981644e-9,
-7.1559033009736e-10,
-1.640896248908289e-10,
-3.406305473235719e-11,
-6.4259382586775e-12,
-1.099633223929867e-12,
-1.701265204199945e-13,
-2.187222204034366e-14,
-0.00739889320285642,
9.3609263561925e-8,
1.077702500175433e-7,
8.27145786500116e-8,
4.76118693845824e-8,
2.192380165211345e-8,
8.41182414821667e-9,
2.76584318492455e-9,
7.95412658385413e-10,
2.031624175965854e-10,
4.662423019716622e-11,
9.69448309017518e-12,
1.834920675500264e-12,
3.16196769556783e-13,
4.979007523029719e-14,
6.667692062897249e-15,
0.00214712716427622,
-2.324012865583011e-8,
-2.675589699310007e-8,
-2.053546483439199e-8,
-1.182065145942089e-8,
-5.44313929382916e-9,
-2.088519734557128e-9,
-6.86760950880928e-10,
-1.97528551252236e-10,
-5.046609190389149e-11,
-1.158795736313647e-11,
-2.412135513078611e-12,
-4.575798038244675e-13,
-7.92202606895948e-14,
-1.261987172512074e-14,
-1.73376759032416e-15,
-0.0005429890005600467,
5.13164188248301e-9,
5.90796613436133e-9,
4.53444728477539e-9,
2.610140629247361e-9,
1.201924794610044e-9,
4.611870813554512e-10,
1.516580822862924e-10,
4.362472611053818e-11,
1.114778010688876e-11,
2.560755058942065e-12,
5.334701836610884e-13,
1.013618109419531e-13,
1.760735947943902e-14,
2.827891847164611e-15,
3.953590078787925e-16,
0.0001217324840420969,
-1.020473030821055e-9,
-1.174853439708116e-9,
-9.01718672191229e-10,
-5.19054107658294e-10,
-2.390176982653961e-10,
-9.17144952696498e-11,
-3.016078044854255e-11,
-8.67645039352192e-12,
-2.217494670061195e-12,
-5.095329832904965e-13,
-1.062126243049205e-13,
-2.020533771708925e-14,
-3.51861978183282e-15,
-5.685571277376785e-16,
-8.05032755450409e-17,
-0.00002451647481660272,
1.845975434261662e-10,
2.125242404077754e-10,
1.63116025647044e-10,
9.38944187289494e-11,
4.323747854577615e-11,
1.659107740319476e-11,
5.456219168288798e-12,
1.569699719950386e-12,
4.012247050135418e-13,
9.2214426184043e-14,
1.923121645140427e-14,
3.661895997842645e-15,
6.389328513185139e-16,
1.037254650801854e-16,
1.482864119891097e-17,
4.482677578351634e-6,
-3.06271111778479e-11,
-3.52605357315408e-11,
-2.706310965390827e-11,
-1.557837335270876e-11,
-7.17373316377795e-12,
-2.752735644545293e-12,
-9.05298587554376e-13,
-2.604574987183728e-13,
-6.65807215240837e-14,
-1.530527062149855e-14,
-3.193098379657364e-15,
-6.084696067127089e-16,
-1.063311854062762e-16,
-1.732606201423462e-17,
-2.49566999692996e-18,
-7.505822505509945e-7,
4.69286024495479e-12,
5.40282313993184e-12,
4.146771067172445e-12,
2.387016966764005e-12,
1.099210042641041e-12,
4.217976134256437e-13,
1.387202112962952e-13,
3.991180298926841e-14,
1.020342978540776e-14,
2.345877149331688e-15,
4.895648806202358e-16,
9.33478773327618e-17,
1.633333679405426e-17,
2.669441536799405e-18,
3.86844991446675e-19,
1.159096268994195e-7,
-6.67930933803367e-13,
-7.68979749950531e-13,
-5.9020739045776e-13,
-3.397433404541148e-13,
-1.564508259455655e-13,
-6.00350315660801e-14,
-1.974455151067981e-14,
-5.680972648653729e-15,
-1.452429955527492e-15,
-3.339717576075009e-16,
-6.97149776429625e-17,
-1.329973371298844e-17,
-2.329529309195697e-18,
-3.816769343178398e-19,
-5.559353989638694e-20,
-1.66135993488051e-8,
8.87705979100156e-14,
1.022004183816599e-13,
7.84409380914699e-14,
4.515333353487398e-14,
2.07930494802547e-14,
7.97899131151139e-15,
2.624196594153006e-15,
7.55063519165096e-16,
1.930542640936029e-16,
4.439569757382711e-17,
9.26939693624207e-18,
1.769111936263638e-18,
3.101418952266909e-19,
5.092744380892347e-20,
7.452499875092077e-21,
2.254678996656599e-9,
-1.120949049448733e-14,
-1.290534328730621e-14,
-9.90512558294599e-15,
-5.7017433525547e-15,
-2.625652888189691e-15,
-1.007557113718797e-15,
-3.313776116342085e-16,
-9.53499604032161e-17,
-2.438018050953951e-17,
-5.607114708777778e-18,
-1.170931833382154e-18,
-2.235636116467669e-19,
-3.922976290540955e-20,
-6.452208912905768e-21,
-9.39622766937201e-22,
-2.820636683608053e-10,
1.313485684127351e-15,
1.512199767375867e-15,
1.160646219751527e-15,
6.68110164720779e-16,
3.076655035989778e-16,
1.180628665259392e-16,
3.883033415958412e-17,
1.117318849024625e-17,
2.857004126114461e-18,
6.571233402511167e-19,
1.372469327420008e-19,
2.621797221953171e-20,
4.608042790526688e-21,
7.522840708114618e-22,
1.053348142480165e-22,
// [{0,0.00001},{2.,0.0001}]: m=3
0.0667312142866671,
-2.44180474326182e-6,
-2.81108406449965e-6,
-2.157360303157789e-6,
-1.241615751933406e-6,
-5.7154516275564e-7,
-2.191544087336167e-7,
-7.19677284663062e-8,
-2.06443360186287e-8,
-5.24611480111717e-9,
-1.191601571374604e-9,
-2.426029346896902e-10,
-4.395033794232421e-11,
-6.8680289031942e-12,
-8.07271569830951e-13,
-2.66490757872456e-14,
-0.099245400212443,
2.49148328822421e-6,
2.868339049155653e-6,
2.201397895245058e-6,
1.267072594233305e-6,
5.83366758253824e-7,
2.237664949645577e-7,
7.35343683033114e-8,
2.112371953209794e-8,
5.38329276381055e-9,
1.22985730900805e-9,
2.533871602198079e-10,
4.706745560942009e-11,
7.78939546363023e-12,
1.100528700072178e-12,
1.095995132851407e-13,
0.0787290802371146,
-1.493878071913892e-6,
-1.719854369689857e-6,
-1.319981259412343e-6,
-7.59778108184203e-7,
-3.498316359583414e-7,
-1.342074839845467e-7,
-4.411646420417291e-8,
-1.268056279268969e-8,
-3.235443935603913e-9,
-7.4094410884281e-10,
-1.534061790028876e-10,
-2.878469059330599e-11,
-4.869660202670843e-12,
-7.31204519626001e-13,
-8.72254111059781e-14,
-0.04342242569853842,
6.59960208655453e-7,
7.59795037945808e-7,
5.83145467308588e-7,
3.356638995500348e-7,
1.545590303842836e-7,
5.92989408244624e-8,
1.949578570960861e-8,
5.60555299796334e-9,
1.431180660194732e-9,
3.281792497816607e-10,
6.8126109464715e-11,
1.285187651735511e-11,
2.199266447859757e-12,
3.402530408399925e-13,
4.37444440806848e-14,
0.01849723300714059,
-2.340231589048107e-7,
-2.694256250438561e-7,
-2.067864466250273e-7,
-1.190296734614551e-7,
-5.48095041302832e-8,
-2.10295603705415e-8,
-6.91460796231132e-9,
-1.988531645963516e-9,
-5.079060439914596e-10,
-1.165605754929146e-10,
-2.423620772543777e-11,
-4.587301688750629e-12,
-7.90491923891946e-13,
-1.244751880757351e-13,
-1.666923015724752e-14,
-0.006441381492764766,
6.97203859672106e-8,
8.02676909789781e-8,
6.16063945029288e-8,
3.546195437812037e-8,
1.632941788142194e-8,
6.26555920364624e-9,
2.060282852634513e-9,
5.92585653754328e-10,
1.513982757110659e-10,
3.476387208926942e-11,
7.23640653920662e-12,
1.372739411467821e-12,
2.37660782067715e-13,
3.785961517519295e-14,
5.201302771052039e-15,
0.001900461501972016,
-1.796074658873951e-8,
-2.067788147032103e-8,
-1.587056549675714e-8,
-9.13549220239067e-9,
-4.206736781146624e-9,
-1.614154784748481e-9,
-5.30803288003471e-10,
-1.526865413873002e-10,
-3.901723037421719e-11,
-8.96264270632178e-12,
-1.867145642818921e-12,
-3.547663382976773e-13,
-6.162575817820889e-14,
-9.89762146526255e-15,
-1.383756527598324e-15,
-0.0004869299375074189,
4.08189212914723e-9,
4.69941376558247e-9,
3.606874693945695e-9,
2.076216433615425e-9,
9.56070794434916e-10,
3.668579816056009e-10,
1.206431219675001e-10,
3.470580162396313e-11,
8.86997869299853e-12,
2.038131936095628e-12,
4.24850497832093e-13,
8.08213509853389e-14,
1.40744791491589e-14,
2.274228514457997e-15,
3.22013101172947e-16,
0.0001103241365256943,
-8.30688944802073e-10,
-9.5635908112617e-10,
-7.34022114867663e-10,
-4.225248839671057e-10,
-1.945686533117784e-10,
-7.46598482590355e-11,
-2.455298623909792e-11,
-7.06364873453924e-12,
-1.805511171221627e-12,
-4.149649175195659e-13,
-8.65404739666825e-14,
-1.647853197957247e-14,
-2.875197829647664e-15,
-4.667645906550448e-16,
-6.672888424019577e-17,
-0.00002241337360637932,
1.531354933412235e-10,
1.763026066469301e-10,
1.353154929996757e-10,
7.78918349481649e-11,
3.58686511678391e-11,
1.376367260054084e-11,
4.526491088644783e-12,
1.302286961507739e-12,
3.329034715604733e-13,
7.6526321810754e-14,
1.596548536330669e-14,
3.042346785184446e-15,
5.316556989967258e-16,
8.66302731668587e-17,
1.247835519552249e-17,
4.12820333181226e-6,
-2.581073528781781e-11,
-2.971553180635267e-11,
-2.280724435148912e-11,
-1.312859532159534e-11,
-6.04565615755495e-12,
-2.319887228045141e-12,
-7.62961278627668e-13,
-2.195149499631295e-13,
-5.611887239154251e-14,
-1.290232629644404e-14,
-2.692607258513142e-15,
-5.13413394458709e-16,
-8.98333574581993e-17,
-1.468194208581559e-17,
-2.127657751793028e-18,
-6.955388098750048e-7,
4.00794046531915e-12,
4.61428704860545e-12,
3.541557913087792e-12,
2.038640545410878e-12,
9.3878807755012e-13,
3.602420865369153e-13,
1.184777999783321e-13,
3.408885464009729e-14,
8.71535166018302e-15,
2.004008105289263e-15,
4.183269488510265e-16,
7.98054868161499e-17,
1.397844773464852e-17,
2.290268556045601e-18,
3.335572317704815e-19,
1.079853897316299e-7,
-5.76996466999997e-13,
-6.64288421154988e-13,
-5.09855123307201e-13,
-2.934903507649288e-13,
-1.351519125264294e-13,
-5.186232718589895e-14,
-1.7056910697015e-14,
-4.907807223288131e-15,
-1.254825701782562e-15,
-2.885658097056259e-16,
-6.024976878319551e-17,
-1.149900875711175e-17,
-2.015912521680194e-18,
-3.30986253321629e-19,
-4.840353594696109e-20,
-1.554997025721341e-8,
7.74472312037082e-14,
8.91640077810908e-14,
6.84352722237922e-14,
3.939378085096509e-14,
1.814083548278338e-14,
6.96128786834851e-15,
2.289512276848532e-15,
6.58779561716447e-16,
1.684442107717881e-16,
3.873983429626561e-17,
8.09000013479482e-18,
1.544593736328593e-18,
2.710068346840129e-19,
4.457593679233541e-20,
6.527551808605074e-21,
2.119177436461979e-9,
-9.86642876150714e-15,
-1.135909699672855e-14,
-8.71835407886476e-15,
-5.018601619574392e-15,
-2.311071865043249e-15,
-8.86845517149761e-16,
-2.916794222620125e-16,
-8.39289520261591e-17,
-2.146078070312201e-17,
-4.936086045417996e-18,
-1.030968894331489e-18,
-1.969047666382934e-19,
-3.456678597905933e-20,
-5.693497744978517e-21,
-8.40680266496296e-22,
-2.660652429013055e-10,
1.164911495230911e-15,
1.341148512637594e-15,
1.029361220904577e-15,
5.92538391128976e-16,
2.728652087000155e-16,
1.047091359771849e-16,
3.443865393975857e-17,
9.90968225156778e-18,
2.534009361478124e-18,
5.828749594026236e-19,
1.21766927413289e-19,
2.326381456013543e-20,
4.067317039632711e-21,
6.706461240708435e-22,
1.164712208631568e-22,
// [{0,0.00001},{2.,0.0001}]: m=4
0.0496227001062215,
-1.245741644112106e-6,
-1.434169524577826e-6,
-1.100698947622529e-6,
-6.33536297116653e-7,
-2.91683379126912e-7,
-1.118832474822788e-7,
-3.67671841516557e-8,
-1.056185976604897e-8,
-2.691646381905274e-9,
-6.14928654504025e-10,
-1.26693580109904e-10,
-2.353372780471005e-11,
-3.894697731815113e-12,
-5.50264350036089e-13,
-5.47997566425704e-14,
-0.0787290802371146,
1.493878071913892e-6,
1.719854369689857e-6,
1.319981259412343e-6,
7.59778108184203e-7,
3.498316359583414e-7,
1.342074839845467e-7,
4.41164642041729e-8,
1.268056279268969e-8,
3.235443935603913e-9,
7.4094410884281e-10,
1.534061790028876e-10,
2.878469059330599e-11,
4.869660202670842e-12,
7.31204519626001e-13,
8.72254111059781e-14,
0.0651336385478076,
-9.89940312983179e-7,
-1.139692556918712e-6,
-8.74718200962882e-7,
-5.03495849325052e-7,
-2.318385455764254e-7,
-8.89484112366935e-8,
-2.924367856441292e-8,
-8.40832949694501e-9,
-2.146770990292098e-9,
-4.92268874672491e-10,
-1.021891641970725e-10,
-1.927781477603266e-11,
-3.298899671789636e-12,
-5.103795612599888e-13,
-6.56166661210273e-14,
-0.03699446601428245,
4.68046317809627e-7,
5.38851250087718e-7,
4.13572893250059e-7,
2.380593469229128e-7,
1.096190082605676e-7,
4.205912074108347e-8,
1.38292159246228e-8,
3.977063291927076e-9,
1.01581208798293e-9,
2.331211509858319e-10,
4.847241545087608e-11,
9.17460337750136e-12,
1.580983847783911e-12,
2.489503761514733e-13,
3.333846031449425e-14,
0.01610345373191149,
-1.743009649180247e-7,
-2.006692274474434e-7,
-1.540159862573204e-7,
-8.86548859453001e-8,
-4.082354470355447e-8,
-1.566389800911544e-8,
-5.15070713158623e-9,
-1.481464134385806e-9,
-3.784956892776611e-10,
-8.69096802231727e-11,
-1.809101634801638e-11,
-3.431848528669523e-12,
-5.941519551692809e-13,
-9.46490379379786e-14,
-1.300325692762754e-14,
-0.005701384505855584,
5.38822397659687e-8,
6.20336444106755e-8,
4.76116964900507e-8,
2.740647660704496e-8,
1.262021034338136e-8,
4.842464354222988e-9,
1.592409864003028e-9,
4.580596241597755e-10,
1.170516911221081e-10,
2.688792811884033e-11,
5.601436928430657e-12,
1.064299014888035e-12,
1.848772745337259e-13,
2.969286439565057e-14,
4.151269582796967e-15,
0.001704254781287215,
-1.428662245205928e-8,
-1.644794817958929e-8,
-1.26240614288488e-8,
-7.26675751767636e-9,
-3.34624778053251e-9,
-1.284002935623557e-9,
-4.222509268875508e-10,
-1.214703056842452e-10,
-3.104492542559058e-11,
-7.13346177635674e-12,
-1.48697674241683e-12,
-2.828747284494922e-13,
-4.926067702237234e-14,
-7.9597998007144e-15,
-1.127045854015503e-15,
-0.0004412965473699125,
3.32275578444332e-9,
3.82543633053171e-9,
2.936088464096531e-9,
1.690099538531252e-9,
7.78274614473354e-10,
2.986393935067008e-10,
9.82119451111588e-11,
2.825459498269171e-11,
7.22204469627488e-12,
1.659859672697936e-12,
3.461618964139855e-13,
6.59141280230328e-14,
1.150079133708983e-14,
1.867058365460472e-15,
2.669155373042351e-16,
0.0001008601810872844,
-6.89109719482447e-10,
-7.93361729274455e-10,
-6.08919718009835e-10,
-3.505132569854248e-10,
-1.614089301257283e-10,
-6.19365266527209e-11,
-2.036920988255086e-11,
-5.86029132207984e-12,
-1.498065620818502e-12,
-3.443684478713012e-13,
-7.18446840787422e-14,
-1.369056052318402e-14,
-2.392450640150571e-15,
-3.898362278516262e-16,
-5.615260100704947e-17,
-0.00002064100314068597,
1.290536205903914e-10,
1.485775947338179e-10,
1.140361724073231e-10,
6.56429482001937e-11,
3.022826770590417e-11,
1.159943112017706e-11,
3.814804742040348e-12,
1.097574274706759e-12,
2.805942404635888e-13,
6.45116035347866e-14,
1.346303045366496e-14,
2.567065855063923e-15,
4.49166591526978e-16,
7.340967985331921e-17,
1.063828347672058e-17,
3.825464359480108e-6,
-2.20436760990568e-11,
-2.537858284266244e-11,
-1.947857164989373e-11,
-1.121252480030428e-11,
-5.163335255683301e-12,
-1.981331794135822e-12,
-6.51628004531686e-13,
-1.874887306344078e-13,
-4.793444183516381e-14,
-1.102204635246246e-14,
-2.300798575598205e-15,
-4.389302427267171e-16,
-7.68815031945993e-17,
-1.259648573912417e-17,
-1.834540830493704e-18,
-6.479890353124228e-7,
3.46229565677034e-12,
3.98609531808162e-12,
3.059410725275057e-12,
1.7611032747145e-12,
8.10985694491638e-13,
3.112024441082874e-13,
1.023508316033489e-13,
2.944953884594464e-14,
7.52964350132523e-15,
1.731553417334081e-15,
3.615317400983791e-16,
6.9000388783289e-17,
1.209658429529557e-17,
1.986093865399926e-18,
2.904524617260767e-19,
1.010719538529282e-7,
-5.03395846486838e-13,
-5.79553206415135e-13,
-4.44819411266625e-13,
-2.560539007833456e-13,
-1.179128173948491e-13,
-4.524736833253102e-14,
-1.488149997314094e-14,
-4.281972241642746e-15,
-1.094863087865468e-15,
-2.518033342712184e-16,
-5.258388167690405e-17,
-1.003965254892361e-17,
-1.76140088010017e-18,
-2.897173288117767e-19,
-4.25213492237919e-20,
-1.461395747546334e-8,
6.81549601180452e-14,
7.84659592863715e-14,
6.02243300722063e-14,
3.466731328506337e-14,
1.596433709343739e-14,
6.12611812411606e-15,
2.014851707534039e-15,
5.797608788138512e-16,
1.482457472239786e-16,
3.409720087844421e-17,
7.12163904699506e-18,
1.360142769627861e-18,
2.387747901490626e-19,
3.933847961373905e-20,
5.803512153622177e-21,
1.999000662501528e-9,
-8.75056772309857e-15,
-1.007442277199323e-14,
-7.73234286994228e-15,
-4.451022560199272e-15,
-2.049705512725154e-15,
-7.86552806475871e-16,
-2.586958632896904e-16,
-7.44394340776206e-17,
-1.903495832339634e-17,
-4.378440329299179e-18,
-9.14624182252063e-19,
-1.747344010968614e-19,
-3.069587012671286e-20,
-5.060848506522572e-21,
-7.444477171711922e-22,
-2.517803037933736e-10,
1.040145470417048e-15,
1.197507184998744e-15,
9.19113758210025e-16,
5.290763819473768e-16,
2.436412843333928e-16,
9.34951234004928e-17,
3.075062054432752e-17,
8.84859110657803e-18,
2.262749368108308e-18,
5.205109731609964e-19,
1.087404390769433e-19,
2.078213517487286e-20,
3.663670423787433e-21,
6.0085970814543e-22,
7.613399507433994e-23,
// [{0,0.00001},{2.,0.0001}]: m=5
0.0393645401185573,
-7.46939035956946e-7,
-8.59927184844929e-7,
-6.59990629706171e-7,
-3.79889054092102e-7,
-1.749158179791707e-7,
-6.71037419922733e-8,
-2.205823210208645e-8,
-6.34028139634484e-9,
-1.617721967801957e-9,
-3.70472054421405e-10,
-7.67030895014438e-11,
-1.439234529665299e-11,
-2.434830101335421e-12,
-3.656022598130006e-13,
-4.36127055529891e-14,
-0.0651336385478076,
9.89940312983179e-7,
1.139692556918712e-6,
8.74718200962882e-7,
5.03495849325052e-7,
2.318385455764254e-7,
8.89484112366935e-8,
2.924367856441292e-8,
8.40832949694501e-9,
2.146770990292098e-9,
4.92268874672491e-10,
1.021891641970725e-10,
1.927781477603266e-11,
3.298899671789636e-12,
5.103795612599888e-13,
6.56166661210273e-14,
0.05549169902142368,
-7.0206947671444e-7,
-8.08276875131577e-7,
-6.20359339875089e-7,
-3.570890203843693e-7,
-1.644285123908514e-7,
-6.30886811116252e-8,
-2.07438238869342e-8,
-5.96559493789061e-9,
-1.523718131974396e-9,
-3.496817264787478e-10,
-7.27086231763141e-11,
-1.376190506625204e-11,
-2.371475771675867e-12,
-3.734255642272101e-13,
-5.000769047174151e-14,
-0.03220690746382418,
3.48601929836054e-7,
4.01338454894892e-7,
3.08031972514645e-7,
1.773097718906025e-7,
8.164708940711e-8,
3.132779601823131e-8,
1.030141426317261e-8,
2.962928268771652e-9,
7.56991378555332e-10,
1.738193604463478e-10,
3.618203269603325e-11,
6.86369705733914e-12,
1.188303910338578e-12,
1.892980758759592e-13,
2.600651385525549e-14,
0.01425346126463856,
-1.347055994149203e-7,
-1.55084111026687e-7,
-1.190292412251254e-7,
-6.85161915176116e-8,
-3.155052585845305e-8,
-1.210616088555734e-8,
-3.981024660007526e-9,
-1.145149060399426e-9,
-2.926292278052671e-10,
-6.72198202971001e-11,
-1.400359232107648e-11,
-2.660747537220063e-12,
-4.6219318633432e-13,
-7.42321609891206e-14,
-1.037817395697994e-14,
-0.005112764343804261,
4.28598673559534e-8,
4.93438445385095e-8,
3.787218428634812e-8,
2.180027255291495e-8,
1.003874334154497e-8,
3.8520088068505e-9,
1.266752780656018e-9,
3.644109170508264e-10,
9.31347762762835e-11,
2.140038532895792e-11,
4.460930227227025e-12,
8.48624185343964e-13,
1.477820310663178e-13,
2.387939940204261e-14,
3.381137562043761e-15,
0.001544537915805397,
-1.162964524559135e-8,
-1.338902715690672e-8,
-1.027630962437297e-8,
-5.91534838487959e-9,
-2.723961150666047e-9,
-1.045237877277024e-9,
-3.437418078902306e-10,
-9.8891082439759e-11,
-2.52771564370485e-11,
-5.809508854462699e-12,
-1.211566637453213e-12,
-2.306994480813154e-13,
-4.025276967964371e-14,
-6.534704279230921e-15,
-9.34204380924222e-16,
-0.0004034407255516892,
2.75643888263241e-9,
3.1734469225119e-9,
2.435678876194772e-9,
1.402053030333723e-9,
6.45635721604449e-10,
2.477461070335894e-10,
8.14768396692327e-11,
2.344116532832603e-11,
5.99226249350474e-12,
1.377473793838585e-12,
2.873787368066443e-13,
5.476224218720932e-14,
9.56980257744793e-15,
1.55934491361432e-15,
2.246104039952238e-16,
0.0000928845139985245,
-5.80741292157245e-10,
-6.68599175727093e-10,
-5.13162775391561e-10,
-2.953932666467885e-10,
-1.360272045595624e-10,
-5.219743999589637e-11,
-1.716662132441357e-11,
-4.939084231930846e-12,
-1.262674080999637e-12,
-2.903022156561577e-13,
-6.058363698783771e-14,
-1.155179633873295e-14,
-2.021249664114978e-15,
-3.303435580941793e-16,
-4.787227106529098e-17,
-0.00001912730896802574,
1.102183303263074e-10,
1.268928564543501e-10,
9.73928139181444e-11,
5.60625984827252e-11,
2.581666452691317e-11,
9.9066544611314e-12,
3.258138539454469e-12,
9.37443226369199e-13,
2.396721000314141e-13,
5.511020665536111e-14,
1.150398763271633e-14,
2.194650206882762e-15,
3.844073363617421e-16,
6.298240396319154e-17,
9.17270413919534e-18,
3.563940555478069e-6,
-1.90426293093481e-11,
-2.192352793024672e-11,
-1.68267618141104e-11,
-9.6860696371646e-12,
-4.460422068592515e-12,
-1.711613729976621e-12,
-5.629296683396467e-13,
-1.619724908517666e-13,
-4.141304621140989e-14,
-9.52354539749808e-15,
-1.988424913911961e-15,
-3.795021972398252e-16,
-6.65311995483368e-17,
-1.092352324398022e-17,
-1.597517360468124e-18,
-6.065045110253032e-7,
3.02065971045644e-12,
3.477646931482878e-12,
2.669167979465104e-12,
1.536468184494748e-12,
7.07543576018922e-13,
2.715097947206304e-13,
8.92974147328563e-14,
2.569425489704577e-14,
6.56979775332021e-15,
1.510962451132461e-15,
3.155330495707883e-16,
6.024362081613797e-17,
1.056942070681568e-17,
1.738450961046147e-18,
2.551336627337491e-19,
9.49880091552728e-8,
-4.42997164476555e-13,
-5.10017134642312e-13,
-3.914492416487432e-13,
-2.25332410971265e-13,
-1.037658308458994e-13,
-3.981886207196201e-14,
-1.309623819774512e-14,
-3.768359989181798e-15,
-9.63575439627573e-16,
-2.216267570529354e-16,
-4.628957241861899e-17,
-8.84074017227247e-18,
-1.552077909038744e-18,
-2.556801695934568e-19,
-3.763520030926459e-20,
-1.378394718458547e-8,
6.0436480543118e-14,
6.95797885786013e-14,
5.34040299576478e-14,
3.074133420170459e-14,
1.41564501738494e-14,
5.432387459844929e-15,
1.786702528778249e-15,
5.141213732070334e-16,
1.314662218929665e-16,
3.023995668491921e-17,
6.316893465916403e-18,
1.206771048699139e-18,
2.11968465767491e-19,
3.498524987884409e-20,
5.175630160295978e-21,
1.891693292851328e-9,
-7.81349319312446e-15,
-8.99558235921423e-15,
-6.90431224433074e-15,
-3.974381319822e-15,
-1.830214704677621e-15,
-7.02328227810591e-16,
-2.309963187651701e-16,
-6.646994372921257e-17,
-1.699759694481763e-17,
-3.91004555232016e-18,
-8.16882764589036e-19,
-1.560990420299531e-19,
-2.743061536749483e-20,
-4.529237528341765e-21,
-6.73628186411664e-22,
-2.38948075493952e-10,
9.34367590939857e-16,
1.07572659207505e-15,
8.25644760100583e-16,
4.752725232505056e-16,
2.188648169810847e-16,
8.39876662428974e-17,
2.762379877706944e-17,
7.94894735687802e-18,
2.032749832460508e-18,
4.676235427033569e-19,
9.77000529244895e-20,
1.869147156911137e-20,
3.300905655001099e-21,
5.239695675118818e-22,
6.359593919648229e-23,
// [{0,0.00001},{2.,0.0001}]: m=6
0.0325668192739038,
-4.9497015649159e-7,
-5.69846278459356e-7,
-4.37359100481441e-7,
-2.51747924662526e-7,
-1.159192727882127e-7,
-4.44742056183468e-8,
-1.462183928220646e-8,
-4.2041647484725e-9,
-1.073385495146049e-9,
-2.461344373362455e-10,
-5.10945820985362e-11,
-9.63890738801633e-12,
-1.649449835894818e-12,
-2.551897806299944e-13,
-3.280833306051366e-14,
-0.0554916990214237,
7.0206947671444e-7,
8.08276875131577e-7,
6.20359339875089e-7,
3.57089020384369e-7,
1.644285123908514e-7,
6.30886811116252e-8,
2.07438238869342e-8,
5.96559493789061e-9,
1.523718131974396e-9,
3.496817264787478e-10,
7.27086231763141e-11,
1.376190506625204e-11,
2.371475771675867e-12,
3.734255642272101e-13,
5.000769047174151e-14,
0.04831036119573628,
-5.22902894754081e-7,
-6.02007682342338e-7,
-4.62047958771967e-7,
-2.659646578359038e-7,
-1.224706341106651e-7,
-4.6991694027347e-8,
-1.545212139475891e-8,
-4.444392403157478e-9,
-1.135487067832999e-9,
-2.607290406695217e-10,
-5.42730490440499e-11,
-1.029554558600871e-11,
-1.782455865507867e-12,
-2.83947113813939e-13,
-3.900977078288359e-14,
-0.02850692252927825,
2.69411198829845e-7,
3.10168222053379e-7,
2.380584824502544e-7,
1.370323830352254e-7,
6.31010517169071e-8,
2.421232177111505e-8,
7.96204932001518e-9,
2.290298120798888e-9,
5.85258455610543e-10,
1.344396405942023e-10,
2.800718464215341e-11,
5.321495074440211e-12,
9.24386372668655e-13,
1.484643219782434e-13,
2.07563479139596e-14,
0.01278191085951027,
-1.071496683898822e-7,
-1.233596113462722e-7,
-9.46804607158691e-8,
-5.45006813822867e-8,
-2.50968583538621e-8,
-9.63002201712613e-9,
-3.166881951640006e-9,
-9.11027292627055e-10,
-2.328369406907059e-10,
-5.350096332239412e-11,
-1.115232556806741e-11,
-2.121560463359895e-12,
-3.694550776658093e-13,
-5.969849850509124e-14,
-8.45284390509181e-15,
-0.004633613747361591,
3.48889357365714e-8,
4.01670814704868e-8,
3.08289288729398e-8,
1.774604515453568e-8,
8.17188345195067e-9,
3.135713631812854e-9,
1.0312254236647e-9,
2.966732473175527e-10,
7.58314693107045e-11,
1.742852656328665e-11,
3.634699912338443e-12,
6.92098344239885e-13,
1.207583090382114e-13,
1.960411283758311e-14,
2.802613142762072e-15,
0.00141204253944112,
-9.64753608924951e-9,
-1.110706422883317e-8,
-8.52487606671357e-9,
-4.90718560618637e-9,
-2.259725025624019e-9,
-8.67111374620804e-10,
-2.851689388433805e-10,
-8.20440786494479e-11,
-2.0972918727345e-11,
-4.821158278453223e-12,
-1.005825578827214e-12,
-1.916678476555901e-13,
-3.349430902077314e-14,
-5.45770719808581e-15,
-7.86136414363731e-16,
-0.000371538057138318,
2.322965172876352e-9,
2.674396707798324e-9,
2.052651105319395e-9,
1.181573068747613e-9,
5.44108819233151e-10,
2.087897603653722e-10,
6.86664854232259e-11,
1.975633696385796e-11,
5.050696333239286e-12,
1.161208864750486e-12,
2.423345483956682e-13,
4.620718544002495e-14,
8.08499867120764e-15,
1.321374234682103e-15,
1.914890848013756e-16,
0.00008607289022778,
-4.95982486015005e-10,
-5.71017853522606e-10,
-4.38267662231026e-10,
-2.52281692941649e-10,
-1.161749902649101e-10,
-4.457994503433793e-11,
-1.4661623414141e-11,
-4.218494514804474e-12,
-1.078524449155393e-12,
-2.479959297205357e-13,
-5.176794429768875e-14,
-9.87592592665706e-15,
-1.7298330168695e-15,
-2.834208121553982e-16,
-4.127716419892662e-17,
-0.00001781969057031607,
9.52131012344671e-11,
1.096175874837278e-10,
8.4133769030783e-11,
4.84303251373917e-11,
2.230209972905551e-11,
8.55806457686665e-12,
2.814647002062529e-12,
8.09862068764267e-13,
2.07065132474159e-13,
4.761770430802811e-14,
9.94211982891196e-15,
1.897510078879962e-15,
3.326558417406355e-16,
5.461759119897644e-17,
7.98757968121712e-18,
3.33577563204664e-6,
-1.661363130931906e-11,
-1.912706146397572e-11,
-1.46804264512156e-11,
-8.45057649074983e-12,
-3.891490347822903e-12,
-1.493304131801944e-12,
-4.911358668225297e-13,
-1.413184266196056e-13,
-3.613389395404155e-14,
-8.31029494454306e-15,
-1.735432089219854e-15,
-3.313399413572592e-16,
-5.813179357049205e-17,
-9.56151747974925e-18,
-1.403263714479498e-18,
-5.699973122398121e-7,
2.658240064408711e-12,
3.060398778317186e-12,
2.348922614078152e-12,
1.352125230271628e-12,
6.2265520269443e-13,
2.389362805438208e-13,
7.85850295613436e-14,
2.261234702439405e-14,
5.782011944355227e-15,
1.329889214713091e-15,
2.777643299314198e-16,
5.304958527990379e-17,
9.31335332910817e-18,
1.534226382155937e-18,
2.258512424046336e-19,
8.95930678664721e-8,
-3.92827977936292e-13,
-4.52258096540615e-13,
-3.47118113301494e-13,
-1.998140203298265e-13,
-9.2014783868678e-14,
-3.530969640762065e-14,
-1.161329604808461e-14,
-3.3417111238277e-15,
-8.54510552592086e-16,
-1.965551059832e-16,
-4.105880939528003e-17,
-7.84392884084792e-18,
-1.377862083497408e-18,
-2.272849914819144e-19,
-3.354653120700057e-20,
-1.304293588329608e-8,
5.39560961891695e-14,
6.211901544888e-14,
4.76777441537689e-14,
2.744509878005331e-14,
1.263855103456915e-14,
4.849928450367401e-15,
1.595145084434443e-15,
4.590080357871924e-16,
1.173767844563979e-16,
2.700075321828004e-17,
5.640939925039553e-18,
1.077928765481046e-18,
1.894530387868074e-19,
3.127633828545774e-20,
4.615985791970062e-21,
1.795296986398792e-9,
-7.01901357534415e-15,
-8.08090908838249e-15,
-6.2022825340291e-15,
-3.570269708153194e-15,
-1.644122880298181e-15,
-6.30919336710073e-16,
-2.075112928528751e-16,
-5.971286592390153e-17,
-1.527010437806158e-17,
-3.51285424162569e-18,
-7.33980674523756e-19,
-1.402865708714662e-19,
-2.46675070516765e-20,
-4.078173017287489e-21,
-6.030655639932018e-22,
-2.273580590059977e-10,
8.43917013640667e-16,
9.71592074626354e-16,
7.45719420845243e-16,
4.292647857463867e-16,
1.976783791660721e-16,
7.58577675509868e-17,
2.495000277726278e-17,
7.17962931358556e-18,
1.836058702906183e-18,
4.224056757101472e-19,
8.82700588021967e-20,
1.686379123318533e-20,
2.956271660317826e-21,
5.019194670235021e-22,
8.613011400612053e-23,
// [{0,0.00001},{2.,0.0001}]: m=7
0.02774584951071184,
-3.5103473835722e-7,
-4.04138437565789e-7,
-3.10179669937544e-7,
-1.785445101921846e-7,
-8.22142561954257e-8,
-3.15443405558126e-8,
-1.03719119434671e-8,
-2.98279746894531e-9,
-7.61859065987198e-10,
-1.748408632393739e-10,
-3.63543115881571e-11,
-6.88095253312602e-12,
-1.185737885837933e-12,
-1.867127821136051e-13,
-2.500384523587076e-14,
-0.0483103611957363,
5.22902894754081e-7,
6.02007682342338e-7,
4.62047958771967e-7,
2.659646578359038e-7,
1.22470634110665e-7,
4.6991694027347e-8,
1.545212139475891e-8,
4.44439240315748e-9,
1.135487067832999e-9,
2.607290406695217e-10,
5.42730490440499e-11,
1.029554558600871e-11,
1.782455865507867e-12,
2.83947113813939e-13,
3.900977078288357e-14,
0.04276038379391739,
-4.04116798244767e-7,
-4.65252333080068e-7,
-3.57087723675382e-7,
-2.055485745528381e-7,
-9.46515775753606e-8,
-3.631848265667258e-8,
-1.194307398002276e-8,
-3.435447181198332e-9,
-8.77887683415815e-10,
-2.016594608913034e-10,
-4.201077696323011e-11,
-7.98224261166032e-12,
-1.386579559002983e-12,
-2.226964829673651e-13,
-3.113452187093943e-14,
-0.02556382171902163,
2.142993367797683e-7,
2.467192226925488e-7,
1.893609214317416e-7,
1.090013627645753e-7,
5.01937167077251e-8,
1.92600440342526e-8,
6.33376390328012e-9,
1.822054585254142e-9,
4.656738813814202e-10,
1.070019266447902e-10,
2.230465113613523e-11,
4.243120926719868e-12,
7.38910155331631e-13,
1.193969970101845e-13,
1.690568781018465e-14,
0.01158403436840361,
-8.72223393414272e-8,
-1.004177036762156e-7,
-7.70723221823484e-8,
-4.43651128863386e-8,
-2.042970862987638e-8,
-7.83928407953202e-9,
-2.578063559161713e-9,
-7.41683118293871e-10,
-1.895786732767587e-10,
-4.357131640821602e-11,
-9.08674978084598e-12,
-1.730245860599679e-12,
-3.018957725955244e-13,
-4.901028209396514e-14,
-7.00653285690787e-15,
-0.004236127618271287,
2.89426082675646e-8,
3.33211926862877e-8,
2.557462819997815e-8,
1.472155681846555e-8,
6.77917507682897e-9,
2.601334123845877e-9,
8.55506816524703e-10,
2.461322359467786e-10,
6.29187561816348e-11,
1.446347483526759e-11,
3.017476736462394e-12,
5.750035429630891e-13,
1.0048292706168e-13,
1.637312159415301e-14,
2.358409243068696e-15,
0.001300383199993869,
-8.13037810510011e-9,
-9.36038847733198e-9,
-7.18427886864693e-9,
-4.135505740633368e-9,
-1.904380867323729e-9,
-7.30764161281758e-10,
-2.403326989822625e-10,
-6.91471793737826e-11,
-1.767743716640903e-11,
-4.064231026643071e-12,
-8.48170919388261e-13,
-1.617251490409709e-13,
-2.829749534945652e-14,
-4.624809821172302e-15,
-6.702117966251377e-16,
-0.0003442915620023958,
1.983929947915093e-9,
2.284071418528727e-9,
1.753070652330605e-9,
1.00912677372751e-9,
4.646999619626514e-10,
1.783197804838772e-10,
5.86464937705386e-11,
1.687397809201566e-11,
4.314097805009188e-12,
9.91983720811891e-13,
2.070717775940158e-13,
3.9503703783708e-14,
6.91933208111807e-15,
1.133683250881649e-15,
1.651086570099987e-16,
0.0000801886074437631,
-4.28458955141761e-10,
-4.932791432009e-10,
-3.786019602732783e-10,
-2.17936462908013e-10,
-1.003594486839287e-10,
-3.85112905587453e-11,
-1.266591149706091e-11,
-3.644379305922348e-12,
-9.31793095234289e-13,
-2.142796691802981e-13,
-4.473953918751434e-14,
-8.53879534379454e-15,
-1.496951283994625e-15,
-2.457791632044625e-16,
-3.594411163731898e-17,
-0.0000166788665179825,
8.30681154194555e-11,
9.56352599706615e-11,
7.34020959144447e-11,
4.225286153409268e-11,
1.945744210550469e-11,
7.46651696216567e-12,
2.45567811819532e-12,
7.06591783201039e-13,
1.806693802883664e-13,
4.155145413545286e-14,
8.67715614436493e-15,
1.656698884770281e-15,
2.906588213274559e-16,
4.780756292713706e-17,
7.016317297500673e-18,
3.134986002393469e-6,
-1.462032299980164e-11,
-1.683219632654148e-11,
-1.291907671515107e-11,
-7.43669011217799e-12,
-3.424604234514577e-12,
-1.314149780796055e-12,
-4.322177408034738e-13,
-1.243679311434804e-13,
-3.180107145106969e-14,
-7.3143919983405e-15,
-1.527704085480597e-15,
-2.917727906358351e-16,
-5.122347146794076e-17,
-8.43822674896831e-18,
-1.242159342095492e-18,
-5.376244599972371e-7,
2.357201201221624e-12,
2.713817213618229e-12,
2.082914862984084e-12,
1.199002809027594e-12,
5.52143359210774e-13,
2.118791523804419e-13,
6.96866747593052e-14,
2.005225187313633e-14,
5.127570988185237e-15,
1.179447437175678e-15,
2.463772618024358e-16,
4.70682363530426e-17,
8.26800431110451e-18,
1.363849417994612e-18,
2.012864745876435e-19,
8.47766089183064e-8,
-3.50706287267439e-13,
-4.03764001013433e-13,
-3.098979692295628e-13,
-1.783889008929866e-13,
-8.21486286382072e-14,
-3.152378543988512e-14,
-1.036819653617134e-14,
-2.983481290321384e-15,
-7.62930953487431e-16,
-1.755007437300178e-16,
-3.666525920861124e-17,
-7.00631102232248e-18,
-1.231349659287304e-18,
-2.033549731061653e-19,
-3.007905120742167e-20,
-1.237736546593907e-8,
4.84629335572792e-14,
5.57948141959361e-14,
4.282379548294771e-14,
2.465100483652301e-14,
1.135188172497275e-14,
4.356195757098847e-15,
1.432765832875665e-15,
4.122885346354685e-16,
1.054326355856648e-16,
2.425451346986248e-17,
5.067767672474487e-18,
9.68611080205896e-19,
1.702898490151387e-19,
2.814745222975294e-20,
4.191762419493499e-21,
1.708230920431472e-9,
-6.3396401943817e-15,
-7.29875576927241e-15,
-5.60196410926419e-15,
-3.224706050292234e-15,
-1.484991756071111e-15,
-5.698557463760904e-16,
-1.87428435259924e-16,
-5.393453752804776e-17,
-1.379277490390298e-17,
-3.173153216358077e-18,
-6.63069519689951e-19,
-1.267570763883361e-19,
-2.229312612719155e-20,
-3.690843429489241e-21,
-5.516929506375976e-22,
-2.168384896029171e-10,
7.65973336160491e-16,
8.81856555036416e-16,
6.76845563241366e-16,
3.896186110064761e-16,
1.79421382145426e-16,
6.88519548703524e-17,
2.26458797413703e-17,
6.516664962983658e-18,
1.666555978103291e-18,
3.83425771576204e-19,
8.01219438564471e-20,
1.531325406834832e-20,
2.712646449623193e-21,
4.541015679700695e-22,
4.773975368216752e-23,
// [{0,0.00001},{2.,0.0001}]: m=8
0.02415518059786814,
-2.61451447377041e-7,
-3.01003841171169e-7,
-2.31023979385984e-7,
-1.329823289179519e-7,
-6.12353170553325e-8,
-2.349584701367348e-8,
-7.72606069737946e-9,
-2.222196201578739e-9,
-5.67743533916499e-10,
-1.303645203347608e-10,
-2.713652452202493e-11,
-5.14777279300435e-12,
-8.91227932753933e-13,
-1.419735569069695e-13,
-1.950488539144179e-14,
-0.04276038379391738,
4.04116798244767e-7,
4.65252333080068e-7,
3.57087723675382e-7,
2.055485745528381e-7,
9.46515775753606e-8,
3.63184826566726e-8,
1.194307398002276e-8,
3.435447181198332e-9,
8.77887683415815e-10,
2.016594608913034e-10,
4.20107769632301e-11,
7.98224261166032e-12,
1.386579559002983e-12,
2.226964829673651e-13,
3.113452187093939e-14,
0.03834573257853244,
-3.21449005169652e-7,
-3.70078834038823e-7,
-2.840413821476124e-7,
-1.63502044146863e-7,
-7.52905750615876e-8,
-2.889006605137891e-8,
-9.50064585492019e-9,
-2.733081877881213e-9,
-6.9851082207213e-10,
-1.605028899671853e-10,
-3.345697670420284e-11,
-6.3646813900798e-12,
-1.108365232997447e-12,
-1.790954955152766e-13,
-2.53585317152772e-14,
-0.02316806873680826,
1.744446786828579e-7,
2.008354073524352e-7,
1.541446443646999e-7,
8.87302257726789e-8,
4.085941725975357e-8,
1.567856815906436e-8,
5.15612711832353e-9,
1.483366236587772e-9,
3.79157346553525e-10,
8.71426328164338e-11,
1.817349956169232e-11,
3.460491721199428e-12,
6.03791545191057e-13,
9.8020564187933e-14,
1.401306571382036e-14,
0.01059031904567787,
-7.23565206689103e-8,
-8.3302981715718e-8,
-6.39365704999444e-8,
-3.680389204616329e-8,
-1.694793769207215e-8,
-6.50333530961459e-9,
-2.138767041311724e-9,
-6.15330589866937e-10,
-1.572968904540844e-10,
-3.61586870881684e-11,
-7.54369184115586e-12,
-1.437508857407689e-12,
-2.512073176542126e-13,
-4.093280398539419e-14,
-5.89602310765283e-15,
-0.003901149599931837,
2.439113431513261e-8,
2.808116543180286e-8,
2.15528366057926e-8,
1.24065172218148e-8,
5.7131426019319e-9,
2.192292483830198e-9,
7.20998096941829e-10,
2.074415381199209e-10,
5.30323114988622e-11,
1.219269307984525e-11,
2.544512758147192e-12,
4.851754471195759e-13,
8.48924860478949e-14,
1.387442946339376e-14,
2.010635389736627e-15,
0.001205020467017728,
-6.94375481773292e-9,
-7.99424996488519e-9,
-6.13574728318371e-9,
-3.531943708061595e-9,
-1.626449866876329e-9,
-6.24119231696276e-10,
-2.05262728197775e-10,
-5.90589233223109e-11,
-1.509934231759762e-11,
-3.471943022856588e-12,
-7.2475122158236e-13,
-1.382629632438469e-13,
-2.421766228357941e-14,
-3.967891377813699e-15,
-5.778803000302959e-16,
-0.0003207544308180596,
1.713835824081688e-9,
1.973116576849972e-9,
1.514407844198799e-9,
8.71745853419806e-10,
4.014377955589861e-10,
1.540451625509077e-10,
5.066364609215455e-11,
1.457751725359148e-11,
3.727172388584292e-12,
8.57118678480735e-13,
1.789581571183177e-13,
3.415518144521022e-14,
5.987805146901852e-15,
9.83116655254221e-16,
1.437764484040839e-16,
0.0000750548992134585,
-3.73806519009174e-10,
-4.30358669432357e-10,
-3.303094312806527e-10,
-1.901378767109529e-10,
-8.75584893861402e-11,
-3.359932629573376e-11,
-1.105055152069209e-11,
-3.179663021185243e-12,
-8.13012210474674e-13,
-1.869815434212262e-13,
-3.904720260817368e-14,
-7.45514497088985e-15,
-1.307964699955252e-15,
-2.151340361734458e-16,
-3.157342187236572e-17,
-0.00001567491888466318,
7.31015775036223e-11,
8.41609384646814e-11,
6.45953504432739e-11,
3.718343148853416e-11,
1.712301238964368e-11,
6.57074553357181e-12,
2.161087595461371e-12,
6.21839336711989e-13,
1.590052756727344e-13,
3.657194122057153e-14,
7.63851650098787e-15,
1.458863205120413e-15,
2.561172345016725e-16,
4.219110900360451e-17,
6.210783717305808e-18,
2.956935281799807e-6,
-1.296460902848059e-11,
-1.492599746304826e-11,
-1.145603388638263e-11,
-6.59451668150322e-12,
-3.036789042934547e-12,
-1.165335555782063e-12,
-3.832767827766977e-13,
-1.102874059078893e-13,
-2.820164570250457e-14,
-6.48696211035308e-15,
-1.355075204844935e-15,
-2.588753657440675e-16,
-4.547399957002777e-17,
-7.501154832614245e-18,
-1.107112218894787e-18,
-5.087227847714207e-7,
2.10445045277829e-12,
2.422828918842503e-12,
1.85957579171741e-12,
1.070441611911792e-12,
4.929416015677836e-13,
1.891618345710218e-13,
6.22154685828189e-14,
1.790269761164363e-14,
4.578048579395502e-15,
1.053110958833625e-15,
2.200138235436784e-16,
4.204211427094626e-17,
7.38881720390523e-18,
1.220264789685559e-18,
1.805239378174982e-19,
8.0450506029121e-8,
-3.15001435480093e-13,
-3.626575048951635e-13,
-2.78347926116391e-13,
-1.602276490233642e-13,
-7.37854433364184e-14,
-2.831458633086628e-14,
-9.31275225108575e-15,
-2.679810532803403e-15,
-6.8529552952642e-16,
-1.57650535316195e-16,
-3.29396562600311e-17,
-6.295769672427725e-18,
-1.106956481568528e-18,
-1.830059901716741e-19,
-2.713519345632809e-20,
-1.177629400785197e-8,
4.37664976940021e-14,
5.03878715979287e-14,
3.867385820109638e-14,
2.226216016866672e-14,
1.025182531490938e-14,
3.934069746365905e-15,
1.293935235146047e-15,
3.723435997950233e-16,
9.52200367079801e-17,
2.190620426729303e-17,
4.577544443269812e-18,
8.75089750481551e-19,
1.539445072378741e-19,
2.545999468030028e-20,
3.764324975198888e-21,
1.629205130064932e-9,
-5.75419448937257e-15,
-6.62473991234789e-15,
-5.08464307037462e-15,
-2.926918165640748e-15,
-1.347860933445797e-15,
-5.172341205294613e-16,
-1.701218498199704e-16,
-4.895491976275477e-17,
-1.251960411061887e-17,
-2.880374939451266e-18,
-6.019391106274603e-19,
-1.150931696221955e-19,
-2.025942381042666e-20,
-3.353420818997351e-21,
-4.908838705581142e-22,
-2.07247830844227e-10,
6.98335512023841e-16,
8.03986007452428e-16,
6.17078285185663e-16,
3.5521446322952e-16,
1.635782972910344e-16,
6.27724150874943e-17,
2.064638022993854e-17,
5.941340323799456e-18,
1.519451068346985e-18,
3.495960780284427e-19,
7.30725435352599e-20,
1.396270351495438e-20,
2.440743890585293e-21,
4.195885898625509e-22,
7.655987434740443e-23,
// [{0,0.00001},{2.,0.0001}]: m=9
0.02138019189695869,
-2.02058399122384e-7,
-2.32626166540034e-7,
-1.785438618376908e-7,
-1.027742872764191e-7,
-4.73257887876803e-8,
-1.815924132833629e-8,
-5.97153699001138e-9,
-1.717723590599166e-9,
-4.38943841707907e-10,
-1.008297304456517e-10,
-2.100538848161506e-11,
-3.99112130583016e-12,
-6.93289779501492e-13,
-1.113482414836825e-13,
-1.55672609354697e-14,
-0.03834573257853244,
3.21449005169652e-7,
3.70078834038823e-7,
2.84041382147612e-7,
1.63502044146863e-7,
7.52905750615876e-8,
2.889006605137891e-8,
9.50064585492019e-9,
2.733081877881213e-9,
6.9851082207213e-10,
1.605028899671852e-10,
3.345697670420284e-11,
6.3646813900798e-12,
1.108365232997447e-12,
1.790954955152765e-13,
2.535853171527728e-14,
0.03475210310521239,
-2.61667018024287e-7,
-3.01253111028653e-7,
-2.312169665470499e-7,
-1.330953386590184e-7,
-6.12891258896304e-8,
-2.351785223859654e-8,
-7.73419067748529e-9,
-2.225049354881658e-9,
-5.68736019830287e-10,
-1.307139492246507e-10,
-2.726024934253848e-11,
-5.19073758179914e-12,
-9.05687317786587e-13,
-1.470308462818995e-13,
-2.101959857072982e-14,
-0.02118063809135673,
1.447130413378238e-7,
1.666059634314396e-7,
1.278731409998916e-7,
7.36077840923282e-8,
3.389587538414505e-8,
1.300667061922947e-8,
4.277534082623542e-9,
1.230661179733901e-9,
3.145937809081758e-10,
7.23173741763384e-11,
1.508738368231205e-11,
2.875017714815442e-12,
5.024146353084431e-13,
8.18656079707905e-14,
1.1792046215299e-14,
0.00975287399982926,
-6.09778357878305e-8,
-7.0202913579506e-8,
-5.38820915144806e-8,
-3.101629305453646e-8,
-1.428285650482951e-8,
-5.4807312095754e-9,
-1.802495242354542e-9,
-5.18603845299793e-10,
-1.325807787471532e-10,
-3.048173269961261e-11,
-6.36128189536789e-12,
-1.212938617798914e-12,
-2.122312151196895e-13,
-3.468607365849047e-14,
-5.026588474383559e-15,
-0.003615061401005523,
2.083126445304523e-8,
2.398274989447883e-8,
1.840724184941547e-8,
1.059583112410669e-8,
4.87934960059303e-9,
1.872357695075026e-9,
6.15788184588786e-10,
1.771767699656265e-10,
4.529802695245878e-11,
1.04158290684929e-11,
2.174253664731082e-12,
4.147888897284741e-13,
7.26529868500188e-14,
1.190367413334643e-14,
1.733640900265701e-15,
0.001122640507872172,
-5.99842538431356e-9,
-6.90590801900674e-9,
-5.30042745472023e-9,
-3.051110486983389e-9,
-1.405032284462929e-9,
-5.39158068930663e-10,
-1.773227613233585e-10,
-5.102131038780547e-11,
-1.304510336010528e-11,
-2.999915374696372e-12,
-6.26353549916598e-13,
-1.195431350589527e-13,
-2.095731801520629e-14,
-3.440908293191452e-15,
-5.032175685213029e-16,
-0.0003002195978526556,
1.495226079254038e-9,
1.721434681433518e-9,
1.321237727965588e-9,
7.60551508480342e-10,
3.50233958298193e-10,
1.343973054721386e-10,
4.420220617789029e-11,
1.271865211211414e-11,
3.252048848899459e-12,
7.47926175295672e-13,
1.561888107685639e-13,
2.982057994791674e-14,
5.231858813252161e-15,
8.60536146583482e-16,
1.262936855620675e-16,
0.00007053713486829623,
-3.28957098418639e-10,
-3.78724222690808e-10,
-2.906790766875246e-10,
-1.673254415215625e-10,
-7.705355567196e-11,
-2.956835486982213e-11,
-9.72489416929746e-12,
-2.798277012245909e-12,
-7.15523739769856e-13,
-1.645737353191744e-13,
-3.437332422232763e-14,
-6.56488441378075e-15,
-1.152527544203325e-15,
-1.898599932893378e-16,
-2.794853578232938e-17,
-0.00001478466575308267,
6.48230108187083e-11,
7.4629947798743e-11,
5.72801391020571e-11,
3.297256594845158e-11,
1.518393717466434e-11,
5.82667469358733e-12,
1.916382899090096e-12,
5.514367375130567e-13,
1.410081538267647e-13,
3.243479336773735e-14,
6.77537243700645e-15,
1.294376141675225e-15,
2.273698651745581e-16,
3.750575442035775e-17,
5.53557048389579e-18,
2.797976037498119e-6,
-1.157447971545851e-11,
-1.332556161545735e-11,
-1.022766882070703e-11,
-5.88742999737319e-12,
-2.711179329851224e-12,
-1.040390290160423e-12,
-3.421851429936586e-13,
-9.84648557968223e-14,
-2.517927203381252e-14,
-5.792111383003814e-15,
-1.21007623920401e-15,
-2.312316889281478e-16,
-4.063855498136773e-17,
-6.711437268229779e-18,
-9.92834269250936e-19,
-4.827634930263684e-7,
1.890203347724314e-12,
2.17616922549002e-12,
1.670259632573236e-12,
9.61464947818494e-13,
4.427582748567807e-13,
1.699050225078504e-13,
5.588227091828332e-14,
1.60805200032275e-14,
4.112196902573714e-15,
9.46000704715917e-16,
1.976583041752437e-16,
3.777851680614723e-17,
6.64245331493428e-18,
1.098147488515672e-18,
1.627982396430855e-19,
7.654363786628603e-8,
-2.84475221937273e-13,
-3.27513091309568e-13,
-2.513738812586663e-13,
-1.447004738283433e-13,
-6.6635221795895e-14,
-2.557082295073063e-14,
-8.41037168425922e-15,
-2.420173728207389e-15,
-6.1891496403045e-16,
-1.423868322413886e-16,
-2.975336772052616e-17,
-5.687889823761394e-18,
-1.000474705589814e-18,
-1.655535945253074e-19,
-2.459132735127034e-20,
-1.123079470719621e-8,
3.97200591760105e-14,
4.57292607568034e-14,
3.509827856836677e-14,
2.020393290026035e-14,
9.30401514872967e-15,
3.570363717209678e-15,
1.174316958530167e-15,
3.37925887908462e-16,
8.64202430416044e-17,
1.988261348066399e-17,
4.155050473399395e-18,
7.94455045794174e-19,
1.398375287227971e-19,
2.315170361663721e-20,
3.395770516177613e-21,
1.557156642489694e-9,
-5.24614822895325e-15,
-6.03983285733823e-15,
-4.635714640758614e-15,
-2.668499168183489e-15,
-1.228859173908907e-15,
-4.715690280205463e-16,
-1.551030570342082e-16,
-4.463349670882182e-17,
-1.141468128129787e-17,
-2.626271773762513e-18,
-5.488803709876844e-19,
-1.049619127524285e-19,
-1.848244463329645e-20,
-3.064716714150588e-21,
-4.488313286375959e-22,
-1.984684131898111e-10,
6.39265693549197e-16,
7.35979677655611e-16,
5.64881976950422e-16,
3.251684041970878e-16,
1.497420835025352e-16,
5.746296148772212e-17,
1.890014123504304e-17,
5.438880400442476e-18,
1.390973943268356e-18,
3.200448219321849e-19,
6.691251144148433e-20,
1.279528241592067e-20,
2.202708689988286e-21,
3.725486592810723e-22,
1.081172376745804e-22,
// [{0,0.00001},{2.,0.0001}]: m=10
0.01917286628926622,
-1.60724502584826e-7,
-1.85039417019412e-7,
-1.420206910738062e-7,
-8.17510220734315e-8,
-3.76452875307938e-8,
-1.444503302568945e-8,
-4.75032292746009e-9,
-1.366540938940606e-9,
-3.49255411036065e-10,
-8.02514449835926e-11,
-1.672848835210142e-11,
-3.1823406950399e-12,
-5.54182616498723e-13,
-8.95477477576383e-14,
-1.267926585763864e-14,
-0.03475210310521239,
2.61667018024287e-7,
3.01253111028653e-7,
2.312169665470499e-7,
1.330953386590184e-7,
6.12891258896304e-8,
2.351785223859654e-8,
7.73419067748529e-9,
2.225049354881658e-9,
5.68736019830287e-10,
1.307139492246507e-10,
2.726024934253848e-11,
5.19073758179914e-12,
9.05687317786586e-13,
1.470308462818994e-13,
2.101959857072982e-14,
0.03177095713703509,
-2.17069562006736e-7,
-2.499089451471595e-7,
-1.918097114998374e-7,
-1.104116761384923e-7,
-5.08438130762176e-8,
-1.951000592884421e-8,
-6.41630112393531e-9,
-1.845991769600852e-9,
-4.71890671362264e-10,
-1.084760612645076e-10,
-2.263107552346808e-11,
-4.312526572223163e-12,
-7.53621952962665e-13,
-1.227984119561857e-13,
-1.768806932294772e-14,
-0.01950574799965947,
1.219556715756639e-7,
1.404058271590153e-7,
1.077641830289638e-7,
6.20325861090744e-8,
2.856571300965971e-8,
1.096146241915107e-8,
3.604990484709171e-9,
1.037207690599612e-9,
2.651615574943129e-10,
6.09634653992267e-11,
1.272256379073609e-11,
2.425877235597886e-12,
4.244624302393908e-13,
6.93721473169834e-14,
1.0053176948766e-14,
0.00903765350251348,
-5.20781611326121e-8,
-5.9956874736196e-8,
-4.60181046235378e-8,
-2.648957781026624e-8,
-1.219837400148234e-8,
-4.68089423768748e-9,
-1.539470461471936e-9,
-4.42941924914058e-10,
-1.132450673811449e-10,
-2.603957267123177e-11,
-5.43563416182762e-12,
-1.036972224321161e-12,
-1.816324671250011e-13,
-2.975918533337181e-14,
-4.334102250709236e-15,
-0.003367921523570791,
1.799527615279962e-8,
2.071772405685781e-8,
1.590128236403604e-8,
9.15333146087841e-9,
4.215096853355743e-9,
1.617474206779308e-9,
5.31968283965905e-10,
1.530639311622162e-10,
3.91353100800089e-11,
8.99974612401848e-12,
1.87906064973506e-12,
3.586294051740588e-13,
6.2871954045049e-14,
1.032272487946809e-14,
1.509652705626839e-15,
0.001050768592492907,
-5.23329127741463e-9,
-6.02502138504667e-9,
-4.62433204790209e-9,
-2.661930279694164e-9,
-1.225818854049648e-9,
-4.70390569154777e-10,
-1.547077216233698e-10,
-4.451528239261642e-11,
-1.138217097120366e-11,
-2.617741613547592e-12,
-5.466608376922366e-13,
-1.043720298183095e-13,
-1.831150584754728e-14,
-3.011876512943864e-15,
-4.420278983292304e-16,
-0.0002821485404314073,
1.31582839663074e-9,
1.514896894166652e-9,
1.162716309362306e-9,
6.69301767589941e-10,
3.082142233802998e-10,
1.182734197450179e-10,
3.889957676459124e-11,
1.119310807413525e-11,
2.862094965512078e-12,
6.58294942756947e-13,
1.374932971982138e-13,
2.62595377139365e-14,
4.610110188502445e-15,
7.59439975238572e-16,
1.117941420477163e-16,
0.00006653099578058606,
-2.91703548363651e-10,
-3.358347647253133e-10,
-2.577606256760174e-10,
-1.483765466049881e-10,
-6.83277172109066e-11,
-2.622003609233006e-11,
-8.62372303642861e-12,
-2.481465316081519e-12,
-6.34536691521941e-13,
-1.45956569994503e-13,
-3.048917593815358e-14,
-5.824692630477262e-15,
-1.023164378505412e-15,
-1.687758955593125e-16,
-2.491008158994148e-17,
-0.00001398986996469895,
5.78723670396913e-11,
6.6627771768383e-11,
5.11383162355773e-11,
2.943713394495913e-11,
1.355588926185013e-11,
5.201948615906992e-12,
1.710924782539274e-12,
4.923240106576766e-13,
1.258962915434777e-13,
2.89605411237163e-14,
6.050377899168918e-15,
1.156157815954237e-15,
2.031926537415297e-16,
3.355716533277562e-17,
4.964179247678013e-18,
2.655199904724914e-6,
-1.039612046405234e-11,
-1.196893310214444e-11,
-9.1864297920062e-12,
-5.28805825655285e-12,
-2.435170992275102e-12,
-9.34477808208059e-13,
-3.073525507062279e-13,
-8.84428774730774e-14,
-2.261708743511534e-14,
-5.203004902886766e-15,
-1.087120853449444e-15,
-2.077818850918129e-16,
-3.653359041047376e-17,
-6.039809834578548e-18,
-8.95295635974657e-19,
-4.593198267221632e-7,
1.707030259775339e-12,
1.965284545929343e-12,
1.50840139603182e-12,
8.68293856510202e-13,
3.998532431228273e-13,
1.534410214432653e-13,
5.046752022906309e-14,
1.452256471616946e-14,
3.713879129107168e-15,
8.54410582620486e-16,
1.785389183798552e-16,
3.413091202137689e-17,
6.003515912425998e-18,
9.9343468310066e-19,
1.475239926023095e-19,
7.299798121226998e-8,
-2.581739187310265e-13,
-2.972327507816516e-13,
-2.281330971382328e-13,
-1.313222748995908e-13,
-6.04745838806241e-14,
-2.320678294286303e-14,
-7.63286906254988e-15,
-2.196463257958237e-15,
-5.617174877749302e-16,
-1.292337488123237e-16,
-2.700726327626857e-17,
-5.163829738754773e-18,
-9.08628262064151e-19,
-1.50483005299634e-19,
-2.237988006241134e-20,
-1.073351304323786e-8,
3.62091337162591e-14,
4.16871779401449e-14,
3.199589528367619e-14,
1.841809198002851e-14,
8.48163674714437e-15,
3.25478869952911e-15,
1.07052750676633e-15,
3.080621059852897e-16,
7.8784525512592e-17,
1.812659802778393e-17,
3.788400177030932e-18,
7.24454155943436e-19,
1.275108940911145e-19,
2.114492486848763e-20,
3.155638078721699e-21,
1.491201712204158e-9,
-4.80245113191137e-15,
-5.52901003937582e-15,
-4.243647235089434e-15,
-2.442811167581828e-15,
-1.124929822095117e-15,
-4.316875921222074e-16,
-1.419863540335417e-16,
-4.085931475531725e-17,
-1.044965048173414e-17,
-2.40432474214544e-18,
-5.025341823089611e-19,
-9.61159711433709e-20,
-1.692009883468657e-20,
-2.805048086007115e-21,
-4.218919382942428e-22,
-1.904016124627554e-10,
5.87377109108216e-16,
6.76240998588058e-16,
5.19031247653446e-16,
2.987750648062686e-16,
1.375879271257132e-16,
5.279895819093133e-17,
1.736617500024145e-17,
4.997493648024255e-18,
1.278116066304174e-18,
2.940839595109088e-19,
6.146782311990996e-20,
1.176753466567911e-20,
2.081465196144886e-21,
3.332593984837643e-22,
3.982224433672097e-23,
// [{0,0.00001},{2.,0.0001}]: m=11
0.01737605155260619,
-1.30833509012143e-7,
-1.506265555143264e-7,
-1.156084832735249e-7,
-6.65476693295092e-8,
-3.06445629448152e-8,
-1.175892611929827e-8,
-3.86709533874265e-9,
-1.112524677440829e-9,
-2.84368009915144e-10,
-6.53569746123253e-11,
-1.363012467126924e-11,
-2.595368790899571e-12,
-4.52843658893293e-13,
-7.35154231409497e-14,
-1.050979928536491e-14,
-0.03177095713703509,
2.17069562006736e-7,
2.49908945147159e-7,
1.918097114998373e-7,
1.104116761384923e-7,
5.08438130762176e-8,
1.951000592884421e-8,
6.41630112393531e-9,
1.845991769600852e-9,
4.71890671362264e-10,
1.084760612645076e-10,
2.263107552346808e-11,
4.31252657222316e-12,
7.53621952962665e-13,
1.227984119561857e-13,
1.768806932294773e-14,
0.0292586219994892,
-1.829335073634959e-7,
-2.10608740738523e-7,
-1.616462745434457e-7,
-9.30488791636116e-8,
-4.28485695144896e-8,
-1.64421936287266e-8,
-5.40748572706376e-9,
-1.555811535899418e-9,
-3.977423362414693e-10,
-9.144519809884e-11,
-1.908384568610413e-11,
-3.638815853396829e-12,
-6.36693645359086e-13,
-1.040582209754753e-13,
-1.507976542314885e-14,
-0.01807530700502788,
1.04156322265227e-7,
1.199137494723951e-7,
9.20362092470781e-8,
5.29791556205339e-8,
2.439674800296532e-8,
9.3617884753752e-9,
3.078940922943953e-9,
8.85883849828139e-10,
2.264901347622956e-10,
5.20791453424649e-11,
1.087126832365552e-11,
2.073944448642376e-12,
3.632649342500121e-13,
5.951837066674502e-14,
8.66820450141848e-15,
0.00841980380892667,
-4.49881903819982e-8,
-5.17943101421435e-8,
-3.97532059100893e-8,
-2.288332865219558e-8,
-1.053774213338915e-8,
-4.04368551694819e-9,
-1.329920709914736e-9,
-3.82659827905533e-10,
-9.78382752000203e-11,
-2.249936531004575e-11,
-4.697651624337561e-12,
-8.96573512935139e-13,
-1.571798851126111e-13,
-2.580681219865749e-14,
-3.774131764074083e-15,
-0.003152305777434784,
1.569987383211383e-8,
1.807506415499026e-8,
1.387299614359134e-8,
7.98579083901634e-9,
3.677456562118478e-9,
1.41117170745264e-9,
4.641231648662641e-10,
1.335458471767427e-10,
3.414651291332798e-11,
7.85322484057766e-12,
1.639982513063092e-12,
3.131160894523162e-13,
5.493451754219977e-14,
9.03562953876835e-15,
1.326083694955835e-15,
0.000987519891518215,
-4.60539938823117e-9,
-5.30213912961043e-9,
-4.06950708278891e-9,
-2.342556186576788e-9,
-1.078749781836573e-9,
-4.139569691096823e-10,
-1.361485186767665e-10,
-3.917587825967399e-11,
-1.00173323793436e-11,
-2.304032299661205e-12,
-4.812265401961578e-13,
-9.1908381998992e-14,
-1.613538565995965e-14,
-2.658039913659629e-15,
-3.91279497082939e-16,
-0.0002661239840431351,
1.16681419618015e-9,
1.343339062039144e-9,
1.031042505112477e-9,
5.93506187806328e-10,
2.733108694820624e-10,
1.048801446143186e-10,
3.449489222629749e-11,
9.92586128751577e-12,
2.538146772018623e-12,
5.83826281342672e-13,
1.219567040380526e-13,
2.32987705766627e-14,
4.092657523139704e-15,
6.751035835749024e-16,
9.9640327170334e-17,
0.00006295441473693082,
-2.604256513821475e-10,
-2.998249726164082e-10,
-2.301224227981303e-10,
-1.324671026015169e-10,
-6.10015016088814e-11,
-2.340876874493236e-11,
-7.69916151266149e-12,
-2.215458045437283e-12,
-5.665333113004617e-13,
-1.303224349072592e-13,
-2.722670051539487e-14,
-5.202710168949811e-15,
-9.14366940680748e-16,
-1.510072401298637e-16,
-2.233880633170011e-17,
-0.00001327598970016617,
5.1980573243157e-11,
5.98446320345578e-11,
4.59321232662628e-11,
2.644027649240068e-11,
1.217584815030718e-11,
4.672386427308145e-12,
1.53676189384179e-12,
4.422141399692395e-13,
1.130853739030114e-13,
2.60150099557213e-14,
5.435601222207991e-15,
1.038908841596818e-15,
1.826678542681373e-16,
3.01990343792739e-17,
4.476470195527094e-18,
2.526259713992397e-6,
-9.38866832625614e-12,
-1.080906718717391e-11,
-8.2962093548801e-12,
-4.77561717598523e-12,
-2.19919328164783e-12,
-8.4392578850358e-13,
-2.775714173612241e-13,
-7.98741220825177e-14,
-2.042633933882997e-14,
-4.69925916078512e-15,
-9.8196425208136e-16,
-1.877200352859679e-16,
-3.301933661853749e-17,
-5.463914198024244e-18,
-8.11391871630245e-19,
-4.380436211844593e-7,
1.549208481078976e-12,
1.783586431408132e-12,
1.368944356192627e-12,
7.8801756239265e-13,
3.628861458188222e-13,
1.392555266431037e-13,
4.580209181510312e-14,
1.318018314752582e-14,
3.370663903304194e-15,
7.75485092223038e-16,
1.620608534337658e-16,
3.098628828137346e-17,
5.452331253491443e-18,
9.0298595307969e-19,
1.343165336392501e-19,
6.976573252774e-8,
-2.353533888435352e-13,
-2.709597715398177e-13,
-2.079680348836551e-13,
-1.197145559215981e-13,
-5.51292380161391e-14,
-2.115558897641656e-14,
-6.95825197940347e-15,
-2.002352809173996e-15,
-5.12086405389e-16,
-1.178198737676831e-16,
-2.462395792836574e-17,
-4.708888804679986e-18,
-8.28847259355553e-19,
-1.373718774098637e-19,
-2.045731613825221e-20,
-1.027833565960898e-8,
3.31433470062868e-14,
3.81575767580003e-14,
2.928685113895347e-14,
1.685866945502615e-14,
7.76352251431899e-15,
2.979222424706089e-15,
9.79895855278048e-16,
2.81983887797824e-16,
7.21165259282239e-17,
1.65930348713391e-17,
3.468134236037341e-18,
6.633148252463269e-19,
1.168051243202551e-19,
1.937017044093433e-20,
2.872028793460649e-21,
1.430599617299857e-9,
-4.41268905917091e-15,
-5.08028183373855e-15,
-3.899238623640202e-15,
-2.244557104196952e-15,
-1.033633648113434e-15,
-3.966538437461329e-16,
-1.304639412496254e-16,
-3.754382671222849e-17,
-9.60188187142288e-18,
-2.209337834491366e-18,
-4.618109908465489e-19,
-8.83373501029114e-20,
-1.55526513344028e-20,
-2.581730651452015e-21,
-3.908041519106676e-22,
-1.829641505803153e-10,
5.41552346143645e-16,
6.23483511307936e-16,
4.785387186225517e-16,
2.754660815298857e-16,
1.268541029777403e-16,
4.867997679979588e-17,
1.601145588015471e-17,
4.607678007411019e-18,
1.178436226833287e-18,
2.71159992022452e-19,
5.668897169252106e-20,
1.084338171276972e-20,
1.893838032101017e-21,
3.17795471743889e-22,
6.465142259401713e-23,
// [{0,0.00001},{2.,0.0001}]: m=12
0.01588547856851754,
-1.085347810033679e-7,
-1.249544725735797e-7,
-9.59048557499187e-8,
-5.52058380692462e-8,
-2.54219065381088e-8,
-9.7550029644221e-9,
-3.20815056196766e-9,
-9.22995884800426e-10,
-2.359453356811319e-10,
-5.42380306322538e-11,
-1.131553776173404e-11,
-2.156263286111581e-12,
-3.76810976481333e-13,
-6.13992059780928e-14,
-8.84403466147387e-15,
-0.0292586219994892,
1.82933507363496e-7,
2.10608740738523e-7,
1.616462745434457e-7,
9.30488791636116e-8,
4.28485695144896e-8,
1.64421936287266e-8,
5.40748572706376e-9,
1.555811535899417e-9,
3.97742336241469e-10,
9.144519809884e-11,
1.908384568610413e-11,
3.638815853396829e-12,
6.36693645359086e-13,
1.040582209754753e-13,
1.507976542314883e-14,
0.02711296050754183,
-1.562344833978405e-7,
-1.798706242085926e-7,
-1.380543138706171e-7,
-7.94687334308008e-8,
-3.659512200444798e-8,
-1.404268271306281e-8,
-4.61841138441593e-9,
-1.328825774742209e-9,
-3.397352021434435e-10,
-7.81187180136973e-11,
-1.630690248548329e-11,
-3.110916672963565e-12,
-5.44897401375019e-13,
-8.92775560001176e-14,
-1.30023067521274e-14,
-0.01683960761785421,
8.99763807639988e-8,
1.035886202842899e-7,
7.95064118201809e-8,
4.57666573043924e-8,
2.107548426677889e-8,
8.08737103389661e-9,
2.659841419829546e-9,
7.65319655811087e-10,
1.956765504000461e-10,
4.499873062009275e-11,
9.39530324867539e-12,
1.793147025870329e-12,
3.14359770225228e-13,
5.161362439731684e-14,
7.54826352815151e-15,
0.00788076444358666,
-3.92496845802838e-8,
-4.51876603874747e-8,
-3.468249035897762e-8,
-1.996447709754043e-8,
-9.193641405296e-9,
-3.527929268631526e-9,
-1.160307912165636e-9,
-3.338646179418497e-10,
-8.53662822833182e-11,
-1.963306210144373e-11,
-4.099956282657652e-12,
-7.82790223630777e-13,
-1.373362938554768e-13,
-2.258907384691763e-14,
-3.315209237409059e-15,
-0.002962559674512358,
1.381619816457323e-8,
1.59064173886928e-8,
1.220852124826043e-8,
7.02766855966918e-9,
3.236249345481541e-9,
1.241870907318234e-9,
4.084455560267431e-10,
1.175276347779985e-10,
3.005199713776905e-11,
6.91209689892338e-12,
1.443679620575838e-12,
2.757251459945766e-13,
4.84061569795659e-14,
7.97411974089964e-15,
1.173838491123224e-15,
0.000931433944158961,
-4.0838496866524e-9,
-4.70168671716219e-9,
-3.608648767912998e-9,
-2.077271657333275e-9,
-9.56588043192342e-10,
-3.670805061520814e-10,
-1.207321227926879e-10,
-3.474051450649131e-11,
-8.88351370211282e-12,
-2.043391984710329e-12,
-4.268484641352856e-13,
-8.15456970186917e-14,
-1.432430133154518e-14,
-2.362862542596465e-15,
-3.487411446204668e-16,
-0.0002518176598338937,
1.041702608049445e-9,
1.199299893367867e-9,
9.20489693420057e-10,
5.29868411688327e-10,
2.440060070260159e-10,
9.36350752063291e-11,
3.079664612517772e-11,
8.86183220319755e-12,
2.266133250687334e-12,
5.212897408913666e-13,
1.089068023261341e-13,
2.08108407261961e-14,
3.657467769896408e-15,
6.040289620618524e-16,
8.93552273260951e-17,
0.00005974195355031009,
-2.339125793192052e-10,
-2.693008438389042e-10,
-2.066945544551798e-10,
-1.189812440759207e-10,
-5.47913166119654e-11,
-2.102573889816671e-11,
-6.91542851415734e-12,
-1.989963627521769e-12,
-5.088841819646898e-13,
-1.170675446628073e-13,
-2.446020547332725e-14,
-4.67508978231654e-15,
-8.22005337620733e-16,
-1.35895653847528e-16,
-2.014412151923348e-17,
-0.00001263128911584707,
4.69433147378547e-11,
5.40453049737481e-11,
4.148102301021612e-11,
2.387807220030248e-11,
1.099596010866905e-11,
4.219626525067847e-12,
1.387856291673573e-12,
3.993703815927506e-13,
1.021316381724987e-13,
2.349628233721764e-14,
4.90981844016283e-15,
9.38599638059327e-16,
1.650966011055972e-16,
2.731955521826781e-17,
4.056943696118551e-18,
2.409240559362163e-6,
-8.52064840606048e-12,
-9.8097273991598e-12,
-7.52919551438282e-12,
-4.33409748846684e-12,
-1.995874214299622e-12,
-7.65905554755309e-13,
-2.519115570231464e-13,
-7.24910222872783e-14,
-1.853865530090934e-14,
-4.265168889506737e-15,
-8.91334865193806e-16,
-1.704246183320365e-16,
-2.998786194509384e-17,
-4.966426480871686e-18,
-7.387065298896906e-19,
-4.18648033608736e-7,
1.412272912788526e-12,
1.625934292690665e-12,
1.247943035291353e-12,
7.18364946810806e-13,
3.308111686784668e-13,
1.269472492501087e-13,
4.17540230570258e-14,
1.201541506354445e-14,
3.072850456552067e-15,
7.06995644972768e-16,
1.477597386971371e-16,
2.825638927631595e-17,
4.973573254518842e-18,
8.24319106161508e-19,
1.228071717361372e-19,
6.680715571962686e-8,
-2.154262081615089e-13,
-2.480178622862597e-13,
-1.903596304994703e-13,
-1.095785297229138e-13,
-5.04615969118278e-14,
-1.936444710511236e-14,
-6.36915904480836e-15,
-1.832848070907389e-15,
-4.687453395850075e-16,
-1.078519480107809e-16,
-2.254232977939311e-17,
-4.311437401322269e-18,
-7.59113061604757e-19,
-1.259005080691098e-19,
-1.877179853569675e-20,
-9.86013944946147e-9,
3.04505948848589e-14,
3.505744489213165e-14,
2.69074328464191e-14,
1.54889901841074e-14,
7.13278400627202e-15,
2.73718454396326e-15,
9.00290900395629e-16,
2.590781654649089e-16,
6.62595528074915e-17,
1.524592867602564e-17,
3.186769301446558e-18,
6.095811453774979e-19,
1.074080403952579e-19,
1.782027588907594e-20,
2.610328390102486e-21,
1.374724881875941e-9,
-4.06847047248987e-15,
-4.68398719863167e-15,
-3.595073795840764e-15,
-2.069468684967655e-15,
-9.53005150229424e-16,
-3.657135856706435e-16,
-1.202877930239127e-16,
-3.461568037746428e-17,
-8.85313806651268e-18,
-2.037117434630383e-18,
-4.258386067692415e-19,
-8.14666158932286e-20,
-1.434477486457806e-20,
-2.382481852878323e-21,
-3.631453403011232e-22,
-1.760852254525408e-10,
5.00882976044306e-16,
5.76661356334575e-16,
4.426016747202778e-16,
2.547793878433331e-16,
1.173278339629122e-16,
4.502437043704108e-17,
1.480913272923939e-17,
4.261710506334652e-18,
1.089964989726284e-18,
2.508091025582025e-19,
5.245315208152325e-20,
1.003478852453822e-20,
1.715714033871173e-21,
2.904171729674563e-22,
9.4782947052109e-23,
// [{0,0.00001},{2.,0.0001}]: m=13
0.0146293109997446,
-9.14667536817479e-8,
-1.053043703692615e-7,
-8.08231372717228e-8,
-4.65244395818058e-8,
-2.14242847572448e-8,
-8.2210968143633e-9,
-2.70374286353188e-9,
-7.77905767949709e-10,
-1.988711681207346e-10,
-4.572259904942e-11,
-9.54192284305207e-12,
-1.819407926698415e-12,
-3.18346822679543e-13,
-5.20291104877376e-14,
-7.53988271157442e-15,
-0.02711296050754183,
1.562344833978404e-7,
1.798706242085926e-7,
1.380543138706171e-7,
7.94687334308008e-8,
3.6595122004448e-8,
1.404268271306281e-8,
4.61841138441593e-9,
1.328825774742209e-9,
3.397352021434434e-10,
7.81187180136973e-11,
1.630690248548328e-11,
3.110916672963564e-12,
5.44897401375018e-13,
8.92775560001175e-14,
1.300230675212739e-14,
0.02525941142678132,
-1.349645711459983e-7,
-1.553829304264348e-7,
-1.192596177302713e-7,
-6.86499859565887e-8,
-3.161322640016833e-8,
-1.213105655084491e-8,
-3.989762129744319e-9,
-1.147979483716631e-9,
-2.935148256000691e-10,
-6.74980959301391e-11,
-1.409295487301308e-11,
-2.689720538805493e-12,
-4.715396553378429e-13,
-7.74204365959753e-14,
-1.132239529222631e-14,
-0.01576152888717417,
7.84993691605698e-8,
9.03753207749521e-8,
6.93649807179573e-8,
3.9928954195082e-8,
1.838728281059255e-8,
7.05585853726326e-9,
2.320615824331341e-9,
6.67729235883719e-10,
1.707325645666414e-10,
3.926612420288862e-11,
8.19991256531555e-12,
1.5655804472616e-12,
2.746725877109598e-13,
4.517814769383647e-14,
6.63041847482066e-15,
0.00740639918628061,
-3.45404954114323e-8,
-3.97660434717311e-8,
-3.05213031206504e-8,
-1.756917139917256e-8,
-8.09062336370367e-9,
-3.104677268295517e-9,
-1.021113890066835e-9,
-2.938190869449898e-10,
-7.5129992844421e-11,
-1.728024224730806e-11,
-3.609199051439538e-12,
-6.89312864986432e-13,
-1.210153924488527e-13,
-1.993529935224244e-14,
-2.934596227869022e-15,
-0.002794301832436131,
1.225154905984561e-8,
1.41050601513581e-8,
1.082594630364039e-8,
6.23181497194307e-9,
2.869764129550889e-9,
1.101241518446214e-9,
3.621963683747647e-10,
1.042215435185245e-10,
2.665054110609564e-11,
6.13017595407511e-12,
1.280545392394147e-12,
2.446370910538354e-13,
4.297290399432306e-14,
7.08858762772927e-15,
1.046223433758344e-15,
0.000881361809426337,
-3.6459591281934e-9,
-4.19754962681096e-9,
-3.221713926988178e-9,
-1.854539440919494e-9,
-8.54021024595821e-10,
-3.277227632239808e-10,
-1.077882614387235e-10,
-3.101641271136454e-11,
-7.93146637745006e-12,
-1.824514093130024e-12,
-3.811738081430112e-13,
-7.2837942541953e-14,
-1.28011371961984e-14,
-2.114101367377049e-15,
-3.127432941299107e-16,
-0.0002389678150552966,
9.35650319615187e-10,
1.077203378047753e-9,
8.26778219887e-10,
4.75924977493118e-10,
2.191652669956059e-10,
8.41029558028632e-11,
2.766171412576607e-11,
7.95985452998308e-12,
2.03553673294732e-12,
4.68270179822164e-13,
9.78408221385363e-14,
1.870035917618978e-14,
3.28802135754259e-15,
5.435826166697702e-16,
8.0576487638473e-17,
0.000056840800924387,
-2.112449160645598e-10,
-2.432038720873827e-10,
-1.866646033199489e-10,
-1.074513247712527e-10,
-4.94818204290947e-11,
-1.898831933981255e-11,
-6.24535330496856e-12,
-1.797166714991096e-12,
-4.595923712181532e-13,
-1.057332703888292e-13,
-2.209418296106067e-14,
-4.223698367656598e-15,
-7.42934686255997e-16,
-1.229379967171182e-16,
-1.825626452642562e-17,
-0.00001204619368530222,
4.260321708372e-11,
4.90486082750554e-11,
3.764595552803757e-11,
2.16704747529841e-11,
9.97936522795181e-12,
3.829525531321329e-12,
1.259557047539086e-12,
3.624548991782701e-13,
9.26932222175022e-14,
2.132583195549161e-14,
4.456671711613639e-15,
8.52122591249472e-16,
1.499392292881743e-16,
2.483211851744206e-17,
3.693521778995972e-18,
2.302564805211842e-6,
-7.76750265747842e-12,
-8.94264049462302e-12,
-6.86368814075172e-12,
-3.951008040209786e-12,
-1.819461811220047e-12,
-6.98210018039173e-13,
-2.296471752170461e-13,
-6.60847967787484e-14,
-1.690068108280362e-14,
-3.888476870185914e-15,
-8.12678690397459e-16,
-1.554101656342762e-16,
-2.735476755532333e-17,
-4.533764848494669e-18,
-6.753311364045834e-19,
-4.008946289833196e-7,
1.292698783388895e-12,
1.488270120838068e-12,
1.142282848916412e-12,
6.5754317135733e-13,
3.028027348272671e-13,
1.161994051989388e-13,
3.821913890932613e-14,
1.099829267167908e-14,
2.812780036642952e-15,
6.47182562118369e-16,
1.352688025438562e-16,
2.587146220112595e-17,
4.55515873063446e-18,
7.554833397968588e-19,
1.126657152270933e-19,
6.408895121588519e-8,
-1.979237069806067e-13,
-2.278674514071006e-13,
-1.748937541042234e-13,
-1.006758116214603e-13,
-4.636188740199847e-14,
-1.779123572106636e-14,
-5.85173829973277e-15,
-1.683964174463609e-15,
-4.306758369397489e-16,
-9.90959446537276e-17,
-2.071359338044696e-17,
-3.962195653839004e-18,
-6.97806197639684e-19,
-1.158054099457362e-19,
-1.729039153595065e-20,
-9.47459908077048e-9,
2.807278806909172e-14,
3.231990509436386e-14,
2.480631100441724e-14,
1.427950749024103e-14,
6.57581530582125e-15,
2.52345423099166e-15,
8.29995720520719e-16,
2.388510113118864e-16,
6.108734923387729e-17,
1.405626107697749e-17,
2.93831395717183e-18,
5.621197772293763e-19,
9.89793432804607e-20,
1.644230386478487e-20,
2.502068152537289e-21,
1.323045724111841e-9,
-3.76297311855181e-15,
-4.33227178179472e-15,
-3.325124401249924e-15,
-1.914075813397446e-15,
-8.81446382944943e-16,
-3.382536550477469e-16,
-1.112562620868301e-16,
-3.201686382564679e-17,
-8.18859100716539e-18,
-1.884256555053259e-18,
-3.939057547711249e-19,
-7.53662049234513e-20,
-1.327581022292812e-20,
-2.205691072284636e-21,
-3.339120094730368e-22,
-1.697042612142781e-10,
4.64624385107586e-16,
5.34917271426196e-16,
4.105621520129466e-16,
2.363362397968911e-16,
1.088347118469272e-16,
4.176521499898875e-17,
1.373719485821352e-17,
3.953257963771483e-18,
1.01109661042451e-18,
2.326663776037686e-19,
4.862322287099137e-20,
9.30666345436323e-21,
1.687185622591723e-21,
2.736895899895075e-22,
-7.720305188852785e-24,
// [{0,0.00001},{2.,0.0001}]: m=14
0.01355648025377091,
-7.81172416989202e-8,
-8.99353121042963e-8,
-6.90271569353085e-8,
-3.97343667154004e-8,
-1.829756100222399e-8,
-7.0213413565314e-9,
-2.30920569220796e-9,
-6.64412887371104e-10,
-1.698676010717217e-10,
-3.90593590068487e-11,
-8.15345124274164e-12,
-1.555458336481782e-12,
-2.72448700687509e-13,
-4.46387780000588e-14,
-6.50115337606369e-15,
-0.02525941142678132,
1.349645711459982e-7,
1.553829304264348e-7,
1.192596177302713e-7,
6.86499859565887e-8,
3.16132264001683e-8,
1.213105655084491e-8,
3.98976212974432e-9,
1.147979483716631e-9,
2.935148256000691e-10,
6.74980959301391e-11,
1.409295487301308e-11,
2.689720538805493e-12,
4.71539655337843e-13,
7.74204365959753e-14,
1.132239529222632e-14,
0.02364229333076126,
-1.177490537408548e-7,
-1.355629811624282e-7,
-1.04047471076936e-7,
-5.98934312926231e-8,
-2.758092421588883e-8,
-1.058378780589489e-8,
-3.480923736497011e-9,
-1.001593853825579e-9,
-2.560988468499621e-10,
-5.88991863043329e-11,
-1.229986884797332e-11,
-2.3483706708924e-12,
-4.120088815664392e-13,
-6.77672215407547e-14,
-9.94562771223152e-15,
-0.01481279837256203,
6.90809908228668e-8,
7.95320869434647e-8,
6.10426062413027e-8,
3.513834279834621e-8,
1.618124672740786e-8,
6.20935453659123e-9,
2.042227780133734e-9,
5.87638173889998e-10,
1.502599856888466e-10,
3.45604844946172e-11,
7.2183981028793e-12,
1.378625729972909e-12,
2.420307848977133e-13,
3.987059870448504e-14,
5.869192455737652e-15,
0.00698575458109005,
-3.06288726496133e-8,
-3.52626503783944e-8,
-2.706486575910036e-8,
-1.557953742985731e-8,
-7.17441032387705e-9,
-2.753103796115471e-9,
-9.05490920936891e-10,
-2.605538587963053e-10,
-6.66263527652376e-11,
-1.532543988518742e-11,
-3.201363480985277e-12,
-6.11592727634577e-13,
-1.074322599858426e-13,
-1.772146906932023e-14,
-2.615558584359082e-15,
-0.002644085428239684,
1.093787738447643e-8,
1.259264888031339e-8,
9.66514178087282e-9,
5.56361832270569e-9,
2.562063073763152e-9,
9.83168289662613e-10,
3.23364784313102e-10,
9.30492381332105e-11,
2.379439913212433e-11,
5.473542279338107e-12,
1.143521424418161e-12,
2.185138276237533e-13,
3.840341158823905e-14,
6.342304102098342e-15,
9.38229882375272e-16,
0.000836387352700987,
-3.27477611867212e-9,
-3.77021182318898e-9,
-2.893723769621265e-9,
-1.665737421235563e-9,
-7.67078434489064e-10,
-2.943603453117266e-10,
-9.68159994407422e-11,
-2.785949085510219e-11,
-7.12437856535682e-12,
-1.638945629387091e-12,
-3.424428774872665e-13,
-6.54512571169975e-14,
-1.150807475046825e-14,
-1.902539158406839e-15,
-2.820177077275495e-16,
-0.0002273632045217339,
8.44979666433221e-10,
9.72815490853565e-10,
7.46658415201703e-10,
4.298053001913394e-10,
1.979272822258523e-10,
7.59532775547605e-11,
2.498141328418065e-11,
7.18866687847046e-12,
1.838369489605765e-12,
4.229330826443952e-13,
8.83767320721681e-14,
1.689479351451736e-14,
2.97173875224515e-15,
4.917519878189265e-16,
7.302505872099295e-17,
0.00005420787149021083,
-1.917144766382247e-10,
-2.207187369631495e-10,
-1.694067996654067e-10,
-9.7517136267105e-11,
-4.490714346991266e-11,
-1.723286486950567e-11,
-5.6680067068737e-12,
-1.631047044272781e-12,
-4.171194994607345e-13,
-9.59662436801344e-14,
-2.005502267218454e-14,
-3.834551656223781e-15,
-6.74726543739943e-16,
-1.117445327803489e-16,
-1.662083511916795e-17,
-0.00001151281523321886,
3.88374900838401e-11,
4.4713175759102e-11,
3.431842020009329e-11,
1.975502839830254e-11,
9.09730362083795e-12,
3.491048004416178e-12,
1.148235190039438e-12,
3.304237864637772e-13,
8.45033549188517e-14,
1.944237273169939e-14,
4.063391020423853e-15,
7.7705036131623e-16,
1.367737610615704e-16,
2.266881260105212e-17,
3.376648435158583e-18,
2.204921058806342e-6,
-7.10984483523894e-12,
-8.18548742216857e-12,
-6.28255701801062e-12,
-3.616488218987962e-12,
-1.66541539914527e-12,
-6.39096865821417e-13,
-2.102053091383545e-13,
-6.04906226835729e-14,
-1.547029351708236e-14,
-3.559504856547666e-15,
-7.4397860703229e-16,
-1.422930715953771e-16,
-2.505329434460607e-17,
-4.155160349473616e-18,
-6.197470935082611e-19,
-3.845835939955996e-7,
1.187673887309078e-12,
1.367356270479662e-12,
1.049478852235074e-12,
6.04121832647507e-13,
2.782021613896428e-13,
1.06759248004065e-13,
3.511432208128328e-14,
1.010490516595591e-14,
2.584341506716519e-15,
5.946415914523316e-16,
1.242953533328738e-16,
2.377581801400121e-17,
4.187277575424234e-18,
6.949033013050658e-19,
1.037790213994504e-19,
6.158300489693699e-8,
-1.824683110700086e-13,
-2.100738438211672e-13,
-1.612367699842989e-13,
-9.28143513232847e-14,
-4.274167245617458e-14,
-1.640202000288554e-14,
-5.394829925087337e-15,
-1.552490634859748e-15,
-3.970573206563204e-16,
-9.13632876210765e-17,
-1.909843025847751e-17,
-3.653681680835663e-18,
-6.436213189019236e-19,
-1.068732145178601e-19,
-1.598318271471571e-20,
-9.11803769048186e-9,
2.596270885245738e-14,
2.989059636691113e-14,
2.2941762612806e-14,
1.32062043833765e-14,
6.08155682471773e-15,
2.333787706474226e-15,
7.67614686424205e-16,
2.209009178586428e-16,
5.649731214768575e-17,
1.300045156422843e-17,
2.717734648998845e-18,
5.199772204886534e-19,
9.16415930894902e-20,
1.522853983126331e-20,
2.256539826295124e-21,
1.275107162118632e-9,
-3.49060487684232e-15,
-4.018697461345905e-15,
-3.084449067458325e-15,
-1.775534086022244e-15,
-8.17647522956954e-16,
-3.137714445680023e-16,
-1.032040571951261e-16,
-2.9699823509469e-17,
-7.59608565162711e-18,
-1.747961866417588e-18,
-3.654280931016107e-19,
-6.992358599937881e-20,
-1.23302604724955e-20,
-2.049861064388107e-21,
-2.989636695271795e-22,
-1.637691279331433e-10,
4.32161590052975e-16,
4.97543235635115e-16,
3.818767315895077e-16,
2.198238286634412e-16,
1.012306904060007e-16,
3.884723654774419e-17,
1.277746711629213e-17,
3.677091769887316e-18,
9.40469274238664e-19,
2.164179300591965e-19,
4.525606925672435e-20,
8.66535145473227e-21,
1.504850035988425e-21,
2.464647303040488e-22,
5.913287286551328e-23,
// [{0,0.00001},{2.,0.0001}]: m=15
0.01262970571339066,
-6.74822855729991e-8,
-7.76914652132174e-8,
-5.96298088651356e-8,
-3.43249929782943e-8,
-1.580661320008417e-8,
-6.06552827542245e-9,
-1.994881064872159e-9,
-5.73989741858316e-10,
-1.467574128000346e-10,
-3.37490479650696e-11,
-7.04647743650654e-12,
-1.344860269402746e-12,
-2.357698276689214e-13,
-3.87102182979877e-14,
-5.66119764611316e-15,
-0.02364229333076126,
1.177490537408548e-7,
1.355629811624281e-7,
1.040474710769359e-7,
5.98934312926231e-8,
2.758092421588882e-8,
1.058378780589489e-8,
3.48092373649701e-9,
1.001593853825579e-9,
2.560988468499621e-10,
5.88991863043329e-11,
1.229986884797332e-11,
2.3483706708924e-12,
4.12008881566439e-13,
6.77672215407547e-14,
9.94562771223153e-15,
0.02221919755884305,
-1.036214862343002e-7,
-1.192981304151971e-7,
-9.15639093619541e-8,
-5.27075141975193e-8,
-2.427187009111179e-8,
-9.31403180488684e-9,
-3.063341670200602e-9,
-8.81457260834997e-10,
-2.2538997853327e-10,
-5.18407267419258e-11,
-1.082759715431895e-11,
-2.067938594959363e-12,
-3.630461773465707e-13,
-5.98058980567276e-14,
-8.80378868360571e-15,
-0.01397150916218089,
6.12577452992286e-8,
7.05253007567912e-8,
5.41297315182025e-8,
3.115907485971564e-8,
1.434882064775458e-8,
5.50620759223112e-9,
1.810981841873841e-9,
5.21107717592628e-10,
1.332527055304795e-10,
3.065087977037586e-11,
6.40272696197076e-12,
1.223185455269192e-12,
2.14864519971693e-13,
3.544293813864285e-14,
5.231117168717256e-15,
0.00661021357059894,
-2.73446934611904e-8,
-3.14816222007827e-8,
-2.416285445218147e-8,
-1.390904580676389e-8,
-6.40515768440773e-9,
-2.457920724156473e-9,
-8.08411960782735e-10,
-2.326230953330207e-10,
-5.94859978303094e-11,
-1.368385569834493e-11,
-2.858803561045347e-12,
-5.462845690593761e-13,
-9.60085289705578e-14,
-1.585576025523944e-14,
-2.345574705977076e-15,
-0.002509162058064962,
9.82432835591959e-9,
1.131063546945552e-8,
8.68117130877828e-9,
4.99721226365746e-9,
2.301235303444523e-9,
8.8308103592648e-10,
2.904479983193651e-10,
8.35784725644831e-11,
2.137313569585985e-11,
4.916836888112795e-12,
1.027328632451678e-12,
1.963537713490823e-13,
3.452422425102103e-14,
5.707617475128772e-15,
8.4605312322787e-16,
0.000795771215833274,
-2.957428832534e-9,
-3.40485421800789e-9,
-2.613304453221631e-9,
-1.504318550678708e-9,
-6.92745487794637e-10,
-2.658364714432555e-10,
-8.74349464951565e-11,
-2.516033407479748e-11,
-6.43429321365883e-12,
-1.480265789264327e-12,
-3.093185622541282e-13,
-5.913177730100021e-14,
-1.040108563371638e-14,
-1.721131957548465e-15,
-2.55587704709622e-16,
-0.0002168314867571758,
7.66857908581026e-10,
8.8287495018756e-10,
6.77627200453769e-10,
3.900685461000502e-10,
1.796285743547252e-10,
6.89314596603326e-11,
2.267202688745957e-11,
6.52418819434782e-12,
1.668478002256694e-12,
3.838649757363557e-13,
8.02200909008073e-14,
1.533820666517524e-14,
2.698906183041837e-15,
4.469781327490499e-16,
6.648333956402625e-17,
0.0000518076684588974,
-1.747687051543457e-10,
-2.012092906592967e-10,
-1.54432890703425e-10,
-8.88976276789631e-11,
-4.093786624154984e-11,
-1.570971599983297e-11,
-5.16705834858611e-12,
-1.486907037190235e-12,
-3.802650966489308e-13,
-8.74906771802327e-14,
-1.828525957201429e-14,
-3.49672662352372e-15,
-6.154819154528167e-16,
-1.020096543682886e-16,
-1.51949265697513e-17,
-0.00001102459679834341,
3.55492025393252e-11,
4.09274122005333e-11,
3.141276597077154e-11,
1.808243008909742e-11,
8.32707192744147e-12,
3.195482384152132e-12,
1.051025905963798e-12,
3.02452929316442e-13,
7.73514204976747e-14,
1.779751344611571e-14,
3.719890772600106e-15,
7.11464926616731e-16,
1.252663863904386e-16,
2.07757863421134e-17,
3.098743750253839e-18,
2.115210346777698e-6,
-6.53220780707907e-12,
-7.52046113038983e-12,
-5.77213494814585e-12,
-3.322670805360166e-12,
-1.530112221879893e-12,
-5.87175992286022e-13,
-1.931288136346885e-13,
-5.557699055292234e-14,
-1.421388139651941e-14,
-3.270529472288141e-15,
-6.83624572787313e-16,
-1.307670146845885e-16,
-2.303008052184879e-17,
-3.821983139331391e-18,
-5.707359240693988e-19,
-3.69546230187744e-7,
1.094932623343795e-12,
1.260584391734736e-12,
9.67529093277675e-13,
5.56948549660075e-13,
2.564787896852157e-13,
9.84231547322171e-14,
3.23726090514876e-14,
9.3159883101238e-15,
2.382611076114251e-15,
5.482412054117432e-16,
1.146034213536379e-16,
2.192454347697152e-17,
3.862201546353065e-18,
6.413194129727535e-19,
9.58651561044819e-20,
5.926541762128847e-8,
-1.687531104506747e-13,
-1.942836989298232e-13,
-1.491174831571626e-13,
-8.58380409940064e-14,
-3.952906594746141e-14,
-1.516921584393051e-14,
-4.989362499042998e-15,
-1.435817703801241e-15,
-3.67222729409151e-16,
-8.45006687706981e-17,
-1.766486260706632e-17,
-3.379801742633804e-18,
-5.955129678158377e-19,
-9.89386690908656e-20,
-1.480748669401029e-20,
-8.7873098689133e-9,
2.408165991792115e-14,
2.772496708730422e-14,
2.127959351384305e-14,
1.224939767226121e-14,
5.64094462318789e-15,
2.164706942438325e-15,
7.1200399044558e-16,
2.048988181818841e-16,
5.240530512509865e-17,
1.205915911993345e-17,
2.521105629944072e-18,
4.824066352197457e-19,
8.499153245953e-20,
1.413327120333069e-20,
2.143878517843161e-21,
1.230517644937703e-9,
-3.24674707910193e-15,
-3.73794683438386e-15,
-2.868966591317841e-15,
-1.651494236094352e-15,
-7.60526750625149e-16,
-2.918518348449519e-16,
-9.59946579692345e-17,
-2.762528281489145e-17,
-7.06558027641213e-18,
-1.62592328863697e-18,
-3.399326416969031e-19,
-6.505328847543768e-20,
-1.146893583643801e-20,
-1.905302115973067e-21,
-2.831699690523324e-22,
-1.58234720425302e-10,
4.02983089898288e-16,
4.63950365460614e-16,
3.560934344393391e-16,
2.04981981063897e-16,
9.43959616530389e-17,
3.622446185068988e-17,
1.191482752335287e-17,
3.42886058599257e-18,
8.76994303888022e-19,
2.018161638503344e-19,
4.218367355259331e-20,
8.07755367558445e-21,
1.456820219946711e-21,
2.347672121424111e-22,
2.446222092424265e-25,
// [{0,0.00001},{2.,0.0001}]: m=16
0.01182114666538063,
-5.88745268704274e-8,
-6.77814905812141e-8,
-5.2023735538468e-8,
-2.99467156463115e-8,
-1.379046210794441e-8,
-5.29189390294745e-9,
-1.740461868248505e-9,
-5.00796926912789e-10,
-1.28049423424981e-10,
-2.94495931521665e-11,
-6.14993442398666e-12,
-1.1741853354462e-12,
-2.060044407832196e-13,
-3.38836107703774e-14,
-4.97281385611577e-15,
-0.02221919755884305,
1.036214862343001e-7,
1.192981304151971e-7,
9.15639093619541e-8,
5.27075141975193e-8,
2.427187009111178e-8,
9.31403180488684e-9,
3.063341670200601e-9,
8.81457260834997e-10,
2.253899785332699e-10,
5.18407267419258e-11,
1.082759715431895e-11,
2.067938594959363e-12,
3.630461773465707e-13,
5.98058980567276e-14,
8.80378868360572e-15,
0.02095726374327133,
-9.1886617948843e-8,
-1.057879511351868e-7,
-8.11945972773038e-8,
-4.67386122895735e-8,
-2.152323097163187e-8,
-8.25931138834669e-9,
-2.716472762810762e-9,
-7.81661576388942e-10,
-1.998790582957193e-10,
-4.59763196555638e-11,
-9.60409044295615e-12,
-1.834778182903789e-12,
-3.222967799575399e-13,
-5.316440720796429e-14,
-7.84667575307552e-15,
-0.01322042714119864,
5.46893869223827e-8,
6.29632444015676e-8,
4.83257089043646e-8,
2.781809161352873e-8,
1.281031536881589e-8,
4.91584144831312e-9,
1.616823921565526e-9,
4.65246190666057e-10,
1.189719956606228e-10,
2.736771139669081e-11,
5.71760712209089e-12,
1.09256913811879e-12,
1.920170579411226e-13,
3.171152051047945e-14,
4.691149411953844e-15,
0.006272905145162142,
-2.45608208897984e-8,
-2.827658867363807e-8,
-2.170292827194514e-8,
-1.249303065914334e-8,
-5.75308825861116e-9,
-2.207702589816145e-9,
-7.26119995798394e-10,
-2.089461814112025e-10,
-5.34328392396483e-11,
-1.229209222028168e-11,
-2.568321581129133e-12,
-4.908844283726948e-13,
-8.63105606275402e-14,
-1.426904368782044e-14,
-2.115132808080358e-15,
-0.002387313647463065,
8.87228649751156e-9,
1.021456265391953e-8,
7.83991335958496e-9,
4.51295565199011e-9,
2.078236463362721e-9,
7.97509414321635e-10,
2.623048394827951e-10,
7.54810022236228e-11,
1.930287964077964e-11,
4.440797367747681e-12,
9.27955686752919e-13,
1.773953319011738e-13,
3.120325690080893e-14,
5.16339587261211e-15,
7.66763114144875e-16,
0.000758910203657092,
-2.6840026800502e-9,
-3.090062325675584e-9,
-2.371695201602868e-9,
-1.365239911358625e-9,
-6.28700010245429e-10,
-2.412601088126573e-10,
-7.93520941065996e-11,
-2.28346586803587e-11,
-5.83967300793458e-12,
-1.343527415085586e-12,
-2.807703181545715e-13,
-5.368372332839711e-14,
-9.44617164067124e-15,
-1.564423464674479e-15,
-2.326916885143574e-16,
-0.000207230674605888,
6.99074822513031e-10,
8.04837164819627e-10,
6.17731564488777e-10,
3.55590511680096e-10,
1.637514654102421e-10,
6.28388641697336e-11,
2.066823345039253e-11,
5.9476281648906e-12,
1.521060390721229e-12,
3.499627096702657e-13,
7.3141038486435e-14,
1.398690653231616e-14,
2.461927668914824e-15,
4.080386182749437e-16,
6.077970597791802e-17,
0.00004961068550482589,
-1.59971411218132e-10,
-1.841733546619743e-10,
-1.413574466839393e-10,
-8.13709352947138e-11,
-3.747182362456921e-11,
-1.437967070991248e-11,
-4.729616570662588e-12,
-1.36103818014713e-12,
-3.48081391785255e-13,
-8.00888104026479e-14,
-1.673950845358807e-14,
-3.201592166266469e-15,
-5.636987415154672e-16,
-9.34910377705865e-17,
-1.394434310678223e-17,
-0.00001057604351594217,
3.26610188118538e-11,
3.76022823687879e-11,
2.88606568703216e-11,
1.661334373985821e-11,
7.65055637217107e-12,
2.935878143515817e-12,
9.65643470229689e-13,
2.778847806868544e-13,
7.10693629700523e-14,
1.635263723341851e-14,
3.418120747324512e-15,
6.53834666295708e-16,
1.151503276230163e-16,
1.910990618610436e-17,
2.853681864565476e-18,
2.032504827477997e-6,
-6.02213076500321e-12,
-6.93321569336958e-12,
-5.32141119411672e-12,
-3.063217703014373e-12,
-1.410633656361464e-12,
-5.41327471176924e-13,
-1.780493893028274e-13,
-5.123794707837306e-14,
-1.310436382505355e-14,
-3.015327300980685e-15,
-6.30318971448685e-16,
-1.205850114160933e-16,
-2.124207474818375e-17,
-3.527262088160409e-18,
-5.272996039708701e-19,
-3.55639130761964e-7,
1.012633401169528e-12,
1.165834290827114e-12,
8.94806286879674e-13,
5.15086609036028e-13,
2.372012723974948e-13,
9.10256090185404e-14,
2.993956743414121e-14,
8.61588250761833e-15,
2.203586081843988e-15,
5.070614748887839e-16,
1.060011860328828e-16,
2.028111691368882e-17,
3.573497504306901e-18,
5.936907601732805e-19,
8.88390369613826e-20,
5.711574463521358e-8,
-1.565265768687907e-13,
-1.802074361455052e-13,
-1.383136354032001e-13,
-7.96189420811494e-14,
-3.666515327702863e-14,
-1.407021645026165e-14,
-4.627901383608457e-15,
-1.331806474822948e-15,
-3.406253262216629e-16,
-7.83824190058817e-17,
-1.638668524388626e-17,
-3.135572868734698e-18,
-5.52593758995813e-19,
-9.18489450237606e-20,
-1.376009300695039e-20,
-8.47970907747161e-9,
2.239768524719276e-14,
2.578622677530074e-14,
1.979156634715164e-14,
1.139283305937177e-14,
5.246493720171432e-15,
2.013339777907031e-15,
6.62219062087997e-16,
1.905729586741094e-16,
4.87418751569105e-17,
1.121642120426565e-17,
2.34502776028419e-18,
4.487577113520279e-19,
7.90940538604908e-20,
1.315604765948021e-20,
1.97896111870414e-21,
1.18893838002676e-9,
-3.027558166934984e-15,
-3.485597171653042e-15,
-2.675282446106886e-15,
-1.5400022669561e-15,
-7.09184263295754e-16,
-2.721495492352205e-16,
-8.95145119439685e-17,
-2.576057159598882e-17,
-6.588724901266713e-18,
-1.516224389990611e-18,
-3.170112762345134e-19,
-6.066861988549547e-20,
-1.069876476250194e-20,
-1.782118849111409e-21,
-2.644891857669804e-22,
-1.530618144796241e-10,
3.76660666708937e-16,
4.33645659818393e-16,
3.328338729034126e-16,
1.915928849125529e-16,
8.82302242565756e-17,
3.385840259621e-17,
1.113661988028257e-17,
3.20492356219612e-18,
8.19725292298265e-19,
1.886413819818227e-19,
3.943915677125963e-20,
7.55127373053468e-21,
1.340133677427794e-21,
2.197542791310605e-22,
2.54213968746448e-23,
// [{0,0.00001},{2.,0.0001}]: m=17
0.01110959877942152,
-5.18107431171501e-8,
-5.96490652075986e-8,
-4.5781954680977e-8,
-2.63537570987597e-8,
-1.213593504555589e-8,
-4.65701590244342e-9,
-1.531670835100301e-9,
-4.40728630417498e-10,
-1.12694989266635e-10,
-2.59203633709629e-11,
-5.41379857715948e-12,
-1.033969297479682e-12,
-1.815230886732854e-13,
-2.99029490283638e-14,
-4.40189434180286e-15,
-0.02095726374327133,
9.1886617948843e-8,
1.057879511351868e-7,
8.11945972773037e-8,
4.67386122895735e-8,
2.152323097163187e-8,
8.25931138834669e-9,
2.716472762810762e-9,
7.81661576388942e-10,
1.998790582957192e-10,
4.59763196555638e-11,
9.60409044295615e-12,
1.834778182903789e-12,
3.222967799575399e-13,
5.31644072079643e-14,
7.84667575307554e-15,
0.01983064071179797,
-8.2034080383574e-8,
-9.44448666023514e-8,
-7.24885633565469e-8,
-4.17271374202931e-8,
-1.921547305322384e-8,
-7.37376217246967e-9,
-2.42523588234829e-9,
-6.97869285999086e-10,
-1.784579934909343e-10,
-4.105156709503622e-11,
-8.57641068313634e-12,
-1.638853707178185e-12,
-2.880255869116839e-13,
-4.756728076571926e-14,
-7.03672411793088e-15,
-0.01254581029032503,
4.91216417795985e-8,
5.65531773472782e-8,
4.34058565438918e-8,
2.498606131828757e-8,
1.150617651722274e-8,
4.41540517963245e-9,
1.452239991596841e-9,
4.178923628224199e-10,
1.068656784793004e-10,
2.458418444056424e-11,
5.13664316225845e-12,
9.81768856745424e-13,
1.726211212550885e-13,
2.853808737564266e-14,
4.230265616158734e-15,
0.00596828411865741,
-2.218071624377831e-8,
-2.553640663479815e-8,
-1.959978339896188e-8,
-1.128238912997498e-8,
-5.19559115840667e-9,
-1.993773535804036e-9,
-6.5576209870697e-10,
-1.887025055590519e-10,
-4.825719910194784e-11,
-1.110199341936891e-11,
-2.319889216882232e-12,
-4.434883297529266e-13,
-7.80081422520281e-14,
-1.290848968152615e-14,
-1.916907785355508e-15,
-0.002276730610935684,
8.05200804006587e-9,
9.2701869769292e-9,
7.11508560473373e-9,
4.095719734032773e-9,
1.886100030716439e-9,
7.23780326430355e-10,
2.380562823172935e-10,
6.85039760403551e-11,
1.751901902361933e-11,
4.030582245214308e-12,
8.42310954454861e-13,
1.610511699835219e-13,
2.833851492165603e-14,
4.693270393942298e-15,
6.98075065599652e-16,
0.000725307361127371,
-2.446761878811198e-9,
-2.816930076886645e-9,
-2.162060475724498e-9,
-1.244566790888267e-9,
-5.731301289395e-10,
-2.19936024595469e-10,
-7.23388170768348e-11,
-2.081669857724976e-11,
-5.323711367558216e-12,
-1.224869483853772e-12,
-2.55993634704244e-13,
-4.89541728633342e-14,
-8.61674684105106e-15,
-1.428135164055639e-15,
-2.127289711019039e-16,
-0.0001984427427652148,
6.39885646648256e-10,
7.36693420692275e-10,
5.65429788304869e-10,
3.254837420821007e-10,
1.498872949142296e-10,
5.75186829992723e-11,
1.891846633515305e-11,
5.444152735697915e-12,
1.392325571005653e-12,
3.203552425001323e-13,
6.69580340000274e-14,
1.280636870019059e-14,
2.254794973137201e-15,
3.739641526360174e-16,
5.577737171936908e-17,
0.00004759219573671243,
-1.469745844573177e-10,
-1.692102704338648e-10,
-1.298729557432314e-10,
-7.47600467296517e-11,
-3.442750362885235e-11,
-1.321145162820027e-11,
-4.345395610237729e-12,
-1.250481511422949e-12,
-3.198121329388424e-13,
-7.35868674518454e-14,
-1.5381543341273e-14,
-2.942255995332894e-15,
-5.181764763403796e-16,
-8.59945768007655e-17,
-1.284156597495948e-17,
-0.0000101625161796157,
3.01106348808148e-11,
3.466605665657673e-11,
2.660703923065333e-11,
1.531607887887571e-11,
7.05316384425081e-12,
2.706635652967544e-12,
8.9024638639368e-13,
2.561895741985048e-13,
6.55217778959478e-14,
1.507662701545148e-14,
3.151592875341947e-15,
6.029246809033361e-16,
1.062103012425042e-16,
1.763629543338979e-17,
2.636502238461938e-18,
1.956015763405458e-6,
-5.56948496107445e-12,
-6.41209004400618e-12,
-4.92143568649538e-12,
-2.832976987887251e-12,
-1.3046072920783e-12,
-5.006409623835251e-13,
-1.646676579838961e-13,
-4.738736446722419e-14,
-1.211972617920517e-14,
-2.788838742284304e-15,
-5.830066622834306e-16,
-1.115461629488098e-16,
-1.965422234984527e-17,
-3.265305046141634e-18,
-4.886311335881094e-19,
-3.427396167560625e-7,
9.39266941387906e-13,
1.081368357733338e-12,
8.2997678663367e-13,
4.77768323572495e-13,
2.200160961973918e-13,
8.44309602239571e-14,
2.777058615249827e-14,
7.99175338209708e-15,
2.043985871687163e-15,
4.703483497882134e-16,
9.83313599553394e-17,
1.881557904900047e-17,
3.315962272602415e-18,
5.511706016379823e-19,
8.25492972021861e-20,
5.511639379696104e-8,
-1.455809998537674e-13,
-1.676059215468713e-13,
-1.286416871037378e-13,
-7.4051403506532e-14,
-3.410128292199674e-14,
-1.308635310300306e-14,
-4.30430698780436e-15,
-1.238690585822894e-15,
-3.168135873992887e-16,
-7.29047518311747e-17,
-1.524224147185622e-17,
-2.916860169284645e-18,
-5.141569751103382e-19,
-8.54981426147682e-20,
-1.280957113454036e-20,
-8.19289375255994e-9,
2.088420950197982e-14,
2.404377963789887e-14,
1.845419827448317e-14,
1.062299308258489e-14,
4.891979413133312e-15,
1.877297639732878e-15,
6.17474364043776e-16,
1.776973363566924e-16,
4.54492419769949e-17,
1.045895437700163e-17,
2.186763502970013e-18,
4.185088737314674e-19,
7.37658086314893e-20,
1.227528169599155e-20,
1.859826686707005e-21,
1.150074743808087e-9,
-2.82982201543597e-15,
-3.257945795291312e-15,
-2.500554756495964e-15,
-1.439422303908022e-15,
-6.62866749884623e-16,
-2.543755223249226e-16,
-8.36685525818308e-17,
-2.407833887307808e-17,
-6.158526228342047e-18,
-1.41725386216376e-18,
-2.963341481864194e-19,
-5.671700112583661e-20,
-9.9941031087521e-21,
-1.665335078403581e-21,
-2.575718289636711e-22,
-1.482161393505649e-10,
3.52833638178053e-16,
4.062138703155901e-16,
3.117793358349108e-16,
1.794730796729894e-16,
8.26489955697231e-17,
3.171664042848847e-17,
1.043218161597261e-17,
3.002212929431896e-18,
7.67886249736562e-19,
1.767150633492216e-19,
3.694194585285631e-20,
7.074409072333332e-21,
1.269903106075378e-21,
2.059076181191656e-22,
7.385789699388559e-24,
// [{0,0.00001},{2.,0.0001}]: m=18
0.01047863187163567,
-4.59433089744215e-8,
-5.28939755675934e-8,
-4.05972986386519e-8,
-2.33693061447867e-8,
-1.076161548581594e-8,
-4.12965569417334e-9,
-1.358236381405381e-9,
-3.90830788194471e-10,
-9.99395291478596e-11,
-2.298815982778189e-11,
-4.80204522147807e-12,
-9.17389091451894e-13,
-1.611483899787699e-13,
-2.658220360398214e-14,
-3.92333787653777e-15,
-0.01983064071179797,
8.2034080383574e-8,
9.44448666023514e-8,
7.24885633565469e-8,
4.17271374202931e-8,
1.921547305322384e-8,
7.37376217246967e-9,
2.42523588234829e-9,
6.97869285999086e-10,
1.784579934909343e-10,
4.10515670950362e-11,
8.57641068313634e-12,
1.638853707178185e-12,
2.880255869116839e-13,
4.75672807657193e-14,
7.03672411793082e-15,
0.01881871543548754,
-7.36824626693977e-8,
-8.48297660209173e-8,
-6.51087848158378e-8,
-3.74790919774314e-8,
-1.725926477583411e-8,
-6.62310776944867e-9,
-2.178359987395261e-9,
-6.2683854423363e-10,
-1.602985177189506e-10,
-3.687627666084636e-11,
-7.70496474338768e-12,
-1.472653285118137e-12,
-2.589316818826331e-13,
-4.280713106346391e-14,
-6.3453984242378e-15,
-0.01193656823731554,
4.43614324875583e-8,
5.10728132695982e-8,
3.91995667979252e-8,
2.25647782599508e-8,
1.039118231681372e-8,
3.987547071608221e-9,
1.31152419741399e-9,
3.77405011118118e-10,
9.65143982038993e-11,
2.220398683873865e-11,
4.639778433764639e-12,
8.86976659505886e-13,
1.56016284504057e-13,
2.581697936305343e-14,
3.833815570716772e-15,
0.005691826527338964,
-2.013002010016412e-8,
-2.317546744232237e-8,
-1.778771401183383e-8,
-1.023929933508165e-8,
-4.71525007679097e-9,
-1.809450816075838e-9,
-5.95140705793217e-10,
-1.712599401008831e-10,
-4.379754755904712e-11,
-1.00764556130355e-11,
-2.105777386137099e-12,
-4.026279249587891e-13,
-7.084628730413e-14,
-1.173317598486011e-14,
-1.745187664007665e-15,
-0.002175922083347612,
7.34028563635406e-9,
8.45079023056837e-9,
6.48618142710321e-9,
3.733700372624343e-9,
1.719390386799868e-9,
6.59808073779257e-10,
2.170164512281529e-10,
6.24500957310725e-11,
1.597113410250155e-11,
3.674608451521475e-12,
7.6798090410435e-13,
1.468625185884172e-13,
2.585024052301987e-14,
4.284405492109268e-15,
6.381869131329446e-16,
0.0006945495996848134,
-2.23959976328356e-9,
-2.578426972439846e-9,
-1.979004259079998e-9,
-1.139193097294811e-9,
-5.24605532203239e-10,
-2.013153904987711e-10,
-6.62146321734692e-11,
-1.905453457506748e-11,
-4.873139498551697e-12,
-1.121243348757775e-12,
-2.34353119001637e-13,
-4.4822290451049e-14,
-7.89178240602411e-15,
-1.308874534144292e-15,
-1.952208010294923e-16,
-0.0001903687836698694,
5.87898339496101e-10,
6.76841083654464e-10,
5.1949182444581e-10,
2.990401877664605e-10,
1.37710014905854e-10,
5.28458066626348e-11,
1.738158249023407e-11,
5.001926059874738e-12,
1.279248535382896e-12,
2.943474706423084e-13,
6.15261735403584e-14,
1.176902401454519e-14,
2.072705909277376e-15,
3.439783084180013e-16,
5.136626626236793e-17,
0.00004573132272577522,
-1.354978567793068e-10,
-1.559972547423439e-10,
-1.197316763750317e-10,
-6.89223548611639e-11,
-3.173923725594352e-11,
-1.217986042178158e-11,
-4.006108733320559e-12,
-1.152853082324503e-12,
-2.948480001307128e-13,
-6.78448214774655e-14,
-1.418216791882608e-14,
-2.713161059641313e-15,
-4.779463572439185e-16,
-7.93633300819411e-17,
-1.186425759303183e-17,
-9.78007110346992e-6,
2.78474070229288e-11,
3.206042974727862e-11,
2.460716271912378e-11,
1.416487589417784e-11,
6.52303229496491e-12,
2.503203213428925e-12,
8.23337764146142e-13,
2.369366710265486e-13,
6.05985921955726e-14,
1.394418480412206e-14,
2.915031444353124e-15,
5.577304602126408e-16,
9.82710621578136e-17,
1.632651253352224e-17,
2.443139218497201e-18,
1.885068420167596e-6,
-5.16596935761595e-12,
-5.94752732603566e-12,
-4.56487336917006e-12,
-2.62772637986158e-12,
-1.210088805489452e-12,
-4.643703873022344e-13,
-1.527382587276414e-13,
-4.395465364218622e-14,
-1.124192486033806e-14,
-2.58691651393935e-15,
-5.408226135132353e-16,
-1.034857108412305e-16,
-1.823777038107218e-17,
-3.031436625035196e-18,
-4.54049180484532e-19,
-3.307421261579287e-7,
8.73586888101665e-13,
1.005751681770877e-12,
7.7193927258446e-13,
4.443597394585031e-13,
2.046313301468341e-13,
7.85271876693993e-14,
2.582882491016176e-14,
7.43300197232941e-15,
1.901101093938638e-15,
4.374790460955488e-16,
9.14640307898959e-17,
1.750317432308813e-17,
3.085254026805515e-18,
5.130586391139432e-19,
7.69163060846972e-20,
5.325214525958733e-8,
-1.357436428135815e-13,
-1.562802860563141e-13,
-1.199490025554983e-13,
-6.9047563346671e-14,
-3.179699504386689e-14,
-1.220210035604655e-14,
-4.013473406741357e-15,
-1.155001041671167e-15,
-2.954119876714059e-16,
-6.79813411397215e-17,
-1.421352957619666e-17,
-2.720232122899651e-18,
-4.795779276695352e-19,
-7.97876756707459e-20,
-1.196847128884856e-20,
-7.924827842138691e-9,
1.951898712281232e-14,
2.247201468592252e-14,
1.724783237718278e-14,
9.92856258852489e-15,
4.572191137983991e-15,
1.754581096867533e-15,
5.771123311398884e-16,
1.660827643825234e-16,
4.247904582333e-17,
9.77563533485847e-18,
2.043968788312721e-18,
3.91230426717934e-19,
6.89980051154902e-20,
1.146399326253157e-20,
1.705413737765658e-21,
1.113669316213229e-9,
-2.650829683296406e-15,
-3.05187393982637e-15,
-2.342389809868058e-15,
-1.348376447836094e-15,
-6.20939694462901e-16,
-2.382862726987814e-16,
-7.83767039518415e-17,
-2.255554563627526e-17,
-5.769095973295958e-18,
-1.327658030206355e-18,
-2.776099780178295e-19,
-5.314343692859557e-20,
-9.36915002566649e-21,
-1.554365849439767e-21,
-2.36905828751522e-22,
-1.436676203002864e-10,
3.31196475638161e-16,
3.813032460827856e-16,
2.926598475476703e-16,
1.684671583876007e-16,
7.75807112775786e-17,
2.977171418872201e-17,
9.79248189471393e-18,
2.818128906826917e-18,
7.20806659520934e-19,
1.658909205824334e-19,
3.469319536593594e-20,
6.623206134051955e-21,
1.152784251106269e-21,
2.130170506449782e-22,
5.055732197831876e-23,
// [{0,0.00001},{2.,0.0001}]: m=19
0.00991532035589898,
-4.1017040191787e-8,
-4.72224333011757e-8,
-3.62442816782735e-8,
-2.08635687101465e-8,
-9.60773652661192e-9,
-3.68688108623484e-9,
-1.212617941174145e-9,
-3.48934642999543e-10,
-8.92289967454671e-11,
-2.052578354751811e-11,
-4.28820534156817e-12,
-8.19426853589093e-13,
-1.440127934558419e-13,
-2.378364038285963e-14,
-3.51836205896541e-15,
-0.01881871543548754,
7.36824626693977e-8,
8.48297660209173e-8,
6.51087848158378e-8,
3.74790919774314e-8,
1.725926477583411e-8,
6.62310776944867e-9,
2.178359987395261e-9,
6.2683854423363e-10,
1.602985177189506e-10,
3.68762766608464e-11,
7.70496474338768e-12,
1.472653285118136e-12,
2.58931681882633e-13,
4.280713106346392e-14,
6.34539842423783e-15,
0.01790485235597331,
-6.65421487313374e-8,
-7.66092199043973e-8,
-5.87993501968879e-8,
-3.38471673899262e-8,
-1.558677347522058e-8,
-5.98132060741233e-9,
-1.967286296120985e-9,
-5.66107516677177e-10,
-1.447715973058489e-10,
-3.330598025810797e-11,
-6.95966765064696e-12,
-1.33046498925883e-12,
-2.340244267560853e-13,
-3.872546904457995e-14,
-5.75072335607533e-15,
-0.01138365305467862,
4.02600402003298e-8,
4.63509348846465e-8,
3.5575428023669e-8,
2.04785986701641e-8,
9.4305001535823e-9,
3.618901632151816e-9,
1.190281411586481e-9,
3.425198802017795e-10,
8.75950951180976e-11,
2.015291122607177e-11,
4.21155477227436e-12,
8.05255849917611e-13,
1.416925746082688e-13,
2.346635196971879e-14,
3.490375328011924e-15,
0.005439805208368792,
-1.835071409088463e-8,
-2.112697557642032e-8,
-1.621545356775757e-8,
-9.33425093156059e-9,
-4.29847596699955e-9,
-1.649520184448096e-9,
-5.42541128070367e-10,
-1.561252393276769e-10,
-3.992783525625276e-11,
-9.18652112880343e-12,
-1.919952260260818e-12,
-3.671562964710186e-13,
-6.46256013075501e-14,
-1.071101373028739e-14,
-1.595467282832494e-15,
-0.002083648799020967,
6.71879928977588e-9,
7.73528091723342e-9,
5.93701277717389e-9,
3.417579291846383e-9,
1.573816596592193e-9,
6.03946171489589e-10,
1.986438965181959e-10,
5.71636037245659e-11,
1.461941849549228e-11,
3.363730046235881e-12,
7.03059356997109e-13,
1.344668713515746e-13,
2.367534721772277e-14,
3.926623602470897e-15,
5.85662403169478e-16,
0.0006662907428509147,
-2.057644188250169e-9,
-2.368943792806531e-9,
-1.818221385572545e-9,
-1.04664065718964e-9,
-4.81985052173725e-10,
-1.849603233204636e-10,
-6.08355387162278e-11,
-1.750674120967917e-11,
-4.477369873870201e-12,
-1.030216147254859e-12,
-2.153416073926788e-13,
-4.119158405155676e-14,
-7.25447068266234e-15,
-1.203924079081851e-15,
-1.797819317078212e-16,
-0.0001829252916045912,
5.41991428684872e-10,
6.23989020774189e-10,
4.78926706885367e-10,
2.756894202420574e-10,
1.269569493909853e-10,
4.871944182804433e-11,
1.602443497963294e-11,
4.611412342637176e-12,
1.179392003934752e-12,
2.713792866946885e-13,
5.672867183918949e-14,
1.08526442710842e-14,
1.911785435294563e-15,
3.174533200175453e-16,
4.745702973679158e-17,
0.00004401031988550482,
-1.253133314294745e-10,
-1.442719336627687e-10,
-1.107322320825634e-10,
-6.37419414354429e-11,
-2.935364528665266e-11,
-1.126441444481554e-11,
-3.705019933521655e-12,
-1.066215018141056e-12,
-2.726936645019332e-13,
-6.27488315333347e-14,
-1.311764148233243e-14,
-2.509787062725731e-15,
-4.422197756787536e-16,
-7.346931129961391e-17,
-1.099413076590235e-17,
-9.42533461696537e-6,
2.582983006378265e-11,
2.973761737565822e-11,
2.282435206751914e-11,
1.313862339228473e-11,
6.05044010988102e-12,
2.321850433137741e-12,
7.63690799149134e-13,
2.197731259032757e-13,
5.620958790250164e-14,
1.29345741955667e-14,
2.704111317021152e-15,
5.174282109028901e-16,
9.11887900418053e-17,
1.515718234032976e-17,
2.270246928878301e-18,
1.819082206608985e-6,
-4.80472899634906e-12,
-5.53163552973277e-12,
-4.24566698164161e-12,
-2.443979132547878e-12,
-1.125472576237936e-12,
-4.31899632122213e-13,
-1.420585698783935e-13,
-4.088152031033806e-14,
-1.045605843755251e-14,
-2.406135298718427e-15,
-5.030522769579931e-16,
-9.62675121752915e-17,
-1.696892985012564e-17,
-2.821790257848593e-18,
-4.230054474189464e-19,
-3.195553318128451e-7,
8.14556742497059e-13,
9.37790957221295e-13,
7.19777860474043e-13,
4.143336448367426e-13,
1.908041966493027e-13,
7.32211315539507e-14,
2.408364593366764e-14,
6.93081363417724e-15,
1.772678436470088e-15,
4.079355634919646e-16,
8.5291114261294e-17,
1.632332361781147e-17,
2.877805996742205e-18,
4.787496354682876e-19,
7.181753424386334e-20,
5.150976496475303e-8,
-1.268699122707143e-13,
-1.460640613055025e-13,
-1.121078141368492e-13,
-6.45338744571077e-14,
-2.971842159871501e-14,
-1.140446214718382e-14,
-3.751126548321344e-15,
-1.079508145318659e-15,
-2.761061665625308e-16,
-6.35399121988443e-17,
-1.328546425675366e-17,
-2.542826962334894e-18,
-4.483689710272306e-19,
-7.462069209769759e-20,
-1.120762295363988e-20,
-7.67373259234005e-9,
1.828328316613355e-14,
2.104936264630737e-14,
1.615591382257241e-14,
9.30001207531722e-15,
4.282740604954294e-15,
1.6435062409141e-15,
5.405791628590293e-16,
1.555699029226576e-16,
3.979054583480593e-17,
9.15711761783094e-18,
1.914727818861098e-18,
3.664992246122683e-19,
6.461570365885436e-20,
1.076619238578081e-20,
1.637096151483827e-21,
1.079496192178807e-9,
-2.48828643271345e-15,
-2.864739705809654e-15,
-2.198759896609017e-15,
-1.265697481904316e-15,
-5.828655983610446e-16,
-2.236755465413333e-16,
-7.35711331720112e-17,
-2.117267424860109e-17,
-5.415444028574946e-18,
-1.246294794612859e-18,
-2.60603021063619e-19,
-4.988743588047087e-20,
-8.80436405317327e-21,
-1.464939179235139e-21,
-2.159752939997065e-22,
-1.393897559181534e-10,
3.114889903635243e-16,
3.586142354296515e-16,
2.752454961563789e-16,
1.584427760743491e-16,
7.29644269780789e-17,
2.800023723717278e-17,
9.20982857277109e-18,
2.650462630933545e-18,
6.779294768011252e-19,
1.560170501979678e-19,
3.261714626341141e-20,
6.251576632882246e-21,
1.12363534557216e-21,
1.768780469168181e-22,
4.746719255773233e-24,
// [{0,0.00001},{2.,0.0001}]: m=20
0.00940935771774377,
-3.68412313346989e-8,
-4.24148830104586e-8,
-3.25543924079189e-8,
-1.87395459887157e-8,
-8.62963238791705e-9,
-3.31155388472434e-9,
-1.08917999369763e-9,
-3.13419272116815e-10,
-8.01492588594753e-11,
-1.843813833042318e-11,
-3.85248237169384e-12,
-7.36326642559068e-13,
-1.294658409413165e-13,
-2.140356553173196e-14,
-3.17269921211891e-15,
-0.01790485235597331,
6.65421487313374e-8,
7.66092199043973e-8,
5.87993501968878e-8,
3.38471673899262e-8,
1.558677347522058e-8,
5.98132060741233e-9,
1.967286296120985e-9,
5.66107516677177e-10,
1.447715973058489e-10,
3.330598025810797e-11,
6.95966765064696e-12,
1.33046498925883e-12,
2.340244267560852e-13,
3.872546904457995e-14,
5.75072335607535e-15,
0.01707547958201794,
-6.03900603004947e-8,
-6.95264023269698e-8,
-5.33631420355036e-8,
-3.071789800524615e-8,
-1.414575023037345e-8,
-5.42835244822772e-9,
-1.785422117379721e-9,
-5.13779820302669e-10,
-1.313926426771465e-10,
-3.022936683910766e-11,
-6.31733215841154e-12,
-1.207883774876417e-12,
-2.12538861912403e-13,
-3.519952795457821e-14,
-5.235562992018107e-15,
-0.01087961041673826,
3.67014281817707e-8,
4.22539511528423e-8,
3.243090713551644e-8,
1.866850186312193e-8,
8.59695193399944e-9,
3.299040368896325e-9,
1.085082256140777e-9,
3.122504786553662e-10,
7.98556705125087e-11,
1.83730422576076e-11,
3.839904520521789e-12,
7.34312592942067e-13,
1.292512026151079e-13,
2.142202746057516e-14,
3.190934565662721e-15,
0.005209121997552186,
-1.67969982244392e-8,
-1.933820229308298e-8,
-1.48425319429343e-8,
-8.54394822961571e-9,
-3.934541491480369e-9,
-1.509865428723928e-9,
-4.96609741295475e-10,
-1.429090093114107e-10,
-3.654854623872964e-11,
-8.40932511558946e-12,
-1.757648392492716e-12,
-3.361671783789285e-13,
-5.91883680443209e-14,
-9.81655900617494e-15,
-1.464156007906931e-15,
-0.001998872228520239,
6.17293256468003e-9,
7.10683137833845e-9,
5.45466415665535e-9,
3.139921971533068e-9,
1.445955156504666e-9,
5.54880969955055e-10,
1.825066161465993e-10,
5.25202236284378e-11,
1.343210962145719e-11,
3.090648441729276e-12,
6.46024822170695e-13,
1.235747521532447e-13,
2.17634120476437e-14,
3.611772237220061e-15,
5.39345795202635e-16,
0.0006402385206222618,
-1.896970000410091e-9,
-2.183961572724675e-9,
-1.676243474110307e-9,
-9.64912970853834e-10,
-4.443493228715033e-10,
-1.705180463993274e-10,
-5.60855224291009e-11,
-1.613994319934108e-11,
-4.127872013799986e-12,
-9.49827503437962e-13,
-1.985503514386888e-13,
-3.79842549489959e-14,
-6.6912490231451e-15,
-1.111086620140165e-15,
-1.66099604535166e-16,
-0.0001760412802232244,
5.01253327194948e-10,
5.77087736351588e-10,
4.42928929635441e-10,
2.549677664930919e-10,
1.17414581492601e-10,
4.505765791203673e-11,
1.482007977775886e-11,
4.264860085132557e-12,
1.090774661222584e-12,
2.50995326873138e-13,
5.247056608345483e-14,
1.003914828070786e-14,
1.768879109263648e-15,
2.938772458242301e-16,
4.397652201866855e-17,
0.00004241400569848595,
-1.162342351230741e-10,
-1.338192780017104e-10,
-1.027095841589645e-10,
-5.91238051818871e-11,
-2.722698045606073e-11,
-1.044832693438224e-11,
-3.43660859132357e-12,
-9.88979065169745e-13,
-2.529431452048151e-13,
-5.820558379758683e-14,
-1.216850090729569e-14,
-2.328426946773889e-15,
-4.103495603131395e-16,
-6.820731926558444e-17,
-1.02161051918508e-17,
-9.09540376558367e-6,
2.402362922393996e-11,
2.765815950685521e-11,
2.122832098390935e-11,
1.221988764733093e-11,
5.62735919001494e-12,
2.159496744114375e-12,
7.10292383477546e-13,
2.044074674673063e-13,
5.228025789088209e-14,
1.203066860097278e-14,
2.515259738046952e-15,
4.813372433768556e-16,
8.48445851725969e-17,
1.410894395979879e-17,
2.115032957866042e-18,
1.757554823299827e-6,
-4.48006313307272e-12,
-5.1578514728109e-12,
-3.958779159849986e-12,
-2.278835580361898e-12,
-1.049423327372933e-12,
-4.027163178738488e-13,
-1.324600836615613e-13,
-3.811948391647417e-14,
-9.74973368181034e-15,
-2.243646127554654e-15,
-4.691012527564932e-16,
-8.97782929639826e-17,
-1.582789819455988e-17,
-2.633132904770772e-18,
-3.95036754935593e-19,
-3.090998222293608e-7,
7.6130887587225e-13,
8.76487295775103e-13,
6.72725884629681e-13,
3.872487223352357e-13,
1.783314715516816e-13,
6.84348094075927e-14,
2.250940266572524e-14,
6.4778096025151e-15,
1.656831581085843e-15,
3.81284252603567e-16,
7.97221391046195e-17,
1.525876120309315e-17,
2.690552727100838e-18,
4.477684484261009e-19,
6.723585922565072e-20,
4.987769126083403e-8,
-1.188380333784917e-13,
-1.368170496518693e-13,
-1.050105174557656e-13,
-6.04483962387709e-14,
-2.783703923877843e-14,
-1.068249327513473e-14,
-3.513666772662124e-15,
-1.011176229331082e-15,
-2.586313586561989e-16,
-5.951959766638939e-17,
-1.244533664126422e-17,
-2.382208542927149e-18,
-4.201178766069871e-19,
-6.994360792894199e-20,
-1.050763023673351e-20,
-7.438047178578824e-9,
1.716122929995456e-14,
1.97575545310738e-14,
1.516442080439575e-14,
8.72927012690648e-15,
4.019910959480468e-15,
1.542646806237132e-15,
5.074057874992749e-16,
1.46023795397537e-16,
3.734924746370501e-17,
8.59544981491374e-18,
1.797334039153257e-18,
3.440481174531097e-19,
6.070696866442153e-20,
1.012126076035663e-20,
1.496367499622789e-21,
1.047356305244603e-9,
-2.340238034040048e-15,
-2.694293215611191e-15,
-2.067938190851931e-15,
-1.190391387150912e-15,
-5.481867190935752e-16,
-2.103676940794333e-16,
-6.91940723032256e-17,
-1.991310458306133e-17,
-5.093319346624846e-18,
-1.172181362659948e-18,
-2.451164112292248e-19,
-4.692625837861557e-20,
-8.27766354244309e-21,
-1.377795651375181e-21,
-2.074477057037163e-22,
-1.353591030616356e-10,
2.934884972105077e-16,
3.378904639758835e-16,
2.593395091482234e-16,
1.492866637622242e-16,
6.87479825803465e-17,
2.638219452613871e-17,
8.67763976674966e-18,
2.497316016184957e-18,
6.387601947858151e-19,
1.470034122739783e-19,
3.074922501262052e-20,
5.898240023436667e-21,
1.017654965913443e-21,
1.580376594415134e-22,
4.890328076415335e-23,
// [{0,0.00001},{2.,0.0001}]: m=21
0.00895242617798665,
-3.32710743656687e-8,
-3.83046099521987e-8,
-2.93996750984439e-8,
-1.69235836949631e-8,
-7.79338673761029e-9,
-2.99066030370617e-9,
-9.83643148060492e-10,
-2.83053758338588e-10,
-7.23857986529245e-11,
-1.665299012905398e-11,
-3.47983382532348e-12,
-6.65232494629415e-13,
-1.170122133780426e-13,
-1.936273452228997e-14,
-2.87536167803768e-15,
-0.01707547958201794,
6.03900603004947e-8,
6.95264023269698e-8,
5.33631420355036e-8,
3.07178980052461e-8,
1.414575023037345e-8,
5.42835244822772e-9,
1.785422117379721e-9,
5.13779820302669e-10,
1.313926426771465e-10,
3.022936683910766e-11,
6.31733215841154e-12,
1.207883774876417e-12,
2.12538861912403e-13,
3.519952795457821e-14,
5.2355629920181e-15,
0.01631941562510739,
-5.50521422726561e-8,
-6.33809267292635e-8,
-4.86463607032747e-8,
-2.80027527946829e-8,
-1.289542790099916e-8,
-4.94856055334449e-9,
-1.627623384211166e-9,
-4.68375717983049e-10,
-1.197835057687631e-10,
-2.755956338641141e-11,
-5.75985678078268e-12,
-1.1014688894131e-12,
-1.938768039226625e-13,
-3.213304119086298e-14,
-4.786401848493465e-15,
-0.01041824399510503,
3.35939964488798e-8,
3.86764045861675e-8,
2.968506388586983e-8,
1.708789645923212e-8,
7.86908298296106e-9,
3.019730857447982e-9,
9.93219482590992e-10,
2.858180186228331e-10,
7.30970924774623e-11,
1.681865023117961e-11,
3.515296784985577e-12,
6.72334356757885e-13,
1.183767360886458e-13,
1.963311801235033e-14,
2.928312015814758e-15,
0.004997180571300372,
-1.54323314116996e-8,
-1.776707844584559e-8,
-1.363666039163798e-8,
-7.84980492883243e-9,
-3.614887891261556e-9,
-1.387202424887597e-9,
-4.562665403664846e-10,
-1.313005590710905e-10,
-3.358027405364198e-11,
-7.72662110432295e-12,
-1.615062055426702e-12,
-3.089368803831162e-13,
-5.440853011907391e-14,
-9.02943059303363e-15,
-1.348364488042133e-15,
-0.001920715561835194,
5.69091000116375e-9,
6.55188471809744e-9,
5.02873042227214e-9,
2.894738912527665e-9,
1.333047968598927e-9,
5.11554139192002e-10,
1.682565672853357e-10,
4.841982959745718e-11,
1.238361604125517e-11,
2.849482510280568e-12,
5.95651054309091e-13,
1.139527648456422e-13,
2.007374706921783e-14,
3.333259860395434e-15,
4.982988135818783e-16,
0.0006161444807873087,
-1.754386645194645e-9,
-2.019807077244751e-9,
-1.550251253734936e-9,
-8.92387182732092e-10,
-4.109510352269913e-10,
-1.577018026932367e-10,
-5.18702792225205e-11,
-1.492701029806883e-11,
-3.817711314305927e-12,
-8.78483644062274e-13,
-1.836469812931058e-13,
-3.513701898236752e-14,
-6.19107688321614e-15,
-1.028570360816106e-15,
-1.539178262679177e-16,
-0.0001696560234560031,
4.64936941886379e-10,
5.35277113611836e-10,
4.10838337867732e-10,
2.364952214366667e-10,
1.08907922150799e-10,
4.179330786284575e-11,
1.374643440651359e-11,
3.955916272541431e-12,
1.011772583853437e-12,
2.328223358885899e-13,
4.867400377528325e-14,
9.31370781527162e-15,
1.641398246015295e-15,
2.728292776243981e-16,
4.086442105241617e-17,
0.00004092931686939687,
-1.081063313527402e-10,
-1.244617176024103e-10,
-9.55274442906363e-11,
-5.49894943341516e-11,
-2.532311631876173e-11,
-9.71773533458233e-12,
-3.196315721066361e-12,
-9.19833602284263e-13,
-2.352611601710895e-13,
-5.413800862532839e-14,
-1.131866880795585e-14,
-2.166017596420744e-15,
-3.818006245803478e-16,
-6.349024258701094e-17,
-9.51765705633867e-18,
-8.78776705329337e-6,
2.240030079267706e-11,
2.578924024127355e-11,
1.979388265707935e-11,
1.139417033662492e-11,
5.24711315302088e-12,
2.01358025243505e-12,
6.62299978562179e-13,
1.905972930285414e-13,
4.874863603903749e-14,
1.121822318855121e-14,
2.345504705597459e-15,
4.488911644965694e-16,
7.91394389093319e-17,
1.316565812641096e-17,
1.975181994246561e-18,
1.700049506966896e-6,
-4.18719980930024e-12,
-4.82068126884648e-12,
-3.699993242041459e-12,
-2.129868477439085e-12,
-9.80823325905585e-13,
-3.763915409150488e-13,
-1.238017439921827e-13,
-3.562796125361914e-14,
-9.11257585808286e-15,
-2.097063894880253e-15,
-4.384718522456548e-16,
-8.3923179951002e-17,
-1.479808984613009e-17,
-2.462758585821495e-18,
-3.697470134282182e-19,
-2.993062211574183e-7,
7.13112580815713e-13,
8.20999444420645e-13,
6.30137667155429e-13,
3.627332986891992e-13,
1.670420011041916e-13,
6.41025447791192e-14,
2.108449554333649e-14,
6.06777538209739e-15,
1.551971804298625e-15,
3.571598499524043e-16,
7.46808586727616e-17,
1.429495309400992e-17,
2.521006565487079e-18,
4.197005827716491e-19,
6.305219075478584e-20,
4.834577900942276e-8,
-1.115448639537459e-13,
-1.284205049470645e-13,
-9.85659725165524e-14,
-5.67386654916517e-14,
-2.612868887176814e-14,
-1.002692319305693e-14,
-3.298045177063184e-15,
-9.49128070199476e-16,
-2.42763295292737e-16,
-5.586883167340524e-17,
-1.168239109266614e-17,
-2.236330063412326e-18,
-3.944516429519404e-19,
-6.569123854761202e-20,
-9.87141001684892e-21,
-7.216396345662224e-9,
1.61393134496704e-14,
1.858103407522598e-14,
1.426141357970955e-14,
8.20946382636215e-15,
3.780537245944177e-15,
1.450788303529514e-15,
4.771927814337706e-16,
1.373295179359721e-16,
3.512575954323227e-17,
8.08387922000786e-18,
1.690430755789689e-18,
3.236029684591341e-19,
5.707912387397252e-20,
9.52426175945602e-21,
1.437406156293209e-21,
1.017073559341758e-9,
-2.205011918121826e-15,
-2.538608863084494e-15,
-1.948446751001467e-15,
-1.121607410125732e-15,
-5.165112869231838e-16,
-1.982123809623341e-16,
-6.519607847682923e-17,
-1.87626103356137e-17,
-4.799086348955582e-18,
-1.104483766240053e-18,
-2.309691012882243e-19,
-4.421980143217727e-20,
-7.79669257694007e-21,
-1.299691319241905e-21,
-2.005371362286244e-22,
-1.315548483375343e-10,
2.770035132589007e-16,
3.189114799984647e-16,
2.44772685315931e-16,
1.409014234231786e-16,
6.48865265231319e-17,
2.490037489183232e-17,
8.19025404964577e-18,
2.357061562850304e-18,
6.028926641288853e-19,
1.387493024527583e-19,
2.901288135066777e-20,
5.569719882820686e-21,
9.88357396775587e-22,
1.47881739061282e-22,
1.827567803658338e-23,
// [{0,0.00001},{2.,0.0001}]: m=22
0.00853773979100897,
-3.01950301502474e-8,
-3.47632011634849e-8,
-2.66815710177518e-8,
-1.535894900262307e-8,
-7.07287511518673e-9,
-2.71417622411386e-9,
-8.92711058689861e-10,
-2.56889910151335e-10,
-6.56963213385732e-11,
-1.511468341955383e-11,
-3.15866607920577e-12,
-6.03941887438209e-13,
-1.062694309562015e-13,
-1.75997639772891e-14,
-2.617781496009046e-15,
-0.01631941562510739,
5.50521422726561e-8,
6.33809267292635e-8,
4.86463607032747e-8,
2.80027527946829e-8,
1.289542790099916e-8,
4.94856055334449e-9,
1.627623384211166e-9,
4.68375717983049e-10,
1.197835057687631e-10,
2.75595633864114e-11,
5.75985678078268e-12,
1.1014688894131e-12,
1.938768039226625e-13,
3.213304119086297e-14,
4.78640184849346e-15,
0.01562736599265755,
-5.03909946733197e-8,
-5.80146068792513e-8,
-4.45275958288048e-8,
-2.563184468884819e-8,
-1.18036244744416e-8,
-4.52959628617197e-9,
-1.489829223886488e-9,
-4.2872702793425e-10,
-1.096456387161934e-10,
-2.522797534676941e-11,
-5.27294517747837e-12,
-1.008501535136827e-12,
-1.775651041329684e-13,
-2.944967701852566e-14,
-4.392468023722517e-15,
-0.00999436114260138,
3.08646628234005e-8,
3.55341568916927e-8,
2.727332078327711e-8,
1.569960985766554e-8,
7.22977578252342e-9,
2.774404849775311e-9,
9.12533080733008e-10,
2.626011181421922e-10,
6.71605481072868e-11,
1.545324220864657e-11,
3.230124110853541e-12,
6.17873760766259e-13,
1.088170602381516e-13,
1.805886118606799e-14,
2.696728976085124e-15,
0.004801788904587765,
-1.422727500290894e-8,
-1.63797117952431e-8,
-1.257182605567996e-8,
-7.23684728131894e-9,
-3.332619921497216e-9,
-1.278885347979966e-9,
-4.206414182133262e-10,
-1.210495739936392e-10,
-3.095904010313699e-11,
-7.1237062757012e-12,
-1.489127635772674e-12,
-2.848819121141068e-13,
-5.018436767306051e-14,
-8.33314965097726e-15,
-1.245747033938097e-15,
-0.001848433442331198,
5.26315993552105e-9,
6.05942123166185e-9,
4.65075376114924e-9,
2.677161548164288e-9,
1.232853105666243e-9,
4.731054080740571e-10,
1.556108376657021e-10,
4.478103089367136e-11,
1.145313394278091e-11,
2.635450932155324e-12,
5.50940943872713e-13,
1.054110569458376e-13,
1.857323064946536e-14,
3.085711082411992e-15,
4.617534787599963e-16,
0.000593796082101874,
-1.627279296613999e-9,
-1.873469897654864e-9,
-1.437934182547375e-9,
-8.27733275034271e-10,
-3.811777275305308e-10,
-1.462765775210094e-10,
-4.811252042314268e-11,
-1.384570695399431e-11,
-3.5412040435124e-12,
-8.14878175616012e-13,
-1.703590132148682e-13,
-3.259797735340609e-14,
-5.744893860746279e-15,
-9.549024719991e-16,
-1.430254739983041e-16,
-0.0001637172681215471,
4.32425326728872e-10,
4.9784687192694e-10,
3.821097783271105e-10,
2.199579780069794e-10,
1.012924655837605e-10,
3.887094145679907e-11,
1.27852629232327e-11,
3.679334420351428e-12,
9.41044643552742e-13,
2.165520351614483e-13,
4.527467537018801e-14,
8.6640704121797e-15,
1.527202502222596e-15,
2.539609711089842e-16,
3.807062910549783e-17,
0.00003954495166610586,
-1.00801353420301e-10,
-1.16051580916784e-10,
-8.90724718271859e-11,
-5.1273766440168e-11,
-2.361200915421952e-11,
-9.0611111227664e-12,
-2.980349899190849e-12,
-8.57687817379978e-13,
-2.193688618566514e-13,
-5.04820042736446e-14,
-1.055477115818622e-14,
-2.020010240983896e-15,
-3.561274781192885e-16,
-5.924545741756735e-17,
-8.88831591488808e-18,
-8.50024066472393e-6,
2.09359849864405e-11,
2.410339015701891e-11,
1.849995378610721e-11,
1.06493352353608e-11,
4.904113336034522e-12,
1.881956440687415e-12,
6.19008304240995e-13,
1.781396866282077e-13,
4.556284868909632e-14,
1.048531243168944e-14,
2.1923577857489e-15,
4.196156172054016e-16,
7.39904060471927e-17,
1.231378481776514e-17,
1.848727115535535e-18,
1.64618468817209e-6,
-3.92212013372481e-12,
-4.51549802564979e-12,
-3.465757999308146e-12,
-1.99503362054671e-12,
-9.18731226084732e-13,
-3.525640807155159e-13,
-1.159647532595916e-13,
-3.337277259215057e-14,
-8.53584696573319e-15,
-1.964379654143318e-15,
-4.107448302374502e-16,
-7.86222360251064e-17,
-1.386552019371953e-17,
-2.308381120219133e-18,
-3.468029455950038e-19,
-2.901136521181579e-7,
6.69348953848424e-13,
7.70614868265973e-13,
5.91466323559495e-13,
3.404725690726796e-13,
1.567908189524662e-13,
6.01687098593656e-14,
1.979062966023358e-14,
5.695447201100662e-15,
1.456753390070749e-15,
3.352529476307742e-16,
7.01027130554859e-17,
1.341958261451398e-17,
2.366966503831866e-18,
3.941935826264305e-19,
5.926211869641813e-20,
4.690508924964104e-8,
-1.049025772242258e-13,
-1.207733134404019e-13,
-9.26965725034621e-14,
-5.33600091269058e-14,
-2.457279868759711e-14,
-9.4298578736672e-15,
-3.101665552721093e-15,
-8.92616682769057e-16,
-2.283110004336744e-16,
-5.254370276482703e-17,
-1.098746387871355e-17,
-2.103441693437043e-18,
-3.710567609387268e-19,
-6.181572135230731e-20,
-9.30115226894419e-21,
-7.0075636439435e-9,
1.52059723269715e-14,
1.750648862206955e-14,
1.343667441580657e-14,
7.73471149932472e-15,
3.561910968733341e-15,
1.366891397713782e-15,
4.495983225203498e-16,
1.293887207840652e-16,
3.309494525542372e-17,
7.6166207689035e-18,
1.592768019735033e-18,
3.049395999491251e-19,
5.3804215614057e-20,
8.96413302135875e-21,
1.342714176895383e-21,
9.88491610471899e-10,
-2.081169855051614e-15,
-2.39603083338893e-15,
-1.839014705297984e-15,
-1.058613993313482e-15,
-4.875024210498249e-16,
-1.870803350698967e-16,
-6.153463581481589e-17,
-1.770895851399173e-17,
-4.529617860657255e-18,
-1.04248236330609e-18,
-2.180074741102754e-19,
-4.174135120331739e-20,
-7.367646225503457e-21,
-1.226889347105212e-21,
-1.812362116437473e-22,
-1.279584496308404e-10,
2.618686573542635e-16,
3.014868823574167e-16,
2.313988878437504e-16,
1.332029336157717e-16,
6.13413209553302e-17,
2.353991345770765e-17,
7.74278335381067e-18,
2.228291565107368e-18,
5.699589032328297e-19,
1.311765163739087e-19,
2.743409644079745e-20,
5.252674347342054e-21,
9.21671107267508e-22,
1.551242903050004e-22,
3.085618482393098e-23,
// [{0,0.00001},{2.,0.0001}]: m=23
0.0081597078125537,
-2.7526071136328e-8,
-3.16904633646317e-8,
-2.43231803516373e-8,
-1.400137639734145e-8,
-6.44771395049958e-9,
-2.47428027667224e-9,
-8.13811692105583e-10,
-2.34187858991525e-10,
-5.98917528843815e-11,
-1.37797816932057e-11,
-2.87992839039134e-12,
-5.5073444470655e-13,
-9.69384019613312e-14,
-1.606652059543149e-14,
-2.39320092424673e-15,
-0.01562736599265754,
5.03909946733197e-8,
5.80146068792513e-8,
4.45275958288047e-8,
2.563184468884818e-8,
1.180362447444159e-8,
4.52959628617197e-9,
1.489829223886487e-9,
4.2872702793425e-10,
1.096456387161934e-10,
2.522797534676941e-11,
5.27294517747837e-12,
1.008501535136827e-12,
1.775651041329683e-13,
2.944967701852566e-14,
4.39246802372255e-15,
0.01499154171390208,
-4.62969942351008e-8,
-5.3301235337539e-8,
-4.09099811749157e-8,
-2.354941478649831e-8,
-1.084466367378513e-8,
-4.16160727466297e-9,
-1.368799621099512e-9,
-3.939016772132884e-10,
-1.007408221609302e-10,
-2.317986331296985e-11,
-4.84518616628031e-12,
-9.26810641149389e-13,
-1.632255903572276e-13,
-2.708829177910182e-14,
-4.045093464127603e-15,
-0.00960357780917615,
2.84545500058191e-8,
3.27594235904876e-8,
2.514365211136101e-8,
1.447369456263851e-8,
6.66523984299472e-9,
2.557770695960044e-9,
8.41282836426689e-10,
2.42099147987289e-10,
6.19180802062767e-11,
1.424741255140301e-11,
2.978255271545478e-12,
5.69763824228239e-13,
1.003687353461274e-13,
1.666629930195495e-14,
2.491494067873799e-15,
0.004621083605827781,
-1.315789983880221e-8,
-1.514855307915415e-8,
-1.162688440287272e-8,
-6.69290387041051e-9,
-3.082132764165509e-9,
-1.182763520185105e-9,
-3.890270941642431e-10,
-1.119525772341749e-10,
-2.863283485695137e-11,
-6.5886273303881e-12,
-1.377352359681741e-12,
-2.635276423645797e-13,
-4.643307662365809e-14,
-7.71427770603695e-15,
-1.154383696905138e-15,
-0.001781388246275712,
4.88183788978245e-9,
5.62040969289604e-9,
4.31380254758951e-9,
2.483199825072525e-9,
1.143533182577645e-9,
4.388297325576756e-10,
1.443375612676675e-10,
4.153712086147627e-11,
1.06236121304076e-11,
2.444634526818212e-12,
5.110770396383782e-13,
9.77939320590133e-14,
1.723468158198331e-14,
2.864707415973056e-15,
4.290764220494079e-16,
0.000573010438431126,
-1.513488643562119e-9,
-1.742464051757031e-9,
-1.337384224154666e-9,
-7.69852923030058e-10,
-3.545236295457542e-10,
-1.360482950997916e-10,
-4.474842023164168e-11,
-1.287767047132417e-11,
-3.293656252458683e-12,
-7.57932123070587e-13,
-1.584613637967985e-13,
-3.032424644293996e-14,
-5.345208757911899e-15,
-8.88863398775239e-16,
-1.332472017328964e-16,
-0.0001581798072912461,
4.03205414929017e-10,
4.64206325103731e-10,
3.562898884113672e-10,
2.050950663953885e-10,
9.44480369091717e-11,
3.624444460323425e-11,
1.192139963365814e-11,
3.430751280137876e-12,
8.7747545014252e-13,
2.019280177195893e-13,
4.221908476333998e-14,
8.08004098914635e-15,
1.424509917451893e-15,
2.369818302139547e-16,
3.555326299754015e-17,
0.00003825108291945429,
-9.421193229984e-11,
-1.08465255546392e-10,
-8.32497919145301e-11,
-4.7922008488347e-11,
-2.206850997956199e-11,
-8.46880397058555e-12,
-2.785537364970365e-12,
-8.01628588642922e-13,
-2.050328187980958e-13,
-4.71839058730414e-14,
-9.86561002152593e-15,
-1.888270274038787e-15,
-3.329568254828768e-16,
-5.541203241772863e-17,
-8.31927386575798e-18,
-8.23091675357465e-6,
1.961058735639782e-11,
2.25774748020093e-11,
1.732877823325889e-11,
9.97516133129232e-12,
4.593653012104051e-12,
1.762819206912229e-12,
5.79823372688349e-13,
1.668637496835797e-13,
4.267920585407511e-14,
9.82189160268785e-15,
2.053722757580223e-15,
3.931109114670128e-16,
6.93275495897565e-17,
1.154189952281973e-17,
1.734019353444982e-18,
1.595625546225396e-6,
-3.68142013673865e-12,
-4.23838280077035e-12,
-3.253065566527092e-12,
-1.872599582901364e-12,
-8.6234971285063e-13,
-3.309279842821563e-13,
-1.088484894634523e-13,
-3.132496718413523e-14,
-8.01214558370429e-15,
-1.843891657927123e-15,
-3.855650134049203e-16,
-7.38077239541328e-17,
-1.301832767834929e-17,
-2.168062339022607e-18,
-3.259286888529111e-19,
-2.814684762979725e-7,
6.2949099064285e-13,
7.24726834502606e-13,
5.56246174337742e-13,
3.201984727275372e-13,
1.474544840013524e-13,
5.6585936557215e-14,
1.861222647168344e-14,
5.356342777775862e-15,
1.370030390881146e-15,
3.153000484764944e-16,
6.59326910435182e-17,
1.262217282134292e-17,
2.226625680719063e-18,
3.709304247141115e-19,
5.579044223440001e-20,
4.55477152361798e-8,
-9.88360133071592e-14,
-1.137889445802142e-13,
-8.733590347162e-14,
-5.02741970196825e-14,
-2.315176381379317e-14,
-8.88454177361078e-15,
-2.922306105263601e-15,
-8.41002801519301e-16,
-2.151110350042376e-16,
-4.95066279393456e-17,
-1.035270445908607e-17,
-1.982050013326213e-18,
-3.49686702158966e-19,
-5.826952126390661e-20,
-8.7722706421281e-21,
-6.810469164797189e-9,
1.435126381563716e-14,
1.652247194632553e-14,
1.268141810072314e-14,
7.29995607556683e-15,
3.361703356990816e-15,
1.290062463900755e-15,
4.243285101413353e-16,
1.22116837997916e-16,
3.123517839368961e-17,
7.1887161367531e-18,
1.503336336190727e-18,
2.878210100829168e-19,
5.077296490606675e-20,
8.47931908910405e-21,
1.289170146784642e-21,
9.61471174430419e-10,
-1.967469650719962e-15,
-2.265129004842048e-15,
-1.738544405741404e-15,
-1.000779292347268e-15,
-4.608691580061829e-16,
-1.768599039658049e-16,
-5.817302321867189e-17,
-1.674158316194008e-17,
-4.282211389597685e-18,
-9.85557036398218e-19,
-2.061083306690822e-19,
-3.946204592296807e-20,
-6.966667626392447e-21,
-1.164190646505857e-21,
-1.720856049738761e-22,
-1.245533346837032e-10,
2.47940496053459e-16,
2.854515379975758e-16,
2.190913736540617e-16,
1.261182365823927e-16,
5.807876891269681e-17,
2.228791767405579e-17,
7.33098696855092e-18,
2.10978851397581e-18,
5.396524129460607e-19,
1.241985583821267e-19,
2.596960585995978e-20,
4.986998084151254e-21,
8.91468448801826e-22,
1.311577247203746e-22,
8.821262906270662e-24,
// [{0,0.00001},{2.,0.0001}]: m=24
0.00781368299632877,
-2.51954973366598e-8,
-2.90073034396257e-8,
-2.22637979144024e-8,
-1.281592234442409e-8,
-5.9018122372208e-9,
-2.26479814308599e-9,
-7.44914611943244e-10,
-2.14363513967125e-10,
-5.48228193580967e-11,
-1.26139876733847e-11,
-2.63647258873918e-12,
-5.04250767568414e-13,
-8.87825520664842e-14,
-1.472483850926283e-14,
-2.196234011861277e-15,
-0.01499154171390207,
4.62969942351008e-8,
5.3301235337539e-8,
4.09099811749157e-8,
2.35494147864983e-8,
1.084466367378513e-8,
4.16160727466297e-9,
1.368799621099512e-9,
3.93901677213288e-10,
1.007408221609302e-10,
2.317986331296985e-11,
4.84518616628031e-12,
9.26810641149388e-13,
1.632255903572275e-13,
2.708829177910182e-14,
4.045093464127603e-15,
0.01440536671376423,
-4.26818250087287e-8,
-4.91391353857314e-8,
-3.77154781670415e-8,
-2.171054184395777e-8,
-9.99785976449208e-9,
-3.83665604394007e-9,
-1.261924254640034e-9,
-3.631487219809335e-10,
-9.2877120309415e-11,
-2.137111882710452e-11,
-4.46738290731822e-12,
-8.54645736342358e-13,
-1.505531030191909e-13,
-2.499944895293252e-14,
-3.737241101810957e-15,
-0.00924216721165617,
2.63157996776056e-8,
3.02971061583096e-8,
2.325376880574649e-8,
1.338580774082162e-8,
6.16426552833129e-9,
2.365527040370317e-9,
7.78054188328521e-10,
2.239051544683598e-10,
5.72656697139053e-11,
1.317725466077679e-11,
2.754704719363605e-12,
5.27055284729182e-13,
9.28661532473204e-14,
1.542855541207534e-14,
2.308767393810135e-15,
0.004453470615689071,
-1.220459472445574e-8,
-1.405102423223965e-8,
-1.078450636897343e-8,
-6.20799956268111e-9,
-2.858832956444019e-9,
-1.097074331394154e-9,
-3.608439031691571e-10,
-1.038428021536873e-10,
-2.655903032601815e-11,
-6.11158631704533e-12,
-1.277692599095896e-12,
-2.444848301475326e-13,
-4.308670395497668e-14,
-7.1617685399237e-15,
-1.072691055104613e-15,
-0.001719031315264243,
4.5404659306299e-9,
5.2273921552061e-9,
4.01215267241411e-9,
2.309558769061455e-9,
1.063570888624038e-9,
4.081448852942997e-10,
1.342452606932557e-10,
3.863301141349211e-11,
9.88096875725317e-12,
2.27379636918347e-12,
4.753840913844833e-13,
9.09727393277155e-14,
1.603562627352231e-14,
2.666590196259748e-15,
3.99741605213904e-16,
0.0005536293255249282,
-1.411218952262067e-9,
-1.624722137875157e-9,
-1.247014609449071e-9,
-7.17832732389205e-10,
-3.305681291845626e-10,
-1.268555561122645e-10,
-4.172489871811419e-11,
-1.200762948057197e-11,
-3.071164075521649e-12,
-7.06748062023905e-13,
-1.477667966729959e-13,
-2.828014346199043e-14,
-4.985784710627391e-15,
-8.29436406029787e-16,
-1.244364209638531e-16,
-0.0001530043322883908,
3.76847730382519e-10,
4.33861023547728e-10,
3.329991687036133e-10,
1.91688034555218e-10,
8.8274040195397e-11,
3.387521598869915e-11,
1.114214949486465e-11,
3.206514364639522e-12,
8.20131277767617e-13,
1.88735624085032e-13,
3.946244020995087e-14,
7.55308111940644e-15,
1.331827306510567e-15,
2.216481309355039e-16,
3.327709506442247e-17,
0.00003703912532109696,
-8.82476429716758e-11,
-1.015986364569399e-10,
-7.79795019329228e-11,
-4.488822592361365e-11,
-2.067143852352109e-11,
-7.93268641922893e-12,
-2.609205173191194e-12,
-7.50886872452087e-13,
-1.92056426056279e-13,
-4.419851214480325e-14,
-9.24175239291773e-15,
-1.768999102247232e-15,
-3.119739783358037e-16,
-5.193854391185969e-17,
-7.80308164535351e-18,
-7.97812121719321e-6,
1.840708806121587e-11,
2.119189947171274e-11,
1.626531667884512e-11,
9.36299149391336e-12,
4.311745607501468e-12,
1.654638786746746e-12,
5.442420741007098e-13,
1.566247285123995e-13,
4.006070044470769e-14,
9.21945196510727e-15,
1.927823745932182e-15,
3.690383704192411e-16,
6.50915894055122e-17,
1.084029969277358e-17,
1.629647544210204e-18,
1.548077067601368e-6,
-3.4622012941268e-12,
-3.98599856328545e-12,
-3.05935470606014e-12,
-1.761092030122924e-12,
-8.10999860083012e-13,
-3.112227270770681e-13,
-1.023672705967746e-13,
-2.94598924718978e-14,
-7.53516898747777e-15,
-1.734150697971096e-15,
-3.626299028503707e-16,
-6.94219445578165e-17,
-1.224641173931347e-17,
-2.040144563842902e-18,
-3.068787764970762e-19,
-2.733232486991608e-7,
5.93087693857625e-13,
6.82816116020128e-13,
5.24078702203178e-13,
3.016816095531021e-13,
1.389273581046246e-13,
5.331368819302998e-14,
1.753595408719394e-14,
5.046626193679795e-15,
1.290822083519539e-15,
2.970756476011465e-16,
6.212372275688855e-17,
1.18937221516632e-17,
2.098394781771412e-18,
3.496766222853702e-19,
5.26152394644916e-20,
4.426663772246974e-8,
-9.32805497503848e-14,
-1.073929994026291e-13,
-8.24268626948794e-14,
-4.744835887647836e-14,
-2.185044754524739e-14,
-8.38516644694017e-15,
-2.758056515557333e-15,
-7.93736773508965e-16,
-2.030228668278276e-16,
-4.672529380743629e-17,
-9.7713694140153e-18,
-1.870859835460604e-18,
-3.301050662301854e-19,
-5.502482003086655e-20,
-8.29264903919867e-21,
-6.624150917512373e-9,
1.356660182483632e-14,
1.561909899498534e-14,
1.198805765167605e-14,
6.9008302239824e-15,
3.177903260784427e-15,
1.219529756214835e-15,
4.011295259988945e-16,
1.15440841154701e-16,
2.952778941405839e-17,
6.79585336218088e-18,
1.421223557781126e-18,
2.72130037489919e-19,
4.79949971886582e-20,
8.00186190971277e-21,
1.236425000855065e-21,
9.35887762971445e-10,
-1.862833950205046e-15,
-2.144663032753728e-15,
-1.64608386181306e-15,
-9.47555308039853e-16,
-4.363591446054027e-16,
-1.674542509993945e-16,
-5.507939210596032e-17,
-1.585132082263484e-17,
-4.05452430824691e-18,
-9.33165998290434e-19,
-1.951555695392296e-19,
-3.736946032392217e-20,
-6.602057388532768e-21,
-1.100241336160292e-21,
-1.580304667576864e-22,
-1.213246464107609e-10,
2.350941405570916e-16,
2.706616640503643e-16,
2.077397863533705e-16,
1.195838072595482e-16,
5.50696171134661e-17,
2.11331622858909e-17,
6.95117320402844e-18,
2.000486933964367e-18,
5.116986541210038e-19,
1.177724131917653e-19,
2.462154701909176e-20,
4.7117308328876e-21,
8.582218530055496e-22,
1.441655199762228e-22,
-8.296254227295984e-24,
// [{0,0.00001},{2.,0.0001}]: m=25
0.00749577085695104,
-2.31484971175504e-8,
-2.66506176687695e-8,
-2.04549905874578e-8,
-1.177470739324915e-8,
-5.42233183689256e-9,
-2.08080363733148e-9,
-6.84399810549756e-10,
-1.969508386066442e-10,
-5.03704110804651e-11,
-1.158993165648492e-11,
-2.42259308314016e-12,
-4.63405320574694e-13,
-8.16127951786138e-14,
-1.354414588955091e-14,
-2.0225467320638e-15,
-0.01440536671376423,
4.26818250087287e-8,
4.91391353857314e-8,
3.77154781670415e-8,
2.171054184395776e-8,
9.99785976449208e-9,
3.83665604394007e-9,
1.261924254640034e-9,
3.63148721980933e-10,
9.2877120309415e-11,
2.137111882710452e-11,
4.46738290731822e-12,
8.54645736342358e-13,
1.505531030191909e-13,
2.499944895293252e-14,
3.737241101810955e-15,
0.01386325081748426,
-3.94736995164084e-8,
-4.54456592374645e-8,
-3.48806532086197e-8,
-2.007871161123243e-8,
-9.24639829249694e-9,
-3.548290560555475e-9,
-1.167081282492781e-9,
-3.358577317025397e-10,
-8.58985045708579e-11,
-1.976588199116519e-11,
-4.132057079045408e-12,
-7.90582927093774e-13,
-1.392992298709801e-13,
-2.314283311811291e-14,
-3.463151090715846e-15,
-0.00890694123137873,
2.44091894489126e-8,
2.81020484644806e-8,
2.156901273794785e-8,
1.241599912536279e-8,
5.7176659128883e-9,
2.194148662788408e-9,
7.21687806338347e-10,
2.076856043073841e-10,
5.31180606520387e-11,
1.222317263409122e-11,
2.555385198191908e-12,
4.88969660295088e-13,
8.6173407909959e-14,
1.432353707984758e-14,
2.145382110207419e-15,
0.004297578288160405,
-1.135116482657437e-8,
-1.306848038801481e-8,
-1.003038168103495e-8,
-5.77389692265345e-9,
-2.658927221560007e-9,
-1.020362213235716e-9,
-3.356131517331282e-10,
-9.65825285337271e-11,
-2.47024218931321e-11,
-5.68449092295849e-12,
-1.188460228461155e-12,
-2.27431848319276e-13,
-4.008906568384159e-14,
-6.66647549065506e-15,
-9.99354012993511e-16,
-0.001660887976546386,
4.2336568567326e-9,
4.87416641356375e-9,
3.74104382829984e-9,
2.153498197140347e-9,
9.91704387541131e-10,
3.805666683319747e-10,
1.251746961527575e-10,
3.602288844125976e-11,
9.21349222644826e-12,
2.120244186044862e-12,
4.433003900134011e-13,
8.48404303848877e-14,
1.495735413160572e-14,
2.488309218066253e-15,
3.733092629847007e-16,
0.0005355151630147974,
-1.318967056348808e-9,
-1.51851358242855e-9,
-1.165497090471474e-9,
-6.70908120948345e-10,
-3.089591406862299e-10,
-1.185632559613451e-10,
-3.899752323232169e-11,
-1.122280027632335e-11,
-2.870459472208348e-12,
-6.60574684302577e-13,
-1.381185407361887e-13,
-2.643578391824209e-14,
-4.661395571945225e-15,
-7.75768458146615e-16,
-1.16469833708133e-16,
-0.0001481565018795331,
3.52990573010104e-10,
4.0639454712112e-10,
3.119180087243789e-10,
1.795529042658878e-10,
8.26857543572355e-11,
3.173074577790099e-11,
1.043682072598115e-11,
3.003547499367761e-12,
7.68225706670383e-13,
1.76794049141988e-13,
3.696700968885874e-14,
7.07599643154559e-15,
1.247895918821125e-15,
2.077541763062595e-16,
3.121232497771818e-17,
0.00003590154540910547,
-8.28318961498658e-11,
-9.53635474780988e-11,
-7.31939249438123e-11,
-4.213346165871911e-11,
-1.94028552043341e-11,
-7.44587452906935e-12,
-2.449089329739252e-12,
-7.04811277236893e-13,
-1.802731517284265e-13,
-4.148753378053835e-14,
-8.67520684005163e-15,
-1.660672662965798e-15,
-2.929121616708688e-16,
-4.878135009353902e-17,
-7.333402916352376e-18,
-7.7403789886696e-6,
1.731099448568047e-11,
1.992997901826279e-11,
1.529676293985373e-11,
8.80545405430431e-12,
4.054996492998188e-12,
1.556112558028294e-12,
5.118359986163971e-13,
1.472993603753326e-13,
3.767581885040754e-14,
8.67074748564001e-15,
1.813148262609718e-15,
3.471094829577442e-16,
6.12320043461944e-17,
1.020071487694398e-17,
1.534406391549501e-18,
1.503278304767024e-6,
-3.26198312014907e-12,
-3.75548956367026e-12,
-2.882433572508367e-12,
-1.659249261473248e-12,
-7.64100657892718e-13,
-2.9322535732917e-13,
-9.64477712504171e-14,
-2.775645090671387e-14,
-7.09952320560646e-15,
-1.633916461487331e-15,
-3.416805791723266e-16,
-6.54154968224829e-17,
-1.154111828012181e-17,
-1.923212185667416e-18,
-2.894470916190397e-19,
-2.65635849773094e-7,
5.59751295530368e-13,
6.4443628075568e-13,
4.94621261418495e-13,
2.847247408759342e-13,
1.311186132434371e-13,
5.031711110228191e-14,
1.65503496089831e-14,
4.762999251425531e-15,
1.218285205047973e-15,
2.803858285912288e-16,
5.863532520999846e-17,
1.122651788269083e-17,
1.980916998853787e-18,
3.3019590231226e-19,
4.970963106385112e-20,
4.305560391268823e-8,
-8.81803781065264e-14,
-1.015212263790426e-13,
-7.79201357951716e-14,
-4.48541076264489e-14,
-2.065577767504496e-14,
-7.92671564972767e-15,
-2.607267000470128e-15,
-7.50343905148841e-16,
-1.919251262823136e-16,
-4.417178747139365e-17,
-9.23763201632825e-18,
-1.768765855776024e-18,
-3.121163736308277e-19,
-5.204169940436197e-20,
-7.857060817182669e-21,
-6.447749171593877e-9,
1.284454036551695e-14,
1.478779729785989e-14,
1.135001351835918e-14,
6.53354652430898e-15,
3.008766576192354e-15,
1.154624002051668e-15,
3.797812531758332e-16,
1.092973932175069e-16,
2.795658415240903e-17,
6.43431999661174e-18,
1.345653029746529e-18,
2.576838392432835e-19,
4.544609773672434e-20,
7.566753741317381e-21,
1.176300183173915e-21,
9.11629770964043e-10,
-1.766324680649315e-15,
-2.033552925905847e-15,
-1.560804157403606e-15,
-8.98464886883153e-16,
-4.137526517968241e-16,
-1.587790583923619e-16,
-5.222601101257314e-17,
-1.5030191761783e-17,
-3.844516818025628e-18,
-8.84842575412958e-19,
-1.850498733540409e-19,
-3.543722732009773e-20,
-6.272370257216378e-21,
-1.043321124312141e-21,
-1.384035336658648e-22,
-1.182590267133827e-10,
2.232204434444284e-16,
2.569916004768811e-16,
1.972476791774222e-16,
1.135441274455824e-16,
5.228829941188409e-17,
2.006583646296892e-17,
6.60011534799495e-18,
1.8994605484664e-18,
4.858608706123437e-19,
1.118304233850086e-19,
2.33760206276614e-20,
4.463013921065519e-21,
8.241470067721109e-22,
1.504745413743266e-22,
-1.784554314220056e-23,
// [{0,0.00001},{2.,0.0001}]: m=26
0.00720268335688211,
-2.13409125043643e-8,
-2.45695676928657e-8,
-1.88577390835208e-8,
-1.085527092197888e-8,
-4.99892988224604e-9,
-1.91832802197003e-9,
-6.30962127320017e-10,
-1.815743609904667e-10,
-4.64385601547075e-11,
-1.068555941355226e-11,
-2.23369145365911e-12,
-4.27322868171179e-13,
-7.52765515095954e-14,
-1.249972447646626e-14,
-1.868620550905476e-15,
-0.01386325081748425,
3.94736995164084e-8,
4.54456592374645e-8,
3.48806532086197e-8,
2.007871161123242e-8,
9.24639829249694e-9,
3.54829056055547e-9,
1.167081282492781e-9,
3.3585773170254e-10,
8.58985045708579e-11,
1.976588199116519e-11,
4.13205707904541e-12,
7.90582927093774e-13,
1.3929922987098e-13,
2.314283311811291e-14,
3.463151090715911e-15,
0.0133604118470681,
-3.66137841733689e-8,
-4.21530726967209e-8,
-3.23535191069218e-8,
-1.862399868804419e-8,
-8.57649886933245e-9,
-3.291222994182612e-9,
-1.082531709507521e-9,
-3.115284064610763e-10,
-7.96770909780581e-11,
-1.833475895113683e-11,
-3.833077797287863e-12,
-7.33454490442632e-13,
-1.292601118649383e-13,
-2.14853056197712e-14,
-3.218073165311424e-15,
-0.00859515657632139,
2.27023296531498e-8,
2.613696077603084e-8,
2.006076336207083e-8,
1.154779384530743e-8,
5.31785444312026e-9,
2.040724426471527e-9,
6.71226303466288e-10,
1.931650570674632e-10,
4.94048437862665e-11,
1.136898184591751e-11,
2.37692045692242e-12,
4.548636966385737e-13,
8.01781313676939e-14,
1.333295098131034e-14,
1.998708025979602e-15,
0.004152219941365766,
-1.058414214183113e-8,
-1.218541603390897e-8,
-9.35260957074929e-9,
-5.38374549285069e-9,
-2.479260968852743e-9,
-9.51416670829905e-10,
-3.129367403818833e-10,
-9.00572211031464e-11,
-2.303373056611988e-11,
-5.30061046511198e-12,
-1.10825097503346e-12,
-2.121010759622e-13,
-3.739338532902899e-14,
-6.220773045179969e-15,
-9.33273157442326e-16,
-0.001606545489016693,
3.95690116899546e-9,
4.55554074722697e-9,
3.496491271369388e-9,
2.012724362819111e-9,
9.26877422046751e-10,
3.556897678794539e-10,
1.169925696954582e-10,
3.366840082853636e-11,
8.61137841651409e-12,
1.981724052882201e-12,
4.143556222033147e-13,
7.93073517536941e-14,
1.39841867154143e-14,
2.32730537442025e-15,
3.494095013805974e-16,
0.000518547756583665,
-1.235467005544875e-9,
-1.42238091493487e-9,
-1.09171303054373e-9,
-6.28435164935445e-10,
-2.89400140252552e-10,
-1.110576102235084e-10,
-3.652887254121522e-11,
-1.051241624786811e-11,
-2.688789973367018e-12,
-6.1877917200161e-13,
-1.293845339121607e-13,
-2.47659875109439e-14,
-4.367635715412107e-15,
-7.27139616667981e-16,
-1.092431380117364e-16,
-0.0001436061822168989,
3.31327585667519e-10,
3.81454191142038e-10,
2.927757007190318e-10,
1.685338471781579e-10,
7.76114210675235e-11,
2.978349821228774e-11,
9.79635735053703e-12,
2.819245118036094e-12,
7.210926092387e-13,
1.659501356571871e-13,
3.470082747077843e-14,
6.64269067339075e-15,
1.171648654089123e-15,
1.95125400901853e-16,
2.933360784466598e-17,
0.00003483170538239128,
-7.78994750659961e-11,
-8.96849054445273e-11,
-6.88354331236878e-11,
-3.962454318355047e-11,
-1.824748419048406e-11,
-7.00250650037923e-12,
-2.303261990238449e-12,
-6.62847120671319e-13,
-1.695411845669651e-13,
-3.901836362695313e-14,
-8.15916716679017e-15,
-1.561992666425109e-15,
-2.755440264589522e-16,
-4.590322219326548e-17,
-6.904820223025871e-18,
-7.51638533098555e-6,
1.630990420623061e-11,
1.877743469995292e-11,
1.441215779383196e-11,
8.29624051138892e-12,
3.820500620352373e-12,
1.46612576236343e-12,
4.822385193417332e-13,
1.387821575730618e-13,
3.54975912247561e-14,
8.16957659923905e-15,
1.708401711735713e-15,
3.270772550553429e-16,
5.770552462432508e-17,
9.61605460994244e-18,
1.447262961864377e-18,
1.460997600163661e-6,
-3.07863289069324e-12,
-3.544400425211631e-12,
-2.720417614034565e-12,
-1.565986464086072e-12,
-7.21152552101343e-13,
-2.767441798551702e-13,
-9.10269454772232e-14,
-2.619650239648545e-14,
-6.70057029052372e-15,
-1.54212243092967e-15,
-3.224943868903953e-16,
-6.174589316640635e-17,
-1.089499292937037e-17,
-1.81604311472732e-18,
-2.734641667584545e-19,
-2.583687590761119e-7,
5.29146915815601e-13,
6.09201785964687e-13,
4.67577939947314e-13,
2.691575294379954e-13,
1.239498093457411e-13,
4.756610520038047e-14,
1.56455134758435e-14,
4.502613539602466e-15,
1.151691475946011e-15,
2.650631111013778e-16,
5.543253166827958e-17,
1.061389296278322e-17,
1.873019077105655e-18,
3.122879741952591e-19,
4.704912642542467e-20,
4.190902568860111e-8,
-8.348710045259e-14,
-9.61179056112413e-14,
-7.37729565843097e-14,
-4.246682554954989e-14,
-1.955641776330977e-14,
-7.50483919944639e-15,
-2.468506829327217e-15,
-7.10412526720664e-16,
-1.817125578794651e-16,
-4.182190291355086e-17,
-8.74642824129865e-18,
-1.674801969288271e-18,
-2.955761841923473e-19,
-4.929396221717355e-20,
-7.435632285447218e-21,
-6.280493228110051e-9,
1.217859668148201e-14,
1.402110334112734e-14,
1.07615572960491e-14,
6.19480750368758e-15,
2.852774817922225e-15,
1.094762505040567e-15,
3.600920478607696e-16,
1.036313503349058e-16,
2.650746433637421e-17,
6.100879218264605e-18,
1.275939544427026e-18,
2.443349628426254e-19,
4.312725882846893e-20,
7.192738849822225e-21,
1.082939828269795e-21,
8.885968526801829e-10,
-1.677121998380802e-15,
-1.930854808693987e-15,
-1.48198084782207e-15,
-8.5309101259683e-16,
-3.928576434781639e-16,
-1.507606349534535e-16,
-4.958864369298902e-17,
-1.427122221910293e-17,
-3.650403492773886e-18,
-8.40176310514553e-19,
-1.757168542182724e-19,
-3.36502744618157e-20,
-5.945905644899291e-21,
-9.91363410316025e-22,
-1.430128829578035e-22,
-1.153444321731911e-10,
2.122236774113532e-16,
2.44331137633865e-16,
1.875304638486995e-16,
1.079505050817776e-16,
4.97123930797728e-17,
1.90773356890339e-17,
6.274983601580797e-18,
1.805896050824561e-18,
4.619286356581044e-19,
1.063185547730778e-19,
2.223663168419786e-20,
4.258287423703185e-21,
7.50592928477458e-22,
1.260641483834288e-22,
2.093242853483953e-23,
// [{0,0.00001},{2.,0.0001}]: m=27
0.00693162540874213,
-1.97368497582042e-8,
-2.27228296187322e-8,
-1.74403266043099e-8,
-1.003935580561621e-8,
-4.62319914624847e-9,
-1.774145280277737e-9,
-5.83540641246391e-10,
-1.679288658512698e-10,
-4.2949252285429e-11,
-9.8829409955826e-12,
-2.066028539522704e-12,
-3.95291463546887e-13,
-6.964961493549e-14,
-1.157141655905646e-14,
-1.731575545357956e-15,
-0.0133604118470681,
3.66137841733689e-8,
4.21530726967209e-8,
3.23535191069218e-8,
1.862399868804419e-8,
8.57649886933245e-9,
3.29122299418261e-9,
1.082531709507521e-9,
3.115284064610762e-10,
7.96770909780581e-11,
1.833475895113683e-11,
3.83307779728786e-12,
7.33454490442632e-13,
1.292601118649383e-13,
2.14853056197712e-14,
3.218073165311418e-15,
0.01289273486448208,
-3.40534944797247e-8,
-3.92054411640463e-8,
-3.00911450431062e-8,
-1.732169076796115e-8,
-7.97678166468039e-9,
-3.06108663970729e-9,
-1.006839455199432e-9,
-2.897475856011949e-10,
-7.41072656793998e-11,
-1.705347276887627e-11,
-3.56538068538363e-12,
-6.82295544957861e-13,
-1.202671970515409e-13,
-1.999942647196536e-14,
-2.998062038969277e-15,
-0.0083044398827321,
2.11682842836633e-8,
2.437083206781911e-8,
1.870521914149948e-8,
1.076749098570189e-8,
4.95852193770572e-9,
1.9028333416599e-9,
6.25873480763797e-10,
1.801144422063013e-10,
4.606746113224197e-11,
1.060122093022447e-11,
2.216501950067026e-12,
4.242021519244203e-13,
7.47867706580625e-14,
1.244154609036041e-14,
1.866546314883752e-15,
0.00401636372254154,
-9.89225292248831e-9,
-1.138885186806705e-8,
-8.74122817842317e-9,
-5.0318109070476e-9,
-2.317193555116798e-9,
-8.89224419698604e-10,
-2.924814242386353e-10,
-8.4171002071338e-11,
-2.15284460412845e-11,
-4.954310132205334e-12,
-1.035889055508252e-12,
-1.982683793842222e-13,
-3.49604667885322e-14,
-5.81826343605794e-15,
-8.7352375345501e-16,
-0.001555643269723962,
3.70640101658611e-9,
4.26714274474876e-9,
3.27513909158832e-9,
1.885305494781656e-9,
8.68200420746292e-10,
3.33172830666164e-10,
1.095866176222112e-10,
3.153724874319149e-11,
8.06636991999545e-12,
1.856337515980525e-12,
3.881536017314214e-13,
7.42979625318578e-14,
1.310290714600263e-14,
2.181418849977687e-15,
3.277294140973138e-16,
0.0005026216377643208,
-1.159646549845381e-9,
-1.335089669007569e-9,
-1.02471495252462e-9,
-5.89868465128163e-10,
-2.716399737384553e-10,
-1.042422437438218e-10,
-3.428725072714761e-11,
-9.86735791320346e-12,
-2.523824132355175e-12,
-5.8082547480466e-13,
-1.214528961486805e-13,
-2.324941735715945e-14,
-4.100770289360687e-15,
-6.829389030293569e-16,
-1.02667627413403e-16,
-0.0001393268220960792,
3.11597901280685e-10,
3.58739622948628e-10,
2.753417333931544e-10,
1.58498173251361e-10,
7.29899370000938e-11,
2.801002609291092e-11,
9.21304799101546e-12,
2.651388491336833e-12,
6.78164740480926e-13,
1.560734550171781e-13,
3.263666877326495e-14,
6.24797068608553e-15,
1.1021761106124e-15,
1.836128893639043e-16,
2.761927970395055e-17,
0.00003382373392437805,
-7.33945688140862e-11,
-8.44984560185967e-11,
-6.4854709971551e-11,
-3.733308224328705e-11,
-1.719225276489303e-11,
-6.59756592039201e-12,
-2.170073333668474e-12,
-6.24519708109067e-13,
-1.59739160263434e-13,
-3.676309463976638e-14,
-7.68780769073515e-15,
-1.471847644565339e-15,
-2.596748603816602e-16,
-4.327224678306031e-17,
-6.512683639525911e-18,
-7.304981956932094e-6,
1.539315360682829e-11,
1.772198963842473e-11,
1.360207848559059e-11,
7.82992680313656e-12,
3.60576021973149e-12,
1.383719924242243e-12,
4.551344066743088e-13,
1.309824196836005e-13,
3.350282784280591e-14,
7.71060672050372e-15,
1.612470801432402e-15,
3.087292484194863e-16,
5.447491648209907e-17,
9.08020908436644e-18,
1.367330552356079e-18,
1.421028591313775e-6,
-2.91030876632742e-12,
-3.350610662490036e-12,
-2.571679314189703e-12,
-1.48036678289887e-12,
-6.817241222466e-13,
-2.616136441646541e-13,
-8.60503456823389e-14,
-2.476438067427931e-14,
-6.3343047048346e-15,
-1.457847475386098e-15,
-3.048790014626152e-16,
-5.837642956827421e-17,
-1.030160742931068e-17,
-1.717579624974746e-18,
-2.587686405499862e-19,
-2.514884445825096e-7,
5.00984141513869e-13,
5.76778282714117e-13,
4.42692117985045e-13,
2.548322558661888e-13,
1.173529217613643e-13,
4.503456708564358e-14,
1.481286054628983e-14,
4.262998821163747e-15,
1.090409297248697e-15,
2.509622480621564e-16,
5.248500397901196e-17,
1.005004560104244e-17,
1.773713178603456e-18,
2.958007967087405e-19,
4.457732698926141e-20,
4.082189362494242e-8,
-7.91585797612428e-14,
-9.11345252816664e-14,
-6.99480912162134e-14,
-4.026507952388181e-14,
-1.854249786366124e-14,
-7.11574964899478e-15,
-2.340530344006477e-15,
-6.73584216518484e-16,
-1.722935158656574e-16,
-3.965456505185527e-17,
-8.29336392110173e-18,
-1.588124308596184e-18,
-2.803187208471239e-19,
-4.676086710462083e-20,
-7.044092175683834e-21,
-6.121690191752148e-9,
1.156310556930754e-14,
1.331249484807587e-14,
1.021768299805956e-14,
5.88173153714796e-15,
2.708600997074182e-15,
1.039436051397442e-15,
3.41894433750183e-16,
9.83945248733633e-17,
2.516810355486153e-17,
5.792685261574385e-18,
1.21152059411634e-18,
2.32006380858479e-19,
4.093160549778402e-20,
6.83411361047218e-21,
1.055279734900732e-21,
8.666985375032869e-10,
-1.59450685571112e-15,
-1.835740850543579e-15,
-1.408978555254496e-15,
-8.11067938797265e-16,
-3.735056931985294e-16,
-1.433343491930162e-16,
-4.714603306219307e-17,
-1.356829601208943e-17,
-3.470622014789348e-18,
-7.98805913305354e-19,
-1.670731417478519e-19,
-3.199817684745696e-20,
-5.641343532391365e-21,
-9.40226634665134e-22,
-1.498360745644417e-22,
-1.125699762742978e-10,
2.020196036049885e-16,
2.325832923762876e-16,
1.785137036946634e-16,
1.027600917063631e-16,
4.732216636882868e-17,
1.816008832868641e-17,
5.973287151849428e-18,
1.719074659288904e-18,
4.397247525579588e-19,
1.012081157704128e-19,
2.115823732909041e-20,
4.055392747674596e-21,
7.427480747188306e-22,
1.184314179068758e-22,
-1.074629147265734e-23,
// [{0,0.00001},{2.,0.0001}]: m=28
0.00668020592353405,
-1.83068920866845e-8,
-2.10765363483604e-8,
-1.61767595534609e-8,
-9.31199934402209e-9,
-4.28824943466623e-9,
-1.645611497091306e-9,
-5.4126585475376e-10,
-1.557642032305381e-10,
-3.9838545489029e-11,
-9.16737947556841e-12,
-1.916538898643931e-12,
-3.66727245221316e-13,
-6.46300559324691e-14,
-1.07426528098856e-14,
-1.609036582655708e-15,
-0.01289273486448208,
3.40534944797247e-8,
3.92054411640463e-8,
3.00911450431062e-8,
1.732169076796115e-8,
7.97678166468039e-9,
3.06108663970729e-9,
1.006839455199432e-9,
2.897475856011948e-10,
7.41072656793998e-11,
1.705347276887627e-11,
3.56538068538363e-12,
6.82295544957861e-13,
1.202671970515409e-13,
1.999942647196536e-14,
2.998062038969257e-15,
0.01245665982409815,
-3.17524264254949e-8,
-3.65562481017287e-8,
-2.805782871224923e-8,
-1.615123647855283e-8,
-7.43778290655859e-9,
-2.854250012489851e-9,
-9.38810221145695e-10,
-2.70171663309452e-10,
-6.9101191698363e-11,
-1.59018313953367e-11,
-3.32475292510054e-12,
-6.36303227886631e-13,
-1.121801559870937e-13,
-1.866231913554061e-14,
-2.799819472325713e-15,
-0.00803272744508363,
1.978450584497758e-8,
2.27777037361352e-8,
1.748245635684719e-8,
1.00636218140957e-8,
4.63438711023382e-9,
1.778448839397295e-9,
5.84962848477299e-10,
1.683420041426842e-10,
4.305689208257109e-11,
9.90862026441115e-12,
2.071778111016605e-12,
3.965367587684651e-13,
6.9920933577065e-14,
1.163652687211495e-14,
1.747047506912964e-15,
0.003889108174309717,
-9.26600254146495e-9,
-1.066785686187151e-8,
-8.18784772897051e-9,
-4.71326373695398e-9,
-2.170501051865654e-9,
-8.32932076665381e-10,
-2.739665440555184e-10,
-7.8843121857976e-11,
-2.016592479998792e-11,
-4.64084378995115e-12,
-9.70384004328518e-13,
-1.857449063296393e-13,
-3.275726786501167e-14,
-5.453547124943328e-15,
-8.19323535235066e-16,
-0.001507864913266565,
3.47893964948991e-9,
4.00526900696947e-9,
3.074144857533004e-9,
1.76960539536097e-9,
8.14919921204535e-10,
3.127267312273092e-10,
1.028617521800757e-10,
2.960207373921693e-11,
7.57147239696489e-12,
1.742476424390833e-12,
3.643586884411551e-13,
6.97482520705045e-14,
1.2302310868026e-14,
2.048816709110942e-15,
3.080028821243729e-16,
0.0004876438773413331,
-1.090592654491046e-9,
-1.255588680330153e-9,
-9.63696066883682e-10,
-5.54743606384162e-10,
-2.554647795023538e-10,
-9.80350913259656e-11,
-3.224566796880979e-11,
-9.2798597197525e-12,
-2.373576591702049e-12,
-5.462570925644756e-13,
-1.142283407074281e-13,
-2.186789740143621e-14,
-3.85761638688582e-15,
-6.426451128029666e-16,
-9.66674792971394e-17,
-0.000135294936250719,
2.93578276225306e-10,
3.37993825189943e-10,
2.594188407424221e-10,
1.493323294660238e-10,
6.87690112865469e-11,
2.639026376867065e-11,
8.68029336332408e-12,
2.498078840681667e-12,
6.38956643162702e-13,
1.470523790442773e-13,
3.075123086514276e-14,
5.887390598354827e-15,
1.038699443213593e-15,
1.730889870043596e-16,
2.605073647061036e-17,
0.00003287241874263065,
-6.92691911220039e-11,
-7.9748953247739e-11,
-6.12093530890847e-11,
-3.523467055881085e-11,
-1.622592096332372e-11,
-6.22673964931662e-12,
-2.04810482681963e-12,
-5.89420887651075e-13,
-1.507627250562783e-13,
-3.469773018756635e-14,
-7.25611859326082e-15,
-1.389281616144924e-15,
-2.451371288694955e-16,
-4.086094050353401e-17,
-6.152981858756952e-18,
-7.105137054651394e-6,
1.455153349430703e-11,
1.675304141117768e-11,
1.285838743641276e-11,
7.40182865626566e-12,
3.408618189759388e-12,
1.308067291571618e-12,
4.302514227581145e-13,
1.23821815405744e-13,
3.16715010243376e-14,
7.2892321995781e-15,
1.52439391896171e-15,
2.918819359785529e-16,
5.150801403929663e-17,
8.58789672584771e-18,
1.293828034184781e-18,
1.383186852042043e-6,
-2.75541347420515e-12,
-3.172281356086581e-12,
-2.434807263828086e-12,
-1.401577761232727e-12,
-6.45441232694116e-13,
-2.476901815256622e-13,
-8.14707535805877e-14,
-2.34464994376687e-14,
-5.99725264692952e-15,
-1.380292714316918e-15,
-2.886676094908698e-16,
-5.527526216962577e-17,
-9.75538446384061e-18,
-1.62690673787155e-18,
-2.452192388321342e-19,
-2.44964846735509e-7,
4.75010127807435e-13,
5.46874674017642e-13,
4.197403724374851e-13,
2.416203099061934e-13,
1.112687255057399e-13,
4.269977003904885e-14,
1.404491620119739e-14,
4.042004374970887e-15,
1.033888750817745e-15,
2.379567679752963e-16,
4.976634833758031e-17,
9.52993737238327e-18,
1.682069389002824e-18,
2.805845615733787e-19,
4.23236492888774e-20,
3.978970400919706e-8,
-7.5157992996477e-14,
-8.65286914968893e-14,
-6.64130014721838e-14,
-3.823013938702551e-14,
-1.760539273244764e-14,
-6.7561371804573e-15,
-2.222248969747267e-15,
-6.39545749498196e-16,
-1.635879092309372e-16,
-3.765135158171079e-17,
-7.87459961463943e-18,
-1.508004965601735e-18,
-2.661954567353268e-19,
-4.441460214879057e-20,
-6.70055446158828e-21,
-5.970715399431829e-9,
1.099309875895364e-14,
1.265625191181291e-14,
9.71400047255818e-15,
5.59179149498996e-15,
2.575081368742002e-15,
9.88198069231489e-16,
3.25041535290316e-16,
9.35446543479175e-17,
2.392770371414451e-17,
5.507256320421366e-18,
1.151830091317749e-18,
2.205873211530094e-19,
3.897443632579203e-20,
6.502111880826759e-21,
9.46135699844675e-22,
8.458530448758933e-10,
-1.517846493511204e-15,
-1.747482563727149e-15,
-1.341238149529294e-15,
-7.72073809835038e-16,
-3.555485860741631e-16,
-1.364433255155899e-16,
-4.487947284733214e-17,
-1.291603006559978e-17,
-3.303797536255409e-18,
-7.60417540900583e-19,
-1.590445144121383e-19,
-3.046125773058033e-20,
-5.378741385688141e-21,
-8.965436932125448e-22,
-1.343935540239795e-22,
-1.09925793805563e-10,
1.925338566045045e-16,
2.216624487088496e-16,
1.701316865628306e-16,
9.7935061000298e-17,
4.510020016394198e-17,
1.730740996348641e-17,
5.692828394400065e-18,
1.638364458551077e-18,
4.190778691606939e-19,
9.64573469081481e-20,
2.018730267854162e-20,
3.867058878753502e-21,
6.48742626589017e-22,
1.107189820002902e-22,
5.370924611641185e-23,
// [{0,0.00001},{2.,0.0001}]: m=29
0.00644636743224104,
-1.70267472398624e-8,
-1.96027205820231e-8,
-1.50455725215531e-8,
-8.66084538398057e-9,
-3.9883908323402e-9,
-1.530543319853645e-9,
-5.03419727599716e-10,
-1.448737928005974e-10,
-3.70536328396999e-11,
-8.52673638443813e-12,
-1.782690342691815e-12,
-3.4114777247893e-13,
-6.01335985257705e-14,
-9.99971323598268e-15,
-1.499031019484629e-15,
-0.01245665982409814,
3.17524264254949e-8,
3.65562481017287e-8,
2.80578287122492e-8,
1.615123647855283e-8,
7.43778290655858e-9,
2.85425001248985e-9,
9.38810221145695e-10,
2.70171663309452e-10,
6.91011916983629e-11,
1.59018313953367e-11,
3.324752925100539e-12,
6.3630322788663e-13,
1.121801559870937e-13,
1.866231913554062e-14,
2.799819472325698e-15,
0.01204909116762545,
-2.96767587674664e-8,
-3.41665556042028e-8,
-2.622368453527079e-8,
-1.509543272114355e-8,
-6.95158066535073e-9,
-2.667673259095943e-9,
-8.77444272715949e-10,
-2.525130062140263e-10,
-6.45853381238566e-11,
-1.486293039661673e-11,
-3.107667166524908e-12,
-5.94805138152698e-13,
-1.048814003655981e-13,
-1.745479030817249e-14,
-2.620571260368908e-15,
-0.00777821634861997,
1.853200508293082e-8,
2.133571372374409e-8,
1.637569545794184e-8,
9.42652747390842e-9,
4.34100210373152e-9,
1.665864153330844e-9,
5.47933088111064e-10,
1.576862437159598e-10,
4.033184959997784e-11,
9.28168757990276e-12,
1.940768008657133e-12,
3.71489812659298e-13,
6.55145357300255e-14,
1.090709424988605e-14,
1.638647070471483e-15,
0.003769662283166227,
-8.69734912372446e-9,
-1.001317251742333e-8,
-7.68536214383224e-9,
-4.42401348840227e-9,
-2.037299803011265e-9,
-7.81816828068245e-10,
-2.571543804501801e-10,
-7.40051843480397e-11,
-1.892868099241155e-11,
-4.356191060976925e-12,
-9.10896721102869e-13,
-1.743706301762593e-13,
-3.075577717002785e-14,
-5.122041772772393e-15,
-7.70007205348563e-16,
-0.001462931631998208,
3.27177796342902e-9,
3.76676604093967e-9,
2.891088200612064e-9,
1.664230819130047e-9,
7.66394338496728e-10,
2.941052739739312e-10,
9.6737003905125e-11,
2.78395791588821e-11,
7.12072977501012e-12,
1.638771277671335e-12,
3.426850221176534e-13,
6.56036922033949e-14,
1.157284916052586e-14,
1.927935338414391e-15,
2.90002437858351e-16,
0.0004735322768824587,
-1.027523966796829e-9,
-1.182978388174309e-9,
-9.07965942605776e-10,
-5.22663153135285e-10,
-2.40691539504849e-10,
-9.23659231910898e-11,
-3.03810267718785e-11,
-8.74327594245612e-12,
-2.236348251087503e-12,
-5.146833266591509e-13,
-1.076293080285233e-13,
-2.060586709429029e-14,
-3.635448052183737e-15,
-6.05811454650064e-16,
-9.11775766887692e-17,
-0.0001314896755110326,
2.77076765412521e-10,
3.189958140553301e-10,
2.448374131732735e-10,
1.409386827055059e-10,
6.49036840698562e-11,
2.490695868037293e-11,
8.19241933461428e-12,
2.357683558471421e-12,
6.0305090223745e-13,
1.387909212133165e-13,
2.902447447000025e-14,
5.557126483498271e-15,
9.80548518526098e-16,
1.634437621647189e-16,
2.461192777848321e-17,
0.0000319731166837937,
-6.54819006205349e-11,
-7.53886862307417e-11,
-5.78627433720937e-11,
-3.330822890037231e-11,
-1.533878182959157e-11,
-5.88630280273717e-12,
-1.936131399341042e-12,
-5.57198168442248e-13,
-1.425217543827108e-13,
-3.280154484556371e-14,
-6.85977262852022e-15,
-1.313468711236235e-15,
-2.317860518839993e-16,
-3.864553364005658e-17,
-5.822237802373823e-18,
-6.915928493747966e-6,
1.377705750797017e-11,
1.586139542518782e-11,
1.217402760369425e-11,
7.00788378918004e-12,
3.227203853092356e-12,
1.238450021009488e-12,
4.073534762720815e-13,
1.172324132582504e-13,
2.998624176601647e-14,
6.9014586310226e-15,
1.443337013545031e-15,
2.763761104943135e-16,
4.877688829983774e-17,
8.13453042186972e-18,
1.226094336465223e-18,
1.347307054755278e-6,
-2.612556367607337e-12,
-3.00781147232142e-12,
-2.308572635735845e-12,
-1.328912042576193e-12,
-6.11978145976921e-13,
-2.348487949636917e-13,
-7.72470587590392e-14,
-2.223102971781026e-14,
-5.686389580933035e-15,
-1.308762559922858e-15,
-2.737149604319259e-16,
-5.24146604503692e-17,
-9.25145180765503e-18,
-1.543224757267109e-18,
-2.327072753486338e-19,
-2.387709405303213e-7,
4.51003916421081e-13,
5.19236573420812e-13,
3.985274562673765e-13,
2.294093003802852e-13,
1.056454644184138e-13,
4.054185335031068e-14,
1.333514839787049e-14,
3.837750677400868e-15,
9.81649258668857e-16,
2.259361419334967e-16,
4.725346260221572e-17,
9.04916103836251e-18,
1.597368913726115e-18,
2.665120982895302e-19,
4.021013292336484e-20,
3.880839662869369e-8,
-7.145304710124e-14,
-8.2263225665945e-14,
-6.31391519822751e-14,
-3.634557915108286e-14,
-1.673753819114923e-14,
-6.42309913908857e-15,
-2.11270804059651e-15,
-6.08022428768896e-16,
-1.555255002003173e-16,
-3.579610769978496e-17,
-7.4867528497488e-18,
-1.433799785317118e-18,
-2.531173388253407e-19,
-4.223600949351583e-20,
-6.375500636484276e-21,
-5.827004227255201e-9,
1.046420454847048e-14,
1.20473414461874e-14,
9.24664671650489e-15,
5.32276369229267e-15,
2.451191923487096e-15,
9.40655607564098e-16,
3.094041136834027e-16,
8.90445507744262e-17,
2.277674577354638e-17,
5.242405383237658e-18,
1.096466661375919e-18,
2.099906500642133e-19,
3.708800124517849e-20,
6.194030025173148e-21,
9.20608924678713e-22,
8.259862658283937e-10,
-1.446582311755105e-15,
-1.665436838898264e-15,
-1.278266030126244e-15,
-7.3582449118148e-16,
-3.388554777080166e-16,
-1.300373539057222e-16,
-4.277244930003738e-17,
-1.230967256546718e-17,
-3.148713276808408e-18,
-7.24731787872697e-19,
-1.51582435276582e-19,
-2.90278927045898e-20,
-5.128099395768467e-21,
-8.609499980965732e-22,
-1.28245475757726e-22,
-1.074029238899221e-10,
1.837005881073877e-16,
2.114927962817407e-16,
1.623262263345486e-16,
9.34419188907192e-17,
4.30310704262595e-17,
1.651338175665708e-17,
5.431659594757884e-18,
1.563205339842345e-18,
3.998559083584614e-19,
9.20332804628363e-20,
1.925548690531046e-20,
3.691891311708644e-21,
6.370940771287276e-22,
1.027434122580279e-22,
3.131459379328649e-23,
// [{0,0.00001},{2.,0.0001}]: m=30
0.00622832991204907,
-1.58762132127475e-8,
-1.82781240508643e-8,
-1.402891435612461e-8,
-8.07561823927641e-9,
-3.71889145327929e-9,
-1.427125006244925e-9,
-4.69405110572847e-10,
-1.35085831654726e-10,
-3.45505958491815e-11,
-7.95091569766835e-12,
-1.66237646255027e-12,
-3.18151613943315e-13,
-5.60900779935469e-14,
-9.33115956777031e-15,
-1.399909736162849e-15,
-0.01204909116762544,
2.96767587674664e-8,
3.41665556042028e-8,
2.62236845352708e-8,
1.509543272114355e-8,
6.95158066535073e-9,
2.667673259095942e-9,
8.77444272715949e-10,
2.525130062140263e-10,
6.45853381238566e-11,
1.486293039661672e-11,
3.107667166524908e-12,
5.94805138152698e-13,
1.04881400365598e-13,
1.745479030817247e-14,
2.620571260368916e-15,
0.01166732452292996,
-2.77980076243962e-8,
-3.20035705856161e-8,
-2.456354318691276e-8,
-1.413979121086263e-8,
-6.51150315559728e-9,
-2.498796229996267e-9,
-8.21899632166596e-10,
-2.365293655739397e-10,
-6.04977743999668e-11,
-1.392253136985414e-11,
-2.911152012985699e-12,
-5.57234718988947e-13,
-9.82718035950384e-14,
-1.636064137482918e-14,
-2.457970605707123e-15,
-0.00753932456633298,
1.73946982474498e-8,
2.002634503484767e-8,
1.537072428766525e-8,
8.84802697680498e-9,
4.07459960602274e-9,
1.563633656136569e-9,
5.14308760900386e-10,
1.480103686960868e-10,
3.785736198482502e-11,
8.71238212195429e-12,
1.82179344220583e-12,
3.487412603525349e-13,
6.15115543400597e-14,
1.024408354554692e-14,
1.540014410696537e-15,
0.003657329079995338,
-8.17944490857226e-9,
-9.41691510234883e-9,
-7.2277205015299e-9,
-4.16057704782497e-9,
-1.91598584624175e-9,
-7.35263184934801e-10,
-2.418425097628037e-10,
-6.95989478972027e-11,
-1.780182443752466e-11,
-4.096928194178187e-12,
-8.56712555294105e-13,
-1.640092305084872e-13,
-2.893212290130626e-14,
-4.819838346028836e-15,
-7.25006094654131e-16,
-0.001420596830622163,
3.08257190034835e-9,
3.54893516447441e-9,
2.723897827780095e-9,
1.567989459384421e-9,
7.22074618504677e-10,
2.770977695694816e-10,
9.11430803143896e-11,
2.622982782700979e-11,
6.70904475317079e-12,
1.544049979956325e-12,
3.228879240811705e-13,
6.18176012820749e-14,
1.090634415637196e-14,
1.817434363866797e-15,
2.735327300825646e-16,
0.000460213864293448,
-9.6976867895172e-10,
-1.116485349202748e-9,
-8.56930946113436e-10,
-4.93285389473288e-10,
-2.271628942463466e-10,
-8.71743553820152e-11,
-2.867346767138351e-11,
-8.25189245471717e-12,
-2.110678157848279e-12,
-4.857682242506118e-13,
-1.015856606457532e-13,
-1.944994269225973e-14,
-3.431919815083566e-15,
-5.720531677505109e-16,
-8.6141746988571e-17,
-0.0001278924672635575,
2.61927603365178e-10,
3.015547459396009e-10,
2.314509742686678e-10,
1.332329160506594e-10,
6.13551275252143e-11,
2.354521129032768e-11,
7.7445256234739e-12,
2.228792681283223e-12,
5.70087019453018e-13,
1.312061798249288e-13,
2.743909060636866e-14,
5.253874861900197e-15,
9.27144211122372e-16,
1.54582135981897e-16,
2.328895098636706e-17,
0.00003112167816109189,
-6.19967586865748e-11,
-7.13762792990325e-11,
-5.47831241288861e-11,
-3.15354770008044e-11,
-1.452241731565711e-11,
-5.57302508561712e-12,
-1.833090640288536e-12,
-5.275458588172905e-13,
-1.349380877307571e-13,
-3.105656378930913e-14,
-6.49501655161674e-15,
-1.24369249689661e-15,
-2.194959940351202e-16,
-3.660538483916357e-17,
-5.517427730208786e-18,
-6.736529636693894e-6,
1.3062772417362e-11,
1.503904651567065e-11,
1.154285485414009e-11,
6.6445554209195e-12,
3.059888523131006e-12,
1.174243127965564e-12,
3.862350152441073e-13,
1.11155068423525e-13,
2.843192739820192e-14,
6.54380807783351e-15,
1.368573816821918e-15,
2.620731187529543e-16,
4.625722214091083e-17,
7.71611168570673e-18,
1.163537903322046e-18,
1.313240561898948e-6,
-2.480522175823014e-12,
-2.855801885467954e-12,
-2.191901571033747e-12,
-1.26175147535144e-12,
-5.81050203166226e-13,
-2.229802505544638e-13,
-7.33433349789182e-14,
-2.110763413308131e-14,
-5.399072307380431e-15,
-1.242649102315601e-15,
-2.598941033241935e-16,
-4.977038834144682e-17,
-8.78555192235415e-18,
-1.465829222070715e-18,
-2.211335407709209e-19,
-2.328823622058583e-7,
4.28771731199422e-13,
4.93640888869863e-13,
3.78882141514721e-13,
2.181006623003609e-13,
1.004377492557456e-13,
3.85433994897935e-14,
1.267782861498408e-14,
3.648589395840399e-15,
9.33269344441351e-16,
2.148034309312394e-16,
4.492611123457012e-17,
8.60385306787548e-18,
1.518906760155234e-18,
2.534692509887029e-19,
3.824833654720775e-20,
3.787430151698624e-8,
-6.801532663459e-14,
-7.83054134446448e-14,
-6.01014337761089e-14,
-3.45969451803205e-14,
-1.593227832433289e-14,
-6.11408139937497e-15,
-2.011067516487794e-15,
-5.787725374855069e-16,
-1.480444828940813e-16,
-3.407462162442281e-17,
-7.12684930740413e-18,
-1.364929816375807e-18,
-2.409952464415347e-19,
-4.022219045378994e-20,
-6.058348012117906e-21,
-5.690045049819448e-9,
9.97256389862677e-15,
1.148132058676029e-14,
8.81221173407449e-15,
5.07268521065164e-15,
2.336028734382496e-15,
8.96461794972434e-16,
2.948680836316241e-16,
8.48613862265501e-17,
2.170684060279983e-17,
4.996204323503268e-18,
1.04500002631645e-18,
2.001330703813326e-19,
3.533154788520629e-20,
5.913206273115382e-21,
9.00859263118871e-22,
8.070308844062857e-10,
-1.380219682930633e-15,
-1.589034217417857e-15,
-1.219625124963231e-15,
-7.02068388040511e-16,
-3.233105081910145e-16,
-1.240719743194029e-16,
-4.08103398286144e-17,
-1.174501666877108e-17,
-3.004291907801741e-18,
-6.914964308871651e-19,
-1.446406317140347e-19,
-2.770177486289251e-20,
-4.877256092284389e-21,
-8.177869302360066e-22,
-1.388470985868986e-22,
-1.049932087234711e-10,
1.754613230369001e-16,
2.020070134433617e-16,
1.550456521451808e-16,
8.9250921712886e-17,
4.110108010405856e-17,
1.577274756839396e-17,
5.188052547929261e-18,
1.493100366058928e-18,
3.819262536424918e-19,
8.79041650509103e-20,
1.838610561745396e-20,
3.534348303293092e-21,
6.278061461363655e-22,
8.992722286086213e-23,
7.372926066282132e-24,
// [{0,0.00001},{2.,0.0001}]: m=31
0.00602454558381272,
-1.48383793837332e-8,
-1.70832778021014e-8,
-1.311184226763539e-8,
-7.54771636057177e-9,
-3.47579033267537e-9,
-1.333836629547971e-9,
-4.38722136357974e-10,
-1.262565031070131e-10,
-3.22926690619283e-11,
-7.43146519830836e-12,
-1.553833583262454e-12,
-2.97402569076349e-13,
-5.2440700182799e-14,
-8.72739515408623e-15,
-1.310285630184457e-15,
-0.01166732452292996,
2.77980076243962e-8,
3.20035705856161e-8,
2.45635431869128e-8,
1.413979121086263e-8,
6.51150315559728e-9,
2.498796229996266e-9,
8.21899632166596e-10,
2.365293655739397e-10,
6.04977743999668e-11,
1.392253136985414e-11,
2.911152012985699e-12,
5.57234718988947e-13,
9.82718035950384e-14,
1.636064137482918e-14,
2.457970605707069e-15,
0.01130898684949947,
-2.60920473711747e-8,
-3.00395175522715e-8,
-2.305608643149788e-8,
-1.327204046520748e-8,
-6.1118994090341e-9,
-2.345450484204854e-9,
-7.71463141350579e-10,
-2.220155530441303e-10,
-5.67860429772375e-11,
-1.306857318293144e-11,
-2.732690163308745e-12,
-5.23111890528802e-13,
-9.22673315100893e-14,
-1.536612531832053e-14,
-2.310021616045164e-15,
-0.00731465815999119,
1.635888981714536e-8,
1.883383020469863e-8,
1.445544100306054e-8,
8.32115409565036e-9,
3.831971692483696e-9,
1.470526369869678e-9,
4.83685019525632e-10,
1.391978957944126e-10,
3.560364887505115e-11,
8.19385638835679e-12,
1.7134251105883e-12,
3.280184610169911e-13,
5.78642458026087e-14,
9.63967669205844e-15,
1.450012189315349e-15,
0.003551492076555231,
-7.7064297508706e-9,
-8.87233791118571e-9,
-6.80974456944999e-9,
-3.91997364846091e-9,
-1.805186546261625e-9,
-6.92744423923679e-10,
-2.278577007859656e-10,
-6.55745695675221e-11,
-1.677261188292635e-11,
-3.860124949890666e-12,
-8.07219810202891e-13,
-1.54544003205193e-13,
-2.726586039094737e-14,
-4.543585909654503e-15,
-6.83831825184291e-16,
-0.001380641592855684,
2.90930603681487e-9,
3.34945604756186e-9,
2.570792838304707e-9,
1.479856168399371e-9,
6.81488682729602e-10,
2.61523066142424e-10,
8.60204030129593e-11,
2.475567736380868e-11,
6.33203447345716e-12,
1.457304672731647e-12,
3.047569819329461e-13,
5.83498280759808e-14,
1.029575944534298e-14,
1.716159503215056e-15,
2.584252407190237e-16,
0.0004476236354271813,
-9.16746611785681e-10,
-1.055441610797305e-9,
-8.10078409947016e-10,
-4.66315206181153e-10,
-2.147429463400207e-10,
-8.24082395168263e-11,
-2.710583968238213e-11,
-7.80077438455558e-12,
-1.995304568101993e-12,
-4.592216293911525e-13,
-9.60368171232145e-14,
-1.838856201648152e-14,
-3.245004738550065e-15,
-5.410374762945324e-16,
-8.15113289387499e-17,
-0.000124486713161155,
2.479870355905988e-10,
2.855051181681641e-10,
2.191324972616061e-10,
1.261419084326827e-10,
5.80896694604021e-11,
2.229210041836518e-11,
7.33236258611853e-12,
2.110183442453804e-12,
5.397523527605703e-13,
1.242262555803117e-13,
2.598006629625675e-14,
4.974770004341203e-15,
8.77983975747611e-16,
1.464215400905676e-16,
2.206971451482201e-17,
0.00003031438330565365,
-5.87824757831006e-11,
-6.76757092111127e-11,
-5.1942846759659e-11,
-2.990049934580019e-11,
-1.376949833182952e-11,
-5.28409406730261e-12,
-1.738057565788651e-12,
-5.001978070974608e-13,
-1.279436730852556e-13,
-2.944713630119412e-14,
-6.15858216446141e-15,
-1.179329036557664e-15,
-2.08157503312336e-16,
-3.472249799879548e-17,
-5.2359156506397e-18,
-6.566197296116133e-6,
1.240260187172347e-11,
1.4278999057212e-11,
1.095949989582463e-11,
6.30875279501702e-12,
2.905248905886305e-12,
1.114900443069854e-12,
3.667164085626553e-13,
1.055380940161787e-13,
2.699534193214657e-14,
6.21324099811083e-15,
1.299469563629987e-15,
2.488517626177274e-16,
4.392775108623624e-17,
7.329138711679527e-18,
1.105642523538237e-18,
1.280853372761289e-6,
-2.358245129821438e-12,
-2.715025589027726e-12,
-2.083852315786171e-12,
-1.199553952034309e-12,
-5.52407763380811e-13,
-2.119887518692678e-13,
-6.972807536657e-14,
-2.006724685130236e-14,
-5.132982717524803e-15,
-1.181419183913473e-15,
-2.470936814806475e-16,
-4.732117839781965e-17,
-8.35396965579957e-18,
-1.394109949155256e-18,
-2.103908094308648e-19,
-2.272770896962259e-7,
4.08143063634761e-13,
4.69891316037879e-13,
3.606537603409214e-13,
2.076076657837116e-13,
9.56056408095783e-14,
3.668908227832067e-14,
1.206791614428876e-14,
3.473070097740821e-15,
8.88378129983511e-16,
2.044733364163468e-16,
4.276648126192319e-17,
8.19059711786776e-18,
1.446075676401933e-18,
2.413724971292435e-19,
3.643460572726157e-20,
3.698409319019726e-8,
-6.48197483966139e-14,
-7.46263768532031e-14,
-5.72776823713241e-14,
-3.297147878747319e-14,
-1.51837377368231e-14,
-5.82682934660692e-15,
-1.91658586297773e-15,
-5.515827027898724e-16,
-1.410902927175224e-16,
-3.247434013047348e-17,
-6.79228654819901e-18,
-1.300904890495889e-18,
-2.296945562944042e-19,
-3.834669326673153e-20,
-5.793510362254166e-21,
-5.559373167159936e-9,
9.51475997427874e-15,
1.095425557279718e-14,
8.40767627703793e-15,
4.839818059536606e-15,
2.22879145342353e-15,
8.55309506468725e-16,
2.813324323236971e-16,
8.09660967741919e-17,
2.07105574816286e-17,
4.766930959926143e-18,
9.97064286018199e-19,
1.909815010503952e-19,
3.371640025330338e-20,
5.619201131391084e-21,
8.61021322793413e-22,
7.88925617086823e-10,
-1.318319360743522e-15,
-1.517769000317567e-15,
-1.164927298832616e-15,
-6.70582075387313e-16,
-3.088107898069787e-16,
-1.185077047091386e-16,
-3.898015834075969e-17,
-1.121832505766223e-17,
-2.869582204998614e-18,
-6.60495758057543e-19,
-1.381525629369126e-19,
-2.646244252495652e-20,
-4.675664711295744e-21,
-7.800583063169534e-22,
-1.154430556850604e-22,
-1.026892056175602e-10,
1.677639908950874e-16,
1.931451520508437e-16,
1.482439524528632e-16,
8.53355834975334e-17,
3.929803233003138e-17,
1.508082717698864e-17,
4.960468052278739e-18,
1.427604305688614e-18,
3.651739242963972e-19,
8.40567800176111e-20,
1.75822502617661e-20,
3.357614996120668e-21,
5.980866057036833e-22,
1.113253570338705e-22,
6.803771661892152e-24,
// [{0,0.00001},{2.,0.0001}]: m=32
0.00583366226146498,
-1.38990038121981e-8,
-1.60017852928081e-8,
-1.228177159345638e-8,
-7.06989560543131e-9,
-3.25575157779864e-9,
-1.249398114998133e-9,
-4.10949816083298e-10,
-1.182646827869698e-10,
-3.02488871999834e-11,
-6.96126568492707e-12,
-1.455576006492849e-12,
-2.78617359494473e-13,
-4.91359017975192e-14,
-8.18032068741459e-15,
-1.228985302853533e-15,
-0.01130898684949947,
2.60920473711747e-8,
3.00395175522715e-8,
2.305608643149787e-8,
1.327204046520747e-8,
6.1118994090341e-9,
2.345450484204854e-9,
7.71463141350579e-10,
2.220155530441303e-10,
5.67860429772375e-11,
1.306857318293143e-11,
2.732690163308745e-12,
5.23111890528802e-13,
9.22673315100893e-14,
1.536612531832052e-14,
2.310021616045183e-15,
0.01097198723998679,
-2.4538334725718e-8,
-2.82507453070479e-8,
-2.168316150459081e-8,
-1.248173114347554e-8,
-5.74795753872555e-9,
-2.205789554804517e-9,
-7.25527529288448e-10,
-2.087968436916189e-10,
-5.34054733125767e-11,
-1.229078458253519e-11,
-2.570137665882451e-12,
-4.92027691525487e-13,
-8.67963687039128e-14,
-1.445951503808752e-14,
-2.175018283973371e-15,
-0.00710298415311096,
1.5412859501742e-8,
1.774467582237234e-8,
1.361948913890068e-8,
7.83994729692223e-9,
3.610373092523439e-9,
1.385488847847429e-9,
4.55715401571955e-10,
1.31149139135051e-10,
3.354522376585444e-11,
7.72024989978174e-12,
1.614439620405865e-12,
3.090880064104017e-13,
5.45317207818993e-14,
9.08717181930994e-15,
1.367663650367038e-15,
0.003451603982139037,
-7.27326509203691e-9,
-8.37364011890434e-9,
-6.42698209576153e-9,
-3.699640420998289e-9,
-1.703721706823942e-9,
-6.53807665356036e-10,
-2.150510075323902e-10,
-6.18891934095194e-11,
-1.583008618364231e-11,
-3.643261681828985e-12,
-7.61892454832334e-13,
-1.458745701899369e-13,
-2.573939861337032e-14,
-4.290398758048853e-15,
-6.46063101777191e-16,
-0.001342870906257414,
2.75023983531848e-9,
3.16632483234752e-9,
2.430235229806977e-9,
1.398945618523845e-9,
6.4422883901103e-10,
2.472247185470129e-10,
8.13175190460063e-11,
2.340232315333862e-11,
5.98591370422204e-12,
1.377664888154135e-12,
2.881104513656214e-13,
5.516568604868104e-14,
9.73501421546922e-15,
1.623112428848222e-15,
2.445339868533237e-16,
0.0004357034960686731,
-8.67954624574337e-10,
-9.9926791359691e-10,
-7.6696374042202e-10,
-4.41496679518073e-10,
-2.033138431131036e-10,
-7.8022351464929e-11,
-2.566326905162894e-11,
-7.38564204864994e-12,
-1.88913323467776e-12,
-4.34791894534634e-13,
-9.09302320377149e-14,
-1.741169501559941e-14,
-3.072943914836171e-15,
-5.124753900127225e-16,
-7.72440012627569e-17,
-0.0001212575337283045,
2.351299039404565e-10,
2.707028377747558e-10,
2.077713877526695e-10,
1.196019977942292e-10,
5.50779935166015e-11,
2.1136376341849e-11,
6.9522302870473e-12,
2.000791235266081e-12,
5.117746940999834e-13,
1.177885456096777e-13,
2.463432874232109e-14,
4.71731616233468e-15,
8.32630016607404e-16,
1.388899926115167e-16,
2.094366223285276e-17,
0.00002954788777430395,
-5.58117083317212e-11,
-6.4255495652647e-11,
-4.93177494507687e-11,
-2.838938753127061e-11,
-1.307362005516392e-11,
-5.017051985630978e-12,
-1.650223835840251e-12,
-4.749214222979657e-13,
-1.214790384964294e-13,
-2.795958444693603e-14,
-5.847613026313973e-15,
-1.119832926731249e-15,
-1.976748826466992e-16,
-3.298112797853108e-17,
-4.975386494682394e-18,
-6.404261468821201e-6,
1.179121702839705e-11,
1.357511802019338e-11,
1.041925396127548e-11,
5.9977653751215e-12,
2.762036797536796e-12,
1.059942984403096e-12,
3.486401219340456e-13,
1.003361608974455e-13,
2.566489482241544e-14,
5.907091600076631e-15,
1.235467505030006e-15,
2.366057196060327e-16,
4.176981518439976e-17,
6.970543863552277e-18,
1.051955431157579e-18,
1.250024365956273e-6,
-2.244787432652635e-12,
-2.584402909021191e-12,
-1.983596196741532e-12,
-1.141842458189734e-12,
-5.25831160938905e-13,
-2.017900049080361e-13,
-6.637355602166e-14,
-1.910189049686869e-14,
-4.886080983950231e-15,
-1.124603635664104e-15,
-2.352157094108876e-16,
-4.504831600544531e-17,
-7.95340350152671e-18,
-1.327525089078316e-18,
-2.004157319702729e-19,
-2.219351680254354e-7,
3.88967400365755e-13,
4.4781457074176e-13,
3.437093133378236e-13,
1.978537515032163e-13,
9.11138833917717e-14,
3.496537275492284e-14,
1.150096135776061e-14,
3.309912422781315e-15,
8.46648220716654e-16,
1.948705471499349e-16,
4.075884317521905e-17,
7.80640869570783e-18,
1.378344851988078e-18,
2.301119306825837e-19,
3.476287457306473e-20,
3.613475117297413e-8,
-6.18441034557143e-14,
-7.12005470188501e-14,
-5.46482730934591e-14,
-3.145788328675883e-14,
-1.448671428291109e-14,
-5.55934671432207e-15,
-1.828606512387502e-15,
-5.262639988714294e-16,
-1.346146230367744e-16,
-3.098415135460179e-17,
-6.48072641241774e-18,
-1.24128080575747e-18,
-2.191811621545221e-19,
-3.659761629128368e-20,
-5.53404558963887e-21,
-5.434565547729025e-9,
9.08775872572768e-15,
1.046265333943046e-14,
8.03035934042422e-15,
4.622618953046671e-15,
2.128769393855061e-15,
8.1692602359215e-16,
2.68707463162884e-16,
7.73328693025733e-17,
1.978129538441255e-17,
4.553084534677123e-18,
9.52342625811639e-19,
1.824238806923028e-19,
3.224135189061518e-20,
5.369661503718115e-21,
7.82494213961961e-22,
7.716145521100278e-10,
-1.260490204939736e-15,
-1.451190872489685e-15,
-1.113826924805112e-15,
-6.41166597463282e-16,
-2.952647028764275e-16,
-1.133093869160628e-16,
-3.727034169043935e-17,
-1.072627033310689e-17,
-2.743729706083956e-18,
-6.315339681507547e-19,
-1.320957597452805e-19,
-2.530227707311297e-20,
-4.474317207902693e-21,
-7.47285747521011e-22,
-1.071533880134756e-22,
-1.004841103493636e-10,
1.605621023459035e-16,
1.848536894811604e-16,
1.418800474374682e-16,
8.16722571683819e-17,
3.76110375718393e-17,
1.443344156964503e-17,
4.747531461598753e-18,
1.366324612658374e-18,
3.494988819520011e-19,
8.04500739919843e-20,
1.683853147299706e-20,
3.213494612274667e-21,
5.387402671483542e-22,
1.059562328401753e-22,
4.757279942093814e-23,
// [{0,0.00001},{2.,0.0001}]: m=33
0.00565449342474973,
-1.30460236855873e-8,
-1.50197587761358e-8,
-1.152804321574894e-8,
-6.63602023260374e-9,
-3.05594970451705e-9,
-1.172725242102427e-9,
-3.8573157067529e-10,
-1.110077765220651e-10,
-2.83930214886188e-11,
-6.53428659146572e-12,
-1.366345081654372e-12,
-2.61555945264401e-13,
-4.61336657550446e-14,
-7.68306265916026e-15,
-1.155010808022591e-15,
-0.01097198723998678,
2.4538334725718e-8,
2.82507453070479e-8,
2.168316150459081e-8,
1.248173114347554e-8,
5.74795753872554e-9,
2.205789554804517e-9,
7.25527529288448e-10,
2.087968436916189e-10,
5.34054733125767e-11,
1.229078458253519e-11,
2.57013766588245e-12,
4.92027691525487e-13,
8.67963687039127e-14,
1.445951503808752e-14,
2.17501828397339e-15,
0.01065447622966645,
-2.3119289252613e-8,
-2.66170137335585e-8,
-2.042923370835103e-8,
-1.175992094538334e-8,
-5.41555963878516e-9,
-2.078233271771144e-9,
-6.83573102357933e-10,
-1.967237087025765e-10,
-5.03178356487817e-11,
-1.15803748496726e-11,
-2.421659430608797e-12,
-4.63632009615603e-13,
-8.1797581172849e-14,
-1.363075772896481e-14,
-2.051495475550497e-15,
-0.00690320796427857,
1.454653018407458e-8,
1.674728023780956e-8,
1.285396419152374e-8,
7.39928084199697e-9,
3.407443413648065e-9,
1.30761533071214e-9,
4.30102015064803e-10,
1.237783868190453e-10,
3.166017236728629e-11,
7.28652336365836e-12,
1.523784909664748e-12,
2.917491403798894e-13,
5.14787972267453e-14,
8.58079751609787e-15,
1.292126203552527e-15,
0.003357177265643364,
-6.87559958829595e-9,
-7.91581208086851e-9,
-6.07558807451721e-9,
-3.497364046309479e-9,
-1.610572097527514e-9,
-6.18061796367509e-10,
-2.03293797615008e-10,
-5.85058078833443e-11,
-1.496478426055454e-11,
-3.44416222038521e-12,
-7.20276128414031e-13,
-1.379142151216891e-13,
-2.43375355386575e-14,
-4.057781072129515e-15,
-6.113349671501284e-16,
-0.001307110488182396,
2.60386387368607e-9,
2.997803740748205e-9,
2.300891221233419e-9,
1.324490038535429e-9,
6.09941529330658e-10,
2.340670543914666e-10,
7.69898071537946e-11,
2.21569261456355e-11,
5.66739970395287e-12,
1.304375683585394e-12,
2.727906961092979e-13,
5.223508504605745e-14,
9.21883174431527e-15,
1.537426170016907e-15,
2.31732003848125e-16,
0.0004244013680536011,
-8.2295466379854e-10,
-9.47459932219638e-10,
-7.27199857140478e-10,
-4.186069922833337e-10,
-1.927729773097316e-10,
-7.39773171970956e-11,
-2.433280600487082e-11,
-7.00276932349038e-12,
-1.791211429365092e-12,
-4.122599096372673e-13,
-8.62201505986517e-14,
-1.651060656854204e-14,
-2.914205058701472e-15,
-4.861149738902206e-16,
-7.33028172053176e-17,
-0.0001181915515922747,
2.232468341009775e-10,
2.570219835017936e-10,
1.972709984870985e-10,
1.13557550518836e-10,
5.22944804019839e-11,
2.006820801210964e-11,
6.60089536624956e-12,
1.899685695779126e-12,
4.85916155670793e-13,
1.118383381756321e-13,
2.339045218603619e-14,
4.479331722387251e-15,
7.90699534228133e-16,
1.319245124383632e-16,
1.990154512931473e-17,
0.00002881917655267552,
-5.30604765404998e-11,
-6.10880309903776e-11,
-4.68866427486089e-11,
-2.698994414364695e-11,
-1.242916556846895e-11,
-4.769743421967436e-12,
-1.568880546122336e-12,
-4.51512723295525e-13,
-1.154920265103138e-13,
-2.658191215767545e-14,
-5.559603766413118e-15,
-1.064725733523017e-15,
-1.879641600395673e-16,
-3.136745058080051e-17,
-4.733808159839277e-18,
-6.250116548213608e-6,
1.122392890486711e-11,
1.292200503728931e-11,
9.91797368620895e-12,
5.70920809019405e-12,
2.629153870197001e-12,
1.00894928216579e-12,
3.318675359220203e-13,
9.55093822081921e-14,
2.443038694281393e-14,
5.623014040186904e-15,
1.176077683900132e-15,
2.252414150357341e-16,
3.976698208752338e-17,
6.637619819626523e-18,
1.002084250137681e-18,
1.220643789094292e-6,
-2.13932126068778e-12,
-2.462980782278473e-12,
-1.890401717030004e-12,
-1.088195917446585e-12,
-5.0112648952256e-13,
-1.923096003732355e-13,
-6.32553039863965e-14,
-1.820452308071758e-14,
-4.656566433859344e-15,
-1.071788282377125e-15,
-2.241736758494111e-16,
-4.293527807307825e-17,
-7.58095343413989e-18,
-1.265594999048234e-18,
-1.911362971457692e-19,
-2.168384724427299e-7,
3.71111475127122e-13,
4.27257225151506e-13,
3.279310412579082e-13,
1.887711328966088e-13,
8.69312611588384e-14,
3.336029218142606e-14,
1.097302447663648e-14,
3.157982708391113e-15,
8.07789729926828e-16,
1.859283853193545e-16,
3.888926208156216e-17,
7.44862252097011e-18,
1.315271438782842e-18,
2.196161101593395e-19,
3.318937556293204e-20,
3.53235258285527e-8,
-5.90686709346159e-14,
-6.8005219533151e-14,
-5.21957798040942e-14,
-3.004612754662377e-14,
-1.383658860324644e-14,
-5.309860871048309e-15,
-1.746546448476395e-15,
-5.026486627551432e-16,
-1.285745747430772e-16,
-2.959418902486109e-17,
-6.190108478986817e-18,
-1.185659502232429e-18,
-2.093836416861699e-19,
-3.496831053208889e-20,
-5.280180893901115e-21,
-5.315236262333765e-9,
8.68885857714746e-15,
1.000340359465218e-14,
7.67787370547611e-15,
4.419713718992091e-15,
2.035329745714752e-15,
7.8106851164962e-16,
2.569133078540814e-16,
7.39387219859961e-17,
1.891317568092393e-17,
4.353310040535742e-18,
9.10570143934558e-19,
1.744170803278818e-19,
3.083178759100993e-20,
5.149432499759837e-21,
7.50787524326497e-22,
7.550465737446868e-10,
-1.206382996838135e-15,
-1.388897782595735e-15,
-1.06601541941761e-15,
-6.13644322046494e-16,
-2.825904472185133e-16,
-1.084456308381107e-16,
-3.56705656776176e-17,
-1.026588199610956e-17,
-2.625974690628624e-18,
-6.04434446435838e-19,
-1.264336186938139e-19,
-2.421961348724699e-20,
-4.272169198315273e-21,
-7.132482671945954e-22,
-1.141271907806528e-22,
-9.83716901608753e-11,
1.538140466733587e-16,
1.770847198046746e-16,
1.35917168212656e-16,
7.82397771680046e-17,
3.603034900191667e-17,
1.382685049632524e-17,
4.548012646530554e-18,
1.30890697448461e-18,
3.348122771924194e-19,
7.70660885340419e-20,
1.613286158136547e-20,
3.091036337900762e-21,
5.163399333245171e-22,
8.664035051052412e-23,
4.146170877275371e-23,
// [{0,0.00001},{2.,0.0001}]: m=34
0.00548599361999339,
-1.2269167362859e-8,
-1.4125372653524e-8,
-1.08415807522954e-8,
-6.24086557173777e-9,
-2.87397876936277e-9,
-1.102894777402258e-9,
-3.62763764644224e-10,
-1.043984218458094e-10,
-2.67027366562884e-11,
-6.1453922912676e-12,
-1.285068832941225e-12,
-2.46013845762743e-13,
-4.33981843519564e-14,
-7.22975751904376e-15,
-1.087509141986696e-15,
-0.01065447622966645,
2.3119289252613e-8,
2.66170137335585e-8,
2.042923370835102e-8,
1.175992094538334e-8,
5.41555963878516e-9,
2.078233271771144e-9,
6.83573102357933e-10,
1.967237087025764e-10,
5.03178356487817e-11,
1.15803748496726e-11,
2.421659430608797e-12,
4.63632009615603e-13,
8.1797581172849e-14,
1.363075772896481e-14,
2.05149547555052e-15,
0.01035481194641785,
-2.18197952761119e-8,
-2.51209203567143e-8,
-1.928094628728561e-8,
-1.109892126299546e-8,
-5.1111651204721e-9,
-1.961422996068211e-9,
-6.45153022597205e-10,
-1.85667580228568e-10,
-4.74902585509294e-11,
-1.092978504548753e-11,
-2.285677364497122e-12,
-4.37623710569834e-13,
-7.72181958401185e-14,
-1.287119627414688e-14,
-1.938189305328207e-15,
-0.00671435453128721,
1.375119917659264e-8,
1.583162416173787e-8,
1.215117614903508e-8,
6.99472809261933e-9,
3.221144195055201e-9,
1.236123592735084e-9,
4.065875952300379e-10,
1.170116157666949e-10,
2.992956852111069e-11,
6.88832444077079e-12,
1.440552256828139e-12,
2.758284302433938e-13,
4.867507107731953e-14,
8.11556214425854e-15,
1.222669934298396e-15,
0.003267776220455824,
-6.50965968421493e-9,
-7.49450935187023e-9,
-5.75222805308333e-9,
-3.311225096338446e-9,
-1.524853823326587e-9,
-5.85167635978644e-10,
-1.924745178844792e-10,
-5.53923153640866e-11,
-1.416849925988163e-11,
-3.260939208963359e-12,
-6.81976740273233e-13,
-1.305877126151416e-13,
-2.304707936074989e-14,
-3.843565425037482e-15,
-5.793300096580433e-16,
-0.001273204104137667,
2.4688639913602e-9,
2.84237979661814e-9,
2.181599571390138e-9,
1.255820976831986e-9,
5.78318931920898e-10,
2.21931951588103e-10,
7.29984180135652e-11,
2.100830797016975e-11,
5.37363428801818e-12,
1.236779728894064e-12,
2.586604517922573e-13,
4.953181970488997e-14,
8.74261517594602e-15,
1.458344921679893e-15,
2.199084516431554e-16,
0.0004136704305774052,
-7.81363919360084e-10,
-8.99576942263948e-10,
-6.90448494710732e-10,
-3.974514268193151e-10,
-1.830306814085043e-10,
-7.02387280429827e-11,
-2.310313378207045e-11,
-6.64889993528364e-12,
-1.700706544862353e-12,
-3.914341836180667e-13,
-8.18665826514621e-14,
-1.567766102841592e-14,
-2.767448370723133e-15,
-4.61735793651068e-16,
-6.965540705781479e-17,
-0.0001152767066955675,
2.122419069042266e-10,
2.4435212481603e-10,
1.875465716503019e-10,
1.079597769521327e-10,
4.97166624477398e-11,
1.907897375459106e-11,
6.27552220643575e-12,
1.806050899498252e-12,
4.619681076569287e-13,
1.063276490024858e-13,
2.223841514339311e-14,
4.258902949319518e-15,
7.51856642844686e-16,
1.2546980236603e-16,
1.893523272503652e-17,
0.00002812552441109176,
-5.05076799881359e-11,
-5.81490225713627e-11,
-4.46308815139207e-11,
-2.569143636326433e-11,
-1.183119239626459e-11,
-4.540271762216032e-12,
-1.493403909172364e-12,
-4.297922192240491e-13,
-1.099367410594335e-13,
-2.530356313868048e-14,
-5.292349573030484e-15,
-1.013586366858239e-15,
-1.789514086644711e-16,
-2.986928777876566e-17,
-4.509389356041204e-18,
-6.103213772652438e-6,
1.069659838499407e-11,
1.231489479495823e-11,
9.45200158804724e-12,
5.44097555939866e-12,
2.505630592746717e-12,
9.61547290050484e-13,
3.162762857969827e-13,
9.10225480198707e-14,
2.328281493272255e-14,
5.358937445007818e-15,
1.120867548809872e-15,
2.14676229424391e-16,
3.790474111382387e-17,
6.327972728825044e-18,
9.5567801770405e-19,
1.192611956026261e-6,
-2.041113649340634e-12,
-2.349915355588129e-12,
-1.803621200677838e-12,
-1.0382415036477e-12,
-4.781220619628338e-13,
-1.83481655193444e-13,
-6.03516504737005e-14,
-1.736890945849873e-14,
-4.442844687136621e-15,
-1.022606389067475e-15,
-2.138909717100405e-16,
-4.096742916398593e-17,
-7.2340576210919e-18,
-1.207897390730274e-18,
-1.824806222811292e-19,
-2.119705033850724e-7,
3.5445695128244e-13,
4.08083039723167e-13,
3.132143772212201e-13,
1.802996173897345e-13,
8.30300552907435e-14,
3.186320374663705e-14,
1.048060706699471e-14,
3.016274280946152e-15,
7.7154524073153e-16,
1.775876423361298e-16,
3.71453631717256e-17,
7.11486429637803e-18,
1.256448948605845e-18,
2.098297793125316e-19,
3.170028276357978e-20,
3.454790867996898e-8,
-5.64758909913157e-14,
-6.50201779595672e-14,
-4.99046859355336e-14,
-2.872727965174637e-14,
-1.322924752686802e-14,
-5.076793427368759e-15,
-1.669886539552937e-15,
-4.805873137214619e-16,
-1.229319468608704e-16,
-2.829566501669308e-17,
-5.918607717711973e-18,
-1.133693842939497e-18,
-2.0021134427222e-19,
-3.344430110496795e-20,
-5.062140631577334e-21,
-5.201032505390665e-9,
8.31564766160018e-15,
9.57372958458088e-15,
7.34808815102108e-15,
4.229875546494585e-15,
1.947907558837647e-15,
7.47520176042338e-16,
2.458786631169447e-16,
7.0763138587977e-17,
1.810094769776647e-17,
4.166390713527559e-18,
8.71507558811288e-19,
1.669422790589266e-19,
2.94612864552677e-20,
4.922135179712114e-21,
7.700242409043706e-22,
7.391748590218508e-10,
-1.155685162671971e-15,
-1.330529868121991e-15,
-1.021216580031162e-15,
-5.87856256473948e-16,
-2.707148061922694e-16,
-1.038883402350566e-16,
-3.417158913191804e-17,
-9.83450070844476e-18,
-2.515639740366926e-18,
-5.790419990244824e-19,
-1.211197705407585e-19,
-2.320456391699532e-20,
-4.105296758895983e-21,
-6.821775413898381e-22,
-9.59147650080271e-23,
-9.63462250189759e-11,
1.474824902588904e-16,
1.697952612604971e-16,
1.303223252952621e-16,
7.50191534913886e-17,
3.454722170222676e-17,
1.325769831052701e-17,
4.360807263273296e-18,
1.255032024634649e-18,
3.210369078347964e-19,
7.3896468263019e-20,
1.544844020247067e-20,
2.95855255520242e-21,
5.472915716997836e-22,
9.02929918911118e-23,
-1.31594664406958e-23,
// [{0,0.00001},{2.,0.0001}]: m=35
0.00532723811483322,
-1.15596446263065e-8,
-1.33085068667793e-8,
-1.021461685417551e-8,
-5.87996047269167e-9,
-2.70777981939258e-9,
-1.039116635885572e-9,
-3.41786551178966e-10,
-9.83618543512882e-11,
-2.51589178243908e-11,
-5.7901874248363e-12,
-1.210829715304398e-12,
-2.31816004807801e-13,
-4.08987905864245e-14,
-6.81537886448241e-15,
-1.02574773777526e-15,
-0.01035481194641785,
2.18197952761119e-8,
2.51209203567143e-8,
1.928094628728561e-8,
1.109892126299545e-8,
5.1111651204721e-9,
1.96142299606821e-9,
6.45153022597205e-10,
1.85667580228568e-10,
4.74902585509294e-11,
1.092978504548753e-11,
2.285677364497121e-12,
4.37623710569834e-13,
7.72181958401185e-14,
1.287119627414688e-14,
1.938189305328207e-15,
0.01007153179693082,
-2.0626798764889e-8,
-2.374743624260681e-8,
-1.822676422355262e-8,
-1.0492092138929e-8,
-4.8317162925828e-9,
-1.854185389102626e-9,
-6.09881392845057e-10,
-1.755174236500424e-10,
-4.4894352781666e-11,
-1.033248666115619e-11,
-2.160828385242209e-12,
-4.137426453650908e-13,
-7.30126066159791e-14,
-1.217334321638773e-14,
-1.834004901447782e-15,
-0.00653555244091212,
1.301931936843057e-8,
1.498901870374127e-8,
1.150445610616728e-8,
6.62245019267725e-9,
3.04970764665334e-9,
1.170335271957352e-9,
3.849490357689793e-10,
1.107846307281793e-10,
2.83369985197648e-11,
6.52187841792707e-12,
1.363953480546541e-12,
2.611754252302982e-13,
4.60941587215037e-14,
7.68713085007465e-15,
1.15866001931438e-15,
0.003183010260344004,
-6.17215997840027e-9,
-7.10594949154507e-9,
-5.45399892847513e-9,
-3.139552442079842e-9,
-1.44579732980219e-9,
-5.54829878970236e-10,
-1.82496045033906e-10,
-5.25207699254223e-11,
-1.343408572004492e-11,
-3.091949322235043e-12,
-6.4665112948061e-13,
-1.23829549262215e-13,
-2.185653793988502e-14,
-3.645862304205091e-15,
-5.497711290856678e-16,
-0.001241011291709546,
2.344091758046263e-9,
2.698730826752714e-9,
2.071345484102162e-9,
1.192354280440656e-9,
5.49092044217551e-10,
2.107161841258926e-10,
6.93094013452064e-11,
1.994669980556168e-11,
5.102119634513069e-12,
1.174302550837179e-12,
2.455997479508503e-13,
4.703298308453925e-14,
8.30234511197281e-15,
1.385207380962099e-15,
2.089662212573335e-16,
0.0004034684734388421,
-7.42846674171192e-10,
-8.55232436863472e-10,
-6.56413000781711e-10,
-3.778592193357195e-10,
-1.740083185685882e-10,
-6.6776408141644e-11,
-2.196432772271434e-11,
-6.32117814829835e-12,
-1.616888376813134e-12,
-3.721467715118598e-13,
-7.78344530027784e-14,
-1.49061603228742e-14,
-2.631498249365465e-15,
-4.391443081468373e-16,
-6.627331519955999e-17,
-0.0001125020981194502,
2.020307206648329e-10,
2.325960911055032e-10,
1.785235266850945e-10,
1.027657458153739e-10,
4.732476975190955e-11,
1.816108711289427e-11,
5.97361565775068e-12,
1.719168882957615e-12,
4.397469657883221e-13,
1.012142529114681e-13,
2.116939836630416e-14,
4.054345482159248e-15,
7.15805638491232e-16,
1.194771510640822e-16,
1.803755604035006e-17,
0.00002746446192217142,
-4.81346926520193e-11,
-5.5417026484686e-11,
-4.25340070751197e-11,
-2.448438997636979e-11,
-1.127533764851415e-11,
-4.326962797994889e-12,
-1.423243283707457e-12,
-4.096014654046774e-13,
-1.047726670227047e-13,
-2.411521846274182e-14,
-5.043903958251974e-15,
-9.6604302936961e-16,
-1.705713426018688e-16,
-2.847587879375499e-17,
-4.30054255360294e-18,
-5.963054711674627e-6,
1.020556064764939e-11,
1.17495680292183e-11,
9.01809928851449e-12,
5.19120365286645e-12,
2.390608529763481e-12,
9.17407592862069e-13,
3.017580276770216e-13,
8.6844482626369e-14,
2.221420689348364e-14,
5.113028138961071e-15,
1.069454065760193e-15,
2.048369899476112e-16,
3.617025123320826e-17,
6.039486121030327e-18,
9.12413205416512e-19,
1.165838119137127e-6,
-1.949513746996235e-12,
-2.244457311326472e-12,
-1.72267952974399e-12,
-9.91648157576936e-13,
-4.566654247225916e-13,
-1.752476668964776e-13,
-5.76433540949287e-14,
-1.65895129277706e-14,
-4.243499941239645e-15,
-9.76732288024185e-16,
-2.042995702272816e-16,
-3.913177182407475e-17,
-6.91042089315015e-18,
-1.154055393598747e-18,
-1.744059336319103e-19,
-2.073162083886839e-7,
3.3889845955242e-13,
3.90170704062974e-13,
2.994662127843564e-13,
1.723856082884852e-13,
7.93855843661333e-14,
3.046463619484125e-14,
1.002059403560335e-14,
2.883890768363199e-15,
7.37685532700772e-16,
1.697955880739227e-16,
3.551615210387398e-17,
6.80304083647157e-18,
1.201455348436104e-18,
2.006778336765418e-19,
3.034006522739066e-20,
3.380560654875872e-8,
-5.40500868520022e-14,
-6.22273738138131e-14,
-4.77611388693934e-14,
-2.74933655151397e-14,
-1.266101896261792e-14,
-4.858735251857333e-15,
-1.598163320964199e-15,
-4.599465885404618e-16,
-1.176526387017351e-16,
-2.708073386174216e-17,
-5.664570660923904e-18,
-1.08507161760266e-18,
-1.916483833448207e-19,
-3.201595538175029e-20,
-4.836107419387612e-21,
-5.091631117243621e-9,
7.96596733655659e-15,
9.17114608938134e-15,
7.03909521449355e-15,
4.052006428125937e-15,
1.865997197202235e-15,
7.16086983382555e-16,
2.35539709765309e-16,
6.77877537914119e-17,
1.733992625295647e-17,
3.99125505723233e-18,
8.34876461764995e-19,
1.599286094360395e-19,
2.82551927689047e-20,
4.720986412395024e-21,
7.042004614489819e-22,
7.239564365162565e-10,
-1.108116255623189e-15,
-1.275764253906793e-15,
-9.79182592597007e-16,
-5.63659749578228e-16,
-2.595720883920412e-16,
-9.96123065834759e-17,
-3.276512125822901e-17,
-9.42974046066941e-18,
-2.412111265829167e-18,
-5.552171642542151e-19,
-1.161431369235273e-19,
-2.224947341544638e-20,
-3.923552301880704e-21,
-6.555628545627487e-22,
-1.057014609323805e-22,
-9.44024559725398e-11,
1.415338598163625e-16,
1.629466613113605e-16,
1.250658519792536e-16,
7.19933088551754e-17,
3.315379143264185e-17,
1.27229670909396e-17,
4.184924038936146e-18,
1.2044154488543e-18,
3.080884573875532e-19,
7.091609645257946e-20,
1.48362155666737e-20,
2.842013942946399e-21,
4.946147492479233e-22,
8.33412842216049e-23,
2.319061848034465e-23,
// [{0,0.00001},{2.,0.0001}]: m=36
0.00517740597320892,
-1.09098976380559e-8,
-1.25604601783572e-8,
-9.6404731436428e-9,
-5.54946063149773e-9,
-2.55558256023605e-9,
-9.80711498034105e-10,
-3.22576511298602e-10,
-9.2833790114284e-11,
-2.37451292754647e-11,
-5.46489252274377e-12,
-1.142838682248561e-12,
-2.18811855284917e-13,
-3.86090979200593e-14,
-6.43559813707344e-15,
-9.69094652664104e-16,
-0.01007153179693082,
2.0626798764889e-8,
2.37474362426068e-8,
1.822676422355262e-8,
1.0492092138929e-8,
4.8317162925828e-9,
1.854185389102626e-9,
6.09881392845057e-10,
1.755174236500424e-10,
4.4894352781666e-11,
1.033248666115618e-11,
2.160828385242209e-12,
4.13742645365091e-13,
7.30126066159791e-14,
1.217334321638773e-14,
1.834004901447781e-15,
0.00980332866136818,
-1.95289790526459e-8,
-2.24835280556119e-8,
-1.725668415925092e-8,
-9.93367528901588e-9,
-4.57456146998001e-9,
-1.755502907936028e-9,
-5.77423553653469e-10,
-1.66176946092269e-10,
-4.25054977796472e-11,
-9.78281762689061e-12,
-2.045930220819811e-12,
-3.917631378454472e-13,
-6.91412380822558e-14,
-1.153069627511207e-14,
-1.737990028971355e-15,
-0.00636602052068847,
1.234431995680122e-8,
1.421189898309093e-8,
1.090799785695087e-8,
6.27910488416003e-9,
2.891594659604539e-9,
1.109659757940533e-9,
3.64992090067832e-10,
1.050415398508504e-10,
2.686817144009133e-11,
6.18389864447043e-12,
1.293302258961292e-12,
2.47659098524444e-13,
4.371307587977118e-14,
7.29172460841007e-15,
1.099542258172242e-15,
0.003102528229273705,
-5.86022939511543e-9,
-6.74682706688152e-9,
-5.1783637102552e-9,
-2.980885701101524e-9,
-1.372730110543824e-9,
-5.26790460314711e-10,
-1.732735033630091e-10,
-4.98667495139022e-11,
-1.275529908628217e-11,
-2.93575637709283e-12,
-6.13999369877105e-13,
-1.175824577113477e-13,
-2.075586277992016e-14,
-3.46301845240021e-15,
-5.224155531559277e-16,
-0.001210405420294305,
2.228540022480933e-9,
2.565697310552833e-9,
1.969239002316287e-9,
1.133577657990553e-9,
5.22024955698118e-10,
2.003292244219973e-10,
6.58929831671778e-11,
1.896353444461724e-11,
4.850665130368349e-12,
1.116440314519227e-12,
2.335033590048842e-13,
4.471848096795114e-14,
7.89449474804086e-15,
1.31743292444097e-15,
1.988199455463971e-16,
0.000393757343422347,
-7.07107522333066e-10,
-8.14086318876343e-10,
-6.24832343403266e-10,
-3.596801103569375e-10,
-1.656366941331243e-10,
-6.35638048956829e-11,
-2.090765480230924e-11,
-6.01709109040399e-12,
-1.539114380272529e-12,
-3.542498851932494e-13,
-7.40928942826357e-14,
-1.419020918759414e-14,
-2.505319734968254e-15,
-4.181700288305402e-16,
-6.313144586542089e-17,
-0.0001098578481543733,
1.925387712922033e-10,
2.216681067263724e-10,
1.701360289050042e-10,
9.79375602534703e-11,
4.510135075431077e-11,
1.730785125347808e-11,
5.69297315505837e-12,
1.638405867440473e-12,
4.19090669579905e-13,
9.64608741936768e-14,
2.017561590521766e-14,
3.864172131479794e-15,
6.82285371721071e-16,
1.139035152535673e-16,
1.720217127960476e-17,
0.00002683374614883335,
-4.59250228370877e-11,
-5.28730560424477e-11,
-4.05814467299788e-11,
-2.336041639856164e-11,
-1.075773836582031e-11,
-4.128334160927428e-12,
-1.35791112225994e-12,
-3.908001711606001e-13,
-9.99639308522399e-14,
-2.300862658631868e-14,
-4.81254328850034e-15,
-9.21766454008807e-16,
-1.627661279178309e-16,
-2.71776865292612e-17,
-4.105862480655998e-18,
-5.829185627464968e-6,
9.74756143638292e-12,
1.122227815382153e-11,
8.61339119934109e-12,
4.9582370753431e-12,
2.283325413942194e-12,
8.76237678385653e-13,
2.882165546665787e-13,
8.29475025294189e-14,
2.12174838195396e-14,
4.883657783745319e-15,
1.021497082046907e-15,
1.956587103792505e-16,
3.455208811638511e-17,
5.770275328918851e-18,
8.72019903015072e-19,
1.14023948985918e-6,
-1.863942022514965e-12,
-2.145939442208565e-12,
-1.647064607698253e-12,
-9.48121097364022e-13,
-4.366208299603058e-13,
-1.675555435668703e-13,
-5.511328183150729e-14,
-1.586140343800112e-14,
-4.057271507695932e-15,
-9.33875983428497e-16,
-1.953388849270299e-16,
-3.741673117942411e-17,
-6.60801968148433e-18,
-1.103732698443813e-18,
-1.668518658595319e-19,
-2.028618269073727e-7,
3.24341930076746e-13,
3.73411916653274e-13,
2.866034240921071e-13,
1.649812563824164e-13,
7.59758136788999e-14,
2.915613390901155e-14,
9.59020432346999e-15,
2.760031912148325e-15,
7.06005967729057e-16,
1.625051486722865e-16,
3.399178023958896e-17,
6.51127050283465e-18,
1.149998303411199e-18,
1.921089872251826e-19,
2.90590133770176e-20,
3.309451895050437e-8,
-5.17772276665361e-14,
-5.9610653542626e-14,
-4.57527403873455e-14,
-2.633724825452847e-14,
-1.212861635226877e-14,
-4.654425156076435e-15,
-1.530961986014585e-15,
-4.40607124310275e-16,
-1.127061240385985e-16,
-2.59423748701018e-17,
-5.426543186957061e-18,
-1.039510181302153e-18,
-1.836125786213633e-19,
-3.067731055140827e-20,
-4.635086097563273e-21,
-4.986735535465638e-9,
7.63788094781216e-15,
8.79342346158468e-15,
6.74918359062621e-15,
3.885121271668497e-15,
1.78914502219035e-15,
6.8659485353938e-16,
2.258391931061513e-16,
6.49960919347162e-17,
1.662589138528102e-17,
3.826933729450285e-18,
8.00510130230928e-19,
1.5333925294562e-19,
2.710845941087637e-20,
4.540780317174983e-21,
6.61651340265542e-22,
7.0935179843328e-10,
-1.063424074426288e-15,
-1.224310583541251e-15,
-9.39690601913472e-16,
-5.409265174123465e-16,
-2.491032185723847e-16,
-9.55948601665443e-17,
-3.144370555885599e-17,
-9.04945596253822e-18,
-2.314843760137872e-18,
-5.328324096319308e-19,
-1.114617568057462e-19,
-2.135248281068314e-20,
-3.76609579566139e-21,
-6.301704942593148e-22,
-1.016190738540604e-22,
-9.25355396262518e-11,
1.359378970093596e-16,
1.565040838807133e-16,
1.201210107716973e-16,
6.91468521370829e-17,
3.184297055835111e-17,
1.221993695387131e-17,
4.019467675873013e-18,
1.156800178319509e-18,
2.959080534082013e-19,
6.810834794783471e-20,
1.425587012762694e-20,
2.743159811110548e-21,
4.608678546317214e-22,
6.546523776154696e-23,
3.652516153958378e-23
}
,{
// [{0,0.0001},{2.,0.001}]: m=-1
48.02102665402209,
-57.32373297496431,
33.05723545371804,
-12.66486976017776,
3.65062842828516,
-0.839675452961072,
0.1611778873478245,
-0.02653282198113176,
0.003807141121508701,
-0.0004897957242940235,
0.00005596136937133466,
-5.87132013863754e-6,
5.796550041724301e-7,
-4.469841295626467e-8,
5.282926328289451e-9,
-1.687869742311659e-10,
-1.432226895012693,
0.06888932578355599,
0.03759706814740095,
0.01289561987730128,
0.002869339369869317,
0.0002996112679554335,
-0.0000662570510037279,
-0.00004468494970915405,
-0.00001338831640303826,
-2.537927375953536e-6,
-1.989623400288233e-7,
6.95860229040654e-8,
3.817754912490289e-8,
1.077124650878555e-8,
1.960175283314781e-9,
1.49882238571651e-10,
0.3786051702961769,
-0.000767185534510511,
-0.000858453714419276,
-0.000630934926615585,
-0.0003397388757139925,
-0.0001408649032577984,
-0.00004554153590523612,
-0.00001106846090450971,
-1.656848908216021e-6,
8.54313698926125e-8,
1.624054425910095e-7,
6.616196858089345e-8,
1.768471667272862e-8,
3.163162614972937e-9,
1.248980675047594e-10,
-1.388662691452453e-10,
-0.1336541494561748,
0.0000864662725411934,
0.0000993932484327838,
0.000076053598703056,
0.0000435167375323743,
0.00001980412961434969,
7.4249170731508e-6,
2.331899918895038e-6,
6.109404858075674e-7,
1.275476780746993e-7,
1.726037532765433e-8,
-8.93813447166593e-10,
-1.645852558803568e-9,
-7.12973816790485e-10,
-2.263659069443763e-10,
-5.194688260387262e-11,
0.04448111491880526,
-0.00001627101711958949,
-0.00001872288461692408,
-0.00001435529310411399,
-8.24626978851871e-6,
-3.781650641958394e-6,
-1.43910376165571e-6,
-4.654227364149111e-7,
-1.294140653751825e-7,
-3.081002772771367e-8,
-6.052556633564101e-9,
-8.4149069322271e-10,
-4.926198167386e-12,
5.19456871868548e-11,
2.685524316758694e-11,
8.62087984960331e-12,
-0.01323142176075637,
3.32107027778361e-6,
3.82236304144437e-6,
2.931991420412901e-6,
1.685741063561321e-6,
7.74426967291114e-7,
2.957520082257698e-7,
9.63358384949678e-8,
2.718293170976506e-8,
6.67700505138784e-9,
1.410409668207587e-9,
2.425767239106724e-10,
2.676700457022694e-11,
-2.14971477679239e-12,
-2.885185539885152e-12,
-1.118407396078726e-12,
0.003498810744242983,
-6.63819646647317e-7,
-7.64089253906457e-7,
-5.86212537061969e-7,
-3.371660527536172e-7,
-1.550083323536912e-7,
-5.92854172213933e-8,
-1.936915169551525e-8,
-5.498896659878151e-9,
-1.368065976794694e-9,
-2.972100267113107e-10,
-5.480599576958855e-11,
-7.71746188281797e-12,
-3.832721186810524e-13,
3.029551822706963e-13,
1.470859171503893e-13,
-0.000827044692035062,
1.256884964792139e-7,
1.446809380253402e-7,
1.110109760100837e-7,
6.38619081260894e-8,
2.937161140505651e-8,
1.124271047901404e-8,
3.679081038243184e-9,
1.047940313654526e-9,
2.624973343889202e-10,
5.786470370751664e-11,
1.103798264309746e-11,
1.710868020110938e-12,
1.594412185201518e-13,
-2.728056631103515e-14,
-1.914337529824247e-14,
0.0001761554124145428,
-2.228531921622011e-8,
-2.565359546726693e-8,
-1.968475649589784e-8,
-1.132557964041569e-8,
-5.210210627745628e-9,
-1.995340371120423e-9,
-6.53618930070773e-10,
-1.865566868082822e-10,
-4.692693701183988e-11,
-1.043654701982214e-11,
-2.030746653791339e-12,
-3.312618826418303e-13,
-3.803991945109317e-14,
1.412554557475289e-15,
2.388102978079952e-15,
-0.00003407994171994235,
3.68854960945801e-9,
4.2461395807918e-9,
3.258326367651829e-9,
1.874830505310079e-9,
8.62642784442323e-10,
3.304770397051854e-10,
1.083296787041122e-10,
3.096253796149069e-11,
7.81049932352483e-12,
1.747370005988438e-12,
3.44447855691739e-13,
5.799200152030055e-14,
7.406771133195857e-15,
1.580643502851627e-16,
-2.791966663769723e-16,
6.032991696537171e-6,
-5.70134918459281e-10,
-6.56331072898696e-10,
-5.03659069752685e-10,
-2.898216665946327e-10,
-1.333685404047106e-10,
-5.110589739519659e-11,
-1.676071969122311e-11,
-4.795305756128165e-12,
-1.212112505582582e-12,
-2.723229066300239e-13,
-5.41735859510269e-14,
-9.3183989993075e-15,
-1.269613459269369e-15,
-6.863392222993981e-17,
2.999651634597303e-17,
-9.83664990719458e-7,
8.24564507884492e-11,
9.49237772916846e-11,
7.28448418371035e-11,
4.191922068994122e-11,
1.929195262561307e-11,
7.39392104734087e-12,
2.425822421903528e-12,
6.94560530319417e-13,
1.758334989745955e-13,
3.962923929235433e-14,
7.93693986237743e-15,
1.386509368448683e-15,
1.972956323063134e-16,
1.478555300115983e-17,
-2.886756306238957e-18,
1.485641061091062e-7,
-1.118613700943079e-11,
-1.287758574407769e-11,
-9.88248416322899e-12,
-5.68717109894373e-12,
-2.617525031272476e-12,
-1.003350515804585e-12,
-3.292787319005523e-13,
-9.43343807938469e-14,
-2.390995932980516e-14,
-5.402031058036824e-15,
-1.087551682926809e-15,
-1.922145936024379e-16,
-2.821775869040511e-17,
-2.522940123414119e-18,
2.367707832768539e-19,
-2.089590823247337e-8,
1.427664512626457e-12,
1.643552726331945e-12,
1.261309422062311e-12,
7.25879370873878e-13,
3.341060281062499e-13,
1.280845731264119e-13,
4.204452579561749e-14,
1.205092002249075e-14,
3.057333359952182e-15,
6.92101188619949e-16,
1.39910207727191e-16,
2.495413422365772e-17,
3.750394239725406e-18,
3.751266493111653e-19,
-1.433518210184691e-20,
2.789147363442905e-9,
-1.740167476356508e-13,
-2.003323853142951e-13,
-1.537426764510496e-13,
-8.84805485335878e-14,
-4.072759675642128e-14,
-1.56150574479916e-14,
-5.126736578022542e-15,
-1.470016438176342e-15,
-3.732410167774304e-16,
-8.46293746746141e-17,
-1.716634566474671e-17,
-3.08463673474417e-18,
-4.723157879404586e-19,
-5.113880995018679e-20,
1.223214062406311e-22,
-3.440766644818779e-10,
1.979196842925603e-14,
2.278511635598537e-14,
1.748633600717828e-14,
1.006377171675723e-14,
4.632537454975632e-15,
1.776266587774524e-15,
5.83276564250453e-16,
1.672993647437164e-16,
4.250512671700951e-17,
9.6503817522426e-18,
1.962898501940955e-18,
3.548242167988057e-19,
5.50733976411664e-20,
6.310152616231479e-21,
1.931921552910251e-22,
// [{0,0.0001},{2.,0.001}]: m=0
0.716113447506346,
-0.034444662891778,
-0.01879853407370048,
-0.006447809938650639,
-0.001434669684934658,
-0.0001498056339777167,
0.00003312852550186395,
0.00002234247485457703,
6.694158201519128e-6,
1.268963687976768e-6,
9.94811700144116e-8,
-3.479301145203271e-8,
-1.908877456245145e-8,
-5.385623254392776e-9,
-9.80087641657391e-10,
-7.494111928582548e-11,
-0.3786051702961769,
0.000767185534510511,
0.000858453714419276,
0.000630934926615585,
0.0003397388757139925,
0.0001408649032577984,
0.00004554153590523612,
0.00001106846090450971,
1.65684890821602e-6,
-8.54313698926125e-8,
-1.624054425910095e-7,
-6.616196858089345e-8,
-1.768471667272862e-8,
-3.163162614972937e-9,
-1.248980675047594e-10,
1.388662691452453e-10,
0.2004812241842621,
-0.0001296994088117901,
-0.0001490898726491756,
-0.000114080398054584,
-0.0000652751062985615,
-0.00002970619442152453,
-0.00001113737560972621,
-3.497849878342558e-6,
-9.16410728711351e-7,
-1.91321517112049e-7,
-2.589056299148149e-8,
1.34072017074989e-9,
2.468778838205352e-9,
1.069460725185728e-9,
3.395488604165645e-10,
7.792032390580893e-11,
-0.0889622298376121,
0.0000325420342391791,
0.0000374457692338483,
0.00002871058620822806,
0.00001649253957703747,
7.56330128391681e-6,
2.878207523311428e-6,
9.30845472829825e-7,
2.588281307503657e-7,
6.162005545542752e-8,
1.210511326712824e-8,
1.682981386445429e-9,
9.8523963347736e-12,
-1.038913743737093e-10,
-5.371048633517385e-11,
-1.724175969920662e-11,
0.0330785544018904,
-8.30267569445899e-6,
-9.5559076036109e-6,
-7.32997855103223e-6,
-4.21435265890329e-6,
-1.936067418227779e-6,
-7.39380020564422e-7,
-2.408395962374187e-7,
-6.79573292744124e-8,
-1.669251262846953e-8,
-3.526024170518955e-9,
-6.064418097766783e-10,
-6.691751142556688e-11,
5.3742869419811e-12,
7.212963849712898e-12,
2.796018490196767e-12,
-0.01049643223265196,
1.991458939937842e-6,
2.292267761714642e-6,
1.758637611182278e-6,
1.011498158258763e-6,
4.650249970601123e-7,
1.778562516638111e-7,
5.81074550864247e-8,
1.649668997959972e-8,
4.104197930375252e-9,
8.91630080131925e-10,
1.644179873083565e-10,
2.315238564837954e-11,
1.149816356031379e-12,
-9.08865546813431e-13,
-4.412577514511299e-13,
0.002894656422136845,
-4.39909737677951e-7,
-5.06383283089499e-7,
-3.885384160359138e-7,
-2.2351667844167e-7,
-1.028006399178623e-7,
-3.934948667661221e-8,
-1.287678363387186e-8,
-3.667791097796785e-9,
-9.18740670362733e-10,
-2.025264629766523e-10,
-3.863293925091096e-11,
-5.988038070400926e-12,
-5.580442648237766e-13,
9.54819820881448e-14,
6.700181354517896e-14,
-0.0007046216512716314,
8.9141276950952e-8,
1.026143819681563e-7,
7.87390260596371e-8,
4.530231860542948e-8,
2.084084253112981e-8,
7.98136149220734e-9,
2.614475722820323e-9,
7.46226747961071e-10,
1.877077482324062e-10,
4.174618812134812e-11,
8.12298662373957e-12,
1.325047532125832e-12,
1.521596780506174e-13,
-5.650218201478136e-15,
-9.5524119125238e-15,
0.0001533597375621232,
-1.659847323372793e-8,
-1.910762810339408e-8,
-1.466246864662894e-8,
-8.43673726940367e-9,
-3.881892527922721e-9,
-1.487146677880399e-9,
-4.87483553908062e-10,
-1.393314207519686e-10,
-3.514724693685266e-11,
-7.8631650226228e-12,
-1.550015349735084e-12,
-2.609640066824561e-13,
-3.333047005820811e-14,
-7.11289570255761e-16,
1.256384981819018e-15,
-0.00003016494126963626,
2.8506736740694e-9,
3.281654307398183e-9,
2.518294537493549e-9,
1.449107866061642e-9,
6.66842487088462e-10,
2.555294045572935e-10,
8.38035713884659e-11,
2.397652101481292e-11,
6.060560553800155e-12,
1.36161408444992e-12,
2.708678382818758e-13,
4.659197837258179e-14,
6.34806467400743e-15,
3.431693049547489e-16,
-1.499825843178661e-16,
5.410158585786174e-6,
-4.53510535871791e-10,
-5.22080840189953e-10,
-4.006466800545682e-10,
-2.305557425431847e-10,
-1.061057526751583e-10,
-4.066657083546658e-11,
-1.334202498740433e-11,
-3.820083395118073e-12,
-9.67084366025904e-13,
-2.179608437908666e-13,
-4.365317486003615e-14,
-7.62580254334369e-15,
-1.085126242152258e-15,
-8.13205799766808e-17,
1.587726741182461e-17,
-8.91482295071577e-7,
6.71220315358124e-11,
7.72715118006271e-11,
5.92995076468765e-11,
3.412567557466872e-11,
1.570636960277154e-11,
6.02057068994322e-12,
1.975825957314111e-12,
5.660503435008302e-13,
1.434709559325074e-13,
3.241473201409614e-14,
6.525829072710774e-15,
1.153381864008957e-15,
1.69321405562783e-16,
1.51393922703467e-17,
-1.420584916039998e-18,
1.358198205686524e-7,
-9.27964115103859e-12,
-1.068288759213321e-11,
-8.19835381559875e-12,
-4.718125304687159e-12,
-2.17164747250272e-12,
-8.32533730274643e-13,
-2.732841640321277e-13,
-7.83294725062725e-14,
-1.987228338824805e-14,
-4.498570478191809e-15,
-9.09398649400329e-16,
-1.621986676045063e-16,
-2.437672748561826e-17,
-2.438202572514619e-18,
9.28407742667169e-20,
-1.924354341548659e-8,
1.203155132044604e-12,
1.385101798521978e-12,
1.062979452569055e-12,
6.11755723665051e-13,
2.815909053169112e-13,
1.079624261141648e-13,
3.544610066766133e-14,
1.016357432809354e-14,
2.58051982380415e-15,
5.850942249605053e-16,
1.18673849515008e-16,
2.132164041236025e-17,
3.263615783373818e-18,
3.529073479789304e-19,
-1.039530602144817e-21,
2.584984978480699e-9,
-1.486590725683006e-13,
-1.711408502312924e-13,
-1.313412858495526e-13,
-7.55898078337689e-14,
-3.479536877928214e-14,
-1.334168648337843e-14,
-4.381040533085556e-15,
-1.256600873750398e-15,
-3.192604120455439e-16,
-7.248524996138361e-17,
-1.474352337427722e-17,
-2.665126438044643e-18,
-4.1407989237779e-19,
-4.747380599567242e-20,
-1.034507478814396e-21,
-3.20590735857459e-10,
1.710107554022612e-14,
1.968736113136778e-14,
1.510910429079345e-14,
8.69576837223407e-15,
4.002954971144075e-15,
1.534967195106978e-15,
5.041084426386114e-16,
1.446309461965557e-16,
3.676591378022891e-17,
8.35664270464468e-18,
1.703688637032291e-18,
3.095065720204116e-19,
4.861378344866118e-20,
5.819428417547224e-21,
2.841710482835484e-22,
// [{0,0.0001},{2.,0.001}]: m=1
0.1893025851480885,
-0.000383592767255255,
-0.000429226857209638,
-0.0003154674633077923,
-0.0001698694378569962,
-0.0000704324516288992,
-0.00002277076795261806,
-5.534230452254855e-6,
-8.2842445410801e-7,
4.27156849463062e-8,
8.12027212955047e-8,
3.308098429044673e-8,
8.84235833636431e-9,
1.581581307486468e-9,
6.24490337523797e-11,
-6.943313457262264e-11,
-0.2004812241842621,
0.0001296994088117901,
0.0001490898726491756,
0.000114080398054584,
0.0000652751062985615,
0.00002970619442152453,
0.00001113737560972621,
3.497849878342558e-6,
9.16410728711351e-7,
1.91321517112049e-7,
2.589056299148149e-8,
-1.34072017074989e-9,
-2.468778838205352e-9,
-1.069460725185728e-9,
-3.395488604165645e-10,
-7.792032390580893e-11,
0.1334433447564182,
-0.0000488130513587686,
-0.0000561686538507724,
-0.0000430658793123421,
-0.0000247388093655562,
-0.00001134495192587521,
-4.317311284967142e-6,
-1.396268209244737e-6,
-3.882421961255486e-7,
-9.24300831831413e-8,
-1.815766990069237e-8,
-2.524472079668144e-9,
-1.47785945021604e-11,
1.55837061560564e-10,
8.056572950276078e-11,
2.586263954880993e-11,
-0.0661571088037823,
0.00001660535138891805,
0.0000191118152072219,
0.00001465995710206452,
8.42870531780662e-6,
3.872134836455575e-6,
1.478760041128851e-6,
4.816791924748396e-7,
1.359146585488255e-7,
3.338502525693923e-8,
7.05204834103795e-9,
1.212883619553364e-9,
1.338350228511351e-10,
-1.074857388396198e-11,
-1.442592769942577e-11,
-5.592036980393537e-12,
0.0262410805816294,
-4.97864734984458e-6,
-5.73066940428658e-6,
-4.39659402795567e-6,
-2.528745395646896e-6,
-1.162562492650275e-6,
-4.446406291595257e-7,
-1.45268637716061e-7,
-4.12417249489991e-8,
-1.026049482593808e-8,
-2.229075200329801e-9,
-4.11044968270889e-10,
-5.788096412094843e-11,
-2.874540890078337e-12,
2.272163867033595e-12,
1.103144378627778e-12,
-0.00868396926633847,
1.319729213030269e-6,
1.519149849264372e-6,
1.165615248104575e-6,
6.70550035323188e-7,
3.084019197527478e-7,
1.180484600295149e-7,
3.86303509015099e-8,
1.100337329336003e-8,
2.756222011080485e-9,
6.075793889282021e-10,
1.158988177523745e-10,
1.796411421113738e-11,
1.674132794460831e-12,
-2.864459462657076e-13,
-2.010054406354744e-13,
0.002466175779463988,
-3.1199446932895e-7,
-3.59150336889259e-7,
-2.755865912092761e-7,
-1.585581151193176e-7,
-7.29429488590991e-8,
-2.793476522278122e-8,
-9.15066502988937e-9,
-2.611793617868984e-9,
-6.56977118814754e-10,
-1.461116584250217e-10,
-2.843045318315015e-11,
-4.637666362451585e-12,
-5.32558873180084e-13,
1.977576370471276e-14,
3.343344169502833e-14,
-0.0006134389517588052,
6.63938930100179e-8,
7.64305125000415e-8,
5.86498746528741e-8,
3.374694911580656e-8,
1.55275701292724e-8,
5.94858671826377e-9,
1.949934217846742e-9,
5.5732568364337e-10,
1.405889879090323e-10,
3.145266012726152e-11,
6.200061406450974e-12,
1.043856028100347e-12,
1.333218804520483e-13,
2.845158307770642e-15,
-5.02553992770104e-15,
0.000135742235546423,
-1.282803152553777e-8,
-1.476744437434145e-8,
-1.133232541185189e-8,
-6.52098539332391e-9,
-3.000791190078062e-9,
-1.149882319809845e-9,
-3.771160710188206e-10,
-1.078943445008495e-10,
-2.727252247535627e-11,
-6.127263376211408e-12,
-1.218905271493371e-12,
-2.096639025362401e-13,
-2.856629099634747e-14,
-1.544261866444646e-15,
6.749216145001461e-16,
-0.00002705077681628359,
2.267551878110538e-9,
2.610403278521023e-9,
2.003232692347989e-9,
1.152778305276881e-9,
5.30528575812489e-10,
2.033327822504469e-10,
6.67101013123265e-11,
1.910041019599075e-11,
4.835420105915433e-12,
1.089803826680201e-12,
2.182657941730547e-13,
3.812899809641025e-14,
5.425628877913974e-15,
4.066026138138043e-16,
-7.938633906367554e-17,
4.90315369138435e-6,
-3.69171223207041e-10,
-4.24993372189383e-10,
-3.261473360226132e-10,
-1.876912409644881e-10,
-8.63850444640643e-11,
-3.311314326200711e-11,
-1.086704423268379e-11,
-3.113277310455488e-12,
-7.89090364799806e-13,
-1.782810504839261e-13,
-3.589206486014905e-14,
-6.343601150118869e-15,
-9.3126796658284e-16,
-8.32666951559789e-17,
7.813313792584295e-18,
-8.15010338781873e-7,
5.56823927268262e-11,
6.4102558880549e-11,
4.91941392501957e-11,
2.831106340186088e-11,
1.303094896083883e-11,
4.995610453251424e-12,
1.63983901706975e-12,
4.700152985720766e-13,
1.192434825245255e-13,
2.699364840826399e-14,
5.456846499898212e-15,
9.7327494915496e-16,
1.462735759075006e-16,
1.463084220778622e-17,
-5.570053376563378e-19,
1.250796646391692e-7,
-7.82035153053033e-12,
-9.00298114353625e-12,
-6.9092278787986e-12,
-3.976332454343678e-12,
-1.830304171219599e-12,
-7.017416901866e-13,
-2.303950293894043e-13,
-6.60619056427317e-14,
-1.677304108556831e-14,
-3.803035540544413e-15,
-7.71364391309041e-16,
-1.385878332785544e-16,
-2.121275233411732e-17,
-2.293778479041264e-18,
6.445132932016128e-21,
-1.78323373536803e-8,
1.027557472889646e-12,
1.182955329677742e-12,
9.07853637475391e-13,
5.22489592134188e-13,
2.40511309454067e-13,
9.22197843666961e-14,
3.028232836942152e-14,
8.6857351285142e-15,
2.206727475265101e-15,
5.010047809817304e-16,
1.01898979581175e-16,
1.841767263157804e-17,
2.860671346821435e-18,
3.276344958201862e-19,
7.06354241752734e-21,
2.40857541778405e-9,
-1.284510939182061e-13,
-1.478774298850928e-13,
-1.134888287208e-13,
-6.53164203628798e-14,
-3.006734994322672e-14,
-1.152958341787885e-14,
-3.78650581962173e-15,
-1.086366002737287e-15,
-2.761600884971409e-16,
-6.276949800527201e-17,
-1.279689946272658e-17,
-2.324780551281339e-18,
-3.655367122605591e-19,
-4.379332715490169e-20,
-1.736884613838118e-21,
-3.000967190911536e-10,
1.492254083063418e-14,
1.717941689251523e-14,
1.318447227715122e-14,
7.58819074453352e-15,
3.493200177320069e-15,
1.339574507129917e-15,
4.399890369323374e-16,
1.262640545951299e-16,
3.211196274424035e-17,
7.30577775208239e-18,
1.492364169978748e-18,
2.722579286741192e-19,
4.325079806205489e-20,
5.361849447339295e-21,
2.675079096448836e-22,
// [{0,0.0001},{2.,0.001}]: m=2
0.1002406120921311,
-0.000064849704405895,
-0.0000745449363245878,
-0.000057040199027292,
-0.00003263755314928073,
-0.00001485309721076226,
-5.5686878048631e-6,
-1.748924939171279e-6,
-4.582053643556756e-7,
-9.56607585560245e-8,
-1.294528149574075e-8,
6.70360085374945e-10,
1.234389419102676e-9,
5.34730362592864e-10,
1.697744302082822e-10,
3.896016195290447e-11,
-0.1334433447564182,
0.0000488130513587686,
0.0000561686538507724,
0.0000430658793123421,
0.0000247388093655562,
0.00001134495192587521,
4.317311284967142e-6,
1.396268209244737e-6,
3.882421961255486e-7,
9.24300831831413e-8,
1.815766990069237e-8,
2.524472079668144e-9,
1.47785945021604e-11,
-1.55837061560564e-10,
-8.056572950276078e-11,
-2.586263954880993e-11,
0.0992356632056734,
-0.0000249080270833771,
-0.00002866772281083284,
-0.00002198993565309678,
-0.00001264305797670993,
-5.80820225468336e-6,
-2.218140061693276e-6,
-7.22518788712259e-7,
-2.038719878232382e-7,
-5.007753788540884e-8,
-1.057807251155692e-8,
-1.819325429330046e-9,
-2.007525342767027e-10,
1.612286082594296e-11,
2.163889154913865e-11,
8.38805547059031e-12,
-0.0524821611632602,
9.95729469968923e-6,
0.00001146133880857323,
8.79318805591141e-6,
5.05749079129383e-6,
2.325124985300566e-6,
8.89281258319057e-7,
2.905372754321239e-7,
8.24834498979988e-8,
2.05209896518763e-8,
4.458150400659635e-9,
8.22089936541785e-10,
1.157619282418981e-10,
5.74908178015687e-12,
-4.544327734067166e-12,
-2.206288757255555e-12,
0.02170992316584569,
-3.29932303257565e-6,
-3.79787462316091e-6,
-2.914038120261419e-6,
-1.676375088307958e-6,
-7.71004799381865e-7,
-2.951211500737854e-7,
-9.65758772537741e-8,
-2.75084332333999e-8,
-6.89055502770117e-9,
-1.518948472320495e-9,
-2.897470443809342e-10,
-4.491028552784306e-11,
-4.18533198615204e-12,
7.161148656642803e-13,
5.025136015887138e-13,
-0.00739852733832423,
9.35983407983696e-7,
1.077451010664145e-6,
8.26759773625041e-7,
4.75674345356349e-7,
2.188288465765588e-7,
8.38042956680605e-8,
2.745199508957508e-8,
7.83538085358025e-9,
1.970931356437467e-9,
4.383349752735183e-10,
8.52913595491339e-11,
1.391299908729678e-11,
1.597676619530985e-12,
-5.93272911152958e-14,
-1.003003250851625e-13,
0.002147036331168343,
-2.323786255356111e-7,
-2.675067937507766e-7,
-2.052745612855439e-7,
-1.181143219056019e-7,
-5.43464954525818e-8,
-2.082005351397242e-8,
-6.82476976247977e-9,
-1.950639892756439e-9,
-4.92061457682795e-10,
-1.100843104456847e-10,
-2.170021492263378e-11,
-3.653496098361301e-12,
-4.666265815832901e-13,
-9.95805407747165e-15,
1.758938974634614e-14,
-0.0005429689436052176,
5.13121261682567e-8,
5.90697775734694e-8,
4.53293017058142e-8,
2.608394160691143e-8,
1.200316477578756e-8,
4.599529285174158e-9,
1.50846428602478e-9,
4.315773785629595e-10,
1.090900900437924e-10,
2.450905353726208e-11,
4.875621092606704e-12,
8.38655611359702e-13,
1.142651641796413e-13,
6.177047490265253e-15,
-2.699686456337987e-15,
0.0001217284955158054,
-1.020398344460235e-8,
-1.174681474540668e-8,
-9.01454710947387e-9,
-5.18750237023964e-9,
-2.387378589542002e-9,
-9.14997519507939e-10,
-3.001954557020942e-10,
-8.59518458235738e-11,
-2.175939046175994e-11,
-4.904117216674774e-12,
-9.82196073082988e-13,
-1.71580491306925e-13,
-2.441532993556434e-14,
-1.829711758848565e-15,
3.572385323956528e-16,
-0.00002451575331280929,
1.845855410804964e-9,
2.124966049055554e-9,
1.630736057017077e-9,
9.38455846201332e-10,
4.319250572260899e-10,
1.655656529964442e-10,
5.433520036571914e-11,
1.556638058274578e-11,
3.945450305191344e-12,
8.91404906592829e-13,
1.794602535365976e-13,
3.171799279271567e-14,
4.656337759555481e-15,
4.163332130659502e-16,
-3.906658628542306e-17,
4.482557871182997e-6,
-3.06253204128721e-10,
-3.525641246488647e-10,
-2.70567804867858e-10,
-1.557108711520871e-10,
-7.16702296161332e-11,
-2.747586145519041e-11,
-9.01911589556451e-12,
-2.585084515831098e-12,
-6.55839248991937e-13,
-1.484650879180648e-13,
-3.001266020107972e-14,
-5.353013032774453e-15,
-8.0450476784312e-16,
-8.04696531398857e-17,
3.063491484521224e-18,
-7.50563908288278e-7,
4.69261102591883e-11,
5.40224930718761e-11,
4.145890236569371e-11,
2.386002933864641e-11,
1.098276167826889e-11,
4.210809346499566e-12,
1.38248817068267e-12,
3.964053015925489e-13,
1.006468633681975e-13,
2.282017527033577e-14,
4.628587820377762e-15,
8.31600511000735e-16,
1.272882833944648e-16,
1.376416659434946e-17,
-3.857653685301125e-20,
1.159070162544373e-7,
-6.6789844864018e-12,
-7.68904951909914e-12,
-5.90092575394121e-12,
-3.396111619317485e-12,
-1.563290949799383e-12,
-5.99416110454731e-13,
-1.96831031918597e-13,
-5.645610060057798e-14,
-1.43434288415118e-14,
-3.25646277084659e-15,
-6.623293404942325e-16,
-1.197123123003917e-16,
-1.859403828733052e-17,
-2.12955761806438e-18,
-4.580383872687194e-20,
-1.661325238335893e-8,
8.87666163889481e-13,
1.021912507940966e-12,
7.84268657930473e-13,
4.51371330117559e-13,
2.077812936482425e-13,
7.96754098539535e-14,
2.616664907145459e-14,
7.50729046118544e-15,
1.908372138695745e-15,
4.337513424793662e-16,
8.84252341748789e-17,
1.606233939040305e-17,
2.524937629072978e-18,
3.022479054338385e-19,
1.189943004668096e-20,
2.254635183587847e-9,
-1.120902484107969e-13,
-1.290427110263642e-13,
-9.90347976913772e-14,
-5.69984862656746e-14,
-2.623907901498463e-14,
-1.006217925454407e-14,
-3.304967213879382e-15,
-9.48429994377442e-16,
-2.412086580945119e-16,
-5.487740592712283e-17,
-1.120999256649295e-17,
-2.045083691417853e-18,
-3.247903648722694e-19,
-4.02971080042213e-20,
-2.13096955530698e-21,
-2.820585345040085e-10,
1.313434789683321e-14,
1.51208258081234e-14,
1.160466336850861e-14,
6.67903075722858e-15,
3.07474779800917e-15,
1.179164946775645e-15,
3.873405275908195e-16,
1.111777640684121e-16,
2.828659431762837e-17,
6.44076178065678e-18,
1.317899997485608e-18,
2.413022441148719e-19,
3.86700825015124e-20,
4.927953646027296e-21,
2.835332067836265e-22,
// [{0,0.0001},{2.,0.001}]: m=3
0.0667216723782091,
-0.0000244065256793843,
-0.0000280843269253862,
-0.00002153293965617104,
-0.0000123694046827781,
-5.67247596293761e-6,
-2.158655642483571e-6,
-6.98134104622369e-7,
-1.941210980627743e-7,
-4.62150415915706e-8,
-9.07883495034618e-9,
-1.262236039834072e-9,
-7.3892972510802e-12,
7.7918530780282e-11,
4.028286475138039e-11,
1.293131977440497e-11,
-0.0992356632056734,
0.0000249080270833771,
0.00002866772281083284,
0.00002198993565309678,
0.00001264305797670993,
5.80820225468336e-6,
2.218140061693276e-6,
7.22518788712259e-7,
2.038719878232382e-7,
5.007753788540884e-8,
1.057807251155692e-8,
1.819325429330046e-9,
2.007525342767027e-10,
-1.612286082594297e-11,
-2.163889154913865e-11,
-8.38805547059031e-12,
0.0787232417448903,
-0.00001493594204953385,
-0.00001719200821285985,
-0.00001318978208386711,
-7.58623618694074e-6,
-3.487687477950849e-6,
-1.333921887478586e-6,
-4.358059131481859e-7,
-1.237251748469981e-7,
-3.078148447781446e-8,
-6.68722560098945e-9,
-1.233134904812677e-9,
-1.736428923628471e-10,
-8.6236226702353e-12,
6.816491601100749e-12,
3.309433135883332e-12,
-0.04341984633169272,
6.59864606515136e-6,
7.59574924632188e-6,
5.82807624052289e-6,
3.352750176615947e-6,
1.542009598763743e-6,
5.90242300147576e-7,
1.9315175450755e-7,
5.50168664668003e-8,
1.378111005540246e-8,
3.037896944641019e-9,
5.794940887618742e-10,
8.98205710556872e-11,
8.37066397230426e-12,
-1.432229731328537e-12,
-1.005027203177429e-12,
0.01849631834581012,
-2.339958519959223e-6,
-2.693627526660342e-6,
-2.066899434062587e-6,
-1.189185863390863e-6,
-5.47072116441393e-7,
-2.095107391701495e-7,
-6.86299877239372e-8,
-1.958845213395047e-8,
-4.927328391093629e-9,
-1.095837438183787e-9,
-2.13228398872833e-10,
-3.478249771824161e-11,
-3.994191548827428e-12,
1.483182277882459e-13,
2.507508127129336e-13,
-0.006441108993441135,
6.97135876604036e-7,
8.02520381249109e-7,
6.1582368385416e-7,
3.543429657153829e-7,
1.630394863570904e-7,
6.24601605416661e-8,
2.047430928735681e-8,
5.85191967824563e-9,
1.476184373042356e-9,
3.302529313356801e-10,
6.51006447676198e-11,
1.096048829503224e-11,
1.399879744741435e-12,
2.987416223127267e-14,
-5.276816923901124e-14,
0.001900391302630114,
-1.795924415893881e-7,
-2.067442215077067e-7,
-1.586525559707825e-7,
-9.1293795624439e-8,
-4.20110767153711e-8,
-1.609835249815352e-8,
-5.279625001101176e-9,
-1.510520824974506e-9,
-3.818153151543293e-10,
-8.57816873806581e-11,
-1.706467382417301e-11,
-2.935294639768043e-12,
-3.99928074629717e-13,
-2.161966621614388e-14,
9.44890259651085e-15,
-0.00048691398340223,
4.08159338370373e-8,
4.69872590491219e-8,
3.605818848969573e-8,
2.075000951077238e-8,
9.54951437189335e-9,
3.65999008329565e-9,
1.200781824537649e-9,
3.438073837907325e-10,
8.70375619733914e-11,
1.961646889548975e-11,
3.928784298231221e-12,
6.86321966310644e-13,
9.76613199185822e-14,
7.31884705904548e-15,
-1.428954129632189e-15,
0.0001103208897586262,
-8.3063493424658e-9,
-9.56234721366229e-9,
-7.33831225113724e-9,
-4.22305130477518e-9,
-1.94366275607605e-9,
-7.45045437931195e-10,
-2.445084014641171e-10,
-7.0048712570209e-11,
-1.775452636008486e-11,
-4.011322076640538e-12,
-8.0757114029173e-13,
-1.427309674532691e-13,
-2.095351990583249e-14,
-1.873499455757135e-15,
1.757996466653907e-16,
-0.00002241277507078061,
1.53126539518615e-9,
1.762819903188862e-9,
1.352838471720881e-9,
7.78554037699031e-10,
3.583510016552433e-10,
1.373792511193945e-10,
4.509556102950449e-11,
1.292541728303486e-11,
3.27919489700842e-12,
7.42325132444891e-13,
1.500632380689912e-13,
2.676505360859464e-14,
4.022521962385745e-15,
4.023480160463803e-16,
-1.53174617663265e-17,
4.128102449351917e-6,
-2.58093645829855e-10,
-2.971237572594964e-10,
-2.280239978269672e-10,
-1.312301814010143e-10,
-6.04051984557295e-11,
-2.31594549439189e-11,
-7.6036861011895e-12,
-2.180229492520783e-12,
-5.535578334978187e-13,
-1.255109833624941e-13,
-2.545723700018966e-14,
-4.573803538626838e-15,
-7.000856346464019e-16,
-7.570293721305091e-17,
2.121158816489881e-19,
-6.955231446181034e-7,
4.007745541459e-11,
4.61383823070262e-11,
3.540868977178737e-11,
2.037847421863615e-11,
9.38057643485029e-12,
3.596815263669759e-12,
1.181090856966094e-12,
3.387666508359187e-13,
8.60682205712336e-14,
1.954051919392509e-14,
3.974333117039319e-15,
7.18339442757947e-16,
1.115748556140058e-16,
1.277874883669855e-17,
2.748728300220376e-19,
1.079831345047721e-7,
-5.76970587537059e-12,
-6.64228832812109e-12,
-5.09763654866065e-12,
-2.933850490899301e-12,
-1.350549333650683e-12,
-5.178790128573603e-13,
-1.700795553386088e-13,
-4.879633608663234e-14,
-1.240415109519116e-14,
-2.819322659284012e-15,
-5.747514493220695e-16,
-1.044029142950362e-16,
-1.64118632493097e-17,
-1.964541490491631e-18,
-7.7165499385473e-20,
-1.55496675493651e-8,
7.74440086250477e-13,
8.91565876714736e-13,
6.84238822845082e-13,
3.938066830304537e-13,
1.812875921457205e-13,
6.95201995005216e-14,
2.283416034157902e-14,
6.55271115589882e-15,
1.666496123299349e-15,
3.791370084507284e-16,
7.7444371955601e-17,
1.41272373403006e-17,
2.243073624068191e-18,
2.780836490846397e-19,
1.470674992651655e-20,
2.119138872788884e-9,
-9.86604653130835e-14,
-1.135821689587505e-13,
-8.7170031125901e-14,
-5.017046328595236e-14,
-2.309639480871484e-14,
-8.85746227199854e-15,
-2.909563240545061e-15,
-8.35127949187894e-16,
-2.124790792245925e-16,
-4.83808769611382e-17,
-9.89972955575064e-18,
-1.812584188203213e-18,
-2.902993683272677e-19,
-3.705002699431193e-20,
-2.359337971382327e-21,
-2.660606897522339e-10,
1.164869211500799e-14,
1.341051152475139e-14,
1.029211771501556e-14,
5.92366338001626e-15,
2.727067514027841e-15,
1.045875263919459e-15,
3.435865973558771e-16,
9.86364342154849e-17,
2.510461235282249e-17,
5.720336514587358e-18,
1.17222022998189e-18,
2.153040020752702e-19,
3.474900818865183e-20,
4.532729442232236e-21,
3.117561207136863e-22,
// [{0,0.0001},{2.,0.001}]: m=4
0.0496178316028367,
-0.00001245401354168854,
-0.00001433386140541642,
-0.00001099496782654839,
-6.32152898835496e-6,
-2.904101127341681e-6,
-1.109070030846638e-6,
-3.6125939435613e-7,
-1.019359939116191e-7,
-2.503876894270442e-8,
-5.28903625577846e-9,
-9.09662714665023e-10,
-1.003762671383513e-10,
8.06143041297148e-12,
1.081944577456933e-11,
4.194027735295153e-12,
-0.0787232417448903,
0.00001493594204953385,
0.00001719200821285985,
0.00001318978208386711,
7.58623618694074e-6,
3.487687477950849e-6,
1.333921887478586e-6,
4.35805913148186e-7,
1.237251748469981e-7,
3.078148447781446e-8,
6.68722560098945e-9,
1.233134904812677e-9,
1.736428923628471e-10,
8.6236226702353e-12,
-6.816491601100749e-12,
-3.309433135883332e-12,
0.0651297694975391,
-9.89796909772705e-6,
-0.00001139362386948282,
-8.74211436078433e-6,
-5.02912526492392e-6,
-2.313014398145615e-6,
-8.85363450221364e-7,
-2.89727631761325e-7,
-8.25252997002004e-8,
-2.06716650831037e-8,
-4.556845416961529e-9,
-8.69241133142811e-10,
-1.347308565835308e-10,
-1.255599595845639e-11,
2.148344596992805e-12,
1.507540804766143e-12,
-0.03699263669162151,
4.6799170399185e-6,
5.38725505332074e-6,
4.13379886812522e-6,
2.378371726781752e-6,
1.094144232882798e-6,
4.190214783403037e-7,
1.372599754478758e-7,
3.917690426790138e-8,
9.85465678218737e-9,
2.191674876367599e-9,
4.264567977456712e-10,
6.95649954364842e-11,
7.98838309765501e-12,
-2.966364555764718e-13,
-5.015016254258666e-13,
0.01610277248360242,
-1.742839691510072e-6,
-2.006300953122753e-6,
-1.539559209635385e-6,
-8.85857414288449e-7,
-4.075987158927221e-7,
-1.561504013541637e-7,
-5.118577321839153e-8,
-1.462979919561393e-8,
-3.690460932605853e-9,
-8.25632328339192e-10,
-1.627516119190479e-10,
-2.740122073758029e-11,
-3.499699361853538e-12,
-7.46854055781729e-14,
1.319204230975259e-13,
-0.005701173907829879,
5.38777324765666e-7,
6.20232664520244e-7,
4.7595766791014e-7,
2.738813868720467e-7,
1.260332301455285e-7,
4.829505749423627e-8,
1.583887500322984e-8,
4.531562474902359e-9,
1.145445945457601e-9,
2.573450621407459e-10,
5.119402147226702e-11,
8.80588391925769e-12,
1.19978422388158e-12,
6.48589986474549e-14,
-2.834670778957505e-14,
0.001704198941919053,
-1.428557684300705e-7,
-1.64455406672433e-7,
-1.262036597143237e-7,
-7.2625033287927e-8,
-3.342330030172971e-8,
-1.280996529157428e-8,
-4.202736385894751e-9,
-1.203325843271291e-9,
-3.04631466907819e-10,
-6.86576411344307e-11,
-1.375074504385385e-11,
-2.402126882095397e-12,
-3.418146197162079e-13,
-2.561596470691093e-14,
5.001339453596354e-15,
-0.0004412835603016199,
3.32253974222117e-8,
3.82493889149153e-8,
2.935324905080144e-8,
1.689220524572174e-8,
7.77465103655991e-9,
2.980181756425225e-9,
9.78033607400759e-10,
2.801948507242375e-10,
7.10181055532276e-11,
1.6045288332301e-11,
3.230284566448054e-12,
5.709238707860225e-13,
8.38140797817794e-14,
7.49399784374456e-15,
-7.031985855593577e-16,
0.0001008574876770924,
-6.89069427280726e-9,
-7.93268955798299e-9,
-6.08777311785754e-9,
-3.503493166833192e-9,
-1.612579506153786e-9,
-6.18206629540659e-10,
-2.029300244696e-10,
-5.81643777268006e-11,
-1.475637702460559e-11,
-3.340463093279363e-12,
-6.752845707496e-13,
-1.204427411365033e-13,
-1.810134881715361e-14,
-1.810566068793721e-15,
6.892858072807581e-17,
-0.00002064049872860255,
1.290467670681364e-9,
1.485618143361928e-9,
1.140119495700999e-9,
6.56150623004821e-10,
3.020258615313923e-10,
1.157972245739436e-10,
3.801841403103835e-11,
1.090114273227574e-11,
2.767787963167158e-12,
6.275546422229527e-13,
1.272861286596662e-13,
2.286900731483302e-14,
3.50042648447097e-15,
3.785144634727136e-16,
-1.060592743277197e-18,
3.825378200553315e-6,
-2.204260401771194e-10,
-2.537611434393427e-10,
-1.94747825019908e-10,
-1.120816262033023e-10,
-5.159317867897834e-11,
-1.978248712873098e-11,
-6.49600075766883e-12,
-1.863216879496563e-12,
-4.733752895130937e-13,
-1.074728729930176e-13,
-2.18588357350055e-14,
-3.950867587940293e-15,
-6.13661788093974e-16,
-7.028314186970552e-17,
-1.511823829672034e-18,
-6.479755027128229e-7,
3.46214036917582e-11,
3.98573776311793e-11,
3.05886187639644e-11,
1.760471420650165e-11,
8.10403778987035e-12,
3.107558575970855e-12,
1.020570801601262e-12,
2.92804853799664e-13,
7.44317392312595e-14,
1.691749382749839e-14,
3.448828348369489e-15,
6.264763619267371e-16,
9.84807535650926e-17,
1.178851723085295e-17,
4.630755836455327e-19,
1.010699862955196e-7,
-5.03374900085014e-12,
-5.79504976530318e-12,
-4.44745377931805e-12,
-2.559686706845653e-12,
-1.17834322998705e-12,
-4.518712789752225e-13,
-1.484187507417825e-13,
-4.259167732642693e-14,
-1.083198410370222e-14,
-2.464335631340321e-15,
-5.033770956952763e-16,
-9.18249884055417e-17,
-1.457972969290131e-17,
-1.807466781346476e-18,
-9.5508693436991e-20,
-1.461369108672385e-8,
6.81523155735881e-13,
7.84598701134701e-13,
6.02149831128757e-13,
3.465655266069989e-13,
1.595442682791911e-13,
6.11851244539749e-14,
2.009848795042058e-14,
5.768816066454646e-15,
1.467729413978037e-15,
3.341917584496094e-16,
6.83800230939261e-17,
1.251899849252063e-17,
2.004615320079478e-18,
2.556982438737988e-19,
1.626043829568196e-20,
1.998966460212688e-9,
-8.75025015268092e-14,
-1.007369155203081e-13,
-7.73122043563035e-14,
-4.449730361425589e-14,
-2.048515424793266e-14,
-7.85639462031191e-15,
-2.580950717214918e-15,
-7.40936617031012e-16,
-1.885808491918373e-16,
-4.297012617753021e-17,
-8.80559021555685e-18,
-1.617305622655593e-18,
-2.609146947065633e-19,
-3.409359813744764e-20,
-2.453591546135044e-21,
-2.51776238297825e-10,
1.04010996234808e-14,
1.197425426005217e-14,
9.18988256640945e-15,
5.289318983202898e-15,
2.435082174442991e-15,
9.33929993787296e-16,
3.068344357121479e-16,
8.80992819942863e-17,
2.242971124699322e-17,
5.114063969092849e-18,
1.049345739502293e-18,
1.932597860416594e-19,
3.138982631152257e-20,
4.180173513575459e-21,
3.113245107021066e-22,
// [{0,0.0001},{2.,0.001}]: m=5
0.0393616208724452,
-7.46797102476692e-6,
-8.59600410642993e-6,
-6.59489104193356e-6,
-3.79311809347037e-6,
-1.743843738975425e-6,
-6.66960943739293e-7,
-2.179029565740929e-7,
-6.18625874234991e-8,
-1.539074223890723e-8,
-3.343612800494726e-9,
-6.16567452406338e-10,
-8.68214461814236e-11,
-4.31181133511765e-12,
3.408245800550374e-12,
1.654716567941666e-12,
-0.0651297694975391,
9.89796909772705e-6,
0.00001139362386948282,
8.74211436078433e-6,
5.02912526492392e-6,
2.313014398145615e-6,
8.85363450221364e-7,
2.89727631761325e-7,
8.25252997002004e-8,
2.06716650831037e-8,
4.556845416961529e-9,
8.69241133142811e-10,
1.347308565835308e-10,
1.255599595845638e-11,
-2.148344596992805e-12,
-1.507540804766143e-12,
0.05548895503743227,
-7.01987555987775e-6,
-8.08088257998111e-6,
-6.20069830218783e-6,
-3.567557590172628e-6,
-1.641216349324196e-6,
-6.28532217510456e-7,
-2.058899631718138e-7,
-5.87653564018521e-8,
-1.478198517328106e-8,
-3.287512314551399e-9,
-6.39685196618507e-10,
-1.043474931547263e-10,
-1.198257464648252e-11,
4.449546833647074e-13,
7.52252438138799e-13,
-0.03220554496720603,
3.48567938302019e-6,
4.01260190624556e-6,
3.079118419270812e-6,
1.771714828576921e-6,
8.15197431785455e-7,
3.123008027083316e-7,
1.023715464367844e-7,
2.925959839122825e-8,
7.38092186521181e-9,
1.651264656678407e-9,
3.255032238381006e-10,
5.480244147516145e-11,
6.99939872370723e-12,
1.493708111563657e-13,
-2.638408461950577e-13,
0.0142529347695743,
-1.346943311914151e-6,
-1.550581661300594e-6,
-1.189894169775338e-6,
-6.84703467180109e-7,
-3.150830753638177e-7,
-1.207376437355893e-7,
-3.959718750807415e-8,
-1.132890618725577e-8,
-2.86361486364397e-9,
-6.43362655351858e-10,
-1.27985053680666e-10,
-2.201470979814395e-11,
-2.999460559703926e-12,
-1.621474966186258e-13,
7.086676947396482e-14,
-0.005112596825699778,
4.28567305287968e-7,
4.93366220014716e-7,
3.786109791409885e-7,
2.1787509986264e-7,
1.002699009046638e-7,
3.842989587452133e-8,
1.260820915761805e-8,
3.60997752979486e-9,
9.13894400718615e-10,
2.059729234021874e-10,
4.125223513133475e-11,
7.20638064624432e-12,
1.025443859141557e-12,
7.68478941197801e-14,
-1.500401836063089e-14,
0.001544492461066372,
-1.162888909781382e-7,
-1.338728612026609e-7,
-1.027363716781561e-7,
-5.91227183602281e-8,
-2.72112786280527e-8,
-1.043063614752397e-8,
-3.423117625914379e-9,
-9.80681977538198e-10,
-2.485633694371544e-10,
-5.615850916324926e-11,
-1.130599598260862e-11,
-1.998233547758463e-12,
-2.933492792369128e-13,
-2.62289924533597e-14,
2.461195048801274e-15,
-0.0004034299519109027,
2.75627771382538e-8,
3.173075828606925e-8,
2.435109251297912e-8,
1.401397269124684e-8,
6.45031803562483e-9,
2.472826522385336e-9,
8.11720099265826e-10,
2.326575113056191e-10,
5.902550819988585e-11,
1.336185239626454e-11,
2.701138287752177e-12,
4.817709654235066e-13,
7.240539541501343e-14,
7.242264295016743e-15,
-2.757143244740341e-16,
0.0000928822441441511,
-5.80710451307112e-9,
-6.68528163937815e-9,
-5.1305377262411e-9,
-2.952677800981487e-9,
-1.359116375721773e-9,
-5.210875101341805e-10,
-1.710828629922812e-10,
-4.905514225291037e-11,
-1.245504582346974e-11,
-2.823995887542073e-12,
-5.727875784603759e-13,
-1.029105328235678e-13,
-1.575191917094477e-14,
-1.703315082815569e-15,
4.77267486668002e-18,
-0.00001912687817358787,
1.102129699211995e-9,
1.268805139644312e-9,
9.7373868184343e-10,
5.60407875894323e-10,
2.579657759404349e-10,
9.89123905946681e-11,
3.247998898688638e-11,
9.31608014705818e-12,
2.366875365124627e-12,
5.373641180254963e-13,
1.09294127955531e-13,
1.975432857731167e-14,
3.068307391131053e-15,
3.514154989482565e-16,
7.5591228351932e-18,
3.563866126167773e-6,
-1.90417752274807e-10,
-2.192156137772189e-10,
-1.682374314493329e-10,
-9.6825944394139e-11,
-4.457221532951711e-11,
-1.709157503884462e-11,
-5.613140352172521e-12,
-1.610426966830695e-12,
-4.093746347842395e-13,
-9.30462318035614e-14,
-1.896855916766499e-14,
-3.445620588249012e-15,
-5.416442056216559e-16,
-6.483686141175788e-17,
-2.546960755959924e-18,
-6.064927045683448e-7,
3.02053402287484e-11,
3.477357531058087e-11,
2.66872374704285e-11,
1.535956766586142e-11,
7.07072575274639e-12,
2.711483257347899e-12,
8.90596479889009e-13,
2.555741785620008e-13,
6.49980458007383e-14,
1.478741478779902e-14,
3.020550348879581e-15,
5.510030529267847e-16,
8.74871173464348e-17,
1.084598794531978e-17,
5.730838972746197e-19,
9.49862776678502e-8,
-4.42979975244964e-12,
-5.0997755572621e-12,
-3.913884874995174e-12,
-2.252624681636446e-12,
-1.037014152719274e-12,
-3.976942604447108e-13,
-1.306371984855451e-13,
-3.749645053747071e-14,
-9.54002368578854e-15,
-2.172196784364871e-15,
-4.444599025891934e-16,
-8.13716044486074e-17,
-1.302980359077406e-17,
-1.661988362303288e-18,
-1.055564849062571e-19,
-1.378371096380844e-8,
6.04342838890571e-13,
6.95747306853899e-13,
5.33962660111419e-13,
3.07323959845889e-13,
1.414821826429585e-13,
5.426069802205123e-14,
1.782546818769302e-14,
5.117296483986094e-15,
1.302427801198381e-15,
2.967670593137069e-16,
6.08125675763083e-17,
1.116855213957432e-17,
1.801412214242851e-18,
2.352611790904971e-19,
1.697173445101161e-20,
1.891662753159726e-9,
-7.81322650427844e-14,
-8.99496829564126e-14,
-6.90336964537036e-14,
-3.973296153178138e-14,
-1.829215285229556e-14,
-7.01561209397536e-15,
-2.304917751468477e-15,
-6.617956109850137e-16,
-1.684905450989462e-16,
-3.84165843269248e-17,
-7.88270623995697e-18,
-1.45177065454781e-18,
-2.356663112577069e-19,
-3.14119673033035e-20,
-2.499606205462344e-21,
-2.389444234365865e-10,
9.34337486796588e-15,
1.075657275805633e-14,
8.25538358186429e-15,
4.751500278189103e-15,
2.187520004575581e-15,
8.39010832896365e-16,
2.756684431950973e-16,
7.91616660281501e-17,
2.015979846376892e-17,
4.599091791392101e-18,
9.4477323014005e-19,
1.7441526097376e-19,
2.846632059548352e-20,
3.863768390019195e-21,
3.314840869968504e-22,
// [{0,0.0001},{2.,0.001}]: m=6
0.0325648847487695,
-4.94898454886352e-6,
-5.69681193474141e-6,
-4.37105718039217e-6,
-2.51456263246196e-6,
-1.156507199072807e-6,
-4.42681725110682e-7,
-1.448638158806625e-7,
-4.12626498501002e-8,
-1.033583254155185e-8,
-2.278422708480764e-9,
-4.34620566571406e-10,
-6.73654282917654e-11,
-6.27799797922819e-12,
1.074172298496402e-12,
7.53770402383072e-13,
-0.0554889550374323,
7.01987555987775e-6,
8.08088257998111e-6,
6.20069830218783e-6,
3.56755759017263e-6,
1.641216349324196e-6,
6.28532217510456e-7,
2.058899631718138e-7,
5.87653564018521e-8,
1.478198517328105e-8,
3.287512314551399e-9,
6.39685196618507e-10,
1.043474931547263e-10,
1.198257464648252e-11,
-4.449546833647075e-13,
-7.522524381388e-13,
0.04830831745080904,
-5.22851907453029e-6,
-6.01890285936834e-6,
-4.61867762890622e-6,
-2.657572242865382e-6,
-1.222796147678183e-6,
-4.68451204062497e-7,
-1.535573196551767e-7,
-4.388939758684238e-8,
-1.107138279781771e-8,
-2.476896985017611e-9,
-4.882548357571509e-10,
-8.22036622127422e-11,
-1.049909808556084e-11,
-2.240562167345485e-13,
3.957612692925865e-13,
-0.02850586953914973,
2.69388662382834e-6,
3.10116332260124e-6,
2.379788339550713e-6,
1.36940693436024e-6,
6.30166150727645e-7,
2.414752874711824e-7,
7.91943750161496e-8,
2.26578123745119e-8,
5.72722972728803e-9,
1.286725310703736e-9,
2.559701073613364e-10,
4.402941959628869e-11,
5.998921119407978e-12,
3.242949932372695e-13,
-1.417335389479249e-13,
0.01278149206424906,
-1.071418263219905e-6,
-1.233415550036774e-6,
-9.46527447852459e-7,
-5.44687749656593e-7,
-2.506747522616562e-7,
-9.60747396863021e-8,
-3.152052289404472e-8,
-9.02494382448704e-9,
-2.284736001796509e-9,
-5.149323085054619e-10,
-1.031305878283355e-10,
-1.801595161561055e-11,
-2.563609647853851e-12,
-1.921197352994491e-13,
3.751004590157793e-14,
-0.004633477383144518,
3.48866672932388e-7,
4.01618583605649e-7,
3.082091150326775e-7,
1.773681550796537e-7,
8.16338358836836e-8,
3.12919084423899e-8,
1.026935287768333e-8,
2.942045932597419e-9,
7.45690108307088e-10,
1.684755274887492e-10,
3.391798794762047e-11,
5.994700643237401e-12,
8.80047837704607e-13,
7.86869773592149e-14,
-7.38358514658634e-15,
0.001412004831698367,
-9.64697199842489e-8,
-1.110576540016575e-7,
-8.52288237957455e-8,
-4.90489044195473e-8,
-2.257611312477132e-8,
-8.65489282838106e-9,
-2.841020347441032e-9,
-8.14301289572723e-10,
-2.065892787003793e-10,
-4.676648338710368e-11,
-9.4539840071692e-12,
-1.686198378989172e-12,
-2.53418883953689e-13,
-2.534792503260279e-14,
9.65000135651449e-16,
-0.0003715289777208076,
2.322841809475694e-8,
2.674112660640913e-8,
2.052215094249135e-8,
1.181071122552526e-8,
5.43646551283125e-9,
2.084350044350862e-9,
6.84331453222389e-10,
1.962205693715762e-10,
4.982018338556464e-11,
1.129598357109523e-11,
2.291150318145444e-12,
4.116421320903091e-13,
6.300767681278701e-14,
6.813260349406244e-15,
-1.909069618786906e-17,
0.0000860709516528113,
-4.95958364192033e-9,
-5.70962312318001e-9,
-4.38182406428966e-9,
-2.521835439218844e-9,
-1.160845990670457e-9,
-4.451057572688508e-10,
-1.461599503071966e-10,
-4.192236062333267e-11,
-1.065093913326955e-11,
-2.418138528879489e-12,
-4.918235753400497e-13,
-8.88944785112294e-14,
-1.380738324552102e-14,
-1.581369744665666e-15,
-3.401605283209957e-17,
-0.00001781931842394169,
9.52088308265123e-10,
1.096077547242862e-9,
8.41186756897828e-10,
4.84129491542625e-10,
2.228609705603141e-10,
8.54578345038128e-11,
2.806568839065651e-11,
8.0521309942597e-12,
2.04687219578985e-12,
4.652309357627968e-13,
9.48427499240016e-14,
1.722809444894103e-14,
2.708219648025381e-15,
3.241841134858098e-16,
1.273477280598566e-17,
3.335710696522027e-6,
-1.661294002753621e-10,
-1.912546976144586e-10,
-1.467798317259616e-10,
-8.44776369191053e-11,
-3.888899843414405e-11,
-1.491316052137931e-11,
-4.898281495714429e-12,
-1.405658228053469e-12,
-3.574893145723941e-13,
-8.13307956394805e-14,
-1.661302986141962e-14,
-3.030517345678118e-15,
-4.811792399229139e-16,
-5.965293763006107e-17,
-3.15195984771281e-18,
-5.699869223104657e-7,
2.658136921177349e-11,
3.060161286764397e-11,
2.348558061466157e-11,
1.351705541517002e-11,
6.22268679862878e-12,
2.386396418246631e-12,
7.83899046297356e-13,
2.250004887248585e-13,
5.724569150963982e-14,
1.303444733563703e-14,
2.667019902157191e-15,
4.882778081321929e-16,
7.81866687635686e-17,
9.97302728670479e-18,
6.334965125320368e-19,
8.95915324671678e-8,
-3.92813699949771e-12,
-4.5222522084463e-12,
-3.470676485854008e-12,
-1.997559229963519e-12,
-9.19612774491689e-13,
-3.52686323953237e-13,
-1.158628443515941e-13,
-3.326165194911687e-14,
-8.46558319644798e-15,
-1.92894079550117e-15,
-3.952724166039476e-16,
-7.25938411633116e-17,
-1.170887825363635e-17,
-1.529185411333228e-18,
-1.103241678749614e-19,
-1.304272499138691e-8,
5.39542518895906e-13,
6.21147688627168e-13,
4.76712255655595e-13,
2.743759425858941e-13,
1.263163950243036e-13,
4.844624099116961e-14,
1.591655890546971e-14,
4.56999882289308e-15,
1.163495312933969e-15,
2.65278185634008e-16,
5.443081324519405e-17,
1.002400827950048e-17,
1.627082254791185e-18,
2.167379523970107e-19,
1.708989059261531e-20,
1.795269551970905e-9,
-7.0187874682559e-14,
-8.08038846569759e-14,
-6.201483367384e-14,
-3.569349665864426e-14,
-1.643275534670509e-14,
-6.30269026226939e-15,
-2.070835163860348e-15,
-5.946666282864243e-16,
-1.51441591061144e-16,
-3.454868649267511e-17,
-7.097210940348351e-18,
-1.310265850910447e-18,
-2.138709130680962e-19,
-2.899282510358693e-20,
-2.473949046751747e-21,
-2.273547604797866e-10,
8.43891271575813e-15,
9.71532802204956e-15,
7.45628436327233e-15,
4.291600394250424e-15,
1.975819090330612e-15,
7.57837294464706e-16,
2.490129997848814e-16,
7.15159913403473e-17,
1.821719410389699e-17,
4.158005623510881e-18,
8.55070856968932e-19,
1.581765297773209e-19,
2.58559745191899e-20,
3.58815850313841e-21,
4.187649272576989e-22,
// [{0,0.0001},{2.,0.001}]: m=7
0.02774447751871613,
-3.50993777993887e-6,
-4.04044128999056e-6,
-3.10034915109391e-6,
-1.783778795086314e-6,
-8.20608174662098e-7,
-3.14266108755228e-7,
-1.029449815859069e-7,
-2.9382678200926e-8,
-7.39099258664053e-9,
-1.643756157275699e-9,
-3.19842598309253e-10,
-5.21737465773631e-11,
-5.99128732324126e-12,
2.224773416823538e-13,
3.761262190693997e-13,
-0.048308317450809,
5.22851907453029e-6,
6.01890285936834e-6,
4.61867762890622e-6,
2.657572242865382e-6,
1.222796147678183e-6,
4.68451204062497e-7,
1.535573196551766e-7,
4.38893975868424e-8,
1.107138279781771e-8,
2.476896985017611e-9,
4.88254835757151e-10,
8.22036622127422e-11,
1.049909808556084e-11,
2.24056216734548e-13,
-3.957612692925865e-13,
0.0427588043087246,
-4.04082993574252e-6,
-4.65174498390185e-6,
-3.56968250932607e-6,
-2.05411040154036e-6,
-9.45249226091468e-7,
-3.622129312067737e-7,
-1.187915625242243e-7,
-3.398671856176785e-8,
-8.59084459093205e-9,
-1.930087966055604e-9,
-3.839551610420045e-10,
-6.6044129394433e-11,
-8.99838167911197e-12,
-4.86442489855904e-13,
2.126003084218886e-13,
-0.02556298412849921,
2.142836526439849e-6,
2.466831100073592e-6,
1.893054895704952e-6,
1.089375499313206e-6,
5.01349504523321e-7,
1.921494793726077e-7,
6.30410457880906e-8,
1.80498876489744e-8,
4.569472003593101e-9,
1.029864617010943e-9,
2.062611756566749e-10,
3.603190323122182e-11,
5.127219295707824e-12,
3.842394705989145e-13,
-7.502009180315719e-14,
0.01158369345786093,
-8.72166682330958e-7,
-1.004046459014109e-6,
-7.70522787581683e-7,
-4.43420387699128e-7,
-2.040845897092061e-7,
-7.82297711059736e-8,
-2.567338219420797e-8,
-7.35511483149344e-9,
-1.864225270767693e-9,
-4.211888187218668e-10,
-8.47949698690499e-11,
-1.498675160809325e-11,
-2.200119594261398e-12,
-1.967174433980563e-13,
1.845896286638083e-14,
-0.004236014495043028,
2.89409159950907e-7,
3.33172962002855e-7,
2.556864713856112e-7,
1.471467132577064e-7,
6.77283393738833e-8,
2.596467848497797e-8,
8.52306104226881e-9,
2.442903868702578e-9,
6.19767836097165e-10,
1.402994501604039e-10,
2.836195202132092e-11,
5.058595136932896e-12,
7.60256651855291e-13,
7.60437750970242e-14,
-2.895000406953769e-15,
0.001300351422032582,
-8.1299463331978e-8,
-9.35939431228105e-8,
-7.18275282990102e-8,
-4.133748928950562e-8,
-1.902762929498634e-8,
-7.29522515525754e-9,
-2.395160086288065e-9,
-6.86771992803304e-10,
-1.743706418501867e-10,
-3.953594249899539e-11,
-8.01902611354166e-12,
-1.440747462322785e-12,
-2.205268688479546e-13,
-2.384641122248109e-14,
6.68174389569792e-17,
-0.0003442838077025061,
1.983833460623092e-8,
2.28384925371005e-8,
1.75272962912197e-8,
1.008734177647998e-8,
4.643383971707756e-9,
1.780423032537447e-9,
5.8463980236642e-10,
1.676894428200926e-10,
4.260375661633248e-11,
9.6725541345289e-12,
1.967294305272815e-12,
3.5557791477034e-13,
5.522953310240482e-14,
6.325478995172259e-15,
1.360642120438401e-16,
0.0000801869327850801,
-4.28439738305976e-9,
-4.93234895783439e-9,
-3.785340402388178e-9,
-2.178582709839781e-9,
-1.00287436655363e-9,
-3.845602548959392e-10,
-1.262955976359653e-10,
-3.623458943912597e-11,
-9.21092487212226e-12,
-2.093539208894473e-12,
-4.267923742481386e-13,
-7.75264249364563e-14,
-1.218698837561906e-14,
-1.458828515666978e-15,
-5.730650679757607e-17,
-0.00001667854184052018,
8.30646590117323e-10,
9.56273014607547e-10,
7.33898795255573e-10,
4.223879754474276e-10,
1.944448958792589e-10,
7.45657656727139e-11,
2.44913953419339e-11,
7.02828765426698e-12,
1.787445684679153e-12,
4.066537753824891e-13,
8.30651075643226e-14,
1.51525789897918e-14,
2.405894920314462e-15,
2.982645113969136e-16,
1.575978726150197e-17,
3.134928857771723e-6,
-1.461975571195622e-10,
-1.683089012283322e-10,
-1.291707167552733e-10,
-7.43438182373078e-11,
-3.422478358667736e-11,
-1.312518267631042e-11,
-4.311445535415705e-12,
-1.237502912274333e-12,
-3.148513604719018e-13,
-7.16894733915622e-14,
-1.466861208517339e-14,
-2.68552847863554e-15,
-4.300269376153891e-16,
-5.485162085363649e-17,
-3.484043813938413e-18,
-5.376152466894051e-7,
2.357115526545006e-11,
2.713619943882837e-11,
2.082612050803338e-11,
1.198654197529925e-11,
5.518222953694e-12,
2.116327488708628e-12,
6.95245922967309e-13,
1.995896894150052e-13,
5.079853825686446e-14,
1.157479543789454e-14,
2.37187133160016e-15,
4.356069503739193e-16,
7.02605138643156e-17,
9.17611736132663e-18,
6.620268081938943e-19,
8.47752381534865e-8,
-3.50694299550027e-12,
-4.03736398732617e-12,
-3.098555992186067e-12,
-1.783401224387761e-12,
-8.21037045406858e-13,
-3.14893078174983e-13,
-1.034551721090753e-13,
-2.970428546434918e-14,
-7.56253935590659e-15,
-1.724267089189371e-15,
-3.53792016768791e-16,
-6.51543766810752e-17,
-1.057522018961278e-17,
-1.408882307999152e-18,
-1.116708092293394e-19,
-1.237717604433278e-8,
4.8461370215768e-13,
5.57912145253352e-13,
4.281826991390781e-13,
2.464464351378015e-13,
1.1346023039242e-13,
4.351699405008979e-14,
1.429808117331319e-14,
4.105862463667024e-15,
1.045618314486256e-15,
2.385359606911374e-16,
4.900025875886393e-17,
9.04576569425846e-18,
1.476310921250258e-18,
2.000616410254947e-19,
1.706119160072902e-20,
1.708206141372558e-9,
-6.3394468459895e-14,
-7.29831057470625e-14,
-5.60128072545344e-14,
-3.223919301688664e-14,
-1.484267169860541e-14,
-5.692996473322645e-15,
-1.870626289555611e-15,
-5.372399875007187e-16,
-1.36850723273668e-16,
-3.123565246951771e-17,
-6.423212730281756e-18,
-1.18838276973239e-18,
-1.949149028312955e-19,
-2.681222081832572e-20,
-2.42589957497629e-21,
-2.168354957243309e-10,
7.65951153507505e-15,
8.81805478302983e-15,
6.76767159199309e-15,
3.895283478545934e-15,
1.793382506181082e-15,
6.87881535068076e-16,
2.260391059156843e-16,
6.492510069148754e-17,
1.654197866969647e-17,
3.777332034404011e-18,
7.77471946299843e-19,
1.441256970618243e-19,
2.37460002029557e-20,
3.2993417036626e-21,
3.048014925088416e-22,
// [{0,0.0001},{2.,0.001}]: m=8
0.02415415872540452,
-2.61425953726514e-6,
-3.00945142968417e-6,
-2.30933881445311e-6,
-1.328786121432691e-6,
-6.11398073839091e-7,
-2.342256020312487e-7,
-7.67786598275883e-8,
-2.194469879342119e-8,
-5.53569139890886e-9,
-1.238448492508806e-9,
-2.441274178785754e-10,
-4.11018311063711e-11,
-5.24954904278042e-12,
-1.12028108367274e-13,
1.978806346462933e-13,
-0.04275880430872459,
4.04082993574252e-6,
4.65174498390185e-6,
3.56968250932607e-6,
2.05411040154036e-6,
9.45249226091468e-7,
3.62212931206774e-7,
1.187915625242243e-7,
3.398671856176785e-8,
8.59084459093205e-9,
1.930087966055604e-9,
3.839551610420045e-10,
6.6044129394433e-11,
8.99838167911197e-12,
4.86442489855904e-13,
-2.126003084218886e-13,
0.03834447619274882,
-3.21425478965977e-6,
-3.70024665011039e-6,
-2.839582343557429e-6,
-1.634063248969809e-6,
-7.52024256784982e-7,
-2.882242190589115e-7,
-9.45615686821359e-8,
-2.707483147346159e-8,
-6.85420800538965e-9,
-1.544796925516414e-9,
-3.093917634850123e-10,
-5.40478548468327e-11,
-7.69082894356174e-12,
-5.76359205898372e-13,
1.125301377047355e-13,
-0.0231673869157229,
1.74433336466195e-6,
2.008092918028259e-6,
1.541045575163397e-6,
8.86840775398274e-7,
4.081691794184203e-7,
1.564595422119504e-7,
5.1346764388417e-8,
1.471022966298718e-8,
3.728450541535462e-9,
8.42377637443751e-10,
1.695899397381034e-10,
2.997350321618716e-11,
4.400239188522905e-12,
3.934348867961272e-13,
-3.691792573276039e-14,
0.01059003623760722,
-7.23522899877257e-7,
-8.32932405007124e-7,
-6.39216178464018e-7,
-3.678667831442604e-7,
-1.693208484347055e-7,
-6.49116962124439e-8,
-2.130765260567169e-8,
-6.10725967175635e-9,
-1.549419590242888e-9,
-3.507486254010041e-10,
-7.09048800533011e-11,
-1.264648784233204e-11,
-1.900641629638207e-12,
-1.901094377425396e-13,
7.237501017404139e-15,
-0.003901054266047978,
2.43898389994257e-7,
2.807818293665006e-7,
2.154825848955488e-7,
1.24012467867664e-7,
5.70828878845664e-8,
2.188567546562201e-8,
7.1854802588147e-9,
2.060315978395694e-9,
5.231119255469367e-10,
1.186078274961585e-10,
2.405707834045448e-11,
4.322242386936675e-12,
6.615806065386286e-13,
7.15392336667266e-14,
-2.004523169548948e-16,
0.001204993326968114,
-6.94341711221092e-8,
-7.99347238801982e-8,
-6.13455370195349e-8,
-3.530569621783297e-8,
-1.625184390104761e-8,
-6.23148061390809e-9,
-2.046239308291353e-9,
-5.86913049872876e-10,
-1.491131481578141e-10,
-3.385393947099988e-11,
-6.8855300684856e-12,
-1.244522701701598e-12,
-1.933033658589974e-13,
-2.21391764835742e-14,
-4.762247426272147e-16,
-0.0003207477321833136,
1.71375895673845e-8,
1.972939587179906e-8,
1.514136164060615e-8,
8.71433085723273e-9,
4.0114974744436e-9,
1.538241022740235e-9,
5.051823915811373e-10,
1.449383580544699e-10,
3.684369956442169e-11,
8.37415685292394e-12,
1.707169500565833e-12,
3.10105700409548e-13,
4.874795361198184e-14,
5.835314077876518e-15,
2.292260290585806e-16,
0.0000750534381648796,
-3.7379096517443e-9,
-4.30322856137799e-9,
-3.302544575306948e-9,
-1.900745887589187e-9,
-8.75002030570729e-10,
-3.355459451873806e-10,
-1.102112789270227e-10,
-3.162729441211772e-11,
-8.0435055728787e-12,
-1.8299419873514e-12,
-3.737929836530495e-13,
-6.81866053854496e-14,
-1.082652713346428e-14,
-1.342190296056411e-15,
-7.09190375258657e-17,
-0.000015674633161701,
7.30987410654288e-10,
8.415440744852e-10,
6.45853252488084e-10,
3.717189005050391e-10,
1.711238301428298e-10,
6.56258797071958e-11,
2.155721661107484e-11,
6.18751138257214e-12,
1.574255992285091e-12,
3.584471819039838e-13,
7.33430223045347e-14,
1.342763531346754e-14,
2.150133520213839e-15,
2.7425794072815e-16,
1.742019935734167e-17,
2.956884608597265e-6,
-1.29641378176955e-10,
-1.492491247935695e-10,
-1.145436841916341e-10,
-6.59259931800688e-11,
-3.035023191568309e-11,
-1.163980336296323e-11,
-3.823853291118476e-12,
-1.097743497131859e-12,
-2.793920127523305e-13,
-6.36613868749851e-14,
-1.304529479558504e-14,
-2.395838668853526e-15,
-3.86432881243309e-16,
-5.046867603337965e-17,
-3.641175567409147e-18,
-5.087145593510291e-7,
2.104378520609823e-11,
2.422663291655431e-11,
1.859321550925485e-11,
1.070148917325335e-11,
4.926720350066751e-12,
1.889549519706172e-12,
6.20793815362825e-13,
1.782437476296587e-13,
4.537983207350633e-14,
1.034665243506966e-14,
2.122968381241793e-15,
3.909664229686519e-16,
6.345794870342863e-17,
8.45422604008443e-18,
6.70132956159433e-19,
8.04492748185131e-8,
-3.14991273961004e-12,
-3.626341074984575e-12,
-2.783120106271219e-12,
-1.601863012423633e-12,
-7.37473626314175e-13,
-2.828536061923522e-13,
-9.29352748039334e-14,
-2.668745881599622e-14,
-6.79635408536399e-15,
-1.550446031641503e-15,
-3.184938955738165e-16,
-5.879607893532634e-17,
-9.59583610419497e-18,
-1.300310622869471e-18,
-1.1082251199984e-19,
-1.177612294252817e-8,
4.37651610971896e-13,
5.03847940154356e-13,
3.866913404192469e-13,
2.225672145996818e-13,
1.024681632846368e-13,
3.930225493971194e-14,
1.291406456506071e-14,
3.708881679987076e-15,
9.44754976986547e-16,
2.156341264345359e-16,
4.434130739203662e-17,
8.20333253405085e-18,
1.345360288180395e-18,
1.850012581776046e-19,
1.668303646316358e-20,
1.629182639256327e-9,
-5.75402787240788e-14,
-6.62435626796137e-14,
-5.08405416680244e-14,
-2.92624018663242e-14,
-1.347236521102087e-14,
-5.167549001504942e-15,
-1.698066130988302e-15,
-4.877348446112601e-16,
-1.242678766419432e-16,
-2.837640653734229e-17,
-5.840619008530518e-18,
-1.082668290134924e-18,
-1.783348666818574e-19,
-2.485069554371498e-20,
-2.364505199611033e-21,
-2.072451013325128e-10,
6.98316262379002e-15,
8.03941684094476e-15,
6.17010247668567e-15,
3.551361344795997e-15,
1.635061570878973e-15,
6.27170491066917e-16,
2.060995942248034e-16,
5.920378611597638e-17,
1.50872934019016e-17,
3.446557591144159e-18,
7.099878401810195e-19,
1.318348028684336e-19,
2.177808488328785e-20,
3.071912449425966e-21,
3.275717368687817e-22,
// [{0,0.0001},{2.,0.001}]: m=9
0.0213794021543623,
-2.02041496787126e-6,
-2.32587249195093e-6,
-1.784841254663035e-6,
-1.02705520077018e-6,
-4.72624613045734e-7,
-1.811064656033868e-7,
-5.93957812621122e-8,
-1.699335928088393e-8,
-4.29542229546602e-9,
-9.65043983027802e-10,
-1.919775805210023e-10,
-3.30220646972165e-11,
-4.49919083955598e-12,
-2.43221244927952e-13,
1.063001542109443e-13,
-0.03834447619274882,
3.21425478965977e-6,
3.70024665011039e-6,
2.83958234355743e-6,
1.634063248969809e-6,
7.52024256784982e-7,
2.882242190589115e-7,
9.45615686821359e-8,
2.707483147346159e-8,
6.85420800538965e-9,
1.544796925516414e-9,
3.093917634850123e-10,
5.40478548468327e-11,
7.69082894356174e-12,
5.76359205898372e-13,
-1.125301377047356e-13,
0.03475108037358435,
-2.61650004699293e-6,
-3.01213937704239e-6,
-2.311568362745095e-6,
-1.330261163097411e-6,
-6.12253769127631e-7,
-2.346893133179256e-7,
-7.70201465826255e-8,
-2.206534449448077e-8,
-5.59267581230319e-9,
-1.263566456165626e-9,
-2.543849096071552e-10,
-4.496025482428074e-11,
-6.60035878278436e-12,
-5.90152330194191e-13,
5.537688859914127e-14,
-0.02118007247521543,
1.447045799754546e-6,
1.665864810014285e-6,
1.278432356928064e-6,
7.35733566288537e-7,
3.386416968694185e-7,
1.298233924248907e-7,
4.261530521134433e-8,
1.221451934351297e-8,
3.098839180485845e-9,
7.01497250802024e-10,
1.418097601066056e-10,
2.529297568466469e-11,
3.80128325927651e-12,
3.802188754850933e-13,
-1.447500203480219e-14,
0.00975263566511961,
-6.09745974985632e-7,
-7.0195457341624e-7,
-5.38706462238863e-7,
-3.100311696691546e-7,
-1.427072197114134e-7,
-5.47141886640541e-8,
-1.796370064703644e-8,
-5.15078994598915e-9,
-1.307779813867319e-9,
-2.96519568740391e-10,
-6.01426958511352e-11,
-1.080560596734149e-11,
-1.653951516346502e-12,
-1.788480841668077e-13,
5.01130792346425e-16,
-0.003614979980856681,
2.083025133647923e-7,
2.398041716388272e-7,
1.840366110572481e-7,
1.059170886527181e-7,
4.87555317027834e-8,
1.869444184158639e-8,
6.13871792482875e-9,
1.76073914960561e-9,
4.473394444701242e-10,
1.015618184122414e-10,
2.065659020530045e-11,
3.733568105075727e-12,
5.799100975722706e-13,
6.641752945003142e-14,
1.428674227687575e-15,
0.001122617062650561,
-5.99815634861223e-8,
-6.9052885551615e-8,
-5.29947657423658e-8,
-3.050015800045518e-8,
-1.404024116061735e-8,
-5.38384357961566e-9,
-1.768138370542143e-9,
-5.072842531929896e-10,
-1.289529484760738e-10,
-2.930954898537049e-11,
-5.975093252008325e-12,
-1.085369951438604e-12,
-1.706178376436309e-13,
-2.042359927276603e-14,
-8.02291100789078e-16,
-0.0003002137536583272,
1.495163863914976e-8,
1.721291428255093e-8,
1.321017832965457e-8,
7.60298356671861e-9,
3.500008129816067e-9,
1.342183783639125e-9,
4.408451166577092e-10,
1.265091779212812e-10,
3.217402236104946e-11,
7.3197679652961e-12,
1.495171937888459e-12,
2.727464221508362e-13,
4.330610863358633e-14,
5.368761198817325e-15,
2.836761532421009e-16,
0.0000705358491149678,
-3.28944334446777e-9,
-3.78694833118101e-9,
-2.906339633124607e-9,
-1.67273505050462e-9,
-7.70057234828696e-10,
-2.953164583701221e-10,
-9.7007474647214e-11,
-2.784380119209032e-11,
-7.08415195776607e-12,
-1.613012316849527e-12,
-3.300436000190656e-13,
-6.042435884510602e-14,
-9.67560082101406e-15,
-1.234160731079092e-15,
-7.83909071007422e-17,
-0.00001478441238720412,
6.48206547656855e-10,
7.46245228823649e-10,
5.72718117691515e-10,
3.296297913464287e-10,
1.517510792121599e-10,
5.81989859875489e-11,
1.911925632473622e-11,
5.488714575225188e-12,
1.396959321941798e-12,
3.183067648495838e-13,
6.52264390271325e-14,
1.197918684682001e-14,
1.932163337434665e-15,
2.523432244645381e-16,
1.820585027719578e-17,
2.797930797677268e-6,
-1.157408408847599e-10,
-1.332465066579964e-10,
-1.02262704961537e-10,
-5.88582017692002e-11,
-2.709696713555416e-11,
-1.039252435697314e-11,
-3.41436664132459e-12,
-9.80340800675311e-13,
-2.495891245149006e-13,
-5.69065993907975e-14,
-1.167632834771818e-14,
-2.15031574700451e-15,
-3.490188393301513e-16,
-4.64982558107001e-17,
-3.685674328803767e-18,
-4.827561050015806e-7,
1.890142373488608e-11,
2.176028829318002e-11,
1.67004412153691e-11,
9.61216840293865e-12,
4.425297714345007e-12,
1.697296535083976e-12,
5.576691260489896e-13,
1.60141265190742e-13,
4.078233321458658e-14,
9.30363798767351e-15,
1.911161659828976e-15,
3.528133399698781e-16,
5.758110117151095e-17,
7.802743830688997e-18,
6.650656752443549e-19,
7.654252596909264e-8,
-2.84466534234321e-12,
-3.274930874293696e-12,
-2.513431748472797e-12,
-1.446651229393078e-12,
-6.66026640449267e-13,
-2.554583581720592e-13,
-8.39393495504237e-14,
-2.410713615707802e-14,
-6.140755721456275e-15,
-1.401587161232548e-15,
-2.882113989471061e-16,
-5.33203318748685e-17,
-8.7444735346045e-18,
-1.20247235737402e-18,
-1.086027001613251e-19,
-1.123063945762416e-8,
3.97189075657432e-13,
4.57266091132102e-13,
3.509420823031666e-13,
2.019924689769723e-13,
9.29969938432094e-14,
3.567051479544305e-14,
1.172138130445683e-14,
3.366718582830314e-15,
8.57787226055593e-16,
1.958724495982231e-16,
4.031484669750316e-17,
7.47277964747377e-18,
1.230815074512769e-18,
1.714417020881336e-19,
1.624196054757414e-20,
1.557136137413227e-9,
-5.24600363958729e-14,
-6.03949993243028e-14,
-4.635203592294604e-14,
-2.667910819436682e-14,
-1.228317308912642e-14,
-4.711531591006379e-15,
-1.548294921841653e-15,
-4.447604470137451e-16,
-1.133413289232355e-16,
-2.589184171846918e-17,
-5.333651206005919e-18,
-9.90401379234826e-19,
-1.637755018393559e-19,
-2.307939172171348e-20,
-2.271660430447577e-21,
-1.984659145565973e-10,
6.39248882331137e-15,
7.35940968883759e-15,
5.64822557913428e-15,
3.250999974447538e-15,
1.49679081260078e-15,
5.741460855346674e-16,
1.88683333740074e-16,
5.42057317824349e-17,
1.381612259984348e-17,
3.157329831841823e-18,
6.508876578916568e-19,
1.210566353241569e-19,
2.009322636403895e-20,
2.853102830862273e-21,
2.834878429359616e-22,
// [{0,0.0001},{2.,0.001}]: m=10
0.01917223809637441,
-1.60712739482989e-6,
-1.85012332505519e-6,
-1.419791171778714e-6,
-8.17031624484904e-7,
-3.76012128392491e-7,
-1.441121095294557e-7,
-4.72807843410679e-8,
-1.35374157367308e-8,
-3.42710400269483e-9,
-7.72398462758207e-10,
-1.546958817425062e-10,
-2.702392742341636e-11,
-3.84541447178087e-12,
-2.88179602949186e-13,
5.62650688523678e-14,
-0.03475108037358434,
2.61650004699292e-6,
3.01213937704239e-6,
2.311568362745095e-6,
1.33026116309741e-6,
6.1225376912763e-7,
2.346893133179256e-7,
7.70201465826255e-8,
2.206534449448077e-8,
5.59267581230319e-9,
1.263566456165626e-9,
2.543849096071552e-10,
4.49602548242807e-11,
6.60035878278436e-12,
5.90152330194191e-13,
-5.537688859914125e-14,
0.03177010871282315,
-2.17056869963182e-6,
-2.498797215021428e-6,
-1.917648535392097e-6,
-1.103600349432806e-6,
-5.07962545304128e-7,
-1.947350886373361e-7,
-6.39229578170165e-8,
-1.832177901526945e-8,
-4.64825877072877e-9,
-1.052245876203036e-9,
-2.127146401599083e-10,
-3.793946352699703e-11,
-5.70192488891477e-12,
-5.7032831322764e-13,
2.171250305220283e-14,
-0.01950527133024017,
1.219491949971294e-6,
1.403909146832513e-6,
1.077412924477751e-6,
6.20062339338324e-7,
2.854144394228338e-7,
1.094283773281108e-7,
3.592740129407374e-8,
1.030157989197854e-8,
2.615559627734702e-9,
5.93039137480797e-10,
1.202853917022733e-10,
2.161121193468354e-11,
3.3079030326931e-12,
3.576961683336295e-13,
-1.002261584693861e-15,
0.00903744995214138,
-5.20756283411971e-7,
-5.99510429097057e-7,
-4.60091527643112e-7,
-2.647927216317905e-7,
-1.218888292569562e-7,
-4.673610460396513e-8,
-1.534679481207158e-8,
-4.401847874013945e-9,
-1.11834861117529e-9,
-2.539045460305987e-10,
-5.164147551325015e-11,
-9.33392026268914e-12,
-1.449775243930665e-12,
-1.660438236250722e-13,
-3.571685569197822e-15,
-0.003367851187905958,
1.799446904569562e-7,
2.071586566532212e-7,
1.589842972258511e-7,
9.15004740006481e-8,
4.212072348152175e-8,
1.615153073872028e-8,
5.30441511158479e-9,
1.521852759567006e-9,
3.868588454251717e-10,
8.79286469554143e-11,
1.792527975588117e-11,
3.256109854289052e-12,
5.118535129263812e-13,
6.127079781762976e-14,
2.406873302357439e-15,
0.001050748137812758,
-5.23307352372791e-8,
-6.02451999892218e-8,
-4.62356241540163e-8,
-2.661044248364479e-8,
-1.225002845441593e-8,
-4.697643242759836e-9,
-1.542957908309508e-9,
-4.427821227266468e-10,
-1.126090782642244e-10,
-2.561918787866247e-11,
-5.233101782635775e-12,
-9.54612477532702e-13,
-1.515713802179823e-13,
-1.879066419605633e-14,
-9.92866536772312e-16,
-0.000282143397418082,
1.315777340743218e-8,
1.514779335875656e-8,
1.162535855861788e-8,
6.69094021705236e-9,
3.080228946236597e-9,
1.181265836135645e-9,
3.880298994614638e-10,
1.113752050190683e-10,
2.833660789497588e-11,
6.45204928200855e-12,
1.320174403090067e-12,
2.416974359413465e-13,
3.870240337806179e-14,
4.936642938211872e-15,
3.135636291852125e-16,
0.00006652985563413383,
-2.91692946125056e-9,
-3.358103526016296e-9,
-2.577231526779693e-9,
-1.483334059428803e-9,
-6.8287985570418e-10,
-2.618954366560629e-10,
-8.60366533666897e-11,
-2.469921556132537e-11,
-6.2863169418064e-12,
-1.432380440237581e-12,
-2.935189752934234e-13,
-5.390634075077286e-14,
-8.69473501218572e-15,
-1.135544507431354e-15,
-8.19263218410306e-17,
-0.00001398964376571796,
5.78703889055716e-10,
6.66232170219201e-10,
5.11313246156132e-10,
2.942908484591976e-10,
1.354847618334268e-10,
5.196259345872113e-11,
1.707182389733461e-11,
4.901701328744944e-12,
1.247944940742926e-12,
2.84532841085028e-13,
5.838160958508982e-14,
1.075157274966645e-14,
1.745093196944047e-15,
2.324911321899406e-16,
1.842835985126076e-17,
2.655159270580562e-6,
-1.039578510570655e-10,
-1.196816092308458e-10,
-9.18524448113178e-11,
-5.28669366496634e-11,
-2.433914223267354e-11,
-9.33513278568958e-12,
-3.067180798898466e-12,
-8.80777132563729e-13,
-2.243028770462503e-13,
-5.117001908043078e-14,
-1.051139123130187e-14,
-1.940473752887466e-15,
-3.16696100405968e-16,
-4.291510887460255e-17,
-3.657885277941006e-18,
-4.59313154639644e-7,
1.706978129059051e-11,
1.965164512289926e-11,
1.508217141663322e-11,
8.68081732870732e-12,
3.996578797579208e-12,
1.532910857029923e-12,
5.036889134244079e-13,
1.446579914295302e-13,
3.68484026905105e-14,
8.41040728554665e-15,
1.729450820330974e-15,
3.199559562158185e-16,
5.247250141600486e-17,
7.215659205026467e-18,
6.516957897929491e-19,
7.299697211532433e-8,
-2.581664334200111e-12,
-2.972155154568538e-12,
-2.281066404913017e-12,
-1.312918165165832e-12,
-6.04465319956914e-13,
-2.318525384595795e-13,
-7.61870697226822e-14,
-2.188312234772844e-14,
-5.575477140600564e-15,
-1.273138938242488e-15,
-2.620398817223916e-16,
-4.857186127074741e-17,
-8.00014912092056e-18,
-1.1143133080675e-18,
-1.055079176777015e-19,
-1.073337151634794e-8,
3.62081345110437e-13,
4.16848772156279e-13,
3.199236361129296e-13,
1.841402611329262e-13,
8.47789211312635e-14,
3.251914779371935e-14,
1.068636998501893e-14,
3.069740114066089e-15,
7.82278887407224e-16,
1.787030265935141e-16,
3.681159780667785e-17,
6.835238481642259e-18,
1.130195805676016e-18,
1.592087859312922e-19,
1.564658280523398e-20,
1.491182941348708e-9,
-4.80232485610986e-14,
-5.52871928226469e-14,
-4.24320091487322e-14,
-2.44229733702593e-14,
-1.124456586807e-14,
-4.31324393771588e-15,
-1.41747435469643e-15,
-4.072180248434918e-16,
-1.037930255661827e-16,
-2.371934074539061e-17,
-4.889803257926122e-18,
-9.09409011548562e-19,
-1.508944445046162e-19,
-2.147081942779269e-20,
-2.193235344399947e-21,
-1.903993166398805e-10,
5.87362341649021e-15,
6.76206995665923e-15,
5.189790521815e-15,
2.987149741739771e-15,
1.375325838509106e-15,
5.275648328554541e-16,
1.733823418796657e-16,
4.981411379443879e-17,
1.269887890725706e-17,
2.902985429061114e-18,
5.988793834333464e-19,
1.115415571462571e-19,
1.853186875798623e-20,
2.658429457706029e-21,
3.152849306992208e-22,
// [{0,0.0001},{2.,0.001}]: m=11
0.01737554018679217,
-1.30825002349646e-6,
-1.506069688521194e-6,
-1.155784181372547e-6,
-6.65130581548705e-7,
-3.06126884563815e-7,
-1.173446566589628e-7,
-3.85100732913127e-8,
-1.103267224724038e-8,
-2.7963379061516e-9,
-6.31783228082813e-10,
-1.271924548035776e-10,
-2.248012741214037e-11,
-3.30017939139218e-12,
-2.95076165097095e-13,
2.768844429957062e-14,
-0.03177010871282315,
2.17056869963182e-6,
2.49879721502143e-6,
1.917648535392097e-6,
1.103600349432806e-6,
5.07962545304128e-7,
1.947350886373361e-7,
6.39229578170165e-8,
1.832177901526945e-8,
4.64825877072877e-9,
1.052245876203036e-9,
2.127146401599083e-10,
3.793946352699703e-11,
5.70192488891476e-12,
5.7032831322764e-13,
-2.171250305220285e-14,
0.02925790699536026,
-1.829237924956941e-6,
-2.10586372024877e-6,
-1.616119386716627e-6,
-9.30093509007486e-7,
-4.28121659134251e-7,
-1.641425659921663e-7,
-5.38911019411106e-8,
-1.545236983796782e-8,
-3.923339441602054e-9,
-8.89558706221195e-10,
-1.8042808755341e-10,
-3.241681790202532e-11,
-4.96185454903965e-12,
-5.365442525004443e-13,
1.50339237704125e-15,
-0.01807489990428368,
1.04151256682397e-6,
1.199020858194145e-6,
9.20183055286248e-7,
5.29585443263595e-7,
2.437776585139187e-7,
9.34722092079327e-8,
3.069358962414397e-8,
8.80369574802812e-9,
2.236697222350638e-9,
5.078090920612108e-10,
1.032829510265031e-10,
1.866784052537879e-11,
2.899550487861415e-12,
3.320876472501558e-13,
7.14337113839817e-15,
0.00841962796976458,
-4.49861726142382e-7,
-5.17896641633043e-7,
-3.9746074306462e-7,
-2.287511850016158e-7,
-1.053018087038023e-7,
-4.03788268467999e-8,
-1.326103777896171e-8,
-3.804631898917439e-9,
-9.6714711356291e-10,
-2.198216173885314e-10,
-4.481319938970203e-11,
-8.14027463572246e-12,
-1.279633782315893e-12,
-1.53176994544067e-13,
-6.01718325592895e-15,
-0.003152244413394336,
1.569922057105368e-7,
1.80735599966168e-7,
1.387068724608997e-7,
7.98313274502729e-8,
3.675008536294326e-8,
1.409292972816269e-8,
4.628873724890131e-9,
1.328346368168909e-9,
3.378272347898607e-10,
7.68575636353443e-11,
1.569930534777453e-11,
2.863837432573307e-12,
4.547141406498719e-13,
5.637199258761734e-14,
2.97859961020644e-15,
0.000987501890971576,
-4.60522069262484e-8,
-5.30172767559194e-8,
-4.06887549553709e-8,
-2.34182907598032e-8,
-1.07808013118833e-8,
-4.134430426495937e-9,
-1.358104648122085e-9,
-3.898132175687395e-10,
-9.91781276329257e-11,
-2.258217248714664e-11,
-4.620610410839036e-12,
-8.4594102579911e-13,
-1.354584118248143e-13,
-1.727825028396868e-14,
-1.097472701216438e-15,
-0.0002661194234573155,
1.166771787225705e-8,
1.343241413544258e-8,
1.030892613120053e-8,
5.9333362515763e-9,
2.731519429198619e-9,
1.047581749072348e-9,
3.441466142713475e-10,
9.87968624764836e-11,
2.514526782616863e-11,
5.729521774428737e-12,
1.174075903956451e-12,
2.156253635226303e-13,
3.477894013436607e-14,
4.542178041471488e-15,
3.277052895163687e-16,
0.00006295339684151753,
-2.604167497786159e-9,
-2.998044762573413e-9,
-2.300909605083161e-9,
-1.324308816558676e-9,
-6.09681427556236e-10,
-2.338316702979513e-10,
-7.68232074504829e-11,
-2.205765595420269e-11,
-5.615752226929339e-12,
-1.280397783415159e-12,
-2.627172428336841e-13,
-4.838207731849544e-14,
-7.85291936630442e-15,
-1.046210091705169e-15,
-8.2927630742502e-17,
-0.00001327578652955806,
5.19788964521283e-10,
5.98407711408709e-10,
4.59261967143658e-10,
2.643345353731757e-10,
1.216956430789277e-10,
4.667563781126769e-11,
1.533589541084833e-11,
4.40388319648333e-12,
1.121513756405211e-12,
2.558499516088304e-13,
5.255692647018341e-14,
9.70236322382428e-15,
1.583479586238879e-15,
2.145754167147851e-16,
1.828940513726482e-17,
2.526223017531125e-6,
-9.3883816072727e-11,
-1.080840700205615e-10,
-8.29519595569838e-11,
-4.77445049578972e-11,
-2.198118782976512e-11,
-8.43101141805872e-12,
-2.770289584017539e-12,
-7.95619113830256e-13,
-2.026662558491353e-13,
-4.625724946346975e-14,
-9.51198142694818e-15,
-1.759758109793741e-15,
-2.885988845922523e-16,
-3.968614728508119e-17,
-3.584255492905991e-18,
-4.380375659579882e-7,
1.549163565240026e-11,
1.783483010311609e-11,
1.36878560226899e-11,
7.87834795928515e-12,
3.627178196202852e-12,
1.391263406346595e-12,
4.571711175639967e-13,
1.313127268174638e-13,
3.345643048427621e-14,
7.63964944370438e-15,
1.572407708985887e-15,
2.914625905451515e-16,
4.800610391191137e-17,
6.686617633461156e-18,
6.331577091307949e-19,
6.976481262633019e-8,
-2.353468941478366e-12,
-2.709448171486759e-12,
-2.079450795016401e-12,
-1.196881283501683e-12,
-5.51048984129294e-13,
-2.113690889314989e-13,
-6.94596393767116e-14,
-1.99528034204257e-14,
-5.084683386688914e-15,
-1.161540067686619e-15,
-2.392693501530629e-16,
-4.442794888731089e-17,
-7.34587461918013e-18,
-1.034784953815478e-18,
-1.019239030048494e-19,
-1.027820611555973e-8,
3.31424744861204e-13,
3.81555677314389e-13,
2.928376722762137e-13,
1.685511907177052e-13,
7.76025262983594e-14,
2.976712855785289e-14,
9.7824501492234e-15,
2.810337283948475e-15,
7.16304459589152e-16,
1.636922522660634e-16,
3.374492144385554e-17,
6.275644812391326e-18,
1.041260481986177e-18,
1.481395444085199e-19,
1.506793140870843e-20,
1.430582369858065e-9,
-4.41257813312466e-14,
-5.08002642015159e-14,
-3.898846556372023e-14,
-2.244105732296128e-14,
-1.033217936115488e-14,
-3.963347923982214e-15,
-1.302540624315467e-15,
-3.742302785245063e-16,
-9.54008385853406e-17,
-2.180883110153148e-17,
-4.499023467962314e-18,
-8.37913236326405e-19,
-1.39478389467269e-19,
-2.003103856223345e-20,
-2.095415807980588e-21,
-1.829620338670429e-10,
5.41539304433044e-15,
6.23453482005089e-15,
4.784926227348518e-15,
2.754130130519647e-15,
1.268052270042879e-15,
4.864246528643131e-16,
1.598677982347036e-16,
4.593475258451502e-17,
1.171171284392715e-17,
2.678146293672163e-18,
5.528365294832994e-19,
1.030822774592977e-19,
1.718998623478946e-20,
2.504152214962003e-21,
2.87617910726825e-22,
// [{0,0.0001},{2.,0.001}]: m=12
0.01588505435641157,
-1.085284349815909e-6,
-1.249398607510714e-6,
-9.58824267696048e-7,
-5.51800174716403e-7,
-2.53981272652064e-7,
-9.7367544318668e-8,
-3.19614789085082e-8,
-9.16088950763473e-9,
-2.324129385364384e-9,
-5.26122938101518e-10,
-1.063573200799542e-10,
-1.896973176349851e-11,
-2.850962444457382e-12,
-2.8516415661382e-13,
1.085625152610142e-14,
-0.02925790699536026,
1.82923792495694e-6,
2.10586372024877e-6,
1.616119386716627e-6,
9.30093509007486e-7,
4.28121659134251e-7,
1.641425659921663e-7,
5.38911019411106e-8,
1.545236983796781e-8,
3.92333944160205e-9,
8.89558706221195e-10,
1.8042808755341e-10,
3.241681790202532e-11,
4.96185454903965e-12,
5.36544252500444e-13,
-1.50339237704127e-15,
0.02711234985642552,
-1.562268850235954e-6,
-1.798531287291218e-6,
-1.380274582929372e-6,
-7.94378164895392e-7,
-3.656664877708781e-7,
-1.40208313811899e-7,
-4.6040384436216e-8,
-1.320554362204218e-8,
-3.355045833525958e-9,
-7.61713638091816e-10,
-1.549244265397546e-10,
-2.800176078806819e-11,
-4.349325731792123e-12,
-4.981314708752336e-13,
-1.071505670759685e-14,
-0.01683925593953005,
8.99723452284788e-7,
1.035793283266114e-6,
7.94921486129262e-7,
4.57502370003244e-7,
2.106036174076105e-7,
8.07576536936021e-8,
2.652207555792416e-8,
7.60926379783509e-9,
1.934294227125874e-9,
4.396432347770751e-10,
8.96263987794066e-11,
1.62805492714454e-11,
2.559267564631867e-12,
3.063539890881473e-13,
1.203436651185954e-14,
0.00788061103348554,
-3.92480514276334e-7,
-4.51838999915411e-7,
-3.46767181152242e-7,
-1.995783186256782e-7,
-9.18752134073562e-8,
-3.523232432040599e-8,
-1.157218431222509e-8,
-3.320865920422202e-9,
-8.44568086974634e-10,
-1.921439090883566e-10,
-3.92482633694355e-11,
-7.1595935814331e-12,
-1.136785351624628e-12,
-1.409299814690484e-13,
-7.44649902554079e-15,
-0.002962505672872443,
1.381566207775424e-7,
1.590518302663735e-7,
1.220662648650499e-7,
7.02548722787978e-8,
3.234240393536824e-8,
1.240329127937976e-8,
4.074313944330742e-9,
1.169439652696014e-9,
2.97534382896175e-10,
6.77465174608447e-11,
1.386183123239419e-11,
2.537823077374426e-12,
4.063752354705697e-13,
5.183475085129606e-14,
3.292418103612645e-15,
0.000931417982108593,
-4.08370125531184e-8,
-4.70134494743009e-8,
-3.608124145939511e-8,
-2.076667688062829e-8,
-9.56031800224638e-9,
-3.666536121772864e-9,
-1.204513149956174e-9,
-3.457890186695485e-10,
-8.80084373920635e-11,
-2.005332621060878e-11,
-4.10926566386972e-12,
-7.54688772333628e-13,
-1.21726290471576e-13,
-1.589762314498901e-14,
-1.146968512721536e-15,
-0.0002518135882522307,
1.041667001635261e-8,
1.199217907931465e-8,
9.20363844260595e-9,
5.29723527905493e-9,
2.438725716127662e-9,
9.35326683456126e-10,
3.072928305461469e-10,
8.82306240306606e-11,
2.246300896224911e-11,
5.12159114613429e-12,
1.050868973910626e-12,
1.935283097542886e-13,
3.141167754659799e-14,
4.184840379274999e-15,
3.317105234599522e-16,
0.00005974103928257467,
-2.339050337595821e-9,
-2.69283469817327e-9,
-2.066678849716645e-9,
-1.189505407780716e-9,
-5.47630393211234e-10,
-2.100403699036809e-10,
-6.90115292676256e-11,
-1.981747436084281e-11,
-5.046811897872503e-12,
-1.151324780879445e-12,
-2.365061688371312e-13,
-4.366063445142758e-14,
-7.12565812253239e-15,
-9.65589377463088e-16,
-8.23023298278396e-17,
-0.00001263110563364583,
4.6941881143559e-10,
5.40420040495903e-10,
4.14759560165041e-10,
2.387223880185379e-10,
1.099058761764154e-10,
4.215503293366852e-11,
1.385143998052235e-11,
3.978093287720785e-12,
1.013330697480638e-12,
2.312861142447249e-13,
4.755987965385092e-14,
8.79878542228118e-15,
1.442993555239343e-15,
1.984306062164152e-16,
1.792127214963798e-17,
2.409207255609692e-6,
-8.52040136890716e-11,
-9.80915858303891e-11,
-7.52832236766464e-11,
-4.333092272755015e-11,
-1.994948420061148e-11,
-7.65195031596393e-12,
-2.514441666265011e-12,
-7.22220146832013e-13,
-1.840104057517978e-13,
-4.201808064653462e-14,
-8.64824418464546e-15,
-1.603044605871794e-15,
-2.640336677718185e-16,
-3.67763816351058e-17,
-3.482327322272396e-18,
-4.186425136039033e-7,
1.412233941088437e-11,
1.625844558225224e-11,
1.247805290536972e-11,
7.18206367034841e-12,
3.30665117845296e-12,
1.268351586089931e-12,
4.168028813481273e-13,
1.197297642091341e-13,
3.051140096066224e-14,
6.96999538862734e-15,
1.435772017901484e-15,
2.66596791322341e-16,
4.408016115341587e-17,
6.209436398896405e-18,
6.115819735725935e-19,
6.680631370498926e-8,
-2.154205369036403e-12,
-2.480048038973151e-12,
-1.903395855113078e-12,
-1.095554527331214e-12,
-5.044034312447009e-13,
-1.934813526157241e-13,
-6.35842881508667e-14,
-1.826672168423259e-14,
-4.655858945430554e-15,
-1.063972201324218e-15,
-2.193363598897032e-16,
-4.079056126872912e-17,
-6.767896376505048e-18,
-9.62957735053871e-19,
-9.80620368892738e-20,
-9.86002043023122e-9,
3.04498285292775e-13,
3.505568031445203e-13,
2.690472416852754e-13,
1.548587178797527e-13,
7.12991197403601e-14,
2.734980311984635e-14,
8.98840910334276e-15,
2.582436020037467e-15,
6.58326010094323e-16,
1.504934216593317e-16,
3.10453358755966e-17,
5.781791396600654e-18,
9.62271953609004e-19,
1.381590729520629e-19,
1.452373929088961e-20,
1.374708979838913e-9,
-4.06837250800713e-14,
-4.68376162966945e-14,
-3.594727540663524e-14,
-2.069070054283617e-14,
-9.52638012060452e-15,
-3.654318131018036e-15,
-1.201024362375593e-15,
-3.450899483675244e-16,
-8.79855968571554e-17,
-2.011986837729586e-17,
-4.153205194107521e-18,
-7.74510133959045e-19,
-1.292852703515816e-19,
-1.871640149868659e-20,
-2.013025658723561e-21,
-1.760832676987481e-10,
5.00871401547455e-15,
5.76634705364447e-15,
4.425607646449572e-15,
2.547322895472684e-15,
1.172844564744187e-15,
4.499107882775513e-16,
1.478723207904643e-16,
4.249105283628866e-17,
1.083521227585098e-17,
2.478405983327858e-18,
5.118728964044542e-19,
9.55813936491132e-20,
1.604679678121581e-20,
2.32399792743987e-21,
2.062517499266574e-22,
// [{0,0.0001},{2.,0.001}]: m=13
0.01462895349768013,
-9.1461896247847e-7,
-1.052931860124385e-6,
-8.08059693358314e-7,
-4.65046754503743e-7,
-2.14060829567125e-7,
-8.20712829960831e-8,
-2.69455509705553e-8,
-7.72618491898391e-9,
-1.961669720801027e-9,
-4.44779353110597e-10,
-9.0214043776705e-11,
-1.620840895101266e-11,
-2.480927274519825e-12,
-2.682721262502221e-13,
7.5169618852064e-16,
-0.02711234985642551,
1.562268850235954e-6,
1.798531287291218e-6,
1.380274582929372e-6,
7.94378164895392e-7,
3.65666487770878e-7,
1.40208313811899e-7,
4.60403844362159e-8,
1.320554362204218e-8,
3.355045833525957e-9,
7.61713638091816e-10,
1.549244265397546e-10,
2.800176078806819e-11,
4.349325731792123e-12,
4.98131470875234e-13,
1.071505670759684e-14,
0.02525888390929508,
-1.349585178427183e-6,
-1.553689924899171e-6,
-1.192382229193893e-6,
-6.86253555004867e-7,
-3.159054261114158e-7,
-1.211364805404031e-7,
-3.978311333688625e-8,
-1.141389569675264e-8,
-2.901441340688812e-9,
-6.59464852165613e-10,
-1.3443959816911e-10,
-2.442082390716811e-11,
-3.838901346947799e-12,
-4.59530983632221e-13,
-1.805154976779005e-14,
-0.01576122206697193,
7.84961028552691e-7,
9.03677999830848e-7,
6.93534362304505e-7,
3.99156637251368e-7,
1.837504268147179e-7,
7.04646486408141e-8,
2.314436862445086e-8,
6.6417318408446e-9,
1.689136173949318e-9,
3.842878181767247e-10,
7.84965267388734e-11,
1.431918716286665e-11,
2.27357070324933e-12,
2.81859962938109e-13,
1.489299805108336e-14,
0.00740626418218082,
-3.45391551943848e-7,
-3.97629575665925e-7,
-3.051656621626181e-7,
-1.756371806969907e-7,
-8.08560098384188e-8,
-3.100822819844872e-8,
-1.018578486082663e-8,
-2.92359913173997e-9,
-7.43835957240421e-10,
-1.69366293652108e-10,
-3.465457808098467e-11,
-6.34455769343593e-12,
-1.015938088676446e-12,
-1.295868771282302e-13,
-8.23104525898488e-15,
-0.002794253946285026,
1.225110376582394e-7,
1.41040348421618e-7,
1.082437243771994e-7,
6.23000306413174e-8,
2.868095400647787e-8,
1.099960836521836e-8,
3.613539449835579e-9,
1.037367055999178e-9,
2.640253121737762e-10,
6.01599786312739e-11,
1.232779699149499e-11,
2.264066316979585e-12,
3.651788714111759e-13,
4.769286943440043e-14,
3.440905538082392e-15,
0.000881347558890517,
-3.64583450574376e-8,
-4.19726267778355e-8,
-3.221273454930057e-8,
-1.854032347679572e-8,
-8.53554000649446e-9,
-3.273643392114718e-9,
-1.075524906917521e-9,
-3.088071841090385e-10,
-7.86205313683121e-11,
-1.792556901157084e-11,
-3.678041408708516e-12,
-6.77349084143755e-13,
-1.099408714125395e-13,
-1.464694132771888e-14,
-1.160986833310096e-15,
-0.0002389641579843458,
9.35620137376642e-9,
1.077133881961325e-8,
8.26671541952756e-9,
4.7580216430151e-9,
2.190521578320433e-9,
8.40161481715193e-10,
2.760461177608865e-10,
7.92698976417655e-11,
2.018724764208699e-11,
4.605299135094362e-12,
9.4602467774098e-13,
1.746425382523303e-13,
2.850263256473575e-14,
3.862357521443379e-15,
3.292093208914795e-16,
0.00005683997525448241,
-2.112384648902347e-9,
-2.431890179286851e-9,
-1.866418018482641e-9,
-1.074250744782559e-9,
-4.94576442194914e-10,
-1.896976479717381e-10,
-6.23314798368271e-11,
-1.79014197730394e-11,
-4.559988133128192e-12,
-1.040787512833617e-12,
-2.140194581741984e-13,
-3.95945343532417e-14,
-6.493471005541453e-15,
-8.92937724683815e-16,
-8.06457096894445e-17,
-0.00001204602716663737,
4.26019818985074e-10,
4.90457641957268e-10,
3.764158979640503e-10,
2.166544867667957e-10,
9.97473625883593e-11,
3.825972917120423e-11,
1.257220096604275e-11,
3.611098617613717e-12,
9.20051488970907e-13,
2.100902797298819e-13,
4.324119540032073e-14,
8.01521826286754e-15,
1.320167541319152e-15,
1.838817865134589e-16,
1.741162116403761e-17,
2.302534445178863e-6,
-7.76728831309293e-11,
-8.9421469549825e-11,
-6.86293054447892e-11,
-3.950135851299558e-11,
-1.818658531506371e-11,
-6.97593519412322e-12,
-2.292416330797316e-12,
-6.58513842066022e-13,
-1.678127407078255e-13,
-3.833498275115396e-14,
-7.89674781515627e-15,
-1.466282652579477e-15,
-2.424408408971786e-16,
-3.415192203609259e-17,
-3.36379713228292e-18,
-4.008895763422916e-7,
1.292664752698188e-11,
1.488191763266311e-11,
1.142162567876736e-11,
6.57404696627213e-12,
3.026752003222666e-12,
1.161015250960665e-12,
3.815475158302874e-13,
1.096123383306061e-13,
2.793821616085098e-14,
6.38453389840874e-15,
1.316162960337476e-15,
2.447704177557933e-16,
4.061191031505636e-17,
5.778428327577458e-18,
5.884535930086869e-19,
6.408817761105612e-8,
-1.979187257796411e-12,
-2.278559819061866e-12,
-1.748761480878274e-12,
-1.00655542495481e-12,
-4.63432196060771e-13,
-1.777690853059765e-13,
-5.84231356970224e-14,
-1.67853963101651e-14,
-4.279007419856271e-15,
-9.78181668125714e-16,
-2.017892708534315e-16,
-3.758069976103338e-17,
-6.254914328593389e-18,
-8.97962607608761e-19,
-9.40986075639028e-20,
-9.47448935538047e-9,
2.807211134616315e-13,
3.23183469001842e-13,
2.480391912928257e-13,
1.427675381359859e-13,
6.57327917451601e-14,
2.521507791575372e-14,
8.28715305847941e-15,
2.381140453964205e-15,
6.071033118689835e-16,
1.38826610519728e-16,
2.86565558818159e-17,
5.343862118346574e-18,
8.91964941181705e-19,
1.290755032567031e-19,
1.387055927240534e-20,
1.323031016135611e-9,
-3.76288617404881e-14,
-4.33207158688481e-14,
-3.324817095787224e-14,
-1.913722023683273e-14,
-8.81120542699336e-15,
-3.380035773538776e-15,
-1.110917543584386e-15,
-3.192217780028097e-16,
-8.14015084355359e-17,
-1.861952123486044e-17,
-3.845710464854974e-18,
-7.180204797250433e-19,
-1.201664571840128e-19,
-1.752047574782883e-20,
-1.926132466399336e-21,
-1.697024451801858e-10,
4.64614065910326e-15,
5.34893510847758e-15,
4.105256787564781e-15,
2.362942494080205e-15,
1.087960386284606e-15,
4.173553380603572e-16,
1.371767010760593e-16,
3.942019803331886e-17,
1.005343651854418e-17,
2.30019025850263e-18,
4.753343775633826e-19,
8.88361257588641e-20,
1.49078330219497e-20,
2.197637876473961e-21,
2.415094813632007e-22,
// [{0,0.0001},{2.,0.001}]: m=14
0.01355617492821276,
-7.81134425117977e-7,
-8.99265643645609e-7,
-6.90137291464686e-7,
-3.97189082447696e-7,
-1.82833243885439e-7,
-7.01041569059495e-8,
-2.3020192218108e-8,
-6.60277181102109e-9,
-1.677522916762979e-9,
-3.80856819045908e-10,
-7.74622132698773e-11,
-1.40008803940341e-11,
-2.174662865896061e-12,
-2.490657354376168e-13,
-5.35752835379842e-15,
-0.02525888390929507,
1.349585178427183e-6,
1.553689924899171e-6,
1.192382229193893e-6,
6.86253555004867e-7,
3.15905426111416e-7,
1.211364805404031e-7,
3.97831133368862e-8,
1.141389569675264e-8,
2.901441340688812e-9,
6.59464852165613e-10,
1.344395981691099e-10,
2.44208239071681e-11,
3.838901346947799e-12,
4.59530983632221e-13,
1.805154976779005e-14,
0.0236418331004579,
-1.177441542829036e-6,
-1.355516999746272e-6,
-1.040301543456757e-6,
-5.98734955877052e-7,
-2.756256402220769e-7,
-1.056969729612211e-7,
-3.471655293667629e-8,
-9.9625977612669e-9,
-2.533704260923977e-9,
-5.76431727265087e-10,
-1.177447901083101e-10,
-2.147878074429998e-11,
-3.410356054873995e-12,
-4.227899444071634e-13,
-2.233949707662503e-14,
-0.01481252836436246,
6.90783103887718e-7,
7.95259151331875e-7,
6.10331324325255e-7,
3.512743613939924e-7,
1.617120196768427e-7,
6.20164563968994e-8,
2.03715697216539e-8,
5.84719826348012e-9,
1.487671914480889e-9,
3.387325873042266e-10,
6.93091561619716e-11,
1.268911538687227e-11,
2.031876177352963e-12,
2.591737542564713e-13,
1.64620905179702e-14,
0.00698563486571228,
-3.06277594145591e-7,
-3.52600871054037e-7,
-2.706093109429923e-7,
-1.557500766032899e-7,
-7.1702385016193e-8,
-2.749902091304527e-8,
-9.03384862458874e-9,
-2.593417639997886e-9,
-6.60063280434425e-10,
-1.503999465781813e-10,
-3.081949247873675e-11,
-5.660165792448819e-12,
-9.12947178527916e-13,
-1.192321735860051e-13,
-8.60226384520541e-15,
-0.002644042676632222,
1.093750351712749e-7,
1.259178803323117e-7,
9.66382036469847e-8,
5.56209704298593e-8,
2.560662001924034e-8,
9.82093017625092e-9,
3.22657472072192e-9,
9.26421552318309e-10,
2.358615941026901e-10,
5.377670703419846e-11,
1.103412422601926e-11,
2.032047252411395e-12,
3.298226142342892e-13,
4.394082398264999e-14,
3.482960499870569e-15,
0.000836374552952659,
-3.27467048083722e-8,
-3.76996858688648e-8,
-2.893350396851407e-8,
-1.665307575064934e-8,
-7.66682552416594e-9,
-2.940565186020219e-9,
-9.66161412168705e-10,
-2.774446417477894e-10,
-7.06553667477151e-11,
-1.611854697292421e-11,
-3.311086372112869e-12,
-6.112488838869741e-13,
-9.97592139771747e-14,
-1.351825132494006e-14,
-1.152232623172795e-15,
-0.0002273599018421071,
8.44953861735874e-9,
9.72756074218667e-9,
7.465672093148e-9,
4.297002990191629e-9,
1.978305773872649e-9,
7.58790593840717e-10,
2.493259199894927e-10,
7.16056792767117e-11,
1.823995257958564e-11,
4.163150062107246e-12,
8.56077834924305e-13,
1.583781378295079e-13,
2.597388409174216e-14,
3.571750909214163e-15,
3.225828402963219e-16,
0.00005420712215621996,
-1.917089183047733e-9,
-2.207059386061818e-9,
-1.693871538730777e-9,
-9.74945189237546e-10,
-4.488631310890961e-10,
-1.721687810561574e-10,
-5.65749042767646e-11,
-1.624994375902061e-11,
-4.140231695205794e-12,
-9.45406257603369e-13,
-1.945853790568533e-13,
-3.606848213479242e-14,
-5.940753928751368e-15,
-8.27468040836516e-16,
-7.83522942915302e-17,
-0.00001151266343314466,
3.88364183624087e-10,
4.47107080620417e-10,
3.431463222048261e-10,
1.975066745576998e-10,
9.09328722412869e-11,
3.487965512708753e-11,
1.14620748029154e-11,
3.292567241434648e-12,
8.39063201347227e-13,
1.916747988279483e-13,
3.948371531200812e-14,
7.33140881817749e-15,
1.212203462240526e-15,
1.707594991447515e-16,
1.681896862802037e-17,
2.204893269274721e-6,
-7.10965766640859e-11,
-8.18505645545147e-11,
-6.28189547218121e-11,
-3.615726607844301e-11,
-1.664713959249905e-11,
-6.38558525165125e-12,
-2.098511787834599e-12,
-6.02867990370332e-13,
-1.536602219317413e-13,
-3.51149440005362e-14,
-7.23889784811179e-15,
-1.346237606322361e-15,
-2.233655513588362e-16,
-3.178134522211645e-17,
-3.236501654742779e-18,
-3.845789518520748e-7,
1.187643997288874e-11,
1.367287446993825e-11,
1.04937320618914e-11,
6.0400020643934e-12,
2.780901440665428e-12,
1.0667327676616e-12,
3.505776837564921e-13,
1.007235483962237e-13,
2.567689370725763e-14,
5.869742050823569e-15,
1.210870446473103e-15,
2.255094184446351e-16,
3.753370141247785e-17,
5.388403638014542e-18,
5.646862914006763e-19,
6.158229170070776e-8,
-1.824639124701254e-12,
-2.100637157873041e-12,
-1.612212231463826e-12,
-9.27964528285793e-13,
-4.272518797415617e-13,
-1.638936843187097e-13,
-5.386507419629282e-14,
-1.547700464211264e-14,
-3.946067373371987e-15,
-9.02349144561554e-16,
-1.862626751826858e-16,
-3.47341288377542e-17,
-5.797633826910771e-18,
-8.39026463438296e-19,
-9.01362633704477e-20,
-9.11793621250478e-9,
2.596210832422705e-13,
2.9889213614817e-13,
2.29396400450305e-13,
1.320376074759048e-13,
6.07930623677856e-14,
2.332060412682628e-14,
7.66478427377829e-15,
2.202469198169473e-15,
5.616273137202276e-16,
1.28463900106764e-16,
2.653275658004932e-17,
4.953704766255004e-18,
8.29041977414193e-19,
1.208413811991376e-19,
1.32220282607487e-20,
1.275093518716196e-9,
-3.49052736082348e-14,
-4.01851897600438e-14,
-3.084175086680971e-14,
-1.775218661503228e-14,
-8.17357016607886e-15,
-3.135484846193008e-15,
-1.030573878079466e-15,
-2.961540438475411e-16,
-7.55289689568174e-17,
-1.728074918447067e-17,
-3.57108719945005e-18,
-6.674731807008576e-19,
-1.11977494087019e-19,
-1.643583934063682e-20,
-1.83828951242181e-21,
-1.637674387826546e-10,
4.32152351133262e-15,
4.97521962452644e-15,
3.818440765452749e-15,
2.197862340134106e-15,
1.011960656564188e-15,
3.882066246258935e-16,
1.275998564441334e-16,
3.667029535484621e-17,
9.35323293210897e-18,
2.140500381365876e-18,
4.425696459007032e-19,
8.27966973124866e-20,
1.387449016390116e-20,
2.060374515330747e-21,
2.848215862778604e-22,
// [{0,0.0001},{2.,0.001}]: m=15
0.01262944195464754,
-6.74792589213591e-7,
-7.76844962449586e-7,
-5.96191114596947e-7,
-3.43126777502433e-7,
-1.579527130557079e-7,
-6.05682402702015e-8,
-1.989155666844312e-8,
-5.70694784837632e-9,
-1.450720670344406e-9,
-3.29732426082806e-10,
-6.7219799084555e-11,
-1.221041195358405e-11,
-1.9194506734739e-12,
-2.297654918161105e-13,
-9.02577488389503e-15,
-0.0236418331004579,
1.177441542829036e-6,
1.355516999746272e-6,
1.040301543456757e-6,
5.98734955877052e-7,
2.756256402220769e-7,
1.056969729612211e-7,
3.47165529366763e-8,
9.9625977612669e-9,
2.533704260923977e-9,
5.76431727265087e-10,
1.177447901083101e-10,
2.147878074429997e-11,
3.410356054873995e-12,
4.227899444071634e-13,
2.233949707662506e-14,
0.02221879254654369,
-1.036174655831577e-6,
-1.192888726997812e-6,
-9.15496986487883e-7,
-5.26911542090989e-7,
-2.425680295152641e-7,
-9.30246845953491e-8,
-3.055735458248085e-8,
-8.77079739522019e-9,
-2.231507871721334e-9,
-5.0809888095634e-10,
-1.039637342429573e-10,
-1.90336730803084e-11,
-3.047814266029445e-12,
-3.887606313847069e-13,
-2.46931357769549e-14,
-0.01397126973142536,
6.12555188291203e-7,
7.05201742108097e-7,
5.41218621886002e-7,
3.115001532065901e-7,
1.434047700323907e-7,
5.49980418260923e-8,
1.806769724917807e-8,
5.18683527999594e-9,
1.320126560868894e-9,
3.007998931563726e-10,
6.16389849574756e-11,
1.132033158489802e-11,
1.825894357055898e-12,
2.384643471720211e-13,
1.72045276904106e-14,
0.00661010669158029,
-2.73437587928181e-7,
-3.14794700830772e-7,
-2.415955091174559e-7,
-1.39052426074645e-7,
-6.40165500480993e-8,
-2.455232544062671e-8,
-8.0664368018046e-9,
-2.316053880795716e-9,
-5.89653985256711e-10,
-1.344417675854929e-10,
-2.758531056504748e-11,
-5.080118131028357e-12,
-8.24556535585667e-13,
-1.098520599566235e-13,
-8.70740124971173e-15,
-0.002509123658819978,
9.82401144241488e-8,
1.130990576054802e-7,
8.68005119046871e-8,
4.99592272514558e-8,
2.30004765722712e-8,
8.82169555797372e-9,
2.898484236477538e-9,
8.32333925235155e-10,
2.119661002410504e-10,
4.835564091829308e-11,
9.93325911623943e-12,
1.83374665164238e-12,
2.992776419283717e-13,
4.055475397431712e-14,
3.456697869481877e-15,
0.00079575965645458,
-2.95733851609329e-8,
-3.40464625978575e-8,
-2.612985232617468e-8,
-1.503951046576088e-8,
-6.92407020859579e-9,
-2.65576707845844e-9,
-8.72640719968461e-10,
-2.506198774699959e-10,
-6.38398340289337e-11,
-1.457102521746324e-11,
-2.996272422252893e-12,
-5.543234824067528e-13,
-9.09085943226428e-14,
-1.250112818226372e-14,
-1.129039940014972e-15,
-0.0002168284894212044,
7.66835675247179e-9,
8.82823756759593e-9,
6.77548617284305e-9,
3.899780767264787e-9,
1.795452529105564e-9,
6.88675126046527e-10,
2.262996177059154e-10,
6.49997752081944e-11,
1.656092682472746e-11,
3.781625040463424e-12,
7.78341518306042e-13,
1.442739289279793e-13,
2.376301578081605e-14,
3.309872173628679e-15,
3.134091781431734e-16,
0.00005180698535856437,
-1.747638824079088e-9,
-2.011981860225352e-9,
-1.544158447951925e-9,
-8.88780034375846e-10,
-4.091979245637475e-10,
-1.569584478716232e-10,
-5.157933654728883e-11,
-1.481655256753512e-11,
-3.775784401234614e-12,
-8.62536593620971e-13,
-1.776767186800917e-13,
-3.299133963798088e-14,
-5.454915560109004e-15,
-7.68417746139303e-16,
-7.56853723688601e-17,
-0.00001102445785076988,
3.55482666956193e-10,
4.09252573679745e-10,
3.140945824320043e-10,
1.807862203519347e-10,
8.32356472963567e-11,
3.192790682153178e-11,
1.049255255032957e-11,
3.0143381156925e-12,
7.6830064127038e-13,
1.755746127864315e-13,
3.619446706442054e-14,
6.73118388185672e-15,
1.116827055529184e-15,
1.58906618397215e-16,
1.618249739984052e-17,
2.115184814982735e-6,
-6.53204341193957e-11,
-7.52008260115237e-11,
-5.7715538947929e-11,
-3.322001861099767e-11,
-1.529496126496452e-11,
-5.8670315039583e-12,
-1.928177682004454e-12,
-5.53979637280588e-13,
-1.41222946290716e-13,
-3.228358835062223e-14,
-6.65978888812181e-15,
-1.240302082333064e-15,
-2.064354885860296e-16,
-2.963621944593793e-17,
-3.105684111919709e-18,
-3.695419505305597e-7,
1.094906229214824e-11,
1.260523617706831e-11,
9.67435803309023e-12,
5.56841148398185e-12,
2.563798733126014e-12,
9.83472380299215e-13,
3.232266923242247e-13,
9.28724453147197e-14,
2.367906164412808e-14,
5.414703156813115e-15,
1.117701869558986e-15,
2.084283243705711e-16,
3.47897783791591e-17,
5.034761359828357e-18,
5.408809009973649e-19,
5.926475803201487e-8,
-1.687492071066243e-12,
-1.942747112471684e-12,
-1.491036867827705e-12,
-8.58221577253611e-13,
-3.951443746116254e-13,
-1.5157988691804e-13,
-4.98197698318423e-14,
-1.431566811336888e-14,
-3.650480148957106e-15,
-8.34993064855363e-16,
-1.724584054834516e-16,
-3.21981949095154e-17,
-5.388351418535796e-18,
-7.854721016568884e-19,
-8.62399531452197e-20,
-8.78721574317139e-9,
2.408112457128462e-13,
2.77237344191711e-13,
2.127770132838358e-13,
1.224721926514896e-13,
5.63893830779298e-14,
2.163167120832348e-14,
7.10991051715286e-15,
2.043157967904888e-15,
5.210703663376336e-16,
1.192181621218891e-16,
2.463623675288266e-17,
4.604652159153836e-18,
7.72436377455591e-19,
1.133396522187845e-19,
1.267752702870482e-20,
1.230504954674273e-9,
-3.24667767711064e-14,
-3.737787032018018e-14,
-2.86872128936192e-14,
-1.651211828241882e-14,
-7.60266652306027e-15,
-2.916522122670593e-15,
-9.58633401236976e-16,
-2.754969918425909e-16,
-7.02691181973516e-17,
-1.608118291505807e-17,
-3.32482285611464e-18,
-6.22066464074225e-19,
-1.045888556209307e-19,
-1.544774475357566e-20,
-1.756607889681167e-21,
-1.58233145321541e-10,
4.02974785684572e-15,
4.63931244489079e-15,
3.560640830944739e-15,
2.049481898226978e-15,
9.4364839787566e-16,
3.620057613900332e-16,
1.189911494715616e-16,
3.419816480374666e-17,
8.72365013662195e-18,
1.996863472942071e-18,
4.130490601786899e-19,
7.73501375561445e-20,
1.301898771757847e-20,
1.937576698117748e-21,
2.331066498064726e-22,
// [{0,0.0001},{2.,0.001}]: m=16
0.01182091655022895,
-5.88720771414518e-7,
-6.77758499873136e-7,
-5.20150771728378e-7,
-2.99367477938526e-7,
-1.378128201110384e-7,
-5.28484864806105e-8,
-1.735827646833814e-8,
-4.98129888063345e-9,
-1.266852130461989e-9,
-2.88215863632543e-10,
-5.8872395054155e-11,
-1.073939037214999e-11,
-1.705178027436997e-12,
-2.113949722035817e-13,
-1.116974853831253e-14,
-0.02221879254654368,
1.036174655831577e-6,
1.192888726997812e-6,
9.15496986487883e-7,
5.26911542090989e-7,
2.425680295152641e-7,
9.30246845953491e-8,
3.055735458248084e-8,
8.77079739522019e-9,
2.231507871721333e-9,
5.0809888095634e-10,
1.039637342429573e-10,
1.90336730803084e-11,
3.047814266029444e-12,
3.887606313847069e-13,
2.469313577695489e-14,
0.02095690459713804,
-9.18832782436804e-7,
-1.057802613162145e-6,
-8.11827932829004e-7,
-4.67250229809885e-7,
-2.151071550485861e-7,
-8.24970627391385e-8,
-2.71015458737671e-8,
-7.78025291999391e-9,
-1.980189841303341e-9,
-4.51199839734559e-10,
-9.24584774362134e-11,
-1.698049737734704e-11,
-2.738841535583848e-12,
-3.576965207580315e-13,
-2.580679153561584e-14,
-0.01322021338316134,
5.4687517585638e-7,
6.29589401661565e-7,
4.83191018234928e-7,
2.781048521492995e-7,
1.28033100096203e-7,
4.91046508812551e-8,
1.613287360360976e-8,
4.632107761591591e-9,
1.179307970513462e-9,
2.688835351709951e-10,
5.51706211300969e-11,
1.016023626205707e-11,
1.649113071171395e-12,
2.197041199132589e-13,
1.741480249942506e-14,
0.006272809147049685,
-2.45600286060366e-7,
-2.827476440136933e-7,
-2.170012797617123e-7,
-1.248980681286364e-7,
-5.75011914306765e-8,
-2.205423889493374e-8,
-7.24621059119366e-9,
-2.080834813087835e-9,
-5.29915250602612e-10,
-1.208891022957296e-10,
-2.483314779059793e-11,
-4.584366629105822e-12,
-7.48194104820901e-13,
-1.013868849357998e-13,
-8.64174467371051e-15,
-0.002387278969326983,
8.87201554818942e-8,
1.021393877925311e-7,
7.83895569777248e-8,
4.51185313968226e-8,
2.077221062557556e-8,
7.96730123529406e-9,
2.617922159878671e-9,
7.51859632402311e-10,
1.915195020848427e-10,
4.371307565194127e-11,
8.98881726666588e-12,
1.662970447202947e-12,
2.727257829650119e-13,
3.750338454626086e-14,
3.387119819977744e-15,
0.000758899712981192,
-2.68392486338174e-8,
-3.089883148677699e-8,
-2.371420160509743e-8,
-1.364923268551123e-8,
-6.28408385190837e-9,
-2.410362941177765e-9,
-7.92048661975609e-10,
-2.274992132300902e-10,
-5.79632438869059e-11,
-1.323568764170431e-11,
-2.724195314088085e-12,
-5.049587512512866e-13,
-8.31705552336378e-14,
-1.158455260757179e-14,
-1.096932123323579e-15,
-0.0002072279422045484,
6.99055531527245e-9,
8.04792746272495e-9,
6.17663380855714e-9,
3.555120147144286e-9,
1.636791702694005e-9,
6.27833793189425e-10,
2.063173467489228e-10,
5.92662104310263e-11,
1.510313764598323e-11,
3.450146383881493e-12,
7.10706876665061e-13,
1.319653589152078e-13,
2.181966230175486e-14,
3.073670995100446e-15,
3.027414907011824e-16,
0.00004961006024074581,
-1.599671999214596e-9,
-1.841636579154688e-9,
-1.413425619098835e-9,
-8.13537990521623e-10,
-3.745604123445817e-10,
-1.436755805092874e-10,
-4.721648641481416e-11,
-1.356452150289074e-11,
-3.457352881193832e-12,
-7.90085756503748e-13,
-1.628751015770894e-13,
-3.029032742656729e-14,
-5.025721739768929e-15,
-7.150797838835605e-16,
-7.282124078666844e-17,
-0.0000105759158570464,
3.26601968365585e-10,
3.76003897235268e-10,
2.885775160497855e-10,
1.660999902019297e-10,
7.64747589676133e-11,
2.933513935221814e-11,
9.64088243819556e-12,
2.769896470007151e-12,
7.06114293571094e-13,
1.614178414970205e-13,
3.329892369438642e-14,
6.201506531829435e-15,
1.032176787558258e-15,
1.481809894765433e-16,
1.552840848182198e-17,
2.032481289358259e-6,
-6.02198559726818e-11,
-6.93288143615695e-11,
-5.32089809919833e-11,
-3.062626995969443e-11,
-1.410089616215817e-11,
-5.40909929240365e-12,
-1.777747202491087e-12,
-5.107985626818708e-13,
-1.302348679912843e-13,
-2.97808739889596e-14,
-6.147361643839864e-15,
-1.1463560491833e-15,
-1.913438474792982e-16,
-2.769118313057235e-17,
-2.974827572255353e-18,
-3.556351727778543e-7,
1.012609978823168e-11,
1.165780359476602e-11,
8.94723500567353e-12,
5.14991300138063e-12,
2.371134929271677e-12,
9.09582395418079e-13,
2.989525002100396e-13,
8.59037466702949e-14,
2.190536522495259e-14,
5.010527186568595e-15,
1.0348681354816e-15,
1.932112006520031e-16,
3.233382885242499e-17,
4.713422441603742e-18,
5.175072883203839e-19,
5.711513283435658e-8,
-1.565230971966201e-12,
-1.801994239890713e-12,
-1.383013364838931e-12,
-7.96047827643828e-13,
-3.665211253035327e-13,
-1.406020784282137e-13,
-4.621317436182355e-14,
-1.328016922880918e-14,
-3.386866143522284e-15,
-7.74897166924572e-16,
-1.601312507286627e-16,
-2.99294096556207e-17,
-5.020622618446095e-18,
-7.36714298483381e-19,
-8.24626594481361e-20,
-8.47962153368826e-9,
2.23972059875808e-13,
2.578512325049327e-13,
1.978987239983023e-13,
1.139088287510797e-13,
5.244697595778809e-14,
2.011961272362782e-14,
6.61312238935286e-15,
1.900510122230071e-15,
4.847484933135743e-16,
1.109346329261656e-16,
2.293570216484723e-17,
4.291144098009516e-18,
7.21440488922859e-19,
1.064910234017906e-19,
1.209523504104623e-20,
1.188926546482424e-9,
-3.027495785676032e-14,
-3.485453534901896e-14,
-2.675061958782579e-14,
-1.539748427134207e-14,
-7.08950475900818e-15,
-2.719701196356828e-15,
-8.93964773405686e-16,
-2.569263344405707e-16,
-6.553967465403424e-17,
-1.50021866410451e-17,
-3.103143699010849e-18,
-5.811399975672977e-19,
-9.79103936414276e-20,
-1.453149732322786e-20,
-1.671944157038608e-21,
-1.530603422594229e-10,
3.76653175331636e-15,
4.33628410447437e-15,
3.328073945151517e-15,
1.915624011886971e-15,
8.82021486020155e-16,
3.383685477493158e-16,
1.112244505041241e-16,
3.196764583682583e-17,
8.15550335266358e-18,
1.867202449184393e-18,
3.863947419486052e-19,
7.241722765491095e-20,
1.219676581270092e-20,
1.82920180082645e-21,
2.450277519634389e-22,
// [{0,0.0001},{2.,0.001}]: m=17
0.01110939627327184,
-5.18087327915789e-7,
-5.96444363498906e-7,
-4.57748493243941e-7,
-2.63455771045494e-7,
-1.21284014757632e-7,
-4.65123422976745e-8,
-1.527867729124042e-8,
-4.38539869761009e-9,
-1.115753935860667e-9,
-2.5404944047817e-10,
-5.19818671214787e-11,
-9.5168365401542e-12,
-1.523907133014722e-12,
-1.943803156923534e-13,
-1.234656788847745e-14,
-0.02095690459713804,
9.18832782436804e-7,
1.057802613162145e-6,
8.11827932829004e-7,
4.67250229809885e-7,
2.151071550485861e-7,
8.24970627391385e-8,
2.71015458737671e-8,
7.78025291999391e-9,
1.980189841303341e-9,
4.51199839734559e-10,
9.24584774362134e-11,
1.698049737734704e-11,
2.738841535583847e-12,
3.576965207580315e-13,
2.580679153561584e-14,
0.01983032007474201,
-8.2031276378457e-7,
-9.44384102492347e-7,
-7.24786527352393e-7,
-4.17157278223949e-7,
-1.920496501443045e-7,
-7.36569763218827e-8,
-2.419931040541465e-8,
-6.94816164238739e-9,
-1.768961955770194e-9,
-4.033253027564926e-10,
-8.27559316951453e-11,
-1.524035439308561e-11,
-2.473669606757094e-12,
-3.295561798698882e-13,
-2.612220374913713e-14,
-0.01254561829410011,
4.91200572120749e-7,
5.65495288027407e-7,
4.3400255952344e-7,
2.497961362572818e-7,
1.150023828613572e-7,
4.41084777898691e-8,
1.449242118238784e-8,
4.16166962617582e-9,
1.059830501205263e-9,
2.41778204591468e-10,
4.966629558119767e-11,
9.16873325821199e-12,
1.496388209641861e-12,
2.027737698716071e-13,
1.728348934741964e-14,
0.005968197423317204,
-2.218003887047295e-7,
-2.55348469481321e-7,
-1.959738924443068e-7,
-1.127963284920535e-7,
-5.19305265639375e-8,
-1.991825308823463e-8,
-6.5448053996965e-9,
-1.879649081005727e-9,
-4.78798755212094e-10,
-1.092826891298503e-10,
-2.247204316666411e-11,
-4.157426118007248e-12,
-6.81814457412481e-13,
-9.37584613656574e-14,
-8.46779954997662e-15,
-0.002276699138907984,
8.05177459006047e-8,
9.26964944593555e-8,
7.11426048145436e-8,
4.094769805610275e-8,
1.885225155552668e-8,
7.23108882345717e-9,
2.376145985901804e-9,
6.82497639683078e-10,
1.738897316588825e-10,
3.970706292469273e-11,
8.17258594217729e-12,
1.514876253737508e-12,
2.495116656980723e-13,
3.475365782234151e-14,
3.290796370020211e-15,
0.000725297797722682,
-2.44669436036095e-8,
-2.816774611971681e-8,
-2.161821833008777e-8,
-1.24429205150843e-8,
-5.72877095946553e-9,
-2.197418276176995e-9,
-7.22110713625834e-10,
-2.074317365099156e-10,
-5.286098176127907e-11,
-1.207551234366251e-11,
-2.487474068343467e-12,
-4.618787562064073e-13,
-7.63688180574049e-14,
-1.075784848274485e-14,
-1.059595216623046e-15,
-0.0001984402417088875,
6.39868801461532e-9,
7.36654633706175e-9,
5.65370249208525e-9,
3.25415197111756e-9,
1.498241653536576e-9,
5.74702323632391e-10,
1.888659461836379e-10,
5.425808616228552e-11,
1.382941156323104e-11,
3.160343034820934e-12,
6.51500408130935e-13,
1.211613100487504e-13,
2.01028870181572e-14,
2.860319143589872e-15,
2.912849626743641e-16,
0.00004759162127168222,
-1.469708855684926e-9,
-1.692017535301982e-9,
-1.298598820492006e-9,
-7.4744995491173e-10,
-3.441364148952217e-10,
-1.320081269088775e-10,
-4.338397091399054e-11,
-1.246453409839215e-11,
-3.177514316823473e-12,
-7.26380285764838e-13,
-1.498451564264942e-13,
-2.790677935352528e-14,
-4.644795528539621e-15,
-6.668144536907383e-16,
-6.987784829149055e-17,
-0.00001016239848909105,
3.01099090425037e-10,
3.466438537135194e-10,
2.660447375734829e-10,
1.531312534513265e-10,
7.05044364488713e-11,
2.704547944332061e-11,
8.88873041813997e-12,
2.553991205438616e-12,
6.51173929695269e-13,
1.489042759988063e-13,
3.073678877359687e-14,
5.731776593872129e-15,
9.56718611930145e-16,
1.384558277122196e-16,
1.487413713668523e-17,
1.955993994487951e-6,
-5.56935613814614e-11,
-6.41179342152464e-11,
-4.92098036169516e-11,
-2.832452788853513e-11,
-1.304124504904075e-11,
-5.002704301943596e-12,
-1.644239121673381e-12,
-4.724707131900241e-13,
-1.204795359161322e-13,
-2.755790574621865e-14,
-5.691776015053508e-15,
-1.062661856550199e-15,
-1.778361554878192e-16,
-2.592381799008454e-17,
-2.84622712425434e-18,
-3.427359455308221e-7,
9.39246061289168e-12,
1.081320280038294e-11,
8.29902985816521e-12,
4.77683359266131e-12,
2.199378439755718e-12,
8.43709026374843e-13,
2.773107855937842e-13,
7.96901382157602e-14,
2.032352448192157e-14,
4.649916008099793e-15,
9.60897837439479e-16,
1.795971697236569e-16,
3.012726001411805e-17,
4.420794381079359e-18,
4.948084439182831e-19,
5.511582477782486e-8,
-1.455778847398149e-12,
-1.675987488049191e-12,
-1.286306767060244e-12,
-7.40387276080028e-13,
-3.408960838898607e-13,
-1.307739302854089e-13,
-4.29841277693008e-14,
-1.235298012808119e-14,
-3.150779547527583e-15,
-7.21055509278134e-16,
-1.490780588875324e-16,
-2.789164177042218e-17,
-4.689064190119928e-18,
-6.922062540770054e-19,
-7.881236000172302e-20,
-8.19281212432923e-9,
2.088377876613648e-13,
2.404278784168321e-13,
1.845267583340098e-13,
1.062124034615386e-13,
4.89036513660542e-14,
1.876058698023573e-14,
6.16659347770297e-15,
1.772282297250134e-15,
4.520924826414871e-16,
1.034844325643224e-16,
2.140509386353025e-17,
4.008512918039279e-18,
6.753101307877538e-19,
1.002358288650155e-19,
1.154152208280701e-20,
1.150063683133295e-9,
-2.82976573960949e-14,
-3.25781621663469e-14,
-2.500355848722193e-14,
-1.439193307732574e-14,
-6.6265584332965e-15,
-2.542136532721052e-15,
-8.35620695315595e-16,
-2.401704921073787e-16,
-6.12717061776457e-17,
-1.402814917344287e-17,
-2.902893278494789e-18,
-5.441057189400685e-19,
-9.18371639277373e-20,
-1.37029548013763e-20,
-1.605353941183668e-21,
-1.482147602604988e-10,
3.5282685698791e-15,
4.061982561904712e-15,
3.117553675948382e-15,
1.794454857815437e-15,
8.2623581425018e-16,
3.169713526832175e-16,
1.041935064351243e-16,
2.994827399069433e-17,
7.64105721605116e-18,
1.749756803854403e-18,
3.622425629070179e-19,
6.794954368897788e-20,
1.144348759065692e-20,
1.720770121943172e-21,
2.512707953951398e-22,
// [{0,0.0001},{2.,0.001}]: m=18
0.01047845229856902,
-4.59416391218402e-7,
-5.28901306581073e-7,
-4.05913966414502e-7,
-2.33625114904943e-7,
-1.075535775242931e-7,
-4.12485313695693e-8,
-1.355077293688355e-8,
-3.89012645999696e-9,
-9.9009492065167e-10,
-2.255999198672794e-10,
-4.62292387181067e-11,
-8.49024868867352e-12,
-1.369420767791924e-12,
-1.788482603790157e-13,
-1.290339576780792e-14,
-0.01983032007474201,
8.2031276378457e-7,
9.44384102492347e-7,
7.24786527352393e-7,
4.17157278223949e-7,
1.920496501443045e-7,
7.36569763218827e-8,
2.419931040541464e-8,
6.94816164238739e-9,
1.768961955770194e-9,
4.03325302756493e-10,
8.27559316951453e-11,
1.524035439308561e-11,
2.473669606757094e-12,
3.295561798698881e-13,
2.612220374913714e-14,
0.01881842744115017,
-7.36800858181124e-7,
-8.48242932041111e-7,
-6.5100383928516e-7,
-3.74694204385923e-7,
-1.725035742920358e-7,
-6.61627166848036e-8,
-2.173863177358176e-8,
-6.24250443926373e-9,
-1.589745751807895e-9,
-3.62667306887202e-10,
-7.44994433717965e-11,
-1.375309988731798e-11,
-2.244582314462792e-12,
-3.041606548074108e-13,
-2.592523402112844e-14,
-0.01193639484663513,
4.43600777409476e-7,
5.10696938962661e-7,
3.91947784888628e-7,
2.255926569841155e-7,
1.038610531278789e-7,
3.983650617647074e-8,
1.30896107993935e-8,
3.759298162011594e-9,
9.57597510424224e-10,
2.185653782597088e-10,
4.494408633332991e-11,
8.31485223601482e-12,
1.363628914825018e-12,
1.875169227313226e-13,
1.693559909995233e-14,
0.005691747847269715,
-2.012943647515064e-7,
-2.317412361483823e-7,
-1.778565120363541e-7,
-1.023692451402541e-7,
-4.71306288888154e-8,
-1.807772205864244e-8,
-5.94036496475435e-9,
-1.70624409920765e-9,
-4.347243291471944e-10,
-9.92676573117291e-11,
-2.043146485544269e-11,
-3.787190634343673e-12,
-6.23779164245103e-13,
-8.68841445558422e-14,
-8.22699092511517e-15,
-0.002175893393133547,
7.34008308100331e-8,
8.45032383582347e-8,
6.48546549895605e-8,
3.732876154484838e-8,
1.718631287821033e-8,
6.59225482845953e-9,
2.166332140854014e-9,
6.22295209522995e-10,
1.585829452821144e-10,
3.622653703059295e-11,
7.46242220494871e-12,
1.385636268603879e-12,
2.291064541695549e-13,
3.227354544785034e-14,
3.178785649885851e-15,
0.0006945408459876679,
-2.239540805130027e-8,
-2.578291217988493e-8,
-1.978795872242794e-8,
-1.138953189898604e-8,
-5.24384578741235e-9,
-2.011458132726544e-9,
-6.61030811647063e-10,
-1.899033015692442e-10,
-4.840294047162641e-11,
-1.106120062194609e-11,
-2.280251428472807e-12,
-4.240645851733157e-13,
-7.03601045654788e-14,
-1.001111700279973e-14,
-1.019497367814908e-15,
-0.0001903664858097421,
5.87883543940769e-9,
6.76807016039727e-9,
5.19439529669578e-9,
2.989799828124195e-9,
1.376545663484171e-9,
5.28032509132955e-10,
1.735358841482071e-10,
4.98581365350606e-11,
1.271005730339774e-11,
2.905521151328412e-12,
5.993806274180624e-13,
1.116271177355577e-13,
1.857918216948388e-14,
2.667257822925546e-15,
2.795113932695806e-16,
0.00004573079311841504,
-1.354945905069105e-9,
-1.5598973395884e-9,
-1.197201317451708e-9,
-6.89090639593336e-10,
-3.17269963588194e-10,
-1.217046573293145e-10,
-3.999928682718301e-11,
-1.149296040882283e-11,
-2.930282679633563e-12,
-6.70069241079293e-13,
-1.383155492979482e-13,
-2.57929946380647e-14,
-4.305233730981269e-15,
-6.230512223574346e-16,
-6.693363473896917e-17,
-9.77996225895189e-6,
2.78467629086179e-10,
3.205894663563227e-10,
2.46048860962913e-10,
1.416225490035457e-10,
6.52061836033293e-11,
2.501350553434146e-11,
8.22119035689055e-12,
2.362352056454235e-12,
6.02397294409913e-13,
1.377894405131893e-13,
2.845886180868627e-14,
5.313305853657376e-15,
8.89180190663997e-16,
1.296190023163374e-16,
1.42311309335067e-17,
1.885048228424162e-6,
-5.16585451705164e-11,
-5.94726289866399e-11,
-4.56446746460064e-11,
-2.627259076090114e-11,
-1.209658418189828e-11,
-4.640400705155347e-12,
-1.525209669249651e-12,
-4.382958603597498e-13,
-1.11779410220807e-13,
-2.557454390218627e-14,
-5.284939281435865e-15,
-9.87784655955556e-16,
-1.657000674085892e-16,
-2.431438129651678e-17,
-2.721342910424332e-18,
-3.307387116487756e-7,
8.73568195542089e-12,
1.005708640999874e-11,
7.71873203567911e-12,
4.442836764341042e-12,
2.045612759185265e-12,
7.84734218268908e-13,
2.579345609519386e-13,
7.41264449179692e-14,
1.890686255655575e-14,
4.326833561217356e-15,
8.94571994744235e-16,
1.673693054905883e-16,
2.813770018474627e-17,
4.153735695224197e-18,
4.729146662798839e-19,
5.325161469062367e-8,
-1.357408430975675e-12,
-1.562738395351097e-12,
-1.199391069251646e-12,
-6.90361708323742e-13,
-3.178650249734499e-13,
-1.219404742755021e-13,
-4.008175928886747e-14,
-1.151951921638136e-14,
-2.938520548690822e-15,
-6.72630352413442e-16,
-1.391293981948201e-16,
-2.605462652625154e-17,
-4.389103521055607e-18,
-6.51501315482203e-19,
-7.532259055675029e-20,
-7.924751550002437e-9,
1.951859857971573e-13,
2.247112004082895e-13,
1.724645906566525e-13,
9.92698153880332e-14,
4.570734983790907e-14,
1.75346351064863e-14,
5.763771446307416e-15,
1.656596031985376e-15,
4.226255462704089e-16,
9.67595250355849e-17,
2.002256923137276e-17,
3.752860442496435e-18,
6.333654780685766e-19,
9.44907005761226e-20,
1.109621996208627e-20,
1.113658955146451e-9,
-2.650778741944726e-14,
-3.051756644097557e-14,
-2.342209756729778e-14,
-1.348169158246621e-14,
-6.2074877956446e-15,
-2.381397468665542e-15,
-7.82803139683294e-16,
-2.250006479735164e-16,
-5.740711864524607e-17,
-1.314589397939036e-17,
-2.721395165915645e-18,
-5.10498571347907e-19,
-8.63128650682938e-20,
-1.293781817676422e-20,
-1.535735653900603e-21,
-1.43666325781105e-10,
3.31190317682431e-15,
3.812890669904038e-15,
2.926380821241388e-15,
1.68442100519734e-15,
7.75576328087622e-16,
2.975400147813677e-16,
9.78082982445057e-17,
2.811423356632949e-17,
7.17376437311876e-18,
1.643046552772363e-18,
3.402534395953913e-19,
6.387375008953629e-20,
1.08342343035392e-20,
1.631154352132068e-21,
1.765932076359716e-22,
// [{0,0.0001},{2.,0.001}]: m=19
0.009915160037371,
-4.10156381892285e-7,
-4.72192051246174e-7,
-3.62393263676196e-7,
-2.08578639111975e-7,
-9.60248250721522e-8,
-3.68284881609413e-8,
-1.209965520270732e-8,
-3.47408082119369e-9,
-8.84480977885097e-10,
-2.016626513782463e-10,
-4.13779658475727e-11,
-7.62017719654281e-12,
-1.236834803378547e-12,
-1.647780899349441e-13,
-1.306110187456857e-14,
-0.01881842744115016,
7.36800858181124e-7,
8.4824293204111e-7,
6.5100383928516e-7,
3.74694204385923e-7,
1.725035742920358e-7,
6.61627166848036e-8,
2.173863177358176e-8,
6.24250443926373e-9,
1.589745751807895e-9,
3.62667306887202e-10,
7.44994433717965e-11,
1.375309988731798e-11,
2.244582314462792e-12,
3.041606548074108e-13,
2.592523402112844e-14,
0.01790459226995269,
-6.65401166114214e-7,
-7.66045408443992e-7,
-5.87921677332942e-7,
-3.38388985476173e-7,
-1.557915796918184e-7,
-5.97547592647061e-8,
-1.963441619909025e-8,
-5.63894724301739e-9,
-1.436396265636336e-9,
-3.278480673895632e-10,
-6.74161294999949e-11,
-1.247227835402222e-11,
-2.045443372237526e-12,
-2.812753840969838e-13,
-2.540339864992917e-14,
-0.01138349569454013,
4.02588729503028e-7,
4.63482472296783e-7,
3.55713024072722e-7,
2.047384902805161e-7,
9.42612577776345e-8,
3.615544411728628e-8,
1.188072992950916e-8,
3.412488198415431e-9,
8.69448658294423e-10,
1.985353146234659e-10,
4.086292971088697e-11,
7.57438126868765e-12,
1.247558328490257e-12,
1.737682891116918e-13,
1.645398185023052e-14,
0.005439733482833629,
-1.835020770250777e-7,
-2.112580958955809e-7,
-1.621366374738968e-7,
-9.33219038621183e-8,
-4.29657821955246e-8,
-1.648063707114836e-8,
-5.41583035213488e-9,
-1.555738023807444e-9,
-3.964573632052748e-10,
-9.05663425764798e-11,
-1.865605551237123e-11,
-3.464090671509592e-12,
-5.727661354239065e-13,
-8.06838636196296e-14,
-7.94696412467633e-15,
-0.002083622537929531,
6.71862241531528e-8,
7.73487365387936e-8,
5.93638761666229e-8,
3.416859569657766e-8,
1.573153736206189e-8,
6.03437439811243e-9,
1.983092434919097e-9,
5.69709904701382e-10,
1.452088214132587e-10,
3.318360186546705e-11,
6.84075428534152e-12,
1.272193755505489e-12,
2.110803136939704e-13,
3.003335100803961e-14,
3.058492103416608e-15,
0.0006662827003404689,
-2.057592403806509e-8,
-2.368824556154949e-8,
-1.818038353855729e-8,
-1.046429939850495e-8,
-4.81790982222695e-9,
-1.848113781977756e-9,
-6.07375594522806e-10,
-1.745034778738851e-10,
-4.448520056219139e-11,
-1.016932402971799e-11,
-2.097832195977716e-12,
-3.906949120772338e-13,
-6.5027137592881e-14,
-9.33540238018305e-15,
-9.78289877262691e-16,
-0.0001829231731751443,
5.41978363595258e-9,
6.23958937640109e-9,
4.78880528365823e-9,
2.756362566346216e-9,
1.269079858023831e-9,
4.868186307256263e-10,
1.59997147771705e-10,
4.597184176837487e-11,
1.172113075249535e-11,
2.680276972096708e-12,
5.532621988033914e-13,
1.031719788551991e-13,
1.722093497539191e-14,
2.492204897010017e-15,
2.677345397639386e-16,
0.00004400983008517436,
-1.253104329150785e-9,
-1.442652596603671e-9,
-1.107219872798279e-9,
-6.37301469632505e-10,
-2.93427825808201e-10,
-1.125607747484772e-10,
-3.699535655470502e-11,
-1.063058423929632e-11,
-2.710787821081427e-12,
-6.20052481447419e-13,
-1.280648779575062e-13,
-2.390987630675872e-14,
-4.00131086016187e-15,
-5.832855108319567e-16,
-6.404008066824934e-17,
-9.42523365831357e-6,
2.582925586126225e-10,
2.973629523949329e-10,
2.282232254573646e-10,
1.313628687465284e-10,
6.04828817451153e-11,
2.320198850070422e-11,
7.62604340705558e-12,
2.191477882006786e-12,
5.588966887927052e-13,
1.27872636515311e-13,
2.642467921350898e-14,
4.938920048354197e-15,
8.28499789166637e-16,
1.21571825167205e-16,
1.360670468445208e-17,
1.819063426804297e-6,
-4.80462618725198e-11,
-5.53139880544756e-11,
-4.245303601982e-11,
-2.4435607858347e-11,
-1.125087277909512e-11,
-4.316039199328126e-12,
-1.418640413594058e-12,
-4.076955414407882e-13,
-1.039877681476847e-13,
-2.379759010386025e-14,
-4.920147130186701e-15,
-9.20531401153625e-16,
-1.547573449513376e-16,
-2.284554494760235e-17,
-2.601077450206323e-18,
-3.195521480281917e-7,
8.14539942492411e-12,
9.3775227415999e-12,
7.19718480653083e-12,
4.14265282798481e-12,
1.907412349668874e-12,
7.3172809068635e-13,
2.405185783364985e-13,
6.91251705148073e-14,
1.763317887218904e-14,
4.036252992690747e-15,
8.34873939050517e-16,
1.563460903051434e-16,
2.633772599909062e-17,
3.909471610827147e-18,
4.519953303599638e-19,
5.150926907956328e-8,
-1.268673868017534e-12,
-1.460582462532346e-12,
-1.120988878281823e-12,
-6.45235978828529e-13,
-2.970895682569761e-13,
-1.139719801199407e-13,
-3.746347951418024e-14,
-1.076757671299441e-14,
-2.746990135556867e-15,
-6.289195233428215e-16,
-1.301430538441762e-16,
-2.439289912159938e-17,
-4.116877333887303e-18,
-6.141910017295024e-19,
-7.199512177913384e-20,
-7.673661130066444e-9,
1.828293148386746e-13,
2.104855287534488e-13,
1.615467079520282e-13,
9.29858101652474e-14,
4.28142259164625e-14,
1.642494674866713e-14,
5.399137182977365e-15,
1.551868839434619e-15,
3.959459202098174e-16,
9.06688280509997e-17,
1.876958776527533e-17,
3.520846411806892e-18,
5.952776274550762e-19,
8.92267084243586e-20,
1.057229310200798e-20,
1.07948646642761e-9,
-2.488240172759516e-14,
-2.864633189266712e-14,
-2.198596389831615e-14,
-1.265509241497913e-14,
-5.826922276840393e-15,
-2.23542485546798e-15,
-7.34836007391547e-16,
-2.112229175189508e-16,
-5.389667280288916e-17,
-1.234425347277306e-17,
-2.556382502379422e-18,
-4.799043792573729e-19,
-8.12697133591778e-20,
-1.223482053735841e-20,
-1.470185293716772e-21,
-1.393885384275676e-10,
3.114833815930369e-15,
3.586013208683244e-15,
2.75225671825387e-15,
1.58419952905867e-15,
7.29434066617175e-16,
2.79841042741506e-16,
9.19921581751422e-17,
2.644353666115726e-17,
6.748025697773608e-18,
1.545796648041133e-18,
3.202377462248142e-19,
6.016440712192513e-20,
1.01836401190912e-20,
1.535555202210527e-21,
2.075252819746456e-22,
// [{0,0.0001},{2.,0.001}]: m=20
0.00940921372057508,
-3.68400429090562e-7,
-4.24121466020555e-7,
-3.2550191964258e-7,
-1.87347102192961e-7,
-8.62517871460179e-8,
-3.30813583424018e-8,
-1.086931588679088e-8,
-3.12125221963187e-9,
-7.94872875903947e-10,
-1.81333653443601e-10,
-3.72497216858983e-11,
-6.87654994365899e-12,
-1.122291157231396e-12,
-1.520803274037054e-13,
-1.296261701056422e-14,
-0.01790459226995269,
6.65401166114213e-7,
7.66045408443992e-7,
5.87921677332942e-7,
3.38388985476173e-7,
1.557915796918184e-7,
5.97547592647061e-8,
1.963441619909024e-8,
5.63894724301739e-9,
1.436396265636336e-9,
3.278480673895632e-10,
6.74161294999949e-11,
1.247227835402222e-11,
2.045443372237526e-12,
2.812753840969837e-13,
2.540339864992918e-14,
0.01707524354181019,
-6.03883094254543e-7,
-6.95223708445174e-7,
-5.33569536109083e-7,
-3.071077354207742e-7,
-1.413918866664518e-7,
-5.42331661759294e-8,
-1.782109489426374e-8,
-5.11873229762315e-9,
-1.304172987441634e-9,
-2.978029719351989e-10,
-6.12943945663305e-11,
-1.136157190303147e-11,
-1.871337492735386e-12,
-2.606524336675377e-13,
-2.468097277534603e-14,
-0.01087946696566793,
3.6700415405017e-7,
4.22516191791179e-7,
3.242732749478065e-7,
1.866438077242441e-7,
8.59315643910526e-8,
3.296127414229804e-8,
1.08316607042702e-8,
3.111476047615012e-9,
7.92914726410581e-10,
1.811326851529669e-10,
3.731211102474397e-11,
6.92818134301947e-12,
1.145532270847861e-12,
1.61367727239266e-13,
1.589392824935398e-14,
0.005209056344823594,
-1.67965560382877e-7,
-1.933718413469784e-7,
-1.484096904165528e-7,
-8.54214892414417e-8,
-3.932884340515358e-8,
-1.508593599528063e-8,
-4.9577310872976e-9,
-1.424274761753414e-9,
-3.630220535331361e-10,
-8.29590046636652e-11,
-1.710188571335331e-11,
-3.180484388763629e-12,
-5.277007842349087e-13,
-7.50833775200953e-14,
-7.64623025854294e-15,
-0.001998848100988902,
6.17277721134905e-8,
7.10647366838371e-8,
5.45411506150491e-8,
3.139289819515639e-8,
1.445372946651581e-8,
5.54434134586995e-9,
1.8221267835476e-9,
5.23510433615671e-10,
1.33455601685047e-10,
3.05079720888041e-11,
6.29349658786063e-12,
1.172084736218063e-12,
1.950814127763593e-13,
2.800620714020972e-14,
2.934869631715569e-15,
0.0006402311061191978,
-1.896924272596443e-8,
-2.183856281755393e-8,
-1.676081849291904e-8,
-9.64726898227808e-9,
-4.441779503113945e-9,
-1.703865207551408e-9,
-5.59990017204819e-10,
-1.609014461904193e-10,
-4.102395763401631e-11,
-9.38096940240326e-12,
-1.936417695825204e-12,
-3.611019259956518e-13,
-6.027327241454809e-14,
-8.72271713967387e-15,
-9.37070888910547e-16,
-0.0001760393210218967,
5.01241733137338e-9,
5.77061040341922e-9,
4.42887950424408e-9,
2.549205886042175e-9,
1.173711306691741e-9,
4.50243100320913e-10,
1.479814266550548e-10,
4.252233708258774e-11,
1.084315131632916e-11,
2.48020993312199e-12,
5.122595133497128e-13,
9.56395055127684e-14,
1.600524348867376e-14,
2.33314205055209e-15,
2.561603240182991e-16,
0.00004241355138455349,
-1.16231651211735e-9,
-1.338133283889746e-9,
-1.027004513109522e-9,
-5.91132908525549e-10,
-2.721729674690844e-10,
-1.04408948105873e-10,
-3.431719528332769e-11,
-9.86165045511031e-12,
-2.51503509601406e-12,
-5.754268635043604e-13,
-1.189110562936662e-13,
-2.222514018704258e-14,
-3.728249041413799e-15,
-5.470732111594352e-16,
-6.123017575713776e-17,
-9.09530986662183e-6,
2.402311517872966e-10,
2.765697588606254e-10,
2.122650408658351e-10,
1.221779591488433e-10,
5.62543269940371e-11,
2.158018183958565e-11,
7.09319741402972e-12,
2.038476369356443e-12,
5.1993849931157e-13,
1.189878722948201e-13,
2.460071943911933e-14,
4.602653958027796e-15,
7.73786210287434e-16,
1.1422764690331e-16,
1.300537498066753e-17,
1.757537312480132e-6,
-4.47997073302938e-11,
-5.1576387159328e-11,
-3.958452570771887e-11,
-2.278459589079136e-11,
-1.049077038053048e-11,
-4.024505441534513e-12,
-1.322852490775692e-12,
-3.801885269269537e-13,
-9.69825065389199e-14,
-2.219939667380096e-14,
-4.591807732551531e-15,
-8.59903690542865e-16,
-1.448575607177003e-16,
-2.150210912311619e-17,
-2.485939625372906e-18,
-3.090968465687832e-7,
7.61293721497912e-12,
8.76452401868173e-12,
6.72672321261796e-12,
3.87187056539428e-12,
1.782746770648931e-12,
6.8391220107644e-13,
2.248072813173196e-13,
6.46130505846522e-14,
1.648387790692284e-14,
3.773960948980505e-15,
7.80950297255595e-16,
1.463746839434461e-16,
2.470419174206706e-17,
3.685590507777513e-18,
4.32032077451987e-19,
4.987722676898217e-8,
-1.188357474997792e-12,
-1.368117862695961e-12,
-1.050024379758573e-12,
-6.04390945845581e-13,
-2.782847236217794e-13,
-1.067591825709417e-13,
-3.509341489898303e-14,
-1.008686665428323e-14,
-2.573576804964994e-15,
-5.893309477002324e-16,
-1.21998959096804e-16,
-2.288489538696002e-17,
-3.869081544853856e-18,
-5.79920252414517e-19,
-6.883854404183075e-20,
-7.437980101958228e-9,
1.716090996242862e-13,
1.975681923572351e-13,
1.516329209923381e-13,
8.72797068282431e-14,
4.018714162820786e-14,
1.541728271673685e-14,
5.068015412583559e-15,
1.456760002635556e-15,
3.717131045723501e-16,
8.51350918088173e-17,
1.763052221133934e-17,
3.309678229960723e-18,
5.604637157560817e-19,
8.43610183653494e-20,
1.012781536065235e-20,
1.047347158154767e-9,
-2.340195899314145e-14,
-2.694196197645451e-14,
-2.067789264672775e-14,
-1.190219932835681e-14,
-5.480288083717191e-15,
-2.102464983380119e-15,
-6.91143450196747e-16,
-1.986721445234316e-16,
-5.069841503963692e-17,
-1.161370497855053e-17,
-2.405916786930467e-18,
-4.519740135035686e-19,
-7.666043517608444e-20,
-1.158820694655372e-20,
-1.402220030912598e-21,
-1.35357955927734e-10,
2.934833742494777e-15,
3.378786680194881e-15,
2.593214019098192e-15,
1.492658174186163e-15,
6.87287829297228e-16,
2.636745891375133e-16,
8.66794593709351e-17,
2.491735720999768e-17,
6.359068653686813e-18,
1.45693282769542e-18,
3.019182984567375e-19,
5.674717940071495e-20,
9.63694743467752e-21,
1.4717598237721e-21,
1.823237592170172e-22,
// [{0,0.0001},{2.,0.001}]: m=21
0.00895229613497635,
-3.32700583057107e-7,
-3.83022704221996e-7,
-2.93960838666471e-7,
-1.691944927380866e-7,
-7.78957898459092e-8,
-2.98773796323531e-8,
-9.81720809954512e-9,
-2.8194736215087e-9,
-7.18198132818168e-10,
-1.639240336947816e-10,
-3.37080647499974e-11,
-6.23613917701111e-12,
-1.022721686118763e-12,
-1.406376920484919e-13,
-1.270169932496459e-14,
-0.01707524354181019,
6.03883094254542e-7,
6.95223708445174e-7,
5.33569536109083e-7,
3.07107735420774e-7,
1.413918866664517e-7,
5.42331661759294e-8,
1.782109489426373e-8,
5.11873229762315e-9,
1.304172987441634e-9,
2.978029719351989e-10,
6.12943945663305e-11,
1.136157190303147e-11,
1.871337492735386e-12,
2.606524336675377e-13,
2.4680972775346e-14,
0.0163192004485019,
-5.50506231075255e-7,
-6.33774287686768e-7,
-4.8640991242171e-7,
-2.799657115863661e-7,
-1.28897346586579e-7,
-4.94419112134471e-8,
-1.62474910564053e-8,
-4.66721407142252e-9,
-1.189372089615872e-9,
-2.716990277294504e-10,
-5.5968166537116e-11,
-1.03922720145292e-11,
-1.718298406271791e-12,
-2.420515908588991e-13,
-2.384089237403129e-14,
-0.01041811268964785,
3.35931120765768e-7,
3.86743682693973e-7,
2.968193808331179e-7,
1.708429784828904e-7,
7.86576868103104e-8,
3.01718719905625e-8,
9.91546217459561e-9,
2.848549523506945e-9,
7.26044107066302e-10,
1.659180093273373e-10,
3.420377142670804e-11,
6.36096877752753e-12,
1.055401568469862e-12,
1.501667550401977e-13,
1.529246051708785e-14,
0.004997120252472029,
-1.543194302837215e-7,
-1.776618417095873e-7,
-1.363528765376187e-7,
-7.84822454878886e-8,
-3.613432366628843e-8,
-1.386085336467445e-8,
-4.555316958868865e-9,
-1.308776084039139e-9,
-3.336390042126076e-10,
-7.62699302220079e-11,
-1.573374146965109e-11,
-2.930211840545067e-12,
-4.877035319408967e-13,
-7.0015517850522e-14,
-7.33717407927507e-15,
-0.001920693318326002,
5.69077281772281e-8,
6.55156884518959e-8,
5.02824554781693e-8,
2.89418069464959e-8,
1.332533850918605e-8,
5.11159562259446e-9,
1.679970051594809e-9,
4.827043385656096e-10,
1.230718729006074e-10,
2.814290820687944e-11,
5.80925308740713e-12,
1.083305777974086e-12,
1.808198172414573e-13,
2.616815141867625e-14,
2.811212666688119e-15,
0.0006161376235826619,
-1.75434606599301e-8,
-2.01971364121092e-8,
-1.550107826496319e-8,
-8.92222060121031e-9,
-4.107989573449964e-9,
-1.575850851134271e-9,
-5.17934993296333e-10,
-1.488281797901039e-10,
-3.795102960741923e-11,
-8.68073476598818e-12,
-1.792908296736782e-12,
-3.347382692971447e-13,
-5.601835221054797e-14,
-8.1659971769234e-15,
-8.96561134279056e-16,
-0.0001696542062002678,
4.64926606240999e-9,
5.35253315160838e-9,
4.10801806475599e-9,
2.364531641192418e-9,
1.088691873141014e-9,
4.176357936759806e-10,
1.372687815450571e-10,
3.944660193880847e-11,
1.006014041426657e-11,
2.301707460940048e-12,
4.756442266096028e-13,
8.89005610178927e-14,
1.491299621167792e-14,
2.188292851839073e-15,
2.449207037510636e-16,
0.00004092889432406916,
-1.081040181492963e-9,
-1.244563913088492e-9,
-9.5519268252679e-10,
-5.49800815381523e-10,
-2.531444711102073e-10,
-9.71108181388854e-11,
-3.191938831735549e-11,
-9.17314364894331e-12,
-2.339723243543056e-12,
-5.354454245573128e-13,
-1.107032373157654e-13,
-2.071194277972054e-14,
-3.482037942617026e-15,
-5.140244118064537e-16,
-5.852418604290213e-17,
-8.78767949925303e-6,
2.239983879271228e-10,
2.578817645746307e-10,
1.979224971257922e-10,
1.139229038123617e-10,
5.24538170736554e-11,
2.012251384557636e-11,
6.61425806118884e-12,
1.900941371841322e-12,
4.849122103976595e-13,
1.109969095157573e-13,
2.295902335403745e-14,
4.299515574761706e-15,
7.24287313086236e-16,
1.075104692555782e-16,
1.242968982519591e-17,
1.700033140829842e-6,
-4.18711646022506e-11,
-4.8204893523208e-11,
-3.699698643460413e-11,
-2.129529315495746e-11,
-9.80510956167078e-12,
-3.761517997182826e-12,
-1.236440340246298e-12,
-3.55371862449947e-13,
-9.06613499877009e-14,
-2.075679014284094e-14,
-4.295227658385673e-15,
-8.05060965382599e-16,
-1.358730840630454e-16,
-2.027073990963791e-17,
-2.376179066513054e-18,
-2.993034338764959e-7,
7.13098864114254e-12,
8.20967860836216e-12,
6.30089185224491e-12,
3.626774829482849e-12,
1.669905944883343e-12,
6.40630905600161e-13,
2.105854114243803e-13,
6.05283644149792e-14,
1.544328938876811e-14,
3.536404693485541e-15,
7.3208061152937e-16,
1.373257030378186e-16,
2.321726550825267e-17,
3.479951969494172e-18,
4.130855182455352e-19,
4.834534302360917e-8,
-1.115427883112563e-12,
-1.284157256457066e-12,
-9.85586361147764e-13,
-5.67302193143808e-13,
-2.612090988626073e-13,
-1.002095286666258e-13,
-3.294117673037863e-14,
-9.46867453525952e-15,
-2.416067418235461e-15,
-5.533625818362612e-16,
-1.145951740764169e-16,
-2.151225969088906e-17,
-3.642907529941631e-18,
-5.483794046191707e-19,
-6.583653379423865e-20,
-7.216333263297663e-9,
1.613902261137619e-13,
1.858036440101177e-13,
1.426038560494067e-13,
8.2082803493709e-14,
3.779447254708266e-14,
1.449951740258147e-14,
4.766424574953803e-15,
1.370127590295691e-15,
3.496370283955861e-16,
8.00924897077577e-17,
1.659194365973461e-17,
3.116906286161121e-18,
5.286708459212875e-19,
7.9889382138331e-20,
9.63715500227562e-21,
1.017064940796394e-9,
-2.204973432613832e-14,
-2.538520247658212e-14,
-1.948310722977569e-14,
-1.121450804981066e-14,
-5.163670522705708e-15,
-1.981016813940938e-15,
-6.512325580613215e-16,
-1.872069428634413e-16,
-4.777641887821303e-17,
-1.094609013880331e-17,
-2.268345969437812e-18,
-4.264092572726877e-19,
-7.242065865769614e-20,
-1.098988048407311e-20,
-1.347829504520532e-21,
-1.315537656368279e-10,
2.769988216115907e-15,
3.189006771677606e-15,
2.447561025570869e-15,
1.408823321555068e-15,
6.48689432819541e-16,
2.488687989623537e-16,
8.18137660439921e-17,
2.351950752105613e-17,
6.002769309911081e-18,
1.375506138758841e-18,
2.851526877124998e-19,
5.362824755195999e-20,
9.06413326330079e-21,
1.393831515772799e-21,
2.29687797340613e-22,
// [{0,0.0001},{2.,0.001}]: m=22
0.00853762177090509,
-3.01941547127271e-7,
-3.47611854222587e-7,
-2.66784768054541e-7,
-1.535538677103871e-7,
-7.06959433332259e-8,
-2.71165830879647e-8,
-8.91054744713187e-9,
-2.55936614881157e-9,
-6.52086493720817e-10,
-1.489014859675995e-10,
-3.06471972831652e-11,
-5.68078595151573e-12,
-9.35668746367693e-13,
-1.303262168337688e-13,
-1.2340486387673e-14,
-0.0163192004485019,
5.50506231075255e-7,
6.33774287686768e-7,
4.8640991242171e-7,
2.79965711586366e-7,
1.28897346586579e-7,
4.94419112134471e-8,
1.624749105640529e-8,
4.66721407142252e-9,
1.189372089615872e-9,
2.716990277294503e-10,
5.5968166537116e-11,
1.03922720145292e-11,
1.718298406271791e-12,
2.420515908588991e-13,
2.38408923740313e-14,
0.01562716903447177,
-5.03896681148652e-7,
-5.80115524040959e-7,
-4.45229071249677e-7,
-2.562644677243356e-7,
-1.179865302154656e-7,
-4.52578079858438e-8,
-1.487319326189341e-8,
-4.27282428526042e-9,
-1.089066160599453e-9,
-2.488770139910059e-10,
-5.13056571400621e-11,
-9.54145316629129e-12,
-1.583102352704794e-12,
-2.252501325602966e-13,
-2.293869077563061e-14,
-0.0099942405049447,
3.08638860567456e-7,
3.5532368341919e-7,
2.72705753075249e-7,
1.569644909757839e-7,
7.22686473325799e-8,
2.772170672935008e-8,
9.11063391773812e-9,
2.61755216807839e-9,
6.67278008425244e-10,
1.525398604440224e-10,
3.146748293930353e-11,
5.86042368109039e-12,
9.75407063881837e-13,
1.400310357010517e-13,
1.467434815855005e-14,
0.004801733295814785,
-1.422693204430658e-7,
-1.637892211297348e-7,
-1.257061386954195e-7,
-7.23545173662375e-8,
-3.33133462729641e-8,
-1.277898905648575e-8,
-4.199925128986894e-9,
-1.206760846413987e-9,
-3.076796822515089e-10,
-7.03572705171964e-11,
-1.452313271851741e-11,
-2.708264444935128e-12,
-4.520495431035626e-13,
-6.54203785466919e-14,
-7.02803166678698e-15,
-0.001848412870717258,
5.26303819791614e-8,
6.05914092356036e-8,
4.65032347943339e-8,
2.676666180331109e-8,
1.232396872020262e-8,
4.727552553346313e-9,
1.553804979870424e-9,
4.464845393649716e-10,
1.138530888208947e-10,
2.604220429765215e-11,
5.378724890145577e-12,
1.004214807879274e-12,
1.680550566295581e-13,
2.449799153042126e-14,
2.689683402819713e-15,
0.0005937897217068004,
-1.62724312185517e-8,
-1.873386603076372e-8,
-1.437806322674911e-8,
-8.27586074423283e-9,
-3.810421556020884e-9,
-1.461725277876419e-9,
-4.804407354111473e-10,
-1.380631067868208e-10,
-3.521049145018611e-11,
-8.05597611334813e-12,
-1.664754793145021e-12,
-3.111519635649759e-13,
-5.219548674281799e-14,
-7.65902498139893e-15,
-8.57222461555699e-16,
-0.0001637155779402311,
4.32416073915075e-9,
4.97825566752645e-9,
3.820770741752048e-9,
2.199203268228939e-9,
1.012577887527153e-9,
3.884432737396155e-10,
1.276775536586843e-10,
3.669257470768075e-11,
9.35889300273582e-12,
2.141781704775546e-12,
4.428129506204872e-13,
8.28477713739102e-14,
1.392815181394748e-14,
2.056097654319241e-15,
2.340967448575112e-16,
0.00003954455767292489,
-1.007992744204619e-9,
-1.160467938896422e-9,
-8.90651235769436e-10,
-5.12653066409281e-10,
-2.360421764877928e-10,
-9.05513121732481e-11,
-2.976416123200525e-11,
-8.55423616082448e-12,
-2.182104943607105e-12,
-4.994860920922141e-13,
-1.033156049492033e-13,
-1.934782005680037e-14,
-3.259292885694078e-15,
-4.837971122039197e-16,
-5.593362272240742e-17,
-8.50015883409361e-6,
2.093556824129588e-10,
2.410243057492302e-10,
1.849848079401942e-10,
1.064763942658521e-10,
4.902551488208753e-11,
1.880757735368811e-11,
6.18219754840898e-12,
1.77685811837092e-12,
4.53306445209402e-13,
1.03783880876011e-13,
2.147612381010615e-14,
4.025302104593978e-15,
6.79364957708047e-16,
1.013536255462821e-16,
1.18808861047633e-17,
1.646169358123345e-6,
-3.92204469185177e-11,
-4.51532431590085e-11,
-3.465491348634911e-11,
-1.994726633910582e-11,
-9.18448489641262e-12,
-3.523470824670998e-12,
-1.158220040258521e-12,
-3.329060840414042e-13,
-8.49381120064121e-14,
-1.945023047798745e-14,
-4.026444286562024e-15,
-7.55291556794863e-16,
-1.276951045280784e-16,
-1.91397317365906e-17,
-2.271856053470347e-18,
-2.901110358914854e-7,
6.69336498681355e-12,
7.70586189436554e-12,
5.91422300511071e-12,
3.404218866697158e-12,
1.567441401218472e-12,
6.01328841268174e-13,
1.976706215306463e-13,
5.681882071518565e-14,
1.449813339851651e-14,
3.320571717240961e-15,
6.87653206793839e-16,
1.290890102737394e-16,
2.186006840323789e-17,
3.290689041516961e-18,
3.950756301160782e-19,
4.690467922584168e-8,
-1.049006868226419e-12,
-1.207689606669869e-12,
-9.26898908347507e-13,
-5.33523167190286e-13,
-2.456571392186446e-13,
-9.42442034904598e-14,
-3.098088537825898e-14,
-8.90557796026728e-15,
-2.272576490764047e-15,
-5.205864846002448e-16,
-1.078447213283569e-16,
-2.025929032103269e-17,
-3.435913042853285e-18,
-5.192956313957349e-19,
-6.299488980267932e-20,
-7.007504209633767e-9,
1.520570669701839e-13,
1.750587699154688e-13,
1.343573553987969e-13,
7.73363059854264e-14,
3.5609154500533e-14,
1.366127340721198e-14,
4.490956950995659e-15,
1.290994136758436e-15,
3.294693157938824e-16,
7.54846194139681e-17,
1.56424457942868e-17,
2.940467647071973e-18,
4.99402168889467e-19,
7.576077054787629e-20,
9.27529647419157e-21,
9.88483475975525e-10,
-2.081134609443614e-14,
-2.395949678026103e-14,
-1.838890128705929e-14,
-1.05847057179141e-14,
-4.873703285117821e-15,
-1.869789543968782e-15,
-6.146794338814853e-16,
-1.767057087828357e-16,
-4.509978113007272e-17,
-1.033438689120276e-17,
-2.14223193898961e-18,
-4.029527012304412e-19,
-6.852706249863636e-20,
-1.043366657007357e-20,
-1.292005622135642e-21,
-1.279574260862426e-10,
2.618643499534349e-15,
3.014769642774429e-15,
2.313836632057196e-15,
1.331854059082534e-15,
6.13251777591397e-16,
2.352752360095979e-16,
7.73463280012539e-17,
2.223600046048645e-17,
5.675586688904183e-18,
1.300714573530143e-18,
2.697051789674421e-19,
5.076087709076691e-20,
8.63996483931613e-21,
1.31949085255516e-21,
1.679548966585212e-22,
// [{0,0.0001},{2.,0.001}]: m=23
0.00815960022425095,
-2.75253115537628e-7,
-3.16887143843384e-7,
-2.43204956210855e-7,
-1.399828557931831e-7,
-6.44486732932895e-8,
-2.47209556067235e-8,
-8.12374552820265e-9,
-2.33360703571126e-9,
-5.94686044807936e-10,
-1.358495138647252e-10,
-2.7984083268558e-11,
-5.1961360072646e-12,
-8.59149203135895e-13,
-1.210257954294495e-13,
-1.192044618701565e-14,
-0.01562716903447177,
5.03896681148652e-7,
5.80115524040959e-7,
4.45229071249677e-7,
2.562644677243356e-7,
1.179865302154656e-7,
4.52578079858437e-8,
1.487319326189341e-8,
4.27282428526042e-9,
1.089066160599453e-9,
2.488770139910059e-10,
5.13056571400621e-11,
9.54145316629129e-12,
1.583102352704794e-12,
2.252501325602966e-13,
2.29386907756306e-14,
0.01499136075741705,
-4.62958290851184e-7,
-5.32985525128785e-7,
-4.09058629612873e-7,
-2.354467364636759e-7,
-1.084029709988699e-7,
-4.15825600940251e-8,
-1.366595087660718e-8,
-3.926328252117585e-9,
-1.000917012637865e-9,
-2.288097906660336e-10,
-4.72012244089553e-11,
-8.79063552163558e-12,
-1.463110595822756e-12,
-2.100465535515777e-13,
-2.201152223782487e-14,
-0.00960346659163019,
2.84538640886144e-7,
3.27578442259484e-7,
2.514122773908499e-7,
1.447090347324813e-7,
6.66266925459311e-8,
2.555797811297261e-8,
8.39985025797415e-9,
2.413521692828079e-9,
6.15359364503045e-10,
1.40714541034399e-10,
2.90462654370361e-11,
5.4165288898705e-12,
9.04099086207164e-13,
1.308407570933901e-13,
1.405606333357714e-14,
0.004621032176792931,
-1.315759549478994e-7,
-1.514785230890043e-7,
-1.162580869858311e-7,
-6.69166545082756e-8,
-3.080992180050558e-8,
-1.181888138336541e-8,
-3.884512449675938e-9,
-1.116211348412394e-9,
-2.846327220522278e-10,
-6.51055107441283e-11,
-1.344681222536352e-11,
-2.510537019698108e-12,
-4.201376415738719e-13,
-6.124497882604664e-14,
-6.7242085070587e-15,
-0.001781369165090491,
4.88172936550597e-8,
5.62015980916057e-8,
4.31341896797212e-8,
2.482758223239564e-8,
1.143126466792321e-8,
4.38517583357576e-9,
1.441322206215855e-9,
4.141893203554062e-10,
1.056314743492677e-10,
2.416792833974856e-11,
4.994264379373681e-12,
9.33455890683379e-13,
1.565864602265547e-13,
2.297707494388879e-14,
2.571667384550542e-15,
0.00057300452279652,
-1.513456258713829e-8,
-1.742389483647e-8,
-1.337269759622996e-8,
-7.69721143885758e-9,
-3.544022606370953e-9,
-1.359551458098598e-9,
-4.46871437808664e-10,
-1.284240114778225e-10,
-3.275612550981529e-11,
-7.49623596676942e-12,
-1.54984532718305e-12,
-2.899671998107811e-13,
-4.874853134935301e-14,
-7.19634179024767e-15,
-8.1933860683598e-16,
-0.0001581782313185174,
4.0319709892964e-9,
4.64187176995118e-9,
3.562604954103276e-9,
2.05061227198348e-9,
9.4416870887336e-10,
3.62205249814105e-10,
1.190566452965909e-10,
3.421694474926013e-11,
8.72841980147629e-12,
1.997944374568485e-12,
4.132624210829375e-13,
7.7391280469224e-14,
1.303717158320239e-14,
1.935188455264182e-15,
2.237344926379818e-16,
0.00003825071468161841,
-9.42100569466914e-10,
-1.084609374269655e-9,
-8.32431634501427e-10,
-4.79143773488657e-10,
-2.206148166435414e-10,
-8.46340979665806e-11,
-2.781988892674035e-11,
-7.99586152085268e-12,
-2.039879000425739e-12,
-4.670274632504684e-13,
-9.66425570026202e-14,
-1.811385944407391e-14,
-3.05714230350746e-15,
-4.560913136190126e-16,
-5.346398896761662e-17,
-8.23084010338296e-6,
1.961021014724546e-10,
2.25766062537547e-10,
1.732744498064499e-10,
9.97362639897775e-11,
4.592239330684357e-11,
1.761734216282341e-11,
5.79109626922396e-12,
1.664529289754542e-12,
4.246902714729728e-13,
9.72510862496201e-14,
2.013220771353853e-14,
3.776455201719846e-15,
6.384750865527935e-16,
9.56985901412953e-17,
1.135926693260566e-17,
1.595611156975216e-6,
-3.68135163330592e-11,
-4.23822506717666e-11,
-3.252823439711802e-11,
-1.872320829628704e-11,
-8.62092979230327e-12,
-3.307309427132841e-12,
-1.087188681477413e-12,
-3.12503589564172e-13,
-7.97397529991066e-14,
-1.826314887089371e-14,
-3.78209355246866e-15,
-7.09989727837126e-16,
-1.202304137622725e-16,
-1.809879701587369e-17,
-2.172908454514505e-18,
-2.814660158599689e-7,
6.29479647025832e-12,
7.24700715081731e-12,
5.56206080057472e-12,
3.201523133666372e-12,
1.474119708814523e-12,
5.65533079362095e-13,
1.859076209739016e-13,
5.343988141639154e-14,
1.363709609392371e-14,
3.123894156034171e-15,
6.47146158480626e-16,
1.215703939510726e-16,
2.061797022149798e-17,
3.116161041041464e-18,
3.780251900413407e-19,
4.554732892413733e-8,
-9.88342867561163e-13,
-1.137849690823294e-12,
-8.73298009323873e-13,
-5.02671713422246e-13,
-2.314529310594451e-13,
-8.87957552880481e-14,
-2.919039109844391e-14,
-8.39122352353577e-15,
-2.141489702121197e-15,
-4.906360774505113e-16,
-1.016730122487113e-16,
-1.911249699292824e-17,
-3.245999394608413e-18,
-4.924252595723728e-19,
-6.030927160486944e-20,
-6.810413071200431e-9,
1.435102056451492e-13,
1.652191184439863e-13,
1.268055832280938e-13,
7.29896623748639e-14,
3.360791707048164e-14,
1.289362774914388e-14,
4.238682256364213e-15,
1.218519029701194e-15,
3.109963398045912e-16,
7.12629426268132e-17,
1.477209337112835e-17,
2.778582259319187e-18,
4.725020475741927e-19,
7.192767340336016e-20,
8.91771600036137e-21,
9.61463484342746e-10,
-1.967437291485252e-14,
-2.265054495528536e-14,
-1.738430031049172e-14,
-1.000647615915433e-14,
-4.607478827045744e-15,
-1.767668253672415e-15,
-5.811179216250092e-16,
-1.670633912927503e-16,
-4.264179682724991e-17,
-9.77252683891029e-18,
-2.02634119432471e-18,
-3.813775966661031e-19,
-6.493815701240064e-20,
-9.916934349869e-21,
-1.238264765995424e-21,
-1.245523655787467e-10,
2.479365320781275e-15,
2.854424106758828e-15,
2.19077362855979e-15,
1.26102106325415e-15,
5.806391276995403e-16,
2.22765156701746e-16,
7.32348630426793e-17,
2.105470325307713e-17,
5.374425408825287e-18,
1.231860071547985e-18,
2.554848119181385e-19,
4.810781223731397e-20,
8.23164924392807e-21,
1.262348067191068e-21,
1.245775697090673e-22,
// [{0,0.0001},{2.,0.001}]: m=24
0.00781358451723588,
-2.51948340574326e-7,
-2.9005776202048e-7,
-2.22614535624838e-7,
-1.281322338621678e-7,
-5.89932651077328e-8,
-2.26289039929219e-8,
-7.43659663094671e-9,
-2.13641214263021e-9,
-5.44533080299727e-10,
-1.24438506995503e-10,
-2.5652828570031e-11,
-4.77072658314564e-12,
-7.91551176352397e-13,
-1.126250662801483e-13,
-1.14693453878153e-14,
-0.01499136075741705,
4.62958290851184e-7,
5.32985525128785e-7,
4.09058629612873e-7,
2.354467364636759e-7,
1.084029709988699e-7,
4.15825600940251e-8,
1.366595087660717e-8,
3.92632825211758e-9,
1.000917012637865e-9,
2.288097906660336e-10,
4.72012244089553e-11,
8.79063552163558e-12,
1.463110595822756e-12,
2.100465535515776e-13,
2.201152223782484e-14,
0.01440519988744529,
-4.26807961329216e-7,
-4.91367663389226e-7,
-3.77118416086275e-7,
-2.170635520987221e-7,
-9.99400388188967e-8,
-3.83369671694589e-8,
-1.259977538696123e-8,
-3.620282539242119e-9,
-9.23039046754567e-10,
-2.110718115515986e-10,
-4.356939815555416e-11,
-8.12479333480575e-12,
-1.356148629310746e-12,
-1.962611356400851e-13,
-2.108409500036611e-14,
-0.00924206435358647,
2.63151909895811e-7,
3.02957046178022e-7,
2.325161739716726e-7,
1.338333090165572e-7,
6.16198436010139e-8,
2.363776276673187e-8,
7.76902489935222e-9,
2.232422696824887e-9,
5.69265444104481e-10,
1.302110214882625e-10,
2.689362445072825e-11,
5.021074039396445e-12,
8.40275283147781e-13,
1.224899576520987e-13,
1.344841701412012e-14,
0.004453422912726019,
-1.220432341376453e-7,
-1.405039952290097e-7,
-1.078354741992996e-7,
-6.20689555809871e-8,
-2.857816166980711e-8,
-1.096293958393905e-8,
-3.60330551553952e-9,
-1.035473300888482e-9,
-2.640786858731607e-10,
-6.04198208493694e-11,
-1.248566094843379e-11,
-2.333639726708367e-12,
-3.914661505663985e-13,
-5.744268735972592e-14,
-6.42916846134924e-15,
-0.001719013568360425,
4.54036877608503e-8,
5.227168450876e-8,
4.0118092788191e-8,
2.309163431628558e-8,
1.063206781898064e-8,
4.078654374245067e-9,
1.340614313409315e-9,
3.852720344286728e-10,
9.82683765282219e-11,
2.24887079000277e-11,
4.64953598149093e-12,
8.69901599421359e-13,
1.462455940462312e-13,
2.158902537047527e-14,
2.458015820418452e-15,
0.0005536238096203776,
-1.411189846264249e-8,
-1.624655119495011e-8,
-1.246911733945432e-8,
-7.17714295199562e-9,
-3.30459048108137e-9,
-1.267718374358809e-9,
-4.166982585411721e-10,
-1.197593066233029e-10,
-3.054946930539481e-11,
-6.99280531104189e-12,
-1.446418473801353e-12,
-2.708694816444443e-13,
-4.563010054092033e-14,
-6.773159593345522e-15,
-7.83070724936717e-16,
-0.0001530028593370427,
3.76840228969907e-9,
4.3384375106998e-9,
3.329726548459987e-9,
1.916575099972177e-9,
8.82459269344967e-10,
3.385363929293624e-10,
1.112795560564452e-10,
3.198344618388893e-11,
8.15951602735258e-12,
1.868109858881624e-12,
3.865702292304901e-13,
7.24554380063766e-14,
1.222856925267624e-14,
1.824365260203007e-15,
2.138559573254507e-16,
0.00003703878039523487,
-8.82459455304922e-10,
-1.015947279897987e-9,
-7.79735022961673e-10,
-4.488131872820623e-10,
-2.066507695713996e-10,
-7.9278039614002e-11,
-2.605993317248245e-11,
-7.49038179267508e-12,
-1.911106218764476e-12,
-4.376298874670392e-13,
-9.05949345717415e-14,
-1.69940483806813e-14,
-2.873137893144142e-15,
-4.306436565226587e-16,
-5.111669222883267e-17,
-7.97804927099165e-6,
1.840674554424852e-10,
2.119111080419628e-10,
1.626410604546252e-10,
9.36159772834886e-11,
4.310461940135656e-11,
1.653653579467056e-11,
5.435939678935911e-12,
1.562516875874045e-12,
3.986984913535674e-13,
9.13156816263121e-14,
1.891045474740218e-14,
3.549946185528907e-15,
6.011516543224985e-16,
9.0493922883469e-17,
1.086452944855385e-17,
1.548063535189044e-6,
-3.46213890422039e-11,
-3.98585490644116e-11,
-3.059134187473407e-11,
-1.760838153585886e-11,
-8.10766037875601e-12,
-3.110432696245975e-12,
-1.022492165136425e-12,
-2.939194196055085e-13,
-7.50040468467909e-14,
-1.718142205851519e-14,
-3.559304762916091e-15,
-6.68637339871655e-16,
-1.133988111616349e-16,
-1.713888006544646e-17,
-2.079198131021309e-18,
-2.73320930546994e-7,
5.93077333437641e-12,
6.82792260468388e-12,
5.24042083031278e-12,
3.016394509563633e-12,
1.388885296835105e-12,
5.328388752057563e-13,
1.751635000734236e-13,
5.035342286437888e-14,
1.285049072929444e-14,
2.94417235643344e-15,
6.101119114844201e-16,
1.146888980677641e-16,
1.947835662544428e-17,
2.954910028605099e-18,
3.619178394912323e-19,
4.426627312450749e-8,
-9.32789686584373e-13,
-1.073893588330065e-12,
-8.24212742810497e-13,
-4.744192509312032e-13,
-2.184452197178271e-13,
-8.3806185849782e-14,
-2.755064743432037e-14,
-7.92014735241443e-15,
-2.021418437718991e-15,
-4.631958891556777e-16,
-9.60157954692911e-17,
-1.806023820457132e-17,
-3.071349953621556e-18,
-4.675486640702569e-19,
-5.776805231356291e-20,
-6.62409789084601e-9,
1.356637850895558e-13,
1.561858479515908e-13,
1.198726833496403e-13,
6.89992150541002e-14,
3.17706632198645e-14,
1.21888740713363e-14,
4.007069611975211e-15,
1.151976157488752e-15,
2.940335263540929e-16,
6.73855116131812e-17,
1.397232094484932e-17,
2.629686521687217e-18,
4.477693347878254e-19,
6.837434891666423e-20,
8.51181996345151e-21,
9.35880481863097e-10,
-1.862804170729717e-14,
-2.144594463494315e-14,
-1.64597860529948e-14,
-9.47434129054736e-15,
-4.362475374714611e-15,
-1.673685926166866e-15,
-5.502304230938863e-16,
-1.581888617457078e-16,
-4.037929638711197e-17,
-9.25524367063569e-18,
-1.919600125662206e-18,
-3.614827221814182e-19,
-6.161976572120577e-20,
-9.44275916136876e-21,
-1.18980292778427e-21,
-1.213237275171144e-10,
2.350904844640324e-15,
2.706532456466596e-15,
2.077268637682938e-15,
1.195689298286808e-15,
5.505591482200303e-16,
2.112264577027517e-16,
6.944255154492e-17,
1.996505049037265e-17,
5.096595955287362e-18,
1.168328632803861e-18,
2.423827787062979e-19,
4.565667945037062e-20,
7.786906871958849e-21,
1.208669707685264e-21,
1.578113808871961e-22,
// [{0,0.0001},{2.,0.001}]: m=25
0.00749568037870852,
-2.31479145425592e-7,
-2.66492762564392e-7,
-2.04529314806437e-7,
-1.177233682318379e-7,
-5.42014854994349e-8,
-2.07912800470126e-8,
-6.83297543830359e-9,
-1.963164126058792e-9,
-5.00458506318933e-10,
-1.144048953330168e-10,
-2.36006122044776e-11,
-4.39531776081779e-12,
-7.31555297911378e-13,
-1.050232767757888e-13,
-1.100576111891242e-14,
-0.01440519988744529,
4.26807961329216e-7,
4.91367663389226e-7,
3.77118416086275e-7,
2.17063552098722e-7,
9.99400388188967e-8,
3.83369671694589e-8,
1.259977538696123e-8,
3.62028253924212e-9,
9.23039046754567e-10,
2.110718115515985e-10,
4.35693981555542e-11,
8.12479333480574e-12,
1.356148629310746e-12,
1.96261135640085e-13,
2.108409500036611e-14,
0.01386309653037971,
-3.94727864843716e-7,
-4.54435569267033e-7,
-3.48774260957509e-7,
-2.007499635248358e-7,
-9.24297654015209e-8,
-3.545664415009782e-8,
-1.165353734902834e-8,
-3.348634045237332e-9,
-8.53898166156722e-10,
-1.953165322323937e-10,
-4.034043667609238e-11,
-7.53161105909467e-12,
-1.260412924721672e-12,
-1.83734936478148e-13,
-2.017262552117973e-14,
-0.00890684582545263,
2.44086468275302e-7,
2.81007990458032e-7,
2.15670948398609e-7,
1.241379111619799e-7,
5.71563233396168e-8,
2.192587916787909e-8,
7.20661103107937e-9,
2.070946601777059e-9,
5.28157371746346e-10,
1.208396416987444e-10,
2.497132189686872e-11,
4.66727945341695e-12,
7.82932301132834e-13,
1.148853747194577e-13,
1.285833692269921e-14,
0.00429753392090086,
-1.13509219402122e-7,
-1.306792112718958e-7,
-1.002952319704742e-7,
-5.77290857907121e-8,
-2.658016954745073e-8,
-1.019663593561233e-8,
-3.351535783523178e-9,
-9.6318008607165e-10,
-2.456709413205467e-10,
-5.62217697500674e-11,
-1.162383995372695e-11,
-2.174753998553318e-12,
-3.656139851155455e-13,
-5.397256342619487e-14,
-6.14503955106731e-15,
-0.001660871428832734,
4.23356953873914e-8,
4.87396535842332e-8,
3.74073520178893e-8,
2.153142885571423e-8,
9.91377144311857e-9,
3.803155123028263e-9,
1.250094775607682e-9,
3.59277919865356e-10,
9.16484079150222e-11,
2.097841593285921e-11,
4.339255421348752e-12,
8.12608444922923e-13,
1.36890301621005e-13,
2.031947877974916e-14,
2.349212174759709e-15,
0.0005355100076850789,
-1.318940801404663e-8,
-1.51845312875643e-8,
-1.165404291969823e-8,
-6.70801284995343e-9,
-3.08860744273078e-9,
-1.184877375261745e-9,
-3.894784462005094e-10,
-1.119420616444598e-10,
-2.855830609595071e-11,
-6.53838450613528e-12,
-1.352995802316873e-12,
-2.535940330244713e-13,
-4.279999238508436e-14,
-6.385278410525948e-15,
-7.48495850241086e-16,
-0.0001481551221760804,
3.52983783245353e-9,
4.06378913252517e-9,
3.118940101772969e-9,
1.795252754841889e-9,
8.26603080916473e-10,
3.171121594653716e-10,
1.042397330217718e-10,
2.996152726610918e-11,
7.64442489941486e-12,
1.750519555452427e-12,
3.623797394460581e-13,
6.7976193740906e-14,
1.149255160920959e-14,
1.722574632109341e-15,
2.044667702036745e-16,
0.00003590122165119892,
-8.28303548235146e-10,
-9.5359998474279e-10,
-7.31884770935971e-10,
-4.21271897136864e-10,
-1.939707870119488e-10,
-7.44144109631607e-11,
-2.446172851810792e-11,
-7.03132593076492e-12,
-1.794143208367083e-12,
-4.109205666948791e-13,
-8.50970462352568e-14,
-1.597475780770143e-14,
-2.705182436429193e-15,
-4.072226554183178e-16,
-4.889038639434378e-17,
-7.74031132665482e-6,
1.731068253632988e-10,
1.992926073445912e-10,
1.529566034756137e-10,
8.80418467235744e-11,
4.053827382641137e-11,
1.555215271287847e-11,
5.112457285440015e-12,
1.469596080161963e-12,
3.750199743827946e-13,
8.59070507172411e-14,
1.779651144886819e-14,
3.343184371166244e-15,
5.669936654470561e-16,
8.5694336653163e-17,
1.039597594719582e-17,
1.503265554926964e-6,
-3.2619261378273e-11,
-3.75535835810839e-11,
-2.882232167021011e-11,
-1.659017389142939e-11,
-7.63887101532177e-12,
-2.930614535965914e-12,
-9.63399487884119e-13,
-2.769438940359161e-13,
-7.06777164455478e-14,
-1.619295195096961e-14,
-3.355616333996661e-15,
-6.307891140947906e-16,
-1.07131009139349e-16,
-1.625198863787676e-17,
-1.9905274966458e-18,
-2.656336619195459e-7,
5.59741807949283e-12,
6.44414434967679e-12,
4.94587727297064e-12,
2.846861339869311e-12,
1.310830559446525e-12,
5.028982096947796e-13,
1.653239702860109e-13,
4.752665900867658e-14,
1.212998490116654e-14,
2.779513336166986e-15,
5.761649275464406e-16,
1.083746421685118e-16,
1.843031864891898e-17,
2.805649051263158e-18,
3.466897489536233e-19,
4.305525924926036e-8,
-8.81789265906688e-13,
-1.015178841662125e-12,
-7.79150053686207e-13,
-4.484820110778429e-13,
-2.065033771284283e-13,
-7.92254048810319e-14,
-2.604520401059062e-14,
-7.48762981951308e-15,
-1.911162973546049e-15,
-4.379932492037111e-16,
-9.08174967419394e-17,
-1.70924091781101e-17,
-2.910357584806885e-18,
-4.44488264572842e-19,
-5.538334651924377e-20,
-6.447698967178462e-9,
1.284433486575826e-13,
1.478732412074638e-13,
1.134928717286149e-13,
6.53271030233632e-14,
3.007996406898823e-14,
1.154032897833431e-14,
3.79392398732492e-15,
1.09073570105e-15,
2.784207412018329e-16,
6.3815921370684e-17,
1.323571929492295e-17,
2.492418034396565e-18,
4.249378843029396e-19,
6.508662081213043e-20,
8.11724489100791e-21,
9.11622867072163e-10,
-1.76629721395879e-14,
-2.033489681976802e-14,
-1.560707075451249e-14,
-8.9835311899648e-15,
-4.136497123070865e-15,
-1.587000523403207e-15,
-5.217403740057592e-16,
-1.500027590198529e-16,
-3.829210081636478e-17,
-8.77794295268864e-18,
-1.821059961187111e-18,
-3.431091922883857e-19,
-5.857165166740554e-20,
-8.9936711344313e-21,
-1.121474995823788e-21,
-1.182581542293254e-10,
2.232170641703822e-15,
2.569838194662274e-15,
1.972357350124374e-15,
1.135303764404003e-15,
5.227563456087866e-16,
2.005611611811e-16,
6.59372112700295e-17,
1.895780770683169e-17,
4.839753282682664e-18,
1.109580473180895e-18,
2.302695104555806e-19,
4.340123181126373e-20,
7.359690544145594e-21,
1.143244976997443e-21,
2.018695607901269e-22,
// [{0,0.0001},{2.,0.001}]: m=26
0.00720259994372264,
-2.13403980664608e-7,
-2.45683831694613e-7,
-1.88559208043137e-7,
-1.08531776049361e-7,
-4.99700194094483e-8,
-1.91684835847295e-8,
-6.29988769348062e-9,
-1.810141269621059e-9,
-4.61519523377284e-10,
-1.055359057757993e-10,
-2.178469907777708e-11,
-4.06239666740287e-12,
-6.78074314655373e-13,
-9.81305678200425e-14,
-1.054204750018305e-14,
-0.0138630965303797,
3.94727864843716e-7,
4.54435569267033e-7,
3.48774260957509e-7,
2.007499635248358e-7,
9.24297654015209e-8,
3.54566441500978e-8,
1.165353734902833e-8,
3.34863404523733e-9,
8.53898166156721e-10,
1.953165322323937e-10,
4.03404366760924e-11,
7.53161105909467e-12,
1.260412924721672e-12,
1.83734936478148e-13,
2.017262552117978e-14,
0.01336026873817895,
-3.66129702412953e-7,
-4.21511985687048e-7,
-3.23506422597914e-7,
-1.862068667429699e-7,
-8.57344850094253e-8,
-3.288881875181865e-8,
-1.080991654661906e-8,
-3.106419902665589e-9,
-7.92236057619518e-10,
-1.812594625481167e-10,
-3.745698284530309e-11,
-7.00091918012543e-12,
-1.174398451699251e-12,
-1.723280620791865e-13,
-1.928750538404856e-14,
-0.0085950678418023,
2.27018438804255e-7,
2.613584225438038e-7,
2.005904639409578e-7,
1.154581715814295e-7,
5.31603390949039e-8,
2.039327187122562e-8,
6.70307156704667e-9,
1.926360172143391e-9,
4.91341882641116e-10,
1.124435395001401e-10,
2.324767990745499e-11,
4.349507997106843e-12,
7.31227970231132e-13,
1.079451268523948e-13,
1.229007910212902e-14,
0.004152178572081637,
-1.05839238468475e-7,
-1.218491339605788e-7,
-9.35183800447201e-8,
-5.38285721392838e-8,
-2.478442860779559e-8,
-9.50788780757034e-9,
-3.125236939019099e-9,
-8.9819479966336e-10,
-2.291210197875477e-10,
-5.24460398321462e-11,
-1.084813855337153e-11,
-2.031521112307232e-12,
-3.422257540524675e-13,
-5.079869694937714e-14,
-5.873030436932541e-15,
-0.001606530023027538,
3.95682240416303e-8,
4.55535938621062e-8,
3.496212875864437e-8,
2.012403854960109e-8,
9.26582232807299e-9,
3.554632125739443e-9,
1.168435338586473e-9,
3.358261849290508e-10,
8.5674918286747e-11,
1.961515351815245e-11,
4.058987406898104e-12,
7.6078209906348e-13,
1.283999771533513e-13,
1.915583523133925e-14,
2.245487550904355e-15,
0.0005185429276215804,
-1.235443241368245e-8,
-1.422326196394757e-8,
-1.091629035628942e-8,
-6.28338464199498e-9,
-2.893110783229926e-9,
-1.109892558137346e-9,
-3.648390655790106e-10,
-1.048653454321899e-10,
-2.675548714815832e-11,
-6.12681844413074e-12,
-1.268329088070603e-12,
-2.379166780951492e-13,
-4.02239306336163e-14,
-6.0290112122926e-15,
-7.15633694634164e-16,
-0.0001436048871852686,
3.31321420362099e-9,
3.81439995126723e-9,
2.927539093181154e-9,
1.68508759397963e-9,
7.75883150549076e-10,
2.97657644812293e-10,
9.78469143879341e-11,
2.81253038137733e-11,
7.17657285662822e-12,
1.643682272089694e-12,
3.403881860420355e-13,
6.38990314389949e-14,
1.082072978430473e-14,
1.628890626702664e-15,
1.955615431245903e-16,
0.00003483140090332525,
-7.78980712939202e-10,
-8.96816731674148e-10,
-6.88304714583783e-10,
-3.961883096479654e-10,
-1.824222319388377e-10,
-6.99846871005214e-11,
-2.300605774915961e-11,
-6.61318235057308e-12,
-1.687589882128496e-12,
-3.865817276334253e-13,
-8.00843014022139e-14,
-1.504432964573667e-14,
-2.551471475873197e-15,
-3.856245156703363e-16,
-4.678190663787459e-17,
-7.51632158182979e-6,
1.630961929478981e-10,
1.877677867253049e-10,
1.441115076698913e-10,
8.29508115042117e-11,
3.819432839179458e-11,
1.465306244183892e-11,
4.816994073495145e-12,
1.384718502404986e-12,
3.533883351481307e-13,
8.0964703103282e-14,
1.67780699199176e-14,
3.153943350059274e-15,
5.356546445392759e-16,
8.12598885328857e-17,
9.95265261449373e-18,
1.460985566966155e-6,
-3.07858070898627e-11,
-3.544280273352294e-11,
-2.720233176327811e-11,
-1.565774126151782e-11,
-7.20956986916807e-12,
-2.765940840932278e-12,
-9.09282062639872e-13,
-2.613966895489999e-13,
-6.67149335600603e-14,
-1.528732715260422e-14,
-3.168907852944705e-15,
-5.960606865244317e-16,
-1.013668766265165e-16,
-1.543106768042125e-17,
-1.906693480685754e-18,
-2.583666908428633e-7,
5.29138205767081e-12,
6.09181730492498e-12,
4.67547154018275e-12,
2.691220864465169e-12,
1.239171659994383e-12,
4.754105148831252e-13,
1.562903207593882e-13,
4.493126961990224e-14,
1.146837965244334e-14,
2.628280911191632e-15,
5.449716636262147e-16,
1.025670475885487e-16,
1.746437242307067e-17,
2.667246810731983e-18,
3.322654211550897e-19,
4.190869936932821e-8,
-8.3485764738832e-13,
-9.61148300398414e-13,
-7.37682354611298e-13,
-4.246139024783728e-13,
-1.955141179280602e-13,
-7.50099712135737e-14,
-2.46597934222623e-14,
-7.0895771924911e-15,
-1.809682487311634e-15,
-4.14791498549955e-16,
-8.60298107609106e-17,
-1.620023654505489e-17,
-2.761696000260048e-18,
-4.230622240240243e-19,
-5.3087148006751e-20,
-6.280445626604428e-9,
1.217840715285961e-13,
1.40206669385447e-13,
1.076088740069183e-13,
6.19403627087438e-14,
2.852064503819734e-14,
1.094217338986456e-14,
3.597334131822768e-15,
1.034249217237506e-15,
2.640185092708226e-16,
6.052244295379062e-17,
1.25558496338017e-17,
2.365612491169261e-18,
4.037263852609426e-19,
6.202333353548747e-20,
7.82418292667626e-21,
8.885902974463336e-10,
-1.677096611148272e-14,
-1.930796352847194e-14,
-1.481891115739932e-14,
-8.52987706375523e-15,
-3.927624972170283e-15,
-1.506876101233429e-15,
-4.954060465957322e-16,
-1.424357109831869e-16,
-3.636256027871872e-17,
-8.33661411886114e-18,
-1.729928957528166e-18,
-3.260937526180516e-19,
-5.569741728684126e-20,
-8.583426588038289e-21,
-1.106805243112249e-21,
-1.153436026711593e-10,
2.122205477123872e-15,
2.443239312856723e-15,
1.87519401810555e-15,
1.079377696379345e-15,
4.970066357526678e-16,
1.906833328317813e-16,
6.269061415974255e-17,
1.802487217337758e-17,
4.601844981129759e-18,
1.05515397488292e-18,
2.190071224337072e-19,
4.130313677471739e-20,
7.050623471995223e-21,
1.089143776054996e-21,
1.563303457413716e-22,
// [{0,0.0001},{2.,0.001}]: m=27
0.00693154826518985,
-1.97363932421858e-7,
-2.27217784633517e-7,
-1.74387130478754e-7,
-1.003749817624179e-7,
-4.62148827007604e-8,
-1.772832207504891e-8,
-5.82676867451417e-9,
-1.674317022618666e-9,
-4.26949083078361e-10,
-9.76582661161968e-11,
-2.017021833804619e-11,
-3.76580552954733e-12,
-6.30206462360836e-13,
-9.1867468239074e-14,
-1.008631276058989e-14,
-0.01336026873817894,
3.66129702412953e-7,
4.21511985687048e-7,
3.23506422597914e-7,
1.862068667429698e-7,
8.57344850094252e-8,
3.28888187518186e-8,
1.080991654661906e-8,
3.106419902665588e-9,
7.92236057619518e-10,
1.812594625481166e-10,
3.74569828453031e-11,
7.00091918012542e-12,
1.174398451699251e-12,
1.723280620791865e-13,
1.928750538404855e-14,
0.01289260176270345,
-3.40527658206382e-7,
-3.92037633815706e-7,
-3.00885695911437e-7,
-1.731872573721443e-7,
-7.97405086423559e-8,
-3.058990780683843e-8,
-1.005460735057e-8,
-2.889540258215087e-9,
-7.37012823961675e-10,
-1.686653092502101e-10,
-3.487151986118249e-11,
-6.52426199566026e-12,
-1.096841955346699e-12,
-1.619176902785922e-13,
-1.84351186531933e-14,
-0.00830435714416384,
2.1167847693696e-7,
2.436982679211693e-7,
1.870367600894491e-7,
1.076571442785727e-7,
4.95688572155935e-8,
1.901577561514158e-8,
6.2504738780385e-9,
1.796389599326805e-9,
4.582420395751173e-10,
1.048920796642975e-10,
2.16962771067441e-11,
4.06304222461466e-12,
6.84451508104966e-13,
1.015973938987598e-13,
1.174606087386832e-14,
0.004016325057568651,
-9.89205601040722e-8,
-1.138839846552615e-7,
-8.74053218966079e-8,
-5.0310096374001e-8,
-2.316455582018167e-8,
-8.8865803143483e-9,
-2.921088346466082e-9,
-8.39565462322598e-10,
-2.141872957168601e-10,
-4.903788379537944e-11,
-1.014746851724491e-11,
-1.901955247658632e-12,
-3.209999428833532e-13,
-4.788958807834792e-14,
-5.613718877277607e-15,
-0.001555628782837709,
3.70632972405622e-8,
4.26697858912842e-8,
3.27488710684396e-8,
1.885015392573819e-8,
8.67933234957616e-9,
3.329677674368446e-9,
1.0945171967227e-9,
3.145960362924491e-10,
8.02664614434229e-11,
1.838045533215096e-11,
3.804987264161674e-12,
7.13750034276007e-13,
1.206717918993544e-13,
1.808703363661645e-14,
2.146901083742341e-15,
0.0005026171051536145,
-1.159624971276409e-8,
-1.335039982953964e-8,
-1.024638682621413e-8,
-5.8978065789748e-9,
-2.715591026942991e-9,
-1.041801756851169e-9,
-3.424642003604468e-10,
-9.84385633489764e-11,
-2.511800499839535e-11,
-5.75288795235901e-12,
-1.191358651156395e-12,
-2.236466100382608e-13,
-3.78725542457053e-14,
-5.701117193489715e-15,
-6.844654005081895e-16,
-0.0001393256041798111,
3.11592286192367e-9,
3.58726693840144e-9,
2.753218867318645e-9,
1.584753243762858e-9,
7.29688930136378e-10,
2.799387493156053e-10,
9.20242312969786e-11,
2.645272948864869e-11,
6.75035955056224e-12,
1.546326915589759e-12,
3.203372066592976e-13,
6.017731878082428e-14,
1.020588593525811e-14,
1.542498068123954e-15,
1.871276294896254e-16,
0.00003382344705317756,
-7.33932867126042e-10,
-8.44955038951995e-10,
-6.48501783507639e-10,
-3.732786511893867e-10,
-1.71874477496209e-10,
-6.59387808858868e-11,
-2.167647329706525e-11,
-6.23123325114315e-12,
-1.590247505695073e-12,
-3.64341163397958e-13,
-7.55013145230011e-14,
-1.419274505308799e-14,
-2.410445892542997e-15,
-3.656694977724551e-16,
-4.478694205574379e-17,
-7.304921790986961e-6,
1.539289269844937e-10,
1.772138887948708e-10,
1.360115629760794e-10,
7.82886511409962e-11,
3.604782394393198e-11,
1.382969445881049e-11,
4.546407109031096e-12,
1.306982526454826e-12,
3.335744325787163e-13,
7.64365818227198e-14,
1.584452806054341e-14,
2.980301321292178e-15,
5.068340380776e-16,
7.71552806867227e-17,
9.53344241937312e-18,
1.421017216028057e-6,
-2.91026086105033e-11,
-3.350500357369446e-11,
-2.571509991543837e-11,
-1.480171846404122e-11,
-6.81544583803612e-12,
-2.614758487188711e-12,
-8.59596979634402e-13,
-2.471220448612239e-13,
-6.30761039072313e-14,
-1.445554863966248e-14,
-2.997344896477865e-15,
-5.641189027471169e-16,
-9.60540987818856e-17,
-1.466986270287306e-17,
-1.827425741945875e-18,
-2.514864864263403e-7,
5.00976126346671e-12,
5.7675982724875e-12,
4.42663788119136e-12,
2.547996404560715e-12,
1.173228826228267e-12,
4.501151207244671e-13,
1.479769394996836e-13,
4.254269012872578e-14,
1.085942946488391e-14,
2.489055023025555e-15,
5.162424181545314e-16,
9.72133998315924e-17,
1.657217004976095e-17,
2.53869853171712e-18,
3.186259098376911e-19,
4.08215842241405e-8,
-7.91573478574298e-13,
-9.1131688739097e-13,
-6.99437370103191e-13,
-4.026006664175655e-13,
-1.853788094277985e-13,
-7.11220616235723e-14,
-2.338199279789546e-14,
-6.72242465855373e-15,
-1.716070454023978e-15,
-3.933844437956939e-16,
-8.16106702884181e-17,
-1.537603917443298e-17,
-2.624060871331633e-18,
-4.031320249169251e-19,
-5.096666898812526e-20,
-6.121644995958006e-9,
1.156293039950938e-13,
1.331209150758504e-13,
1.021706385414535e-13,
5.88101873280991e-14,
2.707944495816205e-14,
1.038932186167678e-14,
3.415629680032835e-15,
9.82037344075024e-16,
2.507049180920674e-16,
5.747733290845571e-17,
1.192700460707259e-17,
2.248240195428593e-18,
3.840542662202708e-19,
5.915741455733837e-20,
7.560547987416924e-21,
8.666923051794789e-10,
-1.594483343296107e-14,
-1.835686711582686e-14,
-1.40889544974266e-14,
-8.10972261533383e-15,
-3.73417573247187e-15,
-1.432667170101883e-15,
-4.710154138181873e-16,
-1.354268655031333e-16,
-3.457520222739703e-17,
-7.92773055525266e-18,
-1.645447681571821e-18,
-3.103152130480533e-19,
-5.308031796871049e-20,
-8.195787732989549e-21,
-1.034364260483587e-21,
-1.125691866559816e-10,
2.020166995067716e-15,
2.325766054882203e-15,
1.785034390463496e-15,
1.027482742716083e-15,
4.731128234987762e-16,
1.815173484709756e-16,
5.967791986206958e-17,
1.715911372506783e-17,
4.38104739019682e-18,
1.004636514649962e-18,
2.085525762470363e-19,
3.934455382348827e-20,
6.767545967429119e-21,
1.049806141757257e-21,
9.70168175649803e-23,
// [{0,0.0001},{2.,0.001}]: m=28
0.00668013436908947,
-1.83064851206476e-7,
-2.10755992843524e-7,
-1.61753211298957e-7,
-9.31034333714849e-8,
-4.28672425047126e-8,
-1.644440937590932e-8,
-5.40495827330953e-9,
-1.553209951332794e-9,
-3.96118028809759e-10,
-9.06297312740583e-11,
-1.872849142265154e-11,
-3.50045959006271e-12,
-5.87199225849625e-13,
-8.61640310395933e-14,
-9.64375269202427e-15,
-0.01289260176270344,
3.40527658206382e-7,
3.92037633815706e-7,
3.00885695911437e-7,
1.731872573721443e-7,
7.97405086423559e-8,
3.05899078068384e-8,
1.005460735057e-8,
2.889540258215086e-9,
7.37012823961675e-10,
1.686653092502101e-10,
3.487151986118248e-11,
6.52426199566026e-12,
1.096841955346699e-12,
1.619176902785922e-13,
1.843511865319334e-14,
0.01245653571624576,
-3.1751771540544e-7,
-3.65547401881754e-7,
-2.805551401341737e-7,
-1.61485716417859e-7,
-7.43532858233903e-8,
-2.852366342271237e-8,
-9.37571081705774e-9,
-2.694584398990208e-9,
-6.87363059362676e-10,
-1.573381194964463e-10,
-3.254441566011615e-11,
-6.09456333692199e-12,
-1.026677262157449e-12,
-1.523960908481394e-13,
-1.76190913108032e-14,
-0.00803265011513785,
1.978411202081541e-7,
2.277679693105341e-7,
1.748106437932243e-7,
1.006201927480069e-7,
4.63291116403656e-8,
1.777316062869747e-8,
5.84217669293245e-9,
1.679130924645278e-9,
4.283745914337411e-10,
9.80757675907637e-11,
2.029493703449082e-11,
3.803910495317451e-12,
6.41999885766744e-13,
9.57791761567006e-14,
1.122743775454975e-14,
0.003889071957094083,
-9.26582431014023e-8,
-1.066744647282067e-7,
-8.18721776710961e-8,
-4.71253848143438e-8,
-2.169833087393965e-8,
-8.32419418592082e-9,
-2.736292991806655e-9,
-7.86490090731095e-10,
-2.006661536085502e-10,
-4.59511383303758e-11,
-9.51246816040384e-12,
-1.78437508568994e-12,
-3.016794797484063e-13,
-4.521758409155533e-14,
-5.36725270931835e-15,
-0.001507851315434446,
3.47887491378299e-8,
4.00511994880866e-8,
3.073916047823383e-8,
1.769341973668924e-8,
8.14677308072069e-9,
3.125405270511964e-9,
1.027392601067681e-9,
2.953156900430019e-10,
7.53540149941832e-11,
1.725866385684705e-11,
3.574075953421498e-12,
6.70939830105766e-13,
1.136176627353773e-13,
1.710335158023516e-14,
2.05339620171383e-15,
0.0004876396146343946,
-1.090573001681932e-8,
-1.255543428450459e-8,
-9.63626603569167e-9,
-5.54663635321399e-9,
-2.553911255497577e-9,
-9.79785622612389e-10,
-3.220848095419797e-10,
-9.2584553211005e-11,
-2.362625842715539e-11,
-5.412144204607093e-12,
-1.121180223316709e-12,
-2.106206157348385e-13,
-3.5720600772976e-14,
-5.39874323815906e-15,
-6.549467040844445e-16,
-0.0001352937887659132,
2.93573147819364e-9,
3.37982016696322e-9,
2.594007142592256e-9,
1.49311460968575e-9,
6.87497912254075e-10,
2.637551244141826e-10,
8.67058934745056e-11,
2.492493308687821e-11,
6.36099004379571e-12,
1.457364658411408e-12,
3.020052590917228e-13,
5.677098040127915e-14,
9.64178360548111e-15,
1.462677996039618e-15,
1.791477655541535e-16,
0.00003287214799587798,
-6.92680170343003e-10,
-7.9746249832523e-10,
-6.12052032431681e-10,
-3.522989295815064e-10,
-1.622152074930698e-10,
-6.22336249669554e-11,
-2.045883195852071e-11,
-5.88142135981095e-12,
-1.501084944246431e-12,
-3.439646176621846e-13,
-7.13003761572341e-14,
-1.34113559219718e-14,
-2.280753176477556e-15,
-3.4719876572611e-16,
-4.29004803147452e-17,
-7.10508017826321e-6,
1.455129396806657e-10,
1.675248988590849e-10,
1.285754082369577e-10,
7.40085397438175e-11,
3.407720498087685e-11,
1.307378314759621e-11,
4.29798184438016e-12,
1.235609346231211e-12,
3.153802953343832e-13,
7.22776917808567e-14,
1.49867138134773e-14,
2.820592498165925e-15,
4.802701271254946e-16,
7.334926058337091e-17,
9.13714590237282e-18,
1.383176082180391e-6,
-2.75536939077603e-11,
-3.172179851005131e-11,
-2.434651449531923e-11,
-1.401398376438331e-11,
-6.45276017396476e-12,
-2.475633789256398e-12,
-8.13873372825824e-13,
-2.339848548209011e-13,
-5.97268771475889e-14,
-1.368980608425852e-14,
-2.839334038050719e-15,
-5.346738487093858e-16,
-9.11469009640982e-17,
-1.396282844355485e-17,
-1.752511171049284e-18,
-2.449629901014597e-7,
4.75002735562183e-12,
5.46857652868653e-12,
4.197142442954052e-12,
2.415902292670102e-12,
1.112410208983643e-12,
4.267850675378204e-13,
1.403092825933529e-13,
4.033952974327607e-14,
1.029769473873108e-14,
2.360598381375954e-15,
4.897245683952429e-16,
9.22676708279843e-17,
1.574639994843245e-17,
2.419092655523431e-18,
3.057547866724858e-19,
3.978941024510755e-8,
-7.51568544228044e-13,
-8.65260698528115e-13,
-6.6408977142833e-13,
-3.822550628096096e-13,
-1.760112558672064e-13,
-6.75286214293105e-14,
-2.220094500053313e-14,
-6.38305643047587e-15,
-1.629534406947863e-15,
-3.735917643961412e-16,
-7.7523199603294e-17,
-1.461309582590583e-17,
-2.496469304240649e-18,
-3.845586443063808e-19,
-4.891958217515986e-20,
-5.9706724315697e-9,
1.099293653401351e-13,
1.265587837767607e-13,
9.71342708243663e-14,
5.59113136552558e-14,
2.574473381263956e-14,
9.87731437936742e-15,
3.247345636402685e-15,
9.33679619972157e-16,
2.383730096130992e-16,
5.465625594159223e-17,
1.134419598768576e-17,
2.139360455942753e-18,
3.658290632082935e-19,
5.650682122625359e-20,
7.24536403904537e-21,
8.458471121873237e-10,
-1.517824675830797e-14,
-1.747432327000833e-14,
-1.34116103408593e-14,
-7.71985028749091e-15,
-3.554668175359866e-15,
-1.36380567991668e-15,
-4.483818795991214e-16,
-1.289226641094129e-16,
-3.291639354785214e-17,
-7.54819105850262e-18,
-1.567017514418096e-18,
-2.956519946152571e-19,
-5.060142453019413e-20,
-7.83568061468952e-21,
-1.01442083107869e-21,
-1.099250412633155e-10,
1.925311569426711e-15,
2.216562325487034e-15,
1.701221444984549e-15,
9.7924075455086e-16,
4.509008233852242e-16,
1.729964450935556e-16,
5.687719667754015e-17,
1.63542385893017e-17,
4.175758098051905e-18,
9.57653128656202e-19,
1.98844974271782e-19,
3.754256617514515e-20,
6.445029539448249e-21,
9.88342085918176e-22,
1.161010889584829e-22,
// [{0,0.0001},{2.,0.001}]: m=29
0.00644630088135172,
-1.70263829103191e-7,
-1.96018816907853e-7,
-1.50442847955718e-7,
-8.65936286860721e-8,
-3.9870254321178e-8,
-1.529495390341921e-8,
-5.027303675285e-9,
-1.444770129107543e-9,
-3.68506411980837e-10,
-8.43326546251051e-11,
-1.743575993059124e-11,
-3.26213099783013e-12,
-5.48420977673349e-13,
-8.09588451392961e-14,
-9.21755932659667e-15,
-0.01245653571624576,
3.1751771540544e-7,
3.65547401881754e-7,
2.80555140134174e-7,
1.61485716417859e-7,
7.43532858233903e-8,
2.852366342271237e-8,
9.37571081705774e-9,
2.694584398990208e-9,
6.87363059362676e-10,
1.573381194964463e-10,
3.254441566011614e-11,
6.09456333692199e-12,
1.026677262157448e-12,
1.523960908481394e-13,
1.761909131080317e-14,
0.01204897517270678,
-2.96761680312231e-7,
-3.41651953965801e-7,
-2.622159656898366e-7,
-1.509302891220103e-7,
-6.94936674605484e-8,
-2.665974094304621e-8,
-8.76326503939868e-9,
-2.518696386967917e-9,
-6.42561887150612e-10,
-1.471136513861455e-10,
-3.044240555173623e-11,
-5.70586574297618e-12,
-9.62999828650116e-13,
-1.43668764235051e-13,
-1.684115663182496e-14,
-0.0077781439141887,
1.853164862028137e-7,
2.13348929456424e-7,
1.637443553422004e-7,
9.42507696286923e-8,
4.33966617478814e-8,
1.664838837184247e-8,
5.47258598361358e-9,
1.572980181462268e-9,
4.013323072171203e-10,
9.19022766607562e-11,
1.902493632080863e-11,
3.568750171380058e-12,
6.03358959496841e-13,
9.04351681831163e-14,
1.073450541863963e-14,
0.00376962828858593,
-8.69718728445717e-8,
-1.00127998720213e-7,
-7.68479011955818e-8,
-4.42335493417215e-8,
-2.0366932701801e-8,
-7.81351317627963e-9,
-2.568481502669112e-9,
-7.38289225107478e-10,
-1.883850374854514e-10,
-4.314665964211608e-11,
-8.93518988355342e-12,
-1.677349575264363e-12,
-2.840441568384551e-13,
-4.275837895057806e-14,
-5.133490504263285e-15,
-0.001462918843877392,
3.27171900500168e-8,
3.76663028530059e-8,
2.890879810668521e-8,
1.663990905941758e-8,
7.66173376638941e-9,
2.939356867797527e-9,
9.66254428612907e-10,
2.777536596292677e-10,
7.08787752805093e-11,
1.62364326136018e-11,
3.363540669904514e-12,
6.31861847195933e-13,
1.071618023175372e-13,
1.619622971421987e-14,
1.96484011213418e-15,
0.0004735282606856386,
-1.027506017376034e-8,
-1.182937058446637e-8,
-9.07902499914588e-9,
-5.22590113394214e-9,
-2.406242692908605e-9,
-9.23142935457061e-10,
-3.034706271632098e-10,
-8.72372658047754e-11,
-2.226346515346412e-11,
-5.100776304481111e-12,
-1.057018406829802e-12,
-1.986984314058729e-13,
-3.374624261891746e-14,
-5.119372986400976e-15,
-6.270171799540639e-16,
-0.0001314885925240183,
2.77072069061693e-9,
3.18985000394437e-9,
2.448208137895623e-9,
1.409195723028137e-9,
6.48860832137418e-10,
2.489345006985221e-10,
8.18353281072011e-11,
2.352568551777696e-11,
6.0043397970386e-12,
1.375858475248189e-12,
2.852015055846874e-13,
5.364542386792832e-14,
9.12301273542472e-15,
1.388795068095035e-15,
1.716019233628358e-16,
0.00003197286074004727,
-6.54808227524542e-10,
-7.53862043670336e-10,
-5.78589336148721e-10,
-3.330384283190039e-10,
-1.533474221707411e-10,
-5.88320240708718e-11,
-1.934091826903142e-11,
-5.56024204921886e-12,
-1.41921132675265e-12,
-3.252496124960861e-13,
-6.74402120505548e-14,
-1.269266622416195e-14,
-2.161215574913322e-15,
-3.300716693494282e-16,
-4.11171506239213e-17,
-6.915874644478261e-6,
1.377683709095959e-10,
1.586088790009137e-10,
1.217324853269053e-10,
7.00698686575732e-11,
3.226377777110039e-11,
1.237816008397625e-11,
4.069363950374683e-12,
1.169923436275461e-12,
2.986341718041207e-13,
6.84489813525928e-14,
1.419665999515744e-14,
2.673367321540925e-15,
4.557341864672859e-16,
6.981408829213714e-17,
8.76253707493703e-18,
1.347296843265409e-6,
-2.612515710249567e-11,
-3.007717855981523e-11,
-2.308428930923008e-11,
-1.32874659902454e-11,
-6.11825770603039e-12,
-2.347318468691336e-12,
-7.71701250624843e-13,
-2.218674700502098e-13,
-5.663733547755911e-14,
-1.298329441145613e-14,
-2.693485829649991e-15,
-5.074723022076672e-16,
-8.66051844394396e-17,
-1.330503054606926e-17,
-1.681686271827486e-18,
-2.387691777270638e-7,
4.50997084213239e-12,
5.19220841793022e-12,
3.985033075844971e-12,
2.293814986276509e-12,
1.056198586739442e-12,
4.052220092239091e-13,
1.332222013061047e-13,
3.830309203995456e-14,
9.77842020516565e-15,
2.241828977951652e-15,
4.65197033192819e-16,
8.76894845880792e-17,
1.498063976492812e-17,
2.307651894848802e-18,
2.936053734807258e-19,
3.880811734577777e-8,
-7.1451992667126e-13,
-8.22607977585205e-13,
-6.313542504544e-13,
-3.634128842348554e-13,
-1.673358637753926e-13,
-6.4200661163173e-14,
-2.11071277636691e-14,
-6.06873957766677e-15,
-1.549379131347761e-15,
-3.552552192737741e-16,
-7.37350604775448e-17,
-1.390548805064459e-17,
-2.377927856798544e-18,
-3.672279133935973e-19,
-4.699404002304721e-20,
-5.826963326632739e-9,
1.046405402420435e-13,
1.204699485359896e-13,
9.24611468261468e-14,
5.32215117495909e-14,
2.45062778704208e-14,
9.40222631592549e-15,
3.091192815155892e-15,
8.88806017594463e-16,
2.2692864344936e-16,
5.203775923292053e-17,
1.080302803916913e-17,
2.038219161246642e-18,
3.489244303827531e-19,
5.400060180434336e-20,
6.898017373692932e-21,
8.259806116835908e-10,
-1.446562029831952e-14,
-1.665390138351857e-14,
-1.278194342846494e-14,
-7.35741959374485e-15,
-3.38779464788739e-15,
-1.299790137525014e-15,
-4.273407038983357e-16,
-1.228758187159876e-16,
-3.137410483050254e-17,
-7.19525382463251e-18,
-1.494057057513113e-18,
-2.8200541203275e-19,
-4.83011781390554e-20,
-7.495402199158491e-21,
-9.83465309740144e-22,
-1.074022058734696e-10,
1.83698074141526e-15,
2.114870076986244e-15,
1.623173406166607e-15,
9.34316889767719e-16,
4.302164853440102e-16,
1.650615044372845e-16,
5.426902415347953e-17,
1.560466859667049e-17,
3.984555138514377e-18,
9.13897935786209e-19,
1.898236083838082e-19,
3.583550690834624e-20,
6.091500863919678e-21,
9.59978554286573e-22,
1.787857226343754e-22,
// [{0,0.0001},{2.,0.001}]: m=30
0.00622826785812288,
-1.5875885770272e-7,
-1.82773700940877e-7,
-1.402775700670868e-7,
-8.07428582089295e-8,
-3.71766429116952e-8,
-1.426183171135618e-8,
-4.68785540852887e-9,
-1.347292199495104e-9,
-3.43681529681338e-10,
-7.86690597482231e-11,
-1.627220783005807e-11,
-3.04728166846099e-12,
-5.13338631078724e-13,
-7.61980454240697e-14,
-8.80954565540159e-15,
-0.01204897517270678,
2.96761680312231e-7,
3.41651953965801e-7,
2.62215965689837e-7,
1.509302891220103e-7,
6.94936674605484e-8,
2.66597409430462e-8,
8.76326503939867e-9,
2.518696386967917e-9,
6.42561887150612e-10,
1.471136513861455e-10,
3.044240555173622e-11,
5.70586574297618e-12,
9.62999828650116e-13,
1.436687642350509e-13,
1.684115663182492e-14,
0.01166721587128306,
-2.77974729304221e-7,
-3.20023394184636e-7,
-2.456165330133006e-7,
-1.413761544430385e-7,
-6.50949926218222e-8,
-2.497258255776371e-8,
-8.20887897542037e-9,
-2.359470272193403e-9,
-6.0199846082568e-10,
-1.378534149911343e-10,
-2.853740448121295e-11,
-5.35312525707009e-12,
-9.05038439245263e-13,
-1.356527522746743e-13,
-1.610175812795812e-14,
-0.00753925657717239,
1.739437456891522e-7,
2.00255997440436e-7,
1.536958023911714e-7,
8.84670986834475e-8,
4.07338654036041e-8,
1.562702635256005e-8,
5.13696300533848e-9,
1.476578450215031e-9,
3.767700749709219e-10,
8.62933192842365e-11,
1.787037976710774e-11,
3.354699150528896e-12,
5.68088313676936e-13,
8.55167579011609e-14,
1.02669810085312e-14,
0.0036572971096933,
-8.17929751250391e-8,
-9.41657571325113e-8,
-7.22719952667104e-8,
-4.15997726485425e-8,
-1.915433441597284e-8,
-7.34839216949355e-9,
-2.415636071532179e-9,
-6.94384149073144e-10,
-1.771969382012668e-10,
-4.059108153400304e-11,
-8.40885167476101e-12,
-1.579654617989764e-12,
-2.679045057937608e-13,
-4.049057428555991e-14,
-4.912100280410591e-15,
-0.001420584782031703,
3.08251805208597e-8,
3.5488111752914e-8,
2.723707499706532e-8,
1.56777034016121e-8,
7.21872807862713e-9,
2.769428806333321e-9,
9.10411881477181e-10,
2.617117974107467e-10,
6.67903954594783e-11,
1.530232891323367e-11,
3.171055220445802e-12,
5.96095294209394e-13,
1.012387278554811e-13,
1.535811895898206e-14,
1.881051539681096e-15,
0.0004602100738388979,
-9.69752241723824e-9,
-1.116447501389621e-8,
-8.56872848270446e-9,
-4.93218503063865e-9,
-2.271012912499458e-9,
-8.71270752451924e-10,
-2.864236483775369e-10,
-8.23398993128903e-11,
-2.101518928980656e-11,
-4.815504663407884e-12,
-9.98205269553926e-13,
-1.87758983539525e-13,
-3.193054457592329e-14,
-4.860782738113942e-15,
-6.006067300390544e-16,
-0.0001278914434885683,
2.61923291892843e-9,
3.015448184847411e-9,
2.314357352397398e-9,
1.332153717767237e-9,
6.13389690751003e-10,
2.353280970769377e-10,
7.73636733369998e-11,
2.224096827188963e-11,
5.67684532616575e-12,
1.300998454378196e-12,
2.697608491157802e-13,
5.077066506909108e-14,
8.64486232691296e-15,
1.320286681940187e-15,
1.644686056241411e-16,
0.0000311214358393786,
-6.19957668100285e-10,
-7.13739954361014e-10,
-5.47796183093739e-10,
-3.153144084540745e-10,
-1.451869997374154e-10,
-5.57017202886747e-11,
-1.831213774735229e-11,
-5.26465545480429e-12,
-1.343853770963006e-12,
-3.080204155933738e-13,
-6.3884969882991e-14,
-1.203015292511361e-14,
-2.050803816622508e-15,
-3.141633994750803e-16,
-3.943143654777474e-17,
-6.736478579281371e-6,
1.306256913069905e-10,
1.503857843426107e-10,
1.154213633052091e-10,
6.64372820367356e-11,
3.059126646733464e-11,
1.173658387854957e-11,
3.858503469994917e-12,
1.109336549963887e-12,
2.831864730311565e-13,
6.49164251817147e-14,
1.34674194041394e-14,
2.537359671026927e-15,
4.33025625406317e-16,
6.652510450779137e-17,
8.40840445562101e-18,
1.313230866478547e-6,
-2.480484598671582e-11,
-2.855715361496001e-11,
-2.191768753248578e-11,
-1.261598565678184e-11,
-5.80909371540541e-12,
-2.228721621769798e-12,
-7.32722294933138e-13,
-2.106670602092513e-13,
-5.378132492433128e-14,
-1.233006253698305e-14,
-2.558584294870826e-15,
-4.822923020912323e-16,
-8.23936543544345e-17,
-1.269207482924899e-17,
-1.614712681447014e-18,
-2.328806862994523e-7,
4.28765403880429e-12,
4.9362631978057e-12,
3.788597773689567e-12,
2.180749150280909e-12,
1.004140356969601e-12,
3.852519929838209e-13,
1.266585567823981e-13,
3.6416977928771e-14,
9.29743421626859e-15,
2.131797266132979e-15,
4.424656346099289e-16,
8.34433673412117e-17,
1.426928334680314e-17,
2.203641890420225e-18,
2.820817480650516e-19,
3.787403567076894e-8,
-6.80143482530155e-13,
-7.83031606530446e-13,
-6.00979756482699e-13,
-3.45929639240775e-13,
-1.592861153546955e-13,
-6.1112671309524e-14,
-2.009216156728031e-14,
-5.777068955837768e-15,
-1.474992702909975e-15,
-3.382354785650063e-16,
-7.02177455277002e-17,
-1.324800083164911e-17,
-2.267601563343649e-18,
-3.510285453508282e-19,
-4.518219580905909e-20,
-5.690006070827657e-9,
9.97242397675358e-14,
1.148099840686384e-13,
8.81171717454505e-14,
5.07211583639768e-14,
2.33550433297459e-14,
8.96059315335529e-15,
2.946033130165003e-15,
8.47089848527297e-16,
2.162886778706869e-16,
4.960292630568058e-17,
1.029968377031818e-17,
1.944059543575911e-18,
3.330891605673035e-19,
5.167411906002314e-20,
6.644393946989417e-21,
8.07025489647068e-10,
-1.38020079599387e-14,
-1.588990728918135e-14,
-1.219558368292192e-14,
-7.01991532694006e-15,
-3.232397233403728e-15,
-1.24017646690488e-15,
-4.077460033401911e-16,
-1.17244450680902e-16,
-2.993767838596543e-17,
-6.866491994587255e-18,
-1.426067912920039e-18,
-2.692797287828813e-19,
-4.616645477634557e-20,
-7.178798072943141e-21,
-9.40499277812653e-22,
-1.049925229110944e-10,
1.754589781250088e-15,
2.020016141181003e-15,
1.550373639524409e-15,
8.92413797099796e-16,
4.109229178355696e-16,
1.576600256502089e-16,
5.183615321245917e-17,
1.490545518689109e-17,
3.806191083502636e-18,
8.73067149866735e-19,
1.813720320317084e-19,
3.425815896980286e-20,
5.836217467975606e-21,
9.15220782766164e-22,
1.661559331028786e-22,
// [{0,0.0001},{2.,0.001}]: m=31
0.00602448758635339,
-1.48380840156116e-7,
-1.70825976982901e-7,
-1.311079828449183e-7,
-7.54651445610052e-8,
-3.47468337302742e-8,
-1.33298704715231e-8,
-4.38163251969934e-9,
-1.259348193483958e-9,
-3.21280943575306e-10,
-7.35568256930727e-11,
-1.522120277586811e-11,
-2.85293287148809e-12,
-4.81499914325058e-13,
-7.18343821175255e-14,
-8.42057831591246e-15,
-0.01166721587128305,
2.77974729304221e-7,
3.20023394184636e-7,
2.45616533013301e-7,
1.413761544430385e-7,
6.50949926218222e-8,
2.497258255776371e-8,
8.20887897542037e-9,
2.359470272193402e-9,
6.0199846082568e-10,
1.378534149911342e-10,
2.853740448121294e-11,
5.35312525707009e-12,
9.05038439245263e-13,
1.356527522746743e-13,
1.610175812795809e-14,
0.01130888486575858,
-2.60915618533728e-7,
-3.00383996160654e-7,
-2.305437035867572e-7,
-1.327006480251713e-7,
-6.11007981054061e-8,
-2.344053952884008e-8,
-7.70544450800773e-9,
-2.214867675322547e-9,
-5.65155112456383e-10,
-1.294399789263548e-10,
-2.680556965066161e-11,
-5.03204872579335e-12,
-8.52132470515405e-13,
-1.282751368517413e-13,
-1.540047151279618e-14,
-0.00731459421938711,
1.635859502500865e-7,
1.883315142650322e-7,
1.445439905334282e-7,
8.31995452970892e-8,
3.830866883194765e-8,
1.469678433898786e-8,
4.83127214306461e-9,
1.388768298146359e-9,
3.543938764025518e-10,
8.11821630680102e-11,
1.681770334952288e-11,
3.159309235979691e-12,
5.35809011587546e-13,
8.09811485711243e-14,
9.82420056082559e-15,
0.003551461955079081,
-7.70629513021463e-8,
-8.87202793822818e-8,
-6.80926874926608e-8,
-3.91942585040288e-8,
-1.804682019656717e-8,
-6.92357201583305e-9,
-2.276029703692869e-9,
-6.54279493526843e-10,
-1.669759886486897e-10,
-3.825582228308276e-11,
-7.92763805111423e-12,
-1.490238235523431e-12,
-2.530968196386535e-13,
-3.839529739745352e-14,
-4.702628849246127e-15,
-0.001380630221492034,
2.90925672513118e-8,
3.34934250412248e-8,
2.57061854477574e-8,
1.479655509171103e-8,
6.81303873740402e-9,
2.61381225731957e-9,
8.59270945120708e-10,
2.470196979352483e-10,
6.30455678685457e-11,
1.444651399002315e-11,
2.994615808620077e-12,
5.63276950610701e-13,
9.57916337265386e-14,
1.458234821413024e-14,
1.801820189956029e-15,
0.0004476200522147192,
-9.1673152163251e-9,
-1.055406864705296e-8,
-8.10025073345768e-9,
-4.66253801222377e-9,
-2.146863917646211e-9,
-8.23648339776074e-10,
-2.707728566817323e-10,
-7.78433889522558e-11,
-1.986895864174417e-11,
-4.553494590361309e-12,
-9.44162971912669e-13,
-1.776973277432859e-13,
-3.025701814549535e-14,
-4.621003386850103e-15,
-5.756401185397092e-16,
-0.0001244857438742986,
2.479830680844024e-9,
2.854959827164145e-9,
2.191184739835184e-9,
1.261257638110501e-9,
5.80748000926985e-10,
2.228068819133487e-10,
7.32485512388441e-11,
2.10586218909436e-11,
5.375415102168477e-12,
1.232081666575291e-12,
2.555398804055384e-13,
4.812061186547258e-14,
8.20321529311142e-15,
1.256653602305154e-15,
1.577257486907635e-16,
0.00003031415354729766,
-5.87815609931186e-10,
-6.76736028447723e-10,
-5.1939613403377e-10,
-2.98967768681984e-10,
-1.376606988804512e-10,
-5.28146273680839e-11,
-1.736326558690201e-11,
-4.99201446676414e-12,
-1.274339126577571e-12,
-2.921239128446749e-13,
-6.0603387225092e-14,
-1.141811850121832e-14,
-1.948615298061332e-15,
-2.993629694917241e-16,
-3.783783434475484e-17,
-6.566148819049337e-6,
1.240241398608393e-10,
1.427856643762306e-10,
1.095883580731452e-10,
6.30798824712937e-11,
2.904544748198695e-11,
1.114360001520778e-11,
3.663608813573885e-12,
1.053334535834132e-12,
2.689064292124735e-13,
6.16502678579977e-14,
1.279291215708069e-14,
2.411459750165138e-15,
4.119679811084883e-16,
6.346032709953742e-17,
8.07354397824833e-18,
1.280844155273678e-6,
-2.358210329559215e-11,
-2.714945459018734e-11,
-2.083729312957023e-11,
-1.199412342005234e-11,
-5.52277338778395e-12,
-2.118886507940249e-12,
-6.96622241996727e-13,
-2.00293430281371e-13,
-5.11359013912873e-14,
-1.172488799139257e-14,
-2.433561588994517e-15,
-4.589386382088172e-16,
-7.84811624294226e-17,
-1.21200354317897e-17,
-1.551358369778976e-18,
-2.272754944191764e-7,
4.08137192677989e-12,
4.69877797751715e-12,
3.606330092151963e-12,
2.075837755307504e-12,
9.55836375754103e-13,
3.667219474820119e-13,
1.205680672234734e-13,
3.466675519906593e-14,
8.85106488170238e-15,
2.02966719970434e-15,
4.213593253969332e-16,
7.94979904486025e-17,
1.360728589838318e-17,
2.106439352080781e-18,
2.711728194009019e-19,
3.698383983424324e-8,
-6.481883892891e-13,
-7.46242827402246e-13,
-5.72744678208795e-13,
-3.296777795438459e-13,
-1.518032921938245e-13,
-5.82421329979927e-14,
-1.914864900510418e-14,
-5.505921156929325e-15,
-1.405834797804517e-15,
-3.224094789012303e-16,
-6.69460582768967e-17,
-1.263601516091948e-17,
-2.16475094644638e-18,
-3.358663767565611e-19,
-4.34764338308102e-20,
-5.559335977544788e-9,
9.51462968236807e-14,
1.095395556651423e-13,
8.40721575481499e-14,
4.839287871400811e-14,
2.228303142688415e-14,
8.54934726330621e-15,
2.810858835417635e-15,
8.0824182355558e-16,
2.063794966111572e-16,
4.733497293343304e-17,
9.83069471945082e-18,
1.856283059618826e-18,
3.182943136069368e-19,
4.947769946006027e-20,
6.419021574634739e-21,
7.889204642718386e-10,
-1.318301743783704e-14,
-1.517728436022797e-14,
-1.164865030924483e-14,
-6.7051038782025e-15,
-3.087447645147093e-15,
-1.18457030027711e-15,
-3.894682200577569e-16,
-1.119913655412506e-16,
-2.859764630017673e-17,
-6.559748009672524e-18,
-1.362610903656053e-18,
-2.573946513597877e-19,
-4.417792184413362e-20,
-6.88244018812694e-21,
-8.905029341147273e-22,
-1.026885498910619e-10,
1.677618002179066e-15,
1.931401078610805e-15,
1.482362094061734e-15,
8.53266691103119e-16,
3.928982205503985e-16,
1.507452570544122e-16,
4.956322531980955e-17,
1.425218683660726e-17,
3.639536254398547e-18,
8.34915311013534e-19,
1.734683218922945e-19,
3.277043416501024e-20,
5.611341711403803e-21,
8.885697560355829e-22,
1.346389162826731e-22,
// [{0,0.0001},{2.,0.001}]: m=32
0.00583360793564153,
-1.3898736465211e-7,
-1.60011697092318e-7,
-1.228082665066503e-7,
-7.06880772215192e-8,
-3.25474963109111e-8,
-1.248629127888185e-8,
-4.10443948771019e-9,
-1.179735136096701e-9,
-3.0099923041284e-10,
-6.89267074955671e-11,
-1.426870224060647e-11,
-2.67656262853504e-12,
-4.52519219622631e-13,
-6.78263761373372e-14,
-8.05087906397904e-15,
-0.01130888486575858,
2.60915618533728e-7,
3.00383996160654e-7,
2.305437035867572e-7,
1.327006480251713e-7,
6.11007981054061e-8,
2.344053952884007e-8,
7.70544450800773e-9,
2.214867675322547e-9,
5.65155112456383e-10,
1.294399789263548e-10,
2.680556965066161e-11,
5.03204872579334e-12,
8.52132470515404e-13,
1.282751368517413e-13,
1.54004715127962e-14,
0.01097189132908067,
-2.4537892537513e-7,
-2.82497271397548e-7,
-2.168159858001424e-7,
-1.247993179456338e-7,
-5.74630032479215e-8,
-2.204517650848179e-8,
-7.24690821459691e-9,
-2.083152447219539e-9,
-5.31590814603828e-10,
-1.217732446020154e-10,
-2.522655502428433e-11,
-4.73896385396954e-12,
-8.0371351738132e-13,
-1.214717228566864e-13,
-1.473630084123808e-14,
-0.00710292391015866,
1.541259026043006e-7,
1.774405587645728e-7,
1.361853749853287e-7,
7.83885170080617e-8,
3.609364039313622e-8,
1.384714403166682e-8,
4.55205940738598e-9,
1.308558987053754e-9,
3.339519772973968e-10,
7.65116445661695e-11,
1.585527610222928e-11,
2.980476471047018e-12,
5.061936392773364e-13,
7.6790594794911e-14,
9.4052576984904e-15,
0.003451575553729912,
-7.27314181282769e-8,
-8.37335626030589e-8,
-6.42654636193911e-8,
-3.699138772927619e-8,
-1.703259684350942e-8,
-6.53453064329868e-9,
-2.148177362801691e-9,
-6.17549244838098e-10,
-1.576139196713583e-10,
-3.611628497505653e-11,
-7.48653952154992e-12,
-1.40819237652669e-12,
-2.3947908431632e-13,
-3.645587053533522e-14,
-4.504550474909262e-15,
-0.001342860156620028,
2.75019456485897e-8,
3.1662205940715e-8,
2.430075220003233e-8,
1.39876140364752e-8,
6.44059175284833e-9,
2.470945019293574e-9,
8.12318570033805e-10,
2.335301668534917e-10,
5.96068759243959e-11,
1.3660483770892e-11,
2.832488915698163e-12,
5.330919832223119e-13,
9.07710544350885e-14,
1.38630101603539e-14,
1.726920355697836e-15,
0.0004357001035646755,
-8.67940738302649e-9,
-9.99235939515787e-9,
-7.66914658948712e-9,
-4.41440173342358e-9,
-2.032618003261406e-9,
-7.79824086703227e-10,
-2.563699293380937e-10,
-7.37051766189178e-11,
-1.881395285774681e-11,
-4.31228583304949e-12,
-8.94389581426721e-13,
-1.684221415308055e-13,
-2.871125352656151e-14,
-4.398287607822925e-15,
-5.52040119946931e-16,
-0.0001212566146948774,
2.35126244780518e-9,
2.706944123093707e-9,
2.07758454327505e-9,
1.1958710788378e-9,
5.50642797414253e-10,
2.112585101984246e-10,
6.94530625863398e-11,
1.996805793570667e-11,
5.097356523842111e-12,
1.168495655400781e-12,
2.424135497354807e-13,
4.567247416295388e-14,
7.79446122114496e-15,
1.197451882135691e-15,
1.513513361185737e-16,
0.00002954766962750372,
-5.58108628463444e-10,
-6.42535488644994e-10,
-4.93147610524772e-10,
-2.838594706578081e-10,
-1.307045134557394e-10,
-5.014619998663393e-11,
-1.648623963418676e-11,
-4.740005403519111e-12,
-1.210078929480524e-12,
-2.774262049086898e-13,
-5.756810461453219e-14,
-1.085156885511948e-14,
-1.853855906802244e-15,
-2.855714748833016e-16,
-3.633095350942116e-17,
-6.404215381416844e-6,
1.179104302719599e-10,
1.357471737040183e-10,
1.041863894751871e-10,
5.99705732542394e-11,
2.761384674937164e-11,
1.059442479343446e-11,
3.483108663078006e-12,
1.001466419014305e-12,
2.556793199187755e-13,
5.862439704730652e-14,
1.216779903377745e-14,
2.294691504893604e-15,
3.924055085141033e-16,
6.06001324046107e-17,
7.75680050935826e-18,
1.250015591930223e-6,
-2.244755142383114e-11,
-2.584328558430534e-11,
-1.98348206552433e-11,
-1.141711061768839e-11,
-5.25710143123696e-12,
-2.016971234715269e-12,
-6.63124541874e-13,
-1.906672030990187e-13,
-4.868086949410526e-14,
-1.116317249364497e-14,
-2.317476880864762e-15,
-4.372390785852712e-16,
-7.48401240800782e-17,
-1.15853985683075e-17,
-1.491415694895873e-18,
-2.219336476985405e-7,
3.88961942935159e-12,
4.47802004626228e-12,
3.436900238282841e-12,
1.978315439639657e-12,
9.10934299470899e-13,
3.494967467805516e-13,
1.149063440143641e-13,
3.303968220353922e-14,
8.43606995148303e-15,
1.934700323700533e-15,
4.017269177786207e-16,
7.58256566616675e-17,
1.299020215697491e-17,
2.015452616413651e-18,
2.60836549393625e-19,
3.613450944765338e-8,
-6.18432565812246e-13,
-7.11985970308079e-13,
-5.46452797800536e-13,
-3.145443715719099e-13,
-1.448354034913295e-13,
-5.55691070914701e-14,
-1.827003988025718e-14,
-5.253415830807901e-15,
-1.341426875458386e-15,
-3.07668198024377e-16,
-6.389765244808284e-17,
-1.206542920917517e-17,
-2.068750812479283e-18,
-3.216586951017615e-19,
-4.183202208726242e-20,
-5.434530027095319e-9,
9.08763720028935e-14,
1.046237351852318e-13,
8.02992980349983e-14,
4.622124437364726e-14,
2.128313937713349e-14,
8.165764592255e-15,
2.684775023916698e-15,
7.72005024612314e-16,
1.971357054723003e-16,
4.521901002046592e-17,
9.39301039304701e-18,
1.774288347976196e-18,
3.044431428983201e-19,
4.744761964771463e-20,
6.223551736745592e-21,
7.716096253267283e-10,
-1.260473746638342e-14,
-1.451152976082235e-14,
-1.11376875220416e-14,
-6.41099624704402e-15,
-2.952030199571048e-15,
-1.132620449833697e-15,
-3.72391978191025e-16,
-1.070834384313655e-16,
-2.734557381285053e-17,
-6.273098550986302e-18,
-1.303305193883474e-18,
-2.46280956663707e-19,
-4.228562950338001e-20,
-6.601117781199816e-21,
-8.762259534700636e-22,
-1.004834827722538e-10,
1.605600526725581e-15,
1.848489699620238e-15,
1.418728027726353e-15,
8.16639165559002e-16,
3.760335574851375e-16,
1.442754565030385e-16,
4.74365263649667e-17,
1.364092801175869e-17,
3.483589026678746e-18,
7.99200786134944e-19,
1.660635683391037e-19,
3.140436759905749e-20,
5.415831169436531e-21,
8.30644387090291e-22,
8.842133370802922e-23,
// [{0,0.0001},{2.,0.001}]: m=33
0.00565444243287929,
-1.30457809266864e-7,
-1.50191998080327e-7,
-1.152718517933786e-7,
-6.63503240125856e-8,
-3.0550399052703e-8,
-1.172026976442004e-8,
-3.85272225400386e-9,
-1.107433837661273e-9,
-2.82577556228191e-10,
-6.47199894631774e-11,
-1.34027848253308e-11,
-2.51602436289667e-12,
-4.26066235257702e-13,
-6.41375684258707e-14,
-7.7002357563981e-15,
-0.01097189132908067,
2.4537892537513e-7,
2.82497271397548e-7,
2.168159858001423e-7,
1.247993179456337e-7,
5.74630032479215e-8,
2.204517650848178e-8,
7.24690821459691e-9,
2.083152447219539e-9,
5.31590814603828e-10,
1.217732446020154e-10,
2.522655502428432e-11,
4.73896385396954e-12,
8.0371351738132e-13,
1.214717228566863e-13,
1.473630084123807e-14,
0.010654385865238,
-2.31188853906451e-7,
-2.66160838146859e-7,
-2.042780624779931e-7,
-1.175827755120925e-7,
-5.41404605897043e-8,
-2.077071604750023e-8,
-6.82808911107897e-9,
-1.962838480580631e-9,
-5.00927965946095e-10,
-1.147674668492543e-10,
-2.378291415334393e-11,
-4.47071470657053e-12,
-7.59290458916004e-13,
-1.151858921923667e-13,
-1.410788654773617e-14,
-0.00690315110746032,
1.454628362565615e-7,
1.674671252061267e-7,
1.28530927238789e-7,
7.39827754585563e-8,
3.406519368702064e-8,
1.306906128659806e-8,
4.296354725603609e-9,
1.235098489676261e-9,
3.152278393427333e-10,
7.22325699501169e-11,
1.497307904310063e-11,
2.816384753053531e-12,
4.789581686326643e-13,
7.2911741070674e-14,
9.00910094982078e-15,
0.003357150391549899,
-6.87548641214717e-8,
-7.91555148517844e-8,
-6.07518805000785e-8,
-3.496903509118669e-8,
-1.610147938212021e-8,
-6.1773625482337e-9,
-2.030796425084436e-9,
-5.83825417133707e-10,
-1.490171898109842e-10,
-3.415120942722871e-11,
-7.08122228924513e-12,
-1.332729958055738e-12,
-2.269276360877457e-13,
-3.465752540087315e-14,
-4.317300889207857e-15,
-0.001307100310670404,
2.60382221487101e-8,
2.997707818504835e-8,
2.300743976813499e-8,
1.324320520008287e-8,
6.09785400969771e-9,
2.339472260076489e-9,
7.69109788003368e-10,
2.211155298536151e-10,
5.6441858572439e-11,
1.293685749896459e-11,
2.683168744241921e-12,
5.052664245851752e-13,
8.61337605785126e-14,
1.319486282329186e-14,
1.656120359735409e-15,
0.0004243981514366063,
-8.22941856738756e-9,
-9.4743044309079e-9,
-7.27154590152402e-9,
-4.185548775967613e-9,
-1.927249790966144e-9,
-7.39404785700725e-10,
-2.430857190542404e-10,
-6.98882027755632e-11,
-1.784074783359799e-11,
-4.089734793937395e-12,
-8.4844742408166e-13,
-1.59853659571439e-13,
-2.728061427345093e-14,
-4.191081587793294e-15,
-5.29729677284637e-16,
-0.0001181906790050707,
2.232434521594607e-9,
2.570141963491809e-9,
1.972590448938984e-9,
1.135437886568375e-9,
5.22818055635877e-10,
2.005848006421149e-10,
6.59449587654498e-11,
1.89600216798439e-11,
4.840315734718216e-12,
1.109704823488388e-12,
2.302724192595044e-13,
4.340627557212933e-14,
7.41542365195344e-15,
1.142285903364477e-15,
1.453238160275795e-16,
0.00002881896915935625,
-5.30596935350961e-10,
-6.1086228066318e-10,
-4.68838751867072e-10,
-2.69867579200123e-10,
-1.24262310167746e-10,
-4.767491149202058e-11,
-1.567398895806188e-11,
-4.506598878148354e-12,
-1.150556937741038e-12,
-2.63809786277062e-13,
-5.475509555836976e-14,
-1.032611175825848e-14,
-1.765824794219781e-15,
-2.727005917103306e-16,
-3.490559258473045e-17,
-6.250072678115639e-6,
1.122376745362262e-10,
1.292163328457346e-10,
9.91740303048741e-11,
5.70855110850917e-11,
2.628548781507416e-11,
1.008484875279865e-11,
3.315620269457912e-12,
9.53335313855849e-13,
2.434041682811397e-13,
5.581582135554112e-14,
1.158737585595217e-14,
2.186193775912398e-15,
3.742003532661016e-16,
5.792695091957493e-17,
7.457060822105093e-18,
1.220635427294186e-6,
-2.139291244812678e-11,
-2.462911668627326e-11,
-1.89029562470341e-11,
-1.088073775952922e-11,
-5.010139955512017e-12,
-1.922232609309623e-12,
-6.31985057141301e-13,
-1.817182995853573e-13,
-4.639839685252865e-14,
-1.064085456993322e-14,
-2.20949864476094e-15,
-4.170411991545859e-16,
-7.14460803603202e-17,
-1.10850164807691e-17,
-1.434656254269139e-18,
-2.168370219076691e-7,
3.71106393295158e-12,
4.27245523876187e-12,
3.279130793096716e-12,
1.887504537385884e-12,
8.69122153635768e-13,
3.334567446751688e-13,
1.096340822358036e-13,
3.152447576744501e-14,
8.0495778933892e-15,
1.84624244417663e-15,
3.834344069310314e-16,
7.24017455555562e-17,
1.241404117143034e-17,
1.930194692308556e-18,
2.510690822331963e-19,
3.532329495131586e-8,
-5.90678810407811e-13,
-6.80034007467917e-13,
-5.2192987890127e-13,
-3.004291328225937e-13,
-1.383362821903562e-13,
-5.30758876412203e-14,
-1.745051742782622e-14,
-5.017883061546433e-15,
-1.281343887664866e-15,
-2.939147726064453e-16,
-6.105269254782537e-17,
-1.153260048656003e-17,
-1.978962162533116e-18,
-3.083214946930154e-19,
-4.029795117263016e-20,
-5.315202300845629e-9,
8.68874504931298e-14,
1.000314218875428e-13,
7.6774724362815e-14,
4.419251747127375e-14,
2.034904262682503e-14,
7.80741951460386e-15,
2.566984802617933e-15,
7.38150663548082e-16,
1.884990679732928e-16,
4.324174058040319e-17,
8.98388103609688e-18,
1.697636931109211e-18,
2.915263310465216e-19,
4.550073461025896e-20,
5.980062068000155e-21,
7.550418584454743e-10,
-1.206367597807483e-14,
-1.38886232522942e-14,
-1.065960990837231e-14,
-6.13581659670892e-15,
-2.825327342042352e-15,
-1.084013358046666e-15,
-3.564142609138074e-16,
-1.024910906551881e-16,
-2.617393426528318e-17,
-6.004828828107985e-18,
-1.247777571830412e-18,
-2.358670831938373e-19,
-4.053691526347528e-20,
-6.34151145524823e-21,
-8.339968148207758e-22,
-9.83710889593033e-11,
1.538121261614288e-15,
1.770802976883879e-15,
1.359103800723468e-15,
7.82319621362775e-16,
3.602315125221604e-16,
1.382132616965489e-16,
4.544378146999976e-17,
1.306815025954792e-17,
3.337446607156179e-18,
7.65740964898188e-19,
1.591421473181057e-19,
3.008668770671781e-20,
5.179009669256277e-21,
8.176172266714431e-22,
1.018062241454387e-22,
// [{0,0.0001},{2.,0.001}]: m=34
0.00548594566454033,
-1.22689462687565e-7,
-1.41248635698774e-7,
-1.084079929000712e-7,
-6.23996589728169e-8,
-2.87315016239607e-8,
-1.102258825424089e-8,
-3.62345410729845e-9,
-1.041576223609769e-9,
-2.65795407301914e-10,
-6.08866223010077e-11,
-1.261327751214216e-11,
-2.36948192698477e-12,
-4.0185675869066e-13,
-6.07358614283432e-14,
-7.36815042061903e-15,
-0.01065438586523799,
2.31188853906451e-7,
2.66160838146859e-7,
2.04278062477993e-7,
1.175827755120925e-7,
5.41404605897043e-8,
2.077071604750023e-8,
6.82808911107896e-9,
1.96283848058063e-9,
5.00927965946095e-10,
1.147674668492543e-10,
2.378291415334392e-11,
4.47071470657053e-12,
7.59290458916004e-13,
1.151858921923667e-13,
1.410788654773619e-14,
0.01035472666119048,
-2.18194254384842e-7,
-2.5120068780919e-7,
-1.927963908581835e-7,
-1.109741631878344e-7,
-5.1097790530531e-8,
-1.960359192989709e-8,
-6.44453208840541e-9,
-1.852647734514391e-9,
-4.728417590141e-10,
-1.083488549251754e-10,
-2.245961856465095e-11,
-4.224577129580298e-12,
-7.18437252948996e-13,
-1.093676116060108e-13,
-1.351365142473139e-14,
-0.00671430078310028,
1.375097282429507e-7,
1.583110297035773e-7,
1.215037610001636e-7,
6.99380701823771e-8,
3.220295876424216e-8,
1.235472509646807e-8,
4.06159285016909e-9,
1.167650834267477e-9,
2.980343796219844e-10,
6.83024188544611e-11,
1.416244457849102e-11,
2.665459916111621e-12,
4.538552721755184e-13,
6.93150508017507e-14,
8.63460177841374e-15,
0.003267750776675843,
-6.50955553717727e-8,
-7.4942695462618e-8,
-5.75185994203353e-8,
-3.31080130002059e-8,
-1.524463502424369e-8,
-5.848680650191e-9,
-1.922774470008346e-9,
-5.52788824634017e-10,
-1.41104646431092e-10,
-3.234214374741023e-11,
-6.70792186060454e-12,
-1.263166061462878e-12,
-2.153344014462839e-13,
-3.298715705824069e-14,
-4.140300899325921e-15,
-0.001273194454286683,
2.46882557018085e-8,
2.842291329231597e-8,
2.181463770425912e-8,
1.25566463277227e-8,
5.78174937281548e-9,
2.218214357070349e-9,
7.29257157152257e-10,
2.096646083236804e-10,
5.35222435000254e-11,
1.226920438163583e-11,
2.545342272208339e-12,
4.795609787073987e-13,
8.18418428191114e-14,
1.257324476317559e-14,
1.589189031888406e-15,
0.0004136673765221914,
-7.81352082564775e-9,
-8.99549687229804e-9,
-6.90406657134532e-9,
-3.974032603023199e-9,
-1.829863194741174e-9,
-7.02046802253389e-10,
-2.308073556810427e-10,
-6.63600758800198e-11,
-1.694110507165833e-11,
-3.883966882242453e-12,
-8.05953467415233e-13,
-1.519219645040078e-13,
-2.595398278185019e-14,
-3.998000661521482e-15,
-5.086333563583693e-16,
-0.0001152758771222875,
2.122387748826027e-9,
2.443449131197709e-9,
1.875355014026632e-9,
1.079470320575572e-9,
4.97049242409284e-10,
1.906996466350346e-10,
6.26959560515399e-11,
1.802639557565596e-11,
4.602227767070191e-12,
1.055239148803968e-12,
2.190203830015407e-13,
4.130444717807788e-14,
7.06329920231546e-15,
1.090802371057186e-15,
1.396223702931401e-16,
0.00002812532699565123,
-5.05069534575367e-10,
-5.81473496841437e-10,
-4.46283135631773e-10,
-2.568847994568648e-10,
-1.182846949716522e-10,
-4.53818193123225e-11,
-1.492029118781129e-11,
-4.290008905233811e-12,
-1.095318755447396e-12,
-2.51171195683726e-13,
-5.214319126447164e-14,
-9.83787197242724e-15,
-1.683901588849564e-15,
-2.606712818682106e-16,
-3.355677109053676e-17,
-6.103171963682859e-6,
1.069644830571531e-10,
1.231454922692527e-10,
9.45147112675624e-11,
5.44036485232405e-11,
2.505068123252534e-11,
9.61115593117411e-12,
3.159922946187297e-12,
9.08590825144613e-13,
2.319918124356911e-13,
5.320423342217504e-14,
1.104748502870382e-14,
2.08520444767774e-15,
3.572301336958219e-16,
5.542503818992122e-17,
7.17327783955967e-18,
1.192603978081331e-6,
-2.041085699258415e-11,
-2.349850998559111e-11,
-1.803522409939869e-11,
-1.038127768252489e-11,
-4.78017310064821e-12,
-1.83401257748494e-12,
-6.02987610703812e-13,
-1.733846622761642e-13,
-4.427269004822675e-14,
-1.015433610757899e-14,
-2.108889795747507e-15,
-3.98209721132484e-16,
-6.82772348428014e-17,
-1.061605600032197e-17,
-1.380893638043731e-18,
-2.119691179460536e-7,
3.54452211370514e-12,
4.08072125741089e-12,
3.131976237972411e-12,
1.802803295698656e-12,
8.30122909282203e-13,
3.184956952614907e-13,
1.04716377940972e-13,
3.011111543138409e-14,
7.68903819402341e-15,
1.76371232786124e-15,
3.663626534929272e-16,
6.92043903877343e-17,
1.187528441155831e-17,
1.850175013138649e-18,
2.418192668642951e-19,
3.454768793690074e-8,
-5.64751530806047e-13,
-6.50184788677731e-13,
-4.990207775721e-13,
-2.872427691687957e-13,
-1.322648196303008e-13,
-5.074670844284393e-14,
-1.668490196516624e-14,
-4.797835736723724e-15,
-1.225207272492912e-15,
-2.810629137551513e-16,
-5.839347172665795e-17,
-1.103426617604524e-17,
-1.894888611464334e-18,
-2.957940093328427e-19,
-3.883347978654669e-20,
-5.201000002639212e-9,
8.31554144495192e-14,
9.57348501317395e-14,
7.34771272340767e-14,
4.229443325303116e-14,
1.947509476465262e-14,
7.47214645770544e-15,
2.456776693350709e-15,
7.06474455407132e-16,
1.804175721636978e-16,
4.139132836866498e-17,
8.6008892802564e-18,
1.625818130115752e-18,
2.794314310779572e-19,
4.369815974364809e-20,
5.728701796250186e-21,
7.391703418808486e-10,
-1.155670733953493e-14,
-1.330496644964211e-14,
-1.021165581046693e-14,
-5.87797542495381e-15,
-2.706607296846906e-15,
-1.038468362210125e-15,
-3.4144285664999e-16,
-9.81878451058025e-17,
-2.507598378119938e-17,
-5.753398437916086e-18,
-1.195724412305467e-18,
-2.261035964970586e-19,
-3.888711327598988e-20,
-6.091896293691551e-21,
-8.043367892676701e-22,
-9.63456485650123e-11,
1.474806882832071e-15,
1.697911120818746e-15,
1.303159561258611e-15,
7.50118208090833e-16,
3.454046816722612e-16,
1.3252514920945e-16,
4.357397594149765e-17,
1.253069466943444e-17,
3.200306805126146e-18,
7.34329451033069e-19,
1.526509605215897e-19,
2.88757410090761e-20,
4.93804997909688e-21,
7.755121323782658e-22,
1.359059756996912e-22,
// [{0,0.0001},{2.,0.001}]: m=35
0.005327192932619,
-1.15594426953225e-7,
-1.3308041907343e-7,
-1.021390312389965e-7,
-5.87913877560463e-8,
-2.70702302948522e-8,
-1.038535802375011e-8,
-3.41404455553948e-9,
-9.81419240290315e-10,
-2.50463982973048e-10,
-5.73837334246271e-11,
-1.189145707667196e-11,
-2.235357353285264e-12,
-3.79645229458002e-13,
-5.75929460961833e-14,
-7.0539432738681e-15,
-0.01035472666119047,
2.18194254384842e-7,
2.5120068780919e-7,
1.927963908581835e-7,
1.109741631878344e-7,
5.1097790530531e-8,
1.960359192989708e-8,
6.44453208840541e-9,
1.852647734514391e-9,
4.728417590141e-10,
1.083488549251753e-10,
2.245961856465095e-11,
4.2245771295803e-12,
7.18437252948996e-13,
1.093676116060108e-13,
1.351365142473141e-14,
0.01007145117465042,
-2.06264592364426e-7,
-2.37466544555366e-7,
-1.822556415002454e-7,
-1.049071052735657e-7,
-4.83044381463632e-8,
-1.85320876447021e-8,
-6.09238927525364e-9,
-1.751476251401216e-9,
-4.47051569432977e-10,
-1.024536282816917e-10,
-2.124366686773653e-11,
-3.998189874167432e-12,
-6.80782908263278e-13,
-1.039725762026259e-13,
-1.295190266762017e-14,
-0.00653550155335216,
1.301911107435526e-7,
1.498853909252441e-7,
1.150371988406768e-7,
6.62160260004154e-8,
3.048927004848904e-8,
1.169736130038263e-8,
3.845548940016901e-9,
1.105577649268093e-9,
2.822092928621993e-10,
6.4684287494824e-11,
1.341584372120981e-11,
2.526332122925895e-12,
4.306688028925929e-13,
6.59743141164853e-14,
8.28060179865131e-15,
0.003182986135716543,
-6.17206392545189e-8,
-7.10572832307872e-8,
-5.45365942606457e-8,
-3.139161581930553e-8,
-1.445437343203815e-8,
-5.54553589267566e-9,
-1.823142892880572e-9,
-5.24161520809181e-10,
-1.338056087500583e-10,
-3.067301095408839e-11,
-6.36335568052061e-12,
-1.198902446768448e-12,
-2.046046070477388e-13,
-3.143311190793912e-14,
-3.972972579753571e-15,
-0.001241002129543905,
2.344056247660336e-8,
2.698649061650281e-8,
2.071219971373562e-8,
1.192209780889672e-8,
5.48958958414392e-9,
2.106140406729626e-9,
6.92422067033086e-10,
1.990802276371714e-10,
5.08233152142374e-11,
1.16519006465581e-11,
2.417860402210531e-12,
4.557658935053707e-13,
7.78619483443627e-14,
1.199400198438069e-14,
1.525900069083069e-15,
0.0004034655699323622,
-7.42835712095509e-9,
-8.55207195926565e-9,
-6.56374254914975e-9,
-3.778146122047051e-9,
-1.739672348447481e-9,
-6.67448763228372e-10,
-2.194358461822805e-10,
-6.30923845153396e-11,
-1.610779718488461e-11,
-3.693337020845761e-12,
-7.66571340511694e-13,
-1.445655651245144e-13,
-2.472154720915291e-14,
-3.817808298751785e-15,
-4.886782951640351e-16,
-0.0001125013084576853,
2.020278145424275e-9,
2.325893995566075e-9,
1.785132548820907e-9,
1.027539201450278e-9,
4.731387815548012e-10,
1.815272778893464e-10,
5.96811649616962e-11,
1.716003568145636e-11,
4.38127503724718e-12,
1.004684786282016e-12,
2.085727657949707e-13,
3.935148802917933e-14,
6.7356063800853e-15,
1.042685131285132e-15,
1.342270843568904e-16,
0.00002746427378180863,
-4.81340172952658e-10,
-5.54154714285399e-10,
-4.25316199993135e-10,
-2.448164179453789e-10,
-1.127280653579386e-10,
-4.325020161798761e-11,
-1.421965323407178e-11,
-4.088658706314605e-12,
-1.043963154213739e-12,
-2.394190499989104e-13,
-4.971368254980176e-14,
-9.3834199992967e-15,
-1.607535588772627e-15,
-2.494126708187084e-16,
-3.227976081753798e-17,
-5.963014821979679e-6,
1.020542089732919e-10,
1.174924624428251e-10,
9.01760533514593e-11,
5.19063497626029e-11,
2.390084770614097e-11,
9.17005605898773e-12,
3.014935808323706e-12,
8.66922665711712e-13,
2.213632853321239e-13,
5.077164269569586e-14,
1.054444111421876e-14,
1.991047117454505e-15,
3.413859126846588e-16,
5.30802395106317e-17,
6.904466893288373e-18,
1.165830499220511e-6,
-1.949487677474608e-11,
-2.244397284411149e-11,
-1.72258738589078e-11,
-9.91542074543104e-12,
-4.565677207061325e-12,
-1.751726786664941e-12,
-5.75940230821036e-13,
-1.656111786270218e-13,
-4.228972124766332e-14,
-9.70042036958316e-15,
-2.014995103345022e-15,
-3.806242432351091e-16,
-6.531414379468141e-17,
-1.017597085815983e-17,
-1.329941100940565e-18,
-2.073148837617594e-7,
3.38894031572434e-12,
3.90160508324728e-12,
2.994505618915789e-12,
1.723675897806908e-12,
7.93689890502554e-13,
3.045189921293463e-13,
1.001221500172377e-13,
2.879067765585627e-14,
7.35217925308901e-15,
1.68659218170129e-15,
3.504054550539684e-16,
6.62140412160026e-17,
1.137080577913134e-17,
1.77499336436268e-18,
2.330153176678666e-19,
3.380539528721777e-8,
-5.40493964628032e-13,
-6.22257841434509e-13,
-4.7758698657118e-13,
-2.749055615477873e-13,
-1.265843149836898e-13,
-4.856749359637901e-14,
-1.596856898819229e-14,
-4.591946059330708e-15,
-1.172678982137403e-15,
-2.690355447354638e-16,
-5.590417168631965e-17,
-1.056751862767078e-17,
-1.816063243405977e-18,
-2.840078684278922e-19,
-3.74319056212012e-20,
-5.0915999812572e-9,
7.96586781674437e-14,
9.17091693788621e-14,
7.0387434570367e-14,
4.051601457720633e-14,
1.865624213041772e-14,
7.15800715911008e-15,
2.35351388087508e-15,
6.76793548259223e-16,
1.728446527194152e-16,
3.965714111763594e-17,
8.24188898668497e-18,
1.558471309261488e-18,
2.680013557754902e-19,
4.198502578119016e-20,
5.570266212180227e-21,
7.239521053037385e-10,
-1.108102717401624e-14,
-1.275733081177931e-14,
-9.79134741100275e-15,
-5.63604659216153e-15,
-2.595213492768544e-15,
-9.95733639940306e-16,
-3.273950270468835e-16,
-9.41499426947132e-17,
-2.404567077582436e-17,
-5.517429221329388e-18,
-1.146867165541541e-18,
-2.169325278447977e-19,
-3.731999843243253e-20,
-5.857771751036021e-21,
-7.904052572835582e-22,
-9.44019027694796e-11,
1.415321668219667e-15,
1.629427630695106e-15,
1.250598680071864e-15,
7.19864196398334e-16,
3.31474463488696e-16,
1.271809719360828e-16,
4.181720368836646e-17,
1.202571410590963e-17,
3.071451453257124e-18,
7.048160724508659e-19,
1.465226560030315e-19,
2.772199518583565e-20,
4.784279169291607e-21,
7.525082761274235e-22,
8.756155116559947e-23,
// [{0,0.0001},{2.,0.001}]: m=36
0.00517736333059524,
-1.09097127192421e-7,
-1.25600343904595e-7,
-9.63981954290917e-8,
-5.54870815939172e-8,
-2.55488952652655e-8,
-9.80179596494854e-9,
-3.22226604420271e-9,
-9.26323867257195e-10,
-2.3642087950705e-10,
-5.41744274625877e-11,
-1.122980928232547e-11,
-2.112288564790149e-12,
-3.59218626474498e-13,
-5.46838058030054e-14,
-6.7568257123657e-15,
-0.01007145117465042,
2.06264592364426e-7,
2.37466544555366e-7,
1.822556415002454e-7,
1.049071052735657e-7,
4.83044381463632e-8,
1.85320876447021e-8,
6.09238927525363e-9,
1.751476251401215e-9,
4.47051569432977e-10,
1.024536282816916e-10,
2.124366686773652e-11,
3.99818987416743e-12,
6.80782908263278e-13,
1.039725762026259e-13,
1.295190266762013e-14,
0.00980325233002824,
-1.95286666115329e-7,
-2.248280863878663e-7,
-1.725557982610152e-7,
-9.93240390006231e-8,
-4.57339050727336e-8,
-1.754604195057395e-8,
-5.76832341002535e-9,
-1.65836647390214e-9,
-4.23313939293299e-10,
-9.7026431242236e-11,
-2.012376558181472e-11,
-3.789498184388844e-12,
-6.46003204338889e-13,
-9.89614711747279e-14,
-1.24209026979771e-14,
-0.00636597227143355,
1.234412785090445e-7,
1.421145664615821e-7,
1.090731885212974e-7,
6.27832316386145e-8,
2.890874686407789e-8,
1.109107178535192e-8,
3.646285785761345e-9,
1.048323041618419e-9,
2.676112175001314e-10,
6.13460219081802e-11,
1.272671136104193e-11,
2.39780489353703e-12,
4.092092140954962e-13,
6.28662238158817e-14,
7.94594515951215e-15,
0.003102505323859601,
-5.86014061915061e-8,
-6.74662265412544e-8,
-5.1780499284337e-8,
-2.980524452224064e-8,
-1.372397396035926e-8,
-5.26535101682386e-9,
-1.731055167582647e-9,
-4.97700569092909e-10,
-1.270582880355885e-10,
-2.91297516163941e-11,
-6.04465100552608e-12,
-1.13941473376338e-12,
-1.946548708609077e-13,
-2.998500496095225e-14,
-3.814750172697401e-15,
-0.001210396709774866,
2.228507136253881e-8,
2.565621587742113e-8,
1.969122764716081e-8,
1.133443836597512e-8,
5.21901704526599e-9,
2.00234628965578e-9,
6.58307538537196e-10,
1.89277153543245e-10,
4.832339155394537e-11,
1.10800110623747e-11,
2.299714021501215e-12,
4.336966953671403e-13,
7.41646416265167e-14,
1.145342489608946e-14,
1.466034885299673e-15,
0.0003937545796061698,
-7.07097350904647e-9,
-8.14062898455208e-9,
-6.24796392092753e-9,
-3.59638720510726e-9,
-1.65598573545621e-9,
-6.3534547261824e-10,
-2.088840773677541e-10,
-6.00601248856199e-11,
-1.533446263049862e-11,
-3.516396752017681e-12,
-7.30004680288861e-13,
-1.377302081033694e-13,
-2.357462233023087e-14,
-3.64939795949508e-15,
-4.697947955735271e-16,
-0.0001098570955929195,
1.925360698651814e-9,
2.216618865017695e-9,
1.701264806017512e-9,
9.792656752611e-10,
4.509122630339954e-10,
1.730008070867051e-10,
5.68786131384207e-11,
1.635463488338864e-11,
4.175852631702142e-12,
9.57676203402939e-13,
1.988547309086652e-13,
3.753368013136042e-14,
6.43014237557262e-15,
9.97650686776246e-16,
1.291190465160319e-16,
0.00002683356664520639,
-4.59243939606477e-10,
-5.28716080102387e-10,
-4.05792239398234e-10,
-2.335785735383753e-10,
-1.075538144965141e-10,
-4.126525219595152e-11,
-1.356721111460682e-11,
-3.901151989131332e-12,
-9.96134782316279e-13,
-2.284723917455879e-13,
-4.744998493262356e-14,
-8.95971201291648e-15,
-1.536236608224171e-15,
-2.388610778554598e-16,
-3.10700965935236e-17,
-5.829147527910416e-6,
9.74743108886029e-11,
1.12219780194418e-10,
8.61293048037728e-11,
4.95770666052191e-11,
2.282836894180371e-11,
8.75862737481701e-12,
2.879698997643656e-12,
8.28055272973071e-13,
2.114484478406381e-13,
4.850206549712024e-14,
1.007496795051972e-14,
1.903119785019908e-15,
3.265704935484433e-16,
5.087981650663358e-17,
6.649678155128617e-18,
1.140232204409161e-6,
-1.863917668619364e-11,
-2.145883365635128e-11,
-1.646978527767893e-11,
-9.4802199554803e-12,
-4.365295557016806e-12,
-1.674854901500267e-12,
-5.506719713443453e-13,
-1.583487691670195e-13,
-4.043699663376766e-14,
-9.27625946368593e-15,
-1.927230523495518e-15,
-3.641773271327108e-16,
-6.253942439108322e-17,
-9.76246265390426e-18,
-1.281612881104947e-18,
-2.028605591762748e-7,
3.24337787256408e-12,
3.73402377514019e-12,
2.865887811036858e-12,
1.649643982460749e-12,
7.59602870751817e-13,
2.914421716020146e-13,
9.58236487219605e-14,
2.755519487654969e-14,
7.03697257273635e-15,
1.614419506843956e-15,
3.354679437882497e-16,
6.34132299054515e-17,
1.089769372087652e-17,
1.704263919366662e-18,
2.24709623952821e-19,
3.309431657269018e-8,
-5.17765808056659e-13,
-5.9609164099145e-13,
-4.57504540271774e-13,
-2.633461601977211e-13,
-1.212619202234077e-13,
-4.652564469032891e-14,
-1.529737929012478e-14,
-4.399025503447611e-15,
-1.123456387392369e-15,
-2.577636508938394e-16,
-5.357063899226421e-17,
-1.012974546805847e-17,
-1.742028244208682e-18,
-2.729070371035504e-19,
-3.611997575140966e-20,
-4.986705681842181e-9,
7.6377875736635e-14,
8.79320846089247e-14,
6.74885355520083e-14,
3.884741309240128e-14,
1.78879507061128e-14,
6.86326263466018e-15,
2.25662500511453e-15,
6.48943872893958e-16,
1.657385430346956e-16,
3.802965552222764e-17,
7.90485100194221e-18,
1.495215054239347e-18,
2.573734273472994e-19,
4.037634742064088e-20,
5.289175648904328e-21,
7.093476419052711e-10,
-1.063411354925037e-14,
-1.224281295971217e-14,
-9.39645644209512e-15,
-5.408747585950356e-15,
-2.490555478416746e-15,
-9.5558272557102e-16,
-3.141963624096826e-16,
-9.03560154208755e-17,
-2.307755676051972e-17,
-5.295679109734162e-18,
-1.100934534472172e-18,
-2.08308075130643e-19,
-3.586619911819267e-20,
-5.636552265357878e-21,
-7.556416101570611e-22,
-9.25350082956573e-11,
1.359363043847093e-15,
1.565004167470815e-15,
1.201153815594988e-15,
6.9140371343866e-16,
3.183700164724558e-16,
1.2215355844101e-16,
4.016453826775056e-17,
1.155064592386001e-17,
2.950213739527524e-18,
6.77044068700084e-19,
1.408002902197823e-19,
2.664239902867414e-20,
4.514468213519474e-21,
7.229472749159727e-22,
1.796078090826229e-22
}
,{
// [{0,0.001},{2.,0.01}]: m=-1
14.03862538880742,
-17.99184688665234,
10.52131914011945,
-3.986281353900659,
1.156130699819357,
-0.2665104140001246,
0.05041846550396862,
-0.00853116584717116,
0.001192502862570744,
-0.0001480152267433812,
0.0000214116735527774,
-8.92285039910528e-7,
2.838831701096234e-7,
-4.83222081845451e-8,
-2.068891432867252e-8,
-6.073251783727989e-9,
-1.309802877156762,
0.1949048538318667,
0.0940960218849192,
0.02351688562053119,
0.000562453753135497,
-0.002075634189140562,
-0.000916943888694243,
-0.0001886537503730247,
4.59058669629946e-6,
0.00001868009583390829,
7.398867769372037e-6,
1.487641031800073e-6,
-3.6649796946283e-9,
-1.257615566864204e-7,
-5.245803587512776e-8,
-1.080585414876466e-8,
0.3758100602999355,
-0.00680078781236287,
-0.00714486458520635,
-0.004747216007574748,
-0.002153002510429176,
-0.0006394264610965363,
-0.0000766541849658829,
0.0000381733324376373,
0.00002853744044005544,
9.94461473241798e-6,
1.788119377571694e-6,
-1.679373779207748e-7,
-2.564647872360895e-7,
-1.023043442770554e-7,
-2.08733874196383e-8,
-8.7685352923385e-11,
-0.1333184064374121,
0.000853539174873315,
0.000969274326798154,
0.000724452969274372,
0.000396064683639912,
0.0001646941475476493,
0.00005105895293391665,
9.89524429624485e-6,
-4.1663849794696e-7,
-1.379074416494112e-6,
-7.08498315568304e-7,
-2.290857305346724e-7,
-4.504157603542249e-8,
8.3534781805035e-10,
5.779762616591709e-9,
2.571158873518976e-9,
0.0444176662423345,
-0.0001619498253810516,
-0.0001854874957856914,
-0.0001409008388257598,
-0.0000794442472459729,
-0.00003508250777760183,
-0.00001234298323838987,
-3.353581092636681e-6,
-5.829385981592981e-7,
2.94105695920809e-8,
7.84485061561566e-8,
4.065147862547897e-8,
1.432936902217529e-8,
3.626244718787234e-9,
3.715617101411353e-10,
-1.545078776154193e-10,
-0.01321845854675028,
0.0000331202948807779,
0.0000380158851877677,
0.00002900199051936135,
0.00001649306270249414,
7.41098580287713e-6,
2.704323408441653e-6,
7.99318682700916e-7,
1.795441190967325e-7,
2.115164001982556e-8,
-5.83334212784193e-9,
-5.27794578343375e-9,
-2.342310612114397e-9,
-7.74955554609939e-10,
-1.921965517644644e-10,
-2.672645496594845e-11,
0.003496218567243741,
-6.62560767208654e-6,
-7.61194086330313e-6,
-5.81776353958239e-6,
-3.320725931886076e-6,
-1.503361924083868e-6,
-5.572130676090911e-7,
-1.704584559853922e-7,
-4.179856462639555e-8,
-7.07058306429931e-9,
-2.2694523010571e-11,
6.28425216009112e-10,
3.414622745650076e-10,
1.280006110951583e-10,
3.920791488625922e-11,
8.67833592565576e-12,
-0.000826553775152415,
1.255066758606127e-6,
1.44262636471247e-6,
1.10369677811125e-6,
6.31249972206742e-7,
2.869483619778084e-7,
1.072549853833872e-7,
3.341010806561429e-8,
8.55215849358072e-9,
1.653186239762131e-9,
1.409232135448479e-10,
-6.67754883133201e-11,
-4.7325546204536e-11,
-1.947574233827819e-11,
-6.611672527568827e-12,
-1.68833300779283e-12,
0.0001760683576778132,
-2.225934314975602e-7,
-2.559382234913965e-7,
-1.959309105409507e-7,
-1.122020059416475e-7,
-5.113366311339552e-8,
-1.921254733199561e-8,
-6.051205660757165e-9,
-1.588463118557195e-9,
-3.290634844584053e-10,
-4.088067868601598e-11,
5.59282383152318e-12,
6.22063621361842e-12,
2.800471195242041e-12,
1.017286217334015e-12,
2.791336848813225e-13,
-0.00003406553149430204,
3.68495603431325e-8,
4.23786942953486e-8,
3.245641251565679e-8,
1.860243539832031e-8,
8.4923158332529e-9,
3.202110213961155e-9,
1.016028937475209e-9,
2.711357582540391e-10,
5.858833956447516e-11,
8.6074715138942e-12,
-1.90937043011569e-13,
-7.68104599914526e-13,
-3.813046124738391e-13,
-1.461388473418256e-13,
-4.19651735542427e-14,
6.03076417011802e-6,
-5.69658335724742e-9,
-6.55234185291226e-9,
-5.0197640046382e-9,
-2.87886346782076e-9,
-1.315887015065654e-9,
-4.974287480069884e-10,
-1.586702112493734e-10,
-4.283444544760099e-11,
-9.52182952531167e-12,
-1.539734044629471e-12,
-5.48056577097415e-14,
8.82753683979391e-14,
4.91120738723659e-14,
1.974036597947807e-14,
5.85981426263239e-15,
-9.83342815177743e-7,
8.23961394123118e-10,
9.47849579452735e-10,
7.26318676210783e-10,
4.167423450377811e-10,
1.90666011179027e-10,
7.22128983484697e-11,
2.312579152520296e-11,
6.296549518117166e-12,
1.428382921128152e-12,
2.45815605681079e-13,
1.730493429388834e-14,
-9.34702540816003e-15,
-5.98043618564172e-15,
-2.515390880918203e-15,
-7.668144254081758e-16,
1.485203976202731e-7,
-1.117886760450012e-10,
-1.286085289005134e-10,
-9.85681110183585e-11,
-5.65763601990017e-11,
-2.590352762895952e-11,
-9.82530159408641e-12,
-3.15616030142935e-12,
-8.64993659684182e-13,
-1.992374260716601e-13,
-3.581848912723233e-14,
-3.354122212208911e-15,
8.98458911007533e-16,
6.88564085493608e-16,
3.03013873510742e-16,
9.45046942680186e-17,
-2.08903296219955e-8,
1.426830138973631e-11,
1.641632078584207e-11,
1.258362427563939e-11,
7.22488777127179e-12,
3.309862948518327e-12,
1.256936770045144e-12,
4.047513617083618e-13,
1.115055859230054e-13,
2.598966100084625e-14,
4.82600216310768e-15,
5.321365496601009e-16,
-7.62637675484001e-17,
-7.50117261284033e-17,
-3.458101990153911e-17,
-1.100871555374491e-17,
2.788467373034197e-9,
-1.739245498447727e-12,
-2.0012014851125e-12,
-1.534170108713324e-12,
-8.8105836504686e-13,
-4.038278396370317e-13,
-1.535076016067925e-13,
-4.953211584014501e-14,
-1.370430655535695e-14,
-3.225163937476438e-15,
-6.14270046887818e-16,
-7.553259353438624e-17,
5.34126284790039e-18,
7.80894481341958e-18,
3.783928790974564e-18,
1.228250583426292e-18,
-3.439993233747174e-10,
1.97823618208958e-13,
2.276300167117335e-13,
1.745240102304167e-13,
1.002472387571922e-13,
4.596602411622979e-14,
1.748719184879384e-14,
5.651869283838907e-15,
1.569148768151971e-15,
3.72135276730484e-16,
7.228380681807004e-17,
9.58453236879396e-18,
-2.38075672943489e-19,
-7.62903117278959e-19,
-3.893907526327891e-19,
-1.286708456649543e-19,
// [{0,0.001},{2.,0.01}]: m=0
0.6549014385783812,
-0.0974524269159333,
-0.04704801094245961,
-0.0117584428102656,
-0.000281226876567748,
0.001037817094570281,
0.0004584719443471215,
0.0000943268751865124,
-2.29529334814973e-6,
-9.34004791695414e-6,
-3.699433884686018e-6,
-7.438205159000364e-7,
1.8324898473141e-9,
6.28807783432102e-8,
2.622901793756388e-8,
5.402927074382328e-9,
-0.3758100602999355,
0.00680078781236287,
0.00714486458520635,
0.004747216007574748,
0.002153002510429176,
0.0006394264610965363,
0.0000766541849658829,
-0.0000381733324376373,
-0.00002853744044005544,
-9.94461473241798e-6,
-1.788119377571694e-6,
1.679373779207748e-7,
2.564647872360895e-7,
1.023043442770554e-7,
2.08733874196383e-8,
8.7685352923385e-11,
0.1999776096561181,
-0.001280308762309972,
-0.001453911490197231,
-0.001086679453911558,
-0.000594097025459868,
-0.000247041221321474,
-0.000076588429400875,
-0.00001484286644436727,
6.2495774692044e-7,
2.068611624741168e-6,
1.062747473352456e-6,
3.436285958020085e-7,
6.756236405313373e-8,
-1.25302172707553e-9,
-8.669643924887563e-9,
-3.856738310278464e-9,
-0.0888353324846706,
0.000323899650762104,
0.0003709749915713837,
0.0002818016776515205,
0.0001588884944919462,
0.0000701650155552039,
0.00002468596647677981,
6.707162185273387e-6,
1.165877196318603e-6,
-5.88211391841601e-8,
-1.568970123123128e-7,
-8.13029572509579e-8,
-2.865873804435058e-8,
-7.25248943757447e-9,
-7.43123420282272e-10,
3.090157552308381e-10,
0.03304614636687517,
-0.0000828007372019444,
-0.0000950397129694189,
-0.0000725049762984031,
-0.00004123265675623523,
-0.00001852746450719276,
-6.76080852110411e-6,
-1.998296706752283e-6,
-4.488602977418292e-7,
-5.28791000495634e-8,
1.458335531960493e-8,
1.31948644585844e-8,
5.85577653028599e-9,
1.937388886524846e-9,
4.804913794111607e-10,
6.681613741487096e-11,
-0.01048865570165425,
0.00001987682301621856,
0.00002283582258986216,
0.00001745329061871094,
9.96217779563742e-6,
4.510085772242059e-6,
1.671639202823639e-6,
5.113753679550004e-7,
1.253956938788592e-7,
2.121174919281978e-8,
6.808356901629e-11,
-1.8852756480295e-9,
-1.024386823695039e-9,
-3.840018332853389e-10,
-1.176237446587042e-10,
-2.603500777694265e-11,
0.002892938213047577,
-4.39273365512847e-6,
-5.04919227650173e-6,
-3.862938723395572e-6,
-2.209374902727159e-6,
-1.004319266923963e-6,
-3.753924488424774e-7,
-1.169353782298517e-7,
-2.99325547275888e-8,
-5.786151839180966e-9,
-4.93231247409669e-10,
2.337142090962245e-10,
1.656394117158637e-10,
6.81650981839929e-11,
2.314085384650218e-11,
5.909165527279681e-12,
-0.0007042734323243767,
8.90373726850571e-7,
1.023752894955584e-6,
7.83723642922899e-7,
4.488080242026906e-7,
2.045346526536134e-7,
7.68501894041337e-8,
2.420482266767505e-8,
6.35385248109139e-9,
1.316253939471619e-9,
1.635227150673623e-10,
-2.23712952807286e-11,
-2.488254485413623e-11,
-1.120188478381836e-11,
-4.069144870875256e-12,
-1.116534740042635e-12,
0.0001532948915467763,
-1.658230214558017e-7,
-1.907041242274628e-7,
-1.460538562425422e-7,
-8.37109592476737e-8,
-3.8215421229098e-8,
-1.440949595500111e-8,
-4.572130216103158e-9,
-1.220110911435492e-9,
-2.636475278703058e-10,
-3.873362177855516e-11,
8.5921669852932e-13,
3.456470699770004e-12,
1.715870755891325e-12,
6.576248128955239e-13,
1.888432809337626e-13,
-0.00003015380364112873,
2.84829076080779e-8,
3.276169870307168e-8,
2.50988119250142e-8,
1.439431268669929e-8,
6.57943294135698e-9,
2.487142927639104e-9,
7.93350793314429e-10,
2.141721540262895e-10,
4.760913015205038e-11,
7.69866677411787e-12,
2.74027804587534e-13,
-4.41376845592412e-13,
-2.455603389592092e-13,
-9.87018134781142e-14,
-2.929906579048499e-14,
5.408386620085812e-6,
-4.53178823279551e-9,
-5.21317333730628e-9,
-3.994753217834638e-9,
-2.292083184238141e-9,
-1.048663192948776e-9,
-3.971709909937442e-10,
-1.271918696154082e-10,
-3.463102687909743e-11,
-7.85610715319923e-12,
-1.351986048658197e-12,
-9.51771704723149e-14,
5.14086387516886e-14,
3.289240056126495e-14,
1.383465076199551e-14,
4.217479727914378e-15,
-8.91220023781104e-7,
6.70784127740403e-10,
7.71711093075973e-10,
5.91454610397342e-10,
3.394845561988626e-10,
1.554332726715991e-10,
5.895641862125e-11,
1.893845353316824e-11,
5.190377318712984e-12,
1.195523696726076e-12,
2.149305026309232e-13,
2.012747902846824e-14,
-5.39073301320085e-15,
-4.13155699361603e-15,
-1.818176388369426e-15,
-5.670595016564783e-16,
1.357835602968489e-7,
-9.27421779630987e-11,
-1.06704035521631e-10,
-8.17919861283771e-11,
-4.696086746233232e-11,
-2.151369483296647e-11,
-8.16993117827451e-12,
-2.630832709497947e-12,
-7.24772033123335e-13,
-1.689293706477591e-13,
-3.136832884840242e-14,
-3.458787174351364e-15,
4.95717626603988e-16,
4.87571370098913e-16,
2.247737318367452e-16,
7.15554230297216e-17,
-1.923884195115636e-8,
1.202516445673264e-11,
1.383631560577541e-11,
1.060723455722623e-11,
6.09159968009174e-12,
2.79202275431359e-12,
1.061315575282712e-12,
3.424404393059056e-13,
9.47371910720108e-14,
2.229140698979339e-14,
4.243689360821298e-15,
5.208419780365343e-16,
-3.74476146118835e-17,
-5.41672296626094e-17,
-2.621998875844858e-17,
-8.50776509340608e-18,
2.584404063151491e-9,
-1.485869319071511e-12,
-1.70974780376167e-12,
-1.31086451636655e-12,
-7.52965786738086e-13,
-3.452551508243456e-13,
-1.313481960376716e-13,
-4.245196591469567e-14,
-1.178618623171419e-14,
-2.795231203956988e-15,
-5.429719249861267e-16,
-7.200756478784178e-17,
1.78169987773742e-18,
5.72773920078944e-18,
2.924002979315657e-18,
9.66546087672634e-19,
-3.205239086961994e-10,
1.709341990156899e-13,
1.966973727795767e-13,
1.508205966766589e-13,
8.66464762184025e-14,
3.974313136006349e-14,
1.513008435418909e-14,
4.896865000655594e-15,
1.36350010952173e-15,
3.254474920284934e-16,
6.423568546412815e-17,
9.0136993467315e-18,
6.7209328975768e-20,
-5.66218247145542e-19,
-3.057420636972848e-19,
-1.02831268458744e-19,
// [{0,0.001},{2.,0.01}]: m=1
0.1879050301499678,
-0.003400393906181433,
-0.003572432292603177,
-0.002373608003787374,
-0.001076501255214588,
-0.0003197132305482681,
-0.00003832709248294146,
0.00001908666621881865,
0.00001426872022002772,
4.972307366208991e-6,
8.94059688785847e-7,
-8.39686889603874e-8,
-1.282323936180448e-7,
-5.115217213852769e-8,
-1.043669370981915e-8,
-4.38426764616925e-11,
-0.1999776096561181,
0.001280308762309972,
0.001453911490197231,
0.001086679453911558,
0.000594097025459868,
0.000247041221321474,
0.000076588429400875,
0.00001484286644436727,
-6.2495774692044e-7,
-2.068611624741168e-6,
-1.062747473352456e-6,
-3.436285958020085e-7,
-6.75623640531337e-8,
1.25302172707553e-9,
8.669643924887563e-9,
3.856738310278464e-9,
0.1332529987270059,
-0.000485849476143156,
-0.000556462487357076,
-0.0004227025164772807,
-0.0002383327417379193,
-0.0001052475233328058,
-0.00003702894971516972,
-0.00001006074327791008,
-1.748815794477905e-6,
8.823170877624e-8,
2.353455184684692e-7,
1.219544358764368e-7,
4.298810706652587e-8,
1.087873415636171e-8,
1.114685130423408e-9,
-4.635236328462572e-10,
-0.0660922927337518,
0.0001656014744038895,
0.0001900794259388386,
0.000145009952596807,
0.0000824653135124708,
0.00003705492901438569,
0.00001352161704220829,
3.996593413504587e-6,
8.97720595483664e-7,
1.057582000991282e-7,
-2.91667106392096e-8,
-2.638972891716875e-8,
-1.171155306057198e-8,
-3.874777773049695e-9,
-9.60982758822323e-10,
-1.336322748297423e-10,
0.02622163925413512,
-0.0000496920575405462,
-0.0000570895564746551,
-0.0000436332265467771,
-0.00002490544448909342,
-0.00001127521443060509,
-4.179098007059078e-6,
-1.278438419887494e-6,
-3.134892346971461e-7,
-5.302937298204899e-8,
-1.7020892254062e-10,
4.71318912007376e-9,
2.560967059237598e-9,
9.60004583213347e-10,
2.940593616467602e-10,
6.508751944235648e-11,
-0.00867881463907068,
0.00001317820096534958,
0.00001514757682946395,
0.0000115888161701551,
6.62812470816331e-6,
3.012957800763555e-6,
1.126177346524257e-6,
3.508061346885263e-7,
8.97976641824793e-8,
1.735845551747399e-8,
1.479693742215226e-9,
-7.01142627290695e-10,
-4.96918235147654e-10,
-2.044952945518767e-10,
-6.94225615394481e-11,
-1.772749658181915e-11,
0.002464957013148594,
-3.11630804398318e-6,
-3.583135132351659e-6,
-2.7430327502356e-6,
-1.570828084712552e-6,
-7.15871284289085e-7,
-2.689756629150162e-7,
-8.47168793370405e-8,
-2.223848368386962e-8,
-4.60688878816266e-9,
-5.723295027381942e-10,
7.82995334821818e-11,
8.70889069894584e-11,
3.920659674337873e-11,
1.424200704807268e-11,
3.907871590153002e-12,
-0.0006131795676971241,
6.63292086573957e-7,
7.62816497773785e-7,
5.8421542563265e-7,
3.348438373713454e-7,
1.528616850910398e-7,
5.76379838865311e-8,
1.828852088596966e-8,
4.88044365175928e-9,
1.054590112925276e-9,
1.549344874030484e-10,
-3.43686675176405e-12,
-1.382588279775239e-11,
-6.86348302569993e-12,
-2.630499252806725e-12,
-7.553731241532557e-13,
0.0001356921162181695,
-1.281730841586352e-7,
-1.474276440743881e-7,
-1.129446535939795e-7,
-6.47744070507345e-8,
-2.960744821801897e-8,
-1.119214316748263e-8,
-3.570078567678943e-9,
-9.63774692492827e-10,
-2.142410855334238e-10,
-3.464400045302946e-11,
-1.23312511601396e-12,
1.986195805396911e-12,
1.10502152513536e-12,
4.441581605348246e-13,
1.318457960088209e-13,
-0.00002704191699091293,
2.265893315482153e-8,
2.606585746990578e-8,
1.997375902168236e-8,
1.146041186033058e-8,
5.243314101564126e-9,
1.985854245248203e-9,
6.35959118102009e-10,
1.731550702014707e-10,
3.928052036049371e-11,
6.7599271619993e-12,
4.75885400523616e-13,
-2.570432079263973e-13,
-1.64461980041143e-13,
-6.917324074348707e-14,
-2.108739417075984e-14,
4.901711199092292e-6,
-3.68931319998017e-9,
-4.24441158433341e-9,
-3.253000796152276e-9,
-1.867165311348114e-9,
-8.54883115460622e-10,
-3.242603465369203e-10,
-1.041615087436116e-10,
-2.854707925621386e-11,
-6.575381297192163e-12,
-1.182117959688563e-12,
-1.107011642886449e-13,
2.96490300935266e-14,
2.272356461959819e-14,
9.99997088299325e-15,
3.118827573370185e-15,
-8.1479275938672e-7,
5.56498507102803e-10,
6.40276502939369e-10,
4.90792013631044e-10,
2.817882437494446e-10,
1.290927396044635e-10,
4.902361361474045e-11,
1.578630100305855e-11,
4.348996398850257e-12,
1.013663625985573e-12,
1.882274546372094e-13,
2.07552865399871e-14,
-2.97422535768915e-15,
-2.925557352921771e-15,
-1.348716530809206e-15,
-4.293579136039243e-16,
1.250491057338889e-7,
-7.81620012987023e-11,
-8.99342473676122e-11,
-6.89456411393455e-11,
-3.959460289585789e-11,
-1.814778304318188e-11,
-6.89841218711969e-12,
-2.225817751219869e-12,
-6.157791248720784e-13,
-1.448911034344346e-13,
-2.758336557849544e-14,
-3.385379469811432e-15,
2.43414156999578e-16,
3.520833646155378e-16,
1.704275725640266e-16,
5.529947002009226e-17,
-1.782832196725241e-8,
1.027057911206476e-11,
1.181805324930748e-11,
9.06088956122573e-12,
5.20459034488577e-12,
2.386426251169908e-12,
9.07872744207794e-13,
2.934164033766186e-13,
8.1457284925948e-14,
1.931559073222961e-14,
3.750594594117506e-15,
4.966902798324169e-16,
-1.27028714909244e-17,
-3.97233336490296e-17,
-2.02550663413645e-17,
-6.692909562134478e-18,
2.408073459744274e-9,
-1.283936018516743e-12,
-1.477450788377033e-12,
-1.132857298674509e-12,
-6.50827107164744e-13,
-2.985225634757728e-13,
-1.136467814726188e-13,
-3.678200292820123e-14,
-1.024178025041167e-14,
-2.444600358756174e-15,
-4.825249271668107e-16,
-6.771768548698211e-17,
-5.0980845622796e-19,
4.2510915957599e-18,
2.29596339453104e-18,
7.724820082933403e-19,
-3.000384042114452e-10,
1.491634268653875e-13,
1.716514805640346e-13,
1.316257552179964e-13,
7.56299277040187e-14,
3.470008000521737e-14,
1.321792279706379e-14,
4.283086108907656e-15,
1.195559580265325e-15,
2.869153366684282e-16,
5.738699140112297e-17,
8.41532605632251e-18,
2.64040516007059e-19,
-4.23830148092609e-19,
-2.434146583358929e-19,
-8.335460792469668e-20,
// [{0,0.001},{2.,0.01}]: m=2
0.099988804828059,
-0.000640154381154986,
-0.000726955745098616,
-0.000543339726955779,
-0.000297048512729934,
-0.000123520610660737,
-0.00003829421470043749,
-7.42143322218364e-6,
3.1247887346022e-7,
1.034305812370584e-6,
5.313737366762278e-7,
1.718142979010043e-7,
3.378118202656687e-8,
-6.2651086353776e-10,
-4.334821962443781e-9,
-1.928369155139232e-9,
-0.1332529987270059,
0.000485849476143156,
0.000556462487357076,
0.000422702516477281,
0.0002383327417379193,
0.0001052475233328058,
0.00003702894971516972,
0.00001006074327791008,
1.748815794477905e-6,
-8.823170877624e-8,
-2.353455184684692e-7,
-1.219544358764368e-7,
-4.298810706652587e-8,
-1.087873415636171e-8,
-1.114685130423408e-9,
4.635236328462572e-10,
0.0991384391006278,
-0.0002484022116058343,
-0.000285119138908258,
-0.0002175149288952104,
-0.0001236979702687062,
-0.0000555823935215785,
-0.00002028242556331243,
-5.994890120256881e-6,
-1.346580893225497e-6,
-1.586373001486923e-7,
4.37500659588144e-8,
3.95845933757531e-8,
1.756732959085798e-8,
5.81216665957454e-9,
1.441474138233484e-9,
2.004484122446135e-10,
-0.05244327850827165,
0.000099384115081093,
0.000114179112949311,
0.0000872664530935549,
0.0000498108889781872,
0.00002255042886121034,
8.35819601411821e-6,
2.556876839775007e-6,
6.269784693942975e-7,
1.060587459640993e-7,
3.4041784508151e-10,
-9.42637824014749e-9,
-5.12193411847519e-9,
-1.920009166426695e-9,
-5.881187232935214e-10,
-1.301750388847133e-10,
0.02169703659767622,
-0.0000329455024133737,
-0.0000378689420736596,
-0.00002897204042538758,
-0.00001657031177040818,
-7.53239450190884e-6,
-2.815443366310625e-6,
-8.7701533672131e-7,
-2.244941604561965e-7,
-4.339613879368457e-8,
-3.699234355537982e-9,
1.752856568226749e-9,
1.242295587869137e-9,
5.11238236379691e-10,
1.7355640384862e-10,
4.431874145454778e-11,
-0.00739487103937806,
9.348924131918e-6,
0.00001074940539701869,
8.22909825067897e-6,
4.71248425412166e-6,
2.147613852859917e-6,
8.06926988742252e-7,
2.541506380102143e-7,
6.671545105135506e-8,
1.382066636442679e-8,
1.716988508202207e-9,
-2.34898600448425e-10,
-2.612667209684689e-10,
-1.176197902300595e-10,
-4.272602114417094e-11,
-1.172361477044261e-11,
0.002146128486952457,
-2.321522303014331e-6,
-2.669857742214556e-6,
-2.044753989719114e-6,
-1.17195343080249e-6,
-5.35015897819916e-7,
-2.017329436033455e-7,
-6.40098231010518e-8,
-1.708155278120176e-8,
-3.691065395249187e-9,
-5.422707059128584e-10,
1.20290336308318e-11,
4.83905897921113e-11,
2.402219058996146e-11,
9.2067473848311e-12,
2.64380593453865e-12,
-0.0005427684662919453,
5.12692337295341e-7,
5.89710577057999e-7,
4.5177861495908e-7,
2.590976285380547e-7,
1.184297930258707e-7,
4.476857272854348e-8,
1.428031428972802e-8,
3.855098775289641e-9,
8.56964343415949e-10,
1.385760020714667e-10,
4.93250050345162e-12,
-7.9447832196265e-12,
-4.420086102148e-12,
-1.776632643126102e-12,
-5.27383184378736e-13,
0.0001216886263016644,
-1.019651991277712e-7,
-1.172963585352544e-7,
-8.98819155367381e-8,
-5.15718533365261e-8,
-2.359491344099022e-8,
-8.93634409749801e-9,
-2.861816029472472e-9,
-7.79197815349877e-10,
-1.76762341487451e-10,
-3.041967220147703e-11,
-2.141484298051677e-12,
1.156694435946558e-12,
7.40078910037516e-13,
3.112795832504423e-13,
9.4893273740584e-14,
-0.00002450854085410496,
1.844655895033034e-8,
2.122204980904263e-8,
1.6264997759453e-8,
9.33582298163645e-9,
4.274413936584132e-9,
1.621301107387851e-9,
5.208073408908642e-10,
1.427353395437948e-10,
3.287689280655417e-11,
5.910587031635606e-12,
5.535054011546524e-13,
-1.482451713932325e-13,
-1.136178059598243e-13,
-4.999984388591667e-14,
-1.559413420266395e-14,
4.48136118433719e-6,
-3.06074223021703e-9,
-3.521521273856274e-9,
-2.699356464322727e-9,
-1.549835564389289e-9,
-7.10010170540346e-10,
-2.696299140445043e-10,
-8.68246682316446e-11,
-2.391948375704064e-11,
-5.575150805507431e-12,
-1.035251176642486e-12,
-1.141541035214523e-13,
1.63582376887644e-14,
1.609056638678354e-14,
7.41794152967276e-15,
2.361468701972372e-15,
-7.503805392208181e-7,
4.69012003053389e-10,
5.39651510631523e-10,
4.137091430087317e-10,
2.375879004873177e-10,
1.088960067680408e-10,
4.13940207022126e-11,
1.335605723414411e-11,
3.694996644591436e-12,
8.69424229933771e-13,
1.65515890825468e-13,
2.031466132136554e-14,
-1.4603662047325e-15,
-2.112597410164293e-15,
-1.022625178828033e-15,
-3.318176146354041e-16,
1.158809167862013e-7,
-6.67573738593657e-11,
-7.68157460444694e-11,
-5.88945550347913e-11,
-3.382913199850638e-11,
-1.551144690518864e-11,
-5.90104940670556e-12,
-1.907166548879679e-12,
-5.294611214283341e-13,
-1.255486211594189e-13,
-2.437830973148982e-14,
-3.228399985230435e-15,
8.2574271954257e-17,
2.581986886379645e-16,
1.316560063555634e-16,
4.350335360013502e-17,
-1.660978358461025e-8,
8.87268170804308e-12,
1.020996298346522e-11,
7.8286269233707e-12,
4.497534605258191e-12,
2.062922966145434e-12,
7.85338462670673e-13,
2.541690159058701e-13,
7.07679451645039e-14,
1.688930035667059e-14,
3.332589955267447e-15,
4.671752120791122e-16,
3.22759165084e-18,
-2.947844209544235e-17,
-1.59001363260598e-17,
-5.347624790575857e-18,
2.254197152981085e-9,
-1.120437002040585e-12,
-1.289355517304007e-12,
-9.88703525328664e-13,
-5.68092488592779e-13,
-2.606490517449079e-13,
-9.92863424721442e-14,
-3.217246874484394e-14,
-8.98051974368815e-15,
-2.155211147191724e-15,
-4.310857035509128e-16,
-6.322182190511247e-17,
-1.98720757733645e-18,
3.182391856615605e-18,
1.827980962156138e-18,
6.258490785882362e-19,
-2.820072068747347e-10,
1.312926019093877e-13,
1.510911315563204e-13,
1.158668890060079e-13,
6.6583457223875e-14,
3.055708379479337e-14,
1.164565693224936e-14,
3.777497966824955e-15,
1.056688597864467e-15,
2.547691796860498e-16,
5.153008891727403e-17,
7.827729421667651e-18,
3.89868760299631e-19,
-3.190720293457178e-19,
-1.961584950494798e-19,
-6.832579826003051e-20,
// [{0,0.001},{2.,0.01}]: m=3
0.066626499363503,
-0.000242924738071578,
-0.000278231243678538,
-0.0002113512582386403,
-0.0001191663708689596,
-0.0000526237616664029,
-0.00001851447485758486,
-5.03037163895504e-6,
-8.74407897238952e-7,
4.41158543881201e-8,
1.176727592342346e-7,
6.09772179382184e-8,
2.149405353326293e-8,
5.43936707818085e-9,
5.57342565211704e-10,
-2.317618164231286e-10,
-0.0991384391006278,
0.000248402211605834,
0.000285119138908258,
0.0002175149288952104,
0.0001236979702687062,
0.0000555823935215785,
0.00002028242556331243,
5.99489012025688e-6,
1.346580893225497e-6,
1.586373001486923e-7,
-4.37500659588144e-8,
-3.95845933757531e-8,
-1.756732959085798e-8,
-5.81216665957454e-9,
-1.441474138233484e-9,
-2.004484122446135e-10,
0.0786649177624075,
-0.0001490761726216395,
-0.0001712686694239665,
-0.0001308996796403323,
-0.0000747163334672808,
-0.00003382564329181551,
-0.00001253729402117732,
-3.835315259662511e-6,
-9.40467704091446e-7,
-1.590881189461489e-7,
-5.1062676762226e-10,
1.413956736022123e-8,
7.68290117771279e-9,
2.880013749640043e-9,
8.82178084940282e-10,
1.952625583270699e-10,
-0.04339407319535377,
0.0000658910048267481,
0.00007573788414732,
0.0000579440808507757,
0.00003314062354081666,
0.00001506478900381782,
5.6308867326213e-6,
1.754030673442637e-6,
4.489883209123977e-7,
8.67922775873703e-8,
7.3984687110762e-9,
-3.50571313645346e-9,
-2.484591175738272e-9,
-1.022476472759384e-9,
-3.471128076972407e-10,
-8.86374829090958e-11,
0.0184871775984447,
-0.00002337231032979482,
-0.00002687351349254651,
-0.00002057274562669727,
-0.00001178121063530407,
-5.36903463214975e-6,
-2.017317471855613e-6,
-6.3537659502553e-7,
-1.667886276283862e-7,
-3.455166591106662e-8,
-4.292471270505442e-9,
5.87246501121075e-10,
6.53166802421173e-10,
2.940494755751485e-10,
1.068150528604271e-10,
2.930903692610645e-11,
-0.006438385460793488,
6.96456690901503e-6,
8.00957322661148e-6,
6.13426196913266e-6,
3.515860292393284e-6,
1.605047693453236e-6,
6.05198830807554e-7,
1.920294693023494e-7,
5.124465834337939e-8,
1.107319618569288e-8,
1.626812117727409e-9,
-3.60871008942413e-11,
-1.451717693764463e-10,
-7.20665717698266e-11,
-2.762024215445497e-11,
-7.93141780360231e-12,
0.001899689632033659,
-1.794423180538589e-6,
-2.063987019708631e-6,
-1.581225152361101e-6,
-9.06841699885675e-7,
-4.145042755916875e-7,
-1.566900045503371e-7,
-4.998110001418938e-8,
-1.349284571355341e-8,
-2.999375201965456e-9,
-4.850160072521176e-10,
-1.72637517623985e-11,
2.78067412686686e-11,
1.547030135752682e-11,
6.218214250947389e-12,
1.84584114532758e-12,
-0.0004867545065454368,
4.07860797097151e-7,
4.69185434815479e-7,
3.595276626642035e-7,
2.062874136433776e-7,
9.4379653900418e-8,
3.574537644202037e-8,
1.144726413478144e-8,
3.116791266133418e-9,
7.070493670957504e-10,
1.216786890399097e-10,
8.56593722879373e-12,
-4.62677774142925e-12,
-2.960315641361636e-12,
-1.245118333805489e-12,
-3.795730952479897e-13,
0.0001102884336944808,
-8.30095152149421e-8,
-9.54992240698631e-8,
-7.31924898632167e-8,
-4.201120338614133e-8,
-1.92348627002937e-8,
-7.2958549777776e-9,
-2.34363303223233e-9,
-6.42309027448377e-10,
-1.479460175083481e-10,
-2.659764161741732e-11,
-2.490774301200008e-12,
6.67103271572996e-13,
5.11280126709746e-13,
2.24999297410687e-13,
7.017360388550426e-14,
-0.00002240679163899582,
1.530370489878031e-8,
1.760759917395204e-8,
1.349677680344852e-8,
7.74917465056092e-9,
3.550049396942206e-9,
1.348149015171025e-9,
4.341231609547693e-10,
1.195973682826228e-10,
2.787574180226696e-11,
5.176253386813935e-12,
5.707701272826863e-13,
-8.1791213591521e-14,
-8.04528190073853e-14,
-3.708969907289846e-14,
-1.180734046436469e-14,
4.127093919326896e-6,
-2.57956641070234e-9,
-2.968083761805526e-9,
-2.275400634229363e-9,
-1.306733652517972e-9,
-5.98928128973331e-10,
-2.276671488578331e-10,
-7.34583261584859e-11,
-2.032248473713305e-11,
-4.781834040017552e-12,
-9.10337559184949e-13,
-1.117306628406447e-13,
8.03201218357922e-15,
1.161928644986081e-14,
5.624438969863899e-15,
1.824997057091287e-15,
-6.953665339413735e-7,
4.00579715241071e-10,
4.60935298546185e-10,
3.533986371955613e-10,
2.029927846616358e-10,
9.30769405981702e-11,
3.54094454929226e-11,
1.144402166738456e-11,
3.177053252216159e-12,
7.53361086420407e-13,
1.462840216086912e-13,
1.937261441913712e-14,
-4.95302945407555e-16,
-1.549265476749509e-15,
-7.899846951383126e-16,
-2.610373887737727e-16,
1.079605877982377e-7,
-5.7671189627044e-11,
-6.63633306334168e-11,
-5.08849792206396e-11,
-2.92333451090669e-11,
-1.340871011586378e-11,
-5.104589712123393e-12,
-1.652062766565907e-12,
-4.599815837729392e-13,
-1.09778008558135e-13,
-2.16613315586243e-14,
-3.036558286624011e-15,
-2.09732234135375e-17,
1.916077046739952e-16,
1.033493531069104e-16,
3.47589850162533e-17,
-1.554664116349577e-8,
7.74117947143659e-12,
8.90824275878641e-12,
6.83100773099314e-12,
3.924970584004976e-12,
1.800822167731935e-12,
6.85959986791642e-13,
2.222709147828209e-13,
6.204071175269519e-14,
1.488727011480853e-14,
2.9769215522333e-15,
4.361923952870102e-16,
1.350061521166735e-17,
-2.206606938926355e-17,
-1.265611015382341e-17,
-4.33138134387552e-18,
2.118753318210304e-9,
-9.86222553476039e-13,
-1.13494203956205e-12,
-8.70350382885635e-13,
-5.001511338837572e-13,
-2.295340389442243e-13,
-8.74781811688783e-14,
-2.837534362448392e-14,
-7.93754633902932e-15,
-1.913776692545696e-15,
-3.870949581390471e-16,
-5.880715815939967e-17,
-2.931551291923769e-18,
2.395690006034934e-18,
1.473075597243047e-18,
5.131740172442221e-19,
-2.660151673496517e-10,
1.164446508946558e-13,
1.340078016197189e-13,
1.027718348815281e-13,
5.90647656494469e-14,
2.71124733106644e-14,
1.033743708255618e-14,
3.356162065410434e-15,
9.40575847114572e-16,
2.276877466086749e-16,
4.649403777003954e-17,
7.269719716682912e-18,
4.684550113775979e-19,
-2.408125472009139e-19,
-1.597426192955282e-19,
-5.661532427069736e-20,
// [{0,0.001},{2.,0.01}]: m=4
0.0495692195503139,
-0.0001242011058029171,
-0.000142559569454129,
-0.0001087574644476052,
-0.0000618489851343531,
-0.00002779119676078926,
-0.00001014121278165621,
-2.99744506012844e-6,
-6.73290446612748e-7,
-7.93186500743462e-8,
2.18750329794072e-8,
1.979229668787656e-8,
8.78366479542899e-9,
2.906083329787271e-9,
7.20737069116742e-10,
1.002242061223067e-10,
-0.0786649177624075,
0.0001490761726216395,
0.0001712686694239665,
0.0001308996796403323,
0.0000747163334672808,
0.00003382564329181551,
0.00001253729402117732,
3.835315259662511e-6,
9.40467704091446e-7,
1.590881189461489e-7,
5.1062676762226e-10,
-1.413956736022123e-8,
-7.68290117771279e-9,
-2.880013749640043e-9,
-8.82178084940282e-10,
-1.952625583270699e-10,
0.0650911097930307,
-0.0000988365072401221,
-0.0001136068262209799,
-0.0000869161212761635,
-0.000049710935311225,
-0.00002259718350572673,
-8.44633009893195e-6,
-2.631046010163955e-6,
-6.73482481368597e-7,
-1.301884163810554e-7,
-1.10977030666143e-8,
5.25856970468019e-9,
3.72688676360741e-9,
1.533714709139075e-9,
5.206692115458611e-10,
1.329562243636438e-10,
-0.03697435519689066,
0.0000467446206595902,
0.0000537470269850936,
0.000041145491253395,
0.0000235624212706084,
0.00001073806926429962,
4.034634943711271e-6,
1.270753190051076e-6,
3.335772552567765e-7,
6.91033318221343e-8,
8.5849425410111e-9,
-1.174493002242117e-9,
-1.306333604842344e-9,
-5.88098951150298e-10,
-2.136301057208549e-10,
-5.861807385221314e-11,
0.0160959636519833,
-0.0000174114172725374,
-0.00002002393306652852,
-0.00001533565492283151,
-8.78965073098313e-6,
-4.012619233633051e-6,
-1.51299707701887e-6,
-4.800736732558687e-7,
-1.281116458584471e-7,
-2.768299046423187e-8,
-4.067030294318455e-9,
9.0217752235614e-11,
3.62929423441117e-10,
1.801664294245662e-10,
6.905060538613723e-11,
1.982854450900571e-11,
-0.005699068896040523,
5.3832695415908e-6,
6.19196105909715e-6,
4.74367545706126e-6,
2.720525099644357e-6,
1.243512826769246e-6,
4.700700136487927e-7,
1.499433000418473e-7,
4.047853714045788e-8,
8.99812560584721e-9,
1.455048021746232e-9,
5.17912552855747e-11,
-8.34202238061295e-11,
-4.64109040725369e-11,
-1.865464275281062e-11,
-5.537523435971328e-12,
0.001703640772920275,
-1.427512789844427e-6,
-1.642149021859239e-6,
-1.258346819328594e-6,
-7.22005947754053e-7,
-3.303287886524876e-7,
-1.251088175474622e-7,
-4.006542447186216e-8,
-1.09087694315027e-8,
-2.474672784843834e-9,
-4.258754116414896e-10,
-2.99807803010733e-11,
1.61937220949769e-11,
1.036110474477222e-11,
4.357914168324357e-12,
1.328505833369899e-12,
-0.0004411537360448336,
3.32038061383075e-7,
3.81996896881703e-7,
2.927699599147602e-7,
1.68044813810049e-7,
7.69394509230632e-8,
2.918341995760203e-8,
9.37453214403525e-9,
2.569236114033915e-9,
5.917840710634891e-10,
1.063905666817545e-10,
9.96309723876932e-12,
-2.66841308369901e-12,
-2.045120507752579e-12,
-8.99997190303729e-13,
-2.806944157810275e-13,
0.0001008305622340825,
-6.88666719892251e-8,
-7.92341962191563e-8,
-6.07354955667171e-8,
-3.48712858994721e-8,
-1.597522227335853e-8,
-6.06667056335459e-9,
-1.953554222698368e-9,
-5.381881568225503e-10,
-1.254408380007292e-10,
-2.329314021796137e-11,
-2.568465569060536e-12,
3.68060461482429e-13,
3.620376854527952e-13,
1.669036457628099e-13,
5.313303206413008e-14,
-0.00002063545608065993,
1.289782647073863e-8,
1.484041238406017e-8,
1.137699824354273e-8,
6.5336654303376e-9,
2.994639344528337e-9,
1.138335248303787e-9,
3.672914696381562e-10,
1.016123784478073e-10,
2.390915921071961e-11,
4.551685533332798e-12,
5.5865295180545e-13,
-4.01600885818507e-14,
-5.8096422501631e-14,
-2.812218779795243e-14,
-9.12498273722614e-15,
3.824516841692969e-6,
-2.203188787680607e-9,
-2.535144549248493e-9,
-1.943692816923487e-9,
-1.116460495183368e-9,
-5.119232557361291e-10,
-1.947519816692053e-10,
-6.2942129399068e-11,
-1.747379576258665e-11,
-4.143486675978995e-12,
-8.04562264144984e-13,
-1.065494030585135e-13,
2.72416414540703e-15,
8.52096063139e-15,
4.344916243590534e-15,
1.435705806995747e-15,
-6.478402100914079e-7,
3.46058811343945e-10,
3.98216435529775e-10,
3.053378318377262e-10,
1.754161392954623e-10,
8.0459638099657e-11,
3.063035222124497e-11,
9.91329090034525e-12,
2.760146157519597e-12,
6.587303990634872e-13,
1.299808260935422e-13,
1.822140578588359e-14,
1.25996297730593e-16,
-1.149701538119273e-15,
-6.201361241372888e-16,
-2.085683577757705e-16,
1.010503152233469e-7,
-5.03165513259262e-11,
-5.79022944260321e-11,
-4.4400565829432e-11,
-2.551174292882243e-11,
-1.170508424586555e-11,
-4.458640768037418e-12,
-1.444728709228491e-12,
-4.032555640433551e-13,
-9.67650474633945e-14,
-1.934953216034065e-14,
-2.835175711854562e-15,
-8.77475176599473e-17,
1.434278593407771e-16,
8.22633837748756e-17,
2.815343394811309e-17,
-1.461102776771818e-8,
6.81258791743257e-12,
7.83990096220323e-12,
6.01215854350436e-12,
3.454907058369822e-12,
1.585549566567784e-12,
6.04265302208744e-13,
1.960014332809909e-13,
5.482568332675237e-14,
1.321736724165005e-14,
2.672796095236221e-15,
4.057448106117913e-16,
2.007004209150228e-17,
-1.661095218009669e-17,
-1.01966283190181e-17,
-3.550751289202287e-18,
1.998624505580399e-9,
-8.74707546034923e-13,
-1.006638284679925e-12,
-7.72000413743442e-13,
-4.436822263986098e-13,
-2.036633730464694e-13,
-7.76528097237092e-14,
-2.521089345681033e-14,
-7.065473030318773e-15,
-1.710376113702632e-15,
-3.492689125299821e-16,
-5.461502933959398e-17,
-3.52139688889311e-18,
1.808040340425157e-18,
1.199717319833241e-18,
4.252978430126712e-19,
-2.517355909742621e-10,
1.039754987691102e-13,
1.196608202254954e-13,
9.17734084002573e-14,
5.274885176872806e-14,
2.421795591172085e-14,
9.23740729309144e-15,
3.001395559743593e-15,
8.42527019494516e-16,
2.046705507394439e-16,
4.213963953188685e-17,
6.749600937106948e-18,
5.152874139222852e-19,
-1.816161590216214e-19,
-1.313291440350727e-19,
-4.736281696807574e-20,
// [{0,0.001},{2.,0.01}]: m=5
0.0393324588812037,
-0.0000745380863108197,
-0.0000856343347119833,
-0.0000654498398201662,
-0.0000373581667336404,
-0.00001691282164590776,
-6.26864701058866e-6,
-1.917657629831256e-6,
-4.70233852045723e-7,
-7.95440594730744e-8,
-2.5531338381113e-10,
7.06978368011062e-9,
3.8414505888564e-9,
1.440006874820021e-9,
4.41089042470141e-10,
9.7631279163535e-11,
-0.0650911097930307,
0.0000988365072401221,
0.0001136068262209799,
0.0000869161212761635,
0.000049710935311225,
0.00002259718350572673,
8.44633009893195e-6,
2.631046010163955e-6,
6.73482481368597e-7,
1.301884163810554e-7,
1.10977030666143e-8,
-5.25856970468019e-9,
-3.72688676360741e-9,
-1.533714709139075e-9,
-5.206692115458611e-10,
-1.329562243636438e-10,
0.055461532795336,
-0.0000701169309893853,
-0.0000806205404776404,
-0.0000617182368800925,
-0.0000353436319059126,
-0.00001610710389644943,
-6.05195241556691e-6,
-1.906129785076614e-6,
-5.003658828851648e-7,
-1.036549977332014e-7,
-1.287741381151664e-8,
1.76173950336318e-9,
1.959500407263515e-9,
8.82148426725447e-10,
3.204451585812824e-10,
8.79271107783197e-11,
-0.03219192730396779,
0.0000348228345450753,
0.0000400478661330576,
0.00003067130984566343,
0.00001757930146196649,
8.02523846726621e-6,
3.025994154037782e-6,
9.60147346511751e-7,
2.562232917168981e-7,
5.536598092846466e-8,
8.1340605886371e-9,
-1.80435504471197e-10,
-7.25858846882231e-10,
-3.603328588491331e-10,
-1.38101210772275e-10,
-3.965708901801163e-11,
0.01424767224010091,
-0.00001345817385397684,
-0.00001547990264774271,
-0.00001185918864265302,
-6.80131274911082e-6,
-3.108782066923081e-6,
-1.175175034121969e-6,
-3.748582501046139e-7,
-1.011963428511435e-7,
-2.249531401461774e-8,
-3.637620054365519e-9,
-1.29478138213926e-10,
2.085505595153248e-10,
1.16027260181342e-10,
4.663660688202641e-11,
1.384380858992825e-11,
-0.005110922318703453,
4.28253836951085e-6,
4.9264470655519e-6,
3.775040457965981e-6,
2.166017843250777e-6,
9.90986365952236e-7,
3.753264526403924e-7,
1.20196273414938e-7,
3.27263082943258e-8,
7.42401835448708e-9,
1.277626234915258e-9,
8.99423409017141e-11,
-4.85811662850605e-11,
-3.108331423428387e-11,
-1.307374250494693e-11,
-3.985517500100119e-12,
0.001544038076167619,
-1.162133214844734e-6,
-1.33698913909053e-6,
-1.024694859705167e-6,
-5.88156848337187e-7,
-2.692880782316467e-7,
-1.021419698519604e-7,
-3.281086250423834e-8,
-8.99232639915106e-9,
-2.071244248730118e-9,
-3.723669833877909e-10,
-3.487084033596696e-11,
9.33944579292079e-12,
7.15792177713846e-12,
3.149990166067087e-12,
9.8243045523557e-13,
-0.0004033222501386793,
2.75466688426996e-7,
3.169367854176495e-7,
2.429419826818226e-7,
1.394851438364131e-7,
6.39008892029639e-8,
2.426668229521051e-8,
7.81421690438198e-9,
2.152752631110172e-9,
5.017633529337566e-10,
9.3172561064877e-11,
1.027386230779777e-11,
-1.472241843209495e-12,
-1.44815074249774e-12,
-6.676145835991664e-13,
-2.125321284575468e-13,
0.0000928595522284288,
-5.80402190683889e-8,
-6.67818556708006e-8,
-5.11964920518622e-8,
-2.940149441117905e-8,
-1.347587703873962e-8,
-5.122508612925121e-9,
-1.652811611926531e-9,
-4.572557026083458e-10,
-1.075912163488406e-10,
-2.048258487925379e-11,
-2.513938279675307e-12,
1.80720398942184e-13,
2.614339012017888e-13,
1.265498450396846e-13,
4.106242229241786e-14,
-0.00001912257138124668,
1.1015938923283e-8,
1.267571697443881e-8,
9.71845965776595e-9,
5.58229993126609e-9,
2.559615110185126e-9,
9.73759462495307e-10,
3.147105020291511e-10,
8.73689380603518e-11,
2.071742344941289e-11,
4.022809261402067e-12,
5.327466786458099e-13,
-1.36208497487861e-14,
-4.26047958340435e-14,
-2.172457537224815e-14,
-7.17852688966189e-15,
3.56312201662505e-6,
-1.903323781995563e-9,
-2.190190763246613e-9,
-1.679358357238274e-9,
-9.64788928312344e-10,
-4.425280840354093e-10,
-1.684669656469532e-10,
-5.452310920158929e-11,
-1.518080646996188e-11,
-3.623017831035535e-12,
-7.148946762830286e-13,
-1.002177538986502e-13,
-6.9298171157084e-16,
6.32335881437727e-15,
3.410749011160666e-15,
1.147126129582218e-15,
-6.063746670122074e-7,
3.0192776102395e-10,
3.474465126368139e-10,
2.664285105289422e-10,
1.53084894540257e-10,
7.02371348848629e-11,
2.675437412352496e-11,
8.66919471506968e-12,
2.419764592425207e-12,
5.806466250173256e-13,
1.161088764742563e-13,
1.70129642349879e-14,
5.26649766277694e-16,
-8.60608700079012e-16,
-4.936134679640776e-16,
-1.689327732584051e-16,
9.49689664880882e-8,
-4.42808141722735e-11,
-5.09581969606613e-11,
-3.907814134513487e-11,
-2.245638471594256e-11,
-1.030583742211427e-11,
-3.927634861584203e-12,
-1.273980164203038e-12,
-3.563587358791514e-13,
-8.59108820101968e-14,
-1.737275617464851e-14,
-2.637271691058872e-15,
-1.304487344760518e-16,
1.079700715389844e-16,
6.627704659498209e-17,
2.307937225140244e-17,
-1.378134922816962e-8,
6.04123243573705e-12,
6.95241759584954e-12,
5.33186822722411e-12,
3.064311002964914e-12,
1.406603206067477e-12,
5.363046170378262e-13,
1.741140575896563e-13,
4.879425522004483e-14,
1.181081717149736e-14,
2.411325956746899e-15,
3.768195416440749e-16,
2.417684159849404e-17,
-1.253696165835079e-17,
-8.30276972211949e-18,
-2.942144030923578e-18,
1.891357413564452e-9,
-7.81056041206669e-13,
-8.98883040976582e-13,
-6.89394998664876e-13,
-3.962455417732875e-13,
-1.819236188679129e-13,
-6.9390840164673e-14,
-2.2546347905734e-14,
-6.329052495892688e-15,
-1.537497012840484e-15,
-3.165623287515245e-16,
-5.070764649450723e-17,
-3.872705832526184e-18,
1.363498454647104e-18,
9.86247208481807e-19,
3.558492356692666e-19,
-2.389079093334354e-10,
9.34036529931661e-14,
1.074964405168746e-13,
8.24475011442089e-14,
4.739262345257896e-14,
2.176254388973798e-14,
8.30370985103514e-15,
2.699911865052183e-15,
7.58994008775643e-16,
1.849499927002465e-16,
3.835395240877245e-17,
6.269964669216211e-18,
5.405621491807216e-19,
-1.363848840799243e-19,
-1.088638563498179e-19,
-3.992115169191106e-20,
// [{0,0.001},{2.,0.01}]: m=6
0.0325455548965153,
-0.000049418253620061,
-0.00005680341311049,
-0.0000434580606380818,
-0.0000248554676556125,
-0.00001129859175286336,
-4.22316504946598e-6,
-1.315523005081977e-6,
-3.367412406842983e-7,
-6.50942081905277e-8,
-5.54885153330715e-9,
2.6292848523401e-9,
1.863443381803704e-9,
7.66857354569538e-10,
2.603346057729306e-10,
6.64781121818219e-11,
-0.055461532795336,
0.0000701169309893853,
0.0000806205404776404,
0.0000617182368800925,
0.0000353436319059126,
0.00001610710389644943,
6.05195241556691e-6,
1.906129785076614e-6,
5.00365882885165e-7,
1.036549977332014e-7,
1.287741381151664e-8,
-1.76173950336318e-9,
-1.959500407263515e-9,
-8.82148426725447e-10,
-3.204451585812824e-10,
-8.79271107783197e-11,
0.0482878909559517,
-0.0000522342518176129,
-0.0000600717991995864,
-0.0000460069647684951,
-0.00002636895219294974,
-0.00001203785770089932,
-4.53899123105667e-6,
-1.440221019767626e-6,
-3.843349375753471e-7,
-8.3048971392697e-8,
-1.220109088295565e-8,
2.70653256706796e-10,
1.088788270323346e-9,
5.404992882737e-10,
2.071518161584125e-10,
5.948563352701744e-11,
-0.02849534448020295,
0.0000269163477079541,
0.0000309598052954859,
0.00002371837728530642,
0.00001360262549822185,
6.21756413384626e-6,
2.350350068243975e-6,
7.4971650020924e-7,
2.023926857022904e-7,
4.499062802923632e-8,
7.27524010873121e-9,
2.58956276427882e-10,
-4.17101119030647e-10,
-2.320545203626845e-10,
-9.32732137640533e-11,
-2.768761717985667e-11,
0.01277730579675825,
-0.00001070634592377699,
-0.00001231611766387959,
-9.43760114491483e-6,
-5.41504460812687e-6,
-2.477465914880559e-6,
-9.38316131600969e-7,
-3.004906835373412e-7,
-8.18157707358134e-8,
-1.856004588621744e-8,
-3.194065587288088e-9,
-2.248558522542757e-10,
1.214529157126522e-10,
7.77082855857096e-11,
3.26843562623672e-11,
9.96379375025021e-12,
-0.004632114228448266,
3.48639964451394e-6,
4.01096741724827e-6,
3.074084579097615e-6,
1.764470545001279e-6,
8.07864234690218e-7,
3.06425909554079e-7,
9.84325875121286e-8,
2.697697919728812e-8,
6.213732746150023e-9,
1.117100950154956e-9,
1.046125210065008e-10,
-2.80183373788947e-11,
-2.147376533139115e-11,
-9.44997049817945e-12,
-2.94729136569842e-12,
0.001411627875495584,
-9.64133409498092e-7,
-1.109278748965922e-6,
-8.50296939389562e-7,
-4.88198003429276e-7,
-2.23653112211214e-7,
-8.49333880335576e-8,
-2.734975916544138e-8,
-7.53463420891504e-9,
-1.756171735275358e-9,
-3.261039637285827e-10,
-3.595851807754728e-11,
5.15284645120762e-12,
5.06852759874442e-12,
2.336651042600268e-12,
7.438624496039724e-13,
-0.0003714382100577525,
2.321608766981506e-7,
2.671274231718696e-7,
2.047859685822605e-7,
1.176059778601826e-7,
5.39035082539152e-8,
2.049003448946999e-8,
6.61124645999438e-9,
1.829022813892286e-9,
4.303648662405379e-10,
8.19303396933937e-11,
1.00557531480434e-11,
-7.22881592995391e-13,
-1.045735605316031e-12,
-5.061993806159122e-13,
-1.642496893422524e-13,
0.0000860515710872937,
-4.95717251094501e-8,
-5.70407263328109e-8,
-4.37330684199354e-8,
-2.51203496676947e-8,
-1.151826798526721e-8,
-4.381917577195017e-9,
-1.416197257818031e-9,
-3.931602209015303e-10,
-9.32284054317129e-11,
-1.810264165728528e-11,
-2.397360050699299e-12,
6.12938241917917e-14,
1.917215812253118e-13,
9.77605891348452e-14,
3.230337096964181e-14,
-0.00001781559787799885,
9.51661438027053e-9,
1.095094860298208e-8,
8.39678778758546e-9,
4.82394234290029e-9,
2.212639364477302e-9,
8.42334425298103e-10,
2.726154149130701e-10,
7.59039954491606e-11,
1.811508013857516e-11,
3.574471499749735e-12,
5.01088456456924e-13,
3.4648789692619e-15,
-3.161678863611761e-14,
-1.705374017770298e-14,
-5.735628814408801e-15,
3.335061489849869e-6,
-1.660602975720164e-9,
-1.910956153371675e-9,
-1.465357063998351e-9,
-8.41967067198401e-10,
-3.863043094925774e-10,
-1.471490834977857e-10,
-4.768057933757955e-11,
-1.330870762682997e-11,
-3.193557017762192e-12,
-6.385989423698472e-13,
-9.35713238164409e-14,
-2.89657577806241e-15,
4.73334802461564e-15,
2.714874332644663e-15,
9.29130475019117e-16,
-5.698830451854704e-7,
2.657105841646646e-10,
3.05778758955688e-10,
2.34491534017609e-10,
1.347513496688155e-10,
6.18410140075276e-11,
2.356809521644496e-11,
7.64462474747682e-12,
2.138361769893088e-12,
5.155164474882286e-13,
1.042472126349544e-13,
1.582540616840639e-14,
7.82860284677353e-16,
-6.47851294033926e-16,
-3.976899592514364e-16,
-1.384866084499015e-16,
8.95761815429227e-8,
-3.92670965641891e-11,
-4.51896621216403e-11,
-3.465633636391943e-11,
-1.991755750581033e-11,
-9.14270770394492e-12,
-3.485898639218287e-12,
-1.131714885353696e-12,
-3.171551941840182e-13,
-7.6768483109199e-14,
-1.567323496538615e-14,
-2.44926233636023e-15,
-1.571429640811712e-16,
8.14897075123686e-17,
5.396718442570943e-17,
1.912322778817246e-17,
-1.304061646869953e-8,
5.39358144078138e-12,
6.20723220437944e-12,
4.76060835247461e-12,
2.736262474093259e-12,
1.256262873404833e-12,
4.791700917727244e-13,
1.556882644521209e-13,
4.370207674250831e-14,
1.061555470177947e-14,
2.185274727897265e-15,
3.498525385090896e-16,
2.662675704533134e-17,
-9.45579552350551e-18,
-6.8242215306679e-18,
-2.461196111148105e-18,
1.794995256290891e-9,
-7.01652703245019e-13,
-8.07518443210928e-13,
-6.1934967504356e-13,
-3.560157961620295e-13,
-1.63481412082809e-13,
-6.237797815416363e-14,
-2.028194233950789e-14,
-5.701642878373297e-15,
-1.389375519611966e-15,
-2.881269765026621e-16,
-4.710435082766124e-17,
-4.062227357017164e-18,
1.023553694611054e-18,
8.174900902419867e-19,
3.002845664892361e-19,
-2.273217807506617e-10,
8.43633919191852e-14,
9.70940313746999e-14,
7.44719133926361e-14,
4.281135133753725e-14,
1.966185022101745e-14,
7.50448388885116e-15,
2.441574156926553e-15,
6.87255979755201e-16,
1.679299264565287e-16,
3.504524261737225e-17,
5.830305392346529e-18,
5.51139465642593e-19,
-1.014078712463924e-19,
-9.08857750425005e-20,
-3.39665578701585e-20,
// [{0,0.001},{2.,0.01}]: m=7
0.027730766397668,
-0.0000350584654946926,
-0.0000403102702388202,
-0.0000308591184400463,
-0.0000176718159529563,
-8.05355194822472e-6,
-3.02597620778345e-6,
-9.53064892538307e-7,
-2.501829414425824e-7,
-5.18274988666007e-8,
-6.43870690575832e-9,
8.80869751681588e-10,
9.79750203631758e-10,
4.41074213362723e-10,
1.602225792906412e-10,
4.39635553891599e-11,
-0.0482878909559517,
0.0000522342518176129,
0.0000600717991995864,
0.0000460069647684951,
0.00002636895219294974,
0.00001203785770089932,
4.53899123105667e-6,
1.440221019767626e-6,
3.843349375753471e-7,
8.3048971392697e-8,
1.220109088295565e-8,
-2.70653256706796e-10,
-1.088788270323346e-9,
-5.404992882737e-10,
-2.071518161584125e-10,
-5.94856335270174e-11,
0.04274301672030443,
-0.0000403745215619312,
-0.0000464397079432289,
-0.0000355775659279596,
-0.00002040393824733277,
-9.32634620076939e-6,
-3.525525102365962e-6,
-1.12457475031386e-6,
-3.035890285534357e-7,
-6.74859420438545e-8,
-1.091286016309682e-8,
-3.88434414641823e-10,
6.2565167854597e-10,
3.48081780544027e-10,
1.399098206460799e-10,
4.1531425769785e-11,
-0.02555461159351758,
0.00002141269184755436,
0.00002463223532775963,
0.00001887520228983,
0.00001083008921625394,
4.95493182976121e-6,
1.876632263201972e-6,
6.00981367074694e-7,
1.636315414716299e-7,
3.712009177243564e-8,
6.38813117457634e-9,
4.49711704508579e-10,
-2.429058314253016e-10,
-1.554165711714196e-10,
-6.536871252473478e-11,
-1.992758750050057e-11,
0.0115802855711203,
-8.71599911128473e-6,
-0.00001002741854312054,
-7.68521144774393e-6,
-4.41117636250314e-6,
-2.019660586725516e-6,
-7.66064773885186e-7,
-2.46081468780318e-7,
-6.74424479932193e-8,
-1.553433186537481e-8,
-2.792752375387338e-9,
-2.61531302516243e-10,
7.00458434472377e-11,
5.36844133284778e-11,
2.362492624544851e-11,
7.36822841424598e-12,
-0.004234883626434686,
2.89240022847589e-6,
3.327836246876601e-6,
2.55089081815245e-6,
1.464594010278493e-6,
6.70959336629355e-7,
2.548001640990361e-7,
8.20492774957913e-8,
2.260390262659496e-8,
5.268515205789296e-9,
9.7831189117803e-10,
1.078755542313381e-10,
-1.545853935375536e-11,
-1.520558279621537e-11,
-7.009953127782435e-12,
-2.231587348805007e-12,
0.001300033735211888,
-8.12563068446814e-7,
-9.34945981105326e-7,
-7.16750890040813e-7,
-4.116209225123075e-7,
-1.886622788894694e-7,
-7.17151207134376e-8,
-2.313936261007565e-8,
-6.40157984864989e-9,
-1.506277031848484e-9,
-2.867561889282703e-10,
-3.519513601839007e-11,
2.53008557545818e-12,
3.66007461860806e-12,
1.77169783215876e-12,
5.748739126997491e-13,
-0.000344206285440285,
1.982869008231849e-7,
2.281629057747913e-7,
1.749322740199579e-7,
1.004813988663709e-7,
4.607307203091025e-8,
1.752767034308e-8,
5.664789042437828e-9,
1.572640886752683e-9,
3.729136224975982e-10,
7.24105667908909e-11,
9.58944023011886e-12,
-2.45175293990197e-13,
-7.66886325275972e-13,
-3.910423569242066e-13,
-1.292134840236043e-13,
0.0000801701903283534,
-4.28247646698958e-8,
-4.92792686658607e-8,
-3.778554500765435e-8,
-2.170774052207735e-8,
-9.95687713051267e-9,
-3.790504910161991e-9,
-1.226769365910424e-9,
-3.415679791831567e-10,
-8.15178605405961e-11,
-1.60851217313697e-11,
-2.254898051062242e-12,
-1.55919550387579e-14,
1.422755488388286e-13,
7.674183076122314e-14,
2.581032964053055e-14,
-0.00001667529580876663,
8.30301076719673e-9,
9.55477603495241e-9,
7.32678169045689e-9,
4.209833249353531e-9,
1.931520589006293e-9,
7.35745051566341e-10,
2.384027775685853e-10,
6.65435045656018e-11,
1.596777686622996e-11,
3.192992986245488e-12,
4.678563276047213e-13,
1.44828492651895e-14,
-2.36667361279083e-14,
-1.357436755915353e-14,
-4.645650824988947e-15,
3.134357533480861e-6,
-1.461408477380822e-9,
-1.681783478651323e-9,
-1.289703670585565e-9,
-7.41132557420692e-10,
-3.401256387106087e-10,
-1.296245472406065e-10,
-4.20454437813281e-11,
-1.176099189817549e-11,
-2.835340992369972e-12,
-5.733597815260327e-13,
-8.70397530871045e-14,
-4.30573363216747e-15,
3.56318226529999e-15,
2.187295021379813e-15,
7.616765055856279e-16,
-5.375231320253242e-7,
2.356259053139788e-10,
2.711648190577268e-10,
2.079586102419165e-10,
1.195171835165188e-10,
5.48616839989717e-11,
2.091746788648e-11,
6.79096513216688e-12,
1.903121615359878e-12,
4.606575492742529e-13,
9.40491999790208e-14,
1.469722771138559e-14,
9.43025858866532e-16,
-4.88960894100271e-16,
-3.238263836888499e-16,
-1.14748180579328e-16,
8.47615330818664e-8,
-3.50574458216441e-11,
-4.03460499700174e-11,
-3.094321840730039e-11,
-1.778528299193547e-11,
-8.16551431497569e-12,
-3.114531373744996e-12,
-1.011949544835253e-12,
-2.840566793157049e-13,
-6.89994314311869e-14,
-1.420393263517478e-14,
-2.273981114422054e-15,
-1.730674088279405e-16,
6.14622119160084e-17,
4.435666741156477e-17,
1.599726571129566e-17,
-1.237528216429034e-8,
4.84457411974569e-12,
5.57552330038334e-12,
4.276304918251048e-12,
2.458109064778589e-12,
1.128751955468292e-12,
4.306831840511733e-13,
1.400325615459121e-13,
3.936450444363497e-14,
9.59164246435003e-15,
1.988770209070945e-15,
3.249808490231628e-16,
2.795286987668092e-17,
-7.09988170198734e-18,
-5.655594216136173e-18,
-2.076615155177638e-18,
1.707958392341619e-9,
-6.3375138747264e-13,
-7.293860399541e-13,
-5.59445096355806e-13,
-3.216058853853799e-13,
-1.477031029243337e-13,
-5.637498459673648e-14,
-1.834156032769511e-14,
-5.162813489891212e-15,
-1.261535015325164e-15,
-2.632739205308692e-16,
-4.38016122833237e-17,
-4.141560463854403e-18,
7.61117386142222e-19,
6.825931737137797e-19,
2.553818760910251e-19,
-2.1680556170644e-10,
7.65729382681586e-14,
8.81294903347015e-14,
6.75983561691934e-14,
3.8862648106884e-14,
1.785079917299544e-14,
6.8151356328515e-15,
2.218541752458516e-15,
6.251990039295343e-16,
1.531420768179573e-16,
3.21387613070813e-17,
5.428651568606039e-18,
5.517277003633352e-19,
-7.42181716484908e-20,
-7.637376206876255e-20,
-2.907980925964592e-20,
// [{0,0.001},{2.,0.01}]: m=8
0.02414394547797584,
-0.0000261171259088064,
-0.0000300358995997932,
-0.0000230034823842476,
-0.00001318447609647487,
-6.01892885044966e-6,
-2.269495615528336e-6,
-7.20110509883813e-7,
-1.921674687876736e-7,
-4.15244856963485e-8,
-6.10054544147783e-9,
1.35326628353398e-10,
5.44394135161673e-10,
2.7024964413685e-10,
1.035759080792063e-10,
2.974281676350872e-11,
-0.04274301672030443,
0.0000403745215619312,
0.0000464397079432289,
0.0000355775659279596,
0.00002040393824733277,
9.32634620076939e-6,
3.525525102365962e-6,
1.12457475031386e-6,
3.035890285534356e-7,
6.74859420438545e-8,
1.091286016309682e-8,
3.88434414641823e-10,
-6.2565167854597e-10,
-3.48081780544027e-10,
-1.399098206460799e-10,
-4.1531425769785e-11,
0.03833191739027638,
-0.0000321190377713315,
-0.0000369483529916394,
-0.00002831280343474501,
-0.00001624513382438091,
-7.43239774464181e-6,
-2.814948394802958e-6,
-9.0147205061204e-7,
-2.454473122074449e-7,
-5.56801376586535e-8,
-9.5821967618645e-9,
-6.74567556762868e-10,
3.64358747137952e-10,
2.331248567571293e-10,
9.80530687871022e-11,
2.989138125075085e-11,
-0.02316057114224164,
0.0000174319982225698,
0.00002005483708624148,
0.00001537042289548817,
8.82235272500645e-6,
4.039321173451114e-6,
1.532129547770404e-6,
4.921629375606461e-7,
1.348848959864414e-7,
3.106866373075032e-8,
5.585504750774824e-9,
5.23062605032511e-10,
-1.400916868944727e-10,
-1.073688266569559e-10,
-4.724985249089735e-11,
-1.47364568284921e-11,
0.01058720906608636,
-7.23100057118961e-6,
-8.31959061719137e-6,
-6.37722704538103e-6,
-3.661485025696176e-6,
-1.677398341573361e-6,
-6.3700041024758e-7,
-2.05123193739475e-7,
-5.65097565664865e-8,
-1.317128801447301e-8,
-2.445779727945026e-9,
-2.696888855783369e-10,
3.86463483843894e-11,
3.80139569905384e-11,
1.752488281945598e-11,
5.578968372012457e-12,
-0.003900101205585903,
2.437689205323675e-6,
2.804837943296682e-6,
2.150252670107638e-6,
1.234862767528412e-6,
5.65986836664499e-7,
2.1514536213882e-7,
6.94180878297407e-8,
1.92047395458125e-8,
4.518831095511778e-9,
8.60268566777709e-10,
1.055854080539545e-10,
-7.59025672650556e-12,
-1.098022385581158e-11,
-5.315093496460756e-12,
-1.724621738093118e-12,
0.001204721999050339,
-6.94004152884156e-7,
-7.98570170215232e-7,
-6.12262959072509e-7,
-3.516848960338253e-7,
-1.612557521088876e-7,
-6.1346846201048e-8,
-1.982676164861973e-8,
-5.504243103659053e-9,
-1.30519767874766e-9,
-2.534369837694034e-10,
-3.356304080563843e-11,
8.5811352894025e-13,
2.684102138467078e-12,
1.368648249237596e-12,
4.522471940842622e-13,
-0.0003206807623562697,
1.712990590309412e-7,
1.971170750678348e-7,
1.511421803408095e-7,
8.68309622666515e-8,
3.982750860397884e-8,
1.516201967193459e-8,
4.907077473831645e-9,
1.366271919607211e-9,
3.260714428680671e-10,
6.434048707431689e-11,
9.01959222972577e-12,
6.23678229008e-14,
-5.69102195620422e-13,
-3.06967323370089e-13,
-1.032413186895958e-13,
0.0000750388310220034,
-3.73635484145587e-8,
-4.29964921137491e-8,
-3.297051757365982e-8,
-1.894424960288898e-8,
-8.6918426417062e-9,
-3.310852728678789e-9,
-1.072812497960614e-9,
-2.994457702351639e-10,
-7.18549958217697e-11,
-1.436846842194814e-11,
-2.105353471425143e-12,
-6.51728213736939e-14,
1.065003125615889e-13,
6.108465398023003e-14,
2.090542869084759e-14,
-0.00001567177654171201,
7.30703863850223e-9,
8.40891307907105e-9,
6.44851504369626e-9,
3.70566088449087e-9,
1.700627319516306e-9,
6.48122402426916e-10,
2.102271101968672e-10,
5.880492882384534e-11,
1.417669743338565e-11,
2.866797319772186e-12,
4.351984936365064e-13,
2.152863886802373e-14,
-1.781590849220756e-14,
-1.093647163840202e-14,
-3.808381174597204e-15,
2.956377977850177e-6,
-1.295942721333004e-9,
-1.49140678347103e-9,
-1.143772570080046e-9,
-6.57344632241115e-10,
-3.017393184595885e-10,
-1.150460949434225e-10,
-3.735031525470585e-11,
-1.046717086889261e-11,
-2.533617009137613e-12,
-5.172707032937449e-13,
-8.08347703067461e-14,
-5.18664426900873e-15,
2.689285001401924e-15,
1.781045339713325e-15,
6.31115137658936e-16,
-5.08632320607844e-7,
2.103659413982321e-10,
2.421007762487348e-10,
1.856780852901172e-10,
1.067224923788843e-10,
4.89980447166386e-11,
1.86890819134893e-11,
6.07231403144896e-12,
1.704514064647889e-12,
4.140393011885592e-13,
8.52326045050769e-14,
1.364542874768972e-14,
1.038570645563634e-15,
-3.68789371957285e-16,
-2.661596794033704e-16,
-9.59912499270177e-17,
8.04369648965234e-8,
-3.1488968734886e-11,
-3.624002322291214e-11,
-2.779530829643134e-11,
-1.597732157752145e-11,
-7.33670974958935e-12,
-2.79937272136315e-12,
-9.10189500636783e-13,
-2.558630246269652e-13,
-6.234413758433785e-14,
-1.292668044446471e-14,
-2.11231912856181e-15,
-1.81687209998571e-16,
4.61489846190391e-17,
3.6760641123356e-17,
1.349752416861388e-17,
-1.177441257657754e-8,
4.3751798677517e-12,
5.035403044528e-12,
3.862192066435961e-12,
2.220238308901846e-12,
1.019679375300169e-12,
3.891860416596594e-13,
1.266195063496798e-13,
3.563997768834128e-14,
8.70806930013538e-15,
1.817043346756617e-15,
3.021822690578147e-16,
2.851359648571233e-17,
-5.28154746323171e-18,
-4.72165142075885e-18,
-1.765721395998373e-18,
1.628957766983168e-9,
-5.75236212110142e-13,
-6.62052126886571e-13,
-5.07816845739482e-13,
-2.9194661399919e-13,
-1.341000330902283e-13,
-5.119718273110471e-14,
-1.66663252567552e-14,
-4.696690443434845e-15,
-1.150459125550289e-15,
-2.414418554214318e-16,
-4.078428549304976e-17,
-4.145887693210981e-18,
5.56919002507231e-19,
5.73689265943242e-19,
2.187042375813914e-19,
-2.072178103529504e-10,
6.98123811831979e-14,
8.03498609039473e-14,
6.16330237478578e-14,
3.54353477174281e-14,
1.627856253764323e-14,
6.216439146681027e-15,
2.024674209470029e-15,
5.711610417504367e-16,
1.402147688656053e-16,
2.957334405808123e-17,
5.062257054576078e-18,
5.455717245733561e-19,
-5.29076256753341e-20,
-6.457118745240238e-20,
-2.506913313648143e-20,
// [{0,0.001},{2.,0.01}]: m=9
0.02137150836015221,
-0.0000201872607809656,
-0.0000232198539716144,
-0.00001778878296397981,
-0.00001020196912366638,
-4.6631731003847e-6,
-1.762762551182981e-6,
-5.6228737515693e-7,
-1.517945142767178e-7,
-3.37429710219272e-8,
-5.45643008154841e-9,
-1.94217207320911e-10,
3.12825839272985e-10,
1.740408902720134e-10,
6.995491032304e-11,
2.07657128848925e-11,
-0.03833191739027638,
0.0000321190377713315,
0.0000369483529916394,
0.000028312803434745,
0.00001624513382438091,
7.43239774464181e-6,
2.814948394802958e-6,
9.0147205061204e-7,
2.454473122074449e-7,
5.56801376586535e-8,
9.5821967618645e-9,
6.74567556762868e-10,
-3.64358747137952e-10,
-2.331248567571293e-10,
-9.80530687871022e-11,
-2.989138125075085e-11,
0.03474085671336246,
-0.0000261479973338547,
-0.0000300822556293622,
-0.00002305563434323225,
-0.00001323352908750967,
-6.05898176017667e-6,
-2.298194321655606e-6,
-7.38244406340969e-7,
-2.023273439796622e-7,
-4.660299559612548e-8,
-8.37825712616224e-9,
-7.84593907548767e-10,
2.10137530341709e-10,
1.610532399854338e-10,
7.0874778736346e-11,
2.210468524273815e-11,
-0.02117441813217372,
0.00001446200114237953,
0.00001663918123438311,
0.00001275445409076234,
7.32297005139251e-6,
3.354796683146797e-6,
1.274000820495189e-6,
4.102463874789593e-7,
1.130195131329756e-7,
2.634257602894667e-8,
4.891559455890189e-9,
5.39377771156698e-10,
-7.72926967687761e-11,
-7.60279139810769e-11,
-3.504976563891223e-11,
-1.115793674402502e-11,
0.00975025301396442,
-6.09422301330908e-6,
-7.01209485824159e-6,
-5.375631675269e-6,
-3.087156918820978e-6,
-1.414967091661223e-6,
-5.37863405347041e-7,
-1.735452195743487e-7,
-4.801184886453039e-8,
-1.129707773877923e-8,
-2.150671416944227e-9,
-2.639635201348785e-10,
1.89756418162648e-11,
2.745055963952895e-11,
1.328773374115181e-11,
4.31155434523272e-12,
-0.003614165997103363,
2.082012458637119e-6,
2.395710510628032e-6,
1.836788877203977e-6,
1.055054688093685e-6,
4.83767256323083e-7,
1.840405386017768e-7,
5.94802849454137e-8,
1.651272931085136e-8,
3.915593036212035e-9,
7.60310951301654e-10,
1.006891224157798e-10,
-2.57434058694921e-12,
-8.0523064153926e-12,
-4.105944747699603e-12,
-1.356741582247526e-12,
0.001122382668255906,
-5.99546706611059e-7,
-6.89909762740604e-7,
-5.28997631195274e-7,
-3.039083679346837e-7,
-1.393962801145708e-7,
-5.30670688520174e-8,
-1.717477115849107e-8,
-4.781951718647935e-9,
-1.141250050043828e-9,
-2.251917047612989e-10,
-3.156857280424806e-11,
-2.18287380177362e-13,
1.991857684671606e-12,
1.074385631797522e-12,
3.613446154154155e-13,
-0.0003001553250866967,
1.494541939798758e-7,
1.719859688251911e-7,
1.318820705786082e-7,
7.57769985748305e-8,
3.476737064183961e-8,
1.324341094336823e-8,
4.291250001178965e-9,
1.197783083576974e-9,
2.874199839355625e-10,
5.747387382518237e-11,
8.42141390949609e-12,
2.60691288186671e-13,
-4.26001250427634e-13,
-2.443386161971375e-13,
-8.36217148733778e-14,
0.00007052299432503093,
-3.28816738385035e-8,
-3.7840108815816e-8,
-2.901831766594632e-8,
-1.66754739625639e-8,
-7.65282292971572e-9,
-2.916550807823634e-9,
-9.46021994876173e-10,
-2.646221794219447e-10,
-6.379513837991438e-11,
-1.290058792401631e-11,
-1.9583932187506e-12,
-9.68788745972602e-14,
8.01715882120485e-14,
4.921412234497459e-14,
1.713771526398285e-14,
-0.00001478187923481006,
6.47971017528828e-9,
7.45702996799088e-9,
5.71885982092248e-9,
3.286721419336637e-9,
1.508695792014341e-9,
5.75230169036227e-10,
1.86751476668423e-10,
5.233582621929484e-11,
1.26680781274344e-11,
2.586352050743623e-12,
4.041735976732476e-13,
2.593319262672111e-14,
-1.34464230721587e-14,
-8.90522375232119e-15,
-3.155574516191252e-15,
2.797478484502789e-6,
-1.157012900146538e-9,
-1.331554525408737e-9,
-1.021229665504348e-9,
-5.8697382101944e-10,
-2.694892978339403e-10,
-1.027899703494282e-10,
-3.339773363566664e-11,
-9.3748291819841e-12,
-2.277216606621315e-12,
-4.687794205187858e-13,
-7.50498748435102e-14,
-5.712140527652386e-15,
2.028341570679377e-15,
1.463878415160247e-15,
5.2795200695642e-16,
-4.826822378593394e-7,
1.889532802615667e-10,
2.174625459824317e-10,
1.667890374645381e-10,
9.58738119264356e-11,
4.402479889191884e-11,
1.679797060318561e-11,
5.461702111660706e-12,
1.535337715449938e-12,
3.741040761246558e-13,
7.75683984468088e-14,
1.267535505151176e-14,
1.090286195230206e-15,
-2.76904886515213e-16,
-2.205805609852575e-16,
-8.09917919908542e-17,
7.653140886448874e-8,
-2.84379680269355e-11,
-3.272931282821117e-11,
-2.510362941223981e-11,
-1.443119306979296e-11,
-6.62775239053687e-12,
-2.529646787759414e-12,
-8.23006422844401e-13,
-2.316540986590388e-13,
-5.660103192513234e-14,
-1.181048000837805e-14,
-1.964132010657013e-15,
-1.853321452271207e-16,
3.43299634958768e-17,
3.069017098520028e-17,
1.147678869711754e-17,
-1.122908720943234e-8,
3.97073943580649e-12,
4.57001026753532e-12,
3.505352786852843e-12,
2.015242661775112e-12,
9.2565966396845e-13,
3.533992290835757e-13,
1.15041217782568e-13,
3.241853504981747e-14,
7.94048122305448e-15,
1.666209013775212e-15,
2.813533212602439e-16,
2.85532362198322e-17,
-3.8669013541507e-18,
-3.967820124254653e-18,
-1.511840798008812e-18,
1.556931117727051e-9,
-5.24455809065846e-13,
-6.03617187390963e-13,
-4.630095848712015e-13,
-2.662032064895123e-13,
-1.222905196479206e-13,
-4.67001994747453e-14,
-1.5210126608684e-14,
-4.290792849132678e-15,
-1.053356727151405e-15,
-2.221714772213996e-16,
-3.803184627229795e-17,
-4.099459359734631e-18,
3.96940821392215e-19,
4.849781686894752e-19,
1.884943294786565e-19,
-1.984409318379418e-10,
6.39080808312148e-14,
7.35554012960543e-14,
5.64228670986964e-14,
3.244164538680744e-14,
1.490497823305733e-14,
5.693191214264248e-15,
1.855108058151538e-15,
5.238210962338066e-16,
1.288501294833138e-16,
2.729870378000487e-17,
4.728113830891324e-18,
5.348935869694291e-19,
-3.60365048373343e-20,
-5.48693813605117e-20,
-2.181910290840288e-20,
// [{0,0.001},{2.,0.01}]: m=10
0.01916595869513819,
-0.0000160595188856658,
-0.0000184741764958197,
-0.0000141564017173725,
-8.12256691219046e-6,
-3.71619887232091e-6,
-1.407474197401479e-6,
-4.5073602530602e-7,
-1.227236561037224e-7,
-2.784006882932673e-8,
-4.79109838093225e-9,
-3.37283778381434e-10,
1.82179373568976e-10,
1.165624283785647e-10,
4.90265343935511e-11,
1.494569062537543e-11,
-0.03474085671336245,
0.0000261479973338547,
0.0000300822556293622,
0.00002305563434323225,
0.00001323352908750967,
6.05898176017667e-6,
2.298194321655606e-6,
7.38244406340969e-7,
2.023273439796621e-7,
4.66029955961255e-8,
8.37825712616224e-9,
7.84593907548767e-10,
-2.10137530341709e-10,
-1.610532399854338e-10,
-7.0874778736346e-11,
-2.210468524273815e-11,
0.03176162719826058,
-0.0000216930017135693,
-0.00002495877185157467,
-0.0000191316811361435,
-0.00001098445507708877,
-5.0321950247202e-6,
-1.911001230742784e-6,
-6.15369581218439e-7,
-1.695292696994634e-7,
-3.951386404342e-8,
-7.33733918383528e-9,
-8.09066656735046e-10,
1.159390451531641e-10,
1.140418709716154e-10,
5.257464845836835e-11,
1.673690511603754e-11,
-0.01950050602792979,
0.00001218844602661846,
0.00001402418971648351,
0.00001075126335053827,
6.1743138376421e-6,
2.829934183322514e-6,
1.075726810694108e-6,
3.47090439148706e-7,
9.60236977290632e-8,
2.259415547755906e-8,
4.30134283388858e-9,
5.27927040269779e-10,
-3.7951283632527e-11,
-5.4901119279058e-11,
-2.657546748230385e-11,
-8.62310869046554e-12,
0.00903541499275808,
-5.2050311465927e-6,
-5.98927627656997e-6,
-4.59197219300986e-6,
-2.637636720234163e-6,
-1.209418140807686e-6,
-4.601013465044334e-7,
-1.487007123635314e-7,
-4.128182327712761e-8,
-9.78898259052989e-9,
-1.900777378254094e-9,
-2.517228060394422e-10,
6.4358514673739e-12,
2.01307660384814e-11,
1.026486186924893e-11,
3.391853955618853e-12,
-0.003367148004722,
1.798640119819074e-6,
2.069729288205579e-6,
1.586992893573371e-6,
9.11725103796892e-7,
4.181888403404228e-7,
1.592012065547955e-7,
5.152431347506352e-8,
1.434585515582802e-8,
3.423750150102952e-9,
6.75575114277827e-10,
9.47057184116819e-11,
6.5486214040688e-13,
-5.97557305400939e-12,
-3.223156895381286e-12,
-1.084033846241635e-12,
0.00105054363781205,
-5.23089678932114e-7,
-6.01950890891103e-7,
-4.61587247027379e-7,
-2.652194950132008e-7,
-1.216857972470333e-7,
-4.635193830201605e-8,
-1.501937500420048e-8,
-4.192240792540369e-9,
-1.005969943779642e-9,
-2.011585583892428e-10,
-2.947494868343206e-11,
-9.12419508677171e-13,
1.491004376498941e-12,
8.55185156691894e-13,
2.926760020558431e-13,
-0.000282091978258219,
1.315266956495507e-7,
1.51360435603418e-7,
1.160732709247172e-7,
6.67018960002922e-8,
3.061129178780276e-8,
1.166620325763267e-8,
3.784087988090487e-9,
1.058488720114208e-9,
2.551805541175952e-10,
5.160235182326086e-11,
7.83357289726379e-12,
3.87515501012773e-13,
-3.20686352962334e-13,
-1.968564896160849e-13,
-6.855086115209117e-14,
0.00006651845644837309,
-2.91586957567521e-8,
-3.35566348190755e-8,
-2.573486916585721e-8,
-1.479024637074499e-8,
-6.78913105658803e-9,
-2.588535757806121e-9,
-8.40381644076243e-10,
-2.355112177233235e-10,
-5.700635150841448e-11,
-1.163858421445936e-11,
-1.818781187068926e-12,
-1.166993665207855e-13,
6.05089037975837e-14,
4.007350686138073e-14,
1.420008533432594e-14,
-0.00001398738220107807,
5.7850613478446e-9,
6.65776899816103e-9,
5.10614554380742e-9,
2.9348675044533e-9,
1.347445753694592e-9,
5.139495707625856e-10,
1.669885765820046e-10,
4.687412002390386e-11,
1.138607665409039e-11,
2.343895745622715e-12,
3.752491367227001e-13,
2.85606746483772e-14,
-1.014170663276781e-14,
-7.319389557750851e-15,
-2.639759012103208e-15,
2.654753001218059e-6,
-1.039243246541139e-9,
-1.196044238973199e-9,
-9.17339887148282e-10,
-5.27306069729492e-10,
-2.421364417583388e-10,
-9.23888566029069e-11,
-3.003936757715742e-11,
-8.44435912150789e-12,
-2.057572834971808e-12,
-4.26626280340017e-13,
-6.971446853096182e-14,
-5.996575990358137e-15,
1.522977044707718e-15,
1.213193239619059e-15,
4.454547875953491e-16,
-4.592464450193997e-7,
1.706456960293249e-10,
1.963964653857763e-10,
1.506375698389725e-10,
8.65962396503631e-11,
3.977068705145262e-11,
1.517947488876372e-11,
4.938558207693181e-12,
1.390071455975583e-12,
3.396423828411766e-13,
7.087057882403996e-14,
1.178613949800517e-14,
1.112151667106199e-15,
-2.059867168934663e-16,
-1.841553045557665e-16,
-6.886652267365509e-17,
7.298688275477095e-8,
-2.580915991269967e-11,
-2.970432271952538e-11,
-2.27842223641094e-11,
-1.309874910290322e-11,
-6.01663699853663e-12,
-2.297037359130363e-12,
-7.47749121969876e-13,
-2.107151623892867e-13,
-5.161181594251398e-14,
-1.083007845853254e-14,
-1.828746961022235e-15,
-1.855899950408115e-16,
2.5134338929961e-17,
2.579034429540988e-17,
9.82716735672052e-18,
-1.073195646222101e-8,
3.61981448440191e-12,
4.16618782077198e-12,
3.195706585234861e-12,
1.837340019225349e-12,
8.44049100470884e-13,
3.223227639820717e-13,
1.049783273924495e-13,
2.961373808150801e-14,
7.26955113532656e-15,
1.533088466559263e-15,
2.62352902863225e-16,
2.824014397051717e-17,
-2.75864474441562e-18,
-3.353853727840249e-18,
-1.302851388613039e-18,
1.490995259936524e-9,
-4.80106238470404e-13,
-5.52581270098873e-13,
-4.238739991650607e-13,
-2.437162966502144e-13,
-1.119729669363708e-13,
-4.276986665066505e-14,
-1.393644215744954e-14,
-3.935200611012763e-15,
-9.67990828480515e-16,
-2.050850721046817e-16,
-3.552193195109384e-17,
-4.019136431258534e-18,
2.7090178974844e-19,
4.121196566912351e-19,
1.634073157379542e-19,
-1.903763615853395e-10,
5.87214699042478e-14,
6.75867076909557e-14,
5.18457351789887e-14,
2.981145070204579e-14,
1.369797577748767e-14,
5.233243206458396e-15,
1.705951373478751e-15,
4.821187612157297e-16,
1.188072566081731e-16,
2.527326326201246e-17,
4.423341826278025e-18,
5.212685934507646e-19,
-2.28071183325054e-20,
-4.683985197595369e-20,
-1.896691305835728e-20,
// [{0,0.001},{2.,0.01}]: m=11
0.01737042835668123,
-0.0000130739986669274,
-0.00001504112781468111,
-0.00001152781717161612,
-6.61676454375484e-6,
-3.02949088008834e-6,
-1.149097160827803e-6,
-3.69122203170485e-7,
-1.011636719898311e-7,
-2.330149779806274e-8,
-4.18912856308112e-9,
-3.92296953774383e-10,
1.050687651708545e-10,
8.05266199927169e-11,
3.543738936817301e-11,
1.105234262136907e-11,
-0.03176162719826058,
0.0000216930017135693,
0.0000249587718515747,
0.0000191316811361435,
0.00001098445507708877,
5.0321950247202e-6,
1.911001230742784e-6,
6.15369581218439e-7,
1.695292696994633e-7,
3.951386404342e-8,
7.33733918383528e-9,
8.09066656735046e-10,
-1.159390451531641e-10,
-1.140418709716154e-10,
-5.257464845836835e-11,
-1.673690511603753e-11,
0.02925075904189469,
-0.0000182826690399277,
-0.00002103628457472527,
-0.0000161268950258074,
-9.26147075646316e-6,
-4.24490127498377e-6,
-1.613590216041161e-6,
-5.20635658723059e-7,
-1.440355465935948e-7,
-3.38912332163386e-8,
-6.45201425083287e-9,
-7.91890560404669e-10,
5.69269254487905e-11,
8.2351678918587e-11,
3.986320122345578e-11,
1.293466303569831e-11,
-0.01807082998551708,
0.00001041006229318568,
0.00001197855255314025,
9.18394438601995e-6,
5.27527344046846e-6,
2.418836281615434e-6,
9.20202693008891e-7,
2.974014247270707e-7,
8.25636465542574e-8,
1.957796518106033e-8,
3.801554756508305e-9,
5.034456120789051e-10,
-1.28717029347453e-11,
-4.02615320769629e-11,
-2.052972373849807e-11,
-6.78370791123779e-12,
0.00841787001180469,
-4.4966002995476e-6,
-5.17432322051385e-6,
-3.96748223393335e-6,
-2.279312759492184e-6,
-1.045472100851036e-6,
-3.980030163869809e-7,
-1.288107836876562e-7,
-3.586463788956933e-8,
-8.5593753752572e-9,
-1.688937785694529e-9,
-2.367642960291979e-10,
-1.63715535101634e-12,
1.493893263502345e-11,
8.05789223845316e-12,
2.710084615604093e-12,
-0.003151630913392219,
1.56926903678334e-6,
1.805852672658342e-6,
1.384761741070657e-6,
7.95658485033001e-7,
3.650573917380664e-7,
1.39055814904889e-7,
4.505812501222342e-8,
1.257672237751419e-8,
3.017909831312536e-9,
6.034756751620939e-10,
8.84248460493008e-11,
2.73725852591e-12,
-4.47301312949396e-12,
-2.565555470065988e-12,
-8.78028006163452e-13,
0.000987321923912055,
-4.60343434775785e-7,
-5.29761524614677e-7,
-4.06256448238592e-7,
-2.334566360022198e-7,
-1.071395212578598e-7,
-4.083171140192459e-8,
-1.324430795838529e-8,
-3.70471052041914e-9,
-8.93131939416382e-10,
-1.80608231382441e-10,
-2.741750514060664e-11,
-1.356304253567738e-12,
1.122402235368942e-12,
6.889977136579025e-13,
2.399280140323472e-13,
-0.000266073826714166,
1.166347832994908e-7,
1.342265395899249e-7,
1.029394769040145e-7,
5.9160985621324e-8,
2.715652428992541e-8,
1.035414305551694e-8,
3.361526584226955e-9,
9.42044873133885e-10,
2.280254065867137e-10,
4.655433697591922e-11,
7.27512476913622e-12,
4.667974686293141e-13,
-2.420356152507497e-13,
-1.602940276483158e-13,
-5.680034142228831e-14,
0.00006294321980064963,
-2.603277603566193e-8,
-2.995996045761048e-8,
-2.297765492096325e-8,
-1.320690375499058e-8,
-6.06350588470947e-9,
-2.312773065788374e-9,
-7.51448593756726e-10,
-2.109335398635067e-10,
-5.123734488307323e-11,
-1.054753084237737e-11,
-1.688621112947424e-12,
-1.285230356277822e-13,
4.56376798393652e-14,
3.293725298925434e-14,
1.187891555232328e-14,
-0.00001327375518388191,
5.19621332576536e-9,
5.98021784902268e-9,
4.586696869086e-9,
2.636528872743494e-9,
1.21068153056887e-9,
4.619440238536944e-10,
1.501967533711669e-10,
4.22217717040884e-11,
1.02878582746543e-11,
2.133130141957304e-12,
3.485721201045705e-13,
2.998285279013614e-14,
-7.61488457479277e-15,
-6.065964037219267e-15,
-2.227273035880032e-15,
2.525856114545626e-6,
-9.38551517862238e-10,
-1.080180777966988e-9,
-8.28506801614439e-10,
-4.76279414398753e-10,
-2.187388230496122e-10,
-8.3487128806205e-11,
-2.716207566136805e-11,
-7.64539456995866e-12,
-1.868033491787547e-12,
-3.897882662563296e-13,
-6.48237819870899e-14,
-6.116836026324568e-15,
1.132926985780499e-15,
1.012854309145961e-15,
3.787658982914736e-16,
-4.379770233475502e-7,
1.548714519761599e-10,
1.782449189293068e-10,
1.367198960812658e-10,
7.86008681455277e-11,
3.610366988249718e-11,
1.378369450161559e-11,
4.486974224846142e-12,
1.26442659040006e-12,
3.097043704375189e-13,
6.498761790545851e-14,
1.097374441619157e-14,
1.113694064082802e-15,
-1.5080973542937e-16,
-1.547543145849577e-16,
-5.896809939518236e-17,
6.975561500822221e-8,
-2.352819626939224e-11,
-2.707953267785083e-11,
-2.07715648951071e-11,
-1.194240654832843e-11,
-5.48617963823894e-12,
-2.095044645519585e-12,
-6.82341733679345e-13,
-1.92484374291044e-13,
-4.725086531641095e-14,
-9.96481431256959e-15,
-1.705247395906292e-15,
-1.83555078436134e-16,
1.793108024592e-17,
2.179962163105869e-17,
8.46843234855073e-18,
-1.02769108626108e-8,
3.31337512670916e-12,
3.81354843130607e-12,
2.925294387898029e-12,
1.681964246000794e-12,
7.72759138490948e-13,
2.951660444560685e-13,
9.61779303667744e-14,
2.715689769381549e-14,
6.679791938769407e-15,
1.415067939160791e-15,
2.450269998865967e-16,
2.769139449515298e-17,
-1.88562640432753e-18,
-2.849681503155718e-18,
-1.129274975903821e-18,
1.430409919283272e-9,
-4.4114691128898e-13,
-5.07747311393674e-13,
-3.894927793849626e-13,
-2.239595311571182e-13,
-1.029065372045428e-13,
-3.931495229375236e-14,
-1.281604479697109e-14,
-3.621950374386679e-15,
-8.92552423204283e-16,
-1.898703754069169e-16,
-3.323225411596367e-17,
-3.916727530377945e-18,
1.71162492947389e-19,
3.51829910697428e-19,
1.424071925151057e-19,
-1.829408695376009e-10,
5.41408914335723e-14,
6.23153282254465e-14,
4.780318786172646e-14,
2.748826991036703e-14,
1.263169794761616e-14,
4.82679397146453e-15,
1.574060172989031e-15,
4.451950208955061e-16,
1.098897445424629e-16,
2.346245639752815e-17,
4.145046781642336e-18,
5.058193489660272e-19,
-1.22691796276671e-20,
-4.016065602092482e-20,
-1.660074495723009e-20,
// [{0,0.001},{2.,0.01}]: m=12
0.01588081359913029,
-0.00001084650085678465,
-0.00001247938592578734,
-9.56584056807175e-6,
-5.49222753854439e-6,
-2.5160975123601e-6,
-9.55500615371392e-7,
-3.07684790609219e-7,
-8.47646348497317e-8,
-1.975693202171e-8,
-3.66866959191764e-9,
-4.04533328367523e-10,
5.7969522576582e-11,
5.70209354858077e-11,
2.628732422918417e-11,
8.36845255801877e-12,
-0.02925075904189469,
0.0000182826690399277,
0.00002103628457472526,
0.0000161268950258074,
9.26147075646316e-6,
4.24490127498377e-6,
1.613590216041161e-6,
5.20635658723059e-7,
1.440355465935948e-7,
3.38912332163386e-8,
6.45201425083287e-9,
7.91890560404669e-10,
-5.69269254487905e-11,
-8.2351678918587e-11,
-3.986320122345578e-11,
-1.293466303569831e-11,
0.02710624497827563,
-0.00001561509343977851,
-0.00001796782882971038,
-0.00001377591657902993,
-7.9129101607027e-6,
-3.628254422423152e-6,
-1.380304039513337e-6,
-4.46102137090606e-7,
-1.238454698313862e-7,
-2.93669477715905e-8,
-5.70233213476246e-9,
-7.55168418118358e-10,
1.93075544021179e-11,
6.03922981154443e-11,
3.079458560774711e-11,
1.017556186685669e-11,
-0.01683574002361026,
8.99320059909544e-6,
0.00001034864644102798,
7.93496446786692e-6,
4.5586255189845e-6,
2.090944201702131e-6,
7.96006032773984e-7,
2.576215673753197e-7,
7.17292757791407e-8,
1.711875075051491e-8,
3.377875571389168e-9,
4.735285920584153e-10,
3.2743107020351e-12,
-2.98778652700469e-11,
-1.611578447690649e-11,
-5.420169231208258e-12,
0.00787907728348025,
-3.92317259195827e-6,
-4.51463168164576e-6,
-3.461904352676571e-6,
-1.98914621258246e-6,
-9.12643479345147e-7,
-3.476395372622151e-7,
-1.126453125305562e-7,
-3.14418059437848e-8,
-7.54477457828117e-9,
-1.508689187905199e-9,
-2.210621151232455e-10,
-6.84314631477418e-12,
1.118253282373491e-11,
6.413888675164925e-12,
2.195070015408611e-12,
-0.002961965771693883,
1.381030304315329e-6,
1.589284573830188e-6,
1.218769344705157e-6,
7.00369908000553e-7,
3.21418563770773e-7,
1.224951342047013e-7,
3.9732923874806e-8,
1.111413156115839e-8,
2.679395818224665e-9,
5.418246941420788e-10,
8.22525154208856e-11,
4.06891276058571e-12,
-3.36720670610588e-12,
-2.066993140965414e-12,
-7.19784042093543e-13,
0.000931258393507569,
-4.08221741550404e-7,
-4.69792888567254e-7,
-3.602881691659817e-7,
-2.070634496757443e-7,
-9.50478350152493e-8,
-3.623950069450439e-8,
-1.1765343044858e-8,
-3.297157055986629e-9,
-7.98088923057961e-10,
-1.629401794166765e-10,
-2.546293669214892e-11,
-1.633791140224671e-12,
8.47124653377415e-13,
5.610290967703451e-13,
1.988011949786716e-13,
-0.0002517728800886606,
1.041311043946692e-7,
1.198398421205179e-7,
9.19106199063802e-8,
5.28276151479277e-8,
2.425402359764696e-8,
9.2510922856294e-9,
3.00579438235908e-9,
8.43734161529299e-10,
2.049493800453184e-10,
4.219012347941273e-11,
6.754484471370223e-12,
5.140921449735275e-13,
-1.825507193768491e-13,
-1.317490121308271e-13,
-4.751566228300075e-14,
0.0000597318982270427,
-2.33829599384507e-8,
-2.69109802889569e-8,
-2.064013588661043e-8,
-1.186437991338481e-8,
-5.44806688114338e-9,
-2.078748104888931e-9,
-6.75885389369864e-10,
-1.899979724417087e-10,
-4.629536217982665e-11,
-9.5990856267484e-12,
-1.56857453830646e-12,
-1.349228372779395e-13,
3.42669805900173e-14,
2.729683815172875e-14,
1.002272865217777e-14,
-0.00001262927111976936,
4.69275490065208e-9,
5.40090079519645e-9,
4.142531634069041e-9,
2.381395706811461e-9,
1.09369348785071e-9,
4.17435404249625e-10,
1.358103000844227e-10,
3.822695071000321e-11,
9.34016198578633e-12,
1.948940158790725e-12,
3.241187010426376e-13,
3.058415386142598e-14,
-5.66463472318942e-15,
-5.064269691386073e-15,
-1.89382870424167e-15,
2.408874271183495e-6,
-8.51793161838495e-10,
-9.80347256653702e-10,
-7.51959583827361e-10,
-4.323048641562422e-10,
-1.985702254223201e-10,
-7.58103354571788e-11,
-2.467836335947665e-11,
-6.95434769810833e-12,
-1.703374396583982e-12,
-3.574319756654559e-13,
-6.035560813989234e-14,
-6.125319130588675e-15,
8.29453521340803e-16,
8.51148831949233e-16,
3.24324607941085e-16,
-4.185873219322741e-7,
1.411844317112969e-10,
1.624947534842475e-10,
1.246428582666275e-10,
7.16621846455721e-11,
3.292063736553285e-11,
1.257162827188834e-11,
4.094494196672377e-12,
1.155031855785016e-12,
2.835362438191193e-13,
5.979553800692396e-14,
1.023266953307715e-14,
1.101479516927158e-15,
-1.075876516072218e-16,
-1.308082512010409e-16,
-5.081505544674274e-17,
6.679789477761999e-8,
-2.153638372118454e-11,
-2.478742645140942e-11,
-1.901392380982346e-11,
-1.093248597671582e-11,
-5.022804964563943e-12,
-1.918529812742651e-12,
-6.25140401811546e-13,
-1.765152621905915e-13,
-4.341751558389682e-14,
-9.19769834053298e-15,
-1.592631844449008e-15,
-1.799884575062055e-16,
1.225664338679246e-17,
1.852260659963781e-17,
7.340096132870483e-18,
-9.85883040265393e-9,
3.04421666349671e-12,
3.503804027585315e-12,
2.687765060096416e-12,
1.545471063879343e-12,
7.10122316249352e-13,
2.712974261767853e-13,
8.84376784435665e-14,
2.499288438708546e-14,
6.158681814870589e-15,
1.309986830391913e-15,
2.292218353186332e-16,
2.698900503072703e-17,
-1.1947532104262e-18,
-2.432587057696292e-18,
-9.84066047088274e-19,
1.374549980525845e-9,
-4.06739306603341e-13,
-4.68150664062871e-13,
-3.591266601885474e-13,
-2.065086532631293e-13,
-9.48970477569356e-14,
-3.626185156542346e-14,
-1.182532374043217e-14,
-3.344591016929401e-15,
-8.25566404686777e-16,
-1.76267838399839e-16,
-3.114158567468301e-17,
-3.80054906083266e-18,
9.1938383953685e-20,
3.016057492885113e-19,
1.247330587101735e-19,
-1.760636926487431e-10,
5.00755679541556e-14,
5.76368274967938e-14,
4.421518464888158e-14,
2.542616218730271e-14,
1.168511167837242e-14,
4.46586639035278e-15,
1.456872561056324e-15,
4.123481253161954e-16,
1.019361849936923e-16,
2.183741569314243e-17,
3.890635656714003e-18,
4.893013177086312e-19,
-3.903576420935e-21,
-3.45483311285739e-20,
-1.456998565045907e-20,
// [{0,0.001},{2.,0.01}]: m=13
0.01462537952094734,
-9.14133451996385e-6,
-0.00001051814228736263,
-8.0634475129037e-6,
-4.63073537823158e-6,
-2.12245063749189e-6,
-8.06795108020581e-7,
-2.6031782936153e-7,
-7.20177732967974e-8,
-1.69456166081693e-8,
-3.22600712541643e-9,
-3.95945280202334e-10,
2.84634627243953e-11,
4.11758394592935e-11,
1.993160061172789e-11,
6.46733151784915e-12,
-0.02710624497827562,
0.00001561509343977851,
0.00001796782882971038,
0.00001377591657902993,
7.9129101607027e-6,
3.62825442242315e-6,
1.380304039513336e-6,
4.46102137090606e-7,
1.238454698313862e-7,
2.93669477715905e-8,
5.70233213476246e-9,
7.55168418118358e-10,
-1.9307554402118e-11,
-6.03922981154443e-11,
-3.079458560774711e-11,
-1.017556186685669e-11,
0.02525361003541539,
-0.00001348980089864317,
-0.00001552296966154197,
-0.00001190244670180038,
-6.83793827847674e-6,
-3.136416302553197e-6,
-1.194009049160976e-6,
-3.864323510629796e-7,
-1.075939136687111e-7,
-2.567812612577237e-8,
-5.066813357083752e-9,
-7.10292888087623e-10,
-4.9114660530527e-12,
4.48167979050704e-11,
2.417367671535973e-11,
8.13025384681239e-12,
-0.01575815456696134,
7.84634518391677e-6,
9.02926336329179e-6,
6.92380870535335e-6,
3.97829242516504e-6,
1.825286958690348e-6,
6.95279074524451e-7,
2.252906250611191e-7,
6.28836118875715e-8,
1.508954915656282e-8,
3.017378375810499e-9,
4.421242302465092e-10,
1.36862926295507e-11,
-2.236506564746979e-11,
-1.282777735033e-11,
-4.390140030817296e-12,
0.00740491442923442,
-3.45257576078825e-6,
-3.97321143457538e-6,
-3.046923361762826e-6,
-1.750924770001344e-6,
-8.03546409426915e-7,
-3.062378355117464e-7,
-9.93323096870128e-8,
-2.778532890289535e-8,
-6.69848954556151e-9,
-1.354561735355163e-9,
-2.056312885522079e-10,
-1.017228190146348e-11,
8.41801676526473e-12,
5.167482852413488e-12,
1.799460105233821e-12,
-0.002793775180481958,
1.224665224640058e-6,
1.409378665688923e-6,
1.080864507488095e-6,
6.21190349021568e-7,
2.851435050431443e-7,
1.08718502082518e-7,
3.529602913424925e-8,
9.89147116786791e-9,
2.394266769151114e-9,
4.888205382451365e-10,
7.63888100755685e-11,
4.901373420560594e-12,
-2.5413739601332e-12,
-1.683087290303871e-12,
-5.964035849326151e-13,
0.00088120508031802,
-3.64458865383376e-7,
-4.19439447424154e-7,
-3.216871696741267e-7,
-1.848966530187798e-7,
-8.48890825922391e-8,
-3.237882299988442e-8,
-1.052028033831603e-8,
-2.953069565369338e-9,
-7.17322830162776e-10,
-1.476654321788414e-10,
-2.364069564995777e-11,
-1.79932250742882e-12,
6.38927517818187e-13,
4.611215424591604e-13,
1.663048179914946e-13,
-0.0002389275937621265,
9.35318399875823e-8,
1.076439214249097e-7,
8.2560543752868e-8,
4.74575197722504e-8,
2.179226757913404e-8,
8.31499244041125e-9,
2.703541564285239e-9,
7.599918916944e-10,
1.851814491964815e-10,
3.839634260953091e-11,
6.274298171632489e-12,
5.396913514886162e-13,
-1.370679223416563e-13,
-1.091873527570381e-13,
-4.009091467820194e-14,
0.00005683171994204827,
-2.111739702736179e-8,
-2.430405354894948e-8,
-1.864139233072957e-8,
-1.071628066766519e-8,
-4.921620689359116e-9,
-1.878459316841318e-9,
-6.11146349634995e-10,
-1.720212779839089e-10,
-4.20307288837112e-11,
-8.77023070328254e-12,
-1.458534152655678e-12,
-1.376286921064163e-13,
2.54908562653473e-14,
2.278921359527835e-14,
8.52222915547718e-15,
-0.00001204436224548133,
4.2589633151436e-9,
4.90173341259715e-9,
3.759795716902523e-9,
2.161523054324815e-9,
9.9285054503911e-10,
3.790514547911186e-10,
1.233917441906578e-10,
3.477171792652941e-11,
8.51686689223299e-12,
1.787158784418408e-12,
3.017778443243644e-13,
3.062657029552884e-14,
-4.14726778933047e-15,
-4.255742558285513e-15,
-1.621622313384642e-15,
2.302230890920921e-6,
-7.7651453808779e-10,
-8.93721332557167e-10,
-6.85535864995346e-10,
-3.94142098669101e-10,
-1.810635437151019e-10,
-6.91439701011354e-11,
-2.251972284942532e-11,
-6.3526765579847e-12,
-1.559449675923247e-12,
-3.28875531207771e-13,
-5.627969546130126e-14,
-6.058139070972794e-15,
5.91732005373947e-16,
7.194454835529389e-16,
2.794829003561654e-16,
-4.008390572467275e-7,
1.292324523118452e-10,
1.487408454606769e-10,
1.140960372338883e-10,
6.56021010999988e-11,
3.014013217542024e-11,
1.151244120052383e-11,
3.75125434514584e-12,
1.059208243091025e-12,
2.605339755265935e-13,
5.519239634312988e-14,
9.55690522913092e-15,
1.080074611788536e-15,
-7.35388906600106e-17,
-1.111447254690815e-16,
-4.404462527722446e-17,
6.408044263345523e-8,
-1.978689245695557e-11,
-2.277413241946318e-11,
-1.74700173796099e-11,
-1.00452999511857e-11,
-4.615674646142924e-12,
-1.763387237278036e-12,
-5.748298834597316e-13,
-1.624494900488323e-13,
-4.003037623475262e-14,
-8.51468694002256e-15,
-1.489900874715171e-15,
-1.75423088282232e-16,
7.76616856134648e-18,
1.581149585941034e-17,
6.396102456729262e-18,
-9.47339224694026e-9,
2.806534551966423e-12,
3.230276980309296e-12,
2.478001153221781e-12,
1.424923630746253e-12,
6.54794446579872e-13,
2.502074020239298e-13,
8.15941372725506e-14,
2.307704578312525e-14,
5.696011875671969e-15,
1.216049548443181e-15,
2.147910096112926e-16,
2.619063473476301e-17,
-6.46187610558447e-19,
-2.085143509791671e-18,
-8.61684214789955e-19,
1.322883955061917e-9,
-3.7620169014873e-13,
-4.33007023342976e-13,
-3.321745412556387e-13,
-1.910186494572894e-13,
-8.77865411245591e-14,
-3.355065654381961e-14,
-1.094503917359744e-14,
-3.097852387280228e-15,
-7.65820606689669e-16,
-1.640605799791104e-16,
-2.923028751790788e-17,
-3.67645918567703e-18,
2.89113760552175e-20,
2.595044582460809e-19,
1.097080467297499e-19,
-1.696842870573713e-10,
4.64510893584011e-14,
5.34655972914853e-14,
4.101611024059967e-14,
2.358746152645338e-14,
1.084096792726432e-14,
4.143915081368412e-15,
1.352284190155571e-15,
3.830003350970383e-16,
9.48129988367274e-17,
2.037387461251867e-17,
3.657686580062797e-18,
4.722915907380297e-19,
2.8265007140249e-21,
-2.982942522420859e-20,
-1.290236852274554e-20,
// [{0,0.001},{2.,0.01}]: m=14
0.01355312248913781,
-7.80754671988926e-6,
-8.98391441485519e-6,
-6.88795828951496e-6,
-3.95645508035135e-6,
-1.814127211211576e-6,
-6.90152019756668e-7,
-2.23051068545303e-7,
-6.19227349156931e-8,
-1.468347388579525e-8,
-2.85116606738123e-9,
-3.77584209059179e-10,
9.653777201059e-12,
3.01961490577221e-11,
1.539729280387355e-11,
5.08778093342834e-12,
-0.02525361003541539,
0.00001348980089864317,
0.00001552296966154197,
0.00001190244670180038,
6.83793827847674e-6,
3.1364163025532e-6,
1.194009049160976e-6,
3.8643235106298e-7,
1.075939136687111e-7,
2.567812612577237e-8,
5.06681335708375e-9,
7.10292888087623e-10,
4.9114660530527e-12,
-4.48167979050704e-11,
-2.417367671535973e-11,
-8.13025384681239e-12,
0.02363723185044202,
-0.00001176951777587515,
-0.00001354389504493769,
-0.00001038571305803002,
-5.96743863774756e-6,
-2.737930438035522e-6,
-1.042918611786677e-6,
-3.379359375916787e-7,
-9.43254178313573e-8,
-2.263432373484423e-8,
-4.52606756371575e-9,
-6.63186345369764e-10,
-2.05294389443261e-11,
3.35475984712047e-11,
1.9241666025495e-11,
6.58521004622594e-12,
-0.01480982885846966,
6.90515152157671e-6,
7.94642286915101e-6,
6.09384672352584e-6,
3.501849540002797e-6,
1.60709281885388e-6,
6.12475671023512e-7,
1.986646193740318e-7,
5.55706578057925e-8,
1.339697909112346e-8,
2.709123470710422e-9,
4.11262577104433e-10,
2.034456380292924e-11,
-1.683603353052943e-11,
-1.033496570482711e-11,
-3.598920210467699e-12,
0.00698443795120462,
-3.06166306160007e-6,
-3.52344666422222e-6,
-2.702161268720174e-6,
-1.552975872553884e-6,
-7.12858762607844e-7,
-2.717962552062886e-7,
-8.82400728356211e-8,
-2.472867791966918e-8,
-5.98566692287764e-9,
-1.22205134561281e-9,
-1.909720251889154e-10,
-1.225343355140072e-11,
6.35343490033302e-12,
4.207718225759644e-12,
1.491008962331512e-12,
-0.002643615240914738,
1.093376596139752e-6,
1.258318342260518e-6,
9.65061509013218e-7,
5.5468995905107e-7,
2.546672477742954e-7,
9.71364689987273e-8,
3.156084101464584e-8,
8.85920869602236e-9,
2.151968490467097e-9,
4.42996296531949e-10,
7.09220869490462e-11,
5.397967522177115e-12,
-1.916782553456503e-12,
-1.383364627371232e-12,
-4.989144539717493e-13,
0.000836246578174891,
-3.27361439958435e-7,
-3.76753724989367e-7,
-2.889619031367127e-7,
-1.661013192038398e-7,
-7.62729365274119e-8,
-2.910247354160869e-8,
-9.46239547505362e-9,
-2.659971620946075e-9,
-6.48135072191575e-10,
-1.343871991341987e-10,
-2.196004360086668e-11,
-1.88891973023063e-12,
4.79737728195275e-13,
3.821557346505219e-13,
1.403182013742595e-13,
-0.0002273268805922855,
8.44695883268941e-8,
9.72162144460836e-8,
7.45655695149284e-8,
4.286512278108561e-8,
1.968648280819228e-8,
7.51383728676936e-9,
2.444585404874022e-9,
6.88085113730694e-10,
1.681229159797876e-10,
3.508092290901109e-11,
5.834136627956125e-12,
5.505147707168999e-13,
-1.019634250208334e-13,
-9.11568545117606e-14,
-3.408891667903866e-14,
0.00005419963001102709,
-1.916533489430011e-8,
-2.205780032923963e-8,
-1.691908070500423e-8,
-9.72685373235131e-9,
-4.467827447109193e-9,
-1.705731544431536e-9,
-5.552628481629645e-10,
-1.564727304723097e-10,
-3.832590096614223e-11,
-8.04221451931583e-12,
-1.35800029753609e-12,
-1.378195660723689e-13,
1.866270505780243e-14,
1.915084150096499e-14,
7.297300404090487e-15,
-0.00001151114566276178,
3.88257037062933e-9,
4.46860399264066e-9,
3.427677276538166e-9,
1.970709315290054e-9,
9.05317177092584e-10,
3.457196434952584e-10,
1.125985466730849e-10,
3.176336363953086e-11,
7.79724363278908e-12,
1.644376633140998e-12,
2.813982923863126e-13,
3.029067091318425e-14,
-2.95866045968945e-15,
-3.597226026641632e-15,
-1.397413892374361e-15,
2.204615414189456e-6,
-7.10778640340549e-10,
-8.18074825709979e-10,
-6.2752833956115e-10,
-3.608116335615159e-10,
-1.657707625947565e-10,
-6.33184402261888e-11,
-2.063190334657444e-11,
-5.825646598351396e-12,
-1.432937178417379e-12,
-3.035582475206903e-13,
-5.256299107244216e-14,
-5.940412013080082e-15,
4.04463863017406e-16,
6.112960627385594e-16,
2.422454766183146e-16,
-3.8453253684157e-7,
1.187345161889409e-10,
1.36659943593875e-10,
1.048317261004141e-10,
6.02784834085438e-11,
2.769711998204948e-11,
1.058149789801481e-11,
3.449362682352461e-12,
9.74805590137414e-13,
2.402091885640268e-13,
5.109392506555825e-14,
8.94045439531614e-15,
1.052677190390532e-15,
-4.65945519132854e-17,
-9.48768558650925e-17,
-3.838007552662919e-17,
6.15751606838831e-8,
-1.824199355892325e-11,
-2.099624669386556e-11,
-1.610658272686292e-11,
-9.26175930709783e-12,
-4.256051608013624e-12,
-1.626305176630729e-12,
-5.30347872668918e-13,
-1.499968221958574e-13,
-3.702309064430741e-14,
-7.90410890420964e-15,
-1.396102758146393e-15,
-1.702339318950663e-16,
4.20033242882686e-18,
1.355320449229686e-17,
5.600828050461565e-18,
-9.11692156181674e-9,
2.595610423441078e-12,
2.987539021229701e-12,
2.291842384941718e-12,
1.317934076279113e-12,
6.05682297407504e-13,
2.314813507924464e-13,
7.5514151712164e-14,
2.137290998901984e-14,
5.283394384610352e-15,
1.131755831898033e-15,
2.01598721266722e-16,
2.533698296048365e-17,
-2.09456940263855e-19,
-1.79392322982601e-18,
-7.580034019148893e-19,
1.27495710135388e-9,
-3.4897523481969e-13,
-4.016734632216137e-13,
-3.081436452263693e-13,
-1.772066442388924e-13,
-8.14454751824212e-14,
-3.113221066380664e-14,
-1.015938717108952e-14,
-2.877395547355513e-15,
-7.123117638283208e-16,
-1.530664249290336e-16,
-2.748040937251995e-17,
-3.548577900778073e-18,
-2.13424460008641e-20,
2.239999605174088e-19,
9.69197658997169e-20,
-1.637505492636802e-10,
4.32059978843259e-14,
4.97309289019176e-14,
3.815176605467709e-14,
2.194105196733567e-14,
1.008501387026058e-14,
3.855529035414853e-15,
1.258553705932328e-15,
3.566725638442387e-16,
8.84088645805223e-17,
1.905136458571643e-17,
3.444113937936758e-18,
4.551495732887338e-19,
8.10463350947245e-21,
-2.581642044549817e-20,
-1.139169673618453e-20,
// [{0,0.001},{2.,0.01}]: m=15
0.01262680501770769,
-6.74490044932158e-6,
-7.76148483077098e-6,
-5.95122335090019e-6,
-3.41896913923837e-6,
-1.568208151276598e-6,
-5.97004524580488e-7,
-1.932161755314898e-7,
-5.37969568343555e-8,
-1.283906306288618e-8,
-2.533406678541876e-9,
-3.55146444043811e-10,
-2.4557330265263e-12,
2.24083989525352e-11,
1.208683835767987e-11,
4.06512692340619e-12,
-0.02363723185044201,
0.00001176951777587515,
0.00001354389504493768,
0.00001038571305803002,
5.96743863774756e-6,
2.737930438035522e-6,
1.042918611786676e-6,
3.379359375916787e-7,
9.43254178313573e-8,
2.263432373484423e-8,
4.52606756371575e-9,
6.63186345369764e-10,
2.05294389443261e-11,
-3.35475984712047e-11,
-1.9241666025495e-11,
-6.58521004622594e-12,
0.02221474328770449,
-0.00001035772728236506,
-0.00001191963430372652,
-9.14077008528876e-6,
-5.2527743100042e-6,
-2.41063922828082e-6,
-9.18713506535268e-7,
-2.979969290610478e-7,
-8.33559867086887e-8,
-2.009546863668519e-8,
-4.063685206065633e-9,
-6.1689386565665e-10,
-3.05168457043939e-11,
2.52540502957941e-11,
1.550244855724066e-11,
5.398380315701549e-12,
-0.01396887590241002,
6.12332612320035e-6,
7.04689332844468e-6,
5.40432253744053e-6,
3.105951745107871e-6,
1.425717525215736e-6,
5.43592510412595e-7,
1.76480145671248e-7,
4.945735583934e-8,
1.197133384575569e-8,
2.444102691225709e-9,
3.819440503778471e-10,
2.450686710280363e-11,
-1.270686980066598e-11,
-8.4154364515194e-12,
-2.982017924663076e-12,
0.00660903810228657,
-2.73344149034931e-6,
-3.14579585565122e-6,
-2.412653772532985e-6,
-1.386724897627642e-6,
-6.36668119435723e-7,
-2.428411724968124e-7,
-7.89021025366127e-8,
-2.214802174005535e-8,
-5.379921226167606e-9,
-1.107490741329843e-9,
-1.773052173726101e-10,
-1.349491880544205e-11,
4.79195638364133e-12,
3.458411568428051e-12,
1.247286134929314e-12,
-0.002508739734486678,
9.82084319865628e-7,
1.130261174956965e-6,
8.66885709401594e-7,
4.98303957606606e-7,
2.288188095799771e-7,
8.73074206239624e-8,
2.838718642487885e-8,
7.97991486275826e-9,
1.944405216554881e-9,
4.031615973983087e-10,
6.58801308018201e-11,
5.666759190586673e-12,
-1.439213184588841e-12,
-1.146467203946192e-12,
-4.209546041202864e-13,
0.000795644082080204,
-2.95643559145902e-7,
-3.40256750563333e-7,
-2.609794933038148e-7,
-1.500279297347e-7,
-6.89026898290869e-8,
-2.629843050385104e-8,
-8.55604891711077e-9,
-2.408297898072095e-9,
-5.884302059329003e-10,
-1.22783230182328e-10,
-2.041947819799037e-11,
-1.926801697528897e-12,
3.56871987570975e-13,
3.19048990791976e-13,
1.193112083782905e-13,
-0.0002167985208403536,
7.66613397799672e-8,
8.82312015503489e-8,
6.76763229990686e-8,
3.89074150323813e-8,
1.787130983577207e-8,
6.82292619582506e-9,
2.221051398561503e-9,
6.25890923564978e-10,
1.533036042804295e-10,
3.216885816711076e-11,
5.432001206489995e-12,
5.512782664944793e-13,
-7.46508201682544e-14,
-7.66033661164735e-14,
-2.918920166830801e-14,
0.00005180015539185011,
-1.74715666455434e-8,
-2.010871794122797e-8,
-1.542454772473949e-8,
-8.86819190748524e-9,
-4.073927291712798e-9,
-1.555738393738694e-9,
-5.066934593789505e-10,
-1.429351361934968e-10,
-3.508759630173952e-11,
-7.399694839213e-12,
-1.266292313928966e-12,
-1.363080188607352e-13,
1.331397209339184e-14,
1.618751710927594e-14,
6.288362494555838e-15,
-0.00001102306857618916,
3.55389103850619e-9,
4.090371638648e-9,
3.137639787610524e-9,
1.804057069218052e-9,
8.28853307981935e-10,
3.165920080444816e-10,
1.031594536864142e-10,
2.912821511430153e-11,
7.16468145551807e-12,
1.517790279073734e-12,
2.628147809790088e-13,
2.970203654131377e-14,
-2.0223199843191e-15,
-3.056479112209145e-15,
-1.211226831691067e-15,
2.114929532369193e-6,
-6.53039981695875e-10,
-7.51629853969615e-10,
-5.76574619527267e-10,
-3.31531731199911e-10,
-1.523341932080471e-10,
-5.81982511757495e-11,
-1.89714989127841e-11,
-5.361431925945315e-12,
-1.321150830314854e-12,
-2.810166513618927e-13,
-4.917251075537863e-14,
-5.789726139962371e-15,
2.56269877072795e-16,
5.218227771853065e-16,
2.110905500428805e-16,
-3.69499159632066e-7,
1.094642342637209e-10,
1.259916066383064e-10,
9.66503338666393e-11,
5.5576788697719e-11,
2.553917472280442e-11,
9.75892653719291e-12,
3.182444930563636e-12,
9.00082361066276e-13,
2.221637147823787e-13,
4.743009165642721e-14,
8.37760592007162e-15,
1.021537057348962e-15,
-2.51982095816341e-17,
-8.13260448576898e-17,
-3.360808252256317e-17,
5.925816297829716e-8,
-1.687101814171344e-11,
-1.941848611898325e-11,
-1.489657846715859e-11,
-8.5663431461826e-12,
-3.93682996029391e-12,
-1.504588638034971e-12,
-4.90828875556727e-13,
-1.389201953285055e-13,
-3.434113938244244e-14,
-7.35621277178772e-15,
-1.310355186336764e-15,
-1.646853646646222e-16,
1.36196415280431e-18,
1.166027528000685e-17,
4.926604258426684e-18,
-8.7862746008249e-9,
2.407577212505305e-12,
2.771141126102489e-12,
2.12587875855104e-12,
1.222544920081794e-12,
5.61889450185409e-13,
2.147791175732719e-13,
7.0088363731395e-14,
1.985045436198586e-14,
4.913888091455408e-15,
1.055845635926596e-15,
1.895212429302384e-16,
2.445670639326136e-17,
1.38555811207376e-19,
-1.548412285206756e-18,
-6.695297757472081e-19,
1.230378066957977e-9,
-3.24598378418835e-13,
-3.736189446941921e-13,
-2.866269279591078e-13,
-1.648389493364072e-13,
-7.57668077686119e-14,
-2.896587588774462e-14,
-9.45528968118025e-15,
-2.67962242495069e-15,
-6.642039156286021e-16,
-1.431315658268113e-16,
-2.587578548334032e-17,
-3.419810893768558e-18,
-6.13830980197862e-20,
1.939065117532168e-19,
8.594089635954783e-20,
-1.582173960689359e-10,
4.02891758176355e-14,
4.63740085297099e-14,
3.557706859689082e-14,
2.046104782821899e-14,
9.40538987079081e-15,
3.596203827624059e-15,
1.174230196198162e-15,
3.329648700389993e-16,
8.26304718746722e-17,
1.785250861594795e-17,
3.247916802631876e-18,
4.381552225498995e-19,
1.236209935313545e-20,
-2.239572339548941e-20,
-1.014654969729588e-20,
// [{0,0.001},{2.,0.01}]: m=16
0.01181861592522101,
-5.88475888793757e-6,
-6.77194752246884e-6,
-5.19285652901501e-6,
-2.98371931887378e-6,
-1.368965219017761e-6,
-5.21459305893338e-7,
-1.689679687958393e-7,
-4.71627089156786e-8,
-1.131716186742211e-8,
-2.263033781857875e-9,
-3.31593172684882e-10,
-1.0264719472163e-11,
1.67737992356023e-11,
9.6208330127475e-12,
3.292605023112972e-12,
-0.02221474328770448,
0.00001035772728236506,
0.00001191963430372652,
9.14077008528876e-6,
5.2527743100042e-6,
2.41063922828082e-6,
9.18713506535268e-7,
2.979969290610478e-7,
8.33559867086887e-8,
2.009546863668518e-8,
4.063685206065633e-9,
6.16893865656649e-10,
3.05168457043939e-11,
-2.52540502957941e-11,
-1.550244855724066e-11,
-5.39838031570155e-12,
0.02095331385361504,
-9.18498918480052e-6,
-0.00001057033999266702,
-8.10648380616079e-6,
-4.65892761766181e-6,
-2.138576287823604e-6,
-8.15388765618893e-7,
-2.64720218506872e-7,
-7.418603375901e-8,
-1.795700076863354e-8,
-3.666154036838564e-9,
-5.72916075566771e-10,
-3.676030065420545e-11,
1.906030470099897e-11,
1.26231546772791e-11,
4.473026886994615e-12,
-0.01321807620457391,
5.46688298069882e-6,
6.29159171130265e-6,
4.82530754506614e-6,
2.773449795255379e-6,
1.27333623887149e-6,
4.85682344993642e-7,
1.578042050732308e-7,
4.429604348011225e-8,
1.07598424523356e-8,
2.21498148265977e-9,
3.546104347452356e-10,
2.69898376108862e-11,
-9.58391276728258e-12,
-6.9168231368562e-12,
-2.494572269858673e-12,
0.006271849336216433,
-2.45521079966401e-6,
-2.82565293739234e-6,
-2.167214273503931e-6,
-1.245759894016482e-6,
-5.72047023949928e-7,
-2.182685515599005e-7,
-7.09679660621953e-8,
-1.994978715689514e-8,
-4.861013041387075e-9,
-1.007903993495744e-9,
-1.647003270045451e-10,
-1.416689797646596e-11,
3.59803296147218e-12,
2.866168009865441e-12,
1.05238651030066e-12,
-0.002386932246203858,
8.86930677428663e-7,
1.02077025167959e-6,
7.82938479903458e-7,
4.50083789199507e-7,
2.067080694851492e-7,
7.88952915107457e-8,
2.56681467510686e-8,
7.22489369414147e-9,
1.765290617780113e-9,
3.683496905429584e-10,
6.125843459323448e-11,
5.780405092485479e-12,
-1.070615962716692e-12,
-9.57146972371262e-13,
-3.579336251327084e-13,
0.000758794822948214,
-2.68314689231546e-7,
-3.088092054281327e-7,
-2.368671304982067e-7,
-1.36175952614178e-7,
-6.254958442559e-8,
-2.388024168553601e-8,
-7.77367989501371e-9,
-2.190618232491173e-9,
-5.365626149849232e-10,
-1.125910035856299e-10,
-1.901200422285115e-11,
-1.929473932749953e-12,
2.61277870586995e-13,
2.681117814086715e-13,
1.021622058404993e-13,
-0.0002072006223376173,
6.98862667716969e-8,
8.04348719830605e-8,
6.16981910663192e-8,
3.547276772619666e-8,
1.629570921110015e-8,
6.22295359187579e-9,
2.026773843042273e-9,
5.717405463419026e-10,
1.403503855964895e-10,
2.959877944121358e-11,
5.065169271153318e-12,
5.452320775639606e-13,
-5.32558882945997e-14,
-6.475006853483362e-14,
-2.515345002360975e-14,
0.00004960380850514074,
-1.599250965239911e-8,
-1.84066723498836e-8,
-1.41193790258097e-8,
-8.11825680087673e-9,
-3.729839881043499e-9,
-1.424664034335642e-9,
-4.642175409797551e-10,
-1.310769678414613e-10,
-3.224106650683233e-11,
-6.83005624649978e-12,
-1.182666512693418e-12,
-1.336591641935996e-13,
9.10043995261736e-15,
1.375415599227613e-14,
5.450520725485384e-15,
-0.00001057463944476907,
3.26519788656761e-9,
3.7581469425505e-9,
2.8828713121589e-9,
1.657657629104791e-9,
7.61670493974311e-10,
2.909910753584892e-10,
9.48574356052743e-11,
2.680714290256461e-11,
6.60574999589265e-12,
1.405082356804952e-12,
2.458623890834694e-13,
2.894860807135798e-14,
-1.28135022835505e-15,
-2.6091128429038e-15,
-1.055452265452543e-15,
2.032245939364306e-6,
-6.02053422083444