/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.util.AsyncGUIJob;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

final class AsyncInitSupport
implements AWTEventListener,
HierarchyListener,
Runnable,
ActionListener {
    private static final Object CANCELLED_LOCK = new Object();
    private Task initTask;
    private boolean wasCancelled;
    private Component comp4Init;
    private AsyncGUIJob initJob;
    Timer timer = null;

    public AsyncInitSupport(Component component, AsyncGUIJob asyncGUIJob) {
        this.comp4Init = component;
        this.initJob = asyncGUIJob;
        if (component.isShowing()) {
            throw new IllegalStateException("Component already shown, can't be inited: " + component);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8192L);
        component.addHierarchyListener(this);
        if (!RepaintManager.currentManager(component).isDoubleBufferingEnabled()) {
            this.timer = new Timer(20, this);
            this.timer.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.wasCancelled || this.initTask != null) {
            this.detach();
            return;
        }
        if (this.comp4Init != null && this.comp4Init.isDisplayable()) {
            this.start();
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() instanceof Component && SwingUtilities.isDescendingFrom(this.comp4Init, (Component)aWTEvent.getSource())) {
            this.start();
        }
    }

    private void start() {
        this.detach();
        if (this.initTask == null) {
            this.initTask = RequestProcessor.getDefault().post(this);
        }
    }

    private void detach() {
        if (this.timer != null) {
            this.timer.stop();
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && !this.comp4Init.isShowing()) {
            this.comp4Init.removeHierarchyListener(this);
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl;
            this.initJob.construct();
            this.comp4Init.removeHierarchyListener(this);
            Object object = CANCELLED_LOCK;
            synchronized (object) {
                bl = this.wasCancelled;
            }
            if (!bl) {
                SwingUtilities.invokeLater(this);
            }
        } else {
            this.initJob.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        if (this.initTask != null && !this.initTask.isFinished() && this.initJob instanceof Cancellable) {
            Object object = CANCELLED_LOCK;
            synchronized (object) {
                this.wasCancelled = true;
            }
            ((Cancellable)((Object)this.initJob)).cancel();
        }
    }
}

