/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import org.tigris.swidgets.Horizontal;
import org.tigris.swidgets.LineLayout;
import org.tigris.swidgets.Orientation;

public class SerialLayout
extends LineLayout {
    public static final int LEFTTORIGHT = 10;
    public static final int TOPTOBOTTOM = 10;
    public static final int RIGHTTOLEFT = 11;
    public static final int BOTTOMTOTOP = 11;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String NORTHEAST = "NorthEast";
    public static final String NORTHWEST = "NorthWest";
    public static final String SOUTHEAST = "SouthEast";
    public static final String SOUTHWEST = "SouthWest";
    public static final int LEFT = 20;
    public static final int RIGHT = 21;
    public static final int TOP = 20;
    public static final int BOTTOM = 21;
    public static final int CENTER = 22;
    public static final int FILL = 23;
    private String position = "West";
    private int direction = 10;
    private int alignment = 20;

    public SerialLayout() {
        this(Horizontal.getInstance(), WEST, 10, 20);
    }

    public SerialLayout(Orientation orientation) {
        this(orientation, WEST, 10, 20);
    }

    public SerialLayout(Orientation orientation, String string) {
        this(orientation, string, 10, 20);
    }

    public SerialLayout(Orientation orientation, String string, int n) {
        this(orientation, string, n, 20);
    }

    public SerialLayout(Orientation orientation, String string, int n, int n2) {
        super(orientation);
        this.position = string;
        this.direction = n;
        this.alignment = n2;
    }

    public SerialLayout(Orientation orientation, String string, int n, int n2, int n3) {
        super(orientation, n3);
        this.position = string;
        this.direction = n;
        this.alignment = n2;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = this._orientation.getBreadth(container.getPreferredSize());
        if (this.direction == 10) {
            Point point = this.position.equals(EAST) ? new Point(container.getWidth() - (insets.right + this.preferredLayoutSize((Container)container).width), insets.top) : new Point(insets.left, insets.top);
            int n2 = container.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (component == null || !component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                if (this.alignment == 23) {
                    this._orientation.setBreadth(dimension, n);
                }
                component.setSize(dimension);
                component.setLocation(point);
                point = this._orientation.addToPosition(point, component);
                point = this._orientation.addToPosition(point, this._gap);
            }
        } else {
            int n3 = this._orientation.getLastUsablePosition(container);
            int n4 = this._orientation.getFirstUsableOffset(container);
            Point point = this._orientation.newPoint(n3, n4);
            int n5 = container.getComponentCount();
            for (int i = 0; i < n5; ++i) {
                Component component = container.getComponent(i);
                if (component == null || !component.isVisible()) continue;
                point = this._orientation.subtractFromPosition(point, component);
                Dimension dimension = component.getPreferredSize();
                if (this.alignment == 23) {
                    this._orientation.setBreadth(dimension, n);
                }
                component.setSize(dimension);
                component.setLocation(point);
                point = this._orientation.subtractFromPosition(point, this._gap);
            }
        }
    }
}

