/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.tigris.swidgets.Horizontal;
import org.tigris.swidgets.SerialLayout;

public abstract class Dialog
extends JDialog
implements ActionListener {
    public static final int CLOSE_OPTION = 0;
    public static final int YES_NO_OPTION = 1;
    public static final int YES_NO_HELP_OPTION = 2;
    public static final int YES_NO_CANCEL_OPTION = 3;
    public static final int YES_NO_CANCEL_HELP_OPTION = 4;
    public static final int OK_CANCEL_OPTION = 5;
    public static final int OK_CANCEL_HELP_OPTION = 6;
    public static final int DEFAULT_OPTION = 0;
    private int leftBorder = 10;
    private int rightBorder = 10;
    private int topBorder = 10;
    private int bottomBorder = 10;
    private int componentGap = 10;
    private int labelGap = 5;
    private int buttonGap = 5;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton closeButton = null;
    private JButton yesButton = null;
    private JButton noButton = null;
    private JButton helpButton = null;
    private JPanel mainPanel;
    private JComponent content;
    private JPanel buttonPanel;
    private int optionType;

    public Dialog(Frame frame, String string, boolean bl) {
        this(frame, string, 0, bl);
    }

    public Dialog(Frame frame, String string, int n, boolean bl) {
        super(frame, string, bl);
        this.optionType = n;
        JButton[] jButtonArray = this.createButtons();
        this.nameButtons();
        this.content = null;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, this.bottomBorder));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder));
        this.getContentPane().add(this.mainPanel);
        this.buttonPanel = new JPanel(new SerialLayout(Horizontal.getInstance(), "East", 10, 20, this.buttonGap));
        this.mainPanel.add((Component)this.buttonPanel, "South");
        for (int i = 0; i < jButtonArray.length; ++i) {
            this.buttonPanel.add(jButtonArray[i]);
            jButtonArray[i].addActionListener(this);
        }
        this.getRootPane().setDefaultButton(jButtonArray[0]);
    }

    public JComponent getContent() {
        return this.content;
    }

    public final void setContent(JComponent jComponent) {
        if (this.content != null) {
            this.mainPanel.remove(this.content);
        }
        this.content = jComponent;
        this.mainPanel.add((Component)this.content, "Center");
        this.pack();
        this.centerOnParent();
    }

    public void addButton(JButton jButton) {
        this.buttonPanel.add(jButton);
    }

    public void addButton(JButton jButton, int n) {
        this.buttonPanel.add((Component)jButton, n);
    }

    protected JButton getOkButton() {
        return this.okButton;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    protected JButton getCloseButton() {
        return this.closeButton;
    }

    protected JButton getYesButton() {
        return this.yesButton;
    }

    protected JButton getNoButton() {
        return this.noButton;
    }

    protected JButton getHelpButton() {
        return this.helpButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton || actionEvent.getSource() == this.cancelButton || actionEvent.getSource() == this.closeButton || actionEvent.getSource() == this.yesButton || actionEvent.getSource() == this.noButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private JButton[] createButtons() {
        JButton[] jButtonArray;
        switch (this.optionType) {
            case 1: {
                this.yesButton = new JButton();
                this.noButton = new JButton();
                jButtonArray = new JButton[]{this.yesButton, this.noButton};
                break;
            }
            case 2: {
                this.yesButton = new JButton();
                this.noButton = new JButton();
                this.helpButton = new JButton();
                jButtonArray = new JButton[]{this.yesButton, this.noButton, this.helpButton};
                break;
            }
            case 3: {
                this.yesButton = new JButton();
                this.noButton = new JButton();
                this.cancelButton = new JButton();
                jButtonArray = new JButton[]{this.yesButton, this.noButton, this.cancelButton};
                break;
            }
            case 4: {
                this.yesButton = new JButton();
                this.noButton = new JButton();
                this.cancelButton = new JButton();
                this.helpButton = new JButton();
                jButtonArray = new JButton[]{this.yesButton, this.noButton, this.cancelButton, this.helpButton};
                break;
            }
            case 5: {
                this.okButton = new JButton();
                this.cancelButton = new JButton();
                jButtonArray = new JButton[]{this.okButton, this.cancelButton};
                break;
            }
            case 6: {
                this.okButton = new JButton();
                this.cancelButton = new JButton();
                this.helpButton = new JButton();
                jButtonArray = new JButton[]{this.okButton, this.cancelButton, this.helpButton};
                break;
            }
            default: {
                this.closeButton = new JButton();
                jButtonArray = new JButton[]{this.closeButton};
            }
        }
        return jButtonArray;
    }

    private void centerOnParent() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getParent().getSize();
        int n = this.getParent().getX() - dimension.width + (int)((double)(dimension.width + dimension2.width) / 2.0);
        int n2 = this.getParent().getY() - dimension.height + (int)((double)(dimension.height + dimension2.height) / 2.0);
        this.setLocation(n, n2);
    }

    protected abstract void nameButtons();

    protected int getComponentGap() {
        return this.componentGap;
    }

    protected int getLabelGap() {
        return this.labelGap;
    }
}

