/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.memoryimpl.MultivaluedIndexImpl;

public class MultivalueLog {
    private static final byte OP_ADD = 0;
    private static final byte OP_REMOVE = 1;
    private static final byte OP_REPLACE = 2;
    private static final byte OP_ADD_ALL = 3;
    private static final int NULL_POSITION = -1;
    private ArrayList log = new ArrayList();
    private MultivaluedIndexImpl index;
    private boolean rollingBack = false;

    public MultivalueLog(MultivaluedIndexImpl index) {
        this.index = index;
    }

    public void clear() {
        this.log.clear();
    }

    public void logAdd(Object key, Object value) {
        if (this.rollingBack) {
            return;
        }
        Record rec = new Record(1, key, value);
        this.log.add(0, rec);
    }

    public void logAdd(Object key, Object value, int position) {
        if (this.rollingBack) {
            return;
        }
        Record rec = new Record(1, key, value, position);
        this.log.add(0, rec);
    }

    public void logRemove(Object key, Object value) {
        if (this.rollingBack) {
            return;
        }
        Record rec = new Record(0, key, value);
        this.log.add(0, rec);
    }

    public void logRemove(Object key, Object value, int position) {
        if (this.rollingBack) {
            return;
        }
        Record rec = new Record(0, key, value, position);
        this.log.add(0, rec);
    }

    public void logRemoveKey(Object key, Object value) {
        if (this.rollingBack) {
            return;
        }
        Record rec = new Record(3, key, value);
        this.log.add(0, rec);
    }

    public void logReplace(Object key, Object oldValue, int position) {
        if (this.rollingBack) {
            return;
        }
        Record rec = new Record(2, key, oldValue, position);
        this.log.add(0, rec);
    }

    public void rollBack() throws StorageException {
        this.rollingBack = true;
        Iterator iter = this.log.iterator();
        while (iter.hasNext()) {
            Record rec = (Record)iter.next();
            switch (rec.opCode) {
                case 0: {
                    if (rec.position == -1) {
                        this.index.add(rec.key, rec.value);
                        break;
                    }
                    ((MultivaluedOrderedIndex)((Object)this.index)).add(rec.key, rec.position, rec.value);
                    break;
                }
                case 1: {
                    if (rec.position == -1) {
                        this.index.remove(rec.key, rec.value);
                        break;
                    }
                    ((MultivaluedOrderedIndex)((Object)this.index)).remove(rec.key, rec.position);
                    break;
                }
                case 2: {
                    ((MultivaluedOrderedIndex)((Object)this.index)).replace(rec.key, rec.position, rec.value);
                    break;
                }
                case 3: {
                    this.index.setKey(rec.key, rec.value);
                }
            }
        }
        this.rollingBack = false;
    }

    private static class Record {
        byte opCode;
        Object key;
        Object value;
        int position;

        public Record(byte opCode, Object key, Object value, int position) {
            this.opCode = opCode;
            this.key = key;
            this.value = value;
            this.position = position;
        }

        public Record(byte opCode, Object key, Object value) {
            this.opCode = opCode;
            this.key = key;
            this.value = value;
            this.position = -1;
        }
    }
}

