/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng.classfile;

import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.CommonAST;
import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import antlr.collections.impl.ASTArray;
import org.argouml.language.java.reveng.classfile.ByteToken;
import org.argouml.language.java.reveng.classfile.ClassfileTokenTypes;
import org.argouml.language.java.reveng.classfile.ObjectAST;
import org.argouml.language.java.reveng.classfile.ParserUtils;
import org.argouml.language.java.reveng.classfile.ShortAST;

public class ClassfileParser
extends LLkParser
implements ClassfileTokenTypes {
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_Utf8 = 1;
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SUPER = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_BRIDGE = 64;
    public static final short ACC_VARARGS = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_SYNTHETIC = 4096;
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;
    private String _className = null;
    private AST[] _constant = null;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "ACCESS_MODIFIERS", "ATTRIBUTE_CONSTANT", "CLASS_DEF", "CONSTANT_CLASSINFO", "CONSTANT_DOUBLEINFO", "CONSTANT_FIELDINFO", "CONSTANT_FLOATINFO", "CONSTANT_INTEGERINFO", "CONSTANT_INTERFACE_METHODINFO", "CONSTANT_LONGINFO", "CONSTANT_METHODINFO", "CONSTANT_NAME_TYPE_INFO", "CONSTANT_STRINGINFO", "CONSTANT_UTF8STRING", "CTOR_DEF", "EXTENDS_CLAUSE", "IDENT", "IMPLEMENTS_CLAUSE", "INTERFACE_DEF", "MAGIC", "METHOD_DEF", "PARAMETERS", "PARAMETER_DEF", "SOURCEFILE", "THROWS", "TYPE", "UNKNOWN_ATTRIBUTE", "VARIABLE_DEF", "VERSION", "SIGNATURE", "BYTE"};

    private void setClassName(String name) {
        int lastDot = name.lastIndexOf(47);
        this._className = lastDot == -1 ? name : name.substring(lastDot + 1);
    }

    private String getClassName() {
        return this._className;
    }

    private void initPoolBuffer(int size) {
        this._constant = new AST[size & 0xFFFF];
    }

    private void copyConstant(int index, AST node) {
        this._constant[index] = node;
    }

    private AST getConstant(short index) {
        return this._constant[index & 0xFFFF];
    }

    String convertDescriptor(String desc) {
        return ParserUtils.convertFieldDescriptor(desc);
    }

    String[] convertMethodDescriptor(String desc) {
        return ParserUtils.convertMethodDescriptor(desc);
    }

    protected ClassfileParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
        this.buildTokenTypeASTClassMap();
        this.astFactory = new ASTFactory(this.getTokenTypeToASTClassMap());
    }

    public ClassfileParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 1);
    }

    protected ClassfileParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
        this.buildTokenTypeASTClassMap();
        this.astFactory = new ASTFactory(this.getTokenTypeToASTClassMap());
    }

    public ClassfileParser(TokenStream lexer) {
        this(lexer, 1);
    }

    public ClassfileParser(ParserSharedInputState state) {
        super(state, 1);
        this.tokenNames = _tokenNames;
        this.buildTokenTypeASTClassMap();
        this.astFactory = new ASTFactory(this.getTokenTypeToASTClassMap());
    }

    public final void classfile() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST classfile_AST = null;
        this.magic_number();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.version_number();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.constant_pool();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.type_definition();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.field_block();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.method_block();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.attribute_block();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        AST tmp1_AST = null;
        tmp1_AST = this.astFactory.create(this.LT(1));
        this.astFactory.addASTChild(currentAST, tmp1_AST);
        this.match(1);
        this.returnAST = classfile_AST = currentAST.root;
    }

    public final void magic_number() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST magic_number_AST = null;
        int magic = 0;
        magic = this.u4();
        if (magic != -889275714) {
            throw new SemanticException("magic==0xcafebabe");
        }
        magic_number_AST = currentAST.root;
        currentAST.root = magic_number_AST = this.astFactory.create(23, Integer.toHexString(magic));
        currentAST.child = magic_number_AST != null && magic_number_AST.getFirstChild() != null ? magic_number_AST.getFirstChild() : magic_number_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = magic_number_AST;
    }

    public final void version_number() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST version_number_AST = null;
        short minor = 0;
        short major = 0;
        String verStr = null;
        minor = this.u2();
        major = this.u2();
        version_number_AST = currentAST.root;
        verStr = "" + major + "." + minor;
        currentAST.root = version_number_AST = this.astFactory.create(32, verStr);
        currentAST.child = version_number_AST != null && version_number_AST.getFirstChild() != null ? version_number_AST.getFirstChild() : version_number_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = version_number_AST;
    }

    public final void constant_pool() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        Object constant_pool_AST = null;
        AST cp_AST = null;
        short poolSize = 0;
        int index = 1;
        poolSize = this.u2();
        this.initPoolBuffer(poolSize);
        while (this.LA(1) == 34 && index < (poolSize & 0xFFFF)) {
            this.cp_info();
            cp_AST = this.returnAST;
            this.copyConstant(index++, cp_AST);
            if (cp_AST.getType() != 13 && cp_AST.getType() != 8) continue;
            ++index;
        }
        if (index != (poolSize & 0xFFFF)) {
            throw new SemanticException("index==((int)poolSize & 0xffff)");
        }
        this.returnAST = constant_pool_AST;
    }

    public final void type_definition() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST type_definition_AST = null;
        AST m_AST = null;
        AST c_AST = null;
        AST s_AST = null;
        AST i_AST = null;
        this.access_modifiers();
        m_AST = this.returnAST;
        this.class_info();
        c_AST = this.returnAST;
        this.superclass_info();
        s_AST = this.returnAST;
        this.interface_block();
        i_AST = this.returnAST;
        type_definition_AST = currentAST.root;
        type_definition_AST = (((ShortAST)m_AST).getShortValue() & 0x200) > 0 ? this.astFactory.make(new ASTArray(4).add(this.astFactory.create(22)).add(m_AST).add(c_AST).add(this.astFactory.make(new ASTArray(2).add(this.astFactory.create(19)).add(i_AST)))) : this.astFactory.make(new ASTArray(5).add(this.astFactory.create(6)).add(m_AST).add(c_AST).add(this.astFactory.make(new ASTArray(2).add(this.astFactory.create(19)).add(s_AST))).add(this.astFactory.make(new ASTArray(2).add(this.astFactory.create(21)).add(i_AST))));
        currentAST.root = type_definition_AST;
        currentAST.child = type_definition_AST != null && type_definition_AST.getFirstChild() != null ? type_definition_AST.getFirstChild() : type_definition_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = type_definition_AST;
    }

    public final void field_block() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST field_block_AST = null;
        short fields_count = 0;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (fields_count = this.u2(); this.LA(1) == 34 && fields_count > 0; fields_count = (short)(fields_count - 1)) {
            this.field_info();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (fields_count != 0) {
            throw new SemanticException("fields_count==0");
        }
        this.returnAST = field_block_AST = currentAST.root;
    }

    public final void method_block() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST method_block_AST = null;
        int methods_count = 0;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (methods_count = this.u2(); this.LA(1) == 34 && methods_count > 0; --methods_count) {
            this.method_info();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (methods_count != 0) {
            throw new SemanticException("methods_count==0");
        }
        this.returnAST = method_block_AST = currentAST.root;
    }

    public final void attribute_block() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST attribute_block_AST = null;
        int attributes_count = 0;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (attributes_count = this.u2(); this.LA(1) == 34 && attributes_count > 0; --attributes_count) {
            this.attribute_info();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (attributes_count != 0) {
            throw new SemanticException("attributes_count==0");
        }
        this.returnAST = attribute_block_AST = currentAST.root;
    }

    public final int u4() throws RecognitionException, TokenStreamException {
        int res = 0;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        Object u4_AST = null;
        Token high1 = null;
        AST high1_AST = null;
        Token high2 = null;
        AST high2_AST = null;
        Token low1 = null;
        AST low1_AST = null;
        Token low2 = null;
        AST low2_AST = null;
        high1 = this.LT(1);
        high1_AST = this.astFactory.create(high1);
        this.match(34);
        high2 = this.LT(1);
        high2_AST = this.astFactory.create(high2);
        this.match(34);
        low1 = this.LT(1);
        low1_AST = this.astFactory.create(low1);
        this.match(34);
        low2 = this.LT(1);
        low2_AST = this.astFactory.create(low2);
        this.match(34);
        res = ((ByteToken)high1).getIntValue() << 24 | ((ByteToken)high2).getIntValue() << 16 | ((ByteToken)low1).getIntValue() << 8 | ((ByteToken)low2).getIntValue();
        this.returnAST = u4_AST;
        return res;
    }

    public final short u2() throws RecognitionException, TokenStreamException {
        short res = 0;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        Object u2_AST = null;
        Token high = null;
        AST high_AST = null;
        Token low = null;
        AST low_AST = null;
        high = this.LT(1);
        high_AST = this.astFactory.create(high);
        this.match(34);
        low = this.LT(1);
        low_AST = this.astFactory.create(low);
        this.match(34);
        res = (short)(((ByteToken)high).getShortValue() << 8 | ((ByteToken)low).getShortValue());
        this.returnAST = u2_AST;
        return res;
    }

    public final void cp_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST cp_info_AST = null;
        AST cl_AST = null;
        AST cf_AST = null;
        AST cm_AST = null;
        AST ci_AST = null;
        AST cs_AST = null;
        AST ct_AST = null;
        AST ca_AST = null;
        AST co_AST = null;
        AST cd_AST = null;
        AST cn_AST = null;
        AST cu_AST = null;
        byte tag = 0;
        tag = this.u1();
        if (this.LA(1) == 34 && tag == 7) {
            this.constant_class_info();
            cl_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = cl_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 9) {
            this.constant_fieldref_info();
            cf_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = cf_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 10) {
            this.constant_methodref_info();
            cm_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = cm_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 11) {
            this.constant_interface_methodref_info();
            ci_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = ci_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 8) {
            this.constant_string_info();
            cs_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = cs_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 3) {
            this.constant_integer_info();
            ct_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = ct_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 4) {
            this.constant_float_info();
            ca_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = ca_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 5) {
            this.constant_long_info();
            co_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = co_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 6) {
            this.constant_double_info();
            cd_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = cd_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 12) {
            this.constant_name_and_type_info();
            cn_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = cn_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else if (this.LA(1) == 34 && tag == 1) {
            this.constant_utf8_info();
            cu_AST = this.returnAST;
            cp_info_AST = currentAST.root;
            currentAST.root = cp_info_AST = cu_AST;
            currentAST.child = cp_info_AST != null && cp_info_AST.getFirstChild() != null ? cp_info_AST.getFirstChild() : cp_info_AST;
            currentAST.advanceChildToEnd();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.returnAST = cp_info_AST;
    }

    public final byte u1() throws RecognitionException, TokenStreamException {
        byte res = 0;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        Object u1_AST = null;
        Token val = null;
        AST val_AST = null;
        val = this.LT(1);
        val_AST = this.astFactory.create(val);
        this.match(34);
        res = ((ByteToken)val).getValue();
        this.returnAST = u1_AST;
        return res;
    }

    public final void constant_class_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_class_info_AST = null;
        short name_index = 0;
        name_index = this.u2();
        constant_class_info_AST = currentAST.root;
        currentAST.root = constant_class_info_AST = new ShortAST(7, name_index);
        currentAST.child = constant_class_info_AST != null && constant_class_info_AST.getFirstChild() != null ? constant_class_info_AST.getFirstChild() : constant_class_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_class_info_AST;
    }

    public final void constant_fieldref_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_fieldref_info_AST = null;
        short class_index = 0;
        short name_and_type_index = 0;
        class_index = this.u2();
        name_and_type_index = this.u2();
        constant_fieldref_info_AST = currentAST.root;
        constant_fieldref_info_AST = new ShortAST(9, class_index);
        constant_fieldref_info_AST.addChild(new ShortAST(15, name_and_type_index));
        currentAST.root = constant_fieldref_info_AST;
        currentAST.child = constant_fieldref_info_AST != null && constant_fieldref_info_AST.getFirstChild() != null ? constant_fieldref_info_AST.getFirstChild() : constant_fieldref_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_fieldref_info_AST;
    }

    public final void constant_methodref_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_methodref_info_AST = null;
        short class_index = 0;
        short name_and_type_index = 0;
        class_index = this.u2();
        name_and_type_index = this.u2();
        constant_methodref_info_AST = currentAST.root;
        constant_methodref_info_AST = new ShortAST(14, class_index);
        constant_methodref_info_AST.addChild(new ShortAST(15, name_and_type_index));
        currentAST.root = constant_methodref_info_AST;
        currentAST.child = constant_methodref_info_AST != null && constant_methodref_info_AST.getFirstChild() != null ? constant_methodref_info_AST.getFirstChild() : constant_methodref_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_methodref_info_AST;
    }

    public final void constant_interface_methodref_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_interface_methodref_info_AST = null;
        short class_index = 0;
        short name_and_type_index = 0;
        class_index = this.u2();
        name_and_type_index = this.u2();
        constant_interface_methodref_info_AST = currentAST.root;
        constant_interface_methodref_info_AST = new ShortAST(12, class_index);
        constant_interface_methodref_info_AST.addChild(new ShortAST(15, name_and_type_index));
        currentAST.root = constant_interface_methodref_info_AST;
        currentAST.child = constant_interface_methodref_info_AST != null && constant_interface_methodref_info_AST.getFirstChild() != null ? constant_interface_methodref_info_AST.getFirstChild() : constant_interface_methodref_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_interface_methodref_info_AST;
    }

    public final void constant_string_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_string_info_AST = null;
        short string_index = 0;
        string_index = this.u2();
        constant_string_info_AST = currentAST.root;
        currentAST.root = constant_string_info_AST = new ShortAST(16, string_index);
        currentAST.child = constant_string_info_AST != null && constant_string_info_AST.getFirstChild() != null ? constant_string_info_AST.getFirstChild() : constant_string_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_string_info_AST;
    }

    public final void constant_integer_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_integer_info_AST = null;
        int val = 0;
        val = this.u4();
        constant_integer_info_AST = currentAST.root;
        currentAST.root = constant_integer_info_AST = new ObjectAST(11, new Integer(val));
        currentAST.child = constant_integer_info_AST != null && constant_integer_info_AST.getFirstChild() != null ? constant_integer_info_AST.getFirstChild() : constant_integer_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_integer_info_AST;
    }

    public final void constant_float_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_float_info_AST = null;
        int bytes = 0;
        bytes = this.u4();
        constant_float_info_AST = currentAST.root;
        currentAST.root = constant_float_info_AST = new ObjectAST(10, new Double(Float.intBitsToFloat(bytes)));
        currentAST.child = constant_float_info_AST != null && constant_float_info_AST.getFirstChild() != null ? constant_float_info_AST.getFirstChild() : constant_float_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_float_info_AST;
    }

    public final void constant_long_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_long_info_AST = null;
        int high_bytes = 0;
        int low_bytes = 0;
        long val = 0L;
        high_bytes = this.u4();
        low_bytes = this.u4();
        constant_long_info_AST = currentAST.root;
        currentAST.root = constant_long_info_AST = new ObjectAST(13, new Long((long)high_bytes | (long)low_bytes & 0xFFFFL));
        currentAST.child = constant_long_info_AST != null && constant_long_info_AST.getFirstChild() != null ? constant_long_info_AST.getFirstChild() : constant_long_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_long_info_AST;
    }

    public final void constant_double_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_double_info_AST = null;
        int high_bytes = 0;
        int low_bytes = 0;
        high_bytes = this.u4();
        low_bytes = this.u4();
        constant_double_info_AST = currentAST.root;
        currentAST.root = constant_double_info_AST = new ObjectAST(8, new Double(Double.longBitsToDouble((long)high_bytes | (long)low_bytes & 0xFFFFL)));
        currentAST.child = constant_double_info_AST != null && constant_double_info_AST.getFirstChild() != null ? constant_double_info_AST.getFirstChild() : constant_double_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_double_info_AST;
    }

    public final void constant_name_and_type_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_name_and_type_info_AST = null;
        short name_index = 0;
        short descriptor_index = 0;
        name_index = this.u2();
        descriptor_index = this.u2();
        constant_name_and_type_info_AST = currentAST.root;
        constant_name_and_type_info_AST = new ShortAST(15, name_index);
        constant_name_and_type_info_AST.addChild(new ShortAST(16, descriptor_index));
        currentAST.root = constant_name_and_type_info_AST;
        currentAST.child = constant_name_and_type_info_AST != null && constant_name_and_type_info_AST.getFirstChild() != null ? constant_name_and_type_info_AST.getFirstChild() : constant_name_and_type_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_name_and_type_info_AST;
    }

    public final void constant_utf8_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constant_utf8_info_AST = null;
        short length = 0;
        byte bytebuf = 0;
        int bytepos = 0;
        byte[] bytes = new byte[length];
        for (length = this.u2(); this.LA(1) == 34 && length > 0; length = (short)(length - 1)) {
            bytebuf = this.u1();
            bytes[bytepos++] = bytebuf;
        }
        if (length != 0) {
            throw new SemanticException("length==0");
        }
        constant_utf8_info_AST = currentAST.root;
        String name = new String(bytes);
        currentAST.root = constant_utf8_info_AST = this.astFactory.create(17, name);
        currentAST.child = constant_utf8_info_AST != null && constant_utf8_info_AST.getFirstChild() != null ? constant_utf8_info_AST.getFirstChild() : constant_utf8_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constant_utf8_info_AST;
    }

    public final void access_modifiers() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST access_modifiers_AST = null;
        short modifiers = 0;
        modifiers = this.u2();
        access_modifiers_AST = currentAST.root;
        currentAST.root = access_modifiers_AST = new ShortAST(4, modifiers);
        currentAST.child = access_modifiers_AST != null && access_modifiers_AST.getFirstChild() != null ? access_modifiers_AST.getFirstChild() : access_modifiers_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = access_modifiers_AST;
    }

    public final void class_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST class_info_AST = null;
        short class_info_index = 0;
        class_info_index = this.u2();
        class_info_AST = currentAST.root;
        String class_name = this.getConstant(((ShortAST)this.getConstant(class_info_index)).getShortValue()).getText();
        this.setClassName(class_name);
        currentAST.root = class_info_AST = this.astFactory.create(20, class_name);
        currentAST.child = class_info_AST != null && class_info_AST.getFirstChild() != null ? class_info_AST.getFirstChild() : class_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = class_info_AST;
    }

    public final void superclass_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST superclass_info_AST = null;
        short class_info_index = 0;
        class_info_index = this.u2();
        superclass_info_AST = currentAST.root;
        String class_name = this.getConstant(((ShortAST)this.getConstant(class_info_index)).getShortValue()).getText();
        currentAST.root = superclass_info_AST = this.astFactory.create(20, class_name);
        currentAST.child = superclass_info_AST != null && superclass_info_AST.getFirstChild() != null ? superclass_info_AST.getFirstChild() : superclass_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = superclass_info_AST;
    }

    public final void interface_block() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST interface_block_AST = null;
        short interfaces_count = 0;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (interfaces_count = this.u2(); this.LA(1) == 34 && interfaces_count > 0; interfaces_count = (short)(interfaces_count - 1)) {
            this.interface_info();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (interfaces_count != 0) {
            throw new SemanticException("interfaces_count==0");
        }
        this.returnAST = interface_block_AST = currentAST.root;
    }

    public final void interface_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST interface_info_AST = null;
        short interface_index = 0;
        interface_index = this.u2();
        interface_info_AST = currentAST.root;
        String interface_name = this.getConstant(((ShortAST)this.getConstant(interface_index)).getShortValue()).getText();
        currentAST.root = interface_info_AST = this.astFactory.create(20, interface_name);
        currentAST.child = interface_info_AST != null && interface_info_AST.getFirstChild() != null ? interface_info_AST.getFirstChild() : interface_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = interface_info_AST;
    }

    public final void field_info() throws RecognitionException, TokenStreamException {
        short attributes_count;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST field_info_AST = null;
        AST attr_AST = null;
        short access_flags = 0;
        short name_index = 0;
        short descriptor_index = 0;
        AST signature = this.astFactory.create(33);
        access_flags = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        name_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        descriptor_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (attributes_count = this.u2(); this.LA(1) == 34 && attributes_count > 0; attributes_count = (short)(attributes_count - 1)) {
            this.attribute_info();
            attr_AST = this.returnAST;
            this.astFactory.addASTChild(currentAST, this.returnAST);
            if (attr_AST == null || 33 != attr_AST.getType()) {
                throw new SemanticException("attr_AST != null && SIGNATURE == attr_AST.getType()");
            }
            signature = attr_AST;
        }
        if (attributes_count != 0) {
            throw new SemanticException("attributes_count==0");
        }
        field_info_AST = currentAST.root;
        ShortAST access = new ShortAST(4, access_flags);
        String typeIdent = this.convertDescriptor(this.getConstant(descriptor_index).getText());
        String name = this.getConstant(name_index).getText();
        currentAST.root = field_info_AST = this.astFactory.make(new ASTArray(5).add(this.astFactory.create(31)).add(access).add(this.astFactory.create(29, typeIdent)).add(this.astFactory.create(20, name)).add(signature));
        currentAST.child = field_info_AST != null && field_info_AST.getFirstChild() != null ? field_info_AST.getFirstChild() : field_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = field_info_AST = currentAST.root;
    }

    public final void attribute_info() throws RecognitionException, TokenStreamException {
        AST attribute_info_AST;
        block15: {
            this.returnAST = null;
            ASTPair currentAST = new ASTPair();
            attribute_info_AST = null;
            AST cattr_AST = null;
            AST cvattr_AST = null;
            AST exattr_AST = null;
            AST icattr_AST = null;
            AST lnattr_AST = null;
            AST lattr_AST = null;
            AST lvtattr_AST = null;
            AST sigattr_AST = null;
            AST sattr_AST = null;
            short attribute_name_index = 0;
            int attribute_length = 0;
            String attribute_name = null;
            int bytepos = 0;
            byte bytebuf = 0;
            try {
                attribute_name_index = this.u2();
                if (this.getConstant(attribute_name_index).getType() != 17) {
                    throw new SemanticException("getConstant(attribute_name_index).getType()==CONSTANT_UTF8STRING");
                }
                attribute_name = this.getConstant(attribute_name_index).getText();
                attribute_length = this.u4();
                if (this.LA(1) == 34 && "Code".equals(attribute_name)) {
                    this.code_attribute();
                    cattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = cattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 34 && "ConstantValue".equals(attribute_name)) {
                    this.constantValue_attribute();
                    cvattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = cvattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 34 && "Exceptions".equals(attribute_name)) {
                    this.exceptions_attribute();
                    exattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = exattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 34 && "InnerClasses".equals(attribute_name)) {
                    this.innerClasses_attribute();
                    icattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = icattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 34 && "LineNumberTable".equals(attribute_name)) {
                    this.lineNumberTable_attribute();
                    lnattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = lnattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 34 && "LocalVariableTable".equals(attribute_name)) {
                    this.localVariableTable_attribute();
                    lattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = lattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 34 && "LocalVariableTypeTable".equals(attribute_name)) {
                    this.localVariableTypeTable_attribute();
                    lvtattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = lvtattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 34 && "Signature".equals(attribute_name)) {
                    this.signature_attribute();
                    sigattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = sigattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 34 && attribute_length == 2 && "SourceFile".equals(attribute_name)) {
                    this.sourcefile_attribute();
                    sattr_AST = this.returnAST;
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = sattr_AST;
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                if (this.LA(1) == 1 || this.LA(1) == 34) {
                    byte[] info = new byte[attribute_length];
                    while (this.LA(1) == 34 && bytepos < attribute_length) {
                        bytebuf = this.u1();
                        info[bytepos++] = bytebuf;
                    }
                    if (bytepos != attribute_length) {
                        throw new SemanticException("bytepos==attribute_length");
                    }
                    attribute_info_AST = currentAST.root;
                    currentAST.root = attribute_info_AST = this.astFactory.create(30, attribute_name);
                    currentAST.child = attribute_info_AST != null && attribute_info_AST.getFirstChild() != null ? attribute_info_AST.getFirstChild() : attribute_info_AST;
                    currentAST.advanceChildToEnd();
                    break block15;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (SemanticException se) {
                // empty catch block
            }
        }
        this.returnAST = attribute_info_AST;
    }

    public final void method_info() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST method_info_AST = null;
        AST attr_AST = null;
        short access_flags = 0;
        short name_index = 0;
        short descriptor_index = 0;
        short attributes_count = 0;
        AST exceptions = this.astFactory.create(28);
        AST signature = this.astFactory.create(33);
        access_flags = this.u2();
        name_index = this.u2();
        descriptor_index = this.u2();
        for (attributes_count = this.u2(); this.LA(1) == 34 && attributes_count > 0; attributes_count = (short)(attributes_count - 1)) {
            this.attribute_info();
            attr_AST = this.returnAST;
            if (this.LA(1) == 34 && attr_AST != null && 28 == attr_AST.getType()) {
                exceptions = attr_AST;
                continue;
            }
            if (this.LA(1) == 34 && attr_AST != null && 33 == attr_AST.getType()) {
                signature = attr_AST;
                continue;
            }
            if (this.LA(1) == 34) continue;
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (attributes_count != 0) {
            throw new SemanticException("attributes_count==0");
        }
        method_info_AST = currentAST.root;
        String[] method_descriptor = this.convertMethodDescriptor(this.getConstant(descriptor_index).getText());
        CommonAST parameters = new CommonAST();
        parameters.setType(25);
        for (int i = 1; i < method_descriptor.length; ++i) {
            ShortAST access = new ShortAST(4, 0);
            String paramType = method_descriptor[i];
            String paramIdent = "param" + i;
            AST param = this.astFactory.make(new ASTArray(4).add(this.astFactory.create(26)).add(access).add(this.astFactory.create(29, paramType)).add(this.astFactory.create(20, paramIdent)));
            parameters.addChild(param);
        }
        ShortAST access = new ShortAST(4, access_flags);
        String ident = this.getConstant(name_index).getText();
        if ("<init>".equals(ident)) {
            ident = this.getClassName();
            method_info_AST = this.astFactory.make(new ASTArray(6).add(this.astFactory.create(18)).add(access).add(this.astFactory.create(20, ident)).add(parameters).add(exceptions).add(signature));
        } else {
            String retType = method_descriptor[0];
            method_info_AST = this.astFactory.make(new ASTArray(7).add(this.astFactory.create(24)).add(access).add(this.astFactory.create(29, retType)).add(this.astFactory.create(20, ident)).add(parameters).add(exceptions).add(signature));
        }
        currentAST.root = method_info_AST;
        currentAST.child = method_info_AST != null && method_info_AST.getFirstChild() != null ? method_info_AST.getFirstChild() : method_info_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = method_info_AST;
    }

    public final void code_attribute() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST code_attribute_AST = null;
        short max_stack = 0;
        short max_locals = 0;
        int code_length = 0;
        int codepos = 0;
        byte[] code = null;
        byte bytebuf = 0;
        short exception_table_length = 0;
        int exceptionpos = 0;
        short attribute_count = 0;
        int attributepos = 0;
        max_stack = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        max_locals = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        code_length = this.u4();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        code = new byte[code_length];
        while (this.LA(1) == 34 && codepos < code_length) {
            bytebuf = this.u1();
            this.astFactory.addASTChild(currentAST, this.returnAST);
            code[codepos++] = bytebuf;
        }
        if (codepos != code_length) {
            throw new SemanticException("codepos==code_length");
        }
        exception_table_length = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        while (this.LA(1) == 34 && exceptionpos < (exception_table_length & 0xFFFF)) {
            this.exception_table_entry();
            this.astFactory.addASTChild(currentAST, this.returnAST);
            ++exceptionpos;
        }
        if (exceptionpos != (exception_table_length & 0xFFFF)) {
            throw new SemanticException("exceptionpos==((int)exception_table_length & 0xffff)");
        }
        attribute_count = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        while (this.LA(1) == 34 && attributepos < (attribute_count & 0xFFFF)) {
            this.attribute_info();
            this.astFactory.addASTChild(currentAST, this.returnAST);
            ++attributepos;
        }
        if (attributepos != (attribute_count & 0xFFFF)) {
            throw new SemanticException("attributepos==((int)attribute_count & 0xffff)");
        }
        this.returnAST = code_attribute_AST = currentAST.root;
    }

    public final void constantValue_attribute() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST constantValue_attribute_AST = null;
        short constantvalue_index = 0;
        constantvalue_index = this.u2();
        constantValue_attribute_AST = currentAST.root;
        currentAST.root = constantValue_attribute_AST = new ShortAST(5, constantvalue_index);
        currentAST.child = constantValue_attribute_AST != null && constantValue_attribute_AST.getFirstChild() != null ? constantValue_attribute_AST.getFirstChild() : constantValue_attribute_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = constantValue_attribute_AST;
    }

    public final void exceptions_attribute() throws RecognitionException, TokenStreamException {
        int indexpos;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST exceptions_attribute_AST = null;
        short number_of_exceptions = 0;
        number_of_exceptions = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (indexpos = 0; this.LA(1) == 34 && indexpos < (number_of_exceptions & 0xFFFF); ++indexpos) {
            this.exception_index_entry();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (indexpos != (number_of_exceptions & 0xFFFF)) {
            throw new SemanticException("indexpos==((int)number_of_exceptions & 0xffff)");
        }
        exceptions_attribute_AST = currentAST.root;
        currentAST.root = exceptions_attribute_AST = this.astFactory.make(new ASTArray(2).add(this.astFactory.create(28)).add(exceptions_attribute_AST));
        currentAST.child = exceptions_attribute_AST != null && exceptions_attribute_AST.getFirstChild() != null ? exceptions_attribute_AST.getFirstChild() : exceptions_attribute_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = exceptions_attribute_AST = currentAST.root;
    }

    public final void innerClasses_attribute() throws RecognitionException, TokenStreamException {
        int entrypos;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST innerClasses_attribute_AST = null;
        short inner_class_table_length = 0;
        inner_class_table_length = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (entrypos = 0; this.LA(1) == 34 && entrypos < (inner_class_table_length & 0xFFFF); ++entrypos) {
            this.innerClassTableEntry();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (entrypos != (inner_class_table_length & 0xFFFF)) {
            throw new SemanticException("entrypos==((int)inner_class_table_length & 0xffff)");
        }
        this.returnAST = innerClasses_attribute_AST = currentAST.root;
    }

    public final void lineNumberTable_attribute() throws RecognitionException, TokenStreamException {
        int entrypos;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST lineNumberTable_attribute_AST = null;
        short line_number_table_length = 0;
        line_number_table_length = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (entrypos = 0; this.LA(1) == 34 && entrypos < (line_number_table_length & 0xFFFF); ++entrypos) {
            this.lineNumberTableEntry();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (entrypos != (line_number_table_length & 0xFFFF)) {
            throw new SemanticException("entrypos==((int)line_number_table_length & 0xffff)");
        }
        this.returnAST = lineNumberTable_attribute_AST = currentAST.root;
    }

    public final void localVariableTable_attribute() throws RecognitionException, TokenStreamException {
        int entrypos;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST localVariableTable_attribute_AST = null;
        short local_variable_table_length = 0;
        local_variable_table_length = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (entrypos = 0; this.LA(1) == 34 && entrypos < (local_variable_table_length & 0xFFFF); ++entrypos) {
            this.localVariableTableEntry();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (entrypos != (local_variable_table_length & 0xFFFF)) {
            throw new SemanticException("entrypos==((int)local_variable_table_length & 0xffff)");
        }
        this.returnAST = localVariableTable_attribute_AST = currentAST.root;
    }

    public final void localVariableTypeTable_attribute() throws RecognitionException, TokenStreamException {
        int entrypos;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST localVariableTypeTable_attribute_AST = null;
        short local_variable_type_table_length = 0;
        local_variable_type_table_length = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        for (entrypos = 0; this.LA(1) == 34 && entrypos < (local_variable_type_table_length & 0xFFFF); ++entrypos) {
            this.localVariableTypeTableEntry();
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        if (entrypos != (local_variable_type_table_length & 0xFFFF)) {
            throw new SemanticException("entrypos==((int)local_variable_type_table_length & 0xffff)");
        }
        this.returnAST = localVariableTypeTable_attribute_AST = currentAST.root;
    }

    public final void signature_attribute() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST signature_attribute_AST = null;
        short signature_index = 0;
        signature_index = this.u2();
        signature_attribute_AST = currentAST.root;
        String signature_name = this.getConstant(signature_index).getText();
        currentAST.root = signature_attribute_AST = this.astFactory.create(33, signature_name);
        currentAST.child = signature_attribute_AST != null && signature_attribute_AST.getFirstChild() != null ? signature_attribute_AST.getFirstChild() : signature_attribute_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = signature_attribute_AST;
    }

    public final void sourcefile_attribute() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST sourcefile_attribute_AST = null;
        short sourcefile_index = 0;
        sourcefile_index = this.u2();
        sourcefile_attribute_AST = currentAST.root;
        String sourcefile_name = this.getConstant(sourcefile_index).getText();
        currentAST.root = sourcefile_attribute_AST = this.astFactory.create(27, sourcefile_name);
        currentAST.child = sourcefile_attribute_AST != null && sourcefile_attribute_AST.getFirstChild() != null ? sourcefile_attribute_AST.getFirstChild() : sourcefile_attribute_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = sourcefile_attribute_AST;
    }

    public final void exception_table_entry() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST exception_table_entry_AST = null;
        short start_pc = 0;
        short end_pc = 0;
        short handler_pc = 0;
        short catch_type = 0;
        start_pc = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        end_pc = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        handler_pc = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        catch_type = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.returnAST = exception_table_entry_AST = currentAST.root;
    }

    public final void exception_index_entry() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST exception_index_entry_AST = null;
        short index = 0;
        index = this.u2();
        if (index == 0) {
            throw new SemanticException("index != 0");
        }
        exception_index_entry_AST = currentAST.root;
        String exception_name = this.getConstant(((ShortAST)this.getConstant(index)).getShortValue()).getText();
        currentAST.root = exception_index_entry_AST = this.astFactory.create(20, exception_name);
        currentAST.child = exception_index_entry_AST != null && exception_index_entry_AST.getFirstChild() != null ? exception_index_entry_AST.getFirstChild() : exception_index_entry_AST;
        currentAST.advanceChildToEnd();
        this.returnAST = exception_index_entry_AST;
    }

    public final void lineNumberTableEntry() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST lineNumberTableEntry_AST = null;
        short start_pc = 0;
        short line_number = 0;
        start_pc = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        line_number = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.returnAST = lineNumberTableEntry_AST = currentAST.root;
    }

    public final void localVariableTableEntry() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST localVariableTableEntry_AST = null;
        short start_pc = 0;
        short length = 0;
        short name_index = 0;
        short descriptor_index = 0;
        short index = 0;
        start_pc = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        length = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        name_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        descriptor_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.returnAST = localVariableTableEntry_AST = currentAST.root;
    }

    public final void localVariableTypeTableEntry() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST localVariableTypeTableEntry_AST = null;
        short start_pc = 0;
        short length = 0;
        short name_index = 0;
        short signature_index = 0;
        short index = 0;
        start_pc = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        length = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        name_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        signature_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.returnAST = localVariableTypeTableEntry_AST = currentAST.root;
    }

    public final void innerClassTableEntry() throws RecognitionException, TokenStreamException {
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        AST innerClassTableEntry_AST = null;
        short inner_class_info_index = 0;
        short outer_class_info_index = 0;
        short inner_name_index = 0;
        short inner_class_access_flags = 0;
        inner_class_info_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        outer_class_info_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        inner_name_index = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        inner_class_access_flags = this.u2();
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.returnAST = innerClassTableEntry_AST = currentAST.root;
    }

    protected void buildTokenTypeASTClassMap() {
        this.tokenTypeToASTClassMap = null;
    }
}

