/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng;

import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.argouml.language.java.reveng.ClassifierNotFoundException;
import org.argouml.model.Model;
import org.argouml.profile.Profile;
import org.argouml.uml.reveng.ImportClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Context {
    private static final Logger LOG = Logger.getLogger(Context.class);
    private Context context;

    public Context(Context base) {
        this.context = base;
    }

    public abstract Object get(String var1, boolean var2, Profile var3) throws ClassifierNotFoundException;

    protected String getJavaName(Object mPackage) {
        if (mPackage == null) {
            return "";
        }
        Object parent = Model.getFacade().getNamespace(mPackage);
        if (Model.getFacade().isAModel(parent)) {
            return Model.getFacade().getName(mPackage);
        }
        if (parent != null) {
            return this.getJavaName(parent) + "." + Model.getFacade().getName(mPackage);
        }
        return "";
    }

    protected void setContext(Context c) {
        this.context = c;
    }

    protected Context getContext() {
        return this.context;
    }

    protected Class<?> findClass(String name, boolean interfacesOnly) {
        return this.findClassOnUserClasspath(name, interfacesOnly);
    }

    private Class<?> findClassOnUserClasspath(String name, boolean interfacesOnly) {
        Class clazz = null;
        try {
            clazz = ImportClassLoader.getInstance().loadClass(name);
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)"Classpath configuration error", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (LinkageError e) {
            LOG.warn((Object)("Linkage error loading found class " + name), (Throwable)e);
            return null;
        }
        if (clazz != null && interfacesOnly && !clazz.isInterface()) {
            return null;
        }
        return clazz;
    }
}

