/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ColorFactory {
    private static final Map USED_COLORS_BY_RGB_STRING = new HashMap();
    private static final Map USED_COLORS_BY_RGB_INTEGER = new HashMap();

    private ColorFactory() {
    }

    public static Color getColor(String colorDescr, Color defaultColor) {
        Color color = ColorFactory.getColor(colorDescr);
        if (color != null) {
            return color;
        }
        return defaultColor;
    }

    public static Color getColor(String colorDescr) {
        Color color = null;
        color = colorDescr.equalsIgnoreCase("white") ? Color.white : (colorDescr.equalsIgnoreCase("black") ? Color.black : (colorDescr.equalsIgnoreCase("red") ? Color.red : (colorDescr.equalsIgnoreCase("green") ? Color.green : (colorDescr.equalsIgnoreCase("blue") ? Color.blue : (colorDescr.indexOf(32) > 0 ? ColorFactory.getColorByRgb(colorDescr) : ColorFactory.getColorByRgb(Integer.valueOf(colorDescr)))))));
        return color;
    }

    private static Color getColorByRgb(String colorDescr) {
        Color color = (Color)USED_COLORS_BY_RGB_STRING.get(colorDescr);
        if (color == null) {
            StringTokenizer st = new StringTokenizer(colorDescr, " ");
            int red = Integer.parseInt(st.nextToken());
            int green = Integer.parseInt(st.nextToken());
            int blue = Integer.parseInt(st.nextToken());
            color = new Color(red, green, blue);
            ColorFactory.cacheColor(colorDescr, color);
        }
        return color;
    }

    private static Color getColorByRgb(Integer rgbInteger) {
        Color color = (Color)USED_COLORS_BY_RGB_INTEGER.get(rgbInteger);
        if (color == null) {
            color = Color.decode(rgbInteger.toString());
            ColorFactory.cacheColor(rgbInteger, color);
        }
        return color;
    }

    private static void cacheColor(Color color) {
        ColorFactory.cacheColor(ColorFactory.colorToInteger(color), color);
    }

    private static void cacheColor(String stringIndex, Color color) {
        ColorFactory.cacheColor(stringIndex, ColorFactory.colorToInteger(color), color);
    }

    private static Integer colorToInteger(Color color) {
        return new Integer(color.getRGB());
    }

    private static void cacheColor(Integer intIndex, Color color) {
        ColorFactory.cacheColor(color.getRed() + " " + color.getGreen() + " " + color.getBlue(), intIndex, color);
    }

    private static void cacheColor(String stringIndex, Integer intIndex, Color color) {
        USED_COLORS_BY_RGB_INTEGER.put(intIndex, color);
        USED_COLORS_BY_RGB_STRING.put(stringIndex, color);
    }

    static {
        ColorFactory.cacheColor(Color.white);
        ColorFactory.cacheColor(Color.black);
        ColorFactory.cacheColor(Color.red);
        ColorFactory.cacheColor(Color.green);
        ColorFactory.cacheColor(Color.blue);
    }
}

