/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigGroup
extends Fig {
    private static final long serialVersionUID = -6310938507588533546L;
    private List<Fig> figs;
    private int extraFrameSpace = 0;
    private Color textColor = Color.black;
    private Color textFillColor = Color.white;
    private boolean textFilled = false;
    private Font font = new Font("TimesRoman", 0, 10);
    private boolean suppressCalcBounds;

    public FigGroup() {
        this.figs = Collections.synchronizedList(new ArrayList());
    }

    public FigGroup(List<Fig> figs) {
        this.figs = Collections.synchronizedList(figs);
        this.calcBounds();
    }

    public void parseDynObjects(String dynStr) {
    }

    public void addFig(Fig fig) {
        Fig group = fig.getGroup();
        if (group != this) {
            if (group != null) {
                ((FigGroup)group).removeFig(fig);
            }
            this.figs.add(fig);
            fig.setGroup(this);
            this.calcBounds();
        }
    }

    public void addFigs(Collection<Fig> figs) {
        Iterator<Fig> figIter = figs.iterator();
        while (figIter.hasNext()) {
            this.addFig(figIter.next());
        }
        this.calcBounds();
    }

    public void setFigs(Collection<Fig> figs) {
        this.figs.clear();
        this.addFigs(figs);
    }

    @Override
    public void calcBounds() {
        if (this.suppressCalcBounds) {
            return;
        }
        Rectangle boundingBox = null;
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.figs.get(figIndex);
            if (!f.isVisible()) continue;
            if (boundingBox == null) {
                boundingBox = f.getBounds();
                continue;
            }
            boundingBox.add(this.getSubFigBounds(f));
        }
        if (boundingBox == null) {
            boundingBox = new Rectangle(0, 0, 0, 0);
        }
        this._x = boundingBox.x;
        this._y = boundingBox.y;
        this._w = boundingBox.width;
        this._h = boundingBox.height + this.extraFrameSpace;
    }

    protected Rectangle getSubFigBounds(Fig subFig) {
        return subFig.getBounds();
    }

    @Override
    public Object clone() {
        FigGroup figClone = (FigGroup)super.clone();
        int figCount = this.figs.size();
        ArrayList<Fig> figsClone = new ArrayList<Fig>(figCount);
        for (int i = 0; i < figCount; ++i) {
            Fig tempFig = this.figs.get(i);
            Fig tempFigClone = (Fig)tempFig.clone();
            figsClone.add(tempFigClone);
            tempFigClone.setGroup(figClone);
        }
        figClone.figs = figsClone;
        return figClone;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.hitFig(new Rectangle(x, y, 0, 0)) != null;
    }

    @Deprecated
    public Iterator iterator() {
        return this.figs.iterator();
    }

    public Fig getFigAt(int i) {
        return this.figs.get(i);
    }

    public int getFigCount() {
        return this.figs.size();
    }

    public int getFigPosn(Fig f) {
        return this.figs.indexOf(f);
    }

    public List<Fig> getFigs() {
        return Collections.unmodifiableList(this.figs);
    }

    public List<DiagramElement> getDiagramElements() {
        return Collections.unmodifiableList(new ArrayList<Fig>(this.figs));
    }

    public Font getFont() {
        return this.font;
    }

    public String getFontFamily() {
        return this.font.getFamily();
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    @Override
    public String getPrivateData() {
        Fig enc = this.getEnclosingFig();
        if (enc != null) {
            return "enclosingFig=\"" + enc.getId() + "\"";
        }
        return "";
    }

    public int getExtraFrameSpace() {
        return this.extraFrameSpace;
    }

    @Override
    public boolean hit(Rectangle r) {
        return this.hitFig(r) != null;
    }

    public Fig hitFig(Rectangle r) {
        if (!this.isVisible()) {
            return null;
        }
        Fig res = null;
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.figs.get(figIndex);
            if (!f.hit(r)) continue;
            res = f;
        }
        return res;
    }

    @Override
    public boolean isReshapable() {
        return false;
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.isVisible()) {
            for (Fig f : this.getFigs()) {
                if (!f.isVisible()) continue;
                f.paint(g);
            }
        }
    }

    @Override
    public void appendSvg(StringBuffer sb) {
        sb.append("<g id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("'");
        this.appendSvgStyle(sb);
        for (Fig fig : this.getFigs()) {
            fig.appendSvg(sb);
        }
        sb.append("</g>");
    }

    public void removeAll() {
        Rectangle oldBounds = this.getBounds();
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.figs.get(figIndex);
            f.setGroup(null);
        }
        this.figs.clear();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void removeFig(Fig f) {
        if (!this.figs.contains(f)) {
            return;
        }
        Rectangle oldBounds = this.getBounds();
        this.figs.remove(f);
        f.setGroup(null);
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public Collection getDisplayedFigs(Collection c) {
        if (c == null) {
            c = new ArrayList<Fig>();
        }
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.figs.get(figIndex);
            if (!f.isVisible()) continue;
            c.add(f);
        }
        return c;
    }

    @Override
    protected void setBoundsImpl(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.figs.get(figIndex);
            if (!f.isVisible()) continue;
            int newW = this._w == 0 ? 0 : f.getWidth() * w / this._w;
            int newH = this._h == 0 ? 0 : f.getHeight() * h / this._h;
            int newX = this._w == 0 ? x : x + (f.getX() - this._x) * w / this._w;
            int newY = this._h == 0 ? y : y + (f.getY() - this._y) * h / this._h;
            f.setBoundsImpl(newX, newY, newW, newH);
        }
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void setFigs(List<Fig> figs) {
        Rectangle oldBounds = this.getBounds();
        this.figs = new ArrayList<Fig>(figs);
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    @Override
    public void setFillColor(Color col) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            this.figs.get(i).setFillColor(col);
        }
        super.setFillColor(col);
    }

    @Override
    public void setFilled(boolean f) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            this.figs.get(i).setFilled(f);
        }
        super.setFilled(f);
    }

    public void setFont(Font f) {
        this.firePropChange("font", this.font, f);
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Fig ft = this.figs.get(i);
            if (ft instanceof FigText) {
                ((FigText)ft).setFont(f);
                continue;
            }
            if (!(ft instanceof FigGroup)) continue;
            ((FigGroup)ft).setFont(f);
        }
        this.font = f;
    }

    public void setFontFamily(String s) {
        Font f = new Font(s, this.font.getStyle(), this.font.getSize());
        this.setFont(f);
    }

    public void setFontSize(int size) {
        Font f = new Font(this.font.getFamily(), this.font.getStyle(), size);
        this.setFont(f);
    }

    @Override
    public void setLineColor(Color col) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            this.figs.get(i).setLineColor(col);
        }
        super.setLineColor(col);
    }

    @Override
    public void setLineWidth(int w) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            this.figs.get(i).setLineWidth(w);
        }
        super.setLineWidth(w);
    }

    @Override
    public void setPrivateData(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data, "=\"' ");
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (!tok.equals("enclosingFig")) continue;
            String s = tokenizer.nextToken();
            Integer.parseInt(s);
        }
    }

    public void setTextColor(Color c) {
        this.firePropChange("textColor", this.textColor, c);
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Fig ft = this.figs.get(i);
            if (ft instanceof FigText) {
                ((FigText)ft).setTextColor(c);
                continue;
            }
            if (!(ft instanceof FigGroup)) continue;
            ((FigGroup)ft).setTextColor(c);
        }
        this.textColor = c;
    }

    public void setTextFillColor(Color c) {
        this.firePropChange("textFillColor", this.textFillColor, c);
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Fig ft = this.figs.get(i);
            if (ft instanceof FigText) {
                ((FigText)ft).setTextFillColor(c);
                continue;
            }
            if (!(ft instanceof FigGroup)) continue;
            ((FigGroup)ft).setTextFillColor(c);
        }
        this.textFillColor = c;
    }

    public void setTextFilled(boolean b) {
        this.firePropChange("textFilled", this.textFilled, b);
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Fig ft = this.figs.get(i);
            if (ft instanceof FigText) {
                ((FigText)ft).setTextFilled(b);
                continue;
            }
            if (!(ft instanceof FigGroup)) continue;
            ((FigGroup)ft).setTextFilled(b);
        }
        this.textFilled = b;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getTextFillColor() {
        return this.textFillColor;
    }

    public boolean getTextFilled() {
        return this.textFilled;
    }

    public void setExtraFrameSpace(int extraSpace) {
        this.extraFrameSpace = extraSpace;
    }

    @Override
    protected void translateImpl(int dx, int dy) {
        Rectangle oldBounds = this.getBounds();
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = this.figs.get(figIndex);
            f.translate(dx, dy);
        }
        this._x += dx;
        this._y += dy;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public Fig deepSelect(Rectangle hitRect) {
        return this;
    }
}

