/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.AnnotationProperties;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigLine;

public abstract class AnnotationStrategy
implements Serializable {
    Hashtable annotations = new Hashtable();

    public Point restoreAnnotationPosition(Fig annotation) {
        return new Point(1, 1);
    }

    public abstract void translateAnnotations(Fig var1);

    public abstract void storeAnnotationPosition(Fig var1);

    protected boolean lineIsVisible(Fig annotation) {
        return true;
    }

    public void addAnnotation(Fig owner, Fig annotation, AnnotationProperties properties) {
        if (this.annotations.containsKey(annotation) || owner == null || annotation == null) {
            return;
        }
        annotation.setAnnotationOwner(owner);
        this.annotations.put(annotation, properties);
    }

    public int numOfAnnotations() {
        return this.annotations.size();
    }

    public AnnotationProperties getAnnotationProperties(Fig annotation) {
        return (AnnotationProperties)this.annotations.get(annotation);
    }

    public Enumeration getAllAnnotations() {
        return this.annotations.keys();
    }

    public Vector getAnnotationsVector() {
        Vector v = new Vector();
        Enumeration iter = this.getAllAnnotations();
        while (iter.hasMoreElements()) {
            v.addElement(iter.nextElement());
        }
        return v;
    }

    public void replaceAnnotation(Fig annotation, AnnotationProperties properties) {
        Fig owner = annotation.getAnnotationOwner();
        this.annotations.remove(annotation);
        this.addAnnotation(owner, annotation, properties);
    }

    public void removeAnnotation(Fig annotation) {
        AnnotationProperties props = this.getAnnotationProperties(annotation);
        if (props != null) {
            props.removeLine();
        }
        annotation.unsetAnnotationOwner();
        this.annotations.remove(annotation);
    }

    public void removeAllAnnotations() {
        Enumeration iter = this.annotations.keys();
        while (iter.hasMoreElements()) {
            Fig annotation = (Fig)iter.nextElement();
            this.removeAnnotation(annotation);
        }
    }

    public void removeAllConnectingLines() {
        Enumeration iter = this.annotations.keys();
        while (iter.hasMoreElements()) {
            Fig annotation = (Fig)iter.nextElement();
            AnnotationProperties prop = (AnnotationProperties)this.annotations.get(annotation);
            FigLine line = prop.getConnectingLine();
            if (!Globals.curEditor().getLayerManager().getContents().contains(line)) continue;
            Globals.curEditor().remove(line);
        }
    }
}

