/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.lib;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import tudresden.ocl.lib.Ocl;
import tudresden.ocl.lib.OclAddable;
import tudresden.ocl.lib.OclAny;
import tudresden.ocl.lib.OclBag;
import tudresden.ocl.lib.OclBoolean;
import tudresden.ocl.lib.OclBooleanEvaluatable;
import tudresden.ocl.lib.OclComparableEvaluatable;
import tudresden.ocl.lib.OclContainer;
import tudresden.ocl.lib.OclException;
import tudresden.ocl.lib.OclInteger;
import tudresden.ocl.lib.OclIterator;
import tudresden.ocl.lib.OclRoot;
import tudresden.ocl.lib.OclRootEvaluatable;
import tudresden.ocl.lib.OclSequence;
import tudresden.ocl.lib.OclSet;
import tudresden.ocl.lib.OclSizable;

public abstract class OclCollection
implements OclSizable,
OclRoot {
    public boolean STRICT_VALUE_TYPES = Ocl.STRICT_VALUE_TYPES;
    protected Collection collection;
    private String undefinedreason = null;

    OclCollection(Collection c) {
        this.collection = c;
        if (Ocl.STRICT_FLATTENING && c != null) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof OclCollection)) continue;
                c.remove(o);
                c.addAll(((OclCollection)o).collection);
            }
        }
    }

    public abstract OclBoolean isEqualTo(Object var1);

    public OclBoolean isNotEqualTo(Object o) {
        return this.isEqualTo(o).not();
    }

    public abstract OclRoot getFeature(String var1);

    public OclCollection getFeatureAsCollection(String name) {
        OclRoot or = this.getFeature(name);
        if (or instanceof OclCollection) {
            return (OclCollection)or;
        }
        HashSet<OclRoot> set = new HashSet<OclRoot>();
        set.add(or);
        return new OclSet(set);
    }

    public OclBoolean exists(OclIterator iter, OclBooleanEvaluatable eval) {
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        boolean ret = false;
        while (iter.hasNext() && !ret) {
            iter.next();
            ret = eval.evaluate().isTrue();
        }
        return Ocl.getOclRepresentationFor(ret);
    }

    public OclBoolean forAll(OclIterator iter, OclBooleanEvaluatable eval) {
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        try {
            boolean ret = true;
            while (iter.hasNext() && ret) {
                iter.next();
                ret = eval.evaluate().isTrue();
            }
            return Ocl.getOclRepresentationFor(ret);
        }
        catch (OclException e) {
            return new OclBoolean(0, e.toString());
        }
    }

    public OclBoolean isUnique(OclIterator iter, OclRootEvaluatable eval) {
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        boolean ret = true;
        HashSet<OclRoot> hs = new HashSet<OclRoot>(this.collection.size());
        while (iter.hasNext() && ret) {
            iter.next();
            ret = hs.add(eval.evaluate());
        }
        return Ocl.getOclRepresentationFor(ret);
    }

    public OclSequence sortedBy(OclIterator iter, OclComparableEvaluatable eval) {
        if (this.isUndefined()) {
            return new OclSequence(0, this.getUndefinedReason());
        }
        TreeMap<Comparable, ArrayList> tm = new TreeMap<Comparable, ArrayList>();
        while (iter.hasNext()) {
            ArrayList list;
            Comparable key;
            iter.next();
            try {
                key = eval.evaluate();
            }
            catch (ClassCastException e) {
                return new OclSequence(0, "ClassCastException in OclComparableEvaluatable.evaluate()");
            }
            OclRoot obj = iter.getValue();
            if (tm.keySet().contains(key)) {
                list = (ArrayList)tm.get(key);
                list.add(obj);
                continue;
            }
            list = new ArrayList();
            list.add(obj);
            tm.put(key, list);
        }
        ArrayList l = new ArrayList(tm.size() * 2);
        Iterator mapIter = tm.values().iterator();
        while (mapIter.hasNext()) {
            ArrayList valList = (ArrayList)mapIter.next();
            Iterator valIter = ((AbstractList)valList).iterator();
            while (valIter.hasNext()) {
                l.add(valIter.next());
            }
        }
        return new OclSequence(l);
    }

    /*
     * Unable to fully structure code
     */
    public OclRoot iterate(OclIterator iter, OclContainer accum, OclRootEvaluatable eval) {
        if (!this.isUndefined()) ** GOTO lbl6
        return this;
lbl-1000:
        // 1 sources

        {
            iter.next();
            root = eval.evaluate();
            accum.setValue(root);
lbl6:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl7:
        // 1 sources

        return accum.getValue();
    }

    public abstract OclCollection select(OclIterator var1, OclBooleanEvaluatable var2);

    protected List selectToList(OclIterator iter, OclBooleanEvaluatable eval) {
        if (this.isUndefined()) {
            return null;
        }
        ArrayList<OclRoot> list = new ArrayList<OclRoot>(this.collection.size());
        while (iter.hasNext()) {
            iter.next();
            if (!eval.evaluate().isTrue()) continue;
            list.add(iter.getValue());
        }
        return list;
    }

    public OclCollection reject(OclIterator iter, final OclBooleanEvaluatable eval) {
        return this.select(iter, new OclBooleanEvaluatable(){

            public OclBoolean evaluate() {
                return eval.evaluate().not();
            }
        });
    }

    public abstract OclCollection collect(OclIterator var1, OclRootEvaluatable var2);

    protected List collectToList(OclIterator iter, OclRootEvaluatable eval) {
        if (this.isUndefined()) {
            return null;
        }
        ArrayList list = new ArrayList(this.collection.size());
        while (iter.hasNext()) {
            iter.next();
            OclRoot or = eval.evaluate();
            if (or instanceof OclCollection) {
                Iterator i = ((OclCollection)or).collection.iterator();
                while (i.hasNext()) {
                    list.add(i.next());
                }
                continue;
            }
            list.add(or);
        }
        return list;
    }

    public OclInteger size() {
        if (this.isUndefined()) {
            return new OclInteger(0, this.getUndefinedReason());
        }
        return new OclInteger(this.collection.size());
    }

    public OclBoolean includes(OclRoot obj) {
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (obj.isUndefined()) {
            return new OclBoolean(0, obj.getUndefinedReason());
        }
        boolean ret = false;
        Iterator iter = this.collection.iterator();
        while (iter.hasNext() && !ret) {
            try {
                if (!obj.isEqualTo(iter.next()).isTrue()) continue;
                ret = true;
            }
            catch (OclException e) {
                // empty catch block
            }
        }
        return Ocl.getOclRepresentationFor(ret);
    }

    public OclBoolean excludes(OclRoot obj) {
        return this.includes(obj).not();
    }

    public OclBoolean excludesAll(OclCollection coll) {
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (coll.isUndefined()) {
            return new OclBoolean(0, coll.getUndefinedReason());
        }
        boolean ret = true;
        Iterator iter = coll.collection.iterator();
        while (iter.hasNext() && ret) {
            try {
                ret = this.excludes((OclRoot)iter.next()).isTrue();
            }
            catch (OclException e) {
                // empty catch block
            }
        }
        return Ocl.getOclRepresentationFor(ret);
    }

    public OclInteger count(Object obj) {
        if (this.isUndefined()) {
            return new OclInteger(0, this.getUndefinedReason());
        }
        OclRoot or = obj instanceof OclRoot ? (OclRoot)obj : Ocl.getOclRepresentationFor(obj);
        Iterator iter = this.collection.iterator();
        int count = 0;
        while (iter.hasNext()) {
            try {
                Object next = iter.next();
                if (!or.isEqualTo(next).isTrue()) continue;
                ++count;
            }
            catch (OclException e) {
                // empty catch block
            }
        }
        return new OclInteger(count);
    }

    public OclBoolean includesAll(OclCollection coll) {
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (coll.isUndefined()) {
            return new OclBoolean(0, coll.getUndefinedReason());
        }
        return Ocl.getOclRepresentationFor(this.collection.containsAll(coll.collection));
    }

    public OclBoolean isEmpty() {
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        return Ocl.getOclRepresentationFor(this.collection.isEmpty());
    }

    public OclBoolean notEmpty() {
        return this.isEmpty().not();
    }

    public OclAddable sum() {
        if (this.isUndefined()) {
            return new OclInteger(0, this.getUndefinedReason());
        }
        if (this.collection.isEmpty()) {
            return new OclInteger(0L);
        }
        try {
            Iterator iter = this.collection.iterator();
            OclAddable sum = (OclAddable)iter.next();
            while (iter.hasNext()) {
                OclAddable nextsum;
                sum = nextsum = sum.add((OclAddable)iter.next());
            }
            return sum;
        }
        catch (ClassCastException cce) {
            return new OclInteger(0, "sum() of collection with non-OclAddable element requested");
        }
    }

    public abstract OclCollection union(OclCollection var1);

    public abstract OclCollection including(OclRoot var1);

    public abstract OclCollection excluding(OclRoot var1);

    public OclSet asSet() {
        if (this.isUndefined()) {
            return new OclSet(0, this.getUndefinedReason());
        }
        HashSet set = new HashSet(this.collection);
        return new OclSet(set);
    }

    public OclBag asBag() {
        if (this.isUndefined()) {
            return new OclBag(0, this.getUndefinedReason());
        }
        ArrayList list = new ArrayList(this.collection);
        return new OclBag(list);
    }

    public OclSequence asSequence() {
        if (this.isUndefined()) {
            return new OclSequence(0, this.getUndefinedReason());
        }
        ArrayList list = new ArrayList(this.collection);
        return new OclSequence(list);
    }

    public OclIterator getIterator() {
        if (this.isUndefined()) {
            return null;
        }
        return new OclIterator(this.collection);
    }

    private OclCollection error(String msg) {
        return new OclSet(0, msg);
    }

    public boolean equals(Object o) {
        try {
            return this.isEqualTo(o).isTrue();
        }
        catch (OclException e) {
            return false;
        }
    }

    public String toString() {
        if (this.isUndefined()) {
            return "[UNDEFINED:" + this.getUndefinedReason() + "]";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.collection.iterator();
        sb.append("[");
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public void setToRange(OclInteger begin, OclInteger end) {
        int iEnd;
        if (this.isUndefined() || begin.isUndefined() || end.isUndefined()) {
            return;
        }
        int iBegin = begin.getInt();
        if (iBegin > (iEnd = end.getInt())) {
            this.becomeUndefined("lower range boundary (" + iBegin + ") greater than upper range boundary (" + iEnd + ") in collection literal.");
        }
        int i = iBegin;
        while (i <= iEnd) {
            this.collection.add(new OclInteger(i));
            ++i;
        }
    }

    public void setToInclude(OclAny any) {
        if (this.isUndefined()) {
            return;
        }
        if (any != null && !any.isUndefined()) {
            this.collection.add(any);
        }
    }

    protected OclCollection(int dummy, String undefinedreason) {
        if (dummy != 0) {
            throw new RuntimeException();
        }
        this.undefinedreason = undefinedreason;
    }

    public final boolean isUndefined() {
        return this.undefinedreason != null;
    }

    public final String getUndefinedReason() {
        if (this.undefinedreason != null) {
            return this.undefinedreason;
        }
        throw new RuntimeException();
    }

    protected void becomeUndefined(String undefinedreason) {
        if (this.undefinedreason != null) {
            throw new RuntimeException();
        }
        this.undefinedreason = undefinedreason;
    }
}

