/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import tudresden.ocl.gui.OCLEditor;

public class OCLEditorPreferences
extends JDialog {
    private OCLEditor m_ocleEditor;
    private JPanel m_jpOptionsGroup;
    private JCheckBox m_jcbTypeCheck;
    private JCheckBox m_jcbAutoSplit;
    private JPanel jPanel3;
    private JPanel m_jpButtonsGroup;
    private JButton m_jbOKButton;
    private JButton m_jbCancelButton;

    public OCLEditorPreferences(JFrame parent, OCLEditor ocle) {
        super((Frame)parent, true);
        this.m_ocleEditor = ocle;
        this.initComponents();
        int nOptionMask = this.m_ocleEditor.getOptionMask();
        this.m_jcbTypeCheck.setVisible((nOptionMask & 1) != 0);
        this.m_jcbTypeCheck.setSelected(this.m_ocleEditor.getDoTypeCheck());
        this.m_jcbAutoSplit.setVisible((nOptionMask & 2) != 0);
        this.m_jcbAutoSplit.setSelected(this.m_ocleEditor.getDoAutoSplit());
    }

    private void initComponents() {
        this.m_jpOptionsGroup = new JPanel();
        this.m_jcbTypeCheck = new JCheckBox();
        this.m_jcbAutoSplit = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.m_jpButtonsGroup = new JPanel();
        this.m_jbOKButton = new JButton();
        this.m_jbCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("OCL Editor Preferences");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OCLEditorPreferences.this.closeDialog(evt);
            }
        });
        this.m_jpOptionsGroup.setLayout(new GridBagLayout());
        this.m_jpOptionsGroup.setBorder(new TitledBorder(new EtchedBorder(), "Options"));
        this.m_jcbTypeCheck.setToolTipText("Check this option to have the editor perform type checks on each constraint you submit.");
        this.m_jcbTypeCheck.setSelected(true);
        this.m_jcbTypeCheck.setText("Check type conformance of OCL constraints");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        this.m_jpOptionsGroup.add((Component)this.m_jcbTypeCheck, gridBagConstraints2);
        this.m_jcbAutoSplit.setToolTipText("Check this option to have the editor automatically split multiple constraints that were entered in one go.");
        this.m_jcbAutoSplit.setSelected(true);
        this.m_jcbAutoSplit.setText("AutoSplit: Automatically split apart multiple constraints entered as a single text");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        this.m_jpOptionsGroup.add((Component)this.m_jcbAutoSplit, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.m_jpOptionsGroup.add((Component)this.jPanel3, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.getContentPane().add((Component)this.m_jpOptionsGroup, gridBagConstraints1);
        this.m_jpButtonsGroup.setLayout(new FlowLayout(2, 5, 5));
        this.m_jbOKButton.setText("OK");
        this.m_jbOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OCLEditorPreferences.this.onOKButton(evt);
            }
        });
        this.m_jpButtonsGroup.add(this.m_jbOKButton);
        this.m_jbCancelButton.setText("Cancel");
        this.m_jbCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OCLEditorPreferences.this.onCancelButton(evt);
            }
        });
        this.m_jpButtonsGroup.add(this.m_jbCancelButton);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.gridheight = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weightx = 1.0;
        this.getContentPane().add((Component)this.m_jpButtonsGroup, gridBagConstraints1);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        ((Component)this).setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void onOKButton(ActionEvent evt) {
        this.m_ocleEditor.setDoAutoSplit(this.m_jcbAutoSplit.isSelected());
        this.m_ocleEditor.setDoTypeCheck(this.m_jcbTypeCheck.isSelected());
        this.closeDialog();
    }

    private void onCancelButton(ActionEvent evt) {
        this.closeDialog();
    }

    private void closeDialog(WindowEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

