/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import tudresden.ocl.OclTree;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.ADeclaratorTail;
import tudresden.ocl.parser.node.AIterateDeclarator;
import tudresden.ocl.parser.node.ALetExpression;
import tudresden.ocl.parser.node.APostStereotype;
import tudresden.ocl.parser.node.AStandardDeclarator;
import tudresden.ocl.parser.node.Start;

public class NameCreator {
    public static String defaultPrefix = "tudOcl";
    protected static NameCreator theInstance = new NameCreator();
    protected HashSet names = new HashSet();
    protected HashMap fixmap = new HashMap();
    protected String prefix;

    public NameCreator(String prefix) {
        this.prefix = prefix;
    }

    public NameCreator() {
        this(defaultPrefix);
    }

    public static NameCreator getInstance() {
        return theInstance;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUniqueName() {
        return this.getUniqueName("");
    }

    public String getUniqueName(String infix) {
        String newName;
        if (!this.fixmap.containsKey(infix)) {
            this.fixmap.put(infix, new Integer(0));
        }
        do {
            Integer iPostfix = (Integer)this.fixmap.get(infix);
            newName = this.prefix + infix + iPostfix.toString();
            this.fixmap.put(infix, new Integer(iPostfix + 1));
        } while (this.names.contains(newName));
        this.names.add(newName);
        return newName;
    }

    public boolean reserveName(String s) {
        if (s == null) {
            return false;
        }
        return this.names.add(s);
    }

    public void reserveAllNames(OclTree tree) {
        NameReserver nr = new NameReserver();
        tree.apply(nr);
    }

    public void clear() {
        this.names.clear();
        this.fixmap.clear();
    }

    class NameReserver
    extends DepthFirstAdapter {
        NameReserver() {
        }

        public void inStart(Start s) {
            NameCreator.this.reserveName("self");
        }

        public void inAPostStereotype(APostStereotype ps) {
            NameCreator.this.reserveName("result");
        }

        public void inALetExpression(ALetExpression le) {
            String name = le.getName().toString().trim();
            NameCreator.this.reserveName(name);
        }

        public void inAStandardDeclarator(AStandardDeclarator sd) {
            String iterName = sd.getName().toString().trim();
            NameCreator.this.reserveName(iterName);
            Iterator iter = sd.getDeclaratorTail().iterator();
            while (iter.hasNext()) {
                ADeclaratorTail dt = (ADeclaratorTail)iter.next();
                String anotherIterName = dt.getName().toString().trim();
                NameCreator.this.reserveName(anotherIterName);
            }
        }

        public void inAIterateDeclarator(AIterateDeclarator id) {
            String iterName = id.getIterator().toString().trim();
            String accuName = id.getAccumulator().toString().trim();
            NameCreator.this.reserveName(iterName);
            NameCreator.this.reserveName(accuName);
        }
    }
}

