/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.argouml.core.propertypanels.ui.LabelledLayout;
import org.argouml.core.propertypanels.ui.RowSelector;

class XmlPropertyPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getLogger(XmlPropertyPanel.class);
    private JList selectedList;

    public XmlPropertyPanel() {
        super(new LabelledLayout());
        this.setName("UML Properties");
    }

    public Component add(Component comp) {
        super.add(comp);
        if (comp instanceof RowSelector) {
            RowSelector rs = (RowSelector)comp;
            rs.addListSelectionListener(this);
        }
        return comp;
    }

    public void remove(Component comp) {
        super.remove(comp);
        if (comp instanceof RowSelector) {
            RowSelector rs = (RowSelector)comp;
            rs.removeListSelectionListener(this);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        JList list = (JList)e.getSource();
        if (this.selectedList == null && list.getSelectedValues().length > 0) {
            this.selectedList = list;
            for (Component c : this.getComponents()) {
                if (!(c instanceof RowSelector) || ((RowSelector)c).getList() == list) continue;
                ((RowSelector)c).clearSelection();
            }
            this.selectedList = null;
        }
    }

    public void removeNotify() {
        LOG.info((Object)"The XML panel is being removed");
        this.removeAll();
    }
}

