/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.Action;
import org.apache.log4j.Logger;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;
import org.argouml.uml.util.PathComparator;

class UMLModelElementNamespaceComboBoxModel
extends UMLComboBoxModel {
    private static final Logger LOG = Logger.getLogger(UMLModelElementNamespaceComboBoxModel.class);
    private static final long serialVersionUID = -775116993155949065L;

    public UMLModelElementNamespaceComboBoxModel(String propertyName, Object target) {
        super(target, "namespace", true);
        assert (target != null);
        Model.getPump().addClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getNamespace(), "ownedElement");
    }

    protected boolean isValidElement(Object o) {
        return Model.getFacade().isANamespace(o) && Model.getCoreHelper().isValidNamespace(this.getTarget(), o);
    }

    protected void buildMinimalModelList() {
        Object namespace;
        Object target = this.getTarget();
        ArrayList<Object> c = new ArrayList<Object>(1);
        if (target != null && (namespace = Model.getFacade().getNamespace(target)) != null && !c.contains(namespace)) {
            c.add(namespace);
        }
        this.setElements(c);
    }

    protected void buildModelList() {
        TreeSet<Object> elements = new TreeSet<Object>((Comparator<Object>)new PathComparator());
        Object model = ProjectManager.getManager().getCurrentProject().getRoot();
        Object target = this.getTarget();
        elements.addAll(Model.getCoreHelper().getAllPossibleNamespaces(target, model));
        Object namespace = Model.getFacade().getNamespace(target);
        if (namespace != null && !elements.contains(namespace)) {
            elements.add(namespace);
            LOG.warn((Object)"The current namespace is not a valid one!");
        }
        this.removeAllElements();
        this.addAll(elements);
    }

    protected Object getSelectedModelElement() {
        return Model.getFacade().getNamespace(this.getTarget());
    }

    protected boolean isLazy() {
        return true;
    }

    public Action getAction() {
        return new SetAction();
    }

    class SetAction
    extends UndoableAction {
        private static final long serialVersionUID = 6281434994800778660L;

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            Object oldNamespace = null;
            Object newNamespace = null;
            Object m = null;
            UMLComboBox box = (UMLComboBox)source;
            Object o = UMLModelElementNamespaceComboBoxModel.this.getTarget();
            if (Model.getFacade().isAModelElement(o)) {
                m = o;
                oldNamespace = Model.getFacade().getNamespace(m);
            }
            o = box.getSelectedItem();
            if (Model.getFacade().isANamespace(o)) {
                newNamespace = o;
            }
            if (newNamespace != oldNamespace && m != null && newNamespace != null) {
                super.actionPerformed(e);
                Model.getCoreHelper().setNamespace(m, newNamespace);
            }
        }
    }
}

