/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.argouml.sequence2.diagram.FigClassifierRole;
import org.argouml.sequence2.diagram.FigMessage;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeBroomMessages
extends FigModifyingModeImpl {
    private static final int DIRECTION_UNDEFINED = 0;
    private static final int DIRECTION_UPWARD = 1;
    private static final int DIRECTION_DOWNWARD = 2;
    private int currentDirection = 0;
    private boolean shouldDraw = true;
    private int x1;
    private int x2;
    private int y;
    private int lastX1;
    private int lastX2;
    private int lastY;

    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        this.x1 = me.getX();
        this.x2 = me.getX();
        this.y = me.getY();
        this.lastX1 = this.x1 - 100;
        this.lastY = this.y;
        this.lastX2 = this.x1 + 100;
        this.editor.damageAll();
        me.consume();
        this.start();
    }

    public void mouseDragged(MouseEvent me) {
        me.consume();
        this.editor.getSelectionManager().deselectAll();
        int crY = 0;
        List nodes = this.editor.getGraphModel().getNodes();
        if (nodes.size() > 0) {
            crY = this.editor.getLayerManager().getActiveLayer().presentationFor(nodes.get(0)).getY();
        }
        Point snapPt = me.getPoint();
        snapPt.x = Math.max(0, snapPt.x);
        snapPt.y = Math.max(crY, snapPt.y);
        this.editor.snap(snapPt);
        int dy = snapPt.y - this.lastY;
        if (dy == 0) {
            this.x1 = me.getX();
            this.x2 = me.getX();
            this.editor.damageAll();
            return;
        }
        this.lastX1 = Math.min(snapPt.x, this.lastX1);
        this.lastX2 = Math.max(snapPt.x, this.lastX2);
        if (this.currentDirection == 1 && dy > 0) {
            this.currentDirection = 2;
        } else if (this.currentDirection == 2 && dy > 0) {
            this.currentDirection = 1;
        }
        if (this.currentDirection == 0) {
            if (dy < 0) {
                this.currentDirection = 1;
            } else if (dy > 0) {
                this.currentDirection = 2;
            }
        }
        this.x1 = this.lastX1;
        this.x2 = this.lastX2;
        if (this.currentDirection == 2 || this.currentDirection == 1) {
            List<FigMessage> messages = this.getAllFigMessagesDownward(this.lastY);
            for (FigMessage message : messages) {
                FigNode dest;
                message.translate(0, dy);
                FigNode source = message.getSourceFigNode();
                if (source != null && source instanceof FigClassifierRole) {
                    ((FigClassifierRole)source).createActivations();
                }
                if ((dest = message.getDestFigNode()) == null || message.isSelfMessage() || !(dest instanceof FigClassifierRole)) continue;
                ((FigClassifierRole)dest).createActivations();
            }
        }
        this.lastY = snapPt.y;
        this.editor.damageAll();
    }

    public void mouseReleased(MouseEvent me) {
        this.shouldDraw = false;
        me.consume();
        this.editor.damageAll();
        this.done();
    }

    private List<FigMessage> getAllFigMessagesDownward(int position) {
        List<FigMessage> messages = this.getAllFigMessages();
        LinkedList<FigMessage> dMessages = new LinkedList<FigMessage>();
        for (FigMessage message : messages) {
            if (message.getY() <= position) continue;
            dMessages.add(message);
        }
        return dMessages;
    }

    private List<FigMessage> getAllFigMessages() {
        List edges = this.editor.getGraphModel().getEdges();
        ArrayList<FigMessage> messages = new ArrayList<FigMessage>(edges.size());
        for (Object message : edges) {
            Fig figM = this.editor.getLayerManager().getActiveLayer().presentationFor(message);
            messages.add((FigMessage)figM);
        }
        return messages;
    }

    public void paint(Graphics g) {
        if (!this.shouldDraw) {
            return;
        }
        Color selectRectColor = Globals.getPrefs().getRubberbandColor();
        g.setColor(selectRectColor);
        switch (this.currentDirection) {
            case 0: {
                g.fillRect(this.x1 - 10, this.y - 2, 20, 4);
                g.fillRect((this.x1 + this.x2) / 2 - 2, this.y - 10, 4, 20);
                break;
            }
            case 1: {
                g.fillRect(this.lastX1, this.lastY - 2, this.lastX2 - this.lastX1, 4);
                g.fillRect((this.lastX1 + this.lastX2) / 2 - 2, this.lastY, 4, 10);
                break;
            }
            case 2: {
                g.fillRect(this.lastX1, this.lastY - 2, this.lastX2 - this.lastX1, 4);
                g.fillRect((this.lastX1 + this.lastX2) / 2 - 2, this.lastY - 10, 4, 10);
            }
        }
    }
}

