// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package abi

import (
	"math/big"
	"strings"

	ethereum "energi.world/core/gen3"
	"energi.world/core/gen3/accounts/abi"
	"energi.world/core/gen3/accounts/abi/bind"
	"energi.world/core/gen3/common"
	"energi.world/core/gen3/core/types"
	"energi.world/core/gen3/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = abi.U256
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// TreasuryV1ABI is the input ABI used to generate the binding from.
const TreasuryV1ABI = "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_proxy\",\"type\":\"address\"},{\"internalType\":\"contractIGovernedProxy\",\"name\":\"_mnregistry_proxy\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_superblock_cycle\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"ref_uuid\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"contractIBudgetProposal\",\"name\":\"proposal\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"payout_address\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"deadline\",\"type\":\"uint256\"}],\"name\":\"BudgetProposal\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"}],\"name\":\"Contribution\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"ref_uuid\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"contractIBudgetProposal\",\"name\":\"proposal\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"}],\"name\":\"Payout\",\"type\":\"event\"},{\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"fallback\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"active_proposals\",\"outputs\":[{\"internalType\":\"contractIBudgetProposal\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"balance\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[],\"name\":\"contribute\",\"outputs\":[],\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_newImpl\",\"type\":\"address\"}],\"name\":\"destroy\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_blockNumber\",\"type\":\"uint256\"}],\"name\":\"getReward\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_blockNumber\",\"type\":\"uint256\"}],\"name\":\"isSuperblock\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"listProposals\",\"outputs\":[{\"internalType\":\"contractIBudgetProposal[]\",\"name\":\"proposals\",\"type\":\"address[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_oldImpl\",\"type\":\"address\"}],\"name\":\"migrate\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"mnregistry_proxy\",\"outputs\":[{\"internalType\":\"contractIGovernedProxy\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"contractIBudgetProposal\",\"name\":\"proposal\",\"type\":\"address\"}],\"name\":\"proposal_uuid\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_amount\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"_ref_uuid\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"_period\",\"type\":\"uint256\"}],\"name\":\"propose\",\"outputs\":[{\"internalType\":\"contractIBudgetProposal\",\"name\":\"proposal\",\"type\":\"address\"}],\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"proxy\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[],\"name\":\"reward\",\"outputs\":[],\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"superblock_cycle\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_ref_uuid\",\"type\":\"uint256\"}],\"name\":\"uuid_proposal\",\"outputs\":[{\"internalType\":\"contractIBudgetProposal\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"v1storage\",\"outputs\":[{\"internalType\":\"contractStorageTreasuryV1\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"}]"

// TreasuryV1Bin is the compiled bytecode used for deploying new contracts.
const TreasuryV1Bin = `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`

// DeployTreasuryV1 deploys a new Ethereum contract, binding an instance of TreasuryV1 to it.
func DeployTreasuryV1(auth *bind.TransactOpts, backend bind.ContractBackend, _proxy common.Address, _mnregistry_proxy common.Address, _superblock_cycle *big.Int) (common.Address, *types.Transaction, *TreasuryV1, error) {
	parsed, err := abi.JSON(strings.NewReader(TreasuryV1ABI))
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	address, tx, contract, err := bind.DeployContract(auth, parsed, common.FromHex(TreasuryV1Bin), backend, _proxy, _mnregistry_proxy, _superblock_cycle)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &TreasuryV1{TreasuryV1Caller: TreasuryV1Caller{contract: contract}, TreasuryV1Transactor: TreasuryV1Transactor{contract: contract}, TreasuryV1Filterer: TreasuryV1Filterer{contract: contract}}, nil
}

// TreasuryV1Bin is the compiled bytecode of contract after deployment.
const TreasuryV1RuntimeBin = `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`

// TreasuryV1 is an auto generated Go binding around an Ethereum contract.
type TreasuryV1 struct {
	TreasuryV1Caller     // Read-only binding to the contract
	TreasuryV1Transactor // Write-only binding to the contract
	TreasuryV1Filterer   // Log filterer for contract events
}

// TreasuryV1Caller is an auto generated read-only Go binding around an Ethereum contract.
type TreasuryV1Caller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// TreasuryV1Transactor is an auto generated write-only Go binding around an Ethereum contract.
type TreasuryV1Transactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// TreasuryV1Filterer is an auto generated log filtering Go binding around an Ethereum contract events.
type TreasuryV1Filterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// TreasuryV1Session is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type TreasuryV1Session struct {
	Contract     *TreasuryV1       // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// TreasuryV1CallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type TreasuryV1CallerSession struct {
	Contract *TreasuryV1Caller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts     // Call options to use throughout this session
}

// TreasuryV1TransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type TreasuryV1TransactorSession struct {
	Contract     *TreasuryV1Transactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts     // Transaction auth options to use throughout this session
}

// TreasuryV1Raw is an auto generated low-level Go binding around an Ethereum contract.
type TreasuryV1Raw struct {
	Contract *TreasuryV1 // Generic contract binding to access the raw methods on
}

// TreasuryV1CallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type TreasuryV1CallerRaw struct {
	Contract *TreasuryV1Caller // Generic read-only contract binding to access the raw methods on
}

// TreasuryV1TransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type TreasuryV1TransactorRaw struct {
	Contract *TreasuryV1Transactor // Generic write-only contract binding to access the raw methods on
}

// NewTreasuryV1 creates a new instance of TreasuryV1, bound to a specific deployed contract.
func NewTreasuryV1(address common.Address, backend bind.ContractBackend) (*TreasuryV1, error) {
	contract, err := bindTreasuryV1(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &TreasuryV1{TreasuryV1Caller: TreasuryV1Caller{contract: contract}, TreasuryV1Transactor: TreasuryV1Transactor{contract: contract}, TreasuryV1Filterer: TreasuryV1Filterer{contract: contract}}, nil
}

// NewTreasuryV1Caller creates a new read-only instance of TreasuryV1, bound to a specific deployed contract.
func NewTreasuryV1Caller(address common.Address, caller bind.ContractCaller) (*TreasuryV1Caller, error) {
	contract, err := bindTreasuryV1(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &TreasuryV1Caller{contract: contract}, nil
}

// NewTreasuryV1Transactor creates a new write-only instance of TreasuryV1, bound to a specific deployed contract.
func NewTreasuryV1Transactor(address common.Address, transactor bind.ContractTransactor) (*TreasuryV1Transactor, error) {
	contract, err := bindTreasuryV1(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &TreasuryV1Transactor{contract: contract}, nil
}

// NewTreasuryV1Filterer creates a new log filterer instance of TreasuryV1, bound to a specific deployed contract.
func NewTreasuryV1Filterer(address common.Address, filterer bind.ContractFilterer) (*TreasuryV1Filterer, error) {
	contract, err := bindTreasuryV1(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &TreasuryV1Filterer{contract: contract}, nil
}

// bindTreasuryV1 binds a generic wrapper to an already deployed contract.
func bindTreasuryV1(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(TreasuryV1ABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_TreasuryV1 *TreasuryV1Raw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _TreasuryV1.Contract.TreasuryV1Caller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_TreasuryV1 *TreasuryV1Raw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _TreasuryV1.Contract.TreasuryV1Transactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_TreasuryV1 *TreasuryV1Raw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _TreasuryV1.Contract.TreasuryV1Transactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_TreasuryV1 *TreasuryV1CallerRaw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _TreasuryV1.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_TreasuryV1 *TreasuryV1TransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _TreasuryV1.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_TreasuryV1 *TreasuryV1TransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _TreasuryV1.Contract.contract.Transact(opts, method, params...)
}

// ActiveProposals is a free data retrieval call binding the contract method 0xd5f99789.
//
// Solidity: function active_proposals(uint256 ) constant returns(address)
func (_TreasuryV1 *TreasuryV1Caller) ActiveProposals(opts *bind.CallOpts, arg0 *big.Int) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "active_proposals", arg0)
	return *ret0, err
}

// ActiveProposals is a free data retrieval call binding the contract method 0xd5f99789.
//
// Solidity: function active_proposals(uint256 ) constant returns(address)
func (_TreasuryV1 *TreasuryV1Session) ActiveProposals(arg0 *big.Int) (common.Address, error) {
	return _TreasuryV1.Contract.ActiveProposals(&_TreasuryV1.CallOpts, arg0)
}

// ActiveProposals is a free data retrieval call binding the contract method 0xd5f99789.
//
// Solidity: function active_proposals(uint256 ) constant returns(address)
func (_TreasuryV1 *TreasuryV1CallerSession) ActiveProposals(arg0 *big.Int) (common.Address, error) {
	return _TreasuryV1.Contract.ActiveProposals(&_TreasuryV1.CallOpts, arg0)
}

// Balance is a free data retrieval call binding the contract method 0xb69ef8a8.
//
// Solidity: function balance() constant returns(uint256 amount)
func (_TreasuryV1 *TreasuryV1Caller) Balance(opts *bind.CallOpts) (*big.Int, error) {
	var (
		ret0 = new(*big.Int)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "balance")
	return *ret0, err
}

// Balance is a free data retrieval call binding the contract method 0xb69ef8a8.
//
// Solidity: function balance() constant returns(uint256 amount)
func (_TreasuryV1 *TreasuryV1Session) Balance() (*big.Int, error) {
	return _TreasuryV1.Contract.Balance(&_TreasuryV1.CallOpts)
}

// Balance is a free data retrieval call binding the contract method 0xb69ef8a8.
//
// Solidity: function balance() constant returns(uint256 amount)
func (_TreasuryV1 *TreasuryV1CallerSession) Balance() (*big.Int, error) {
	return _TreasuryV1.Contract.Balance(&_TreasuryV1.CallOpts)
}

// GetReward is a free data retrieval call binding the contract method 0x1c4b774b.
//
// Solidity: function getReward(uint256 _blockNumber) constant returns(uint256 amount)
func (_TreasuryV1 *TreasuryV1Caller) GetReward(opts *bind.CallOpts, _blockNumber *big.Int) (*big.Int, error) {
	var (
		ret0 = new(*big.Int)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "getReward", _blockNumber)
	return *ret0, err
}

// GetReward is a free data retrieval call binding the contract method 0x1c4b774b.
//
// Solidity: function getReward(uint256 _blockNumber) constant returns(uint256 amount)
func (_TreasuryV1 *TreasuryV1Session) GetReward(_blockNumber *big.Int) (*big.Int, error) {
	return _TreasuryV1.Contract.GetReward(&_TreasuryV1.CallOpts, _blockNumber)
}

// GetReward is a free data retrieval call binding the contract method 0x1c4b774b.
//
// Solidity: function getReward(uint256 _blockNumber) constant returns(uint256 amount)
func (_TreasuryV1 *TreasuryV1CallerSession) GetReward(_blockNumber *big.Int) (*big.Int, error) {
	return _TreasuryV1.Contract.GetReward(&_TreasuryV1.CallOpts, _blockNumber)
}

// IsSuperblock is a free data retrieval call binding the contract method 0x52782d86.
//
// Solidity: function isSuperblock(uint256 _blockNumber) constant returns(bool)
func (_TreasuryV1 *TreasuryV1Caller) IsSuperblock(opts *bind.CallOpts, _blockNumber *big.Int) (bool, error) {
	var (
		ret0 = new(bool)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "isSuperblock", _blockNumber)
	return *ret0, err
}

// IsSuperblock is a free data retrieval call binding the contract method 0x52782d86.
//
// Solidity: function isSuperblock(uint256 _blockNumber) constant returns(bool)
func (_TreasuryV1 *TreasuryV1Session) IsSuperblock(_blockNumber *big.Int) (bool, error) {
	return _TreasuryV1.Contract.IsSuperblock(&_TreasuryV1.CallOpts, _blockNumber)
}

// IsSuperblock is a free data retrieval call binding the contract method 0x52782d86.
//
// Solidity: function isSuperblock(uint256 _blockNumber) constant returns(bool)
func (_TreasuryV1 *TreasuryV1CallerSession) IsSuperblock(_blockNumber *big.Int) (bool, error) {
	return _TreasuryV1.Contract.IsSuperblock(&_TreasuryV1.CallOpts, _blockNumber)
}

// ListProposals is a free data retrieval call binding the contract method 0x26c7eb1c.
//
// Solidity: function listProposals() constant returns(address[] proposals)
func (_TreasuryV1 *TreasuryV1Caller) ListProposals(opts *bind.CallOpts) ([]common.Address, error) {
	var (
		ret0 = new([]common.Address)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "listProposals")
	return *ret0, err
}

// ListProposals is a free data retrieval call binding the contract method 0x26c7eb1c.
//
// Solidity: function listProposals() constant returns(address[] proposals)
func (_TreasuryV1 *TreasuryV1Session) ListProposals() ([]common.Address, error) {
	return _TreasuryV1.Contract.ListProposals(&_TreasuryV1.CallOpts)
}

// ListProposals is a free data retrieval call binding the contract method 0x26c7eb1c.
//
// Solidity: function listProposals() constant returns(address[] proposals)
func (_TreasuryV1 *TreasuryV1CallerSession) ListProposals() ([]common.Address, error) {
	return _TreasuryV1.Contract.ListProposals(&_TreasuryV1.CallOpts)
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_TreasuryV1 *TreasuryV1Caller) MnregistryProxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "mnregistry_proxy")
	return *ret0, err
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_TreasuryV1 *TreasuryV1Session) MnregistryProxy() (common.Address, error) {
	return _TreasuryV1.Contract.MnregistryProxy(&_TreasuryV1.CallOpts)
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_TreasuryV1 *TreasuryV1CallerSession) MnregistryProxy() (common.Address, error) {
	return _TreasuryV1.Contract.MnregistryProxy(&_TreasuryV1.CallOpts)
}

// ProposalUuid is a free data retrieval call binding the contract method 0xcaef1d5a.
//
// Solidity: function proposal_uuid(address proposal) constant returns(uint256)
func (_TreasuryV1 *TreasuryV1Caller) ProposalUuid(opts *bind.CallOpts, proposal common.Address) (*big.Int, error) {
	var (
		ret0 = new(*big.Int)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "proposal_uuid", proposal)
	return *ret0, err
}

// ProposalUuid is a free data retrieval call binding the contract method 0xcaef1d5a.
//
// Solidity: function proposal_uuid(address proposal) constant returns(uint256)
func (_TreasuryV1 *TreasuryV1Session) ProposalUuid(proposal common.Address) (*big.Int, error) {
	return _TreasuryV1.Contract.ProposalUuid(&_TreasuryV1.CallOpts, proposal)
}

// ProposalUuid is a free data retrieval call binding the contract method 0xcaef1d5a.
//
// Solidity: function proposal_uuid(address proposal) constant returns(uint256)
func (_TreasuryV1 *TreasuryV1CallerSession) ProposalUuid(proposal common.Address) (*big.Int, error) {
	return _TreasuryV1.Contract.ProposalUuid(&_TreasuryV1.CallOpts, proposal)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_TreasuryV1 *TreasuryV1Caller) Proxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "proxy")
	return *ret0, err
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_TreasuryV1 *TreasuryV1Session) Proxy() (common.Address, error) {
	return _TreasuryV1.Contract.Proxy(&_TreasuryV1.CallOpts)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_TreasuryV1 *TreasuryV1CallerSession) Proxy() (common.Address, error) {
	return _TreasuryV1.Contract.Proxy(&_TreasuryV1.CallOpts)
}

// SuperblockCycle is a free data retrieval call binding the contract method 0x0ef34745.
//
// Solidity: function superblock_cycle() constant returns(uint256)
func (_TreasuryV1 *TreasuryV1Caller) SuperblockCycle(opts *bind.CallOpts) (*big.Int, error) {
	var (
		ret0 = new(*big.Int)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "superblock_cycle")
	return *ret0, err
}

// SuperblockCycle is a free data retrieval call binding the contract method 0x0ef34745.
//
// Solidity: function superblock_cycle() constant returns(uint256)
func (_TreasuryV1 *TreasuryV1Session) SuperblockCycle() (*big.Int, error) {
	return _TreasuryV1.Contract.SuperblockCycle(&_TreasuryV1.CallOpts)
}

// SuperblockCycle is a free data retrieval call binding the contract method 0x0ef34745.
//
// Solidity: function superblock_cycle() constant returns(uint256)
func (_TreasuryV1 *TreasuryV1CallerSession) SuperblockCycle() (*big.Int, error) {
	return _TreasuryV1.Contract.SuperblockCycle(&_TreasuryV1.CallOpts)
}

// UuidProposal is a free data retrieval call binding the contract method 0x5c099215.
//
// Solidity: function uuid_proposal(uint256 _ref_uuid) constant returns(address)
func (_TreasuryV1 *TreasuryV1Caller) UuidProposal(opts *bind.CallOpts, _ref_uuid *big.Int) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "uuid_proposal", _ref_uuid)
	return *ret0, err
}

// UuidProposal is a free data retrieval call binding the contract method 0x5c099215.
//
// Solidity: function uuid_proposal(uint256 _ref_uuid) constant returns(address)
func (_TreasuryV1 *TreasuryV1Session) UuidProposal(_ref_uuid *big.Int) (common.Address, error) {
	return _TreasuryV1.Contract.UuidProposal(&_TreasuryV1.CallOpts, _ref_uuid)
}

// UuidProposal is a free data retrieval call binding the contract method 0x5c099215.
//
// Solidity: function uuid_proposal(uint256 _ref_uuid) constant returns(address)
func (_TreasuryV1 *TreasuryV1CallerSession) UuidProposal(_ref_uuid *big.Int) (common.Address, error) {
	return _TreasuryV1.Contract.UuidProposal(&_TreasuryV1.CallOpts, _ref_uuid)
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_TreasuryV1 *TreasuryV1Caller) V1storage(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _TreasuryV1.contract.Call(opts, out, "v1storage")
	return *ret0, err
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_TreasuryV1 *TreasuryV1Session) V1storage() (common.Address, error) {
	return _TreasuryV1.Contract.V1storage(&_TreasuryV1.CallOpts)
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_TreasuryV1 *TreasuryV1CallerSession) V1storage() (common.Address, error) {
	return _TreasuryV1.Contract.V1storage(&_TreasuryV1.CallOpts)
}

// Contribute is a paid mutator transaction binding the contract method 0xd7bb99ba.
//
// Solidity: function contribute() returns()
func (_TreasuryV1 *TreasuryV1Transactor) Contribute(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _TreasuryV1.contract.Transact(opts, "contribute")
}

// Contribute is a paid mutator transaction binding the contract method 0xd7bb99ba.
//
// Solidity: function contribute() returns()
func (_TreasuryV1 *TreasuryV1Session) Contribute() (*types.Transaction, error) {
	return _TreasuryV1.Contract.Contribute(&_TreasuryV1.TransactOpts)
}

// Contribute is a paid mutator transaction binding the contract method 0xd7bb99ba.
//
// Solidity: function contribute() returns()
func (_TreasuryV1 *TreasuryV1TransactorSession) Contribute() (*types.Transaction, error) {
	return _TreasuryV1.Contract.Contribute(&_TreasuryV1.TransactOpts)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_TreasuryV1 *TreasuryV1Transactor) Destroy(opts *bind.TransactOpts, _newImpl common.Address) (*types.Transaction, error) {
	return _TreasuryV1.contract.Transact(opts, "destroy", _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_TreasuryV1 *TreasuryV1Session) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _TreasuryV1.Contract.Destroy(&_TreasuryV1.TransactOpts, _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_TreasuryV1 *TreasuryV1TransactorSession) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _TreasuryV1.Contract.Destroy(&_TreasuryV1.TransactOpts, _newImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_TreasuryV1 *TreasuryV1Transactor) Migrate(opts *bind.TransactOpts, _oldImpl common.Address) (*types.Transaction, error) {
	return _TreasuryV1.contract.Transact(opts, "migrate", _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_TreasuryV1 *TreasuryV1Session) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _TreasuryV1.Contract.Migrate(&_TreasuryV1.TransactOpts, _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_TreasuryV1 *TreasuryV1TransactorSession) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _TreasuryV1.Contract.Migrate(&_TreasuryV1.TransactOpts, _oldImpl)
}

// Propose is a paid mutator transaction binding the contract method 0x40376d56.
//
// Solidity: function propose(uint256 _amount, uint256 _ref_uuid, uint256 _period) returns(address proposal)
func (_TreasuryV1 *TreasuryV1Transactor) Propose(opts *bind.TransactOpts, _amount *big.Int, _ref_uuid *big.Int, _period *big.Int) (*types.Transaction, error) {
	return _TreasuryV1.contract.Transact(opts, "propose", _amount, _ref_uuid, _period)
}

// Propose is a paid mutator transaction binding the contract method 0x40376d56.
//
// Solidity: function propose(uint256 _amount, uint256 _ref_uuid, uint256 _period) returns(address proposal)
func (_TreasuryV1 *TreasuryV1Session) Propose(_amount *big.Int, _ref_uuid *big.Int, _period *big.Int) (*types.Transaction, error) {
	return _TreasuryV1.Contract.Propose(&_TreasuryV1.TransactOpts, _amount, _ref_uuid, _period)
}

// Propose is a paid mutator transaction binding the contract method 0x40376d56.
//
// Solidity: function propose(uint256 _amount, uint256 _ref_uuid, uint256 _period) returns(address proposal)
func (_TreasuryV1 *TreasuryV1TransactorSession) Propose(_amount *big.Int, _ref_uuid *big.Int, _period *big.Int) (*types.Transaction, error) {
	return _TreasuryV1.Contract.Propose(&_TreasuryV1.TransactOpts, _amount, _ref_uuid, _period)
}

// Reward is a paid mutator transaction binding the contract method 0x228cb733.
//
// Solidity: function reward() returns()
func (_TreasuryV1 *TreasuryV1Transactor) Reward(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _TreasuryV1.contract.Transact(opts, "reward")
}

// Reward is a paid mutator transaction binding the contract method 0x228cb733.
//
// Solidity: function reward() returns()
func (_TreasuryV1 *TreasuryV1Session) Reward() (*types.Transaction, error) {
	return _TreasuryV1.Contract.Reward(&_TreasuryV1.TransactOpts)
}

// Reward is a paid mutator transaction binding the contract method 0x228cb733.
//
// Solidity: function reward() returns()
func (_TreasuryV1 *TreasuryV1TransactorSession) Reward() (*types.Transaction, error) {
	return _TreasuryV1.Contract.Reward(&_TreasuryV1.TransactOpts)
}

// TreasuryV1BudgetProposalIterator is returned from FilterBudgetProposal and is used to iterate over the raw logs and unpacked data for BudgetProposal events raised by the TreasuryV1 contract.
type TreasuryV1BudgetProposalIterator struct {
	Event *TreasuryV1BudgetProposal // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *TreasuryV1BudgetProposalIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(TreasuryV1BudgetProposal)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(TreasuryV1BudgetProposal)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *TreasuryV1BudgetProposalIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *TreasuryV1BudgetProposalIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// TreasuryV1BudgetProposal represents a BudgetProposal event raised by the TreasuryV1 contract.
type TreasuryV1BudgetProposal struct {
	RefUuid       *big.Int
	Proposal      common.Address
	PayoutAddress common.Address
	Amount        *big.Int
	Deadline      *big.Int
	Raw           types.Log // Blockchain specific contextual infos
}

// FilterBudgetProposal is a free log retrieval operation binding the contract event 0xa94befa3ce181974130fe36e854a282c70fb75e4decb42bfecdecbd6f88f0f5d.
//
// Solidity: event BudgetProposal(uint256 indexed ref_uuid, address proposal, address payout_address, uint256 amount, uint256 deadline)
func (_TreasuryV1 *TreasuryV1Filterer) FilterBudgetProposal(opts *bind.FilterOpts, ref_uuid []*big.Int) (*TreasuryV1BudgetProposalIterator, error) {

	var ref_uuidRule []interface{}
	for _, ref_uuidItem := range ref_uuid {
		ref_uuidRule = append(ref_uuidRule, ref_uuidItem)
	}

	logs, sub, err := _TreasuryV1.contract.FilterLogs(opts, "BudgetProposal", ref_uuidRule)
	if err != nil {
		return nil, err
	}
	return &TreasuryV1BudgetProposalIterator{contract: _TreasuryV1.contract, event: "BudgetProposal", logs: logs, sub: sub}, nil
}

// WatchBudgetProposal is a free log subscription operation binding the contract event 0xa94befa3ce181974130fe36e854a282c70fb75e4decb42bfecdecbd6f88f0f5d.
//
// Solidity: event BudgetProposal(uint256 indexed ref_uuid, address proposal, address payout_address, uint256 amount, uint256 deadline)
func (_TreasuryV1 *TreasuryV1Filterer) WatchBudgetProposal(opts *bind.WatchOpts, sink chan<- *TreasuryV1BudgetProposal, ref_uuid []*big.Int) (event.Subscription, error) {

	var ref_uuidRule []interface{}
	for _, ref_uuidItem := range ref_uuid {
		ref_uuidRule = append(ref_uuidRule, ref_uuidItem)
	}

	logs, sub, err := _TreasuryV1.contract.WatchLogs(opts, "BudgetProposal", ref_uuidRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(TreasuryV1BudgetProposal)
				if err := _TreasuryV1.contract.UnpackLog(event, "BudgetProposal", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// TreasuryV1ContributionIterator is returned from FilterContribution and is used to iterate over the raw logs and unpacked data for Contribution events raised by the TreasuryV1 contract.
type TreasuryV1ContributionIterator struct {
	Event *TreasuryV1Contribution // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *TreasuryV1ContributionIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(TreasuryV1Contribution)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(TreasuryV1Contribution)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *TreasuryV1ContributionIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *TreasuryV1ContributionIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// TreasuryV1Contribution represents a Contribution event raised by the TreasuryV1 contract.
type TreasuryV1Contribution struct {
	From   common.Address
	Amount *big.Int
	Raw    types.Log // Blockchain specific contextual infos
}

// FilterContribution is a free log retrieval operation binding the contract event 0x4d154d4aae216bed6d0926db77c00df2b57c6b5ba4eee05775de20facede3a7b.
//
// Solidity: event Contribution(address from, uint256 amount)
func (_TreasuryV1 *TreasuryV1Filterer) FilterContribution(opts *bind.FilterOpts) (*TreasuryV1ContributionIterator, error) {

	logs, sub, err := _TreasuryV1.contract.FilterLogs(opts, "Contribution")
	if err != nil {
		return nil, err
	}
	return &TreasuryV1ContributionIterator{contract: _TreasuryV1.contract, event: "Contribution", logs: logs, sub: sub}, nil
}

// WatchContribution is a free log subscription operation binding the contract event 0x4d154d4aae216bed6d0926db77c00df2b57c6b5ba4eee05775de20facede3a7b.
//
// Solidity: event Contribution(address from, uint256 amount)
func (_TreasuryV1 *TreasuryV1Filterer) WatchContribution(opts *bind.WatchOpts, sink chan<- *TreasuryV1Contribution) (event.Subscription, error) {

	logs, sub, err := _TreasuryV1.contract.WatchLogs(opts, "Contribution")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(TreasuryV1Contribution)
				if err := _TreasuryV1.contract.UnpackLog(event, "Contribution", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// TreasuryV1PayoutIterator is returned from FilterPayout and is used to iterate over the raw logs and unpacked data for Payout events raised by the TreasuryV1 contract.
type TreasuryV1PayoutIterator struct {
	Event *TreasuryV1Payout // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *TreasuryV1PayoutIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(TreasuryV1Payout)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(TreasuryV1Payout)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *TreasuryV1PayoutIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *TreasuryV1PayoutIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// TreasuryV1Payout represents a Payout event raised by the TreasuryV1 contract.
type TreasuryV1Payout struct {
	RefUuid  *big.Int
	Proposal common.Address
	Amount   *big.Int
	Raw      types.Log // Blockchain specific contextual infos
}

// FilterPayout is a free log retrieval operation binding the contract event 0x5f7341a552ae2d452b071917104c05fbac3663936a69be768a05c40605056e7d.
//
// Solidity: event Payout(uint256 indexed ref_uuid, address proposal, uint256 amount)
func (_TreasuryV1 *TreasuryV1Filterer) FilterPayout(opts *bind.FilterOpts, ref_uuid []*big.Int) (*TreasuryV1PayoutIterator, error) {

	var ref_uuidRule []interface{}
	for _, ref_uuidItem := range ref_uuid {
		ref_uuidRule = append(ref_uuidRule, ref_uuidItem)
	}

	logs, sub, err := _TreasuryV1.contract.FilterLogs(opts, "Payout", ref_uuidRule)
	if err != nil {
		return nil, err
	}
	return &TreasuryV1PayoutIterator{contract: _TreasuryV1.contract, event: "Payout", logs: logs, sub: sub}, nil
}

// WatchPayout is a free log subscription operation binding the contract event 0x5f7341a552ae2d452b071917104c05fbac3663936a69be768a05c40605056e7d.
//
// Solidity: event Payout(uint256 indexed ref_uuid, address proposal, uint256 amount)
func (_TreasuryV1 *TreasuryV1Filterer) WatchPayout(opts *bind.WatchOpts, sink chan<- *TreasuryV1Payout, ref_uuid []*big.Int) (event.Subscription, error) {

	var ref_uuidRule []interface{}
	for _, ref_uuidItem := range ref_uuid {
		ref_uuidRule = append(ref_uuidRule, ref_uuidItem)
	}

	logs, sub, err := _TreasuryV1.contract.WatchLogs(opts, "Payout", ref_uuidRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(TreasuryV1Payout)
				if err := _TreasuryV1.contract.UnpackLog(event, "Payout", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}
