/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import org.gradle.internal.component.NoMatchingCapabilitiesException;
import org.gradle.internal.component.resolution.failure.CapabilitiesDescriber;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.NoMatchingCapabilitiesFailure;

public abstract class NoMatchingCapabilitiesFailureDescriber
extends AbstractResolutionFailureDescriber<NoMatchingCapabilitiesException, NoMatchingCapabilitiesFailure> {
    @Override
    public NoMatchingCapabilitiesException describeFailure(NoMatchingCapabilitiesFailure failure) {
        String message = this.buildNoMatchingCapabilitiesFailureMsg(failure);
        NoMatchingCapabilitiesException e = new NoMatchingCapabilitiesException(message);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    private String buildNoMatchingCapabilitiesFailureMsg(NoMatchingCapabilitiesFailure failure) {
        StringBuilder sb = new StringBuilder("Unable to find a variant of ");
        sb.append(failure.getTargetComponent().getId()).append(" providing the requested ");
        sb.append(CapabilitiesDescriber.describeCapabilitiesWithTitle(failure.getTargetComponent(), failure.getRequestedCapabilities()));
        sb.append(":\n");
        for (ResolutionCandidateAssessor.AssessedCandidate candidate : failure.getCandidates()) {
            sb.append("   - Variant ").append(candidate.getDisplayName()).append(" provides ");
            sb.append(CapabilitiesDescriber.describeCapabilities(failure.getTargetComponent(), candidate.getCandidateCapabilities().asSet())).append("\n");
        }
        return sb.toString();
    }
}

