/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.AmbiguousArtifactVariantsException;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.AmbiguousResolutionFailure;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class AmbiguousArtifactVariantsFailureDescriber
extends AbstractResolutionFailureDescriber<AmbiguousArtifactVariantsException, AmbiguousResolutionFailure> {
    private static final String AMBIGUOUS_VARIANTS_PREFIX = "Ambiguity errors are explained in more detail at ";
    private static final String AMBIGUOUS_VARIANTS_SECTION = "sub:variant-ambiguity";

    @Override
    public AmbiguousArtifactVariantsException describeFailure(AmbiguousResolutionFailure failure) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), failure.getSchema());
        String message = this.buildMultipleMatchingVariantsFailureMsg(failure, describer);
        AmbiguousArtifactVariantsException e = new AmbiguousArtifactVariantsException(message);
        this.suggestSpecificDocumentation(e, AMBIGUOUS_VARIANTS_PREFIX, AMBIGUOUS_VARIANTS_SECTION);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    private String buildMultipleMatchingVariantsFailureMsg(AmbiguousResolutionFailure failure, AttributeDescriber describer) {
        TreeFormatter formatter = new TreeFormatter();
        if (failure.getRequestedAttributes().isEmpty()) {
            formatter.node("More than one variant of " + failure.getRequestedName() + " matches the consumer attributes");
        } else {
            formatter.node("The consumer was configured to find " + describer.describeAttributeSet(failure.getRequestedAttributes().asMap()) + ". However we cannot choose between the following variants of " + failure.getRequestedName());
        }
        formatter.startChildren();
        for (ResolutionCandidateAssessor.AssessedCandidate assessedCandidate : failure.getCandidates()) {
            String candidateName = assessedCandidate.getDisplayName();
            formatter.node(candidateName);
            this.formatAttributeMatchesForAmbiguity(assessedCandidate, formatter, describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

