/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.transformers;

import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.ProblemReport;
import org.gradle.api.problems.internal.ProblemTransformer;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;

public class ProblemStreamLocationTransformer
implements ProblemTransformer {
    private final ProblemStream problemStream;

    public ProblemStreamLocationTransformer(ProblemStream problemStream) {
        this.problemStream = problemStream;
    }

    public ProblemReport transform(ProblemReport problem, OperationIdentifier id) {
        ProblemDiagnostics problemDiagnostics = this.problemStream.forCurrentCaller((Throwable)problem.getContext().getException());
        Location loc = problemDiagnostics.getLocation();
        InternalProblemBuilder builder = problem.toBuilder();
        if (loc != null) {
            builder.lineInFileLocation(loc.getSourceLongDisplayName().getDisplayName(), loc.getLineNumber());
        }
        if (problemDiagnostics.getSource() != null && problemDiagnostics.getSource().getPluginId() != null) {
            builder.pluginLocation(problemDiagnostics.getSource().getPluginId()).build();
        }
        return builder.build();
    }
}

