/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.buildtree.BuildTreeModelController;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.tooling.internal.gradle.GradleBuildIdentity;
import org.gradle.tooling.internal.gradle.GradleProjectIdentity;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalActionAwareBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.InternalStreamedValueRelay;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.provider.connection.ProviderBuildResult;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.internal.provider.serialization.StreamedValue;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelParameterCarrier;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;
import org.gradle.util.Path;

class DefaultBuildController
implements InternalBuildController,
InternalBuildControllerVersion2,
InternalActionAwareBuildController,
InternalStreamedValueRelay {
    private final WorkerThreadRegistry workerThreadRegistry;
    private final BuildTreeModelController controller;
    private final BuildCancellationToken cancellationToken;
    private final BuildStateRegistry buildStateRegistry;
    private final ToolingModelParameterCarrier.Factory parameterCarrierFactory;
    private final BuildEventConsumer buildEventConsumer;
    private final PayloadSerializer payloadSerializer;

    public DefaultBuildController(BuildTreeModelController controller, WorkerThreadRegistry workerThreadRegistry, BuildCancellationToken cancellationToken, BuildStateRegistry buildStateRegistry, ToolingModelParameterCarrier.Factory parameterCarrierFactory, BuildEventConsumer buildEventConsumer, PayloadSerializer payloadSerializer) {
        this.workerThreadRegistry = workerThreadRegistry;
        this.controller = controller;
        this.cancellationToken = cancellationToken;
        this.buildStateRegistry = buildStateRegistry;
        this.parameterCarrierFactory = parameterCarrierFactory;
        this.buildEventConsumer = buildEventConsumer;
        this.payloadSerializer = payloadSerializer;
    }

    @Deprecated
    public BuildResult<?> getBuildModel() throws BuildExceptionVersion1 {
        this.assertCanQuery();
        return new ProviderBuildResult((Object)this.controller.getConfiguredModel());
    }

    @Deprecated
    public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        return this.getModel(target, modelIdentifier, null);
    }

    public BuildResult<?> getModel(@Nullable Object target, ModelIdentifier modelIdentifier, Object parameter) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        Object model;
        this.assertCanQuery();
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException(String.format("Could not build '%s' model. Build cancelled.", modelIdentifier.getName()));
        }
        ToolingModelScope scope = this.getTarget(target, modelIdentifier, parameter != null);
        try {
            model = parameter == null ? scope.getModel(modelIdentifier.getName(), null) : scope.getModel(modelIdentifier.getName(), this.parameterCarrierFactory.createCarrier(parameter));
        }
        catch (UnknownModelException e) {
            throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)e);
        }
        return new ProviderBuildResult(model);
    }

    public boolean getCanQueryProjectModelInParallel(Class<?> modelType) {
        return this.controller.queryModelActionsRunInParallel();
    }

    public <T> List<T> run(List<Supplier<T>> actions) {
        this.assertCanQuery();
        return this.controller.runQueryModelActions(actions);
    }

    private ToolingModelScope getTarget(@Nullable Object target, ModelIdentifier modelIdentifier, boolean parameter) {
        if (target == null) {
            return this.controller.locateBuilderForDefaultTarget(modelIdentifier.getName(), parameter);
        }
        if (target instanceof GradleProjectIdentity) {
            GradleProjectIdentity projectIdentity = (GradleProjectIdentity)target;
            BuildState build = this.findBuild((GradleBuildIdentity)projectIdentity);
            ProjectState project = this.findProject(build, projectIdentity);
            return this.controller.locateBuilderForTarget(project, modelIdentifier.getName(), parameter);
        }
        if (target instanceof GradleBuildIdentity) {
            GradleBuildIdentity buildIdentity = (GradleBuildIdentity)target;
            BuildState build = this.findBuild(buildIdentity);
            return this.controller.locateBuilderForTarget(build, modelIdentifier.getName(), parameter);
        }
        throw new IllegalArgumentException("Don't know how to build models for " + target);
    }

    private BuildState findBuild(GradleBuildIdentity buildIdentity) {
        AtomicReference match = new AtomicReference();
        this.buildStateRegistry.visitBuilds(buildState -> {
            if (buildState.isImportableBuild() && buildState.getBuildRootDir().equals(buildIdentity.getRootDir())) {
                match.set(buildState);
            }
        });
        if (match.get() != null) {
            return (BuildState)match.get();
        }
        throw new IllegalArgumentException(buildIdentity.getRootDir() + " is not included in this build");
    }

    private ProjectState findProject(BuildState build, GradleProjectIdentity projectIdentity) {
        build.ensureProjectsLoaded();
        return build.getProjects().getProject(Path.path((String)projectIdentity.getProjectPath()));
    }

    private void assertCanQuery() {
        if (!this.workerThreadRegistry.isWorkerThread()) {
            throw new IllegalStateException("A build controller cannot be used from a thread that is not managed by Gradle.");
        }
    }

    public void dispatch(Object value) {
        SerializedPayload serializedModel = this.payloadSerializer.serialize(value);
        this.buildEventConsumer.dispatch((Object)new StreamedValue(serializedModel));
    }
}

