import { FC, KeyboardEventHandler, RefObject } from "react";
import { TCascadeOption } from "./CascadeOption";
import { PublicBaseSelectProps } from "react-select/base";
export type TCascadeMenuForwardRef = {
    setOpen: (value: boolean) => void;
};
export type TStylingProps = {
    components?: {
        option?: FC<{
            option: TValue;
        }>;
        openerOption?: FC<{
            option: TValue;
        }>;
    };
    classNames?: {
        option?: string;
        openerOption?: string;
    };
    styles?: {
        maxMenuHeight?: string;
        menuWidth?: string;
        menuZIndex?: number;
    };
};
export type TValue = {
    value: string;
    label: string;
};
export type TMeta = Record<string, any>;
type TCascadeProps<Meta extends TMeta> = TStylingProps & {
    options: Array<TCascadeOption<Meta>>;
    onSelect: (value: TCascadeOption<Meta>[]) => void;
    onKeyDown?: KeyboardEventHandler<HTMLDivElement>;
    afterSelectDisplayTransform?: (values: TValue[]) => string;
    afterSelectValueTransform?: (values: TValue[]) => string;
    separator?: string;
    selectProps?: Partial<PublicBaseSelectProps<TCascadeOption<Meta>, false, any>>;
    menuPortalTarget?: RefObject<HTMLDivElement>;
    openerSelectable?: boolean;
};
export declare function Cascade<Meta extends TMeta = object>({ separator, ...props }: TCascadeProps<Meta>): import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=index.d.ts.map