/*
  Copyright(C) 2005-2006 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef COMMON_IOPERMS_H
#define COMMON_IOPERMS_H

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

int is_file_accessible(const char *file, struct stat *stat_buf);
gid_t *get_process_group_ids(int *gid_nbr);
int is_file_readable(const char *file);
int is_file_writable(const char *file);
int is_file_executable(const char *file);

#endif /* COMMON_IOPERMS_H */
