# Upgrading to 13.0.0

## Summary#ok? / Summary.ok? `strict` argument

The `strict` argument for all the result / summary classes has changed to a keyword argument.

This was typically used in `.ok?` and `#ok?` checks for the summary reporter.

### Before 13.0.0

```ruby
summary = Cucumber::Core::Report::Summary.new(event_bus)
# There are many examples of the strict configuration
strict = ::Cucumber::Core::Test::Result::StrictConfiguration.new([:undefined])
summary.ok?(strict)
```

```ruby
# There are many examples of result classes
Result::Flaky.ok?(false)
```

### With cucumber 13.0.0

```ruby
summary = Cucumber::Core::Report::Summary.new(event_bus)
# There are many examples of the strict configuration
strict = ::Cucumber::Core::Test::Result::StrictConfiguration.new([:undefined])
summary.ok?(strict: strict)
```

```ruby
# There are many examples of result classes
Result::Flaky.ok?(strict: false)
```
