// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package osis

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePipeline for more information on using the CreatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePipelineRequest method.
//	req, resp := client.CreatePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/CreatePipeline
func (c *OSIS) CreatePipelineRequest(input *CreatePipelineInput) (req *request.Request, output *CreatePipelineOutput) {
	op := &request.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/2022-01-01/osis/createPipeline",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	output = &CreatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePipeline API operation for Amazon OpenSearch Ingestion.
//
// Creates an OpenSearch Ingestion pipeline. For more information, see Creating
// Amazon OpenSearch Ingestion pipelines (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation CreatePipeline for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You attempted to create more than the allowed number of tags.
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - ResourceAlreadyExistsException
//     You attempted to create a resource that already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/CreatePipeline
func (c *OSIS) CreatePipeline(input *CreatePipelineInput) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	return out, req.Send()
}

// CreatePipelineWithContext is the same as CreatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) CreatePipelineWithContext(ctx aws.Context, input *CreatePipelineInput, opts ...request.Option) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePipeline for more information on using the DeletePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePipelineRequest method.
//	req, resp := client.DeletePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/DeletePipeline
func (c *OSIS) DeletePipelineRequest(input *DeletePipelineInput) (req *request.Request, output *DeletePipelineOutput) {
	op := &request.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2022-01-01/osis/deletePipeline/{PipelineName}",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	output = &DeletePipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePipeline API operation for Amazon OpenSearch Ingestion.
//
// Deletes an OpenSearch Ingestion pipeline. For more information, see Deleting
// Amazon OpenSearch Ingestion pipelines (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/delete-pipeline.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation DeletePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
//   - ConflictException
//     The client attempted to remove a resource that is currently in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/DeletePipeline
func (c *OSIS) DeletePipeline(input *DeletePipelineInput) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	return out, req.Send()
}

// DeletePipelineWithContext is the same as DeletePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) DeletePipelineWithContext(ctx aws.Context, input *DeletePipelineInput, opts ...request.Option) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipeline = "GetPipeline"

// GetPipelineRequest generates a "aws/request.Request" representing the
// client's request for the GetPipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipeline for more information on using the GetPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPipelineRequest method.
//	req, resp := client.GetPipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipeline
func (c *OSIS) GetPipelineRequest(input *GetPipelineInput) (req *request.Request, output *GetPipelineOutput) {
	op := &request.Operation{
		Name:       opGetPipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/2022-01-01/osis/getPipeline/{PipelineName}",
	}

	if input == nil {
		input = &GetPipelineInput{}
	}

	output = &GetPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipeline API operation for Amazon OpenSearch Ingestion.
//
// Retrieves information about an OpenSearch Ingestion pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation GetPipeline for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipeline
func (c *OSIS) GetPipeline(input *GetPipelineInput) (*GetPipelineOutput, error) {
	req, out := c.GetPipelineRequest(input)
	return out, req.Send()
}

// GetPipelineWithContext is the same as GetPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) GetPipelineWithContext(ctx aws.Context, input *GetPipelineInput, opts ...request.Option) (*GetPipelineOutput, error) {
	req, out := c.GetPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipelineBlueprint = "GetPipelineBlueprint"

// GetPipelineBlueprintRequest generates a "aws/request.Request" representing the
// client's request for the GetPipelineBlueprint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipelineBlueprint for more information on using the GetPipelineBlueprint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPipelineBlueprintRequest method.
//	req, resp := client.GetPipelineBlueprintRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipelineBlueprint
func (c *OSIS) GetPipelineBlueprintRequest(input *GetPipelineBlueprintInput) (req *request.Request, output *GetPipelineBlueprintOutput) {
	op := &request.Operation{
		Name:       opGetPipelineBlueprint,
		HTTPMethod: "GET",
		HTTPPath:   "/2022-01-01/osis/getPipelineBlueprint/{BlueprintName}",
	}

	if input == nil {
		input = &GetPipelineBlueprintInput{}
	}

	output = &GetPipelineBlueprintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipelineBlueprint API operation for Amazon OpenSearch Ingestion.
//
// Retrieves information about a specific blueprint for OpenSearch Ingestion.
// Blueprints are templates for the configuration needed for a CreatePipeline
// request. For more information, see Using blueprints to create a pipeline
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#pipeline-blueprint).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation GetPipelineBlueprint for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipelineBlueprint
func (c *OSIS) GetPipelineBlueprint(input *GetPipelineBlueprintInput) (*GetPipelineBlueprintOutput, error) {
	req, out := c.GetPipelineBlueprintRequest(input)
	return out, req.Send()
}

// GetPipelineBlueprintWithContext is the same as GetPipelineBlueprint with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipelineBlueprint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) GetPipelineBlueprintWithContext(ctx aws.Context, input *GetPipelineBlueprintInput, opts ...request.Option) (*GetPipelineBlueprintOutput, error) {
	req, out := c.GetPipelineBlueprintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipelineChangeProgress = "GetPipelineChangeProgress"

// GetPipelineChangeProgressRequest generates a "aws/request.Request" representing the
// client's request for the GetPipelineChangeProgress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipelineChangeProgress for more information on using the GetPipelineChangeProgress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPipelineChangeProgressRequest method.
//	req, resp := client.GetPipelineChangeProgressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipelineChangeProgress
func (c *OSIS) GetPipelineChangeProgressRequest(input *GetPipelineChangeProgressInput) (req *request.Request, output *GetPipelineChangeProgressOutput) {
	op := &request.Operation{
		Name:       opGetPipelineChangeProgress,
		HTTPMethod: "GET",
		HTTPPath:   "/2022-01-01/osis/getPipelineChangeProgress/{PipelineName}",
	}

	if input == nil {
		input = &GetPipelineChangeProgressInput{}
	}

	output = &GetPipelineChangeProgressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipelineChangeProgress API operation for Amazon OpenSearch Ingestion.
//
// Returns progress information for the current change happening on an OpenSearch
// Ingestion pipeline. Currently, this operation only returns information when
// a pipeline is being created.
//
// For more information, see Tracking the status of pipeline creation (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#get-pipeline-progress).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation GetPipelineChangeProgress for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipelineChangeProgress
func (c *OSIS) GetPipelineChangeProgress(input *GetPipelineChangeProgressInput) (*GetPipelineChangeProgressOutput, error) {
	req, out := c.GetPipelineChangeProgressRequest(input)
	return out, req.Send()
}

// GetPipelineChangeProgressWithContext is the same as GetPipelineChangeProgress with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipelineChangeProgress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) GetPipelineChangeProgressWithContext(ctx aws.Context, input *GetPipelineChangeProgressInput, opts ...request.Option) (*GetPipelineChangeProgressOutput, error) {
	req, out := c.GetPipelineChangeProgressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPipelineBlueprints = "ListPipelineBlueprints"

// ListPipelineBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelineBlueprints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelineBlueprints for more information on using the ListPipelineBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPipelineBlueprintsRequest method.
//	req, resp := client.ListPipelineBlueprintsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineBlueprints
func (c *OSIS) ListPipelineBlueprintsRequest(input *ListPipelineBlueprintsInput) (req *request.Request, output *ListPipelineBlueprintsOutput) {
	op := &request.Operation{
		Name:       opListPipelineBlueprints,
		HTTPMethod: "POST",
		HTTPPath:   "/2022-01-01/osis/listPipelineBlueprints",
	}

	if input == nil {
		input = &ListPipelineBlueprintsInput{}
	}

	output = &ListPipelineBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelineBlueprints API operation for Amazon OpenSearch Ingestion.
//
// Retrieves a list of all available blueprints for Data Prepper. For more information,
// see Using blueprints to create a pipeline (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#pipeline-blueprint).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation ListPipelineBlueprints for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - InvalidPaginationTokenException
//     An invalid pagination token provided in the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineBlueprints
func (c *OSIS) ListPipelineBlueprints(input *ListPipelineBlueprintsInput) (*ListPipelineBlueprintsOutput, error) {
	req, out := c.ListPipelineBlueprintsRequest(input)
	return out, req.Send()
}

// ListPipelineBlueprintsWithContext is the same as ListPipelineBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelineBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) ListPipelineBlueprintsWithContext(ctx aws.Context, input *ListPipelineBlueprintsInput, opts ...request.Option) (*ListPipelineBlueprintsOutput, error) {
	req, out := c.ListPipelineBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelines for more information on using the ListPipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPipelinesRequest method.
//	req, resp := client.ListPipelinesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelines
func (c *OSIS) ListPipelinesRequest(input *ListPipelinesInput) (req *request.Request, output *ListPipelinesOutput) {
	op := &request.Operation{
		Name:       opListPipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/2022-01-01/osis/listPipelines",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	output = &ListPipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelines API operation for Amazon OpenSearch Ingestion.
//
// Lists all OpenSearch Ingestion pipelines in the current Amazon Web Services
// account and Region. For more information, see Viewing Amazon OpenSearch Ingestion
// pipelines (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/list-pipeline.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation ListPipelines for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - InvalidPaginationTokenException
//     An invalid pagination token provided in the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelines
func (c *OSIS) ListPipelines(input *ListPipelinesInput) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	return out, req.Send()
}

// ListPipelinesWithContext is the same as ListPipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) ListPipelinesWithContext(ctx aws.Context, input *ListPipelinesInput, opts ...request.Option) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipelinesPages iterates over the pages of a ListPipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPipelines operation.
//	pageNum := 0
//	err := client.ListPipelinesPages(params,
//	    func(page *osis.ListPipelinesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OSIS) ListPipelinesPages(input *ListPipelinesInput, fn func(*ListPipelinesOutput, bool) bool) error {
	return c.ListPipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipelinesPagesWithContext same as ListPipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) ListPipelinesPagesWithContext(ctx aws.Context, input *ListPipelinesInput, fn func(*ListPipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPipelinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListTagsForResource
func (c *OSIS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2022-01-01/osis/listTagsForResource/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon OpenSearch Ingestion.
//
// Lists all resource tags associated with an OpenSearch Ingestion pipeline.
// For more information, see Tagging Amazon OpenSearch Ingestion pipelines (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListTagsForResource
func (c *OSIS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPipeline = "StartPipeline"

// StartPipelineRequest generates a "aws/request.Request" representing the
// client's request for the StartPipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPipeline for more information on using the StartPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartPipelineRequest method.
//	req, resp := client.StartPipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/StartPipeline
func (c *OSIS) StartPipelineRequest(input *StartPipelineInput) (req *request.Request, output *StartPipelineOutput) {
	op := &request.Operation{
		Name:       opStartPipeline,
		HTTPMethod: "PUT",
		HTTPPath:   "/2022-01-01/osis/startPipeline/{PipelineName}",
	}

	if input == nil {
		input = &StartPipelineInput{}
	}

	output = &StartPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPipeline API operation for Amazon OpenSearch Ingestion.
//
// Starts an OpenSearch Ingestion pipeline. For more information, see Starting
// an OpenSearch Ingestion pipeline (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/pipeline--stop-start.html#pipeline--start).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation StartPipeline for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - ConflictException
//     The client attempted to remove a resource that is currently in use.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/StartPipeline
func (c *OSIS) StartPipeline(input *StartPipelineInput) (*StartPipelineOutput, error) {
	req, out := c.StartPipelineRequest(input)
	return out, req.Send()
}

// StartPipelineWithContext is the same as StartPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See StartPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) StartPipelineWithContext(ctx aws.Context, input *StartPipelineInput, opts ...request.Option) (*StartPipelineOutput, error) {
	req, out := c.StartPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopPipeline = "StopPipeline"

// StopPipelineRequest generates a "aws/request.Request" representing the
// client's request for the StopPipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopPipeline for more information on using the StopPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopPipelineRequest method.
//	req, resp := client.StopPipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/StopPipeline
func (c *OSIS) StopPipelineRequest(input *StopPipelineInput) (req *request.Request, output *StopPipelineOutput) {
	op := &request.Operation{
		Name:       opStopPipeline,
		HTTPMethod: "PUT",
		HTTPPath:   "/2022-01-01/osis/stopPipeline/{PipelineName}",
	}

	if input == nil {
		input = &StopPipelineInput{}
	}

	output = &StopPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopPipeline API operation for Amazon OpenSearch Ingestion.
//
// Stops an OpenSearch Ingestion pipeline. For more information, see Stopping
// an OpenSearch Ingestion pipeline (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/pipeline--stop-start.html#pipeline--stop).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation StopPipeline for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - ConflictException
//     The client attempted to remove a resource that is currently in use.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/StopPipeline
func (c *OSIS) StopPipeline(input *StopPipelineInput) (*StopPipelineOutput, error) {
	req, out := c.StopPipelineRequest(input)
	return out, req.Send()
}

// StopPipelineWithContext is the same as StopPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See StopPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) StopPipelineWithContext(ctx aws.Context, input *StopPipelineInput, opts ...request.Option) (*StopPipelineOutput, error) {
	req, out := c.StopPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/TagResource
func (c *OSIS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2022-01-01/osis/tagResource/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon OpenSearch Ingestion.
//
// Tags an OpenSearch Ingestion pipeline. For more information, see Tagging
// Amazon OpenSearch Ingestion pipelines (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You attempted to create more than the allowed number of tags.
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/TagResource
func (c *OSIS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/UntagResource
func (c *OSIS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2022-01-01/osis/untagResource/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon OpenSearch Ingestion.
//
// Removes one or more tags from an OpenSearch Ingestion pipeline. For more
// information, see Tagging Amazon OpenSearch Ingestion pipelines (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/UntagResource
func (c *OSIS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePipeline = "UpdatePipeline"

// UpdatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePipeline for more information on using the UpdatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePipelineRequest method.
//	req, resp := client.UpdatePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/UpdatePipeline
func (c *OSIS) UpdatePipelineRequest(input *UpdatePipelineInput) (req *request.Request, output *UpdatePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdatePipeline,
		HTTPMethod: "PUT",
		HTTPPath:   "/2022-01-01/osis/updatePipeline/{PipelineName}",
	}

	if input == nil {
		input = &UpdatePipelineInput{}
	}

	output = &UpdatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipeline API operation for Amazon OpenSearch Ingestion.
//
// Updates an OpenSearch Ingestion pipeline. For more information, see Updating
// Amazon OpenSearch Ingestion pipelines (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/update-pipeline.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation UpdatePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - ResourceNotFoundException
//     You attempted to access or delete a resource that does not exist.
//
//   - ConflictException
//     The client attempted to remove a resource that is currently in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/UpdatePipeline
func (c *OSIS) UpdatePipeline(input *UpdatePipelineInput) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	return out, req.Send()
}

// UpdatePipelineWithContext is the same as UpdatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) UpdatePipelineWithContext(ctx aws.Context, input *UpdatePipelineInput, opts ...request.Option) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidatePipeline = "ValidatePipeline"

// ValidatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the ValidatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidatePipeline for more information on using the ValidatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidatePipelineRequest method.
//	req, resp := client.ValidatePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ValidatePipeline
func (c *OSIS) ValidatePipelineRequest(input *ValidatePipelineInput) (req *request.Request, output *ValidatePipelineOutput) {
	op := &request.Operation{
		Name:       opValidatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/2022-01-01/osis/validatePipeline",
	}

	if input == nil {
		input = &ValidatePipelineInput{}
	}

	output = &ValidatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidatePipeline API operation for Amazon OpenSearch Ingestion.
//
// Checks whether an OpenSearch Ingestion pipeline configuration is valid prior
// to creation. For more information, see Creating Amazon OpenSearch Ingestion
// pipelines (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Ingestion's
// API operation ValidatePipeline for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permissions to access the resource.
//
//   - InternalException
//     The request failed because of an unknown error, exception, or failure (the
//     failure is internal to the service).
//
//   - ValidationException
//     An exception for missing or invalid input fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ValidatePipeline
func (c *OSIS) ValidatePipeline(input *ValidatePipelineInput) (*ValidatePipelineOutput, error) {
	req, out := c.ValidatePipelineRequest(input)
	return out, req.Send()
}

// ValidatePipelineWithContext is the same as ValidatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See ValidatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OSIS) ValidatePipelineWithContext(ctx aws.Context, input *ValidatePipelineInput, opts ...request.Option) (*ValidatePipelineOutput, error) {
	req, out := c.ValidatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permissions to access the resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Progress details for a specific stage of a pipeline configuration change.
type ChangeProgressStage struct {
	_ struct{} `type:"structure"`

	// A description of the stage.
	Description *string `type:"string"`

	// The most recent updated timestamp of the stage.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the stage.
	Name *string `type:"string"`

	// The current status of the stage that the change is in.
	Status *string `type:"string" enum:"ChangeProgressStageStatuses"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStage) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ChangeProgressStage) SetDescription(v string) *ChangeProgressStage {
	s.Description = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ChangeProgressStage) SetLastUpdatedAt(v time.Time) *ChangeProgressStage {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChangeProgressStage) SetName(v string) *ChangeProgressStage {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeProgressStage) SetStatus(v string) *ChangeProgressStage {
	s.Status = &v
	return s
}

// The progress details of a pipeline configuration change.
type ChangeProgressStatus struct {
	_ struct{} `type:"structure"`

	// Information about the stages that the pipeline is going through to perform
	// the configuration change.
	ChangeProgressStages []*ChangeProgressStage `type:"list"`

	// The time at which the configuration change is made on the pipeline.
	StartTime *time.Time `type:"timestamp"`

	// The overall status of the pipeline configuration change.
	Status *string `type:"string" enum:"ChangeProgressStatuses"`

	// The total number of stages required for the pipeline configuration change.
	TotalNumberOfStages *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStatus) GoString() string {
	return s.String()
}

// SetChangeProgressStages sets the ChangeProgressStages field's value.
func (s *ChangeProgressStatus) SetChangeProgressStages(v []*ChangeProgressStage) *ChangeProgressStatus {
	s.ChangeProgressStages = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ChangeProgressStatus) SetStartTime(v time.Time) *ChangeProgressStatus {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeProgressStatus) SetStatus(v string) *ChangeProgressStatus {
	s.Status = &v
	return s
}

// SetTotalNumberOfStages sets the TotalNumberOfStages field's value.
func (s *ChangeProgressStatus) SetTotalNumberOfStages(v int64) *ChangeProgressStatus {
	s.TotalNumberOfStages = &v
	return s
}

// The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch.
type CloudWatchLogDestination struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch Logs group to send pipeline logs to. You can specify
	// an existing log group or create a new one. For example, /aws/OpenSearchService/IngestionService/my-pipeline.
	//
	// LogGroup is a required field
	LogGroup *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogDestination"}
	if s.LogGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroup"))
	}
	if s.LogGroup != nil && len(*s.LogGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroup sets the LogGroup field's value.
func (s *CloudWatchLogDestination) SetLogGroup(v string) *CloudWatchLogDestination {
	s.LogGroup = &v
	return s
}

// The client attempted to remove a resource that is currently in use.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreatePipelineInput struct {
	_ struct{} `type:"structure"`

	// Key-value pairs to configure log publishing.
	LogPublishingOptions *LogPublishingOptions `type:"structure"`

	// The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
	//
	// MaxUnits is a required field
	MaxUnits *int64 `min:"1" type:"integer" required:"true"`

	// The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
	//
	// MinUnits is a required field
	MinUnits *int64 `min:"1" type:"integer" required:"true"`

	// The pipeline configuration in YAML format. The command accepts the pipeline
	// configuration as a string or within a .yaml file. If you provide the configuration
	// as a string, each new line must be escaped with \n.
	//
	// PipelineConfigurationBody is a required field
	PipelineConfigurationBody *string `min:"1" type:"string" required:"true"`

	// The name of the OpenSearch Ingestion pipeline to create. Pipeline names are
	// unique across the pipelines owned by an account within an Amazon Web Services
	// Region.
	//
	// PipelineName is a required field
	PipelineName *string `min:"3" type:"string" required:"true"`

	// List of tags to add to the pipeline upon creation.
	Tags []*Tag `type:"list"`

	// Container for the values required to configure VPC access for the pipeline.
	// If you don't specify these values, OpenSearch Ingestion creates the pipeline
	// with a public endpoint.
	VpcOptions *VpcOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePipelineInput"}
	if s.MaxUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxUnits"))
	}
	if s.MaxUnits != nil && *s.MaxUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxUnits", 1))
	}
	if s.MinUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("MinUnits"))
	}
	if s.MinUnits != nil && *s.MinUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinUnits", 1))
	}
	if s.PipelineConfigurationBody == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineConfigurationBody"))
	}
	if s.PipelineConfigurationBody != nil && len(*s.PipelineConfigurationBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineConfigurationBody", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 3))
	}
	if s.LogPublishingOptions != nil {
		if err := s.LogPublishingOptions.Validate(); err != nil {
			invalidParams.AddNested("LogPublishingOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcOptions != nil {
		if err := s.VpcOptions.Validate(); err != nil {
			invalidParams.AddNested("VpcOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *CreatePipelineInput) SetLogPublishingOptions(v *LogPublishingOptions) *CreatePipelineInput {
	s.LogPublishingOptions = v
	return s
}

// SetMaxUnits sets the MaxUnits field's value.
func (s *CreatePipelineInput) SetMaxUnits(v int64) *CreatePipelineInput {
	s.MaxUnits = &v
	return s
}

// SetMinUnits sets the MinUnits field's value.
func (s *CreatePipelineInput) SetMinUnits(v int64) *CreatePipelineInput {
	s.MinUnits = &v
	return s
}

// SetPipelineConfigurationBody sets the PipelineConfigurationBody field's value.
func (s *CreatePipelineInput) SetPipelineConfigurationBody(v string) *CreatePipelineInput {
	s.PipelineConfigurationBody = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *CreatePipelineInput) SetPipelineName(v string) *CreatePipelineInput {
	s.PipelineName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePipelineInput) SetTags(v []*Tag) *CreatePipelineInput {
	s.Tags = v
	return s
}

// SetVpcOptions sets the VpcOptions field's value.
func (s *CreatePipelineInput) SetVpcOptions(v *VpcOptions) *CreatePipelineInput {
	s.VpcOptions = v
	return s
}

type CreatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// Container for information about the created pipeline.
	Pipeline *Pipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *CreatePipelineOutput) SetPipeline(v *Pipeline) *CreatePipelineOutput {
	s.Pipeline = v
	return s
}

type DeletePipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipeline to delete.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"PipelineName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePipelineInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *DeletePipelineInput) SetPipelineName(v string) *DeletePipelineInput {
	s.PipelineName = &v
	return s
}

type DeletePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipelineOutput) GoString() string {
	return s.String()
}

type GetPipelineBlueprintInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the blueprint to retrieve.
	//
	// BlueprintName is a required field
	BlueprintName *string `location:"uri" locationName:"BlueprintName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineBlueprintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineBlueprintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineBlueprintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineBlueprintInput"}
	if s.BlueprintName == nil {
		invalidParams.Add(request.NewErrParamRequired("BlueprintName"))
	}
	if s.BlueprintName != nil && len(*s.BlueprintName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlueprintName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlueprintName sets the BlueprintName field's value.
func (s *GetPipelineBlueprintInput) SetBlueprintName(v string) *GetPipelineBlueprintInput {
	s.BlueprintName = &v
	return s
}

type GetPipelineBlueprintOutput struct {
	_ struct{} `type:"structure"`

	// The requested blueprint in YAML format.
	Blueprint *PipelineBlueprint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineBlueprintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineBlueprintOutput) GoString() string {
	return s.String()
}

// SetBlueprint sets the Blueprint field's value.
func (s *GetPipelineBlueprintOutput) SetBlueprint(v *PipelineBlueprint) *GetPipelineBlueprintOutput {
	s.Blueprint = v
	return s
}

type GetPipelineChangeProgressInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipeline.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"PipelineName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineChangeProgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineChangeProgressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineChangeProgressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineChangeProgressInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *GetPipelineChangeProgressInput) SetPipelineName(v string) *GetPipelineChangeProgressInput {
	s.PipelineName = &v
	return s
}

type GetPipelineChangeProgressOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the change happening on the pipeline.
	ChangeProgressStatuses []*ChangeProgressStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineChangeProgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineChangeProgressOutput) GoString() string {
	return s.String()
}

// SetChangeProgressStatuses sets the ChangeProgressStatuses field's value.
func (s *GetPipelineChangeProgressOutput) SetChangeProgressStatuses(v []*ChangeProgressStatus) *GetPipelineChangeProgressOutput {
	s.ChangeProgressStatuses = v
	return s
}

type GetPipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipeline to get information about.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"PipelineName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *GetPipelineInput) SetPipelineName(v string) *GetPipelineInput {
	s.PipelineName = &v
	return s
}

type GetPipelineOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the requested pipeline.
	Pipeline *Pipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *GetPipelineOutput) SetPipeline(v *Pipeline) *GetPipelineOutput {
	s.Pipeline = v
	return s
}

// The request failed because of an unknown error, exception, or failure (the
// failure is internal to the service).
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An invalid pagination token provided in the request.
type InvalidPaginationTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidPaginationTokenException(v protocol.ResponseMetadata) error {
	return &InvalidPaginationTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPaginationTokenException) Code() string {
	return "InvalidPaginationTokenException"
}

// Message returns the exception's message.
func (s *InvalidPaginationTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPaginationTokenException) OrigErr() error {
	return nil
}

func (s *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPaginationTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPaginationTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You attempted to create more than the allowed number of tags.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListPipelineBlueprintsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelineBlueprintsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelineBlueprintsInput) GoString() string {
	return s.String()
}

type ListPipelineBlueprintsOutput struct {
	_ struct{} `type:"structure"`

	// A list of available blueprints for Data Prepper.
	Blueprints []*PipelineBlueprintSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelineBlueprintsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelineBlueprintsOutput) GoString() string {
	return s.String()
}

// SetBlueprints sets the Blueprints field's value.
func (s *ListPipelineBlueprintsOutput) SetBlueprints(v []*PipelineBlueprintSummary) *ListPipelineBlueprintsOutput {
	s.Blueprints = v
	return s
}

type ListPipelinesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListPipelines operation returns a nextToken, you can include
	// the returned nextToken in subsequent ListPipelines operations, which returns
	// results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPipelinesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPipelinesInput) SetMaxResults(v int64) *ListPipelinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelinesInput) SetNextToken(v string) *ListPipelinesInput {
	s.NextToken = &v
	return s
}

type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`

	// A list of all existing Data Prepper pipelines.
	Pipelines []*PipelineSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelinesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelinesOutput) SetNextToken(v string) *ListPipelinesOutput {
	s.NextToken = &v
	return s
}

// SetPipelines sets the Pipelines field's value.
func (s *ListPipelinesOutput) SetPipelines(v []*PipelineSummary) *ListPipelinesOutput {
	s.Pipelines = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the pipeline to retrieve tags for.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"arn" min:"46" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 46 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 46))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceInput) SetArn(v string) *ListTagsForResourceInput {
	s.Arn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the given pipeline.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Container for the values required to configure logging for the pipeline.
// If you don't specify these values, OpenSearch Ingestion will not publish
// logs from your application to CloudWatch Logs.
type LogPublishingOptions struct {
	_ struct{} `type:"structure"`

	// The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs.
	// This parameter is required if IsLoggingEnabled is set to true.
	CloudWatchLogDestination *CloudWatchLogDestination `type:"structure"`

	// Whether logs should be published.
	IsLoggingEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogPublishingOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogPublishingOptions"}
	if s.CloudWatchLogDestination != nil {
		if err := s.CloudWatchLogDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogDestination sets the CloudWatchLogDestination field's value.
func (s *LogPublishingOptions) SetCloudWatchLogDestination(v *CloudWatchLogDestination) *LogPublishingOptions {
	s.CloudWatchLogDestination = v
	return s
}

// SetIsLoggingEnabled sets the IsLoggingEnabled field's value.
func (s *LogPublishingOptions) SetIsLoggingEnabled(v bool) *LogPublishingOptions {
	s.IsLoggingEnabled = &v
	return s
}

// Information about an existing OpenSearch Ingestion pipeline.
type Pipeline struct {
	_ struct{} `type:"structure"`

	// The date and time when the pipeline was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The ingestion endpoints for the pipeline, which you can send data to.
	IngestEndpointUrls []*string `type:"list"`

	// The date and time when the pipeline was last updated.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// Key-value pairs that represent log publishing settings.
	LogPublishingOptions *LogPublishingOptions `type:"structure"`

	// The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
	MaxUnits *int64 `type:"integer"`

	// The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
	MinUnits *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string `type:"string"`

	// The Data Prepper pipeline configuration in YAML format.
	PipelineConfigurationBody *string `type:"string"`

	// The name of the pipeline.
	PipelineName *string `type:"string"`

	// The current status of the pipeline.
	Status *string `type:"string" enum:"PipelineStatus"`

	// The reason for the current status of the pipeline.
	StatusReason *PipelineStatusReason `type:"structure"`

	// The VPC interface endpoints that have access to the pipeline.
	VpcEndpoints []*VpcEndpoint `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Pipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Pipeline) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Pipeline) SetCreatedAt(v time.Time) *Pipeline {
	s.CreatedAt = &v
	return s
}

// SetIngestEndpointUrls sets the IngestEndpointUrls field's value.
func (s *Pipeline) SetIngestEndpointUrls(v []*string) *Pipeline {
	s.IngestEndpointUrls = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *Pipeline) SetLastUpdatedAt(v time.Time) *Pipeline {
	s.LastUpdatedAt = &v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *Pipeline) SetLogPublishingOptions(v *LogPublishingOptions) *Pipeline {
	s.LogPublishingOptions = v
	return s
}

// SetMaxUnits sets the MaxUnits field's value.
func (s *Pipeline) SetMaxUnits(v int64) *Pipeline {
	s.MaxUnits = &v
	return s
}

// SetMinUnits sets the MinUnits field's value.
func (s *Pipeline) SetMinUnits(v int64) *Pipeline {
	s.MinUnits = &v
	return s
}

// SetPipelineArn sets the PipelineArn field's value.
func (s *Pipeline) SetPipelineArn(v string) *Pipeline {
	s.PipelineArn = &v
	return s
}

// SetPipelineConfigurationBody sets the PipelineConfigurationBody field's value.
func (s *Pipeline) SetPipelineConfigurationBody(v string) *Pipeline {
	s.PipelineConfigurationBody = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *Pipeline) SetPipelineName(v string) *Pipeline {
	s.PipelineName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Pipeline) SetStatus(v string) *Pipeline {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *Pipeline) SetStatusReason(v *PipelineStatusReason) *Pipeline {
	s.StatusReason = v
	return s
}

// SetVpcEndpoints sets the VpcEndpoints field's value.
func (s *Pipeline) SetVpcEndpoints(v []*VpcEndpoint) *Pipeline {
	s.VpcEndpoints = v
	return s
}

// Container for information about an OpenSearch Ingestion blueprint.
type PipelineBlueprint struct {
	_ struct{} `type:"structure"`

	// The name of the blueprint.
	BlueprintName *string `type:"string"`

	// The YAML configuration of the blueprint.
	PipelineConfigurationBody *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineBlueprint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineBlueprint) GoString() string {
	return s.String()
}

// SetBlueprintName sets the BlueprintName field's value.
func (s *PipelineBlueprint) SetBlueprintName(v string) *PipelineBlueprint {
	s.BlueprintName = &v
	return s
}

// SetPipelineConfigurationBody sets the PipelineConfigurationBody field's value.
func (s *PipelineBlueprint) SetPipelineConfigurationBody(v string) *PipelineBlueprint {
	s.PipelineConfigurationBody = &v
	return s
}

// A summary of an OpenSearch Ingestion blueprint.
type PipelineBlueprintSummary struct {
	_ struct{} `type:"structure"`

	// The name of the blueprint.
	BlueprintName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineBlueprintSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineBlueprintSummary) GoString() string {
	return s.String()
}

// SetBlueprintName sets the BlueprintName field's value.
func (s *PipelineBlueprintSummary) SetBlueprintName(v string) *PipelineBlueprintSummary {
	s.BlueprintName = &v
	return s
}

// Information about a pipeline's current status.
type PipelineStatusReason struct {
	_ struct{} `type:"structure"`

	// A description of why a pipeline has a certain status.
	Description *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineStatusReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineStatusReason) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *PipelineStatusReason) SetDescription(v string) *PipelineStatusReason {
	s.Description = &v
	return s
}

// Summary information for an OpenSearch Ingestion pipeline.
type PipelineSummary struct {
	_ struct{} `type:"structure"`

	// The date and time when the pipeline was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The date and time when the pipeline was last updated.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
	MaxUnits *int64 `min:"1" type:"integer"`

	// The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
	MinUnits *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string `min:"46" type:"string"`

	// The name of the pipeline.
	PipelineName *string `min:"3" type:"string"`

	// The current status of the pipeline.
	Status *string `type:"string" enum:"PipelineStatus"`

	// Information about a pipeline's current status.
	StatusReason *PipelineStatusReason `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PipelineSummary) SetCreatedAt(v time.Time) *PipelineSummary {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *PipelineSummary) SetLastUpdatedAt(v time.Time) *PipelineSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetMaxUnits sets the MaxUnits field's value.
func (s *PipelineSummary) SetMaxUnits(v int64) *PipelineSummary {
	s.MaxUnits = &v
	return s
}

// SetMinUnits sets the MinUnits field's value.
func (s *PipelineSummary) SetMinUnits(v int64) *PipelineSummary {
	s.MinUnits = &v
	return s
}

// SetPipelineArn sets the PipelineArn field's value.
func (s *PipelineSummary) SetPipelineArn(v string) *PipelineSummary {
	s.PipelineArn = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PipelineSummary) SetPipelineName(v string) *PipelineSummary {
	s.PipelineName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PipelineSummary) SetStatus(v string) *PipelineSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *PipelineSummary) SetStatusReason(v *PipelineStatusReason) *PipelineSummary {
	s.StatusReason = v
	return s
}

// You attempted to create a resource that already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You attempted to access or delete a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartPipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipeline to start.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"PipelineName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPipelineInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *StartPipelineInput) SetPipelineName(v string) *StartPipelineInput {
	s.PipelineName = &v
	return s
}

type StartPipelineOutput struct {
	_ struct{} `type:"structure"`

	// Information about an existing OpenSearch Ingestion pipeline.
	Pipeline *Pipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *StartPipelineOutput) SetPipeline(v *Pipeline) *StartPipelineOutput {
	s.Pipeline = v
	return s
}

type StopPipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipeline to stop.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"PipelineName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopPipelineInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *StopPipelineInput) SetPipelineName(v string) *StopPipelineInput {
	s.PipelineName = &v
	return s
}

type StopPipelineOutput struct {
	_ struct{} `type:"structure"`

	// Information about an existing OpenSearch Ingestion pipeline.
	Pipeline *Pipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *StopPipelineOutput) SetPipeline(v *Pipeline) *StopPipelineOutput {
	s.Pipeline = v
	return s
}

// A tag (key-value pair) for an OpenSearch Ingestion pipeline.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key. Tag keys must be unique for the pipeline to which they are attached.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value assigned to the corresponding tag key. Tag values can be null and
	// don't have to be unique in a tag set. For example, you can have a key value
	// pair in a tag set of project : Trinity and cost-center : Trinity
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the pipeline to tag.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"arn" min:"46" type:"string" required:"true"`

	// The list of key-value tags to add to the pipeline.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 46 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 46))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the pipeline to remove tags from.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"arn" min:"46" type:"string" required:"true"`

	// The tag keys to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 46 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 46))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdatePipelineInput struct {
	_ struct{} `type:"structure"`

	// Key-value pairs to configure log publishing.
	LogPublishingOptions *LogPublishingOptions `type:"structure"`

	// The maximum pipeline capacity, in Ingestion Compute Units (ICUs)
	MaxUnits *int64 `min:"1" type:"integer"`

	// The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
	MinUnits *int64 `min:"1" type:"integer"`

	// The pipeline configuration in YAML format. The command accepts the pipeline
	// configuration as a string or within a .yaml file. If you provide the configuration
	// as a string, each new line must be escaped with \n.
	PipelineConfigurationBody *string `min:"1" type:"string"`

	// The name of the pipeline to update.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"PipelineName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipelineInput"}
	if s.MaxUnits != nil && *s.MaxUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxUnits", 1))
	}
	if s.MinUnits != nil && *s.MinUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinUnits", 1))
	}
	if s.PipelineConfigurationBody != nil && len(*s.PipelineConfigurationBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineConfigurationBody", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 3))
	}
	if s.LogPublishingOptions != nil {
		if err := s.LogPublishingOptions.Validate(); err != nil {
			invalidParams.AddNested("LogPublishingOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *UpdatePipelineInput) SetLogPublishingOptions(v *LogPublishingOptions) *UpdatePipelineInput {
	s.LogPublishingOptions = v
	return s
}

// SetMaxUnits sets the MaxUnits field's value.
func (s *UpdatePipelineInput) SetMaxUnits(v int64) *UpdatePipelineInput {
	s.MaxUnits = &v
	return s
}

// SetMinUnits sets the MinUnits field's value.
func (s *UpdatePipelineInput) SetMinUnits(v int64) *UpdatePipelineInput {
	s.MinUnits = &v
	return s
}

// SetPipelineConfigurationBody sets the PipelineConfigurationBody field's value.
func (s *UpdatePipelineInput) SetPipelineConfigurationBody(v string) *UpdatePipelineInput {
	s.PipelineConfigurationBody = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *UpdatePipelineInput) SetPipelineName(v string) *UpdatePipelineInput {
	s.PipelineName = &v
	return s
}

type UpdatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// Container for information about the updated pipeline.
	Pipeline *Pipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdatePipelineOutput) SetPipeline(v *Pipeline) *UpdatePipelineOutput {
	s.Pipeline = v
	return s
}

type ValidatePipelineInput struct {
	_ struct{} `type:"structure"`

	// The pipeline configuration in YAML format. The command accepts the pipeline
	// configuration as a string or within a .yaml file. If you provide the configuration
	// as a string, each new line must be escaped with \n.
	//
	// PipelineConfigurationBody is a required field
	PipelineConfigurationBody *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidatePipelineInput"}
	if s.PipelineConfigurationBody == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineConfigurationBody"))
	}
	if s.PipelineConfigurationBody != nil && len(*s.PipelineConfigurationBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineConfigurationBody", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineConfigurationBody sets the PipelineConfigurationBody field's value.
func (s *ValidatePipelineInput) SetPipelineConfigurationBody(v string) *ValidatePipelineInput {
	s.PipelineConfigurationBody = &v
	return s
}

type ValidatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors if the configuration is invalid.
	Errors []*ValidationMessage `type:"list"`

	// A boolean indicating whether or not the pipeline configuration is valid.
	IsValid *bool `locationName:"isValid" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatePipelineOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *ValidatePipelineOutput) SetErrors(v []*ValidationMessage) *ValidatePipelineOutput {
	s.Errors = v
	return s
}

// SetIsValid sets the IsValid field's value.
func (s *ValidatePipelineOutput) SetIsValid(v bool) *ValidatePipelineOutput {
	s.IsValid = &v
	return s
}

// An exception for missing or invalid input fields.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A validation message associated with a ValidatePipeline request in OpenSearch
// Ingestion.
type ValidationMessage struct {
	_ struct{} `type:"structure"`

	// The validation message.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationMessage) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationMessage) SetMessage(v string) *ValidationMessage {
	s.Message = &v
	return s
}

// An OpenSearch Ingestion-managed VPC endpoint that will access one or more
// pipelines.
type VpcEndpoint struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the endpoint.
	VpcEndpointId *string `type:"string"`

	// The ID for your VPC. Amazon Web Services PrivateLink generates this value
	// when you create a VPC.
	VpcId *string `type:"string"`

	// Information about the VPC, including associated subnets and security groups.
	VpcOptions *VpcOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpoint) GoString() string {
	return s.String()
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *VpcEndpoint) SetVpcEndpointId(v string) *VpcEndpoint {
	s.VpcEndpointId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcEndpoint) SetVpcId(v string) *VpcEndpoint {
	s.VpcId = &v
	return s
}

// SetVpcOptions sets the VpcOptions field's value.
func (s *VpcEndpoint) SetVpcOptions(v *VpcOptions) *VpcEndpoint {
	s.VpcOptions = v
	return s
}

// Options that specify the subnets and security groups for an OpenSearch Ingestion
// VPC endpoint.
type VpcOptions struct {
	_ struct{} `type:"structure"`

	// A list of security groups associated with the VPC endpoint.
	SecurityGroupIds []*string `min:"1" type:"list"`

	// A list of subnet IDs associated with the VPC endpoint.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcOptions"}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcOptions) SetSecurityGroupIds(v []*string) *VpcOptions {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcOptions) SetSubnetIds(v []*string) *VpcOptions {
	s.SubnetIds = v
	return s
}

const (
	// ChangeProgressStageStatusesPending is a ChangeProgressStageStatuses enum value
	ChangeProgressStageStatusesPending = "PENDING"

	// ChangeProgressStageStatusesInProgress is a ChangeProgressStageStatuses enum value
	ChangeProgressStageStatusesInProgress = "IN_PROGRESS"

	// ChangeProgressStageStatusesCompleted is a ChangeProgressStageStatuses enum value
	ChangeProgressStageStatusesCompleted = "COMPLETED"

	// ChangeProgressStageStatusesFailed is a ChangeProgressStageStatuses enum value
	ChangeProgressStageStatusesFailed = "FAILED"
)

// ChangeProgressStageStatuses_Values returns all elements of the ChangeProgressStageStatuses enum
func ChangeProgressStageStatuses_Values() []string {
	return []string{
		ChangeProgressStageStatusesPending,
		ChangeProgressStageStatusesInProgress,
		ChangeProgressStageStatusesCompleted,
		ChangeProgressStageStatusesFailed,
	}
}

const (
	// ChangeProgressStatusesPending is a ChangeProgressStatuses enum value
	ChangeProgressStatusesPending = "PENDING"

	// ChangeProgressStatusesInProgress is a ChangeProgressStatuses enum value
	ChangeProgressStatusesInProgress = "IN_PROGRESS"

	// ChangeProgressStatusesCompleted is a ChangeProgressStatuses enum value
	ChangeProgressStatusesCompleted = "COMPLETED"

	// ChangeProgressStatusesFailed is a ChangeProgressStatuses enum value
	ChangeProgressStatusesFailed = "FAILED"
)

// ChangeProgressStatuses_Values returns all elements of the ChangeProgressStatuses enum
func ChangeProgressStatuses_Values() []string {
	return []string{
		ChangeProgressStatusesPending,
		ChangeProgressStatusesInProgress,
		ChangeProgressStatusesCompleted,
		ChangeProgressStatusesFailed,
	}
}

const (
	// PipelineStatusCreating is a PipelineStatus enum value
	PipelineStatusCreating = "CREATING"

	// PipelineStatusActive is a PipelineStatus enum value
	PipelineStatusActive = "ACTIVE"

	// PipelineStatusUpdating is a PipelineStatus enum value
	PipelineStatusUpdating = "UPDATING"

	// PipelineStatusDeleting is a PipelineStatus enum value
	PipelineStatusDeleting = "DELETING"

	// PipelineStatusCreateFailed is a PipelineStatus enum value
	PipelineStatusCreateFailed = "CREATE_FAILED"

	// PipelineStatusUpdateFailed is a PipelineStatus enum value
	PipelineStatusUpdateFailed = "UPDATE_FAILED"

	// PipelineStatusStarting is a PipelineStatus enum value
	PipelineStatusStarting = "STARTING"

	// PipelineStatusStartFailed is a PipelineStatus enum value
	PipelineStatusStartFailed = "START_FAILED"

	// PipelineStatusStopping is a PipelineStatus enum value
	PipelineStatusStopping = "STOPPING"

	// PipelineStatusStopped is a PipelineStatus enum value
	PipelineStatusStopped = "STOPPED"
)

// PipelineStatus_Values returns all elements of the PipelineStatus enum
func PipelineStatus_Values() []string {
	return []string{
		PipelineStatusCreating,
		PipelineStatusActive,
		PipelineStatusUpdating,
		PipelineStatusDeleting,
		PipelineStatusCreateFailed,
		PipelineStatusUpdateFailed,
		PipelineStatusStarting,
		PipelineStatusStartFailed,
		PipelineStatusStopping,
		PipelineStatusStopped,
	}
}
