// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/intent.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents the options for views of an intent.
// An intent can be a sizable object. Therefore, we provide a resource view that
// does not return training phrases in the response by default.
type IntentView int32

const (
	// Training phrases field is not populated in the response.
	IntentView_INTENT_VIEW_UNSPECIFIED IntentView = 0
	// All fields are populated.
	IntentView_INTENT_VIEW_FULL IntentView = 1
)

var IntentView_name = map[int32]string{
	0: "INTENT_VIEW_UNSPECIFIED",
	1: "INTENT_VIEW_FULL",
}

var IntentView_value = map[string]int32{
	"INTENT_VIEW_UNSPECIFIED": 0,
	"INTENT_VIEW_FULL":        1,
}

func (x IntentView) String() string {
	return proto.EnumName(IntentView_name, int32(x))
}

func (IntentView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0}
}

// Represents the different states that webhooks can be in.
type Intent_WebhookState int32

const (
	// Webhook is disabled in the agent and in the intent.
	Intent_WEBHOOK_STATE_UNSPECIFIED Intent_WebhookState = 0
	// Webhook is enabled in the agent and in the intent.
	Intent_WEBHOOK_STATE_ENABLED Intent_WebhookState = 1
	// Webhook is enabled in the agent and in the intent. Also, each slot
	// filling prompt is forwarded to the webhook.
	Intent_WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING Intent_WebhookState = 2
)

var Intent_WebhookState_name = map[int32]string{
	0: "WEBHOOK_STATE_UNSPECIFIED",
	1: "WEBHOOK_STATE_ENABLED",
	2: "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING",
}

var Intent_WebhookState_value = map[string]int32{
	"WEBHOOK_STATE_UNSPECIFIED":              0,
	"WEBHOOK_STATE_ENABLED":                  1,
	"WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING": 2,
}

func (x Intent_WebhookState) String() string {
	return proto.EnumName(Intent_WebhookState_name, int32(x))
}

func (Intent_WebhookState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 0}
}

// Represents different types of training phrases.
type Intent_TrainingPhrase_Type int32

const (
	// Not specified. This value should never be used.
	Intent_TrainingPhrase_TYPE_UNSPECIFIED Intent_TrainingPhrase_Type = 0
	// Examples do not contain @-prefixed entity type names, but example parts
	// can be annotated with entity types.
	Intent_TrainingPhrase_EXAMPLE Intent_TrainingPhrase_Type = 1
	// Templates are not annotated with entity types, but they can contain
	// @-prefixed entity type names as substrings.
	// Template mode has been deprecated. Example mode is the only supported
	// way to create new training phrases. If you have existing training
	// phrases that you've created in template mode, those will continue to
	// work.
	Intent_TrainingPhrase_TEMPLATE Intent_TrainingPhrase_Type = 2 // Deprecated: Do not use.
)

var Intent_TrainingPhrase_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "EXAMPLE",
	2: "TEMPLATE",
}

var Intent_TrainingPhrase_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"EXAMPLE":          1,
	"TEMPLATE":         2,
}

func (x Intent_TrainingPhrase_Type) String() string {
	return proto.EnumName(Intent_TrainingPhrase_Type_name, int32(x))
}

func (Intent_TrainingPhrase_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 0, 0}
}

// Represents different platforms that a rich message can be intended for.
type Intent_Message_Platform int32

const (
	// Not specified.
	Intent_Message_PLATFORM_UNSPECIFIED Intent_Message_Platform = 0
	// Facebook.
	Intent_Message_FACEBOOK Intent_Message_Platform = 1
	// Slack.
	Intent_Message_SLACK Intent_Message_Platform = 2
	// Telegram.
	Intent_Message_TELEGRAM Intent_Message_Platform = 3
	// Kik.
	Intent_Message_KIK Intent_Message_Platform = 4
	// Skype.
	Intent_Message_SKYPE Intent_Message_Platform = 5
	// Line.
	Intent_Message_LINE Intent_Message_Platform = 6
	// Viber.
	Intent_Message_VIBER Intent_Message_Platform = 7
	// Actions on Google.
	// When using Actions on Google, you can choose one of the specific
	// Intent.Message types that mention support for Actions on Google,
	// or you can use the advanced Intent.Message.payload field.
	// The payload field provides access to AoG features not available in the
	// specific message types.
	// If using the Intent.Message.payload field, it should have a structure
	// similar to the JSON message shown here. For more information, see
	// [Actions on Google Webhook
	// Format](https://developers.google.com/actions/dialogflow/webhook)
	// <pre>{
	//   "expectUserResponse": true,
	//   "isSsml": false,
	//   "noInputPrompts": [],
	//   "richResponse": {
	//     "items": [
	//       {
	//         "simpleResponse": {
	//           "displayText": "hi",
	//           "textToSpeech": "hello"
	//         }
	//       }
	//     ],
	//     "suggestions": [
	//       {
	//         "title": "Say this"
	//       },
	//       {
	//         "title": "or this"
	//       }
	//     ]
	//   },
	//   "systemIntent": {
	//     "data": {
	//       "@type": "type.googleapis.com/google.actions.v2.OptionValueSpec",
	//       "listSelect": {
	//         "items": [
	//           {
	//             "optionInfo": {
	//               "key": "key1",
	//               "synonyms": [
	//                 "key one"
	//               ]
	//             },
	//             "title": "must not be empty, but unique"
	//           },
	//           {
	//             "optionInfo": {
	//               "key": "key2",
	//               "synonyms": [
	//                 "key two"
	//               ]
	//             },
	//             "title": "must not be empty, but unique"
	//           }
	//         ]
	//       }
	//     },
	//     "intent": "actions.intent.OPTION"
	//   }
	// }</pre>
	Intent_Message_ACTIONS_ON_GOOGLE Intent_Message_Platform = 8
	// Telephony Gateway.
	Intent_Message_TELEPHONY Intent_Message_Platform = 10
	// Google Hangouts.
	Intent_Message_GOOGLE_HANGOUTS Intent_Message_Platform = 11
)

var Intent_Message_Platform_name = map[int32]string{
	0:  "PLATFORM_UNSPECIFIED",
	1:  "FACEBOOK",
	2:  "SLACK",
	3:  "TELEGRAM",
	4:  "KIK",
	5:  "SKYPE",
	6:  "LINE",
	7:  "VIBER",
	8:  "ACTIONS_ON_GOOGLE",
	10: "TELEPHONY",
	11: "GOOGLE_HANGOUTS",
}

var Intent_Message_Platform_value = map[string]int32{
	"PLATFORM_UNSPECIFIED": 0,
	"FACEBOOK":             1,
	"SLACK":                2,
	"TELEGRAM":             3,
	"KIK":                  4,
	"SKYPE":                5,
	"LINE":                 6,
	"VIBER":                7,
	"ACTIONS_ON_GOOGLE":    8,
	"TELEPHONY":            10,
	"GOOGLE_HANGOUTS":      11,
}

func (x Intent_Message_Platform) String() string {
	return proto.EnumName(Intent_Message_Platform_name, int32(x))
}

func (Intent_Message_Platform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 0}
}

// The width of the cards in the carousel.
type Intent_Message_RbmCarouselCard_CardWidth int32

const (
	// Not specified.
	Intent_Message_RbmCarouselCard_CARD_WIDTH_UNSPECIFIED Intent_Message_RbmCarouselCard_CardWidth = 0
	// 120 DP. Note that tall media cannot be used.
	Intent_Message_RbmCarouselCard_SMALL Intent_Message_RbmCarouselCard_CardWidth = 1
	// 232 DP.
	Intent_Message_RbmCarouselCard_MEDIUM Intent_Message_RbmCarouselCard_CardWidth = 2
)

var Intent_Message_RbmCarouselCard_CardWidth_name = map[int32]string{
	0: "CARD_WIDTH_UNSPECIFIED",
	1: "SMALL",
	2: "MEDIUM",
}

var Intent_Message_RbmCarouselCard_CardWidth_value = map[string]int32{
	"CARD_WIDTH_UNSPECIFIED": 0,
	"SMALL":                  1,
	"MEDIUM":                 2,
}

func (x Intent_Message_RbmCarouselCard_CardWidth) String() string {
	return proto.EnumName(Intent_Message_RbmCarouselCard_CardWidth_name, int32(x))
}

func (Intent_Message_RbmCarouselCard_CardWidth) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 17, 0}
}

// Orientation of the card.
type Intent_Message_RbmStandaloneCard_CardOrientation int32

const (
	// Not specified.
	Intent_Message_RbmStandaloneCard_CARD_ORIENTATION_UNSPECIFIED Intent_Message_RbmStandaloneCard_CardOrientation = 0
	// Horizontal layout.
	Intent_Message_RbmStandaloneCard_HORIZONTAL Intent_Message_RbmStandaloneCard_CardOrientation = 1
	// Vertical layout.
	Intent_Message_RbmStandaloneCard_VERTICAL Intent_Message_RbmStandaloneCard_CardOrientation = 2
)

var Intent_Message_RbmStandaloneCard_CardOrientation_name = map[int32]string{
	0: "CARD_ORIENTATION_UNSPECIFIED",
	1: "HORIZONTAL",
	2: "VERTICAL",
}

var Intent_Message_RbmStandaloneCard_CardOrientation_value = map[string]int32{
	"CARD_ORIENTATION_UNSPECIFIED": 0,
	"HORIZONTAL":                   1,
	"VERTICAL":                     2,
}

func (x Intent_Message_RbmStandaloneCard_CardOrientation) String() string {
	return proto.EnumName(Intent_Message_RbmStandaloneCard_CardOrientation_name, int32(x))
}

func (Intent_Message_RbmStandaloneCard_CardOrientation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 18, 0}
}

// Thumbnail preview alignment for standalone cards with horizontal
// layout.
type Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment int32

const (
	// Not specified.
	Intent_Message_RbmStandaloneCard_THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment = 0
	// Thumbnail preview is left-aligned.
	Intent_Message_RbmStandaloneCard_LEFT Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment = 1
	// Thumbnail preview is right-aligned.
	Intent_Message_RbmStandaloneCard_RIGHT Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment = 2
)

var Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_name = map[int32]string{
	0: "THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED",
	1: "LEFT",
	2: "RIGHT",
}

var Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_value = map[string]int32{
	"THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED": 0,
	"LEFT":                                  1,
	"RIGHT":                                 2,
}

func (x Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment) String() string {
	return proto.EnumName(Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_name, int32(x))
}

func (Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 18, 1}
}

// Media height
type Intent_Message_RbmCardContent_RbmMedia_Height int32

const (
	// Not specified.
	Intent_Message_RbmCardContent_RbmMedia_HEIGHT_UNSPECIFIED Intent_Message_RbmCardContent_RbmMedia_Height = 0
	// 112 DP.
	Intent_Message_RbmCardContent_RbmMedia_SHORT Intent_Message_RbmCardContent_RbmMedia_Height = 1
	// 168 DP.
	Intent_Message_RbmCardContent_RbmMedia_MEDIUM Intent_Message_RbmCardContent_RbmMedia_Height = 2
	// 264 DP. Not available for rich card carousels when the card width
	// is set to small.
	Intent_Message_RbmCardContent_RbmMedia_TALL Intent_Message_RbmCardContent_RbmMedia_Height = 3
)

var Intent_Message_RbmCardContent_RbmMedia_Height_name = map[int32]string{
	0: "HEIGHT_UNSPECIFIED",
	1: "SHORT",
	2: "MEDIUM",
	3: "TALL",
}

var Intent_Message_RbmCardContent_RbmMedia_Height_value = map[string]int32{
	"HEIGHT_UNSPECIFIED": 0,
	"SHORT":              1,
	"MEDIUM":             2,
	"TALL":               3,
}

func (x Intent_Message_RbmCardContent_RbmMedia_Height) String() string {
	return proto.EnumName(Intent_Message_RbmCardContent_RbmMedia_Height_name, int32(x))
}

func (Intent_Message_RbmCardContent_RbmMedia_Height) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 19, 0, 0}
}

// Format of response media type.
type Intent_Message_MediaContent_ResponseMediaType int32

const (
	// Unspecified.
	Intent_Message_MediaContent_RESPONSE_MEDIA_TYPE_UNSPECIFIED Intent_Message_MediaContent_ResponseMediaType = 0
	// Response media type is audio.
	Intent_Message_MediaContent_AUDIO Intent_Message_MediaContent_ResponseMediaType = 1
)

var Intent_Message_MediaContent_ResponseMediaType_name = map[int32]string{
	0: "RESPONSE_MEDIA_TYPE_UNSPECIFIED",
	1: "AUDIO",
}

var Intent_Message_MediaContent_ResponseMediaType_value = map[string]int32{
	"RESPONSE_MEDIA_TYPE_UNSPECIFIED": 0,
	"AUDIO":                           1,
}

func (x Intent_Message_MediaContent_ResponseMediaType) String() string {
	return proto.EnumName(Intent_Message_MediaContent_ResponseMediaType_name, int32(x))
}

func (Intent_Message_MediaContent_ResponseMediaType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 23, 0}
}

// Image display options for Actions on Google. This should be used for
// when the image's aspect ratio does not match the image container's
// aspect ratio.
type Intent_Message_BrowseCarouselCard_ImageDisplayOptions int32

const (
	// Fill the gaps between the image and the image container with gray
	// bars.
	Intent_Message_BrowseCarouselCard_IMAGE_DISPLAY_OPTIONS_UNSPECIFIED Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 0
	// Fill the gaps between the image and the image container with gray
	// bars.
	Intent_Message_BrowseCarouselCard_GRAY Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 1
	// Fill the gaps between the image and the image container with white
	// bars.
	Intent_Message_BrowseCarouselCard_WHITE Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 2
	// Image is scaled such that the image width and height match or exceed
	// the container dimensions. This may crop the top and bottom of the
	// image if the scaled image height is greater than the container
	// height, or crop the left and right of the image if the scaled image
	// width is greater than the container width. This is similar to "Zoom
	// Mode" on a widescreen TV when playing a 4:3 video.
	Intent_Message_BrowseCarouselCard_CROPPED Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 3
	// Pad the gaps between image and image frame with a blurred copy of the
	// same image.
	Intent_Message_BrowseCarouselCard_BLURRED_BACKGROUND Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 4
)

var Intent_Message_BrowseCarouselCard_ImageDisplayOptions_name = map[int32]string{
	0: "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED",
	1: "GRAY",
	2: "WHITE",
	3: "CROPPED",
	4: "BLURRED_BACKGROUND",
}

var Intent_Message_BrowseCarouselCard_ImageDisplayOptions_value = map[string]int32{
	"IMAGE_DISPLAY_OPTIONS_UNSPECIFIED": 0,
	"GRAY":                              1,
	"WHITE":                             2,
	"CROPPED":                           3,
	"BLURRED_BACKGROUND":                4,
}

func (x Intent_Message_BrowseCarouselCard_ImageDisplayOptions) String() string {
	return proto.EnumName(Intent_Message_BrowseCarouselCard_ImageDisplayOptions_name, int32(x))
}

func (Intent_Message_BrowseCarouselCard_ImageDisplayOptions) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 24, 0}
}

// Type of the URI.
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint int32

const (
	// Unspecified
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_URL_TYPE_HINT_UNSPECIFIED Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint = 0
	// Url would be an amp action
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_AMP_ACTION Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint = 1
	// URL that points directly to AMP content, or to a canonical URL
	// which refers to AMP content via <link rel="amphtml">.
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_AMP_CONTENT Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint = 2
)

var Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_name = map[int32]string{
	0: "URL_TYPE_HINT_UNSPECIFIED",
	1: "AMP_ACTION",
	2: "AMP_CONTENT",
}

var Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_value = map[string]int32{
	"URL_TYPE_HINT_UNSPECIFIED": 0,
	"AMP_ACTION":                1,
	"AMP_CONTENT":               2,
}

func (x Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint) String() string {
	return proto.EnumName(Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_name, int32(x))
}

func (Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 24, 0, 0, 0}
}

// Text alignments within a cell.
type Intent_Message_ColumnProperties_HorizontalAlignment int32

const (
	// Text is aligned to the leading edge of the column.
	Intent_Message_ColumnProperties_HORIZONTAL_ALIGNMENT_UNSPECIFIED Intent_Message_ColumnProperties_HorizontalAlignment = 0
	// Text is aligned to the leading edge of the column.
	Intent_Message_ColumnProperties_LEADING Intent_Message_ColumnProperties_HorizontalAlignment = 1
	// Text is centered in the column.
	Intent_Message_ColumnProperties_CENTER Intent_Message_ColumnProperties_HorizontalAlignment = 2
	// Text is aligned to the trailing edge of the column.
	Intent_Message_ColumnProperties_TRAILING Intent_Message_ColumnProperties_HorizontalAlignment = 3
)

var Intent_Message_ColumnProperties_HorizontalAlignment_name = map[int32]string{
	0: "HORIZONTAL_ALIGNMENT_UNSPECIFIED",
	1: "LEADING",
	2: "CENTER",
	3: "TRAILING",
}

var Intent_Message_ColumnProperties_HorizontalAlignment_value = map[string]int32{
	"HORIZONTAL_ALIGNMENT_UNSPECIFIED": 0,
	"LEADING":                          1,
	"CENTER":                           2,
	"TRAILING":                         3,
}

func (x Intent_Message_ColumnProperties_HorizontalAlignment) String() string {
	return proto.EnumName(Intent_Message_ColumnProperties_HorizontalAlignment_name, int32(x))
}

func (Intent_Message_ColumnProperties_HorizontalAlignment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 26, 0}
}

// Represents an intent.
// Intents convert a number of user expressions or patterns into an action. An
// action is an extraction of a user command or sentence semantics.
type Intent struct {
	// The unique identifier of this intent.
	// Required for [Intents.UpdateIntent][google.cloud.dialogflow.v2beta1.Intents.UpdateIntent] and [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents]
	// methods.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of this intent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Indicates whether webhooks are enabled for the intent.
	WebhookState Intent_WebhookState `protobuf:"varint,6,opt,name=webhook_state,json=webhookState,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_WebhookState" json:"webhook_state,omitempty"`
	// The priority of this intent. Higher numbers represent higher
	// priorities.
	//
	// - If the supplied value is unspecified or 0, the service
	//   translates the value to 500,000, which corresponds to the
	//   `Normal` priority in the console.
	// - If the supplied value is negative, the intent is ignored
	//   in runtime detect intent requests.
	Priority int32 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
	// Optional. Indicates whether this is a fallback intent.
	IsFallback bool `protobuf:"varint,4,opt,name=is_fallback,json=isFallback,proto3" json:"is_fallback,omitempty"`
	// Optional. Indicates whether Machine Learning is enabled for the intent.
	// Note: If `ml_enabled` setting is set to false, then this intent is not
	// taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	// DEPRECATED! Please use `ml_disabled` field instead.
	// NOTE: If both `ml_enabled` and `ml_disabled` are either not set or false,
	// then the default value is determined as follows:
	// - Before April 15th, 2018 the default is:
	//   ml_enabled = false / ml_disabled = true.
	// - After April 15th, 2018 the default is:
	//   ml_enabled = true / ml_disabled = false.
	MlEnabled bool `protobuf:"varint,5,opt,name=ml_enabled,json=mlEnabled,proto3" json:"ml_enabled,omitempty"` // Deprecated: Do not use.
	// Optional. Indicates whether Machine Learning is disabled for the intent.
	// Note: If `ml_disabled` setting is set to true, then this intent is not
	// taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	MlDisabled bool `protobuf:"varint,19,opt,name=ml_disabled,json=mlDisabled,proto3" json:"ml_disabled,omitempty"`
	// Optional. Indicates that this intent ends an interaction. Some integrations
	// (e.g., Actions on Google or Dialogflow phone gateway) use this information
	// to close interaction with an end user. Default is false.
	EndInteraction bool `protobuf:"varint,21,opt,name=end_interaction,json=endInteraction,proto3" json:"end_interaction,omitempty"`
	// Optional. The list of context names required for this intent to be
	// triggered.
	// Format: `projects/<Project ID>/agent/sessions/-/contexts/<Context ID>`.
	InputContextNames []string `protobuf:"bytes,7,rep,name=input_context_names,json=inputContextNames,proto3" json:"input_context_names,omitempty"`
	// Optional. The collection of event names that trigger the intent.
	// If the collection of input contexts is not empty, all of the contexts must
	// be present in the active user session for an event to trigger this intent.
	Events []string `protobuf:"bytes,8,rep,name=events,proto3" json:"events,omitempty"`
	// Optional. The collection of examples that the agent is
	// trained on.
	TrainingPhrases []*Intent_TrainingPhrase `protobuf:"bytes,9,rep,name=training_phrases,json=trainingPhrases,proto3" json:"training_phrases,omitempty"`
	// Optional. The name of the action associated with the intent.
	// Note: The action name must not contain whitespaces.
	Action string `protobuf:"bytes,10,opt,name=action,proto3" json:"action,omitempty"`
	// Optional. The collection of contexts that are activated when the intent
	// is matched. Context messages in this collection should not set the
	// parameters field. Setting the `lifespan_count` to 0 will reset the context
	// when the intent is matched.
	// Format: `projects/<Project ID>/agent/sessions/-/contexts/<Context ID>`.
	OutputContexts []*Context `protobuf:"bytes,11,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// Optional. Indicates whether to delete all contexts in the current
	// session when this intent is matched.
	ResetContexts bool `protobuf:"varint,12,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Optional. The collection of parameters associated with the intent.
	Parameters []*Intent_Parameter `protobuf:"bytes,13,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. The collection of rich messages corresponding to the
	// `Response` field in the Dialogflow console.
	Messages []*Intent_Message `protobuf:"bytes,14,rep,name=messages,proto3" json:"messages,omitempty"`
	// Optional. The list of platforms for which the first responses will be
	// copied from the messages in PLATFORM_UNSPECIFIED (i.e. default platform).
	DefaultResponsePlatforms []Intent_Message_Platform `protobuf:"varint,15,rep,packed,name=default_response_platforms,json=defaultResponsePlatforms,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_Platform" json:"default_response_platforms,omitempty"`
	// Read-only. The unique identifier of the root intent in the chain of
	// followup intents. It identifies the correct followup intents chain for
	// this intent. We populate this field only in the output.
	//
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	RootFollowupIntentName string `protobuf:"bytes,16,opt,name=root_followup_intent_name,json=rootFollowupIntentName,proto3" json:"root_followup_intent_name,omitempty"`
	// Read-only after creation. The unique identifier of the parent intent in the
	// chain of followup intents. You can set this field when creating an intent,
	// for example with [CreateIntent][google.cloud.dialogflow.v2beta1.Intents.CreateIntent] or
	// [BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents], in order to make this
	// intent a followup intent.
	//
	// It identifies the parent followup intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	ParentFollowupIntentName string `protobuf:"bytes,17,opt,name=parent_followup_intent_name,json=parentFollowupIntentName,proto3" json:"parent_followup_intent_name,omitempty"`
	// Read-only. Information about all followup intents that have this intent as
	// a direct or indirect parent. We populate this field only in the output.
	FollowupIntentInfo   []*Intent_FollowupIntentInfo `protobuf:"bytes,18,rep,name=followup_intent_info,json=followupIntentInfo,proto3" json:"followup_intent_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Intent) Reset()         { *m = Intent{} }
func (m *Intent) String() string { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()    {}
func (*Intent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0}
}

func (m *Intent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent.Unmarshal(m, b)
}
func (m *Intent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent.Marshal(b, m, deterministic)
}
func (m *Intent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent.Merge(m, src)
}
func (m *Intent) XXX_Size() int {
	return xxx_messageInfo_Intent.Size(m)
}
func (m *Intent) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent.DiscardUnknown(m)
}

var xxx_messageInfo_Intent proto.InternalMessageInfo

func (m *Intent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Intent) GetWebhookState() Intent_WebhookState {
	if m != nil {
		return m.WebhookState
	}
	return Intent_WEBHOOK_STATE_UNSPECIFIED
}

func (m *Intent) GetPriority() int32 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *Intent) GetIsFallback() bool {
	if m != nil {
		return m.IsFallback
	}
	return false
}

// Deprecated: Do not use.
func (m *Intent) GetMlEnabled() bool {
	if m != nil {
		return m.MlEnabled
	}
	return false
}

func (m *Intent) GetMlDisabled() bool {
	if m != nil {
		return m.MlDisabled
	}
	return false
}

func (m *Intent) GetEndInteraction() bool {
	if m != nil {
		return m.EndInteraction
	}
	return false
}

func (m *Intent) GetInputContextNames() []string {
	if m != nil {
		return m.InputContextNames
	}
	return nil
}

func (m *Intent) GetEvents() []string {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *Intent) GetTrainingPhrases() []*Intent_TrainingPhrase {
	if m != nil {
		return m.TrainingPhrases
	}
	return nil
}

func (m *Intent) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *Intent) GetOutputContexts() []*Context {
	if m != nil {
		return m.OutputContexts
	}
	return nil
}

func (m *Intent) GetResetContexts() bool {
	if m != nil {
		return m.ResetContexts
	}
	return false
}

func (m *Intent) GetParameters() []*Intent_Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *Intent) GetMessages() []*Intent_Message {
	if m != nil {
		return m.Messages
	}
	return nil
}

func (m *Intent) GetDefaultResponsePlatforms() []Intent_Message_Platform {
	if m != nil {
		return m.DefaultResponsePlatforms
	}
	return nil
}

func (m *Intent) GetRootFollowupIntentName() string {
	if m != nil {
		return m.RootFollowupIntentName
	}
	return ""
}

func (m *Intent) GetParentFollowupIntentName() string {
	if m != nil {
		return m.ParentFollowupIntentName
	}
	return ""
}

func (m *Intent) GetFollowupIntentInfo() []*Intent_FollowupIntentInfo {
	if m != nil {
		return m.FollowupIntentInfo
	}
	return nil
}

// Represents an example that the agent is trained on.
type Intent_TrainingPhrase struct {
	// Output only. The unique identifier of this training phrase.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The type of the training phrase.
	Type Intent_TrainingPhrase_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_TrainingPhrase_Type" json:"type,omitempty"`
	// Required. The ordered list of training phrase parts.
	// The parts are concatenated in order to form the training phrase.
	//
	// Note: The API does not automatically annotate training phrases like the
	// Dialogflow Console does.
	//
	// Note: Do not forget to include whitespace at part boundaries,
	// so the training phrase is well formatted when the parts are concatenated.
	//
	// If the training phrase does not need to be annotated with parameters,
	// you just need a single part with only the [Part.text][google.cloud.dialogflow.v2beta1.Intent.TrainingPhrase.Part.text] field set.
	//
	// If you want to annotate the training phrase, you must create multiple
	// parts, where the fields of each part are populated in one of two ways:
	//
	// -   `Part.text` is set to a part of the phrase that has no parameters.
	// -   `Part.text` is set to a part of the phrase that you want to annotate,
	//     and the `entity_type`, `alias`, and `user_defined` fields are all
	//     set.
	Parts []*Intent_TrainingPhrase_Part `protobuf:"bytes,3,rep,name=parts,proto3" json:"parts,omitempty"`
	// Optional. Indicates how many times this example was added to
	// the intent. Each time a developer adds an existing sample by editing an
	// intent or training, this counter is increased.
	TimesAddedCount      int32    `protobuf:"varint,4,opt,name=times_added_count,json=timesAddedCount,proto3" json:"times_added_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_TrainingPhrase) Reset()         { *m = Intent_TrainingPhrase{} }
func (m *Intent_TrainingPhrase) String() string { return proto.CompactTextString(m) }
func (*Intent_TrainingPhrase) ProtoMessage()    {}
func (*Intent_TrainingPhrase) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 0}
}

func (m *Intent_TrainingPhrase) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_TrainingPhrase.Unmarshal(m, b)
}
func (m *Intent_TrainingPhrase) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_TrainingPhrase.Marshal(b, m, deterministic)
}
func (m *Intent_TrainingPhrase) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_TrainingPhrase.Merge(m, src)
}
func (m *Intent_TrainingPhrase) XXX_Size() int {
	return xxx_messageInfo_Intent_TrainingPhrase.Size(m)
}
func (m *Intent_TrainingPhrase) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_TrainingPhrase.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_TrainingPhrase proto.InternalMessageInfo

func (m *Intent_TrainingPhrase) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent_TrainingPhrase) GetType() Intent_TrainingPhrase_Type {
	if m != nil {
		return m.Type
	}
	return Intent_TrainingPhrase_TYPE_UNSPECIFIED
}

func (m *Intent_TrainingPhrase) GetParts() []*Intent_TrainingPhrase_Part {
	if m != nil {
		return m.Parts
	}
	return nil
}

func (m *Intent_TrainingPhrase) GetTimesAddedCount() int32 {
	if m != nil {
		return m.TimesAddedCount
	}
	return 0
}

// Represents a part of a training phrase.
type Intent_TrainingPhrase_Part struct {
	// Required. The text for this part.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. The entity type name prefixed with `@`.
	// This field is required for annotated parts of the training phrase.
	EntityType string `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The parameter name for the value extracted from the
	// annotated part of the example.
	// This field is required for annotated parts of the training phrase.
	Alias string `protobuf:"bytes,3,opt,name=alias,proto3" json:"alias,omitempty"`
	// Optional. Indicates whether the text was manually annotated.
	// This field is set to true when the Dialogflow Console is used to
	// manually annotate the part. When creating an annotated part with the
	// API, you must set this to true.
	UserDefined          bool     `protobuf:"varint,4,opt,name=user_defined,json=userDefined,proto3" json:"user_defined,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_TrainingPhrase_Part) Reset()         { *m = Intent_TrainingPhrase_Part{} }
func (m *Intent_TrainingPhrase_Part) String() string { return proto.CompactTextString(m) }
func (*Intent_TrainingPhrase_Part) ProtoMessage()    {}
func (*Intent_TrainingPhrase_Part) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 0, 0}
}

func (m *Intent_TrainingPhrase_Part) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_TrainingPhrase_Part.Unmarshal(m, b)
}
func (m *Intent_TrainingPhrase_Part) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_TrainingPhrase_Part.Marshal(b, m, deterministic)
}
func (m *Intent_TrainingPhrase_Part) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_TrainingPhrase_Part.Merge(m, src)
}
func (m *Intent_TrainingPhrase_Part) XXX_Size() int {
	return xxx_messageInfo_Intent_TrainingPhrase_Part.Size(m)
}
func (m *Intent_TrainingPhrase_Part) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_TrainingPhrase_Part.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_TrainingPhrase_Part proto.InternalMessageInfo

func (m *Intent_TrainingPhrase_Part) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetEntityType() string {
	if m != nil {
		return m.EntityType
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetUserDefined() bool {
	if m != nil {
		return m.UserDefined
	}
	return false
}

// Represents intent parameters.
type Intent_Parameter struct {
	// The unique identifier of this parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the parameter.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The definition of the parameter value. It can be:
	// - a constant string,
	// - a parameter value defined as `$parameter_name`,
	// - an original parameter value defined as `$parameter_name.original`,
	// - a parameter value from some context defined as
	//   `#context_name.parameter_name`.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// Optional. The default value to use when the `value` yields an empty
	// result.
	// Default values can be extracted from contexts by using the following
	// syntax: `#context_name.parameter_name`.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Optional. The name of the entity type, prefixed with `@`, that
	// describes values of the parameter. If the parameter is
	// required, this must be provided.
	EntityTypeDisplayName string `protobuf:"bytes,5,opt,name=entity_type_display_name,json=entityTypeDisplayName,proto3" json:"entity_type_display_name,omitempty"`
	// Optional. Indicates whether the parameter is required. That is,
	// whether the intent cannot be completed without collecting the parameter
	// value.
	Mandatory bool `protobuf:"varint,6,opt,name=mandatory,proto3" json:"mandatory,omitempty"`
	// Optional. The collection of prompts that the agent can present to the
	// user in order to collect a value for the parameter.
	Prompts []string `protobuf:"bytes,7,rep,name=prompts,proto3" json:"prompts,omitempty"`
	// Optional. Indicates whether the parameter represents a list of values.
	IsList               bool     `protobuf:"varint,8,opt,name=is_list,json=isList,proto3" json:"is_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Parameter) Reset()         { *m = Intent_Parameter{} }
func (m *Intent_Parameter) String() string { return proto.CompactTextString(m) }
func (*Intent_Parameter) ProtoMessage()    {}
func (*Intent_Parameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 1}
}

func (m *Intent_Parameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Parameter.Unmarshal(m, b)
}
func (m *Intent_Parameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Parameter.Marshal(b, m, deterministic)
}
func (m *Intent_Parameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Parameter.Merge(m, src)
}
func (m *Intent_Parameter) XXX_Size() int {
	return xxx_messageInfo_Intent_Parameter.Size(m)
}
func (m *Intent_Parameter) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Parameter.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Parameter proto.InternalMessageInfo

func (m *Intent_Parameter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent_Parameter) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Intent_Parameter) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Intent_Parameter) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

func (m *Intent_Parameter) GetEntityTypeDisplayName() string {
	if m != nil {
		return m.EntityTypeDisplayName
	}
	return ""
}

func (m *Intent_Parameter) GetMandatory() bool {
	if m != nil {
		return m.Mandatory
	}
	return false
}

func (m *Intent_Parameter) GetPrompts() []string {
	if m != nil {
		return m.Prompts
	}
	return nil
}

func (m *Intent_Parameter) GetIsList() bool {
	if m != nil {
		return m.IsList
	}
	return false
}

// Corresponds to the `Response` field in the Dialogflow console.
type Intent_Message struct {
	// Required. The rich response message.
	//
	// Types that are valid to be assigned to Message:
	//	*Intent_Message_Text_
	//	*Intent_Message_Image_
	//	*Intent_Message_QuickReplies_
	//	*Intent_Message_Card_
	//	*Intent_Message_Payload
	//	*Intent_Message_SimpleResponses_
	//	*Intent_Message_BasicCard_
	//	*Intent_Message_Suggestions_
	//	*Intent_Message_LinkOutSuggestion_
	//	*Intent_Message_ListSelect_
	//	*Intent_Message_CarouselSelect_
	//	*Intent_Message_TelephonyPlayAudio_
	//	*Intent_Message_TelephonySynthesizeSpeech_
	//	*Intent_Message_TelephonyTransferCall_
	//	*Intent_Message_RbmText_
	//	*Intent_Message_RbmStandaloneRichCard
	//	*Intent_Message_RbmCarouselRichCard
	//	*Intent_Message_BrowseCarouselCard_
	//	*Intent_Message_TableCard_
	//	*Intent_Message_MediaContent_
	Message isIntent_Message_Message `protobuf_oneof:"message"`
	// Optional. The platform that this message is intended for.
	Platform             Intent_Message_Platform `protobuf:"varint,6,opt,name=platform,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_Platform" json:"platform,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Intent_Message) Reset()         { *m = Intent_Message{} }
func (m *Intent_Message) String() string { return proto.CompactTextString(m) }
func (*Intent_Message) ProtoMessage()    {}
func (*Intent_Message) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2}
}

func (m *Intent_Message) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message.Unmarshal(m, b)
}
func (m *Intent_Message) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message.Marshal(b, m, deterministic)
}
func (m *Intent_Message) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message.Merge(m, src)
}
func (m *Intent_Message) XXX_Size() int {
	return xxx_messageInfo_Intent_Message.Size(m)
}
func (m *Intent_Message) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message proto.InternalMessageInfo

type isIntent_Message_Message interface {
	isIntent_Message_Message()
}

type Intent_Message_Text_ struct {
	Text *Intent_Message_Text `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type Intent_Message_Image_ struct {
	Image *Intent_Message_Image `protobuf:"bytes,2,opt,name=image,proto3,oneof"`
}

type Intent_Message_QuickReplies_ struct {
	QuickReplies *Intent_Message_QuickReplies `protobuf:"bytes,3,opt,name=quick_replies,json=quickReplies,proto3,oneof"`
}

type Intent_Message_Card_ struct {
	Card *Intent_Message_Card `protobuf:"bytes,4,opt,name=card,proto3,oneof"`
}

type Intent_Message_Payload struct {
	Payload *_struct.Struct `protobuf:"bytes,5,opt,name=payload,proto3,oneof"`
}

type Intent_Message_SimpleResponses_ struct {
	SimpleResponses *Intent_Message_SimpleResponses `protobuf:"bytes,7,opt,name=simple_responses,json=simpleResponses,proto3,oneof"`
}

type Intent_Message_BasicCard_ struct {
	BasicCard *Intent_Message_BasicCard `protobuf:"bytes,8,opt,name=basic_card,json=basicCard,proto3,oneof"`
}

type Intent_Message_Suggestions_ struct {
	Suggestions *Intent_Message_Suggestions `protobuf:"bytes,9,opt,name=suggestions,proto3,oneof"`
}

type Intent_Message_LinkOutSuggestion_ struct {
	LinkOutSuggestion *Intent_Message_LinkOutSuggestion `protobuf:"bytes,10,opt,name=link_out_suggestion,json=linkOutSuggestion,proto3,oneof"`
}

type Intent_Message_ListSelect_ struct {
	ListSelect *Intent_Message_ListSelect `protobuf:"bytes,11,opt,name=list_select,json=listSelect,proto3,oneof"`
}

type Intent_Message_CarouselSelect_ struct {
	CarouselSelect *Intent_Message_CarouselSelect `protobuf:"bytes,12,opt,name=carousel_select,json=carouselSelect,proto3,oneof"`
}

type Intent_Message_TelephonyPlayAudio_ struct {
	TelephonyPlayAudio *Intent_Message_TelephonyPlayAudio `protobuf:"bytes,13,opt,name=telephony_play_audio,json=telephonyPlayAudio,proto3,oneof"`
}

type Intent_Message_TelephonySynthesizeSpeech_ struct {
	TelephonySynthesizeSpeech *Intent_Message_TelephonySynthesizeSpeech `protobuf:"bytes,14,opt,name=telephony_synthesize_speech,json=telephonySynthesizeSpeech,proto3,oneof"`
}

type Intent_Message_TelephonyTransferCall_ struct {
	TelephonyTransferCall *Intent_Message_TelephonyTransferCall `protobuf:"bytes,15,opt,name=telephony_transfer_call,json=telephonyTransferCall,proto3,oneof"`
}

type Intent_Message_RbmText_ struct {
	RbmText *Intent_Message_RbmText `protobuf:"bytes,18,opt,name=rbm_text,json=rbmText,proto3,oneof"`
}

type Intent_Message_RbmStandaloneRichCard struct {
	RbmStandaloneRichCard *Intent_Message_RbmStandaloneCard `protobuf:"bytes,19,opt,name=rbm_standalone_rich_card,json=rbmStandaloneRichCard,proto3,oneof"`
}

type Intent_Message_RbmCarouselRichCard struct {
	RbmCarouselRichCard *Intent_Message_RbmCarouselCard `protobuf:"bytes,20,opt,name=rbm_carousel_rich_card,json=rbmCarouselRichCard,proto3,oneof"`
}

type Intent_Message_BrowseCarouselCard_ struct {
	BrowseCarouselCard *Intent_Message_BrowseCarouselCard `protobuf:"bytes,22,opt,name=browse_carousel_card,json=browseCarouselCard,proto3,oneof"`
}

type Intent_Message_TableCard_ struct {
	TableCard *Intent_Message_TableCard `protobuf:"bytes,23,opt,name=table_card,json=tableCard,proto3,oneof"`
}

type Intent_Message_MediaContent_ struct {
	MediaContent *Intent_Message_MediaContent `protobuf:"bytes,24,opt,name=media_content,json=mediaContent,proto3,oneof"`
}

func (*Intent_Message_Text_) isIntent_Message_Message() {}

func (*Intent_Message_Image_) isIntent_Message_Message() {}

func (*Intent_Message_QuickReplies_) isIntent_Message_Message() {}

func (*Intent_Message_Card_) isIntent_Message_Message() {}

func (*Intent_Message_Payload) isIntent_Message_Message() {}

func (*Intent_Message_SimpleResponses_) isIntent_Message_Message() {}

func (*Intent_Message_BasicCard_) isIntent_Message_Message() {}

func (*Intent_Message_Suggestions_) isIntent_Message_Message() {}

func (*Intent_Message_LinkOutSuggestion_) isIntent_Message_Message() {}

func (*Intent_Message_ListSelect_) isIntent_Message_Message() {}

func (*Intent_Message_CarouselSelect_) isIntent_Message_Message() {}

func (*Intent_Message_TelephonyPlayAudio_) isIntent_Message_Message() {}

func (*Intent_Message_TelephonySynthesizeSpeech_) isIntent_Message_Message() {}

func (*Intent_Message_TelephonyTransferCall_) isIntent_Message_Message() {}

func (*Intent_Message_RbmText_) isIntent_Message_Message() {}

func (*Intent_Message_RbmStandaloneRichCard) isIntent_Message_Message() {}

func (*Intent_Message_RbmCarouselRichCard) isIntent_Message_Message() {}

func (*Intent_Message_BrowseCarouselCard_) isIntent_Message_Message() {}

func (*Intent_Message_TableCard_) isIntent_Message_Message() {}

func (*Intent_Message_MediaContent_) isIntent_Message_Message() {}

func (m *Intent_Message) GetMessage() isIntent_Message_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Intent_Message) GetText() *Intent_Message_Text {
	if x, ok := m.GetMessage().(*Intent_Message_Text_); ok {
		return x.Text
	}
	return nil
}

func (m *Intent_Message) GetImage() *Intent_Message_Image {
	if x, ok := m.GetMessage().(*Intent_Message_Image_); ok {
		return x.Image
	}
	return nil
}

func (m *Intent_Message) GetQuickReplies() *Intent_Message_QuickReplies {
	if x, ok := m.GetMessage().(*Intent_Message_QuickReplies_); ok {
		return x.QuickReplies
	}
	return nil
}

func (m *Intent_Message) GetCard() *Intent_Message_Card {
	if x, ok := m.GetMessage().(*Intent_Message_Card_); ok {
		return x.Card
	}
	return nil
}

func (m *Intent_Message) GetPayload() *_struct.Struct {
	if x, ok := m.GetMessage().(*Intent_Message_Payload); ok {
		return x.Payload
	}
	return nil
}

func (m *Intent_Message) GetSimpleResponses() *Intent_Message_SimpleResponses {
	if x, ok := m.GetMessage().(*Intent_Message_SimpleResponses_); ok {
		return x.SimpleResponses
	}
	return nil
}

func (m *Intent_Message) GetBasicCard() *Intent_Message_BasicCard {
	if x, ok := m.GetMessage().(*Intent_Message_BasicCard_); ok {
		return x.BasicCard
	}
	return nil
}

func (m *Intent_Message) GetSuggestions() *Intent_Message_Suggestions {
	if x, ok := m.GetMessage().(*Intent_Message_Suggestions_); ok {
		return x.Suggestions
	}
	return nil
}

func (m *Intent_Message) GetLinkOutSuggestion() *Intent_Message_LinkOutSuggestion {
	if x, ok := m.GetMessage().(*Intent_Message_LinkOutSuggestion_); ok {
		return x.LinkOutSuggestion
	}
	return nil
}

func (m *Intent_Message) GetListSelect() *Intent_Message_ListSelect {
	if x, ok := m.GetMessage().(*Intent_Message_ListSelect_); ok {
		return x.ListSelect
	}
	return nil
}

func (m *Intent_Message) GetCarouselSelect() *Intent_Message_CarouselSelect {
	if x, ok := m.GetMessage().(*Intent_Message_CarouselSelect_); ok {
		return x.CarouselSelect
	}
	return nil
}

func (m *Intent_Message) GetTelephonyPlayAudio() *Intent_Message_TelephonyPlayAudio {
	if x, ok := m.GetMessage().(*Intent_Message_TelephonyPlayAudio_); ok {
		return x.TelephonyPlayAudio
	}
	return nil
}

func (m *Intent_Message) GetTelephonySynthesizeSpeech() *Intent_Message_TelephonySynthesizeSpeech {
	if x, ok := m.GetMessage().(*Intent_Message_TelephonySynthesizeSpeech_); ok {
		return x.TelephonySynthesizeSpeech
	}
	return nil
}

func (m *Intent_Message) GetTelephonyTransferCall() *Intent_Message_TelephonyTransferCall {
	if x, ok := m.GetMessage().(*Intent_Message_TelephonyTransferCall_); ok {
		return x.TelephonyTransferCall
	}
	return nil
}

func (m *Intent_Message) GetRbmText() *Intent_Message_RbmText {
	if x, ok := m.GetMessage().(*Intent_Message_RbmText_); ok {
		return x.RbmText
	}
	return nil
}

func (m *Intent_Message) GetRbmStandaloneRichCard() *Intent_Message_RbmStandaloneCard {
	if x, ok := m.GetMessage().(*Intent_Message_RbmStandaloneRichCard); ok {
		return x.RbmStandaloneRichCard
	}
	return nil
}

func (m *Intent_Message) GetRbmCarouselRichCard() *Intent_Message_RbmCarouselCard {
	if x, ok := m.GetMessage().(*Intent_Message_RbmCarouselRichCard); ok {
		return x.RbmCarouselRichCard
	}
	return nil
}

func (m *Intent_Message) GetBrowseCarouselCard() *Intent_Message_BrowseCarouselCard {
	if x, ok := m.GetMessage().(*Intent_Message_BrowseCarouselCard_); ok {
		return x.BrowseCarouselCard
	}
	return nil
}

func (m *Intent_Message) GetTableCard() *Intent_Message_TableCard {
	if x, ok := m.GetMessage().(*Intent_Message_TableCard_); ok {
		return x.TableCard
	}
	return nil
}

func (m *Intent_Message) GetMediaContent() *Intent_Message_MediaContent {
	if x, ok := m.GetMessage().(*Intent_Message_MediaContent_); ok {
		return x.MediaContent
	}
	return nil
}

func (m *Intent_Message) GetPlatform() Intent_Message_Platform {
	if m != nil {
		return m.Platform
	}
	return Intent_Message_PLATFORM_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Intent_Message) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Intent_Message_Text_)(nil),
		(*Intent_Message_Image_)(nil),
		(*Intent_Message_QuickReplies_)(nil),
		(*Intent_Message_Card_)(nil),
		(*Intent_Message_Payload)(nil),
		(*Intent_Message_SimpleResponses_)(nil),
		(*Intent_Message_BasicCard_)(nil),
		(*Intent_Message_Suggestions_)(nil),
		(*Intent_Message_LinkOutSuggestion_)(nil),
		(*Intent_Message_ListSelect_)(nil),
		(*Intent_Message_CarouselSelect_)(nil),
		(*Intent_Message_TelephonyPlayAudio_)(nil),
		(*Intent_Message_TelephonySynthesizeSpeech_)(nil),
		(*Intent_Message_TelephonyTransferCall_)(nil),
		(*Intent_Message_RbmText_)(nil),
		(*Intent_Message_RbmStandaloneRichCard)(nil),
		(*Intent_Message_RbmCarouselRichCard)(nil),
		(*Intent_Message_BrowseCarouselCard_)(nil),
		(*Intent_Message_TableCard_)(nil),
		(*Intent_Message_MediaContent_)(nil),
	}
}

// The text response message.
type Intent_Message_Text struct {
	// Optional. The collection of the agent's responses.
	Text                 []string `protobuf:"bytes,1,rep,name=text,proto3" json:"text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_Text) Reset()         { *m = Intent_Message_Text{} }
func (m *Intent_Message_Text) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Text) ProtoMessage()    {}
func (*Intent_Message_Text) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 0}
}

func (m *Intent_Message_Text) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Text.Unmarshal(m, b)
}
func (m *Intent_Message_Text) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Text.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Text) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Text.Merge(m, src)
}
func (m *Intent_Message_Text) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Text.Size(m)
}
func (m *Intent_Message_Text) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Text.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Text proto.InternalMessageInfo

func (m *Intent_Message_Text) GetText() []string {
	if m != nil {
		return m.Text
	}
	return nil
}

// The image response message.
type Intent_Message_Image struct {
	// Optional. The public URI to an image file.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// A text description of the image to be used for accessibility,
	// e.g., screen readers. Required if image_uri is set for CarouselSelect.
	AccessibilityText    string   `protobuf:"bytes,2,opt,name=accessibility_text,json=accessibilityText,proto3" json:"accessibility_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_Image) Reset()         { *m = Intent_Message_Image{} }
func (m *Intent_Message_Image) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Image) ProtoMessage()    {}
func (*Intent_Message_Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 1}
}

func (m *Intent_Message_Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Image.Unmarshal(m, b)
}
func (m *Intent_Message_Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Image.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Image.Merge(m, src)
}
func (m *Intent_Message_Image) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Image.Size(m)
}
func (m *Intent_Message_Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Image proto.InternalMessageInfo

func (m *Intent_Message_Image) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *Intent_Message_Image) GetAccessibilityText() string {
	if m != nil {
		return m.AccessibilityText
	}
	return ""
}

// The quick replies response message.
type Intent_Message_QuickReplies struct {
	// Optional. The title of the collection of quick replies.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The collection of quick replies.
	QuickReplies         []string `protobuf:"bytes,2,rep,name=quick_replies,json=quickReplies,proto3" json:"quick_replies,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_QuickReplies) Reset()         { *m = Intent_Message_QuickReplies{} }
func (m *Intent_Message_QuickReplies) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_QuickReplies) ProtoMessage()    {}
func (*Intent_Message_QuickReplies) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 2}
}

func (m *Intent_Message_QuickReplies) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_QuickReplies.Unmarshal(m, b)
}
func (m *Intent_Message_QuickReplies) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_QuickReplies.Marshal(b, m, deterministic)
}
func (m *Intent_Message_QuickReplies) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_QuickReplies.Merge(m, src)
}
func (m *Intent_Message_QuickReplies) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_QuickReplies.Size(m)
}
func (m *Intent_Message_QuickReplies) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_QuickReplies.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_QuickReplies proto.InternalMessageInfo

func (m *Intent_Message_QuickReplies) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_QuickReplies) GetQuickReplies() []string {
	if m != nil {
		return m.QuickReplies
	}
	return nil
}

// The card response message.
type Intent_Message_Card struct {
	// Optional. The title of the card.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The subtitle of the card.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// Optional. The public URI to an image file for the card.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional. The collection of card buttons.
	Buttons              []*Intent_Message_Card_Button `protobuf:"bytes,4,rep,name=buttons,proto3" json:"buttons,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *Intent_Message_Card) Reset()         { *m = Intent_Message_Card{} }
func (m *Intent_Message_Card) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Card) ProtoMessage()    {}
func (*Intent_Message_Card) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 3}
}

func (m *Intent_Message_Card) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Card.Unmarshal(m, b)
}
func (m *Intent_Message_Card) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Card.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Card) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Card.Merge(m, src)
}
func (m *Intent_Message_Card) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Card.Size(m)
}
func (m *Intent_Message_Card) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Card.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Card proto.InternalMessageInfo

func (m *Intent_Message_Card) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_Card) GetSubtitle() string {
	if m != nil {
		return m.Subtitle
	}
	return ""
}

func (m *Intent_Message_Card) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *Intent_Message_Card) GetButtons() []*Intent_Message_Card_Button {
	if m != nil {
		return m.Buttons
	}
	return nil
}

// Optional. Contains information about a button.
type Intent_Message_Card_Button struct {
	// Optional. The text to show on the button.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. The text to send back to the Dialogflow API or a URI to
	// open.
	Postback             string   `protobuf:"bytes,2,opt,name=postback,proto3" json:"postback,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_Card_Button) Reset()         { *m = Intent_Message_Card_Button{} }
func (m *Intent_Message_Card_Button) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Card_Button) ProtoMessage()    {}
func (*Intent_Message_Card_Button) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 3, 0}
}

func (m *Intent_Message_Card_Button) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Card_Button.Unmarshal(m, b)
}
func (m *Intent_Message_Card_Button) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Card_Button.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Card_Button) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Card_Button.Merge(m, src)
}
func (m *Intent_Message_Card_Button) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Card_Button.Size(m)
}
func (m *Intent_Message_Card_Button) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Card_Button.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Card_Button proto.InternalMessageInfo

func (m *Intent_Message_Card_Button) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_Message_Card_Button) GetPostback() string {
	if m != nil {
		return m.Postback
	}
	return ""
}

// The simple response message containing speech or text.
type Intent_Message_SimpleResponse struct {
	// One of text_to_speech or ssml must be provided. The plain text of the
	// speech output. Mutually exclusive with ssml.
	TextToSpeech string `protobuf:"bytes,1,opt,name=text_to_speech,json=textToSpeech,proto3" json:"text_to_speech,omitempty"`
	// One of text_to_speech or ssml must be provided. Structured spoken
	// response to the user in the SSML format. Mutually exclusive with
	// text_to_speech.
	Ssml string `protobuf:"bytes,2,opt,name=ssml,proto3" json:"ssml,omitempty"`
	// Optional. The text to display.
	DisplayText          string   `protobuf:"bytes,3,opt,name=display_text,json=displayText,proto3" json:"display_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_SimpleResponse) Reset()         { *m = Intent_Message_SimpleResponse{} }
func (m *Intent_Message_SimpleResponse) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SimpleResponse) ProtoMessage()    {}
func (*Intent_Message_SimpleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 4}
}

func (m *Intent_Message_SimpleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_SimpleResponse.Unmarshal(m, b)
}
func (m *Intent_Message_SimpleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_SimpleResponse.Marshal(b, m, deterministic)
}
func (m *Intent_Message_SimpleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_SimpleResponse.Merge(m, src)
}
func (m *Intent_Message_SimpleResponse) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_SimpleResponse.Size(m)
}
func (m *Intent_Message_SimpleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_SimpleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_SimpleResponse proto.InternalMessageInfo

func (m *Intent_Message_SimpleResponse) GetTextToSpeech() string {
	if m != nil {
		return m.TextToSpeech
	}
	return ""
}

func (m *Intent_Message_SimpleResponse) GetSsml() string {
	if m != nil {
		return m.Ssml
	}
	return ""
}

func (m *Intent_Message_SimpleResponse) GetDisplayText() string {
	if m != nil {
		return m.DisplayText
	}
	return ""
}

// The collection of simple response candidates.
// This message in `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type Intent_Message_SimpleResponses struct {
	// Required. The list of simple responses.
	SimpleResponses      []*Intent_Message_SimpleResponse `protobuf:"bytes,1,rep,name=simple_responses,json=simpleResponses,proto3" json:"simple_responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *Intent_Message_SimpleResponses) Reset()         { *m = Intent_Message_SimpleResponses{} }
func (m *Intent_Message_SimpleResponses) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SimpleResponses) ProtoMessage()    {}
func (*Intent_Message_SimpleResponses) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 5}
}

func (m *Intent_Message_SimpleResponses) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_SimpleResponses.Unmarshal(m, b)
}
func (m *Intent_Message_SimpleResponses) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_SimpleResponses.Marshal(b, m, deterministic)
}
func (m *Intent_Message_SimpleResponses) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_SimpleResponses.Merge(m, src)
}
func (m *Intent_Message_SimpleResponses) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_SimpleResponses.Size(m)
}
func (m *Intent_Message_SimpleResponses) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_SimpleResponses.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_SimpleResponses proto.InternalMessageInfo

func (m *Intent_Message_SimpleResponses) GetSimpleResponses() []*Intent_Message_SimpleResponse {
	if m != nil {
		return m.SimpleResponses
	}
	return nil
}

// The basic card message. Useful for displaying information.
type Intent_Message_BasicCard struct {
	// Optional. The title of the card.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The subtitle of the card.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// Required, unless image is present. The body text of the card.
	FormattedText string `protobuf:"bytes,3,opt,name=formatted_text,json=formattedText,proto3" json:"formatted_text,omitempty"`
	// Optional. The image for the card.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Optional. The collection of card buttons.
	Buttons              []*Intent_Message_BasicCard_Button `protobuf:"bytes,5,rep,name=buttons,proto3" json:"buttons,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *Intent_Message_BasicCard) Reset()         { *m = Intent_Message_BasicCard{} }
func (m *Intent_Message_BasicCard) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_BasicCard) ProtoMessage()    {}
func (*Intent_Message_BasicCard) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 6}
}

func (m *Intent_Message_BasicCard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BasicCard.Unmarshal(m, b)
}
func (m *Intent_Message_BasicCard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BasicCard.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BasicCard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BasicCard.Merge(m, src)
}
func (m *Intent_Message_BasicCard) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BasicCard.Size(m)
}
func (m *Intent_Message_BasicCard) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BasicCard.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BasicCard proto.InternalMessageInfo

func (m *Intent_Message_BasicCard) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetSubtitle() string {
	if m != nil {
		return m.Subtitle
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetFormattedText() string {
	if m != nil {
		return m.FormattedText
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Intent_Message_BasicCard) GetButtons() []*Intent_Message_BasicCard_Button {
	if m != nil {
		return m.Buttons
	}
	return nil
}

// The button object that appears at the bottom of a card.
type Intent_Message_BasicCard_Button struct {
	// Required. The title of the button.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Required. Action to take when a user taps on the button.
	OpenUriAction        *Intent_Message_BasicCard_Button_OpenUriAction `protobuf:"bytes,2,opt,name=open_uri_action,json=openUriAction,proto3" json:"open_uri_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *Intent_Message_BasicCard_Button) Reset()         { *m = Intent_Message_BasicCard_Button{} }
func (m *Intent_Message_BasicCard_Button) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_BasicCard_Button) ProtoMessage()    {}
func (*Intent_Message_BasicCard_Button) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 6, 0}
}

func (m *Intent_Message_BasicCard_Button) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BasicCard_Button.Unmarshal(m, b)
}
func (m *Intent_Message_BasicCard_Button) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BasicCard_Button.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BasicCard_Button) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BasicCard_Button.Merge(m, src)
}
func (m *Intent_Message_BasicCard_Button) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BasicCard_Button.Size(m)
}
func (m *Intent_Message_BasicCard_Button) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BasicCard_Button.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BasicCard_Button proto.InternalMessageInfo

func (m *Intent_Message_BasicCard_Button) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_BasicCard_Button) GetOpenUriAction() *Intent_Message_BasicCard_Button_OpenUriAction {
	if m != nil {
		return m.OpenUriAction
	}
	return nil
}

// Opens the given URI.
type Intent_Message_BasicCard_Button_OpenUriAction struct {
	// Required. The HTTP or HTTPS scheme URI.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_BasicCard_Button_OpenUriAction) Reset() {
	*m = Intent_Message_BasicCard_Button_OpenUriAction{}
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_BasicCard_Button_OpenUriAction) ProtoMessage() {}
func (*Intent_Message_BasicCard_Button_OpenUriAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 6, 0, 0}
}

func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.Unmarshal(m, b)
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.Merge(m, src)
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.Size(m)
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction proto.InternalMessageInfo

func (m *Intent_Message_BasicCard_Button_OpenUriAction) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The suggestion chip message that the user can tap to quickly post a reply
// to the conversation.
type Intent_Message_Suggestion struct {
	// Required. The text shown the in the suggestion chip.
	Title                string   `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_Suggestion) Reset()         { *m = Intent_Message_Suggestion{} }
func (m *Intent_Message_Suggestion) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Suggestion) ProtoMessage()    {}
func (*Intent_Message_Suggestion) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 7}
}

func (m *Intent_Message_Suggestion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Suggestion.Unmarshal(m, b)
}
func (m *Intent_Message_Suggestion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Suggestion.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Suggestion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Suggestion.Merge(m, src)
}
func (m *Intent_Message_Suggestion) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Suggestion.Size(m)
}
func (m *Intent_Message_Suggestion) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Suggestion.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Suggestion proto.InternalMessageInfo

func (m *Intent_Message_Suggestion) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

// The collection of suggestions.
type Intent_Message_Suggestions struct {
	// Required. The list of suggested replies.
	Suggestions          []*Intent_Message_Suggestion `protobuf:"bytes,1,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Intent_Message_Suggestions) Reset()         { *m = Intent_Message_Suggestions{} }
func (m *Intent_Message_Suggestions) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Suggestions) ProtoMessage()    {}
func (*Intent_Message_Suggestions) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 8}
}

func (m *Intent_Message_Suggestions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Suggestions.Unmarshal(m, b)
}
func (m *Intent_Message_Suggestions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Suggestions.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Suggestions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Suggestions.Merge(m, src)
}
func (m *Intent_Message_Suggestions) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Suggestions.Size(m)
}
func (m *Intent_Message_Suggestions) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Suggestions.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Suggestions proto.InternalMessageInfo

func (m *Intent_Message_Suggestions) GetSuggestions() []*Intent_Message_Suggestion {
	if m != nil {
		return m.Suggestions
	}
	return nil
}

// The suggestion chip message that allows the user to jump out to the app
// or website associated with this agent.
type Intent_Message_LinkOutSuggestion struct {
	// Required. The name of the app or site this chip is linking to.
	DestinationName string `protobuf:"bytes,1,opt,name=destination_name,json=destinationName,proto3" json:"destination_name,omitempty"`
	// Required. The URI of the app or site to open when the user taps the
	// suggestion chip.
	Uri                  string   `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_LinkOutSuggestion) Reset()         { *m = Intent_Message_LinkOutSuggestion{} }
func (m *Intent_Message_LinkOutSuggestion) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_LinkOutSuggestion) ProtoMessage()    {}
func (*Intent_Message_LinkOutSuggestion) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 9}
}

func (m *Intent_Message_LinkOutSuggestion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_LinkOutSuggestion.Unmarshal(m, b)
}
func (m *Intent_Message_LinkOutSuggestion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_LinkOutSuggestion.Marshal(b, m, deterministic)
}
func (m *Intent_Message_LinkOutSuggestion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_LinkOutSuggestion.Merge(m, src)
}
func (m *Intent_Message_LinkOutSuggestion) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_LinkOutSuggestion.Size(m)
}
func (m *Intent_Message_LinkOutSuggestion) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_LinkOutSuggestion.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_LinkOutSuggestion proto.InternalMessageInfo

func (m *Intent_Message_LinkOutSuggestion) GetDestinationName() string {
	if m != nil {
		return m.DestinationName
	}
	return ""
}

func (m *Intent_Message_LinkOutSuggestion) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The card for presenting a list of options to select from.
type Intent_Message_ListSelect struct {
	// Optional. The overall title of the list.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Required. List items.
	Items []*Intent_Message_ListSelect_Item `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// Optional. Subtitle of the list.
	Subtitle             string   `protobuf:"bytes,3,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_ListSelect) Reset()         { *m = Intent_Message_ListSelect{} }
func (m *Intent_Message_ListSelect) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_ListSelect) ProtoMessage()    {}
func (*Intent_Message_ListSelect) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 10}
}

func (m *Intent_Message_ListSelect) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_ListSelect.Unmarshal(m, b)
}
func (m *Intent_Message_ListSelect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_ListSelect.Marshal(b, m, deterministic)
}
func (m *Intent_Message_ListSelect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_ListSelect.Merge(m, src)
}
func (m *Intent_Message_ListSelect) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_ListSelect.Size(m)
}
func (m *Intent_Message_ListSelect) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_ListSelect.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_ListSelect proto.InternalMessageInfo

func (m *Intent_Message_ListSelect) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_ListSelect) GetItems() []*Intent_Message_ListSelect_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *Intent_Message_ListSelect) GetSubtitle() string {
	if m != nil {
		return m.Subtitle
	}
	return ""
}

// An item in the list.
type Intent_Message_ListSelect_Item struct {
	// Required. Additional information about this option.
	Info *Intent_Message_SelectItemInfo `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	// Required. The title of the list item.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The main text describing the item.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The image to display.
	Image                *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Intent_Message_ListSelect_Item) Reset()         { *m = Intent_Message_ListSelect_Item{} }
func (m *Intent_Message_ListSelect_Item) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_ListSelect_Item) ProtoMessage()    {}
func (*Intent_Message_ListSelect_Item) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 10, 0}
}

func (m *Intent_Message_ListSelect_Item) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_ListSelect_Item.Unmarshal(m, b)
}
func (m *Intent_Message_ListSelect_Item) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_ListSelect_Item.Marshal(b, m, deterministic)
}
func (m *Intent_Message_ListSelect_Item) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_ListSelect_Item.Merge(m, src)
}
func (m *Intent_Message_ListSelect_Item) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_ListSelect_Item.Size(m)
}
func (m *Intent_Message_ListSelect_Item) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_ListSelect_Item.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_ListSelect_Item proto.InternalMessageInfo

func (m *Intent_Message_ListSelect_Item) GetInfo() *Intent_Message_SelectItemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Intent_Message_ListSelect_Item) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_ListSelect_Item) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Intent_Message_ListSelect_Item) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// The card for presenting a carousel of options to select from.
type Intent_Message_CarouselSelect struct {
	// Required. Carousel items.
	Items                []*Intent_Message_CarouselSelect_Item `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *Intent_Message_CarouselSelect) Reset()         { *m = Intent_Message_CarouselSelect{} }
func (m *Intent_Message_CarouselSelect) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_CarouselSelect) ProtoMessage()    {}
func (*Intent_Message_CarouselSelect) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 11}
}

func (m *Intent_Message_CarouselSelect) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_CarouselSelect.Unmarshal(m, b)
}
func (m *Intent_Message_CarouselSelect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_CarouselSelect.Marshal(b, m, deterministic)
}
func (m *Intent_Message_CarouselSelect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_CarouselSelect.Merge(m, src)
}
func (m *Intent_Message_CarouselSelect) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_CarouselSelect.Size(m)
}
func (m *Intent_Message_CarouselSelect) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_CarouselSelect.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_CarouselSelect proto.InternalMessageInfo

func (m *Intent_Message_CarouselSelect) GetItems() []*Intent_Message_CarouselSelect_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

// An item in the carousel.
type Intent_Message_CarouselSelect_Item struct {
	// Required. Additional info about the option item.
	Info *Intent_Message_SelectItemInfo `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	// Required. Title of the carousel item.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The body text of the card.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The image to display.
	Image                *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Intent_Message_CarouselSelect_Item) Reset()         { *m = Intent_Message_CarouselSelect_Item{} }
func (m *Intent_Message_CarouselSelect_Item) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_CarouselSelect_Item) ProtoMessage()    {}
func (*Intent_Message_CarouselSelect_Item) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 11, 0}
}

func (m *Intent_Message_CarouselSelect_Item) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_CarouselSelect_Item.Unmarshal(m, b)
}
func (m *Intent_Message_CarouselSelect_Item) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_CarouselSelect_Item.Marshal(b, m, deterministic)
}
func (m *Intent_Message_CarouselSelect_Item) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_CarouselSelect_Item.Merge(m, src)
}
func (m *Intent_Message_CarouselSelect_Item) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_CarouselSelect_Item.Size(m)
}
func (m *Intent_Message_CarouselSelect_Item) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_CarouselSelect_Item.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_CarouselSelect_Item proto.InternalMessageInfo

func (m *Intent_Message_CarouselSelect_Item) GetInfo() *Intent_Message_SelectItemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Intent_Message_CarouselSelect_Item) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_CarouselSelect_Item) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Intent_Message_CarouselSelect_Item) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// Additional info about the select item for when it is triggered in a
// dialog.
type Intent_Message_SelectItemInfo struct {
	// Required. A unique key that will be sent back to the agent if this
	// response is given.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. A list of synonyms that can also be used to trigger this
	// item in dialog.
	Synonyms             []string `protobuf:"bytes,2,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_SelectItemInfo) Reset()         { *m = Intent_Message_SelectItemInfo{} }
func (m *Intent_Message_SelectItemInfo) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SelectItemInfo) ProtoMessage()    {}
func (*Intent_Message_SelectItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 12}
}

func (m *Intent_Message_SelectItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_SelectItemInfo.Unmarshal(m, b)
}
func (m *Intent_Message_SelectItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_SelectItemInfo.Marshal(b, m, deterministic)
}
func (m *Intent_Message_SelectItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_SelectItemInfo.Merge(m, src)
}
func (m *Intent_Message_SelectItemInfo) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_SelectItemInfo.Size(m)
}
func (m *Intent_Message_SelectItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_SelectItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_SelectItemInfo proto.InternalMessageInfo

func (m *Intent_Message_SelectItemInfo) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Intent_Message_SelectItemInfo) GetSynonyms() []string {
	if m != nil {
		return m.Synonyms
	}
	return nil
}

// Plays audio from a file in Telephony Gateway.
type Intent_Message_TelephonyPlayAudio struct {
	// Required. URI to a Google Cloud Storage object containing the audio to
	// play, e.g., "gs://bucket/object". The object must contain a single
	// channel (mono) of linear PCM audio (2 bytes / sample) at 8kHz.
	//
	// This object must be readable by the `service-<Project
	// Number>@gcp-sa-dialogflow.iam.gserviceaccount.com` service account
	// where <Project Number> is the number of the Telephony Gateway project
	// (usually the same as the Dialogflow agent project). If the Google Cloud
	// Storage bucket is in the Telephony Gateway project, this permission is
	// added by default when enabling the Dialogflow V2 API.
	//
	// For audio from other sources, consider using the
	// `TelephonySynthesizeSpeech` message with SSML.
	AudioUri             string   `protobuf:"bytes,1,opt,name=audio_uri,json=audioUri,proto3" json:"audio_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_TelephonyPlayAudio) Reset()         { *m = Intent_Message_TelephonyPlayAudio{} }
func (m *Intent_Message_TelephonyPlayAudio) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TelephonyPlayAudio) ProtoMessage()    {}
func (*Intent_Message_TelephonyPlayAudio) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 13}
}

func (m *Intent_Message_TelephonyPlayAudio) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TelephonyPlayAudio.Unmarshal(m, b)
}
func (m *Intent_Message_TelephonyPlayAudio) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TelephonyPlayAudio.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TelephonyPlayAudio) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TelephonyPlayAudio.Merge(m, src)
}
func (m *Intent_Message_TelephonyPlayAudio) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TelephonyPlayAudio.Size(m)
}
func (m *Intent_Message_TelephonyPlayAudio) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TelephonyPlayAudio.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TelephonyPlayAudio proto.InternalMessageInfo

func (m *Intent_Message_TelephonyPlayAudio) GetAudioUri() string {
	if m != nil {
		return m.AudioUri
	}
	return ""
}

// Synthesizes speech and plays back the synthesized audio to the caller in
// Telephony Gateway.
//
// Telephony Gateway takes the synthesizer settings from
// `DetectIntentResponse.output_audio_config` which can either be set
// at request-level or can come from the agent-level synthesizer config.
type Intent_Message_TelephonySynthesizeSpeech struct {
	// Required. The source to be synthesized.
	//
	// Types that are valid to be assigned to Source:
	//	*Intent_Message_TelephonySynthesizeSpeech_Text
	//	*Intent_Message_TelephonySynthesizeSpeech_Ssml
	Source               isIntent_Message_TelephonySynthesizeSpeech_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *Intent_Message_TelephonySynthesizeSpeech) Reset() {
	*m = Intent_Message_TelephonySynthesizeSpeech{}
}
func (m *Intent_Message_TelephonySynthesizeSpeech) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TelephonySynthesizeSpeech) ProtoMessage()    {}
func (*Intent_Message_TelephonySynthesizeSpeech) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 14}
}

func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.Unmarshal(m, b)
}
func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.Merge(m, src)
}
func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.Size(m)
}
func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech proto.InternalMessageInfo

type isIntent_Message_TelephonySynthesizeSpeech_Source interface {
	isIntent_Message_TelephonySynthesizeSpeech_Source()
}

type Intent_Message_TelephonySynthesizeSpeech_Text struct {
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type Intent_Message_TelephonySynthesizeSpeech_Ssml struct {
	Ssml string `protobuf:"bytes,2,opt,name=ssml,proto3,oneof"`
}

func (*Intent_Message_TelephonySynthesizeSpeech_Text) isIntent_Message_TelephonySynthesizeSpeech_Source() {
}

func (*Intent_Message_TelephonySynthesizeSpeech_Ssml) isIntent_Message_TelephonySynthesizeSpeech_Source() {
}

func (m *Intent_Message_TelephonySynthesizeSpeech) GetSource() isIntent_Message_TelephonySynthesizeSpeech_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Intent_Message_TelephonySynthesizeSpeech) GetText() string {
	if x, ok := m.GetSource().(*Intent_Message_TelephonySynthesizeSpeech_Text); ok {
		return x.Text
	}
	return ""
}

func (m *Intent_Message_TelephonySynthesizeSpeech) GetSsml() string {
	if x, ok := m.GetSource().(*Intent_Message_TelephonySynthesizeSpeech_Ssml); ok {
		return x.Ssml
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Intent_Message_TelephonySynthesizeSpeech) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Intent_Message_TelephonySynthesizeSpeech_Text)(nil),
		(*Intent_Message_TelephonySynthesizeSpeech_Ssml)(nil),
	}
}

// Transfers the call in Telephony Gateway.
type Intent_Message_TelephonyTransferCall struct {
	// Required. The phone number to transfer the call to
	// in [E.164 format](https://en.wikipedia.org/wiki/E.164).
	//
	// We currently only allow transferring to US numbers (+1xxxyyyzzzz).
	PhoneNumber          string   `protobuf:"bytes,1,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_TelephonyTransferCall) Reset()         { *m = Intent_Message_TelephonyTransferCall{} }
func (m *Intent_Message_TelephonyTransferCall) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TelephonyTransferCall) ProtoMessage()    {}
func (*Intent_Message_TelephonyTransferCall) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 15}
}

func (m *Intent_Message_TelephonyTransferCall) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TelephonyTransferCall.Unmarshal(m, b)
}
func (m *Intent_Message_TelephonyTransferCall) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TelephonyTransferCall.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TelephonyTransferCall) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TelephonyTransferCall.Merge(m, src)
}
func (m *Intent_Message_TelephonyTransferCall) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TelephonyTransferCall.Size(m)
}
func (m *Intent_Message_TelephonyTransferCall) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TelephonyTransferCall.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TelephonyTransferCall proto.InternalMessageInfo

func (m *Intent_Message_TelephonyTransferCall) GetPhoneNumber() string {
	if m != nil {
		return m.PhoneNumber
	}
	return ""
}

// Rich Business Messaging (RBM) text response with suggestions.
type Intent_Message_RbmText struct {
	// Required. Text sent and displayed to the user.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. One or more suggestions to show to the user.
	RbmSuggestion        []*Intent_Message_RbmSuggestion `protobuf:"bytes,2,rep,name=rbm_suggestion,json=rbmSuggestion,proto3" json:"rbm_suggestion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Intent_Message_RbmText) Reset()         { *m = Intent_Message_RbmText{} }
func (m *Intent_Message_RbmText) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_RbmText) ProtoMessage()    {}
func (*Intent_Message_RbmText) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 16}
}

func (m *Intent_Message_RbmText) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmText.Unmarshal(m, b)
}
func (m *Intent_Message_RbmText) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmText.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmText) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmText.Merge(m, src)
}
func (m *Intent_Message_RbmText) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmText.Size(m)
}
func (m *Intent_Message_RbmText) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmText.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmText proto.InternalMessageInfo

func (m *Intent_Message_RbmText) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_Message_RbmText) GetRbmSuggestion() []*Intent_Message_RbmSuggestion {
	if m != nil {
		return m.RbmSuggestion
	}
	return nil
}

// Carousel Rich Business Messaging (RBM) rich card.
//
// Rich cards allow you to respond to users with more vivid content, e.g.
// with media and suggestions.
//
// For more details about RBM rich cards, please see:
// https://developers.google.com/rcs-business-messaging/rbm/guides/build/send-messages#rich-cards.
// If you want to show a single card with more control over the layout,
// please use [RbmStandaloneCard][google.cloud.dialogflow.v2beta1.Intent.Message.RbmStandaloneCard] instead.
type Intent_Message_RbmCarouselCard struct {
	// Required. The width of the cards in the carousel.
	CardWidth Intent_Message_RbmCarouselCard_CardWidth `protobuf:"varint,1,opt,name=card_width,json=cardWidth,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_RbmCarouselCard_CardWidth" json:"card_width,omitempty"`
	// Required. The cards in the carousel. A carousel must have at least
	// 2 cards and at most 10.
	CardContents         []*Intent_Message_RbmCardContent `protobuf:"bytes,2,rep,name=card_contents,json=cardContents,proto3" json:"card_contents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *Intent_Message_RbmCarouselCard) Reset()         { *m = Intent_Message_RbmCarouselCard{} }
func (m *Intent_Message_RbmCarouselCard) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_RbmCarouselCard) ProtoMessage()    {}
func (*Intent_Message_RbmCarouselCard) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 17}
}

func (m *Intent_Message_RbmCarouselCard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmCarouselCard.Unmarshal(m, b)
}
func (m *Intent_Message_RbmCarouselCard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmCarouselCard.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmCarouselCard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmCarouselCard.Merge(m, src)
}
func (m *Intent_Message_RbmCarouselCard) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmCarouselCard.Size(m)
}
func (m *Intent_Message_RbmCarouselCard) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmCarouselCard.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmCarouselCard proto.InternalMessageInfo

func (m *Intent_Message_RbmCarouselCard) GetCardWidth() Intent_Message_RbmCarouselCard_CardWidth {
	if m != nil {
		return m.CardWidth
	}
	return Intent_Message_RbmCarouselCard_CARD_WIDTH_UNSPECIFIED
}

func (m *Intent_Message_RbmCarouselCard) GetCardContents() []*Intent_Message_RbmCardContent {
	if m != nil {
		return m.CardContents
	}
	return nil
}

// Standalone Rich Business Messaging (RBM) rich card.
//
// Rich cards allow you to respond to users with more vivid content, e.g.
// with media and suggestions.
//
// For more details about RBM rich cards, please see:
// https://developers.google.com/rcs-business-messaging/rbm/guides/build/send-messages#rich-cards.
// You can group multiple rich cards into one using [RbmCarouselCard][google.cloud.dialogflow.v2beta1.Intent.Message.RbmCarouselCard] but
// carousel cards will give you less control over the card layout.
type Intent_Message_RbmStandaloneCard struct {
	// Required. Orientation of the card.
	CardOrientation Intent_Message_RbmStandaloneCard_CardOrientation `protobuf:"varint,1,opt,name=card_orientation,json=cardOrientation,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_RbmStandaloneCard_CardOrientation" json:"card_orientation,omitempty"`
	// Required if orientation is horizontal.
	// Image preview alignment for standalone cards with horizontal layout.
	ThumbnailImageAlignment Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment `protobuf:"varint,2,opt,name=thumbnail_image_alignment,json=thumbnailImageAlignment,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment" json:"thumbnail_image_alignment,omitempty"`
	// Required. Card content.
	CardContent          *Intent_Message_RbmCardContent `protobuf:"bytes,3,opt,name=card_content,json=cardContent,proto3" json:"card_content,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *Intent_Message_RbmStandaloneCard) Reset()         { *m = Intent_Message_RbmStandaloneCard{} }
func (m *Intent_Message_RbmStandaloneCard) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_RbmStandaloneCard) ProtoMessage()    {}
func (*Intent_Message_RbmStandaloneCard) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 18}
}

func (m *Intent_Message_RbmStandaloneCard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmStandaloneCard.Unmarshal(m, b)
}
func (m *Intent_Message_RbmStandaloneCard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmStandaloneCard.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmStandaloneCard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmStandaloneCard.Merge(m, src)
}
func (m *Intent_Message_RbmStandaloneCard) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmStandaloneCard.Size(m)
}
func (m *Intent_Message_RbmStandaloneCard) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmStandaloneCard.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmStandaloneCard proto.InternalMessageInfo

func (m *Intent_Message_RbmStandaloneCard) GetCardOrientation() Intent_Message_RbmStandaloneCard_CardOrientation {
	if m != nil {
		return m.CardOrientation
	}
	return Intent_Message_RbmStandaloneCard_CARD_ORIENTATION_UNSPECIFIED
}

func (m *Intent_Message_RbmStandaloneCard) GetThumbnailImageAlignment() Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment {
	if m != nil {
		return m.ThumbnailImageAlignment
	}
	return Intent_Message_RbmStandaloneCard_THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED
}

func (m *Intent_Message_RbmStandaloneCard) GetCardContent() *Intent_Message_RbmCardContent {
	if m != nil {
		return m.CardContent
	}
	return nil
}

// Rich Business Messaging (RBM) Card content
type Intent_Message_RbmCardContent struct {
	// Optional. Title of the card (at most 200 bytes).
	//
	// At least one of the title, description or media must be set.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. Description of the card (at most 2000 bytes).
	//
	// At least one of the title, description or media must be set.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. However at least one of the title, description or media must
	// be set. Media (image, GIF or a video) to include in the card.
	Media *Intent_Message_RbmCardContent_RbmMedia `protobuf:"bytes,3,opt,name=media,proto3" json:"media,omitempty"`
	// Optional. List of suggestions to include in the card.
	Suggestions          []*Intent_Message_RbmSuggestion `protobuf:"bytes,4,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Intent_Message_RbmCardContent) Reset()         { *m = Intent_Message_RbmCardContent{} }
func (m *Intent_Message_RbmCardContent) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_RbmCardContent) ProtoMessage()    {}
func (*Intent_Message_RbmCardContent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 19}
}

func (m *Intent_Message_RbmCardContent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmCardContent.Unmarshal(m, b)
}
func (m *Intent_Message_RbmCardContent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmCardContent.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmCardContent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmCardContent.Merge(m, src)
}
func (m *Intent_Message_RbmCardContent) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmCardContent.Size(m)
}
func (m *Intent_Message_RbmCardContent) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmCardContent.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmCardContent proto.InternalMessageInfo

func (m *Intent_Message_RbmCardContent) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_RbmCardContent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Intent_Message_RbmCardContent) GetMedia() *Intent_Message_RbmCardContent_RbmMedia {
	if m != nil {
		return m.Media
	}
	return nil
}

func (m *Intent_Message_RbmCardContent) GetSuggestions() []*Intent_Message_RbmSuggestion {
	if m != nil {
		return m.Suggestions
	}
	return nil
}

// Rich Business Messaging (RBM) Media displayed in Cards
// The following media-types are currently supported:
//
// ## Image Types
//
//  image/jpeg
//  image/jpg'
//  image/gif
//  image/png
//
// ## Video Types
//
//  video/h263
//  video/m4v
//  video/mp4
//  video/mpeg
//  video/mpeg4
//  video/webm
type Intent_Message_RbmCardContent_RbmMedia struct {
	// Required. Publicly reachable URI of the file. The RBM platform
	// determines the MIME type of the file from the content-type field in
	// the HTTP headers when the platform fetches the file. The content-type
	// field must be present and accurate in the HTTP response from the URL.
	FileUri string `protobuf:"bytes,1,opt,name=file_uri,json=fileUri,proto3" json:"file_uri,omitempty"`
	// Optional. Publicly reachable URI of the thumbnail.If you don't
	// provide a thumbnail URI, the RBM platform displays a blank
	// placeholder thumbnail until the user's device downloads the file.
	// Depending on the user's setting, the file may not download
	// automatically and may require the user to tap a download button.
	ThumbnailUri string `protobuf:"bytes,2,opt,name=thumbnail_uri,json=thumbnailUri,proto3" json:"thumbnail_uri,omitempty"`
	// Required for cards with vertical orientation. The height of the media
	// within a rich card with a vertical layout. (https://goo.gl/NeFCjz).
	// For a standalone card with horizontal layout, height is not
	// customizable, and this field is ignored.
	Height               Intent_Message_RbmCardContent_RbmMedia_Height `protobuf:"varint,3,opt,name=height,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_RbmCardContent_RbmMedia_Height" json:"height,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *Intent_Message_RbmCardContent_RbmMedia) Reset() {
	*m = Intent_Message_RbmCardContent_RbmMedia{}
}
func (m *Intent_Message_RbmCardContent_RbmMedia) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_RbmCardContent_RbmMedia) ProtoMessage()    {}
func (*Intent_Message_RbmCardContent_RbmMedia) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 19, 0}
}

func (m *Intent_Message_RbmCardContent_RbmMedia) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmCardContent_RbmMedia.Unmarshal(m, b)
}
func (m *Intent_Message_RbmCardContent_RbmMedia) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmCardContent_RbmMedia.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmCardContent_RbmMedia) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmCardContent_RbmMedia.Merge(m, src)
}
func (m *Intent_Message_RbmCardContent_RbmMedia) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmCardContent_RbmMedia.Size(m)
}
func (m *Intent_Message_RbmCardContent_RbmMedia) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmCardContent_RbmMedia.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmCardContent_RbmMedia proto.InternalMessageInfo

func (m *Intent_Message_RbmCardContent_RbmMedia) GetFileUri() string {
	if m != nil {
		return m.FileUri
	}
	return ""
}

func (m *Intent_Message_RbmCardContent_RbmMedia) GetThumbnailUri() string {
	if m != nil {
		return m.ThumbnailUri
	}
	return ""
}

func (m *Intent_Message_RbmCardContent_RbmMedia) GetHeight() Intent_Message_RbmCardContent_RbmMedia_Height {
	if m != nil {
		return m.Height
	}
	return Intent_Message_RbmCardContent_RbmMedia_HEIGHT_UNSPECIFIED
}

// Rich Business Messaging (RBM) suggestion. Suggestions allow user to
// easily select/click a predefined response or perform an action (like
// opening a web uri).
type Intent_Message_RbmSuggestion struct {
	// Predefined suggested response or action for user to choose
	//
	// Types that are valid to be assigned to Suggestion:
	//	*Intent_Message_RbmSuggestion_Reply
	//	*Intent_Message_RbmSuggestion_Action
	Suggestion           isIntent_Message_RbmSuggestion_Suggestion `protobuf_oneof:"suggestion"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *Intent_Message_RbmSuggestion) Reset()         { *m = Intent_Message_RbmSuggestion{} }
func (m *Intent_Message_RbmSuggestion) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_RbmSuggestion) ProtoMessage()    {}
func (*Intent_Message_RbmSuggestion) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 20}
}

func (m *Intent_Message_RbmSuggestion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmSuggestion.Unmarshal(m, b)
}
func (m *Intent_Message_RbmSuggestion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmSuggestion.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmSuggestion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmSuggestion.Merge(m, src)
}
func (m *Intent_Message_RbmSuggestion) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmSuggestion.Size(m)
}
func (m *Intent_Message_RbmSuggestion) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmSuggestion.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmSuggestion proto.InternalMessageInfo

type isIntent_Message_RbmSuggestion_Suggestion interface {
	isIntent_Message_RbmSuggestion_Suggestion()
}

type Intent_Message_RbmSuggestion_Reply struct {
	Reply *Intent_Message_RbmSuggestedReply `protobuf:"bytes,1,opt,name=reply,proto3,oneof"`
}

type Intent_Message_RbmSuggestion_Action struct {
	Action *Intent_Message_RbmSuggestedAction `protobuf:"bytes,2,opt,name=action,proto3,oneof"`
}

func (*Intent_Message_RbmSuggestion_Reply) isIntent_Message_RbmSuggestion_Suggestion() {}

func (*Intent_Message_RbmSuggestion_Action) isIntent_Message_RbmSuggestion_Suggestion() {}

func (m *Intent_Message_RbmSuggestion) GetSuggestion() isIntent_Message_RbmSuggestion_Suggestion {
	if m != nil {
		return m.Suggestion
	}
	return nil
}

func (m *Intent_Message_RbmSuggestion) GetReply() *Intent_Message_RbmSuggestedReply {
	if x, ok := m.GetSuggestion().(*Intent_Message_RbmSuggestion_Reply); ok {
		return x.Reply
	}
	return nil
}

func (m *Intent_Message_RbmSuggestion) GetAction() *Intent_Message_RbmSuggestedAction {
	if x, ok := m.GetSuggestion().(*Intent_Message_RbmSuggestion_Action); ok {
		return x.Action
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Intent_Message_RbmSuggestion) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Intent_Message_RbmSuggestion_Reply)(nil),
		(*Intent_Message_RbmSuggestion_Action)(nil),
	}
}

// Rich Business Messaging (RBM) suggested reply that the user can click
// instead of typing in their own response.
type Intent_Message_RbmSuggestedReply struct {
	// Suggested reply text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Opaque payload that the Dialogflow receives in a user event
	// when the user taps the suggested reply. This data will be also
	// forwarded to webhook to allow performing custom business logic.
	PostbackData         string   `protobuf:"bytes,2,opt,name=postback_data,json=postbackData,proto3" json:"postback_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_RbmSuggestedReply) Reset()         { *m = Intent_Message_RbmSuggestedReply{} }
func (m *Intent_Message_RbmSuggestedReply) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_RbmSuggestedReply) ProtoMessage()    {}
func (*Intent_Message_RbmSuggestedReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 21}
}

func (m *Intent_Message_RbmSuggestedReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmSuggestedReply.Unmarshal(m, b)
}
func (m *Intent_Message_RbmSuggestedReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmSuggestedReply.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmSuggestedReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmSuggestedReply.Merge(m, src)
}
func (m *Intent_Message_RbmSuggestedReply) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmSuggestedReply.Size(m)
}
func (m *Intent_Message_RbmSuggestedReply) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmSuggestedReply.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmSuggestedReply proto.InternalMessageInfo

func (m *Intent_Message_RbmSuggestedReply) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_Message_RbmSuggestedReply) GetPostbackData() string {
	if m != nil {
		return m.PostbackData
	}
	return ""
}

// Rich Business Messaging (RBM) suggested client-side action that the user
// can choose from the card.
type Intent_Message_RbmSuggestedAction struct {
	// Text to display alongside the action.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Opaque payload that the Dialogflow receives in a user event
	// when the user taps the suggested action. This data will be also
	// forwarded to webhook to allow performing custom business logic.
	PostbackData string `protobuf:"bytes,2,opt,name=postback_data,json=postbackData,proto3" json:"postback_data,omitempty"`
	// Action that needs to be triggered.
	//
	// Types that are valid to be assigned to Action:
	//	*Intent_Message_RbmSuggestedAction_Dial
	//	*Intent_Message_RbmSuggestedAction_OpenUrl
	//	*Intent_Message_RbmSuggestedAction_ShareLocation
	Action               isIntent_Message_RbmSuggestedAction_Action `protobuf_oneof:"action"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *Intent_Message_RbmSuggestedAction) Reset()         { *m = Intent_Message_RbmSuggestedAction{} }
func (m *Intent_Message_RbmSuggestedAction) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_RbmSuggestedAction) ProtoMessage()    {}
func (*Intent_Message_RbmSuggestedAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 22}
}

func (m *Intent_Message_RbmSuggestedAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction.Unmarshal(m, b)
}
func (m *Intent_Message_RbmSuggestedAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmSuggestedAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmSuggestedAction.Merge(m, src)
}
func (m *Intent_Message_RbmSuggestedAction) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction.Size(m)
}
func (m *Intent_Message_RbmSuggestedAction) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmSuggestedAction.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmSuggestedAction proto.InternalMessageInfo

func (m *Intent_Message_RbmSuggestedAction) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_Message_RbmSuggestedAction) GetPostbackData() string {
	if m != nil {
		return m.PostbackData
	}
	return ""
}

type isIntent_Message_RbmSuggestedAction_Action interface {
	isIntent_Message_RbmSuggestedAction_Action()
}

type Intent_Message_RbmSuggestedAction_Dial struct {
	Dial *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial `protobuf:"bytes,3,opt,name=dial,proto3,oneof"`
}

type Intent_Message_RbmSuggestedAction_OpenUrl struct {
	OpenUrl *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri `protobuf:"bytes,4,opt,name=open_url,json=openUrl,proto3,oneof"`
}

type Intent_Message_RbmSuggestedAction_ShareLocation struct {
	ShareLocation *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation `protobuf:"bytes,5,opt,name=share_location,json=shareLocation,proto3,oneof"`
}

func (*Intent_Message_RbmSuggestedAction_Dial) isIntent_Message_RbmSuggestedAction_Action() {}

func (*Intent_Message_RbmSuggestedAction_OpenUrl) isIntent_Message_RbmSuggestedAction_Action() {}

func (*Intent_Message_RbmSuggestedAction_ShareLocation) isIntent_Message_RbmSuggestedAction_Action() {}

func (m *Intent_Message_RbmSuggestedAction) GetAction() isIntent_Message_RbmSuggestedAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *Intent_Message_RbmSuggestedAction) GetDial() *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial {
	if x, ok := m.GetAction().(*Intent_Message_RbmSuggestedAction_Dial); ok {
		return x.Dial
	}
	return nil
}

func (m *Intent_Message_RbmSuggestedAction) GetOpenUrl() *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri {
	if x, ok := m.GetAction().(*Intent_Message_RbmSuggestedAction_OpenUrl); ok {
		return x.OpenUrl
	}
	return nil
}

func (m *Intent_Message_RbmSuggestedAction) GetShareLocation() *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation {
	if x, ok := m.GetAction().(*Intent_Message_RbmSuggestedAction_ShareLocation); ok {
		return x.ShareLocation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Intent_Message_RbmSuggestedAction) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Intent_Message_RbmSuggestedAction_Dial)(nil),
		(*Intent_Message_RbmSuggestedAction_OpenUrl)(nil),
		(*Intent_Message_RbmSuggestedAction_ShareLocation)(nil),
	}
}

// Opens the user's default dialer app with the specified phone number
// but does not dial automatically (https://goo.gl/ergbB2).
type Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial struct {
	// Required. The phone number to fill in the default dialer app.
	// This field should be in [E.164](https://en.wikipedia.org/wiki/E.164)
	// format. An example of a correctly formatted phone number:
	// +15556767888.
	PhoneNumber          string   `protobuf:"bytes,1,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) Reset() {
	*m = Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial{}
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) ProtoMessage() {}
func (*Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 22, 0}
}

func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial.Unmarshal(m, b)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial.Merge(m, src)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial.Size(m)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial proto.InternalMessageInfo

func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial) GetPhoneNumber() string {
	if m != nil {
		return m.PhoneNumber
	}
	return ""
}

// Opens the user's default web browser app to the specified uri
// (https://goo.gl/6GLJD2). If the user has an app installed that is
// registered as the default handler for the URL, then this app will be
// opened instead, and its icon will be used in the suggested action UI.
type Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri struct {
	// Required. The uri to open on the user device
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) Reset() {
	*m = Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri{}
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) ProtoMessage() {}
func (*Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 22, 1}
}

func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri.Unmarshal(m, b)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri.Merge(m, src)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri.Size(m)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri proto.InternalMessageInfo

func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// Opens the device's location chooser so the user can pick a location
// to send back to the agent (https://goo.gl/GXotJW).
type Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) Reset() {
	*m = Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation{}
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) ProtoMessage() {}
func (*Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 22, 2}
}

func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation.Unmarshal(m, b)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation.Marshal(b, m, deterministic)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation.Merge(m, src)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation.Size(m)
}
func (m *Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation proto.InternalMessageInfo

// The media content card for Actions on Google.
type Intent_Message_MediaContent struct {
	// Optional. What type of media is the content (ie "audio").
	MediaType Intent_Message_MediaContent_ResponseMediaType `protobuf:"varint,1,opt,name=media_type,json=mediaType,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_MediaContent_ResponseMediaType" json:"media_type,omitempty"`
	// Required. List of media objects.
	MediaObjects         []*Intent_Message_MediaContent_ResponseMediaObject `protobuf:"bytes,2,rep,name=media_objects,json=mediaObjects,proto3" json:"media_objects,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                           `json:"-"`
	XXX_unrecognized     []byte                                             `json:"-"`
	XXX_sizecache        int32                                              `json:"-"`
}

func (m *Intent_Message_MediaContent) Reset()         { *m = Intent_Message_MediaContent{} }
func (m *Intent_Message_MediaContent) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_MediaContent) ProtoMessage()    {}
func (*Intent_Message_MediaContent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 23}
}

func (m *Intent_Message_MediaContent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_MediaContent.Unmarshal(m, b)
}
func (m *Intent_Message_MediaContent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_MediaContent.Marshal(b, m, deterministic)
}
func (m *Intent_Message_MediaContent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_MediaContent.Merge(m, src)
}
func (m *Intent_Message_MediaContent) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_MediaContent.Size(m)
}
func (m *Intent_Message_MediaContent) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_MediaContent.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_MediaContent proto.InternalMessageInfo

func (m *Intent_Message_MediaContent) GetMediaType() Intent_Message_MediaContent_ResponseMediaType {
	if m != nil {
		return m.MediaType
	}
	return Intent_Message_MediaContent_RESPONSE_MEDIA_TYPE_UNSPECIFIED
}

func (m *Intent_Message_MediaContent) GetMediaObjects() []*Intent_Message_MediaContent_ResponseMediaObject {
	if m != nil {
		return m.MediaObjects
	}
	return nil
}

// Response media object for media content card.
type Intent_Message_MediaContent_ResponseMediaObject struct {
	// Required. Name of media card.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Description of media card.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Image to show with the media card.
	//
	// Types that are valid to be assigned to Image:
	//	*Intent_Message_MediaContent_ResponseMediaObject_LargeImage
	//	*Intent_Message_MediaContent_ResponseMediaObject_Icon
	Image isIntent_Message_MediaContent_ResponseMediaObject_Image `protobuf_oneof:"image"`
	// Required. Url where the media is stored.
	ContentUrl           string   `protobuf:"bytes,5,opt,name=content_url,json=contentUrl,proto3" json:"content_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_MediaContent_ResponseMediaObject) Reset() {
	*m = Intent_Message_MediaContent_ResponseMediaObject{}
}
func (m *Intent_Message_MediaContent_ResponseMediaObject) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_MediaContent_ResponseMediaObject) ProtoMessage() {}
func (*Intent_Message_MediaContent_ResponseMediaObject) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 23, 0}
}

func (m *Intent_Message_MediaContent_ResponseMediaObject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_MediaContent_ResponseMediaObject.Unmarshal(m, b)
}
func (m *Intent_Message_MediaContent_ResponseMediaObject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_MediaContent_ResponseMediaObject.Marshal(b, m, deterministic)
}
func (m *Intent_Message_MediaContent_ResponseMediaObject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_MediaContent_ResponseMediaObject.Merge(m, src)
}
func (m *Intent_Message_MediaContent_ResponseMediaObject) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_MediaContent_ResponseMediaObject.Size(m)
}
func (m *Intent_Message_MediaContent_ResponseMediaObject) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_MediaContent_ResponseMediaObject.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_MediaContent_ResponseMediaObject proto.InternalMessageInfo

func (m *Intent_Message_MediaContent_ResponseMediaObject) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent_Message_MediaContent_ResponseMediaObject) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type isIntent_Message_MediaContent_ResponseMediaObject_Image interface {
	isIntent_Message_MediaContent_ResponseMediaObject_Image()
}

type Intent_Message_MediaContent_ResponseMediaObject_LargeImage struct {
	LargeImage *Intent_Message_Image `protobuf:"bytes,3,opt,name=large_image,json=largeImage,proto3,oneof"`
}

type Intent_Message_MediaContent_ResponseMediaObject_Icon struct {
	Icon *Intent_Message_Image `protobuf:"bytes,4,opt,name=icon,proto3,oneof"`
}

func (*Intent_Message_MediaContent_ResponseMediaObject_LargeImage) isIntent_Message_MediaContent_ResponseMediaObject_Image() {
}

func (*Intent_Message_MediaContent_ResponseMediaObject_Icon) isIntent_Message_MediaContent_ResponseMediaObject_Image() {
}

func (m *Intent_Message_MediaContent_ResponseMediaObject) GetImage() isIntent_Message_MediaContent_ResponseMediaObject_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Intent_Message_MediaContent_ResponseMediaObject) GetLargeImage() *Intent_Message_Image {
	if x, ok := m.GetImage().(*Intent_Message_MediaContent_ResponseMediaObject_LargeImage); ok {
		return x.LargeImage
	}
	return nil
}

func (m *Intent_Message_MediaContent_ResponseMediaObject) GetIcon() *Intent_Message_Image {
	if x, ok := m.GetImage().(*Intent_Message_MediaContent_ResponseMediaObject_Icon); ok {
		return x.Icon
	}
	return nil
}

func (m *Intent_Message_MediaContent_ResponseMediaObject) GetContentUrl() string {
	if m != nil {
		return m.ContentUrl
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Intent_Message_MediaContent_ResponseMediaObject) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Intent_Message_MediaContent_ResponseMediaObject_LargeImage)(nil),
		(*Intent_Message_MediaContent_ResponseMediaObject_Icon)(nil),
	}
}

// Browse Carousel Card for Actions on Google.
// https://developers.google.com/actions/assistant/responses#browsing_carousel
type Intent_Message_BrowseCarouselCard struct {
	// Required. List of items in the Browse Carousel Card. Minimum of two
	// items, maximum of ten.
	Items []*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// Optional. Settings for displaying the image. Applies to every image in
	// [items][google.cloud.dialogflow.v2beta1.Intent.Message.BrowseCarouselCard.items].
	ImageDisplayOptions  Intent_Message_BrowseCarouselCard_ImageDisplayOptions `protobuf:"varint,2,opt,name=image_display_options,json=imageDisplayOptions,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_BrowseCarouselCard_ImageDisplayOptions" json:"image_display_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_unrecognized     []byte                                                `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *Intent_Message_BrowseCarouselCard) Reset()         { *m = Intent_Message_BrowseCarouselCard{} }
func (m *Intent_Message_BrowseCarouselCard) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_BrowseCarouselCard) ProtoMessage()    {}
func (*Intent_Message_BrowseCarouselCard) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 24}
}

func (m *Intent_Message_BrowseCarouselCard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard.Unmarshal(m, b)
}
func (m *Intent_Message_BrowseCarouselCard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BrowseCarouselCard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BrowseCarouselCard.Merge(m, src)
}
func (m *Intent_Message_BrowseCarouselCard) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard.Size(m)
}
func (m *Intent_Message_BrowseCarouselCard) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BrowseCarouselCard.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BrowseCarouselCard proto.InternalMessageInfo

func (m *Intent_Message_BrowseCarouselCard) GetItems() []*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *Intent_Message_BrowseCarouselCard) GetImageDisplayOptions() Intent_Message_BrowseCarouselCard_ImageDisplayOptions {
	if m != nil {
		return m.ImageDisplayOptions
	}
	return Intent_Message_BrowseCarouselCard_IMAGE_DISPLAY_OPTIONS_UNSPECIFIED
}

// Browsing carousel tile
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem struct {
	// Required. Action to present to the user.
	OpenUriAction *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction `protobuf:"bytes,1,opt,name=open_uri_action,json=openUriAction,proto3" json:"open_uri_action,omitempty"`
	// Required. Title of the carousel item. Maximum of two lines of text.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. Description of the carousel item. Maximum of four lines of
	// text.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Hero image for the carousel item.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Optional. Text that appears at the bottom of the Browse Carousel
	// Card. Maximum of one line of text.
	Footer               string   `protobuf:"bytes,5,opt,name=footer,proto3" json:"footer,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) Reset() {
	*m = Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem{}
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) ProtoMessage() {}
func (*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 24, 0}
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem.Unmarshal(m, b)
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem.Merge(m, src)
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem.Size(m)
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem proto.InternalMessageInfo

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetOpenUriAction() *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction {
	if m != nil {
		return m.OpenUriAction
	}
	return nil
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetFooter() string {
	if m != nil {
		return m.Footer
	}
	return ""
}

// Actions on Google action to open a given url.
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction struct {
	// Required. URL
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Optional. Specifies the type of viewer that is used when opening
	// the URL. Defaults to opening via web browser.
	UrlTypeHint          Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint `protobuf:"varint,3,opt,name=url_type_hint,json=urlTypeHint,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint" json:"url_type_hint,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                                           `json:"-"`
	XXX_unrecognized     []byte                                                                             `json:"-"`
	XXX_sizecache        int32                                                                              `json:"-"`
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) Reset() {
	*m = Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction{}
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) ProtoMessage() {}
func (*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 24, 0, 0}
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction.Unmarshal(m, b)
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction.Merge(m, src)
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction.Size(m)
}
func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction proto.InternalMessageInfo

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) GetUrlTypeHint() Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint {
	if m != nil {
		return m.UrlTypeHint
	}
	return Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_URL_TYPE_HINT_UNSPECIFIED
}

// Table card for Actions on Google.
type Intent_Message_TableCard struct {
	// Required. Title of the card.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. Subtitle to the title.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// Optional. Image which should be displayed on the card.
	Image *Intent_Message_Image `protobuf:"bytes,3,opt,name=image,proto3" json:"image,omitempty"`
	// Optional. Display properties for the columns in this table.
	ColumnProperties []*Intent_Message_ColumnProperties `protobuf:"bytes,4,rep,name=column_properties,json=columnProperties,proto3" json:"column_properties,omitempty"`
	// Optional. Rows in this table of data.
	Rows []*Intent_Message_TableCardRow `protobuf:"bytes,5,rep,name=rows,proto3" json:"rows,omitempty"`
	// Optional. List of buttons for the card.
	Buttons              []*Intent_Message_BasicCard_Button `protobuf:"bytes,6,rep,name=buttons,proto3" json:"buttons,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *Intent_Message_TableCard) Reset()         { *m = Intent_Message_TableCard{} }
func (m *Intent_Message_TableCard) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TableCard) ProtoMessage()    {}
func (*Intent_Message_TableCard) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 25}
}

func (m *Intent_Message_TableCard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TableCard.Unmarshal(m, b)
}
func (m *Intent_Message_TableCard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TableCard.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TableCard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TableCard.Merge(m, src)
}
func (m *Intent_Message_TableCard) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TableCard.Size(m)
}
func (m *Intent_Message_TableCard) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TableCard.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TableCard proto.InternalMessageInfo

func (m *Intent_Message_TableCard) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_TableCard) GetSubtitle() string {
	if m != nil {
		return m.Subtitle
	}
	return ""
}

func (m *Intent_Message_TableCard) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Intent_Message_TableCard) GetColumnProperties() []*Intent_Message_ColumnProperties {
	if m != nil {
		return m.ColumnProperties
	}
	return nil
}

func (m *Intent_Message_TableCard) GetRows() []*Intent_Message_TableCardRow {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *Intent_Message_TableCard) GetButtons() []*Intent_Message_BasicCard_Button {
	if m != nil {
		return m.Buttons
	}
	return nil
}

// Column properties for [TableCard][google.cloud.dialogflow.v2beta1.Intent.Message.TableCard].
type Intent_Message_ColumnProperties struct {
	// Required. Column heading.
	Header string `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Optional. Defines text alignment for all cells in this column.
	HorizontalAlignment  Intent_Message_ColumnProperties_HorizontalAlignment `protobuf:"varint,2,opt,name=horizontal_alignment,json=horizontalAlignment,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_ColumnProperties_HorizontalAlignment" json:"horizontal_alignment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_unrecognized     []byte                                              `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *Intent_Message_ColumnProperties) Reset()         { *m = Intent_Message_ColumnProperties{} }
func (m *Intent_Message_ColumnProperties) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_ColumnProperties) ProtoMessage()    {}
func (*Intent_Message_ColumnProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 26}
}

func (m *Intent_Message_ColumnProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_ColumnProperties.Unmarshal(m, b)
}
func (m *Intent_Message_ColumnProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_ColumnProperties.Marshal(b, m, deterministic)
}
func (m *Intent_Message_ColumnProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_ColumnProperties.Merge(m, src)
}
func (m *Intent_Message_ColumnProperties) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_ColumnProperties.Size(m)
}
func (m *Intent_Message_ColumnProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_ColumnProperties.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_ColumnProperties proto.InternalMessageInfo

func (m *Intent_Message_ColumnProperties) GetHeader() string {
	if m != nil {
		return m.Header
	}
	return ""
}

func (m *Intent_Message_ColumnProperties) GetHorizontalAlignment() Intent_Message_ColumnProperties_HorizontalAlignment {
	if m != nil {
		return m.HorizontalAlignment
	}
	return Intent_Message_ColumnProperties_HORIZONTAL_ALIGNMENT_UNSPECIFIED
}

// Row of [TableCard][google.cloud.dialogflow.v2beta1.Intent.Message.TableCard].
type Intent_Message_TableCardRow struct {
	// Optional. List of cells that make up this row.
	Cells []*Intent_Message_TableCardCell `protobuf:"bytes,1,rep,name=cells,proto3" json:"cells,omitempty"`
	// Optional. Whether to add a visual divider after this row.
	DividerAfter         bool     `protobuf:"varint,2,opt,name=divider_after,json=dividerAfter,proto3" json:"divider_after,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_TableCardRow) Reset()         { *m = Intent_Message_TableCardRow{} }
func (m *Intent_Message_TableCardRow) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TableCardRow) ProtoMessage()    {}
func (*Intent_Message_TableCardRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 27}
}

func (m *Intent_Message_TableCardRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TableCardRow.Unmarshal(m, b)
}
func (m *Intent_Message_TableCardRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TableCardRow.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TableCardRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TableCardRow.Merge(m, src)
}
func (m *Intent_Message_TableCardRow) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TableCardRow.Size(m)
}
func (m *Intent_Message_TableCardRow) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TableCardRow.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TableCardRow proto.InternalMessageInfo

func (m *Intent_Message_TableCardRow) GetCells() []*Intent_Message_TableCardCell {
	if m != nil {
		return m.Cells
	}
	return nil
}

func (m *Intent_Message_TableCardRow) GetDividerAfter() bool {
	if m != nil {
		return m.DividerAfter
	}
	return false
}

// Cell of [TableCardRow][google.cloud.dialogflow.v2beta1.Intent.Message.TableCardRow].
type Intent_Message_TableCardCell struct {
	// Required. Text in this cell.
	Text                 string   `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_TableCardCell) Reset()         { *m = Intent_Message_TableCardCell{} }
func (m *Intent_Message_TableCardCell) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TableCardCell) ProtoMessage()    {}
func (*Intent_Message_TableCardCell) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 28}
}

func (m *Intent_Message_TableCardCell) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TableCardCell.Unmarshal(m, b)
}
func (m *Intent_Message_TableCardCell) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TableCardCell.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TableCardCell) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TableCardCell.Merge(m, src)
}
func (m *Intent_Message_TableCardCell) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TableCardCell.Size(m)
}
func (m *Intent_Message_TableCardCell) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TableCardCell.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TableCardCell proto.InternalMessageInfo

func (m *Intent_Message_TableCardCell) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

// Represents a single followup intent in the chain.
type Intent_FollowupIntentInfo struct {
	// The unique identifier of the followup intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	FollowupIntentName string `protobuf:"bytes,1,opt,name=followup_intent_name,json=followupIntentName,proto3" json:"followup_intent_name,omitempty"`
	// The unique identifier of the followup intent's parent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	ParentFollowupIntentName string   `protobuf:"bytes,2,opt,name=parent_followup_intent_name,json=parentFollowupIntentName,proto3" json:"parent_followup_intent_name,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *Intent_FollowupIntentInfo) Reset()         { *m = Intent_FollowupIntentInfo{} }
func (m *Intent_FollowupIntentInfo) String() string { return proto.CompactTextString(m) }
func (*Intent_FollowupIntentInfo) ProtoMessage()    {}
func (*Intent_FollowupIntentInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 3}
}

func (m *Intent_FollowupIntentInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_FollowupIntentInfo.Unmarshal(m, b)
}
func (m *Intent_FollowupIntentInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_FollowupIntentInfo.Marshal(b, m, deterministic)
}
func (m *Intent_FollowupIntentInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_FollowupIntentInfo.Merge(m, src)
}
func (m *Intent_FollowupIntentInfo) XXX_Size() int {
	return xxx_messageInfo_Intent_FollowupIntentInfo.Size(m)
}
func (m *Intent_FollowupIntentInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_FollowupIntentInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_FollowupIntentInfo proto.InternalMessageInfo

func (m *Intent_FollowupIntentInfo) GetFollowupIntentName() string {
	if m != nil {
		return m.FollowupIntentName
	}
	return ""
}

func (m *Intent_FollowupIntentInfo) GetParentFollowupIntentName() string {
	if m != nil {
		return m.ParentFollowupIntentName
	}
	return ""
}

// The request message for [Intents.ListIntents][google.cloud.dialogflow.v2beta1.Intents.ListIntents].
type ListIntentsRequest struct {
	// Required. The agent to list all intents from.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language to list training phrases, parameters and rich
	// messages for. If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,3,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIntentsRequest) Reset()         { *m = ListIntentsRequest{} }
func (m *ListIntentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListIntentsRequest) ProtoMessage()    {}
func (*ListIntentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{1}
}

func (m *ListIntentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIntentsRequest.Unmarshal(m, b)
}
func (m *ListIntentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIntentsRequest.Marshal(b, m, deterministic)
}
func (m *ListIntentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIntentsRequest.Merge(m, src)
}
func (m *ListIntentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListIntentsRequest.Size(m)
}
func (m *ListIntentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIntentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListIntentsRequest proto.InternalMessageInfo

func (m *ListIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListIntentsRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *ListIntentsRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

func (m *ListIntentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListIntentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Intents.ListIntents][google.cloud.dialogflow.v2beta1.Intents.ListIntents].
type ListIntentsResponse struct {
	// The list of agent intents. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIntentsResponse) Reset()         { *m = ListIntentsResponse{} }
func (m *ListIntentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListIntentsResponse) ProtoMessage()    {}
func (*ListIntentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{2}
}

func (m *ListIntentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIntentsResponse.Unmarshal(m, b)
}
func (m *ListIntentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIntentsResponse.Marshal(b, m, deterministic)
}
func (m *ListIntentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIntentsResponse.Merge(m, src)
}
func (m *ListIntentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListIntentsResponse.Size(m)
}
func (m *ListIntentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIntentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListIntentsResponse proto.InternalMessageInfo

func (m *ListIntentsResponse) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

func (m *ListIntentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [Intents.GetIntent][google.cloud.dialogflow.v2beta1.Intents.GetIntent].
type GetIntentRequest struct {
	// Required. The name of the intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The language to retrieve training phrases, parameters and rich
	// messages for. If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView           IntentView `protobuf:"varint,3,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetIntentRequest) Reset()         { *m = GetIntentRequest{} }
func (m *GetIntentRequest) String() string { return proto.CompactTextString(m) }
func (*GetIntentRequest) ProtoMessage()    {}
func (*GetIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{3}
}

func (m *GetIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetIntentRequest.Unmarshal(m, b)
}
func (m *GetIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetIntentRequest.Marshal(b, m, deterministic)
}
func (m *GetIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetIntentRequest.Merge(m, src)
}
func (m *GetIntentRequest) XXX_Size() int {
	return xxx_messageInfo_GetIntentRequest.Size(m)
}
func (m *GetIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetIntentRequest proto.InternalMessageInfo

func (m *GetIntentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *GetIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.CreateIntent][google.cloud.dialogflow.v2beta1.Intents.CreateIntent].
type CreateIntentRequest struct {
	// Required. The agent to create a intent for.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The intent to create.
	Intent *Intent `protobuf:"bytes,2,opt,name=intent,proto3" json:"intent,omitempty"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intent`. If not specified, the agent's default language is
	// used. [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView           IntentView `protobuf:"varint,4,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CreateIntentRequest) Reset()         { *m = CreateIntentRequest{} }
func (m *CreateIntentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateIntentRequest) ProtoMessage()    {}
func (*CreateIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{4}
}

func (m *CreateIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateIntentRequest.Unmarshal(m, b)
}
func (m *CreateIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateIntentRequest.Marshal(b, m, deterministic)
}
func (m *CreateIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateIntentRequest.Merge(m, src)
}
func (m *CreateIntentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateIntentRequest.Size(m)
}
func (m *CreateIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateIntentRequest proto.InternalMessageInfo

func (m *CreateIntentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *CreateIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *CreateIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.UpdateIntent][google.cloud.dialogflow.v2beta1.Intents.UpdateIntent].
type UpdateIntentRequest struct {
	// Required. The intent to update.
	Intent *Intent `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intent`. If not specified, the agent's default language is
	// used. [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView           IntentView `protobuf:"varint,4,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *UpdateIntentRequest) Reset()         { *m = UpdateIntentRequest{} }
func (m *UpdateIntentRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateIntentRequest) ProtoMessage()    {}
func (*UpdateIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{5}
}

func (m *UpdateIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateIntentRequest.Unmarshal(m, b)
}
func (m *UpdateIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateIntentRequest.Marshal(b, m, deterministic)
}
func (m *UpdateIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateIntentRequest.Merge(m, src)
}
func (m *UpdateIntentRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateIntentRequest.Size(m)
}
func (m *UpdateIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateIntentRequest proto.InternalMessageInfo

func (m *UpdateIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *UpdateIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *UpdateIntentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.DeleteIntent][google.cloud.dialogflow.v2beta1.Intents.DeleteIntent].
type DeleteIntentRequest struct {
	// Required. The name of the intent to delete. If this intent has direct or
	// indirect followup intents, we also delete them.
	//
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteIntentRequest) Reset()         { *m = DeleteIntentRequest{} }
func (m *DeleteIntentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteIntentRequest) ProtoMessage()    {}
func (*DeleteIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{6}
}

func (m *DeleteIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteIntentRequest.Unmarshal(m, b)
}
func (m *DeleteIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteIntentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteIntentRequest.Merge(m, src)
}
func (m *DeleteIntentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteIntentRequest.Size(m)
}
func (m *DeleteIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteIntentRequest proto.InternalMessageInfo

func (m *DeleteIntentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
type BatchUpdateIntentsRequest struct {
	// Required. The name of the agent to update or create intents in.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The source of the intent batch.
	//
	// For each intent in the batch:
	//
	// *    If `name` is specified, we update an existing intent.
	// *    If `name` is not specified, we create a new intent.
	//
	// Types that are valid to be assigned to IntentBatch:
	//	*BatchUpdateIntentsRequest_IntentBatchUri
	//	*BatchUpdateIntentsRequest_IntentBatchInline
	IntentBatch isBatchUpdateIntentsRequest_IntentBatch `protobuf_oneof:"intent_batch"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intents`. If not specified, the agent's default language is
	// used. [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView           IntentView `protobuf:"varint,6,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BatchUpdateIntentsRequest) Reset()         { *m = BatchUpdateIntentsRequest{} }
func (m *BatchUpdateIntentsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateIntentsRequest) ProtoMessage()    {}
func (*BatchUpdateIntentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{7}
}

func (m *BatchUpdateIntentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateIntentsRequest.Unmarshal(m, b)
}
func (m *BatchUpdateIntentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateIntentsRequest.Marshal(b, m, deterministic)
}
func (m *BatchUpdateIntentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateIntentsRequest.Merge(m, src)
}
func (m *BatchUpdateIntentsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateIntentsRequest.Size(m)
}
func (m *BatchUpdateIntentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateIntentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateIntentsRequest proto.InternalMessageInfo

func (m *BatchUpdateIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isBatchUpdateIntentsRequest_IntentBatch interface {
	isBatchUpdateIntentsRequest_IntentBatch()
}

type BatchUpdateIntentsRequest_IntentBatchUri struct {
	IntentBatchUri string `protobuf:"bytes,2,opt,name=intent_batch_uri,json=intentBatchUri,proto3,oneof"`
}

type BatchUpdateIntentsRequest_IntentBatchInline struct {
	IntentBatchInline *IntentBatch `protobuf:"bytes,3,opt,name=intent_batch_inline,json=intentBatchInline,proto3,oneof"`
}

func (*BatchUpdateIntentsRequest_IntentBatchUri) isBatchUpdateIntentsRequest_IntentBatch() {}

func (*BatchUpdateIntentsRequest_IntentBatchInline) isBatchUpdateIntentsRequest_IntentBatch() {}

func (m *BatchUpdateIntentsRequest) GetIntentBatch() isBatchUpdateIntentsRequest_IntentBatch {
	if m != nil {
		return m.IntentBatch
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetIntentBatchUri() string {
	if x, ok := m.GetIntentBatch().(*BatchUpdateIntentsRequest_IntentBatchUri); ok {
		return x.IntentBatchUri
	}
	return ""
}

func (m *BatchUpdateIntentsRequest) GetIntentBatchInline() *IntentBatch {
	if x, ok := m.GetIntentBatch().(*BatchUpdateIntentsRequest_IntentBatchInline); ok {
		return x.IntentBatchInline
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateIntentsRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BatchUpdateIntentsRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BatchUpdateIntentsRequest_IntentBatchUri)(nil),
		(*BatchUpdateIntentsRequest_IntentBatchInline)(nil),
	}
}

// The response message for [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
type BatchUpdateIntentsResponse struct {
	// The collection of updated or created intents.
	Intents              []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BatchUpdateIntentsResponse) Reset()         { *m = BatchUpdateIntentsResponse{} }
func (m *BatchUpdateIntentsResponse) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateIntentsResponse) ProtoMessage()    {}
func (*BatchUpdateIntentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{8}
}

func (m *BatchUpdateIntentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateIntentsResponse.Unmarshal(m, b)
}
func (m *BatchUpdateIntentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateIntentsResponse.Marshal(b, m, deterministic)
}
func (m *BatchUpdateIntentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateIntentsResponse.Merge(m, src)
}
func (m *BatchUpdateIntentsResponse) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateIntentsResponse.Size(m)
}
func (m *BatchUpdateIntentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateIntentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateIntentsResponse proto.InternalMessageInfo

func (m *BatchUpdateIntentsResponse) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

// The request message for [Intents.BatchDeleteIntents][google.cloud.dialogflow.v2beta1.Intents.BatchDeleteIntents].
type BatchDeleteIntentsRequest struct {
	// Required. The name of the agent to delete all entities types for. Format:
	// `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The collection of intents to delete. Only intent `name` must be
	// filled in.
	Intents              []*Intent `protobuf:"bytes,2,rep,name=intents,proto3" json:"intents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BatchDeleteIntentsRequest) Reset()         { *m = BatchDeleteIntentsRequest{} }
func (m *BatchDeleteIntentsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteIntentsRequest) ProtoMessage()    {}
func (*BatchDeleteIntentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{9}
}

func (m *BatchDeleteIntentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteIntentsRequest.Unmarshal(m, b)
}
func (m *BatchDeleteIntentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteIntentsRequest.Marshal(b, m, deterministic)
}
func (m *BatchDeleteIntentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteIntentsRequest.Merge(m, src)
}
func (m *BatchDeleteIntentsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteIntentsRequest.Size(m)
}
func (m *BatchDeleteIntentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteIntentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteIntentsRequest proto.InternalMessageInfo

func (m *BatchDeleteIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteIntentsRequest) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

// This message is a wrapper around a collection of intents.
type IntentBatch struct {
	// A collection of intents.
	Intents              []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *IntentBatch) Reset()         { *m = IntentBatch{} }
func (m *IntentBatch) String() string { return proto.CompactTextString(m) }
func (*IntentBatch) ProtoMessage()    {}
func (*IntentBatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{10}
}

func (m *IntentBatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntentBatch.Unmarshal(m, b)
}
func (m *IntentBatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntentBatch.Marshal(b, m, deterministic)
}
func (m *IntentBatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntentBatch.Merge(m, src)
}
func (m *IntentBatch) XXX_Size() int {
	return xxx_messageInfo_IntentBatch.Size(m)
}
func (m *IntentBatch) XXX_DiscardUnknown() {
	xxx_messageInfo_IntentBatch.DiscardUnknown(m)
}

var xxx_messageInfo_IntentBatch proto.InternalMessageInfo

func (m *IntentBatch) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.IntentView", IntentView_name, IntentView_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_WebhookState", Intent_WebhookState_name, Intent_WebhookState_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_TrainingPhrase_Type", Intent_TrainingPhrase_Type_name, Intent_TrainingPhrase_Type_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_Platform", Intent_Message_Platform_name, Intent_Message_Platform_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_RbmCarouselCard_CardWidth", Intent_Message_RbmCarouselCard_CardWidth_name, Intent_Message_RbmCarouselCard_CardWidth_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_RbmStandaloneCard_CardOrientation", Intent_Message_RbmStandaloneCard_CardOrientation_name, Intent_Message_RbmStandaloneCard_CardOrientation_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment", Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_name, Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_RbmCardContent_RbmMedia_Height", Intent_Message_RbmCardContent_RbmMedia_Height_name, Intent_Message_RbmCardContent_RbmMedia_Height_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_MediaContent_ResponseMediaType", Intent_Message_MediaContent_ResponseMediaType_name, Intent_Message_MediaContent_ResponseMediaType_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_BrowseCarouselCard_ImageDisplayOptions", Intent_Message_BrowseCarouselCard_ImageDisplayOptions_name, Intent_Message_BrowseCarouselCard_ImageDisplayOptions_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint", Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_name, Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_ColumnProperties_HorizontalAlignment", Intent_Message_ColumnProperties_HorizontalAlignment_name, Intent_Message_ColumnProperties_HorizontalAlignment_value)
	proto.RegisterType((*Intent)(nil), "google.cloud.dialogflow.v2beta1.Intent")
	proto.RegisterType((*Intent_TrainingPhrase)(nil), "google.cloud.dialogflow.v2beta1.Intent.TrainingPhrase")
	proto.RegisterType((*Intent_TrainingPhrase_Part)(nil), "google.cloud.dialogflow.v2beta1.Intent.TrainingPhrase.Part")
	proto.RegisterType((*Intent_Parameter)(nil), "google.cloud.dialogflow.v2beta1.Intent.Parameter")
	proto.RegisterType((*Intent_Message)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message")
	proto.RegisterType((*Intent_Message_Text)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Text")
	proto.RegisterType((*Intent_Message_Image)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Image")
	proto.RegisterType((*Intent_Message_QuickReplies)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.QuickReplies")
	proto.RegisterType((*Intent_Message_Card)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Card")
	proto.RegisterType((*Intent_Message_Card_Button)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Card.Button")
	proto.RegisterType((*Intent_Message_SimpleResponse)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SimpleResponse")
	proto.RegisterType((*Intent_Message_SimpleResponses)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SimpleResponses")
	proto.RegisterType((*Intent_Message_BasicCard)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard")
	proto.RegisterType((*Intent_Message_BasicCard_Button)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard.Button")
	proto.RegisterType((*Intent_Message_BasicCard_Button_OpenUriAction)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard.Button.OpenUriAction")
	proto.RegisterType((*Intent_Message_Suggestion)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Suggestion")
	proto.RegisterType((*Intent_Message_Suggestions)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Suggestions")
	proto.RegisterType((*Intent_Message_LinkOutSuggestion)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.LinkOutSuggestion")
	proto.RegisterType((*Intent_Message_ListSelect)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.ListSelect")
	proto.RegisterType((*Intent_Message_ListSelect_Item)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.ListSelect.Item")
	proto.RegisterType((*Intent_Message_CarouselSelect)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.CarouselSelect")
	proto.RegisterType((*Intent_Message_CarouselSelect_Item)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.CarouselSelect.Item")
	proto.RegisterType((*Intent_Message_SelectItemInfo)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SelectItemInfo")
	proto.RegisterType((*Intent_Message_TelephonyPlayAudio)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TelephonyPlayAudio")
	proto.RegisterType((*Intent_Message_TelephonySynthesizeSpeech)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TelephonySynthesizeSpeech")
	proto.RegisterType((*Intent_Message_TelephonyTransferCall)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TelephonyTransferCall")
	proto.RegisterType((*Intent_Message_RbmText)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmText")
	proto.RegisterType((*Intent_Message_RbmCarouselCard)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmCarouselCard")
	proto.RegisterType((*Intent_Message_RbmStandaloneCard)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmStandaloneCard")
	proto.RegisterType((*Intent_Message_RbmCardContent)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmCardContent")
	proto.RegisterType((*Intent_Message_RbmCardContent_RbmMedia)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmCardContent.RbmMedia")
	proto.RegisterType((*Intent_Message_RbmSuggestion)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmSuggestion")
	proto.RegisterType((*Intent_Message_RbmSuggestedReply)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmSuggestedReply")
	proto.RegisterType((*Intent_Message_RbmSuggestedAction)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmSuggestedAction")
	proto.RegisterType((*Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmSuggestedAction.RbmSuggestedActionDial")
	proto.RegisterType((*Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmSuggestedAction.RbmSuggestedActionOpenUri")
	proto.RegisterType((*Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.RbmSuggestedAction.RbmSuggestedActionShareLocation")
	proto.RegisterType((*Intent_Message_MediaContent)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.MediaContent")
	proto.RegisterType((*Intent_Message_MediaContent_ResponseMediaObject)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.MediaContent.ResponseMediaObject")
	proto.RegisterType((*Intent_Message_BrowseCarouselCard)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BrowseCarouselCard")
	proto.RegisterType((*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem")
	proto.RegisterType((*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction")
	proto.RegisterType((*Intent_Message_TableCard)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TableCard")
	proto.RegisterType((*Intent_Message_ColumnProperties)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.ColumnProperties")
	proto.RegisterType((*Intent_Message_TableCardRow)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TableCardRow")
	proto.RegisterType((*Intent_Message_TableCardCell)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TableCardCell")
	proto.RegisterType((*Intent_FollowupIntentInfo)(nil), "google.cloud.dialogflow.v2beta1.Intent.FollowupIntentInfo")
	proto.RegisterType((*ListIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.ListIntentsRequest")
	proto.RegisterType((*ListIntentsResponse)(nil), "google.cloud.dialogflow.v2beta1.ListIntentsResponse")
	proto.RegisterType((*GetIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.GetIntentRequest")
	proto.RegisterType((*CreateIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateIntentRequest")
	proto.RegisterType((*UpdateIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateIntentRequest")
	proto.RegisterType((*DeleteIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteIntentRequest")
	proto.RegisterType((*BatchUpdateIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest")
	proto.RegisterType((*BatchUpdateIntentsResponse)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse")
	proto.RegisterType((*BatchDeleteIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchDeleteIntentsRequest")
	proto.RegisterType((*IntentBatch)(nil), "google.cloud.dialogflow.v2beta1.IntentBatch")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/intent.proto", fileDescriptor_5bdb4dcc248bd417)
}

var fileDescriptor_5bdb4dcc248bd417 = []byte{
	// 4431 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5b, 0xdd, 0x6f, 0x23, 0xc9,
	0x71, 0xd7, 0x90, 0x94, 0x48, 0x16, 0x29, 0x8a, 0x6a, 0x69, 0x77, 0xa9, 0xb9, 0x73, 0x56, 0xc7,
	0xf5, 0xd9, 0x7b, 0x8a, 0x8f, 0xca, 0xe9, 0x1c, 0xfb, 0xbc, 0xeb, 0xdb, 0xf3, 0x90, 0xa2, 0x44,
	0x5a, 0x14, 0xc9, 0x1d, 0x52, 0xbb, 0xd6, 0xe2, 0x9c, 0xc1, 0x90, 0x6c, 0x89, 0x13, 0x0d, 0x67,
	0x78, 0x33, 0x4d, 0xe9, 0x74, 0x1f, 0x88, 0x91, 0x2f, 0x07, 0x3e, 0x04, 0x41, 0x10, 0xe4, 0x0b,
	0xc8, 0x43, 0x90, 0x17, 0x23, 0x79, 0xc9, 0x73, 0xf2, 0x1f, 0xc4, 0x48, 0x5e, 0xf2, 0x85, 0x00,
	0x79, 0x88, 0x0d, 0x04, 0x7e, 0x48, 0x9e, 0x03, 0x04, 0x48, 0x8c, 0x04, 0xfd, 0x31, 0x9c, 0xe1,
	0x87, 0x4e, 0x12, 0xa5, 0x33, 0x02, 0xe4, 0x6d, 0xba, 0xba, 0xbb, 0xaa, 0xab, 0xba, 0xba, 0xea,
	0x57, 0x3d, 0x33, 0xf0, 0xa5, 0x63, 0xdb, 0x3e, 0x36, 0xf1, 0x66, 0xdb, 0xb4, 0x07, 0x9d, 0xcd,
	0x8e, 0xa1, 0x9b, 0xf6, 0xf1, 0x91, 0x69, 0x9f, 0x6d, 0x9e, 0x6e, 0xb5, 0x30, 0xd1, 0xdf, 0xd8,
	0x34, 0x2c, 0x82, 0x2d, 0x92, 0xeb, 0x3b, 0x36, 0xb1, 0xd1, 0x7d, 0x3e, 0x3a, 0xc7, 0x46, 0xe7,
	0xfc, 0xd1, 0x39, 0x31, 0x5a, 0x7e, 0x59, 0xb0, 0xd3, 0xfb, 0xc6, 0xa6, 0x6e, 0x59, 0x36, 0xd1,
	0x89, 0x61, 0x5b, 0x2e, 0x9f, 0x2e, 0xdf, 0x0f, 0xf4, 0x1e, 0x19, 0xd8, 0xec, 0x68, 0x2d, 0xdc,
	0xd5, 0x4f, 0x0d, 0xdb, 0x11, 0x03, 0xd6, 0x02, 0x03, 0x1c, 0xec, 0xda, 0x03, 0xa7, 0x8d, 0x45,
	0xd7, 0xd6, 0x65, 0x0b, 0xd5, 0x07, 0x1d, 0xc3, 0xd6, 0xda, 0xb6, 0x75, 0x64, 0x1c, 0x8b, 0x39,
	0xaf, 0x5f, 0x36, 0xa7, 0x6d, 0x5b, 0x04, 0xbf, 0x2f, 0xb4, 0x93, 0x1f, 0x88, 0xe1, 0xa6, 0x6d,
	0x1d, 0x3b, 0x03, 0xcb, 0x32, 0xac, 0xe3, 0x4d, 0xbb, 0x8f, 0x9d, 0x11, 0x1d, 0x7e, 0x46, 0x0c,
	0x62, 0xad, 0xd6, 0xe0, 0x68, 0xb3, 0x33, 0xe0, 0x03, 0x44, 0xff, 0x4b, 0xe3, 0xfd, 0xb8, 0xd7,
	0x27, 0xe7, 0xa2, 0x73, 0x7d, 0xbc, 0x93, 0x5b, 0xa1, 0xa7, 0xbb, 0x27, 0x62, 0xc4, 0xcb, 0xe3,
	0x23, 0x5c, 0xe2, 0x0c, 0xda, 0xde, 0x0a, 0xef, 0x05, 0xec, 0xd3, 0x36, 0x8d, 0xe1, 0xc6, 0x64,
	0x7f, 0xef, 0x5d, 0x58, 0x28, 0xb3, 0x9d, 0x42, 0x08, 0x22, 0x96, 0xde, 0xc3, 0x19, 0x69, 0x5d,
	0x7a, 0x18, 0x57, 0xd9, 0x33, 0x7a, 0x05, 0x92, 0x1d, 0xc3, 0xed, 0x9b, 0xfa, 0xb9, 0xc6, 0xfa,
	0x42, 0xac, 0x2f, 0x21, 0x68, 0x55, 0x3a, 0xe4, 0x10, 0x16, 0xcf, 0x70, 0xab, 0x6b, 0xdb, 0x27,
	0x9a, 0x4b, 0x74, 0x82, 0x33, 0x0b, 0xeb, 0xd2, 0xc3, 0xd4, 0xd6, 0x97, 0x73, 0x97, 0x6c, 0x79,
	0x8e, 0x8b, 0xcd, 0x3d, 0xe7, 0x93, 0x1b, 0x74, 0xae, 0x9a, 0x3c, 0x0b, 0xb4, 0x90, 0x0c, 0xb1,
	0xbe, 0x63, 0xd8, 0x8e, 0x41, 0xce, 0x33, 0xe1, 0x75, 0xe9, 0xe1, 0xbc, 0x3a, 0x6c, 0xa3, 0xfb,
	0x90, 0x30, 0x5c, 0xed, 0x48, 0x37, 0xcd, 0x96, 0xde, 0x3e, 0xc9, 0x44, 0xd6, 0xa5, 0x87, 0x31,
	0x15, 0x0c, 0x77, 0x47, 0x50, 0xd0, 0x2b, 0x00, 0x3d, 0x53, 0xc3, 0x96, 0xde, 0x32, 0x71, 0x27,
	0x33, 0x4f, 0xfb, 0xf3, 0xa1, 0x8c, 0xa4, 0xc6, 0x7b, 0x66, 0x91, 0x13, 0x29, 0x8f, 0x9e, 0xa9,
	0x75, 0x0c, 0x97, 0x8f, 0x59, 0xe1, 0x3c, 0x7a, 0xe6, 0xb6, 0xa0, 0xa0, 0x2f, 0xc2, 0x12, 0xb6,
	0x3a, 0x1a, 0x75, 0x65, 0x47, 0x6f, 0xd3, 0xcd, 0xca, 0xdc, 0x61, 0x83, 0x52, 0xd8, 0xea, 0x94,
	0x7d, 0x2a, 0xca, 0xc1, 0x8a, 0x61, 0xf5, 0x07, 0x44, 0x13, 0x8e, 0xc1, 0xac, 0xe5, 0x66, 0xa2,
	0xeb, 0xe1, 0x87, 0x71, 0x75, 0x99, 0x75, 0x15, 0x78, 0x0f, 0xb5, 0x99, 0x8b, 0xee, 0xc2, 0x02,
	0x3e, 0xc5, 0x16, 0x71, 0x33, 0x31, 0x36, 0x44, 0xb4, 0x90, 0x0e, 0x69, 0xe2, 0xe8, 0x06, 0xf5,
	0x20, 0xad, 0xdf, 0x75, 0x74, 0x17, 0xbb, 0x99, 0xf8, 0x7a, 0xf8, 0x61, 0x62, 0xeb, 0x2b, 0x57,
	0xb5, 0x67, 0x53, 0xcc, 0xaf, 0xb3, 0xe9, 0xea, 0x12, 0x19, 0x69, 0x33, 0xd1, 0x42, 0x15, 0x60,
	0x9b, 0x29, 0x5a, 0xe8, 0x29, 0x2c, 0xd9, 0x03, 0x12, 0xd0, 0xc1, 0xcd, 0x24, 0x98, 0xe4, 0x87,
	0x97, 0x4a, 0x16, 0xaa, 0xa9, 0x29, 0xce, 0x40, 0x34, 0x5d, 0xf4, 0x2a, 0xa4, 0x1c, 0xec, 0xe2,
	0x00, 0xc7, 0x24, 0xb3, 0xde, 0x22, 0xa3, 0x0e, 0x87, 0x3d, 0x05, 0xe8, 0xeb, 0x8e, 0xde, 0xc3,
	0x04, 0x3b, 0x6e, 0x66, 0x91, 0x09, 0x7d, 0xe3, 0xaa, 0xea, 0xd6, 0xbd, 0x99, 0x6a, 0x80, 0x09,
	0xda, 0x83, 0x58, 0x0f, 0xbb, 0xae, 0x7e, 0x8c, 0xdd, 0x4c, 0x8a, 0x31, 0xdc, 0xbc, 0x2a, 0xc3,
	0x7d, 0x3e, 0x4f, 0x1d, 0x32, 0x40, 0xa7, 0x20, 0x77, 0xf0, 0x91, 0x3e, 0x30, 0x89, 0xe6, 0x60,
	0xb7, 0x6f, 0x5b, 0x2e, 0xd6, 0xfa, 0xa6, 0x4e, 0x8e, 0x6c, 0xa7, 0xe7, 0x66, 0x96, 0xd6, 0xc3,
	0x0f, 0x53, 0x5b, 0x6f, 0x5d, 0x93, 0x7d, 0xae, 0x2e, 0x18, 0xa8, 0x19, 0xc1, 0x5b, 0x15, 0xac,
	0xbd, 0x0e, 0x17, 0x7d, 0x0d, 0xd6, 0x1c, 0xdb, 0x26, 0xda, 0x91, 0x6d, 0x9a, 0xf6, 0xd9, 0xa0,
	0xaf, 0xf1, 0x90, 0xca, 0x4f, 0x62, 0x9a, 0x6d, 0xde, 0x5d, 0x3a, 0x60, 0x47, 0xf4, 0x73, 0x09,
	0xec, 0x50, 0xbe, 0x0d, 0x2f, 0xf5, 0x75, 0x87, 0x0e, 0x9e, 0x3a, 0x79, 0x99, 0x4d, 0xce, 0xf0,
	0x21, 0x53, 0xa6, 0x9b, 0xb0, 0x3a, 0x3e, 0xcf, 0xb0, 0x8e, 0xec, 0x0c, 0x62, 0xa6, 0x7c, 0x74,
	0x55, 0x5d, 0x47, 0x39, 0x97, 0xad, 0x23, 0x5b, 0x45, 0x47, 0x13, 0x34, 0xf9, 0xfb, 0x61, 0x48,
	0x8d, 0x7a, 0xed, 0xd4, 0x58, 0x54, 0x83, 0x08, 0x39, 0xef, 0xf3, 0x18, 0x94, 0xda, 0x7a, 0x3c,
	0xdb, 0x79, 0xc8, 0x35, 0xcf, 0xfb, 0x58, 0x65, 0x8c, 0xd0, 0x53, 0x98, 0xef, 0xeb, 0x0e, 0x71,
	0x33, 0x61, 0xa6, 0xd6, 0xac, 0x1c, 0xeb, 0xba, 0x43, 0x54, 0xce, 0x09, 0x6d, 0xc0, 0x32, 0x31,
	0x7a, 0xd8, 0xd5, 0xf4, 0x4e, 0x07, 0x77, 0xb4, 0xb6, 0x3d, 0xb0, 0x08, 0x8b, 0x4d, 0xf3, 0xea,
	0x12, 0xeb, 0x50, 0x28, 0xbd, 0x40, 0xc9, 0x32, 0x81, 0x08, 0x9d, 0x4a, 0x75, 0xa5, 0xe7, 0xc0,
	0xd3, 0x95, 0x3e, 0xd3, 0xc8, 0x84, 0x2d, 0x62, 0x90, 0x73, 0x6d, 0xa8, 0x72, 0x5c, 0x05, 0x4e,
	0xa2, 0x1a, 0xa0, 0x55, 0x98, 0xd7, 0x4d, 0x43, 0x77, 0x59, 0x5c, 0x8c, 0xab, 0xbc, 0x41, 0xc3,
	0xf5, 0xc0, 0xc5, 0x8e, 0xd6, 0xc1, 0x47, 0x86, 0x85, 0x3b, 0x22, 0x2a, 0x26, 0x28, 0x6d, 0x9b,
	0x93, 0xb2, 0x8f, 0x21, 0x22, 0x18, 0xa4, 0x9b, 0x87, 0xf5, 0xa2, 0x76, 0x50, 0x6d, 0xd4, 0x8b,
	0x85, 0xf2, 0x4e, 0xb9, 0xb8, 0x9d, 0x9e, 0x43, 0x09, 0x88, 0x16, 0xbf, 0xa5, 0xec, 0xd7, 0x2b,
	0xc5, 0xb4, 0x84, 0xd2, 0x10, 0x6b, 0x16, 0xf7, 0xeb, 0x15, 0xa5, 0x59, 0x4c, 0x87, 0xe4, 0x50,
	0x4c, 0x92, 0xbf, 0x1b, 0x82, 0xf8, 0xf0, 0xc0, 0xcd, 0x9a, 0x30, 0x56, 0x61, 0xfe, 0x54, 0x37,
	0x07, 0xd8, 0x5b, 0x3a, 0x6b, 0xa0, 0x07, 0xb0, 0xe8, 0x1d, 0x32, 0xde, 0x1b, 0x61, 0xbd, 0x49,
	0x41, 0x7c, 0xc6, 0x06, 0x7d, 0x15, 0x32, 0x01, 0xb3, 0x68, 0x23, 0x92, 0xe6, 0xd9, 0xf8, 0x3b,
	0xbe, 0x8d, 0xb6, 0x03, 0x32, 0x5f, 0x86, 0x78, 0x4f, 0xb7, 0x3a, 0x3a, 0xb1, 0x9d, 0x73, 0x96,
	0xa0, 0x62, 0xaa, 0x4f, 0x40, 0x19, 0x88, 0xf6, 0x1d, 0xbb, 0xd7, 0x27, 0x5e, 0xc4, 0xf6, 0x9a,
	0xe8, 0x1e, 0x44, 0x0d, 0x57, 0x33, 0x0d, 0x97, 0x64, 0x62, 0x6c, 0xd6, 0x82, 0xe1, 0x56, 0x0c,
	0x97, 0xc8, 0x7f, 0xfd, 0x4d, 0x88, 0x8a, 0xa3, 0x8c, 0xbe, 0x19, 0xd8, 0xc0, 0xc4, 0xd5, 0x13,
	0x9f, 0x17, 0x09, 0x9a, 0xf8, 0x7d, 0x52, 0x9a, 0x13, 0x1b, 0xbf, 0x0f, 0xf3, 0x46, 0x4f, 0x3f,
	0xe6, 0x86, 0x4b, 0x6c, 0xfd, 0xfc, 0x75, 0x99, 0x95, 0xe9, 0xe4, 0xd2, 0x9c, 0xca, 0xb9, 0xa0,
	0x36, 0x2c, 0xbe, 0x37, 0x30, 0xda, 0x27, 0x9a, 0x83, 0xfb, 0xa6, 0x81, 0xb9, 0xbb, 0x24, 0xb6,
	0xbe, 0x7e, 0x5d, 0xb6, 0x4f, 0x29, 0x13, 0x95, 0xf3, 0x28, 0xcd, 0xa9, 0xc9, 0xf7, 0x02, 0x6d,
	0xaa, 0x7f, 0x5b, 0x77, 0xb8, 0xb7, 0xcd, 0xa0, 0x7f, 0x41, 0x77, 0x3a, 0x54, 0x7f, 0xca, 0x03,
	0xbd, 0x09, 0xd1, 0xbe, 0x7e, 0x6e, 0xda, 0x3a, 0x4f, 0xd9, 0x89, 0xad, 0x7b, 0x1e, 0x3b, 0x0f,
	0xd8, 0xe4, 0x1a, 0x0c, 0xd8, 0x94, 0xe6, 0x54, 0x6f, 0x24, 0x32, 0x21, 0xed, 0x1a, 0xbd, 0xbe,
	0x89, 0x87, 0xf1, 0x99, 0x6e, 0x24, 0x9d, 0xfd, 0xce, 0x75, 0x17, 0xd3, 0x60, 0x7c, 0xbc, 0x58,
	0x4c, 0x75, 0x5d, 0x72, 0x47, 0x49, 0xe8, 0x05, 0x40, 0x4b, 0x77, 0x8d, 0xb6, 0xc6, 0x94, 0x8e,
	0x31, 0x39, 0x5f, 0xbb, 0xae, 0x9c, 0x3c, 0xe5, 0x20, 0x34, 0x8f, 0xb7, 0xbc, 0x06, 0xd2, 0x20,
	0xe1, 0x0e, 0x8e, 0x8f, 0xb1, 0xcb, 0x90, 0x63, 0x26, 0xce, 0x98, 0x3f, 0xbe, 0xb6, 0x12, 0x3e,
	0x8b, 0xd2, 0x9c, 0x1a, 0xe4, 0x88, 0x5c, 0x58, 0x31, 0x0d, 0xeb, 0x44, 0xb3, 0x07, 0x44, 0xf3,
	0xe9, 0x0c, 0x0a, 0x24, 0xb6, 0x94, 0xeb, 0x0a, 0xaa, 0x18, 0xd6, 0x49, 0x6d, 0x40, 0x7c, 0x79,
	0xa5, 0x39, 0x75, 0xd9, 0x1c, 0x27, 0xa2, 0x6f, 0x43, 0x82, 0x1e, 0x21, 0xcd, 0xc5, 0x26, 0x6e,
	0x93, 0x4c, 0x82, 0x09, 0x7b, 0x74, 0x7d, 0x61, 0x2e, 0x69, 0x30, 0x0e, 0xa5, 0x39, 0x15, 0xcc,
	0x61, 0x0b, 0x19, 0xb0, 0xd4, 0xd6, 0x1d, 0x7b, 0xe0, 0x62, 0xd3, 0x13, 0x91, 0x64, 0x22, 0x9e,
	0xcc, 0xe0, 0x8a, 0x8c, 0xcd, 0x50, 0x4c, 0xaa, 0x3d, 0x42, 0x41, 0xa7, 0xb0, 0x4a, 0xb0, 0x89,
	0xfb, 0x5d, 0xdb, 0x3a, 0xd7, 0x58, 0xec, 0x61, 0xd5, 0x43, 0x66, 0x91, 0xc9, 0xcb, 0x5f, 0xff,
	0xe8, 0x0b, 0x5e, 0x75, 0x53, 0x3f, 0x57, 0x28, 0xa7, 0xd2, 0x9c, 0x8a, 0xc8, 0x04, 0x15, 0x7d,
	0x22, 0xc1, 0x4b, 0xbe, 0x60, 0xf7, 0xdc, 0x22, 0x5d, 0xec, 0x1a, 0x1f, 0x60, 0xcd, 0xed, 0x63,
	0xdc, 0xee, 0x66, 0x52, 0x4c, 0x7e, 0x79, 0x66, 0xf9, 0x8d, 0x21, 0xc7, 0x06, 0x63, 0x58, 0x9a,
	0x53, 0xd7, 0xc8, 0x45, 0x9d, 0xe8, 0x97, 0xe0, 0x9e, 0xbf, 0x18, 0xe2, 0xe8, 0x96, 0x7b, 0x84,
	0x1d, 0xad, 0xad, 0x9b, 0x66, 0x66, 0x89, 0x2d, 0xa4, 0x38, 0xf3, 0x42, 0x9a, 0x82, 0x5b, 0x41,
	0x37, 0xcd, 0xd2, 0x9c, 0x7a, 0x87, 0x4c, 0xeb, 0x40, 0x4d, 0x88, 0x39, 0xad, 0x9e, 0xc6, 0xa2,
	0x2e, 0x62, 0x12, 0xbf, 0x7a, 0x5d, 0x89, 0x6a, 0xab, 0x27, 0x02, 0x6f, 0xd4, 0xe1, 0x8f, 0xe8,
	0x23, 0xc8, 0x50, 0xae, 0x2e, 0xa1, 0x89, 0xc1, 0xb4, 0x2d, 0xac, 0x39, 0x46, 0xbb, 0xcb, 0x8f,
	0xf9, 0xca, 0x6c, 0x07, 0x44, 0x6d, 0xf5, 0x1a, 0x43, 0x76, 0xe2, 0xb8, 0xdf, 0x71, 0x82, 0x44,
	0xd5, 0x68, 0x77, 0xd9, 0xd1, 0x3f, 0x85, 0xbb, 0x54, 0xfa, 0xd0, 0x93, 0x7d, 0xd9, 0xab, 0xb3,
	0x85, 0x32, 0xb5, 0xd5, 0xf3, 0xfc, 0x59, 0x48, 0x5e, 0x71, 0x7c, 0x52, 0x40, 0xee, 0x6a, 0xcb,
	0xb1, 0xcf, 0x5c, 0xec, 0x8b, 0x66, 0x52, 0xef, 0xce, 0xe6, 0xd2, 0x79, 0xc6, 0x6b, 0x4c, 0x30,
	0x6a, 0x4d, 0x50, 0x69, 0x18, 0x25, 0xb4, 0xca, 0xe2, 0xd2, 0xee, 0xcd, 0x16, 0x46, 0x9b, 0x94,
	0x83, 0x17, 0x46, 0x89, 0xd7, 0xa0, 0x69, 0xaf, 0x87, 0x3b, 0x86, 0xce, 0x0b, 0x0f, 0x8b, 0x64,
	0x32, 0xb3, 0xa5, 0xbd, 0x7d, 0xca, 0xa4, 0xc0, 0x79, 0xd0, 0xb4, 0xd7, 0x0b, 0xb4, 0xa9, 0x13,
	0x7a, 0x55, 0x80, 0xa8, 0x79, 0x67, 0x2f, 0x02, 0x86, 0x9c, 0x64, 0x19, 0x22, 0xcc, 0x19, 0x7d,
	0x54, 0x18, 0xf6, 0x50, 0xa1, 0xdc, 0x80, 0x79, 0x96, 0xdf, 0xd1, 0x4b, 0x10, 0x67, 0xf9, 0x5d,
	0x1b, 0x38, 0x86, 0x80, 0x5f, 0x31, 0x46, 0x38, 0x70, 0x0c, 0xf4, 0x3a, 0x20, 0xbd, 0xdd, 0xc6,
	0xae, 0x6b, 0xb4, 0x0c, 0x93, 0x61, 0x25, 0xca, 0x87, 0x03, 0xb1, 0xe5, 0x91, 0x1e, 0x2a, 0x48,
	0x2e, 0x43, 0x32, 0x98, 0xdd, 0x29, 0x3c, 0x23, 0x06, 0x31, 0x3d, 0x58, 0xc7, 0x1b, 0x14, 0x9e,
	0x8d, 0x02, 0x89, 0x10, 0x5b, 0xd7, 0x08, 0x10, 0x90, 0x7f, 0x2c, 0x41, 0x84, 0xd9, 0x7f, 0x3a,
	0x0f, 0x19, 0x62, 0xee, 0xa0, 0xc5, 0x3b, 0xf8, 0x72, 0x86, 0xed, 0x51, 0x8d, 0xc2, 0x63, 0x1a,
	0x1d, 0x40, 0xb4, 0x35, 0x20, 0x84, 0x66, 0xc4, 0xc8, 0xf5, 0xa0, 0x7a, 0x10, 0x63, 0xe4, 0xf2,
	0x8c, 0x87, 0xea, 0xf1, 0x92, 0xdf, 0x82, 0x05, 0x4e, 0x9a, 0x0a, 0xc1, 0x65, 0x88, 0xf5, 0x6d,
	0x97, 0xb0, 0xdb, 0x05, 0xb1, 0x5a, 0xaf, 0x2d, 0xf7, 0x20, 0x35, 0x0a, 0x14, 0xd0, 0xe7, 0x21,
	0xc5, 0xea, 0x7e, 0x62, 0x7b, 0x21, 0x99, 0xf3, 0x4a, 0x52, 0x6a, 0xd3, 0x16, 0x81, 0x13, 0x41,
	0xc4, 0x75, 0x7b, 0xa6, 0xe0, 0xc7, 0x9e, 0x83, 0x88, 0x99, 0xad, 0x21, 0x3c, 0x82, 0x98, 0xd9,
	0x16, 0x7d, 0x04, 0x4b, 0x63, 0xb8, 0x04, 0x19, 0x53, 0x20, 0x8f, 0xc4, 0x6c, 0xf3, 0xe4, 0x66,
	0x90, 0x67, 0x02, 0xef, 0xc8, 0x7f, 0x15, 0x86, 0xf8, 0x10, 0xae, 0xcc, 0xb0, 0xb5, 0xaf, 0x42,
	0x8a, 0x7a, 0xb6, 0x4e, 0x08, 0xee, 0x04, 0x55, 0x5c, 0x1c, 0x52, 0x99, 0xc3, 0xef, 0x79, 0xc8,
	0x37, 0x72, 0x03, 0xe4, 0xeb, 0xe1, 0xde, 0x17, 0xbe, 0xc7, 0xcc, 0x33, 0xab, 0x7c, 0x63, 0x66,
	0x80, 0x36, 0xe1, 0x36, 0x7f, 0x21, 0x0d, 0xfd, 0x66, 0xba, 0x31, 0x4e, 0x61, 0xc9, 0xee, 0x63,
	0x8b, 0xba, 0xb2, 0x26, 0xae, 0x5a, 0x38, 0x9a, 0xaf, 0xde, 0x74, 0x11, 0xb9, 0x5a, 0x1f, 0x5b,
	0x07, 0x8e, 0xa1, 0x30, 0xae, 0xea, 0xa2, 0x1d, 0x6c, 0xca, 0xaf, 0xc0, 0xe2, 0x48, 0x3f, 0x4a,
	0x43, 0xd8, 0x0f, 0x10, 0xf4, 0x51, 0xce, 0x02, 0x04, 0x70, 0xd9, 0xd4, 0xe5, 0xcb, 0x27, 0x90,
	0x08, 0x00, 0x48, 0xf4, 0xee, 0x28, 0x24, 0x95, 0xae, 0x77, 0x05, 0x30, 0x09, 0x49, 0x47, 0xf0,
	0xa8, 0x5c, 0x87, 0xe5, 0x09, 0x10, 0x89, 0x5e, 0x83, 0x74, 0x87, 0x3e, 0x5a, 0xec, 0x7e, 0x54,
	0x0b, 0x14, 0x99, 0x4b, 0x01, 0x3a, 0x2b, 0xec, 0x84, 0x8a, 0x21, 0x5f, 0xc5, 0xff, 0x0e, 0x01,
	0xf8, 0x50, 0xf1, 0x82, 0x2d, 0x3a, 0x80, 0x79, 0x83, 0xe0, 0x1e, 0x0f, 0x63, 0x33, 0xe4, 0x56,
	0x5f, 0x40, 0xae, 0x4c, 0x70, 0x4f, 0xe5, 0xdc, 0xd0, 0xfd, 0xc0, 0x31, 0x60, 0x4e, 0x9e, 0x0f,
	0xff, 0x50, 0x91, 0xfc, 0xb3, 0x20, 0xff, 0x8b, 0x04, 0x11, 0x3a, 0x01, 0xa9, 0x10, 0x61, 0x37,
	0x2a, 0xd2, 0x6c, 0x40, 0x95, 0xcb, 0xa6, 0x9c, 0xd8, 0xad, 0x0a, 0xe3, 0xe5, 0xab, 0x1a, 0x0a,
	0xaa, 0xba, 0x0e, 0x89, 0x0e, 0x76, 0xdb, 0x8e, 0xd1, 0x67, 0x9e, 0xe8, 0x85, 0x17, 0x9f, 0x74,
	0xab, 0x27, 0x4f, 0xfe, 0x9b, 0x10, 0xa4, 0x46, 0x61, 0x34, 0x3a, 0xf4, 0x8c, 0xcd, 0x7d, 0xa7,
	0x70, 0x33, 0x54, 0x1e, 0x34, 0xf8, 0xff, 0x03, 0x7b, 0x3e, 0x81, 0xd4, 0xe8, 0xe2, 0xa8, 0xcb,
	0x9f, 0xe0, 0x73, 0xef, 0x54, 0x9f, 0xe0, 0x73, 0x16, 0x7d, 0xcf, 0x2d, 0xdb, 0x3a, 0xef, 0x79,
	0x79, 0x79, 0xd8, 0x96, 0xdf, 0x00, 0x34, 0x59, 0x65, 0xd0, 0x74, 0xcb, 0x5f, 0x7b, 0x04, 0x00,
	0x04, 0x23, 0x1c, 0x38, 0x86, 0xfc, 0x14, 0xd6, 0x2e, 0x2c, 0x0c, 0xd0, 0x6a, 0x30, 0x55, 0x0e,
	0xaf, 0x2d, 0x56, 0x83, 0x89, 0x8d, 0x52, 0x69, 0x2b, 0x1f, 0x83, 0x05, 0xfe, 0x2a, 0x46, 0x7e,
	0x04, 0x77, 0xa6, 0x42, 0x7c, 0x9a, 0xfd, 0x28, 0x11, 0x6b, 0xd6, 0xa0, 0xd7, 0xc2, 0x8e, 0x58,
	0x4b, 0x82, 0xd1, 0xaa, 0x8c, 0x24, 0xff, 0x8a, 0x04, 0x51, 0x81, 0xd6, 0xa7, 0x26, 0xea, 0x0e,
	0xa4, 0x18, 0x6c, 0xf7, 0xab, 0x59, 0x7e, 0xa8, 0xdf, 0x9e, 0x05, 0xac, 0xfb, 0x61, 0x6a, 0xd1,
	0x09, 0x36, 0xe5, 0x3f, 0x0e, 0xc1, 0xd2, 0x18, 0xa2, 0x46, 0x5d, 0x00, 0x0a, 0x5e, 0xb5, 0x33,
	0xa3, 0x43, 0x78, 0xc2, 0x4f, 0x5d, 0xbf, 0x06, 0x1b, 0x63, 0xca, 0xa0, 0xca, 0x73, 0xca, 0x50,
	0x8d, 0xb7, 0xbd, 0x47, 0x0a, 0x68, 0x99, 0x24, 0x81, 0x67, 0xbd, 0xb8, 0xf5, 0x64, 0x36, 0x61,
	0x1d, 0x01, 0x61, 0xd5, 0x64, 0xdb, 0x6f, 0xb8, 0xd9, 0x27, 0x10, 0x1f, 0x0a, 0x47, 0x32, 0xdc,
	0x2d, 0x28, 0xea, 0xb6, 0xf6, 0xbc, 0xbc, 0xdd, 0x2c, 0x8d, 0xdd, 0x12, 0xc6, 0x61, 0xbe, 0xb1,
	0xaf, 0x54, 0x2a, 0x69, 0x09, 0x01, 0x2c, 0xec, 0x17, 0xb7, 0xcb, 0x07, 0xfb, 0xe9, 0x90, 0xfc,
	0x97, 0x11, 0x58, 0x9e, 0x28, 0x78, 0xd0, 0x47, 0x90, 0x66, 0x4b, 0xb7, 0x1d, 0x03, 0x5b, 0xfc,
	0xb5, 0x9e, 0x30, 0xd5, 0xd3, 0x1b, 0x57, 0x53, 0xcc, 0x58, 0x35, 0x9f, 0xb1, 0xba, 0xd4, 0x1e,
	0x25, 0xa0, 0xdf, 0x95, 0x60, 0x8d, 0x74, 0x07, 0xbd, 0x96, 0xa5, 0x1b, 0xa6, 0xc6, 0x21, 0xa6,
	0x6e, 0x1a, 0xc7, 0x56, 0x8f, 0x96, 0x05, 0xfc, 0x2a, 0xf9, 0xf0, 0xe6, 0xeb, 0x68, 0x7a, 0x22,
	0xd8, 0xd9, 0x55, 0x3c, 0x01, 0xea, 0x3d, 0x32, 0xbd, 0x03, 0xe9, 0x90, 0x0c, 0x6e, 0xa8, 0xb8,
	0x97, 0xbb, 0xe9, 0x7e, 0x26, 0x02, 0xfb, 0x99, 0x7d, 0x0a, 0x4b, 0x63, 0xe6, 0x41, 0xeb, 0xf0,
	0x32, 0xdb, 0xd4, 0x9a, 0x5a, 0x2e, 0x56, 0x9b, 0x4a, 0xb3, 0x5c, 0xab, 0x8e, 0x6d, 0x6d, 0x0a,
	0xa0, 0x54, 0x53, 0xcb, 0x2f, 0x6a, 0xd5, 0xa6, 0x42, 0xf7, 0x37, 0x09, 0xb1, 0x67, 0x45, 0xb5,
	0x59, 0x2e, 0x28, 0x95, 0x74, 0x28, 0x7b, 0x08, 0xf7, 0x2e, 0xd0, 0x14, 0xbd, 0x06, 0xaf, 0x36,
	0x4b, 0x07, 0xfb, 0xf9, 0xaa, 0x52, 0xae, 0x68, 0xe5, 0x7d, 0x65, 0xb7, 0xa8, 0x29, 0x95, 0xf2,
	0x6e, 0x75, 0xbf, 0x58, 0x6d, 0x8e, 0xc9, 0x88, 0x41, 0xa4, 0x52, 0xdc, 0x69, 0xa6, 0x25, 0xea,
	0x48, 0x6a, 0x79, 0xb7, 0xd4, 0x4c, 0x87, 0xe4, 0xef, 0x44, 0x20, 0x35, 0xaa, 0xcd, 0x05, 0xa9,
	0x7b, 0x2c, 0xfe, 0x86, 0x26, 0xe3, 0xef, 0xb7, 0x61, 0x9e, 0x15, 0x6a, 0xc2, 0xa8, 0xbb, 0x37,
	0x33, 0x2a, 0x6d, 0xb2, 0x3a, 0x50, 0xe5, 0x5c, 0xc7, 0xef, 0xe8, 0x22, 0xb7, 0x11, 0x6c, 0x46,
	0x30, 0xd1, 0x7f, 0x48, 0x10, 0xf3, 0x84, 0xa2, 0x35, 0x88, 0x1d, 0x19, 0x66, 0xb0, 0xd2, 0x8b,
	0xd2, 0x36, 0x2d, 0x8b, 0x1e, 0xc0, 0xa2, 0xef, 0xda, 0x3e, 0x0a, 0x4a, 0x0e, 0x89, 0x74, 0xd0,
	0x11, 0x2c, 0x74, 0xb1, 0x71, 0xdc, 0xe5, 0x2e, 0x96, 0xba, 0x3e, 0x06, 0xbd, 0xc0, 0x1a, 0xb9,
	0x12, 0xe3, 0xaa, 0x0a, 0xee, 0x59, 0x05, 0x16, 0x38, 0x05, 0xdd, 0x05, 0x54, 0x2a, 0xd2, 0x5d,
	0x9d, 0x12, 0x35, 0x4a, 0x35, 0xb5, 0x39, 0x1a, 0x35, 0xa8, 0x37, 0x34, 0x69, 0x2c, 0x09, 0xcb,
	0xff, 0x28, 0xc1, 0xe2, 0x88, 0x59, 0x28, 0x72, 0xa0, 0xf5, 0xe6, 0xb9, 0x48, 0xeb, 0xca, 0xec,
	0x46, 0xc6, 0x1d, 0x5a, 0xa4, 0x9e, 0x97, 0xe6, 0x54, 0xce, 0x11, 0xbd, 0x3b, 0x7c, 0x0d, 0x1a,
	0x9a, 0xed, 0xa2, 0x23, 0xc8, 0x9b, 0xe3, 0xed, 0xd2, 0x9c, 0xf7, 0x32, 0x35, 0x9f, 0x04, 0xf0,
	0x77, 0x54, 0xae, 0xf0, 0xb8, 0x38, 0xb2, 0x92, 0xa9, 0xa9, 0xec, 0x01, 0x2c, 0x7a, 0x35, 0xa6,
	0xd6, 0xd1, 0x89, 0xee, 0xed, 0xa8, 0x47, 0xdc, 0xd6, 0x89, 0x2e, 0xff, 0x30, 0x02, 0x68, 0x52,
	0xf8, 0xcc, 0xfc, 0x90, 0x0d, 0x11, 0xaa, 0xad, 0x38, 0x2d, 0x87, 0x37, 0xb7, 0xc3, 0x14, 0xd2,
	0xb6, 0xa1, 0x9b, 0x14, 0x16, 0x50, 0x76, 0xe8, 0x1c, 0x62, 0xa2, 0x3e, 0x32, 0x05, 0x44, 0x7a,
	0xf7, 0x33, 0x11, 0x2a, 0x8a, 0xa1, 0xd2, 0x9c, 0x1a, 0xe5, 0x85, 0x92, 0x89, 0x3e, 0x91, 0x20,
	0xe5, 0x76, 0x75, 0x07, 0x6b, 0xa6, 0xdd, 0xe6, 0xb9, 0x88, 0xbf, 0x66, 0x68, 0x7d, 0x26, 0x2b,
	0x68, 0x50, 0x51, 0x15, 0x21, 0xa9, 0x34, 0xa7, 0x2e, 0xba, 0x41, 0x82, 0xfc, 0x18, 0xee, 0x4e,
	0x37, 0xd5, 0x55, 0x60, 0xd1, 0xeb, 0xb0, 0x76, 0xa1, 0xca, 0x53, 0x2a, 0xbf, 0x57, 0xe0, 0xfe,
	0x25, 0xeb, 0xa3, 0x70, 0x8d, 0xbb, 0xaf, 0xfc, 0x4f, 0x11, 0x48, 0x06, 0xef, 0xbe, 0x50, 0x0f,
	0x80, 0x5f, 0xa8, 0xb1, 0xd7, 0x91, 0xd2, 0x6c, 0x91, 0x24, 0xc8, 0x31, 0xe7, 0xdd, 0x2f, 0x30,
	0x22, 0x7b, 0x29, 0x1b, 0xef, 0x79, 0x8f, 0x68, 0xe0, 0xdd, 0xdf, 0xd9, 0xad, 0x5f, 0xc4, 0xed,
	0x21, 0xdc, 0xa9, 0xdf, 0x9e, 0xc4, 0x1a, 0x63, 0x2c, 0x6e, 0xf4, 0x78, 0xc3, 0x95, 0xff, 0x28,
	0x04, 0x2b, 0x53, 0x46, 0x4d, 0x7d, 0xd1, 0x79, 0x79, 0x1a, 0xfa, 0x16, 0x24, 0x4c, 0xdd, 0x39,
	0xc6, 0x1c, 0x75, 0x88, 0xe3, 0x35, 0xf3, 0x0b, 0x3d, 0x60, 0xbc, 0xf8, 0xf5, 0xdf, 0x1e, 0x44,
	0x8c, 0xb6, 0x6d, 0xdd, 0xa8, 0xbe, 0xa0, 0xa7, 0x91, 0x32, 0x41, 0xf7, 0x21, 0x21, 0x40, 0x08,
	0x3b, 0x90, 0xfc, 0x35, 0x2a, 0x08, 0xd2, 0x81, 0x63, 0xe6, 0xa3, 0xa2, 0x9c, 0xc9, 0x16, 0x60,
	0x79, 0x62, 0xd7, 0xd0, 0x03, 0xb8, 0xaf, 0x16, 0x1b, 0xf5, 0x5a, 0xb5, 0x51, 0xd4, 0x68, 0x4c,
	0x57, 0xb4, 0x29, 0xaf, 0x95, 0xe3, 0x30, 0xaf, 0x1c, 0x6c, 0x97, 0x6b, 0x69, 0x49, 0xfe, 0x51,
	0x14, 0xd0, 0xe4, 0x1d, 0x31, 0xb2, 0x47, 0x6b, 0xc4, 0xc3, 0x9b, 0x5f, 0x3b, 0x4f, 0x21, 0x05,
	0x4b, 0xf5, 0xef, 0x49, 0x70, 0x87, 0xc3, 0x41, 0xef, 0xf6, 0xcd, 0xee, 0xf3, 0x84, 0xce, 0x41,
	0xe1, 0xb3, 0x5b, 0x58, 0x01, 0x33, 0xb4, 0x78, 0x0d, 0x5d, 0xe3, 0xdc, 0xd5, 0x15, 0x63, 0x92,
	0x28, 0xff, 0x7d, 0x04, 0xee, 0x4e, 0x5f, 0x2e, 0xfa, 0x2d, 0x69, 0xf2, 0x36, 0x89, 0x67, 0xc3,
	0xe3, 0xcf, 0xcc, 0x46, 0xe2, 0x9a, 0xc9, 0x9c, 0x7a, 0xcd, 0xf4, 0x7f, 0xa2, 0x2c, 0x46, 0x77,
	0x61, 0xe1, 0xc8, 0xb6, 0x09, 0x76, 0x84, 0xc3, 0x8a, 0x96, 0xfc, 0xbd, 0x90, 0x77, 0x09, 0x66,
	0x06, 0x2f, 0xc1, 0x4c, 0x3f, 0x14, 0x9a, 0xe8, 0xf7, 0x25, 0x58, 0x1c, 0x38, 0x26, 0xff, 0x86,
	0xa0, 0x6b, 0x58, 0x1e, 0x34, 0x72, 0x7f, 0x4a, 0x06, 0xcd, 0x1d, 0x38, 0x26, 0x3d, 0x3b, 0x25,
	0x83, 0x42, 0xf6, 0x81, 0xdf, 0xc8, 0xee, 0x43, 0x22, 0xd0, 0x87, 0x3e, 0x07, 0x6b, 0x07, 0x6a,
	0x85, 0x1f, 0xa8, 0x52, 0x79, 0x02, 0x47, 0xa7, 0x00, 0x94, 0xfd, 0xba, 0xa6, 0x14, 0x28, 0x8e,
	0x4f, 0x4b, 0x68, 0x09, 0x12, 0xb4, 0x5d, 0xa8, 0x55, 0x9b, 0xc5, 0x6a, 0x33, 0x1d, 0xca, 0x9e,
	0xc2, 0xca, 0x14, 0x17, 0x44, 0xaf, 0xc2, 0x2b, 0x1c, 0xa0, 0x6f, 0x97, 0x1b, 0xf5, 0x8a, 0x72,
	0xa8, 0xd5, 0xea, 0x94, 0x43, 0x63, 0x12, 0xa6, 0xef, 0xaa, 0xca, 0x21, 0x87, 0xe9, 0xcf, 0x4b,
	0xe5, 0x66, 0x31, 0x1d, 0x42, 0x09, 0x88, 0x16, 0xd4, 0x5a, 0xbd, 0x5e, 0xdc, 0x4e, 0x87, 0x29,
	0xd2, 0xcb, 0x57, 0x0e, 0x54, 0xb5, 0xb8, 0xad, 0xe5, 0x95, 0xc2, 0xde, 0xae, 0x5a, 0x3b, 0xa8,
	0x6e, 0xa7, 0x23, 0xf2, 0xf7, 0xc3, 0x10, 0x1f, 0xbe, 0x99, 0x99, 0xe1, 0xc6, 0x78, 0xe8, 0x29,
	0xe1, 0x5b, 0xf0, 0x94, 0x1e, 0x2c, 0xb7, 0x6d, 0x73, 0xd0, 0xb3, 0xb4, 0xbe, 0x63, 0xf7, 0xb1,
	0x43, 0x0c, 0xec, 0x81, 0xf6, 0x6b, 0x5f, 0x0a, 0x17, 0x18, 0xa3, 0xfa, 0x90, 0x8f, 0x9a, 0x6e,
	0x8f, 0x51, 0x50, 0x1d, 0x22, 0xd4, 0x05, 0xc4, 0xb5, 0xf3, 0xd7, 0x67, 0x7e, 0xa1, 0xa5, 0xda,
	0x67, 0x2a, 0xe3, 0x14, 0xbc, 0xcb, 0x5e, 0xb8, 0xed, 0xbb, 0xec, 0x3f, 0x08, 0x41, 0x7a, 0x5c,
	0x29, 0x7a, 0xb6, 0xba, 0x58, 0xef, 0x0c, 0x61, 0x87, 0x68, 0xa1, 0xef, 0x4a, 0xb0, 0xda, 0xb5,
	0x1d, 0xe3, 0x03, 0xdb, 0x22, 0xba, 0x39, 0x51, 0x46, 0x37, 0x6f, 0x6a, 0xcd, 0x5c, 0x69, 0xc8,
	0xdc, 0xaf, 0xa0, 0x57, 0xba, 0x93, 0xc4, 0x6c, 0x0b, 0x56, 0xa6, 0x8c, 0x45, 0x9f, 0x87, 0x75,
	0xbf, 0x78, 0xbd, 0xb0, 0xfc, 0x4c, 0x40, 0xb4, 0x52, 0x54, 0xb6, 0xcb, 0xd5, 0x5d, 0x5e, 0x89,
	0x14, 0x8a, 0xd5, 0x66, 0x51, 0x4d, 0x87, 0x68, 0xad, 0xdb, 0x54, 0x95, 0x72, 0x85, 0xf6, 0x84,
	0xe5, 0xdf, 0x90, 0x20, 0x19, 0xdc, 0x0d, 0xd4, 0x80, 0xf9, 0x36, 0x36, 0x4d, 0x2f, 0x45, 0xbd,
	0x3d, 0xf3, 0xd6, 0x16, 0xb0, 0x69, 0xaa, 0x9c, 0x17, 0xfb, 0xec, 0xc9, 0x38, 0x35, 0x3a, 0xd8,
	0xd1, 0xf4, 0x23, 0x1a, 0xce, 0x42, 0xec, 0x33, 0xa3, 0xa4, 0x20, 0x2a, 0x94, 0x26, 0x3f, 0x80,
	0xc5, 0x91, 0xc9, 0xd3, 0xb0, 0x7e, 0xf6, 0xcf, 0x25, 0x88, 0x79, 0xef, 0x13, 0x51, 0x06, 0x56,
	0xeb, 0x15, 0xa5, 0xb9, 0x53, 0x53, 0xf7, 0xc7, 0xb4, 0x4f, 0x42, 0x6c, 0x47, 0x29, 0x14, 0xf3,
	0xb5, 0xda, 0x1e, 0x3f, 0xd9, 0x8d, 0x8a, 0x52, 0xd8, 0x13, 0xda, 0x17, 0x2b, 0xc5, 0x5d, 0x55,
	0xd9, 0x4f, 0x87, 0x51, 0x14, 0xc2, 0x7b, 0xe5, 0xbd, 0x74, 0x84, 0x8d, 0xd8, 0x3b, 0xac, 0x17,
	0xd3, 0xf3, 0xac, 0x6e, 0x2f, 0x57, 0x8b, 0xe9, 0x05, 0x4a, 0x7c, 0x56, 0xce, 0x17, 0xd5, 0x74,
	0x14, 0xdd, 0x81, 0x65, 0x1e, 0x80, 0x1a, 0x5a, 0xad, 0xaa, 0xed, 0xd6, 0x6a, 0xbb, 0x95, 0x62,
	0x3a, 0x86, 0x16, 0x21, 0x4e, 0xb9, 0xd5, 0x4b, 0xb5, 0xea, 0x61, 0x1a, 0xd0, 0x0a, 0x2c, 0xf1,
	0x2e, 0xad, 0xa4, 0x54, 0x77, 0x6b, 0x07, 0xcd, 0x46, 0x3a, 0x91, 0x8f, 0x43, 0x54, 0x7c, 0x63,
	0x29, 0xff, 0x9a, 0x04, 0x68, 0xf2, 0x6b, 0x41, 0xf4, 0x73, 0x93, 0xdf, 0x21, 0x06, 0x80, 0xd8,
	0xd8, 0xb7, 0x84, 0x57, 0xf9, 0xf0, 0x31, 0xf4, 0xe9, 0x1f, 0x3e, 0x66, 0x09, 0x24, 0x83, 0xdf,
	0x23, 0xd3, 0x08, 0xfc, 0xbc, 0x98, 0x2f, 0xd5, 0x6a, 0x7b, 0x5a, 0xa3, 0xa9, 0x34, 0xc7, 0x71,
	0xcd, 0x1a, 0xdc, 0x19, 0xed, 0x2e, 0x56, 0x95, 0x7c, 0xa5, 0xb8, 0x9d, 0x96, 0xd0, 0x06, 0x7c,
	0x61, 0x6a, 0x97, 0xb6, 0x53, 0x53, 0xb5, 0x46, 0xa5, 0xd6, 0xd4, 0x76, 0xca, 0x15, 0xe6, 0x6a,
	0xa1, 0x47, 0xbf, 0x2d, 0xfd, 0x9b, 0xf2, 0x9b, 0x12, 0xac, 0x07, 0x7c, 0x88, 0xfb, 0x96, 0xde,
	0x37, 0xdc, 0x5c, 0xdb, 0xee, 0x6d, 0x8a, 0x4f, 0xb4, 0x5f, 0xeb, 0x3b, 0x36, 0x83, 0xaa, 0x9b,
	0x1f, 0x8a, 0xa7, 0x8f, 0x37, 0xf5, 0x63, 0x6c, 0x11, 0xf1, 0xb5, 0xbd, 0xbb, 0xf9, 0x21, 0x7f,
	0xf8, 0x18, 0x3d, 0x99, 0x32, 0xd4, 0xab, 0x79, 0xdc, 0xcd, 0x0f, 0xbd, 0xc7, 0x8b, 0xe6, 0x67,
	0xff, 0x59, 0x02, 0x54, 0x31, 0x5c, 0xc2, 0x25, 0xbb, 0x2a, 0x7e, 0x6f, 0x80, 0x5d, 0x5a, 0xdc,
	0x2f, 0x70, 0xe3, 0x79, 0xb1, 0x81, 0xb7, 0xa8, 0x1f, 0x9b, 0xba, 0x75, 0x3c, 0xa0, 0x80, 0xaa,
	0x6d, 0x77, 0x3c, 0x4b, 0x27, 0x3d, 0x62, 0xc1, 0xee, 0x60, 0x54, 0x81, 0x84, 0xd8, 0x8c, 0x53,
	0x03, 0x9f, 0x89, 0xac, 0xfb, 0xb3, 0x57, 0x3c, 0x47, 0xcf, 0x0c, 0x7c, 0xa6, 0x82, 0x31, 0x7c,
	0x46, 0x2f, 0x41, 0xbc, 0x4f, 0xc5, 0xb9, 0xc6, 0x07, 0x58, 0x7c, 0x63, 0x19, 0xa3, 0x84, 0x86,
	0xf1, 0x01, 0xdd, 0x38, 0x60, 0x9d, 0xc4, 0x3e, 0xc1, 0x96, 0xc0, 0x08, 0x6c, 0x78, 0x93, 0x12,
	0xb2, 0xdf, 0x91, 0x60, 0x65, 0x44, 0x3b, 0xf1, 0x1a, 0x57, 0x81, 0xa8, 0xb0, 0x84, 0x38, 0xe5,
	0x5f, 0xbc, 0xe2, 0xea, 0x54, 0x6f, 0x1e, 0xfa, 0x02, 0x2c, 0x59, 0xf8, 0x7d, 0xa2, 0x05, 0xc4,
	0x73, 0x5b, 0x2c, 0x52, 0x72, 0x7d, 0xb8, 0x84, 0x3f, 0x94, 0x20, 0xbd, 0x8b, 0xc5, 0x0a, 0x3c,
	0xf3, 0x4e, 0xab, 0x34, 0x7e, 0xfa, 0xa6, 0xcd, 0xfe, 0x48, 0x82, 0x95, 0x82, 0x83, 0x75, 0x82,
	0x47, 0x97, 0x77, 0xd1, 0xee, 0xbf, 0x03, 0x0b, 0x7c, 0xb6, 0xb8, 0x4c, 0xb9, 0xb2, 0xd5, 0xc4,
	0xb4, 0x49, 0x1d, 0xc3, 0x97, 0xeb, 0x18, 0xb9, 0x99, 0x8e, 0xbf, 0x1e, 0x82, 0x95, 0x83, 0x7e,
	0x67, 0x42, 0x47, 0x5f, 0x17, 0xe9, 0x96, 0x74, 0x99, 0xb6, 0x5f, 0x8f, 0x21, 0x31, 0x60, 0xc2,
	0xd9, 0x3f, 0x1c, 0x02, 0xe8, 0xc8, 0x13, 0xdf, 0x3a, 0xee, 0x18, 0xd8, 0xec, 0xec, 0xeb, 0xee,
	0x89, 0x0a, 0x7c, 0x38, 0x7d, 0xbe, 0x65, 0x43, 0xbc, 0x06, 0x2b, 0xdb, 0xd8, 0xc4, 0xe3, 0x76,
	0x98, 0xe2, 0x8a, 0xd9, 0xff, 0x09, 0xc1, 0x5a, 0x5e, 0x27, 0xed, 0x6e, 0xd0, 0x70, 0x97, 0xc6,
	0x86, 0x0d, 0x48, 0x8b, 0xe5, 0xb6, 0xe8, 0x5c, 0xff, 0xaa, 0xb2, 0x34, 0xa7, 0xa6, 0x78, 0x0f,
	0x67, 0xea, 0x18, 0xe8, 0x17, 0x60, 0x65, 0x64, 0xac, 0x61, 0x99, 0x86, 0xe5, 0x01, 0xc1, 0x2f,
	0x5d, 0x51, 0x45, 0xc6, 0xad, 0x34, 0xa7, 0x2e, 0x07, 0x98, 0x97, 0x19, 0xa3, 0xc9, 0xcd, 0x89,
	0x5c, 0xbe, 0x39, 0xf3, 0x37, 0xd9, 0x9c, 0x85, 0x1b, 0x6d, 0x4e, 0x3e, 0x05, 0xc9, 0xa0, 0x3d,
	0xb2, 0x1a, 0xc8, 0xd3, 0x36, 0xe0, 0xd6, 0xc2, 0x57, 0xf6, 0x54, 0xec, 0x70, 0xd0, 0x25, 0x2e,
	0xdd, 0xe1, 0x80, 0xdc, 0xd0, 0x8c, 0x72, 0xeb, 0x90, 0x08, 0x6c, 0xde, 0x2d, 0x68, 0xb2, 0xf1,
	0x0e, 0x40, 0x39, 0x98, 0x2d, 0xee, 0x95, 0x59, 0x5d, 0xa4, 0x3d, 0x2b, 0x17, 0x9f, 0x8f, 0xe5,
	0xf1, 0x55, 0x48, 0x07, 0x3b, 0x77, 0x0e, 0x2a, 0x95, 0xb4, 0xb4, 0xf5, 0x93, 0x45, 0x88, 0x0a,
	0x03, 0xa0, 0x1f, 0x4b, 0x90, 0x08, 0x24, 0x0c, 0xf4, 0xe6, 0xa5, 0xcb, 0x99, 0x4c, 0x9e, 0xf2,
	0x97, 0xaf, 0x37, 0x89, 0x6f, 0x6a, 0xd6, 0xfc, 0xe5, 0xbf, 0xfb, 0xd7, 0xdf, 0x09, 0x1d, 0xa1,
	0x8d, 0xe1, 0xdf, 0x67, 0x1f, 0x72, 0xb3, 0xbf, 0x3d, 0x4c, 0xf1, 0x1b, 0x3c, 0x8b, 0x7f, 0xec,
	0xa5, 0xf1, 0x17, 0x6f, 0xa1, 0xaf, 0x7c, 0xda, 0x68, 0x1f, 0x08, 0x8c, 0xcf, 0x44, 0xff, 0x20,
	0x41, 0x7c, 0x98, 0x96, 0xd0, 0xe5, 0xbf, 0xe1, 0x8c, 0xa7, 0x30, 0xf9, 0xaa, 0x1b, 0x35, 0x4d,
	0x2f, 0x1a, 0x64, 0x26, 0xb4, 0x1a, 0x62, 0x93, 0x8d, 0x8f, 0x47, 0xf5, 0x1a, 0x1f, 0x3d, 0xa1,
	0x55, 0x60, 0x26, 0xfa, 0x77, 0x09, 0x92, 0xc1, 0x94, 0x86, 0x2e, 0xdf, 0x8c, 0x29, 0x19, 0xf0,
	0xea, 0xda, 0x7d, 0xc4, 0xb4, 0x3b, 0xcd, 0x5e, 0x63, 0xd7, 0x1e, 0x89, 0x0c, 0xf2, 0xe2, 0x1b,
	0xd9, 0x19, 0x77, 0xcf, 0xe3, 0x80, 0xfe, 0x4b, 0x82, 0x64, 0x30, 0x44, 0x5c, 0x41, 0xdb, 0x29,
	0xb9, 0xf0, 0xea, 0xda, 0x7e, 0x22, 0x31, 0x75, 0x7f, 0x55, 0xda, 0x7a, 0xc3, 0x5f, 0xb9, 0xf8,
	0x03, 0xf4, 0xb2, 0x4d, 0x1d, 0xaa, 0xbd, 0xbb, 0xf5, 0xf6, 0xa5, 0x93, 0x3f, 0x6d, 0x8f, 0x87,
	0xda, 0xff, 0x40, 0x82, 0x64, 0x30, 0x7e, 0x5d, 0x41, 0xfb, 0x29, 0x19, 0x50, 0xbe, 0x3b, 0x11,
	0xf1, 0x8b, 0xbd, 0x3e, 0x39, 0xf7, 0x1c, 0x77, 0xe3, 0x5a, 0x8e, 0xbb, 0x31, 0xab, 0xe3, 0xfe,
	0x44, 0x02, 0x34, 0x19, 0xf2, 0xd1, 0xe5, 0x5f, 0x60, 0x5d, 0x98, 0xa8, 0xe5, 0xcf, 0x79, 0x73,
	0x03, 0x3f, 0xac, 0xe6, 0x6a, 0xde, 0x0f, 0xab, 0xfe, 0x66, 0x7e, 0xba, 0x1b, 0x8e, 0xb9, 0x5e,
	0xcb, 0x17, 0xf7, 0x48, 0xda, 0x78, 0xb1, 0x9b, 0xcd, 0xcf, 0xe8, 0xc3, 0xa3, 0x8c, 0x7c, 0xfd,
	0x47, 0x32, 0xd2, 0x55, 0xf5, 0x9f, 0x96, 0xc6, 0x3e, 0x43, 0xfd, 0xb9, 0xb8, 0x5b, 0xd0, 0x7f,
	0xc8, 0x48, 0x7e, 0xff, 0x07, 0xca, 0xda, 0x85, 0x85, 0xe1, 0xdf, 0x2a, 0x87, 0x5d, 0x42, 0xfa,
	0xee, 0xa3, 0xcd, 0xcd, 0xb3, 0xb3, 0x89, 0xaa, 0x51, 0x1f, 0x90, 0x2e, 0xff, 0x87, 0xf9, 0x75,
	0xef, 0xfb, 0xe2, 0x2f, 0x5d, 0x36, 0xdc, 0x17, 0x95, 0xff, 0x53, 0x09, 0x1e, 0xb4, 0xed, 0xde,
	0x65, 0x86, 0xce, 0x8b, 0xc4, 0x5d, 0xa7, 0xa7, 0xa4, 0x2e, 0xbd, 0x28, 0x8b, 0xf1, 0xc7, 0x36,
	0x05, 0x55, 0x39, 0xdb, 0x39, 0xde, 0x3c, 0xc6, 0x16, 0x3b, 0x43, 0x9b, 0xbe, 0xc4, 0x0b, 0xff,
	0xad, 0x7e, 0xec, 0x93, 0xfe, 0x53, 0x92, 0xfe, 0x24, 0x14, 0xda, 0xde, 0xf9, 0xb3, 0xd0, 0xfd,
	0x5d, 0xce, 0xb3, 0xc0, 0xd6, 0xb0, 0xed, 0xaf, 0xe1, 0x19, 0x9f, 0xd4, 0x5a, 0x60, 0xfc, 0xdf,
	0xfc, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd0, 0x69, 0x36, 0x5d, 0x97, 0x3e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// IntentsClient is the client API for Intents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IntentsClient interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Creates an intent in the specified agent.
	CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Updates the specified intent.
	UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Deletes the specified intent and its direct or indirect followup intents.
	DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates/Creates multiple intents in the specified agent.
	//
	// Operation <response: [BatchUpdateIntentsResponse][google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse]>
	BatchUpdateIntents(ctx context.Context, in *BatchUpdateIntentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes intents in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteIntents(ctx context.Context, in *BatchDeleteIntentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type intentsClient struct {
	cc *grpc.ClientConn
}

func NewIntentsClient(cc *grpc.ClientConn) IntentsClient {
	return &intentsClient{cc}
}

func (c *intentsClient) ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error) {
	out := new(ListIntentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/ListIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/GetIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/CreateIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/UpdateIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/DeleteIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) BatchUpdateIntents(ctx context.Context, in *BatchUpdateIntentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/BatchUpdateIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) BatchDeleteIntents(ctx context.Context, in *BatchDeleteIntentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/BatchDeleteIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IntentsServer is the server API for Intents service.
type IntentsServer interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(context.Context, *GetIntentRequest) (*Intent, error)
	// Creates an intent in the specified agent.
	CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error)
	// Updates the specified intent.
	UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error)
	// Deletes the specified intent and its direct or indirect followup intents.
	DeleteIntent(context.Context, *DeleteIntentRequest) (*empty.Empty, error)
	// Updates/Creates multiple intents in the specified agent.
	//
	// Operation <response: [BatchUpdateIntentsResponse][google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse]>
	BatchUpdateIntents(context.Context, *BatchUpdateIntentsRequest) (*longrunning.Operation, error)
	// Deletes intents in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteIntents(context.Context, *BatchDeleteIntentsRequest) (*longrunning.Operation, error)
}

// UnimplementedIntentsServer can be embedded to have forward compatible implementations.
type UnimplementedIntentsServer struct {
}

func (*UnimplementedIntentsServer) ListIntents(ctx context.Context, req *ListIntentsRequest) (*ListIntentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIntents not implemented")
}
func (*UnimplementedIntentsServer) GetIntent(ctx context.Context, req *GetIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIntent not implemented")
}
func (*UnimplementedIntentsServer) CreateIntent(ctx context.Context, req *CreateIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIntent not implemented")
}
func (*UnimplementedIntentsServer) UpdateIntent(ctx context.Context, req *UpdateIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIntent not implemented")
}
func (*UnimplementedIntentsServer) DeleteIntent(ctx context.Context, req *DeleteIntentRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIntent not implemented")
}
func (*UnimplementedIntentsServer) BatchUpdateIntents(ctx context.Context, req *BatchUpdateIntentsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateIntents not implemented")
}
func (*UnimplementedIntentsServer) BatchDeleteIntents(ctx context.Context, req *BatchDeleteIntentsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteIntents not implemented")
}

func RegisterIntentsServer(s *grpc.Server, srv IntentsServer) {
	s.RegisterService(&_Intents_serviceDesc, srv)
}

func _Intents_ListIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ListIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/ListIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ListIntents(ctx, req.(*ListIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_GetIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).GetIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/GetIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).GetIntent(ctx, req.(*GetIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_CreateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).CreateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/CreateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).CreateIntent(ctx, req.(*CreateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_UpdateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).UpdateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/UpdateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).UpdateIntent(ctx, req.(*UpdateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_DeleteIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).DeleteIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/DeleteIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).DeleteIntent(ctx, req.(*DeleteIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_BatchUpdateIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).BatchUpdateIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/BatchUpdateIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).BatchUpdateIntents(ctx, req.(*BatchUpdateIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_BatchDeleteIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).BatchDeleteIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/BatchDeleteIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).BatchDeleteIntents(ctx, req.(*BatchDeleteIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Intents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Intents",
	HandlerType: (*IntentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListIntents",
			Handler:    _Intents_ListIntents_Handler,
		},
		{
			MethodName: "GetIntent",
			Handler:    _Intents_GetIntent_Handler,
		},
		{
			MethodName: "CreateIntent",
			Handler:    _Intents_CreateIntent_Handler,
		},
		{
			MethodName: "UpdateIntent",
			Handler:    _Intents_UpdateIntent_Handler,
		},
		{
			MethodName: "DeleteIntent",
			Handler:    _Intents_DeleteIntent_Handler,
		},
		{
			MethodName: "BatchUpdateIntents",
			Handler:    _Intents_BatchUpdateIntents_Handler,
		},
		{
			MethodName: "BatchDeleteIntents",
			Handler:    _Intents_BatchDeleteIntents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/intent.proto",
}
