/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    private static HTMLTransfer _instance = new HTMLTransfer();
    private static final String TEXT_HTML = "text/html";
    private static final int TEXT_HTML_ID = HTMLTransfer.registerType("text/html");
    private static final String TEXT_HTML2 = "TEXT/HTML";
    private static final int TEXT_HTML2_ID = HTMLTransfer.registerType("TEXT/HTML");

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        String string;
        byte[] utf8;
        int byteCount;
        long pValue;
        transferData.result = 0;
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((pValue = OS.g_malloc(byteCount = (utf8 = Converter.wcsToMbcs(null, string = (String)object, true)).length)) == 0L) {
            return;
        }
        OS.memmove(pValue, utf8, (long)byteCount);
        transferData.length = byteCount;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        String string;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        int size = transferData.format * transferData.length / 8 / 2 * 2;
        if (size <= 0) {
            return null;
        }
        char[] bom = new char[1];
        if (size > 1) {
            OS.memmove(bom, transferData.pValue, 2L);
        }
        if (bom[0] == '\ufeff' || bom[0] == '\ufffe') {
            char[] chars = new char[size / 2];
            OS.memmove(chars, transferData.pValue, (long)size);
            string = new String(chars);
        } else {
            byte[] utf8 = new byte[size];
            OS.memmove(utf8, transferData.pValue, (long)size);
            char[] unicode = Converter.mbcsToWcs(null, utf8);
            string = new String(unicode);
        }
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TEXT_HTML_ID, TEXT_HTML2_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TEXT_HTML, TEXT_HTML2};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

