/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IEvaluationService;
import org.xmind.core.IAdaptable;
import org.xmind.core.IRevision;
import org.xmind.core.IRevisionManager;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.SourceCommand;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.commands.AddSheetCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteSheetCommand;
import org.xmind.ui.commands.ModifyMetadataCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.dialogs.RevisionPreviewDialog;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.TextFormatter;
import org.xmind.ui.viewers.SWTUtils;

public class WorkbookRevisionDialog
extends Dialog {
    private static final String KEY_SELECTION_PROVIDER = "org.xmind.ui.WorkbookRevisionDialog.selectionProvider";
    private static final int PREVIEW_ID = 1025;
    private static final int RESTORE_ID = 1026;
    private static final String K_AUTO_SAVE = "Configurations/AutoRevisionGeneration";
    private static final String V_NO = "No";
    private Shell shell = null;
    private CurrentSelectionProviderWrap currentSelectionProviderWrap = null;
    private IGraphicalEditor sourceEditor;
    private TableViewer viewer;
    private ISheet sheet;
    private MenuManager popupMenuManager;
    private IRevisionManager revisionManager;
    private Button previewBt;
    private boolean previewDialogOpened = false;
    private ResourceManager resources;
    private IPartListener partListenerHandler = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            if (!(part instanceof IGraphicalEditor)) {
                return;
            }
            if (WorkbookRevisionDialog.this.getSourceEditor() != (IGraphicalEditor)part) {
                if (part != null) {
                    WorkbookRevisionDialog.this.setSourceEditor((IGraphicalEditor)part);
                }
                if (WorkbookRevisionDialog.this.coreEventRegister != null) {
                    WorkbookRevisionDialog.this.coreEventRegister.unregisterAll();
                }
                if (WorkbookRevisionDialog.this.topicEventRegister != null) {
                    WorkbookRevisionDialog.this.topicEventRegister.unregisterAll();
                }
                if (WorkbookRevisionDialog.this.getSheet() != null) {
                    WorkbookRevisionDialog.this.registerCoreEvents();
                }
                WorkbookRevisionDialog.this.update();
            }
        }
    };
    private ICoreEventListener coreEventHandler = new ICoreEventListener(){

        public void handleCoreEvent(CoreEvent event) {
            String type = event.getType();
            if ("revisionAdd".equals(type) || "revisionRemove".equals(type)) {
                WorkbookRevisionDialog.this.updateTabelViewer();
            } else if ("titleText".equals(type)) {
                WorkbookRevisionDialog.this.updateShellTitle();
            } else if ("rootTopic".equals(type)) {
                WorkbookRevisionDialog.this.topicEventRegister.unregisterAll();
                ITopic rootTopic = WorkbookRevisionDialog.this.sheet.getRootTopic();
                WorkbookRevisionDialog.this.topicEventRegister.setNextSourceFrom((Object)rootTopic);
                WorkbookRevisionDialog.this.topicEventRegister.register("titleText");
            }
        }
    };
    private IPageChangedListener pageChangedHandler = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            IViewer viewer = MindMapUIPlugin.getAdapter(WorkbookRevisionDialog.this.getSourceEditor(), IViewer.class);
            if (viewer != null && viewer instanceof IMindMapViewer) {
                ISheet newSheet = ((IMindMapViewer)viewer).getSheet();
                if (WorkbookRevisionDialog.this.getSheet() != newSheet) {
                    WorkbookRevisionDialog.this.setSheet(newSheet);
                }
                if (WorkbookRevisionDialog.this.coreEventRegister != null) {
                    WorkbookRevisionDialog.this.coreEventRegister.unregisterAll();
                }
                if (WorkbookRevisionDialog.this.topicEventRegister != null) {
                    WorkbookRevisionDialog.this.topicEventRegister.unregisterAll();
                }
                WorkbookRevisionDialog.this.registerCoreEvents();
                WorkbookRevisionDialog.this.update();
            }
        }
    };
    private ICoreEventRegister coreEventRegister = new CoreEventRegister(this.coreEventHandler);
    private ICoreEventRegister topicEventRegister = new CoreEventRegister(this.coreEventHandler);

    public WorkbookRevisionDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public WorkbookRevisionDialog(Shell shell, IGraphicalEditor sourceEditor) {
        super(shell);
        this.setSourceEditor(sourceEditor);
        IViewer viewer = MindMapUIPlugin.getAdapter(sourceEditor, IViewer.class);
        if (viewer != null && viewer instanceof IMindMapViewer) {
            this.setSheet(((IMindMapViewer)viewer).getSheet());
        }
        this.setShellStyle(2144);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
        newShell.setText(MindMapMessages.WorkbookRevisionDialog_title);
        newShell.setSize(520, 500);
        newShell.setLocation(Display.getCurrent().getClientArea().width / 2 - newShell.getShell().getSize().x / 2, Display.getCurrent().getClientArea().height / 2 - newShell.getSize().y / 2);
    }

    public void create() {
        super.create();
        this.registerSourceProvider();
    }

    protected Control createDialogArea(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 14;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createDescriptionArea(composite);
        Control viewerControl = this.createViewer(composite);
        GridData viewerData = new GridData(4, 4, true, true);
        viewerControl.setLayoutData((Object)viewerData);
        this.registerCoreEvents();
        viewerControl.setData(KEY_SELECTION_PROVIDER, (Object)this.viewer);
        this.createPopupMenu(viewerControl);
        viewerControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WorkbookRevisionDialog.this.handleViewerDispose();
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WorkbookRevisionDialog.this.handleDisposed();
            }
        });
        return composite;
    }

    private void createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 21;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label discriptionLabel = new Label(composite, 64);
        GridData discriptionLabelData = new GridData(4, 0x1000000, true, true);
        discriptionLabel.setLayoutData((Object)discriptionLabelData);
        discriptionLabel.setAlignment(16384);
        discriptionLabel.setText(DialogMessages.workbookRevisionDialog_Description_Label_text);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 13;
        layout.marginHeight = 23;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createDisableHyperlink(composite2);
        Composite buttonBar = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 0;
        layout2.makeColumnsEqualWidth = true;
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 18;
        layout2.verticalSpacing = 0;
        buttonBar.setLayout((Layout)layout2);
        GridData data2 = new GridData(132);
        buttonBar.setLayoutData((Object)data2);
        buttonBar.setFont(composite.getFont());
        this.createButtonsForButtonBar(buttonBar);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.previewBt = this.createButton(parent, 1025, DialogMessages.WorkbookRevisionDialog_Preview_Button_label, false);
        this.previewBt.setEnabled(this.viewer != null && !StructuredSelection.EMPTY.equals((Object)this.viewer.getSelection()));
        this.createButton(parent, 1026, DialogMessages.WorkbookRevisionDialog_Restore_Button_label, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (1025 == buttonId) {
            this.preview();
        }
        if (1026 == buttonId) {
            this.restore();
        }
        if (12 == buttonId) {
            this.close();
        }
    }

    private void asyncExec(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    private void setSourceEditor(IGraphicalEditor editor) {
        if (editor == this.sourceEditor) {
            return;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener(this.pageChangedHandler);
        }
        this.sourceEditor = editor;
        if (this.sourceEditor != null) {
            IGraphicalViewer viewer;
            this.sourceEditor.addPageChangedListener(this.pageChangedHandler);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.partListenerHandler);
            IGraphicalEditorPage page = this.sourceEditor.getActivePageInstance();
            if (page != null && (viewer = page.getViewer()) instanceof IMindMapViewer) {
                IMindMapViewer mmv = (IMindMapViewer)viewer;
                IMindMap mindMap = mmv.getMindMap();
                this.setSheet(mindMap.getSheet());
            }
        }
    }

    private IGraphicalEditor getSourceEditor() {
        return this.sourceEditor;
    }

    private ISheet getSheet() {
        return this.sheet;
    }

    private void setSheet(ISheet sheet) {
        if (this.sheet == sheet) {
            return;
        }
        this.sheet = sheet;
        this.revisionManager = this.sheet != null ? this.sheet.getOwnedWorkbook().getRevisionRepository().getRevisionManager(this.sheet.getId(), "application/vnd.xmind.sheet") : null;
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.revisionManager);
        }
    }

    private String getTitleText() {
        ISheet sheet2;
        IGraphicalEditorPage page;
        String text = null;
        if (this.getSheet() == null && this.getSourceEditor() != null && (page = this.getSourceEditor().getActivePageInstance()) != null && (sheet2 = (ISheet)page.getInput()) != null) {
            this.setSheet(sheet2);
        }
        if (this.getSheet() != null) {
            text = String.format("%s - %s", this.getSheet().getTitleText(), this.getSheet().getRootTopic().getTitleText());
        }
        return TextFormatter.removeNewLineCharacter(text);
    }

    private void registerSourceProvider() {
        this.currentSelectionProviderWrap = new CurrentSelectionProviderWrap();
        this.currentSelectionProviderWrap.notifySelectionChanges();
        final Listener focusListener = new Listener(){

            public void handleEvent(Event event) {
                if (WorkbookRevisionDialog.this.currentSelectionProviderWrap == null) {
                    return;
                }
                Widget w = event.widget;
                ISelectionProvider selectionProvider = null;
                while (w != null) {
                    selectionProvider = (ISelectionProvider)w.getData(WorkbookRevisionDialog.KEY_SELECTION_PROVIDER);
                    if (selectionProvider != null) break;
                    if (!(w instanceof Control)) continue;
                    w = ((Control)w).getParent();
                }
                WorkbookRevisionDialog.this.currentSelectionProviderWrap.setSelectionProvider(selectionProvider);
            }
        };
        final Display display = Display.getCurrent();
        display.addFilter(15, focusListener);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                display.removeFilter(15, focusListener);
            }
        });
    }

    private void createPopupMenu(Control viewerControl) {
        this.popupMenuManager = new MenuManager("#popup");
        this.popupMenuManager.add((IContributionItem)new GroupMarker("start"));
        this.popupMenuManager.add((IContributionItem)new Separator("additions"));
        this.popupMenuManager.add((IContributionItem)new GroupMarker("end"));
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)this.popupMenuManager, "popup:org.xmind.ui.RevisionsView");
        Menu popupMenu = this.popupMenuManager.createContextMenu(viewerControl);
        viewerControl.setMenu(popupMenu);
    }

    private void handleDisposed() {
        if (this.currentSelectionProviderWrap != null) {
            this.currentSelectionProviderWrap.dispose();
            this.currentSelectionProviderWrap = null;
        }
        this.coreEventRegister.unregisterAll();
        this.topicEventRegister.unregisterAll();
        this.viewer = null;
        this.revisionManager = null;
        this.sheet = null;
        this.setSourceEditor((IGraphicalEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
    }

    private void handleViewerDispose() {
        if (this.currentSelectionProviderWrap != null) {
            this.currentSelectionProviderWrap.dispose();
            this.currentSelectionProviderWrap = null;
        }
    }

    private void registerCoreEvents() {
        this.coreEventRegister.setNextSourceFrom((Object)this.revisionManager);
        this.coreEventRegister.register("revisionAdd");
        this.coreEventRegister.register("revisionRemove");
        this.coreEventRegister.setNextSourceFrom((Object)this.sheet);
        this.coreEventRegister.register("titleText");
        this.coreEventRegister.register("rootTopic");
        ITopic rootTopic = this.getSheet().getRootTopic();
        this.topicEventRegister.setNextSourceFrom((Object)rootTopic);
        this.topicEventRegister.register("titleText");
    }

    private Control createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new RevisionContentProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(2));
        TableViewerColumn col0 = new TableViewerColumn(this.viewer, 16384);
        col0.getColumn().setText(MindMapMessages.RevisionView_VersionColumn_text);
        col0.getColumn().setWidth(200);
        col0.setLabelProvider((CellLabelProvider)new RevisionNumberLabelProvider());
        TableViewerColumn col1 = new TableViewerColumn(this.viewer, 16384);
        col1.getColumn().setText(MindMapMessages.RevisionsView_DateColumn_text);
        col1.getColumn().setWidth(282);
        col1.setLabelProvider((CellLabelProvider)new RevisionDateTimeLabelProvider());
        this.viewer.setInput((Object)this.revisionManager);
        this.viewer.setSorter((ViewerSorter)new VersionCloumnSorter());
        this.viewer.addOpenListener((IOpenListener)new RevisionOpenListener());
        this.viewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (SWTUtils.matchKey((int)e.stateMask, (int)e.keyCode, (int)0, (int)32)) {
                    WorkbookRevisionDialog.this.handleOpen(WorkbookRevisionDialog.this.viewer.getSelection());
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (WorkbookRevisionDialog.this.previewBt != null && !WorkbookRevisionDialog.this.previewBt.isDisposed()) {
                    WorkbookRevisionDialog.this.previewBt.setEnabled(!StructuredSelection.EMPTY.equals((Object)event.getSelection()));
                }
            }
        });
        this.viewer.getControl().setToolTipText(MindMapMessages.RevisionPage_ShowDetails_message);
        return this.viewer.getControl();
    }

    private void handleOpen(ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        IRevision revision = (IRevision)((IStructuredSelection)selection).getFirstElement();
        this.viewRevision(revision);
    }

    private void viewRevision(IRevision revision) {
        if (this.previewDialogOpened) {
            return;
        }
        List revisions = this.revisionManager.getRevisions();
        int index = revisions.indexOf(revision);
        RevisionPreviewDialog dialog = new RevisionPreviewDialog(this.shell, this.sheet, revisions, index){

            @Override
            public int open() {
                WorkbookRevisionDialog.this.previewDialogOpened = true;
                return super.open();
            }

            @Override
            public boolean close() {
                WorkbookRevisionDialog.this.previewDialogOpened = false;
                return super.close();
            }
        };
        dialog.open();
    }

    private void update() {
        this.updateTabelViewer();
        this.updateShellTitle();
    }

    private void updateTabelViewer() {
        if (this.viewer != null) {
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WorkbookRevisionDialog.this.viewer != null) {
                        WorkbookRevisionDialog.this.viewer.setInput((Object)WorkbookRevisionDialog.this.revisionManager);
                        WorkbookRevisionDialog.this.viewer.refresh();
                        WorkbookRevisionDialog.this.createPopupMenu(WorkbookRevisionDialog.this.viewer.getControl());
                    }
                }
            });
        }
    }

    private void updateShellTitle() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (WorkbookRevisionDialog.this.shell != null && !WorkbookRevisionDialog.this.shell.isDisposed()) {
                    WorkbookRevisionDialog.this.shell.setText(WorkbookRevisionDialog.this.getTitleText());
                }
            }
        });
    }

    private void createDisableHyperlink(Composite parent) {
        boolean isAutoSave;
        final Hyperlink disableLink = new Hyperlink(parent, 4);
        disableLink.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        disableLink.setText(MindMapMessages.WorkbookRevisionDialog_Disable_hyperlink);
        disableLink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        boolean bl = isAutoSave = !V_NO.equals(this.getSheet().getOwnedWorkbook().getMeta().getValue(K_AUTO_SAVE));
        if (!isAutoSave) {
            disableLink.setEnabled(false);
        }
        disableLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Boolean isOk = MessageDialog.openConfirm((Shell)WorkbookRevisionDialog.this.shell, (String)DialogMessages.DisableRevisonDialog_Title_text, (String)DialogMessages.DisableRevisonDialog_Comfirm_message);
                if (isOk.booleanValue()) {
                    WorkbookRevisionDialog.this.disableRevision();
                    disableLink.setEnabled(false);
                    WorkbookRevisionDialog.this.close();
                }
            }
        });
    }

    private void disableRevision() {
        IWorkbook workbook = this.getSheet().getOwnedWorkbook();
        ModifyMetadataCommand command = new ModifyMetadataCommand(workbook, K_AUTO_SAVE, V_NO);
        command.setLabel(CommandMessages.Command_TurnOffAutoRevisionSaving);
        ICommandStack commandStack = this.getSourceEditor().getCommandStack();
        if (commandStack != null) {
            commandStack.execute((Command)command);
        } else {
            command.execute();
        }
    }

    private void restore() {
        this.revertToRevision(this.viewer.getSelection(), (IEditorPart)this.getSourceEditor());
    }

    private void preview() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IRevision revision = (IRevision)((IStructuredSelection)selection).getFirstElement();
        this.viewRevision(revision);
    }

    private void revertToRevision(ISelection selection, IEditorPart editor) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof IRevision)) {
            return;
        }
        IRevision revision = (IRevision)obj;
        if (!"application/vnd.xmind.sheet".equals(revision.getContentType())) {
            return;
        }
        IWorkbook workbook = revision.getOwnedWorkbook();
        final ISheet sourceSheet = (ISheet)workbook.findElement(revision.getResourceId(), null);
        ISheet targetSheet = (ISheet)workbook.importElement(revision.getContent());
        if (targetSheet == null) {
            return;
        }
        String title = targetSheet.getTitleText();
        targetSheet.setTitleText("#" + title);
        targetSheet.setTitleText(title);
        int sheetIndex = sourceSheet.getIndex();
        ArrayList<SourceCommand> commands = new ArrayList<SourceCommand>();
        ISheet placeholderSheet = workbook.createSheet();
        commands.add(new AddSheetCommand(placeholderSheet, workbook));
        commands.add(new DeleteSheetCommand(sourceSheet));
        commands.add(new AddSheetCommand(targetSheet, workbook, sheetIndex));
        commands.add(new DeleteSheetCommand(placeholderSheet, workbook));
        CompoundCommand command = new CompoundCommand(MindMapMessages.RevertToRevisionCommand_label, commands);
        final ICommandStack commandStack = editor == null ? null : MindMapUIPlugin.getAdapter(editor, ICommandStack.class);
        final IRevisionManager manager = revision.getOwnedManager();
        final IRevision latestRevision = manager.getLatestRevision();
        SafeRunner.run((ISafeRunnable)new SafeRunnable((Command)command){
            private final /* synthetic */ Command val$command;
            {
                this.val$command = command;
            }

            public void run() throws Exception {
                if (latestRevision == null || sourceSheet.getModifiedTime() > latestRevision.getTimestamp()) {
                    manager.addRevision((IAdaptable)sourceSheet);
                }
                if (commandStack != null) {
                    commandStack.execute(this.val$command);
                } else {
                    this.val$command.execute();
                }
            }
        });
    }

    private class CurrentSelectionProviderWrap
    implements ISelectionChangedListener {
        private ISelectionProvider selectionProvider = null;

        private CurrentSelectionProviderWrap() {
        }

        public void dispose() {
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                this.selectionProvider = null;
            }
        }

        public void notifySelectionChanges() {
            IWorkbenchWindow parentWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IEclipseContext context = ((WorkbenchWindow)parentWindow).getModel().getContext();
            context.remove("selection");
            if (this.selectionProvider != null) {
                IEvaluationService es = (IEvaluationService)parentWindow.getWorkbench().getService(IEvaluationService.class);
                es.getCurrentState().addVariable("selection", (Object)this.selectionProvider.getSelection());
            }
        }

        public void setSelectionProvider(ISelectionProvider selectionProvider) {
            if (selectionProvider == this.selectionProvider) {
                return;
            }
            ISelectionProvider oldSelectionProvider = this.selectionProvider;
            this.selectionProvider = selectionProvider;
            if (oldSelectionProvider != null) {
                oldSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (selectionProvider != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.notifySelectionChanges();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.notifySelectionChanges();
        }
    }

    public static class RevisionContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((IRevisionManager)inputElement).getRevisions().toArray();
        }
    }

    private static class RevisionDateTimeLabelProvider
    extends ColumnLabelProvider {
        private RevisionDateTimeLabelProvider() {
        }

        public String getText(Object element) {
            IRevision revision = (IRevision)element;
            return String.valueOf(String.format("%tF", revision.getTimestamp())) + "/" + String.format("%tT", revision.getTimestamp());
        }
    }

    private static class RevisionNumberLabelProvider
    extends ColumnLabelProvider {
        private RevisionNumberLabelProvider() {
        }

        public String getText(Object element) {
            IRevision revision = (IRevision)element;
            return String.valueOf(revision.getRevisionNumber());
        }
    }

    private class RevisionOpenListener
    implements IOpenListener {
        private RevisionOpenListener() {
        }

        public void open(OpenEvent event) {
            WorkbookRevisionDialog.this.handleOpen(event.getSelection());
        }
    }

    private static class VersionCloumnSorter
    extends ViewerSorter {
        private VersionCloumnSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IRevision revision1 = (IRevision)e1;
            IRevision revision2 = (IRevision)e2;
            if (revision1.getRevisionNumber() > revision2.getRevisionNumber()) {
                return -1;
            }
            if (revision1.getRevisionNumber() == revision2.getRevisionNumber()) {
                return 0;
            }
            return 1;
        }
    }
}

