/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.io.File;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.ui.dialogs.IDialogConstants;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.PrefUtils;

@Deprecated
public class OpenHomeMapAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow window;

    public OpenHomeMapAction(IWorkbenchWindow window) {
        super(MindMapMessages.OpenHomeMap_text);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.setId("org.xmind.ui.openHomeMap");
        this.setToolTipText(MindMapMessages.OpenHomeMap_toolTip);
        this.setActionDefinitionId("org.xmind.ui.command.openHomeMap");
    }

    public void run() {
        if (this.window == null) {
            return;
        }
        Shell shell = this.window.getShell();
        IWorkbenchPage page = this.window.getActivePage();
        OpenHomeMapAction.openHomeMap(shell, page);
    }

    public void dispose() {
        this.window = null;
    }

    public static boolean openHomeMap(final Shell shell, final IWorkbenchPage page) {
        final String path = MindMapUIPlugin.getDefault().getPreferenceStore().getString("homeMapLocation");
        if (path == null || "".equals(path)) {
            PrefUtils.openPrefDialog((Shell)shell, (String)"org.xmind.ui.prefPage.General");
            return false;
        }
        if (!new File(path).exists()) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String dialogMessage = MindMapMessages.OpenHomeMapAction_HomeMapMissingMessage;
                    String[] dialogButtonLabels = new String[]{org.eclipse.jface.dialogs.IDialogConstants.OK_LABEL, MindMapMessages.OpenHomeMapAction_LaterOperationButton};
                    int index = new MessageDialog(shell, IDialogConstants.COMMON_TITLE, null, dialogMessage, 4, dialogButtonLabels, 0).open();
                    if (index == 0) {
                        PrefUtils.openPrefDialog((Shell)shell, (String)"org.xmind.ui.prefPage.General");
                    }
                }
            });
            return false;
        }
        final boolean[] opened = new boolean[]{false};
        String errMessage = NLS.bind((String)DialogMessages.FailedToLoadWorkbook_message, (Object)path);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(errMessage){

            public void run() throws Exception {
                IEditorInput input = MindMapUI.getEditorInputFactory().createEditorInputForFile(new File(path));
                IEditorPart editor = page.openEditor(input, "org.xmind.ui.MindMapEditor");
                opened[0] = editor != null;
            }
        });
        return opened[0];
    }
}

