/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.xmind.core.command.binary.BinaryStore;
import org.xmind.core.command.binary.IBinaryEntry;
import org.xmind.core.command.binary.IBinaryStore;
import org.xmind.core.command.transfer.ChunkReader;
import org.xmind.core.command.transfer.ChunkWriter;

public class CommandTransferUtil {
    public static final String ENCODING = "UTF-8";
    public static final String MARKER_PROPERTIES = "[PROPERTIES]";
    public static final String MARKER_VALUES = "[VALUES]";
    public static final String MARKER_FILES = "[FILES]";

    private CommandTransferUtil() {
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str;
        }
    }

    public static String decode(String str) {
        try {
            return URLDecoder.decode(str, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IBinaryStore readFiles(IProgressMonitor monitor, ChunkReader reader) throws IOException {
        int numFiles;
        String numFilesStr = reader.readText();
        if (numFilesStr == null) {
            return null;
        }
        try {
            numFiles = Integer.parseInt(numFilesStr, 10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid format of files number: " + numFilesStr);
        }
        monitor.beginTask(null, numFiles);
        BinaryStore store = null;
        try {
            while (true) {
                String entryName;
                if ((entryName = reader.readText()) == null) {
                    return store;
                }
                if ("".equals(entryName)) return store;
                if (monitor.isCanceled()) {
                    return store;
                }
                InputStream chunkStream = reader.openNextChunkAsStream();
                if (chunkStream == null) continue;
                SubProgressMonitor fileMonitor = new SubProgressMonitor(monitor, 1);
                if (store == null) {
                    store = new BinaryStore();
                }
                store.addEntry((IProgressMonitor)fileMonitor, entryName, chunkStream);
                if (monitor.isCanceled()) {
                    return null;
                }
                fileMonitor.done();
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public static void writeFiles(IProgressMonitor monitor, IBinaryStore files, ChunkWriter writer) throws IOException {
        monitor.beginTask(null, files.size());
        writer.writeText(String.valueOf(files.size()));
        Iterator entryNames = files.entryNames();
        while (entryNames.hasNext()) {
            String entryName = (String)entryNames.next();
            IBinaryEntry entry = files.getEntry(entryName);
            writer.writeText(entryName);
            if (monitor.isCanceled()) {
                return;
            }
            if (entry != null && !entryName.endsWith("/")) {
                InputStream in = entry.openInputStream();
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    OutputStream out = writer.openNextChunkAsStream();
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = in.read(buffer)) > 0) {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            out.write(buffer, 0, read);
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.done();
    }
}

