/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.internal;

import java.util.ArrayList;
import java.util.List;
import net.xmind.verify.internal.VerifyPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.xmind.core.licensing.ILicenseAgent;
import org.xmind.core.licensing.ILicenseChangedListener;
import org.xmind.core.licensing.ILicenseKeyHeader;

public class LicenseAgent
implements ILicenseAgent {
    private int licenseType = 1;
    private String licenseeName = null;
    private ILicenseKeyHeader licenseKeyHeader = null;
    private final List<ILicenseChangedListener> listeners = new ArrayList<ILicenseChangedListener>();

    public int getLicenseType() {
        return this.licenseType;
    }

    public String getLicenseeName() {
        return this.licenseeName;
    }

    public ILicenseKeyHeader getLicenseKeyHeader() {
        return this.licenseKeyHeader;
    }

    public void addLicenseChangedListener(ILicenseChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeLicenseChangedListener(ILicenseChangedListener listener) {
        this.listeners.remove(listener);
    }

    void setLicenseInfo(int type, String licenseeName, ILicenseKeyHeader keyHeader) {
        int oldType = this.licenseType;
        String oldLicenseeName = this.licenseeName;
        ILicenseKeyHeader oldKeyHeader = this.licenseKeyHeader;
        boolean changed = false;
        changed |= type != oldType;
        changed |= licenseeName != oldLicenseeName && (licenseeName == null || !licenseeName.equals(oldLicenseeName));
        if (!(changed |= keyHeader != oldKeyHeader && (keyHeader == null || !keyHeader.equals(oldKeyHeader)))) {
            return;
        }
        this.licenseType = type;
        this.licenseeName = licenseeName;
        this.licenseKeyHeader = keyHeader;
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((ILicenseChangedListener)listener).licenseChanged((ILicenseAgent)this);
            }
            catch (Throwable e) {
                VerifyPlugin.getDefault().getLog().log((IStatus)new Status(4, "net.xmind.verify", null, e));
            }
            ++n2;
        }
        String licenseType = (type & 4) != 0 ? "Pro" : ((type & 8) != 0 ? "Plus" : ((type & 2) != 0 ? "Sub" : "Free"));
        System.setProperty("org.xmind.product.license_type", licenseType);
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (evaluationService != null) {
            evaluationService.requestEvaluation("org.xmind.product.license_type");
        }
    }

    public void activate() {
        VerifyPlugin.getDefault().setLicenseAgent(this);
    }

    public void deactivate() {
        VerifyPlugin.getDefault().setLicenseAgent(null);
    }
}

