/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.util.Cancelable;
import org.xmind.ui.util.ITimerValidator;

public class UITimer
extends Cancelable {
    private ISafeRunnable task;
    private int delay;
    private int interval;
    private int loops = -1;
    private int currentLoop = 0;
    private Runnable innerTask = null;
    private ITimerValidator validator = null;

    public UITimer(int delay, int interval, ISafeRunnable task) {
        this.task = task;
        this.delay = delay;
        this.interval = interval;
    }

    public UITimer(int delay, int interval, int loops, ISafeRunnable task) {
        this(delay, interval, task);
        this.loops = loops < 0 ? loops : Math.max(1, loops);
    }

    public void start() {
        this.reinitialize();
        this.run();
    }

    @Override
    protected void doJob() {
        if (!this.isValid()) {
            this.cancel();
            return;
        }
        this.innerTask = new InnerTask();
        Display display = Display.getCurrent();
        if (display != null && !display.isDisposed()) {
            display.timerExec(this.delay, this.innerTask);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.innerTask = null;
        this.onCanceled();
    }

    protected void onFinished() {
    }

    protected void onCanceled() {
    }

    protected void postCanceled() {
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public ISafeRunnable getTask() {
        return this.task;
    }

    public void setTask(ISafeRunnable task) {
        this.task = task;
    }

    public int getLoops() {
        return this.loops;
    }

    public void setLoops(int times) {
        this.loops = times;
    }

    public int getCurrentLoop() {
        return this.currentLoop;
    }

    public void setValidator(ITimerValidator validator) {
        this.validator = validator;
    }

    public ITimerValidator getValidator() {
        return this.validator;
    }

    protected boolean isValid() {
        return this.validator == null || this.validator.isRunnable();
    }

    private class InnerTask
    implements Runnable {
        private InnerTask() {
        }

        @Override
        public void run() {
            if (UITimer.this.isCanceled()) {
                return;
            }
            if (!UITimer.this.isValid()) {
                UITimer.this.cancel();
                return;
            }
            if (UITimer.this.loops > 0) {
                if (UITimer.this.currentLoop >= UITimer.this.loops) {
                    UITimer.this.currentLoop = 0;
                    UITimer.this.innerTask = null;
                    UITimer.this.onFinished();
                    return;
                }
                UITimer uITimer = UITimer.this;
                uITimer.currentLoop = uITimer.currentLoop + 1;
            }
            long start = System.currentTimeMillis();
            SafeRunner.run((ISafeRunnable)UITimer.this.task);
            long end = System.currentTimeMillis();
            if (UITimer.this.isCanceled()) {
                UITimer.this.innerTask = null;
                UITimer.this.postCanceled();
            } else {
                Display display = Display.getCurrent();
                if (display == null || display.isDisposed()) {
                    UITimer.this.postCanceled();
                } else if (UITimer.this.innerTask != null) {
                    int taskDuration = (int)(end - start);
                    if (taskDuration >= UITimer.this.interval) {
                        display.asyncExec(UITimer.this.innerTask);
                    } else {
                        int nextInterval = UITimer.this.interval - taskDuration;
                        display.timerExec(nextInterval, UITimer.this.innerTask);
                    }
                }
            }
        }
    }
}

