---
layout: default
title: ICU 77
nav_order: 899
has_children: false
parent: Downloading ICU
---

<!--
© 2025 and later: Unicode, Inc. and others.
License & terms of use: http://www.unicode.org/copyright.html
-->

# ICU 77

ICU is the [premier library for software internationalization](https://icu.unicode.org/#h.i33fakvpjb7o),
used by a [wide array of companies and organizations](https://icu.unicode.org/#h.f9qwubthqabj).

## Release Overview

* Download: [releases/tag/release-77-1](https://github.com/unicode-org/icu/releases/tag/release-77-1)
* [Maven: com.ibm.icu / icu4j / version 77.1](https://mvnrepository.com/artifact/com.ibm.icu/icu4j/77.1)

ICU 77 updates to
[CLDR 47](https://cldr.unicode.org/downloads/cldr-47)
([beta blog](https://blog.unicode.org/2025/02/unicode-cldr-47-beta-available-for.html))
locale data with new locales, and various additions and corrections.

ICU 77 is mostly focused on bug fixes, segmentation conformance, and other refinements.

The Java technology preview implementation of the CLDR MessageFormat 2.0 specification has been updated to incorporate the
[CLDR 46.1 spec](https://www.unicode.org/reports/tr35/tr35-74/tr35-messageFormat.html)
plus most but not all of the CLDR 47 changes.

The C++ technology preview implementation of MessageFormat 2.0 is not yet quite up to date with CLDR 46.1.

For more details, including migration issues, see below.

Please use the [icu-support mailing list](https://icu.unicode.org/contacts) and/or [find/submit error reports](https://icu.unicode.org/bugs).

### Attention: Future Changes

Beginning with ICU 78 (2025-oct):

1. We want to move the minimum required Java version from Java 8 to Java 11.
   This is a significant, useful update in terms of the Java language and
   standard library, and simplifies ICU tooling which currently uses
   a mix of Java 8 and Java 11.
   Note that [Android desugaring](https://developer.android.com/studio/write/java11-default-support-table)
   supports at least Java 11 since late 2023.\
   See [ICU-23072](https://unicode-org.atlassian.net/browse/ICU-23072)
   where you can provide comments.
2. We are planning to remove the
   [ICU4J Locale Service Provider](../userguide/icu4j/locale-service-provider.md)
   ([Maven: com.ibm.icu / icu4j-localespi / version 76.1](https://mvnrepository.com/artifact/com.ibm.icu/icu4j-localespi/76.1)).
   It is much less useful than when we added it, has very low usage,
   needs work for newer Java versions, and complicates ICU4J development.\
   See [ICU-23071](https://unicode-org.atlassian.net/browse/ICU-23071)
   where you can provide comments.

### Version Number

The initial release has library version number 77.1.

* Release date: 2025-03-13
  * [List of tickets fixed in ICU 77](https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20ICU%20AND%20status%20%3D%20Done%20AND%20resolution%20in%20%28Fixed%2C%20%22Fixed%20by%20Other%20Ticket%22%29%20AND%20fixVersion%20%3D%2077.1%20ORDER%20BY%20component%20ASC%2C%20created%20DESC)

If there are maintenance releases, they will be 77.2, 77.3, etc. (During ICU 77 development, the library version number was 77.0.x.)

Note: There may be additional commits on the [maint/maint-77](https://github.com/unicode-org/icu/tree/maint/maint-77) branch that are not included in the prepackaged download files.

## Common Changes

* [CLDR 47](https://cldr.unicode.org/downloads/cldr-47)
  ([beta blog](https://blog.unicode.org/2025/02/unicode-cldr-47-beta-available-for.html)):
  * No major data collection for existing locales; focus on bug fixes and structural improvements
  * New regional variants: English in several European countries, and Cantonese in Macau (`yue_Hant_MO`)
  * Improved RBNF (number spellout) and transliteration data
* Subtle segmentation changes to make ICU fully conform to Unicode 16
  * Word break: Root tailoring of colon reverted, Swedish & Finnish tailorings removed
    ([ICU-22941](https://unicode-org.atlassian.net/browse/ICU-22941))
    * These tailorings were introduced in ICU 72, but feedback has been negative,
      and the UTC declined to adopt these changes.
  * Line break: Fixed a bug in the line breaking of obscure sequences
    ⟨no-break space, combining mark, hyphen, alphabetic character⟩
    ([ICU-22986](https://unicode-org.atlassian.net/browse/ICU-22986)).
  * Updated Indic grapheme clusters to use the latest `Indic_Conjunct_Break` data
    ([ICU-22956](https://unicode-org.atlassian.net/browse/ICU-22956))
* Time zone data (tzdata) version 2025a (2025-jan).

## ICU4C Specific Changes

* [API changes since ICU4C 76 (Markdown)](https://github.com/unicode-org/icu/blob/maint/maint-77/icu4c/APIChangeReport.md) / [(HTML)](https://htmlpreview.github.io/?https://github.com/unicode-org/icu/blob/maint/maint-77/icu4c/APIChangeReport.html)
  * New APIs for colloquial C++ use of C USet ([ICU-22876](https://unicode-org.atlassian.net/browse/ICU-22876))
    and C UCollator ([ICU-22879](https://unicode-org.atlassian.net/browse/ICU-22879))
    * These were added in ICU 76, but some of the new APIs did not actually compile with `U_SHOW_CPLUSPLUS_API=0`.
      They have been fixed in ICU 77 and thoroughly tested.
      USetElementIterator now returns std::u16string instead of icu::UnicodeString,
      and therefore it and related APIs have been changed to `@draft ICU 77`.
      ([ICU-22954](https://unicode-org.atlassian.net/browse/ICU-22954))
    * For details about these APIs and an example see the
      “C++ Header-Only APIs” section of the [ICU 76 Migration Issues](76.md#migration-issues).

## ICU4J Specific Changes

* [API Changes since ICU4J 76](https://htmlpreview.github.io/?https://github.com/unicode-org/icu/blob/maint/maint-77/icu4j/APIChangeReport.html)
* The Java technology preview implementation of the CLDR MessageFormat 2.0 specification has been updated to incorporate the
  [CLDR 46.1 spec](https://www.unicode.org/reports/tr35/tr35-74/tr35-messageFormat.html)
  plus most but not all of the CLDR 47 changes.

## Known Issues

* The new MeasureUnit for `portion-per-1e9` works for formatting,
  but when the new member function `getConstantDenominator()` is called on this unit,
  it incorrectly returns 0. ([ICU-23045](https://unicode-org.atlassian.net/browse/ICU-23045))

## Migration Issues

* (none yet)

### Migration Issues Related to CLDR
* See [CLDR 47 migration issues](https://cldr.unicode.org/downloads/cldr-47#migration)

## ICU4C Platform Support

ICU4C requires C++17 and has been tested with up to C++20.

We routinely test on recent versions of Linux, macOS, and Windows.

We accept patches for other platforms.

Windows: The minimum supported version is Windows 7. (See [How To Build And Install On Windows](../userguide/icu4c/build.html#how-to-build-and-install-on-windows) for more details.)

## ICU4J Platform Support

ICU4J works on Java 8..21 (at least).

ICU4J should work on Android API level 21 and later but may require “[library desugaring](https://developer.android.com/studio/write/java8-support#library-desugaring)”.

## Download

### GitHub
Source and binary downloads are available on the git/GitHub tag page: <https://github.com/unicode-org/icu/releases/tag/release-77-1>

See the [Source Code Setup](../devsetup/source/) page for how to download the ICU file tree directly from GitHub.

ICU locale data was generated from CLDR data equivalent to:

* <https://github.com/unicode-org/cldr/releases/tag/release-47>
* <https://github.com/unicode-org/cldr-staging/releases/tag/release-47>

### Maven
* https://mvnrepository.com/artifact/com.ibm.icu/icu4j/77.1
* https://mvnrepository.com/artifact/com.ibm.icu/icu4j-charset/77.1
* https://mvnrepository.com/artifact/com.ibm.icu/icu4j-localespi/77.1
