#include <stddef.h>

#include "disassembler/arm64dis.h"

Register* v_unpack_lookup[15][32] = {
    {// ARRSPEC_NONE = 0
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}, (Register[]) {REG_NONE},
        (Register[]) {REG_NONE}, (Register[]) {REG_NONE}},
    {// ARRSPEC_FULL = 1
        (Register[]) {REG_V0}, (Register[]) {REG_V1}, (Register[]) {REG_V2}, (Register[]) {REG_V3},
        (Register[]) {REG_V4}, (Register[]) {REG_V5}, (Register[]) {REG_V6}, (Register[]) {REG_V7},
        (Register[]) {REG_V8}, (Register[]) {REG_V9}, (Register[]) {REG_V10},
        (Register[]) {REG_V11}, (Register[]) {REG_V12}, (Register[]) {REG_V13},
        (Register[]) {REG_V14}, (Register[]) {REG_V15}, (Register[]) {REG_V16},
        (Register[]) {REG_V17}, (Register[]) {REG_V18}, (Register[]) {REG_V19},
        (Register[]) {REG_V20}, (Register[]) {REG_V21}, (Register[]) {REG_V22},
        (Register[]) {REG_V23}, (Register[]) {REG_V24}, (Register[]) {REG_V25},
        (Register[]) {REG_V26}, (Register[]) {REG_V27}, (Register[]) {REG_V28},
        (Register[]) {REG_V29}, (Register[]) {REG_V30}, (Register[]) {REG_V31}},
    {// ARRSPEC_2DOUBLES = 2
        (Register[]) {REG_V0_D0, REG_V0_D1}, (Register[]) {REG_V1_D0, REG_V1_D1},
        (Register[]) {REG_V2_D0, REG_V2_D1}, (Register[]) {REG_V3_D0, REG_V3_D1},
        (Register[]) {REG_V4_D0, REG_V4_D1}, (Register[]) {REG_V5_D0, REG_V5_D1},
        (Register[]) {REG_V6_D0, REG_V6_D1}, (Register[]) {REG_V7_D0, REG_V7_D1},
        (Register[]) {REG_V8_D0, REG_V8_D1}, (Register[]) {REG_V9_D0, REG_V9_D1},
        (Register[]) {REG_V10_D0, REG_V10_D1}, (Register[]) {REG_V11_D0, REG_V11_D1},
        (Register[]) {REG_V12_D0, REG_V12_D1}, (Register[]) {REG_V13_D0, REG_V13_D1},
        (Register[]) {REG_V14_D0, REG_V14_D1}, (Register[]) {REG_V15_D0, REG_V15_D1},
        (Register[]) {REG_V16_D0, REG_V16_D1}, (Register[]) {REG_V17_D0, REG_V17_D1},
        (Register[]) {REG_V18_D0, REG_V18_D1}, (Register[]) {REG_V19_D0, REG_V19_D1},
        (Register[]) {REG_V20_D0, REG_V20_D1}, (Register[]) {REG_V21_D0, REG_V21_D1},
        (Register[]) {REG_V22_D0, REG_V22_D1}, (Register[]) {REG_V23_D0, REG_V23_D1},
        (Register[]) {REG_V24_D0, REG_V24_D1}, (Register[]) {REG_V25_D0, REG_V25_D1},
        (Register[]) {REG_V26_D0, REG_V26_D1}, (Register[]) {REG_V27_D0, REG_V27_D1},
        (Register[]) {REG_V28_D0, REG_V28_D1}, (Register[]) {REG_V29_D0, REG_V29_D1},
        (Register[]) {REG_V30_D0, REG_V30_D1}, (Register[]) {REG_V31_D0, REG_V31_D1}},
    {// ARRSPEC_4SINGLES = 3
        (Register[]) {REG_V0_S0, REG_V0_S1, REG_V0_S2, REG_V0_S3},
        (Register[]) {REG_V1_S0, REG_V1_S1, REG_V1_S2, REG_V1_S3},
        (Register[]) {REG_V2_S0, REG_V2_S1, REG_V2_S2, REG_V2_S3},
        (Register[]) {REG_V3_S0, REG_V3_S1, REG_V3_S2, REG_V3_S3},
        (Register[]) {REG_V4_S0, REG_V4_S1, REG_V4_S2, REG_V4_S3},
        (Register[]) {REG_V5_S0, REG_V5_S1, REG_V5_S2, REG_V5_S3},
        (Register[]) {REG_V6_S0, REG_V6_S1, REG_V6_S2, REG_V6_S3},
        (Register[]) {REG_V7_S0, REG_V7_S1, REG_V7_S2, REG_V7_S3},
        (Register[]) {REG_V8_S0, REG_V8_S1, REG_V8_S2, REG_V8_S3},
        (Register[]) {REG_V9_S0, REG_V9_S1, REG_V9_S2, REG_V9_S3},
        (Register[]) {REG_V10_S0, REG_V10_S1, REG_V10_S2, REG_V10_S3},
        (Register[]) {REG_V11_S0, REG_V11_S1, REG_V11_S2, REG_V11_S3},
        (Register[]) {REG_V12_S0, REG_V12_S1, REG_V12_S2, REG_V12_S3},
        (Register[]) {REG_V13_S0, REG_V13_S1, REG_V13_S2, REG_V13_S3},
        (Register[]) {REG_V14_S0, REG_V14_S1, REG_V14_S2, REG_V14_S3},
        (Register[]) {REG_V15_S0, REG_V15_S1, REG_V15_S2, REG_V15_S3},
        (Register[]) {REG_V16_S0, REG_V16_S1, REG_V16_S2, REG_V16_S3},
        (Register[]) {REG_V17_S0, REG_V17_S1, REG_V17_S2, REG_V17_S3},
        (Register[]) {REG_V18_S0, REG_V18_S1, REG_V18_S2, REG_V18_S3},
        (Register[]) {REG_V19_S0, REG_V19_S1, REG_V19_S2, REG_V19_S3},
        (Register[]) {REG_V20_S0, REG_V20_S1, REG_V20_S2, REG_V20_S3},
        (Register[]) {REG_V21_S0, REG_V21_S1, REG_V21_S2, REG_V21_S3},
        (Register[]) {REG_V22_S0, REG_V22_S1, REG_V22_S2, REG_V22_S3},
        (Register[]) {REG_V23_S0, REG_V23_S1, REG_V23_S2, REG_V23_S3},
        (Register[]) {REG_V24_S0, REG_V24_S1, REG_V24_S2, REG_V24_S3},
        (Register[]) {REG_V25_S0, REG_V25_S1, REG_V25_S2, REG_V25_S3},
        (Register[]) {REG_V26_S0, REG_V26_S1, REG_V26_S2, REG_V26_S3},
        (Register[]) {REG_V27_S0, REG_V27_S1, REG_V27_S2, REG_V27_S3},
        (Register[]) {REG_V28_S0, REG_V28_S1, REG_V28_S2, REG_V28_S3},
        (Register[]) {REG_V29_S0, REG_V29_S1, REG_V29_S2, REG_V29_S3},
        (Register[]) {REG_V30_S0, REG_V30_S1, REG_V30_S2, REG_V30_S3},
        (Register[]) {REG_V31_S0, REG_V31_S1, REG_V31_S2, REG_V31_S3}},
    {// ARRSPEC_8HALVES = 4
        (Register[]) {
            REG_V0_H0, REG_V0_H1, REG_V0_H2, REG_V0_H3, REG_V0_H4, REG_V0_H5, REG_V0_H6, REG_V0_H7},
        (Register[]) {
            REG_V1_H0, REG_V1_H1, REG_V1_H2, REG_V1_H3, REG_V1_H4, REG_V1_H5, REG_V1_H6, REG_V1_H7},
        (Register[]) {
            REG_V2_H0, REG_V2_H1, REG_V2_H2, REG_V2_H3, REG_V2_H4, REG_V2_H5, REG_V2_H6, REG_V2_H7},
        (Register[]) {
            REG_V3_H0, REG_V3_H1, REG_V3_H2, REG_V3_H3, REG_V3_H4, REG_V3_H5, REG_V3_H6, REG_V3_H7},
        (Register[]) {
            REG_V4_H0, REG_V4_H1, REG_V4_H2, REG_V4_H3, REG_V4_H4, REG_V4_H5, REG_V4_H6, REG_V4_H7},
        (Register[]) {
            REG_V5_H0, REG_V5_H1, REG_V5_H2, REG_V5_H3, REG_V5_H4, REG_V5_H5, REG_V5_H6, REG_V5_H7},
        (Register[]) {
            REG_V6_H0, REG_V6_H1, REG_V6_H2, REG_V6_H3, REG_V6_H4, REG_V6_H5, REG_V6_H6, REG_V6_H7},
        (Register[]) {
            REG_V7_H0, REG_V7_H1, REG_V7_H2, REG_V7_H3, REG_V7_H4, REG_V7_H5, REG_V7_H6, REG_V7_H7},
        (Register[]) {
            REG_V8_H0, REG_V8_H1, REG_V8_H2, REG_V8_H3, REG_V8_H4, REG_V8_H5, REG_V8_H6, REG_V8_H7},
        (Register[]) {
            REG_V9_H0, REG_V9_H1, REG_V9_H2, REG_V9_H3, REG_V9_H4, REG_V9_H5, REG_V9_H6, REG_V9_H7},
        (Register[]) {REG_V10_H0, REG_V10_H1, REG_V10_H2, REG_V10_H3, REG_V10_H4, REG_V10_H5,
            REG_V10_H6, REG_V10_H7},
        (Register[]) {REG_V11_H0, REG_V11_H1, REG_V11_H2, REG_V11_H3, REG_V11_H4, REG_V11_H5,
            REG_V11_H6, REG_V11_H7},
        (Register[]) {REG_V12_H0, REG_V12_H1, REG_V12_H2, REG_V12_H3, REG_V12_H4, REG_V12_H5,
            REG_V12_H6, REG_V12_H7},
        (Register[]) {REG_V13_H0, REG_V13_H1, REG_V13_H2, REG_V13_H3, REG_V13_H4, REG_V13_H5,
            REG_V13_H6, REG_V13_H7},
        (Register[]) {REG_V14_H0, REG_V14_H1, REG_V14_H2, REG_V14_H3, REG_V14_H4, REG_V14_H5,
            REG_V14_H6, REG_V14_H7},
        (Register[]) {REG_V15_H0, REG_V15_H1, REG_V15_H2, REG_V15_H3, REG_V15_H4, REG_V15_H5,
            REG_V15_H6, REG_V15_H7},
        (Register[]) {REG_V16_H0, REG_V16_H1, REG_V16_H2, REG_V16_H3, REG_V16_H4, REG_V16_H5,
            REG_V16_H6, REG_V16_H7},
        (Register[]) {REG_V17_H0, REG_V17_H1, REG_V17_H2, REG_V17_H3, REG_V17_H4, REG_V17_H5,
            REG_V17_H6, REG_V17_H7},
        (Register[]) {REG_V18_H0, REG_V18_H1, REG_V18_H2, REG_V18_H3, REG_V18_H4, REG_V18_H5,
            REG_V18_H6, REG_V18_H7},
        (Register[]) {REG_V19_H0, REG_V19_H1, REG_V19_H2, REG_V19_H3, REG_V19_H4, REG_V19_H5,
            REG_V19_H6, REG_V19_H7},
        (Register[]) {REG_V20_H0, REG_V20_H1, REG_V20_H2, REG_V20_H3, REG_V20_H4, REG_V20_H5,
            REG_V20_H6, REG_V20_H7},
        (Register[]) {REG_V21_H0, REG_V21_H1, REG_V21_H2, REG_V21_H3, REG_V21_H4, REG_V21_H5,
            REG_V21_H6, REG_V21_H7},
        (Register[]) {REG_V22_H0, REG_V22_H1, REG_V22_H2, REG_V22_H3, REG_V22_H4, REG_V22_H5,
            REG_V22_H6, REG_V22_H7},
        (Register[]) {REG_V23_H0, REG_V23_H1, REG_V23_H2, REG_V23_H3, REG_V23_H4, REG_V23_H5,
            REG_V23_H6, REG_V23_H7},
        (Register[]) {REG_V24_H0, REG_V24_H1, REG_V24_H2, REG_V24_H3, REG_V24_H4, REG_V24_H5,
            REG_V24_H6, REG_V24_H7},
        (Register[]) {REG_V25_H0, REG_V25_H1, REG_V25_H2, REG_V25_H3, REG_V25_H4, REG_V25_H5,
            REG_V25_H6, REG_V25_H7},
        (Register[]) {REG_V26_H0, REG_V26_H1, REG_V26_H2, REG_V26_H3, REG_V26_H4, REG_V26_H5,
            REG_V26_H6, REG_V26_H7},
        (Register[]) {REG_V27_H0, REG_V27_H1, REG_V27_H2, REG_V27_H3, REG_V27_H4, REG_V27_H5,
            REG_V27_H6, REG_V27_H7},
        (Register[]) {REG_V28_H0, REG_V28_H1, REG_V28_H2, REG_V28_H3, REG_V28_H4, REG_V28_H5,
            REG_V28_H6, REG_V28_H7},
        (Register[]) {REG_V29_H0, REG_V29_H1, REG_V29_H2, REG_V29_H3, REG_V29_H4, REG_V29_H5,
            REG_V29_H6, REG_V29_H7},
        (Register[]) {REG_V30_H0, REG_V30_H1, REG_V30_H2, REG_V30_H3, REG_V30_H4, REG_V30_H5,
            REG_V30_H6, REG_V30_H7},
        (Register[]) {REG_V31_H0, REG_V31_H1, REG_V31_H2, REG_V31_H3, REG_V31_H4, REG_V31_H5,
            REG_V31_H6, REG_V31_H7}},
    {
        // ARRSPEC_16BYTES = 5
        (Register[]) {REG_V0_B0, REG_V0_B1, REG_V0_B2, REG_V0_B3, REG_V0_B4, REG_V0_B5, REG_V0_B6,
            REG_V0_B7, REG_V0_B8, REG_V0_B9, REG_V0_B10, REG_V0_B11, REG_V0_B12, REG_V0_B13,
            REG_V0_B14, REG_V0_B15},
        (Register[]) {REG_V1_B0, REG_V1_B1, REG_V1_B2, REG_V1_B3, REG_V1_B4, REG_V1_B5, REG_V1_B6,
            REG_V1_B7, REG_V1_B8, REG_V1_B9, REG_V1_B10, REG_V1_B11, REG_V1_B12, REG_V1_B13,
            REG_V1_B14, REG_V1_B15},
        (Register[]) {REG_V2_B0, REG_V2_B1, REG_V2_B2, REG_V2_B3, REG_V2_B4, REG_V2_B5, REG_V2_B6,
            REG_V2_B7, REG_V2_B8, REG_V2_B9, REG_V2_B10, REG_V2_B11, REG_V2_B12, REG_V2_B13,
            REG_V2_B14, REG_V2_B15},
        (Register[]) {REG_V3_B0, REG_V3_B1, REG_V3_B2, REG_V3_B3, REG_V3_B4, REG_V3_B5, REG_V3_B6,
            REG_V3_B7, REG_V3_B8, REG_V3_B9, REG_V3_B10, REG_V3_B11, REG_V3_B12, REG_V3_B13,
            REG_V3_B14, REG_V3_B15},
        (Register[]) {REG_V4_B0, REG_V4_B1, REG_V4_B2, REG_V4_B3, REG_V4_B4, REG_V4_B5, REG_V4_B6,
            REG_V4_B7, REG_V4_B8, REG_V4_B9, REG_V4_B10, REG_V4_B11, REG_V4_B12, REG_V4_B13,
            REG_V4_B14, REG_V4_B15},
        (Register[]) {REG_V5_B0, REG_V5_B1, REG_V5_B2, REG_V5_B3, REG_V5_B4, REG_V5_B5, REG_V5_B6,
            REG_V5_B7, REG_V5_B8, REG_V5_B9, REG_V5_B10, REG_V5_B11, REG_V5_B12, REG_V5_B13,
            REG_V5_B14, REG_V5_B15},
        (Register[]) {REG_V6_B0, REG_V6_B1, REG_V6_B2, REG_V6_B3, REG_V6_B4, REG_V6_B5, REG_V6_B6,
            REG_V6_B7, REG_V6_B8, REG_V6_B9, REG_V6_B10, REG_V6_B11, REG_V6_B12, REG_V6_B13,
            REG_V6_B14, REG_V6_B15},
        (Register[]) {REG_V7_B0, REG_V7_B1, REG_V7_B2, REG_V7_B3, REG_V7_B4, REG_V7_B5, REG_V7_B6,
            REG_V7_B7, REG_V7_B8, REG_V7_B9, REG_V7_B10, REG_V7_B11, REG_V7_B12, REG_V7_B13,
            REG_V7_B14, REG_V7_B15},
        (Register[]) {REG_V8_B0, REG_V8_B1, REG_V8_B2, REG_V8_B3, REG_V8_B4, REG_V8_B5, REG_V8_B6,
            REG_V8_B7, REG_V8_B8, REG_V8_B9, REG_V8_B10, REG_V8_B11, REG_V8_B12, REG_V8_B13,
            REG_V8_B14, REG_V8_B15},
        (Register[]) {REG_V9_B0, REG_V9_B1, REG_V9_B2, REG_V9_B3, REG_V9_B4, REG_V9_B5, REG_V9_B6,
            REG_V9_B7, REG_V9_B8, REG_V9_B9, REG_V9_B10, REG_V9_B11, REG_V9_B12, REG_V9_B13,
            REG_V9_B14, REG_V9_B15},
        (Register[]) {REG_V10_B0, REG_V10_B1, REG_V10_B2, REG_V10_B3, REG_V10_B4, REG_V10_B5,
            REG_V10_B6, REG_V10_B7, REG_V10_B8, REG_V10_B9, REG_V10_B10, REG_V10_B11, REG_V10_B12,
            REG_V10_B13, REG_V10_B14, REG_V10_B15},
        (Register[]) {REG_V11_B0, REG_V11_B1, REG_V11_B2, REG_V11_B3, REG_V11_B4, REG_V11_B5,
            REG_V11_B6, REG_V11_B7, REG_V11_B8, REG_V11_B9, REG_V11_B10, REG_V11_B11, REG_V11_B12,
            REG_V11_B13, REG_V11_B14, REG_V11_B15},
        (Register[]) {REG_V12_B0, REG_V12_B1, REG_V12_B2, REG_V12_B3, REG_V12_B4, REG_V12_B5,
            REG_V12_B6, REG_V12_B7, REG_V12_B8, REG_V12_B9, REG_V12_B10, REG_V12_B11, REG_V12_B12,
            REG_V12_B13, REG_V12_B14, REG_V12_B15},
        (Register[]) {REG_V13_B0, REG_V13_B1, REG_V13_B2, REG_V13_B3, REG_V13_B4, REG_V13_B5,
            REG_V13_B6, REG_V13_B7, REG_V13_B8, REG_V13_B9, REG_V13_B10, REG_V13_B11, REG_V13_B12,
            REG_V13_B13, REG_V13_B14, REG_V13_B15},
        (Register[]) {REG_V14_B0, REG_V14_B1, REG_V14_B2, REG_V14_B3, REG_V14_B4, REG_V14_B5,
            REG_V14_B6, REG_V14_B7, REG_V14_B8, REG_V14_B9, REG_V14_B10, REG_V14_B11, REG_V14_B12,
            REG_V14_B13, REG_V14_B14, REG_V14_B15},
        (Register[]) {REG_V15_B0, REG_V15_B1, REG_V15_B2, REG_V15_B3, REG_V15_B4, REG_V15_B5,
            REG_V15_B6, REG_V15_B7, REG_V15_B8, REG_V15_B9, REG_V15_B10, REG_V15_B11, REG_V15_B12,
            REG_V15_B13, REG_V15_B14, REG_V15_B15},
        (Register[]) {REG_V16_B0, REG_V16_B1, REG_V16_B2, REG_V16_B3, REG_V16_B4, REG_V16_B5,
            REG_V16_B6, REG_V16_B7, REG_V16_B8, REG_V16_B9, REG_V16_B10, REG_V16_B11, REG_V16_B12,
            REG_V16_B13, REG_V16_B14, REG_V16_B15},
        (Register[]) {REG_V17_B0, REG_V17_B1, REG_V17_B2, REG_V17_B3, REG_V17_B4, REG_V17_B5,
            REG_V17_B6, REG_V17_B7, REG_V17_B8, REG_V17_B9, REG_V17_B10, REG_V17_B11, REG_V17_B12,
            REG_V17_B13, REG_V17_B14, REG_V17_B15},
        (Register[]) {REG_V18_B0, REG_V18_B1, REG_V18_B2, REG_V18_B3, REG_V18_B4, REG_V18_B5,
            REG_V18_B6, REG_V18_B7, REG_V18_B8, REG_V18_B9, REG_V18_B10, REG_V18_B11, REG_V18_B12,
            REG_V18_B13, REG_V18_B14, REG_V18_B15},
        (Register[]) {REG_V19_B0, REG_V19_B1, REG_V19_B2, REG_V19_B3, REG_V19_B4, REG_V19_B5,
            REG_V19_B6, REG_V19_B7, REG_V19_B8, REG_V19_B9, REG_V19_B10, REG_V19_B11, REG_V19_B12,
            REG_V19_B13, REG_V19_B14, REG_V19_B15},
        (Register[]) {REG_V20_B0, REG_V20_B1, REG_V20_B2, REG_V20_B3, REG_V20_B4, REG_V20_B5,
            REG_V20_B6, REG_V20_B7, REG_V20_B8, REG_V20_B9, REG_V20_B10, REG_V20_B11, REG_V20_B12,
            REG_V20_B13, REG_V20_B14, REG_V20_B15},
        (Register[]) {REG_V21_B0, REG_V21_B1, REG_V21_B2, REG_V21_B3, REG_V21_B4, REG_V21_B5,
            REG_V21_B6, REG_V21_B7, REG_V21_B8, REG_V21_B9, REG_V21_B10, REG_V21_B11, REG_V21_B12,
            REG_V21_B13, REG_V21_B14, REG_V21_B15},
        (Register[]) {REG_V22_B0, REG_V22_B1, REG_V22_B2, REG_V22_B3, REG_V22_B4, REG_V22_B5,
            REG_V22_B6, REG_V22_B7, REG_V22_B8, REG_V22_B9, REG_V22_B10, REG_V22_B11, REG_V22_B12,
            REG_V22_B13, REG_V22_B14, REG_V22_B15},
        (Register[]) {REG_V23_B0, REG_V23_B1, REG_V23_B2, REG_V23_B3, REG_V23_B4, REG_V23_B5,
            REG_V23_B6, REG_V23_B7, REG_V23_B8, REG_V23_B9, REG_V23_B10, REG_V23_B11, REG_V23_B12,
            REG_V23_B13, REG_V23_B14, REG_V23_B15},
        (Register[]) {REG_V24_B0, REG_V24_B1, REG_V24_B2, REG_V24_B3, REG_V24_B4, REG_V24_B5,
            REG_V24_B6, REG_V24_B7, REG_V24_B8, REG_V24_B9, REG_V24_B10, REG_V24_B11, REG_V24_B12,
            REG_V24_B13, REG_V24_B14, REG_V24_B15},
        (Register[]) {REG_V25_B0, REG_V25_B1, REG_V25_B2, REG_V25_B3, REG_V25_B4, REG_V25_B5,
            REG_V25_B6, REG_V25_B7, REG_V25_B8, REG_V25_B9, REG_V25_B10, REG_V25_B11, REG_V25_B12,
            REG_V25_B13, REG_V25_B14, REG_V25_B15},
        (Register[]) {REG_V26_B0, REG_V26_B1, REG_V26_B2, REG_V26_B3, REG_V26_B4, REG_V26_B5,
            REG_V26_B6, REG_V26_B7, REG_V26_B8, REG_V26_B9, REG_V26_B10, REG_V26_B11, REG_V26_B12,
            REG_V26_B13, REG_V26_B14, REG_V26_B15},
        (Register[]) {REG_V27_B0, REG_V27_B1, REG_V27_B2, REG_V27_B3, REG_V27_B4, REG_V27_B5,
            REG_V27_B6, REG_V27_B7, REG_V27_B8, REG_V27_B9, REG_V27_B10, REG_V27_B11, REG_V27_B12,
            REG_V27_B13, REG_V27_B14, REG_V27_B15},
        (Register[]) {REG_V28_B0, REG_V28_B1, REG_V28_B2, REG_V28_B3, REG_V28_B4, REG_V28_B5,
            REG_V28_B6, REG_V28_B7, REG_V28_B8, REG_V28_B9, REG_V28_B10, REG_V28_B11, REG_V28_B12,
            REG_V28_B13, REG_V28_B14, REG_V28_B15},
        (Register[]) {REG_V29_B0, REG_V29_B1, REG_V29_B2, REG_V29_B3, REG_V29_B4, REG_V29_B5,
            REG_V29_B6, REG_V29_B7, REG_V29_B8, REG_V29_B9, REG_V29_B10, REG_V29_B11, REG_V29_B12,
            REG_V29_B13, REG_V29_B14, REG_V29_B15},
        (Register[]) {REG_V30_B0, REG_V30_B1, REG_V30_B2, REG_V30_B3, REG_V30_B4, REG_V30_B5,
            REG_V30_B6, REG_V30_B7, REG_V30_B8, REG_V30_B9, REG_V30_B10, REG_V30_B11, REG_V30_B12,
            REG_V30_B13, REG_V30_B14, REG_V30_B15},
        (Register[]) {REG_V31_B0, REG_V31_B1, REG_V31_B2, REG_V31_B3, REG_V31_B4, REG_V31_B5,
            REG_V31_B6, REG_V31_B7, REG_V31_B8, REG_V31_B9, REG_V31_B10, REG_V31_B11, REG_V31_B12,
            REG_V31_B13, REG_V31_B14, REG_V31_B15},
    },
    {// ARRSPEC_1DOUBLE = 6
        (Register[]) {REG_V0_D0}, (Register[]) {REG_V1_D0}, (Register[]) {REG_V2_D0},
        (Register[]) {REG_V3_D0}, (Register[]) {REG_V4_D0}, (Register[]) {REG_V5_D0},
        (Register[]) {REG_V6_D0}, (Register[]) {REG_V7_D0}, (Register[]) {REG_V8_D0},
        (Register[]) {REG_V9_D0}, (Register[]) {REG_V10_D0}, (Register[]) {REG_V11_D0},
        (Register[]) {REG_V12_D0}, (Register[]) {REG_V13_D0}, (Register[]) {REG_V14_D0},
        (Register[]) {REG_V15_D0}, (Register[]) {REG_V16_D0}, (Register[]) {REG_V17_D0},
        (Register[]) {REG_V18_D0}, (Register[]) {REG_V19_D0}, (Register[]) {REG_V20_D0},
        (Register[]) {REG_V21_D0}, (Register[]) {REG_V22_D0}, (Register[]) {REG_V23_D0},
        (Register[]) {REG_V24_D0}, (Register[]) {REG_V25_D0}, (Register[]) {REG_V26_D0},
        (Register[]) {REG_V27_D0}, (Register[]) {REG_V28_D0}, (Register[]) {REG_V29_D0},
        (Register[]) {REG_V30_D0}, (Register[]) {REG_V31_D0}},
    {// ARRSPEC_2SINGLES = 7
        (Register[]) {REG_V0_S0, REG_V0_S1}, (Register[]) {REG_V1_S0, REG_V1_S1},
        (Register[]) {REG_V2_S0, REG_V2_S1}, (Register[]) {REG_V3_S0, REG_V3_S1},
        (Register[]) {REG_V4_S0, REG_V4_S1}, (Register[]) {REG_V5_S0, REG_V5_S1},
        (Register[]) {REG_V6_S0, REG_V6_S1}, (Register[]) {REG_V7_S0, REG_V7_S1},
        (Register[]) {REG_V8_S0, REG_V8_S1}, (Register[]) {REG_V9_S0, REG_V9_S1},
        (Register[]) {REG_V10_S0, REG_V10_S1}, (Register[]) {REG_V11_S0, REG_V11_S1},
        (Register[]) {REG_V12_S0, REG_V12_S1}, (Register[]) {REG_V13_S0, REG_V13_S1},
        (Register[]) {REG_V14_S0, REG_V14_S1}, (Register[]) {REG_V15_S0, REG_V15_S1},
        (Register[]) {REG_V16_S0, REG_V16_S1}, (Register[]) {REG_V17_S0, REG_V17_S1},
        (Register[]) {REG_V18_S0, REG_V18_S1}, (Register[]) {REG_V19_S0, REG_V19_S1},
        (Register[]) {REG_V20_S0, REG_V20_S1}, (Register[]) {REG_V21_S0, REG_V21_S1},
        (Register[]) {REG_V22_S0, REG_V22_S1}, (Register[]) {REG_V23_S0, REG_V23_S1},
        (Register[]) {REG_V24_S0, REG_V24_S1}, (Register[]) {REG_V25_S0, REG_V25_S1},
        (Register[]) {REG_V26_S0, REG_V26_S1}, (Register[]) {REG_V27_S0, REG_V27_S1},
        (Register[]) {REG_V28_S0, REG_V28_S1}, (Register[]) {REG_V29_S0, REG_V29_S1},
        (Register[]) {REG_V30_S0, REG_V30_S1}, (Register[]) {REG_V31_S0, REG_V31_S1}},
    {// ARRSPEC_4HALVES = 8
        (Register[]) {REG_V0_H0, REG_V0_H1, REG_V0_H2, REG_V0_H3},
        (Register[]) {REG_V1_H0, REG_V1_H1, REG_V1_H2, REG_V1_H3},
        (Register[]) {REG_V2_H0, REG_V2_H1, REG_V2_H2, REG_V2_H3},
        (Register[]) {REG_V3_H0, REG_V3_H1, REG_V3_H2, REG_V3_H3},
        (Register[]) {REG_V4_H0, REG_V4_H1, REG_V4_H2, REG_V4_H3},
        (Register[]) {REG_V5_H0, REG_V5_H1, REG_V5_H2, REG_V5_H3},
        (Register[]) {REG_V6_H0, REG_V6_H1, REG_V6_H2, REG_V6_H3},
        (Register[]) {REG_V7_H0, REG_V7_H1, REG_V7_H2, REG_V7_H3},
        (Register[]) {REG_V8_H0, REG_V8_H1, REG_V8_H2, REG_V8_H3},
        (Register[]) {REG_V9_H0, REG_V9_H1, REG_V9_H2, REG_V9_H3},
        (Register[]) {REG_V10_H0, REG_V10_H1, REG_V10_H2, REG_V10_H3},
        (Register[]) {REG_V11_H0, REG_V11_H1, REG_V11_H2, REG_V11_H3},
        (Register[]) {REG_V12_H0, REG_V12_H1, REG_V12_H2, REG_V12_H3},
        (Register[]) {REG_V13_H0, REG_V13_H1, REG_V13_H2, REG_V13_H3},
        (Register[]) {REG_V14_H0, REG_V14_H1, REG_V14_H2, REG_V14_H3},
        (Register[]) {REG_V15_H0, REG_V15_H1, REG_V15_H2, REG_V15_H3},
        (Register[]) {REG_V16_H0, REG_V16_H1, REG_V16_H2, REG_V16_H3},
        (Register[]) {REG_V17_H0, REG_V17_H1, REG_V17_H2, REG_V17_H3},
        (Register[]) {REG_V18_H0, REG_V18_H1, REG_V18_H2, REG_V18_H3},
        (Register[]) {REG_V19_H0, REG_V19_H1, REG_V19_H2, REG_V19_H3},
        (Register[]) {REG_V20_H0, REG_V20_H1, REG_V20_H2, REG_V20_H3},
        (Register[]) {REG_V21_H0, REG_V21_H1, REG_V21_H2, REG_V21_H3},
        (Register[]) {REG_V22_H0, REG_V22_H1, REG_V22_H2, REG_V22_H3},
        (Register[]) {REG_V23_H0, REG_V23_H1, REG_V23_H2, REG_V23_H3},
        (Register[]) {REG_V24_H0, REG_V24_H1, REG_V24_H2, REG_V24_H3},
        (Register[]) {REG_V25_H0, REG_V25_H1, REG_V25_H2, REG_V25_H3},
        (Register[]) {REG_V26_H0, REG_V26_H1, REG_V26_H2, REG_V26_H3},
        (Register[]) {REG_V27_H0, REG_V27_H1, REG_V27_H2, REG_V27_H3},
        (Register[]) {REG_V28_H0, REG_V28_H1, REG_V28_H2, REG_V28_H3},
        (Register[]) {REG_V29_H0, REG_V29_H1, REG_V29_H2, REG_V29_H3},
        (Register[]) {REG_V30_H0, REG_V30_H1, REG_V30_H2, REG_V30_H3},
        (Register[]) {REG_V31_H0, REG_V31_H1, REG_V31_H2, REG_V31_H3}},
    {
        // ARRSPEC_8BYTES = 9
        (Register[]) {
            REG_V0_B0, REG_V0_B1, REG_V0_B2, REG_V0_B3, REG_V0_B4, REG_V0_B5, REG_V0_B6, REG_V0_B7},
        (Register[]) {
            REG_V1_B0, REG_V1_B1, REG_V1_B2, REG_V1_B3, REG_V1_B4, REG_V1_B5, REG_V1_B6, REG_V1_B7},
        (Register[]) {
            REG_V2_B0, REG_V2_B1, REG_V2_B2, REG_V2_B3, REG_V2_B4, REG_V2_B5, REG_V2_B6, REG_V2_B7},
        (Register[]) {
            REG_V3_B0, REG_V3_B1, REG_V3_B2, REG_V3_B3, REG_V3_B4, REG_V3_B5, REG_V3_B6, REG_V3_B7},
        (Register[]) {
            REG_V4_B0, REG_V4_B1, REG_V4_B2, REG_V4_B3, REG_V4_B4, REG_V4_B5, REG_V4_B6, REG_V4_B7},
        (Register[]) {
            REG_V5_B0, REG_V5_B1, REG_V5_B2, REG_V5_B3, REG_V5_B4, REG_V5_B5, REG_V5_B6, REG_V5_B7},
        (Register[]) {
            REG_V6_B0, REG_V6_B1, REG_V6_B2, REG_V6_B3, REG_V6_B4, REG_V6_B5, REG_V6_B6, REG_V6_B7},
        (Register[]) {
            REG_V7_B0, REG_V7_B1, REG_V7_B2, REG_V7_B3, REG_V7_B4, REG_V7_B5, REG_V7_B6, REG_V7_B7},
        (Register[]) {
            REG_V8_B0, REG_V8_B1, REG_V8_B2, REG_V8_B3, REG_V8_B4, REG_V8_B5, REG_V8_B6, REG_V8_B7},
        (Register[]) {
            REG_V9_B0, REG_V9_B1, REG_V9_B2, REG_V9_B3, REG_V9_B4, REG_V9_B5, REG_V9_B6, REG_V9_B7},
        (Register[]) {REG_V10_B0, REG_V10_B1, REG_V10_B2, REG_V10_B3, REG_V10_B4, REG_V10_B5,
            REG_V10_B6, REG_V10_B7},
        (Register[]) {REG_V11_B0, REG_V11_B1, REG_V11_B2, REG_V11_B3, REG_V11_B4, REG_V11_B5,
            REG_V11_B6, REG_V11_B7},
        (Register[]) {REG_V12_B0, REG_V12_B1, REG_V12_B2, REG_V12_B3, REG_V12_B4, REG_V12_B5,
            REG_V12_B6, REG_V12_B7},
        (Register[]) {REG_V13_B0, REG_V13_B1, REG_V13_B2, REG_V13_B3, REG_V13_B4, REG_V13_B5,
            REG_V13_B6, REG_V13_B7},
        (Register[]) {REG_V14_B0, REG_V14_B1, REG_V14_B2, REG_V14_B3, REG_V14_B4, REG_V14_B5,
            REG_V14_B6, REG_V14_B7},
        (Register[]) {REG_V15_B0, REG_V15_B1, REG_V15_B2, REG_V15_B3, REG_V15_B4, REG_V15_B5,
            REG_V15_B6, REG_V15_B7},
        (Register[]) {REG_V16_B0, REG_V16_B1, REG_V16_B2, REG_V16_B3, REG_V16_B4, REG_V16_B5,
            REG_V16_B6, REG_V16_B7},
        (Register[]) {REG_V17_B0, REG_V17_B1, REG_V17_B2, REG_V17_B3, REG_V17_B4, REG_V17_B5,
            REG_V17_B6, REG_V17_B7},
        (Register[]) {REG_V18_B0, REG_V18_B1, REG_V18_B2, REG_V18_B3, REG_V18_B4, REG_V18_B5,
            REG_V18_B6, REG_V18_B7},
        (Register[]) {REG_V19_B0, REG_V19_B1, REG_V19_B2, REG_V19_B3, REG_V19_B4, REG_V19_B5,
            REG_V19_B6, REG_V19_B7},
        (Register[]) {REG_V20_B0, REG_V20_B1, REG_V20_B2, REG_V20_B3, REG_V20_B4, REG_V20_B5,
            REG_V20_B6, REG_V20_B7},
        (Register[]) {REG_V21_B0, REG_V21_B1, REG_V21_B2, REG_V21_B3, REG_V21_B4, REG_V21_B5,
            REG_V21_B6, REG_V21_B7},
        (Register[]) {REG_V22_B0, REG_V22_B1, REG_V22_B2, REG_V22_B3, REG_V22_B4, REG_V22_B5,
            REG_V22_B6, REG_V22_B7},
        (Register[]) {REG_V23_B0, REG_V23_B1, REG_V23_B2, REG_V23_B3, REG_V23_B4, REG_V23_B5,
            REG_V23_B6, REG_V23_B7},
        (Register[]) {REG_V24_B0, REG_V24_B1, REG_V24_B2, REG_V24_B3, REG_V24_B4, REG_V24_B5,
            REG_V24_B6, REG_V24_B7},
        (Register[]) {REG_V25_B0, REG_V25_B1, REG_V25_B2, REG_V25_B3, REG_V25_B4, REG_V25_B5,
            REG_V25_B6, REG_V25_B7},
        (Register[]) {REG_V26_B0, REG_V26_B1, REG_V26_B2, REG_V26_B3, REG_V26_B4, REG_V26_B5,
            REG_V26_B6, REG_V26_B7},
        (Register[]) {REG_V27_B0, REG_V27_B1, REG_V27_B2, REG_V27_B3, REG_V27_B4, REG_V27_B5,
            REG_V27_B6, REG_V27_B7},
        (Register[]) {REG_V28_B0, REG_V28_B1, REG_V28_B2, REG_V28_B3, REG_V28_B4, REG_V28_B5,
            REG_V28_B6, REG_V28_B7},
        (Register[]) {REG_V29_B0, REG_V29_B1, REG_V29_B2, REG_V29_B3, REG_V29_B4, REG_V29_B5,
            REG_V29_B6, REG_V29_B7},
        (Register[]) {REG_V30_B0, REG_V30_B1, REG_V30_B2, REG_V30_B3, REG_V30_B4, REG_V30_B5,
            REG_V30_B6, REG_V30_B7},
        (Register[]) {REG_V31_B0, REG_V31_B1, REG_V31_B2, REG_V31_B3, REG_V31_B4, REG_V31_B5,
            REG_V31_B6, REG_V31_B7},
    },
    {// ARRSPEC_1SINGLE = 10
        (Register[]) {REG_V0_S0}, (Register[]) {REG_V1_S0}, (Register[]) {REG_V2_S0},
        (Register[]) {REG_V3_S0}, (Register[]) {REG_V4_S0}, (Register[]) {REG_V5_S0},
        (Register[]) {REG_V6_S0}, (Register[]) {REG_V7_S0}, (Register[]) {REG_V8_S0},
        (Register[]) {REG_V9_S0}, (Register[]) {REG_V10_S0}, (Register[]) {REG_V11_S0},
        (Register[]) {REG_V12_S0}, (Register[]) {REG_V13_S0}, (Register[]) {REG_V14_S0},
        (Register[]) {REG_V15_S0}, (Register[]) {REG_V16_S0}, (Register[]) {REG_V17_S0},
        (Register[]) {REG_V18_S0}, (Register[]) {REG_V19_S0}, (Register[]) {REG_V20_S0},
        (Register[]) {REG_V21_S0}, (Register[]) {REG_V22_S0}, (Register[]) {REG_V23_S0}},
    {// ARRSPEC_2HALVES = 11
        (Register[]) {REG_V0_H0, REG_V0_H1}, (Register[]) {REG_V1_H0, REG_V1_H1},
        (Register[]) {REG_V2_H0, REG_V2_H1}, (Register[]) {REG_V3_H0, REG_V3_H1},
        (Register[]) {REG_V4_H0, REG_V4_H1}, (Register[]) {REG_V5_H0, REG_V5_H1},
        (Register[]) {REG_V6_H0, REG_V6_H1}, (Register[]) {REG_V7_H0, REG_V7_H1},
        (Register[]) {REG_V8_H0, REG_V8_H1}, (Register[]) {REG_V9_H0, REG_V9_H1},
        (Register[]) {REG_V10_H0, REG_V10_H1}, (Register[]) {REG_V11_H0, REG_V11_H1},
        (Register[]) {REG_V12_H0, REG_V12_H1}, (Register[]) {REG_V13_H0, REG_V13_H1},
        (Register[]) {REG_V14_H0, REG_V14_H1}, (Register[]) {REG_V15_H0, REG_V15_H1},
        (Register[]) {REG_V16_H0, REG_V16_H1}, (Register[]) {REG_V17_H0, REG_V17_H1},
        (Register[]) {REG_V18_H0, REG_V18_H1}, (Register[]) {REG_V19_H0, REG_V19_H1},
        (Register[]) {REG_V20_H0, REG_V20_H1}, (Register[]) {REG_V21_H0, REG_V21_H1},
        (Register[]) {REG_V22_H0, REG_V22_H1}, (Register[]) {REG_V23_H0, REG_V23_H1},
        (Register[]) {REG_V24_H0, REG_V24_H1}, (Register[]) {REG_V25_H0, REG_V25_H1},
        (Register[]) {REG_V26_H0, REG_V26_H1}, (Register[]) {REG_V27_H0, REG_V27_H1},
        (Register[]) {REG_V28_H0, REG_V28_H1}, (Register[]) {REG_V29_H0, REG_V29_H1},
        (Register[]) {REG_V30_H0, REG_V30_H1}, (Register[]) {REG_V31_H0, REG_V31_H1}},
    {// ARRSPEC_4BYTES = 12
        (Register[]) {REG_V0_B0, REG_V0_B1, REG_V0_B2, REG_V0_B3},
        (Register[]) {REG_V1_B0, REG_V1_B1, REG_V1_B2, REG_V1_B3},
        (Register[]) {REG_V2_B0, REG_V2_B1, REG_V2_B2, REG_V2_B3},
        (Register[]) {REG_V3_B0, REG_V3_B1, REG_V3_B2, REG_V3_B3},
        (Register[]) {REG_V4_B0, REG_V4_B1, REG_V4_B2, REG_V4_B3},
        (Register[]) {REG_V5_B0, REG_V5_B1, REG_V5_B2, REG_V5_B3},
        (Register[]) {REG_V6_B0, REG_V6_B1, REG_V6_B2, REG_V6_B3},
        (Register[]) {REG_V7_B0, REG_V7_B1, REG_V7_B2, REG_V7_B3},
        (Register[]) {REG_V8_B0, REG_V8_B1, REG_V8_B2, REG_V8_B3},
        (Register[]) {REG_V9_B0, REG_V9_B1, REG_V9_B2, REG_V9_B3},
        (Register[]) {REG_V10_B0, REG_V10_B1, REG_V10_B2, REG_V10_B3},
        (Register[]) {REG_V11_B0, REG_V11_B1, REG_V11_B2, REG_V11_B3},
        (Register[]) {REG_V12_B0, REG_V12_B1, REG_V12_B2, REG_V12_B3},
        (Register[]) {REG_V13_B0, REG_V13_B1, REG_V13_B2, REG_V13_B3},
        (Register[]) {REG_V14_B0, REG_V14_B1, REG_V14_B2, REG_V14_B3},
        (Register[]) {REG_V15_B0, REG_V15_B1, REG_V15_B2, REG_V15_B3},
        (Register[]) {REG_V16_B0, REG_V16_B1, REG_V16_B2, REG_V16_B3},
        (Register[]) {REG_V17_B0, REG_V17_B1, REG_V17_B2, REG_V17_B3},
        (Register[]) {REG_V18_B0, REG_V18_B1, REG_V18_B2, REG_V18_B3},
        (Register[]) {REG_V19_B0, REG_V19_B1, REG_V19_B2, REG_V19_B3},
        (Register[]) {REG_V20_B0, REG_V20_B1, REG_V20_B2, REG_V20_B3},
        (Register[]) {REG_V21_B0, REG_V21_B1, REG_V21_B2, REG_V21_B3},
        (Register[]) {REG_V22_B0, REG_V22_B1, REG_V22_B2, REG_V22_B3},
        (Register[]) {REG_V23_B0, REG_V23_B1, REG_V23_B2, REG_V23_B3},
        (Register[]) {REG_V24_B0, REG_V24_B1, REG_V24_B2, REG_V24_B3},
        (Register[]) {REG_V25_B0, REG_V25_B1, REG_V25_B2, REG_V25_B3},
        (Register[]) {REG_V26_B0, REG_V26_B1, REG_V26_B2, REG_V26_B3},
        (Register[]) {REG_V27_B0, REG_V27_B1, REG_V27_B2, REG_V27_B3},
        (Register[]) {REG_V28_B0, REG_V28_B1, REG_V28_B2, REG_V28_B3},
        (Register[]) {REG_V29_B0, REG_V29_B1, REG_V29_B2, REG_V29_B3},
        (Register[]) {REG_V30_B0, REG_V30_B1, REG_V30_B2, REG_V30_B3},
        (Register[]) {REG_V31_B0, REG_V31_B1, REG_V31_B2, REG_V31_B3}},
    {// ARRSPEC_1HALF = 13
        (Register[]) {REG_V0_H0}, (Register[]) {REG_V1_H0}, (Register[]) {REG_V2_H0},
        (Register[]) {REG_V3_H0}, (Register[]) {REG_V4_H0}, (Register[]) {REG_V5_H0},
        (Register[]) {REG_V6_H0}, (Register[]) {REG_V7_H0}, (Register[]) {REG_V8_H0},
        (Register[]) {REG_V9_H0}, (Register[]) {REG_V10_H0}, (Register[]) {REG_V11_H0},
        (Register[]) {REG_V12_H0}, (Register[]) {REG_V13_H0}, (Register[]) {REG_V14_H0},
        (Register[]) {REG_V15_H0}, (Register[]) {REG_V16_H0}, (Register[]) {REG_V17_H0},
        (Register[]) {REG_V18_H0}, (Register[]) {REG_V19_H0}, (Register[]) {REG_V20_H0},
        (Register[]) {REG_V21_H0}, (Register[]) {REG_V22_H0}, (Register[]) {REG_V23_H0},
        (Register[]) {REG_V24_H0}, (Register[]) {REG_V25_H0}, (Register[]) {REG_V26_H0},
        (Register[]) {REG_V27_H0}, (Register[]) {REG_V28_H0}, (Register[]) {REG_V29_H0},
        (Register[]) {REG_V30_H0}, (Register[]) {REG_V31_H0}},
    {// ARRSPEC_1BYTE = 14
        (Register[]) {REG_V0_B0}, (Register[]) {REG_V1_B0}, (Register[]) {REG_V2_B0},
        (Register[]) {REG_V3_B0}, (Register[]) {REG_V4_B0}, (Register[]) {REG_V5_B0},
        (Register[]) {REG_V6_B0}, (Register[]) {REG_V7_B0}, (Register[]) {REG_V8_B0},
        (Register[]) {REG_V9_B0}, (Register[]) {REG_V10_B0}, (Register[]) {REG_V11_B0},
        (Register[]) {REG_V12_B0}, (Register[]) {REG_V13_B0}, (Register[]) {REG_V14_B0},
        (Register[]) {REG_V15_B0}, (Register[]) {REG_V16_B0}, (Register[]) {REG_V17_B0},
        (Register[]) {REG_V18_B0}, (Register[]) {REG_V19_B0}, (Register[]) {REG_V20_B0},
        (Register[]) {REG_V21_B0}, (Register[]) {REG_V22_B0}, (Register[]) {REG_V23_B0},
        (Register[]) {REG_V24_B0}, (Register[]) {REG_V25_B0}, (Register[]) {REG_V26_B0},
        (Register[]) {REG_V27_B0}, (Register[]) {REG_V28_B0}, (Register[]) {REG_V29_B0},
        (Register[]) {REG_V30_B0}, (Register[]) {REG_V31_B0}}};
