/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTextField;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.Range;
import net.gcalc.plugin.properties.View;

class ViewTextField
extends JTextField
implements Observer,
FocusListener,
ActionListener {
    private GraphProperties properties;
    private int variable;
    private int field;

    public ViewTextField(GraphProperties gp, int var, int field) {
        super("", 7);
        this.properties = gp;
        this.variable = var;
        this.field = field;
        gp.addObserver(this);
        this.addFocusListener(this);
    }

    public void update(Observable o, Object obj) {
        if (obj == null) {
            return;
        }
        if (obj.equals(GraphProperties.VIEW)) {
            this.updateValue();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.updateValue();
    }

    public void updateValue() {
        View view = this.properties.getViewProperty(GraphProperties.VIEW);
        Range range = view.getRange(this.variable);
        double val = 0.0;
        switch (this.field) {
            case 0: {
                val = range.getMin();
                break;
            }
            case 1: {
                val = range.getMax();
                break;
            }
            case 2: {
                val = range.getScale();
            }
        }
        this.setText("" + val);
        this.setCaretPosition(0);
    }

    public double getValue() {
        double val = 0.0;
        try {
            val = Double.parseDouble(this.getText());
        }
        catch (NumberFormatException exception) {
            val = Double.NaN;
        }
        return val;
    }

    public void focusLost(FocusEvent f) {
    }

    public void focusGained(FocusEvent f) {
        this.setCaretPosition(this.getText().length());
        this.select(0, this.getText().length());
    }
}

