/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane;

import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.ColoredModel;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.plugin.gui.InputPanel;
import net.gcalc.plugin.gui.TextInputPanel;
import net.gcalc.plugin.plane.ParametricGraphPlugin;
import net.gcalc.plugin.plane.graph.PolarGraph;
import net.gcalc.plugin.plane.gui.ModelListPanel;

public class PolarGraphPlugin
extends ParametricGraphPlugin {
    public PolarGraphPlugin() {
        this.graph = new PolarGraph(this);
    }

    protected InputPanel getInputPanel() {
        return new TextInputPanel(null, this.getModelLabels(), null);
    }

    protected String[] getModelLabels() {
        return new String[]{"r(t)="};
    }

    protected JPanel makeModelListPanel() {
        return new ModelListPanel(this.graph.getProperties(), true, true);
    }

    public String getDescription() {
        return "<p>Draws a polar graph on the plane</p>";
    }

    public String getPluginName() {
        return "Polar Graph Plugin";
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ip) {
            String s1 = this.ip.getValues()[0].trim();
            Function r = null;
            try {
                r = FunctionFactory.getFunction(s1);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s1 + "'!\n" + e.getMessage(), 0);
                return;
            }
            this.drawGraph(new ColoredModel(r, s1, this.getNewColor()));
            this.statusBar.setText("Graphing: " + s1);
        }
    }
}

