/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.parser;

import net.gcalc.calc.math.functions.FunctionFactory;

public class Token {
    public static final int CONSTANT = 0;
    public static final int OPERATION = 1;
    public static final int DELIMETER = 2;
    public static final int VARIABLE = 3;
    private String s;
    private int type;
    private int pos;
    private int hashcode;

    public Token(String s, int type, int pos) {
        this.s = s;
        this.type = type;
        this.pos = pos;
        this.hashcode = 0;
    }

    public Token(String s, Token T) {
        this(s, T.type, T.pos);
    }

    public Token(char c, int type, int pos) {
        this("" + c, type, pos);
    }

    public Token(String s, int type) {
        this(s, type, -1);
    }

    public boolean equals(Object o) {
        return this.s.equals(((Token)o).s);
    }

    public String getName() {
        return this.s;
    }

    public String toString() {
        boolean DEBUG = false;
        if (DEBUG) {
            return "<" + this.s + "," + this.pos + ">";
        }
        return this.s;
    }

    public boolean isConstant() {
        return this.type == 0;
    }

    public boolean isNumber() {
        return this.isConstant() || this.isVariable();
    }

    public boolean isVariable() {
        return this.type == 3;
    }

    public boolean isSemiColon() {
        return this.s.equals(";");
    }

    public boolean isRightParen() {
        return this.s.equals(")");
    }

    public boolean isLeftParen() {
        return this.s.equals("(");
    }

    public boolean isComma() {
        return this.s.equals(",");
    }

    public boolean isMinusSign() {
        return this.s.equals("-");
    }

    public boolean isPlusSign() {
        return this.s.equals("+");
    }

    public boolean isCaret() {
        return this.s.equals("^");
    }

    public boolean isMultiply() {
        return this.s.equals("*");
    }

    public boolean isDerivative() {
        return this.s.equals("diff");
    }

    public boolean isDivide() {
        return this.s.equals("/");
    }

    public boolean isEqualSign() {
        return this.s.equals("=");
    }

    public boolean isGreaterThan() {
        return this.s.equals(">");
    }

    public boolean isGreaterThanOrEqualTo() {
        return this.s.equals(">=");
    }

    public boolean isLessThan() {
        return this.s.equals("<");
    }

    public boolean isLessThanOrEqualTo() {
        return this.s.equals("<=");
    }

    public boolean isEquality() {
        return this.s.equals("==");
    }

    public boolean isNotEqualTo() {
        return this.s.equals("!=");
    }

    public boolean isOr() {
        return this.s.equals("||");
    }

    public boolean isAnd() {
        return this.s.equals("&&");
    }

    public boolean isInequality() {
        return this.isGreaterThan() || this.isLessThan() || this.isGreaterThanOrEqualTo() || this.isLessThanOrEqualTo() || this.isNotEqualTo();
    }

    public boolean isBooleanOperation() {
        return this.isOr() || this.isAnd();
    }

    public boolean isBinary() {
        return this.isCaret() || this.isPlusSign() || this.isMinusSign() || this.isMultiply() || this.isDivide() || this.isEqualSign() || this.isBooleanOperation() || this.isInequality() || this.isEquality();
    }

    public float precedence() {
        if (this.isFunction()) {
            return 1.0f;
        }
        if (this.isCaret()) {
            return 2.0f;
        }
        if (this.isDivide()) {
            return 3.0f;
        }
        if (this.isMultiply()) {
            return 3.0f;
        }
        if (this.isPlusSign()) {
            return 4.0f;
        }
        if (this.isMinusSign()) {
            return 4.0f;
        }
        if (this.isEquality()) {
            return 6.0f;
        }
        if (this.isInequality()) {
            return 6.0f;
        }
        if (this.isBooleanOperation()) {
            return 7.0f;
        }
        if (this.isEqualSign()) {
            return 10.0f;
        }
        return -1.0f;
    }

    public boolean isFunction() {
        return FunctionFactory.isFunctionName(this.s);
    }

    public boolean isOperation() {
        return this.isFunction() || this.isBinary();
    }

    public int getPos() {
        return this.pos;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = (String.valueOf(this.s) + this.type).hashCode();
        }
        return this.hashcode;
    }
}

