/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.EngineeringOperation;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.parser.ParseTree;

public class TriangleWave
extends EngineeringOperation {
    public TriangleWave(ParseTree pt) {
        super(pt);
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        double t = ((Function)this.getArg(0)).evaluate(st, vt);
        double d = ((Function)this.getArg(1)).evaluate(st, vt);
        double T = ((Function)this.getArg(2)).evaluate(st, vt);
        double x = t / T - Math.floor(t / T);
        if (0.0 <= x && x < d / 2.0) {
            return 2.0 * x / d;
        }
        if (d / 2.0 <= x && x < d) {
            return 2.0 * (1.0 - x / d);
        }
        return 0.0;
    }
}

