/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.BinaryOperation;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.ParseTree;

public class Exponentiation
extends BinaryOperation {
    public Exponentiation(ParseTree pt) {
        super(pt);
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        return Math.pow(this.L.evaluate(st, vt), this.R.evaluate(st, vt));
    }

    public Function derivative(Vector vars) {
        Function F = null;
        boolean lconstant = this.L.isConstant();
        boolean rconstant = this.R.isConstant();
        if (this.R.isZero()) {
            F = this.L.isZero() ? NOT_A_NUMBER : ZERO;
        }
        if (lconstant && rconstant) {
            F = ZERO;
        } else if (rconstant) {
            F = FunctionFactory.getFunction(MULT_TOKEN, FunctionFactory.getFunction(CARET_TOKEN, this.L, FunctionFactory.getFunction(MINUS_TOKEN, this.R, ONE)), FunctionFactory.getFunction(MULT_TOKEN, this.R, this.L.derivative(vars)));
        } else if (lconstant) {
            F = FunctionFactory.getFunction(MULT_TOKEN, FunctionFactory.getFunction(MULT_TOKEN, this, FunctionFactory.getFunction(LN_TOKEN, this.L)), this.R.derivative(vars));
        } else {
            Function lhs = FunctionFactory.getFunction(MULT_TOKEN, FunctionFactory.getFunction(DIV_TOKEN, this.R, this.L), this.L.derivative(vars));
            Function rhs = FunctionFactory.getFunction(MULT_TOKEN, FunctionFactory.getFunction(LN_TOKEN, this.L), this.R.derivative(vars));
            F = FunctionFactory.getFunction(MULT_TOKEN, this, FunctionFactory.getFunction(PLUS_TOKEN, lhs, rhs));
        }
        return F;
    }

    public Function simplify() {
        if (this.simpleVersion != null) {
            return this.simpleVersion;
        }
        if (this.L.isZero() && this.L.isZero()) {
            this.simpleVersion = NOT_A_NUMBER;
            return this.simpleVersion;
        }
        if (this.R.simplify().isZero()) {
            this.simpleVersion = ONE;
            return this.simpleVersion;
        }
        if (this.R.simplify().isOne()) {
            this.simpleVersion = this.L.simplify();
            return this.simpleVersion;
        }
        if (this.L.simplify().isOne()) {
            this.simpleVersion = ONE;
            return this.simpleVersion;
        }
        return super.simplify();
    }
}

