/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.main;

import java.util.Hashtable;
import net.gcalc.calc.main.Value;
import net.gcalc.calc.parser.Token;
import net.gcalc.calc.parser.VariableToken;

public class ValueTable {
    private final Hashtable H = new Hashtable();

    public ValueTable() {
        this.setValue(new VariableToken("pi"), Math.PI);
        this.setValue(new VariableToken("e"), Math.E);
    }

    public boolean containsVariable(Token var) {
        return this.H.containsKey(var);
    }

    public synchronized void setValue(Token variable, double value) {
        if (this.H.containsKey(variable)) {
            ((Value)this.H.get(variable)).setValue(value);
        } else {
            this.H.put(variable, new Value(value));
        }
    }

    public synchronized void clearValue(Token variable) {
        if (this.H.containsKey(variable)) {
            this.H.remove(variable);
        }
    }

    public synchronized double getValue(Token variable) {
        if (this.H.containsKey(variable)) {
            return ((Value)this.H.get(variable)).getValue();
        }
        return Double.NaN;
    }
}

