/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.gui.gradient;

import java.awt.Color;
import java.util.Observable;

public class Marker
extends Observable
implements Comparable {
    private double position;
    private Color left;
    private Color center;
    private Color right;

    public Marker(double pos) {
        this.setPosition(pos);
    }

    public Marker(double pos, Color c) {
        this(pos, c, c, c);
    }

    public Marker(double pos, Color l, Color c, Color r) {
        this(pos);
        this.left = l;
        this.center = c;
        this.right = r;
    }

    public void setPosition(double p) {
        this.position = p;
        this.setChanged();
        this.notifyObservers();
    }

    public double getPosition() {
        return this.position;
    }

    public void setColor(Color c) {
        this.center = this.right = c;
        this.left = this.right;
        this.setChanged();
        this.notifyObservers();
    }

    public Color getLeft() {
        return this.left;
    }

    public void setLeft(Color left) {
        this.left = left;
        this.setChanged();
        this.notifyObservers();
    }

    public Color getRight() {
        return this.right;
    }

    public void setRight(Color right) {
        this.right = right;
        this.setChanged();
        this.notifyObservers();
    }

    public int compareTo(Object o) {
        Marker m = (Marker)o;
        if (this.getPosition() < m.getPosition()) {
            return -1;
        }
        if (this.getPosition() > m.getPosition()) {
            return 1;
        }
        return 0;
    }

    public Color getCenter() {
        return this.center;
    }

    public void setCenter(Color center) {
        this.center = center;
        this.setChanged();
        this.notifyObservers();
    }

    public String toString() {
        return "" + this.getPosition();
    }
}

