// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/channel/v1/repricing.proto

package channel

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	decimal "google.golang.org/genproto/googleapis/type/decimal"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the different costs that the modified bill can be based on.
type RebillingBasis int32

const (
	// Not used.
	RebillingBasis_REBILLING_BASIS_UNSPECIFIED RebillingBasis = 0
	// Use the list cost, also known as the MSRP.
	RebillingBasis_COST_AT_LIST RebillingBasis = 1
	// Pass through all discounts except the Reseller Program Discount. If this is
	// the default cost base and no adjustments are specified, the output cost
	// will be exactly what the customer would see if they viewed the bill in the
	// Google Cloud Console.
	RebillingBasis_DIRECT_CUSTOMER_COST RebillingBasis = 2
)

// Enum value maps for RebillingBasis.
var (
	RebillingBasis_name = map[int32]string{
		0: "REBILLING_BASIS_UNSPECIFIED",
		1: "COST_AT_LIST",
		2: "DIRECT_CUSTOMER_COST",
	}
	RebillingBasis_value = map[string]int32{
		"REBILLING_BASIS_UNSPECIFIED": 0,
		"COST_AT_LIST":                1,
		"DIRECT_CUSTOMER_COST":        2,
	}
)

func (x RebillingBasis) Enum() *RebillingBasis {
	p := new(RebillingBasis)
	*p = x
	return p
}

func (x RebillingBasis) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RebillingBasis) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_repricing_proto_enumTypes[0].Descriptor()
}

func (RebillingBasis) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_repricing_proto_enumTypes[0]
}

func (x RebillingBasis) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RebillingBasis.Descriptor instead.
func (RebillingBasis) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{0}
}

// Configuration for how a reseller will reprice a Customer.
type CustomerRepricingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the CustomerRepricingConfig.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/customerRepricingConfigs/{id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The configuration for bill modifications made by a reseller before
	// sending it to customers.
	RepricingConfig *RepricingConfig `protobuf:"bytes,2,opt,name=repricing_config,json=repricingConfig,proto3" json:"repricing_config,omitempty"`
	// Output only. Timestamp of an update to the repricing rule. If `update_time` is after
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month] then it indicates this was set
	// mid-month.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *CustomerRepricingConfig) Reset() {
	*x = CustomerRepricingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerRepricingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerRepricingConfig) ProtoMessage() {}

func (x *CustomerRepricingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerRepricingConfig.ProtoReflect.Descriptor instead.
func (*CustomerRepricingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{0}
}

func (x *CustomerRepricingConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomerRepricingConfig) GetRepricingConfig() *RepricingConfig {
	if x != nil {
		return x.RepricingConfig
	}
	return nil
}

func (x *CustomerRepricingConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Configuration for how a distributor will rebill a channel partner
// (also known as a distributor-authorized reseller).
type ChannelPartnerRepricingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the ChannelPartnerRepricingConfig.
	// Format:
	// accounts/{account_id}/channelPartnerLinks/{channel_partner_id}/channelPartnerRepricingConfigs/{id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The configuration for bill modifications made by a reseller before
	// sending it to ChannelPartner.
	RepricingConfig *RepricingConfig `protobuf:"bytes,2,opt,name=repricing_config,json=repricingConfig,proto3" json:"repricing_config,omitempty"`
	// Output only. Timestamp of an update to the repricing rule. If `update_time` is after
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month] then it indicates this was set
	// mid-month.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *ChannelPartnerRepricingConfig) Reset() {
	*x = ChannelPartnerRepricingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChannelPartnerRepricingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelPartnerRepricingConfig) ProtoMessage() {}

func (x *ChannelPartnerRepricingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelPartnerRepricingConfig.ProtoReflect.Descriptor instead.
func (*ChannelPartnerRepricingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{1}
}

func (x *ChannelPartnerRepricingConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChannelPartnerRepricingConfig) GetRepricingConfig() *RepricingConfig {
	if x != nil {
		return x.RepricingConfig
	}
	return nil
}

func (x *ChannelPartnerRepricingConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Configuration for repricing a Google bill over a period of time.
type RepricingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Defines the granularity for repricing.
	//
	// Types that are assignable to Granularity:
	//	*RepricingConfig_EntitlementGranularity_
	//	*RepricingConfig_ChannelPartnerGranularity_
	Granularity isRepricingConfig_Granularity `protobuf_oneof:"granularity"`
	// Required. The YearMonth when these adjustments activate. The Day field needs to be
	// "0" since we only accept YearMonth repricing boundaries.
	EffectiveInvoiceMonth *date.Date `protobuf:"bytes,1,opt,name=effective_invoice_month,json=effectiveInvoiceMonth,proto3" json:"effective_invoice_month,omitempty"`
	// Required. Information about the adjustment.
	Adjustment *RepricingAdjustment `protobuf:"bytes,2,opt,name=adjustment,proto3" json:"adjustment,omitempty"`
	// Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to use for this bill. Specifies the relative cost
	// based on repricing costs you will apply.
	RebillingBasis RebillingBasis `protobuf:"varint,3,opt,name=rebilling_basis,json=rebillingBasis,proto3,enum=google.cloud.channel.v1.RebillingBasis" json:"rebilling_basis,omitempty"`
}

func (x *RepricingConfig) Reset() {
	*x = RepricingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepricingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingConfig) ProtoMessage() {}

func (x *RepricingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingConfig.ProtoReflect.Descriptor instead.
func (*RepricingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{2}
}

func (m *RepricingConfig) GetGranularity() isRepricingConfig_Granularity {
	if m != nil {
		return m.Granularity
	}
	return nil
}

func (x *RepricingConfig) GetEntitlementGranularity() *RepricingConfig_EntitlementGranularity {
	if x, ok := x.GetGranularity().(*RepricingConfig_EntitlementGranularity_); ok {
		return x.EntitlementGranularity
	}
	return nil
}

func (x *RepricingConfig) GetChannelPartnerGranularity() *RepricingConfig_ChannelPartnerGranularity {
	if x, ok := x.GetGranularity().(*RepricingConfig_ChannelPartnerGranularity_); ok {
		return x.ChannelPartnerGranularity
	}
	return nil
}

func (x *RepricingConfig) GetEffectiveInvoiceMonth() *date.Date {
	if x != nil {
		return x.EffectiveInvoiceMonth
	}
	return nil
}

func (x *RepricingConfig) GetAdjustment() *RepricingAdjustment {
	if x != nil {
		return x.Adjustment
	}
	return nil
}

func (x *RepricingConfig) GetRebillingBasis() RebillingBasis {
	if x != nil {
		return x.RebillingBasis
	}
	return RebillingBasis_REBILLING_BASIS_UNSPECIFIED
}

type isRepricingConfig_Granularity interface {
	isRepricingConfig_Granularity()
}

type RepricingConfig_EntitlementGranularity_ struct {
	// Applies the repricing configuration at the entitlement level. This is
	// the only supported value for CustomerRepricingConfig.
	EntitlementGranularity *RepricingConfig_EntitlementGranularity `protobuf:"bytes,4,opt,name=entitlement_granularity,json=entitlementGranularity,proto3,oneof"`
}

type RepricingConfig_ChannelPartnerGranularity_ struct {
	// Applies the repricing configuration at the channel partner level.
	// This is the only supported value for ChannelPartnerRepricingConfig.
	ChannelPartnerGranularity *RepricingConfig_ChannelPartnerGranularity `protobuf:"bytes,5,opt,name=channel_partner_granularity,json=channelPartnerGranularity,proto3,oneof"`
}

func (*RepricingConfig_EntitlementGranularity_) isRepricingConfig_Granularity() {}

func (*RepricingConfig_ChannelPartnerGranularity_) isRepricingConfig_Granularity() {}

// A type that represents the various adjustments you can apply to a bill.
type RepricingAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A oneof that represents the different types for this adjustment.
	//
	// Types that are assignable to Adjustment:
	//	*RepricingAdjustment_PercentageAdjustment
	Adjustment isRepricingAdjustment_Adjustment `protobuf_oneof:"adjustment"`
}

func (x *RepricingAdjustment) Reset() {
	*x = RepricingAdjustment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepricingAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingAdjustment) ProtoMessage() {}

func (x *RepricingAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingAdjustment.ProtoReflect.Descriptor instead.
func (*RepricingAdjustment) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{3}
}

func (m *RepricingAdjustment) GetAdjustment() isRepricingAdjustment_Adjustment {
	if m != nil {
		return m.Adjustment
	}
	return nil
}

func (x *RepricingAdjustment) GetPercentageAdjustment() *PercentageAdjustment {
	if x, ok := x.GetAdjustment().(*RepricingAdjustment_PercentageAdjustment); ok {
		return x.PercentageAdjustment
	}
	return nil
}

type isRepricingAdjustment_Adjustment interface {
	isRepricingAdjustment_Adjustment()
}

type RepricingAdjustment_PercentageAdjustment struct {
	// Flat markup or markdown on an entire bill.
	PercentageAdjustment *PercentageAdjustment `protobuf:"bytes,2,opt,name=percentage_adjustment,json=percentageAdjustment,proto3,oneof"`
}

func (*RepricingAdjustment_PercentageAdjustment) isRepricingAdjustment_Adjustment() {}

// An adjustment that applies a flat markup or markdown to an entire bill.
type PercentageAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percentage of the bill to adjust.
	// For example:
	// Mark down by 1% => "-1.00"
	// Mark up by 1%   => "1.00"
	// Pass-Through    => "0.00"
	Percentage *decimal.Decimal `protobuf:"bytes,2,opt,name=percentage,proto3" json:"percentage,omitempty"`
}

func (x *PercentageAdjustment) Reset() {
	*x = PercentageAdjustment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PercentageAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PercentageAdjustment) ProtoMessage() {}

func (x *PercentageAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PercentageAdjustment.ProtoReflect.Descriptor instead.
func (*PercentageAdjustment) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{4}
}

func (x *PercentageAdjustment) GetPercentage() *decimal.Decimal {
	if x != nil {
		return x.Percentage
	}
	return nil
}

// Applies the repricing configuration at the entitlement level.
type RepricingConfig_EntitlementGranularity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the entitlement.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Entitlement string `protobuf:"bytes,1,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
}

func (x *RepricingConfig_EntitlementGranularity) Reset() {
	*x = RepricingConfig_EntitlementGranularity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepricingConfig_EntitlementGranularity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingConfig_EntitlementGranularity) ProtoMessage() {}

func (x *RepricingConfig_EntitlementGranularity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingConfig_EntitlementGranularity.ProtoReflect.Descriptor instead.
func (*RepricingConfig_EntitlementGranularity) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{2, 0}
}

func (x *RepricingConfig_EntitlementGranularity) GetEntitlement() string {
	if x != nil {
		return x.Entitlement
	}
	return ""
}

// Applies the repricing configuration at the channel partner level.
// The channel partner value is derived from the resource name. Takes an
// empty json object.
type RepricingConfig_ChannelPartnerGranularity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RepricingConfig_ChannelPartnerGranularity) Reset() {
	*x = RepricingConfig_ChannelPartnerGranularity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepricingConfig_ChannelPartnerGranularity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingConfig_ChannelPartnerGranularity) ProtoMessage() {}

func (x *RepricingConfig_ChannelPartnerGranularity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingConfig_ChannelPartnerGranularity.ProtoReflect.Descriptor instead.
func (*RepricingConfig_ChannelPartnerGranularity) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{2, 1}
}

var File_google_cloud_channel_v1_repricing_proto protoreflect.FileDescriptor

var file_google_cloud_channel_v1_repricing_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63,
	0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xe8, 0x02, 0x0a, 0x17, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x3a, 0x97, 0x01, 0xea, 0x41, 0x93, 0x01, 0x0a, 0x33, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0x92, 0x03,
	0x0a, 0x1d, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x3a, 0xbb, 0x01, 0xea, 0x41, 0xb7, 0x01, 0x0a, 0x39, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x7d,
	0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x7b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x7d, 0x22, 0xa4, 0x05, 0x0a, 0x0f, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x0a, 0x17, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x72, 0x61,
	0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x16, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x84, 0x01, 0x0a, 0x1b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x19,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x47, 0x72,
	0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4e, 0x0a, 0x17, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x6d,
	0x6f, 0x6e, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x15, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x76,
	0x6f, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x51, 0x0a, 0x0a, 0x61, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x0f,
	0x72, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x61, 0x73, 0x69, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x73, 0x69, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x61,
	0x73, 0x69, 0x73, 0x1a, 0x68, 0x0a, 0x16, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4e, 0x0a,
	0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x1b, 0x0a,
	0x19, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x47,
	0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x42, 0x0d, 0x0a, 0x0b, 0x67, 0x72,
	0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x22, 0x89, 0x01, 0x0a, 0x13, 0x52, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x64, 0x0a, 0x15, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x5f,
	0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x14, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x41, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x0c, 0x0a, 0x0a, 0x61, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x4c, 0x0a, 0x14, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a,
	0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x44, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x2a, 0x5d, 0x0a, 0x0e, 0x52, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x42, 0x61, 0x73, 0x69, 0x73, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x42, 0x49, 0x4c, 0x4c, 0x49,
	0x4e, 0x47, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4f, 0x53, 0x54, 0x5f, 0x41,
	0x54, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x44, 0x49, 0x52, 0x45,
	0x43, 0x54, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x53, 0x54,
	0x10, 0x02, 0x42, 0x6f, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x42, 0x0e, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_channel_v1_repricing_proto_rawDescOnce sync.Once
	file_google_cloud_channel_v1_repricing_proto_rawDescData = file_google_cloud_channel_v1_repricing_proto_rawDesc
)

func file_google_cloud_channel_v1_repricing_proto_rawDescGZIP() []byte {
	file_google_cloud_channel_v1_repricing_proto_rawDescOnce.Do(func() {
		file_google_cloud_channel_v1_repricing_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_channel_v1_repricing_proto_rawDescData)
	})
	return file_google_cloud_channel_v1_repricing_proto_rawDescData
}

var file_google_cloud_channel_v1_repricing_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_channel_v1_repricing_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_channel_v1_repricing_proto_goTypes = []interface{}{
	(RebillingBasis)(0),                               // 0: google.cloud.channel.v1.RebillingBasis
	(*CustomerRepricingConfig)(nil),                   // 1: google.cloud.channel.v1.CustomerRepricingConfig
	(*ChannelPartnerRepricingConfig)(nil),             // 2: google.cloud.channel.v1.ChannelPartnerRepricingConfig
	(*RepricingConfig)(nil),                           // 3: google.cloud.channel.v1.RepricingConfig
	(*RepricingAdjustment)(nil),                       // 4: google.cloud.channel.v1.RepricingAdjustment
	(*PercentageAdjustment)(nil),                      // 5: google.cloud.channel.v1.PercentageAdjustment
	(*RepricingConfig_EntitlementGranularity)(nil),    // 6: google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
	(*RepricingConfig_ChannelPartnerGranularity)(nil), // 7: google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
	(*timestamppb.Timestamp)(nil),                     // 8: google.protobuf.Timestamp
	(*date.Date)(nil),                                 // 9: google.type.Date
	(*decimal.Decimal)(nil),                           // 10: google.type.Decimal
}
var file_google_cloud_channel_v1_repricing_proto_depIdxs = []int32{
	3,  // 0: google.cloud.channel.v1.CustomerRepricingConfig.repricing_config:type_name -> google.cloud.channel.v1.RepricingConfig
	8,  // 1: google.cloud.channel.v1.CustomerRepricingConfig.update_time:type_name -> google.protobuf.Timestamp
	3,  // 2: google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config:type_name -> google.cloud.channel.v1.RepricingConfig
	8,  // 3: google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time:type_name -> google.protobuf.Timestamp
	6,  // 4: google.cloud.channel.v1.RepricingConfig.entitlement_granularity:type_name -> google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
	7,  // 5: google.cloud.channel.v1.RepricingConfig.channel_partner_granularity:type_name -> google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
	9,  // 6: google.cloud.channel.v1.RepricingConfig.effective_invoice_month:type_name -> google.type.Date
	4,  // 7: google.cloud.channel.v1.RepricingConfig.adjustment:type_name -> google.cloud.channel.v1.RepricingAdjustment
	0,  // 8: google.cloud.channel.v1.RepricingConfig.rebilling_basis:type_name -> google.cloud.channel.v1.RebillingBasis
	5,  // 9: google.cloud.channel.v1.RepricingAdjustment.percentage_adjustment:type_name -> google.cloud.channel.v1.PercentageAdjustment
	10, // 10: google.cloud.channel.v1.PercentageAdjustment.percentage:type_name -> google.type.Decimal
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_channel_v1_repricing_proto_init() }
func file_google_cloud_channel_v1_repricing_proto_init() {
	if File_google_cloud_channel_v1_repricing_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_channel_v1_repricing_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomerRepricingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_repricing_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChannelPartnerRepricingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_repricing_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepricingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_repricing_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepricingAdjustment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_repricing_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PercentageAdjustment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_repricing_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepricingConfig_EntitlementGranularity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_repricing_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepricingConfig_ChannelPartnerGranularity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_channel_v1_repricing_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*RepricingConfig_EntitlementGranularity_)(nil),
		(*RepricingConfig_ChannelPartnerGranularity_)(nil),
	}
	file_google_cloud_channel_v1_repricing_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*RepricingAdjustment_PercentageAdjustment)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_channel_v1_repricing_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_channel_v1_repricing_proto_goTypes,
		DependencyIndexes: file_google_cloud_channel_v1_repricing_proto_depIdxs,
		EnumInfos:         file_google_cloud_channel_v1_repricing_proto_enumTypes,
		MessageInfos:      file_google_cloud_channel_v1_repricing_proto_msgTypes,
	}.Build()
	File_google_cloud_channel_v1_repricing_proto = out.File
	file_google_cloud_channel_v1_repricing_proto_rawDesc = nil
	file_google_cloud_channel_v1_repricing_proto_goTypes = nil
	file_google_cloud_channel_v1_repricing_proto_depIdxs = nil
}
