/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.CalibreDrcErrors;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AssuraDrcErrors {
    public static void importErrors(String filename, Map<Cell, String> mangledNames, String type) {
        BufferedReader in;
        try {
            FileReader reader = new FileReader(filename);
            in = new BufferedReader(reader);
        }
        catch (IOException e) {
            System.out.println("Error importing " + type + " Errors: " + e.getMessage());
            return;
        }
        DrcRuleViolation rule = null;
        Cell cell = null;
        ErrorLogger logger = ErrorLogger.newInstance("Assura " + type + " Errors");
        int count2 = 0;
        int num = 1;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String[] strings = line.split("\\s+");
                if (strings.length == 0) continue;
                if (strings[0].equals("Rule") && strings.length > 4) {
                    int number = Integer.valueOf(strings[2]);
                    int remove = 9 + strings[2].length() + 3;
                    rule = new DrcRuleViolation(number, line.substring(remove, line.length()));
                    continue;
                }
                if (rule == null) continue;
                if (strings[0].equals("Real")) {
                    int real = Integer.valueOf(strings[4].replaceAll(";", ""));
                    int flat = Integer.valueOf(strings[9]);
                    rule.setErrorCounts(real, flat);
                    logger.setGroupName(rule.number, "(" + real + ") " + rule.desc);
                    num = 1;
                    continue;
                }
                if (strings[0].equals("Cell")) {
                    cell = CalibreDrcErrors.getCell(strings[3], mangledNames);
                    if (cell != null) continue;
                    System.out.println("Couldn't find cell " + strings[3] + "{lay}");
                    continue;
                }
                if (cell == null) continue;
                double scale = cell.getTechnology().getScale();
                if (!strings[0].equals("Shape")) continue;
                line = in.readLine();
                line = in.readLine();
                line = in.readLine();
                while (!line.startsWith("---") && !line.startsWith("===") && (line = in.readLine()) != null) {
                    strings = line.split("\\s+");
                    if (strings.length < 6) continue;
                    int last2 = strings.length - 1;
                    double x1 = Double.parseDouble(strings[last2 - 3]) / scale * 1000.0;
                    double y1 = Double.parseDouble(strings[last2 - 2]) / scale * 1000.0;
                    double x2 = Double.parseDouble(strings[last2 - 1]) / scale * 1000.0;
                    double y2 = Double.parseDouble(strings[last2]) / scale * 1000.0;
                    Rectangle2D.Double rect = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
                    new DrcError(cell, rect);
                    ArrayList<EPoint> ptList = new ArrayList<EPoint>();
                    ptList.add(EPoint.fromLambda(x1, y1));
                    ptList.add(EPoint.fromLambda(x2, y1));
                    ptList.add(EPoint.fromLambda(x1, y1));
                    ptList.add(EPoint.fromLambda(x1, y2));
                    ptList.add(EPoint.fromLambda(x2, y2));
                    ptList.add(EPoint.fromLambda(x2, y1));
                    ptList.add(EPoint.fromLambda(x2, y2));
                    ptList.add(EPoint.fromLambda(x1, y2));
                    ptList.add(EPoint.fromLambda(x1, y1));
                    ptList.add(EPoint.fromLambda(x2, y2));
                    ptList.add(EPoint.fromLambda(x1, y2));
                    ptList.add(EPoint.fromLambda(x2, y1));
                    logger.logMessage(num + ". " + cell.getName() + ": " + rule.desc, ptList, cell, rule.number, true);
                    ++count2;
                    ++num;
                }
            }
        }
        catch (IOException e) {
            System.out.println("Error importing " + type + " Errors: " + e.getMessage());
            return;
        }
        System.out.println("Imported " + count2 + " errors from file " + filename);
        if (count2 == 0) {
            Job.getUserInterface().showInformationMessage("Imported Zero " + type + " Errors", type + " Import Complete");
        }
        logger.termLogging(true);
    }

    private static class DrcError {
        private final Cell cell;
        private final Shape marker;

        private DrcError(Cell cell, Shape marker) {
            this.cell = cell;
            this.marker = marker;
        }

        public Cell getCell() {
            return this.cell;
        }

        public Shape getMarker() {
            return this.marker;
        }
    }

    private static class DrcRuleViolation {
        private final int number;
        private final String desc;
        private final List<DrcError> errors;

        private DrcRuleViolation(int number, String desc) {
            this.number = number;
            this.desc = desc;
            this.errors = new ArrayList<DrcError>();
        }

        public Iterator<DrcError> getErrors() {
            ArrayList<DrcError> copy = new ArrayList<DrcError>(this.errors);
            return copy.iterator();
        }

        private void setErrorCounts(int real, int flat) {
        }
    }
}

