/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jrobin.mrtg.client.MrtgData;
import org.jrobin.mrtg.client.Util;

class HostDialog
extends JDialog {
    private static final String HOST_FILENAME = System.getProperty("user.home") + System.getProperty("file.separator") + ".last-mrtg-host";
    private static final String DEFAULT_HOST = "localhost";
    private static final String TITLE = "Select JRobin-MRTG host";
    private String host;
    private JLabel hostLabel = Util.standardLabel("Host address:");
    private JTextField hostField = Util.standardTextField();
    private JButton okButton = Util.standardButton("OK");
    private JButton cancelButton = Util.standardButton("Cancel");

    HostDialog(Frame frame) {
        super(frame, TITLE, true);
        this.constructUserInterface();
        this.pack();
        this.setVisible(true);
    }

    private void constructUserInterface() {
        JPanel jPanel = (JPanel)this.getContentPane();
        Box box = Box.createVerticalBox();
        box.add(Util.getPanelFor(this.hostLabel, this.hostField));
        box.add(Util.getPanelFor(Util.standardLabel(), this.okButton, this.cancelButton));
        jPanel.add(box);
        String string = MrtgData.getInstance().getMrtgHost();
        if (string != null) {
            this.hostField.setText(string);
        } else {
            String string2 = this.getHostFromFile();
            this.hostField.setText(string2 == null ? DEFAULT_HOST : string2);
        }
        this.hostField.selectAll();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostDialog.this.cancel();
            }
        });
        this.okButton.setMnemonic(79);
        this.cancelButton.setMnemonic(67);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setDefaultCloseOperation(2);
        Util.centerOnScreen(this);
    }

    String getHost() {
        return this.host;
    }

    private void ok() {
        String string = this.hostField.getText();
        if (string.length() == 0) {
            Util.warn(this, "Please enter host address");
        } else {
            this.host = string;
            this.saveHostToFile();
            this.close();
        }
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void cancel() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHostToFile() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(HOST_FILENAME, false));
            printWriter.println(this.host);
        }
        catch (IOException iOException) {
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getHostFromFile() {
        String string;
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(HOST_FILENAME));
                string = bufferedReader.readLine();
                Object var5_4 = null;
                if (bufferedReader == null) return string;
            }
            catch (IOException iOException) {
                String string2 = null;
                Object var5_5 = null;
                if (bufferedReader == null) return string2;
                try {
                    bufferedReader.close();
                    return string2;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bufferedReader == null) throw throwable;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            bufferedReader.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return string;
        }
        bufferedReader.close();
        return string;
    }
}

